#include <kstatusbar.h>
#include <kapp.h>
#include <kstdaction.h>
#include <kaction.h>

#include "kstatusbardemo.moc"

//Status bar IDs.
const int StatusBarMain = 0, StatusBarMode = 1;

KStatusBarDemo::KStatusBarDemo (const char *name) : KTMainWindow (name)
{
  KStdAction::quit (kapp, SLOT(closeAllWindows()), actionCollection());
  new KAction ("&Change Mode", 0,
	       this, SLOT (slotChangeMode()), actionCollection(),
	       "change_mode");

  createGUI();

  statusBar()->
    insertItem ("Current status of application",
		StatusBarMain, 1);
  statusBar()->insertItem (" Mode2 ", StatusBarMode);
  statusBar()->changeItem (" Mode1 ", StatusBarMode);
  mode=true;

  statusBar()->message ("Application is ready!", 20000);
  
  QLabel *dummyclientarea = new QLabel (this);
  dummyclientarea->setBackgroundColor (Qt::white);
  setView (dummyclientarea);
}


void
KStatusBarDemo::slotChangeMode ()
{
  
  if (mode)
    {
      statusBar()->changeItem (" Mode2 ", StatusBarMode);
      mode=false;
    }
  else
    {
      statusBar()->changeItem (" Mode1 ", StatusBarMode);
      mode=true;
    }

}
