#include <qpopupmenu.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kapp.h>
#include <kstddirs.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kaboutdialog.h>
#include <kiconloader.h>

#include "khelpers.moc"

KHelpers::KHelpers (const char *name) : KTMainWindow (name)
{
  KStdAction::open(0, 0, actionCollection());

  KStdAction::quit( kapp, SLOT (closeAllWindows()),
		    actionCollection());

  createGUI();


  QLabel *clientarea = new QLabel ("KHelpers client area", this);
  clientarea->setBackgroundColor (Qt::white);

  QToolTip::add (clientarea, "Functionless client area");
  QWhatsThis::add (clientarea, "This client area doesn't do anything.");
  

  setView (clientarea);
}

void
KHelpers::slotSpecialHelp()
{
  QString helpfilename (kapp->name());
  helpfilename += "/specialhelp.html";

  kapp->invokeHTMLHelp (helpfilename, "");
}
