#ifndef __KCUSTOMACTIONS_H__
#define __KCUSTOMACTIONS_H__

#include <kmainwindow.h>

class KToggleAction;
class KRadioAction;

/**
 * KCustomActions
 * Create custom actions for the menubar and toolbars.
 *
 * CHANGE: KCustomActions is now derived from KMainWindow, not
 *  KTMainWindow.  KMainWindow serves the same purpose, but is
 *  somewhat simpler to use and is the new KDE 2.0 standard.
 **/
class KCustomActions : public KMainWindow
{
  Q_OBJECT
 public:
  /**
   * Construct the menubar and toolbars and fill
   *  them with interesting things.
   **/
  KCustomActions (const char *name=0);

 public slots:
  void slotMyEntry();
  void slotLoadPage (const QString &url);
  void slotRectangle ();
  void slotPencil ();


 protected:
  KToggleAction *checkable;
  KRadioAction *rectangle, *pencil;
};

#endif
