#!/usr/local/Python-1.4/python
from regsub import *
from string import *
from pythonqt import *


############################################################################
class LsmWidget(Widget):                                                   #
############################################################################
# This widget allows the editing of LSM files.  Files can be loaded by     #
# entering the program's name and version number and clicking on load.     #
# Files are saved in filenames of the form <title>-<version>.lsm           #
############################################################################
    def __init__(s):
	Widget.__init__(s)		# Call base initialiser

	s.setCaption("Python/Qt LSM editor")# set the widget's caption

	s.dframe = Frame(s)		# create frame for data entry
	s.dframe.setFrameStyle(Frame.Box | Frame.Sunken)# set its style

	# This list contains the fields we will be using
	s.fields = ["Title", "Version", "Entered-Date", "Description",
		       "Keywords", "Author", "Maintained-by", "Primary-site",
		       "Alternate-site", "Original-site", "Platform"]

	s.labels = {}			# contains the labels
	s.edits = {}			# contains the line edits

	y = 5				# use to position fields
	for x in s.fields:
	    s.labels[x] = LabelT(x + ':', s.dframe) # create label for field
	    s.edits[x] = LineEdit(s.dframe) # create line edit for field 
	    s.labels[x].setGeometry(5,y,100,20) # set geometry of label 
	    s.edits[x].setGeometry(108,y,300,20) # set geometry of line edit
	    y = y + 30			# update y
	
	s.edits["Title"].setFont(QFontV("helvetica",12,QFont.Bold))
	s.edits["Version"].setFont(QFontV("helvetica",12,QFont.Bold))

	s.dframe.resize(415, y+2)	# resize the frame

	s.bframe = Frame(s)		# Create a button frame
	s.bframe.setFrameStyle(Frame.Box | Frame.Sunken)# set its style
	
	s.loadButton = PushButton("Load", s.bframe)# create
	s.saveButton = PushButton("Save", s.bframe)# some
	s.quitButton = PushButton("Quit", s.bframe)# buttons

	for x in [s.loadButton, s.saveButton]:# set these to autoresize
	    x.setAutoResize(1)

	s.loadButton.move(10,10)	# move the buttons
	s.saveButton.move(s.loadButton.width() + 10 + 5,10)

	## Resize the quit button
	s.quitButton.resize(5 + s.loadButton.width() + s.saveButton.width(),
			    s.loadButton.height())
	s.quitButton.move(10,y-s.quitButton.height()-2) # move the quit button 

	s.quitButton.connect("clicked",s.Quit,s)# connect
	s.loadButton.connect("clicked",s.Load,s)# the
	s.saveButton.connect("clicked",s.Save,s)# buttons


	# Create some labels saying what we are
	s.ego = [LabelT("Python",s.bframe),
		    LabelT("Qt",s.bframe),
		    LabelT("LSM",s.bframe),
		    LabelT("Editor",s.bframe)]
	
	# have a nice font for the labels
	f = QFontV("brushstroke",24,QFont.Bold,1)

	# use this to position the labels
	y = s.loadButton.height() + s.loadButton.y() + 10
	for x in s.ego:			# do this on all the ego labels
	    x.setFont(f)		# set the font
	    x.setGeometry(5,y,s.bframe.width()-10,50)# set the location
	    x.setAlignment(0x24)	# set alignment to centered
	    y = y + 50			# update y


	# Set the geometry of the button frame
	s.bframe.setGeometry(415,0,
			     25 + s.loadButton.width() + 
			     s.saveButton.width(),s.dframe.height())

	# Set the main widget to this fixed size
	s.setFixedSize(s.dframe.width() + s.bframe.width(),
			  s.bframe.height())

############################################################################

    def Quit(s):
	App.quit()			# quit application

############################################################################

    def Save(s):
	#### Generate filename from fields
	filename = s.edits['Title'].text() + '-'\
		   + s.edits['Version'].text() + ".lsm"

	fileobject = open(filename,"w")	# open file

	## Write data to file
	fileobject.write("Begin3\n")
	for x in s.fields:
	    fileobject.write(x + ":  " + s.edits[x].text() + "\n")
	fileobject.write("End\n")

	fileobject.close()		# close file

############################################################################

    def Load(s):
	#### Generate filename from fields
	filename = s.edits['Title'].text() + '-' \
		   + s.edits['Version'].text() + ".lsm"

	fileobject = open(filename,"r")	# open file
	lines = fileobject.readlines()	# read file into list
	fileobject.close()		# close file

	#### Parse file

	if lines[0] != "Begin3\012":	# brain dead check!
	    print "NOT LSM FILE!!!"
	    return

	del lines[0]			# Get rid of `Begin3'
	del lines[len(lines)-1]		# Get rid of 'End'

	### Take data from file and place in fields on screen
	for x in lines:
	    y = split(x,": ")		# seperate field from value
	    field = y[0]
	    value = y[1]
	    field = rstrip(lstrip(field))# get rid of spaces
	    value = value[0:len(value)-1]# get rid of newline
	    value = rstrip(lstrip(value))# remove spaces
	    s.edits[field].setText(value)# set text of lineedit to value
	    

############################################################################



###########################################################################
# THE PROGRAM STARTS HERE                                                 #
###########################################################################
App = Application()			# initialise application          #
w=LsmWidget()				# Create the LSM widget           #
w.show()				# show it                         #
App.setMainWidget(w)			# make it the main widget         #
App.execLoop()				# execute the application         #
					#                                 #
del App					# clean up                        #
					#                                 #
###########################################################################
