#include <Python.h>
#include "ListBox.h"

ListBox::ListBox(Widget *parent=0, const char* name=0)
  : TableView(parent,name)
{
  if(parent)
    listbox = new QListBox(parent->widget, name);
  else
    listbox = new QListBox(NULL, name);

  setWidget(listbox);
}

ListBox::~ListBox()
{
}

void ListBox::setWidget(QListBox *lb)
{
  listbox = lb;
  QObject::connect(listbox, SIGNAL(highlighted(int)), 
		   this, SLOT(highlighted(int)));
  QObject::connect(listbox, SIGNAL(selected(int)),
		   this, SLOT(selected(int)));

  TableView::setWidget((QTableView*)listbox);
}

void ListBox::setFont(const QFont &f)
{
  listbox->setFont(f);
}

unsigned int ListBox::count() const
{
  return listbox->count();
}

				// bug: index is ignored
void ListBox::insertStrList(PyObject *list, int index = -1)
{
  int length = PyObject_Length(list);
  for(int i=0; i<length; i++)
    {
      PyObject *o = PySequence_GetItem(list,i);
      if(!o)
	continue;
      char *s = PyString_AsString(PyObject_Str(o));
      if(strcmp(s,"<C QPixmap instance>")==0)
	{
	  printf("SORRY! Cannot insert pixmaps yet....use insertPixmap"
		 " instead.\n");
	}
      else
	insertItem(s);
    }
}

void ListBox::insertItem(const char* text, int index = -1)
{
  listbox->insertItem(text,index);
}

void ListBox::insertItem(const QPixmap &pixmap, int index=-1)
{
  listbox->insertItem(pixmap,index);
}

void ListBox::inSort(const char* text)
{
  listbox->inSort(text);
}

void ListBox::removeItem(int index)
{
  listbox->removeItem(index);
}

void ListBox::clear()
{
  listbox->clear();
}

const char* ListBox::text(int index) const
{
  return listbox->text(index);
}

const QPixmap* ListBox::pixmap(int index) const
{
  return listbox->pixmap(index);
}

void ListBox::changeItem(const char* temp, int index)
{
  listbox->changeItem(temp,index);
}

void ListBox::changeItem(const QPixmap& pixmap, int index)
{
  listbox->changeItem(pixmap,index);
}

bool ListBox:: autoUpdate() const
{
  return listbox->autoUpdate();
}

void ListBox::setAutoUpdate(int u)
{
  listbox->setAutoUpdate(u);
}

int ListBox::numItemsVisible() const
{
  return listbox->numItemsVisible();
}

int ListBox::currentItem() const
{
  return listbox->currentItem();
}

void ListBox::setCurrentItem(int index)
{
  listbox->setCurrentItem(index);
}

void ListBox::centerCurrentItem()
{
  listbox->centerCurrentItem();
}

int ListBox::topItem() const
{
  return listbox->topItem();
}

void ListBox::setTopItem(int index)
{
  listbox->setTopItem(index);
}

bool ListBox:: dragSelect() const
{
  return listbox->dragSelect();
}

void ListBox::setDragSelect(int ds)
{
  listbox->setDragSelect(ds);
}

bool ListBox::autoScroll() const
{
  return listbox->autoScroll();
}

void ListBox::setAutoScroll(int as)
{
  listbox->setAutoScroll(as);
}

bool ListBox::autoScrollBar() const
{
  return listbox->autoScrollBar();
}

void ListBox::setAutoScrollBar(int asb)
{
  listbox->setAutoScrollBar(asb);
}
 
bool ListBox::scrollBar() const
{
  return listbox->scrollBar();
}
 
void ListBox::setScrollBar(int sb)
{
  listbox->setScrollBar(sb);
}
 
bool ListBox::autoBottomScrollBar() const
{
  return listbox->autoBottomScrollBar();
}
 
void ListBox::setAutoBottomScrollBar(int absb)
{
  listbox->setAutoBottomScrollBar(absb);
}
 
bool ListBox::bottomScrollBar() const
{
  return listbox->bottomScrollBar();
}

void ListBox::setBottomScrollBar(int sbsb)
{
  listbox->setBottomScrollBar(sbsb);
}
 
bool ListBox::smoothScrolling() const
{
  return listbox->smoothScrolling();
} 

void ListBox::setSmoothScrolling(int ss)
{
  listbox->setSmoothScrolling(ss);
}
 
int ListBox::itemHeight() const
{
  return listbox->itemHeight();
}
 
int ListBox::itemHeight(int index) const
{
  return listbox->itemHeight(index);
}
 
long ListBox::maxItemWidth()
{
  return listbox->maxItemWidth();
}
 

void ListBox::highlighted (int index)
{
  PyObject *args;

  args = Py_BuildValue("(i)",index);
  emit("highlighted",args);
  Py_XDECREF(args);
}
 
void ListBox::selected (int index)
{
  PyObject *args;

  args = Py_BuildValue("(i)",index);
  emit("selected",args);
  Py_XDECREF(args);
}
 


