/////////////////////////////////////////////////////////////////////////////
//
// Main module
//
// Time-stamp: <97/05/06 05:11:51 vels>
// Copyright (c) VDOnet Corp. 1996
//
/////////////////////////////////////////////////////////////////////////////

#include <unistd.h>  
#include <qapp.h>

#include "main.h"
#include "main.moc"

// Some lame GUI
MainWidget::MainWidget(QWidget *parent, const char *name)
  : QWidget(parent, name)
{
  QPushButton *quit = new QPushButton("Quit", this, "quit");
  QPushButton *run = new QPushButton("Run test", this, "quit");

  quit->move(0, 0);
  run->move(quit->x() + quit->width(), 0);

  int width  = quit->width() + run->width();
  int height = quit->height();
  resize(width, height);
  setMinimumSize(width, height);

  connect(quit, SIGNAL(clicked()), qApp, SLOT(quit()));
  connect(run, SIGNAL(clicked()), this, SLOT(runTest()));
}

// Create chain and start it
void MainWidget::runTest()
{
  // Create plugin manager
  m_mng = new KPluginManager();
  connect(m_mng, SIGNAL(finished()), this, SLOT(onChainFinished()));

  KPlugin *dirPlugin, *stdoutPlugin;

  // Load input plugin
  debug("--------- Loading input plugin...");
  if ((dirPlugin=m_mng->loadInputPlugin("dir_plugin")) == NULL)
  {
    delete m_mng;
    return;
  }

  // Directory to show
  dirPlugin->set("dir", "/tmp");

  // Show dot files ?
  bool arg = FALSE;
  dirPlugin->set("dots", &arg);

  // Load output plugin
  debug("--------- Loading output plugin...");
  if ((stdoutPlugin=m_mng->loadOutputPlugin("stdout_plugin")) == NULL)
  {
    delete m_mng;
    return;
  }

  // Execute chain
  debug("--------- Executing chain...");

  // In my example all plugins work in blocking mode (lame), so
  // this function will exit when chain has finished working.
  // But for the sake of example i've used signal finished().
  m_mng->start();

  // Run this program and look and the size of the process.
  // Note that when you press "Run test" button process enlarges
  // (plugins are loaded). When manager is deleted plugins are
  // unloaded from memory and process size restores.
  debug("--------- Sleeping (look at the process size)...");
  sleep(10);

  delete m_mng;
}

// The plugins have finished their work
void MainWidget::onChainFinished()
{
  // Note that you can't delete manager in signal handler, because
  // signal called from manager itself !
  debug("--------- Chain finished.");
}


int main(int argc, char *argv[])
{
  // Create lame GUI
  QApplication *qApp  = new QApplication(argc, argv);

  MainWidget w;
  qApp->setMainWidget(&w);
  w.show();

  return qApp->exec();
}
