/***************************************************************************
    File                 : SpreadsheetDoubleHeaderView.h
    Project              : SciDAVis
    --------------------------------------------------------------------
    Copyright            : (C) 2007 by Tilman Benkert,
    Email (use @ for *)  : thzs*gmx.net
    Description          : Horizontal header for SpreadsheetView displaying comments in a second header

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor,                    *
 *   Boston, MA  02110-1301  USA                                           *
 *                                                                         *
 ***************************************************************************/

#ifndef SPREADSHEETDOUBLEHEADERVIEW_H
#define SPREADSHEETDOUBLEHEADERVIEW_H

#include <QHeaderView>
#include <backend/spreadsheet/SpreadsheetModel.h>


class SpreadsheetCommentsHeaderView : public QHeaderView{
	Q_OBJECT

	public:
		explicit SpreadsheetCommentsHeaderView(QWidget *parent = 0);
		virtual ~SpreadsheetCommentsHeaderView();

	virtual void setModel(QAbstractItemModel * model);

	friend class SpreadsheetDoubleHeaderView; // access to paintSection (protected)
};


class SpreadsheetDoubleHeaderView : public QHeaderView{
	Q_OBJECT

	public:
		explicit SpreadsheetDoubleHeaderView(QWidget * parent = 0);
		~SpreadsheetDoubleHeaderView();

		virtual void setModel(QAbstractItemModel * model);
		virtual QSize sizeHint () const;
		
		void showComments(bool on = true);
		bool areCommentsShown() const;

	private:
		SpreadsheetCommentsHeaderView * m_slave;
		bool m_showComments;
		
	public slots:
		void refresh();
		void headerDataChanged(Qt::Orientation orientation, int logicalFirst, int logicalLast);

	protected slots:
		void sectionsInserted(const QModelIndex & parent, int logicalFirst, int logicalLast);

	protected:
		virtual void paintSection(QPainter * painter, const QRect & rect, int logicalIndex) const;
};

#endif
