#ifndef __MAINWIDGET_H
#define __MAINWIDGET_H

#include <qwidget.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qlabel.h>

class MainWidget : public QWidget
{
Q_OBJECT

public:
	MainWidget(QWidget* parent);

private slots:
	void slotCalculate();
	void slotClose();
	void slotAbout();

private:
	void fillDays(QComboBox* comboBox);
	void fillMonths(QComboBox* comboBox);

	bool getDate(QComboBox* comboBoxDay, QComboBox* comboBoxMonth,
		QLineEdit* lineEditYear, int& day, int& month, int& year,
		QString& errorMessage);
	bool validateDate(int day, int month, int year,
		QString& errorMessage);

	int calculateDiff(int day1, int month1, int year1,
		int day2, int month2, int year2);
	int getDayCountFromStart(int day, int month, int year);

	int getLastDayOfGregorianMonth(int month, int year);
	bool isGregorianLeapYear(int year);

	QComboBox* m_comboboxFirstDay;
	QComboBox* m_comboboxFirstMonth;
	QLineEdit* m_lineeditFirstYear;
	QComboBox* m_comboboxSecondDay;
	QComboBox* m_comboboxSecondMonth;
	QLineEdit* m_lineeditSecondYear;
	QLabel* m_labelResult;
};

#endif

