/****************************************************************
Copyright (c) 1998 Sandro Sigala <ssigala@globalnet.it>.
All rights reserved.

Permission to use, copy, modify, and distribute this software
and its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name of the author not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

The author disclaim all warranties with regard to this
software, including all implied warranties of merchantability
and fitness.  In no event shall the author be liable for any
special, indirect or consequential damages or any damages
whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortious action,
arising out of or in connection with the use or performance of
this software.
****************************************************************/

#include "config.h"

#include <klocale.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>

#include "newscoredialog.h"
#include <klocale.h>

NewScoreDialog::NewScoreDialog(QWidget *parent, const char *name)
        : QDialog(parent, name, true)
{
        setCaption(i18n("New High Score"));

        QPushButton *ok, *cancel;
        ok = new QPushButton(i18n("OK"), this);
        ok->setGeometry(10, 60, 70, 30);
        ok->setDefault(true);
        connect(ok, SIGNAL(clicked()), SLOT(accept()));
        cancel = new QPushButton(i18n("Cancel"), this);
        cancel->setGeometry(140, 60, 70, 30);
        connect(cancel, SIGNAL(clicked()), SLOT(reject()));

        QLabel *label = new QLabel(i18n("Enter name"), this);
        label->move(10, 10);
        le = new QLineEdit(this);
        le->move(label->x() + label->width(), 10);
        le->setFocus();
}

QString NewScoreDialog::name()
{
        return le->text();
}
