/* This file is part of the KDE libraries
   Copyright (C) 2001 Kurt Granroth <granroth@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "plugin_babelfish.h"

#include <kaction.h>
#include <kinstance.h>
#include <kmessagebox.h>
#include <klocale.h>

#include <khtml_part.h>

PluginBabelFish::PluginBabelFish( QObject* parent, const char* name )
  : Plugin( parent, name )
{
  KActionMenu *menu;
  menu = new KActionMenu( i18n("Tr&anslate Web Page"), "babelfish",
                          actionCollection(), "translatewebpage" );
  menu->setDelayed( false );

  menu->insert( new KAction( i18n("English to French"), 0,
                             this, SLOT(slotTranslateEN_FR()),
                             actionCollection(), "en_fr") );
  menu->insert( new KAction( i18n("English to German"), 0,
                             this, SLOT(slotTranslateEN_DE()),
                             actionCollection(), "en_de") );
  menu->insert( new KAction( i18n("English to Italian"), 0,
                             this, SLOT(slotTranslateEN_IT()),
                             actionCollection(), "en_it") );
  menu->insert( new KAction( i18n("English to Portuguese"), 0,
                             this, SLOT(slotTranslateEN_PT()),
                             actionCollection(), "en_pt") );
  menu->insert( new KAction( i18n("English to Spanish"), 0,
                             this, SLOT(slotTranslateEN_ES()),
                             actionCollection(), "en_es") );
  menu->insert( new KAction( i18n("French to English"), 0,
                             this, SLOT(slotTranslateFR_EN()),
                             actionCollection(), "fr_en") );
  menu->insert( new KAction( i18n("German to English"), 0,
                             this, SLOT(slotTranslateDE_EN()),
                             actionCollection(), "de_en") );
  menu->insert( new KAction( i18n("Italian to English"), 0,
                             this, SLOT(slotTranslateIT_EN()),
                             actionCollection(), "it_en") );
  menu->insert( new KAction( i18n("Portuguese to English"), 0,
                             this, SLOT(slotTranslatePT_EN()),
                             actionCollection(), "pt_en") );
  menu->insert( new KAction( i18n("Spanish to English"), 0,
                             this, SLOT(slotTranslateES_EN()),
                             actionCollection(), "es_en") );
  menu->insert( new KAction( i18n("Russian to English"), 0,
                             this, SLOT(slotTranslateRU_EN()),
                             actionCollection(), "ru_en") );
  menu->insert( new KAction( i18n("German to French"), 0,
                             this, SLOT(slotTranslateDE_FR()),
                             actionCollection(), "de_fr") );
  menu->insert( new KAction( i18n("French to German"), 0,
                             this, SLOT(slotTranslateFR_DE()),
                             actionCollection(), "fr_de") );
}

PluginBabelFish::~PluginBabelFish()
{
}

void PluginBabelFish::translateURL( const QString& lang )
{
  // The parent is assumed to be a KHTMLPart
  if ( !parent()->inherits("KHTMLPart") )
  {
    QString title = i18n( "Cannot translate source" );
    QString text = i18n( "You cannot translate anything except web pages with\n"
                         "this plugin, sorry." );

    KMessageBox::sorry( 0L, text, title );
    return;
  }

  // Get URL
  KHTMLPart *part = dynamic_cast<KHTMLPart *>(parent());

  QString query;
  // we check if we have text selected.  if so, we translate that.  if
  // not, we translate the url
  if ( part->hasSelection() )
    query = "text=" + KURL::encode_string( part->selectedText() );
  else
  {
    KURL url = part->url();
    query = "urltext=" + KURL::encode_string( url.url() );

    // Check syntax
    if ( url.isMalformed() )
    {
      QString title = i18n( "Malformed URL" );
      QString text = i18n( "The URL you entered is not valid, please "
                           "correct it and try again" );
      KMessageBox::sorry( 0L, text, title );
      return;
    }
  }

  // Create babelfish URL
  KURL babel( "http://babel.altavista.com/translate.dyn" );

  // Handle the language
  query += "&lp=";
  query += lang;

  babel.setQuery( query );

  // Connect to the fish
  part->openURL( babel );
}

void PluginBabelFish::slotTranslateEN_FR() {
  translateURL( "en_fr" );
}
void PluginBabelFish::slotTranslateEN_DE() {
  translateURL( "en_de" );
}
void PluginBabelFish::slotTranslateEN_IT() {
  translateURL( "en_it" );
}
void PluginBabelFish::slotTranslateEN_PT() {
  translateURL( "en_pt" );
}
void PluginBabelFish::slotTranslateEN_ES() {
  translateURL( "en_es" );
}
void PluginBabelFish::slotTranslateFR_EN() {
  translateURL( "fr_en" );
}
void PluginBabelFish::slotTranslateDE_EN() {
  translateURL( "de_en" );
}
void PluginBabelFish::slotTranslateIT_EN() {
  translateURL( "it_en" );
}
void PluginBabelFish::slotTranslatePT_EN() {
  translateURL( "pt_en" );
}
void PluginBabelFish::slotTranslateES_EN() {
  translateURL( "es_en" );
}
void PluginBabelFish::slotTranslateRU_EN() {
  translateURL( "ru_en" );
}
void PluginBabelFish::slotTranslateFR_DE() {
  translateURL( "fr_de" );
}
void PluginBabelFish::slotTranslateDE_FR() {
  translateURL( "de_fr" );
}

BabelFishFactory::BabelFishFactory()
{
}

BabelFishFactory::~BabelFishFactory()
{
  delete s_instance;
  s_instance = 0;
}

QObject* BabelFishFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
  return new PluginBabelFish( parent, name );
}

KInstance *BabelFishFactory::instance()
{
  if ( !s_instance )
    s_instance = new KInstance( "babelfish" );
  return s_instance;
}

extern "C"
{
  void* init_libbabelfishplugin()
  {
    KGlobal::locale()->insertCatalogue("babelfish"); 
    return new BabelFishFactory;
  }
}

KInstance* BabelFishFactory::s_instance = 0L;

#include <plugin_babelfish.moc>
