"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaType = void 0;
exports.getMediaPreviewType = getMediaPreviewType;
const vscode_uri_1 = require("vscode-uri");
var MediaType;
(function (MediaType) {
    MediaType[MediaType["Image"] = 0] = "Image";
    MediaType[MediaType["Video"] = 1] = "Video";
})(MediaType || (exports.MediaType = MediaType = {}));
/**
 * List of common file extensions that can be previewed.
 */
const previewableMediaFileExtension = new Map([
    // Image
    ['.bmp', MediaType.Image],
    ['.gif', MediaType.Image],
    ['.jpg', MediaType.Image],
    ['.jpeg', MediaType.Image],
    ['.png', MediaType.Image],
    ['.svg', MediaType.Image],
    ['.webp', MediaType.Image],
    ['.ico', MediaType.Image],
    ['.tiff', MediaType.Image],
    ['.tif', MediaType.Image],
    // Video
    ['.mp4', MediaType.Video],
]);
function getMediaPreviewType(uri) {
    const ext = vscode_uri_1.Utils.extname(uri).toLowerCase();
    return previewableMediaFileExtension.get(ext);
}
//# sourceMappingURL=media.js.map