/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.chart;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectData;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.IBasicMappingNode;
import org.eclipse.rcptt.tesla.internal.ui.SWTElementMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.AbstractSWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.processors.IModelMapperHelper;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtchart.Chart;

public class ChartProcessor
implements ITeslaCommandProcessor,
IModelMapperHelper {
    private static final ElementKind[] allSelectors = new ElementKind[]{ElementKind.DiagramFigure, ElementKind.Menu};
    private SWTUIProcessor swtUIProcessor;
    private ISWTUIPlayerExtension extension = new AbstractSWTUIPlayerExtension(){

        public GenericElementKind getKind(Object w) {
            return w instanceof Chart ? new GenericElementKind(ElementKind.DiagramFigure) : null;
        }

        public SWTUIElement select(SWTUIPlayer swtuiPlayer, PlayerSelectionFilter f) {
            if (f.kind.is(ElementKind.DiagramFigure)) {
                return swtuiPlayer.selectWidget(f, new Class[]{Chart.class});
            }
            return null;
        }
    };

    public ChartProcessor() {
        SWTUIPlayer.addExtension((ISWTUIPlayerExtension)this.extension);
    }

    public EObject getElementModel(Element element) {
        SWTUIElement swtuiElement = (SWTUIElement)this.getMapper().get(element);
        if (swtuiElement != null) {
            return swtuiElement.getModel();
        }
        return null;
    }

    public int getPriority() {
        return 30;
    }

    public String getFeatureID() {
        return "org.eclipse.rcptt.tesla.swt.chart";
    }

    public boolean isSelectorSupported(String kind) {
        ElementKind[] elementKindArray = allSelectors;
        int n = allSelectors.length;
        int n2 = 0;
        while (n2 < n) {
            ElementKind e = elementKindArray[n2];
            if (e.name().equals(kind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        SelectData data = cmd.getData();
        SWTUIElement parent = (SWTUIElement)this.getMapper().get(data.getParent());
        SWTUIElement after = (SWTUIElement)this.getMapper().get(data.getAfter());
        if (parent == null && after != null) {
            parent = this.getPlayer().getParentElement(after);
        }
        SWTUIElement result = null;
        if (data.getKind().equals(ElementKind.Menu.name())) {
            if (parent.widget == null || !parent.getKind().name().equals(ElementKind.DiagramFigure.name())) return null;
            Chart chart = (Chart)parent.widget;
            if (chart.getMenu() != null) {
                SWTUIElement element = new SWTUIElement((Widget)chart, parent.getPlayer());
                result = this.selectElement(element, data);
            }
            if (result == null) {
                Control control = chart.getPlotArea().getControl();
                SWTUIElement element = new SWTUIElement((Widget)control, parent.getPlayer());
                result = this.selectElement(element, data);
            }
        } else {
            result = this.selectElement(parent, data);
        }
        SelectResponse response = ProtocolFactory.eINSTANCE.createSelectResponse();
        if (result == null) {
            return null;
        }
        response.getElements().add((Object)this.getMapper().get((IBasicMappingNode)result));
        return response;
    }

    public boolean isCommandSupported(Command cmd) {
        return false;
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        return this.swtUIProcessor.executeCommand(command, mapper);
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        return null;
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.swtUIProcessor = (SWTUIProcessor)client.getProcessor(SWTUIProcessor.class);
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
    }

    public boolean isInactivityRequired() {
        return true;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        return true;
    }

    public void clean() {
    }

    public void terminate() {
        SWTUIPlayer.removeExtension((ISWTUIPlayerExtension)this.extension);
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
    }

    public void notifyUI() {
    }

    private synchronized SWTUIPlayer getPlayer() {
        return this.swtUIProcessor.getPlayer();
    }

    private SWTElementMapper getMapper() {
        return this.swtUIProcessor.getMapper();
    }

    private SWTUIElement selectElement(SWTUIElement parent, SelectData data) {
        SWTUIElement after = (SWTUIElement)this.getMapper().get(data.getAfter());
        EList path = data.getPath();
        String[] pathArray = null;
        if (path.size() > 0) {
            pathArray = (String[])path.toArray((Object[])new String[path.size()]);
        }
        EList indexes = data.getIndexes();
        PlayerSelectionFilter filter = new PlayerSelectionFilter(parent, GenericElementKind.fromString((String)data.getKind()), data.getPattern(), pathArray, data.getIndex(), after, (Integer[])indexes.toArray((Object[])new Integer[data.getIndexes().size()]), data.getClassPattern());
        return this.getPlayer().select(filter);
    }
}

