/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;

public class DeclarationContainer {
    private final DeclarationContainer parent;
    private Map<String, Declaration> declarations = new LinkedHashMap<String, Declaration>();

    public DeclarationContainer(DeclarationContainer parent) {
        this.parent = parent;
    }

    public synchronized Iterable<Declaration> declarations() {
        return this.declarations.values();
    }

    public synchronized void declare(String name, Declaration decl) throws CoreException {
        this.declare(name, decl, false);
    }

    public synchronized Declaration lookup(String name) {
        Declaration decl = this.declarations.get(name);
        if (decl != null) {
            return decl;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(name);
    }

    public synchronized void declare(String name, Declaration decl, boolean override) throws CoreException {
        if (this.declarations.containsKey(name) && !override) {
            throw new CoreException(CorePlugin.err(String.format("'%s' already declared", name)));
        }
        this.declarations.put(name, decl);
    }
}

