/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import org.eclipse.e4.ui.progress.internal.AnimationManager;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AnimationItem {
    private final AnimationManager animationManager;
    IAnimationContainer animationContainer = new IAnimationContainer(){

        @Override
        public void animationDone() {
        }

        @Override
        public void animationStart() {
        }
    };

    public AnimationItem(AnimationManager animationManager) {
        this.animationManager = animationManager;
    }

    public void createControl(Composite parent) {
        Control animationItem = this.createAnimationItem(parent);
        animationItem.addMouseListener(MouseListener.mouseDoubleClickAdapter(e -> ProgressManagerUtil.openProgressView()));
        animationItem.addDisposeListener(e -> this.animationManager.removeItem(this));
        this.animationManager.addItem(this);
    }

    protected abstract Control createAnimationItem(Composite var1);

    void paintImage(PaintEvent event, Image image, ImageData imageData) {
        event.gc.drawImage(image, 0, 0);
    }

    public abstract Control getControl();

    void animationStart() {
        this.animationContainer.animationStart();
    }

    void animationDone() {
        this.animationContainer.animationDone();
    }

    public int getPreferredWidth() {
        return this.animationManager.getPreferredWidth() + 5;
    }

    void setAnimationContainer(IAnimationContainer container) {
        this.animationContainer = container;
    }

    static interface IAnimationContainer {
        public void animationStart();

        public void animationDone();
    }
}

