/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PropertySource
implements ExtendedPropertySheetPage.IUnsettablePropertySource {
    protected Object object;
    protected IItemPropertySource itemPropertySource;

    public PropertySource(Object object, IItemPropertySource itemPropertySource) {
        this.object = object;
        this.itemPropertySource = itemPropertySource;
    }

    public Object getObject() {
        return this.object;
    }

    public IItemPropertySource getItemPropertySource() {
        return this.itemPropertySource;
    }

    public Object getEditableValue() {
        return this.itemPropertySource.getEditableValue(this.object);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        List itemPropertyDescriptors = this.itemPropertySource.getPropertyDescriptors(this.object);
        if (itemPropertyDescriptors != null) {
            for (IItemPropertyDescriptor itemPropertyDescriptor : itemPropertyDescriptors) {
                result.add(this.createPropertyDescriptor(itemPropertyDescriptor));
            }
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
        return new PropertyDescriptor(this.object, itemPropertyDescriptor);
    }

    protected IItemPropertyDescriptor getItemPropertyDescriptor(Object propertyId) {
        return this.itemPropertySource.getPropertyDescriptor(this.object, propertyId);
    }

    public Object getPropertyValue(Object propertyId) {
        return this.getItemPropertyDescriptor(propertyId).getPropertyValue(this.object);
    }

    public boolean isPropertySet(Object propertyId) {
        return this.getItemPropertyDescriptor(propertyId).isPropertySet(this.object);
    }

    public boolean isPropertyResettable(Object propertyId) {
        IItemPropertyDescriptor propertyDescriptor = this.getItemPropertyDescriptor(propertyId);
        return propertyDescriptor.canSetProperty(this.object) && propertyDescriptor.isPropertySet(this.object);
    }

    public void resetPropertyValue(Object propertyId) {
        this.getItemPropertyDescriptor(propertyId).resetPropertyValue(this.object);
    }

    public void setPropertyValue(Object propertyId, Object value) {
        this.getItemPropertyDescriptor(propertyId).setPropertyValue(this.object, value);
    }

    @Override
    public boolean isPropertyUnsettable(Object propertyId) {
        IItemPropertyDescriptor propertyDescriptor = this.getItemPropertyDescriptor(propertyId);
        return propertyDescriptor.canSetProperty(this.object) && propertyDescriptor instanceof IItemPropertyDescriptor.ValueHandlerProvider && ((IItemPropertyDescriptor.ValueHandlerProvider)propertyDescriptor).isPropertyUnsettable(this.object);
    }
}

