/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.external.api;

/**
 * A Generic Exception for external use.
 */
public class LSATException extends Exception {
    private static final long serialVersionUID = 1L;

    /**
     * @param message
     * @param cause
     * @param enableSuppression
     * @param writableStackTrace
     */
    public LSATException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    /**
     * @param message
     * @param cause
     */
    public LSATException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * @param message
     */
    public LSATException(String message) {
        super(message);
    }

    /**
     * @param cause
     */
    public LSATException(Throwable cause) {
        super(cause);
    }
}
