/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.engine.python.ui.handlers;

import activity.ActivitySet;
import activity.util.Event2Resource;
import common.ImportContainer;
import common.util.ImportsFlattener;
import dispatching.ActivityDispatching;
import dispatching.util.DispatchingUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;
import org.eclipse.lsat.common.emf.ecore.resource.PersistorFactory;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceSetUtil;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.graph.directed.util.DirectedGraphQueries;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.common.scheduler.algorithm.BellmanFordScheduler;
import org.eclipse.lsat.common.scheduler.algorithm.SchedulerException;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.engine.python.generator.GenerateActivityDispatching;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.scheduler.AddExecutionTimes;
import org.eclipse.lsat.scheduler.AnnotateClaimRelease;
import org.eclipse.lsat.scheduler.CleanupGraph;
import org.eclipse.lsat.scheduler.CleanupSchedule;
import org.eclipse.lsat.scheduler.Dispatching2Graph;
import org.eclipse.lsat.scheduler.Dispatching2GraphOutput;
import org.eclipse.lsat.scheduler.RemoveEvents;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.lsat.timing.util.TimingCalculator;
import setting.SettingUtil;
import setting.Settings;

public class ExecutionEngineGeneratorJob
extends Job {
    private final IFile modelIFile;
    private final File saveFolder;
    private final boolean removeClaimAndReleases;
    private final boolean simulate;

    public ExecutionEngineGeneratorJob(IFile modelIFile, File saveFolder, boolean removeClaimAndReleases, boolean simulate) {
        super("TwinscanCodeGenJob");
        this.modelIFile = modelIFile;
        this.saveFolder = saveFolder;
        this.removeClaimAndReleases = removeClaimAndReleases;
        this.simulate = simulate;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.doGenerate(monitor);
            this.modelIFile.getProject().refreshLocal(2, monitor);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.lsat.engine.python", e.getMessage(), (Throwable)e);
        }
    }

    public File doGenerate(IProgressMonitor monitor) throws QvtoTransformationException, MotionException, IOException, CoreException, SpecificationException, SchedulerException {
        try {
            monitor.beginTask("Generating TWINSCAN code", 100);
            PersistorFactory factory = new PersistorFactory();
            URI modelURI = URIHelper.asURI((IResource)this.modelIFile);
            monitor.subTask("Preparing specification for code generation");
            Persistor dispatchingPersistor = factory.getPersistor(ActivityDispatching.class);
            ActivityDispatching activityDispatching = (ActivityDispatching)dispatchingPersistor.loadOne(modelURI);
            Settings settings = SettingUtil.getSettings((Resource)activityDispatching.eResource());
            EcoreUtil.resolveAll((ResourceSet)factory.getResourceSet());
            ResourceSet resourceSet = ImportsFlattener.flatten((URI)modelURI, (ImportContainer[])new ImportContainer[]{activityDispatching, settings});
            activityDispatching = (ActivityDispatching)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, ActivityDispatching.class);
            settings = (Settings)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, Settings.class);
            ActivitySet activitySet = (ActivitySet)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, ActivitySet.class);
            Event2Resource.surroundEventsWithClaimRelease((ActivitySet)activitySet);
            DispatchingUtil.expand((ActivityDispatching)activityDispatching);
            DispatchingUtil.removeUnusedActivities((ActivityDispatching)activityDispatching);
            Dispatching2Graph d2g = new Dispatching2Graph();
            Dispatching2GraphOutput d2gResult = (Dispatching2GraphOutput)d2g.transformModel((Object)activityDispatching, monitor);
            TaskDependencyGraph taskDependencyGraph = d2gResult.getTaskDependencyGraph();
            taskDependencyGraph = RemoveEvents.transformModel((TaskDependencyGraph)taskDependencyGraph);
            CleanupGraph cleanupGraph = new CleanupGraph(false, CleanupGraph.RemoveClaimReleaseStrategy.KeepAll);
            TaskDependencyGraph graph = (TaskDependencyGraph)cleanupGraph.transformModel((Object)taskDependencyGraph, monitor);
            graph = AnnotateClaimRelease.transformModel((TaskDependencyGraph)graph);
            MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
            TimingCalculator timingCalculator = new TimingCalculator(settings, motionCalculator);
            AddExecutionTimes addExecutionTimes = new AddExecutionTimes((ITimingCalculator)timingCalculator);
            graph = addExecutionTimes.transformModel(graph);
            BellmanFordScheduler scheduler = new BellmanFordScheduler();
            Schedule schedule = scheduler.createSchedule(graph);
            schedule.setName(URIHelper.baseName((IResource)this.modelIFile));
            if (this.removeClaimAndReleases) {
                CleanupSchedule cleanupSchedule = new CleanupSchedule(CleanupSchedule.ClaimReleaseStrategy.RemoveCompletely);
                schedule = (Schedule)cleanupSchedule.transformModel((Object)schedule, null);
            }
            monitor.worked(50);
            monitor.subTask("Generating code");
            EList tasks = DirectedGraphQueries.reverseTopologicalOrdering((Iterable)DirectedGraphQueries.allSubNodes((DirectedGraph)schedule), Comparator.comparing(Node::getName));
            schedule.getNodes().clear();
            schedule.getNodes().addAll((Collection)tasks);
            GenerateActivityDispatching codeGenerator = new GenerateActivityDispatching((EObject)schedule, this.saveFolder, Arrays.asList(this.simulate, settings));
            codeGenerator.generate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            monitor.worked(50);
            File file = new File(this.saveFolder, graph.getName() + ".py");
            return file;
        }
        finally {
            monitor.done();
        }
    }
}

