/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.dispatching.teditor.ui.contentassist;

import dispatching.ActivityDispatching;
import dispatching.Attribute;
import dispatching.HasUserAttributes;
import dispatching.impl.AttributesMapEntryImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
@SuppressWarnings("all")
public class DispatchingProposalProvider extends AbstractDispatchingProposalProvider {
  @Override
  public void complete_AttributesMapEntry(final EObject model, final RuleCall rule, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_AttributesMapEntry(model, rule, context, acceptor);
    final ActivityDispatching activityDispatching = EcoreUtil2.<ActivityDispatching>getContainerOfType(model, ActivityDispatching.class);
    final HasUserAttributes container = EcoreUtil2.<HasUserAttributes>getContainerOfType(model, HasUserAttributes.class);
    final LinkedHashMap<Attribute, String> attrs = CollectionLiterals.<Attribute, String>newLinkedHashMap();
    this.collectUserAttributes(attrs, activityDispatching, container.getClass());
    boolean _isEmpty = attrs.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final Function1<Attribute, String> _function = (Attribute it) -> {
        return it.getName();
      };
      final Function1<String, Boolean> _function_1 = (String nm) -> {
        final Function1<Attribute, Boolean> _function_2 = (Attribute it) -> {
          String _name = it.getName();
          return Boolean.valueOf(Objects.equals(nm, _name));
        };
        Attribute _findFirst = IterableExtensions.<Attribute>findFirst(container.getUserAttributes().keySet(), _function_2);
        return Boolean.valueOf((_findFirst == null));
      };
      final Consumer<String> _function_2 = (String it) -> {
        acceptor.accept(this.createCompletionProposal((it + ": "), it, null, context));
      };
      IterableExtensions.<String>filter(IterableExtensions.<Attribute, String>map(attrs.keySet(), _function), _function_1).forEach(_function_2);
    }
  }

  @Override
  public void complete_IDString(final EObject model, final RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_IDString(model, ruleCall, context, acceptor);
    this.complete_AttributesMapEntryValue(model, ruleCall, context, acceptor);
  }

  @Override
  public void complete_INTASString(final EObject model, final RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_INTASString(model, ruleCall, context, acceptor);
    this.complete_AttributesMapEntryValue(model, ruleCall, context, acceptor);
  }

  private void collectUserAttributes(final Map<Attribute, String> result, final EObject object, final Class<?> clazz) {
    if ((object instanceof HasUserAttributes)) {
      boolean _isInstance = clazz.isInstance(object);
      if (_isInstance) {
        final Consumer<Map.Entry<Attribute, String>> _function = (Map.Entry<Attribute, String> it) -> {
          result.put(it.getKey(), it.getValue());
        };
        ((HasUserAttributes)object).getUserAttributes().forEach(_function);
      }
    }
    if ((object != null)) {
      final Consumer<EObject> _function_1 = (EObject it) -> {
        this.collectUserAttributes(result, it, clazz);
      };
      object.eContents().forEach(_function_1);
    }
  }

  private void complete_AttributesMapEntryValue(final EObject model, final RuleCall rule, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final ActivityDispatching activityDispatching = EcoreUtil2.<ActivityDispatching>getContainerOfType(model, ActivityDispatching.class);
    final HasUserAttributes container = EcoreUtil2.<HasUserAttributes>getContainerOfType(model, HasUserAttributes.class);
    Attribute _key = null;
    if (((AttributesMapEntryImpl) model)!=null) {
      _key=((AttributesMapEntryImpl) model).getKey();
    }
    String _name = null;
    if (_key!=null) {
      _name=_key.getName();
    }
    final String keyName = _name;
    final LinkedHashMap<Attribute, String> attrs = CollectionLiterals.<Attribute, String>newLinkedHashMap();
    this.collectUserAttributes(attrs, activityDispatching, container.getClass());
    if (((!attrs.isEmpty()) && (keyName != null))) {
      final Function1<Map.Entry<Attribute, String>, Boolean> _function = (Map.Entry<Attribute, String> it) -> {
        String _name_1 = it.getKey().getName();
        return Boolean.valueOf(Objects.equals(keyName, _name_1));
      };
      final Function1<Map.Entry<Attribute, String>, String> _function_1 = (Map.Entry<Attribute, String> it) -> {
        return it.getValue();
      };
      final Consumer<String> _function_2 = (String it) -> {
        acceptor.accept(this.createCompletionProposal(this.quote(it), it, null, context));
      };
      IterableExtensions.<String>toSet(IterableExtensions.<String>filterNull(IterableExtensions.<Map.Entry<Attribute, String>, String>map(IterableExtensions.<Map.Entry<Attribute, String>>filter(attrs.entrySet(), _function), _function_1))).forEach(_function_2);
    }
  }

  private String quote(final String string) {
    String _xifexpression = null;
    boolean _matches = string.matches("(\\w)*");
    if (_matches) {
      _xifexpression = string;
    } else {
      _xifexpression = (("\"" + string) + "\"");
    }
    return _xifexpression;
  }
}
