/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.io.File;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.AppProperties;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.PlatformUtils;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.io.StdAppStream;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.DateTimeUtils;
import org.eclipse.escet.common.java.FileSizes;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public final class CrashReport {
    private CrashReport() {
    }

    public static void main(String[] args) {
        final Application<IOutputComponent> app = new Application<IOutputComponent>(){

            @Override
            protected OutputProvider<IOutputComponent> createProvider() {
                return null;
            }

            @Override
            protected int runInternal() {
                return 0;
            }

            @Override
            public String getAppName() {
                return "Test App Name";
            }

            @Override
            public String getAppDescription() {
                return "Test App Description.";
            }

            @Override
            public String getAppToolDefLibName() {
                return null;
            }

            @Override
            public String getAppToolDefToolName() {
                return null;
            }

            @Override
            protected OptionCategory getAllOptions() {
                return null;
            }
        };
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                AppEnv.registerApplication(new AppEnvData(app));
                try {
                    throw new IllegalArgumentException("Crash report test.");
                }
                catch (Exception ex) {
                    CrashReport.writeCrashReport(ex, StdAppStream.OUT);
                    return;
                }
            }
        });
        t.start();
    }

    public static String writeCrashReportFile(Throwable ex) {
        File tempFile;
        File tempDir = new File(Paths.getCurWorkingDir());
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS", Locale.US);
            tempFile = File.createTempFile("crash_report_" + df.format(new Date()) + "_", ".log", tempDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create crash report file.", e);
        }
        String tempFilePath = tempFile.getAbsolutePath();
        try (FileAppStream s = null;){
            s = new FileAppStream(tempFilePath, tempFilePath);
            CrashReport.writeCrashReport(ex, s);
            s.flush();
            s.close();
        }
        return tempFilePath;
    }

    public static void writeCrashReport(Throwable ex, AppStream s) {
        String[][] localeTable;
        String isoLanguage;
        String isoCountry;
        Application<?> app = AppEnv.getApplication();
        s.println("[Reporting]");
        String[] stringArray = Strings.wrap((String[])new String[]{app.getCrashReportIssueReportingInstructions()});
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            s.println(line);
            ++n2;
        }
        s.println();
        s.println("[Exception]");
        s.printStackTrace(ex);
        s.println();
        s.println("[Application]");
        s.println("Application name    = " + app.getAppName());
        s.println("Application version = " + app.getAppVersionSafe());
        s.println("Application class   = " + app.getClass().getName());
        s.println();
        s.println("[Options]");
        s.println("Command line arguments = " + AppEnv.getProperty("org.eclipse.escet.common.app.framework.args.cmdline"));
        s.println("Dialog arguments       = " + AppEnv.getProperty("org.eclipse.escet.common.app.framework.args.dialog", "N/A"));
        s.println("Final arguments        = " + AppEnv.getProperty("org.eclipse.escet.common.app.framework.args.final"));
        s.println();
        s.println("[Date/time]");
        long startEpoch = Long.parseLong(AppEnv.getProperty("org.eclipse.escet.common.app.framework.start.epoch", "0"));
        long startNano = Long.parseLong(AppEnv.getProperty("org.eclipse.escet.common.app.framework.start.nanos", "0"));
        Date startDate = new Date(startEpoch);
        Date curDate = new Date();
        long curNano = System.nanoTime();
        long runningTime = curNano - startNano;
        String[][] dateTable = new String[][]{{"App start (local)", "=", DateTimeUtils.formatDateTime((Date)startDate, (boolean)false, (boolean)true)}, {"App start (UTC)", "=", DateTimeUtils.formatDateTime((Date)startDate, (boolean)true, (boolean)true)}, {"Crash (local)", "=", DateTimeUtils.formatDateTime((Date)curDate, (boolean)false, (boolean)true)}, {"Crash (UTC)", "=", DateTimeUtils.formatDateTime((Date)curDate, (boolean)true, (boolean)true)}, {"App running time", "=", DateTimeUtils.durationToString((long)DateTimeUtils.nanoTimeToMillis((long)runningTime), (boolean)false)}};
        s.println(CrashReport.formatTable(dateTable));
        s.println();
        s.println("[System Properties]");
        s.println(CrashReport.formatTable(CrashReport.sortTable(CrashReport.getPropertiesTable())));
        s.println();
        s.println("[Environment]");
        s.println(CrashReport.formatTable(CrashReport.sortTable(CrashReport.getEnvironmentTable())));
        s.println();
        s.println("[JVM Runtime]");
        Runtime r = Runtime.getRuntime();
        String[][] runtimeTable = new String[][]{{"Processors", "=", String.valueOf(r.availableProcessors())}, {"Memory (free)", "=", FileSizes.formatFileSizeEx((long)r.freeMemory())}, {"Memory (max)", "=", FileSizes.formatFileSizeEx((long)r.maxMemory())}, {"Memory (total)", "=", FileSizes.formatFileSizeEx((long)r.totalMemory())}, {"Default class loader", "=", ClassLoader.getSystemClassLoader().getClass().getName()}};
        s.println(CrashReport.formatTable(runtimeTable));
        s.println();
        s.println("[Threads]");
        CrashReport.printThreadGroups(CrashReport.getRootThreadGroup(), s, 0);
        s.println();
        s.println("[File systems]");
        File[] roots = File.listRoots();
        if (roots == null) {
            s.println("(file system roots could not be determined)");
        } else {
            File[] fileArray = File.listRoots();
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                File root = fileArray[n4];
                s.println("Path: " + root.getPath());
                s.println("    Free space   = " + FileSizes.formatFileSizeEx((long)root.getFreeSpace()));
                s.println("    Total space  = " + FileSizes.formatFileSizeEx((long)root.getTotalSpace()));
                s.println("    Usable space = " + FileSizes.formatFileSizeEx((long)root.getUsableSpace()));
                ++n4;
            }
        }
        s.println();
        s.println("[Locale]");
        Locale locale = Locale.getDefault();
        try {
            isoCountry = locale.getISO3Country();
        }
        catch (MissingResourceException e) {
            isoCountry = "<unknown>";
        }
        try {
            isoLanguage = locale.getISO3Language();
        }
        catch (MissingResourceException e) {
            isoLanguage = "<unknown>";
        }
        String[][] stringArray2 = localeTable = new String[][]{{"Default locale", "=", locale.toString()}, {"Country", "=", locale.getCountry()}, {"Display country", "=", locale.getDisplayCountry()}, {"Display language", "=", locale.getDisplayLanguage()}, {"Display name", "=", locale.getDisplayName()}, {"Display variant", "=", locale.getDisplayVariant()}, {"ISO 3166 country", "=", isoCountry}, {"ISO 639-2/T language", "=", isoLanguage}, {"Language", "=", locale.getLanguage()}, {"Variant", "=", locale.getVariant()}};
        int n5 = localeTable.length;
        int n6 = 0;
        while (n6 < n5) {
            String[] localeEntry = stringArray2[n6];
            localeEntry[2] = Strings.stringToJava((String)localeEntry[2]);
            ++n6;
        }
        s.println(CrashReport.formatTable(localeTable));
        s.println();
        s.println("[Management data]");
        ClassLoadingMXBean clbean = ManagementFactory.getClassLoadingMXBean();
        CompilationMXBean cmpbean = ManagementFactory.getCompilationMXBean();
        MemoryMXBean membean = ManagementFactory.getMemoryMXBean();
        OperatingSystemMXBean osbean = ManagementFactory.getOperatingSystemMXBean();
        RuntimeMXBean rtbean = ManagementFactory.getRuntimeMXBean();
        ThreadMXBean tbean = ManagementFactory.getThreadMXBean();
        Date startTime = new Date(rtbean.getStartTime());
        String[][] managementTable = new String[][]{{"Current loaded class count", "=", String.valueOf(clbean.getLoadedClassCount())}, {"Total loaded class count", "=", String.valueOf(clbean.getTotalLoadedClassCount())}, {"Unloaded class count", "=", String.valueOf(clbean.getUnloadedClassCount())}, {"JIT compiler name", "=", cmpbean == null ? "<N/A>" : cmpbean.getName()}, {"Total compilation time", "=", cmpbean == null ? "<N/A>" : (cmpbean.isCompilationTimeMonitoringSupported() ? DateTimeUtils.durationToString((long)cmpbean.getTotalCompilationTime(), (boolean)false) : "<not supported>")}, {"Heap memory usage", "=", CrashReport.memoryUsageToString(membean.getHeapMemoryUsage())}, {"Non-heap memory usage", "=", CrashReport.memoryUsageToString(membean.getNonHeapMemoryUsage())}, {"Operating system architecture", "=", osbean.getArch()}, {"Available processors", "=", String.valueOf(osbean.getAvailableProcessors())}, {"Operating system name", "=", osbean.getName()}, {"System load average", "=", osbean.getSystemLoadAverage() < 0.0 ? "<not available>" : String.valueOf(osbean.getSystemLoadAverage())}, {"Operating system version", "=", osbean.getVersion()}, {"Boot class path", "=", rtbean.isBootClassPathSupported() ? rtbean.getBootClassPath() : "<unsupported>"}, {"Class path", "=", rtbean.getClassPath()}, {"Runtime input arguments", "=", Strings.stringArrayToJava((String[])rtbean.getInputArguments().toArray(new String[0]))}, {"Library path", "=", rtbean.getLibraryPath()}, {"Management spec version", "=", rtbean.getManagementSpecVersion()}, {"Runtime name", "=", rtbean.getName()}, {"Spec name", "=", rtbean.getSpecName()}, {"Spec vendor", "=", rtbean.getSpecVendor()}, {"Spec version", "=", rtbean.getSpecVersion()}, {"Runtime start time (local)", "=", DateTimeUtils.formatDateTime((Date)startTime, (boolean)false, (boolean)true)}, {"Runtime start time (UTC)", "=", DateTimeUtils.formatDateTime((Date)startTime, (boolean)true, (boolean)true)}, {"Runtime up-time", "=", DateTimeUtils.durationToString((long)rtbean.getUptime(), (boolean)false)}, {"VM name", "=", rtbean.getVmName()}, {"VM vendor", "=", rtbean.getVmVendor()}, {"VM version", "=", rtbean.getVmVersion()}, {"Deamon thread count", "=", String.valueOf(tbean.getDaemonThreadCount())}, {"Peak thread count", "=", String.valueOf(tbean.getPeakThreadCount())}, {"Thread count", "=", String.valueOf(tbean.getThreadCount())}, {"Total started thread count", "=", String.valueOf(tbean.getTotalStartedThreadCount())}};
        s.println(CrashReport.formatTable(managementTable));
        s.println();
        s.println("[Platform (OSGi)]");
        if (!Platform.isRunning()) {
            s.println("(OSGi platform is not running)");
        } else {
            s.println(CrashReport.formatTable(CrashReport.getOsgiTable()));
        }
        s.println();
        s.println("[Bundles (OSGi)]");
        if (!Platform.isRunning()) {
            s.println("(OSGi platform is not running)");
        } else {
            Bundle appFrameworkBundle = FrameworkUtil.getBundle(CrashReport.class);
            BundleContext appFrameworkBundleContext = appFrameworkBundle.getBundleContext();
            Bundle[] bundles = appFrameworkBundleContext.getBundles();
            String[][] bundleTable = new String[bundles.length][6];
            int i = 0;
            Bundle[] bundleArray = bundles;
            int n7 = bundles.length;
            int n8 = 0;
            while (n8 < n7) {
                Bundle bundle = bundleArray[n8];
                bundleTable[i][0] = String.valueOf(bundle.getBundleId());
                bundleTable[i][1] = PlatformUtils.getStateName(bundle);
                bundleTable[i][2] = " ";
                bundleTable[i][3] = bundle.getSymbolicName();
                bundleTable[i][4] = bundle.getVersion().toString();
                bundleTable[i][5] = bundle.getLocation();
                ++i;
                ++n8;
            }
            s.println(CrashReport.formatTable(CrashReport.sortTable(bundleTable, 3)));
        }
        s.println();
    }

    private static String[][] getPropertiesTable() {
        AppProperties props = AppEnv.getProperties();
        String[][] table = new String[props.size()][3];
        int i = 0;
        for (Map.Entry entry : props.entrySet()) {
            table[i][0] = (String)entry.getKey();
            table[i][1] = "=";
            table[i][2] = Strings.stringToJava((String)((String)entry.getValue()));
            ++i;
        }
        return table;
    }

    private static String[][] getEnvironmentTable() {
        Map<String, String> env = System.getenv();
        String[][] table = new String[env.size()][3];
        int i = 0;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            table[i][0] = entry.getKey();
            table[i][1] = "=";
            table[i][2] = Strings.stringToJava((String)entry.getValue());
            ++i;
        }
        return table;
    }

    private static String[][] getOsgiTable() {
        String[][] table;
        Assert.check((boolean)Platform.isRunning());
        String[][] stringArray = table = new String[][]{{"Application arguments", "X", Strings.stringArrayToJava((String[])Platform.getApplicationArgs())}, {"Command line arguments", "X", Strings.stringArrayToJava((String[])Platform.getCommandLineArgs())}, {"Configuration location", "=", Platform.getConfigurationLocation().getURL().toString()}, {"Install location", "=", Platform.getInstallLocation().getURL().toString()}, {"Instance location", "=", Platform.getInstanceLocation().getURL().toString()}, {"Location", "=", Platform.getLocation().toString()}, {"Log file location", "=", Platform.getLogFileLocation().toString()}, {"Natural language", "=", Platform.getNL()}, {"Natural language extensions", "=", Platform.getNLExtensions()}, {"Operating System", "=", Platform.getOS()}, {"Operating System architecture", "=", Platform.getOSArch()}, {"Product / Application", "=", Platform.getProduct().getApplication()}, {"Product / Description", "=", Platform.getProduct().getDescription()}, {"Product / Id", "=", Platform.getProduct().getId()}, {"Product / Name", "=", Platform.getProduct().getName()}, {"Product / Defining bundle", "=", Platform.getProduct().getDefiningBundle().getSymbolicName()}, {"State stamp", "=", Long.valueOf(Platform.getStateStamp()).toString()}, {"User location", "=", Platform.getUserLocation().getURL().toString()}, {"Window system", "=", Platform.getWS()}};
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            String[] row = stringArray[n2];
            if (row[1].equals("X")) {
                row[1] = "=";
            } else {
                row[2] = Strings.stringToJava((String)row[2]);
            }
            ++n2;
        }
        return table;
    }

    private static String[][] sortTable(String[][] table) {
        return CrashReport.sortTable(table, 0);
    }

    private static String[][] sortTable(String[][] table, int sortColIdx) {
        List tableList = Lists.list();
        String[][] stringArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] row = stringArray[n2];
            tableList.add(Lists.list((Object[])row));
            ++n2;
        }
        Collections.sort(tableList, new TableRowComparator(sortColIdx));
        String[][] rslt = new String[tableList.size()][];
        String[] dummy = new String[]{};
        int i = 0;
        while (i < tableList.size()) {
            rslt[i] = ((List)tableList.get(i)).toArray(dummy);
            ++i;
        }
        return rslt;
    }

    private static String formatTable(String[][] table) {
        int numcols = table[0].length;
        int[] width = new int[numcols];
        String[][] stringArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            String[] row = stringArray[n2];
            int i = 0;
            while (i < numcols) {
                if (row[i].length() > width[i]) {
                    width[i] = row[i].length();
                }
                ++i;
            }
            ++n2;
        }
        StringBuilder b = new StringBuilder();
        int r = 0;
        while (r < table.length) {
            String[] row = table[r];
            int c = 0;
            while (c < numcols) {
                if (c > 0) {
                    b.append(" ");
                }
                b.append(row[c]);
                if (c != numcols - 1) {
                    b.append(Strings.spaces((int)(width[c] - row[c].length())));
                }
                ++c;
            }
            if (r != table.length - 1) {
                b.append('\n');
            }
            ++r;
        }
        return b.toString();
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup grp = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = grp.getParent();
        while (parent != null) {
            grp = parent;
            parent = grp.getParent();
        }
        return grp;
    }

    private static void printThreadGroups(ThreadGroup grp, AppStream s, int indent) {
        s.println(Strings.fmt((String)"%sThreadGroup[name=%s, maxpi=%d, daemon=%s, destroyed=%s]", (Object[])new Object[]{Strings.spaces((int)indent), grp.getName(), grp.getMaxPriority(), grp.isDaemon(), grp.isDestroyed()}));
        Object[] objectArray = CrashReport.getChildThreads(grp);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = objectArray[n2];
            s.println(Strings.fmt((String)"%sThread[name=%s, id=%d, prio=%d, state=%s%s%s%s%s]", (Object[])new Object[]{Strings.spaces((int)(indent + 4)), t.getName(), t.threadId(), t.getPriority(), t.getState(), t.isAlive() ? ", alive" : ", dormant", t.isDaemon() ? ", daemon" : "", t.isInterrupted() ? ", interrupted" : "", t == Thread.currentThread() ? ", current" : ""}));
            CrashReport.printStackTrace(t.getStackTrace(), s, indent + 8);
            ++n2;
        }
        objectArray = CrashReport.getChildThreadGroups(grp);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            CrashReport.printThreadGroups((ThreadGroup)child, s, indent + 4);
            ++n2;
        }
    }

    private static ThreadGroup[] getChildThreadGroups(ThreadGroup grp) {
        ThreadGroup[] groups;
        int guess = grp.activeGroupCount() + 1;
        int cnt = 0;
        while ((cnt = grp.enumerate(groups = new ThreadGroup[guess *= 2], false)) >= guess) {
        }
        ThreadGroup[] rslt = new ThreadGroup[cnt];
        System.arraycopy(groups, 0, rslt, 0, cnt);
        return rslt;
    }

    private static Thread[] getChildThreads(ThreadGroup grp) {
        Thread[] threads;
        int guess = grp.activeCount() + 1;
        int cnt = 0;
        while ((cnt = grp.enumerate(threads = new Thread[guess *= 2], false)) >= guess) {
        }
        Thread[] rslt = new Thread[cnt];
        System.arraycopy(threads, 0, rslt, 0, cnt);
        return rslt;
    }

    private static void printStackTrace(StackTraceElement[] trace, AppStream s, int indent) {
        int i = 0;
        while (i < trace.length) {
            s.println(Strings.spaces((int)indent) + trace[i].toString());
            ++i;
        }
    }

    private static String memoryUsageToString(MemoryUsage mu) {
        String init = mu.getInit() == -1L ? "undefined" : FileSizes.formatFileSizeEx((long)mu.getInit());
        String commit = FileSizes.formatFileSizeEx((long)mu.getCommitted());
        String used = FileSizes.formatFileSizeEx((long)mu.getUsed());
        String max = mu.getMax() == -1L ? "undefined" : FileSizes.formatFileSizeEx((long)mu.getMax());
        return Strings.fmt((String)"init=%s, commit=%s, used=%s, max=%s", (Object[])new Object[]{init, commit, used, max});
    }

    private static class TableRowComparator
    implements Comparator<List<String>> {
        private final int sortColIdx;

        public TableRowComparator(int sortColIdx) {
            this.sortColIdx = sortColIdx;
        }

        @Override
        public int compare(List<String> arg0, List<String> arg1) {
            Assert.check((arg0.size() > this.sortColIdx ? 1 : 0) != 0);
            Assert.check((arg1.size() > this.sortColIdx ? 1 : 0) != 0);
            return Strings.SORTER.compare(arg0.get(this.sortColIdx), arg1.get(this.sortColIdx));
        }
    }
}

