/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck.symbols;

import java.util.List;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ModelDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.symbols.DeclarationSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class ModelDefSymbolEntry
extends DeclarationSymbolEntry {
    private ModelDeclaration oldModelDef;
    private ModelDeclaration useModelDef;
    private ModelDeclaration fullModelDef;

    public ModelDefSymbolEntry(ModelDeclaration modelDef, CheckContext ctxt) {
        super(false, ctxt);
        this.oldModelDef = modelDef;
        this.useModelDef = null;
        this.fullModelDef = null;
    }

    @Override
    protected BehaviourDeclaration getOriginalDecl() {
        return this.oldModelDef;
    }

    public ModelDeclaration getNewDecl() {
        Assert.check((boolean)this.useCheckDone());
        if (this.useModelDef == null) {
            throw new SemanticException();
        }
        return this.useModelDef;
    }

    @Override
    public String getName() {
        return this.oldModelDef.getName();
    }

    @Override
    public Position getPosition() {
        return this.oldModelDef.getPosition();
    }

    @Override
    public void typeCheckForUse() {
        if (this.useCheckDone()) {
            return;
        }
        this.checkState = SymbolEntry.TypeCheckState.USE_CHECK_DONE;
        List<VariableDeclaration> newParms = this.checkParameters(true);
        Type rtype = this.checkExitType(this.oldModelDef.getReturnType(), this.ctxt);
        this.useModelDef = ChiConstructors.newModelDeclaration((String)this.oldModelDef.getName(), (Position)PositionUtils.copyPosition((PositionObject)this.oldModelDef), (Type)rtype, null, newParms);
    }

    @Override
    public void fullTypeCheck() {
        if (this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE) {
            return;
        }
        try {
            this.typeCheckForUse();
        }
        finally {
            this.checkState = SymbolEntry.TypeCheckState.FULL_CHECK_DONE;
        }
        if (this.useModelDef == null) {
            return;
        }
        CheckContext chkCtxt = this.parameterCtxt.add(CheckContext.ContextItem.NO_MODELS);
        chkCtxt = chkCtxt.newExitContext(this.useModelDef.getReturnType());
        Assert.check((chkCtxt.funcReturnType == null ? 1 : 0) != 0);
        Assert.check((!chkCtxt.contains(CheckContext.ContextItem.NO_EXIT) ? 1 : 0) != 0);
        this.checkBody((BehaviourDeclaration)this.useModelDef, chkCtxt);
        this.fullModelDef = this.useModelDef;
    }

    @Override
    public void checkUsage(CheckContext ctxt) {
    }

    public ModelDeclaration getModel() {
        Assert.check((this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE ? 1 : 0) != 0);
        if (this.fullModelDef == null) {
            throw new SemanticException();
        }
        return this.fullModelDef;
    }
}

