/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.common.typechecker.TypeChecker;
import org.eclipse.escet.setext.runtime.Token;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.Declaration;
import org.eclipse.escet.tooldef.metamodel.tooldef.Import;
import org.eclipse.escet.tooldef.metamodel.tooldef.JavaTool;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolDefImport;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolDefTool;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Statement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ToolInvokeStatement;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.ImportsChecker;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.eclipse.escet.tooldef.typechecker.ReachabilityChecker;
import org.eclipse.escet.tooldef.typechecker.StatementsChecker;
import org.eclipse.escet.tooldef.typechecker.ToolsChecker;
import org.eclipse.escet.tooldef.typechecker.TypeDeclsChecker;

public class ToolDefTypeChecker
extends TypeChecker<Script, Script> {
    private static final boolean CACHE_BUILTINS = true;
    private static Map<String, List<PositionObject>> cachedBuiltins = null;
    private static final Object CACHED_BUILTINS_LOCK = new Object();
    private static final String RUNTIME_BUILTINS_PREFIX = "tooldef://org.eclipse.escet.tooldef.runtime/org/eclipse/escet/tooldef/runtime/builtins/";
    protected Map<String, List<PositionObject>> builtins = null;
    protected Map<String, CheckerContext> scripts = null;
    protected String[][] importCycle = null;
    protected CheckerContext rootCtxt = null;

    protected Script transRoot(Script script) {
        Assert.check((script.getName() == null ? 1 : 0) != 0);
        Assert.check((this.rootCtxt == null ? 1 : 0) != 0);
        CheckerContext ctxt = new CheckerContext(this, script);
        if (this.builtins == null) {
            this.addBuiltins(ctxt);
        }
        for (Declaration decl : Lists.copy((List)script.getDeclarations())) {
            ToolDefTypeChecker.tcheck(decl, ctxt);
        }
        if (this.hasError()) {
            throw new SemanticException();
        }
        ReachabilityChecker.warnNonReachable((List<Declaration>)script.getDeclarations(), true, ctxt);
        ctxt.checkUnused();
        this.rootCtxt = ctxt;
        return script;
    }

    public List<SemanticProblem> typeCheck(ToolInvokeStatement invocation) {
        this.preparePostUse();
        try {
            ToolDefTypeChecker.tcheck((Declaration)invocation, this.rootCtxt);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        List problems = this.finalizePostUse();
        return problems;
    }

    private static void tcheck(Declaration decl, CheckerContext ctxt) {
        if (decl instanceof Script) {
            throw new RuntimeException("Already resolved import? " + String.valueOf(decl));
        }
        if (decl instanceof Import) {
            ImportsChecker.tcheck((Import)decl, ctxt);
        } else if (decl instanceof Statement) {
            StatementsChecker.tcheck((Statement)decl, ctxt);
        } else if (decl instanceof Tool) {
            Assert.check((boolean)(decl instanceof ToolDefTool));
            ToolsChecker.tcheck((ToolDefTool)decl, ctxt);
        } else if (decl instanceof TypeDecl) {
            TypeDeclsChecker.tcheck((TypeDecl)decl, ctxt);
        } else {
            throw new RuntimeException("Unknown decl: " + String.valueOf(decl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuiltins(CheckerContext ctxt) {
        Object object = CACHED_BUILTINS_LOCK;
        synchronized (object) {
            if (cachedBuiltins == null) {
                cachedBuiltins = Maps.map();
                try {
                    this.addBuiltins(ctxt, cachedBuiltins);
                }
                catch (Throwable ex) {
                    cachedBuiltins = null;
                    throw ex;
                }
            }
            this.builtins = cachedBuiltins;
            return;
        }
    }

    private void addBuiltins(CheckerContext ctxt, Map<String, List<PositionObject>> builtins) {
        try {
            ToolDefTypeChecker.addBuiltIns(ctxt, "tooldef://org.eclipse.escet.tooldef.runtime/org/eclipse/escet/tooldef/runtime/builtins/builtins_data.tooldef", builtins);
            ToolDefTypeChecker.addBuiltIns(ctxt, "tooldef://org.eclipse.escet.tooldef.runtime/org/eclipse/escet/tooldef/runtime/builtins/builtins_file.tooldef", builtins);
            ToolDefTypeChecker.addBuiltIns(ctxt, "tooldef://org.eclipse.escet.tooldef.runtime/org/eclipse/escet/tooldef/runtime/builtins/builtins_generic.tooldef", builtins);
            ToolDefTypeChecker.addBuiltIns(ctxt, "tooldef://org.eclipse.escet.tooldef.runtime/org/eclipse/escet/tooldef/runtime/builtins/builtins_io.tooldef", builtins);
            ToolDefTypeChecker.addBuiltIns(ctxt, "tooldef://org.eclipse.escet.tooldef.runtime/org/eclipse/escet/tooldef/runtime/builtins/builtins_operator.tooldef", builtins);
            ToolDefTypeChecker.addBuiltIns(ctxt, "tooldef://org.eclipse.escet.tooldef.runtime/org/eclipse/escet/tooldef/runtime/builtins/builtins_path.tooldef", builtins);
        }
        catch (SemanticException ex) {
            throw new RuntimeException("Failed to load built-ins.", ex);
        }
    }

    private static void addBuiltIns(CheckerContext ctxt, String importRef, Map<String, List<PositionObject>> builtins) {
        Token impSrc = new Token(importRef, -1, null);
        ToolDefImport imp = ToolDefConstructors.newToolDefImport(null, null, null, (Token)impSrc);
        CheckerContext impCtxt = ImportsChecker.getScript(imp, ctxt);
        List<PositionObject> objs = impCtxt.getImportableObjects();
        for (PositionObject obj : objs) {
            if (obj instanceof JavaTool) continue;
            Assert.check((boolean)(obj instanceof ToolDefTool));
            ToolDefTool tool = (ToolDefTool)obj;
            String name = ToolDefTextUtils.getName((PositionObject)tool);
            Assert.check((boolean)name.startsWith("_"));
            switch (name = name.substring(1)) {
                case "plus": {
                    name = "+";
                    break;
                }
                case "dash": {
                    name = "-";
                    break;
                }
                case "star": {
                    name = "*";
                    break;
                }
                case "slash": {
                    name = "/";
                    break;
                }
                case "lt": {
                    name = "<";
                    break;
                }
                case "le": {
                    name = "<=";
                    break;
                }
                case "gt": {
                    name = ">";
                    break;
                }
                case "ge": {
                    name = ">=";
                    break;
                }
                case "eq": {
                    name = "==";
                    break;
                }
                case "ne": {
                    name = "!=";
                }
            }
            tool.setName(name);
            List others = builtins.get(name);
            if (others == null) {
                others = Lists.list();
                builtins.put(name, others);
            }
            others.add(tool);
        }
    }

    public String resolveImport(String path, TextPosition pos, CheckerContext ctxt) {
        if (path.startsWith("lib:")) {
            String name = path.substring("lib:".length());
            String pluginName = null;
            if (!Platform.isRunning()) {
                pluginName = path;
            } else {
                IExtensionRegistry registry = RegistryFactory.getRegistry();
                String extensionPointId = "org.eclipse.escet.tooldef.library";
                IConfigurationElement[] libs = registry.getConfigurationElementsFor(extensionPointId);
                List pluginNames = Lists.list();
                IConfigurationElement[] iConfigurationElementArray = libs;
                int n = libs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement lib = iConfigurationElementArray[n2];
                    String libName = lib.getAttribute("name");
                    if (libName != null && libName.equals(name)) {
                        pluginNames.add(lib.getContributor().getName());
                    }
                    ++n2;
                }
                Collections.sort(pluginNames, Strings.SORTER);
                if (pluginNames.isEmpty()) {
                    ctxt.addProblem(Message.IMPORT_LIB_NOT_FOUND, pos, name);
                    throw new SemanticException();
                }
                if (pluginNames.size() > 1) {
                    int i = 1;
                    while (i < pluginNames.size()) {
                        ctxt.addProblem(Message.IMPORT_LIB_DUPL, pos, name, (String)pluginNames.get(0), (String)pluginNames.get(i));
                        ++i;
                    }
                    throw new SemanticException();
                }
                pluginName = (String)pluginNames.get(0);
            }
            return Strings.fmt((String)"tooldef://%s/%s.tooldef", (Object[])new Object[]{pluginName, name});
        }
        if (path.startsWith("tooldef://")) {
            String pluginBoth = path.substring("tooldef://".length());
            int slashIdx = pluginBoth.indexOf(47);
            String pluginName = slashIdx == -1 ? "" : pluginBoth.substring(0, slashIdx);
            String pluginPath = slashIdx == -1 ? pluginBoth : pluginBoth.substring(slashIdx + 1);
            pluginPath = Paths.join((String[])new String[]{"/" + pluginPath, "."});
            pluginPath = pluginPath.replace('\\', '/');
            return "tooldef://" + pluginName + pluginPath;
        }
        if (this.getSourceFilePath().startsWith("tooldef://")) {
            if (Paths.isAbsolute((String)path)) {
                return Paths.join((String[])new String[]{path, "."});
            }
            String pluginBoth = this.getSourceFilePath().substring("tooldef://".length());
            int slashIdx = pluginBoth.indexOf(47);
            String pluginName = slashIdx == -1 ? "" : pluginBoth.substring(0, slashIdx);
            String pluginPath = slashIdx == -1 ? pluginBoth : pluginBoth.substring(slashIdx + 1);
            pluginPath = Paths.getAbsFilePathDir((String)("/" + pluginPath));
            pluginPath = Paths.resolve((String)path, (String)pluginPath);
            pluginPath = pluginPath.replace('\\', '/');
            return "tooldef://" + pluginName + pluginPath;
        }
        return this.resolveImport(path);
    }
}

