/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import org.eclipse.escet.cif.common.CifDocAnnotationUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.common.java.Lists;

public class CifDocAnnotationFormatter {
    private final List<String> headerLines;
    private final List<String> preDocLines;
    private final String docLinePrefix;
    private final List<String> postDocLines;
    private final List<String> footerLines;

    public CifDocAnnotationFormatter(List<String> headerLines, List<String> preDocLines, String docLinePrefix, List<String> postDocLines, List<String> footerLines) {
        this.headerLines = headerLines == null ? List.of() : headerLines;
        this.preDocLines = preDocLines == null ? List.of() : preDocLines;
        this.docLinePrefix = docLinePrefix == null ? "" : docLinePrefix;
        this.postDocLines = postDocLines == null ? List.of() : postDocLines;
        this.footerLines = footerLines == null ? List.of() : footerLines;
    }

    public boolean hasDocs(AnnotatedObject obj) {
        return !CifDocAnnotationUtils.getDocs(obj).isEmpty();
    }

    public List<String> formatDocs(List<String> docBlocks) {
        List lines = Lists.list();
        lines.addAll(this.headerLines);
        for (String docBlock : docBlocks) {
            lines.addAll(this.preDocLines);
            String[] stringArray = docBlock.split("\\r?\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                lines.add(this.docLinePrefix + line);
                ++n2;
            }
            lines.addAll(this.postDocLines);
        }
        lines.addAll(this.footerLines);
        return lines;
    }

    public List<String> formatDocs(AnnotatedObject obj) {
        return this.formatDocs(CifDocAnnotationUtils.getDocs(obj));
    }
}

