/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class ElimAutCasts
extends CifWalker
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating casts of automata to strings for a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
    }

    protected void walkCastExpression(CastExpression castExpr) {
        Expression child = castExpr.getChild();
        if (!CifTypeUtils.isAutRefExpr((Expression)child)) {
            super.walkCastExpression(castExpr);
            return;
        }
        CifType ctype = child.getType();
        Assert.check((boolean)(ctype instanceof ComponentType));
        Component comp = ((ComponentType)ctype).getComponent();
        Assert.check((boolean)(comp instanceof Automaton));
        Automaton aut = (Automaton)comp;
        EList locs = aut.getLocations();
        if (locs.size() == 1) {
            StringExpression strExpr = this.createStringLiteral((Location)Lists.first((List)locs));
            EMFHelper.updateParentContainment((EObject)castExpr, (EObject)strExpr);
            return;
        }
        IfExpression ifExpr = CifConstructors.newIfExpression();
        ifExpr.setType((CifType)CifConstructors.newStringType());
        ifExpr.getGuards().add((Object)this.createGuard((Location)Lists.first((List)locs)));
        ifExpr.setThen((Expression)this.createStringLiteral((Location)Lists.first((List)locs)));
        EList elifs = ifExpr.getElifs();
        int i = 1;
        while (i < locs.size() - 1) {
            ElifExpression elifExpr = CifConstructors.newElifExpression();
            elifs.add(elifExpr);
            Location loc = (Location)locs.get(i);
            elifExpr.getGuards().add((Object)this.createGuard(loc));
            elifExpr.setThen((Expression)this.createStringLiteral(loc));
            ++i;
        }
        ifExpr.setElse((Expression)this.createStringLiteral((Location)Lists.last((List)locs)));
        EMFHelper.updateParentContainment((EObject)castExpr, (EObject)ifExpr);
    }

    private LocationExpression createGuard(Location loc) {
        LocationExpression rslt = CifConstructors.newLocationExpression();
        rslt.setType((CifType)CifConstructors.newBoolType());
        rslt.setLocation(loc);
        return rslt;
    }

    private StringExpression createStringLiteral(Location loc) {
        StringExpression strExpr = CifConstructors.newStringExpression();
        strExpr.setType((CifType)CifConstructors.newStringType());
        strExpr.setValue(CifLocationUtils.getName((Location)loc));
        return strExpr;
    }
}

