/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.model.OntResource;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.model.RDFNodeList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public interface OntList<E extends RDFNode>
extends RDFNodeList<E>,
OntResource {
    public OntList<E> addLast(E var1);

    public OntList<E> removeLast();

    public OntList<E> addFirst(E var1);

    public OntList<E> removeFirst();

    public OntList<E> clear();

    public OntList<E> get(int var1) throws OntJenaException;

    public Optional<Resource> type();

    public Stream<OntStatement> spec();

    default public Stream<OntStatement> content() {
        return Stream.concat(Stream.of(this.getMainStatement()), this.spec());
    }

    default public OntList<E> add(E e2) {
        return this.addLast(e2);
    }

    default public OntList<E> remove() {
        return this.removeLast();
    }

    default public OntList<E> addAll(Collection<? extends E> c) {
        c.forEach(this::add);
        return this;
    }

    @Override
    default public boolean isLocal() {
        return this.getMainStatement().isLocal();
    }
}

