/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces;

import com.sun.faces.config.ConfigManager;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.ServletContextFacesContextFactory;
import jakarta.faces.TypedCollections;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.component.search.SearchExpressionContextFactory;
import jakarta.faces.component.visit.VisitContextFactory;
import jakarta.faces.context.ExceptionHandlerFactory;
import jakarta.faces.context.ExternalContextFactory;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.context.FlashFactory;
import jakarta.faces.context.PartialViewContextFactory;
import jakarta.faces.flow.FlowHandlerFactory;
import jakarta.faces.lifecycle.ClientWindowFactory;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.view.ViewDeclarationLanguageFactory;
import jakarta.faces.view.facelets.FaceletCacheFactory;
import jakarta.faces.view.facelets.TagHandlerDelegateFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class FactoryFinderInstance {
    private static final Logger LOGGER = Logger.getLogger("jakarta.faces", "jakarta.faces.LogStrings");
    private static final String INJECTION_PROVIDER_KEY = FactoryFinder.class.getPackage().getName() + "INJECTION_PROVIDER_KEY";
    private final Map<String, Object> factories = new ConcurrentHashMap<String, Object>();
    private final Map<String, List<String>> savedFactoryNames = new ConcurrentHashMap<String, List<String>>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final String createdBy;
    private ServletContextFacesContextFactory servletContextFinder = new ServletContextFacesContextFactory();
    private static final List<String> factoryNames = FactoryFinderInstance.asSortedList((Comparable[])new String[]{"jakarta.faces.application.ApplicationFactory", "jakarta.faces.component.visit.VisitContextFactory", "jakarta.faces.context.ExceptionHandlerFactory", "jakarta.faces.context.ExternalContextFactory", "jakarta.faces.context.FacesContextFactory", "jakarta.faces.context.FlashFactory", "jakarta.faces.flow.FlowHandlerFactory", "jakarta.faces.context.PartialViewContextFactory", "jakarta.faces.lifecycle.ClientWindowFactory", "jakarta.faces.lifecycle.LifecycleFactory", "jakarta.faces.render.RenderKitFactory", "jakarta.faces.view.ViewDeclarationLanguageFactory", "jakarta.faces.view.facelets.FaceletCacheFactory", "jakarta.faces.view.facelets.TagHandlerDelegateFactory", "jakarta.faces.component.search.SearchExpressionContextFactory"});
    private static final Map<String, Class<?>> factoryClasses = FactoryFinderInstance.buildFactoryClassesMap();

    FactoryFinderInstance(FacesContext facesContext) {
        for (String name : factoryNames) {
            this.factories.put(name, new ArrayList(4));
        }
        this.copyInjectionProviderFromFacesContext(facesContext);
        this.createdBy = Util.generateCreatedBy(facesContext);
    }

    FactoryFinderInstance(FacesContext facesContext, FactoryFinderInstance toCopy) {
        this.factories.putAll(toCopy.savedFactoryNames);
        this.copyInjectionProviderFromFacesContext(facesContext);
        this.createdBy = Util.generateCreatedBy(facesContext);
    }

    public String toString() {
        return super.toString() + " created by" + this.createdBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFactory(String factoryName, String implementationClassName) {
        this.validateFactoryName(factoryName);
        Object result = this.factories.get(factoryName);
        this.lock.writeLock().lock();
        try {
            if (result instanceof List) {
                TypedCollections.dynamicallyCastList((List)result, String.class).add(0, implementationClassName);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getFactory(String factoryName) {
        Object factoryOrList;
        this.validateFactoryName(factoryName);
        if (factoryName.equals("com.sun.faces.ServletContextFacesContextFactory")) {
            return this.servletContextFinder;
        }
        if (factoryName.equals("com.sun.faces.ServletContextFacesContextFactory_Removal")) {
            try {
                this.lock.writeLock().lock();
                this.servletContextFinder = null;
                Object var2_2 = null;
                return var2_2;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            factoryOrList = this.factories.get(factoryName);
            if (!(factoryOrList instanceof List)) {
                Object object = factoryOrList;
                return object;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            factoryOrList = this.factories.get(factoryName);
            if (!(factoryOrList instanceof List)) {
                Object object = factoryOrList;
                return object;
            }
            this.savedFactoryNames.put(factoryName, new ArrayList((List)factoryOrList));
            Object factory = this.getImplementationInstance(Util.getContextClassLoader2(), factoryName, (List)factoryOrList);
            if (factory == null) {
                this.logNoFactory(factoryName);
                factory = FactoryFinder.FACTORIES_CACHE.getFallbackFactory(this, factoryName);
                this.notNullFactory(factoryName, factory);
            }
            this.factories.put(factoryName, factory);
            Object object = factory;
            return object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    InjectionProvider getInjectionProvider() {
        return (InjectionProvider)this.factories.get(INJECTION_PROVIDER_KEY);
    }

    void clearInjectionProvider() {
        this.factories.remove(INJECTION_PROVIDER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFactories() {
        InjectionProvider provider = this.getInjectionProvider();
        if (provider != null) {
            this.lock.writeLock().lock();
            try {
                for (Map.Entry<String, Object> entry : this.factories.entrySet()) {
                    Object curFactory = entry.getValue();
                    if (INJECTION_PROVIDER_KEY.equals(entry.getKey()) || curFactory == null || curFactory instanceof String) continue;
                    try {
                        provider.invokePreDestroy(curFactory);
                    }
                    catch (Exception ex) {
                        this.logPreDestroyFail(entry.getValue(), ex);
                    }
                }
            }
            finally {
                this.factories.clear();
                this.lock.writeLock().unlock();
            }
        } else {
            LOGGER.log(Level.SEVERE, "Unable to call @PreDestroy annotated methods because no InjectionProvider can be found. Does this container implement the Mojarra Injection SPI?");
        }
    }

    Collection<Object> getFactories() {
        return this.factories.values();
    }

    private void copyInjectionProviderFromFacesContext(FacesContext facesContext) {
        InjectionProvider injectionProvider = null;
        if (facesContext != null) {
            injectionProvider = (InjectionProvider)facesContext.getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY);
        }
        if (injectionProvider != null) {
            this.factories.put(INJECTION_PROVIDER_KEY, injectionProvider);
        } else {
            LOGGER.log(Level.SEVERE, "Unable to obtain InjectionProvider from init time FacesContext. Does this container implement the Mojarra Injection SPI?");
        }
    }

    private Object getImplementationInstance(ClassLoader classLoader, String factoryName, List<String> implementations) throws FacesException {
        List<String> fromServices;
        String curImplClass;
        int len;
        Object implementation = null;
        if (implementations != null && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = implementations.remove(len - 1);
            implementation = this.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, null);
        }
        if ((fromServices = this.getImplNameFromServices(classLoader, factoryName)) != null) {
            for (String name : fromServices) {
                implementation = this.getImplGivenPreviousImpl(classLoader, factoryName, name, implementation);
            }
        }
        if (implementations != null) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = implementations.remove(len);
                implementation = this.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, implementation);
            }
        }
        return implementation;
    }

    private List<String> getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        ArrayList<String> implementationNames;
        block8: {
            implementationNames = new ArrayList<String>();
            String resourceName = "META-INF/services/" + factoryName;
            try {
                Enumeration<URL> resources = classLoader.getResources(resourceName);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    URLConnection connection = url.openConnection();
                    connection.setUseCaches(false);
                    InputStream stream = connection.getInputStream();
                    try {
                        if (stream == null) continue;
                        implementationNames.add(this.readLineFromStream(stream));
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
            }
            catch (IOException | SecurityException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return implementationNames;
    }

    private Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String factoryImplClassName, Object previousFactoryImplementation) {
        Object factoryImplementation = null;
        Class<?> factoryClass = this.getFactoryClass(factoryName);
        if (!Util.isAnyNull(previousFactoryImplementation, factoryClass)) {
            try {
                factoryImplementation = Class.forName(factoryImplClassName, false, classLoader).getConstructor(factoryClass).newInstance(previousFactoryImplementation);
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new FacesException(factoryImplClassName, e);
            }
        }
        if (Util.isAnyNull(previousFactoryImplementation, factoryClass)) {
            try {
                factoryImplementation = Class.forName(factoryImplClassName, false, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new FacesException(factoryImplClassName, e);
            }
        }
        this.injectImplementation(factoryImplClassName, factoryImplementation);
        return factoryImplementation;
    }

    private Class<?> getFactoryClass(String factoryClassName) {
        return factoryClasses.get(factoryClassName);
    }

    private String readLineFromStream(InputStream stream) throws IOException {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException uee) {
                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(stream));){
                    String string2 = reader2.readLine();
                    return string2;
                }
            }
        }
        reader.close();
        return string;
    }

    private void injectImplementation(String implementationName, Object implementation) {
        if (implementation != null) {
            InjectionProvider provider = this.getInjectionProvider();
            if (provider != null) {
                try {
                    provider.inject(implementation);
                    provider.invokePostConstruct(implementation);
                }
                catch (Exception e) {
                    throw new FacesException(implementationName, e);
                }
            } else {
                LOGGER.log(Level.SEVERE, "Unable to inject {0} because no InjectionProvider can be found. Does this container implement the Mojarra Injection SPI?", implementation);
            }
        }
    }

    private void logNoFactory(String factoryName) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(LOGGER.getResourceBundle().getString("severe.no_factory"), factoryName));
        }
    }

    private void logPreDestroyFail(Object factory, Exception ex) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("Unable to invoke @PreDestroy annotated methods on {0}.", factory), ex);
        }
    }

    private void notNullFactory(String factoryName, Object factory) {
        if (factory == null) {
            throw new IllegalStateException(MessageFormat.format(LOGGER.getResourceBundle().getString("severe.no_factory_backup_failed"), factoryName));
        }
    }

    private void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        if (Util.isOneOf(factoryName, "com.sun.faces.ServletContextFacesContextFactory", "com.sun.faces.ServletContextFacesContextFactory_Removal")) {
            return;
        }
        if (Collections.binarySearch(factoryNames, factoryName) < 0) {
            throw new IllegalArgumentException(factoryName);
        }
    }

    private static Map<String, Class<?>> buildFactoryClassesMap() {
        return Map.ofEntries(Map.entry("jakarta.faces.application.ApplicationFactory", ApplicationFactory.class), Map.entry("jakarta.faces.component.visit.VisitContextFactory", VisitContextFactory.class), Map.entry("jakarta.faces.context.ExceptionHandlerFactory", ExceptionHandlerFactory.class), Map.entry("jakarta.faces.context.ExternalContextFactory", ExternalContextFactory.class), Map.entry("jakarta.faces.context.FacesContextFactory", FacesContextFactory.class), Map.entry("jakarta.faces.context.FlashFactory", FlashFactory.class), Map.entry("jakarta.faces.context.PartialViewContextFactory", PartialViewContextFactory.class), Map.entry("jakarta.faces.lifecycle.LifecycleFactory", LifecycleFactory.class), Map.entry("jakarta.faces.lifecycle.ClientWindowFactory", ClientWindowFactory.class), Map.entry("jakarta.faces.render.RenderKitFactory", RenderKitFactory.class), Map.entry("jakarta.faces.view.ViewDeclarationLanguageFactory", ViewDeclarationLanguageFactory.class), Map.entry("jakarta.faces.view.facelets.FaceletCacheFactory", FaceletCacheFactory.class), Map.entry("jakarta.faces.view.facelets.TagHandlerDelegateFactory", TagHandlerDelegateFactory.class), Map.entry("jakarta.faces.flow.FlowHandlerFactory", FlowHandlerFactory.class), Map.entry("jakarta.faces.component.search.SearchExpressionContextFactory", SearchExpressionContextFactory.class));
    }

    @SafeVarargs
    private static <T extends Comparable<T>> List<T> asSortedList(T ... elements) {
        return Arrays.stream(elements).sorted().collect(Collectors.toList());
    }
}

