/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.bcoview.asm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.bcoview.asm.CommentedASMifierClassVisitor;
import org.eclipse.jdt.bcoview.asm.CommentedClassVisitor;
import org.eclipse.jdt.bcoview.asm.DecompiledClass;
import org.eclipse.jdt.bcoview.asm.DecompiledClassInfo;
import org.eclipse.jdt.bcoview.asm.DecompiledMethod;
import org.eclipse.jdt.bcoview.asm.DecompilerOptions;
import org.eclipse.jdt.bcoview.asm.ICommentedClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public class DecompilerHelper {
    public static DecompiledClass getDecompiledClass(byte[] bytes, DecompilerOptions options) throws UnsupportedClassVersionError {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode(589824);
        int crFlags = 0;
        if (options.modes.get(7)) {
            crFlags |= 8;
        }
        cr.accept((ClassVisitor)cn, crFlags);
        ICommentedClassVisitor printer = options.modes.get(2) ? new CommentedASMifierClassVisitor(cn, options) : new CommentedClassVisitor(cn, options);
        TraceClassVisitor dcv = new TraceClassVisitor(null, (Printer)printer, null);
        cn.accept((ClassVisitor)dcv);
        return DecompilerHelper.getResult(printer, cn);
    }

    private static DecompiledClass getResult(ICommentedClassVisitor printer, ClassNode classNode) {
        ArrayList<Object> classText = new ArrayList<Object>();
        DecompilerHelper.formatText(printer.getText(), new StringBuffer(), classText);
        while (classText.size() > 0 && "\n".equals(classText.get(0))) {
            classText.remove(0);
        }
        DecompiledClassInfo classInfo = printer.getClassInfo();
        return new DecompiledClass(classText, classInfo, classNode);
    }

    private static void formatText(List<?> input, StringBuffer line, List<Object> result) {
        int i = 0;
        while (i < input.size()) {
            Object o = input.get(i);
            if (o instanceof List) {
                DecompilerHelper.formatText((List)o, line, result);
            } else if (o instanceof DecompiledMethod) {
                result.add(o);
            } else {
                int p;
                String s = o.toString();
                do {
                    if ((p = s.indexOf(10)) == -1) {
                        line.append(s);
                        continue;
                    }
                    result.add(line.toString() + s.substring(0, p + 1));
                    s = s.substring(p + 1);
                    line.setLength(0);
                } while (p != -1);
            }
            ++i;
        }
    }
}

