/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import org.eclipse.ant.internal.ui.AntDoubleClickStrategy;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.ColorManager;
import org.eclipse.ant.internal.ui.editor.text.AntEditorProcInstrScanner;
import org.eclipse.ant.internal.ui.editor.text.AntEditorTagScanner;
import org.eclipse.ant.internal.ui.editor.text.MultilineDamagerRepairer;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class AntSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private AntEditorTagScanner tagScanner;
    private AntEditorProcInstrScanner instructionScanner;
    private MultilineDamagerRepairer damageRepairer;
    private MultilineDamagerRepairer dtdDamageRepairer;
    private TextAttribute xmlCommentAttribute;
    private TextAttribute xmlDtdAttribute;

    public AntSourceViewerConfiguration() {
        super(AntUIPlugin.getDefault().getCombinedPreferenceStore());
    }

    private AntEditorProcInstrScanner getDefaultScanner() {
        if (this.instructionScanner == null) {
            this.instructionScanner = new AntEditorProcInstrScanner();
        }
        return this.instructionScanner;
    }

    private AntEditorTagScanner getTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new AntEditorTagScanner();
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        MultilineDamagerRepairer dr = new MultilineDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new MultilineDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        int style = this.getStyle("org.eclipse.ant.ui.commentsColor");
        this.xmlCommentAttribute = new TextAttribute(AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.commentsColor"), null, style);
        this.damageRepairer = new MultilineDamagerRepairer(null, this.xmlCommentAttribute);
        reconciler.setDamager((IPresentationDamager)this.damageRepairer, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)this.damageRepairer, "__xml_comment");
        style = this.getStyle("org.eclipse.ant.ui.dtdColor");
        this.xmlDtdAttribute = new TextAttribute(AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.dtdColor"), null, style);
        this.dtdDamageRepairer = new MultilineDamagerRepairer(null, this.xmlDtdAttribute);
        reconciler.setDamager((IPresentationDamager)this.dtdDamageRepairer, "__xml_dtd");
        reconciler.setRepairer((IPresentationRepairer)this.dtdDamageRepairer, "__xml_dtd");
        return reconciler;
    }

    private int getStyle(String pref) {
        int style = 0;
        if (this.fPreferenceStore.getBoolean(pref + "_bold")) {
            style |= 1;
        }
        if (this.fPreferenceStore.getBoolean(pref + "_italic")) {
            style |= 2;
        }
        return style;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.tagScanner == null) {
            return;
        }
        this.tagScanner.adaptToPreferenceChange(event);
        this.instructionScanner.adaptToPreferenceChange(event);
        String property = event.getProperty();
        if (property.startsWith("org.eclipse.ant.ui.commentsColor")) {
            this.xmlCommentAttribute = this.adaptTextAttribute(event, property, this.xmlCommentAttribute, this.damageRepairer);
        } else if (property.startsWith("org.eclipse.ant.ui.dtdColor")) {
            this.xmlDtdAttribute = this.adaptTextAttribute(event, property, this.xmlDtdAttribute, this.dtdDamageRepairer);
        }
    }

    private TextAttribute adaptTextAttribute(PropertyChangeEvent event, String property, TextAttribute textAttribute, MultilineDamagerRepairer repairer) {
        textAttribute = property.endsWith("_bold") ? this.adaptToStyleChange(event, 1, textAttribute) : (property.endsWith("_italic") ? this.adaptToStyleChange(event, 2, textAttribute) : this.adaptToColorChange(event, textAttribute));
        repairer.setDefaultTextAttribute(textAttribute);
        return textAttribute;
    }

    private TextAttribute adaptToStyleChange(PropertyChangeEvent event, int styleAttribute, TextAttribute textAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        boolean bl = activeValue = (textAttribute.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            textAttribute = new TextAttribute(textAttribute.getForeground(), textAttribute.getBackground(), eventValue ? textAttribute.getStyle() | styleAttribute : textAttribute.getStyle() & ~styleAttribute);
        }
        return textAttribute;
    }

    private TextAttribute adaptToColorChange(PropertyChangeEvent event, TextAttribute textAttribute) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            textAttribute = new TextAttribute(ColorManager.getDefault().getColor(rgb), textAttribute.getBackground(), textAttribute.getStyle());
        }
        return textAttribute;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag", "__xml_cdata", "__xml_dtd"};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return this.fPreferenceStore.getInt("tabWidth");
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.startsWith("org.eclipse.ant.ui.textColor") || property.startsWith("org.eclipse.ant.ui.processingInstructionsColor") || property.startsWith("org.eclipse.ant.ui.constantStringsColor") || property.startsWith("org.eclipse.ant.ui.tagsColor") || property.startsWith("org.eclipse.ant.ui.commentsColor") || property.startsWith("org.eclipse.ant.ui.dtdColor");
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "org.eclipse.ant.ui.antPartitioning";
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__xml_tag".equals(contentType)) {
            return new AntDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }
}

