/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;

public class PositionTracker
implements IQueryListener,
ISearchResultListener,
IFileBufferListener {
    private final Map<Match, Position> fMatchesToPositions = new HashMap<Match, Position>();
    private final Map<Match, AbstractTextSearchResult> fMatchesToSearchResults = new HashMap<Match, AbstractTextSearchResult>();
    private final Map<ITextFileBuffer, Set<Match>> fFileBuffersToMatches = new HashMap<ITextFileBuffer, Set<Match>>();

    public PositionTracker() {
        NewSearchUI.addQueryListener(this);
        FileBuffers.getTextFileBufferManager().addFileBufferListener((IFileBufferListener)this);
    }

    @Override
    public void queryAdded(ISearchQuery query) {
        if (query.getSearchResult() instanceof AbstractTextSearchResult) {
            query.getSearchResult().addListener(this);
        }
    }

    @Override
    public void queryRemoved(ISearchQuery query) {
        ISearchResult result = query.getSearchResult();
        if (result instanceof AbstractTextSearchResult) {
            this.untrackAll((AbstractTextSearchResult)result);
            result.removeListener(this);
        }
    }

    @Override
    public void searchResultChanged(SearchResultEvent e) {
        if (e instanceof MatchEvent) {
            MatchEvent evt = (MatchEvent)e;
            Match[] matches = evt.getMatches();
            int kind = evt.getKind();
            AbstractTextSearchResult result = (AbstractTextSearchResult)e.getSearchResult();
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                ITextFileBuffer fb = this.getTrackedFileBuffer(result, match.getElement());
                if (fb != null) {
                    this.updateMatch(match, fb, kind, result);
                }
                ++n2;
            }
        } else if (e instanceof RemoveAllEvent) {
            RemoveAllEvent evt = (RemoveAllEvent)e;
            ISearchResult result = evt.getSearchResult();
            this.untrackAll((AbstractTextSearchResult)result);
        }
    }

    private void updateMatch(Match match, ITextFileBuffer fb, int kind, AbstractTextSearchResult result) {
        if (kind == 1) {
            this.trackPosition(result, fb, match);
        } else if (kind == 2) {
            this.untrackPosition(fb, match);
        }
    }

    private void untrackAll(AbstractTextSearchResult result) {
        HashSet<Match> matchSet = new HashSet<Match>(this.fMatchesToPositions.keySet());
        for (Match match : matchSet) {
            ITextFileBuffer fb;
            AbstractTextSearchResult matchContainer = this.fMatchesToSearchResults.get(match);
            if (!result.equals(matchContainer) || (fb = this.getTrackedFileBuffer(result, match.getElement())) == null) continue;
            this.untrackPosition(fb, match);
        }
    }

    private void untrackPosition(ITextFileBuffer fb, Match match) {
        Position position = this.fMatchesToPositions.get(match);
        if (position != null) {
            this.removeFileBufferMapping(fb, match);
            this.fMatchesToSearchResults.remove(match);
            this.fMatchesToPositions.remove(match);
            fb.getDocument().removePosition(position);
        }
    }

    private void trackPosition(AbstractTextSearchResult result, ITextFileBuffer fb, Match match) {
        int offset = match.getOffset();
        int length = match.getLength();
        if (offset < 0 || length < 0) {
            return;
        }
        try {
            IDocument doc = fb.getDocument();
            Position position = new Position(offset, length);
            if (match.getBaseUnit() == 1) {
                position = PositionTracker.convertToCharacterPosition(position, doc);
            }
            doc.addPosition(position);
            this.fMatchesToSearchResults.put(match, result);
            this.fMatchesToPositions.put(match, position);
            this.addFileBufferMapping(fb, match);
        }
        catch (BadLocationException e) {
            result.removeMatch(match);
        }
    }

    public static Position convertToCharacterPosition(Position linePosition, IDocument doc) throws BadLocationException {
        int lineOffset = linePosition.getOffset();
        int lineLength = linePosition.getLength();
        int charOffset = doc.getLineOffset(lineOffset);
        int charLength = 0;
        if (lineLength > 0) {
            int lastLine = lineOffset + lineLength - 1;
            int endPosition = doc.getLineOffset(lastLine) + doc.getLineLength(lastLine);
            charLength = endPosition - charOffset;
        }
        return new Position(charOffset, charLength);
    }

    private void addFileBufferMapping(ITextFileBuffer fb, Match match) {
        Set<Match> matches = this.fFileBuffersToMatches.get(fb);
        if (matches == null) {
            matches = new HashSet<Match>();
            this.fFileBuffersToMatches.put(fb, matches);
        }
        matches.add(match);
    }

    private void removeFileBufferMapping(ITextFileBuffer fb, Match match) {
        Set<Match> matches = this.fFileBuffersToMatches.get(fb);
        if (matches != null) {
            matches.remove(match);
            if (matches.isEmpty()) {
                this.fFileBuffersToMatches.remove(fb);
            }
        }
    }

    private ITextFileBuffer getTrackedFileBuffer(AbstractTextSearchResult result, Object element) {
        IFileMatchAdapter adapter = result.getFileMatchAdapter();
        if (adapter == null) {
            return null;
        }
        IFile file = adapter.getFile(element);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
    }

    public Position getCurrentPosition(Match match) {
        ITextFileBuffer fb;
        Position pos = this.fMatchesToPositions.get(match);
        if (pos == null) {
            return pos;
        }
        AbstractTextSearchResult result = this.fMatchesToSearchResults.get(match);
        if (match.getBaseUnit() == 1 && result != null && (fb = this.getTrackedFileBuffer(result, match.getElement())) != null) {
            IDocument doc = fb.getDocument();
            try {
                pos = PositionTracker.convertToLinePosition(pos, doc);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return pos;
    }

    public static Position convertToLinePosition(Position pos, IDocument doc) throws BadLocationException {
        int offset = doc.getLineOfOffset(pos.getOffset());
        int end = doc.getLineOfOffset(pos.getOffset() + pos.getLength());
        int lineLength = end - offset;
        if (pos.getLength() > 0 && lineLength == 0) {
            ++lineLength;
        }
        return new Position(offset, lineLength);
    }

    public void dispose() {
        NewSearchUI.removeQueryListener(this);
        FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this);
    }

    public void bufferCreated(IFileBuffer buffer) {
        ISearchQuery[] queries;
        int[] trackCount = new int[1];
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        IPath location = buffer.getLocation();
        if (location == null) {
            return;
        }
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
        if (file == null) {
            return;
        }
        ISearchQuery[] iSearchQueryArray = queries = NewSearchUI.getQueries();
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTextSearchResult textResult;
            IFileMatchAdapter adapter;
            ISearchQuery query = iSearchQueryArray[n2];
            ISearchResult result = query.getSearchResult();
            if (result instanceof AbstractTextSearchResult && (adapter = (textResult = (AbstractTextSearchResult)result).getFileMatchAdapter()) != null) {
                Match[] matches;
                Match[] matchArray = matches = adapter.computeContainedMatches(textResult, file);
                int n3 = matches.length;
                int n4 = 0;
                while (n4 < n3) {
                    Match match = matchArray[n4];
                    trackCount[0] = trackCount[0] + 1;
                    this.trackPosition((AbstractTextSearchResult)result, (ITextFileBuffer)buffer, match);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void doForExistingMatchesIn(IFileBuffer buffer, IFileBufferMatchOperation operation) {
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        Set<Match> matches = this.fFileBuffersToMatches.get(buffer);
        if (matches != null) {
            HashSet<Match> matchSet = new HashSet<Match>(matches);
            for (Match element : matchSet) {
                operation.run((ITextFileBuffer)buffer, element);
            }
        }
    }

    public void bufferDisposed(IFileBuffer buffer) {
        int[] trackCount = new int[1];
        this.doForExistingMatchesIn(buffer, (textBuffer, match) -> {
            nArray[0] = trackCount[0] + 1;
            this.untrackPosition(textBuffer, match);
        });
    }

    public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
    }

    public void bufferContentReplaced(IFileBuffer buffer) {
        int[] trackCount = new int[1];
        this.doForExistingMatchesIn(buffer, (textBuffer, match) -> {
            nArray[0] = trackCount[0] + 1;
            AbstractTextSearchResult result = this.fMatchesToSearchResults.get(match);
            this.untrackPosition(textBuffer, match);
            this.trackPosition(result, textBuffer, match);
        });
    }

    public void stateChanging(IFileBuffer buffer) {
    }

    public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        if (isDirty) {
            return;
        }
        int[] trackCount = new int[1];
        this.doForExistingMatchesIn(buffer, (textBuffer, match) -> {
            nArray[0] = trackCount[0] + 1;
            Position pos = this.fMatchesToPositions.get(match);
            if (pos != null) {
                if (pos.isDeleted()) {
                    AbstractTextSearchResult result = this.fMatchesToSearchResults.get(match);
                    if (result != null) {
                        result.removeMatch(match);
                    }
                    this.untrackPosition(textBuffer, match);
                } else {
                    if (match.getBaseUnit() == 1) {
                        try {
                            pos = PositionTracker.convertToLinePosition(pos, textBuffer.getDocument());
                        }
                        catch (BadLocationException e) {
                            SearchPlugin.getDefault().getLog().log((IStatus)new Status(4, SearchPlugin.getID(), 0, e.getLocalizedMessage(), (Throwable)e));
                        }
                    }
                    match.setOffset(pos.getOffset());
                    match.setLength(pos.getLength());
                }
            }
        });
    }

    public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
    }

    public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
    }

    public void underlyingFileDeleted(IFileBuffer buffer) {
    }

    public void stateChangeFailed(IFileBuffer buffer) {
    }

    @Override
    public void queryStarting(ISearchQuery query) {
    }

    @Override
    public void queryFinished(ISearchQuery query) {
    }

    private static interface IFileBufferMatchOperation {
        public void run(ITextFileBuffer var1, Match var2);
    }
}

