/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.util.ASTHelper;

public class LinkedNodeFinder {
    private static final int FIELD = 1;
    private static final int METHOD = 2;
    private static final int TYPE = 4;
    private static final int LABEL = 8;
    private static final int NAME = 5;

    private LinkedNodeFinder() {
    }

    public static SimpleName getAssociatedRecordComponentNode(SimpleName simpleName) {
        List ff;
        CompilationUnit astRoot;
        ASTNode foundNode;
        ASTNode root;
        ITypeBinding typeBinding;
        IVariableBinding[] varBindings;
        ITypeBinding cBinding;
        SimpleName rcName = null;
        if (simpleName == null) {
            return null;
        }
        if (!ASTHelper.isRecordDeclarationNodeSupportedInAST(simpleName.getAST())) {
            return null;
        }
        IBinding binding = simpleName.resolveBinding();
        IVariableBinding rcBinding = null;
        ITypeBinding recordTypeBinding = null;
        ITypeBinding tBinding = null;
        String recCompName = null;
        if (binding instanceof IVariableBinding) {
            ITypeBinding typeBinding2;
            IVariableBinding vbinding = (IVariableBinding)binding;
            IVariableBinding bBinding = vbinding.getVariableDeclaration();
            if (bBinding == null) {
                return null;
            }
            if (!bBinding.isField()) {
                IMethodBinding mBinding;
                if (bBinding.isParameter() && (mBinding = bBinding.getDeclaringMethod()) != null && (mBinding.isCompactConstructor() || mBinding.isCanonicalConstructor()) && (typeBinding2 = mBinding.getDeclaringClass()) != null && typeBinding2.isRecord()) {
                    recordTypeBinding = typeBinding2;
                    recCompName = bBinding.getName();
                    tBinding = bBinding.getType();
                }
                if (recordTypeBinding == null) {
                    return null;
                }
            }
            if (recordTypeBinding == null) {
                ITypeBinding cBinding2 = vbinding.getDeclaringClass();
                if (cBinding2 == null) {
                    return null;
                }
                typeBinding2 = cBinding2.getTypeDeclaration();
                if (typeBinding2 == null || !typeBinding2.isRecord()) {
                    return null;
                }
                int modifiers = bBinding.getModifiers();
                if (Flags.isFinal((int)modifiers) && !Flags.isStatic((int)modifiers)) {
                    rcBinding = bBinding;
                }
            }
        } else if (binding instanceof IMethodBinding) {
            IMethodBinding mBinding = (IMethodBinding)binding;
            cBinding = mBinding.getDeclaringClass();
            if (cBinding == null) {
                return null;
            }
            ITypeBinding typeBinding3 = cBinding.getTypeDeclaration();
            IMethodBinding bBinding = mBinding.getMethodDeclaration();
            if (bBinding == null || typeBinding3 == null || bBinding.getParameterTypes().length != 0 || !typeBinding3.isRecord()) {
                return null;
            }
            if (typeBinding3.isRecord()) {
                recordTypeBinding = typeBinding3;
                recCompName = simpleName.getIdentifier();
                tBinding = bBinding.getReturnType();
            }
        } else {
            return null;
        }
        if (recCompName != null && recordTypeBinding != null && tBinding != null && (varBindings = recordTypeBinding.getDeclaredFields()) != null) {
            IVariableBinding[] modifiers = varBindings;
            int bBinding = varBindings.length;
            int typeBinding3 = 0;
            while (typeBinding3 < bBinding) {
                IVariableBinding varBinding = modifiers[typeBinding3];
                String name = varBinding.getName();
                if (simpleName.getIdentifier().equals(name)) {
                    int modifiers2 = varBinding.getModifiers();
                    if (tBinding.isEqualTo((IBinding)varBinding.getType()) && Flags.isFinal((int)modifiers2) && !Flags.isStatic((int)modifiers2)) {
                        rcBinding = varBinding;
                        break;
                    }
                }
                ++typeBinding3;
            }
        }
        RecordDeclaration recordDeclaration = null;
        if (rcBinding != null && (cBinding = rcBinding.getDeclaringClass()) != null && (typeBinding = cBinding.getTypeDeclaration()) != null && (root = simpleName.getRoot()) instanceof CompilationUnit && (foundNode = (astRoot = (CompilationUnit)root).findDeclaringNode((IBinding)typeBinding)) instanceof RecordDeclaration) {
            recordDeclaration = (RecordDeclaration)foundNode;
        }
        if (recordDeclaration != null && (ff = recordDeclaration.recordComponents()) != null) {
            for (ASTNode nd : ff) {
                if (!(nd instanceof SingleVariableDeclaration)) continue;
                SimpleName name = ((SingleVariableDeclaration)nd).getName();
                if (!simpleName.getIdentifier().equals(name.getIdentifier())) continue;
                rcName = name;
                break;
            }
        }
        return rcName;
    }

    public static SimpleName[] findByBinding(ASTNode root, IBinding binding) {
        ArrayList<SimpleName> res = new ArrayList<SimpleName>();
        BindingFinder nodeFinder = new BindingFinder(binding, res);
        root.accept((ASTVisitor)nodeFinder);
        return res.toArray(new SimpleName[res.size()]);
    }

    public static SimpleName[] findByNode(ASTNode root, SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (binding != null) {
            SimpleName recNode = LinkedNodeFinder.getAssociatedRecordComponentNode(name);
            if (recNode != null) {
                IBinding recBinding = recNode.resolveBinding();
                return LinkedNodeFinder.findByBinding(root, recBinding);
            }
            return LinkedNodeFinder.findByBinding(root, binding);
        }
        SimpleName[] names = LinkedNodeFinder.findByProblems(root, name);
        if (names != null) {
            return names;
        }
        int parentKind = name.getParent().getNodeType();
        if (parentKind == 30 || parentKind == 10 || parentKind == 18) {
            ArrayList<SimpleName> res = new ArrayList<SimpleName>();
            LabelFinder nodeFinder = new LabelFinder(name, res);
            root.accept((ASTVisitor)nodeFinder);
            return res.toArray(new SimpleName[res.size()]);
        }
        return new SimpleName[]{name};
    }

    public static Name[] findByNode(ASTNode root, Name name) {
        Name[] names = LinkedNodeFinder.findByProblems(root, name);
        if (names != null) {
            return names;
        }
        int parentKind = name.getParent().getNodeType();
        if (parentKind == 30 || parentKind == 10 || parentKind == 18) {
            ArrayList<Name> res = new ArrayList<Name>();
            QLabelFinder nodeFinder = new QLabelFinder(name, res);
            root.accept((ASTVisitor)nodeFinder);
            return res.toArray(new Name[res.size()]);
        }
        return new Name[]{name};
    }

    private static int getProblemKind(IProblem problem) {
        switch (problem.getID()) {
            case 33554502: {
                return 1;
            }
            case 0x4000064: {
                return 2;
            }
            case 536871086: {
                return 8;
            }
            case 33554515: 
            case 0x22000032: {
                return 5;
            }
            case 0x1000002: {
                return 4;
            }
        }
        return 0;
    }

    private static int getNameNodeProblemKind(IProblem[] problems, SimpleName nameNode) {
        int nameOffset = nameNode.getStartPosition();
        int nameInclEnd = nameOffset + nameNode.getLength() - 1;
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            int kind;
            IProblem curr = iProblemArray[n2];
            if (curr.getSourceStart() == nameOffset && curr.getSourceEnd() == nameInclEnd && (kind = LinkedNodeFinder.getProblemKind(curr)) != 0) {
                return kind;
            }
            ++n2;
        }
        return 0;
    }

    private static int getNameNodeProblemKind(IProblem[] problems, Name nameNode) {
        int nameOffset = nameNode.getStartPosition();
        int nameInclEnd = nameOffset + nameNode.getLength() - 1;
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            int kind;
            IProblem curr = iProblemArray[n2];
            if (curr.getSourceStart() == nameOffset && curr.getSourceEnd() == nameInclEnd && (kind = LinkedNodeFinder.getProblemKind(curr)) != 0) {
                return kind;
            }
            ++n2;
        }
        return 0;
    }

    public static SimpleName[] findByProblems(ASTNode parent, SimpleName nameNode) {
        if (nameNode.getAST().apiLevel() >= 10 && nameNode.isVar()) {
            return null;
        }
        ArrayList<SimpleName> res = new ArrayList<SimpleName>();
        ASTNode astRoot = parent.getRoot();
        if (!(astRoot instanceof CompilationUnit)) {
            return null;
        }
        IProblem[] problems = ((CompilationUnit)astRoot).getProblems();
        int nameNodeKind = LinkedNodeFinder.getNameNodeProblemKind(problems, nameNode);
        if (nameNodeKind == 0) {
            return null;
        }
        int bodyStart = parent.getStartPosition();
        int bodyEnd = bodyStart + parent.getLength();
        String name = nameNode.getIdentifier();
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode node;
            int currKind;
            IProblem curr = iProblemArray[n2];
            int probStart = curr.getSourceStart();
            int probEnd = curr.getSourceEnd() + 1;
            if (probStart > bodyStart && probEnd < bodyEnd && (nameNodeKind & (currKind = LinkedNodeFinder.getProblemKind(curr))) != 0 && (node = NodeFinder.perform((ASTNode)parent, (int)probStart, (int)(probEnd - probStart))) instanceof SimpleName && name.equals(((SimpleName)node).getIdentifier()) && (node.getAST().apiLevel() < 10 || !((SimpleName)node).isVar())) {
                res.add((SimpleName)node);
            }
            ++n2;
        }
        return res.toArray(new SimpleName[res.size()]);
    }

    public static Name[] findByProblems(ASTNode parent, Name nameNode) {
        ArrayList<Name> res = new ArrayList<Name>();
        ASTNode astRoot = parent.getRoot();
        if (!(astRoot instanceof CompilationUnit)) {
            return null;
        }
        IProblem[] problems = ((CompilationUnit)astRoot).getProblems();
        int nameNodeKind = LinkedNodeFinder.getNameNodeProblemKind(problems, nameNode);
        if (nameNodeKind == 0) {
            return null;
        }
        int bodyStart = parent.getStartPosition();
        int bodyEnd = bodyStart + parent.getLength();
        String name = nameNode.getFullyQualifiedName();
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode node;
            int currKind;
            IProblem curr = iProblemArray[n2];
            int probStart = curr.getSourceStart();
            int probEnd = curr.getSourceEnd() + 1;
            if (probStart > bodyStart && probEnd < bodyEnd && (nameNodeKind & (currKind = LinkedNodeFinder.getProblemKind(curr))) != 0 && (node = NodeFinder.perform((ASTNode)parent, (int)probStart, (int)(probEnd - probStart))) instanceof Name && name.equals(((Name)node).getFullyQualifiedName())) {
                res.add((Name)node);
            }
            ++n2;
        }
        return res.toArray(new Name[res.size()]);
    }

    private static class BindingFinder
    extends ASTVisitor {
        private IBinding fBinding;
        private ArrayList<SimpleName> fResult;

        public BindingFinder(IBinding binding, ArrayList<SimpleName> result) {
            super(true);
            this.fBinding = BindingFinder.getDeclaration(binding);
            this.fResult = result;
        }

        public boolean visit(SimpleName node) {
            if (node.getAST().apiLevel() >= 10 && node.isVar()) {
                return false;
            }
            IBinding binding = node.resolveBinding();
            if (binding == null) {
                return false;
            }
            binding = BindingFinder.getDeclaration(binding);
            SimpleName rcNode = LinkedNodeFinder.getAssociatedRecordComponentNode(node);
            if (this.fBinding == binding) {
                this.fResult.add(node);
            } else if (rcNode != null) {
                IBinding rcBinding = rcNode.resolveBinding();
                if (rcBinding != null && this.fBinding == (rcBinding = BindingFinder.getDeclaration(rcBinding))) {
                    this.fResult.add(node);
                }
            } else {
                IMethodBinding curr;
                IMethodBinding methodBinding;
                if (binding.getKind() != this.fBinding.getKind()) {
                    return false;
                }
                if (binding.getKind() == 4 && ((methodBinding = (IMethodBinding)this.fBinding).overrides(curr = (IMethodBinding)binding) || curr.overrides(methodBinding))) {
                    this.fResult.add(node);
                }
            }
            return false;
        }

        private static IBinding getDeclaration(IBinding binding) {
            if (binding instanceof ITypeBinding) {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            if (binding instanceof IMethodBinding) {
                IMethodBinding methodBinding = (IMethodBinding)binding;
                if (methodBinding.isConstructor()) {
                    return methodBinding.getDeclaringClass().getTypeDeclaration();
                }
                return methodBinding.getMethodDeclaration();
            }
            if (binding instanceof IVariableBinding) {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
            return binding;
        }
    }

    private static class LabelFinder
    extends ASTVisitor {
        private SimpleName fLabel;
        private ASTNode fDefiningLabel;
        private ArrayList<SimpleName> fResult;

        public LabelFinder(SimpleName label, ArrayList<SimpleName> result) {
            super(true);
            this.fLabel = label;
            this.fResult = result;
            this.fDefiningLabel = null;
        }

        private boolean isSameLabel(SimpleName label) {
            return label != null && this.fLabel.getIdentifier().equals(label.getIdentifier());
        }

        public boolean visit(BreakStatement node) {
            SimpleName label = node.getLabel();
            if (this.fDefiningLabel != null && this.isSameLabel(label) && ASTNodes.isParent((ASTNode)label, this.fDefiningLabel)) {
                this.fResult.add(label);
            }
            return false;
        }

        public boolean visit(ContinueStatement node) {
            SimpleName label = node.getLabel();
            if (this.fDefiningLabel != null && this.isSameLabel(label) && ASTNodes.isParent((ASTNode)label, this.fDefiningLabel)) {
                this.fResult.add(label);
            }
            return false;
        }

        public boolean visit(LabeledStatement node) {
            SimpleName label;
            if (this.fDefiningLabel == null && (this.fLabel == (label = node.getLabel()) || this.isSameLabel(label) && ASTNodes.isParent((ASTNode)this.fLabel, (ASTNode)node))) {
                this.fDefiningLabel = node;
                this.fResult.add(label);
            }
            node.getBody().accept((ASTVisitor)this);
            return false;
        }
    }

    private static class QLabelFinder
    extends ASTVisitor {
        private Name fLabel;
        private ASTNode fDefiningLabel;
        private ArrayList<Name> fResult;

        public QLabelFinder(Name label, ArrayList<Name> result) {
            super(true);
            this.fLabel = label;
            this.fResult = result;
            this.fDefiningLabel = null;
        }

        private boolean isSameLabel(Name label) {
            return label != null && this.fLabel.getFullyQualifiedName().equals(label.getFullyQualifiedName());
        }

        public boolean visit(ModuleDeclaration node) {
            Name label;
            if (this.fDefiningLabel == null && (this.fLabel == (label = node.getName()) || this.isSameLabel(label) && ASTNodes.isParent((ASTNode)this.fLabel, (ASTNode)node))) {
                this.fDefiningLabel = node;
                this.fResult.add(label);
            }
            node.getName().accept((ASTVisitor)this);
            return false;
        }
    }
}

