/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.service;

import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.util.CancelIndicator;

public class OperationCanceledManager {
    protected RuntimeException getPlatformOperationCanceledException(Throwable t) {
        if (t instanceof CancellationException) {
            return (RuntimeException)t;
        }
        if (t instanceof OperationCanceledException) {
            return (RuntimeException)t;
        }
        if (t instanceof OperationCanceledError) {
            return ((OperationCanceledError)t).getWrapped();
        }
        return null;
    }

    public boolean isOperationCanceledException(Throwable t) {
        return this.getPlatformOperationCanceledException(t) != null;
    }

    public void propagateAsErrorIfCancelException(Throwable t) {
        if (t instanceof OperationCanceledError) {
            throw (OperationCanceledError)t;
        }
        RuntimeException opCanceledException = this.getPlatformOperationCanceledException(t);
        if (opCanceledException != null) {
            throw new OperationCanceledError(opCanceledException);
        }
    }

    public void propagateIfCancelException(Throwable t) {
        RuntimeException cancelException = this.getPlatformOperationCanceledException(t);
        if (cancelException != null) {
            throw cancelException;
        }
    }

    protected Error asWrappingOperationCanceledException(Throwable throwable) {
        if (throwable instanceof OperationCanceledError) {
            return (Error)throwable;
        }
        RuntimeException platform = this.getPlatformOperationCanceledException(throwable);
        if (platform != null) {
            return new OperationCanceledError(platform);
        }
        return null;
    }

    public void throwOperationCanceledException() {
        throw this.asWrappingOperationCanceledException(this.getPlatformSpecificOperationCanceledException());
    }

    protected RuntimeException getPlatformSpecificOperationCanceledException() {
        return new OperationCanceledException();
    }

    public void checkCanceled(CancelIndicator indicator) {
        if (indicator != null && indicator.isCanceled()) {
            this.throwOperationCanceledException();
        }
    }
}

