/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteApplicationCommand
extends Command {
    private final Application application;
    private AutomationSystem system;
    private final CompoundCommand unmappApplicationElements = new CompoundCommand();

    public DeleteApplicationCommand(Application application) {
        super("Delete Application");
        this.application = application;
        if (application != null) {
            this.system = application.getAutomationSystem();
        }
    }

    public boolean canExecute() {
        return this.application != null && this.system != null;
    }

    public void execute() {
        this.getUnmappCommands();
        this.unmappApplicationElements.execute();
        this.system.getApplication().remove((Object)this.application);
    }

    public void redo() {
        this.unmappApplicationElements.redo();
        this.system.getApplication().remove((Object)this.application);
    }

    public void undo() {
        this.system.getApplication().add((Object)this.application);
        this.unmappApplicationElements.undo();
    }

    private void getUnmappCommands() {
        this.application.getFBNetwork().getNetworkElements().stream().forEach(element -> {
            Mapping mapping = element.getMapping();
            if (mapping != null) {
                this.unmappApplicationElements.add((Command)new UnmapCommand((FBNetworkElement)element));
            }
        });
    }
}

