/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.p5edges.OrthogonalEdgeRouter;
import org.eclipse.elk.alg.layered.p5edges.PolylineEdgeRouter;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineEdgeRouter;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.options.EdgeRouting;

public final class EdgeRouterFactory
implements ILayoutPhaseFactory<LayeredPhases, LGraph> {
    private static Map<EdgeRouting, EdgeRouterFactory> factoryCache = new EnumMap<EdgeRouting, EdgeRouterFactory>(EdgeRouting.class);
    private EdgeRouting edgeRoutingStrategy;

    public static EdgeRouterFactory factoryFor(EdgeRouting edgeRoutingStrategy) {
        if (!factoryCache.containsKey(edgeRoutingStrategy)) {
            EdgeRouterFactory factory = new EdgeRouterFactory();
            factory.edgeRoutingStrategy = edgeRoutingStrategy;
            factoryCache.put(edgeRoutingStrategy, factory);
        }
        return factoryCache.get(edgeRoutingStrategy);
    }

    public ILayoutPhase<LayeredPhases, LGraph> create() {
        switch (this.edgeRoutingStrategy) {
            case POLYLINE: {
                return new PolylineEdgeRouter();
            }
            case SPLINES: {
                return new SplineEdgeRouter();
            }
        }
        return new OrthogonalEdgeRouter();
    }
}

