
Initial setup

  $ . $TESTDIR/_exc-util.sh

=== A.3 new branch created ===

.. {{{
..   B' ○⇢ø B
..      | |
..      \Aø⇠◔ A'
..       \|/
..        ● O
.. }}}
..
.. Marker exist from:
..
..  * `Aø⇠○ A'`
..  * `Bø⇠○ B'`
..
.. Command run:
..
..  * hg push -r A
..
.. Expected exchange:
..
..  * chain from A
..
.. Expected Exclude:
..
..  * chain from B
..
.. Extra note:
..
.. If A and B are remontly known, we should expect:
..
..  * `hg push` will complain about the new head
..  * `hg push` should complain about unstable history creation

initial

  $ setuprepos A.3.a
  creating test repo for test case A.3.a
  - pulldest
  - main
  - pushdest
  cd into `main` and proceed with env setup
  $ cd main
  $ mkcommit A0
  $ mkcommit B0
  $ hg update -q 0
  $ mkcommit A1
  created new head
  $ hg update -q 0
  $ mkcommit B1
  created new head
  $ hg debugobsolete `getid 'desc(A0)'` `getid 'desc(A1)'`
  $ hg debugobsolete `getid 'desc(B0)'` `getid 'desc(B1)'`
  $ hg log -G --hidden
  @  f6298a8ac3a4 (draft): B1
  |
  | o  e5ea8f9c7314 (draft): A1
  |/
  | x  6e72f0a95b5e (draft): B0
  | |
  | x  28b51eb45704 (draft): A0
  |/
  o  a9bdc8b26820 (public): O
  
  $ hg debugobsolete
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  6e72f0a95b5e01a7504743aa941f69cb1fbef8b0 f6298a8ac3a4b78bbeae5f1d3dc5bc3c3812f0f3 0 {'date': '', 'user': 'test'}
  $ cd ..
  $ cd ..

Actual Test for first version (changeset unknown remotly)
---------------------------------------------------------

  $ dotest A.3.a A1
  ## Running testcase A.3.a
  # testing echange of "A1" (e5ea8f9c7314)
  ## initial state
  # obstore: main
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  6e72f0a95b5e01a7504743aa941f69cb1fbef8b0 f6298a8ac3a4b78bbeae5f1d3dc5bc3c3812f0f3 0 {'date': '', 'user': 'test'}
  # obstore: pushdest
  # obstore: pulldest
  ## pushing "A1" from main to pushdest
  pushing to pushdest
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 1 files
  OBSEXC: computing relevant nodes
  OBSEXC: computing markers relevant to 2 nodes
  OBSEXC: pushing 1 markers (62 bytes)
  OBSEXC: DONE
  ## post push state
  # obstore: main
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  6e72f0a95b5e01a7504743aa941f69cb1fbef8b0 f6298a8ac3a4b78bbeae5f1d3dc5bc3c3812f0f3 0 {'date': '', 'user': 'test'}
  # obstore: pushdest
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  # obstore: pulldest
  ## pulling "e5ea8f9c7314" from main into pulldest
  pulling from main
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 1 files
  OBSEXC: pull obsolescence markers
  OBSEXC: merging obsolescence markers (62 bytes)
  OBSEXC: 1 markers added
  OBSEXC: DONE
  (run 'hg update' to get a working copy)
  ## post pull state
  # obstore: main
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  6e72f0a95b5e01a7504743aa941f69cb1fbef8b0 f6298a8ac3a4b78bbeae5f1d3dc5bc3c3812f0f3 0 {'date': '', 'user': 'test'}
  # obstore: pushdest
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  # obstore: pulldest
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}


other variant: changeset know remotly
-------------------------------------------

  $ setuprepos A.3.b
  creating test repo for test case A.3.b
  - pulldest
  - main
  - pushdest
  cd into `main` and proceed with env setup
  $ cd main
  $ mkcommit A0
  $ mkcommit B0
  $ hg push -q ../pushdest
  $ hg push -q ../pulldest
  $ hg update -q 0
  $ mkcommit A1
  created new head
  $ hg update -q 0
  $ mkcommit B1
  created new head
  $ hg debugobsolete `getid 'desc(A0)'` `getid 'desc(A1)'`
  $ hg debugobsolete `getid 'desc(B0)'` `getid 'desc(B1)'`
  $ hg log -G --hidden
  @  f6298a8ac3a4 (draft): B1
  |
  | o  e5ea8f9c7314 (draft): A1
  |/
  | x  6e72f0a95b5e (draft): B0
  | |
  | x  28b51eb45704 (draft): A0
  |/
  o  a9bdc8b26820 (public): O
  
  $ hg debugobsolete
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  6e72f0a95b5e01a7504743aa941f69cb1fbef8b0 f6298a8ac3a4b78bbeae5f1d3dc5bc3c3812f0f3 0 {'date': '', 'user': 'test'}
  $ cd ..
  $ cd ..

Actual Test for first version (changeset unknown remotly)
---------------------------------------------------------

check it complains about multiple heads

  $ cd A.3.b
  $ hg push -R main -r e5ea8f9c7314 pushdest
  pushing to pushdest
  searching for changes
  abort: push creates new remote head e5ea8f9c7314!
  (merge or see "hg help push" for details about pushing new heads)
  [255]
  $ cd ..

test obsmarkers exchange.

  $ dotest A.3.b A1 -f
  ## Running testcase A.3.b
  # testing echange of "A1" (e5ea8f9c7314)
  ## initial state
  # obstore: main
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  6e72f0a95b5e01a7504743aa941f69cb1fbef8b0 f6298a8ac3a4b78bbeae5f1d3dc5bc3c3812f0f3 0 {'date': '', 'user': 'test'}
  # obstore: pushdest
  # obstore: pulldest
  ## pushing "A1" from main to pushdest
  pushing to pushdest
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 1 files (+1 heads)
  OBSEXC: computing relevant nodes
  OBSEXC: computing markers relevant to 2 nodes
  OBSEXC: pushing 1 markers (62 bytes)
  OBSEXC: DONE
  ## post push state
  # obstore: main
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  6e72f0a95b5e01a7504743aa941f69cb1fbef8b0 f6298a8ac3a4b78bbeae5f1d3dc5bc3c3812f0f3 0 {'date': '', 'user': 'test'}
  # obstore: pushdest
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  # obstore: pulldest
  ## pulling "e5ea8f9c7314" from main into pulldest
  pulling from main
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 2 files (+1 heads)
  OBSEXC: pull obsolescence markers
  OBSEXC: merging obsolescence markers (62 bytes)
  OBSEXC: 1 markers added
  OBSEXC: DONE
  (run 'hg heads' to see heads, 'hg merge' to merge)
  1 new unstable changesets
  ## post pull state
  # obstore: main
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  6e72f0a95b5e01a7504743aa941f69cb1fbef8b0 f6298a8ac3a4b78bbeae5f1d3dc5bc3c3812f0f3 0 {'date': '', 'user': 'test'}
  # obstore: pushdest
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
  # obstore: pulldest
  28b51eb45704506b5c603decd6bf7ac5e0f6a52f e5ea8f9c73143125d36658e90ef70c6d2027a5b7 0 {'date': '', 'user': 'test'}
