/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(t,e){var n,i,r,o,s;t.Bokeh=(n=[function(t,e,n){var i=t(160),r=t(35);n.overrides={};var o=r.clone(i);n.Models=function(t){var e=n.overrides[t]||o[t];if(null==e)throw new Error("Model '"+t+"' does not exist. This could be due to a widget\n                     or a custom model not being registered before first usage.");return e},n.Models.register=function(t,e){n.overrides[t]=e},n.Models.unregister=function(t){delete n.overrides[t]},n.Models.register_models=function(t,e,n){if(void 0===e&&(e=!1),null!=t)for(var i in t){var r=t[i];e||!o.hasOwnProperty(i)?o[i]=r:null!=n?n(i):console.warn("Model '"+i+"' was already registered")}},n.register_models=n.Models.register_models,n.Models.registered_names=function(){return Object.keys(o)}},function(t,e,n){var i=t(17),r=t(54),o=t(300),s=t(301),a=t(2);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_SESSION_ID="default";var l=0,c=function(){function t(t,e,r,o,a){void 0===t&&(t=n.DEFAULT_SERVER_WEBSOCKET_URL),void 0===e&&(e=n.DEFAULT_SESSION_ID),void 0===r&&(r=null),void 0===o&&(o=null),void 0===a&&(a=null),this.url=t,this.id=e,this.args_string=r,this._on_have_session_hook=o,this._on_closed_permanently_hook=a,this._number=l++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_ack=null,this._pending_replies={},this._pending_messages=[],this._receiver=new s.Receiver,i.logger.debug("Creating websocket "+this._number+" to '"+this.url+"' session '"+this.id+"'")}return t.prototype.connect=function(){var t=this;if(this.closed_permanently)return Promise.reject(new Error("Cannot connect() a closed ClientConnection"));if(null!=this.socket)return Promise.reject(new Error("Already connected"));this._pending_replies={},this._current_handler=null;try{var e=this.url+"?bokeh-protocol-version=1.0&bokeh-session-id="+this.id;return null!=this.args_string&&this.args_string.length>0&&(e+="&"+this.args_string),this.socket=new WebSocket(e),new Promise(function(e,n){t.socket.binaryType="arraybuffer",t.socket.onopen=function(){return t._on_open(e,n)},t.socket.onmessage=function(e){return t._on_message(e)},t.socket.onclose=function(e){return t._on_close(e)},t.socket.onerror=function(){return t._on_error(n)}})}catch(t){return i.logger.error("websocket creation failed to url: "+this.url),i.logger.error(" - "+t),Promise.reject(t)}},t.prototype.close=function(){this.closed_permanently||(i.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed(),null!=this._on_closed_permanently_hook&&(this._on_closed_permanently_hook(),this._on_closed_permanently_hook=null))},t.prototype._schedule_reconnect=function(t){var e=this;setTimeout(function(){e.closed_permanently||i.logger.info("Websocket connection "+e._number+" disconnected, will not attempt to reconnect")},t)},t.prototype.send=function(t){if(null==this.socket)throw new Error("not connected so cannot send "+t);t.send(this.socket)},t.prototype.send_with_reply=function(t){var e=this,n=new Promise(function(n,i){e._pending_replies[t.msgid()]=[n,i],e.send(t)});return n.then(function(t){if("ERROR"===t.msgtype())throw new Error("Error reply "+t.content.text);return t},function(t){throw t})},t.prototype._pull_doc_json=function(){var t=o.Message.create("PULL-DOC-REQ",{}),e=this.send_with_reply(t);return e.then(function(t){if(!("doc"in t.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return t.content.doc},function(t){throw t})},t.prototype._repull_session_doc=function(){var t=this;null==this.session?i.logger.debug("Pulling session for first time"):i.logger.debug("Repulling session"),this._pull_doc_json().then(function(e){if(null==t.session)if(t.closed_permanently)i.logger.debug("Got new document after connection was already closed");else{var n=r.Document.from_json(e),s=r.Document._compute_patch_since_json(e,n);if(s.events.length>0){i.logger.debug("Sending "+s.events.length+" changes from model construction back to server");var l=o.Message.create("PATCH-DOC",{},s);t.send(l)}t.session=new a.ClientSession(t,n,t.id);for(var c=0,h=t._pending_messages;c<h.length;c++){var u=h[c];t.session.handle(u)}t._pending_messages=[],i.logger.debug("Created a new session from new pulled doc"),null!=t._on_have_session_hook&&(t._on_have_session_hook(t.session),t._on_have_session_hook=null)}else t.session.document.replace_with_json(e),i.logger.debug("Updated existing session with new pulled doc")},function(t){throw t}).catch(function(t){null!=console.trace&&console.trace(t),i.logger.error("Failed to repull session "+t)})},t.prototype._on_open=function(t,e){var n=this;i.logger.info("Websocket connection "+this._number+" is now open"),this._pending_ack=[t,e],this._current_handler=function(t){n._awaiting_ack_handler(t)}},t.prototype._on_message=function(t){null==this._current_handler&&i.logger.error("Got a message with no current handler set");try{this._receiver.consume(t.data)}catch(t){this._close_bad_protocol(t.toString())}if(null!=this._receiver.message){var e=this._receiver.message,n=e.problem();null!=n&&this._close_bad_protocol(n),this._current_handler(e)}},t.prototype._on_close=function(t){var e=this;i.logger.info("Lost websocket "+this._number+" connection, "+t.code+" ("+t.reason+")"),this.socket=null,null!=this._pending_ack&&(this._pending_ack[1](new Error("Lost websocket connection, "+t.code+" ("+t.reason+")")),this._pending_ack=null);for(var n=function(){for(var t in e._pending_replies){var n=e._pending_replies[t];return delete e._pending_replies[t],n}return null},r=n();null!=r;)r[1]("Disconnected"),r=n();this.closed_permanently||this._schedule_reconnect(2e3)},t.prototype._on_error=function(t){i.logger.debug("Websocket error on socket "+this._number),t(new Error("Could not open websocket"))},t.prototype._close_bad_protocol=function(t){i.logger.error("Closing connection: "+t),null!=this.socket&&this.socket.close(1002,t)},t.prototype._awaiting_ack_handler=function(t){var e=this;"ACK"===t.msgtype()?(this._current_handler=function(t){return e._steady_state_handler(t)},this._repull_session_doc(),null!=this._pending_ack&&(this._pending_ack[0](this),this._pending_ack=null)):this._close_bad_protocol("First message was not an ACK")},t.prototype._steady_state_handler=function(t){if(t.reqid()in this._pending_replies){var e=this._pending_replies[t.reqid()];delete this._pending_replies[t.reqid()],e[0](t)}else this.session?this.session.handle(t):this._pending_messages.push(t)},t.__name__="ClientConnection",t}();n.ClientConnection=c,n.pull_session=function(t,e,n){return new Promise(function(r,o){var s=new c(t,e,n,function(t){try{r(t)}catch(e){throw i.logger.error("Promise handler threw an error, closing session "+e),t.close(),e}},function(){o(new Error("Connection was closed before we successfully pulled a session"))});s.connect().then(function(t){},function(t){throw i.logger.error("Failed to connect to Bokeh server "+t),t})})}},function(t,e,n){var i=t(54),r=t(300),o=t(17),s=function(){function t(t,e,n){var i=this;this._connection=t,this.document=e,this.id=n,this._document_listener=function(t){return i._document_changed(t)},this.document.on_change(this._document_listener),this.event_manager=this.document.event_manager,this.event_manager.session=this}return t.prototype.handle=function(t){var e=t.msgtype();"PATCH-DOC"===e?this._handle_patch(t):"OK"===e?this._handle_ok(t):"ERROR"===e?this._handle_error(t):o.logger.debug("Doing nothing with message "+t.msgtype())},t.prototype.close=function(){this._connection.close()},t.prototype.send_event=function(t){var e=r.Message.create("EVENT",{},JSON.stringify(t.to_json()));this._connection.send(e)},t.prototype._connection_closed=function(){this.document.remove_on_change(this._document_listener)},t.prototype.request_server_info=function(){var t=r.Message.create("SERVER-INFO-REQ",{}),e=this._connection.send_with_reply(t);return e.then(function(t){return t.content})},t.prototype.force_roundtrip=function(){return this.request_server_info().then(function(t){})},t.prototype._document_changed=function(t){if(t.setter_id!==this.id&&(!(t instanceof i.ModelChangedEvent)||t.attr in t.model.serializable_attributes())){var e=r.Message.create("PATCH-DOC",{},this.document.create_json_patch([t]));this._connection.send(e)}},t.prototype._handle_patch=function(t){this.document.apply_json_patch(t.content,t.buffers,this.id)},t.prototype._handle_ok=function(t){o.logger.trace("Unhandled OK reply to "+t.reqid())},t.prototype._handle_error=function(t){o.logger.error("Unhandled ERROR reply to "+t.reqid()+": "+t.content.text)},t.__name__="ClientSession",t}();n.ClientSession=s},function(t,e,n){var i=t(421);function r(t){return function(e){e.prototype.event_name=t}}var o=function(){function t(){}return t.prototype.to_json=function(){var t=this.event_name;return{event_name:t,event_values:this._to_json()}},t.prototype._to_json=function(){var t=this.origin;return{model_id:null!=t?t.id:null}},t.__name__="BokehEvent",t}();n.BokehEvent=o;var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="ButtonClick",e=i.__decorate([r("button_click")],e)}(o);n.ButtonClick=s;var a=function(t){function e(e){var n=t.call(this)||this;return n.item=e,n}return i.__extends(e,t),e.prototype._to_json=function(){var e=this.item;return i.__assign({},t.prototype._to_json.call(this),{item:e})},e.__name__="MenuItemClick",e=i.__decorate([r("menu_item_click")],e)}(o);n.MenuItemClick=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="UIEvent",e}(o);n.UIEvent=l;var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="LODStart",e=i.__decorate([r("lodstart")],e)}(l);n.LODStart=c;var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="LODEnd",e=i.__decorate([r("lodend")],e)}(l);n.LODEnd=h;var u=function(t){function e(e,n){var i=t.call(this)||this;return i.geometry=e,i.final=n,i}return i.__extends(e,t),e.prototype._to_json=function(){var e=this.geometry,n=this.final;return i.__assign({},t.prototype._to_json.call(this),{geometry:e,final:n})},e.__name__="SelectionGeometry",e=i.__decorate([r("selectiongeometry")],e)}(l);n.SelectionGeometry=u;var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="Reset",e=i.__decorate([r("reset")],e)}(l);n.Reset=_;var d=function(t){function e(e,n,i,r){var o=t.call(this)||this;return o.sx=e,o.sy=n,o.x=i,o.y=r,o}return i.__extends(e,t),e.prototype._to_json=function(){var e=this.sx,n=this.sy,r=this.x,o=this.y;return i.__assign({},t.prototype._to_json.call(this),{sx:e,sy:n,x:r,y:o})},e.__name__="PointEvent",e}(l);n.PointEvent=d;var p=function(t){function e(e,n,i,r,o,s){var a=t.call(this,e,n,i,r)||this;return a.sx=e,a.sy=n,a.x=i,a.y=r,a.delta_x=o,a.delta_y=s,a}return i.__extends(e,t),e.prototype._to_json=function(){var e=this.delta_x,n=this.delta_y;return i.__assign({},t.prototype._to_json.call(this),{delta_x:e,delta_y:n})},e.__name__="Pan",e=i.__decorate([r("pan")],e)}(d);n.Pan=p;var f=function(t){function e(e,n,i,r,o){var s=t.call(this,e,n,i,r)||this;return s.sx=e,s.sy=n,s.x=i,s.y=r,s.scale=o,s}return i.__extends(e,t),e.prototype._to_json=function(){var e=this.scale;return i.__assign({},t.prototype._to_json.call(this),{scale:e})},e.__name__="Pinch",e=i.__decorate([r("pinch")],e)}(d);n.Pinch=f;var m=function(t){function e(e,n,i,r,o){var s=t.call(this,e,n,i,r)||this;return s.sx=e,s.sy=n,s.x=i,s.y=r,s.delta=o,s}return i.__extends(e,t),e.prototype._to_json=function(){var e=this.delta;return i.__assign({},t.prototype._to_json.call(this),{delta:e})},e.__name__="MouseWheel",e=i.__decorate([r("wheel")],e)}(d);n.MouseWheel=m;var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="MouseMove",e=i.__decorate([r("mousemove")],e)}(d);n.MouseMove=v;var g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="MouseEnter",e=i.__decorate([r("mouseenter")],e)}(d);n.MouseEnter=g;var y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="MouseLeave",e=i.__decorate([r("mouseleave")],e)}(d);n.MouseLeave=y;var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="Tap",e=i.__decorate([r("tap")],e)}(d);n.Tap=b;var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="DoubleTap",e=i.__decorate([r("doubletap")],e)}(d);n.DoubleTap=w;var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="Press",e=i.__decorate([r("press")],e)}(d);n.Press=x;var A=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="PanStart",e=i.__decorate([r("panstart")],e)}(d);n.PanStart=A;var k=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="PanEnd",e=i.__decorate([r("panend")],e)}(d);n.PanEnd=k;var C=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="PinchStart",e=i.__decorate([r("pinchstart")],e)}(d);n.PinchStart=C;var T=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="PinchEnd",e=i.__decorate([r("pinchend")],e)}(d);n.PinchEnd=T},function(t,e,n){var i=t(421),r=t(24);n.build_views=function(t,e,n,o){void 0===o&&(o=function(t){return t.default_view});for(var s=r.difference(Object.keys(t),e.map(function(t){return t.id})),a=0,l=s;a<l.length;a++){var c=l[a];t[c].remove(),delete t[c]}for(var h=[],u=e.filter(function(e){return null==t[e.id]}),_=0,d=u;_<d.length;_++){var p=d[_],f=o(p),m=i.__assign({},n,{model:p,connect_signals:!1}),v=new f(m);t[p.id]=v,h.push(v)}for(var g=0,y=h;g<y.length;g++){var v=y[g];v.connect_signals()}return h},n.remove_views=function(t){for(var e in t)t[e].remove(),delete t[e]}},function(t,e,n){var i=t(46),r=function(t){return function(e){void 0===e&&(e={});for(var n=[],r=1;r<arguments.length;r++)n[r-1]=arguments[r];var o=document.createElement(t);for(var s in o.classList.add("bk"),e){var a=e[s];if(null!=a&&(!i.isBoolean(a)||a))if("class"===s&&(i.isString(a)&&(a=a.split(/\s+/)),i.isArray(a)))for(var l=0,c=a;l<c.length;l++){var h=c[l];null!=h&&o.classList.add(h)}else if("style"===s&&i.isPlainObject(a))for(var u in a)o.style[u]=a[u];else if("data"===s&&i.isPlainObject(a))for(var _ in a)o.dataset[_]=a[_];else o.setAttribute(s,a)}function d(t){if(t instanceof HTMLElement)o.appendChild(t);else if(i.isString(t))o.appendChild(document.createTextNode(t));else if(null!=t&&!1!==t)throw new Error("expected an HTMLElement, string, false or null, got "+JSON.stringify(t))}for(var p=0,f=n;p<f.length;p++){var m=f[p];if(i.isArray(m))for(var v=0,g=m;v<g.length;v++){var y=g[v];d(y)}else d(m)}return o}};function o(t){for(var e=[],n=1;n<arguments.length;n++)e[n-1]=arguments[n];for(var i=t.firstChild,r=0,o=e;r<o.length;r++){var s=o[r];t.insertBefore(s,i)}}function s(t,e){var n=Element.prototype,i=n.matches||n.webkitMatchesSelector||n.mozMatchesSelector||n.msMatchesSelector;return i.call(t,e)}function a(t){return parseFloat(t)||0}function l(t){var e=getComputedStyle(t);return{border:{top:a(e.borderTopWidth),bottom:a(e.borderBottomWidth),left:a(e.borderLeftWidth),right:a(e.borderRightWidth)},margin:{top:a(e.marginTop),bottom:a(e.marginBottom),left:a(e.marginLeft),right:a(e.marginRight)},padding:{top:a(e.paddingTop),bottom:a(e.paddingBottom),left:a(e.paddingLeft),right:a(e.paddingRight)}}}function c(t){var e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}function h(t){return Array.from(t.children)}n.createElement=function(t,e){for(var n=[],i=2;i<arguments.length;i++)n[i-2]=arguments[i];return r(t).apply(void 0,[e].concat(n))},n.div=r("div"),n.span=r("span"),n.canvas=r("canvas"),n.link=r("link"),n.style=r("style"),n.a=r("a"),n.p=r("p"),n.i=r("i"),n.pre=r("pre"),n.button=r("button"),n.label=r("label"),n.input=r("input"),n.select=r("select"),n.option=r("option"),n.optgroup=r("optgroup"),n.textarea=r("textarea"),n.nbsp=function(){return document.createTextNode(" ")},n.removeElement=function(t){var e=t.parentNode;null!=e&&e.removeChild(t)},n.replaceWith=function(t,e){var n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=o,n.empty=function(t){for(var e;e=t.firstChild;)t.removeChild(e)},n.display=function(t){t.style.display=""},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset=function(t){var e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},n.matches=s,n.parent=function(t,e){for(var n=t;n=n.parentElement;)if(s(n,e))return n;return null},n.extents=l,n.size=c,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){var e=l(t).margin,n=e.left,i=e.right,r=e.top,o=e.bottom,s=c(t),a=s.width,h=s.height;return{width:Math.ceil(a+n+i),height:Math.ceil(h+r+o)}},n.content_size=function(t){for(var e=t.getBoundingClientRect(),n=e.left,i=e.top,r=l(t).padding,o=0,s=0,a=0,c=h(t);a<c.length;a++){var u=c[a],_=u.getBoundingClientRect();o=Math.max(o,Math.ceil(_.left-n-r.left+_.width)),s=Math.max(s,Math.ceil(_.top-i-r.top+_.height))}return{width:o,height:s}},n.position=function(t,e,n){var i=t.style;if(i.left=e.x+"px",i.top=e.y+"px",i.width=e.width+"px",i.height=e.height+"px",null==n)i.margin="";else{var r=n.top,o=n.right,s=n.bottom,a=n.left;i.margin=r+"px "+o+"px "+s+"px "+a+"px"}},n.children=h;var u=function(){function t(t){this.el=t,this.classList=t.classList}return Object.defineProperty(t.prototype,"values",{get:function(){for(var t=[],e=0;e<this.classList.length;e++){var n=this.classList.item(e);null!=n&&t.push(n)}return t},enumerable:!0,configurable:!0}),t.prototype.has=function(t){return this.classList.contains(t)},t.prototype.add=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];for(var n=0,i=t;n<i.length;n++){var r=i[n];this.classList.add(r)}return this},t.prototype.remove=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];for(var n=0,i=t;n<i.length;n++){var r=i[n];this.classList.remove(r)}return this},t.prototype.clear=function(){for(var t=0,e=this.values;t<e.length;t++){var n=e[t];"bk"!=n&&this.classList.remove(n)}return this},t.prototype.toggle=function(t,e){var n=null!=e?e:!this.has(t);return n?this.add(t):this.remove(t),this},t.__name__="ClassList",t}();function _(t,e,n){var i=t.style,r=i.width,o=i.height,s=i.position,a=i.display;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return n()}finally{t.style.position=s,t.style.display=a,t.style.width=r,t.style.height=o}}n.ClassList=u,n.classes=function(t){return new u(t)},function(t){t[t.Backspace=8]="Backspace",t[t.Tab=9]="Tab",t[t.Enter=13]="Enter",t[t.Esc=27]="Esc",t[t.PageUp=33]="PageUp",t[t.PageDown=34]="PageDown",t[t.Left=37]="Left",t[t.Up=38]="Up",t[t.Right=39]="Right",t[t.Down=40]="Down",t[t.Delete=46]="Delete"}(n.Keys||(n.Keys={})),n.undisplayed=function(t,e){var n=t.style.display;t.style.display="none";try{return e()}finally{t.style.display=n}},n.unsized=function(t,e){return _(t,{},e)},n.sized=_;var d=function(){function t(){this.style=n.style({type:"text/css"}),o(document.head,this.style)}return t.prototype.append=function(t){this.style.appendChild(document.createTextNode(t))},t.__name__="StyleSheet",t}();n.StyleSheet=d,n.styles=new d},function(t,e,n){var i=t(421),r=t(50),o=t(5),s=t(311),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._has_finished=!1,this.el=this._createElement()},e.prototype.remove=function(){o.removeElement(this.el),t.prototype.remove.call(this)},e.prototype.css_classes=function(){return[]},e.prototype.cursor=function(t,e){return null},e.prototype.render=function(){},e.prototype.renderTo=function(t){t.appendChild(this.el),this.render()},e.prototype.has_finished=function(){return this._has_finished},Object.defineProperty(e.prototype,"_root_element",{get:function(){return o.parent(this.el,"."+s.bk_root)||document.body},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_idle",{get:function(){return this.has_finished()},enumerable:!0,configurable:!0}),e.prototype._createElement=function(){return o.createElement(this.tagName,{class:this.css_classes()})},e.__name__="DOMView",e}(r.View);n.DOMView=a,a.prototype.tagName="div"},function(t,e,n){n.Align=["start","center","end"],n.Anchor=["top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"],n.AngleUnits=["deg","rad"],n.BoxOrigin=["corner","center"],n.ButtonType=["default","primary","success","warning","danger"],n.Dimension=["width","height"],n.Dimensions=["width","height","both"],n.Direction=["clock","anticlock"],n.Distribution=["uniform","normal"],n.FontStyle=["normal","italic","bold","bold italic"],n.HatchPatternType=["blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"],n.HTTPMethod=["POST","GET"],n.HexTileOrientation=["pointytop","flattop"],n.HoverMode=["mouse","hline","vline"],n.LatLon=["lat","lon"],n.LegendClickPolicy=["none","hide","mute"],n.LegendLocation=n.Anchor,n.LineCap=["butt","round","square"],n.LineJoin=["miter","round","bevel"],n.LinePolicy=["prev","next","nearest","interp","none"],n.Location=["above","below","left","right"],n.Logo=["normal","grey"],n.MarkerType=["asterisk","circle","circle_cross","circle_x","cross","dash","diamond","diamond_cross","hex","inverted_triangle","square","square_cross","square_x","triangle","x"],n.Orientation=["vertical","horizontal"],n.OutputBackend=["canvas","svg","webgl"],n.PaddingUnits=["percent","absolute"],n.Place=["above","below","left","right","center"],n.PointPolicy=["snap_to_data","follow_mouse","none"],n.RadiusDimension=["x","y","max","min"],n.RenderLevel=["image","underlay","glyph","annotation","overlay"],n.RenderMode=["canvas","css"],n.ResetPolicy=["standard","event_only"],n.RoundingFunction=["round","nearest","floor","rounddown","ceil","roundup"],n.Side=["above","below","left","right"],n.SizingMode=["stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"],n.SliderCallbackPolicy=["continuous","throttle","mouseup"],n.Sort=["ascending","descending"],n.SpatialUnits=["screen","data"],n.StartEnd=["start","end"],n.StepMode=["after","before","center"],n.TapBehavior=["select","inspect"],n.TextAlign=["left","right","center"],n.TextBaseline=["top","middle","bottom","alphabetic","hanging","ideographic"],n.TextureRepetition=["repeat","repeat_x","repeat_y","no_repeat"],n.TickLabelOrientation=["vertical","horizontal","parallel","normal"],n.TooltipAttachment=["horizontal","vertical","left","right","above","below"],n.UpdateMode=["replace","append"],n.VerticalAlign=["top","middle","bottom"]},function(t,e,n){var i=t(421),r=t(22),o=t(19),s=t(37),a=t(18),l=t(40),c=t(24),h=t(35),u=t(46),_=t(33),d=function(t){function e(e){void 0===e&&(e={});var n=t.call(this)||this;for(var i in n._subtype=void 0,n.document=null,n.destroyed=new r.Signal0(n,"destroyed"),n.change=new r.Signal0(n,"change"),n.transformchange=new r.Signal0(n,"transformchange"),n.attributes={},n.properties={},n._set_after_defaults={},n._pending=!1,n._changing=!1,n.props){var o=n.props[i],s=o.type,a=o.default_value;if(null==s)throw new Error("undefined property type for "+n.type+"."+i);n.properties[i]=new s(n,i,a)}null==e.id&&n.setv({id:l.uniqueId()},{silent:!0});var c=e.__deferred__||!1;return c&&delete(e=h.clone(e)).__deferred__,n.setv(e,{silent:!0}),c||n.finalize(),n}return i.__extends(e,t),Object.defineProperty(e.prototype,"type",{get:function(){return this.constructor.__name__},set:function(t){this.constructor.__name__=t},enumerable:!0,configurable:!0}),e.initClass=function(){this.prototype.props={},this.prototype.mixins=[],this.define({id:[a.Any]})},e._fix_default=function(t,e){return void 0===t?void 0:u.isFunction(t)?t:u.isObject(t)?u.isArray(t)?function(){return c.copy(t)}:function(){return h.clone(t)}:function(){return t}},e.define=function(t){var e=function(e){var i=t[e];if(null!=n.prototype.props[e])throw new Error("attempted to redefine property '"+n.prototype.type+"."+e+"'");if(null!=n.prototype[e])throw new Error("attempted to redefine attribute '"+n.prototype.type+"."+e+"'");Object.defineProperty(n.prototype,e,{get:function(){var t=this.getv(e);return t},set:function(t){var n;return this.setv(((n={})[e]=t,n)),this},configurable:!1,enumerable:!0});var r=i,o=r[0],s=r[1],a=r[2],l={type:o,default_value:n._fix_default(s,e),internal:a||!1},c=h.clone(n.prototype.props);c[e]=l,n.prototype.props=c},n=this;for(var i in t)e(i)},e.internal=function(t){var e={};for(var n in t){var i=t[n],r=i[0],o=i[1];e[n]=[r,o,!0]}this.define(e)},e.mixin=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.define(o.create(t));var n=this.prototype.mixins.concat(t);this.prototype.mixins=n},e.mixins=function(t){this.mixin.apply(this,t)},e.override=function(t){for(var e in t){var n=this._fix_default(t[e],e),r=this.prototype.props[e];if(null==r)throw new Error("attempted to override nonexistent '"+this.prototype.type+"."+e+"'");var o=h.clone(this.prototype.props);o[e]=i.__assign({},r,{default_value:n}),this.prototype.props=o}},e.prototype.toString=function(){return this.type+"("+this.id+")"},e.prototype.finalize=function(){var t=this;for(var e in this.properties){var n=this.properties[e];n.update(),null!=n.spec.transform&&this.connect(n.spec.transform.change,function(){return t.transformchange.emit()})}this.initialize(),this.connect_signals()},e.prototype.initialize=function(){},e.prototype.connect_signals=function(){},e.prototype.disconnect_signals=function(){r.Signal.disconnectReceiver(this)},e.prototype.destroy=function(){this.disconnect_signals(),this.destroyed.emit()},e.prototype.clone=function(){return new this.constructor(this.attributes)},e.prototype._setv=function(t,e){var n=e.check_eq,i=e.silent,r=[],o=this._changing;this._changing=!0;var s=this.attributes;for(var a in t){var l=t[a];!1!==n&&_.isEqual(s[a],l)||r.push(a),s[a]=l}if(!i){r.length>0&&(this._pending=!0);for(var c=0;c<r.length;c++)this.properties[r[c]].change.emit()}if(!o){if(!i&&!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}},e.prototype.setv=function(t,e){for(var n in void 0===e&&(e={}),t)if(t.hasOwnProperty(n)){var i=n;if(null==this.props[i])throw new Error("property "+this.type+"."+i+" wasn't declared");null!=e&&e.defaults||(this._set_after_defaults[n]=!0)}if(!h.isEmpty(t)){var r={};for(var n in t)r[n]=this.getv(n);this._setv(t,e);var o=e.silent;if(null==o||!o)for(var n in t)this._tell_document_about_change(n,r[n],this.getv(n),e)}},e.prototype.getv=function(t){if(null==this.props[t])throw new Error("property "+this.type+"."+t+" wasn't declared");return this.attributes[t]},e.prototype.ref=function(){return s.create_ref(this)},e.prototype.set_subtype=function(t){this._subtype=t},e.prototype.attribute_is_serializable=function(t){var e=this.props[t];if(null==e)throw new Error(this.type+".attribute_is_serializable('"+t+"'): "+t+" wasn't declared");return!e.internal},e.prototype.serializable_attributes=function(){var t={};for(var e in this.attributes){var n=this.attributes[e];this.attribute_is_serializable(e)&&(t[e]=n)}return t},e._value_to_json=function(t,n,i){if(n instanceof e)return n.ref();if(u.isArray(n)){for(var r=[],o=0;o<n.length;o++){var s=n[o];r.push(e._value_to_json(o.toString(),s,n))}return r}if(u.isPlainObject(n)){var a={};for(var l in n)n.hasOwnProperty(l)&&(a[l]=e._value_to_json(l,n[l],n));return a}return n},e.prototype.attributes_as_json=function(t,n){void 0===t&&(t=!0),void 0===n&&(n=e._value_to_json);var i=this.serializable_attributes(),r={};for(var o in i)if(i.hasOwnProperty(o)){var s=i[o];t?r[o]=s:o in this._set_after_defaults&&(r[o]=s)}return n("attributes",r,this)},e._json_record_references=function(t,n,i,r){if(null==n);else if(s.is_ref(n)){if(!(n.id in i)){var o=t.get_model_by_id(n.id);e._value_record_references(o,i,r)}}else if(u.isArray(n))for(var a=0,l=n;a<l.length;a++){var c=l[a];e._json_record_references(t,c,i,r)}else if(u.isPlainObject(n))for(var h in n)if(n.hasOwnProperty(h)){var c=n[h];e._json_record_references(t,c,i,r)}},e._value_record_references=function(t,n,i){if(null==t);else if(t instanceof e){if(!(t.id in n)&&(n[t.id]=t,i))for(var r=t._immediate_references(),o=0,s=r;o<s.length;o++){var a=s[o];e._value_record_references(a,n,!0)}}else if(t.buffer instanceof ArrayBuffer);else if(u.isArray(t))for(var l=0,c=t;l<c.length;l++){var h=c[l];e._value_record_references(h,n,i)}else if(u.isPlainObject(t))for(var _ in t)if(t.hasOwnProperty(_)){var h=t[_];e._value_record_references(h,n,i)}},e.prototype._immediate_references=function(){var t={},n=this.serializable_attributes();for(var i in n){var r=n[i];e._value_record_references(r,t,!1)}return h.values(t)},e.prototype.references=function(){var t={};return e._value_record_references(this,t,!0),h.values(t)},e.prototype._doc_attached=function(){},e.prototype.attach_document=function(t){if(null!=this.document&&this.document!=t)throw new Error("models must be owned by only a single document");this.document=t,this._doc_attached()},e.prototype.detach_document=function(){this.document=null},e.prototype._tell_document_about_change=function(t,n,i,r){if(this.attribute_is_serializable(t)&&null!=this.document){var o={};e._value_record_references(i,o,!1);var s={};e._value_record_references(n,s,!1);var a=!1;for(var l in o)if(!(l in s)){a=!0;break}if(!a)for(var c in s)if(!(c in o)){a=!0;break}a&&this.document._invalidate_all_models(),this.document._notify_change(this,t,n,i,r)}},e.prototype.materialize_dataspecs=function(t){var e={};for(var n in this.properties){var i=this.properties[n];if(i instanceof a.VectorSpec&&(!i.optional||null!=i.spec.value||n in this._set_after_defaults)){var r=i.array(t);e["_"+n]=r,null!=i.spec.field&&i.spec.field in t._shapes&&(e["_"+n+"_shape"]=t._shapes[i.spec.field]),i instanceof a.DistanceSpec&&(e["max_"+n]=c.max(r))}}return e},e.__name__="HasProps",e}(r.Signalable());n.HasProps=d,d.initClass()},function(t,e,n){var i=t(24),r=t(209);function o(t){return t*t}function s(t,e){return o(t.x-e.x)+o(t.y-e.y)}function a(t,e,n){var i=s(e,n);if(0==i)return s(t,e);var r=((t.x-e.x)*(n.x-e.x)+(t.y-e.y)*(n.y-e.y))/i;if(r<0)return s(t,e);if(r>1)return s(t,n);var o={x:e.x+r*(n.x-e.x),y:e.y+r*(n.y-e.y)};return s(t,o)}n.point_in_poly=function(t,e,n,i){for(var r=!1,o=n[n.length-1],s=i[i.length-1],a=0;a<n.length;a++){var l=n[a],c=i[a];s<e!=c<e&&o+(e-s)/(c-s)*(l-o)<t&&(r=!r),o=l,s=c}return r},n.point_in_ellipse=function(t,e,n,i,r,o,s){var a=Math.pow(Math.cos(n)/r,2)+Math.pow(Math.sin(n)/i,2),l=2*Math.cos(n)*Math.sin(n)*(Math.pow(1/r,2)-Math.pow(1/i,2)),c=Math.pow(Math.cos(n)/i,2)+Math.pow(Math.sin(n)/r,2);return a*Math.pow(t-o,2)+l*(t-o)*(e-s)+c*Math.pow(e-s,2)<=1},n.create_empty_hit_test_result=function(){return new r.Selection},n.create_hit_test_result_from_hits=function(t){var e=new r.Selection;return e.indices=i.sort_by(t,function(t){return t[0],t[1]}).map(function(t){var e=t[0];return t[1],e}),e},n.dist_2_pts=s,n.dist_to_segment_squared=a,n.dist_to_segment=function(t,e,n){return Math.sqrt(a(t,e,n))},n.check_2_segments_intersect=function(t,e,n,i,r,o,s,a){var l=(a-o)*(n-t)-(s-r)*(i-e);if(0==l)return{hit:!1,x:null,y:null};var c=e-o,h=t-r,u=(s-r)*c-(a-o)*h,_=(n-t)*c-(i-e)*h;h=_/l;var d=t+(c=u/l)*(n-t),p=e+c*(i-e);return{hit:c>0&&c<1&&h>0&&h<1,x:d,y:p}}},function(t,e,n){var i=t(421),r=t(14),o=t(27),s=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.children=[],e}return i.__extends(e,t),e.__name__="Stack",e}(r.Layoutable);n.Stack=s;var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._measure=function(t){for(var e=0,n=0,i=0,r=this.children;i<r.length;i++){var o=r[i],s=o.measure({width:0,height:0});e+=s.width,n=Math.max(n,s.height)}return{width:e,height:n}},e.prototype._set_geometry=function(e,n){t.prototype._set_geometry.call(this,e,n);for(var i=e.top,r=e.bottom,s=e.left,a=0,l=this.children;a<l.length;a++){var c=l[a],h=c.measure({width:0,height:0}).width;c.set_geometry(new o.BBox({left:s,width:h,top:i,bottom:r})),s+=h}},e.__name__="HStack",e}(s);n.HStack=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._measure=function(t){for(var e=0,n=0,i=0,r=this.children;i<r.length;i++){var o=r[i],s=o.measure({width:0,height:0});e=Math.max(e,s.width),n+=s.height}return{width:e,height:n}},e.prototype._set_geometry=function(e,n){t.prototype._set_geometry.call(this,e,n);for(var i=e.left,r=e.right,s=e.top,a=0,l=this.children;a<l.length;a++){var c=l[a],h=c.measure({width:0,height:0}).height;c.set_geometry(new o.BBox({top:s,height:h,left:i,right:r})),s+=h}},e.__name__="VStack",e}(s);n.VStack=l;var c=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.children=[],e}return i.__extends(e,t),e.prototype._measure=function(t){for(var e=0,n=0,i=0,r=this.children;i<r.length;i++){var o=r[i].layout,s=o.measure(t);e=Math.max(e,s.width),n=Math.max(n,s.height)}return{width:e,height:n}},e.prototype._set_geometry=function(e,n){t.prototype._set_geometry.call(this,e,n);for(var i=0,r=this.children;i<r.length;i++){var s=r[i],a=s.layout,l=s.anchor,c=s.margin,h=e.left,u=e.right,_=e.top,d=e.bottom,p=e.hcenter,f=e.vcenter,m=a.measure(e),v=m.width,g=m.height,y=void 0;switch(l){case"top_left":y=new o.BBox({left:h+c,top:_+c,width:v,height:g});break;case"top_center":y=new o.BBox({hcenter:p,top:_+c,width:v,height:g});break;case"top_right":y=new o.BBox({right:u-c,top:_+c,width:v,height:g});break;case"bottom_right":y=new o.BBox({right:u-c,bottom:d-c,width:v,height:g});break;case"bottom_center":y=new o.BBox({hcenter:p,bottom:d-c,width:v,height:g});break;case"bottom_left":y=new o.BBox({left:h+c,bottom:d-c,width:v,height:g});break;case"center_left":y=new o.BBox({left:h+c,vcenter:f,width:v,height:g});break;case"center":y=new o.BBox({hcenter:p,vcenter:f,width:v,height:g});break;case"center_right":y=new o.BBox({right:u-c,vcenter:f,width:v,height:g});break;default:throw new Error("unreachable")}a.set_geometry(y)}},e.__name__="AnchorLayout",e}(r.Layoutable);n.AnchorLayout=c},function(t,e,n){var i=t(421),r=t(16),o=t(14),s=t(46),a=t(27),l=t(24),c=Math.max,h=Math.round,u=function(){function t(t){this.def=t,this._map=new Map}return t.prototype.get=function(t){var e=this._map.get(t);return void 0===e&&(e=this.def(),this._map.set(t,e)),e},t.prototype.apply=function(t,e){var n=this.get(t);this._map.set(t,e(n))},t.__name__="DefaultMap",t}(),_=function(){function t(){this._items=[],this._nrows=0,this._ncols=0}return Object.defineProperty(t.prototype,"nrows",{get:function(){return this._nrows},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ncols",{get:function(){return this._ncols},enumerable:!0,configurable:!0}),t.prototype.add=function(t,e){var n=t.r1,i=t.c1;this._nrows=c(this._nrows,n+1),this._ncols=c(this._ncols,i+1),this._items.push({span:t,data:e})},t.prototype.at=function(t,e){var n=this._items.filter(function(n){var i=n.span;return i.r0<=t&&t<=i.r1&&i.c0<=e&&e<=i.c1});return n.map(function(t){var e=t.data;return e})},t.prototype.row=function(t){var e=this._items.filter(function(e){var n=e.span;return n.r0<=t&&t<=n.r1});return e.map(function(t){var e=t.data;return e})},t.prototype.col=function(t){var e=this._items.filter(function(e){var n=e.span;return n.c0<=t&&t<=n.c1});return e.map(function(t){var e=t.data;return e})},t.prototype.foreach=function(t){for(var e=0,n=this._items;e<n.length;e++){var i=n[e],r=i.span,o=i.data;t(r,o)}},t.prototype.map=function(e){for(var n=new t,i=0,r=this._items;i<r.length;i++){var o=r[i],s=o.span,a=o.data;n.add(s,e(s,a))}return n},t.__name__="Container",t}(),d=function(t){function e(e){void 0===e&&(e=[]);var n=t.call(this)||this;return n.items=e,n.rows="auto",n.cols="auto",n.spacing=0,n.absolute=!1,n}return i.__extends(e,t),e.prototype.is_width_expanding=function(){if(t.prototype.is_width_expanding.call(this))return!0;if("fixed"==this.sizing.width_policy)return!1;var e=this._state.cols;return l.some(e,function(t){return"max"==t.policy})},e.prototype.is_height_expanding=function(){if(t.prototype.is_height_expanding.call(this))return!0;if("fixed"==this.sizing.height_policy)return!1;var e=this._state.rows;return l.some(e,function(t){return"max"==t.policy})},e.prototype._init=function(){var e=this;t.prototype._init.call(this);for(var n=new _,i=0,r=this.items;i<r.length;i++){var o=r[i],a=o.layout,c=o.row,h=o.col,u=o.row_span,d=o.col_span;if(a.sizing.visible){var p=c,f=h,m=c+(null!=u?u:1)-1,v=h+(null!=d?d:1)-1;n.add({r0:p,c0:f,r1:m,c1:v},a)}}for(var g=n.nrows,y=n.ncols,b=new Array(g),w=function(t){var i,r=null==(i=s.isPlainObject(e.rows)?e.rows[t]||e.rows["*"]:e.rows)?{policy:"auto"}:s.isNumber(i)?{policy:"fixed",height:i}:s.isString(i)?{policy:i}:i,o=r.align||"auto";if("fixed"==r.policy)b[t]={policy:"fixed",height:r.height,align:o};else if("min"==r.policy)b[t]={policy:"min",align:o};else if("fit"==r.policy||"max"==r.policy)b[t]={policy:r.policy,flex:r.flex||1,align:o};else{if("auto"!=r.policy)throw new Error("unrechable");l.some(n.row(t),function(t){return t.is_height_expanding()})?b[t]={policy:"max",flex:1,align:o}:b[t]={policy:"min",align:o}}},x=0;x<g;x++)w(x);for(var A=new Array(y),k=function(t){var i,r=null==(i=s.isPlainObject(e.cols)?e.cols[t]||e.cols["*"]:e.cols)?{policy:"auto"}:s.isNumber(i)?{policy:"fixed",width:i}:s.isString(i)?{policy:i}:i,o=r.align||"auto";if("fixed"==r.policy)A[t]={policy:"fixed",width:r.width,align:o};else if("min"==r.policy)A[t]={policy:"min",align:o};else if("fit"==r.policy||"max"==r.policy)A[t]={policy:r.policy,flex:r.flex||1,align:o};else{if("auto"!=r.policy)throw new Error("unrechable");l.some(n.col(t),function(t){return t.is_width_expanding()})?A[t]={policy:"max",flex:1,align:o}:A[t]={policy:"min",align:o}}},C=0;C<y;C++)k(C);var T=s.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing,S=T[0],M=T[1];this._state={items:n,nrows:g,ncols:y,rows:b,cols:A,rspacing:S,cspacing:M}},e.prototype._measure_totals=function(t,e){var n=this._state,i=n.nrows,r=n.ncols,o=n.rspacing,s=n.cspacing;return{height:l.sum(t)+(i-1)*o,width:l.sum(e)+(r-1)*s}},e.prototype._measure_cells=function(t){for(var e=this._state,n=e.items,i=e.nrows,o=e.ncols,s=e.rows,a=e.cols,l=e.rspacing,u=e.cspacing,d=new Array(i),p=0;p<i;p++){var f=s[p];d[p]="fixed"==f.policy?f.height:0}for(var m=new Array(o),v=0;v<o;v++){var g=a[v];m[v]="fixed"==g.policy?g.width:0}var y=new _;n.foreach(function(e,n){for(var i=e.r0,o=e.c0,_=e.r1,p=e.c1,f=(_-i)*l,v=(p-o)*u,g=0,b=i;b<=_;b++)g+=t(b,o).height;g+=f;for(var w=0,x=o;x<=p;x++)w+=t(i,x).width;w+=v;var A=n.measure({width:w,height:g});y.add(e,{layout:n,size_hint:A});var k=new r.Sizeable(A).grow_by(n.sizing.margin);k.height-=f,k.width-=v;for(var C=[],b=i;b<=_;b++){var T=s[b];"fixed"==T.policy?k.height-=T.height:C.push(b)}if(k.height>0)for(var S=h(k.height/C.length),M=0,E=C;M<E.length;M++){var b=E[M];d[b]=c(d[b],S)}for(var z=[],x=o;x<=p;x++){var O=a[x];"fixed"==O.policy?k.width-=O.width:z.push(x)}if(k.width>0)for(var P=h(k.width/z.length),j=0,N=z;j<N.length;j++){var x=N[j];m[x]=c(m[x],P)}});var b=this._measure_totals(d,m);return{size:b,row_heights:d,col_widths:m,size_hints:y}},e.prototype._measure_grid=function(t){var e,n=this._state,i=n.nrows,r=n.ncols,o=n.rows,s=n.cols,a=n.rspacing,l=n.cspacing,u=this._measure_cells(function(t,e){var n=o[t],i=s[e];return{width:"fixed"==i.policy?i.width:1/0,height:"fixed"==n.policy?n.height:1/0}});e="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:u.size.height;for(var _,d=0,p=0;p<i;p++){var f=o[p];"fit"==f.policy||"max"==f.policy?d+=f.flex:e-=u.row_heights[p]}if(e-=(i-1)*a,0!=d&&e>0)for(var p=0;p<i;p++){var f=o[p];if("fit"==f.policy||"max"==f.policy){var m=h(e*(f.flex/d));e-=m,u.row_heights[p]=m,d-=f.flex}}else if(e<0){for(var v=0,p=0;p<i;p++){var f=o[p];"fixed"!=f.policy&&v++}for(var g=-e,p=0;p<i;p++){var f=o[p];if("fixed"!=f.policy){var m=u.row_heights[p],y=h(g/v);u.row_heights[p]=c(m-y,0),g-=y>m?m:y,v--}}}_="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:u.size.width;for(var b=0,w=0;w<r;w++){var x=s[w];"fit"==x.policy||"max"==x.policy?b+=x.flex:_-=u.col_widths[w]}if(_-=(r-1)*l,0!=b&&_>0)for(var w=0;w<r;w++){var x=s[w];if("fit"==x.policy||"max"==x.policy){var A=h(_*(x.flex/b));_-=A,u.col_widths[w]=A,b-=x.flex}}else if(_<0){for(var v=0,w=0;w<r;w++){var x=s[w];"fixed"!=x.policy&&v++}for(var k=-_,w=0;w<r;w++){var x=s[w];if("fixed"!=x.policy){var A=u.col_widths[w],y=h(k/v);u.col_widths[w]=c(A-y,0),k-=y>A?A:y,v--}}}var C=this._measure_cells(function(t,e){return{width:u.col_widths[e],height:u.row_heights[t]}}),T=C.row_heights,S=C.col_widths,M=C.size_hints,E=this._measure_totals(T,S);return{size:E,row_heights:T,col_widths:S,size_hints:M}},e.prototype._measure=function(t){var e=this._measure_grid(t).size;return e},e.prototype._set_geometry=function(e,n){t.prototype._set_geometry.call(this,e,n);for(var r=this._state,o=r.nrows,s=r.ncols,l=r.rspacing,_=r.cspacing,d=this._measure_grid(e),p=d.row_heights,f=d.col_widths,m=d.size_hints,v=this._state.rows.map(function(t,e){return i.__assign({},t,{top:0,height:p[e],get bottom(){return this.top+this.height}})}),g=this._state.cols.map(function(t,e){return i.__assign({},t,{left:0,width:f[e],get right(){return this.left+this.width}})}),y=m.map(function(t,e){return i.__assign({},e,{outer:new a.BBox,inner:new a.BBox})}),b=0,w=this.absolute?e.top:0;b<o;b++){var x=v[b];x.top=w,w+=x.height+l}for(var A=0,k=this.absolute?e.left:0;A<s;A++){var C=g[A];C.left=k,k+=C.width+_}function T(t,e){for(var n=(e-t)*_,i=t;i<=e;i++)n+=g[i].width;return n}function S(t,e){for(var n=(e-t)*l,i=t;i<=e;i++)n+=v[i].height;return n}y.foreach(function(t,e){var n=t.r0,i=t.c0,r=t.r1,o=t.c1,s=e.layout,l=e.size_hint,c=s.sizing,u=l.width,_=l.height,d={width:T(i,o),height:S(n,r)},p=i==o&&"auto"!=g[i].align?g[i].align:c.halign,f=n==r&&"auto"!=v[n].align?v[n].align:c.valign,m=g[i].left;"start"==p?m+=c.margin.left:"center"==p?m+=h((d.width-u)/2):"end"==p&&(m+=d.width-c.margin.right-u);var y=v[n].top;"start"==f?y+=c.margin.top:"center"==f?y+=h((d.height-_)/2):"end"==f&&(y+=d.height-c.margin.bottom-_),e.outer=new a.BBox({left:m,top:y,width:u,height:_})});var M=v.map(function(){return{start:new u(function(){return 0}),end:new u(function(){return 0})}}),E=g.map(function(){return{start:new u(function(){return 0}),end:new u(function(){return 0})}});y.foreach(function(t,e){var n=t.r0,i=t.c0,r=t.r1,o=t.c1,s=e.size_hint,a=e.outer,l=s.inner;null!=l&&(M[n].start.apply(a.top,function(t){return c(t,l.top)}),M[r].end.apply(v[r].bottom-a.bottom,function(t){return c(t,l.bottom)}),E[i].start.apply(a.left,function(t){return c(t,l.left)}),E[o].end.apply(g[o].right-a.right,function(t){return c(t,l.right)}))}),y.foreach(function(t,e){var n=t.r0,i=t.c0,r=t.r1,o=t.c1,s=e.size_hint,l=e.outer;function c(t){var e=t.left,n=t.right,i=t.top,r=t.bottom,o=l.width-e-n,s=l.height-i-r;return new a.BBox({left:e,top:i,width:o,height:s})}if(null!=s.inner){var h=c(s.inner);if(!1!==s.align){var u=M[n].start.get(l.top),_=M[r].end.get(v[r].bottom-l.bottom),d=E[i].start.get(l.left),p=E[o].end.get(g[o].right-l.right);try{h=c({top:u,bottom:_,left:d,right:p})}catch(t){}}e.inner=h}else e.inner=l}),y.foreach(function(t,e){var n=e.layout,i=e.outer,r=e.inner;n.set_geometry(i,r)})},e.__name__="Grid",e}(o.Layoutable);n.Grid=d;var p=function(t){function e(e){var n=t.call(this)||this;return n.items=e.map(function(t,e){return{layout:t,row:0,col:e}}),n.rows="fit",n}return i.__extends(e,t),e.__name__="Row",e}(d);n.Row=p;var f=function(t){function e(e){var n=t.call(this)||this;return n.items=e.map(function(t,e){return{layout:t,row:e,col:0}}),n.cols="fit",n}return i.__extends(e,t),e.__name__="Column",e}(d);n.Column=f},function(t,e,n){var i=t(421),r=t(14),o=t(16),s=t(5),a=function(t){function e(e){var n=t.call(this)||this;return n.content_size=s.unsized(e,function(){return new o.Sizeable(s.size(e))}),n}return i.__extends(e,t),e.prototype._content_size=function(){return this.content_size},e.__name__="ContentBox",e}(r.ContentLayoutable);n.ContentBox=a;var l=function(t){function e(e){var n=t.call(this)||this;return n.el=e,n}return i.__extends(e,t),e.prototype._measure=function(t){var e=this,n=new o.Sizeable(t).bounded_to(this.sizing.size);return s.sized(this.el,n,function(){var t=new o.Sizeable(s.content_size(e.el)),n=s.extents(e.el),i=n.border,r=n.padding;return t.grow_by(i).grow_by(r).map(Math.ceil)})},e.__name__="VariadicBox",e}(r.Layoutable);n.VariadicBox=l},function(t,e,n){var i=t(16);n.Sizeable=i.Sizeable;var r=t(14);n.Layoutable=r.Layoutable,n.LayoutItem=r.LayoutItem;var o=t(10);n.HStack=o.HStack,n.VStack=o.VStack,n.AnchorLayout=o.AnchorLayout;var s=t(11);n.Grid=s.Grid,n.Row=s.Row,n.Column=s.Column;var a=t(12);n.ContentBox=a.ContentBox,n.VariadicBox=a.VariadicBox},function(t,e,n){var i=t(421),r=t(16),o=t(27),s=Math.min,a=Math.max,l=Math.round,c=function(){function t(){this._bbox=new o.BBox,this._inner_bbox=new o.BBox;var t=this;this._top={get value(){return t.bbox.top}},this._left={get value(){return t.bbox.left}},this._width={get value(){return t.bbox.width}},this._height={get value(){return t.bbox.height}},this._right={get value(){return t.bbox.right}},this._bottom={get value(){return t.bbox.bottom}},this._hcenter={get value(){return t.bbox.hcenter}},this._vcenter={get value(){return t.bbox.vcenter}}}return Object.defineProperty(t.prototype,"bbox",{get:function(){return this._bbox},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"inner_bbox",{get:function(){return this._inner_bbox},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"sizing",{get:function(){return this._sizing},enumerable:!0,configurable:!0}),t.prototype.set_sizing=function(t){var e=t.width_policy||"fit",n=t.width,i=null!=t.min_width?t.min_width:0,r=null!=t.max_width?t.max_width:1/0,o=t.height_policy||"fit",s=t.height,a=null!=t.min_height?t.min_height:0,l=null!=t.max_height?t.max_height:1/0,c=t.aspect,h=t.margin||{top:0,right:0,bottom:0,left:0},u=!1!==t.visible,_=t.halign||"start",d=t.valign||"start";this._sizing={width_policy:e,min_width:i,width:n,max_width:r,height_policy:o,min_height:a,height:s,max_height:l,aspect:c,margin:h,visible:u,halign:_,valign:d,size:{width:n,height:s},min_size:{width:i,height:a},max_size:{width:r,height:l}},this._init()},t.prototype._init=function(){},t.prototype._set_geometry=function(t,e){this._bbox=t,this._inner_bbox=e},t.prototype.set_geometry=function(t,e){this._set_geometry(t,e||t)},t.prototype.is_width_expanding=function(){return"max"==this.sizing.width_policy},t.prototype.is_height_expanding=function(){return"max"==this.sizing.height_policy},t.prototype.apply_aspect=function(t,e){var n=e.width,i=e.height,r=this.sizing.aspect;if(null!=r){var o=this.sizing,s=o.width_policy,a=o.height_policy;if("fixed"!=s&&"fixed"!=a)if(s==a){var c=n,h=l(n/r),u=l(i*r),_=i,d=Math.abs(t.width-c)+Math.abs(t.height-h),p=Math.abs(t.width-u)+Math.abs(t.height-_);d<=p?(n=c,i=h):(n=u,i=_)}else!function(t,e){var n={max:4,fit:3,min:2,fixed:1};return n[t]>n[e]}(s,a)?n=l(i*r):i=l(n/r);else"fixed"==s?i=l(n/r):"fixed"==a&&(n=l(i*r))}return{width:n,height:i}},t.prototype.measure=function(t){var e=this;if(!this.sizing.visible)return{width:0,height:0};var n=function(t){return"fixed"==e.sizing.width_policy&&null!=e.sizing.width?e.sizing.width:t},o=function(t){return"fixed"==e.sizing.height_policy&&null!=e.sizing.height?e.sizing.height:t},s=new r.Sizeable(t).shrink_by(this.sizing.margin).map(n,o),a=this._measure(s),l=this.clip_size(a),c=n(l.width),h=o(l.height),u=this.apply_aspect(s,{width:c,height:h});return i.__assign({},a,u)},t.prototype.compute=function(t){void 0===t&&(t={});var e=this.measure({width:null!=t.width&&this.is_width_expanding()?t.width:1/0,height:null!=t.height&&this.is_height_expanding()?t.height:1/0}),n=e.width,i=e.height,r=new o.BBox({left:0,top:0,width:n,height:i}),s=void 0;if(null!=e.inner){var a=e.inner,l=a.left,c=a.top,h=a.right,u=a.bottom;s=new o.BBox({left:l,top:c,right:n-h,bottom:i-u})}this.set_geometry(r,s)},Object.defineProperty(t.prototype,"xview",{get:function(){return this.bbox.xview},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){return this.bbox.yview},enumerable:!0,configurable:!0}),t.prototype.clip_width=function(t){return a(this.sizing.min_width,s(t,this.sizing.max_width))},t.prototype.clip_height=function(t){return a(this.sizing.min_height,s(t,this.sizing.max_height))},t.prototype.clip_size=function(t){var e=t.width,n=t.height;return{width:this.clip_width(e),height:this.clip_height(n)}},t.__name__="Layoutable",t}();n.Layoutable=c;var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._measure=function(t){var e,n,i=this.sizing,r=i.width_policy,o=i.height_policy;if(t.width==1/0)e=null!=this.sizing.width?this.sizing.width:0;else if("fixed"==r)e=null!=this.sizing.width?this.sizing.width:0;else if("min"==r)e=null!=this.sizing.width?s(t.width,this.sizing.width):0;else if("fit"==r)e=null!=this.sizing.width?s(t.width,this.sizing.width):t.width;else{if("max"!=r)throw new Error("unrechable");e=null!=this.sizing.width?a(t.width,this.sizing.width):t.width}if(t.height==1/0)n=null!=this.sizing.height?this.sizing.height:0;else if("fixed"==o)n=null!=this.sizing.height?this.sizing.height:0;else if("min"==o)n=null!=this.sizing.height?s(t.height,this.sizing.height):0;else if("fit"==o)n=null!=this.sizing.height?s(t.height,this.sizing.height):t.height;else{if("max"!=o)throw new Error("unrechable");n=null!=this.sizing.height?a(t.height,this.sizing.height):t.height}return{width:e,height:n}},e.__name__="LayoutItem",e}(c);n.LayoutItem=h;var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._measure=function(t){var e=this,n=this._content_size(),i=t.bounded_to(this.sizing.size).bounded_to(n),r=function(){switch(e.sizing.width_policy){case"fixed":return null!=e.sizing.width?e.sizing.width:n.width;case"min":return n.width;case"fit":return i.width;case"max":return Math.max(n.width,i.width);default:throw new Error("unexpected")}}(),o=function(){switch(e.sizing.height_policy){case"fixed":return null!=e.sizing.height?e.sizing.height:n.height;case"min":return n.height;case"fit":return i.height;case"max":return Math.max(n.height,i.height);default:throw new Error("unexpected")}}();return{width:r,height:o}},e.__name__="ContentLayoutable",e}(c);n.ContentLayoutable=u},function(t,e,n){var i=t(421),r=t(16),o=t(14),s=t(46),a=Math.PI/2,l="left",c="center",h={above:{parallel:0,normal:-a,horizontal:0,vertical:-a},below:{parallel:0,normal:a,horizontal:0,vertical:a},left:{parallel:-a,normal:0,horizontal:0,vertical:-a},right:{parallel:a,normal:0,horizontal:0,vertical:a}},u={above:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"alphabetic",vertical:"middle"},below:{justified:"bottom",parallel:"hanging",normal:"middle",horizontal:"hanging",vertical:"middle"},left:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"},right:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"}},_={above:{justified:c,parallel:c,normal:l,horizontal:c,vertical:l},below:{justified:c,parallel:c,normal:l,horizontal:c,vertical:l},left:{justified:c,parallel:c,normal:"right",horizontal:"right",vertical:c},right:{justified:c,parallel:c,normal:l,horizontal:l,vertical:c}},d={above:"right",below:l,left:"right",right:l},p={above:l,below:"right",left:"right",right:l},f=function(t){function e(e,n){var i=t.call(this)||this;switch(i.side=e,i.obj=n,i.side){case"above":i._dim=0,i._normals=[0,-1];break;case"below":i._dim=0,i._normals=[0,1];break;case"left":i._dim=1,i._normals=[-1,0];break;case"right":i._dim=1,i._normals=[1,0];break;default:throw new Error("unreachable")}return i.is_horizontal?i.set_sizing({width_policy:"max",height_policy:"fixed"}):i.set_sizing({width_policy:"fixed",height_policy:"max"}),i}return i.__extends(e,t),e.prototype._content_size=function(){return new r.Sizeable(this.get_oriented_size())},e.prototype.get_oriented_size=function(){var t=this.obj.get_size(),e=t.width,n=t.height;return!this.obj.rotate||this.is_horizontal?{width:e,height:n}:{width:n,height:e}},e.prototype.has_size_changed=function(){var t=this.get_oriented_size(),e=t.width,n=t.height;return this.is_horizontal?this.bbox.height!=n:this.bbox.width!=e},Object.defineProperty(e.prototype,"dimension",{get:function(){return this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"normals",{get:function(){return this._normals},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_horizontal",{get:function(){return 0==this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_vertical",{get:function(){return 1==this._dim},enumerable:!0,configurable:!0}),e.prototype.apply_label_text_heuristics=function(t,e){var n,i,r=this.side;s.isString(e)?(n=u[r][e],i=_[r][e]):0===e?(n="whatever",i="whatever"):e<0?(n="middle",i=d[r]):(n="middle",i=p[r]),t.textBaseline=n,t.textAlign=i},e.prototype.get_label_angle_heuristic=function(t){return h[this.side][t]},e.__name__="SidePanel",e}(o.ContentLayoutable);n.SidePanel=f},function(t,e,n){var i=Math.min,r=Math.max,o=function(){function t(t){void 0===t&&(t={}),this.width=null!=t.width?t.width:0,this.height=null!=t.height?t.height:0}return t.prototype.bounded_to=function(e){var n=e.width,i=e.height;return new t({width:this.width==1/0&&null!=n?n:this.width,height:this.height==1/0&&null!=i?i:this.height})},t.prototype.expanded_to=function(e){var n=e.width,i=e.height;return new t({width:n!=1/0?r(this.width,n):this.width,height:i!=1/0?r(this.height,i):this.height})},t.prototype.expand_to=function(t){var e=t.width,n=t.height;this.width=r(this.width,e),this.height=r(this.height,n)},t.prototype.narrowed_to=function(e){var n=e.width,r=e.height;return new t({width:i(this.width,n),height:i(this.height,r)})},t.prototype.narrow_to=function(t){var e=t.width,n=t.height;this.width=i(this.width,e),this.height=i(this.height,n)},t.prototype.grow_by=function(e){var n=e.left,i=e.right,r=e.top,o=e.bottom,s=this.width+n+i,a=this.height+r+o;return new t({width:s,height:a})},t.prototype.shrink_by=function(e){var n=e.left,i=e.right,o=e.top,s=e.bottom,a=r(this.width-n-i,0),l=r(this.height-o-s,0);return new t({width:a,height:l})},t.prototype.map=function(e,n){return new t({width:e(this.width),height:(null!=n?n:e)(this.height)})},t.__name__="Sizeable",t}();n.Sizeable=o},function(t,e,n){var i=t(46),r={},o=function(){function t(t,e){this.name=t,this.level=e}return t.__name__="LogLevel",t}();n.LogLevel=o;var s=function(){function t(e,n){void 0===n&&(n=t.INFO),this._name=e,this.set_level(n)}return Object.defineProperty(t,"levels",{get:function(){return Object.keys(t.log_levels)},enumerable:!0,configurable:!0}),t.get=function(e,n){if(void 0===n&&(n=t.INFO),e.length>0){var i=r[e];return null==i&&(r[e]=i=new t(e,n)),i}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")},Object.defineProperty(t.prototype,"level",{get:function(){return this.get_level()},enumerable:!0,configurable:!0}),t.prototype.get_level=function(){return this._log_level},t.prototype.set_level=function(e){if(e instanceof o)this._log_level=e;else{if(!i.isString(e)||null==t.log_levels[e])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=t.log_levels[e]}var n="["+this._name+"]";for(var r in t.log_levels){var s=t.log_levels[r];s.level<this._log_level.level||this._log_level.level===t.OFF.level?this[r]=function(){}:this[r]=a(r,n)}},t.prototype.trace=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.prototype.debug=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.prototype.info=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.prototype.warn=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.prototype.error=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.__name__="Logger",t.TRACE=new o("trace",0),t.DEBUG=new o("debug",1),t.INFO=new o("info",2),t.WARN=new o("warn",6),t.ERROR=new o("error",7),t.FATAL=new o("fatal",8),t.OFF=new o("off",9),t.log_levels={trace:t.TRACE,debug:t.DEBUG,info:t.INFO,warn:t.WARN,error:t.ERROR,fatal:t.FATAL,off:t.OFF},t}();function a(t,e){return null!=console[t]?console[t].bind(console,e):null!=console.log?console.log.bind(console,e):function(){}}n.Logger=s,n.logger=s.get("bokeh"),n.set_log_level=function(t){null==s.log_levels[t]?(console.log("[bokeh] unrecognized logging level '"+t+"' passed to Bokeh.set_log_level(), ignoring"),console.log("[bokeh] valid log levels are: "+s.levels.join(", "))):(console.log("[bokeh] setting log level to: '"+t+"'"),n.logger.set_level(t))}},function(t,e,n){var i=t(421),r=t(22),o=t(7),s=t(24),a=t(25),l=t(30),c=t(46);function h(t){try{return JSON.stringify(t)}catch(e){return t.toString()}}function u(t){return c.isPlainObject(t)&&(void 0===t.value?0:1)+(void 0===t.field?0:1)+(void 0===t.expr?0:1)==1}r.Signal,n.isSpec=u;var _=function(t){function e(e,n,i){var o=t.call(this)||this;return o.obj=e,o.attr=n,o.default_value=i,o.optional=!1,o.change=new r.Signal0(o.obj,"change"),o._init(),o.connect(o.change,function(){return o._init()}),o}return i.__extends(e,t),e.prototype.update=function(){this._init()},e.prototype.init=function(){},e.prototype.transform=function(t){return t},e.prototype.validate=function(t){if(!this.valid(t))throw new Error(this.obj.type+"."+this.attr+" given invalid value: "+h(t))},e.prototype.valid=function(t){return!0},e.prototype.value=function(t){if(void 0===t&&(t=!0),void 0===this.spec.value)throw new Error("attempted to retrieve property value for property without value specification");var e=this.transform([this.spec.value])[0];return null!=this.spec.transform&&t&&(e=this.spec.transform.compute(e)),e},e.prototype._init=function(){var t,e=this.obj,n=this.attr,i=e.getv(n);if(void 0===i){var r=this.default_value;i=void 0!==r?r(e):null,e.setv(((t={})[n]=i,t),{silent:!0,defaults:!0})}c.isArray(i)?this.spec={value:i}:u(i)?this.spec=i:this.spec={value:i},null!=this.spec.value&&this.validate(this.spec.value),this.init()},e.prototype.toString=function(){return"Prop("+this.obj+"."+this.attr+", spec: "+h(this.spec)+")"},e.__name__="Property",e}(r.Signalable());n.Property=_;var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="Any",e}(_);n.Any=d;var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.valid=function(t){return c.isArray(t)||t instanceof Float64Array},e.__name__="Array",e}(_);n.Array=p;var f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.valid=function(t){return c.isBoolean(t)},e.__name__="Boolean",e}(_);n.Boolean=f;var m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.valid=function(t){return c.isString(t)&&l.is_color(t)},e.__name__="Color",e}(_);n.Color=m;var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="Instance",e}(_);n.Instance=v;var g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.valid=function(t){return c.isNumber(t)},e.__name__="Number",e}(_);n.Number=g;var y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.valid=function(t){return c.isNumber(t)&&(0|t)==t},e.__name__="Int",e}(g);n.Int=y;var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="Angle",e}(g);n.Angle=b;var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.valid=function(t){return c.isNumber(t)&&0<=t&&t<=1},e.__name__="Percent",e}(g);n.Percent=w;var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.valid=function(t){return c.isString(t)},e.__name__="String",e}(_);n.String=x;var A=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="FontSize",e}(x);n.FontSize=A;var k=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="Font",e}(x);n.Font=k;var C=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.valid=function(t){return c.isString(t)&&s.includes(this.enum_values,t)},e.__name__="EnumProperty",e}(_);function T(t){return function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(n,e),Object.defineProperty(n.prototype,"enum_values",{get:function(){return t},enumerable:!0,configurable:!0}),n}(C)}n.EnumProperty=C,n.Enum=T;var S=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"enum_values",{get:function(){return o.Direction},enumerable:!0,configurable:!0}),e.prototype.transform=function(t){for(var e=new Uint8Array(t.length),n=0;n<t.length;n++)switch(t[n]){case"clock":e[n]=0;break;case"anticlock":e[n]=1}return e},e.__name__="Direction",e}(C);n.Direction=S,n.Anchor=T(o.Anchor),n.AngleUnits=T(o.AngleUnits),n.BoxOrigin=T(o.BoxOrigin),n.ButtonType=T(o.ButtonType),n.Dimension=T(o.Dimension),n.Dimensions=T(o.Dimensions),n.Distribution=T(o.Distribution),n.FontStyle=T(o.FontStyle),n.HatchPatternType=T(o.HatchPatternType),n.HTTPMethod=T(o.HTTPMethod),n.HexTileOrientation=T(o.HexTileOrientation),n.HoverMode=T(o.HoverMode),n.LatLon=T(o.LatLon),n.LegendClickPolicy=T(o.LegendClickPolicy),n.LegendLocation=T(o.LegendLocation),n.LineCap=T(o.LineCap),n.LineJoin=T(o.LineJoin),n.LinePolicy=T(o.LinePolicy),n.Location=T(o.Location),n.Logo=T(o.Logo),n.MarkerType=T(o.MarkerType),n.Orientation=T(o.Orientation),n.OutputBackend=T(o.OutputBackend),n.PaddingUnits=T(o.PaddingUnits),n.Place=T(o.Place),n.PointPolicy=T(o.PointPolicy),n.RadiusDimension=T(o.RadiusDimension),n.RenderLevel=T(o.RenderLevel),n.RenderMode=T(o.RenderMode),n.ResetPolicy=T(o.ResetPolicy),n.RoundingFunction=T(o.RoundingFunction),n.Side=T(o.Side),n.SizingMode=T(o.SizingMode),n.SliderCallbackPolicy=T(o.SliderCallbackPolicy),n.Sort=T(o.Sort),n.SpatialUnits=T(o.SpatialUnits),n.StartEnd=T(o.StartEnd),n.StepMode=T(o.StepMode),n.TapBehavior=T(o.TapBehavior),n.TextAlign=T(o.TextAlign),n.TextBaseline=T(o.TextBaseline),n.TextureRepetition=T(o.TextureRepetition),n.TickLabelOrientation=T(o.TickLabelOrientation),n.TooltipAttachment=T(o.TooltipAttachment),n.UpdateMode=T(o.UpdateMode),n.VerticalAlign=T(o.VerticalAlign);var M=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="ScalarSpec",e}(_);n.ScalarSpec=M;var E=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.array=function(t){var e;if(null!=this.spec.field){if(null==(e=this.transform(t.get_column(this.spec.field))))throw new Error("attempted to retrieve property array for nonexistent field '"+this.spec.field+"'")}else if(null!=this.spec.expr)e=this.transform(this.spec.expr.v_compute(t));else{var n=t.get_length();null==n&&(n=1);var i=this.value(!1);e=s.repeat(i,n)}return null!=this.spec.transform&&(e=this.spec.transform.v_compute(e)),e},e.__name__="VectorSpec",e}(_);n.VectorSpec=E;var z=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="DataSpec",e}(E);n.DataSpec=z;var O=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.init=function(){null==this.spec.units&&(this.spec.units=this.default_units);var t=this.spec.units;if(!s.includes(this.valid_units,t))throw new Error("units must be one of "+this.valid_units.join(", ")+"; got: "+t)},Object.defineProperty(e.prototype,"units",{get:function(){return this.spec.units},set:function(t){this.spec.units=t},enumerable:!0,configurable:!0}),e.__name__="UnitsSpec",e}(E);n.UnitsSpec=O;var P=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"default_units",{get:function(){return"rad"},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"valid_units",{get:function(){return o.AngleUnits},enumerable:!0,configurable:!0}),e.prototype.transform=function(e){return"deg"==this.spec.units&&(e=a.map(e,function(t){return t*Math.PI/180})),e=a.map(e,function(t){return-t}),t.prototype.transform.call(this,e)},e.__name__="AngleSpec",e}(O);n.AngleSpec=P;var j=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="BooleanSpec",e}(z);n.BooleanSpec=j;var N=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="ColorSpec",e}(z);n.ColorSpec=N;var I=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="CoordinateSpec",e}(z);n.CoordinateSpec=I;var B=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="CoordinateSeqSpec",e}(z);n.CoordinateSeqSpec=B;var R=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"default_units",{get:function(){return"data"},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"valid_units",{get:function(){return o.SpatialUnits},enumerable:!0,configurable:!0}),e.__name__="DistanceSpec",e}(O);n.DistanceSpec=R;var D=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="FontSizeSpec",e}(z);n.FontSizeSpec=D;var F=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="MarkerSpec",e}(z);n.MarkerSpec=F;var V=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="NumberSpec",e}(z);n.NumberSpec=V;var L=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="StringSpec",e}(z);n.StringSpec=L;var U=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="NullStringSpec",e}(z);n.NullStringSpec=U},function(t,e,n){var i=t(18),r=t(35);function o(t,e){var n={};for(var i in t){var r=t[i];n[e+i]=r}return n}var s={line_color:[i.ColorSpec,"black"],line_width:[i.NumberSpec,1],line_alpha:[i.NumberSpec,1],line_join:[i.LineJoin,"bevel"],line_cap:[i.LineCap,"butt"],line_dash:[i.Array,[]],line_dash_offset:[i.Number,0]};n.line=function(t){return void 0===t&&(t=""),o(s,t)};var a={fill_color:[i.ColorSpec,"gray"],fill_alpha:[i.NumberSpec,1]};n.fill=function(t){return void 0===t&&(t=""),o(a,t)};var l={hatch_color:[i.ColorSpec,"black"],hatch_alpha:[i.NumberSpec,1],hatch_scale:[i.NumberSpec,12],hatch_pattern:[i.StringSpec,null],hatch_weight:[i.NumberSpec,1],hatch_extra:[i.Any,{}]};n.hatch=function(t){return void 0===t&&(t=""),o(l,t)};var c={text_font:[i.Font,"helvetica"],text_font_size:[i.FontSizeSpec,"12pt"],text_font_style:[i.FontStyle,"normal"],text_color:[i.ColorSpec,"#444444"],text_alpha:[i.NumberSpec,1],text_align:[i.TextAlign,"left"],text_baseline:[i.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]};n.text=function(t){return void 0===t&&(t=""),o(c,t)},n.create=function(t){for(var e={},i=0,o=t;i<o.length;i++){var s=o[i],a=s.split(":"),l=a[0],c=a[1],h=void 0;switch(l){case"line":h=n.line;break;case"fill":h=n.fill;break;case"hatch":h=n.hatch;break;case"text":h=n.text;break;default:throw new Error("Unknown property mixin kind '"+l+"'")}r.extend(e,h(c))}return e}},function(t,e,n){var i=t(421),r=t(8),o=t(209),s=t(197),a=t(198),l=t(18),c=function(t){function e(e){var n=t.call(this,e)||this;return n.inspectors={},n}return i.__extends(e,t),e.initClass=function(){this.internal({source:[l.Any]})},e.prototype.select=function(t,e,n,i){void 0===i&&(i=!1);for(var r=[],o=[],l=0,c=t;l<c.length;l++){var h=c[l];h instanceof s.GlyphRendererView?r.push(h):h instanceof a.GraphRendererView&&o.push(h)}for(var u=!1,_=0,d=o;_<d.length;_++){var h=d[_],p=h.model.selection_policy.hit_test(e,h);u=u||h.model.selection_policy.do_selection(p,h.model,n,i)}if(r.length>0){var p=this.source.selection_policy.hit_test(e,r);u=u||this.source.selection_policy.do_selection(p,this.source,n,i)}return u},e.prototype.inspect=function(t,e){var n=!1;if(t instanceof s.GlyphRendererView){var i=t.hit_test(e);if(null!=i){n=!i.is_empty();var r=this.get_or_create_inspector(t.model);r.update(i,!0,!1),this.source.setv({inspected:r},{silent:!0}),this.source.inspect.emit([t,{geometry:e}])}}else if(t instanceof a.GraphRendererView){var i=t.model.inspection_policy.hit_test(e,t);n=n||t.model.inspection_policy.do_inspection(i,e,t,!1,!1)}return n},e.prototype.clear=function(t){this.source.selected.clear(),null!=t&&this.get_or_create_inspector(t.model).clear()},e.prototype.get_or_create_inspector=function(t){return null==this.inspectors[t.id]&&(this.inspectors[t.id]=new o.Selection),this.inspectors[t.id]},e.__name__="SelectionManager",e}(r.HasProps);n.SelectionManager=c,c.initClass()},function(t,e,n){var i=function(){function t(){this._dev=!1}return Object.defineProperty(t.prototype,"dev",{get:function(){return this._dev},set:function(t){this._dev=t},enumerable:!0,configurable:!0}),t.__name__="Settings",t}();n.Settings=i,n.settings=new i},function(t,e,n){var i=t(421),r=t(32),o=t(28),s=t(24),a=function(){function t(t,e){this.sender=t,this.name=e}return t.prototype.connect=function(t,e){void 0===e&&(e=null),c.has(this.sender)||c.set(this.sender,[]);var n=c.get(this.sender);if(null!=u(n,this,t,e))return!1;var i=e||t;h.has(i)||h.set(i,[]);var r=h.get(i),o={signal:this,slot:t,context:e};return n.push(o),r.push(o),!0},t.prototype.disconnect=function(t,e){void 0===e&&(e=null);var n=c.get(this.sender);if(null==n||0===n.length)return!1;var i=u(n,this,t,e);if(null==i)return!1;var r=e||t,o=h.get(r);return i.signal=null,d(n),d(o),!0},t.prototype.emit=function(t){for(var e=c.get(this.sender)||[],n=0,i=e;n<i.length;n++){var r=i[n],o=r.signal,s=r.slot,a=r.context;o===this&&s.call(a,t,this.sender)}},t.__name__="Signal",t}();n.Signal=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.emit=function(){t.prototype.emit.call(this,void 0)},e.__name__="Signal0",e}(a);n.Signal0=l,function(t){t.disconnectBetween=function(t,e){var n=c.get(t);if(null!=n&&0!==n.length){var i=h.get(e);if(null!=i&&0!==i.length){for(var r=0,o=i;r<o.length;r++){var s=o[r];if(null==s.signal)return;s.signal.sender===t&&(s.signal=null)}d(n),d(i)}}},t.disconnectSender=function(t){var e=c.get(t);if(null!=e&&0!==e.length){for(var n=0,i=e;n<i.length;n++){var r=i[n];if(null==r.signal)return;var o=r.context||r.slot;r.signal=null,d(h.get(o))}d(e)}},t.disconnectReceiver=function(t){var e=h.get(t);if(null!=e&&0!==e.length){for(var n=0,i=e;n<i.length;n++){var r=i[n];if(null==r.signal)return;var o=r.signal.sender;r.signal=null,d(c.get(o))}d(e)}},t.disconnectAll=function(t){var e=c.get(t);if(null!=e&&0!==e.length){for(var n=0,i=e;n<i.length;n++){var r=i[n];r.signal=null}d(e)}var o=h.get(t);if(null!=o&&0!==o.length){for(var s=0,a=o;s<a.length;s++){var r=a[s];r.signal=null}d(o)}}}(a=n.Signal||(n.Signal={})),n.Signal=a,n.Signalable=function(t){return null!=t?function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect=function(t,e){return t.connect(e,this)},e.prototype.disconnect=function(t,e){return t.disconnect(e,this)},e}(t):function(){function t(){}return t.prototype.connect=function(t,e){return t.connect(e,this)},t.prototype.disconnect=function(t,e){return t.disconnect(e,this)},t}()},function(t){t.connect=function(t,e){return t.connect(e,this)},t.disconnect=function(t,e){return t.disconnect(e,this)}}(n._Signalable||(n._Signalable={}));var c=new WeakMap,h=new WeakMap;function u(t,e,n,i){return s.find(t,function(t){return t.signal===e&&t.slot===n&&t.context===i})}var _=new r.Set;function d(t){0===_.size&&o.defer(p),_.add(t)}function p(){_.forEach(function(t){s.remove_by(t,function(t){return null==t.signal})}),_.clear()}},function(t,e,n){var i=t(421),r=t(390),o=t(22),s=t(17),a=t(5),l=t(47),c=t(24),h=t(35),u=t(46),_=t(31),d=t(3),p=function(){function t(t,e,n){var i=this;this.plot_view=t,this.toolbar=e,this.hit_area=n,this.pan_start=new o.Signal(this,"pan:start"),this.pan=new o.Signal(this,"pan"),this.pan_end=new o.Signal(this,"pan:end"),this.pinch_start=new o.Signal(this,"pinch:start"),this.pinch=new o.Signal(this,"pinch"),this.pinch_end=new o.Signal(this,"pinch:end"),this.rotate_start=new o.Signal(this,"rotate:start"),this.rotate=new o.Signal(this,"rotate"),this.rotate_end=new o.Signal(this,"rotate:end"),this.tap=new o.Signal(this,"tap"),this.doubletap=new o.Signal(this,"doubletap"),this.press=new o.Signal(this,"press"),this.move_enter=new o.Signal(this,"move:enter"),this.move=new o.Signal(this,"move"),this.move_exit=new o.Signal(this,"move:exit"),this.scroll=new o.Signal(this,"scroll"),this.keydown=new o.Signal(this,"keydown"),this.keyup=new o.Signal(this,"keyup"),this.hammer=new r(this.hit_area,{touchAction:"auto"}),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",function(t){return i._mouse_move(t)}),this.hit_area.addEventListener("mouseenter",function(t){return i._mouse_enter(t)}),this.hit_area.addEventListener("mouseleave",function(t){return i._mouse_exit(t)}),this.hit_area.addEventListener("wheel",function(t){return i._mouse_wheel(t)}),document.addEventListener("keydown",this),document.addEventListener("keyup",this)}return t.prototype.destroy=function(){this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)},t.prototype.handleEvent=function(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)},t.prototype._configure_hammerjs=function(){var t=this;this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",function(e){return t._doubletap(e)}),this.hammer.on("tap",function(e){return t._tap(e)}),this.hammer.on("press",function(e){return t._press(e)}),this.hammer.get("pan").set({direction:r.DIRECTION_ALL}),this.hammer.on("panstart",function(e){return t._pan_start(e)}),this.hammer.on("pan",function(e){return t._pan(e)}),this.hammer.on("panend",function(e){return t._pan_end(e)}),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",function(e){return t._pinch_start(e)}),this.hammer.on("pinch",function(e){return t._pinch(e)}),this.hammer.on("pinchend",function(e){return t._pinch_end(e)}),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",function(e){return t._rotate_start(e)}),this.hammer.on("rotate",function(e){return t._rotate(e)}),this.hammer.on("rotateend",function(e){return t._rotate_end(e)})},t.prototype.register_tool=function(t){var e=this,n=t.model.event_type;null!=n&&(u.isString(n)?this._register_tool(t,n):n.forEach(function(n,i){return e._register_tool(t,n,i<1)}))},t.prototype._register_tool=function(t,e,n){void 0===n&&(n=!0);var i=t,r=i.model.id,o=function(t){return function(e){e.id==r&&t(e.e)}},a=function(t){return function(e){t(e.e)}};switch(e){case"pan":null!=i._pan_start&&i.connect(this.pan_start,o(i._pan_start.bind(i))),null!=i._pan&&i.connect(this.pan,o(i._pan.bind(i))),null!=i._pan_end&&i.connect(this.pan_end,o(i._pan_end.bind(i)));break;case"pinch":null!=i._pinch_start&&i.connect(this.pinch_start,o(i._pinch_start.bind(i))),null!=i._pinch&&i.connect(this.pinch,o(i._pinch.bind(i))),null!=i._pinch_end&&i.connect(this.pinch_end,o(i._pinch_end.bind(i)));break;case"rotate":null!=i._rotate_start&&i.connect(this.rotate_start,o(i._rotate_start.bind(i))),null!=i._rotate&&i.connect(this.rotate,o(i._rotate.bind(i))),null!=i._rotate_end&&i.connect(this.rotate_end,o(i._rotate_end.bind(i)));break;case"move":null!=i._move_enter&&i.connect(this.move_enter,o(i._move_enter.bind(i))),null!=i._move&&i.connect(this.move,o(i._move.bind(i))),null!=i._move_exit&&i.connect(this.move_exit,o(i._move_exit.bind(i)));break;case"tap":null!=i._tap&&i.connect(this.tap,o(i._tap.bind(i)));break;case"press":null!=i._press&&i.connect(this.press,o(i._press.bind(i)));break;case"scroll":null!=i._scroll&&i.connect(this.scroll,o(i._scroll.bind(i)));break;default:throw new Error("unsupported event_type: "+e)}n&&(null!=i._doubletap&&i.connect(this.doubletap,a(i._doubletap.bind(i))),null!=i._keydown&&i.connect(this.keydown,a(i._keydown.bind(i))),null!=i._keyup&&i.connect(this.keyup,a(i._keyup.bind(i))),_.is_mobile&&null!=i._scroll&&"pinch"==e&&(s.logger.debug("Registering scroll on touch screen"),i.connect(this.scroll,o(i._scroll.bind(i)))))},t.prototype._hit_test_renderers=function(t,e){for(var n=this.plot_view.get_renderer_views(),i=0,r=c.reversed(n);i<r.length;i++){var o=r[i],s=o.model.level;if(("annotation"==s||"overlay"==s)&&null!=o.interactive_hit&&o.interactive_hit(t,e))return o}return null},t.prototype._hit_test_frame=function(t,e){return this.plot_view.frame.bbox.contains(t,e)},t.prototype._hit_test_canvas=function(t,e){return this.plot_view.layout.bbox.contains(t,e)},t.prototype._trigger=function(t,e,n){var i=this,r=this.toolbar.gestures,o=t.name,s=o.split(":")[0],a=this._hit_test_renderers(e.sx,e.sy),l=this._hit_test_canvas(e.sx,e.sy);switch(s){case"move":var c=r[s].active;null!=c&&this.trigger(t,e,c.id);var u=this.toolbar.inspectors.filter(function(t){return t.active}),d="default";null!=a?(d=a.cursor(e.sx,e.sy)||d,h.isEmpty(u)||(t=this.move_exit,o=t.name)):this._hit_test_frame(e.sx,e.sy)&&(h.isEmpty(u)||(d="crosshair")),this.plot_view.set_cursor(d),this.plot_view.set_toolbar_visibility(l),u.map(function(n){return i.trigger(t,e,n.id)});break;case"tap":var p=n.target;if(null!=p&&p!=this.hit_area)return;null!=a&&null!=a.on_hit&&a.on_hit(e.sx,e.sy);var c=r[s].active;null!=c&&this.trigger(t,e,c.id);break;case"scroll":var f=_.is_mobile?"pinch":"scroll",c=r[f].active;null!=c&&(n.preventDefault(),n.stopPropagation(),this.trigger(t,e,c.id));break;case"pan":var c=r[s].active;null!=c&&(n.preventDefault(),this.trigger(t,e,c.id));break;default:var c=r[s].active;null!=c&&this.trigger(t,e,c.id)}this._trigger_bokeh_event(e)},t.prototype.trigger=function(t,e,n){void 0===n&&(n=null),t.emit({id:n,e:e})},t.prototype._trigger_bokeh_event=function(t){var e=this,n=function(){var n=e.plot_view.frame.xscales.default,i=e.plot_view.frame.yscales.default,r=t.sx,o=t.sy,s=n.invert(r),a=i.invert(o);switch(t.type){case"wheel":return new d.MouseWheel(r,o,s,a,t.delta);case"mousemove":return new d.MouseMove(r,o,s,a);case"mouseenter":return new d.MouseEnter(r,o,s,a);case"mouseleave":return new d.MouseLeave(r,o,s,a);case"tap":return new d.Tap(r,o,s,a);case"doubletap":return new d.DoubleTap(r,o,s,a);case"press":return new d.Press(r,o,s,a);case"pan":return new d.Pan(r,o,s,a,t.deltaX,t.deltaY);case"panstart":return new d.PanStart(r,o,s,a);case"panend":return new d.PanEnd(r,o,s,a);case"pinch":return new d.Pinch(r,o,s,a,t.scale);case"pinchstart":return new d.PinchStart(r,o,s,a);case"pinchend":return new d.PinchEnd(r,o,s,a);default:throw new Error("unreachable")}}();this.plot_view.model.trigger_event(n)},t.prototype._get_sxy=function(t){var e=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,n=e.pageX,i=e.pageY,r=a.offset(this.hit_area),o=r.left,s=r.top;return{sx:n-o,sy:i-s}},t.prototype._gesture_event=function(t){return i.__assign({type:t.type},this._get_sxy(t.srcEvent),{deltaX:t.deltaX,deltaY:t.deltaY,scale:t.scale,shiftKey:t.srcEvent.shiftKey})},t.prototype._tap_event=function(t){return i.__assign({type:t.type},this._get_sxy(t.srcEvent),{shiftKey:t.srcEvent.shiftKey})},t.prototype._move_event=function(t){return i.__assign({type:t.type},this._get_sxy(t))},t.prototype._scroll_event=function(t){return i.__assign({type:t.type},this._get_sxy(t),{delta:l.getDeltaY(t)})},t.prototype._key_event=function(t){return{type:t.type,keyCode:t.keyCode}},t.prototype._pan_start=function(t){var e=this._gesture_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)},t.prototype._pan=function(t){this._trigger(this.pan,this._gesture_event(t),t.srcEvent)},t.prototype._pan_end=function(t){this._trigger(this.pan_end,this._gesture_event(t),t.srcEvent)},t.prototype._pinch_start=function(t){this._trigger(this.pinch_start,this._gesture_event(t),t.srcEvent)},t.prototype._pinch=function(t){this._trigger(this.pinch,this._gesture_event(t),t.srcEvent)},t.prototype._pinch_end=function(t){this._trigger(this.pinch_end,this._gesture_event(t),t.srcEvent)},t.prototype._rotate_start=function(t){this._trigger(this.rotate_start,this._gesture_event(t),t.srcEvent)},t.prototype._rotate=function(t){this._trigger(this.rotate,this._gesture_event(t),t.srcEvent)},t.prototype._rotate_end=function(t){this._trigger(this.rotate_end,this._gesture_event(t),t.srcEvent)},t.prototype._tap=function(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)},t.prototype._doubletap=function(t){var e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)},t.prototype._press=function(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)},t.prototype._mouse_enter=function(t){this._trigger(this.move_enter,this._move_event(t),t)},t.prototype._mouse_move=function(t){this._trigger(this.move,this._move_event(t),t)},t.prototype._mouse_exit=function(t){this._trigger(this.move_exit,this._move_event(t),t)},t.prototype._mouse_wheel=function(t){this._trigger(this.scroll,this._scroll_event(t),t)},t.prototype._key_down=function(t){this.trigger(this.keydown,this._key_event(t))},t.prototype._key_up=function(t){this.trigger(this.keyup,this._key_event(t))},t.__name__="UIEvents",t}();n.UIEvents=p},function(t,e,n){var i=t(34),r=t(26),o=t(25);n.map=o.map,n.reduce=o.reduce,n.min=o.min,n.min_by=o.min_by,n.max=o.max,n.max_by=o.max_by,n.sum=o.sum,n.cumsum=o.cumsum,n.every=o.every,n.some=o.some,n.find=o.find,n.find_last=o.find_last,n.find_index=o.find_index,n.find_last_index=o.find_last_index,n.sorted_index=o.sorted_index;var s=Array.prototype.slice;function a(t){return s.call(t)}function l(t){var e;return(e=[]).concat.apply(e,t)}function c(t,e){return-1!==t.indexOf(e)}function h(t,e,n){void 0===n&&(n=1),r.assert(n>0,"'step' must be a positive number"),null==e&&(e=t,t=0);for(var i=Math.max,o=Math.ceil,s=Math.abs,a=t<=e?n:-n,l=i(o(s(e-t)/n),0),c=Array(l),h=0;h<l;h++,t+=a)c[h]=t;return c}function u(t){for(var e=[],n=0,i=t;n<i.length;n++){var r=i[n];c(e,r)||e.push(r)}return e}n.head=function(t){return t[0]},n.tail=function(t){return t[t.length-1]},n.last=function(t){return t[t.length-1]},n.copy=a,n.concat=l,n.includes=c,n.contains=c,n.nth=function(t,e){return t[e>=0?e:t.length+e]},n.zip=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];if(0==t.length)return[];for(var n=o.min(t.map(function(t){return t.length})),i=t.length,r=new Array(n),s=0;s<n;s++){r[s]=new Array(i);for(var a=0;a<i;a++)r[s][a]=t[a][s]}return r},n.unzip=function(t){for(var e=t.length,n=o.min(t.map(function(t){return t.length})),i=Array(n),r=0;r<n;r++)i[r]=new Array(e);for(var s=0;s<e;s++)for(var r=0;r<n;r++)i[r][s]=t[s][r];return i},n.range=h,n.linspace=function(t,e,n){void 0===n&&(n=100);for(var i=(e-t)/(n-1),r=new Array(n),o=0;o<n;o++)r[o]=t+i*o;return r},n.transpose=function(t){for(var e=t.length,n=t[0].length,i=[],r=0;r<n;r++){i[r]=[];for(var o=0;o<e;o++)i[r][o]=t[o][r]}return i},n.argmin=function(t){return o.min_by(h(t.length),function(e){return t[e]})},n.argmax=function(t){return o.max_by(h(t.length),function(e){return t[e]})},n.sort_by=function(t,e){var n=t.map(function(t,n){return{value:t,index:n,key:e(t)}});return n.sort(function(t,e){var n=t.key,i=e.key;if(n!==i){if(n>i||void 0===n)return 1;if(n<i||void 0===i)return-1}return t.index-e.index}),n.map(function(t){return t.value})},n.uniq=u,n.uniq_by=function(t,e){for(var n=[],i=[],r=0,o=t;r<o.length;r++){var s=o[r],a=e(s);c(i,a)||(i.push(a),n.push(s))}return n},n.union=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];return u(l(t))},n.intersection=function(t){for(var e=[],n=1;n<arguments.length;n++)e[n-1]=arguments[n];var i=[];t:for(var r=0,o=t;r<o.length;r++){var s=o[r];if(!c(i,s)){for(var a=0,l=e;a<l.length;a++){var h=l[a];if(!c(h,s))continue t}i.push(s)}}return i},n.difference=function(t){for(var e=[],n=1;n<arguments.length;n++)e[n-1]=arguments[n];var i=l(e);return t.filter(function(t){return!c(i,t)})},n.remove_at=function(t,e){var n=a(t);return n.splice(e,1),n},n.remove_by=function(t,e){for(var n=0;n<t.length;)e(t[n])?t.splice(n,1):n++},n.shuffle=function(t){for(var e=t.length,n=new Array(e),r=0;r<e;r++){var o=i.randomIn(0,r);o!==r&&(n[r]=n[o]),n[o]=t[r]}return n},n.pairwise=function(t,e){for(var n=t.length,i=new Array(n-1),r=0;r<n-1;r++)i[r]=e(t[r],t[r+1]);return i},n.reversed=function(t){for(var e=t.length,n=new Array(e),i=0;i<e;i++)n[e-i-1]=t[i];return n},n.repeat=function(t,e){for(var n=new Array(e),i=0;i<e;i++)n[i]=t;return n}},function(t,e,n){function i(t,e,n){for(var i=[],r=3;r<arguments.length;r++)i[r-3]=arguments[r];var o=t.length;e<0&&(e+=o),e<0?e=0:e>o&&(e=o),null==n||n>o-e?n=o-e:n<0&&(n=0);for(var s=o-n+i.length,a=new t.constructor(s),l=0;l<e;l++)a[l]=t[l];for(var c=0,h=i;c<h.length;c++){var u=h[c];a[l++]=u}for(var _=e+n;_<o;_++)a[l++]=t[_];return a}function r(t,e){return i(t,e,t.length-e)}function o(t,e,n){var i,r,o=t.length;if(void 0===n&&0==o)throw new Error("can't reduce an empty array without an initial value");for(void 0===n?(i=t[0],r=1):(i=n,r=0);r<o;r++)i=e(i,t[r],r,t);return i}function s(t){return function(e,n){for(var i=e.length,r=t>0?0:i-1;r>=0&&r<i;r+=t)if(n(e[r]))return r;return-1}}n.splice=i,n.head=r,n.insert=function(t,e,n){return i(t,n,0,e)},n.append=function(t,e){return i(t,t.length,0,e)},n.prepend=function(t,e){return i(t,0,0,e)},n.indexOf=function(t,e){for(var n=0,i=t.length;n<i;n++)if(t[n]===e)return n;return-1},n.map=function(t,e){for(var n=t.length,i=new t.constructor(n),r=0;r<n;r++)i[r]=e(t[r],r,t);return i},n.filter=function(t,e){for(var n=t.length,i=new t.constructor(n),o=0,s=0;s<n;s++){var a=t[s];e(a,s,t)&&(i[o++]=a)}return r(i,o)},n.reduce=o,n.min=function(t){for(var e,n=1/0,i=0,r=t.length;i<r;i++)(e=t[i])<n&&(n=e);return n},n.min_by=function(t,e){if(0==t.length)throw new Error("min_by() called with an empty array");for(var n=t[0],i=e(n),r=1,o=t.length;r<o;r++){var s=t[r],a=e(s);a<i&&(n=s,i=a)}return n},n.max=function(t){for(var e,n=-1/0,i=0,r=t.length;i<r;i++)(e=t[i])>n&&(n=e);return n},n.max_by=function(t,e){if(0==t.length)throw new Error("max_by() called with an empty array");for(var n=t[0],i=e(n),r=1,o=t.length;r<o;r++){var s=t[r],a=e(s);a>i&&(n=s,i=a)}return n},n.sum=function(t){for(var e=0,n=0,i=t.length;n<i;n++)e+=t[n];return e},n.cumsum=function(t){var e=new t.constructor(t.length);return o(t,function(t,n,i){return e[i]=t+n},0),e},n.every=function(t,e){for(var n=0,i=t.length;n<i;n++)if(!e(t[n]))return!1;return!0},n.some=function(t,e){for(var n=0,i=t.length;n<i;n++)if(e(t[n]))return!0;return!1},n.index_of=function(t,e){for(var n=0,i=t.length;n<i;n++)if(t[n]===e)return n;return-1},n.find_index=s(1),n.find_last_index=s(-1),n.find=function(t,e){var i=n.find_index(t,e);return-1==i?void 0:t[i]},n.find_last=function(t,e){var i=n.find_last_index(t,e);return-1==i?void 0:t[i]},n.sorted_index=function(t,e){for(var n=0,i=t.length;n<i;){var r=Math.floor((n+i)/2);t[r]<e?n=r+1:i=r}return n}},function(t,e,n){var i=t(421),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="AssertionError",e}(Error);n.AssertionError=r,n.assert=function(t,e){if(!(!0===t||!1!==t&&t()))throw new r(e||"Assertion failed")}},function(t,e,n){var i=Math.min,r=Math.max;n.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},n.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},n.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},n.union=function(t,e){return{x0:i(t.x0,e.x0),x1:r(t.x1,e.x1),y0:i(t.y0,e.y0),y1:r(t.y1,e.y1)}};var o=function(){function t(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){var e=t,n=e.x0,i=e.y0,r=e.x1,o=e.y1;if(!(n<=r&&i<=o))throw new Error("invalid bbox {x0: "+n+", y0: "+i+", x1: "+r+", y1: "+o+"}");this.x0=n,this.y0=i,this.x1=r,this.y1=o}else if("x"in t){var s=t,a=s.x,l=s.y,c=s.width,h=s.height;if(!(c>=0&&h>=0))throw new Error("invalid bbox {x: "+a+", y: "+l+", width: "+c+", height: "+h+"}");this.x0=a,this.y0=l,this.x1=a+c,this.y1=l+h}else{var u,_=void 0,d=void 0,p=void 0;if("width"in t)if("left"in t)_=t.left,d=_+t.width;else if("right"in t)d=t.right,_=d-t.width;else{var f=t.width/2;_=t.hcenter-f,d=t.hcenter+f}else _=t.left,d=t.right;if("height"in t)if("top"in t)u=t.top,p=u+t.height;else if("bottom"in t)p=t.bottom,u=p-t.height;else{var m=t.height/2;u=t.vcenter-m,p=t.vcenter+m}else u=t.top,p=t.bottom;if(!(_<=d&&u<=p))throw new Error("invalid bbox {left: "+_+", top: "+u+", right: "+d+", bottom: "+p+"}");this.x0=_,this.y0=u,this.x1=d,this.y1=p}}return t.prototype.toString=function(){return"BBox({left: "+this.left+", top: "+this.top+", width: "+this.width+", height: "+this.height+"})"},Object.defineProperty(t.prototype,"left",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"top",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return this.x1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"bottom",{get:function(){return this.y1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"p0",{get:function(){return[this.x0,this.y0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"p1",{get:function(){return[this.x1,this.y1]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this.x1-this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.y1-this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rect",{get:function(){return{x0:this.x0,y0:this.y0,x1:this.x1,y1:this.y1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"box",{get:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"h_range",{get:function(){return{start:this.x0,end:this.x1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"v_range",{get:function(){return{start:this.y0,end:this.y1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){return[this.h_range,this.v_range]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"aspect",{get:function(){return this.width/this.height},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hcenter",{get:function(){return(this.left+this.right)/2},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"vcenter",{get:function(){return(this.top+this.bottom)/2},enumerable:!0,configurable:!0}),t.prototype.contains=function(t,e){return t>=this.x0&&t<=this.x1&&e>=this.y0&&e<=this.y1},t.prototype.clip=function(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]},t.prototype.union=function(e){return new t({x0:i(this.x0,e.x0),y0:i(this.y0,e.y0),x1:r(this.x1,e.x1),y1:r(this.y1,e.y1)})},t.prototype.equals=function(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1},Object.defineProperty(t.prototype,"xview",{get:function(){var t=this;return{compute:function(e){return t.left+e},v_compute:function(e){for(var n=new Float64Array(e.length),i=t.left,r=0;r<e.length;r++)n[r]=i+e[r];return n}}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){var t=this;return{compute:function(e){return t.bottom-e},v_compute:function(e){for(var n=new Float64Array(e.length),i=t.bottom,r=0;r<e.length;r++)n[r]=i-e[r];return n}}},enumerable:!0,configurable:!0}),t.__name__="BBox",t}();n.BBox=o},function(t,e,n){n.delay=function(t,e){return setTimeout(t,e)};var i="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;n.defer=function(t){return i(t)},n.throttle=function(t,e,n){void 0===n&&(n={});var i,r,o,s=null,a=0,l=function(){a=!1===n.leading?0:Date.now(),s=null,o=t.apply(i,r),s||(i=r=null)};return function(){var c=Date.now();a||!1!==n.leading||(a=c);var h=e-(c-a);return i=this,r=arguments,h<=0||h>e?(s&&(clearTimeout(s),s=null),a=c,o=t.apply(i,r),s||(i=r=null)):s||!1===n.trailing||(s=setTimeout(l,h)),o}},n.once=function(t){var e,n=!1;return function(){return n||(n=!0,e=t()),e}}},function(t,e,n){n.fixup_ctx=function(t){(function(t){t.setLineDash||(t.setLineDash=function(e){t.mozDash=e,t.webkitLineDash=e}),t.getLineDash||(t.getLineDash=function(){return t.mozDash})})(t),function(t){t.setLineDashOffset=function(e){t.lineDashOffset=e,t.mozDashOffset=e,t.webkitLineDashOffset=e},t.getLineDashOffset=function(){return t.mozDashOffset}}(t),function(t){t.setImageSmoothingEnabled=function(e){t.imageSmoothingEnabled=e,t.mozImageSmoothingEnabled=e,t.oImageSmoothingEnabled=e,t.webkitImageSmoothingEnabled=e,t.msImageSmoothingEnabled=e},t.getImageSmoothingEnabled=function(){var e=t.imageSmoothingEnabled;return null==e||e}}(t),function(t){t.measureText&&null==t.html5MeasureText&&(t.html5MeasureText=t.measureText,t.measureText=function(e){var n=t.html5MeasureText(e);return n.ascent=1.6*t.html5MeasureText("m").width,n})}(t),function(t){t.ellipse||(t.ellipse=function(e,n,i,r,o,s,a,l){void 0===l&&(l=!1);var c=.551784;t.translate(e,n),t.rotate(o);var h=i,u=r;l&&(h=-i,u=-r),t.moveTo(-h,0),t.bezierCurveTo(-h,u*c,-h*c,u,0,u),t.bezierCurveTo(h*c,u,h,u*c,h,0),t.bezierCurveTo(h,-u*c,h*c,-u,0,-u),t.bezierCurveTo(-h*c,-u,-h,-u*c,-h,0),t.rotate(-o),t.translate(-e,-n)})}(t)},n.get_scale_ratio=function(t,e,n){if("svg"==n)return 1;if(e){var i=window.devicePixelRatio||1,r=t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1;return i/r}return 1}},function(t,e,n){var i=t(41),r=t(24);function o(t){var e=Number(t).toString(16);return 1==e.length?"0"+e:e}function s(t){if(0==(t+="").indexOf("#"))return t;if(i.is_svg_color(t))return i.svg_colors[t];if(0==t.indexOf("rgb")){var e=t.replace(/^rgba?\(|\s+|\)$/g,"").split(","),n=e.slice(0,3).map(o).join("");return 4==e.length&&(n+=o(Math.floor(255*parseFloat(e[3])))),"#"+n.slice(0,8)}return t}function a(t){var e;switch(t.substring(0,4)){case"rgba":e={start:"rgba(",len:4,alpha:!0};break;case"rgb(":e={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(t))throw new Error("color expects integers for rgb in rgb/rgba tuple, received "+t);var n=t.replace(e.start,"").replace(")","").split(",").map(parseFloat);if(n.length!=e.len)throw new Error("color expects rgba "+e.len+"-tuple, received "+t);if(e.alpha&&!(0<=n[3]&&n[3]<=1))throw new Error("color expects rgba 4-tuple to have alpha value between 0 and 1");if(r.includes(n.slice(0,3).map(function(t){return 0<=t&&t<=255}),!1))throw new Error("color expects rgb to have value between 0 and 255");return!0}n.is_color=function(t){return i.is_svg_color(t.toLowerCase())||"#"==t.substring(0,1)||a(t)},n.rgb2hex=function(t,e,n){var i=o(255&t),r=o(255&e),s=o(255&n);return"#"+i+r+s},n.color2hex=s,n.color2rgba=function(t,e){if(void 0===e&&(e=1),!t)return[0,0,0,0];var n=s(t);(n=n.replace(/ |#/g,"")).length<=4&&(n=n.replace(/(.)/g,"$1$1"));for(var i=n.match(/../g).map(function(t){return parseInt(t,16)/255});i.length<3;)i.push(0);return i.length<4&&i.push(e),i.slice(0,4)},n.valid_rgb=a},function(t,e,n){var i;n.is_ie=(i="undefined"!=typeof navigator?navigator.userAgent:"").indexOf("MSIE")>=0||i.indexOf("Trident")>0||i.indexOf("Edge")>0,n.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),n.is_little_endian=function(){var t=new ArrayBuffer(4),e=new Uint8Array(t),n=new Uint32Array(t);n[1]=168496141;var i=!0;return 10==e[4]&&11==e[5]&&12==e[6]&&13==e[7]&&(i=!1),i}()},function(t,e,n){var i=t(24),r=t(33),o=t(46),s=function(){function t(){this._dict={}}return t.prototype._existing=function(t){return t in this._dict?this._dict[t]:null},t.prototype.add_value=function(t,e){var n=this._existing(t);null==n?this._dict[t]=e:o.isArray(n)?n.push(e):this._dict[t]=[n,e]},t.prototype.remove_value=function(t,e){var n=this._existing(t);if(o.isArray(n)){var s=i.difference(n,[e]);s.length>0?this._dict[t]=s:delete this._dict[t]}else r.isEqual(n,e)&&delete this._dict[t]},t.prototype.get_one=function(t,e){var n=this._existing(t);if(o.isArray(n)){if(1===n.length)return n[0];throw new Error(e)}return n},t.__name__="MultiDict",t}();n.MultiDict=s;var a=function(){function t(e){if(null==e)this._values=[];else if(e instanceof t)this._values=i.copy(e._values);else{this._values=[];for(var n=0,r=e;n<r.length;n++){var o=r[n];this.add(o)}}}return Object.defineProperty(t.prototype,"values",{get:function(){return i.copy(this._values).sort()},enumerable:!0,configurable:!0}),t.prototype.toString=function(){return"Set(["+this.values.join(",")+"])"},Object.defineProperty(t.prototype,"size",{get:function(){return this._values.length},enumerable:!0,configurable:!0}),t.prototype.has=function(t){return-1!==this._values.indexOf(t)},t.prototype.add=function(t){this.has(t)||this._values.push(t)},t.prototype.remove=function(t){var e=this._values.indexOf(t);-1!==e&&this._values.splice(e,1)},t.prototype.toggle=function(t){var e=this._values.indexOf(t);-1===e?this._values.push(t):this._values.splice(e,1)},t.prototype.clear=function(){this._values=[]},t.prototype.union=function(e){return e=new t(e),new t(this._values.concat(e._values))},t.prototype.intersect=function(e){e=new t(e);for(var n=new t,i=0,r=e._values;i<r.length;i++){var o=r[i];this.has(o)&&e.has(o)&&n.add(o)}return n},t.prototype.diff=function(e){e=new t(e);for(var n=new t,i=0,r=this._values;i<r.length;i++){var o=r[i];e.has(o)||n.add(o)}return n},t.prototype.forEach=function(t,e){for(var n=0,i=this._values;n<i.length;n++){var r=i[n];t.call(e||this,r,r,this)}},t.__name__="Set",t}();n.Set=a;var l=function(){function t(t,e,n){this.nrows=t,this.ncols=e,this._matrix=new Array(t);for(var i=0;i<t;i++){this._matrix[i]=new Array(e);for(var r=0;r<e;r++)this._matrix[i][r]=n(i,r)}}return t.prototype.at=function(t,e){return this._matrix[t][e]},t.prototype.map=function(e){var n=this;return new t(this.nrows,this.ncols,function(t,i){return e(n.at(t,i),t,i)})},t.prototype.apply=function(e){var n=this,i=t.from(e),r=this.nrows,o=this.ncols;if(r==i.nrows&&o==i.ncols)return new t(r,o,function(t,e){return i.at(t,e)(n.at(t,e),t,e)});throw new Error("dimensions don't match")},t.prototype.to_sparse=function(){for(var t=[],e=0;e<this.nrows;e++)for(var n=0;n<this.ncols;n++){var i=this._matrix[e][n];t.push([i,e,n])}return t},t.from=function(e){if(e instanceof t)return e;var n=e.length,r=i.min(e.map(function(t){return t.length}));return new t(n,r,function(t,n){return e[t][n]})},t.__name__="Matrix",t}();n.Matrix=l},function(t,e,n){var i=t(46),r=Object.prototype.toString;n.isEqual=function(t,e){return function t(e,n,o,s){if(e===n)return 0!==e||1/e==1/n;if(null==e||null==n)return e===n;var a=r.call(e);if(a!==r.call(n))return!1;switch(a){case"[object RegExp]":case"[object String]":return""+e==""+n;case"[object Number]":return+e!=+e?+n!=+n:0==+e?1/+e==1/n:+e==+n;case"[object Date]":case"[object Boolean]":return+e==+n}var l="[object Array]"===a;if(!l){if("object"!=typeof e||"object"!=typeof n)return!1;var c=e.constructor,h=n.constructor;if(c!==h&&!(i.isFunction(c)&&c instanceof c&&i.isFunction(h)&&h instanceof h)&&"constructor"in e&&"constructor"in n)return!1}s=s||[];for(var u=(o=o||[]).length;u--;)if(o[u]===e)return s[u]===n;if(o.push(e),s.push(n),l){if((u=e.length)!==n.length)return!1;for(;u--;)if(!t(e[u],n[u],o,s))return!1}else{var _=Object.keys(e),d=void 0;if(u=_.length,Object.keys(n).length!==u)return!1;for(;u--;)if(d=_[u],!n.hasOwnProperty(d)||!t(e[d],n[d],o,s))return!1}return o.pop(),s.pop(),!0}(t,e)}},function(t,e,n){function i(t){for(;t<0;)t+=2*Math.PI;for(;t>2*Math.PI;)t-=2*Math.PI;return t}function r(t,e){return Math.abs(i(t-e))}function o(){return Math.random()}n.angle_norm=i,n.angle_dist=r,n.angle_between=function(t,e,n,o){var s=r(e,n);if(0==s)return!1;var a=i(t),l=r(e,a)<=s&&r(a,n)<=s;return 0==o?l:!l},n.random=o,n.randomIn=function(t,e){return null==e&&(e=t,t=0),t+Math.floor(Math.random()*(e-t+1))},n.atan2=function(t,e){return Math.atan2(e[1]-t[1],e[0]-t[0])},n.rnorm=function(t,e){for(var n,i;n=o(),i=(2*(i=o())-1)*Math.sqrt(1/Math.E*2),!(-4*n*n*Math.log(n)>=i*i););var r=i/n;return r=t+e*r},n.clamp=function(t,e,n){return t>n?n:t<e?e:t}},function(t,e,n){var i=t(421),r=t(24);function o(t,e){return i.__assign(t,e)}function s(t){return Object.keys(t).length}n.keys=Object.keys,n.values=function(t){for(var e=Object.keys(t),n=e.length,i=new Array(n),r=0;r<n;r++)i[r]=t[e[r]];return i},n.extend=o,n.clone=function(t){return o({},t)},n.merge=function(t,e){for(var n=Object.create(Object.prototype),i=r.concat([Object.keys(t),Object.keys(e)]),o=0,s=i;o<s.length;o++){var a=s[o],l=t.hasOwnProperty(a)?t[a]:[],c=e.hasOwnProperty(a)?e[a]:[];n[a]=r.union(l,c)}return n},n.size=s,n.isEmpty=function(t){return 0===s(t)}},function(t,e,n){var i=t(404),r=t(392),o=new r("GOOGLE"),s=new r("WGS84");n.wgs84_mercator=i(s,o);var a={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},l={lon:[-180,180],lat:[-85.06,85.06]};function c(t,e){for(var i=Math.min(t.length,e.length),r=new Array(i),o=new Array(i),s=0;s<i;s++){var a=n.wgs84_mercator.forward([t[s],e[s]]),l=a[0],c=a[1];r[s]=l,o[s]=c}return[r,o]}n.clip_mercator=function(t,e,n){var i=a[n],r=i[0],o=i[1];return[Math.max(t,r),Math.min(e,o)]},n.in_bounds=function(t,e){return t>l[e][0]&&t<l[e][1]},n.project_xy=c,n.project_xsys=function(t,e){for(var n=Math.min(t.length,e.length),i=new Array(n),r=new Array(n),o=0;o<n;o++){var s=c(t[o],e[o]),a=s[0],l=s[1];i[o]=a,r[o]=l}return[i,r]}},function(t,e,n){var i=t(46);n.create_ref=function(t){var e={type:t.type,id:t.id};return null!=t._subtype&&(e.subtype=t._subtype),e},n.is_ref=function(t){if(i.isObject(t)){var e=Object.keys(t).sort();if(2==e.length)return"id"==e[0]&&"type"==e[1];if(3==e.length)return"id"==e[0]&&"subtype"==e[1]&&"type"==e[2]}return!1}},function(t,e,n){var i=t(46),r=t(31);function o(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,2*t.length),n=0,i=e.length;n<i;n+=2){var r=e[n];e[n]=e[n+1],e[n+1]=r}}function s(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,4*t.length),n=0,i=e.length;n<i;n+=4){var r=e[n];e[n]=e[n+3],e[n+3]=r,r=e[n+1],e[n+1]=e[n+2],e[n+2]=r}}function a(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,8*t.length),n=0,i=e.length;n<i;n+=8){var r=e[n];e[n]=e[n+7],e[n+7]=r,r=e[n+1],e[n+1]=e[n+6],e[n+6]=r,r=e[n+2],e[n+2]=e[n+5],e[n+5]=r,r=e[n+3],e[n+3]=e[n+4],e[n+4]=r}}function l(t,e){for(var i=t.order!==n.BYTE_ORDER,r=t.shape,l=null,c=0,h=e;c<h.length;c++){var u=h[c],_=JSON.parse(u[0]);if(_.id===t.__buffer__){l=u[1];break}}var d=new n.ARRAY_TYPES[t.dtype](l);return i&&(2===d.BYTES_PER_ELEMENT?o(d):4===d.BYTES_PER_ELEMENT?s(d):8===d.BYTES_PER_ELEMENT&&a(d)),[d,r]}function c(t,e){return i.isObject(t)&&"__ndarray__"in t?_(t):i.isObject(t)&&"__buffer__"in t?l(t,e):i.isArray(t)||i.isTypedArray(t)?[t,[]]:void 0}function h(t){var e=new Uint8Array(t),n=Array.from(e).map(function(t){return String.fromCharCode(t)});return btoa(n.join(""))}function u(t){for(var e=atob(t),n=e.length,i=new Uint8Array(n),r=0,o=n;r<o;r++)i[r]=e.charCodeAt(r);return i.buffer}function _(t){var e=u(t.__ndarray__),i=t.dtype,r=t.shape;if(!(i in n.ARRAY_TYPES))throw new Error("unknown dtype: "+i);return[new n.ARRAY_TYPES[i](e),r]}function d(t,e){var i,r=h(t.buffer),o=function(t){if("name"in t.constructor)return t.constructor.name;switch(!0){case t instanceof Uint8Array:return"Uint8Array";case t instanceof Int8Array:return"Int8Array";case t instanceof Uint16Array:return"Uint16Array";case t instanceof Int16Array:return"Int16Array";case t instanceof Uint32Array:return"Uint32Array";case t instanceof Int32Array:return"Int32Array";case t instanceof Float32Array:return"Float32Array";case t instanceof Float64Array:return"Float64Array";default:throw new Error("unsupported typed array")}}(t);if(!(o in n.DTYPES))throw new Error("unknown array type: "+o);i=n.DTYPES[o];var s={__ndarray__:r,shape:e,dtype:i};return s}function p(t,e){if(0==t.length||!i.isObject(t[0])&&!i.isArray(t[0]))return[t,[]];for(var n=[],r=[],o=0,s=t;o<s.length;o++){var a=s[o],l=i.isArray(a)?p(a,e):c(a,e),h=l[0],u=l[1];n.push(h),r.push(u)}var _=r.map(function(t){return t.filter(function(t){return 0!=t.length})});return[n,_]}function f(t,e){for(var n=[],r=0,o=t.length;r<o;r++){var s=t[r];if(i.isTypedArray(s)){var a=e[r]?e[r]:void 0;n.push(d(s,a))}else i.isArray(s)?n.push(f(s,e?e[r]:[])):n.push(s)}return n}n.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},n.DTYPES={Uint8Array:"uint8",Int8Array:"int8",Uint16Array:"uint16",Int16Array:"int16",Uint32Array:"uint32",Int32Array:"int32",Float32Array:"float32",Float64Array:"float64"},n.BYTE_ORDER=r.is_little_endian?"little":"big",n.swap16=o,n.swap32=s,n.swap64=a,n.process_buffer=l,n.process_array=c,n.arrayBufferToBase64=h,n.base64ToArrayBuffer=u,n.decode_base64=_,n.encode_base64=d,n.decode_column_data=function(t,e){void 0===e&&(e=[]);var n={},r={};for(var o in t){var s=t[o];if(i.isArray(s)){if(0==s.length||!i.isObject(s[0])&&!i.isArray(s[0])){n[o]=s;continue}var a=p(s,e),l=a[0],h=a[1];n[o]=l,r[o]=h}else{var u=c(s,e),_=u[0],d=u[1];n[o]=_,r[o]=d}}return[n,r]},n.encode_column_data=function(t,e){var n={};for(var r in t){var o=t[r],s=null!=e?e[r]:void 0,a=void 0;a=i.isTypedArray(o)?d(o,s):i.isArray(o)?f(o,s||[]):o,n[r]=a}return n}},function(t,e,n){var i=t(389),r=t(27),o=function(){function t(t){if(this.points=t,this.index=null,t.length>0){this.index=new i(t.length);for(var e=0,n=t;e<n.length;e++){var r=n[e],o=r.x0,s=r.y0,a=r.x1,l=r.y1;this.index.add(o,s,a,l)}this.index.finish()}}return t.prototype._normalize=function(t){var e,n,i=t.x0,r=t.y0,o=t.x1,s=t.y1;return i>o&&(i=(e=[o,i])[0],o=e[1]),r>s&&(r=(n=[s,r])[0],s=n[1]),{x0:i,y0:r,x1:o,y1:s}},Object.defineProperty(t.prototype,"bbox",{get:function(){if(null==this.index)return r.empty();var t=this.index,e=t.minX,n=t.minY,i=t.maxX,o=t.maxY;return{x0:e,y0:n,x1:i,y1:o}},enumerable:!0,configurable:!0}),t.prototype.search=function(t){var e=this;if(null==this.index)return[];var n=this._normalize(t),i=n.x0,r=n.y0,o=n.x1,s=n.y1,a=this.index.search(i,r,o,s);return a.map(function(t){return e.points[t]})},t.prototype.indices=function(t){return this.search(t).map(function(t){var e=t.i;return e})},t.__name__="SpatialIndex",t}();n.SpatialIndex=o},function(t,e,n){var i=t(21);function r(){for(var t=new Array(32),e=0;e<32;e++)t[e]="0123456789ABCDEF".substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]="0123456789ABCDEF".substr(3&t[16].charCodeAt(0)|8,1),t.join("")}n.startsWith=function(t,e,n){return void 0===n&&(n=0),t.substr(n,e.length)==e},n.uuid4=r;var o=1e3;n.uniqueId=function(t){var e=i.settings.dev?"j"+o++:r();return null!=t?t+"-"+e:e},n.escape=function(t){return t.replace(/(?:[&<>"'`])/g,function(t){switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}})},n.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,function(t,e){switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}})},n.use_strict=function(t){return"'use strict';\n"+t}},function(t,e,n){n.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},n.is_svg_color=function(t){return t in n.svg_colors}},function(t,e,n){var i=t(419),r=t(391),o=t(420),s=t(40),a=t(46);function l(t){for(var e=[],n=1;n<arguments.length;n++)e[n-1]=arguments[n];return i.sprintf.apply(void 0,[t].concat(e))}function c(t,e,n){if(a.isNumber(t)){var i=function(){switch(!1){case Math.floor(t)!=t:return"%d";case!(Math.abs(t)>.1&&Math.abs(t)<1e3):return"%0.3f";default:return"%0.3e"}}();return l(i,t)}return""+t}function h(t,e,i,r){if(null==i)return c;if(null!=r&&(t in r||e in r)){var o=e in r?e:t,s=r[o];if(a.isString(s)){if(s in n.DEFAULT_FORMATTERS)return n.DEFAULT_FORMATTERS[s];throw new Error("Unknown tooltip field formatter type '"+s+"'")}return function(t,e,n){return s.format(t,e,n)}}return n.DEFAULT_FORMATTERS.numeral}function u(t,e,n,i){if("$"==t[0]){if(t.substring(1)in i)return i[t.substring(1)];throw new Error("Unknown special variable '"+t+"'")}var r=e.get_column(t);if(null==r)return null;if(a.isNumber(n))return r[n];var o=r[n.index];if(a.isTypedArray(o)||a.isArray(o)){if(a.isArray(o[0])){var s=o[n.dim2];return s[n.dim1]}return o[n.flat_index]}return o}n.sprintf=l,n.DEFAULT_FORMATTERS={numeral:function(t,e,n){return r.format(t,e)},datetime:function(t,e,n){return o(t,e)},printf:function(t,e,n){return l(e,t)}},n.basic_formatter=c,n.get_formatter=h,n.get_value=u,n.replace_placeholders=function(t,e,n,i,r){void 0===r&&(r={});var o=t.replace(/(?:^|[^@])([@|\$](?:\w+|{[^{}]+}))(?:{[^{}]+})?/g,function(t,e,n){return""+e});return t=(t=(t=t.replace(/@\$name/g,function(t){return"@{"+r.name+"}"})).replace(/(^|[^\$])\$(\w+)/g,function(t,e,n){return e+"@$"+n})).replace(/(^|[^@])@(?:(\$?\w+)|{([^{}]+)})(?:{([^{}]+)})?/g,function(t,a,l,c,_){var d=u(l=null!=c?c:l,e,n,r);if(null==d)return""+a+s.escape("???");if("safe"==_)return""+a+d;var p=h(l,o,_,i);return""+a+s.escape(p(d,_,r))})}},function(t,e,n){var i=t(5),r={};n.measure_font=function(t){if(null!=r[t])return r[t];var e=i.span({style:{font:t}},"Hg"),n=i.div({style:{display:"inline-block",width:"1px",height:"0px"}}),o=i.div({},e,n);document.body.appendChild(o);try{n.style.verticalAlign="baseline";var s=i.offset(n).top-i.offset(e).top;n.style.verticalAlign="bottom";var a=i.offset(n).top-i.offset(e).top,l={height:a,ascent:s,descent:a-s};return r[t]=l,l}finally{document.body.removeChild(o)}};var o={};n.measure_text=function(t,e){var n=o[e];if(null!=n){var r=n[t];if(null!=r)return r}else o[e]={};var s=i.div({style:{display:"inline-block","white-space":"nowrap",font:e}},t);document.body.appendChild(s);try{var a=s.getBoundingClientRect(),l=a.width,c=a.height;return o[e][t]={width:l,height:c},{width:l,height:c}}finally{document.body.removeChild(s)}}},function(t,e,n){var i=("undefined"!=typeof window?window.requestAnimationFrame:void 0)||("undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.msRequestAnimationFrame:void 0)||function(t){return t(Date.now()),-1};n.throttle=function(t,e){var n=null,r=0,o=!1,s=function(){r=Date.now(),n=null,o=!1,t()};return function(){var t=Date.now(),a=e-(t-r);a<=0&&!o?(null!=n&&clearTimeout(n),o=!0,i(s)):n||o||(n=setTimeout(function(){return i(s)},a))}}},function(t,e,n){n.concat=function(t){for(var e=[],n=1;n<arguments.length;n++)e[n-1]=arguments[n];for(var i=t.length,r=0,o=e;r<o.length;r++){var s=o[r];i+=s.length}var a=new t.constructor(i);a.set(t,0);for(var l=t.length,c=0,h=e;c<h.length;c++){var s=h[c];a.set(s,l),l+=s.length}return a}},function(t,e,n){var i=t(24),r=Object.prototype.toString;function o(t){return"[object Number]"===r.call(t)}function s(t){var e=typeof t;return"function"===e||"object"===e&&!!t}n.isBoolean=function(t){return!0===t||!1===t||"[object Boolean]"===r.call(t)},n.isNumber=o,n.isInteger=function(t){return o(t)&&isFinite(t)&&Math.floor(t)===t},n.isString=function(t){return"[object String]"===r.call(t)},n.isStrictNaN=function(t){return o(t)&&t!==+t},n.isFunction=function(t){return"[object Function]"===r.call(t)},n.isArray=function(t){return Array.isArray(t)},n.isArrayOf=function(t,e){return i.every(t,e)},n.isArrayableOf=function(t,e){for(var n=0,i=t.length;n<i;n++)if(!e(t[n]))return!1;return!0},n.isTypedArray=function(t){return null!=t&&t.buffer instanceof ArrayBuffer},n.isObject=s,n.isPlainObject=function(t){return s(t)&&(null==t.constructor||t.constructor===Object)}},function(t,e,n){function i(t){var e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}n.getDeltaY=function(t){var e,n=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:n*=i((e=t.target).offsetParent||document.body)||i(e)||16;break;case t.DOM_DELTA_PAGE:n*=function(t){return t.clientHeight}(t.target)}return n}},function(t,e,n){var i=t(34);function r(t,e,n){var i=[t.start,t.end],r=i[0],o=i[1],s=null!=n?n:(o+r)/2,a=r-(r-s)*e,l=o-(o-s)*e;return[a,l]}function o(t,e){var n=e[0],i=e[1],r={};for(var o in t){var s=t[o],a=s.r_invert(n,i),l=a[0],c=a[1];r[o]={start:l,end:c}}return r}n.scale_highlow=r,n.get_info=o,n.scale_range=function(t,e,n,s,a){void 0===n&&(n=!0),void 0===s&&(s=!0),e=i.clamp(e,-.9,.9);var l=n?e:0,c=r(t.bbox.h_range,l,null!=a?a.x:void 0),h=c[0],u=c[1],_=o(t.xscales,[h,u]),d=s?e:0,p=r(t.bbox.v_range,d,null!=a?a.y:void 0),f=p[0],m=p[1],v=o(t.yscales,[f,m]);return{xrs:_,yrs:v,factor:e}}},function(t,e,n){var i=t(46);n.isValue=function(t){return i.isPlainObject(t)&&"value"in t},n.isField=function(t){return i.isPlainObject(t)&&"field"in t}},function(t,e,n){var i=t(421),r=t(22),o=t(46),s=t(40),a=function(t){function e(e){var n=t.call(this)||this;if(n.removed=new r.Signal0(n,"removed"),null==e.model)throw new Error("model of a view wasn't configured");return n.model=e.model,n._parent=e.parent,n.id=e.id||s.uniqueId(),n.initialize(),!1!==e.connect_signals&&n.connect_signals(),n}return i.__extends(e,t),e.prototype.initialize=function(){},e.prototype.remove=function(){this._parent=void 0,this.disconnect_signals(),this.removed.emit()},e.prototype.toString=function(){return this.model.type+"View("+this.id+")"},e.prototype.serializable_state=function(){return{type:this.model.type}},Object.defineProperty(e.prototype,"parent",{get:function(){if(void 0!==this._parent)return this._parent;throw new Error("parent of a view wasn't configured")},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_root",{get:function(){return null===this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"root",{get:function(){return this.is_root?this:this.parent.root},enumerable:!0,configurable:!0}),e.prototype.assert_root=function(){if(!this.is_root)throw new Error(this.toString()+" is not a root layout")},e.prototype.connect_signals=function(){},e.prototype.disconnect_signals=function(){r.Signal.disconnectReceiver(this)},e.prototype.on_change=function(t,e){for(var n=0,i=o.isArray(t)?t:[t];n<i.length;n++){var r=i[n];this.connect(r.change,e)}},e.__name__="View",e}(r.Signalable());n.View=a},function(t,e,n){var i=t(421),r=t(19),o=t(30);function s(t,e,n){t.moveTo(0,n+.5),t.lineTo(e,n+.5),t.stroke()}function a(t,e,n){t.moveTo(n+.5,0),t.lineTo(n+.5,e),t.stroke()}function l(t,e){t.moveTo(0,e),t.lineTo(e,0),t.stroke(),t.moveTo(0,0),t.lineTo(e,e),t.stroke()}function c(t,e,n,i){var r=n,o=r/2,c=o/2,h=function(t){var e=document.createElement("canvas");return e.width=t,e.height=t,e}(n),u=h.getContext("2d");switch(u.strokeStyle=e,u.lineCap="square",u.fillStyle=e,u.lineWidth=i,t){case" ":case"blank":break;case".":case"dot":u.arc(o,o,o/2,0,2*Math.PI,!0),u.fill();break;case"o":case"ring":u.arc(o,o,o/2,0,2*Math.PI,!0),u.stroke();break;case"-":case"horizontal_line":s(u,r,o);break;case"|":case"vertical_line":a(u,r,o);break;case"+":case"cross":s(u,r,o),a(u,r,o);break;case'"':case"horizontal_dash":s(u,o,o);break;case":":case"vertical_dash":a(u,o,o);break;case"@":case"spiral":var _=r/30;u.moveTo(o,o);for(var d=0;d<360;d++){var p=.1*d,f=o+_*p*Math.cos(p),m=o+_*p*Math.sin(p);u.lineTo(f,m)}u.stroke();break;case"/":case"right_diagonal_line":u.moveTo(.5-c,r),u.lineTo(c+.5,0),u.stroke(),u.moveTo(c+.5,r),u.lineTo(3*c+.5,0),u.stroke(),u.moveTo(3*c+.5,r),u.lineTo(5*c+.5,0),u.stroke(),u.stroke();break;case"\\":case"left_diagonal_line":u.moveTo(c+.5,r),u.lineTo(.5-c,0),u.stroke(),u.moveTo(3*c+.5,r),u.lineTo(c+.5,0),u.stroke(),u.moveTo(5*c+.5,r),u.lineTo(3*c+.5,0),u.stroke(),u.stroke();break;case"x":case"diagonal_cross":l(u,r);break;case",":case"right_diagonal_dash":u.moveTo(c+.5,3*c+.5),u.lineTo(3*c+.5,c+.5),u.stroke();break;case"`":case"left_diagonal_dash":u.moveTo(c+.5,c+.5),u.lineTo(3*c+.5,3*c+.5),u.stroke();break;case"v":case"horizontal_wave":u.moveTo(0,c),u.lineTo(o,3*c),u.lineTo(r,c),u.stroke();break;case">":case"vertical_wave":u.moveTo(c,0),u.lineTo(3*c,o),u.lineTo(c,r),u.stroke();break;case"*":case"criss_cross":l(u,r),s(u,r,o),a(u,r,o)}return h}var h=function(){function t(t,e){void 0===e&&(e=""),this.obj=t,this.prefix=e,this.cache={};for(var n=0,i=this.attrs;n<i.length;n++){var r=i[n];this[r]=t.properties[e+r]}}return t.prototype.warm_cache=function(t){for(var e=0,n=this.attrs;e<n.length;e++){var i=n[e],r=this.obj.properties[this.prefix+i];if(void 0!==r.spec.value)this.cache[i]=r.spec.value;else{if(null==t)throw new Error("source is required with a vectorized visual property");this.cache[i+"_array"]=r.array(t)}}},t.prototype.cache_select=function(t,e){var n,i=this.obj.properties[this.prefix+t];return void 0!==i.spec.value?this.cache[t]=n=i.spec.value:this.cache[t]=n=this.cache[t+"_array"][e],n},t.prototype.set_vectorize=function(t,e){null!=this.all_indices?this._set_vectorize(t,this.all_indices[e]):this._set_vectorize(t,e)},t.__name__="ContextProperties",t}();n.ContextProperties=h;var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.set_value=function(t){t.strokeStyle=this.line_color.value(),t.globalAlpha=this.line_alpha.value(),t.lineWidth=this.line_width.value(),t.lineJoin=this.line_join.value(),t.lineCap=this.line_cap.value(),t.setLineDash(this.line_dash.value()),t.setLineDashOffset(this.line_dash_offset.value())},Object.defineProperty(e.prototype,"doit",{get:function(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)},enumerable:!0,configurable:!0}),e.prototype._set_vectorize=function(t,e){this.cache_select("line_color",e),t.strokeStyle!==this.cache.line_color&&(t.strokeStyle=this.cache.line_color),this.cache_select("line_alpha",e),t.globalAlpha!==this.cache.line_alpha&&(t.globalAlpha=this.cache.line_alpha),this.cache_select("line_width",e),t.lineWidth!==this.cache.line_width&&(t.lineWidth=this.cache.line_width),this.cache_select("line_join",e),t.lineJoin!==this.cache.line_join&&(t.lineJoin=this.cache.line_join),this.cache_select("line_cap",e),t.lineCap!==this.cache.line_cap&&(t.lineCap=this.cache.line_cap),this.cache_select("line_dash",e),t.getLineDash()!==this.cache.line_dash&&t.setLineDash(this.cache.line_dash),this.cache_select("line_dash_offset",e),t.getLineDashOffset()!==this.cache.line_dash_offset&&t.setLineDashOffset(this.cache.line_dash_offset)},e.prototype.color_value=function(){var t=o.color2rgba(this.line_color.value(),this.line_alpha.value()),e=t[0],n=t[1],i=t[2],r=t[3];return"rgba("+255*e+","+255*n+","+255*i+","+r+")"},e.__name__="Line",e}(h);n.Line=u,u.prototype.attrs=Object.keys(r.line());var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.set_value=function(t){t.fillStyle=this.fill_color.value(),t.globalAlpha=this.fill_alpha.value()},Object.defineProperty(e.prototype,"doit",{get:function(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)},enumerable:!0,configurable:!0}),e.prototype._set_vectorize=function(t,e){this.cache_select("fill_color",e),t.fillStyle!==this.cache.fill_color&&(t.fillStyle=this.cache.fill_color),this.cache_select("fill_alpha",e),t.globalAlpha!==this.cache.fill_alpha&&(t.globalAlpha=this.cache.fill_alpha)},e.prototype.color_value=function(){var t=o.color2rgba(this.fill_color.value(),this.fill_alpha.value()),e=t[0],n=t[1],i=t[2],r=t[3];return"rgba("+255*e+","+255*n+","+255*i+","+r+")"},e.__name__="Fill",e}(h);n.Fill=_,_.prototype.attrs=Object.keys(r.fill());var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.cache_select=function(e,n){var i;if("pattern"==e){this.cache_select("hatch_color",n),this.cache_select("hatch_scale",n),this.cache_select("hatch_pattern",n),this.cache_select("hatch_weight",n);var r=this.cache,o=r.hatch_color,s=r.hatch_scale,a=r.hatch_pattern,l=r.hatch_weight,h=r.hatch_extra;if(null!=h&&h.hasOwnProperty(a)){var u=h[a];this.cache.pattern=u.get_pattern(o,s,l)}else this.cache.pattern=function(t){var e=c(a,o,s,l);return t.createPattern(e,"repeat")}}else i=t.prototype.cache_select.call(this,e,n);return i},e.prototype._try_defer=function(t){var e=this.cache,n=e.hatch_pattern,i=e.hatch_extra;if(null!=i&&i.hasOwnProperty(n)){var r=i[n];r.onload(t)}},Object.defineProperty(e.prototype,"doit",{get:function(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)},enumerable:!0,configurable:!0}),e.prototype.doit2=function(t,e,n,i){if(this.doit){this.cache_select("pattern",e);var r=this.cache.pattern(t);null==r?this._try_defer(i):(this.set_vectorize(t,e),n())}},e.prototype._set_vectorize=function(t,e){this.cache_select("pattern",e),t.fillStyle=this.cache.pattern(t),this.cache_select("hatch_alpha",e),t.globalAlpha!==this.cache.hatch_alpha&&(t.globalAlpha=this.cache.hatch_alpha)},e.prototype.color_value=function(){var t=o.color2rgba(this.hatch_color.value(),this.hatch_alpha.value()),e=t[0],n=t[1],i=t[2],r=t[3];return"rgba("+255*e+","+255*n+","+255*i+","+r+")"},e.__name__="Hatch",e}(h);n.Hatch=d,d.prototype.attrs=Object.keys(r.hatch());var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.cache_select=function(e,n){var i;if("font"==e){t.prototype.cache_select.call(this,"text_font_style",n),t.prototype.cache_select.call(this,"text_font_size",n),t.prototype.cache_select.call(this,"text_font",n);var r=this.cache,o=r.text_font_style,s=r.text_font_size,a=r.text_font;this.cache.font=i=o+" "+s+" "+a}else i=t.prototype.cache_select.call(this,e,n);return i},e.prototype.font_value=function(){var t=this.text_font.value(),e=this.text_font_size.value(),n=this.text_font_style.value();return n+" "+e+" "+t},e.prototype.color_value=function(){var t=o.color2rgba(this.text_color.value(),this.text_alpha.value()),e=t[0],n=t[1],i=t[2],r=t[3];return"rgba("+255*e+","+255*n+","+255*i+","+r+")"},e.prototype.set_value=function(t){t.font=this.font_value(),t.fillStyle=this.text_color.value(),t.globalAlpha=this.text_alpha.value(),t.textAlign=this.text_align.value(),t.textBaseline=this.text_baseline.value()},Object.defineProperty(e.prototype,"doit",{get:function(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)},enumerable:!0,configurable:!0}),e.prototype._set_vectorize=function(t,e){this.cache_select("font",e),t.font!==this.cache.font&&(t.font=this.cache.font),this.cache_select("text_color",e),t.fillStyle!==this.cache.text_color&&(t.fillStyle=this.cache.text_color),this.cache_select("text_alpha",e),t.globalAlpha!==this.cache.text_alpha&&(t.globalAlpha=this.cache.text_alpha),this.cache_select("text_align",e),t.textAlign!==this.cache.text_align&&(t.textAlign=this.cache.text_align),this.cache_select("text_baseline",e),t.textBaseline!==this.cache.text_baseline&&(t.textBaseline=this.cache.text_baseline)},e.__name__="Text",e}(h);n.Text=p,p.prototype.attrs=Object.keys(r.text());var f=function(){function t(t){for(var e=0,n=t.mixins;e<n.length;e++){var i=n[e],r=i.split(":"),o=r[0],s=r[1],a=void 0===s?"":s,l=void 0;switch(o){case"line":l=u;break;case"fill":l=_;break;case"hatch":l=d;break;case"text":l=p;break;default:throw new Error("unknown visual: "+o)}this[a+o]=new l(t,a)}}return t.prototype.warm_cache=function(t){for(var e in this)if(this.hasOwnProperty(e)){var n=this[e];n instanceof h&&n.warm_cache(t)}},t.prototype.set_all_indices=function(t){for(var e in this)if(this.hasOwnProperty(e)){var n=this[e];n instanceof h&&(n.all_indices=t)}},t.__name__="Visuals",t}();n.Visuals=f},function(t,e,n){var i=t(421),r=t(0),o=t(317),s=t(17),a=t(3),l=t(8),c=t(22),h=t(37),u=t(38),_=t(32),d=t(24),p=t(35),f=t(33),m=t(46),v=t(166),g=t(212),y=t(62),b=t(53),w=function(){function t(t){this.document=t,this.session=null,this.subscribed_models=new _.Set}return t.prototype.send_event=function(t){null!=this.session&&this.session.send_event(t)},t.prototype.trigger=function(t){for(var e=0,n=this.subscribed_models.values;e<n.length;e++){var i=n[e];if(null==t.origin||t.origin.id===i){var r=this.document._all_models[i];null!=r&&r instanceof y.Model&&r._process_event(t)}}},t.__name__="EventManager",t}();n.EventManager=w,n.documents=[],n.DEFAULT_TITLE="Bokeh Application";var x=function(){function t(){n.documents.push(this),this._init_timestamp=Date.now(),this._title=n.DEFAULT_TITLE,this._roots=[],this._all_models={},this._all_models_by_name=new _.MultiDict,this._all_models_freeze_count=0,this._callbacks=[],this.event_manager=new w(this),this.idle=new c.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}return Object.defineProperty(t.prototype,"layoutables",{get:function(){return this._roots.filter(function(t){return t instanceof v.LayoutDOM})},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_idle",{get:function(){for(var t=0,e=this.layoutables;t<e.length;t++){var n=e[t];if(!this._idle_roots.has(n))return!1}return!0},enumerable:!0,configurable:!0}),t.prototype.notify_idle=function(t){this._idle_roots.set(t,!0),this.is_idle&&(s.logger.info("document idle at "+(Date.now()-this._init_timestamp)+" ms"),this.idle.emit())},t.prototype.clear=function(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}},t.prototype.interactive_start=function(t){null==this._interactive_plot&&(this._interactive_plot=t,this._interactive_plot.trigger_event(new a.LODStart)),this._interactive_timestamp=Date.now()},t.prototype.interactive_stop=function(t){null!=this._interactive_plot&&this._interactive_plot.id===t.id&&this._interactive_plot.trigger_event(new a.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null},t.prototype.interactive_duration=function(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp},t.prototype.destructively_move=function(t){if(t===this)throw new Error("Attempted to overwrite a document with itself");t.clear();var e=d.copy(this._roots);this.clear();for(var n=0,i=e;n<i.length;n++){var r=i[n];if(null!=r.document)throw new Error("Somehow we didn't detach "+r)}if(0!==Object.keys(this._all_models).length)throw new Error("this._all_models still had stuff in it: "+this._all_models);for(var o=0,s=e;o<s.length;o++){var r=s[o];t.add_root(r)}t.set_title(this._title)},t.prototype._push_all_models_freeze=function(){this._all_models_freeze_count+=1},t.prototype._pop_all_models_freeze=function(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()},t.prototype._invalidate_all_models=function(){s.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()},t.prototype._recompute_all_models=function(){for(var t=new _.Set,e=0,n=this._roots;e<n.length;e++){var i=n[e];t=t.union(i.references())}for(var r=new _.Set(p.values(this._all_models)),o=r.diff(t),s=t.diff(r),a={},l=0,c=t.values;l<c.length;l++){var h=c[l];a[h.id]=h}for(var u=0,d=o.values;u<d.length;u++){var f=d[u];f.detach_document(),f instanceof y.Model&&null!=f.name&&this._all_models_by_name.remove_value(f.name,f)}for(var m=0,v=s.values;m<v.length;m++){var g=v[m];g.attach_document(this),g instanceof y.Model&&null!=g.name&&this._all_models_by_name.add_value(g.name,g)}this._all_models=a},t.prototype.roots=function(){return this._roots},t.prototype.add_root=function(t,e){if(s.logger.debug("Adding root: "+t),!d.includes(this._roots,t)){this._push_all_models_freeze();try{this._roots.push(t)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new b.RootAddedEvent(this,t,e))}},t.prototype.remove_root=function(t,e){var n=this._roots.indexOf(t);if(!(n<0)){this._push_all_models_freeze();try{this._roots.splice(n,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new b.RootRemovedEvent(this,t,e))}},t.prototype.title=function(){return this._title},t.prototype.set_title=function(t,e){t!==this._title&&(this._title=t,this._trigger_on_change(new b.TitleChangedEvent(this,t,e)))},t.prototype.get_model_by_id=function(t){return t in this._all_models?this._all_models[t]:null},t.prototype.get_model_by_name=function(t){return this._all_models_by_name.get_one(t,"Multiple models are named '"+t+"'")},t.prototype.on_change=function(t){d.includes(this._callbacks,t)||this._callbacks.push(t)},t.prototype.remove_on_change=function(t){var e=this._callbacks.indexOf(t);e>=0&&this._callbacks.splice(e,1)},t.prototype._trigger_on_change=function(t){for(var e=0,n=this._callbacks;e<n.length;e++){var i=n[e];i(t)}},t.prototype._notify_change=function(t,e,n,i,r){"name"===e&&(this._all_models_by_name.remove_value(n,t),null!=i&&this._all_models_by_name.add_value(i,t));var o=null!=r?r.setter_id:void 0,s=null!=r?r.hint:void 0;this._trigger_on_change(new b.ModelChangedEvent(this,t,e,n,i,o,s))},t._references_json=function(t,e){void 0===e&&(e=!0);for(var n=[],i=0,r=t;i<r.length;i++){var o=r[i],s=o.ref();s.attributes=o.attributes_as_json(e),delete s.attributes.id,n.push(s)}return n},t._instantiate_object=function(t,e,n){var o=i.__assign({},n,{id:t,__deferred__:!0}),s=r.Models(e);return new s(o)},t._instantiate_references_json=function(e,n){for(var i={},r=0,o=e;r<o.length;r++){var s=o[r],a=s.id,l=s.type,c=s.attributes||{},h=void 0;a in n?h=n[a]:(h=t._instantiate_object(a,l,c),null!=s.subtype&&h.set_subtype(s.subtype)),i[h.id]=h}return i},t._resolve_refs=function(t,e,n){function i(t){if(h.is_ref(t)){if(t.id in e)return e[t.id];if(t.id in n)return n[t.id];throw new Error("reference "+JSON.stringify(t)+" isn't known (not in Document?)")}return m.isArray(t)?function(t){for(var e=[],n=0,r=t;n<r.length;n++){var o=r[n];e.push(i(o))}return e}(t):m.isPlainObject(t)?function(t){var e={};for(var n in t){var r=t[n];e[n]=i(r)}return e}(t):t}return i(t)},t._initialize_references_json=function(e,n,i){for(var r={},o=0,s=e;o<s.length;o++){var a=s[o],c=a.id,h=a.attributes,u=!(c in n),_=u?i[c]:n[c],d=t._resolve_refs(h,n,i);r[_.id]=[_,d,u]}function p(t,e){var n={};function i(r){if(r instanceof l.HasProps){if(!(r.id in n)&&r.id in t){n[r.id]=!0;var o=t[r.id],s=o[1],a=o[2];for(var c in s){var h=s[c];i(h)}e(r,s,a)}}else if(m.isArray(r))for(var u=0,_=r;u<_.length;u++){var h=_[u];i(h)}else if(m.isPlainObject(r))for(var d in r){var h=r[d];i(h)}}for(var r in t){var o=t[r],s=o[0];i(s)}}p(r,function(t,e,n){n&&t.setv(e,{silent:!0})}),p(r,function(t,e,n){n&&t.finalize()})},t._event_for_attribute_change=function(t,e,n,i,r){var o=i.get_model_by_id(t.id);if(o.attribute_is_serializable(e)){var s={kind:"ModelChanged",model:{id:t.id,type:t.type},attr:e,new:n};return l.HasProps._json_record_references(i,n,r,!0),s}return null},t._events_to_sync_objects=function(e,n,i,r){for(var o=Object.keys(e.attributes),a=Object.keys(n.attributes),l=d.difference(o,a),c=d.difference(a,o),h=d.intersection(o,a),u=[],_=0,p=l;_<p.length;_++){var m=p[_];s.logger.warn("Server sent key "+m+" but we don't seem to have it in our JSON")}for(var v=0,g=c;v<g.length;v++){var m=g[v],y=n.attributes[m];u.push(t._event_for_attribute_change(e,m,y,i,r))}for(var b=0,w=h;b<w.length;b++){var m=w[b],x=e.attributes[m],y=n.attributes[m];null==x&&null==y||(null==x||null==y?u.push(t._event_for_attribute_change(e,m,y,i,r)):f.isEqual(x,y)||u.push(t._event_for_attribute_change(e,m,y,i,r)))}return u.filter(function(t){return null!=t})},t._compute_patch_since_json=function(e,n){var i=n.to_json(!1);function r(t){for(var e={},n=0,i=t.roots.references;n<i.length;n++){var r=i[n];e[r.id]=r}return e}for(var o=r(e),s={},a=[],l=0,c=e.roots.root_ids;l<c.length;l++){var h=c[l];s[h]=o[h],a.push(h)}for(var u=r(i),_={},f=[],m=0,v=i.roots.root_ids;m<v.length;m++){var h=v[m];_[h]=u[h],f.push(h)}if(a.sort(),f.sort(),d.difference(a,f).length>0||d.difference(f,a).length>0)throw new Error("Not implemented: computing add/remove of document roots");var g={},y=[];for(var b in n._all_models)if(b in o){var w=t._events_to_sync_objects(o[b],u[b],n,g);y=y.concat(w)}return{references:t._references_json(p.values(g),!1),events:y}},t.prototype.to_json_string=function(t){return void 0===t&&(t=!0),JSON.stringify(this.to_json(t))},t.prototype.to_json=function(e){void 0===e&&(e=!0);var n=this._roots.map(function(t){return t.id}),i=p.values(this._all_models);return{version:o.version,title:this._title,roots:{root_ids:n,references:t._references_json(i,e)}}},t.from_json_string=function(e){var n=JSON.parse(e);return t.from_json(n)},t.from_json=function(e){s.logger.debug("Creating Document from JSON");var n=e.version,i=-1!==n.indexOf("+")||-1!==n.indexOf("-"),r="Library versions: JS ("+o.version+") / Python ("+n+")";i||o.version===n?s.logger.debug(r):(s.logger.warn("JS/Python version mismatch"),s.logger.warn(r));var a=e.roots,l=a.root_ids,c=a.references,h=t._instantiate_references_json(c,{});t._initialize_references_json(c,{},h);for(var u=new t,_=0,d=l;_<d.length;_++){var p=d[_];u.add_root(h[p])}return u.set_title(e.title),u},t.prototype.replace_with_json=function(e){var n=t.from_json(e);n.destructively_move(this)},t.prototype.create_json_patch_string=function(t){return JSON.stringify(this.create_json_patch(t))},t.prototype.create_json_patch=function(e){for(var n={},i=[],r=0,o=e;r<o.length;r++){var a=o[r];if(a.document!==this)throw s.logger.warn("Cannot create a patch using events from a different document, event had ",a.document," we are ",this),new Error("Cannot create a patch using events from a different document");i.push(a.json(n))}return{events:i,references:t._references_json(p.values(n))}},t.prototype.apply_json_patch=function(e,n,i){var r;void 0===n&&(n=[]);for(var o=e.references,a=e.events,l=t._instantiate_references_json(o,this._all_models),c=0,h=a;c<h.length;c++){var _=h[c];switch(_.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":var d=_.model.id;if(d in this._all_models)l[d]=this._all_models[d];else if(!(d in l))throw s.logger.warn("Got an event for unknown model ",_.model),new Error("event model wasn't known")}}var p={},f={};for(var m in l){var v=l[m];m in this._all_models?p[m]=v:f[m]=v}t._initialize_references_json(o,p,f);for(var y=0,b=a;y<b.length;y++){var _=b[y];switch(_.kind){case"ModelChanged":var w=_.model.id;if(!(w in this._all_models))throw new Error("Cannot apply patch to "+w+" which is not in the document");var x=this._all_models[w],A=_.attr,k=_.model.type;if("data"===A&&"ColumnDataSource"===k){var C=u.decode_column_data(_.new,n),T=C[0],S=C[1];x.setv({_shapes:S,data:T},{setter_id:i})}else{var v=t._resolve_refs(_.new,p,f);x.setv(((r={})[A]=v,r),{setter_id:i})}break;case"ColumnDataChanged":var M=_.column_source.id;if(!(M in this._all_models))throw new Error("Cannot stream to "+M+" which is not in the document");var E=this._all_models[M],z=u.decode_column_data(_.new,n),T=z[0],S=z[1];if(null!=_.cols){for(var O in E.data)O in T||(T[O]=E.data[O]);for(var O in E._shapes)O in S||(S[O]=E._shapes[O])}E.setv({_shapes:S,data:T},{setter_id:i,check_eq:!1});break;case"ColumnsStreamed":var M=_.column_source.id;if(!(M in this._all_models))throw new Error("Cannot stream to "+M+" which is not in the document");var E=this._all_models[M];if(!(E instanceof g.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");var T=_.data,P=_.rollover;E.stream(T,P,i);break;case"ColumnsPatched":var M=_.column_source.id;if(!(M in this._all_models))throw new Error("Cannot patch "+M+" which is not in the document");var E=this._all_models[M];if(!(E instanceof g.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");var j=_.patches;E.patch(j,i);break;case"RootAdded":var N=_.model.id,I=l[N];this.add_root(I,i);break;case"RootRemoved":var N=_.model.id,I=l[N];this.remove_root(I,i);break;case"TitleChanged":this.set_title(_.title,i);break;default:throw new Error("Unknown patch event "+JSON.stringify(_))}}},t.__name__="Document",t}();n.Document=x},function(t,e,n){var i=t(421),r=t(8),o=function(){function t(t){this.document=t}return t.__name__="DocumentChangedEvent",t}();n.DocumentChangedEvent=o;var s=function(t){function e(e,n,i,r,o,s,a){var l=t.call(this,e)||this;return l.model=n,l.attr=i,l.old=r,l.new_=o,l.setter_id=s,l.hint=a,l}return i.__extends(e,t),e.prototype.json=function(t){if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(t);var e=this.new_,n=r.HasProps._value_to_json(this.attr,e,this.model),i={};for(var o in r.HasProps._value_record_references(e,i,!0),this.model.id in i&&this.model!==e&&delete i[this.model.id],i)t[o]=i[o];return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:n}},e.__name__="ModelChangedEvent",e}(o);n.ModelChangedEvent=s;var a=function(t){function e(e,n,i){var r=t.call(this,e)||this;return r.column_source=n,r.patches=i,r}return i.__extends(e,t),e.prototype.json=function(t){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}},e.__name__="ColumnsPatchedEvent",e}(o);n.ColumnsPatchedEvent=a;var l=function(t){function e(e,n,i,r){var o=t.call(this,e)||this;return o.column_source=n,o.data=i,o.rollover=r,o}return i.__extends(e,t),e.prototype.json=function(t){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}},e.__name__="ColumnsStreamedEvent",e}(o);n.ColumnsStreamedEvent=l;var c=function(t){function e(e,n,i){var r=t.call(this,e)||this;return r.title=n,r.setter_id=i,r}return i.__extends(e,t),e.prototype.json=function(t){return{kind:"TitleChanged",title:this.title}},e.__name__="TitleChangedEvent",e}(o);n.TitleChangedEvent=c;var h=function(t){function e(e,n,i){var r=t.call(this,e)||this;return r.model=n,r.setter_id=i,r}return i.__extends(e,t),e.prototype.json=function(t){return r.HasProps._value_record_references(this.model,t,!0),{kind:"RootAdded",model:this.model.ref()}},e.__name__="RootAddedEvent",e}(o);n.RootAddedEvent=h;var u=function(t){function e(e,n,i){var r=t.call(this,e)||this;return r.model=n,r.setter_id=i,r}return i.__extends(e,t),e.prototype.json=function(t){return{kind:"RootRemoved",model:this.model.ref()}},e.__name__="RootRemovedEvent",e}(o);n.RootRemovedEvent=u},function(t,e,n){var i=t(421);i.__exportStar(t(52),n),i.__exportStar(t(53),n)},function(t,e,n){var i=t(5),r=t(311);function o(t){var e=document.getElementById(t);if(null==e)throw new Error("Error rendering Bokeh model: could not find #"+t+" HTML tag");if(!document.body.contains(e))throw new Error("Error rendering Bokeh model: element #"+t+" must be under <body>");if("SCRIPT"==e.tagName){var r=i.div({class:n.BOKEH_ROOT});i.replaceWith(e,r),e=r}return e}n.BOKEH_ROOT=r.bk_root,n._resolve_element=function(t){var e=t.elementid;return null!=e?o(e):document.body},n._resolve_root_elements=function(t){var e={};if(null!=t.roots)for(var n in t.roots)e[n]=o(t.roots[n]);return e}},function(t,e,n){var i=t(54),r=t(17),o=t(28),s=t(40),a=t(46),l=t(59),c=t(58),h=t(55),u=t(59);n.add_document_standalone=u.add_document_standalone,n.index=u.index;var _=t(58);n.add_document_from_session=_.add_document_from_session;var d=t(57);n.embed_items_notebook=d.embed_items_notebook,n.kernels=d.kernels;var p=t(55);function f(t,e,n,o){a.isString(t)&&(t=JSON.parse(s.unescape(t)));var u={};for(var _ in t){var d=t[_];u[_]=i.Document.from_json(d)}for(var p=0,f=e;p<f.length;p++){var m=f[p],v=h._resolve_element(m),g=h._resolve_root_elements(m);if(null!=m.docid)l.add_document_standalone(u[m.docid],v,g,m.use_for_title);else{if(null==m.sessionid)throw new Error("Error rendering Bokeh items: either 'docid' or 'sessionid' was expected.");var y=c._get_ws_url(n,o);r.logger.debug("embed: computed ws url: "+y);var b=c.add_document_from_session(y,m.sessionid,v,g,m.use_for_title);b.then(function(){console.log("Bokeh items were rendered successfully")},function(t){console.log("Error rendering Bokeh items:",t)})}}}n.BOKEH_ROOT=p.BOKEH_ROOT,n.embed_item=function(t,e){var n,i={},r=s.uuid4();i[r]=t.doc,null==e&&(e=t.target_id);var a=document.getElementById(e);null!=a&&a.classList.add(h.BOKEH_ROOT);var l={roots:((n={})[t.root_id]=e,n),docid:r};o.defer(function(){return f(i,[l])})},n.embed_items=function(t,e,n,i){o.defer(function(){return f(t,e,n,i)})}},function(t,e,n){var i=t(54),r=t(301),o=t(17),s=t(35),a=t(59),l=t(55);function c(t,e){e.buffers.length>0?t.consume(e.buffers[0].buffer):t.consume(e.content.data);var n=t.message;null!=n&&this.apply_json_patch(n.content,n.buffers)}function h(t,e){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){o.logger.info("Registering Jupyter comms for target "+t);var i=Jupyter.notebook.kernel.comm_manager;try{i.register_target(t,function(n){o.logger.info("Registering Jupyter comms for target "+t);var i=new r.Receiver;n.on_msg(c.bind(e,i))})}catch(t){o.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+t+")")}}else if(e.roots()[0].id in n.kernels){o.logger.info("Registering JupyterLab comms for target "+t);var s=n.kernels[e.roots()[0].id];try{s.registerCommTarget(t,function(n){o.logger.info("Registering JupyterLab comms for target "+t);var i=new r.Receiver;n.onMsg=c.bind(e,i)})}catch(t){o.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+t+")")}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest jupyterlab_bokeh extension is installed. In an exported notebook this warning is expected.")}t(307),t(310),n.kernels={},n.embed_items_notebook=function(t,e){if(1!=s.size(t))throw new Error("embed_items_notebook expects exactly one document in docs_json");for(var n=i.Document.from_json(s.values(t)[0]),r=0,o=e;r<o.length;r++){var c=o[r];null!=c.notebook_comms_target&&h(c.notebook_comms_target,n);var u=l._resolve_element(c),_=l._resolve_root_elements(c);a.add_document_standalone(n,u,_)}}},function(t,e,n){var i=t(1),r=t(17),o=t(59);n._get_ws_url=function(t,e){var n,i="ws:";return"https:"==window.location.protocol&&(i="wss:"),null!=e?(n=document.createElement("a")).href=e:n=window.location,null!=t?"/"==t&&(t=""):t=n.pathname.replace(/\/+$/,""),i+"//"+n.host+t+"/ws"};var s={};n.add_document_from_session=function(t,e,n,a,l){void 0===a&&(a={}),void 0===l&&(l=!1);var c=window.location.search.substr(1);return function(t,e,n){t in s||(s[t]={});var r=s[t];return e in r||(r[e]=i.pull_session(t,e,n)),r[e]}(t,e,c).then(function(t){return o.add_document_standalone(t.document,n,a,l)},function(t){throw r.logger.error("Failed to load Bokeh session "+e+": "+t),t})}},function(t,e,n){var i=t(54),r=t(5),o=t(55);n.index={},n.add_document_standalone=function(t,e,s,a){void 0===s&&(s={}),void 0===a&&(a=!1);var l={};function c(t){var i;t.id in s?i=s[t.id]:e.classList.contains(o.BOKEH_ROOT)?i=e:(i=r.div({class:o.BOKEH_ROOT}),e.appendChild(i));var a=function(t){var e=new t.default_view({model:t,parent:null});return n.index[t.id]=e,e}(t);a.renderTo(i),l[t.id]=a}for(var h=0,u=t.roots();h<u.length;h++){var _=u[h];c(_)}return a&&(window.document.title=t.title()),t.on_change(function(t){t instanceof i.RootAddedEvent?c(t.model):t instanceof i.RootRemovedEvent?function(t){var e=t.id;if(e in l){var i=l[e];i.remove(),delete l[e],delete n.index[e]}}(t.model):a&&t instanceof i.TitleChangedEvent&&(window.document.title=t.title)}),l}},function(t,e,n){t(298);var i=t(317);n.version=i.version;var r=t(56);n.embed=r;var o=t(56);n.index=o.index;var s=t(299);n.protocol=s;var a=t(316);n._testing=a;var l=t(17);n.logger=l.logger,n.set_log_level=l.set_log_level;var c=t(21);n.settings=c.settings;var h=t(0);n.Models=h.Models;var u=t(54);n.documents=u.documents;var _=t(302);n.safely=_.safely},function(t,e,n){var i=t(421);i.__exportStar(t(60),n)},function(t,e,n){var i=t(421),r=t(8),o=t(18),s=t(46),a=t(35),l=t(17),c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({tags:[o.Array,[]],name:[o.String],js_property_callbacks:[o.Any,{}],js_event_callbacks:[o.Any,{}],subscribed_events:[o.Array,[]]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,function(){return e._update_property_callbacks()}),this.connect(this.properties.js_event_callbacks.change,function(){return e._update_event_callbacks()}),this.connect(this.properties.subscribed_events.change,function(){return e._update_event_callbacks()})},e.prototype._process_event=function(t){for(var e=0,n=this.js_event_callbacks[t.event_name]||[];e<n.length;e++){var i=n[e];i.execute(t)}null!=this.document&&this.subscribed_events.some(function(e){return e==t.event_name})&&this.document.event_manager.send_event(t)},e.prototype.trigger_event=function(t){null!=this.document&&(t.origin=this,this.document.event_manager.trigger(t))},e.prototype._update_event_callbacks=function(){null!=this.document?this.document.event_manager.subscribed_models.add(this.id):l.logger.warn("WARNING: Document not defined for updating event callbacks")},e.prototype._update_property_callbacks=function(){var t=this,e=function(e){var n=e.split(":"),i=n[0],r=n[1],o=void 0===r?null:r;return null!=o?t.properties[o][i]:t[i]};for(var n in this._js_callbacks)for(var i=this._js_callbacks[n],r=e(n),o=0,s=i;o<s.length;o++){var a=s[o];this.disconnect(r,a)}for(var l in this._js_callbacks={},this.js_property_callbacks){var i=this.js_property_callbacks[l],c=i.map(function(e){return function(){return e.execute(t)}});this._js_callbacks[l]=c;for(var r=e(l),h=0,u=c;h<u.length;h++){var a=u[h];this.connect(r,a)}}},e.prototype._doc_attached=function(){a.isEmpty(this.js_event_callbacks)&&a.isEmpty(this.subscribed_events)||this._update_event_callbacks()},e.prototype.select=function(t){if(s.isString(t))return this.references().filter(function(n){return n instanceof e&&n.name===t});if(t.prototype instanceof r.HasProps)return this.references().filter(function(e){return e instanceof t});throw new Error("invalid selector")},e.prototype.select_one=function(t){var e=this.select(t);switch(e.length){case 0:return null;case 1:return e[0];default:throw new Error("found more than one object matching given selector")}},e.__name__="Model",e}(r.HasProps);n.Model=c,c.initClass()},function(t,e,n){var i=t(421),r=t(36),o=t(35),s=t(201),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"panel",{get:function(){return this.layout},enumerable:!0,configurable:!0}),e.prototype.get_size=function(){if(this.model.visible){var t=this._get_size(),e=t.width,n=t.height;return{width:Math.round(e),height:Math.round(n)}}return{width:0,height:0}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties;this.on_change(n.visible,function(){return e.plot_view.request_layout()})},e.prototype._get_size=function(){throw new Error("not implemented")},Object.defineProperty(e.prototype,"ctx",{get:function(){return this.plot_view.canvas_view.ctx},enumerable:!0,configurable:!0}),e.prototype.set_data=function(t){var e,n,i=this.model.materialize_dataspecs(t);o.extend(this,i),this.plot_model.use_map&&(null!=this._x&&(e=r.project_xy(this._x,this._y),this._x=e[0],this._y=e[1]),null!=this._xs&&(n=r.project_xsys(this._xs,this._ys),this._xs=n[0],this._ys=n[1]))},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null==this.layout},enumerable:!0,configurable:!0}),e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this);return null==this.layout?e:i.__assign({},e,{bbox:this.layout.bbox.box})},e.__name__="AnnotationView",e}(s.RendererView);n.AnnotationView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.override({level:"annotation"})},e.__name__="Annotation",e}(s.Renderer);n.Annotation=l,l.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(65),s=t(212),a=t(18),l=t(34),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.model.source&&(this.model.source=new s.ColumnDataSource),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.streaming,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.patching,function(){return e.set_data(e.model.source)})},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,n,i,r=this.plot_view.frame;return"data"==this.model.start_units?(t=r.xscales[this.model.x_range_name].v_compute(this._x_start),e=r.yscales[this.model.y_range_name].v_compute(this._y_start)):(t=r.xview.v_compute(this._x_start),e=r.yview.v_compute(this._y_start)),"data"==this.model.end_units?(n=r.xscales[this.model.x_range_name].v_compute(this._x_end),i=r.yscales[this.model.y_range_name].v_compute(this._y_end)):(n=r.xview.v_compute(this._x_end),i=r.yview.v_compute(this._y_end)),[[t,e],[n,i]]},e.prototype.render=function(){if(this.model.visible){var t=this.plot_view.canvas_view.ctx;t.save();var e=this._map_data(),n=e[0],i=e[1];null!=this.model.end&&this._arrow_head(t,"render",this.model.end,n,i),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,i,n),t.beginPath();var r=this.plot_view.layout.bbox,o=r.x,s=r.y,a=r.width,l=r.height;t.rect(o,s,a,l),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,n,i),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,i,n),t.closePath(),t.clip(),this._arrow_body(t,n,i),t.restore()}},e.prototype._arrow_head=function(t,e,n,i,r){for(var o=0,s=this._x_start.length;o<s;o++){var a=Math.PI/2+l.atan2([i[0][o],i[1][o]],[r[0][o],r[1][o]]);t.save(),t.translate(r[0][o],r[1][o]),t.rotate(a),"render"==e?n.render(t,o):"clip"==e&&n.clip(t,o),t.restore()}},e.prototype._arrow_body=function(t,e,n){if(this.visuals.line.doit)for(var i=0,r=this._x_start.length;i<r;i++)this.visuals.line.set_vectorize(t,i),t.beginPath(),t.moveTo(e[0][i],e[1][i]),t.lineTo(n[0][i],n[1][i]),t.stroke()},e.__name__="ArrowView",e}(r.AnnotationView);n.ArrowView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.mixins(["line"]),this.define({x_start:[a.NumberSpec],y_start:[a.NumberSpec],start_units:[a.SpatialUnits,"data"],start:[a.Instance,null],x_end:[a.NumberSpec],y_end:[a.NumberSpec],end_units:[a.SpatialUnits,"data"],end:[a.Instance,function(){return new o.OpenHead({})}],source:[a.Instance],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]})},e.__name__="Arrow",e}(r.Annotation);n.Arrow=h,h.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(51),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({size:[s.Number,25]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals=new o.Visuals(this)},e.__name__="ArrowHead",e}(r.Annotation);n.ArrowHead=a,a.initClass();var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.mixins(["line"])},e.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(0,0),t.lineTo(.5*this.size,this.size)},e.prototype.render=function(t,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.stroke())},e.__name__="OpenHead",e}(a);n.OpenHead=l,l.initClass();var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.mixins(["line","fill"]),this.override({fill_color:"black"})},e.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(.5*this.size,this.size)},e.prototype.render=function(t,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,e),this._normal(t,e),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),this._normal(t,e),t.stroke())},e.prototype._normal=function(t,e){t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.closePath()},e.__name__="NormalHead",e}(a);n.NormalHead=c,c.initClass();var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.mixins(["line","fill"]),this.override({fill_color:"black"})},e.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(0,.5*this.size),t.lineTo(.5*this.size,this.size)},e.prototype.render=function(t,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,e),this._vee(t,e),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),this._vee(t,e),t.stroke())},e.prototype._vee=function(t,e){t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.lineTo(0,.5*this.size),t.closePath()},e.__name__="VeeHead",e}(a);n.VeeHead=h,h.initClass();var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.mixins(["line"])},e.prototype.render=function(t,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(.5*this.size,0),t.lineTo(-.5*this.size,0),t.stroke())},e.prototype.clip=function(t,e){},e.__name__="TeeHead",e}(a);n.TeeHead=u,u.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(212),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.patching,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.change,function(){return e.set_data(e.model.source)})},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,n,i=this.plot_view.frame,r=this.model.dimension,o=i.xscales[this.model.x_range_name],s=i.yscales[this.model.y_range_name],a="height"==r?s:o,l="height"==r?o:s,c="height"==r?i.yview:i.xview,h="height"==r?i.xview:i.yview;t="data"==this.model.properties.lower.units?a.v_compute(this._lower):c.v_compute(this._lower),e="data"==this.model.properties.upper.units?a.v_compute(this._upper):c.v_compute(this._upper),n="data"==this.model.properties.base.units?l.v_compute(this._base):h.v_compute(this._base);var u="height"==r?[1,0]:[0,1],_=u[0],d=u[1],p=[t,n],f=[e,n];this._lower_sx=p[_],this._lower_sy=p[d],this._upper_sx=f[_],this._upper_sy=f[d]},e.prototype.render=function(){if(this.model.visible){this._map_data();var t=this.plot_view.canvas_view.ctx;t.beginPath(),t.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var e=0,n=this._lower_sx.length;e<n;e++)t.lineTo(this._lower_sx[e],this._lower_sy[e]);for(var i=this._upper_sx.length-1,e=i;e>=0;e--)t.lineTo(this._upper_sx[e],this._upper_sy[e]);t.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(t),t.fill()),t.beginPath(),t.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var e=0,n=this._lower_sx.length;e<n;e++)t.lineTo(this._lower_sx[e],this._lower_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke()),t.beginPath(),t.moveTo(this._upper_sx[0],this._upper_sy[0]);for(var e=0,n=this._upper_sx.length;e<n;e++)t.lineTo(this._upper_sx[e],this._upper_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke())}},e.__name__="BandView",e}(r.AnnotationView);n.BandView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({lower:[s.DistanceSpec],upper:[s.DistanceSpec],base:[s.DistanceSpec],dimension:[s.Dimension,"height"],source:[s.Instance,function(){return new o.ColumnDataSource}],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e.__name__="Band",e}(r.Annotation);n.Band=l,l.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(22),s=t(5),a=t(18),l=t(27),c=t(303);n.EDGE_TOLERANCE=2.5;var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_overlays.appendChild(this.el),this.el.classList.add(c.bk_shading),s.undisplay(this.el)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.data_update,function(){return e.render()})):(this.connect(this.model.change,function(){return e.plot_view.request_render()}),this.connect(this.model.data_update,function(){return e.plot_view.request_render()}))},e.prototype.render=function(){var t=this;if(this.model.visible||"css"!=this.model.render_mode||s.undisplay(this.el),this.model.visible)if(null!=this.model.left||null!=this.model.right||null!=this.model.top||null!=this.model.bottom){var e=this.plot_view.frame,n=e.xscales[this.model.x_range_name],i=e.yscales[this.model.y_range_name],r=function(e,n,i,r,o){return null!=e?t.model.screen?e:"data"==n?i.compute(e):r.compute(e):o};this.sleft=r(this.model.left,this.model.left_units,n,e.xview,e._left.value),this.sright=r(this.model.right,this.model.right_units,n,e.xview,e._right.value),this.stop=r(this.model.top,this.model.top_units,i,e.yview,e._top.value),this.sbottom=r(this.model.bottom,this.model.bottom_units,i,e.yview,e._bottom.value);var o="css"==this.model.render_mode?this._css_box.bind(this):this._canvas_box.bind(this);o(this.sleft,this.sright,this.sbottom,this.stop)}else s.undisplay(this.el)},e.prototype._css_box=function(t,e,n,i){var r=this.model.properties.line_width.value(),o=Math.floor(e-t)-r,a=Math.floor(n-i)-r;this.el.style.left=t+"px",this.el.style.width=o+"px",this.el.style.top=i+"px",this.el.style.height=a+"px",this.el.style.borderWidth=r+"px",this.el.style.borderColor=this.model.properties.line_color.value(),this.el.style.backgroundColor=this.model.properties.fill_color.value(),this.el.style.opacity=this.model.properties.fill_alpha.value();var l=this.model.properties.line_dash.value().length<2?"solid":"dashed";this.el.style.borderStyle=l,s.display(this.el)},e.prototype._canvas_box=function(t,e,n,i){var r=this.plot_view.canvas_view.ctx;r.save(),r.beginPath(),r.rect(t,i,e-t,n-i),this.visuals.fill.set_value(r),r.fill(),this.visuals.line.set_value(r),r.stroke(),r.restore()},e.prototype.interactive_bbox=function(){var t=this.model.properties.line_width.value()+n.EDGE_TOLERANCE;return new l.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})},e.prototype.interactive_hit=function(t,e){if(null==this.model.in_cursor)return!1;var n=this.interactive_bbox();return n.contains(t,e)},e.prototype.cursor=function(t,e){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(e-this.sbottom)<3||Math.abs(e-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&e>this.stop&&e<this.sbottom?this.model.in_cursor:null},e.__name__="BoxAnnotationView",e}(r.AnnotationView);n.BoxAnnotationView=h;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({render_mode:[a.RenderMode,"canvas"],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"],top:[a.Number,null],top_units:[a.SpatialUnits,"data"],bottom:[a.Number,null],bottom_units:[a.SpatialUnits,"data"],left:[a.Number,null],left_units:[a.SpatialUnits,"data"],right:[a.Number,null],right_units:[a.SpatialUnits,"data"]}),this.internal({screen:[a.Boolean,!1],ew_cursor:[a.String,null],ns_cursor:[a.String,null],in_cursor:[a.String,null]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new o.Signal0(this,"data_update")},e.prototype.update=function(t){var e=t.left,n=t.right,i=t.top,r=t.bottom;this.setv({left:e,right:n,top:i,bottom:r,screen:!0},{silent:!0}),this.data_update.emit()},e.__name__="BoxAnnotation",e}(r.Annotation);n.BoxAnnotation=u,u.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(225),s=t(107),a=t(178),l=t(204),c=t(205),h=t(195),u=t(18),_=t(43),d=t(24),p=t(25),f=t(35),m=t(46),v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._set_canvas_image()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.visible.change,function(){return e.plot_view.request_render()}),this.connect(this.model.ticker.change,function(){return e.plot_view.request_render()}),this.connect(this.model.formatter.change,function(){return e.plot_view.request_render()}),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,function(){e._set_canvas_image(),e.plot_view.request_render()})},e.prototype._get_size=function(){if(null==this.model.color_mapper)return{width:0,height:0};var t=this.compute_legend_dimensions(),e=t.width,n=t.height;return{width:e,height:n}},e.prototype._set_canvas_image=function(){var t,e;if(null!=this.model.color_mapper){var n,i,r=this.model.color_mapper.palette;switch("vertical"==this.model.orientation&&(r=d.reversed(r)),this.model.orientation){case"vertical":t=[1,r.length],n=t[0],i=t[1];break;case"horizontal":e=[r.length,1],n=e[0],i=e[1];break;default:throw new Error("unreachable code")}var o=document.createElement("canvas");o.width=n,o.height=i;var s=o.getContext("2d"),l=s.getImageData(0,0,n,i),c=new a.LinearColorMapper({palette:r}).rgba_mapper,h=c.v_compute(d.range(0,r.length));l.data.set(h),s.putImageData(l,0,0),this.image=o}},e.prototype.compute_legend_dimensions=function(){var t,e,n=this._computed_image_dimensions(),i=[n.height,n.width],r=i[0],o=i[1],s=this._get_label_extent(),a=this._title_extent(),l=this._tick_extent(),c=this.model.padding;switch(this.model.orientation){case"vertical":t=r+a+2*c,e=o+l+s+2*c;break;case"horizontal":t=r+a+l+s+2*c,e=o+2*c;break;default:throw new Error("unreachable code")}return{width:e,height:t}},e.prototype.compute_legend_location=function(){var t,e,n=this.compute_legend_dimensions(),i=[n.height,n.width],r=i[0],o=i[1],s=this.model.margin,a=null!=this.panel?this.panel:this.plot_view.frame,l=a.bbox.ranges,c=l[0],h=l[1],u=this.model.location;if(m.isString(u))switch(u){case"top_left":t=c.start+s,e=h.start+s;break;case"top_center":t=(c.end+c.start)/2-o/2,e=h.start+s;break;case"top_right":t=c.end-s-o,e=h.start+s;break;case"bottom_right":t=c.end-s-o,e=h.end-s-r;break;case"bottom_center":t=(c.end+c.start)/2-o/2,e=h.end-s-r;break;case"bottom_left":t=c.start+s,e=h.end-s-r;break;case"center_left":t=c.start+s,e=(h.end+h.start)/2-r/2;break;case"center":t=(c.end+c.start)/2-o/2,e=(h.end+h.start)/2-r/2;break;case"center_right":t=c.end-s-o,e=(h.end+h.start)/2-r/2;break;default:throw new Error("unreachable code")}else{if(!m.isArray(u)||2!=u.length)throw new Error("unreachable code");var _=u[0],d=u[1];t=a.xview.compute(_),e=a.yview.compute(d)-r}return{sx:t,sy:e}},e.prototype.render=function(){if(this.model.visible&&null!=this.model.color_mapper){var t=this.plot_view.canvas_view.ctx;t.save();var e=this.compute_legend_location(),n=e.sx,i=e.sy;t.translate(n,i),this._draw_bbox(t);var r=this._get_image_offset();if(t.translate(r.x,r.y),this._draw_image(t),null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high){var o=this.tick_info();this._draw_major_ticks(t,o),this._draw_minor_ticks(t,o),this._draw_major_labels(t,o)}this.model.title&&this._draw_title(t),t.restore()}},e.prototype._draw_bbox=function(t){var e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_image=function(t){var e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_major_ticks=function(t,e){if(this.visuals.major_tick_line.doit){var n=this._normals(),i=n[0],r=n[1],o=this._computed_image_dimensions(),s=[o.width*i,o.height*r],a=s[0],l=s[1],c=e.coords.major,h=c[0],u=c[1],_=this.model.major_tick_in,d=this.model.major_tick_out;t.save(),t.translate(a,l),this.visuals.major_tick_line.set_value(t);for(var p=0,f=h.length;p<f;p++)t.beginPath(),t.moveTo(Math.round(h[p]+i*d),Math.round(u[p]+r*d)),t.lineTo(Math.round(h[p]-i*_),Math.round(u[p]-r*_)),t.stroke();t.restore()}},e.prototype._draw_minor_ticks=function(t,e){if(this.visuals.minor_tick_line.doit){var n=this._normals(),i=n[0],r=n[1],o=this._computed_image_dimensions(),s=[o.width*i,o.height*r],a=s[0],l=s[1],c=e.coords.minor,h=c[0],u=c[1],_=this.model.minor_tick_in,d=this.model.minor_tick_out;t.save(),t.translate(a,l),this.visuals.minor_tick_line.set_value(t);for(var p=0,f=h.length;p<f;p++)t.beginPath(),t.moveTo(Math.round(h[p]+i*d),Math.round(u[p]+r*d)),t.lineTo(Math.round(h[p]-i*_),Math.round(u[p]-r*_)),t.stroke();t.restore()}},e.prototype._draw_major_labels=function(t,e){if(this.visuals.major_label_text.doit){var n=this._normals(),i=n[0],r=n[1],o=this._computed_image_dimensions(),s=[o.width*i,o.height*r],a=s[0],l=s[1],c=this.model.label_standoff+this._tick_extent(),h=[c*i,c*r],u=h[0],_=h[1],d=e.coords.major,p=d[0],f=d[1],m=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(a+u,l+_);for(var v=0,g=p.length;v<g;v++)t.fillText(m[v],Math.round(p[v]+i*this.model.label_standoff),Math.round(f[v]+r*this.model.label_standoff));t.restore()}},e.prototype._draw_title=function(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())},e.prototype._get_label_extent=function(){var t,e=this.tick_info().labels.major;if(null==this.model.color_mapper.low||null==this.model.color_mapper.high||f.isEmpty(e))t=0;else{var n=this.plot_view.canvas_view.ctx;switch(n.save(),this.visuals.major_label_text.set_value(n),this.model.orientation){case"vertical":t=d.max(e.map(function(t){return n.measureText(t.toString()).width}));break;case"horizontal":t=_.measure_font(this.visuals.major_label_text.font_value()).height;break;default:throw new Error("unreachable code")}t+=this.model.label_standoff,n.restore()}return t},e.prototype._get_image_offset=function(){var t=this.model.padding,e=this.model.padding+this._title_extent();return{x:t,y:e}},e.prototype._normals=function(){return"vertical"==this.model.orientation?[1,0]:[0,1]},e.prototype._title_extent=function(){var t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style,e=this.model.title?_.measure_font(t).height+this.model.title_standoff:0;return e},e.prototype._tick_extent=function(){return null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high?d.max([this.model.major_tick_out,this.model.minor_tick_out]):0},e.prototype._computed_image_dimensions=function(){var t,e,n=this.plot_view.frame._height.value,i=this.plot_view.frame._width.value,r=this._title_extent();switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?t=n-2*this.model.padding-r:(t=d.max([25*this.model.color_mapper.palette.length,.3*n]),t=d.min([t,.8*n-2*this.model.padding-r])):t=this.model.height,e="auto"==this.model.width?25:this.model.width;break;case"horizontal":t="auto"==this.model.height?25:this.model.height,"auto"==this.model.width?null!=this.panel?e=i-2*this.model.padding:(e=d.max([25*this.model.color_mapper.palette.length,.3*i]),e=d.min([e,.8*i-2*this.model.padding])):e=this.model.width;break;default:throw new Error("unreachable code")}return{width:e,height:t}},e.prototype._tick_coordinate_scale=function(t){var e={source_range:new h.Range1d({start:this.model.color_mapper.low,end:this.model.color_mapper.high}),target_range:new h.Range1d({start:0,end:t})};switch(this.model.color_mapper.type){case"LinearColorMapper":return new l.LinearScale(e);case"LogColorMapper":return new c.LogScale(e);default:throw new Error("unreachable code")}},e.prototype._format_major_labels=function(t,e){for(var n=this.model.formatter.doFormat(t,null),i=0,r=e.length;i<r;i++)e[i]in this.model.major_label_overrides&&(n[i]=this.model.major_label_overrides[e[i]]);return n},e.prototype.tick_info=function(){var t,e=this._computed_image_dimensions();switch(this.model.orientation){case"vertical":t=e.height;break;case"horizontal":t=e.width;break;default:throw new Error("unreachable code")}for(var n=this._tick_coordinate_scale(t),i=this._normals(),r=i[0],o=i[1],s=[this.model.color_mapper.low,this.model.color_mapper.high],a=s[0],l=s[1],c=this.model.ticker.get_ticks(a,l,null,null,this.model.ticker.desired_num_ticks),h=c.major,u=c.minor,_=[[],[]],d=[[],[]],f=0,m=h.length;f<m;f++)h[f]<a||h[f]>l||(_[r].push(h[f]),_[o].push(0));for(var f=0,m=u.length;f<m;f++)u[f]<a||u[f]>l||(d[r].push(u[f]),d[o].push(0));var v={major:this._format_major_labels(_[r],h)},g={major:[[],[]],minor:[[],[]]};return g.major[r]=n.v_compute(_[r]),g.minor[r]=n.v_compute(d[r]),g.major[o]=_[o],g.minor[o]=d[o],"vertical"==this.model.orientation&&(g.major[r]=p.map(g.major[r],function(e){return t-e}),g.minor[r]=p.map(g.minor[r],function(e){return t-e})),{coords:g,labels:v}},e.__name__="ColorBarView",e}(r.AnnotationView);n.ColorBarView=v;var g=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=v,this.mixins(["text:major_label_","text:title_","line:major_tick_","line:minor_tick_","line:border_","line:bar_","fill:background_"]),this.define({location:[u.Any,"top_right"],orientation:[u.Orientation,"vertical"],title:[u.String],title_standoff:[u.Number,2],width:[u.Any,"auto"],height:[u.Any,"auto"],scale_alpha:[u.Number,1],ticker:[u.Instance,function(){return new o.BasicTicker}],formatter:[u.Instance,function(){return new s.BasicTickFormatter}],major_label_overrides:[u.Any,{}],color_mapper:[u.Instance],label_standoff:[u.Number,5],margin:[u.Number,30],padding:[u.Number,10],major_tick_in:[u.Number,5],major_tick_out:[u.Number,0],minor_tick_in:[u.Number,0],minor_tick_out:[u.Number,0]}),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"8pt",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"10pt",title_text_font_style:"italic"})},e.__name__="ColorBar",e}(r.Annotation);n.ColorBar=g,g.initClass()},function(t,e,n){var i=t(63);n.Annotation=i.Annotation;var r=t(64);n.Arrow=r.Arrow;var o=t(65);n.ArrowHead=o.ArrowHead;var s=t(65);n.OpenHead=s.OpenHead;var a=t(65);n.NormalHead=a.NormalHead;var l=t(65);n.TeeHead=l.TeeHead;var c=t(65);n.VeeHead=c.VeeHead;var h=t(66);n.Band=h.Band;var u=t(67);n.BoxAnnotation=u.BoxAnnotation;var _=t(68);n.ColorBar=_.ColorBar;var d=t(70);n.Label=d.Label;var p=t(71);n.LabelSet=p.LabelSet;var f=t(72);n.Legend=f.Legend;var m=t(73);n.LegendItem=m.LegendItem;var v=t(74);n.PolyAnnotation=v.PolyAnnotation;var g=t(75);n.Slope=g.Slope;var y=t(76);n.Span=y.Span;var b=t(77);n.TextAnnotation=b.TextAnnotation;var w=t(78);n.Title=w.Title;var x=t(79);n.ToolbarPanel=x.ToolbarPanel;var A=t(80);n.Tooltip=A.Tooltip;var k=t(81);n.Whisker=k.Whisker},function(t,e,n){var i=t(421),r=t(77),o=t(5),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals.warm_cache()},e.prototype._get_size=function(){var t=this.plot_view.canvas_view.ctx;this.visuals.text.set_value(t);var e=t.measureText(this.model.text),n=e.width,i=e.ascent;return{width:n,height:i}},e.prototype.render=function(){if(this.model.visible||"css"!=this.model.render_mode||o.undisplay(this.el),this.model.visible){var t;switch(this.model.angle_units){case"rad":t=-this.model.angle;break;case"deg":t=-this.model.angle*Math.PI/180;break;default:throw new Error("unreachable code")}var e=null!=this.panel?this.panel:this.plot_view.frame,n=this.plot_view.frame.xscales[this.model.x_range_name],i=this.plot_view.frame.yscales[this.model.y_range_name],r="data"==this.model.x_units?n.compute(this.model.x):e.xview.compute(this.model.x),s="data"==this.model.y_units?i.compute(this.model.y):e.yview.compute(this.model.y);r+=this.model.x_offset,s-=this.model.y_offset;var a="canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this);a(this.plot_view.canvas_view.ctx,this.model.text,r,s,t)}},e.__name__="LabelView",e}(r.TextAnnotationView);n.LabelView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[s.Number],x_units:[s.SpatialUnits,"data"],y:[s.Number],y_units:[s.SpatialUnits,"data"],text:[s.String],angle:[s.Angle,0],angle_units:[s.AngleUnits,"rad"],x_offset:[s.Number,0],y_offset:[s.Number,0],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})},e.__name__="Label",e}(r.TextAnnotation);n.Label=l,l.initClass()},function(t,e,n){var i=t(421),r=t(77),o=t(212),s=t(5),a=t(18),l=t(303),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){if(t.prototype.initialize.call(this),this.set_data(this.model.source),"css"==this.model.render_mode)for(var e=0,n=this._text.length;e<n;e++){var i=s.div({class:l.bk_annotation_child,style:{display:"none"}});this.el.appendChild(i)}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,function(){e.set_data(e.model.source),e.render()}),this.connect(this.model.source.streaming,function(){e.set_data(e.model.source),e.render()}),this.connect(this.model.source.patching,function(){e.set_data(e.model.source),e.render()}),this.connect(this.model.source.change,function(){e.set_data(e.model.source),e.render()})):(this.connect(this.model.change,function(){e.set_data(e.model.source),e.plot_view.request_render()}),this.connect(this.model.source.streaming,function(){e.set_data(e.model.source),e.plot_view.request_render()}),this.connect(this.model.source.patching,function(){e.set_data(e.model.source),e.plot_view.request_render()}),this.connect(this.model.source.change,function(){e.set_data(e.model.source),e.plot_view.request_render()}))},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e)},e.prototype._map_data=function(){var t=this.plot_view.frame.xscales[this.model.x_range_name],e=this.plot_view.frame.yscales[this.model.y_range_name],n=null!=this.panel?this.panel:this.plot_view.frame,i="data"==this.model.x_units?t.v_compute(this._x):n.xview.v_compute(this._x),r="data"==this.model.y_units?e.v_compute(this._y):n.yview.v_compute(this._y);return[i,r]},e.prototype.render=function(){if(this.model.visible||"css"!=this.model.render_mode||s.undisplay(this.el),this.model.visible)for(var t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),e=this.plot_view.canvas_view.ctx,n=this._map_data(),i=n[0],r=n[1],o=0,a=this._text.length;o<a;o++)t(e,o,this._text[o],i[o]+this._x_offset[o],r[o]-this._y_offset[o],this._angle[o])},e.prototype._get_size=function(){var t=this.plot_view.canvas_view.ctx;this.visuals.text.set_value(t);var e=t.measureText(this._text[0]),n=e.width,i=e.ascent;return{width:n,height:i}},e.prototype._v_canvas_text=function(t,e,n,i,r,o){this.visuals.text.set_vectorize(t,e);var s=this._calculate_bounding_box_dimensions(t,n);t.save(),t.beginPath(),t.translate(i,r),t.rotate(o),t.rect(s[0],s[1],s[2],s[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(n,0,0)),t.restore()},e.prototype._v_css_text=function(t,e,n,i,r,o){var a=this.el.children[e];a.textContent=n,this.visuals.text.set_vectorize(t,e);var l=this._calculate_bounding_box_dimensions(t,n),c=this.visuals.border_line.line_dash.value(),h=c.length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),a.style.position="absolute",a.style.left=i+l[0]+"px",a.style.top=r+l[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",o&&(a.style.transform="rotate("+o+"rad)"),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+h,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),s.display(a)},e.__name__="LabelSetView",e}(r.TextAnnotationView);n.LabelSetView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[a.NumberSpec],y:[a.NumberSpec],x_units:[a.SpatialUnits,"data"],y_units:[a.SpatialUnits,"data"],text:[a.StringSpec,{field:"text"}],angle:[a.AngleSpec,0],x_offset:[a.NumberSpec,{value:0}],y_offset:[a.NumberSpec,{value:0}],source:[a.Instance,function(){return new o.ColumnDataSource}],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})},e.__name__="LabelSet",e}(r.TextAnnotation);n.LabelSet=h,h.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(18),s=t(22),a=t(43),l=t(27),c=t(24),h=t(35),u=t(46),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.cursor=function(t,e){return"none"==this.model.click_policy?null:"pointer"},Object.defineProperty(e.prototype,"legend_padding",{get:function(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0},enumerable:!0,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.plot_view.request_render()}),this.connect(this.model.item_change,function(){return e.plot_view.request_render()})},e.prototype.compute_legend_bbox=function(){var t=this.model.get_legend_names(),e=this.model,n=e.glyph_height,i=e.glyph_width,r=this.model,o=r.label_height,s=r.label_width;this.max_label_height=c.max([a.measure_font(this.visuals.label_text.font_value()).height,o,n]);var _=this.plot_view.canvas_view.ctx;_.save(),this.visuals.label_text.set_value(_),this.text_widths={};for(var d=0,p=t;d<p.length;d++){var f=p[d];this.text_widths[f]=c.max([_.measureText(f).width,s])}this.visuals.title_text.set_value(_),this.title_height=this.model.title?a.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?_.measureText(this.model.title).width:0,_.restore();var m,v,g=Math.max(c.max(h.values(this.text_widths)),0),y=this.model.margin,b=this.legend_padding,w=this.model.spacing,x=this.model.label_standoff;if("vertical"==this.model.orientation)m=t.length*this.max_label_height+Math.max(t.length-1,0)*w+2*b+this.title_height,v=c.max([g+i+x+2*b,this.title_width+2*b]);else{var A=2*b+Math.max(t.length-1,0)*w;for(var k in this.text_widths){var C=this.text_widths[k];A+=c.max([C,s])+i+x}v=c.max([this.title_width+2*b,A]),m=this.max_label_height+this.title_height+2*b}var T,S,M=null!=this.panel?this.panel:this.plot_view.frame,E=M.bbox.ranges,z=E[0],O=E[1],P=this.model.location;if(u.isString(P))switch(P){case"top_left":T=z.start+y,S=O.start+y;break;case"top_center":T=(z.end+z.start)/2-v/2,S=O.start+y;break;case"top_right":T=z.end-y-v,S=O.start+y;break;case"bottom_right":T=z.end-y-v,S=O.end-y-m;break;case"bottom_center":T=(z.end+z.start)/2-v/2,S=O.end-y-m;break;case"bottom_left":T=z.start+y,S=O.end-y-m;break;case"center_left":T=z.start+y,S=(O.end+O.start)/2-m/2;break;case"center":T=(z.end+z.start)/2-v/2,S=(O.end+O.start)/2-m/2;break;case"center_right":T=z.end-y-v,S=(O.end+O.start)/2-m/2;break;default:throw new Error("unreachable code")}else{if(!u.isArray(P)||2!=P.length)throw new Error("unreachable code");var j=P[0],N=P[1];T=M.xview.compute(j),S=M.yview.compute(N)-m}return new l.BBox({left:T,top:S,width:v,height:m})},e.prototype.interactive_bbox=function(){return this.compute_legend_bbox()},e.prototype.interactive_hit=function(t,e){var n=this.interactive_bbox();return n.contains(t,e)},e.prototype.on_hit=function(t,e){for(var n,i,r,o=this.model.glyph_width,s=this.legend_padding,a=this.model.spacing,c=this.model.label_standoff,h=r=s,u=this.compute_legend_bbox(),_="vertical"==this.model.orientation,d=0,p=this.model.items;d<p.length;d++)for(var f=p[d],m=f.get_labels_list_from_label_prop(),v=0,g=m;v<g.length;v++){var y=g[v],b=u.x+h,w=u.y+r+this.title_height,x=void 0,A=void 0;_?(n=[u.width-2*s,this.max_label_height],x=n[0],A=n[1]):(i=[this.text_widths[y]+o+c,this.max_label_height],x=i[0],A=i[1]);var k=new l.BBox({left:b,top:w,width:x,height:A});if(k.contains(t,e)){switch(this.model.click_policy){case"hide":for(var C=0,T=f.renderers;C<T.length;C++){var S=T[C];S.visible=!S.visible}break;case"mute":for(var M=0,E=f.renderers;M<E.length;M++){var S=E[M];S.muted=!S.muted}}return!0}_?r+=this.max_label_height+a:h+=this.text_widths[y]+o+c+a}return!1},e.prototype.render=function(){if(this.model.visible&&0!=this.model.items.length){for(var t=0,e=this.model.items;t<e.length;t++){var n=e[t];n.legend=this.model}var i=this.plot_view.canvas_view.ctx,r=this.compute_legend_bbox();i.save(),this._draw_legend_box(i,r),this._draw_legend_items(i,r),this.model.title&&this._draw_title(i,r),i.restore()}},e.prototype._draw_legend_box=function(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())},e.prototype._draw_legend_items=function(t,e){for(var n=this,i=this.model,r=i.glyph_width,o=i.glyph_height,s=this.legend_padding,a=this.model.spacing,l=this.model.label_standoff,h=s,u=s,_="vertical"==this.model.orientation,d=function(i){var d,f,m=i.get_labels_list_from_label_prop(),v=i.get_field_from_label_prop();if(0==m.length)return"continue";for(var g=function(){switch(n.model.click_policy){case"none":return!0;case"hide":return c.every(i.renderers,function(t){return t.visible});case"mute":return c.every(i.renderers,function(t){return!t.muted})}}(),y=0,b=m;y<b.length;y++){var w=b[y],x=e.x+h,A=e.y+u+p.title_height,k=x+r,C=A+o;_?u+=p.max_label_height+a:h+=p.text_widths[w]+r+l+a,p.visuals.label_text.set_value(t),t.fillText(w,k+l,A+p.max_label_height/2);for(var T=0,S=i.renderers;T<S.length;T++){var M=S[T],E=p.plot_view.renderer_views[M.id];E.draw_legend(t,x,k,A,C,v,w,i.index)}if(!g){var z=void 0,O=void 0;_?(d=[e.width-2*s,p.max_label_height],z=d[0],O=d[1]):(f=[p.text_widths[w]+r+l,p.max_label_height],z=f[0],O=f[1]),t.beginPath(),t.rect(x,A,z,O),p.visuals.inactive_fill.set_value(t),t.fill()}}},p=this,f=0,m=this.model.items;f<m.length;f++){var v=m[f];d(v)}},e.prototype._draw_title=function(t,e){this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())},e.prototype._get_size=function(){var t=this.compute_legend_bbox(),e=t.width,n=t.height;return{width:e+2*this.model.margin,height:n+2*this.model.margin}},e.__name__="LegendView",e}(r.AnnotationView);n.LegendView=_;var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.item_change=new s.Signal0(this,"item_change")},e.initClass=function(){this.prototype.default_view=_,this.mixins(["text:label_","text:title_","fill:inactive_","line:border_","fill:background_"]),this.define({orientation:[o.Orientation,"vertical"],location:[o.Any,"top_right"],title:[o.String],title_standoff:[o.Number,5],label_standoff:[o.Number,5],glyph_height:[o.Number,20],glyph_width:[o.Number,20],label_height:[o.Number,20],label_width:[o.Number,20],margin:[o.Number,10],padding:[o.Number,10],spacing:[o.Number,3],items:[o.Array,[]],click_policy:[o.Any,"none"]}),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"10pt",label_text_baseline:"middle",title_text_font_size:"10pt",title_text_font_style:"italic"})},e.prototype.get_legend_names=function(){for(var t=[],e=0,n=this.items;e<n.length;e++){var i=n[e],r=i.get_labels_list_from_label_prop();t.push.apply(t,r)}return t},e.__name__="Legend",e}(r.Annotation);n.Legend=d,d.initClass()},function(t,e,n){var i=t(421),r=t(62),o=t(213),s=t(49),a=t(18),l=t(17),c=t(24),h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({label:[a.StringSpec,null],renderers:[a.Array,[]],index:[a.Number,null]})},e.prototype._check_data_sources_on_renderers=function(){var t=this.get_field_from_label_prop();if(null!=t){if(this.renderers.length<1)return!1;var e=this.renderers[0].data_source;if(null!=e)for(var n=0,i=this.renderers;n<i.length;n++){var r=i[n];if(r.data_source!=e)return!1}}return!0},e.prototype._check_field_label_on_data_source=function(){var t=this.get_field_from_label_prop();if(null!=t){if(this.renderers.length<1)return!1;var e=this.renderers[0].data_source;if(null!=e&&!c.includes(e.columns(),t))return!1}return!0},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.legend=null,this.connect(this.change,function(){null!=e.legend&&e.legend.item_change.emit()});var n=this._check_data_sources_on_renderers();n||l.logger.error("Non matching data sources on legend item renderers");var i=this._check_field_label_on_data_source();i||l.logger.error("Bad column name on label: "+this.label)},e.prototype.get_field_from_label_prop=function(){var t=this.label;return s.isField(t)?t.field:null},e.prototype.get_labels_list_from_label_prop=function(){if(s.isValue(this.label)){var t=this.label.value;return null!=t?[t]:[]}var e=this.get_field_from_label_prop();if(null!=e){var n=void 0;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((n=this.renderers[0].data_source)instanceof o.ColumnarDataSource){var i=n.get_column(e);return null!=i?c.uniq(Array.from(i)):["Invalid field"]}}return[]},e.__name__="LegendItem",e}(r.Model);n.LegendItem=h,h.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(22),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.plot_view.request_render()}),this.connect(this.model.data_update,function(){return e.plot_view.request_render()})},e.prototype.render=function(){if(this.model.visible){var t=this.model,e=t.xs,n=t.ys;if(e.length==n.length&&!(e.length<3||n.length<3)){for(var i=this.plot_view.frame,r=this.plot_view.canvas_view.ctx,o=0,s=e.length;o<s;o++){var a=void 0;if("screen"!=this.model.xs_units)throw new Error("not implemented");a=this.model.screen?e[o]:i.xview.compute(e[o]);var l=void 0;if("screen"!=this.model.ys_units)throw new Error("not implemented");l=this.model.screen?n[o]:i.yview.compute(n[o]),0==o?(r.beginPath(),r.moveTo(a,l)):r.lineTo(a,l)}r.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(r),r.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(r),r.fill())}}},e.__name__="PolyAnnotationView",e}(r.AnnotationView);n.PolyAnnotationView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({xs:[s.Array,[]],xs_units:[s.SpatialUnits,"data"],ys:[s.Array,[]],ys_units:[s.SpatialUnits,"data"],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.internal({screen:[s.Boolean,!1]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new o.Signal0(this,"data_update")},e.prototype.update=function(t){var e=t.xs,n=t.ys;this.setv({xs:e,ys:n,screen:!0},{silent:!0}),this.data_update.emit()},e.__name__="PolyAnnotation",e}(r.Annotation);n.PolyAnnotation=l,l.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.plot_view.request_render()})},e.prototype.render=function(){this.model.visible&&this._draw_slope()},e.prototype._draw_slope=function(){var t=this.model.gradient,e=this.model.y_intercept;if(null!=t&&null!=e){var n=this.plot_view.frame,i=n.xscales[this.model.x_range_name],r=n.yscales[this.model.y_range_name],o=n._top.value,s=o+n._height.value,a=r.invert(o),l=r.invert(s),c=(a-e)/t,h=(l-e)/t,u=i.compute(c),_=i.compute(h),d=this.plot_view.canvas_view.ctx;d.save(),d.beginPath(),this.visuals.line.set_value(d),d.moveTo(u,o),d.lineTo(_,s),d.stroke(),d.restore()}},e.__name__="SlopeView",e}(r.AnnotationView);n.SlopeView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s,this.mixins(["line"]),this.define({gradient:[o.Number,null],y_intercept:[o.Number,null],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({line_color:"black"})},e.__name__="Slope",e}(r.Annotation);n.Slope=a,a.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(5),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_overlays.appendChild(this.el),this.el.style.position="absolute",o.undisplay(this.el)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.model.for_hover?this.connect(this.model.properties.computed_location.change,function(){return e._draw_span()}):"canvas"==this.model.render_mode?(this.connect(this.model.change,function(){return e.plot_view.request_render()}),this.connect(this.model.properties.location.change,function(){return e.plot_view.request_render()})):(this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.properties.location.change,function(){return e._draw_span()}))},e.prototype.render=function(){this.model.visible||"css"!=this.model.render_mode||o.undisplay(this.el),this.model.visible&&this._draw_span()},e.prototype._draw_span=function(){var t=this,e=this.model.for_hover?this.model.computed_location:this.model.location;if(null!=e){var n,i,r,s,a=this.plot_view.frame,l=a.xscales[this.model.x_range_name],c=a.yscales[this.model.y_range_name],h=function(n,i){return t.model.for_hover?t.model.computed_location:"data"==t.model.location_units?n.compute(e):i.compute(e)};if("width"==this.model.dimension?(r=h(c,a.yview),i=a._left.value,s=a._width.value,n=this.model.properties.line_width.value()):(r=a._top.value,i=h(l,a.xview),s=this.model.properties.line_width.value(),n=a._height.value),"css"==this.model.render_mode)this.el.style.top=r+"px",this.el.style.left=i+"px",this.el.style.width=s+"px",this.el.style.height=n+"px",this.el.style.backgroundColor=this.model.properties.line_color.value(),this.el.style.opacity=this.model.properties.line_alpha.value(),o.display(this.el);else if("canvas"==this.model.render_mode){var u=this.plot_view.canvas_view.ctx;u.save(),u.beginPath(),this.visuals.line.set_value(u),u.moveTo(i,r),"width"==this.model.dimension?u.lineTo(i+s,r):u.lineTo(i,r+n),u.stroke(),u.restore()}}else o.undisplay(this.el)},e.__name__="SpanView",e}(r.AnnotationView);n.SpanView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line"]),this.define({render_mode:[s.RenderMode,"canvas"],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"],location:[s.Number,null],location_units:[s.SpatialUnits,"data"],dimension:[s.Dimension,"width"]}),this.override({line_color:"black"}),this.internal({for_hover:[s.Boolean,!1],computed_location:[s.Number,null]})},e.__name__="Span",e}(r.Annotation);n.Span=l,l.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(5),s=t(18),a=t(43),l=t(303),c=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.rotate=!0,e}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),"css"==this.model.render_mode&&(this.el.classList.add(l.bk_annotation),this.plot_view.canvas_overlays.appendChild(this.el))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?this.connect(this.model.change,function(){return e.render()}):this.connect(this.model.change,function(){return e.plot_view.request_render()})},e.prototype._calculate_text_dimensions=function(t,e){var n=t.measureText(e).width,i=a.measure_font(this.visuals.text.font_value()).height;return[n,i]},e.prototype._calculate_bounding_box_dimensions=function(t,e){var n,i,r=this._calculate_text_dimensions(t,e),o=r[0],s=r[1];switch(t.textAlign){case"left":n=0;break;case"center":n=-o/2;break;case"right":n=-o;break;default:throw new Error("unreachable code")}switch(t.textBaseline){case"top":i=0;break;case"middle":i=-.5*s;break;case"bottom":i=-1*s;break;case"alphabetic":i=-.8*s;break;case"hanging":i=-.17*s;break;case"ideographic":i=-.83*s;break;default:throw new Error("unreachable code")}return[n,i,o,s]},e.prototype._canvas_text=function(t,e,n,i,r){this.visuals.text.set_value(t);var o=this._calculate_bounding_box_dimensions(t,e);t.save(),t.beginPath(),t.translate(n,i),r&&t.rotate(r),t.rect(o[0],o[1],o[2],o[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(t),t.fillText(e,0,0)),t.restore()},e.prototype._css_text=function(t,e,n,i,r){o.undisplay(this.el),this.visuals.text.set_value(t);var s=this._calculate_bounding_box_dimensions(t,e),a=this.visuals.border_line.line_dash.value(),l=a.length<2?"solid":"dashed";this.visuals.border_line.set_value(t),this.visuals.background_fill.set_value(t),this.el.style.position="absolute",this.el.style.left=n+s[0]+"px",this.el.style.top=i+s[1]+"px",this.el.style.color=""+this.visuals.text.text_color.value(),this.el.style.opacity=""+this.visuals.text.text_alpha.value(),this.el.style.font=""+this.visuals.text.font_value(),this.el.style.lineHeight="normal",r&&(this.el.style.transform="rotate("+r+"rad)"),this.visuals.background_fill.doit&&(this.el.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(this.el.style.borderStyle=""+l,this.el.style.borderWidth=this.visuals.border_line.line_width.value()+"px",this.el.style.borderColor=""+this.visuals.border_line.color_value()),this.el.textContent=e,o.display(this.el)},e.__name__="TextAnnotationView",e}(r.AnnotationView);n.TextAnnotationView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({render_mode:[s.RenderMode,"canvas"]})},e.__name__="TextAnnotation",e}(r.Annotation);n.TextAnnotation=h,h.initClass()},function(t,e,n){var i=t(421),r=t(77),o=t(5),s=t(51),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals.text=new s.Text(this.model)},e.prototype._get_location=function(){var t,e,n=this.panel,i=this.model.offset;switch(n.side){case"above":case"below":switch(this.model.vertical_align){case"top":e=n._top.value+5;break;case"middle":e=n._vcenter.value;break;case"bottom":e=n._bottom.value-5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":t=n._left.value+i;break;case"center":t=n._hcenter.value;break;case"right":t=n._right.value-i;break;default:throw new Error("unreachable code")}break;case"left":switch(this.model.vertical_align){case"top":t=n._left.value-5;break;case"middle":t=n._hcenter.value;break;case"bottom":t=n._right.value+5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":e=n._bottom.value-i;break;case"center":e=n._vcenter.value;break;case"right":e=n._top.value+i;break;default:throw new Error("unreachable code")}break;case"right":switch(this.model.vertical_align){case"top":t=n._right.value-5;break;case"middle":t=n._hcenter.value;break;case"bottom":t=n._left.value+5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":e=n._top.value+i;break;case"center":e=n._vcenter.value;break;case"right":e=n._bottom.value-i;break;default:throw new Error("unreachable code")}break;default:throw new Error("unreachable code")}return[t,e]},e.prototype.render=function(){if(this.model.visible){var t=this.model.text;if(null!=t&&0!=t.length){this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;var e=this._get_location(),n=e[0],i=e[1],r=this.panel.get_label_angle_heuristic("parallel"),s="canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this);s(this.plot_view.canvas_view.ctx,t,n,i,r)}}else"css"==this.model.render_mode&&o.undisplay(this.el)},e.prototype._get_size=function(){var t=this.model.text;if(null==t||0==t.length)return{width:0,height:0};this.visuals.text.set_value(this.ctx);var e=this.ctx.measureText(t),n=e.width,i=e.ascent;return{width:n,height:i+10}},e.__name__="TitleView",e}(r.TextAnnotationView);n.TitleView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.mixins(["line:border_","fill:background_"]),this.define({text:[a.String],text_font:[a.Font,"helvetica"],text_font_size:[a.FontSizeSpec,"10pt"],text_font_style:[a.FontStyle,"bold"],text_color:[a.ColorSpec,"#444444"],text_alpha:[a.NumberSpec,1],vertical_align:[a.VerticalAlign,"bottom"],align:[a.TextAlign,"left"],offset:[a.Number,0]}),this.override({background_fill_color:null,border_line_color:null}),this.internal({text_align:[a.TextAlign,"left"],text_baseline:[a.TextBaseline,"bottom"]})},e.__name__="Title",e}(r.TextAnnotation);n.Title=c,c.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(4),s=t(5),a=t(18),l=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.rotate=!0,e}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_events.appendChild(this.el),this._toolbar_views={},o.build_views(this._toolbar_views,[this.model.toolbar],{parent:this});var e=this._toolbar_views[this.model.toolbar.id];this.plot_view.visibility_callbacks.push(function(t){return e.set_visibility(t)})},e.prototype.remove=function(){o.remove_views(this._toolbar_views),t.prototype.remove.call(this)},e.prototype.render=function(){if(t.prototype.render.call(this),this.model.visible){this.el.style.position="absolute",this.el.style.overflow="hidden",s.position(this.el,this.panel.bbox);var e=this._toolbar_views[this.model.toolbar.id];e.render(),s.empty(this.el),this.el.appendChild(e.el),s.display(this.el)}else s.undisplay(this.el)},e.prototype._get_size=function(){var t=this.model.toolbar,e=t.tools,n=t.logo;return{width:30*e.length+(null!=n?25:0),height:30}},e.__name__="ToolbarPanelView",e}(r.AnnotationView);n.ToolbarPanelView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({toolbar:[a.Instance]})},e.__name__="ToolbarPanel",e}(r.Annotation);n.ToolbarPanel=c,c.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(5),s=t(18),a=t(315),l=t(309);function c(t,e,n,i,r){switch(t){case"horizontal":return e<i?"right":"left";case"vertical":return n<r?"below":"above";default:return t}}n.compute_side=c;var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_overlays.appendChild(this.el),o.undisplay(this.el)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.data.change,function(){return e._draw_tips()})},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(a.bk_tooltip)},e.prototype.render=function(){this.model.visible&&this._draw_tips()},e.prototype._draw_tips=function(){var t=this.model.data;if(o.empty(this.el),o.undisplay(this.el),this.model.custom?this.el.classList.add(a.bk_tooltip_custom):this.el.classList.remove(a.bk_tooltip_custom),0!=t.length){for(var e=this.plot_view.frame,n=0,i=t;n<i.length;n++){var r=i[n],s=r[0],h=r[1],u=r[2];if(!this.model.inner_only||e.bbox.contains(s,h)){var _=o.div({},u);this.el.appendChild(_)}}var d,p,f=t[t.length-1],m=f[0],v=f[1],g=c(this.model.attachment,m,v,e._hcenter.value,e._vcenter.value);switch(this.el.classList.remove(l.bk_right),this.el.classList.remove(l.bk_left),this.el.classList.remove(l.bk_above),this.el.classList.remove(l.bk_below),o.display(this.el),g){case"right":this.el.classList.add(l.bk_left),d=m+(this.el.offsetWidth-this.el.clientWidth)+10,p=v-this.el.offsetHeight/2;break;case"left":this.el.classList.add(l.bk_right),d=m-this.el.offsetWidth-10,p=v-this.el.offsetHeight/2;break;case"below":this.el.classList.add(l.bk_above),p=v+(this.el.offsetHeight-this.el.clientHeight)+10,d=Math.round(m-this.el.offsetWidth/2);break;case"above":this.el.classList.add(l.bk_below),p=v-this.el.offsetHeight-10,d=Math.round(m-this.el.offsetWidth/2);break;default:throw new Error("unreachable code")}this.model.show_arrow&&this.el.classList.add(a.bk_tooltip_arrow),this.el.childNodes.length>0?(this.el.style.top=p+"px",this.el.style.left=d+"px"):o.undisplay(this.el)}},e.__name__="TooltipView",e}(r.AnnotationView);n.TooltipView=h;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=h,this.define({attachment:[s.TooltipAttachment,"horizontal"],inner_only:[s.Boolean,!0],show_arrow:[s.Boolean,!0]}),this.override({level:"overlay"}),this.internal({data:[s.Any,[]],custom:[s.Any]})},e.prototype.clear=function(){this.data=[]},e.prototype.add=function(t,e,n){this.data=this.data.concat([[t,e,n]])},e.__name__="Tooltip",e}(r.Annotation);n.Tooltip=u,u.initClass()},function(t,e,n){var i=t(421),r=t(63),o=t(212),s=t(65),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.patching,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.change,function(){return e.set_data(e.model.source)})},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,n,i=this.plot_view.frame,r=this.model.dimension,o=i.xscales[this.model.x_range_name],s=i.yscales[this.model.y_range_name],a="height"==r?s:o,l="height"==r?o:s,c="height"==r?i.yview:i.xview,h="height"==r?i.xview:i.yview;t="data"==this.model.properties.lower.units?a.v_compute(this._lower):c.v_compute(this._lower),e="data"==this.model.properties.upper.units?a.v_compute(this._upper):c.v_compute(this._upper),n="data"==this.model.properties.base.units?l.v_compute(this._base):h.v_compute(this._base);var u="height"==r?[1,0]:[0,1],_=u[0],d=u[1],p=[t,n],f=[e,n];this._lower_sx=p[_],this._lower_sy=p[d],this._upper_sx=f[_],this._upper_sy=f[d]},e.prototype.render=function(){if(this.model.visible){this._map_data();var t=this.plot_view.canvas_view.ctx;if(this.visuals.line.doit)for(var e=0,n=this._lower_sx.length;e<n;e++)this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(this._lower_sx[e],this._lower_sy[e]),t.lineTo(this._upper_sx[e],this._upper_sy[e]),t.stroke();var i="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(var e=0,n=this._lower_sx.length;e<n;e++)t.save(),t.translate(this._lower_sx[e],this._lower_sy[e]),t.rotate(i+Math.PI),this.model.lower_head.render(t,e),t.restore();if(null!=this.model.upper_head)for(var e=0,n=this._upper_sx.length;e<n;e++)t.save(),t.translate(this._upper_sx[e],this._upper_sy[e]),t.rotate(i),this.model.upper_head.render(t,e),t.restore()}},e.__name__="WhiskerView",e}(r.AnnotationView);n.WhiskerView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.mixins(["line"]),this.define({lower:[a.DistanceSpec],lower_head:[a.Instance,function(){return new s.TeeHead({level:"underlay",size:10})}],upper:[a.DistanceSpec],upper_head:[a.Instance,function(){return new s.TeeHead({level:"underlay",size:10})}],base:[a.DistanceSpec],dimension:[a.Dimension,"height"],source:[a.Instance,function(){return new o.ColumnDataSource}],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({level:"underlay"})},e.__name__="Whisker",e}(r.Annotation);n.Whisker=c,c.initClass()},function(t,e,n){var i=t(421),r=t(199),o=t(18),s=t(24),a=t(46),l=t(192),c=Math.abs,h=Math.min,u=Math.max,_=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.rotate=!0,e}return i.__extends(e,t),Object.defineProperty(e.prototype,"panel",{get:function(){return this.layout},enumerable:!0,configurable:!0}),e.prototype.render=function(){if(this.model.visible){var t={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},e=this.tick_coords,n=this.plot_view.canvas_view.ctx;n.save(),this._draw_rule(n,t),this._draw_major_ticks(n,t,e),this._draw_minor_ticks(n,t,e),this._draw_major_labels(n,t,e),this._draw_axis_label(n,t,e),null!=this._render&&this._render(n,t,e),n.restore()}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.plot_view.request_paint()});var n=this.model.properties;this.on_change(n.visible,function(){return e.plot_view.request_layout()})},e.prototype.get_size=function(){if(this.model.visible&&null==this.model.fixed_location){var t=this._get_size();return{width:0,height:Math.round(t)}}return{width:0,height:0}},e.prototype._get_size=function(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null!=this.model.fixed_location},enumerable:!0,configurable:!0}),e.prototype._draw_rule=function(t,e){if(this.visuals.axis_line.doit){var n=this.rule_coords,i=n[0],r=n[1],o=this.plot_view.map_to_screen(i,r,this.model.x_range_name,this.model.y_range_name),s=o[0],a=o[1],l=this.normals,c=l[0],h=l[1],u=this.offsets,_=u[0],d=u[1];this.visuals.axis_line.set_value(t),t.beginPath(),t.moveTo(Math.round(s[0]+c*_),Math.round(a[0]+h*d));for(var p=1;p<s.length;p++){var f=Math.round(s[p]+c*_),m=Math.round(a[p]+h*d);t.lineTo(f,m)}t.stroke()}},e.prototype._draw_major_ticks=function(t,e,n){var i=this.model.major_tick_in,r=this.model.major_tick_out,o=this.visuals.major_tick_line;this._draw_ticks(t,n.major,i,r,o)},e.prototype._draw_minor_ticks=function(t,e,n){var i=this.model.minor_tick_in,r=this.model.minor_tick_out,o=this.visuals.minor_tick_line;this._draw_ticks(t,n.minor,i,r,o)},e.prototype._draw_major_labels=function(t,e,n){var i=n.major,r=this.compute_labels(i[this.dimension]),o=this.model.major_label_orientation,s=e.tick+this.model.major_label_standoff,a=this.visuals.major_label_text;this._draw_oriented_labels(t,r,i,o,this.panel.side,s,a)},e.prototype._draw_axis_label=function(t,e,n){if(null!=this.model.axis_label&&0!=this.model.axis_label.length&&null==this.model.fixed_location){var i,r;switch(this.panel.side){case"above":i=this.panel._hcenter.value,r=this.panel._bottom.value;break;case"below":i=this.panel._hcenter.value,r=this.panel._top.value;break;case"left":i=this.panel._right.value,r=this.panel._vcenter.value;break;case"right":i=this.panel._left.value,r=this.panel._vcenter.value;break;default:throw new Error("unknown side: "+this.panel.side)}var o=[[i],[r]],a=e.tick+s.sum(e.tick_label)+this.model.axis_label_standoff,l=this.visuals.axis_label_text;this._draw_oriented_labels(t,[this.model.axis_label],o,"parallel",this.panel.side,a,l,"screen")}},e.prototype._draw_ticks=function(t,e,n,i,r){if(r.doit){var o=e[0],s=e[1],a=this.plot_view.map_to_screen(o,s,this.model.x_range_name,this.model.y_range_name),l=a[0],c=a[1],h=this.normals,u=h[0],_=h[1],d=this.offsets,p=d[0],f=d[1],m=[u*(p-n),_*(f-n)],v=m[0],g=m[1],y=[u*(p+i),_*(f+i)],b=y[0],w=y[1];r.set_value(t);for(var x=0;x<l.length;x++){var A=Math.round(l[x]+b),k=Math.round(c[x]+w),C=Math.round(l[x]+v),T=Math.round(c[x]+g);t.beginPath(),t.moveTo(A,k),t.lineTo(C,T),t.stroke()}}},e.prototype._draw_oriented_labels=function(t,e,n,i,r,o,s,l){var c,h,u;if(void 0===l&&(l="data"),s.doit&&0!=e.length){var _,d,p,f;if("screen"==l)_=n[0],d=n[1],p=(c=[0,0])[0],f=c[1];else{var m=n[0],v=n[1];h=this.plot_view.map_to_screen(m,v,this.model.x_range_name,this.model.y_range_name),_=h[0],d=h[1],u=this.offsets,p=u[0],f=u[1]}var g,y=this.normals,b=y[0],w=y[1],x=b*(p+o),A=w*(f+o);s.set_value(t),this.panel.apply_label_text_heuristics(t,i),g=a.isString(i)?this.panel.get_label_angle_heuristic(i):-i;for(var k=0;k<_.length;k++){var C=Math.round(_[k]+x),T=Math.round(d[k]+A);t.translate(C,T),t.rotate(g),t.fillText(e[k],0,0),t.rotate(-g),t.translate(-C,-T)}}},e.prototype._axis_label_extent=function(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;var t=this.model.axis_label_standoff,e=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,t,e)},e.prototype._tick_extent=function(){return this.model.major_tick_out},e.prototype._tick_label_extent=function(){return s.sum(this._tick_label_extents())},e.prototype._tick_label_extents=function(){var t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),n=this.model.major_label_orientation,i=this.model.major_label_standoff,r=this.visuals.major_label_text;return[this._oriented_labels_extent(e,n,this.panel.side,i,r)]},e.prototype._oriented_labels_extent=function(t,e,n,i,r){if(0==t.length)return 0;var o,s,l=this.plot_view.canvas_view.ctx;r.set_value(l),a.isString(e)?(o=1,s=this.panel.get_label_angle_heuristic(e)):(o=2,s=-e),s=Math.abs(s);for(var c=Math.cos(s),h=Math.sin(s),u=0,_=0;_<t.length;_++){var d=1.1*l.measureText(t[_]).width,p=.9*l.measureText(t[_]).ascent,f=void 0;(f="above"==n||"below"==n?d*h+p/o*c:d*c+p/o*h)>u&&(u=f)}return u>0&&(u+=i),u},Object.defineProperty(e.prototype,"normals",{get:function(){return this.panel.normals},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"dimension",{get:function(){return this.panel.dimension},enumerable:!0,configurable:!0}),e.prototype.compute_labels=function(t){for(var e=this.model.formatter.doFormat(t,this),n=0;n<t.length;n++)t[n]in this.model.major_label_overrides&&(e[n]=this.model.major_label_overrides[t[n]]);return e},Object.defineProperty(e.prototype,"offsets",{get:function(){if(null!=this.model.fixed_location)return[0,0];var t=this.plot_view.frame,e=[0,0],n=e[0],i=e[1];switch(this.panel.side){case"below":i=c(this.panel._top.value-t._bottom.value);break;case"above":i=c(this.panel._bottom.value-t._top.value);break;case"right":n=c(this.panel._left.value-t._right.value);break;case"left":n=c(this.panel._right.value-t._left.value)}return[n,i]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"ranges",{get:function(){var t=this.dimension,e=(t+1)%2,n=this.plot_view.frame,i=[n.x_ranges[this.model.x_range_name],n.y_ranges[this.model.y_range_name]];return[i[t],i[e]]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_bounds",{get:function(){var t=this.ranges[0],e=this.model.bounds,n=[t.min,t.max];if("auto"==e)return[t.min,t.max];if(a.isArray(e)){var i=void 0,r=void 0,o=e[0],s=e[1],l=n[0],_=n[1];return c(o-s)>c(l-_)?(i=u(h(o,s),l),r=h(u(o,s),_)):(i=h(o,s),r=u(o,s)),[i,r]}throw new Error("user bounds '"+e+"' not understood")},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"rule_coords",{get:function(){var t=this.dimension,e=(t+1)%2,n=this.ranges[0],i=this.computed_bounds,r=i[0],o=i[1],s=new Array(2),a=new Array(2),l=[s,a];return l[t][0]=Math.max(r,n.min),l[t][1]=Math.min(o,n.max),l[t][0]>l[t][1]&&(l[t][0]=l[t][1]=NaN),l[e][0]=this.loc,l[e][1]=this.loc,l},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"tick_coords",{get:function(){for(var t=this.dimension,e=(t+1)%2,n=this.ranges[0],i=this.computed_bounds,r=i[0],o=i[1],s=this.model.ticker.get_ticks(r,o,n,this.loc,{}),a=s.major,l=s.minor,c=[[],[]],h=[[],[]],u=[n.min,n.max],_=u[0],d=u[1],p=0;p<a.length;p++)a[p]<_||a[p]>d||(c[t].push(a[p]),c[e].push(this.loc));for(var p=0;p<l.length;p++)l[p]<_||l[p]>d||(h[t].push(l[p]),h[e].push(this.loc));return{major:c,minor:h}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"loc",{get:function(){var t=this.model.fixed_location;if(null!=t){if(a.isNumber(t))return t;var e=this.ranges,n=e[1];if(n instanceof l.FactorRange)return n.synthetic(t);throw new Error("unexpected")}var i=this.ranges,r=i[1];switch(this.panel.side){case"left":case"below":return r.start;case"right":case"above":return r.end}},enumerable:!0,configurable:!0}),e.prototype.serializable_state=function(){return i.__assign({},t.prototype.serializable_state.call(this),{bbox:this.layout.bbox.box})},e.__name__="AxisView",e}(r.GuideRendererView);n.AxisView=_;var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=_,this.mixins(["line:axis_","line:major_tick_","line:minor_tick_","text:major_label_","text:axis_label_"]),this.define({bounds:[o.Any,"auto"],ticker:[o.Instance],formatter:[o.Instance],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"],axis_label:[o.String,""],axis_label_standoff:[o.Int,5],major_label_standoff:[o.Int,5],major_label_orientation:[o.Any,"horizontal"],major_label_overrides:[o.Any,{}],major_tick_in:[o.Number,2],major_tick_out:[o.Number,6],minor_tick_in:[o.Number,0],minor_tick_out:[o.Number,4],fixed_location:[o.Any,null]}),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"8pt",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"10pt",axis_label_text_font_style:"italic"})},e.__name__="Axis",e}(r.GuideRenderer);n.Axis=d,d.initClass()},function(t,e,n){var i=t(421),r=t(82),o=t(226),s=t(108),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._render=function(t,e,n){this._draw_group_separators(t,e,n)},e.prototype._draw_group_separators=function(t,e,n){var i,r=this.ranges[0],o=this.computed_bounds,s=o[0],a=o[1];if(r.tops&&!(r.tops.length<2)&&this.visuals.separator_line.doit){for(var l=this.dimension,c=(l+1)%2,h=[[],[]],u=0,_=0;_<r.tops.length-1;_++){for(var d=void 0,p=void 0,f=u;f<r.factors.length;f++)if(r.factors[f][0]==r.tops[_+1]){i=[r.factors[f-1],r.factors[f]],d=i[0],p=i[1],u=f;break}var m=(r.synthetic(d)+r.synthetic(p))/2;m>s&&m<a&&(h[l].push(m),h[c].push(this.loc))}var v=this._tick_label_extent();this._draw_ticks(t,h,-3,v-6,this.visuals.separator_line)}},e.prototype._draw_major_labels=function(t,e,n){for(var i=this._get_factor_info(),r=e.tick+this.model.major_label_standoff,o=0;o<i.length;o++){var s=i[o],a=s[0],l=s[1],c=s[2],h=s[3];this._draw_oriented_labels(t,a,l,c,this.panel.side,r,h),r+=e.tick_label[o]}},e.prototype._tick_label_extents=function(){for(var t=this._get_factor_info(),e=[],n=0,i=t;n<i.length;n++){var r=i[n],o=r[0],s=r[2],a=r[3],l=this._oriented_labels_extent(o,s,this.panel.side,this.model.major_label_standoff,a);e.push(l)}return e},e.prototype._get_factor_info=function(){var t=this.ranges[0],e=this.computed_bounds,n=e[0],i=e[1],r=this.loc,o=this.model.ticker.get_ticks(n,i,t,r,{}),s=this.tick_coords,a=[];if(1==t.levels){var l=o.major,c=this.model.formatter.doFormat(l,this);a.push([c,s.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){var l=o.major.map(function(t){return t[1]}),c=this.model.formatter.doFormat(l,this);a.push([c,s.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([o.tops,s.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){var l=o.major.map(function(t){return t[2]}),c=this.model.formatter.doFormat(l,this),h=o.mids.map(function(t){return t[1]});a.push([c,s.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([h,s.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([o.tops,s.tops,this.model.group_label_orientation,this.visuals.group_text])}return a},Object.defineProperty(e.prototype,"tick_coords",{get:function(){var t=this,e=this.dimension,n=(e+1)%2,i=this.ranges[0],r=this.computed_bounds,o=r[0],s=r[1],a=this.model.ticker.get_ticks(o,s,i,this.loc,{}),l={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return l.major[e]=a.major,l.major[n]=a.major.map(function(e){return t.loc}),3==i.levels&&(l.mids[e]=a.mids),l.mids[n]=a.mids.map(function(e){return t.loc}),i.levels>1&&(l.tops[e]=a.tops),l.tops[n]=a.tops.map(function(e){return t.loc}),l},enumerable:!0,configurable:!0}),e.__name__="CategoricalAxisView",e}(r.AxisView);n.CategoricalAxisView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.mixins(["line:separator_","text:group_","text:subgroup_"]),this.define({group_label_orientation:[a.Any,"parallel"],subgroup_label_orientation:[a.Any,"parallel"]}),this.override({ticker:function(){return new o.CategoricalTicker},formatter:function(){return new s.CategoricalTickFormatter},separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"8pt",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"8pt"})},e.__name__="CategoricalAxis",e}(r.Axis);n.CategoricalAxis=c,c.initClass()},function(t,e,n){var i=t(421),r=t(82),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="ContinuousAxis",e}(r.Axis);n.ContinuousAxis=o},function(t,e,n){var i=t(421),r=t(87),o=t(109),s=t(229),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="DatetimeAxisView",e}(r.LinearAxisView);n.DatetimeAxisView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.override({ticker:function(){return new s.DatetimeTicker},formatter:function(){return new o.DatetimeTickFormatter}})},e.__name__="DatetimeAxis",e}(r.LinearAxis);n.DatetimeAxis=l,l.initClass()},function(t,e,n){var i=t(82);n.Axis=i.Axis;var r=t(83);n.CategoricalAxis=r.CategoricalAxis;var o=t(84);n.ContinuousAxis=o.ContinuousAxis;var s=t(85);n.DatetimeAxis=s.DatetimeAxis;var a=t(87);n.LinearAxis=a.LinearAxis;var l=t(88);n.LogAxis=l.LogAxis;var c=t(89);n.MercatorAxis=c.MercatorAxis},function(t,e,n){var i=t(421),r=t(82),o=t(84),s=t(107),a=t(225),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="LinearAxisView",e}(r.AxisView);n.LinearAxisView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.override({ticker:function(){return new a.BasicTicker},formatter:function(){return new s.BasicTickFormatter}})},e.__name__="LinearAxis",e}(o.ContinuousAxis);n.LinearAxis=c,c.initClass()},function(t,e,n){var i=t(421),r=t(82),o=t(84),s=t(112),a=t(233),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="LogAxisView",e}(r.AxisView);n.LogAxisView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.override({ticker:function(){return new a.LogTicker},formatter:function(){return new s.LogTickFormatter}})},e.__name__="LogAxis",e}(o.ContinuousAxis);n.LogAxis=c,c.initClass()},function(t,e,n){var i=t(421),r=t(82),o=t(87),s=t(113),a=t(234),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="MercatorAxisView",e}(r.AxisView);n.MercatorAxisView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.override({ticker:function(){return new a.MercatorTicker({dimension:"lat"})},formatter:function(){return new s.MercatorTickFormatter({dimension:"lat"})}})},e.__name__="MercatorAxis",e}(o.LinearAxis);n.MercatorAxis=c,c.initClass()},function(t,e,n){var i=t(421),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="Callback",e}(r.Model);n.Callback=o},function(t,e,n){var i=t(421),r=t(90),o=t(18),s=t(35),a=t(40),l=function(e){function n(t){return e.call(this,t)||this}return i.__extends(n,e),n.initClass=function(){this.define({args:[o.Any,{}],code:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(n.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"func",{get:function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0].concat(this.names,["cb_obj","cb_data","require","exports",t])))},enumerable:!0,configurable:!0}),n.prototype.execute=function(e,n){return void 0===n&&(n={}),this.func.apply(e,this.values.concat(e,n,t,{}))},n.__name__="CustomJS",n}(r.Callback);n.CustomJS=l,l.initClass()},function(t,e,n){var i=t(91);n.CustomJS=i.CustomJS;var r=t(93);n.OpenURL=r.OpenURL},function(t,e,n){var i=t(421),r=t(90),o=t(42),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({url:[s.String,"http://"],same_tab:[s.Boolean,!1]})},e.prototype.execute=function(t,e){for(var n=this,i=e.source,r=function(t){var e=o.replace_placeholders(n.url,i,t);n.same_tab?window.location.href=e:window.open(e)},s=i.selected,a=0,l=s.indices;a<l.length;a++){var c=l[a];r(c)}for(var h=0,u=s.line_indices;h<u.length;h++){var c=u[h];r(c)}},e.__name__="OpenURL",e}(r.Callback);n.OpenURL=a,a.initClass()},function(t,e,n){var i=t(421),r=t(8),o=t(6),s=t(17),a=t(18),l=t(5),c=t(27),h=t(31),u=t(29),_=t(305);h.is_ie&&"undefined"!=typeof CanvasPixelArray&&(CanvasPixelArray.prototype.set=function(t){for(var e=0;e<this.length;e++)this[e]=t[e]});var d=t(318),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"ctx",{get:function(){return this._ctx},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.map_el=this.model.map?this.el.appendChild(l.div({class:_.bk_canvas_map})):null;var e={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};switch(this.model.output_backend){case"canvas":case"webgl":this.canvas_el=this.el.appendChild(l.canvas({class:_.bk_canvas,style:e}));var n=this.canvas_el.getContext("2d");if(null==n)throw new Error("unable to obtain 2D rendering context");this._ctx=n;break;case"svg":var n=new d;this._ctx=n,this.canvas_el=this.el.appendChild(n.getSvg())}this.overlays_el=this.el.appendChild(l.div({class:_.bk_canvas_overlays,style:e})),this.events_el=this.el.appendChild(l.div({class:_.bk_canvas_events,style:e})),u.fixup_ctx(this._ctx),s.logger.debug("CanvasView initialized")},e.prototype.get_canvas_element=function(){return this.canvas_el},e.prototype.prepare_canvas=function(t,e){this.bbox=new c.BBox({left:0,top:0,width:t,height:e}),this.el.style.width=t+"px",this.el.style.height=e+"px";var n=u.get_scale_ratio(this.ctx,this.model.use_hidpi,this.model.output_backend);this.model.pixel_ratio=n,this.canvas_el.style.width=t+"px",this.canvas_el.style.height=e+"px",this.canvas_el.setAttribute("width",""+t*n),this.canvas_el.setAttribute("height",""+e*n),s.logger.debug("Rendering CanvasView with width: "+t+", height: "+e+", pixel ratio: "+n)},e.__name__="CanvasView",e}(o.DOMView);n.CanvasView=p;var f=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=p,this.internal({map:[a.Boolean,!1],use_hidpi:[a.Boolean,!0],pixel_ratio:[a.Number,1],output_backend:[a.OutputBackend,"canvas"]})},e.__name__="Canvas",e}(r.HasProps);n.Canvas=f,f.initClass()},function(t,e,n){var i=t(421),r=t(202),o=t(204),s=t(205),a=t(195),l=t(191),c=t(192),h=t(13),u=function(t){function e(e,n,i,r,o,s){void 0===o&&(o={}),void 0===s&&(s={});var a=t.call(this)||this;return a.x_scale=e,a.y_scale=n,a.x_range=i,a.y_range=r,a.extra_x_ranges=o,a.extra_y_ranges=s,a._configure_scales(),a}return i.__extends(e,t),e.prototype.map_to_screen=function(t,e,n,i){void 0===n&&(n="default"),void 0===i&&(i="default");var r=this.xscales[n].v_compute(t),o=this.yscales[i].v_compute(e);return[r,o]},e.prototype._get_ranges=function(t,e){var n={};if(n.default=t,null!=e)for(var i in e)n[i]=e[i];return n},e.prototype._get_scales=function(t,e,n){var i={};for(var h in e){var u=e[h];if(u instanceof l.DataRange1d||u instanceof a.Range1d){if(!(t instanceof s.LogScale||t instanceof o.LinearScale))throw new Error("Range "+u.type+" is incompatible is Scale "+t.type);if(t instanceof r.CategoricalScale)throw new Error("Range "+u.type+" is incompatible is Scale "+t.type)}if(u instanceof c.FactorRange&&!(t instanceof r.CategoricalScale))throw new Error("Range "+u.type+" is incompatible is Scale "+t.type);t instanceof s.LogScale&&u instanceof l.DataRange1d&&(u.scale_hint="log");var _=t.clone();_.setv({source_range:u,target_range:n}),i[h]=_}return i},e.prototype._configure_frame_ranges=function(){this._h_target=new a.Range1d({start:this._left.value,end:this._right.value}),this._v_target=new a.Range1d({start:this._bottom.value,end:this._top.value})},e.prototype._configure_scales=function(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._xscales=this._get_scales(this.x_scale,this._x_ranges,this._h_target),this._yscales=this._get_scales(this.y_scale,this._y_ranges,this._v_target)},e.prototype._update_scales=function(){for(var t in this._configure_frame_ranges(),this._xscales){var e=this._xscales[t];e.target_range=this._h_target}for(var n in this._yscales){var e=this._yscales[n];e.target_range=this._v_target}},e.prototype._set_geometry=function(e,n){t.prototype._set_geometry.call(this,e,n),this._update_scales()},Object.defineProperty(e.prototype,"x_ranges",{get:function(){return this._x_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"y_ranges",{get:function(){return this._y_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"xscales",{get:function(){return this._xscales},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"yscales",{get:function(){return this._yscales},enumerable:!0,configurable:!0}),e.__name__="CartesianFrame",e}(h.LayoutItem);n.CartesianFrame=u},function(t,e,n){var i=t(94);n.Canvas=i.Canvas;var r=t(95);n.CartesianFrame=r.CartesianFrame},function(t,e,n){var i=t(421),r=t(98),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({field:[o.String],include_zero:[o.Boolean,!1]})},e.prototype._v_compute=function(t){var e=new Float64Array(t.get_length()||0),n=t.data[this.field],i=this.include_zero?1:0;e[0]=this.include_zero?0:n[0];for(var r=1;r<e.length;r++)e[r]=e[r-1]+n[r-i];return e},e.__name__="CumSum",e}(r.Expression);n.CumSum=s,s.initClass()},function(t,e,n){var i=t(421),r=t(62),o=function(t){function e(e){var n=t.call(this,e)||this;return n._connected={},n._result={},n}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._connected={},this._result={}},e.prototype.v_compute=function(t){var e=this;null==this._connected[t.id]&&(this.connect(t.change,function(){return delete e._result[t.id]}),this.connect(t.patching,function(){return delete e._result[t.id]}),this.connect(t.streaming,function(){return delete e._result[t.id]}),this._connected[t.id]=!0);var n=this._result[t.id];return null==n&&(this._result[t.id]=n=this._v_compute(t)),n},e.__name__="Expression",e}(r.Model);n.Expression=o},function(t,e,n){var i=t(98);n.Expression=i.Expression;var r=t(100);n.Stack=r.Stack;var o=t(97);n.CumSum=o.CumSum},function(t,e,n){var i=t(421),r=t(98),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({fields:[o.Array,[]]})},e.prototype._v_compute=function(t){for(var e=new Float64Array(t.get_length()||0),n=0,i=this.fields;n<i.length;n++)for(var r=i[n],o=0;o<t.data[r].length;o++){var s=t.data[r][o];e[o]+=s}return e},e.__name__="Stack",e}(r.Expression);n.Stack=s,s.initClass()},function(t,e,n){var i=t(421),r=t(103),o=t(18),s=t(17),a=t(24),l=t(46),c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({booleans:[o.Array,null]})},e.prototype.compute_indices=function(t){var e=this.booleans;return null!=e&&e.length>0?a.every(e,l.isBoolean)?(e.length!==t.get_length()&&s.logger.warn("BooleanFilter "+this.id+": length of booleans doesn't match data source"),a.range(0,e.length).filter(function(t){return!0===e[t]})):(s.logger.warn("BooleanFilter "+this.id+": booleans should be array of booleans, defaulting to no filtering"),null):(null!=e&&0==e.length?s.logger.warn("BooleanFilter "+this.id+": booleans is empty, defaulting to no filtering"):s.logger.warn("BooleanFilter "+this.id+": booleans was not set, defaulting to no filtering"),null)},e.__name__="BooleanFilter",e}(r.Filter);n.BooleanFilter=c,c.initClass()},function(t,e,n){var i=t(421),r=t(103),o=t(18),s=t(35),a=t(40),l=function(e){function n(t){return e.call(this,t)||this}return i.__extends(n,e),n.initClass=function(){this.define({args:[o.Any,{}],code:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(n.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"func",{get:function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0].concat(this.names,["source","require","exports",t])))},enumerable:!0,configurable:!0}),n.prototype.compute_indices=function(n){return this.filter=this.func.apply(this,this.values.concat([n,t,{}])),e.prototype.compute_indices.call(this,n)},n.__name__="CustomJSFilter",n}(r.Filter);n.CustomJSFilter=l,l.initClass()},function(t,e,n){var i=t(421),r=t(62),o=t(18),s=t(46),a=t(24),l=t(17),c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({filter:[o.Array,null]})},e.prototype.compute_indices=function(t){var e=this.filter;return null!=e&&e.length>=0?s.isArrayOf(e,s.isBoolean)?a.range(0,e.length).filter(function(t){return!0===e[t]}):s.isArrayOf(e,s.isInteger)?e:(l.logger.warn("Filter "+this.id+": filter should either be array of only booleans or only integers, defaulting to no filtering"),null):(l.logger.warn("Filter "+this.id+": filter was not set to be an array, defaulting to no filtering"),null)},e.__name__="Filter",e}(r.Model);n.Filter=c,c.initClass()},function(t,e,n){var i=t(421),r=t(103),o=t(18),s=t(17),a=t(24),l=function(t){function e(e){var n=t.call(this,e)||this;return n.indices=null,n}return i.__extends(e,t),e.initClass=function(){this.define({column_name:[o.String],group:[o.String]})},e.prototype.compute_indices=function(t){var e=this,n=t.get_column(this.column_name);return null==n?(s.logger.warn("group filter: groupby column not found in data source"),null):(this.indices=a.range(0,t.get_length()||0).filter(function(t){return n[t]===e.group}),0===this.indices.length&&s.logger.warn("group filter: group '"+this.group+"' did not match any values in column '"+this.column_name+"'"),this.indices)},e.__name__="GroupFilter",e}(r.Filter);n.GroupFilter=l,l.initClass()},function(t,e,n){var i=t(101);n.BooleanFilter=i.BooleanFilter;var r=t(102);n.CustomJSFilter=r.CustomJSFilter;var o=t(103);n.Filter=o.Filter;var s=t(104);n.GroupFilter=s.GroupFilter;var a=t(106);n.IndexFilter=a.IndexFilter},function(t,e,n){var i=t(421),r=t(103),o=t(18),s=t(17),a=t(46),l=t(24),c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({indices:[o.Array,null]})},e.prototype.compute_indices=function(t){return null!=this.indices&&this.indices.length>=0?l.every(this.indices,a.isInteger)?this.indices:(s.logger.warn("IndexFilter "+this.id+": indices should be array of integers, defaulting to no filtering"),null):(s.logger.warn("IndexFilter "+this.id+": indices was not set, defaulting to no filtering"),null)},e.__name__="IndexFilter",e}(r.Filter);n.IndexFilter=c,c.initClass()},function(t,e,n){var i=t(421),r=t(116),o=t(18),s=t(46),a=function(t){function e(e){var n=t.call(this,e)||this;return n.last_precision=3,n}return i.__extends(e,t),e.initClass=function(){this.define({precision:[o.Any,"auto"],use_scientific:[o.Boolean,!0],power_limit_high:[o.Number,5],power_limit_low:[o.Number,-3]})},Object.defineProperty(e.prototype,"scientific_limit_low",{get:function(){return Math.pow(10,this.power_limit_low)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"scientific_limit_high",{get:function(){return Math.pow(10,this.power_limit_high)},enumerable:!0,configurable:!0}),e.prototype.doFormat=function(t,e){if(0==t.length)return[];var n=0;t.length>=2&&(n=Math.abs(t[1]-t[0])/1e4);var i=!1;if(this.use_scientific)for(var r=0,o=t;r<o.length;r++){var a=o[r],l=Math.abs(a);if(l>n&&(l>=this.scientific_limit_high||l<=this.scientific_limit_low)){i=!0;break}}var c=new Array(t.length),h=this.precision;if(null==h||s.isNumber(h))if(i)for(var u=0,_=t.length;u<_;u++)c[u]=t[u].toExponential(h||void 0);else for(var u=0,_=t.length;u<_;u++)c[u]=t[u].toFixed(h||void 0).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");else for(var d=this.last_precision,p=this.last_precision<=15;p?d<=15:d>=15;p?d++:d--){var f=!0;if(i){for(var u=0,_=t.length;u<_;u++)if(c[u]=t[u].toExponential(d),u>0&&c[u]===c[u-1]){f=!1;break}if(f)break}else{for(var u=0,_=t.length;u<_;u++)if(c[u]=t[u].toFixed(d).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),u>0&&c[u]==c[u-1]){f=!1;break}if(f)break}if(f){this.last_precision=d;break}}return c},e.__name__="BasicTickFormatter",e}(r.TickFormatter);n.BasicTickFormatter=a,a.initClass()},function(t,e,n){var i=t(421),r=t(116),o=t(24),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.doFormat=function(t,e){return o.copy(t)},e.__name__="CategoricalTickFormatter",e}(r.TickFormatter);n.CategoricalTickFormatter=s},function(t,e,n){var i=t(421),r=t(420),o=t(116),s=t(17),a=t(18),l=t(42),c=t(24),h=t(46);function u(t){return r(t,"%Y %m %d %H %M %S").split(/\s+/).map(function(t){return parseInt(t,10)})}function _(t,e){if(h.isFunction(e))return e(t);var n=l.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(e=e.replace(/((^|[^%])(%%)*)%f/,n)).indexOf("%")?e:r(t,e)}var d=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],p=function(t){function e(e){var n=t.call(this,e)||this;return n.strip_leading_zeros=!0,n}return i.__extends(e,t),e.initClass=function(){this.define({microseconds:[a.Array,["%fus"]],milliseconds:[a.Array,["%3Nms","%S.%3Ns"]],seconds:[a.Array,["%Ss"]],minsec:[a.Array,[":%M:%S"]],minutes:[a.Array,[":%M","%Mm"]],hourmin:[a.Array,["%H:%M"]],hours:[a.Array,["%Hh","%H:%M"]],days:[a.Array,["%m/%d","%a%d"]],months:[a.Array,["%m/%Y","%b %Y"]],years:[a.Array,["%Y"]]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._update_width_formats()},e.prototype._update_width_formats=function(){var t=+r(new Date),e=function(e){var n=e.map(function(e){return _(t,e).length}),i=c.sort_by(c.zip(n,e),function(t){var e=t[0];return e});return c.unzip(i)};this._width_formats={microseconds:e(this.microseconds),milliseconds:e(this.milliseconds),seconds:e(this.seconds),minsec:e(this.minsec),minutes:e(this.minutes),hourmin:e(this.hourmin),hours:e(this.hours),days:e(this.days),months:e(this.months),years:e(this.years)}},e.prototype._get_resolution_str=function(t,e){var n=1.1*t;switch(!1){case!(n<.001):return"microseconds";case!(n<1):return"milliseconds";case!(n<60):return e>=60?"minsec":"seconds";case!(n<3600):return e>=3600?"hourmin":"minutes";case!(n<86400):return"hours";case!(n<2678400):return"days";case!(n<31536e3):return"months";default:return"years"}},e.prototype.doFormat=function(t,e){if(0==t.length)return[];for(var n=Math.abs(t[t.length-1]-t[0])/1e3,i=n/(t.length-1),r=this._get_resolution_str(i,n),o=this._width_formats[r],a=o[1][0],l=[],c=d.indexOf(r),h={},p=0,f=d;p<f.length;p++){var m=f[p];h[m]=0}h.seconds=5,h.minsec=4,h.minutes=4,h.hourmin=3,h.hours=3;for(var v=0,g=t;v<g.length;v++){var y=g[v],b=void 0,w=void 0;try{w=u(y),b=_(y,a)}catch(t){s.logger.warn("unable to format tick for timestamp value "+y),s.logger.warn(" - "+t),l.push("ERR");continue}for(var x=!1,A=c;0==w[h[d[A]]];){var k=void 0;if((A+=1)==d.length)break;if(("minsec"==r||"hourmin"==r)&&!x){if("minsec"==r&&0==w[4]&&0!=w[5]||"hourmin"==r&&0==w[3]&&0!=w[4]){k=this._width_formats[d[c-1]][1][0],b=_(y,k);break}x=!0}k=this._width_formats[d[A]][1][0],b=_(y,k)}if(this.strip_leading_zeros){var C=b.replace(/^0+/g,"");C!=b&&isNaN(parseInt(C))&&(C="0"+C),l.push(C)}else l.push(b)}return l},e.__name__="DatetimeTickFormatter",e}(o.TickFormatter);n.DatetimeTickFormatter=p,p.initClass()},function(t,e,n){var i=t(421),r=t(116),o=t(18),s=t(35),a=t(40),l=function(e){function n(t){return e.call(this,t)||this}return i.__extends(n,e),n.initClass=function(){this.define({args:[o.Any,{}],code:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(n.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),n.prototype._make_func=function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0,"tick","index","ticks"].concat(this.names,["require","exports",t])))},n.prototype.doFormat=function(e,n){var i=this,r=this._make_func().bind({});return e.map(function(e,n,o){return r.apply(void 0,[e,n,o].concat(i.values,[t,{}]))})},n.__name__="FuncTickFormatter",n}(r.TickFormatter);n.FuncTickFormatter=l,l.initClass()},function(t,e,n){var i=t(107);n.BasicTickFormatter=i.BasicTickFormatter;var r=t(108);n.CategoricalTickFormatter=r.CategoricalTickFormatter;var o=t(109);n.DatetimeTickFormatter=o.DatetimeTickFormatter;var s=t(110);n.FuncTickFormatter=s.FuncTickFormatter;var a=t(112);n.LogTickFormatter=a.LogTickFormatter;var l=t(113);n.MercatorTickFormatter=l.MercatorTickFormatter;var c=t(114);n.NumeralTickFormatter=c.NumeralTickFormatter;var h=t(115);n.PrintfTickFormatter=h.PrintfTickFormatter;var u=t(116);n.TickFormatter=u.TickFormatter},function(t,e,n){var i=t(421),r=t(116),o=t(107),s=t(17),a=t(18),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({ticker:[a.Instance,null]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.basic_formatter=new o.BasicTickFormatter,null==this.ticker&&s.logger.warn("LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)")},e.prototype.doFormat=function(t,e){if(0==t.length)return[];for(var n=null!=this.ticker?this.ticker.base:10,i=!1,r=new Array(t.length),o=0,s=t.length;o<s;o++)if(r[o]=n+"^"+Math.round(Math.log(t[o])/Math.log(n)),o>0&&r[o]==r[o-1]){i=!0;break}return i?this.basic_formatter.doFormat(t,e):r},e.__name__="LogTickFormatter",e}(r.TickFormatter);n.LogTickFormatter=l,l.initClass()},function(t,e,n){var i=t(421),r=t(107),o=t(18),s=t(36),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({dimension:[o.LatLon]})},e.prototype.doFormat=function(e,n){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==e.length)return[];var i=e.length,r=new Array(i);if("lon"==this.dimension)for(var o=0;o<i;o++){var a=s.wgs84_mercator.inverse([e[o],n.loc])[0];r[o]=a}else for(var o=0;o<i;o++){var l=s.wgs84_mercator.inverse([n.loc,e[o]]),c=l[1];r[o]=c}return t.prototype.doFormat.call(this,r,n)},e.__name__="MercatorTickFormatter",e}(r.BasicTickFormatter);n.MercatorTickFormatter=a,a.initClass()},function(t,e,n){var i=t(421),r=t(391),o=t(116),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({format:[s.String,"0,0"],language:[s.String,"en"],rounding:[s.RoundingFunction,"round"]})},Object.defineProperty(e.prototype,"_rounding_fn",{get:function(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}},enumerable:!0,configurable:!0}),e.prototype.doFormat=function(t,e){var n=this.format,i=this.language,o=this._rounding_fn;return t.map(function(t){return r.format(t,n,i,o)})},e.__name__="NumeralTickFormatter",e}(o.TickFormatter);n.NumeralTickFormatter=a,a.initClass()},function(t,e,n){var i=t(421),r=t(116),o=t(42),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({format:[s.String,"%s"]})},e.prototype.doFormat=function(t,e){var n=this;return t.map(function(t){return o.sprintf(n.format,t)})},e.__name__="PrintfTickFormatter",e}(r.TickFormatter);n.PrintfTickFormatter=a,a.initClass()},function(t,e,n){var i=t(421),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="TickFormatter",e}(r.Model);n.TickFormatter=o},function(t,e,n){var i=t(421),r=t(153),o=t(149),s=t(9),a=t(18),l=t(34),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new Float32Array(this._start_angle.length);for(var t=0,e=this._start_angle.length;t<e;t++)this._angle[t]=this._end_angle[t]-this._start_angle[t]},e.prototype._render=function(t,e,n){for(var i=n.sx,r=n.sy,o=n._start_angle,s=n._angle,a=n.sinner_radius,l=n.souter_radius,c=this.model.properties.direction.value(),h=0,u=e;h<u.length;h++){var _=u[h];isNaN(i[_]+r[_]+a[_]+l[_]+o[_]+s[_])||(t.translate(i[_],r[_]),t.rotate(o[_]),t.moveTo(l[_],0),t.beginPath(),t.arc(0,0,l[_],0,s[_],c),t.rotate(s[_]),t.lineTo(a[_],0),t.arc(0,0,a[_],0,-s[_],!c),t.closePath(),t.rotate(-s[_]-o[_]),t.translate(-i[_],-r[_]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,_),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,_),t.stroke()))}},e.prototype._hit_point=function(t){var e,n,i,r,o,a,c=t.sx,h=t.sy,u=this.renderer.xscale.invert(c),_=this.renderer.yscale.invert(h);if("data"==this.model.properties.outer_radius.units)i=u-this.max_outer_radius,o=u+this.max_outer_radius,r=_-this.max_outer_radius,a=_+this.max_outer_radius;else{var d=c-this.max_outer_radius,p=c+this.max_outer_radius;e=this.renderer.xscale.r_invert(d,p),i=e[0],o=e[1];var f=h-this.max_outer_radius,m=h+this.max_outer_radius;n=this.renderer.yscale.r_invert(f,m),r=n[0],a=n[1]}for(var v=[],g=0,y=this.index.indices({x0:i,x1:o,y0:r,y1:a});g<y.length;g++){var b=y[g],w=Math.pow(this.souter_radius[b],2),x=Math.pow(this.sinner_radius[b],2),A=this.renderer.xscale.r_compute(u,this._x[b]),d=A[0],p=A[1],k=this.renderer.yscale.r_compute(_,this._y[b]),f=k[0],m=k[1],C=Math.pow(d-p,2)+Math.pow(f-m,2);C<=w&&C>=x&&v.push([b,C])}for(var T=this.model.properties.direction.value(),S=[],M=0,E=v;M<E.length;M++){var z=E[M],b=z[0],C=z[1],O=Math.atan2(h-this.sy[b],c-this.sx[b]);l.angle_between(-O,-this._start_angle[b],-this._end_angle[b],T)&&S.push([b,C])}return s.create_hit_test_result_from_hits(S)},e.prototype.draw_legend_for_index=function(t,e,n){o.generic_area_legend(this.visuals,t,e,n)},e.prototype._scenterxy=function(t){var e=(this.sinner_radius[t]+this.souter_radius[t])/2,n=(this._start_angle[t]+this._end_angle[t])/2;return{x:this.sx[t]+e*Math.cos(n),y:this.sy[t]+e*Math.sin(n)}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e.__name__="AnnularWedgeView",e}(r.XYGlyphView);n.AnnularWedgeView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.mixins(["line","fill"]),this.define({direction:[a.Direction,"anticlock"],inner_radius:[a.DistanceSpec],outer_radius:[a.DistanceSpec],start_angle:[a.AngleSpec],end_angle:[a.AngleSpec]})},e.__name__="AnnularWedge",e}(r.XYGlyph);n.AnnularWedge=h,h.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(9),s=t(18),a=t(31),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius},e.prototype._render=function(t,e,n){for(var i=n.sx,r=n.sy,o=n.sinner_radius,s=n.souter_radius,l=0,c=e;l<c.length;l++){var h=c[l];if(!isNaN(i[h]+r[h]+o[h]+s[h])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(t,h),t.beginPath(),a.is_ie)for(var u=0,_=[!1,!0];u<_.length;u++){var d=_[u];t.arc(i[h],r[h],o[h],0,Math.PI,d),t.arc(i[h],r[h],s[h],Math.PI,0,!d)}else t.arc(i[h],r[h],o[h],0,2*Math.PI,!0),t.arc(i[h],r[h],s[h],2*Math.PI,0,!1);t.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,h),t.beginPath(),t.arc(i[h],r[h],o[h],0,2*Math.PI),t.moveTo(i[h]+s[h],r[h]),t.arc(i[h],r[h],s[h],0,2*Math.PI),t.stroke())}}},e.prototype._hit_point=function(t){var e,n,i,r,s,a,l=t.sx,c=t.sy,h=this.renderer.xscale.invert(l),u=this.renderer.yscale.invert(c);if("data"==this.model.properties.outer_radius.units)i=h-this.max_outer_radius,s=h+this.max_outer_radius,r=u-this.max_outer_radius,a=u+this.max_outer_radius;else{var _=l-this.max_outer_radius,d=l+this.max_outer_radius;e=this.renderer.xscale.r_invert(_,d),i=e[0],s=e[1];var p=c-this.max_outer_radius,f=c+this.max_outer_radius;n=this.renderer.yscale.r_invert(p,f),r=n[0],a=n[1]}for(var m=[],v=0,g=this.index.indices({x0:i,x1:s,y0:r,y1:a});v<g.length;v++){var y=g[v],b=Math.pow(this.souter_radius[y],2),w=Math.pow(this.sinner_radius[y],2),x=this.renderer.xscale.r_compute(h,this._x[y]),_=x[0],d=x[1],A=this.renderer.yscale.r_compute(u,this._y[y]),p=A[0],f=A[1],k=Math.pow(_-d,2)+Math.pow(p-f,2);k<=b&&k>=w&&m.push([y,k])}return o.create_hit_test_result_from_hits(m)},e.prototype.draw_legend_for_index=function(t,e,n){var i=e.x0,r=e.y0,o=e.x1,s=e.y1,a=n+1,l=new Array(a);l[n]=(i+o)/2;var c=new Array(a);c[n]=(r+s)/2;var h=.5*Math.min(Math.abs(o-i),Math.abs(s-r)),u=new Array(a);u[n]=.4*h;var _=new Array(a);_[n]=.8*h,this._render(t,[n],{sx:l,sy:c,sinner_radius:u,souter_radius:_})},e.__name__="AnnulusView",e}(r.XYGlyphView);n.AnnulusView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.mixins(["line","fill"]),this.define({inner_radius:[s.DistanceSpec],outer_radius:[s.DistanceSpec]})},e.__name__="Annulus",e}(r.XYGlyph);n.Annulus=c,c.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(149),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},e.prototype._render=function(t,e,n){var i=n.sx,r=n.sy,o=n.sradius,s=n._start_angle,a=n._end_angle;if(this.visuals.line.doit)for(var l=this.model.properties.direction.value(),c=0,h=e;c<h.length;c++){var u=h[c];isNaN(i[u]+r[u]+o[u]+s[u]+a[u])||(t.beginPath(),t.arc(i[u],r[u],o[u],s[u],a[u],l),this.visuals.line.set_vectorize(t,u),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,n){o.generic_line_legend(this.visuals,t,e,n)},e.__name__="ArcView",e}(r.XYGlyphView);n.ArcView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line"]),this.define({direction:[s.Direction,"anticlock"],radius:[s.DistanceSpec],start_angle:[s.AngleSpec],end_angle:[s.AngleSpec]})},e.__name__="Arc",e}(r.XYGlyph);n.Arc=l,l.initClass()},function(t,e,n){var i=t(421),r=t(127),o=t(149),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.draw_legend_for_index=function(t,e,n){o.generic_area_legend(this.visuals,t,e,n)},e.__name__="AreaView",e}(r.GlyphView);n.AreaView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.mixins(["fill","hatch"])},e.__name__="Area",e}(r.Glyph);n.Area=a,a.initClass()},function(t,e,n){var i=t(421),r=t(39),o=t(127),s=t(149);function a(t,e,n,i,r,o,s,a){for(var l=[],c=[[],[]],h=0;h<=2;h++){var u=void 0,_=void 0,d=void 0;if(0===h?(_=6*t-12*n+6*r,u=-3*t+9*n-9*r+3*s,d=3*n-3*t):(_=6*e-12*i+6*o,u=-3*e+9*i-9*o+3*a,d=3*i-3*e),Math.abs(u)<1e-12){if(Math.abs(_)<1e-12)continue;var p=-d/_;0<p&&p<1&&l.push(p)}else{var f=_*_-4*d*u,m=Math.sqrt(f);if(!(f<0)){var v=(-_+m)/(2*u);0<v&&v<1&&l.push(v);var g=(-_-m)/(2*u);0<g&&g<1&&l.push(g)}}}for(var y=l.length,b=y;y--;){var p=l[y],w=1-p,x=w*w*w*t+3*w*w*p*n+3*w*p*p*r+p*p*p*s;c[0][y]=x;var A=w*w*w*e+3*w*w*p*i+3*w*p*p*o+p*p*p*a;c[1][y]=A}return c[0][b]=t,c[1][b]=e,c[0][b+1]=s,c[1][b+1]=a,[Math.min.apply(Math,c[0]),Math.max.apply(Math,c[1]),Math.max.apply(Math,c[0]),Math.min.apply(Math,c[1])]}var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,n=this._x0.length;e<n;e++)if(!isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx0[e]+this._cy0[e]+this._cx1[e]+this._cy1[e])){var i=a(this._x0[e],this._y0[e],this._x1[e],this._y1[e],this._cx0[e],this._cy0[e],this._cx1[e],this._cy1[e]),o=i[0],s=i[1],l=i[2],c=i[3];t.push({x0:o,y0:s,x1:l,y1:c,i:e})}return new r.SpatialIndex(t)},e.prototype._render=function(t,e,n){var i=n.sx0,r=n.sy0,o=n.sx1,s=n.sy1,a=n.scx0,l=n.scy0,c=n.scx1,h=n.scy1;if(this.visuals.line.doit)for(var u=0,_=e;u<_.length;u++){var d=_[u];isNaN(i[d]+r[d]+o[d]+s[d]+a[d]+l[d]+c[d]+h[d])||(t.beginPath(),t.moveTo(i[d],r[d]),t.bezierCurveTo(a[d],l[d],c[d],h[d],o[d],s[d]),this.visuals.line.set_vectorize(t,d),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,n){s.generic_line_legend(this.visuals,t,e,n)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e.__name__="BezierView",e}(o.GlyphView);n.BezierView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.coords([["x0","y0"],["x1","y1"],["cx0","cy0"],["cx1","cy1"]]),this.mixins(["line"])},e.__name__="Bezier",e}(o.Glyph);n.Bezier=c,c.initClass()},function(t,e,n){var i=t(421),r=t(39),o=t(127),s=t(149),a=t(9),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.get_anchor_point=function(t,e,n){var i=Math.min(this.sleft[e],this.sright[e]),r=Math.max(this.sright[e],this.sleft[e]),o=Math.min(this.stop[e],this.sbottom[e]),s=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:i,y:o};case"top_center":return{x:(i+r)/2,y:o};case"top_right":return{x:r,y:o};case"bottom_left":return{x:i,y:s};case"bottom_center":return{x:(i+r)/2,y:s};case"bottom_right":return{x:r,y:s};case"center_left":return{x:i,y:(o+s)/2};case"center":return{x:(i+r)/2,y:(o+s)/2};case"center_right":return{x:r,y:(o+s)/2};default:return null}},e.prototype._index_box=function(t){for(var e=[],n=0;n<t;n++){var i=this._lrtb(n),o=i[0],s=i[1],a=i[2],l=i[3];!isNaN(o+s+a+l)&&isFinite(o+s+a+l)&&e.push({x0:Math.min(o,s),y0:Math.min(a,l),x1:Math.max(s,o),y1:Math.max(a,l),i:n})}return new r.SpatialIndex(e)},e.prototype._render=function(t,e,n){for(var i=this,r=n.sleft,o=n.sright,s=n.stop,a=n.sbottom,l=function(e){if(isNaN(r[e]+s[e]+o[e]+a[e]))return"continue";t.rect(r[e],s[e],o[e]-r[e],a[e]-s[e]),c.visuals.fill.doit&&(c.visuals.fill.set_vectorize(t,e),t.beginPath(),t.rect(r[e],s[e],o[e]-r[e],a[e]-s[e]),t.fill()),c.visuals.hatch.doit2(t,e,function(){t.beginPath(),t.rect(r[e],s[e],o[e]-r[e],a[e]-s[e]),t.fill()},function(){return i.renderer.request_render()}),c.visuals.line.doit&&(c.visuals.line.set_vectorize(t,e),t.beginPath(),t.rect(r[e],s[e],o[e]-r[e],a[e]-s[e]),t.stroke())},c=this,h=0,u=e;h<u.length;h++){var _=u[h];l(_)}},e.prototype._clamp_viewport=function(){for(var t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,n=this.stop.length,i=0;i<n;i++)this.stop[i]=Math.max(this.stop[i],e.start),this.sbottom[i]=Math.min(this.sbottom[i],e.end),this.sleft[i]=Math.max(this.sleft[i],t.start),this.sright[i]=Math.min(this.sright[i],t.end)},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){var e=t.sx,n=t.sy,i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(n),o=this.index.indices({x0:i,y0:r,x1:i,y1:r}),s=a.create_empty_hit_test_result();return s.indices=o,s},e.prototype._hit_span=function(t){var e,n=t.sx,i=t.sy;if("v"==t.direction){var r=this.renderer.yscale.invert(i),o=this.renderer.plot_view.frame.bbox.h_range,s=this.renderer.xscale.r_invert(o.start,o.end),l=s[0],c=s[1];e=this.index.indices({x0:l,y0:r,x1:c,y1:r})}else{var h=this.renderer.xscale.invert(n),u=this.renderer.plot_view.frame.bbox.v_range,_=this.renderer.yscale.r_invert(u.start,u.end),d=_[0],p=_[1];e=this.index.indices({x0:h,y0:d,x1:h,y1:p})}var f=a.create_empty_hit_test_result();return f.indices=e,f},e.prototype.draw_legend_for_index=function(t,e,n){s.generic_area_legend(this.visuals,t,e,n)},e.__name__="BoxView",e}(o.GlyphView);n.BoxView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.mixins(["line","fill","hatch"])},e.__name__="Box",e}(o.Glyph);n.Box=c,c.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="CenterRotatableView",e}(r.XYGlyphView);n.CenterRotatableView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.mixins(["line","fill"]),this.define({angle:[o.AngleSpec,0],width:[o.DistanceSpec],height:[o.DistanceSpec]})},e.__name__="CenterRotatable",e}(r.XYGlyph);n.CenterRotatable=a,a.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(9),s=t(18),a=t(24),l=t(25),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._map_data=function(){if(null!=this._radius)if("data"==this.model.properties.radius.spec.units){var t=this.model.properties.radius_dimension.spec.value;switch(t){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":var e=this.sdist(this.renderer.xscale,this._x,this._radius),n=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=l.map(e,function(t,e){return Math.max(t,n[e])});break;case"min":var e=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=l.map(e,function(t,e){return Math.min(t,i[e])})}}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=l.map(this._size,function(t){return t/2})},e.prototype._mask_data=function(){var t,e,n,i,r,o,s,a,l=this.renderer.plot_view.frame.bbox.ranges,c=l[0],h=l[1];if(null!=this._radius&&"data"==this.model.properties.radius.units){var u=c.start,_=c.end;t=this.renderer.xscale.r_invert(u,_),r=t[0],s=t[1],r-=this.max_radius,s+=this.max_radius;var d=h.start,p=h.end;e=this.renderer.yscale.r_invert(d,p),o=e[0],a=e[1],o-=this.max_radius,a+=this.max_radius}else{var u=c.start-this.max_size,_=c.end+this.max_size;n=this.renderer.xscale.r_invert(u,_),r=n[0],s=n[1];var d=h.start-this.max_size,p=h.end+this.max_size;i=this.renderer.yscale.r_invert(d,p),o=i[0],a=i[1]}return this.index.indices({x0:r,x1:s,y0:o,y1:a})},e.prototype._render=function(t,e,n){for(var i=n.sx,r=n.sy,o=n.sradius,s=0,a=e;s<a.length;s++){var l=a[s];isNaN(i[l]+r[l]+o[l])||(t.beginPath(),t.arc(i[l],r[l],o[l],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,l),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,l),t.stroke()))}},e.prototype._hit_point=function(t){var e,n,i,r,s,a,l,c,h,u,_,d,p,f,m,v,g=t.sx,y=t.sy,b=this.renderer.xscale.invert(g),w=this.renderer.yscale.invert(y);null!=this._radius&&"data"==this.model.properties.radius.units?(p=b-this.max_radius,f=b+this.max_radius,m=w-this.max_radius,v=w+this.max_radius):(h=g-this.max_size,u=g+this.max_size,e=this.renderer.xscale.r_invert(h,u),p=e[0],f=e[1],n=[Math.min(p,f),Math.max(p,f)],p=n[0],f=n[1],_=y-this.max_size,d=y+this.max_size,i=this.renderer.yscale.r_invert(_,d),m=i[0],v=i[1],r=[Math.min(m,v),Math.max(m,v)],m=r[0],v=r[1]);var x=this.index.indices({x0:p,x1:f,y0:m,y1:v}),A=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)for(var k=0,C=x;k<C.length;k++){var T=C[k];c=Math.pow(this.sradius[T],2),s=this.renderer.xscale.r_compute(b,this._x[T]),h=s[0],u=s[1],a=this.renderer.yscale.r_compute(w,this._y[T]),_=a[0],d=a[1],(l=Math.pow(h-u,2)+Math.pow(_-d,2))<=c&&A.push([T,l])}else for(var S=0,M=x;S<M.length;S++){var T=M[S];c=Math.pow(this.sradius[T],2),(l=Math.pow(this.sx[T]-g,2)+Math.pow(this.sy[T]-y,2))<=c&&A.push([T,l])}return o.create_hit_test_result_from_hits(A)},e.prototype._hit_span=function(t){var e,n,i,r,s,a,l,c,h=t.sx,u=t.sy,_=this.bounds(),d=o.create_empty_hit_test_result();if("h"==t.direction){var p=void 0,f=void 0;if(l=_.y0,c=_.y1,null!=this._radius&&"data"==this.model.properties.radius.units)p=h-this.max_radius,f=h+this.max_radius,e=this.renderer.xscale.r_invert(p,f),s=e[0],a=e[1];else{var m=this.max_size/2;p=h-m,f=h+m,n=this.renderer.xscale.r_invert(p,f),s=n[0],a=n[1]}}else{var v=void 0,g=void 0;if(s=_.x0,a=_.x1,null!=this._radius&&"data"==this.model.properties.radius.units)v=u-this.max_radius,g=u+this.max_radius,i=this.renderer.yscale.r_invert(v,g),l=i[0],c=i[1];else{var m=this.max_size/2;v=u-m,g=u+m,r=this.renderer.yscale.r_invert(v,g),l=r[0],c=r[1]}}var y=this.index.indices({x0:s,x1:a,y0:l,y1:c});return d.indices=y,d},e.prototype._hit_rect=function(t){var e=t.sx0,n=t.sx1,i=t.sy0,r=t.sy1,s=this.renderer.xscale.r_invert(e,n),a=s[0],l=s[1],c=this.renderer.yscale.r_invert(i,r),h=c[0],u=c[1],_=o.create_empty_hit_test_result();return _.indices=this.index.indices({x0:a,x1:l,y0:h,y1:u}),_},e.prototype._hit_poly=function(t){for(var e=t.sx,n=t.sy,i=a.range(0,this.sx.length),r=[],s=0,l=i.length;s<l;s++){var c=i[s];o.point_in_poly(this.sx[s],this.sy[s],e,n)&&r.push(c)}var h=o.create_empty_hit_test_result();return h.indices=r,h},e.prototype.draw_legend_for_index=function(t,e,n){var i=e.x0,r=e.y0,o=e.x1,s=e.y1,a=n+1,l=new Array(a);l[n]=(i+o)/2;var c=new Array(a);c[n]=(r+s)/2;var h=new Array(a);h[n]=.2*Math.min(Math.abs(o-i),Math.abs(s-r)),this._render(t,[n],{sx:l,sy:c,sradius:h})},e.__name__="CircleView",e}(r.XYGlyphView);n.CircleView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.mixins(["line","fill"]),this.define({angle:[s.AngleSpec,0],size:[s.DistanceSpec,{units:"screen",value:4}],radius:[s.DistanceSpec],radius_dimension:[s.RadiusDimension,"x"]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.properties.radius.optional=!0},e.__name__="Circle",e}(r.XYGlyph);n.Circle=h,h.initClass()},function(t,e,n){var i=t(421),r=t(126),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="EllipseView",e}(r.EllipseOvalView);n.EllipseView=o;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=o},e.__name__="Ellipse",e}(r.EllipseOval);n.Ellipse=s,s.initClass()},function(t,e,n){var i=t(421),r=t(123),o=t(9),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},e.prototype._render=function(t,e,n){for(var i=n.sx,r=n.sy,o=n.sw,s=n.sh,a=n._angle,l=0,c=e;l<c.length;l++){var h=c[l];isNaN(i[h]+r[h]+o[h]+s[h]+a[h])||(t.beginPath(),t.ellipse(i[h],r[h],o[h]/2,s[h]/2,a[h],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,h),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,h),t.stroke()))}},e.prototype._hit_point=function(t){var e,n,i,r,s,a,l,c,h,u,_,d,p,f=t.sx,m=t.sy,v=this.renderer.xscale.invert(f),g=this.renderer.yscale.invert(m);"data"==this.model.properties.width.units?(s=v-this.max_width,a=v+this.max_width):(u=f-this.max_width,_=f+this.max_width,e=this.renderer.xscale.r_invert(u,_),s=e[0],a=e[1]),"data"==this.model.properties.height.units?(l=g-this.max_height,c=g+this.max_height):(d=m-this.max_height,p=m+this.max_height,n=this.renderer.yscale.r_invert(d,p),l=n[0],c=n[1]);for(var y=this.index.indices({x0:s,x1:a,y0:l,y1:c}),b=[],w=0,x=y;w<x.length;w++){var A=x[w];o.point_in_ellipse(f,m,this._angle[A],this.sh[A]/2,this.sw[A]/2,this.sx[A],this.sy[A])&&(i=this.renderer.xscale.r_compute(v,this._x[A]),u=i[0],_=i[1],r=this.renderer.yscale.r_compute(g,this._y[A]),d=r[0],p=r[1],h=Math.pow(u-_,2)+Math.pow(d-p,2),b.push([A,h]))}return o.create_hit_test_result_from_hits(b)},e.prototype.draw_legend_for_index=function(t,e,n){var i=e.x0,r=e.y0,o=e.x1,s=e.y1,a=n+1,l=new Array(a);l[n]=(i+o)/2;var c=new Array(a);c[n]=(r+s)/2;var h=this.sw[n]/this.sh[n],u=.8*Math.min(Math.abs(o-i),Math.abs(s-r)),_=new Array(a),d=new Array(a);h>1?(_[n]=u,d[n]=u/h):(_[n]=u*h,d[n]=u),this._render(t,[n],{sx:l,sy:c,sw:_,sh:d,_angle:[0]})},e.prototype._bounds=function(t){var e=t.x0,n=t.x1,i=t.y0,r=t.y1;return{x0:e-this.max_w2,x1:n+this.max_w2,y0:i-this.max_h2,y1:r+this.max_h2}},e.__name__="EllipseOvalView",e}(r.CenterRotatableView);n.EllipseOvalView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="EllipseOval",e}(r.CenterRotatable);n.EllipseOval=a},function(t,e,n){var i=t(421),r=t(9),o=t(18),s=t(27),a=t(36),l=t(51),c=t(50),h=t(62),u=t(17),_=t(25),d=t(35),p=t(46),f=t(136),m=t(192),v=function(e){function n(){var t=null!==e&&e.apply(this,arguments)||this;return t._nohit_warned={},t}return i.__extends(n,e),Object.defineProperty(n.prototype,"renderer",{get:function(){return this.parent},enumerable:!0,configurable:!0}),n.prototype.initialize=function(){e.prototype.initialize.call(this),this._nohit_warned={},this.visuals=new l.Visuals(this.model);var n=this.renderer.plot_view.gl;if(null!=n){var i=null;try{i=t(503)}catch(t){if("MODULE_NOT_FOUND"!==t.code)throw t;u.logger.warn("WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.")}if(null!=i){var r=i[this.model.type+"GLGlyph"];null!=r&&(this.glglyph=new r(n.ctx,this))}}},n.prototype.set_visuals=function(t){this.visuals.warm_cache(t),null!=this.glglyph&&this.glglyph.set_visuals_changed()},n.prototype.render=function(t,e,n){t.beginPath(),null!=this.glglyph&&this.glglyph.render(t,e,n)||this._render(t,e,n)},n.prototype.has_finished=function(){return!0},n.prototype.notify_finished=function(){this.renderer.notify_finished()},n.prototype._bounds=function(t){return t},n.prototype.bounds=function(){return this._bounds(this.index.bbox)},n.prototype.log_bounds=function(){for(var t=s.empty(),e=this.index.search(s.positive_x()),n=0,i=e;n<i.length;n++){var r=i[n];r.x0<t.x0&&(t.x0=r.x0),r.x1>t.x1&&(t.x1=r.x1)}for(var o=this.index.search(s.positive_y()),a=0,l=o;a<l.length;a++){var c=l[a];c.y0<t.y0&&(t.y0=c.y0),c.y1>t.y1&&(t.y1=c.y1)}return this._bounds(t)},n.prototype.get_anchor_point=function(t,e,n){var i=n[0],r=n[1];switch(t){case"center":return{x:this.scenterx(e,i,r),y:this.scentery(e,i,r)};default:return null}},n.prototype.sdist=function(t,e,n,i,r){var o,s;void 0===i&&(i="edge"),void 0===r&&(r=!1);var a=e.length;if("center"==i){var l=_.map(n,function(t){return t/2});o=new Float64Array(a);for(var c=0;c<a;c++)o[c]=e[c]-l[c];s=new Float64Array(a);for(var c=0;c<a;c++)s[c]=e[c]+l[c]}else{o=e,s=new Float64Array(a);for(var c=0;c<a;c++)s[c]=o[c]+n[c]}var h=t.v_compute(o),u=t.v_compute(s);return r?_.map(h,function(t,e){return Math.ceil(Math.abs(u[e]-h[e]))}):_.map(h,function(t,e){return Math.abs(u[e]-h[e])})},n.prototype.draw_legend_for_index=function(t,e,n){},n.prototype.hit_test=function(t){var e=null,n="_hit_"+t.type;return null!=this[n]?e=this[n](t):null==this._nohit_warned[t.type]&&(u.logger.debug("'"+t.type+"' selection not available for "+this.model.type),this._nohit_warned[t.type]=!0),e},n.prototype._hit_rect_against_index=function(t){var e=t.sx0,n=t.sx1,i=t.sy0,o=t.sy1,s=this.renderer.xscale.r_invert(e,n),a=s[0],l=s[1],c=this.renderer.yscale.r_invert(i,o),h=c[0],u=c[1],_=r.create_empty_hit_test_result();return _.indices=this.index.indices({x0:a,x1:l,y0:h,y1:u}),_},n.prototype.set_data=function(t,e,n){var i,r,o,s,l=this.model.materialize_dataspecs(t);if(this.visuals.set_all_indices(e),e&&!(this instanceof f.LineView)){var c={},h=function(t){var n=l[t];"_"===t.charAt(0)?c[t]=e.map(function(t){return n[t]}):c[t]=n};for(var u in l)h(u);l=c}if(d.extend(this,l),this.renderer.plot_view.model.use_map&&(null!=this._x&&(i=a.project_xy(this._x,this._y),this._x=i[0],this._y=i[1]),null!=this._xs&&(r=a.project_xsys(this._xs,this._ys),this._xs=r[0],this._ys=r[1]),null!=this._x0&&(o=a.project_xy(this._x0,this._y0),this._x0=o[0],this._y0=o[1]),null!=this._x1&&(s=a.project_xy(this._x1,this._y1),this._x1=s[0],this._y1=s[1])),null!=this.renderer.plot_view.frame.x_ranges)for(var p=this.renderer.plot_view.frame.x_ranges[this.model.x_range_name],v=this.renderer.plot_view.frame.y_ranges[this.model.y_range_name],g=0,y=this.model._coords;g<y.length;g++){var b=y[g],w=b[0],x=b[1];w="_"+w,x="_"+x,null!=this._xs?(p instanceof m.FactorRange&&(this[w]=_.map(this[w],function(t){return p.v_synthetic(t)})),v instanceof m.FactorRange&&(this[x]=_.map(this[x],function(t){return v.v_synthetic(t)}))):(p instanceof m.FactorRange&&(this[w]=p.v_synthetic(this[w])),v instanceof m.FactorRange&&(this[x]=v.v_synthetic(this[x])))}null!=this.glglyph&&this.glglyph.set_data_changed(this._x.length),this._set_data(n),this.index_data()},n.prototype._set_data=function(t){},n.prototype.index_data=function(){this.index=this._index_data()},n.prototype.mask_data=function(t){return null!=this.glglyph||null==this._mask_data?t:this._mask_data()},n.prototype.map_data=function(){for(var t,e=0,n=this.model._coords;e<n.length;e++){var i=n[e],r=i[0],o=i[1],s="s"+r,a="s"+o;if(o="_"+o,null!=this[r="_"+r]&&(p.isArray(this[r][0])||p.isTypedArray(this[r][0]))){var l=this[r].length;this[s]=new Array(l),this[a]=new Array(l);for(var c=0;c<l;c++){var h=this.map_to_screen(this[r][c],this[o][c]),u=h[0],_=h[1];this[s][c]=u,this[a][c]=_}}else t=this.map_to_screen(this[r],this[o]),this[s]=t[0],this[a]=t[1]}this._map_data()},n.prototype._map_data=function(){},n.prototype.map_to_screen=function(t,e){return this.renderer.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)},n.__name__="GlyphView",n}(c.View);n.GlyphView=v;var g=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype._coords=[],this.internal({x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]})},e.coords=function(t){var e=this.prototype._coords.concat(t);this.prototype._coords=e;for(var n={},i=0,r=t;i<r.length;i++){var s=r[i],a=s[0],l=s[1];n[a]=[o.CoordinateSpec],n[l]=[o.CoordinateSpec]}this.define(n)},e.__name__="Glyph",e}(h.Model);n.Glyph=g,g.initClass()},function(t,e,n){var i=t(421),r=t(120),o=t(39),s=t(9),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,n=this._x1.length;e<n;e++){var i=this._x1[e],r=this._x2[e],s=this._y[e];!isNaN(i+r+s)&&isFinite(i+r+s)&&t.push({x0:Math.min(i,r),y0:s,x1:Math.max(i,r),y1:s,i:e})}return new o.SpatialIndex(t)},e.prototype._inner=function(t,e,n,i,r){t.beginPath();for(var o=0,s=e.length;o<s;o++)t.lineTo(e[o],i[o]);for(var a=n.length-1,o=a;o>=0;o--)t.lineTo(n[o],i[o]);t.closePath(),r.call(t)},e.prototype._render=function(t,e,n){var i=this,r=n.sx1,o=n.sx2,s=n.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,r,o,s,t.fill)),this.visuals.hatch.doit2(t,0,function(){return i._inner(t,r,o,s,t.fill)},function(){return i.renderer.request_render()})},e.prototype._hit_point=function(t){for(var e=this,n=s.create_empty_hit_test_result(),i=this.sy.length,r=new Float64Array(2*i),o=new Float64Array(2*i),a=0,l=i;a<l;a++)r[a]=this.sx1[a],o[a]=this.sy[a],r[i+a]=this.sx2[i-a-1],o[i+a]=this.sy[i-a-1];return s.point_in_poly(t.sx,t.sy,r,o)&&(n.add_to_selected_glyphs(this.model),n.get_view=function(){return e}),n},e.prototype.scenterx=function(t){return(this.sx1[t]+this.sx2[t])/2},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._map_data=function(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)},e.__name__="HAreaView",e}(r.AreaView);n.HAreaView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({x1:[a.CoordinateSpec],x2:[a.CoordinateSpec],y:[a.CoordinateSpec]})},e.__name__="HArea",e}(r.Area);n.HArea=c,c.initClass()},function(t,e,n){var i=t(421),r=t(122),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.scenterx=function(t){return(this.sleft[t]+this.sright[t])/2},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._index_data=function(){return this._index_box(this._y.length)},e.prototype._lrtb=function(t){var e=Math.min(this._left[t],this._right[t]),n=Math.max(this._left[t],this._right[t]),i=this._y[t]+.5*this._height[t],r=this._y[t]-.5*this._height[t];return[e,n,i,r]},e.prototype._map_data=function(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);var t=this.sy.length;this.stop=new Float64Array(t),this.sbottom=new Float64Array(t);for(var e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()},e.__name__="HBarView",e}(r.BoxView);n.HBarView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s,this.coords([["left","y"]]),this.define({height:[o.NumberSpec],right:[o.CoordinateSpec]}),this.override({left:0})},e.__name__="HBar",e}(r.Box);n.HBar=a,a.initClass()},function(t,e,n){var i=t(421),r=t(127),o=t(9),s=t(18),a=t(39),l=t(149),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._set_data=function(){var t=this._q.length,e=this.model.size,n=this.model.aspect_scale;if(this._x=new Float64Array(t),this._y=new Float64Array(t),"pointytop"==this.model.orientation)for(var i=0;i<t;i++)this._x[i]=e*Math.sqrt(3)*(this._q[i]+this._r[i]/2)/n,this._y[i]=3*-e/2*this._r[i];else for(var i=0;i<t;i++)this._x[i]=3*e/2*this._q[i],this._y[i]=-e*Math.sqrt(3)*(this._r[i]+this._q[i]/2)*n},e.prototype._index_data=function(){var t,e=this.model.size,n=Math.sqrt(3)*e/2;"flattop"==this.model.orientation?(n=(t=[e,n])[0],e=t[1],e*=this.model.aspect_scale):n/=this.model.aspect_scale;for(var i=[],r=0;r<this._x.length;r++){var o=this._x[r],s=this._y[r];!isNaN(o+s)&&isFinite(o+s)&&i.push({x0:o-n,y0:s-e,x1:o+n,y1:s+e,i:r})}return new a.SpatialIndex(i)},e.prototype.map_data=function(){var t,e;t=this.map_to_screen(this._x,this._y),this.sx=t[0],this.sy=t[1],e=this._get_unscaled_vertices(),this.svx=e[0],this.svy=e[1]},e.prototype._get_unscaled_vertices=function(){var t=this.model.size,e=this.model.aspect_scale;if("pointytop"==this.model.orientation){var n=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(n.compute(0)-n.compute(t)),o=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(t))/e,s=r/2,a=[0,-o,-o,0,o,o],l=[r,s,-s,-r,-s,s];return[a,l]}var n=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(n.compute(0)-n.compute(t)),o=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(t))*e,s=r/2,a=[r,s,-s,-r,-s,s],l=[0,-o,-o,0,o,o];return[a,l]},e.prototype._render=function(t,e,n){for(var i=n.sx,r=n.sy,o=n.svx,s=n.svy,a=n._scale,l=0,c=e;l<c.length;l++){var h=c[l];if(!isNaN(i[h]+r[h]+a[h])){t.translate(i[h],r[h]),t.beginPath();for(var u=0;u<6;u++)t.lineTo(o[u]*a[h],s[u]*a[h]);t.closePath(),t.translate(-i[h],-r[h]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,h),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,h),t.stroke())}}},e.prototype._hit_point=function(t){for(var e=t.sx,n=t.sy,i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(n),s=this.index.indices({x0:i,y0:r,x1:i,y1:r}),a=[],l=0,c=s;l<c.length;l++){var h=c[l];o.point_in_poly(e-this.sx[h],n-this.sy[h],this.svx,this.svy)&&a.push(h)}var u=o.create_empty_hit_test_result();return u.indices=a,u},e.prototype._hit_span=function(t){var e,n=t.sx,i=t.sy;if("v"==t.direction){var r=this.renderer.yscale.invert(i),s=this.renderer.plot_view.frame.bbox.h_range,a=this.renderer.xscale.r_invert(s.start,s.end),l=a[0],c=a[1];e=this.index.indices({x0:l,y0:r,x1:c,y1:r})}else{var h=this.renderer.xscale.invert(n),u=this.renderer.plot_view.frame.bbox.v_range,_=this.renderer.yscale.r_invert(u.start,u.end),d=_[0],p=_[1];e=this.index.indices({x0:h,y0:d,x1:h,y1:p})}var f=o.create_empty_hit_test_result();return f.indices=e,f},e.prototype._hit_rect=function(t){var e=t.sx0,n=t.sx1,i=t.sy0,r=t.sy1,s=this.renderer.xscale.r_invert(e,n),a=s[0],l=s[1],c=this.renderer.yscale.r_invert(i,r),h=c[0],u=c[1],_=o.create_empty_hit_test_result();return _.indices=this.index.indices({x0:a,x1:l,y0:h,y1:u}),_},e.prototype.draw_legend_for_index=function(t,e,n){l.generic_area_legend(this.visuals,t,e,n)},e.__name__="HexTileView",e}(r.GlyphView);n.HexTileView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.coords([["r","q"]]),this.mixins(["line","fill"]),this.define({size:[s.Number,1],aspect_scale:[s.Number,1],scale:[s.NumberSpec,1],orientation:[s.HexTileOrientation,"pointytop"]}),this.override({line_color:null})},e.__name__="HexTile",e}(r.Glyph);n.HexTile=h,h.initClass()},function(t,e,n){var i=t(421),r=t(132),o=t(178),s=t(18),a=t(24),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.color_mapper.change,function(){return e._update_image()}),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},e.prototype._update_image=function(){null!=this.image_data&&(this._set_data(),this.renderer.plot_view.request_render())},e.prototype._set_data=function(){this._set_width_heigh_data();for(var t=this.model.color_mapper.rgba_mapper,e=0,n=this._image.length;e<n;e++){var i=void 0;if(null!=this._image_shape&&this._image_shape[e].length>0){i=this._image[e];var r=this._image_shape[e];this._height[e]=r[0],this._width[e]=r[1]}else{var o=this._image[e];i=a.concat(o),this._height[e]=o.length,this._width[e]=o[0].length}var s=t.v_compute(i);this._set_image_data_from_buffer(e,s)}},e.prototype._render=function(t,e,n){var i=n.image_data,r=n.sx,o=n.sy,s=n.sw,a=n.sh,l=t.getImageSmoothingEnabled();t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.global_alpha;for(var c=0,h=e;c<h.length;c++){var u=h[c];if(null!=i[u]&&!isNaN(r[u]+o[u]+s[u]+a[u])){var _=o[u];t.translate(0,_),t.scale(1,-1),t.translate(0,-_),t.drawImage(i[u],0|r[u],0|o[u],s[u],a[u]),t.translate(0,_),t.scale(1,-1),t.translate(0,-_)}}t.setImageSmoothingEnabled(l)},e.__name__="ImageView",e}(r.ImageBaseView);n.ImageView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({color_mapper:[s.Instance,function(){return new o.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})}]})},e.__name__="Image",e}(r.ImageBase);n.Image=c,c.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(18),s=t(9),a=t(39),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._render=function(t,e,n){},e.prototype._index_data=function(){for(var t=[],e=0,n=this._x.length;e<n;e++){var i=this._lrtb(e),r=i[0],o=i[1],s=i[2],l=i[3];!isNaN(r+o+s+l)&&isFinite(r+o+s+l)&&t.push({x0:r,y0:l,x1:o,y1:s,i:e})}return new a.SpatialIndex(t)},e.prototype._lrtb=function(t){var e=this.renderer.xscale.source_range,n=this._x[t],i=e.is_reversed?n-this._dw[t]:n+this._dw[t],r=this.renderer.yscale.source_range,o=this._y[t],s=r.is_reversed?o-this._dh[t]:o+this._dh[t],a=n<i?[n,i]:[i,n],l=a[0],c=a[1],h=o<s?[o,s]:[s,o],u=h[0],_=h[1];return[l,c,_,u]},e.prototype._set_width_heigh_data=function(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new Array(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new Array(this._image.length))},e.prototype._get_or_create_canvas=function(t){var e=this.image_data[t];if(null!=e&&e.width==this._width[t]&&e.height==this._height[t])return e;var n=document.createElement("canvas");return n.width=this._width[t],n.height=this._height[t],n},e.prototype._set_image_data_from_buffer=function(t,e){var n=this._get_or_create_canvas(t),i=n.getContext("2d"),r=i.getImageData(0,0,this._width[t],this._height[t]);r.data.set(e),i.putImageData(r,0,0),this.image_data[t]=n},e.prototype._map_data=function(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}},e.prototype._image_index=function(t,e,n){var i=this._lrtb(t),r=i[0],o=i[1],s=i[2],a=i[3],l=this._width[t],c=this._height[t],h=(o-r)/l,u=(s-a)/c,_=Math.floor((e-r)/h),d=Math.floor((n-a)/u);return{index:t,dim1:_,dim2:d,flat_index:d*l+_}},e.prototype._hit_point=function(t){var e=t.sx,n=t.sy,i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(n),o=this.index.indices({x0:i,x1:i,y0:r,y1:r}),a=s.create_empty_hit_test_result();a.image_indices=[];for(var l=0,c=o;l<c.length;l++){var h=c[l];e!=1/0&&n!=1/0&&a.image_indices.push(this._image_index(h,i,r))}return a},e.__name__="ImageBaseView",e}(r.XYGlyphView);n.ImageBaseView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({image:[o.NumberSpec],dw:[o.DistanceSpec],dh:[o.DistanceSpec],dilate:[o.Boolean,!1],global_alpha:[o.Number,1]})},e.__name__="ImageBase",e}(r.XYGlyph);n.ImageBase=c,c.initClass()},function(t,e,n){var i=t(421),r=t(132),o=t(24),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},e.prototype._set_data=function(t){this._set_width_heigh_data();for(var e=0,n=this._image.length;e<n;e++)if(!(null!=t&&t.indexOf(e)<0)){var i=void 0;if(null!=this._image_shape&&this._image_shape[e].length>0){i=this._image[e].buffer;var r=this._image_shape[e];this._height[e]=r[0],this._width[e]=r[1]}else{var s=this._image[e],a=o.concat(s);i=new ArrayBuffer(4*a.length);for(var l=new Uint32Array(i),c=0,h=a.length;c<h;c++)l[c]=a[c];this._height[e]=s.length,this._width[e]=s[0].length}var u=new Uint8Array(i);this._set_image_data_from_buffer(e,u)}},e.prototype._render=function(t,e,n){var i=n.image_data,r=n.sx,o=n.sy,s=n.sw,a=n.sh,l=t.getImageSmoothingEnabled();t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.global_alpha;for(var c=0,h=e;c<h.length;c++){var u=h[c];if(!isNaN(r[u]+o[u]+s[u]+a[u])){var _=o[u];t.translate(0,_),t.scale(1,-1),t.translate(0,-_),t.drawImage(i[u],0|r[u],0|o[u],s[u],a[u]),t.translate(0,_),t.scale(1,-1),t.translate(0,-_)}}t.setImageSmoothingEnabled(l)},e.__name__="ImageRGBAView",e}(r.ImageBaseView);n.ImageRGBAView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s},e.__name__="ImageRGBA",e}(r.ImageBase);n.ImageRGBA=a,a.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(17),s=t(18),a=t(25),l=t(39),c=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._images_rendered=!1,e}return i.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},e.prototype._index_data=function(){return new l.SpatialIndex([])},e.prototype._set_data=function(){var t=this;null!=this.image&&this.image.length==this._url.length||(this.image=a.map(this._url,function(){return null}));var e=this.model,n=e.retry_attempts,i=e.retry_timeout;this.retries=a.map(this._url,function(){return n});for(var r=function(e,r){var a=s._url[e];if(null==a||""==a)return"continue";var l=new Image;l.onerror=function(){t.retries[e]>0?(o.logger.trace("ImageURL failed to load "+a+" image, retrying in "+i+" ms"),setTimeout(function(){return l.src=a},i)):o.logger.warn("ImageURL unable to load "+a+" image after "+n+" retries"),t.retries[e]-=1},l.onload=function(){t.image[e]=l,t.renderer.request_render()},l.src=a},s=this,l=0,c=this._url.length;l<c;l++)r(l,c);for(var h="data"==this.model.properties.w.units,u="data"==this.model.properties.h.units,_=this._x.length,d=new Array(h?2*_:_),p=new Array(u?2*_:_),l=0;l<_;l++)d[l]=this._x[l],p[l]=this._y[l];if(h)for(var l=0;l<_;l++)d[_+l]=this._x[l]+this._w[l];if(u)for(var l=0;l<_;l++)p[_+l]=this._y[l]+this._h[l];var f=a.min(d),m=a.max(d),v=a.min(p),g=a.max(p);this._bounds_rect={x0:f,x1:m,y0:v,y1:g}},e.prototype.has_finished=function(){return t.prototype.has_finished.call(this)&&1==this._images_rendered},e.prototype._map_data=function(){var t=null!=this.model.w?this._w:a.map(this._x,function(){return NaN}),e=null!=this.model.h?this._h:a.map(this._x,function(){return NaN});switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,t,"edge",this.model.dilate);break;case"screen":this.sw=t}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,e,"edge",this.model.dilate);break;case"screen":this.sh=e}},e.prototype._render=function(t,e,n){var i=n.image,r=n.sx,o=n.sy,s=n.sw,a=n.sh,l=n._angle,c=this.renderer.plot_view.frame;t.rect(c._left.value+1,c._top.value+1,c._width.value-2,c._height.value-2),t.clip();for(var h=!0,u=0,_=e;u<_.length;u++){var d=_[u];if(!isNaN(r[d]+o[d]+l[d])){var p=i[d];null!=p?this._render_image(t,d,p,r,o,s,a,l):h=!1}}h&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())},e.prototype._final_sx_sy=function(t,e,n,i,r){switch(t){case"top_left":return[e,n];case"top_center":return[e-i/2,n];case"top_right":return[e-i,n];case"center_right":return[e-i,n-r/2];case"bottom_right":return[e-i,n-r];case"bottom_center":return[e-i/2,n-r];case"bottom_left":return[e,n-r];case"center_left":return[e,n-r/2];case"center":return[e-i/2,n-r/2]}},e.prototype._render_image=function(t,e,n,i,r,o,s,a){isNaN(o[e])&&(o[e]=n.width),isNaN(s[e])&&(s[e]=n.height);var l=this.model.anchor,c=this._final_sx_sy(l,i[e],r[e],o[e],s[e]),h=c[0],u=c[1];t.save(),t.globalAlpha=this.model.global_alpha,a[e]?(t.translate(h,u),t.rotate(a[e]),t.drawImage(n,0,0,o[e],s[e]),t.rotate(-a[e]),t.translate(-h,-u)):t.drawImage(n,h,u,o[e],s[e]),t.restore()},e.prototype.bounds=function(){return this._bounds_rect},e.__name__="ImageURLView",e}(r.XYGlyphView);n.ImageURLView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({url:[s.StringSpec],anchor:[s.Anchor,"top_left"],global_alpha:[s.Number,1],angle:[s.AngleSpec,0],w:[s.DistanceSpec],h:[s.DistanceSpec],dilate:[s.Boolean,!1],retry_attempts:[s.Number,0],retry_timeout:[s.Number,0]})},e.__name__="ImageURL",e}(r.XYGlyph);n.ImageURL=h,h.initClass()},function(t,e,n){var i=t(117);n.AnnularWedge=i.AnnularWedge;var r=t(118);n.Annulus=r.Annulus;var o=t(119);n.Arc=o.Arc;var s=t(121);n.Bezier=s.Bezier;var a=t(124);n.Circle=a.Circle;var l=t(123);n.CenterRotatable=l.CenterRotatable;var c=t(125);n.Ellipse=c.Ellipse;var h=t(126);n.EllipseOval=h.EllipseOval;var u=t(127);n.Glyph=u.Glyph;var _=t(128);n.HArea=_.HArea;var d=t(129);n.HBar=d.HBar;var p=t(130);n.HexTile=p.HexTile;var f=t(131);n.Image=f.Image;var m=t(133);n.ImageRGBA=m.ImageRGBA;var v=t(134);n.ImageURL=v.ImageURL;var g=t(136);n.Line=g.Line;var y=t(137);n.MultiLine=y.MultiLine;var b=t(138);n.MultiPolygons=b.MultiPolygons;var w=t(139);n.Oval=w.Oval;var x=t(140);n.Patch=x.Patch;var A=t(141);n.Patches=A.Patches;var k=t(142);n.Quad=k.Quad;var C=t(143);n.Quadratic=C.Quadratic;var T=t(144);n.Ray=T.Ray;var S=t(145);n.Rect=S.Rect;var M=t(146);n.Segment=M.Segment;var E=t(147);n.Step=E.Step;var z=t(148);n.Text=z.Text;var O=t(150);n.VArea=O.VArea;var P=t(151);n.VBar=P.VBar;var j=t(152);n.Wedge=j.Wedge;var N=t(153);n.XYGlyph=N.XYGlyph},function(t,e,n){var i=t(421),r=t(153),o=t(149),s=t(9),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._render=function(t,e,n){var i=n.sx,r=n.sy,o=!1,s=null;this.visuals.line.set_value(t);for(var a=0,l=e;a<l.length;a++){var c=l[a];if(o){if(!isFinite(i[c]+r[c])){t.stroke(),t.beginPath(),o=!1,s=c;continue}null!=s&&c-s>1&&(t.stroke(),o=!1)}o?t.lineTo(i[c],r[c]):(t.beginPath(),t.moveTo(i[c],r[c]),o=!0),s=c}o&&t.stroke()},e.prototype._hit_point=function(t){for(var e=this,n=s.create_empty_hit_test_result(),i={x:t.sx,y:t.sy},r=9999,o=Math.max(2,this.visuals.line.line_width.value()/2),a=0,l=this.sx.length-1;a<l;a++){var c={x:this.sx[a],y:this.sy[a]},h={x:this.sx[a+1],y:this.sy[a+1]},u=s.dist_to_segment(i,c,h);u<o&&u<r&&(r=u,n.add_to_selected_glyphs(this.model),n.get_view=function(){return e},n.line_indices=[a])}return n},e.prototype._hit_span=function(t){var e,n,i=this,r=t.sx,o=t.sy,a=s.create_empty_hit_test_result();"v"==t.direction?(e=this.renderer.yscale.invert(o),n=this._y):(e=this.renderer.xscale.invert(r),n=this._x);for(var l=0,c=n.length-1;l<c;l++)(n[l]<=e&&e<=n[l+1]||n[l+1]<=e&&e<=n[l])&&(a.add_to_selected_glyphs(this.model),a.get_view=function(){return i},a.line_indices.push(l));return a},e.prototype.get_interpolation_hit=function(t,e){var n=[this._x[t],this._y[t],this._x[t+1],this._y[t+1]],i=n[0],r=n[1],s=n[2],a=n[3];return o.line_interpolation(this.renderer,e,i,r,s,a)},e.prototype.draw_legend_for_index=function(t,e,n){o.generic_line_legend(this.visuals,t,e,n)},e.__name__="LineView",e}(r.XYGlyphView);n.LineView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line"])},e.__name__="Line",e}(r.XYGlyph);n.Line=l,l.initClass()},function(t,e,n){var i=t(421),r=t(39),o=t(9),s=t(35),a=t(24),l=t(46),c=t(127),h=t(149),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,n=this._xs.length;e<n;e++)if(null!=this._xs[e]&&0!==this._xs[e].length){for(var i=this._xs[e],o=[],s=0,c=i.length;s<c;s++){var h=i[s];l.isStrictNaN(h)||o.push(h)}for(var u=this._ys[e],_=[],s=0,c=u.length;s<c;s++){var d=u[s];l.isStrictNaN(d)||_.push(d)}var p=[a.min(o),a.max(o)],f=p[0],m=p[1],v=[a.min(_),a.max(_)],g=v[0],y=v[1];t.push({x0:f,y0:g,x1:m,y1:y,i:e})}return new r.SpatialIndex(t)},e.prototype._render=function(t,e,n){for(var i=n.sxs,r=n.sys,o=0,s=e;o<s.length;o++){var a=s[o],l=[i[a],r[a]],c=l[0],h=l[1];this.visuals.line.set_vectorize(t,a);for(var u=0,_=c.length;u<_;u++)0!=u?isNaN(c[u])||isNaN(h[u])?(t.stroke(),t.beginPath()):t.lineTo(c[u],h[u]):(t.beginPath(),t.moveTo(c[u],h[u]));t.stroke()}},e.prototype._hit_point=function(t){for(var e=o.create_empty_hit_test_result(),n={x:t.sx,y:t.sy},i=9999,r={},a=0,l=this.sxs.length;a<l;a++){for(var c=Math.max(2,this.visuals.line.cache_select("line_width",a)/2),h=null,u=0,_=this.sxs[a].length-1;u<_;u++){var d={x:this.sxs[a][u],y:this.sys[a][u]},p={x:this.sxs[a][u+1],y:this.sys[a][u+1]},f=o.dist_to_segment(n,d,p);f<c&&f<i&&(i=f,h=[u])}h&&(r[a]=h)}return e.indices=s.keys(r).map(function(t){return parseInt(t,10)}),e.multiline_indices=r,e},e.prototype._hit_span=function(t){var e,n,i=t.sx,r=t.sy,a=o.create_empty_hit_test_result();"v"===t.direction?(e=this.renderer.yscale.invert(r),n=this._ys):(e=this.renderer.xscale.invert(i),n=this._xs);for(var l={},c=0,h=n.length;c<h;c++){for(var u=[],_=0,d=n[c].length-1;_<d;_++)n[c][_]<=e&&e<=n[c][_+1]&&u.push(_);u.length>0&&(l[c]=u)}return a.indices=s.keys(l).map(function(t){return parseInt(t,10)}),a.multiline_indices=l,a},e.prototype.get_interpolation_hit=function(t,e,n){var i=[this._xs[t][e],this._ys[t][e],this._xs[t][e+1],this._ys[t][e+1]],r=i[0],o=i[1],s=i[2],a=i[3];return h.line_interpolation(this.renderer,n,r,o,s,a)},e.prototype.draw_legend_for_index=function(t,e,n){h.generic_line_legend(this.visuals,t,e,n)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e.__name__="MultiLineView",e}(c.GlyphView);n.MultiLineView=u;var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=u,this.coords([["xs","ys"]]),this.mixins(["line"])},e.__name__="MultiLine",e}(c.Glyph);n.MultiLine=_,_.initClass()},function(t,e,n){var i=t(421),r=t(39),o=t(127),s=t(149),a=t(24),l=t(25),c=t(9),h=t(46),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,n=this._xs.length;e<n;e++)for(var i=0,o=this._xs[e].length;i<o;i++){var s=this._xs[e][i][0],l=this._ys[e][i][0];0!=s.length&&t.push({x0:a.min(s),y0:a.min(l),x1:a.max(s),y1:a.max(l),i:e})}return this.hole_index=this._index_hole_data(),new r.SpatialIndex(t)},e.prototype._index_hole_data=function(){for(var t=[],e=0,n=this._xs.length;e<n;e++)for(var i=0,o=this._xs[e].length;i<o;i++)if(this._xs[e][i].length>1)for(var s=1,l=this._xs[e][i].length;s<l;s++){var c=this._xs[e][i][s],h=this._ys[e][i][s];0!=c.length&&t.push({x0:a.min(c),y0:a.min(h),x1:a.max(c),y1:a.max(h),i:e})}return new r.SpatialIndex(t)},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.x_ranges.default,e=[t.min,t.max],n=e[0],i=e[1],r=this.renderer.plot_view.frame.y_ranges.default,o=[r.min,r.max],s=o[0],a=o[1],l=this.index.indices({x0:n,x1:i,y0:s,y1:a});return l.sort(function(t,e){return t-e}).filter(function(t,e,n){return 0===e||t!==n[e-1]})},e.prototype._inner_loop=function(t,e,n){t.beginPath();for(var i=0,r=e.length;i<r;i++)for(var o=0,s=e[i].length;o<s;o++){for(var a=e[i][o],l=n[i][o],c=0,h=a.length;c<h;c++)0!=c?t.lineTo(a[c],l[c]):t.moveTo(a[c],l[c]);t.closePath()}},e.prototype._render=function(t,e,n){var i=this,r=n.sxs,o=n.sys;if(this.visuals.fill.doit||this.visuals.line.doit)for(var s=function(e){var n=[r[e],o[e]],s=n[0],l=n[1];a.visuals.fill.doit&&(a.visuals.fill.set_vectorize(t,e),a._inner_loop(t,s,l),t.fill("evenodd")),a.visuals.hatch.doit2(t,e,function(){i._inner_loop(t,s,l),t.fill("evenodd")},function(){return i.renderer.request_render()}),a.visuals.line.doit&&(a.visuals.line.set_vectorize(t,e),a._inner_loop(t,s,l),t.stroke())},a=this,l=0,c=e;l<c.length;l++){var h=c[l];s(h)}},e.prototype._hit_point=function(t){for(var e=t.sx,n=t.sy,i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(n),o=this.index.indices({x0:i,y0:r,x1:i,y1:r}),s=this.hole_index.indices({x0:i,y0:r,x1:i,y1:r}),a=[],l=0,h=o.length;l<h;l++)for(var u=o[l],_=this.sxs[u],d=this.sys[u],p=0,f=_.length;p<f;p++){var m=_[p].length;if(c.point_in_poly(e,n,_[p][0],d[p][0]))if(1==m)a.push(u);else if(-1==s.indexOf(u))a.push(u);else if(m>1){for(var v=!1,g=1;g<m;g++){var y=_[p][g],b=d[p][g];if(c.point_in_poly(e,n,y,b)){v=!0;break}}v||a.push(u)}}var w=c.create_empty_hit_test_result();return w.indices=a,w},e.prototype._get_snap_coord=function(t){return l.sum(t)/t.length},e.prototype.scenterx=function(t,e,n){if(1==this.sxs[t].length)return this._get_snap_coord(this.sxs[t][0][0]);for(var i=this.sxs[t],r=this.sys[t],o=0,s=i.length;o<s;o++)if(c.point_in_poly(e,n,i[o][0],r[o][0]))return this._get_snap_coord(i[o][0]);throw new Error("unreachable code")},e.prototype.scentery=function(t,e,n){if(1==this.sys[t].length)return this._get_snap_coord(this.sys[t][0][0]);for(var i=this.sxs[t],r=this.sys[t],o=0,s=i.length;o<s;o++)if(c.point_in_poly(e,n,i[o][0],r[o][0]))return this._get_snap_coord(r[o][0]);throw new Error("unreachable code")},e.prototype.map_data=function(){for(var t=0,e=this.model._coords;t<e.length;t++){var n=e[t],i=n[0],r=n[1],o="s"+i,s="s"+r;if(r="_"+r,null!=this[i="_"+i]&&(h.isArray(this[i][0])||h.isTypedArray(this[i][0]))){var a=this[i].length;this[o]=new Array(a),this[s]=new Array(a);for(var l=0;l<a;l++){var c=this[i][l].length;this[o][l]=new Array(c),this[s][l]=new Array(c);for(var u=0;u<c;u++){var _=this[i][l][u].length;this[o][l][u]=new Array(_),this[s][l][u]=new Array(_);for(var d=0;d<_;d++){var p=this.map_to_screen(this[i][l][u][d],this[r][l][u][d]),f=p[0],m=p[1];this[o][l][u][d]=f,this[s][l][u][d]=m}}}}}},e.prototype.draw_legend_for_index=function(t,e,n){s.generic_area_legend(this.visuals,t,e,n)},e.__name__="MultiPolygonsView",e}(o.GlyphView);n.MultiPolygonsView=u;var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=u,this.coords([["xs","ys"]]),this.mixins(["line","fill","hatch"])},e.__name__="MultiPolygons",e}(o.Glyph);n.MultiPolygons=_,_.initClass()},function(t,e,n){var i=t(421),r=t(126),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._map_data=function(){var t,e=this._x.length;this.sw=new Float64Array(e),t="data"==this.model.properties.width.units?this.sdist(this.renderer.xscale,this._x,this._width,"center"):this._width;for(var n=0;n<e;n++)this.sw[n]=.75*t[n];"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},e.__name__="OvalView",e}(r.EllipseOvalView);n.OvalView=o;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=o},e.__name__="Oval",e}(r.EllipseOval);n.Oval=s,s.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(149),s=t(9),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._inner_loop=function(t,e,n,i,r){for(var o=0,s=e;o<s.length;o++){var a=s[o];0!=a?isNaN(n[a]+i[a])?(t.closePath(),r.apply(t),t.beginPath()):t.lineTo(n[a],i[a]):(t.beginPath(),t.moveTo(n[a],i[a]))}t.closePath(),r.call(t)},e.prototype._render=function(t,e,n){var i=this,r=n.sx,o=n.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner_loop(t,e,r,o,t.fill)),this.visuals.hatch.doit2(t,0,function(){return i._inner_loop(t,e,r,o,t.fill)},function(){return i.renderer.request_render()}),this.visuals.line.doit&&(this.visuals.line.set_value(t),this._inner_loop(t,e,r,o,t.stroke))},e.prototype.draw_legend_for_index=function(t,e,n){o.generic_area_legend(this.visuals,t,e,n)},e.prototype._hit_point=function(t){var e=this,n=s.create_empty_hit_test_result();return s.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(n.add_to_selected_glyphs(this.model),n.get_view=function(){return e}),n},e.__name__="PatchView",e}(r.XYGlyphView);n.PatchView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line","fill","hatch"])},e.__name__="Patch",e}(r.XYGlyph);n.Patch=l,l.initClass()},function(t,e,n){var i=t(421),r=t(39),o=t(127),s=t(149),a=t(24),l=t(25),c=t(46),h=t(9),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._build_discontinuous_object=function(t){for(var e=[],n=0,i=t.length;n<i;n++){e[n]=[];for(var r=a.copy(t[n]);r.length>0;){var o=a.find_last_index(r,function(t){return c.isStrictNaN(t)}),s=void 0;o>=0?s=r.splice(o):(s=r,r=[]);var l=s.filter(function(t){return!c.isStrictNaN(t)});e[n].push(l)}}return e},e.prototype._index_data=function(){for(var t=this._build_discontinuous_object(this._xs),e=this._build_discontinuous_object(this._ys),n=[],i=0,o=this._xs.length;i<o;i++)for(var s=0,l=t[i].length;s<l;s++){var c=t[i][s],h=e[i][s];0!=c.length&&n.push({x0:a.min(c),y0:a.min(h),x1:a.max(c),y1:a.max(h),i:i})}return new r.SpatialIndex(n)},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.x_ranges.default,e=[t.min,t.max],n=e[0],i=e[1],r=this.renderer.plot_view.frame.y_ranges.default,o=[r.min,r.max],s=o[0],a=o[1],l=this.index.indices({x0:n,x1:i,y0:s,y1:a});return l.sort(function(t,e){return t-e})},e.prototype._inner_loop=function(t,e,n,i){for(var r=0,o=e.length;r<o;r++)0!=r?isNaN(e[r]+n[r])?(t.closePath(),i.apply(t),t.beginPath()):t.lineTo(e[r],n[r]):(t.beginPath(),t.moveTo(e[r],n[r]));t.closePath(),i.call(t)},e.prototype._render=function(t,e,n){var i=this,r=n.sxs,o=n.sys;this.sxss=this._build_discontinuous_object(r),this.syss=this._build_discontinuous_object(o);for(var s=function(e){var n=[r[e],o[e]],s=n[0],l=n[1];a.visuals.fill.doit&&(a.visuals.fill.set_vectorize(t,e),a._inner_loop(t,s,l,t.fill)),a.visuals.hatch.doit2(t,e,function(){return i._inner_loop(t,s,l,t.fill)},function(){return i.renderer.request_render()}),a.visuals.line.doit&&(a.visuals.line.set_vectorize(t,e),a._inner_loop(t,s,l,t.stroke))},a=this,l=0,c=e;l<c.length;l++){var h=c[l];s(h)}},e.prototype._hit_point=function(t){for(var e=t.sx,n=t.sy,i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(n),o=this.index.indices({x0:i,y0:r,x1:i,y1:r}),s=[],a=0,l=o.length;a<l;a++)for(var c=o[a],u=this.sxss[c],_=this.syss[c],d=0,p=u.length;d<p;d++)h.point_in_poly(e,n,u[d],_[d])&&s.push(c);var f=h.create_empty_hit_test_result();return f.indices=s,f},e.prototype._get_snap_coord=function(t){return l.sum(t)/t.length},e.prototype.scenterx=function(t,e,n){if(1==this.sxss[t].length)return this._get_snap_coord(this.sxs[t]);for(var i=this.sxss[t],r=this.syss[t],o=0,s=i.length;o<s;o++)if(h.point_in_poly(e,n,i[o],r[o]))return this._get_snap_coord(i[o]);throw new Error("unreachable code")},e.prototype.scentery=function(t,e,n){if(1==this.syss[t].length)return this._get_snap_coord(this.sys[t]);for(var i=this.sxss[t],r=this.syss[t],o=0,s=i.length;o<s;o++)if(h.point_in_poly(e,n,i[o],r[o]))return this._get_snap_coord(r[o]);throw new Error("unreachable code")},e.prototype.draw_legend_for_index=function(t,e,n){s.generic_area_legend(this.visuals,t,e,n)},e.__name__="PatchesView",e}(o.GlyphView);n.PatchesView=u;var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=u,this.coords([["xs","ys"]]),this.mixins(["line","fill","hatch"])},e.__name__="Patches",e}(o.Glyph);n.Patches=_,_.initClass()},function(t,e,n){var i=t(421),r=t(122),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.scenterx=function(t){return(this.sleft[t]+this.sright[t])/2},e.prototype.scentery=function(t){return(this.stop[t]+this.sbottom[t])/2},e.prototype._index_data=function(){return this._index_box(this._right.length)},e.prototype._lrtb=function(t){var e=this._left[t],n=this._right[t],i=this._top[t],r=this._bottom[t];return[e,n,i,r]},e.__name__="QuadView",e}(r.BoxView);n.QuadView=o;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=o,this.coords([["right","bottom"],["left","top"]])},e.__name__="Quad",e}(r.Box);n.Quad=s,s.initClass()},function(t,e,n){var i=t(421),r=t(39),o=t(127),s=t(149);function a(t,e,n){if(e==(t+n)/2)return[t,n];var i=(t-e)/(t-2*e+n),r=t*Math.pow(1-i,2)+2*e*(1-i)*i+n*Math.pow(i,2);return[Math.min(t,n,r),Math.max(t,n,r)]}var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,n=this._x0.length;e<n;e++)if(!isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx[e]+this._cy[e])){var i=a(this._x0[e],this._cx[e],this._x1[e]),o=i[0],s=i[1],l=a(this._y0[e],this._cy[e],this._y1[e]),c=l[0],h=l[1];t.push({x0:o,y0:c,x1:s,y1:h,i:e})}return new r.SpatialIndex(t)},e.prototype._render=function(t,e,n){var i=n.sx0,r=n.sy0,o=n.sx1,s=n.sy1,a=n.scx,l=n.scy;if(this.visuals.line.doit)for(var c=0,h=e;c<h.length;c++){var u=h[c];isNaN(i[u]+r[u]+o[u]+s[u]+a[u]+l[u])||(t.beginPath(),t.moveTo(i[u],r[u]),t.quadraticCurveTo(a[u],l[u],o[u],s[u]),this.visuals.line.set_vectorize(t,u),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,n){s.generic_line_legend(this.visuals,t,e,n)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e.__name__="QuadraticView",e}(o.GlyphView);n.QuadraticView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.coords([["x0","y0"],["x1","y1"],["cx","cy"]]),this.mixins(["line"])},e.__name__="Quadratic",e}(o.Glyph);n.Quadratic=c,c.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(149),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length},e.prototype._render=function(t,e,n){var i=n.sx,r=n.sy,o=n.slength,s=n._angle;if(this.visuals.line.doit){for(var a=this.renderer.plot_view.frame._width.value,l=this.renderer.plot_view.frame._height.value,c=2*(a+l),h=0,u=o.length;h<u;h++)0==o[h]&&(o[h]=c);for(var _=0,d=e;_<d.length;_++){var h=d[_];isNaN(i[h]+r[h]+s[h]+o[h])||(t.translate(i[h],r[h]),t.rotate(s[h]),t.beginPath(),t.moveTo(0,0),t.lineTo(o[h],0),this.visuals.line.set_vectorize(t,h),t.stroke(),t.rotate(-s[h]),t.translate(-i[h],-r[h]))}}},e.prototype.draw_legend_for_index=function(t,e,n){o.generic_line_legend(this.visuals,t,e,n)},e.__name__="RayView",e}(r.XYGlyphView);n.RayView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line"]),this.define({length:[s.DistanceSpec],angle:[s.AngleSpec]})},e.__name__="Ray",e}(r.XYGlyph);n.Ray=l,l.initClass()},function(t,e,n){var i=t(421),r=t(123),o=t(149),s=t(9),a=t(18),l=t(25),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){var t,e;if("data"==this.model.properties.width.units)t=this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale),this.sw=t[0],this.sx0=t[1];else{this.sw=this._width;var n=this.sx.length;this.sx0=new Float64Array(n);for(var i=0;i<n;i++)this.sx0[i]=this.sx[i]-this.sw[i]/2}if("data"==this.model.properties.height.units)e=this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale),this.sh=e[0],this.sy1=e[1];else{this.sh=this._height;var r=this.sy.length;this.sy1=new Float64Array(r);for(var i=0;i<r;i++)this.sy1[i]=this.sy[i]-this.sh[i]/2}var o=this.sw.length;this.ssemi_diag=new Float64Array(o);for(var i=0;i<o;i++)this.ssemi_diag[i]=Math.sqrt(this.sw[i]/2*this.sw[i]/2+this.sh[i]/2*this.sh[i]/2)},e.prototype._render=function(t,e,n){var i=n.sx,r=n.sy,o=n.sx0,s=n.sy1,a=n.sw,l=n.sh,c=n._angle;if(this.visuals.fill.doit)for(var h=0,u=e;h<u.length;h++){var _=u[h];isNaN(i[_]+r[_]+o[_]+s[_]+a[_]+l[_]+c[_])||(this.visuals.fill.set_vectorize(t,_),c[_]?(t.translate(i[_],r[_]),t.rotate(c[_]),t.fillRect(-a[_]/2,-l[_]/2,a[_],l[_]),t.rotate(-c[_]),t.translate(-i[_],-r[_])):t.fillRect(o[_],s[_],a[_],l[_]))}if(this.visuals.line.doit){t.beginPath();for(var d=0,p=e;d<p.length;d++){var _=p[d];isNaN(i[_]+r[_]+o[_]+s[_]+a[_]+l[_]+c[_])||0!=a[_]&&0!=l[_]&&(c[_]?(t.translate(i[_],r[_]),t.rotate(c[_]),t.rect(-a[_]/2,-l[_]/2,a[_],l[_]),t.rotate(-c[_]),t.translate(-i[_],-r[_])):t.rect(o[_],s[_],a[_],l[_]),this.visuals.line.set_vectorize(t,_),t.stroke(),t.beginPath())}t.stroke()}},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){for(var e=t.sx,n=t.sy,i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(n),o=[],a=0,c=this.sx0.length;a<c;a++)o.push(this.sx0[a]+this.sw[a]/2);for(var h=[],a=0,c=this.sy1.length;a<c;a++)h.push(this.sy1[a]+this.sh[a]/2);for(var u=l.max(this._ddist(0,o,this.ssemi_diag)),_=l.max(this._ddist(1,h,this.ssemi_diag)),d=i-u,p=i+u,f=r-_,m=r+_,v=[],g=0,y=this.index.indices({x0:d,x1:p,y0:f,y1:m});g<y.length;g++){var a=y[g],b=void 0,w=void 0;if(this._angle[a]){var x=Math.sin(-this._angle[a]),A=Math.cos(-this._angle[a]),k=A*(e-this.sx[a])-x*(n-this.sy[a])+this.sx[a],C=x*(e-this.sx[a])+A*(n-this.sy[a])+this.sy[a];e=k,n=C,w=Math.abs(this.sx[a]-e)<=this.sw[a]/2,b=Math.abs(this.sy[a]-n)<=this.sh[a]/2}else w=e-this.sx0[a]<=this.sw[a]&&e-this.sx0[a]>=0,b=n-this.sy1[a]<=this.sh[a]&&n-this.sy1[a]>=0;b&&w&&v.push(a)}var T=s.create_empty_hit_test_result();return T.indices=v,T},e.prototype._map_dist_corner_for_data_side_length=function(t,e,n){for(var i=t.length,r=new Float64Array(i),o=new Float64Array(i),s=0;s<i;s++)r[s]=Number(t[s])-e[s]/2,o[s]=Number(t[s])+e[s]/2;for(var a=n.v_compute(r),l=n.v_compute(o),c=this.sdist(n,r,e,"edge",this.model.dilate),h=a,s=0,u=a.length;s<u;s++)if(a[s]!=l[s]){h=a[s]<l[s]?a:l;break}return[c,h]},e.prototype._ddist=function(t,e,n){for(var i=0==t?this.renderer.xscale:this.renderer.yscale,r=e,o=r.length,s=new Float64Array(o),a=0;a<o;a++)s[a]=r[a]+n[a];for(var l=i.v_invert(r),c=i.v_invert(s),h=l.length,u=new Float64Array(h),a=0;a<h;a++)u[a]=Math.abs(c[a]-l[a]);return u},e.prototype.draw_legend_for_index=function(t,e,n){o.generic_area_legend(this.visuals,t,e,n)},e.prototype._bounds=function(t){var e=t.x0,n=t.x1,i=t.y0,r=t.y1;return{x0:e-this.max_w2,x1:n+this.max_w2,y0:i-this.max_h2,y1:r+this.max_h2}},e.__name__="RectView",e}(r.CenterRotatableView);n.RectView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({dilate:[a.Boolean,!1]})},e.__name__="Rect",e}(r.CenterRotatable);n.Rect=h,h.initClass()},function(t,e,n){var i=t(421),r=t(9),o=t(39),s=t(127),a=t(149),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,n=this._x0.length;e<n;e++){var i=this._x0[e],r=this._x1[e],s=this._y0[e],a=this._y1[e];isNaN(i+r+s+a)||t.push({x0:Math.min(i,r),y0:Math.min(s,a),x1:Math.max(i,r),y1:Math.max(s,a),i:e})}return new o.SpatialIndex(t)},e.prototype._render=function(t,e,n){var i=n.sx0,r=n.sy0,o=n.sx1,s=n.sy1;if(this.visuals.line.doit)for(var a=0,l=e;a<l.length;a++){var c=l[a];isNaN(i[c]+r[c]+o[c]+s[c])||(t.beginPath(),t.moveTo(i[c],r[c]),t.lineTo(o[c],s[c]),this.visuals.line.set_vectorize(t,c),t.stroke())}},e.prototype._hit_point=function(t){for(var e=t.sx,n=t.sy,i={x:e,y:n},o=[],s=this.renderer.xscale.r_invert(e-2,e+2),a=s[0],l=s[1],c=this.renderer.yscale.r_invert(n-2,n+2),h=c[0],u=c[1],_=this.index.indices({x0:a,y0:h,x1:l,y1:u}),d=0,p=_;d<p.length;d++){var f=p[d],m=Math.pow(Math.max(2,this.visuals.line.cache_select("line_width",f)/2),2),v={x:this.sx0[f],y:this.sy0[f]},g={x:this.sx1[f],y:this.sy1[f]},y=r.dist_to_segment_squared(i,v,g);y<m&&o.push(f)}var b=r.create_empty_hit_test_result();return b.indices=o,b},e.prototype._hit_span=function(t){var e,n,i,o,s,a=this.renderer.plot_view.frame.bbox.ranges,l=a[0],c=a[1],h=t.sx,u=t.sy;"v"==t.direction?(s=this.renderer.yscale.invert(u),e=[this._y0,this._y1],i=e[0],o=e[1]):(s=this.renderer.xscale.invert(h),n=[this._x0,this._x1],i=n[0],o=n[1]);for(var _=[],d=this.renderer.xscale.r_invert(l.start,l.end),p=d[0],f=d[1],m=this.renderer.yscale.r_invert(c.start,c.end),v=m[0],g=m[1],y=this.index.indices({x0:p,y0:v,x1:f,y1:g}),b=0,w=y;b<w.length;b++){var x=w[b];(i[x]<=s&&s<=o[x]||o[x]<=s&&s<=i[x])&&_.push(x)}var A=r.create_empty_hit_test_result();return A.indices=_,A},e.prototype.scenterx=function(t){return(this.sx0[t]+this.sx1[t])/2},e.prototype.scentery=function(t){return(this.sy0[t]+this.sy1[t])/2},e.prototype.draw_legend_for_index=function(t,e,n){a.generic_line_legend(this.visuals,t,e,n)},e.__name__="SegmentView",e}(s.GlyphView);n.SegmentView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.coords([["x0","y0"],["x1","y1"]]),this.mixins(["line"])},e.__name__="Segment",e}(s.Glyph);n.Segment=c,c.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(149),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._render=function(t,e,n){var i,r,o,s,a,l,c=n.sx,h=n.sy,u=!1,_=null;this.visuals.line.set_value(t);var d=e.length;if(!(d<2)){t.beginPath(),t.moveTo(c[0],h[0]);for(var p=0,f=e;p<f.length;p++){var m=f[p],v=void 0,g=void 0,y=void 0,b=void 0;switch(this.model.mode){case"before":i=[c[m-1],h[m]],v=i[0],y=i[1],r=[c[m],h[m]],g=r[0],b=r[1];break;case"after":o=[c[m],h[m-1]],v=o[0],y=o[1],s=[c[m],h[m]],g=s[0],b=s[1];break;case"center":var w=(c[m-1]+c[m])/2;a=[w,h[m-1]],v=a[0],y=a[1],l=[w,h[m]],g=l[0],b=l[1];break;default:throw new Error("unexpected")}if(u){if(!isFinite(c[m]+h[m])){t.stroke(),t.beginPath(),u=!1,_=m;continue}null!=_&&m-_>1&&(t.stroke(),u=!1)}u?(t.lineTo(v,y),t.lineTo(g,b)):(t.beginPath(),t.moveTo(c[m],h[m]),u=!0),_=m}t.lineTo(c[d-1],h[d-1]),t.stroke()}},e.prototype.draw_legend_for_index=function(t,e,n){o.generic_line_legend(this.visuals,t,e,n)},e.__name__="StepView",e}(r.XYGlyphView);n.StepView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line"]),this.define({mode:[s.StepMode,"before"]})},e.__name__="Step",e}(r.XYGlyph);n.Step=l,l.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(9),s=t(18),a=t(43),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._rotate_point=function(t,e,n,i,r){var o=(t-n)*Math.cos(r)-(e-i)*Math.sin(r)+n,s=(t-n)*Math.sin(r)+(e-i)*Math.cos(r)+i;return[o,s]},e.prototype._text_bounds=function(t,e,n,i){var r=[t,t+n,t+n,t,t],o=[e,e,e-i,e-i,e];return[r,o]},e.prototype._render=function(t,e,n){var i=n.sx,r=n.sy,o=n._x_offset,s=n._y_offset,l=n._angle,c=n._text;this._sys=[],this._sxs=[];for(var h=0,u=e;h<u.length;h++){var _=u[h];if(!isNaN(i[_]+r[_]+o[_]+s[_]+l[_])&&null!=c[_]&&(this._sxs[_]=[],this._sys[_]=[],this.visuals.text.doit)){var d=""+c[_];t.save(),t.translate(i[_]+o[_],r[_]+s[_]),t.rotate(l[_]),this.visuals.text.set_vectorize(t,_);var p=this.visuals.text.cache_select("font",_),f=a.measure_font(p).height,m=this.visuals.text.text_line_height.value()*f;if(-1==d.indexOf("\n")){t.fillText(d,0,0);var v=i[_]+o[_],g=r[_]+s[_],y=t.measureText(d).width,b=this._text_bounds(v,g,y,m),w=b[0],x=b[1];this._sxs[_].push(w),this._sys[_].push(x)}else{var A=d.split("\n"),k=m*A.length,C=this.visuals.text.cache_select("text_baseline",_),T=void 0;switch(C){case"top":T=0;break;case"middle":T=-k/2+m/2;break;case"bottom":T=-k+m;break;default:T=0,console.warn("'"+C+"' baseline not supported with multi line text")}for(var S=0,M=A;S<M.length;S++){var E=M[S];t.fillText(E,0,T);var v=i[_]+o[_],g=T+r[_]+s[_],y=t.measureText(E).width,z=this._text_bounds(v,g,y,m),w=z[0],x=z[1];this._sxs[_].push(w),this._sys[_].push(x),T+=m}}t.restore()}}},e.prototype._hit_point=function(t){for(var e=t.sx,n=t.sy,i=[],r=0;r<this._sxs.length;r++)for(var s=this._sxs[r],a=this._sys[r],l=s.length,c=0,h=l;c<h;c++){var u=this._rotate_point(e,n,s[l-1][0],a[l-1][0],-this._angle[r]),_=u[0],d=u[1];o.point_in_poly(_,d,s[c],a[c])&&i.push(r)}var p=o.create_empty_hit_test_result();return p.indices=i,p},e.prototype._scenterxy=function(t){var e=this._sxs[t][0][0],n=this._sys[t][0][0],i=(this._sxs[t][0][2]+e)/2,r=(this._sys[t][0][2]+n)/2,o=this._rotate_point(i,r,e,n,this._angle[t]),s=o[0],a=o[1];return{x:s,y:a}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e.__name__="TextView",e}(r.XYGlyphView);n.TextView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.mixins(["text"]),this.define({text:[s.NullStringSpec,{field:"text"}],angle:[s.AngleSpec,0],x_offset:[s.NumberSpec,0],y_offset:[s.NumberSpec,0]})},e.__name__="Text",e}(r.XYGlyph);n.Text=c,c.initClass()},function(t,e,n){var i=t(9);n.generic_line_legend=function(t,e,n,i){var r=n.x0,o=n.x1,s=n.y0,a=n.y1;e.save(),e.beginPath(),e.moveTo(r,(s+a)/2),e.lineTo(o,(s+a)/2),t.line.doit&&(t.line.set_vectorize(e,i),e.stroke()),e.restore()},n.generic_area_legend=function(t,e,n,i){var r=n.x0,o=n.x1,s=n.y0,a=n.y1,l=.1*Math.abs(o-r),c=.1*Math.abs(a-s),h=r+l,u=o-l,_=s+c,d=a-c;t.fill.doit&&(t.fill.set_vectorize(e,i),e.fillRect(h,_,u-h,d-_)),null!=t.hatch&&t.hatch.doit&&(t.hatch.set_vectorize(e,i),e.fillRect(h,_,u-h,d-_)),t.line&&t.line.doit&&(e.beginPath(),e.rect(h,_,u-h,d-_),t.line.set_vectorize(e,i),e.stroke())},n.line_interpolation=function(t,e,n,r,o,s){var a,l,c,h,u,_,d,p,f,m,v=e.sx,g=e.sy;"point"==e.type?(a=t.yscale.r_invert(g-1,g+1),f=a[0],m=a[1],l=t.xscale.r_invert(v-1,v+1),d=l[0],p=l[1]):"v"==e.direction?(c=t.yscale.r_invert(g,g),f=c[0],m=c[1],h=[Math.min(n-1,o-1),Math.max(n+1,o+1)],d=h[0],p=h[1]):(u=t.xscale.r_invert(v,v),d=u[0],p=u[1],_=[Math.min(r-1,s-1),Math.max(r+1,s+1)],f=_[0],m=_[1]);var y=i.check_2_segments_intersect(d,f,p,m,n,r,o,s),b=y.x,w=y.y;return[b,w]}},function(t,e,n){var i=t(421),r=t(120),o=t(39),s=t(9),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,n=this._x.length;e<n;e++){var i=this._x[e],r=this._y1[e],s=this._y2[e];!isNaN(i+r+s)&&isFinite(i+r+s)&&t.push({x0:i,y0:Math.min(r,s),x1:i,y1:Math.max(r,s),i:e})}return new o.SpatialIndex(t)},e.prototype._inner=function(t,e,n,i,r){t.beginPath();for(var o=0,s=n.length;o<s;o++)t.lineTo(e[o],n[o]);for(var a=i.length-1,o=a;o>=0;o--)t.lineTo(e[o],i[o]);t.closePath(),r.call(t)},e.prototype._render=function(t,e,n){var i=this,r=n.sx,o=n.sy1,s=n.sy2;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,r,o,s,t.fill)),this.visuals.hatch.doit2(t,0,function(){return i._inner(t,r,o,s,t.fill)},function(){return i.renderer.request_render()})},e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return(this.sy1[t]+this.sy2[t])/2},e.prototype._hit_point=function(t){for(var e=this,n=s.create_empty_hit_test_result(),i=this.sx.length,r=new Float64Array(2*i),o=new Float64Array(2*i),a=0,l=i;a<l;a++)r[a]=this.sx[a],o[a]=this.sy1[a],r[i+a]=this.sx[i-a-1],o[i+a]=this.sy2[i-a-1];return s.point_in_poly(t.sx,t.sy,r,o)&&(n.add_to_selected_glyphs(this.model),n.get_view=function(){return e}),n},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)},e.__name__="VAreaView",e}(r.AreaView);n.VAreaView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({x:[a.CoordinateSpec],y1:[a.CoordinateSpec],y2:[a.CoordinateSpec]})},e.__name__="VArea",e}(r.Area);n.VArea=c,c.initClass()},function(t,e,n){var i=t(421),r=t(122),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return(this.stop[t]+this.sbottom[t])/2},e.prototype._index_data=function(){return this._index_box(this._x.length)},e.prototype._lrtb=function(t){var e=this._x[t]-this._width[t]/2,n=this._x[t]+this._width[t]/2,i=Math.max(this._top[t],this._bottom[t]),r=Math.min(this._top[t],this._bottom[t]);return[e,n,i,r]},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);var t=this.sx.length;this.sleft=new Float64Array(t),this.sright=new Float64Array(t);for(var e=0;e<t;e++)this.sleft[e]=this.sx[e]-this.sw[e]/2,this.sright[e]=this.sx[e]+this.sw[e]/2;this._clamp_viewport()},e.__name__="VBarView",e}(r.BoxView);n.VBarView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s,this.coords([["x","bottom"]]),this.define({width:[o.NumberSpec],top:[o.CoordinateSpec]}),this.override({bottom:0})},e.__name__="VBar",e}(r.Box);n.VBar=a,a.initClass()},function(t,e,n){var i=t(421),r=t(153),o=t(149),s=t(9),a=t(18),l=t(34),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},e.prototype._render=function(t,e,n){for(var i=n.sx,r=n.sy,o=n.sradius,s=n._start_angle,a=n._end_angle,l=this.model.properties.direction.value(),c=0,h=e;c<h.length;c++){var u=h[c];isNaN(i[u]+r[u]+o[u]+s[u]+a[u])||(t.beginPath(),t.arc(i[u],r[u],o[u],s[u],a[u],l),t.lineTo(i[u],r[u]),t.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,u),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,u),t.stroke()))}},e.prototype._hit_point=function(t){var e,n,i,r,o,a,c,h,u,_,d,p,f,m=t.sx,v=t.sy,g=this.renderer.xscale.invert(m),y=this.renderer.yscale.invert(v),b=2*this.max_radius;"data"===this.model.properties.radius.units?(_=g-b,d=g+b,p=y-b,f=y+b):(a=m-b,c=m+b,e=this.renderer.xscale.r_invert(a,c),_=e[0],d=e[1],h=v-b,u=v+b,n=this.renderer.yscale.r_invert(h,u),p=n[0],f=n[1]);for(var w=[],x=0,A=this.index.indices({x0:_,x1:d,y0:p,y1:f});x<A.length;x++){var k=A[x],C=Math.pow(this.sradius[k],2);i=this.renderer.xscale.r_compute(g,this._x[k]),a=i[0],c=i[1],r=this.renderer.yscale.r_compute(y,this._y[k]),h=r[0],u=r[1],(o=Math.pow(a-c,2)+Math.pow(h-u,2))<=C&&w.push([k,o])}for(var T=this.model.properties.direction.value(),S=[],M=0,E=w;M<E.length;M++){var z=E[M],k=z[0],O=z[1],P=Math.atan2(v-this.sy[k],m-this.sx[k]);l.angle_between(-P,-this._start_angle[k],-this._end_angle[k],T)&&S.push([k,O])}return s.create_hit_test_result_from_hits(S)},e.prototype.draw_legend_for_index=function(t,e,n){o.generic_area_legend(this.visuals,t,e,n)},e.prototype._scenterxy=function(t){var e=this.sradius[t]/2,n=(this._start_angle[t]+this._end_angle[t])/2;return{x:this.sx[t]+e*Math.cos(n),y:this.sy[t]+e*Math.sin(n)}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e.__name__="WedgeView",e}(r.XYGlyphView);n.WedgeView=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.mixins(["line","fill"]),this.define({direction:[a.Direction,"anticlock"],radius:[a.DistanceSpec],start_angle:[a.AngleSpec],end_angle:[a.AngleSpec]})},e.__name__="Wedge",e}(r.XYGlyph);n.Wedge=h,h.initClass()},function(t,e,n){var i=t(421),r=t(39),o=t(127),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,n=this._x.length;e<n;e++){var i=this._x[e],o=this._y[e];!isNaN(i+o)&&isFinite(i+o)&&t.push({x0:i,y0:o,x1:i,y1:o,i:e})}return new r.SpatialIndex(t)},e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return this.sy[t]},e.__name__="XYGlyphView",e}(o.GlyphView);n.XYGlyphView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.coords([["x","y"]])},e.__name__="XYGlyph",e}(o.Glyph);n.XYGlyph=a,a.initClass()},function(t,e,n){var i=t(421),r=t(62),o=t(25),s=t(24),a=t(9),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype._hit_test_nodes=function(t,e){if(!e.model.visible)return null;var n=e.node_view.glyph.hit_test(t);return null==n?null:e.node_view.model.view.convert_selection_from_subset(n)},e.prototype._hit_test_edges=function(t,e){if(!e.model.visible)return null;var n=e.edge_view.glyph.hit_test(t);return null==n?null:e.edge_view.model.view.convert_selection_from_subset(n)},e.__name__="GraphHitTestPolicy",e}(r.Model);n.GraphHitTestPolicy=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.hit_test=function(t,e){return this._hit_test_nodes(t,e)},e.prototype.do_selection=function(t,e,n,i){if(null==t)return!1;var r=e.node_renderer.data_source.selected;return r.update(t,n,i),e.node_renderer.data_source._select.emit(),!r.is_empty()},e.prototype.do_inspection=function(t,e,n,i,r){if(null==t)return!1;var o=n.model.get_selection_manager().get_or_create_inspector(n.node_view.model);return o.update(t,i,r),n.node_view.model.data_source.setv({inspected:o},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:e}]),!o.is_empty()},e.__name__="NodesOnly",e}(l);n.NodesOnly=c;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.hit_test=function(t,e){return this._hit_test_nodes(t,e)},e.prototype.get_linked_edges=function(t,e,n){var i=[];"selection"==n?i=t.selected.indices.map(function(e){return t.data.index[e]}):"inspection"==n&&(i=t.inspected.indices.map(function(e){return t.data.index[e]}));for(var r=[],o=0;o<e.data.start.length;o++)(s.contains(i,e.data.start[o])||s.contains(i,e.data.end[o]))&&r.push(o);for(var l=a.create_empty_hit_test_result(),c=0,h=r;c<h.length;c++){var o=h[c];l.multiline_indices[o]=[0]}return l.indices=r,l},e.prototype.do_selection=function(t,e,n,i){if(null==t)return!1;var r=e.node_renderer.data_source.selected;r.update(t,n,i);var o=e.edge_renderer.data_source.selected,s=this.get_linked_edges(e.node_renderer.data_source,e.edge_renderer.data_source,"selection");return o.update(s,n,i),e.node_renderer.data_source._select.emit(),!r.is_empty()},e.prototype.do_inspection=function(t,e,n,i,r){if(null==t)return!1;var o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(t,i,r),n.node_view.model.data_source.setv({inspected:o},{silent:!0});var s=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),a=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return s.update(a,i,r),n.edge_view.model.data_source.setv({inspected:s},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:e}]),!o.is_empty()},e.__name__="NodesAndLinkedEdges",e}(l);n.NodesAndLinkedEdges=h;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.hit_test=function(t,e){return this._hit_test_edges(t,e)},e.prototype.get_linked_nodes=function(t,e,n){var i=[];"selection"==n?i=e.selected.indices:"inspection"==n&&(i=e.inspected.indices);for(var r=[],l=0,c=i;l<c.length;l++){var h=c[l];r.push(e.data.start[h]),r.push(e.data.end[h])}var u=s.uniq(r).map(function(e){return o.indexOf(t.data.index,e)}),_=a.create_empty_hit_test_result();return _.indices=u,_},e.prototype.do_selection=function(t,e,n,i){if(null==t)return!1;var r=e.edge_renderer.data_source.selected;r.update(t,n,i);var o=e.node_renderer.data_source.selected,s=this.get_linked_nodes(e.node_renderer.data_source,e.edge_renderer.data_source,"selection");return o.update(s,n,i),e.edge_renderer.data_source._select.emit(),!r.is_empty()},e.prototype.do_inspection=function(t,e,n,i,r){if(null==t)return!1;var o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(t,i,r),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});var s=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),a=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return s.update(a,i,r),n.node_view.model.data_source.setv({inspected:s},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view,{geometry:e}]),!o.is_empty()},e.__name__="EdgesAndLinkedNodes",e}(l);n.EdgesAndLinkedNodes=u},function(t,e,n){var i=t(421);i.__exportStar(t(154),n),i.__exportStar(t(156),n),i.__exportStar(t(157),n)},function(t,e,n){var i=t(421),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="LayoutProvider",e}(r.Model);n.LayoutProvider=o},function(t,e,n){var i=t(421),r=t(156),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({graph_layout:[o.Any,{}]})},e.prototype.get_node_coordinates=function(t){for(var e=[],n=[],i=t.data.index,r=0,o=i.length;r<o;r++){var s=this.graph_layout[i[r]],a=null!=s?s:[NaN,NaN],l=a[0],c=a[1];e.push(l),n.push(c)}return[e,n]},e.prototype.get_edge_coordinates=function(t){for(var e,n,i=[],r=[],o=t.data.start,s=t.data.end,a=null!=t.data.xs&&null!=t.data.ys,l=0,c=o.length;l<c;l++){var h=null!=this.graph_layout[o[l]]&&null!=this.graph_layout[s[l]];if(a&&h)i.push(t.data.xs[l]),r.push(t.data.ys[l]);else{var u=void 0,_=void 0;h?(e=[this.graph_layout[o[l]],this.graph_layout[s[l]]],_=e[0],u=e[1]):(_=(n=[[NaN,NaN],[NaN,NaN]])[0],u=n[1]),i.push([_[0],u[0]]),r.push([_[1],u[1]])}}return[i,r]},e.__name__="StaticLayoutProvider",e}(r.LayoutProvider);n.StaticLayoutProvider=s,s.initClass()},function(t,e,n){var i=t(421),r=t(199),o=t(18),s=t(46),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"_x_range_name",{get:function(){return this.model.x_range_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_y_range_name",{get:function(){return this.model.y_range_name},enumerable:!0,configurable:!0}),e.prototype.render=function(){if(this.model.visible){var t=this.plot_view.canvas_view.ctx;t.save(),this._draw_regions(t),this._draw_minor_grids(t),this._draw_grids(t),t.restore()}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.request_render()})},e.prototype._draw_regions=function(t){var e=this;if(this.visuals.band_fill.doit||this.visuals.band_hatch.doit){this.visuals.band_fill.set_value(t);for(var n=this.grid_coords("major",!1),i=n[0],r=n[1],o=function(n){if(n%2!=1)return"continue";var o=s.plot_view.map_to_screen(i[n],r[n],s._x_range_name,s._y_range_name),a=o[0],l=o[1],c=s.plot_view.map_to_screen(i[n+1],r[n+1],s._x_range_name,s._y_range_name),h=c[0],u=c[1];s.visuals.band_fill.doit&&t.fillRect(a[0],l[0],h[1]-a[0],u[1]-l[0]),s.visuals.band_hatch.doit2(t,n,function(){t.fillRect(a[0],l[0],h[1]-a[0],u[1]-l[0])},function(){return e.request_render()})},s=this,a=0;a<i.length-1;a++)o(a)}},e.prototype._draw_grids=function(t){if(this.visuals.grid_line.doit){var e=this.grid_coords("major"),n=e[0],i=e[1];this._draw_grid_helper(t,this.visuals.grid_line,n,i)}},e.prototype._draw_minor_grids=function(t){if(this.visuals.minor_grid_line.doit){var e=this.grid_coords("minor"),n=e[0],i=e[1];this._draw_grid_helper(t,this.visuals.minor_grid_line,n,i)}},e.prototype._draw_grid_helper=function(t,e,n,i){e.set_value(t);for(var r=0;r<n.length;r++){var o=this.plot_view.map_to_screen(n[r],i[r],this._x_range_name,this._y_range_name),s=o[0],a=o[1];t.beginPath(),t.moveTo(Math.round(s[0]),Math.round(a[0]));for(var l=1;l<s.length;l++)t.lineTo(Math.round(s[l]),Math.round(a[l]));t.stroke()}},e.prototype.ranges=function(){var t=this.model.dimension,e=(t+1)%2,n=this.plot_view.frame,i=[n.x_ranges[this.model.x_range_name],n.y_ranges[this.model.y_range_name]];return[i[t],i[e]]},e.prototype.computed_bounds=function(){var t,e,n,i=this.ranges()[0],r=this.model.bounds,o=[i.min,i.max];if(s.isArray(r))e=Math.min(r[0],r[1]),n=Math.max(r[0],r[1]),e<o[0]&&(e=o[0]),n>o[1]&&(n=o[1]);else{e=o[0],n=o[1];for(var a=0,l=this.plot_view.axis_views;a<l.length;a++){var c=l[a];c.dimension==this.model.dimension&&c.model.x_range_name==this.model.x_range_name&&c.model.y_range_name==this.model.y_range_name&&(t=c.computed_bounds,e=t[0],n=t[1])}}return[e,n]},e.prototype.grid_coords=function(t,e){var n;void 0===e&&(e=!0);var i=this.model.dimension,r=(i+1)%2,o=this.ranges(),s=o[0],a=o[1],l=this.computed_bounds(),c=l[0],h=l[1];n=[Math.min(c,h),Math.max(c,h)],c=n[0],h=n[1];var u=this.model.ticker.get_ticks(c,h,s,a.min,{})[t],_=s.min,d=s.max,p=a.min,f=a.max,m=[[],[]];e||(u[0]!=_&&u.splice(0,0,_),u[u.length-1]!=d&&u.push(d));for(var v=0;v<u.length;v++)if(u[v]!=_&&u[v]!=d||!e){for(var g=[],y=[],b=0;b<2;b++){var w=p+(f-p)/1*b;g.push(u[v]),y.push(w)}m[i].push(g),m[r].push(y)}return m},e.__name__="GridView",e}(r.GuideRendererView);n.GridView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.mixins(["line:grid_","line:minor_grid_","fill:band_","hatch:band_"]),this.define({bounds:[o.Any,"auto"],dimension:[o.Any,0],ticker:[o.Instance],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},e.__name__="Grid",e}(r.GuideRenderer);n.Grid=l,l.initClass()},function(t,e,n){var i=t(158);n.Grid=i.Grid},function(t,e,n){var i=t(421);i.__exportStar(t(69),n),i.__exportStar(t(86),n),i.__exportStar(t(92),n),i.__exportStar(t(96),n),i.__exportStar(t(99),n),i.__exportStar(t(105),n),i.__exportStar(t(111),n),i.__exportStar(t(135),n),i.__exportStar(t(155),n),i.__exportStar(t(159),n),i.__exportStar(t(165),n),i.__exportStar(t(177),n),i.__exportStar(t(292),n),i.__exportStar(t(182),n),i.__exportStar(t(187),n),i.__exportStar(t(193),n),i.__exportStar(t(200),n),i.__exportStar(t(203),n),i.__exportStar(t(207),n),i.__exportStar(t(216),n),i.__exportStar(t(232),n),i.__exportStar(t(242),n),i.__exportStar(t(222),n),i.__exportStar(t(278),n)},function(t,e,n){var i=t(421),r=t(166),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,function(){return e.rebuild()})},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.children},enumerable:!0,configurable:!0}),e.__name__="BoxView",e}(r.LayoutDOMView);n.BoxView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({children:[o.Array,[]],spacing:[o.Number,0]})},e.__name__="Box",e}(r.LayoutDOM);n.Box=a,a.initClass()},function(t,e,n){var i=t(421),r=t(161),o=t(11),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._update_layout=function(){var t=this.child_views.map(function(t){return t.layout});this.layout=new o.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())},e.__name__="ColumnView",e}(r.BoxView);n.ColumnView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({rows:[s.Any,"auto"]})},e.__name__="Column",e}(r.Box);n.Column=l,l.initClass()},function(t,e,n){var i=t(421),r=t(166),o=t(11),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,function(){return e.rebuild()})},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.children.map(function(t){var e=t[0];return e})},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new o.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(var t=0,e=this.model.children;t<e.length;t++){var n=e[t],i=n[0],r=n[1],s=n[2],a=n[3],l=n[4],c=this._child_views[i.id];this.layout.items.push({layout:c.layout,row:r,col:s,row_span:a,col_span:l})}this.layout.set_sizing(this.box_sizing())},e.__name__="GridBoxView",e}(r.LayoutDOMView);n.GridBoxView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({children:[s.Array,[]],rows:[s.Any,"auto"],cols:[s.Any,"auto"],spacing:[s.Any,0]})},e.__name__="GridBox",e}(r.LayoutDOM);n.GridBox=l,l.initClass()},function(t,e,n){var i=t(421),r=t(166),o=t(13),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new o.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())},e.__name__="HTMLBoxView",e}(r.LayoutDOMView);n.HTMLBoxView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="HTMLBox",e}(r.LayoutDOM);n.HTMLBox=a},function(t,e,n){var i=t(161);n.Box=i.Box;var r=t(162);n.Column=r.Column;var o=t(163);n.GridBox=o.GridBox;var s=t(164);n.HTMLBox=s.HTMLBox;var a=t(166);n.LayoutDOM=a.LayoutDOM;var l=t(167);n.Row=l.Row;var c=t(168);n.Spacer=c.Spacer;var h=t(169);n.Panel=h.Panel,n.Tabs=h.Tabs;var u=t(170);n.WidgetBox=u.WidgetBox},function(t,e,n){var i=t(421),r=t(62),o=t(5),s=t(17),a=t(46),l=t(18),c=t(4),h=t(6),u=t(311),_=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._idle_notified=!1,e._offset_parent=null,e._viewport={},e}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el.style.position=this.is_root?"relative":"absolute",this._child_views={},this.build_child_views()},e.prototype.remove=function(){for(var e=0,n=this.child_views;e<n.length;e++){var i=n[e];i.remove()}this._child_views={},t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.is_root&&(this._on_resize=function(){return e.resize_layout()},window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval(function(){var t=e.el.offsetParent;e._offset_parent!=t&&(e._offset_parent=t,null!=t&&(e.compute_viewport(),e.invalidate_layout()))},250));var n=this.model.properties;this.on_change([n.width,n.height,n.min_width,n.min_height,n.max_width,n.max_height,n.margin,n.width_policy,n.height_policy,n.sizing_mode,n.aspect_ratio,n.visible,n.background],function(){return e.invalidate_layout()}),this.on_change([n.css_classes],function(){return e.invalidate_render()})},e.prototype.disconnect_signals=function(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),t.prototype.disconnect_signals.call(this)},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(this.model.css_classes)},Object.defineProperty(e.prototype,"child_views",{get:function(){var t=this;return this.child_models.map(function(e){return t._child_views[e.id]})},enumerable:!0,configurable:!0}),e.prototype.build_child_views=function(){c.build_views(this._child_views,this.child_models,{parent:this})},e.prototype.render=function(){var e;t.prototype.render.call(this),o.empty(this.el);var n=this.model.background;this.el.style.backgroundColor=null!=n?n:"",(e=o.classes(this.el).clear()).add.apply(e,this.css_classes());for(var i=0,r=this.child_views;i<r.length;i++){var s=r[i];this.el.appendChild(s.el),s.render()}},e.prototype.update_layout=function(){for(var t=0,e=this.child_views;t<e.length;t++){var n=e[t];n.update_layout()}this._update_layout()},e.prototype.update_position=function(){this.el.style.display=this.model.visible?"block":"none";var t=this.is_root?this.layout.sizing.margin:void 0;o.position(this.el,this.layout.bbox,t);for(var e=0,n=this.child_views;e<n.length;e++){var i=n[e];i.update_position()}},e.prototype.after_layout=function(){for(var t=0,e=this.child_views;t<e.length;t++){var n=e[t];n.after_layout()}this._has_finished=!0},e.prototype.compute_viewport=function(){this._viewport=this._viewport_size()},e.prototype.renderTo=function(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()},e.prototype.build=function(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this},e.prototype.rebuild=function(){this.build_child_views(),this.invalidate_render()},e.prototype.compute_layout=function(){var t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),s.logger.debug("layout computed in "+(Date.now()-t)+" ms"),this.notify_finished()},e.prototype.resize_layout=function(){this.root.compute_viewport(),this.root.compute_layout()},e.prototype.invalidate_layout=function(){this.root.update_layout(),this.root.compute_layout()},e.prototype.invalidate_render=function(){this.render(),this.invalidate_layout()},e.prototype.has_finished=function(){if(!t.prototype.has_finished.call(this))return!1;for(var e=0,n=this.child_views;e<n.length;e++){var i=n[e];if(!i.has_finished())return!1}return!0},e.prototype.notify_finished=function(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()},e.prototype._width_policy=function(){return null!=this.model.width?"fixed":"fit"},e.prototype._height_policy=function(){return null!=this.model.height?"fixed":"fit"},e.prototype.box_sizing=function(){var t=this.model,e=t.width_policy,n=t.height_policy,i=t.aspect_ratio;"auto"==e&&(e=this._width_policy()),"auto"==n&&(n=this._height_policy());var r=this.model.sizing_mode;if(null!=r)if("fixed"==r)e=n="fixed";else if("stretch_both"==r)e=n="max";else if("stretch_width"==r)e="max";else if("stretch_height"==r)n="max";else switch(null==i&&(i="auto"),r){case"scale_width":e="max",n="min";break;case"scale_height":e="min",n="max";break;case"scale_both":e="max",n="max";break;default:throw new Error("unreachable")}var o={width_policy:e,height_policy:n},s=this.model,l=s.min_width,c=s.min_height;null!=l&&(o.min_width=l),null!=c&&(o.min_height=c);var h=this.model,u=h.width,_=h.height;null!=u&&(o.width=u),null!=_&&(o.height=_);var d=this.model,p=d.max_width,f=d.max_height;null!=p&&(o.max_width=p),null!=f&&(o.max_height=f),"auto"==i&&null!=u&&null!=_?o.aspect=u/_:a.isNumber(i)&&(o.aspect=i);var m=this.model.margin;if(null!=m)if(a.isNumber(m))o.margin={top:m,right:m,bottom:m,left:m};else if(2==m.length){var v=m[0],g=m[1];o.margin={top:v,right:g,bottom:v,left:g}}else{var y=m[0],b=m[1],w=m[2],x=m[3];o.margin={top:y,right:b,bottom:w,left:x}}o.visible=this.model.visible;var A=this.model.align;return a.isArray(A)?(o.halign=A[0],o.valign=A[1]):o.halign=o.valign=A,o},e.prototype._viewport_size=function(){var t=this;return o.undisplayed(this.el,function(){for(var e=t.el;e=e.parentElement;)if(!e.classList.contains(u.bk_root)){if(e==document.body){var n=o.extents(document.body).margin,i=n.left,r=n.right,s=n.top,a=n.bottom,l=Math.ceil(document.documentElement.clientWidth-i-r),c=Math.ceil(document.documentElement.clientHeight-s-a);return{width:l,height:c}}var h=o.extents(e).padding,_=h.left,d=h.right,p=h.top,f=h.bottom,m=e.getBoundingClientRect(),v=m.width,g=m.height,y=Math.ceil(v-_-d),b=Math.ceil(g-p-f);if(y>0||b>0)return{width:y>0?y:void 0,height:b>0?b:void 0}}return{}})},e.prototype.serializable_state=function(){return i.__assign({},t.prototype.serializable_state.call(this),{bbox:this.layout.bbox.box,children:this.child_views.map(function(t){return t.serializable_state()})})},e.__name__="LayoutDOMView",e}(h.DOMView);n.LayoutDOMView=_;var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({width:[l.Number,null],height:[l.Number,null],min_width:[l.Number,null],min_height:[l.Number,null],max_width:[l.Number,null],max_height:[l.Number,null],margin:[l.Any,[0,0,0,0]],width_policy:[l.Any,"auto"],height_policy:[l.Any,"auto"],aspect_ratio:[l.Any,null],sizing_mode:[l.SizingMode,null],visible:[l.Boolean,!0],disabled:[l.Boolean,!1],align:[l.Any,"start"],background:[l.Color,null],css_classes:[l.Array,[]]})},e.__name__="LayoutDOM",e}(r.Model);n.LayoutDOM=d,d.initClass()},function(t,e,n){var i=t(421),r=t(161),o=t(11),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._update_layout=function(){var t=this.child_views.map(function(t){return t.layout});this.layout=new o.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())},e.__name__="RowView",e}(r.BoxView);n.RowView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({cols:[s.Any,"auto"]})},e.__name__="Row",e}(r.Box);n.Row=l,l.initClass()},function(t,e,n){var i=t(421),r=t(166),o=t(13),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new o.LayoutItem,this.layout.set_sizing(this.box_sizing())},e.__name__="SpacerView",e}(r.LayoutDOMView);n.SpacerView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s},e.__name__="Spacer",e}(r.LayoutDOM);n.Spacer=a,a.initClass()},function(t,e,n){var i=t(421),r=t(13),o=t(5),s=t(24),a=t(18),l=t(166),c=t(62),h=t(309),u=t(312),_=t(304),d=t(308),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tabs.change,function(){return e.rebuild()}),this.connect(this.model.properties.active.change,function(){return e.on_active_change()})},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.tabs.map(function(t){return t.child})},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){var t=this.model.tabs_location,e="above"==t||"below"==t,n=this.scroll_el,a=this.headers_el;this.header=new(function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(r,t),r.prototype._measure=function(i){var r=o.size(n),l=o.children(a).slice(0,3).map(function(t){return o.size(t)}),c=t.prototype._measure.call(this,i),h=c.width,u=c.height;if(e){var _=r.width+s.sum(l.map(function(t){return t.width}));return{width:i.width!=1/0?i.width:_,height:u}}var d=r.height+s.sum(l.map(function(t){return t.height}));return{width:h,height:i.height!=1/0?i.height:d}},r}(r.ContentBox))(this.header_el),e?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});var l=1,c=1;switch(t){case"above":l-=1;break;case"below":l+=1;break;case"left":c-=1;break;case"right":c+=1}var h={layout:this.header,row:l,col:c},u=this.child_views.map(function(t){return{layout:t.layout,row:1,col:1}});this.layout=new r.Grid([h].concat(u)),this.layout.set_sizing(this.box_sizing())},e.prototype.update_position=function(){t.prototype.update_position.call(this),this.header_el.style.position="absolute",o.position(this.header_el,this.header.bbox);var e=this.model.tabs_location,n="above"==e||"below"==e,i=o.size(this.scroll_el),r=o.scroll_size(this.headers_el);if(n){var s=this.header.bbox.width;r.width>s?(this.wrapper_el.style.maxWidth=s-i.width+"px",o.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",o.undisplay(this.scroll_el))}else{var a=this.header.bbox.height;r.height>a?(this.wrapper_el.style.maxHeight=a-i.height+"px",o.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",o.undisplay(this.scroll_el))}for(var l=this.child_views,c=0,h=l;c<h.length;c++){var u=h[c];o.hide(u.el)}var _=l[this.model.active];null!=_&&o.show(_.el)},e.prototype.render=function(){var e=this;t.prototype.render.call(this);var n=this.model.active,i=this.model.tabs_location,r="above"==i||"below"==i,a=this.model.tabs.map(function(t,i){var r=o.div({class:[u.bk_tab,i==n?h.bk_active:null]},t.title);if(r.addEventListener("click",function(t){t.target==t.currentTarget&&e.change_active(i)}),t.closable){var a=o.div({class:u.bk_close});a.addEventListener("click",function(t){if(t.target==t.currentTarget){e.model.tabs=s.remove_at(e.model.tabs,i);var n=e.model.tabs.length;e.model.active>n-1&&(e.model.active=n-1)}}),r.appendChild(a)}return r});this.headers_el=o.div({class:[u.bk_headers]},a),this.wrapper_el=o.div({class:u.bk_headers_wrapper},this.headers_el);var l=o.div({class:[_.bk_btn,_.bk_btn_default],disabled:""},o.div({class:[d.bk_caret,h.bk_left]})),c=o.div({class:[_.bk_btn,_.bk_btn_default]},o.div({class:[d.bk_caret,h.bk_right]})),p=0,f=function(t){return function(){var n=e.model.tabs.length;0==(p="left"==t?Math.max(p-1,0):Math.min(p+1,n-1))?l.setAttribute("disabled",""):l.removeAttribute("disabled"),p==n-1?c.setAttribute("disabled",""):c.removeAttribute("disabled");var i=o.children(e.headers_el).slice(0,p).map(function(t){return t.getBoundingClientRect()});if(r){var a=-s.sum(i.map(function(t){return t.width}));e.headers_el.style.left=a+"px"}else{var h=-s.sum(i.map(function(t){return t.height}));e.headers_el.style.top=h+"px"}}};l.addEventListener("click",f("left")),c.addEventListener("click",f("right")),this.scroll_el=o.div({class:_.bk_btn_group},l,c),this.header_el=o.div({class:[u.bk_tabs_header,h.bk_side(i)]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)},e.prototype.change_active=function(t){t!=this.model.active&&(this.model.active=t,null!=this.model.callback&&this.model.callback.execute(this.model))},e.prototype.on_active_change=function(){for(var t=this.model.active,e=o.children(this.headers_el),n=0,i=e;n<i.length;n++){var r=i[n];r.classList.remove(h.bk_active)}e[t].classList.add(h.bk_active);for(var s=this.child_views,a=0,l=s;a<l.length;a++){var c=l[a];o.hide(c.el)}o.show(s[t].el)},e.__name__="TabsView",e}(l.LayoutDOMView);n.TabsView=p;var f=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=p,this.define({tabs:[a.Array,[]],tabs_location:[a.Location,"above"],active:[a.Number,0],callback:[a.Any]})},e.__name__="Tabs",e}(l.LayoutDOM);n.Tabs=f,f.initClass();var m=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({title:[a.String,""],child:[a.Instance],closable:[a.Boolean,!1]})},e.__name__="Panel",e}(c.Model);n.Panel=m,m.initClass()},function(t,e,n){var i=t(421),r=t(162),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="WidgetBoxView",e}(r.ColumnView);n.WidgetBoxView=o;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=o},e.__name__="WidgetBox",e}(r.Column);n.WidgetBox=s,s.initClass()},function(t,e,n){var i=t(421),r=t(172),o=t(175),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({factors:[s.Array],start:[s.Number,0],end:[s.Number]})},e.prototype._v_compute=function(t,e,n,i){var o=i.nan_color;r.cat_v_compute(t,this.factors,n,e,this.start,this.end,o)},e.__name__="CategoricalColorMapper",e}(o.ColorMapper);n.CategoricalColorMapper=a,a.initClass()},function(t,e,n){var i=t(25),r=t(46);function o(t,e){if(t.length!=e.length)return!1;for(var n=0,i=t.length;n<i;n++)if(t[n]!==e[n])return!1;return!0}n._cat_equals=o,n.cat_v_compute=function(t,e,n,s,a,l,c){for(var h=function(h,u){var _=t[h],d=void 0;r.isString(_)?d=i.index_of(e,_):(null!=a?_=null!=l?_.slice(a,l):_.slice(a):null!=l&&(_=_.slice(0,l)),d=1==_.length?i.index_of(e,_[0]):i.find_index(e,function(t){return o(t,_)}));var p=void 0;p=d<0||d>=n.length?c:n[d],s[h]=p},u=0,_=t.length;u<_;u++)h(u,_)}},function(t,e,n){var i=t(421),r=t(172),o=t(180),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({factors:[s.Array],markers:[s.Array],start:[s.Number,0],end:[s.Number],default_value:[s.MarkerType,"circle"]})},e.prototype.v_compute=function(t){var e=new Array(t.length);return r.cat_v_compute(t,this.factors,this.markers,e,this.start,this.end,this.default_value),e},e.__name__="CategoricalMarkerMapper",e}(o.Mapper);n.CategoricalMarkerMapper=a,a.initClass()},function(t,e,n){var i=t(421),r=t(172),o=t(180),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({factors:[s.Array],patterns:[s.Array],start:[s.Number,0],end:[s.Number],default_value:[s.HatchPatternType," "]})},e.prototype.v_compute=function(t){var e=new Array(t.length);return r.cat_v_compute(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e},e.__name__="CategoricalPatternMapper",e}(o.Mapper);n.CategoricalPatternMapper=a,a.initClass()},function(t,e,n){var i=t(421),r=t(180),o=t(18),s=t(46),a=t(30),l=t(31);function c(t){return s.isNumber(t)?t:("#"!=t[0]&&(t=a.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16))}function h(t){for(var e=new Uint32Array(t.length),n=0,i=t.length;n<i;n++)e[n]=c(t[n]);return e}function u(t){if(l.is_little_endian)for(var e=new DataView(t.buffer),n=0,i=t.length;n<i;n++)e.setUint32(4*n,t[n]);return new Uint8Array(t.buffer)}n._convert_color=c,n._convert_palette=h,n._uint32_to_rgba=u;var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({palette:[o.Any],nan_color:[o.Color,"gray"]})},e.prototype.v_compute=function(t){var e=new Array(t.length);return this._v_compute(t,e,this.palette,this._colors(function(t){return t})),e},Object.defineProperty(e.prototype,"rgba_mapper",{get:function(){var t=this,e=h(this.palette),n=this._colors(c);return{v_compute:function(i){var r=new Uint32Array(i.length);return t._v_compute(i,r,e,n),u(r)}}},enumerable:!0,configurable:!0}),e.prototype._colors=function(t){return{nan_color:t(this.nan_color)}},e.__name__="ColorMapper",e}(r.Mapper);n.ColorMapper=_,_.initClass()},function(t,e,n){var i=t(421),r=t(175),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({high:[o.Number],low:[o.Number],high_color:[o.Color],low_color:[o.Color]})},e.prototype._colors=function(e){return i.__assign({},t.prototype._colors.call(this,e),{low_color:null!=this.low_color?e(this.low_color):void 0,high_color:null!=this.high_color?e(this.high_color):void 0})},e.__name__="ContinuousColorMapper",e}(r.ColorMapper);n.ContinuousColorMapper=s,s.initClass()},function(t,e,n){var i=t(171);n.CategoricalColorMapper=i.CategoricalColorMapper;var r=t(173);n.CategoricalMarkerMapper=r.CategoricalMarkerMapper;var o=t(174);n.CategoricalPatternMapper=o.CategoricalPatternMapper;var s=t(176);n.ContinuousColorMapper=s.ContinuousColorMapper;var a=t(175);n.ColorMapper=a.ColorMapper;var l=t(178);n.LinearColorMapper=l.LinearColorMapper;var c=t(179);n.LogColorMapper=c.LogColorMapper},function(t,e,n){var i=t(421),r=t(176),o=t(25),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype._v_compute=function(t,e,n,i){for(var r=i.nan_color,s=i.low_color,a=i.high_color,l=null!=this.low?this.low:o.min(t),c=null!=this.high?this.high:o.max(t),h=n.length-1,u=1/(c-l),_=1/n.length,d=0,p=t.length;d<p;d++){var f=t[d];if(isNaN(f))e[d]=r;else if(f!=c){var m=(f-l)*u,v=Math.floor(m/_);e[d]=v<0?null!=s?s:n[0]:v>h?null!=a?a:n[h]:n[v]}else e[d]=n[h]}},e.__name__="LinearColorMapper",e}(r.ContinuousColorMapper);n.LinearColorMapper=s},function(t,e,n){var i=t(421),r=t(176),o=t(25),s=null!=Math.log1p?Math.log1p:function(t){return Math.log(1+t)},a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype._v_compute=function(t,e,n,i){for(var r=i.nan_color,a=i.low_color,l=i.high_color,c=n.length,h=null!=this.low?this.low:o.min(t),u=null!=this.high?this.high:o.max(t),_=c/(s(u)-s(h)),d=n.length-1,p=0,f=t.length;p<f;p++){var m=t[p];if(isNaN(m))e[p]=r;else if(m>u)e[p]=null!=l?l:n[d];else if(m!=u)if(m<h)e[p]=null!=a?a:n[0];else{var v=s(m)-s(h),g=Math.floor(v*_);g>d&&(g=d),e[p]=n[g]}else e[p]=n[d]}},e.__name__="LogColorMapper",e}(r.ContinuousColorMapper);n.LogColorMapper=a},function(t,e,n){var i=t(421),r=t(297),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.compute=function(t){throw new Error("mapping single values is not supported")},e.__name__="Mapper",e}(r.Transform);n.Mapper=o},function(t,e,n){var i=t(421),r=t(183),o=Math.sqrt(3);function s(t,e){t.moveTo(-e,e),t.lineTo(e,-e),t.moveTo(-e,-e),t.lineTo(e,e)}function a(t,e){t.moveTo(0,e),t.lineTo(0,-e),t.moveTo(-e,0),t.lineTo(e,0)}function l(t,e){t.moveTo(0,e),t.lineTo(e/1.5,0),t.lineTo(0,-e),t.lineTo(-e/1.5,0),t.closePath()}function c(t,e){var n=e*o,i=n/3;t.moveTo(-e,i),t.lineTo(e,i),t.lineTo(0,i-n),t.closePath()}function h(t,e,n,i,r){var o=.65*n;a(t,n),s(t,o),i.doit&&(i.set_vectorize(t,e),t.stroke())}function u(t,e,n,i,r){t.arc(0,0,n,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),a(t,n),t.stroke())}function _(t,e,n,i,r){t.arc(0,0,n,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),s(t,n),t.stroke())}function d(t,e,n,i,r){a(t,n),i.doit&&(i.set_vectorize(t,e),t.stroke())}function p(t,e,n,i,r){l(t,n),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),t.stroke())}function f(t,e,n,i,r){l(t,n),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),a(t,n),t.stroke())}function m(t,e,n,i,r){!function(t,e){var n=e/2,i=o*n;t.moveTo(e,0),t.lineTo(n,-i),t.lineTo(-n,-i),t.lineTo(-e,0),t.lineTo(-n,i),t.lineTo(n,i),t.closePath()}(t,n),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),t.stroke())}function v(t,e,n,i,r){t.rotate(Math.PI),c(t,n),t.rotate(-Math.PI),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),t.stroke())}function g(t,e,n,i,r){var o=2*n;t.rect(-n,-n,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),t.stroke())}function y(t,e,n,i,r){var o=2*n;t.rect(-n,-n,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),a(t,n),t.stroke())}function b(t,e,n,i,r){var o=2*n;t.rect(-n,-n,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),s(t,n),t.stroke())}function w(t,e,n,i,r){c(t,n),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),t.stroke())}function x(t,e,n,i,r){!function(t,e){t.moveTo(-e,0),t.lineTo(e,0)}(t,n),i.doit&&(i.set_vectorize(t,e),t.stroke())}function A(t,e,n,i,r){s(t,n),i.doit&&(i.set_vectorize(t,e),t.stroke())}function k(t,e){var n,o=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.initClass=function(){this.prototype._render_one=e},n}(r.MarkerView);o.initClass();var s=((n=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=o},e}(r.Marker)).__name__=t,n);return s.initClass(),s}n.Asterisk=k("Asterisk",h),n.CircleCross=k("CircleCross",u),n.CircleX=k("CircleX",_),n.Cross=k("Cross",d),n.Dash=k("Dash",x),n.Diamond=k("Diamond",p),n.DiamondCross=k("DiamondCross",f),n.Hex=k("Hex",m),n.InvertedTriangle=k("InvertedTriangle",v),n.Square=k("Square",g),n.SquareCross=k("SquareCross",y),n.SquareX=k("SquareX",b),n.Triangle=k("Triangle",w),n.X=k("X",A),n.marker_funcs={asterisk:h,circle:function(t,e,n,i,r){t.arc(0,0,n,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),i.doit&&(i.set_vectorize(t,e),t.stroke())},circle_cross:u,circle_x:_,cross:d,diamond:p,diamond_cross:f,hex:m,inverted_triangle:v,square:g,square_cross:y,square_x:b,triangle:w,dash:x,x:A}},function(t,e,n){var i=t(421);i.__exportStar(t(181),n);var r=t(183);n.Marker=r.Marker;var o=t(184);n.Scatter=o.Scatter},function(t,e,n){var i=t(421),r=t(153),o=t(9),s=t(18),a=t(24),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._render=function(t,e,n){for(var i=n.sx,r=n.sy,o=n._size,s=n._angle,a=0,l=e;a<l.length;a++){var c=l[a];if(!isNaN(i[c]+r[c]+o[c]+s[c])){var h=o[c]/2;t.beginPath(),t.translate(i[c],r[c]),s[c]&&t.rotate(s[c]),this._render_one(t,c,h,this.visuals.line,this.visuals.fill),s[c]&&t.rotate(-s[c]),t.translate(-i[c],-r[c])}}},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.bbox.h_range,e=t.start-this.max_size,n=t.end+this.max_size,i=this.renderer.xscale.r_invert(e,n),r=i[0],o=i[1],s=this.renderer.plot_view.frame.bbox.v_range,a=s.start-this.max_size,l=s.end+this.max_size,c=this.renderer.yscale.r_invert(a,l),h=c[0],u=c[1];return this.index.indices({x0:r,x1:o,y0:h,y1:u})},e.prototype._hit_point=function(t){for(var e=t.sx,n=t.sy,i=e-this.max_size,r=e+this.max_size,s=this.renderer.xscale.r_invert(i,r),a=s[0],l=s[1],c=n-this.max_size,h=n+this.max_size,u=this.renderer.yscale.r_invert(c,h),_=u[0],d=u[1],p=this.index.indices({x0:a,x1:l,y0:_,y1:d}),f=[],m=0,v=p;m<v.length;m++){var g=v[m],y=this._size[g]/2,b=Math.abs(this.sx[g]-e)+Math.abs(this.sy[g]-n);Math.abs(this.sx[g]-e)<=y&&Math.abs(this.sy[g]-n)<=y&&f.push([g,b])}return o.create_hit_test_result_from_hits(f)},e.prototype._hit_span=function(t){var e,n,i,r,s,a,l=t.sx,c=t.sy,h=this.bounds(),u=this.max_size/2,_=o.create_empty_hit_test_result();if("h"==t.direction){s=h.y0,a=h.y1;var d=l-u,p=l+u;e=this.renderer.xscale.r_invert(d,p),i=e[0],r=e[1]}else{i=h.x0,r=h.x1;var f=c-u,m=c+u;n=this.renderer.yscale.r_invert(f,m),s=n[0],a=n[1]}var v=this.index.indices({x0:i,x1:r,y0:s,y1:a});return _.indices=v,_},e.prototype._hit_rect=function(t){var e=t.sx0,n=t.sx1,i=t.sy0,r=t.sy1,s=this.renderer.xscale.r_invert(e,n),a=s[0],l=s[1],c=this.renderer.yscale.r_invert(i,r),h=c[0],u=c[1],_=o.create_empty_hit_test_result();return _.indices=this.index.indices({x0:a,x1:l,y0:h,y1:u}),_},e.prototype._hit_poly=function(t){for(var e=t.sx,n=t.sy,i=a.range(0,this.sx.length),r=[],s=0,l=i.length;s<l;s++){var c=i[s];o.point_in_poly(this.sx[s],this.sy[s],e,n)&&r.push(c)}var h=o.create_empty_hit_test_result();return h.indices=r,h},e.prototype.draw_legend_for_index=function(t,e,n){var i=e.x0,r=e.x1,o=e.y0,s=e.y1,a=n+1,l=new Array(a);l[n]=(i+r)/2;var c=new Array(a);c[n]=(o+s)/2;var h=new Array(a);h[n]=.4*Math.min(Math.abs(r-i),Math.abs(s-o));var u=new Array(a);u[n]=0,this._render(t,[n],{sx:l,sy:c,_size:h,_angle:u})},e.__name__="MarkerView",e}(r.XYGlyphView);n.MarkerView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.mixins(["line","fill"]),this.define({size:[s.DistanceSpec,{units:"screen",value:4}],angle:[s.AngleSpec,0]})},e.__name__="Marker",e}(r.XYGlyph);n.Marker=c,c.initClass()},function(t,e,n){var i=t(421),r=t(183),o=t(181),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._render=function(t,e,n){for(var i=n.sx,r=n.sy,s=n._size,a=n._angle,l=n._marker,c=0,h=e;c<h.length;c++){var u=h[c];if(!isNaN(i[u]+r[u]+s[u]+a[u])&&null!=l[u]){var _=s[u]/2;t.beginPath(),t.translate(i[u],r[u]),a[u]&&t.rotate(a[u]),o.marker_funcs[l[u]](t,u,_,this.visuals.line,this.visuals.fill),a[u]&&t.rotate(-a[u]),t.translate(-i[u],-r[u])}}},e.prototype.draw_legend_for_index=function(t,e,n){var i=e.x0,r=e.x1,o=e.y0,s=e.y1,a=n+1,l=new Array(a);l[n]=(i+r)/2;var c=new Array(a);c[n]=(o+s)/2;var h=new Array(a);h[n]=.4*Math.min(Math.abs(r-i),Math.abs(s-o));var u=new Array(a);u[n]=0;var _=new Array(a);_[n]=this._marker[n],this._render(t,[n],{sx:l,sy:c,_size:h,_angle:u,_marker:_})},e.__name__="ScatterView",e}(r.MarkerView);n.ScatterView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({marker:[s.MarkerSpec,{value:"circle"}]})},e.__name__="Scatter",e}(r.Marker);n.Scatter=l,l.initClass()},function(t,e,n){var i=t(421),r=t(17),o=t(188),s=t(18),a=t(62),l=t(195),c=t(186);n.GMapPlotView=c.GMapPlotView;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({lat:[s.Number],lng:[s.Number],zoom:[s.Number,12]})},e.__name__="MapOptions",e}(a.Model);n.MapOptions=h,h.initClass();var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({map_type:[s.String,"roadmap"],scale_control:[s.Boolean,!1],styles:[s.String],tilt:[s.Int,45]})},e.__name__="GMapOptions",e}(h);n.GMapOptions=u,u.initClass();var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c.GMapPlotView,this.define({map_options:[s.Instance],api_key:[s.String]}),this.override({x_range:function(){return new l.Range1d},y_range:function(){return new l.Range1d}})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.use_map=!0,this.api_key||r.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")},e.__name__="GMapPlot",e}(o.Plot);n.GMapPlot=_,_.initClass()},function(t,e,n){var i=t(421),r=t(22),o=t(36),s=t(189),a=new r.Signal0({},"gmaps_ready"),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this._tiles_loaded=!1,this.zoom_count=0;var n=this.model.map_options,i=n.zoom,r=n.lat,o=n.lng;this.initial_zoom=i,this.initial_lat=r,this.initial_lng=o,this.canvas_view.map_el.style.position="absolute","undefined"!=typeof google&&null!=google.maps||(void 0===window._bokeh_gmaps_callback&&function(t){window._bokeh_gmaps_callback=function(){return a.emit()};var e=document.createElement("script");e.type="text/javascript",e.src="https://maps.googleapis.com/maps/api/js?key="+t+"&callback=_bokeh_gmaps_callback",document.body.appendChild(e)}(this.model.api_key),a.connect(function(){return e.request_render()})),this.unpause()},e.prototype.update_range=function(e){if(null==e)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),t.prototype.update_range.call(this,null);else if(null!=e.sdx||null!=e.sdy)this.map.panBy(e.sdx||0,e.sdy||0),t.prototype.update_range.call(this,e);else if(null!=e.factor){var n=void 0;if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),t.prototype.update_range.call(this,e),n=e.factor<0?-1:1;var i=this.map.getZoom(),r=i+n;if(r>=2){this.map.setZoom(r);var o=this._get_projected_bounds(),s=o[0],a=o[1];a-s<0&&this.map.setZoom(i)}this.unpause()}this._set_bokeh_ranges()},e.prototype._build_map=function(){var t=this,e=google.maps;this.map_types={satellite:e.MapTypeId.SATELLITE,terrain:e.MapTypeId.TERRAIN,roadmap:e.MapTypeId.ROADMAP,hybrid:e.MapTypeId.HYBRID};var n=this.model.map_options,i={center:new e.LatLng(n.lat,n.lng),zoom:n.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[n.map_type],scaleControl:n.scale_control,tilt:n.tilt};null!=n.styles&&(i.styles=JSON.parse(n.styles)),this.map=new e.Map(this.canvas_view.map_el,i),e.event.addListener(this.map,"idle",function(){return t._set_bokeh_ranges()}),e.event.addListener(this.map,"bounds_changed",function(){return t._set_bokeh_ranges()}),e.event.addListenerOnce(this.map,"tilesloaded",function(){return t._render_finished()}),this.connect(this.model.properties.map_options.change,function(){return t._update_options()}),this.connect(this.model.map_options.properties.styles.change,function(){return t._update_styles()}),this.connect(this.model.map_options.properties.lat.change,function(){return t._update_center("lat")}),this.connect(this.model.map_options.properties.lng.change,function(){return t._update_center("lng")}),this.connect(this.model.map_options.properties.zoom.change,function(){return t._update_zoom()}),this.connect(this.model.map_options.properties.map_type.change,function(){return t._update_map_type()}),this.connect(this.model.map_options.properties.scale_control.change,function(){return t._update_scale_control()}),this.connect(this.model.map_options.properties.tilt.change,function(){return t._update_tilt()})},e.prototype._render_finished=function(){this._tiles_loaded=!0,this.notify_finished()},e.prototype.has_finished=function(){return t.prototype.has_finished.call(this)&&!0===this._tiles_loaded},e.prototype._get_latlon_bounds=function(){var t=this.map.getBounds(),e=t.getNorthEast(),n=t.getSouthWest(),i=n.lng(),r=e.lng(),o=n.lat(),s=e.lat();return[i,r,o,s]},e.prototype._get_projected_bounds=function(){var t=this._get_latlon_bounds(),e=t[0],n=t[1],i=t[2],r=t[3],s=o.wgs84_mercator.forward([e,i]),a=s[0],l=s[1],c=o.wgs84_mercator.forward([n,r]),h=c[0],u=c[1];return[a,h,l,u]},e.prototype._set_bokeh_ranges=function(){var t=this._get_projected_bounds(),e=t[0],n=t[1],i=t[2],r=t[3];this.frame.x_range.setv({start:e,end:n}),this.frame.y_range.setv({start:i,end:r})},e.prototype._update_center=function(t){var e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()},e.prototype._update_map_type=function(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})},e.prototype._update_scale_control=function(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})},e.prototype._update_tilt=function(){this.map.setOptions({tilt:this.model.map_options.tilt})},e.prototype._update_options=function(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()},e.prototype._update_styles=function(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})},e.prototype._update_zoom=function(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()},e.prototype._map_hook=function(t,e){var n=e[0],i=e[1],r=e[2],o=e[3];this.canvas_view.map_el.style.top=i+"px",this.canvas_view.map_el.style.left=n+"px",this.canvas_view.map_el.style.width=r+"px",this.canvas_view.map_el.style.height=o+"px",null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map()},e.prototype._paint_empty=function(t,e){var n=this.layout._width.value,i=this.layout._height.value,r=e[0],o=e[1],s=e[2],a=e[3];t.clearRect(0,0,n,i),t.beginPath(),t.moveTo(0,0),t.lineTo(0,i),t.lineTo(n,i),t.lineTo(n,0),t.lineTo(0,0),t.moveTo(r,o),t.lineTo(r+s,o),t.lineTo(r+s,o+a),t.lineTo(r,o+a),t.lineTo(r,o),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())},e.__name__="GMapPlotView",e}(s.PlotView);n.GMapPlotView=l},function(t,e,n){var i=t(185);n.MapOptions=i.MapOptions;var r=t(185);n.GMapOptions=r.GMapOptions;var o=t(185);n.GMapPlot=o.GMapPlot;var s=t(188);n.Plot=s.Plot},function(t,e,n){var i=t(421),r=t(18),o=t(22),s=t(24),a=t(35),l=t(46),c=t(166),h=t(78),u=t(204),_=t(286),d=t(212),p=t(197),f=t(191),m=t(189);n.PlotView=m.PlotView;var v=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=m.PlotView,this.mixins(["line:outline_","fill:background_","fill:border_"]),this.define({toolbar:[r.Instance,function(){return new _.Toolbar}],toolbar_location:[r.Location,"right"],toolbar_sticky:[r.Boolean,!0],plot_width:[r.Number,600],plot_height:[r.Number,600],frame_width:[r.Number,null],frame_height:[r.Number,null],title:[r.Any,function(){return new h.Title({text:""})}],title_location:[r.Location,"above"],above:[r.Array,[]],below:[r.Array,[]],left:[r.Array,[]],right:[r.Array,[]],center:[r.Array,[]],renderers:[r.Array,[]],x_range:[r.Instance,function(){return new f.DataRange1d}],extra_x_ranges:[r.Any,{}],y_range:[r.Instance,function(){return new f.DataRange1d}],extra_y_ranges:[r.Any,{}],x_scale:[r.Instance,function(){return new u.LinearScale}],y_scale:[r.Instance,function(){return new u.LinearScale}],lod_factor:[r.Number,10],lod_interval:[r.Number,300],lod_threshold:[r.Number,2e3],lod_timeout:[r.Number,500],hidpi:[r.Boolean,!0],output_backend:[r.OutputBackend,"canvas"],min_border:[r.Number,5],min_border_top:[r.Number,null],min_border_left:[r.Number,null],min_border_bottom:[r.Number,null],min_border_right:[r.Number,null],inner_width:[r.Number],inner_height:[r.Number],outer_width:[r.Number],outer_height:[r.Number],match_aspect:[r.Boolean,!1],aspect_scale:[r.Number,1],reset_policy:[r.ResetPolicy,"standard"]}),this.override({outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},Object.defineProperty(e.prototype,"width",{get:function(){var t=this.getv("width");return null!=t?t:this.plot_width},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"height",{get:function(){var t=this.getv("height");return null!=t?t:this.plot_height},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.reset=new o.Signal0(this,"reset");for(var e=0,n=a.values(this.extra_x_ranges).concat(this.x_range);e<n.length;e++){var i=n[e],r=i.plots;l.isArray(r)&&(r=r.concat(this),i.setv({plots:r},{silent:!0}))}for(var s=0,c=a.values(this.extra_y_ranges).concat(this.y_range);s<c.length;s++){var h=c[s],r=h.plots;l.isArray(r)&&(r=r.concat(this),h.setv({plots:r},{silent:!0}))}},e.prototype.add_layout=function(t,e){void 0===e&&(e="center");var n=this.getv(e);n.push(t)},e.prototype.remove_layout=function(t){var e=function(e){s.remove_by(e,function(e){return e==t})};e(this.left),e(this.right),e(this.above),e(this.below),e(this.center)},e.prototype.add_renderers=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.renderers=this.renderers.concat(t)},e.prototype.add_glyph=function(t,e,n){void 0===e&&(e=new d.ColumnDataSource),void 0===n&&(n={});var r=i.__assign({},n,{data_source:e,glyph:t}),o=new p.GlyphRenderer(r);return this.add_renderers(o),o},e.prototype.add_tools=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.toolbar.tools=this.toolbar.tools.concat(t)},Object.defineProperty(e.prototype,"panels",{get:function(){return this.side_panels.concat(this.center)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"side_panels",{get:function(){var t=this.above,e=this.below,n=this.left,i=this.right;return s.concat([t,e,n,i])},enumerable:!0,configurable:!0}),e.__name__="Plot",e}(c.LayoutDOM);n.Plot=v,v.initClass()},function(t,e,n){var i=t(421),r=t(95),o=t(94),s=t(191),a=t(197),l=t(166),c=t(78),h=t(82),u=t(79),_=t(3),d=t(22),p=t(4),f=t(51),m=t(17),v=t(44),g=t(46),y=t(24),b=t(35),w=t(13),x=t(10),A=t(15),k=t(11),C=t(27),T=null,S=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.min_border={left:0,top:0,right:0,bottom:0},e}return i.__extends(e,t),e.prototype._measure=function(t){var e=this;t=new w.Sizeable(t).bounded_to(this.sizing.size);var n,i,r,o=this.left_panel.measure({width:0,height:t.height}),s=Math.max(o.width,this.min_border.left),a=this.right_panel.measure({width:0,height:t.height}),l=Math.max(a.width,this.min_border.right),c=this.top_panel.measure({width:t.width,height:0}),h=Math.max(c.height,this.min_border.top),u=this.bottom_panel.measure({width:t.width,height:0}),_=Math.max(u.height,this.min_border.bottom),d=new w.Sizeable(t).shrink_by({left:s,right:l,top:h,bottom:_}),p=this.center_panel.measure(d),f=s+p.width+l,m=h+p.height+_,v=(n=e.center_panel.sizing,i=n.width_policy,r=n.height_policy,"fixed"!=i&&"fixed"!=r);return{width:f,height:m,inner:{left:s,right:l,top:h,bottom:_},align:v}},e.prototype._set_geometry=function(e,n){t.prototype._set_geometry.call(this,e,n),this.center_panel.set_geometry(n);var i=this.left_panel.measure({width:0,height:e.height}),r=this.right_panel.measure({width:0,height:e.height}),o=this.top_panel.measure({width:e.width,height:0}),s=this.bottom_panel.measure({width:e.width,height:0}),a=n.left,l=n.top,c=n.right,h=n.bottom;this.top_panel.set_geometry(new C.BBox({left:a,right:c,bottom:l,height:o.height})),this.bottom_panel.set_geometry(new C.BBox({left:a,right:c,top:h,height:s.height})),this.left_panel.set_geometry(new C.BBox({top:l,bottom:h,right:a,width:i.width})),this.right_panel.set_geometry(new C.BBox({top:l,bottom:h,left:c,width:r.width}))},e.__name__="PlotLayout",e}(w.Layoutable);n.PlotLayout=S;var M=function(e){function n(){var t=null!==e&&e.apply(this,arguments)||this;return t._outer_bbox=new C.BBox,t._inner_bbox=new C.BBox,t._needs_paint=!0,t._needs_layout=!1,t}return i.__extends(n,e),Object.defineProperty(n.prototype,"canvas_overlays",{get:function(){return this.canvas_view.overlays_el},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"canvas_events",{get:function(){return this.canvas_view.events_el},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"is_paused",{get:function(){return null!=this._is_paused&&0!==this._is_paused},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),n.prototype.pause=function(){null==this._is_paused?this._is_paused=1:this._is_paused+=1},n.prototype.unpause=function(t){if(void 0===t&&(t=!1),null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_paint()},n.prototype.request_render=function(){this.request_paint()},n.prototype.request_paint=function(){this.is_paused||this.throttled_paint()},n.prototype.request_layout=function(){this._needs_layout=!0,this.request_paint()},n.prototype.reset=function(){"standard"==this.model.reset_policy&&(this.clear_state(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new _.Reset)},n.prototype.remove=function(){this.ui_event_bus.destroy(),p.remove_views(this.renderer_views),p.remove_views(this.tool_views),this.canvas_view.remove(),e.prototype.remove.call(this)},n.prototype.render=function(){e.prototype.render.call(this),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()},n.prototype.initialize=function(){var n=this;this.pause(),e.prototype.initialize.call(this),this.force_paint=new d.Signal0(this,"force_paint"),this.state_changed=new d.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new f.Visuals(this.model),this._initial_state_info={selection:{},dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.state={history:[],index:-1},this.canvas=new o.Canvas({map:this.model.use_map||!1,use_hidpi:this.model.hidpi,output_backend:this.model.output_backend}),this.frame=new r.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this.canvas_view=new this.canvas.default_view({model:this.canvas,parent:this}),"webgl"==this.model.output_backend&&this.init_webgl(),this.throttled_paint=v.throttle(function(){return n.force_paint.emit()},15);var i=t(23).UIEvents;this.ui_event_bus=new i(this,this.model.toolbar,this.canvas_view.events_el);var s=this.model,a=s.title_location,l=s.title;null!=a&&null!=l&&(this._title=l instanceof c.Title?l:new c.Title({text:l}));var h=this.model,_=h.toolbar_location,p=h.toolbar;null!=_&&null!=p&&(this._toolbar=new u.ToolbarPanel({toolbar:p}),p.toolbar_location=_),this.renderer_views={},this.tool_views={},this.build_renderer_views(),this.build_tool_views(),this.update_dataranges(),this.unpause(!0),m.logger.debug("PlotView initialized")},n.prototype._width_policy=function(){return null==this.model.frame_width?e.prototype._width_policy.call(this):"min"},n.prototype._height_policy=function(){return null==this.model.frame_height?e.prototype._height_policy.call(this):"min"},n.prototype._update_layout=function(){var t=this;this.layout=new S,this.layout.set_sizing(this.box_sizing());var e=this.model,n=e.frame_width,r=e.frame_height;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(i.__assign({},null!=n?{width_policy:"fixed",width:n}:{width_policy:"fit"},null!=r?{height_policy:"fixed",height:r}:{height_policy:"fit"}));var o=y.copy(this.model.above),s=y.copy(this.model.below),a=y.copy(this.model.left),l=y.copy(this.model.right),h=function(t){switch(t){case"above":return o;case"below":return s;case"left":return a;case"right":return l}},_=this.model,d=_.title_location,p=_.title;null!=d&&null!=p&&h(d).push(this._title);var f=this.model,m=f.toolbar_location,v=f.toolbar;if(null!=m&&null!=v){var b=h(m),w=!0;if(this.model.toolbar_sticky)for(var C=0;C<b.length;C++){var T=b[C];if(T instanceof c.Title){b[C]="above"==m||"below"==m?[T,this._toolbar]:[this._toolbar,T],w=!1;break}}w&&b.push(this._toolbar)}var M=function(e,n){var i=t.renderer_views[n.id];return i.layout=new A.SidePanel(e,i)},E=function(t,e){for(var n="above"==t||"below"==t,r=[],o=0,s=e;o<s.length;o++){var a=s[o];if(g.isArray(a)){var l=a.map(function(e){var r,o=M(t,e);if(e instanceof u.ToolbarPanel){var s=n?"width_policy":"height_policy";o.set_sizing(i.__assign({},o.sizing,((r={})[s]="min",r)))}return o}),c=void 0;n?(c=new k.Row(l)).set_sizing({width_policy:"max",height_policy:"min"}):(c=new k.Column(l)).set_sizing({width_policy:"min",height_policy:"max"}),c.absolute=!0,r.push(c)}else r.push(M(t,a))}return r},z=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:z,top:null!=this.model.min_border_top?this.model.min_border_top:z,right:null!=this.model.min_border_right?this.model.min_border_right:z,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:z};var O=new x.VStack,P=new x.VStack,j=new x.HStack,N=new x.HStack;O.children=y.reversed(E("above",o)),P.children=E("below",s),j.children=y.reversed(E("left",a)),N.children=E("right",l),O.set_sizing({width_policy:"fit",height_policy:"min"}),P.set_sizing({width_policy:"fit",height_policy:"min"}),j.set_sizing({width_policy:"min",height_policy:"fit"}),N.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=O,this.layout.bottom_panel=P,this.layout.left_panel=j,this.layout.right_panel=N},Object.defineProperty(n.prototype,"axis_views",{get:function(){var t=[];for(var e in this.renderer_views){var n=this.renderer_views[e];n instanceof h.AxisView&&t.push(n)}return t},enumerable:!0,configurable:!0}),n.prototype.set_cursor=function(t){void 0===t&&(t="default"),this.canvas_view.el.style.cursor=t},n.prototype.set_toolbar_visibility=function(t){for(var e=0,n=this.visibility_callbacks;e<n.length;e++){var i=n[e];i(t)}},n.prototype.init_webgl=function(){if(null==T){var t=document.createElement("canvas"),e={premultipliedAlpha:!0},n=t.getContext("webgl",e)||t.getContext("experimental-webgl",e);null!=n&&(T={canvas:t,ctx:n})}null!=T?this.gl=T:m.logger.warn("WebGL is not supported, falling back to 2D canvas.")},n.prototype.prepare_webgl=function(t,e){if(null!=this.gl){var n=this.canvas_view.get_canvas_element();this.gl.canvas.width=n.width,this.gl.canvas.height=n.height;var i=this.gl.ctx;i.enable(i.SCISSOR_TEST);var r=e[0],o=e[1],s=e[2],a=e[3],l=this.canvas_view.bbox,c=l.xview,h=l.yview,u=c.compute(r),_=h.compute(o+a);i.scissor(t*u,t*_,t*s,t*a),i.enable(i.BLEND),i.blendFuncSeparate(i.SRC_ALPHA,i.ONE_MINUS_SRC_ALPHA,i.ONE_MINUS_DST_ALPHA,i.ONE)}},n.prototype.clear_webgl=function(){if(null!=this.gl){var t=this.gl.ctx;t.viewport(0,0,this.gl.canvas.width,this.gl.canvas.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT||t.DEPTH_BUFFER_BIT)}},n.prototype.blit_webgl=function(){var t=this.canvas_view.ctx;if(null!=this.gl){m.logger.debug("drawing with WebGL"),t.restore(),t.drawImage(this.gl.canvas,0,0),t.save();var e=this.canvas.pixel_ratio;t.scale(e,e),t.translate(.5,.5)}},n.prototype.update_dataranges=function(){for(var t={},e={},n=!1,i=0,r=b.values(this.frame.x_ranges).concat(b.values(this.frame.y_ranges));i<r.length;i++){var o=r[i];o instanceof s.DataRange1d&&"log"==o.scale_hint&&(n=!0)}for(var l in this.renderer_views){var c=this.renderer_views[l];if(c instanceof a.GlyphRendererView){var h=c.glyph.bounds();if(null!=h&&(t[l]=h),n){var u=c.glyph.log_bounds();null!=u&&(e[l]=u)}}}var _,d=!1,p=!1,f=this.frame.bbox,v=f.width,g=f.height;!1!==this.model.match_aspect&&0!=v&&0!=g&&(_=1/this.model.aspect_scale*(v/g));for(var y=0,w=b.values(this.frame.x_ranges);y<w.length;y++){var x=w[y];if(x instanceof s.DataRange1d){var A="log"==x.scale_hint?e:t;x.update(A,0,this.model.id,_),x.follow&&(d=!0)}null!=x.bounds&&(p=!0)}for(var k=0,C=b.values(this.frame.y_ranges);k<C.length;k++){var T=C[k];if(T instanceof s.DataRange1d){var A="log"==T.scale_hint?e:t;T.update(A,1,this.model.id,_),T.follow&&(d=!0)}null!=T.bounds&&(p=!0)}if(d&&p){m.logger.warn("Follow enabled so bounds are unset.");for(var S=0,M=b.values(this.frame.x_ranges);S<M.length;S++){var x=M[S];x.bounds=null}for(var E=0,z=b.values(this.frame.y_ranges);E<z.length;E++){var T=z[E];T.bounds=null}}this.range_update_timestamp=Date.now()},n.prototype.map_to_screen=function(t,e,n,i){return void 0===n&&(n="default"),void 0===i&&(i="default"),this.frame.map_to_screen(t,e,n,i)},n.prototype.push_state=function(t,e){var n=this.state,r=n.history,o=n.index,s=null!=r[o]?r[o].info:{},a=i.__assign({},this._initial_state_info,s,e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:a}),this.state.index=this.state.history.length-1,this.state_changed.emit()},n.prototype.clear_state=function(){this.state={history:[],index:-1},this.state_changed.emit()},n.prototype.can_undo=function(){return this.state.index>=0},n.prototype.can_redo=function(){return this.state.index<this.state.history.length-1},n.prototype.undo=function(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())},n.prototype.redo=function(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())},n.prototype._do_state_change=function(t){var e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)},n.prototype.get_selection=function(){for(var t={},e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];if(i instanceof a.GlyphRenderer){var r=i.data_source.selected;t[i.id]=r}}return t},n.prototype.update_selection=function(t){for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];if(i instanceof a.GlyphRenderer){var r=i.data_source;null!=t?null!=t[i.id]&&r.selected.update(t[i.id],!0,!1):r.selection_manager.clear()}}},n.prototype.reset_selection=function(){this.update_selection(null)},n.prototype._update_ranges_together=function(t){for(var e=1,n=0,i=t;n<i.length;n++){var r=i[n],o=r[0],s=r[1];e=Math.min(e,this._get_weight_to_constrain_interval(o,s))}if(e<1)for(var a=0,l=t;a<l.length;a++){var c=l[a],o=c[0],s=c[1];s.start=e*s.start+(1-e)*o.start,s.end=e*s.end+(1-e)*o.end}},n.prototype._update_ranges_individually=function(t,e,n,i){for(var r=!1,o=0,s=t;o<s.length;o++){var a=s[o],l=a[0],c=a[1];if(!n){var h=this._get_weight_to_constrain_interval(l,c);h<1&&(c.start=h*c.start+(1-h)*l.start,c.end=h*c.end+(1-h)*l.end)}if(null!=l.bounds&&"auto"!=l.bounds){var u=l.bounds,_=u[0],d=u[1],p=Math.abs(c.end-c.start);l.is_reversed?(null!=_&&_>=c.end&&(r=!0,c.end=_,(e||n)&&(c.start=_+p)),null!=d&&d<=c.start&&(r=!0,c.start=d,(e||n)&&(c.end=d-p))):(null!=_&&_>=c.start&&(r=!0,c.start=_,(e||n)&&(c.end=_+p)),null!=d&&d<=c.end&&(r=!0,c.end=d,(e||n)&&(c.start=d-p)))}}if(!(n&&r&&i))for(var f=0,m=t;f<m.length;f++){var v=m[f],l=v[0],c=v[1];l.have_updated_interactively=!0,l.start==c.start&&l.end==c.end||l.setv(c)}},n.prototype._get_weight_to_constrain_interval=function(t,e){var n=t.min_interval,i=t.max_interval;if(null!=t.bounds&&"auto"!=t.bounds){var r=t.bounds,o=r[0],s=r[1];if(null!=o&&null!=s){var a=Math.abs(s-o);i=null!=i?Math.min(i,a):a}}var l=1;if(null!=n||null!=i){var c=Math.abs(t.end-t.start),h=Math.abs(e.end-e.start);n>0&&h<n&&(l=(c-n)/(c-h)),i>0&&h>i&&(l=(i-c)/(h-c)),l=Math.max(0,Math.min(1,l))}return l},n.prototype.update_range=function(t,e,n,i){void 0===e&&(e=!1),void 0===n&&(n=!1),void 0===i&&(i=!0),this.pause();var r=this.frame,o=r.x_ranges,s=r.y_ranges;if(null==t){for(var a in o){var l=o[a];l.reset()}for(var c in s){var l=s[c];l.reset()}this.update_dataranges()}else{var h=[];for(var u in o){var l=o[u];h.push([l,t.xrs[u]])}for(var _ in s){var l=s[_];h.push([l,t.yrs[_]])}n&&this._update_ranges_together(h),this._update_ranges_individually(h,e,n,i)}this.unpause()},n.prototype.reset_range=function(){this.update_range(null)},n.prototype._invalidate_layout=function(){var t=this;(function(){for(var e=0,n=t.model.side_panels;e<n.length;e++){var i=n[e],r=t.renderer_views[i.id];if(r.layout.has_size_changed())return!0}return!1})()&&this.root.compute_layout()},n.prototype.build_renderer_views=function(){var t,e,n,i,r,o,s;this.computed_renderers=[],(t=this.computed_renderers).push.apply(t,this.model.above),(e=this.computed_renderers).push.apply(e,this.model.below),(n=this.computed_renderers).push.apply(n,this.model.left),(i=this.computed_renderers).push.apply(i,this.model.right),(r=this.computed_renderers).push.apply(r,this.model.center),(o=this.computed_renderers).push.apply(o,this.model.renderers),null!=this._title&&this.computed_renderers.push(this._title),null!=this._toolbar&&this.computed_renderers.push(this._toolbar);for(var a=0,l=this.model.toolbar.tools;a<l.length;a++){var c=l[a];null!=c.overlay&&this.computed_renderers.push(c.overlay),(s=this.computed_renderers).push.apply(s,c.synthetic_renderers)}p.build_views(this.renderer_views,this.computed_renderers,{parent:this})},n.prototype.get_renderer_views=function(){var t=this;return this.computed_renderers.map(function(e){return t.renderer_views[e.id]})},n.prototype.build_tool_views=function(){var t=this,e=this.model.toolbar.tools,n=p.build_views(this.tool_views,e,{parent:this});n.map(function(e){return t.ui_event_bus.register_tool(e)})},n.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.force_paint,function(){return t.repaint()});var n=this.frame,i=n.x_ranges,r=n.y_ranges;for(var o in i){var s=i[o];this.connect(s.change,function(){t._needs_layout=!0,t.request_paint()})}for(var a in r){var s=r[a];this.connect(s.change,function(){t._needs_layout=!0,t.request_paint()})}this.connect(this.model.properties.renderers.change,function(){return t.build_renderer_views()}),this.connect(this.model.toolbar.properties.tools.change,function(){t.build_renderer_views(),t.build_tool_views()}),this.connect(this.model.change,function(){return t.request_paint()}),this.connect(this.model.reset,function(){return t.reset()})},n.prototype.set_initial_range=function(){var t=!0,e=this.frame,n=e.x_ranges,i=e.y_ranges,r={},o={};for(var s in n){var a=n[s],l=a.start,c=a.end;if(null==l||null==c||g.isStrictNaN(l+c)){t=!1;break}r[s]={start:l,end:c}}if(t)for(var h in i){var u=i[h],l=u.start,c=u.end;if(null==l||null==c||g.isStrictNaN(l+c)){t=!1;break}o[h]={start:l,end:c}}t?(this._initial_state_info.range={xrs:r,yrs:o},m.logger.debug("initial ranges set")):m.logger.warn("could not set initial ranges")},n.prototype.has_finished=function(){if(!e.prototype.has_finished.call(this))return!1;for(var t in this.renderer_views){var n=this.renderer_views[t];if(!n.has_finished())return!1}return!0},n.prototype.after_layout=function(){if(e.prototype.after_layout.call(this),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame._width.value),inner_height:Math.round(this.frame._height.value),outer_width:Math.round(this.layout._width.value),outer_height:Math.round(this.layout._height.value)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){var t=this.layout.bbox,n=t.width,i=t.height;this.canvas_view.prepare_canvas(n,i),this._outer_bbox=this.layout.bbox,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&(this._needs_paint=!1,this.paint())},n.prototype.repaint=function(){this._needs_layout&&this._invalidate_layout(),this.paint()},n.prototype.paint=function(){var t=this;if(!this.is_paused){m.logger.trace("PlotView.paint() for "+this.model.id);var e=this.model.document;if(null!=e){var n=e.interactive_duration();n>=0&&n<this.model.lod_interval?setTimeout(function(){e.interactive_duration()>t.model.lod_timeout&&e.interactive_stop(t.model),t.request_paint()},this.model.lod_timeout):e.interactive_stop(this.model)}for(var i in this.renderer_views){var r=this.renderer_views[i];if(null==this.range_update_timestamp||r instanceof a.GlyphRendererView&&r.set_data_timestamp>this.range_update_timestamp){this.update_dataranges();break}}var o=this.canvas_view.ctx,s=this.canvas.pixel_ratio;o.save(),o.scale(s,s),o.translate(.5,.5);var l=[this.frame._left.value,this.frame._top.value,this.frame._width.value,this.frame._height.value];if(this._map_hook(o,l),this._paint_empty(o,l),this.prepare_webgl(s,l),this.clear_webgl(),this.visuals.outline_line.doit){o.save(),this.visuals.outline_line.set_value(o);var c=l[0],h=l[1],u=l[2],_=l[3];c+u==this.layout._width.value&&(u-=1),h+_==this.layout._height.value&&(_-=1),o.strokeRect(c,h,u,_),o.restore()}this._paint_levels(o,["image","underlay","glyph"],l,!0),this._paint_levels(o,["annotation"],l,!1),this._paint_levels(o,["overlay"],l,!1),null==this._initial_state_info.range&&this.set_initial_range(),o.restore()}},n.prototype._paint_levels=function(t,e,n,i){for(var r=0,o=e;r<o.length;r++)for(var s=o[r],a=0,l=this.computed_renderers;a<l.length;a++){var c=l[a];if(c.level==s){var h=this.renderer_views[c.id];t.save(),(i||h.needs_clip)&&(t.beginPath(),t.rect.apply(t,n),t.clip()),h.render(),t.restore(),h.has_webgl&&(this.blit_webgl(),this.clear_webgl())}}},n.prototype._map_hook=function(t,e){},n.prototype._paint_empty=function(t,e){var n=[0,0,this.layout._width.value,this.layout._height.value],i=n[0],r=n[1],o=n[2],s=n[3],a=e[0],l=e[1],c=e[2],h=e[3];t.clearRect(i,r,o,s),this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(i,r,o,s),t.clearRect(a,l,c,h)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(a,l,c,h))},n.prototype.save=function(t){switch(this.model.output_backend){case"canvas":case"webgl":var e=this.canvas_view.get_canvas_element();if(null!=e.msToBlob){var n=e.msToBlob();window.navigator.msSaveBlob(n,t)}else{var i=document.createElement("a");i.href=e.toDataURL("image/png"),i.download=t+".png",i.target="_blank",i.dispatchEvent(new MouseEvent("click"))}break;case"svg":var r=this.canvas_view._ctx,o=r.getSerializedSvg(!0),s=new Blob([o],{type:"text/plain"}),a=document.createElement("a");a.download=t+".svg",a.innerHTML="Download svg",a.href=window.URL.createObjectURL(s),a.onclick=function(t){return document.body.removeChild(t.target)},a.style.display="none",document.body.appendChild(a),a.click()}},n.prototype.serializable_state=function(){var t=e.prototype.serializable_state.call(this),n=t.children,r=i.__rest(t,["children"]),o=this.get_renderer_views().map(function(t){return t.serializable_state()}).filter(function(t){return"bbox"in t});return i.__assign({},r,{children:n.concat(o)})},n.__name__="PlotView",n}(l.LayoutDOMView);n.PlotView=M},function(t,e,n){var i=t(421),r=t(194),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({names:[o.Array,[]],renderers:[o.Array,[]]})},e.__name__="DataRange",e}(r.Range);n.DataRange=s,s.initClass()},function(t,e,n){var i=t(421),r=t(190),o=t(197),s=t(17),a=t(18),l=t(27),c=t(24),h=function(t){function e(e){var n=t.call(this,e)||this;return n._plot_bounds={},n.have_updated_interactively=!1,n}return i.__extends(e,t),e.initClass=function(){this.define({start:[a.Number],end:[a.Number],range_padding:[a.Number,.1],range_padding_units:[a.PaddingUnits,"percent"],flipped:[a.Boolean,!1],follow:[a.StartEnd],follow_interval:[a.Number],default_span:[a.Number,2]}),this.internal({scale_hint:[a.String,"auto"]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),e.prototype.computed_renderers=function(){var t=this.names,e=this.renderers;if(0==e.length)for(var n=0,i=this.plots;n<i.length;n++){var r=i[n],a=r.renderers.filter(function(t){return t instanceof o.GlyphRenderer});e=e.concat(a)}t.length>0&&(e=e.filter(function(e){return c.includes(t,e.name)})),s.logger.debug("computed "+e.length+" renderers for DataRange1d "+this.id);for(var l=0,h=e;l<h.length;l++){var u=h[l];s.logger.trace(" - "+u.type+" "+u.id)}return e},e.prototype._compute_plot_bounds=function(t,e){for(var n=l.empty(),i=0,r=t;i<r.length;i++){var o=r[i];null!=e[o.id]&&(n=l.union(n,e[o.id]))}return n},e.prototype.adjust_bounds_for_aspect=function(t,e){var n=l.empty(),i=t.x1-t.x0;i<=0&&(i=1);var r=t.y1-t.y0;r<=0&&(r=1);var o=.5*(t.x1+t.x0),s=.5*(t.y1+t.y0);return i<e*r?i=e*r:r=i/e,n.x1=o+.5*i,n.x0=o-.5*i,n.y1=s+.5*r,n.y0=s-.5*r,n},e.prototype._compute_min_max=function(t,e){var n,i,r,o,s=l.empty();for(var a in t){var c=t[a];s=l.union(s,c)}return 0==e?(n=[s.x0,s.x1],r=n[0],o=n[1]):(i=[s.y0,s.y1],r=i[0],o=i[1]),[r,o]},e.prototype._compute_range=function(t,e){var n,i,r,o=this.range_padding;if("log"==this.scale_hint){(isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(e)||!isFinite(e)||e<=0?.1:e/100,s.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(e)||!isFinite(e)||e<=0)&&(e=isNaN(t)||!isFinite(t)||t<=0?10:100*t,s.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+e));var a=void 0,l=void 0;if(e==t)l=this.default_span+.001,a=Math.log(t)/Math.log(10);else{var c=void 0,h=void 0;"percent"==this.range_padding_units?(c=Math.log(t)/Math.log(10),h=Math.log(e)/Math.log(10),l=(h-c)*(1+o)):(c=Math.log(t-o)/Math.log(10),h=Math.log(e+o)/Math.log(10),l=h-c),a=(c+h)/2}i=Math.pow(10,a-l/2),r=Math.pow(10,a+l/2)}else{var l=void 0;l=e==t?this.default_span:"percent"==this.range_padding_units?(e-t)*(1+o):e-t+2*o;var a=(e+t)/2;i=a-l/2,r=a+l/2}var u=1;this.flipped&&(i=(n=[r,i])[0],r=n[1],u=-1);var _=this.follow_interval;return null!=_&&Math.abs(i-r)>_&&("start"==this.follow?r=i+u*_:"end"==this.follow&&(i=r-u*_)),[i,r]},e.prototype.update=function(t,e,n,i){if(!this.have_updated_interactively){var r=this.computed_renderers(),o=this._compute_plot_bounds(r,t);null!=i&&(o=this.adjust_bounds_for_aspect(o,i)),this._plot_bounds[n]=o;var s=this._compute_min_max(this._plot_bounds,e),a=s[0],l=s[1],c=this._compute_range(a,l),h=c[0],u=c[1];null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(h=this._initial_start):h=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(u=this._initial_end):u=this._initial_end);var _=[this.start,this.end],d=_[0],p=_[1];if(h!=d||u!=p){var f={};h!=d&&(f.start=h),u!=p&&(f.end=u),this.setv(f)}"auto"==this.bounds&&this.setv({bounds:[h,u]},{silent:!0}),this.change.emit()}},e.prototype.reset=function(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()},e.__name__="DataRange1d",e}(r.DataRange);n.DataRange1d=h,h.initClass()},function(t,e,n){var i=t(421),r=t(194),o=t(18),s=t(25),a=t(24),l=t(46);function c(t,e,n){void 0===n&&(n=0);for(var i={},r=0;r<t.length;r++){var o=t[r];if(o in i)throw new Error("duplicate factor or subfactor: "+o);i[o]={value:.5+r*(1+e)+n}}return[i,(t.length-1)*e]}function h(t,e,n,i){void 0===i&&(i=0);for(var r={},o={},s=[],l=0,h=t;l<h.length;l++){var u=h[l],_=u[0],d=u[1];_ in o||(o[_]=[],s.push(_)),o[_].push(d)}for(var p=i,f=0,m=function(t){var i=o[t].length,s=c(o[t],n,p),l=s[0],h=s[1];f+=h;var u=a.sum(o[t].map(function(t){return l[t].value}));r[t]={value:u/i,mapping:l},p+=i+e+h},v=0,g=s;v<g.length;v++){var _=g[v];m(_)}return[r,s,(s.length-1)*e+f]}function u(t,e,n,i,r){void 0===r&&(r=0);for(var o={},s={},l=[],c=0,u=t;c<u.length;c++){var _=u[c],d=_[0],p=_[1],f=_[2];d in s||(s[d]=[],l.push(d)),s[d].push([p,f])}for(var m=[],v=r,g=0,y=function(t){for(var r=s[t].length,l=h(s[t],n,i,v),c=l[0],u=l[1],_=l[2],d=0,p=u;d<p.length;d++){var f=p[d];m.push([t,f])}g+=_;var y=a.sum(s[t].map(function(t){var e=t[0];return c[e].value}));o[t]={value:y/r,mapping:c},v+=r+e+_},b=0,w=l;b<w.length;b++){var d=w[b];y(d)}return[o,l,m,(l.length-1)*e+g]}n.map_one_level=c,n.map_two_levels=h,n.map_three_levels=u;var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({factors:[o.Array,[]],factor_padding:[o.Number,0],subgroup_padding:[o.Number,.8],group_padding:[o.Number,1.4],range_padding:[o.Number,0],range_padding_units:[o.PaddingUnits,"percent"],start:[o.Number],end:[o.Number]}),this.internal({levels:[o.Number],mids:[o.Array],tops:[o.Array],tops_groups:[o.Array]})},Object.defineProperty(e.prototype,"min",{get:function(){return this.start},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return this.end},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init(!0)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.factors.change,function(){return e.reset()}),this.connect(this.properties.factor_padding.change,function(){return e.reset()}),this.connect(this.properties.group_padding.change,function(){return e.reset()}),this.connect(this.properties.subgroup_padding.change,function(){return e.reset()}),this.connect(this.properties.range_padding.change,function(){return e.reset()}),this.connect(this.properties.range_padding_units.change,function(){return e.reset()})},e.prototype.reset=function(){this._init(!1),this.change.emit()},e.prototype._lookup=function(t){if(1==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])?e[t[0]].value:NaN}if(2==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])&&e[t[0]].mapping.hasOwnProperty(t[1])?e[t[0]].mapping[t[1]].value:NaN}if(3==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])&&e[t[0]].mapping.hasOwnProperty(t[1])&&e[t[0]].mapping[t[1]].mapping.hasOwnProperty(t[2])?e[t[0]].mapping[t[1]].mapping[t[2]].value:NaN}throw new Error("unreachable code")},e.prototype.synthetic=function(t){if(l.isNumber(t))return t;if(l.isString(t))return this._lookup([t]);var e=0,n=t[t.length-1];return l.isNumber(n)&&(e=n,t=t.slice(0,-1)),this._lookup(t)+e},e.prototype.v_synthetic=function(t){var e=this;return s.map(t,function(t){return e.synthetic(t)})},e.prototype._init=function(t){var e,n,i,r,o;if(a.every(this.factors,l.isString))r=1,e=c(this.factors,this.factor_padding),this._mapping=e[0],o=e[1];else if(a.every(this.factors,function(t){return l.isArray(t)&&2==t.length&&l.isString(t[0])&&l.isString(t[1])}))r=2,n=h(this.factors,this.group_padding,this.factor_padding),this._mapping=n[0],this.tops=n[1],o=n[2];else{if(!a.every(this.factors,function(t){return l.isArray(t)&&3==t.length&&l.isString(t[0])&&l.isString(t[1])&&l.isString(t[2])}))throw new Error("???");r=3,i=u(this.factors,this.group_padding,this.subgroup_padding,this.factor_padding),this._mapping=i[0],this.tops=i[1],this.mids=i[2],o=i[3]}var s=0,_=this.factors.length+o;if("percent"==this.range_padding_units){var d=(_-s)*this.range_padding/2;s-=d,_+=d}else s-=this.range_padding,_+=this.range_padding;this.setv({start:s,end:_,levels:r},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[s,_]},{silent:!0})},e.__name__="FactorRange",e}(r.Range);n.FactorRange=_,_.initClass()},function(t,e,n){var i=t(190);n.DataRange=i.DataRange;var r=t(191);n.DataRange1d=r.DataRange1d;var o=t(192);n.FactorRange=o.FactorRange;var s=t(194);n.Range=s.Range;var a=t(195);n.Range1d=a.Range1d},function(t,e,n){var i=t(421),r=t(62),o=t(18),s=t(46),a=function(t){function e(e){var n=t.call(this,e)||this;return n.have_updated_interactively=!1,n}return i.__extends(e,t),e.initClass=function(){this.define({callback:[o.Any],bounds:[o.Any],min_interval:[o.Any],max_interval:[o.Any]}),this.internal({plots:[o.Array,[]]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,function(){return e._emit_callback()})},e.prototype._emit_callback=function(){null!=this.callback&&(s.isFunction(this.callback)?this.callback(this):this.callback.execute(this,{}))},Object.defineProperty(e.prototype,"is_reversed",{get:function(){return this.start>this.end},enumerable:!0,configurable:!0}),e.__name__="Range",e}(r.Model);n.Range=a,a.initClass()},function(t,e,n){var i=t(421),r=t(194),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({start:[o.Number,0],end:[o.Number,1],reset_start:[o.Number],reset_end:[o.Number]})},e.prototype._set_auto_bounds=function(){if("auto"==this.bounds){var t=Math.min(this.reset_start,this.reset_end),e=Math.max(this.reset_start,this.reset_end);this.setv({bounds:[t,e]},{silent:!0})}},e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.reset_start&&(this.reset_start=this.start),null==this.reset_end&&(this.reset_end=this.end),this._set_auto_bounds()},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),e.prototype.reset=function(){this._set_auto_bounds(),this.start!=this.reset_start||this.end!=this.reset_end?this.setv({start:this.reset_start,end:this.reset_end}):this.change.emit()},e.__name__="Range1d",e}(r.Range);n.Range1d=s,s.initClass()},function(t,e,n){var i=t(421),r=t(201),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="DataRendererView",e}(r.RendererView);n.DataRendererView=s;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({level:"glyph"})},e.__name__="DataRenderer",e}(r.Renderer);n.DataRenderer=a,a.initClass()},function(t,e,n){var i=t(421),r=t(196),o=t(136),s=t(140),a=t(128),l=t(150),c=t(211),h=t(17),u=t(18),_=t(25),d=t(24),p=t(35),f=t(192),m={fill:{},line:{}},v={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},g={fill:{fill_alpha:.2},line:{}},y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=this.model.glyph,n=d.includes(e.mixins,"fill"),i=d.includes(e.mixins,"line"),r=p.clone(e.attributes);function o(t){var o=p.clone(r);return n&&p.extend(o,t.fill),i&&p.extend(o,t.line),new e.constructor(o)}delete r.id,this.glyph=this.build_glyph_view(e);var s=this.model.selection_glyph;null==s?s=o({fill:{},line:{}}):"auto"===s&&(s=o(m)),this.selection_glyph=this.build_glyph_view(s);var a=this.model.nonselection_glyph;null==a?a=o({fill:{},line:{}}):"auto"===a&&(a=o(g)),this.nonselection_glyph=this.build_glyph_view(a);var l=this.model.hover_glyph;null!=l&&(this.hover_glyph=this.build_glyph_view(l));var c=this.model.muted_glyph;null!=c&&(this.muted_glyph=this.build_glyph_view(c));var h=o(v);this.decimated_glyph=this.build_glyph_view(h),this.xscale=this.plot_view.frame.xscales[this.model.x_range_name],this.yscale=this.plot_view.frame.yscales[this.model.y_range_name],this.set_data(!1)},e.prototype.build_glyph_view=function(t){return new t.default_view({model:t,parent:this})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.request_render()}),this.connect(this.model.glyph.change,function(){return e.set_data()}),this.connect(this.model.data_source.change,function(){return e.set_data()}),this.connect(this.model.data_source.streaming,function(){return e.set_data()}),this.connect(this.model.data_source.patching,function(t){return e.set_data(!0,t)}),this.connect(this.model.data_source.selected.change,function(){return e.request_render()}),this.connect(this.model.data_source._select,function(){return e.request_render()}),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,function(){return e.request_render()}),this.connect(this.model.properties.view.change,function(){return e.set_data()}),this.connect(this.model.view.change,function(){return e.set_data()});var n=this.plot_view.frame,i=n.x_ranges,r=n.y_ranges;for(var o in i){var s=i[o];s instanceof f.FactorRange&&this.connect(s.change,function(){return e.set_data()})}for(var a in r){var s=r[a];s instanceof f.FactorRange&&this.connect(s.change,function(){return e.set_data()})}this.connect(this.model.glyph.transformchange,function(){return e.set_data()})},e.prototype.have_selection_glyphs=function(){return null!=this.selection_glyph&&null!=this.nonselection_glyph},e.prototype.set_data=function(t,e){void 0===t&&(t=!0),void 0===e&&(e=null);var n=Date.now(),i=this.model.data_source;this.all_indices=this.model.view.indices,this.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.glyph.set_data(i,this.all_indices,e),this.glyph.set_visuals(i),this.decimated_glyph.set_visuals(i),this.have_selection_glyphs()&&(this.selection_glyph.set_visuals(i),this.nonselection_glyph.set_visuals(i)),null!=this.hover_glyph&&this.hover_glyph.set_visuals(i),null!=this.muted_glyph&&this.muted_glyph.set_visuals(i);var r=this.plot_model.lod_factor;this.decimated=[];for(var o=0,s=Math.floor(this.all_indices.length/r);o<s;o++)this.decimated.push(o*r);var a=Date.now()-n;h.logger.debug(this.glyph.model.type+" GlyphRenderer ("+this.model.id+"): set_data finished in "+a+"ms"),this.set_data_timestamp=Date.now(),t&&this.request_render()},Object.defineProperty(e.prototype,"has_webgl",{get:function(){return null!=this.glyph.glglyph},enumerable:!0,configurable:!0}),e.prototype.render=function(){var t=this;if(this.model.visible){var e=Date.now(),n=this.has_webgl;this.glyph.map_data();var i=Date.now()-e,r=Date.now(),c=this.glyph.mask_data(this.all_indices);c.length===this.all_indices.length&&(c=d.range(0,this.all_indices.length));var u=Date.now()-r,p=this.plot_view.canvas_view.ctx;p.save();var f,m=this.model.data_source.selected;f=!m||m.is_empty()?[]:this.glyph instanceof o.LineView&&m.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(c):m.indices;var v,g,y,b=this.model.data_source.inspected,w=new Set(!b||b.is_empty()?[]:b["0d"].glyph?t.model.view.convert_indices_from_subset(c):b["1d"].indices.length>0?b["1d"].indices:_.map(Object.keys(b["2d"].indices),function(t){return parseInt(t)})),x=_.filter(c,function(e){return w.has(t.all_indices[e])}),A=this.plot_model.lod_threshold;null!=this.model.document&&this.model.document.interactive_duration()>0&&!n&&null!=A&&this.all_indices.length>A?(c=this.decimated,v=this.decimated_glyph,g=this.decimated_glyph,y=this.selection_glyph):(v=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,g=this.nonselection_glyph,y=this.selection_glyph),null!=this.hover_glyph&&x.length&&(c=d.difference(c,x));var k,C=null;if(f.length&&this.have_selection_glyphs()){for(var T=Date.now(),S={},M=0,E=f;M<E.length;M++){var z=E[M];S[z]=!0}var O=new Array,P=new Array;if(this.glyph instanceof o.LineView)for(var j=0,N=this.all_indices;j<N.length;j++){var z=N[j];null!=S[z]?O.push(z):P.push(z)}else for(var I=0,B=c;I<B.length;I++){var z=B[I];null!=S[this.all_indices[z]]?O.push(z):P.push(z)}C=Date.now()-T,k=Date.now(),g.render(p,P,this.glyph),y.render(p,O,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof o.LineView?this.hover_glyph.render(p,this.model.view.convert_indices_from_subset(x),this.glyph):this.hover_glyph.render(p,x,this.glyph))}else if(k=Date.now(),this.glyph instanceof o.LineView)this.hover_glyph&&x.length?this.hover_glyph.render(p,this.model.view.convert_indices_from_subset(x),this.glyph):v.render(p,this.all_indices,this.glyph);else if(this.glyph instanceof s.PatchView||this.glyph instanceof a.HAreaView||this.glyph instanceof l.VAreaView)if(0==b.selected_glyphs.length||null==this.hover_glyph)v.render(p,this.all_indices,this.glyph);else for(var R=0,D=b.selected_glyphs;R<D.length;R++){var F=D[R];F.id==this.glyph.model.id&&this.hover_glyph.render(p,this.all_indices,this.glyph)}else v.render(p,c,this.glyph),this.hover_glyph&&x.length&&this.hover_glyph.render(p,x,this.glyph);var V=Date.now()-k;this.last_dtrender=V;var L=Date.now()-e;h.logger.debug(this.glyph.model.type+" GlyphRenderer ("+this.model.id+"): render finished in "+L+"ms"),h.logger.trace(" - map_data finished in       : "+i+"ms"),h.logger.trace(" - mask_data finished in      : "+u+"ms"),null!=C&&h.logger.trace(" - selection mask finished in : "+C+"ms"),h.logger.trace(" - glyph renders finished in  : "+V+"ms"),p.restore()}},e.prototype.draw_legend=function(t,e,n,i,r,o,s,a){null==a&&(a=this.model.get_reference_point(o,s)),this.glyph.draw_legend_for_index(t,{x0:e,x1:n,y0:i,y1:r},a)},e.prototype.hit_test=function(t){if(!this.model.visible)return null;var e=this.glyph.hit_test(t);return null==e?null:this.model.view.convert_selection_from_subset(e)},e.__name__="GlyphRendererView",e}(r.DataRendererView);n.GlyphRendererView=y;var b=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=y,this.define({data_source:[u.Instance],view:[u.Instance,function(){return new c.CDSView}],glyph:[u.Instance],hover_glyph:[u.Instance],nonselection_glyph:[u.Any,"auto"],selection_glyph:[u.Any,"auto"],muted_glyph:[u.Instance],muted:[u.Boolean,!1]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.data_source,this.view.compute_indices())},e.prototype.get_reference_point=function(t,e){var n=0;if(null!=t){var i=this.data_source.get_column(t);if(null!=i){var r=_.indexOf(i,e);-1!=r&&(n=r)}}return n},e.prototype.get_selection_manager=function(){return this.data_source.selection_manager},e.__name__="GlyphRenderer",e}(r.DataRenderer);n.GlyphRenderer=b,b.initClass()},function(t,e,n){var i=t(421),r=t(196),o=t(154),s=t(18),a=t(4),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){var e;t.prototype.initialize.call(this),this.xscale=this.plot_view.frame.xscales.default,this.yscale=this.plot_view.frame.yscales.default,this._renderer_views={},e=a.build_views(this._renderer_views,[this.model.node_renderer,this.model.edge_renderer],{parent:this.parent}),this.node_view=e[0],this.edge_view=e[1],this.set_data()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.layout_provider.change,function(){return e.set_data()}),this.connect(this.model.node_renderer.data_source._select,function(){return e.set_data()}),this.connect(this.model.node_renderer.data_source.inspect,function(){return e.set_data()}),this.connect(this.model.node_renderer.data_source.change,function(){return e.set_data()}),this.connect(this.model.edge_renderer.data_source._select,function(){return e.set_data()}),this.connect(this.model.edge_renderer.data_source.inspect,function(){return e.set_data()}),this.connect(this.model.edge_renderer.data_source.change,function(){return e.set_data()});var n=this.plot_view.frame,i=n.x_ranges,r=n.y_ranges;for(var o in i){var s=i[o];this.connect(s.change,function(){return e.set_data()})}for(var a in r){var s=r[a];this.connect(s.change,function(){return e.set_data()})}},e.prototype.set_data=function(t){var e,n;void 0===t&&(t=!0),this.node_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.edge_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0});var i=this.node_view.glyph;e=this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source),i._x=e[0],i._y=e[1];var r=this.edge_view.glyph;n=this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source),r._xs=n[0],r._ys=n[1],i.index_data(),r.index_data(),t&&this.request_render()},e.prototype.render=function(){this.edge_view.render(),this.node_view.render()},e.__name__="GraphRendererView",e}(r.DataRendererView);n.GraphRendererView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({layout_provider:[s.Instance],node_renderer:[s.Instance],edge_renderer:[s.Instance],selection_policy:[s.Instance,function(){return new o.NodesOnly}],inspection_policy:[s.Instance,function(){return new o.NodesOnly}]})},e.prototype.get_selection_manager=function(){return this.node_renderer.data_source.selection_manager},e.__name__="GraphRenderer",e}(r.DataRenderer);n.GraphRenderer=c,c.initClass()},function(t,e,n){var i=t(421),r=t(201),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="GuideRendererView",e}(r.RendererView);n.GuideRendererView=o;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.override({level:"overlay"})},e.__name__="GuideRenderer",e}(r.Renderer);n.GuideRenderer=s,s.initClass()},function(t,e,n){var i=t(197);n.GlyphRenderer=i.GlyphRenderer;var r=t(198);n.GraphRenderer=r.GraphRenderer;var o=t(199);n.GuideRenderer=o.GuideRenderer;var s=t(201);n.Renderer=s.Renderer},function(t,e,n){var i=t(421),r=t(6),o=t(51),s=t(18),a=t(62),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals=new o.Visuals(this.model),this._has_finished=!0},Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!0,configurable:!0}),e.prototype.request_render=function(){this.plot_view.request_render()},e.prototype.map_to_screen=function(t,e){return this.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return!1},enumerable:!0,configurable:!0}),e.prototype.notify_finished=function(){this.plot_view.notify_finished()},Object.defineProperty(e.prototype,"has_webgl",{get:function(){return!1},enumerable:!0,configurable:!0}),e.__name__="RendererView",e}(r.DOMView);n.RendererView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({level:[s.RenderLevel],visible:[s.Boolean,!0]})},e.__name__="Renderer",e}(a.Model);n.Renderer=c,c.initClass()},function(t,e,n){var i=t(421),r=t(204),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.compute=function(e){return t.prototype.compute.call(this,this.source_range.synthetic(e))},e.prototype.v_compute=function(e){return t.prototype.v_compute.call(this,this.source_range.v_synthetic(e))},e.__name__="CategoricalScale",e}(r.LinearScale);n.CategoricalScale=o},function(t,e,n){var i=t(202);n.CategoricalScale=i.CategoricalScale;var r=t(204);n.LinearScale=r.LinearScale;var o=t(205);n.LogScale=o.LogScale;var s=t(206);n.Scale=s.Scale},function(t,e,n){var i=t(421),r=t(206),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.compute=function(t){var e=this._compute_state(),n=e[0],i=e[1];return n*t+i},e.prototype.v_compute=function(t){for(var e=this._compute_state(),n=e[0],i=e[1],r=new Float64Array(t.length),o=0;o<t.length;o++)r[o]=n*t[o]+i;return r},e.prototype.invert=function(t){var e=this._compute_state(),n=e[0],i=e[1];return(t-i)/n},e.prototype.v_invert=function(t){for(var e=this._compute_state(),n=e[0],i=e[1],r=new Float64Array(t.length),o=0;o<t.length;o++)r[o]=(t[o]-i)/n;return r},e.prototype._compute_state=function(){var t=this.source_range.start,e=this.source_range.end,n=this.target_range.start,i=this.target_range.end,r=(i-n)/(e-t),o=-r*t+n;return[r,o]},e.__name__="LinearScale",e}(r.Scale);n.LinearScale=o},function(t,e,n){var i=t(421),r=t(206),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.compute=function(t){var e,n=this._compute_state(),i=n[0],r=n[1],o=n[2],s=n[3];if(0==o)e=0;else{var a=(Math.log(t)-s)/o;e=isFinite(a)?a*i+r:NaN}return e},e.prototype.v_compute=function(t){var e=this._compute_state(),n=e[0],i=e[1],r=e[2],o=e[3],s=new Float64Array(t.length);if(0==r)for(var a=0;a<t.length;a++)s[a]=0;else for(var a=0;a<t.length;a++){var l=(Math.log(t[a])-o)/r,c=void 0;c=isFinite(l)?l*n+i:NaN,s[a]=c}return s},e.prototype.invert=function(t){var e=this._compute_state(),n=e[0],i=e[1],r=e[2],o=e[3],s=(t-i)/n;return Math.exp(r*s+o)},e.prototype.v_invert=function(t){for(var e=this._compute_state(),n=e[0],i=e[1],r=e[2],o=e[3],s=new Float64Array(t.length),a=0;a<t.length;a++){var l=(t[a]-i)/n;s[a]=Math.exp(r*l+o)}return s},e.prototype._get_safe_factor=function(t,e){var n,i=t<0?0:t,r=e<0?0:e;if(i==r)if(0==i)i=(n=[1,10])[0],r=n[1];else{var o=Math.log(i)/Math.log(10);i=Math.pow(10,Math.floor(o)),r=Math.ceil(o)!=Math.floor(o)?Math.pow(10,Math.ceil(o)):Math.pow(10,Math.ceil(o)+1)}return[i,r]},e.prototype._compute_state=function(){var t,e,n=this.source_range.start,i=this.source_range.end,r=this.target_range.start,o=this.target_range.end,s=o-r,a=this._get_safe_factor(n,i),l=a[0],c=a[1];0==l?(t=Math.log(c),e=0):(t=Math.log(c)-Math.log(l),e=Math.log(l));var h=s,u=r;return[h,u,t,e]},e.__name__="LogScale",e}(r.Scale);n.LogScale=o},function(t,e,n){var i=t(421),r=t(292),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.internal({source_range:[o.Any],target_range:[o.Any]})},e.prototype.r_compute=function(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]},e.prototype.r_invert=function(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]},e.__name__="Scale",e}(r.Transform);n.Scale=s,s.initClass()},function(t,e,n){var i=t(421);i.__exportStar(t(208),n);var r=t(209);n.Selection=r.Selection},function(t,e,n){var i=t(421),r=t(62),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.do_selection=function(t,e,n,i){return null!==t&&(e.selected.update(t,n,i),e._select.emit(),!e.selected.is_empty())},e.__name__="SelectionPolicy",e}(r.Model);n.SelectionPolicy=o;var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.hit_test=function(t,e){for(var n=[],i=0,r=e;i<r.length;i++){var o=r[i],s=o.hit_test(t);null!==s&&n.push(s)}if(n.length>0){for(var a=n[0],l=0,c=n;l<c.length;l++){var h=c[l];a.update_through_intersection(h)}return a}return null},e.__name__="IntersectRenderers",e}(o);n.IntersectRenderers=s;var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.hit_test=function(t,e){for(var n=[],i=0,r=e;i<r.length;i++){var o=r[i],s=o.hit_test(t);null!==s&&n.push(s)}if(n.length>0){for(var a=n[0],l=0,c=n;l<c.length;l++){var h=c[l];a.update_through_union(h)}return a}return null},e.__name__="UnionRenderers",e}(o);n.UnionRenderers=a},function(t,e,n){var i=t(421),r=t(62),o=t(18),s=t(24),a=t(35),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({indices:[o.Array,[]],line_indices:[o.Array,[]],multiline_indices:[o.Any,{}]}),this.internal({final:[o.Boolean],selected_glyphs:[o.Array,[]],get_view:[o.Any],image_indices:[o.Array,[]]})},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this["0d"]={glyph:null,indices:[],flag:!1,get_view:function(){return null}},this["1d"]={indices:this.indices},this["2d"]={indices:{}},this.get_view=function(){return null},this.connect(this.properties.indices.change,function(){return e["1d"].indices=e.indices}),this.connect(this.properties.line_indices.change,function(){e["0d"].indices=e.line_indices,e["0d"].flag=0!=e.line_indices.length}),this.connect(this.properties.selected_glyphs.change,function(){return e["0d"].glyph=e.selected_glyph}),this.connect(this.properties.get_view.change,function(){return e["0d"].get_view=e.get_view}),this.connect(this.properties.multiline_indices.change,function(){return e["2d"].indices=e.multiline_indices})},Object.defineProperty(e.prototype,"selected_glyph",{get:function(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null},enumerable:!0,configurable:!0}),e.prototype.add_to_selected_glyphs=function(t){this.selected_glyphs.push(t)},e.prototype.update=function(t,e,n){this.final=e,n?this.update_through_union(t):(this.indices=t.indices,this.line_indices=t.line_indices,this.selected_glyphs=t.selected_glyphs,this.get_view=t.get_view,this.multiline_indices=t.multiline_indices,this.image_indices=t.image_indices)},e.prototype.clear=function(){this.final=!0,this.indices=[],this.line_indices=[],this.multiline_indices={},this.get_view=function(){return null},this.selected_glyphs=[]},e.prototype.is_empty=function(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length},e.prototype.update_through_union=function(t){this.indices=s.union(t.indices,this.indices),this.selected_glyphs=s.union(t.selected_glyphs,this.selected_glyphs),this.line_indices=s.union(t.line_indices,this.line_indices),this.get_view()||(this.get_view=t.get_view),this.multiline_indices=a.merge(t.multiline_indices,this.multiline_indices)},e.prototype.update_through_intersection=function(t){this.indices=s.intersection(t.indices,this.indices),this.selected_glyphs=s.union(t.selected_glyphs,this.selected_glyphs),this.line_indices=s.union(t.line_indices,this.line_indices),this.get_view()||(this.get_view=t.get_view),this.multiline_indices=a.merge(t.multiline_indices,this.multiline_indices)},e.__name__="Selection",e}(r.Model);n.Selection=l,l.initClass()},function(t,e,n){var i=t(421),r=t(217),o=t(17),s=t(18),a=function(t){function e(e){var n=t.call(this,e)||this;return n.initialized=!1,n}return i.__extends(e,t),e.initClass=function(){this.define({content_type:[s.String,"application/json"],http_headers:[s.Any,{}],method:[s.HTTPMethod,"POST"],if_modified:[s.Boolean,!1]})},e.prototype.destroy=function(){null!=this.interval&&clearInterval(this.interval),t.prototype.destroy.call(this)},e.prototype.setup=function(){var t=this;!this.initialized&&(this.initialized=!0,this.get_data(this.mode),this.polling_interval)&&(this.interval=setInterval(function(){return t.get_data(t.mode,t.max_size,t.if_modified)},this.polling_interval))},e.prototype.get_data=function(t,e,n){var i=this;void 0===e&&(e=0),void 0===n&&(n=!1);var r=this.prepare_request();r.addEventListener("load",function(){return i.do_load(r,t,e)}),r.addEventListener("error",function(){return i.do_error(r)}),r.send()},e.prototype.prepare_request=function(){var t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);var e=this.http_headers;for(var n in e){var i=e[n];t.setRequestHeader(n,i)}return t},e.prototype.do_load=function(t,e,n){if(200===t.status){var i=JSON.parse(t.responseText);this.load_data(i,e,n)}},e.prototype.do_error=function(t){o.logger.error("Failed to fetch JSON from "+this.data_url+" with code "+t.status)},e.__name__="AjaxDataSource",e}(r.RemoteDataSource);n.AjaxDataSource=a,a.initClass()},function(t,e,n){var i=t(421),r=t(62),o=t(18),s=t(209),a=t(24),l=t(213),c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({filters:[o.Array,[]],source:[o.Instance]}),this.internal({indices:[o.Array,[]],indices_map:[o.Any,{}]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.compute_indices()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.filters.change,function(){e.compute_indices(),e.change.emit()});var n=function(){var t=function(){return e.compute_indices()};null!=e.source&&(e.connect(e.source.change,t),e.source instanceof l.ColumnarDataSource&&(e.connect(e.source.streaming,t),e.connect(e.source.patching,t)))},i=null!=this.source;i?n():this.connect(this.properties.source.change,function(){i||(n(),i=!0)})},e.prototype.compute_indices=function(){var t=this,e=this.filters.map(function(e){return e.compute_indices(t.source)}).filter(function(t){return null!=t});e.length>0?this.indices=a.intersection.apply(this,e):this.source instanceof l.ColumnarDataSource&&(this.indices=this.source.get_indices()),this.indices_map_to_subset()},e.prototype.indices_map_to_subset=function(){this.indices_map={};for(var t=0;t<this.indices.length;t++)this.indices_map[this.indices[t]]=t},e.prototype.convert_selection_from_subset=function(t){var e=this,n=new s.Selection;n.update_through_union(t);var i=t.indices.map(function(t){return e.indices[t]});return n.indices=i,n.image_indices=t.image_indices,n},e.prototype.convert_selection_to_subset=function(t){var e=this,n=new s.Selection;n.update_through_union(t);var i=t.indices.map(function(t){return e.indices_map[t]});return n.indices=i,n.image_indices=t.image_indices,n},e.prototype.convert_indices_from_subset=function(t){var e=this;return t.map(function(t){return e.indices[t]})},e.__name__="CDSView",e}(r.Model);n.CDSView=c,c.initClass()},function(t,e,n){var i=t(421),r=t(213),o=t(8),s=t(18),a=t(32),l=t(38),c=t(46),h=t(45),u=t(35),_=t(53);function d(t,e,n){if(c.isArray(t)){var i=t.concat(e);return null!=n&&i.length>n?i.slice(-n):i}if(c.isTypedArray(t)){var r=t.length+e.length;if(null!=n&&r>n){var o=r-n,s=t.length,i=void 0;t.length<n?(i=new t.constructor(n)).set(t,0):i=t;for(var a=o,l=s;a<l;a++)i[a-o]=i[a];for(var a=0,l=e.length;a<l;a++)i[a+(s-o)]=e[a];return i}var u=new t.constructor(e);return h.concat(t,u)}throw new Error("unsupported array types")}function p(t,e){var n,i,r;return c.isNumber(t)?(n=t,r=t+1,i=1):(n=null!=t.start?t.start:0,r=null!=t.stop?t.stop:e,i=null!=t.step?t.step:1),[n,r,i]}function f(t,e,n){for(var i=new a.Set,r=!1,o=0,s=e;o<s.length;o++){var l=s[o],h=l[0],u=l[1],_=void 0,d=void 0,f=void 0,m=void 0;if(c.isArray(h)){var v=h[0];i.add(v),d=n[v],_=t[v],m=u,2===h.length?(d=[1,d[0]],f=[h[0],0,h[1]]):f=h}else c.isNumber(h)?(m=[u],i.add(h)):(m=u,r=!0),f=[0,0,h],d=[1,t.length],_=t;for(var g=0,y=p(f[1],d[0]),b=y[0],w=y[1],x=y[2],A=p(f[2],d[1]),k=A[0],C=A[1],T=A[2],v=b;v<w;v+=x)for(var S=k;S<C;S+=T)r&&i.add(S),_[v*d[1]+S]=m[g],g++}return i}n.stream_to_column=d,n.slice=p,n.patch_to_column=f;var m=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({data:[s.Any,{}]})},e.prototype.initialize=function(){var e;t.prototype.initialize.call(this),e=l.decode_column_data(this.data),this.data=e[0],this._shapes=e[1]},e.prototype.attributes_as_json=function(t,n){void 0===t&&(t=!0),void 0===n&&(n=e._value_to_json);for(var i={},r=this.serializable_attributes(),o=0,s=u.keys(r);o<s.length;o++){var a=s[o],c=r[a];"data"===a&&(c=l.encode_column_data(c,this._shapes)),t?i[a]=c:a in this._set_after_defaults&&(i[a]=c)}return n("attributes",i,this)},e._value_to_json=function(t,e,n){return c.isPlainObject(e)&&"data"===t?l.encode_column_data(e,n._shapes):o.HasProps._value_to_json(t,e,n)},e.prototype.stream=function(t,e,n){var i=this.data;for(var r in t)i[r]=d(i[r],t[r],e);if(this.setv({data:i},{silent:!0}),this.streaming.emit(),null!=this.document){var o=new _.ColumnsStreamedEvent(this.document,this.ref(),t,e);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:o})}},e.prototype.patch=function(t,e){var n=this.data,i=new a.Set;for(var r in t){var o=t[r];i=i.union(f(n[r],o,this._shapes[r]))}if(this.setv({data:n},{silent:!0}),this.patching.emit(i.values),null!=this.document){var s=new _.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}},e.__name__="ColumnDataSource",e}(r.ColumnarDataSource);n.ColumnDataSource=m,m.initClass()},function(t,e,n){var i=t(421),r=t(214),o=t(22),s=t(17),a=t(20),l=t(18),c=t(46),h=t(24),u=t(35),_=t(209),d=t(208),p=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.get_array=function(t){var e=this.data[t];return null==e?this.data[t]=e=[]:c.isArray(e)||(this.data[t]=e=Array.from(e)),e},e.initClass=function(){this.define({selection_policy:[l.Instance,function(){return new d.UnionRenderers}]}),this.internal({selection_manager:[l.Instance,function(t){return new a.SelectionManager({source:t})}],inspected:[l.Instance,function(){return new _.Selection}],_shapes:[l.Any,{}]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._select=new o.Signal0(this,"select"),this.inspect=new o.Signal(this,"inspect"),this.streaming=new o.Signal0(this,"streaming"),this.patching=new o.Signal(this,"patching")},e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:null},e.prototype.columns=function(){return u.keys(this.data)},e.prototype.get_length=function(t){void 0===t&&(t=!0);var e=h.uniq(u.values(this.data).map(function(t){return t.length}));switch(e.length){case 0:return null;case 1:return e[0];default:var n="data source has columns of inconsistent lengths";if(t)return s.logger.warn(n),e.sort()[0];throw new Error(n)}},e.prototype.get_indices=function(){var t=this.get_length();return h.range(0,null!=t?t:1)},e.prototype.clear=function(){for(var t={},e=0,n=this.columns();e<n.length;e++){var i=n[e];t[i]=new this.data[i].constructor(0)}this.data=t},e.__name__="ColumnarDataSource",e}(r.DataSource);n.ColumnarDataSource=p,p.initClass()},function(t,e,n){var i=t(421),r=t(62),o=t(209),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({selected:[s.Instance,function(){return new o.Selection}],callback:[s.Any]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.selected.change,function(){null!=e.callback&&e.callback.execute(e)})},e.__name__="DataSource",e}(r.Model);n.DataSource=a,a.initClass()},function(t,e,n){var i=t(421),r=t(213),o=t(17),s=t(18),a=t(24),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({geojson:[s.Any]}),this.internal({data:[s.Any,{}]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._update_data()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.geojson.change,function(){return e._update_data()})},e.prototype._update_data=function(){this.data=this.geojson_to_column_data()},e.prototype._get_new_list_array=function(t){return a.range(0,t).map(function(t){return[]})},e.prototype._get_new_nan_array=function(t){return a.range(0,t).map(function(t){return NaN})},e.prototype._add_properties=function(t,e,n,i){var r=t.properties||{};for(var o in r)e.hasOwnProperty(o)||(e[o]=this._get_new_nan_array(i)),e[o][n]=r[o]},e.prototype._add_geometry=function(t,e,n){function i(t){return null!=t?t:NaN}function r(t,e){return t.concat([[NaN,NaN,NaN]]).concat(e)}switch(t.type){case"Point":var s=t.coordinates,a=s[0],l=s[1],c=s[2];e.x[n]=a,e.y[n]=l,e.z[n]=i(c);break;case"LineString":for(var h=t.coordinates,u=0;u<h.length;u++){var _=h[u],a=_[0],l=_[1],c=_[2];e.xs[n][u]=a,e.ys[n][u]=l,e.zs[n][u]=i(c)}break;case"Polygon":t.coordinates.length>1&&o.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");for(var d=t.coordinates[0],u=0;u<d.length;u++){var p=d[u],a=p[0],l=p[1],c=p[2];e.xs[n][u]=a,e.ys[n][u]=l,e.zs[n][u]=i(c)}break;case"MultiPoint":o.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":for(var h=t.coordinates.reduce(r),u=0;u<h.length;u++){var f=h[u],a=f[0],l=f[1],c=f[2];e.xs[n][u]=a,e.ys[n][u]=l,e.zs[n][u]=i(c)}break;case"MultiPolygon":for(var m=[],v=0,g=t.coordinates;v<g.length;v++){var y=g[v];y.length>1&&o.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),m.push(y[0])}for(var h=m.reduce(r),u=0;u<h.length;u++){var b=h[u],a=b[0],l=b[1],c=b[2];e.xs[n][u]=a,e.ys[n][u]=l,e.zs[n][u]=i(c)}break;default:throw new Error("Invalid GeoJSON geometry type: "+t.type)}},e.prototype.geojson_to_column_data=function(){var t,e=JSON.parse(this.geojson);switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}for(var n=0,i=0,r=t;i<r.length;i++){var o=r[i],s="Feature"===o.type?o.geometry:o;"GeometryCollection"==s.type?n+=s.geometries.length:n+=1}for(var a={x:this._get_new_nan_array(n),y:this._get_new_nan_array(n),z:this._get_new_nan_array(n),xs:this._get_new_list_array(n),ys:this._get_new_list_array(n),zs:this._get_new_list_array(n)},l=0,c=0,h=t;c<h.length;c++){var o=h[c],s="Feature"==o.type?o.geometry:o;if("GeometryCollection"==s.type)for(var u=0,_=s.geometries;u<_.length;u++){var d=_[u];this._add_geometry(d,a,l),"Feature"===o.type&&this._add_properties(o,a,l,n),l+=1}else this._add_geometry(s,a,l),"Feature"===o.type&&this._add_properties(o,a,l,n),l+=1}return a},e.__name__="GeoJSONDataSource",e}(r.ColumnarDataSource);n.GeoJSONDataSource=l,l.initClass()},function(t,e,n){var i=t(218);n.ServerSentDataSource=i.ServerSentDataSource;var r=t(210);n.AjaxDataSource=r.AjaxDataSource;var o=t(212);n.ColumnDataSource=o.ColumnDataSource;var s=t(213);n.ColumnarDataSource=s.ColumnarDataSource;var a=t(211);n.CDSView=a.CDSView;var l=t(214);n.DataSource=l.DataSource;var c=t(215);n.GeoJSONDataSource=c.GeoJSONDataSource;var h=t(217);n.RemoteDataSource=h.RemoteDataSource},function(t,e,n){var i=t(421),r=t(219),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:[]},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.setup()},e.initClass=function(){this.define({polling_interval:[o.Number]})},e.__name__="RemoteDataSource",e}(r.WebDataSource);n.RemoteDataSource=s,s.initClass()},function(t,e,n){var i=t(421),r=t(219),o=function(t){function e(e){var n=t.call(this,e)||this;return n.initialized=!1,n}return i.__extends(e,t),e.prototype.destroy=function(){t.prototype.destroy.call(this)},e.prototype.setup=function(){var t=this;if(!this.initialized){this.initialized=!0;var e=new EventSource(this.data_url);e.onmessage=function(e){t.load_data(JSON.parse(e.data),t.mode,t.max_size)}}},e.__name__="ServerSentDataSource",e}(r.WebDataSource);n.ServerSentDataSource=o},function(t,e,n){var i=t(421),r=t(212),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:[]},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.setup()},e.prototype.load_data=function(t,e,n){var i,r=this.adapter;switch(i=null!=r?r.execute(this,{response:t}):t,e){case"replace":this.data=i;break;case"append":for(var o=this.data,s=0,a=this.columns();s<a.length;s++){var l=a[s],c=Array.from(o[l]),h=Array.from(i[l]);i[l]=c.concat(h).slice(-n)}this.data=i}},e.initClass=function(){this.define({mode:[o.UpdateMode,"replace"],max_size:[o.Number],adapter:[o.Any,null],data_url:[o.String]})},e.__name__="WebDataSource",e}(r.ColumnDataSource);n.WebDataSource=s,s.initClass()},function(t,e,n){var i=t(421),r=t(223),o=t(18),s=t(40),a=function(e){function n(t){return e.call(this,t)||this}return i.__extends(n,e),n.initClass=function(){this.define({code:[o.String]})},Object.defineProperty(n.prototype,"func",{get:function(){var t=s.use_strict(this.code);return new Function("ctx","color","scale","weight","require","exports",t)},enumerable:!0,configurable:!0}),n.prototype.get_pattern=function(e,n,i){var r=this;return function(o){var s=document.createElement("canvas");s.width=n,s.height=n;var a=s.getContext("2d");return r.func.call(r,a,e,n,i,t,{}),o.createPattern(s,r.repetition)}},n.__name__="CanvasTexture",n}(r.Texture);n.CanvasTexture=a,a.initClass()},function(t,e,n){var i=t(421),r=t(223),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({url:[o.String]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.image=new Image,this.image.src=this.url},e.prototype.get_pattern=function(t,e,n){var i=this;return function(t){return i.image.complete?t.createPattern(i.image,i.repetition):null}},e.prototype.onload=function(t){this.image.complete?t():this.image.onload=function(){t()}},e.__name__="ImageURLTexture",e}(r.Texture);n.ImageURLTexture=s,s.initClass()},function(t,e,n){var i=t(220);n.CanvasTexture=i.CanvasTexture;var r=t(221);n.ImageURLTexture=r.ImageURLTexture;var o=t(223);n.Texture=o.Texture},function(t,e,n){var i=t(421),r=t(62),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({repetition:[o.TextureRepetition,"repeat"]})},e.prototype.onload=function(t){t()},e.__name__="Texture",e}(r.Model);n.Texture=s,s.initClass()},function(t,e,n){var i=t(421),r=t(228),o=t(24),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({base:[s.Number,10],mantissas:[s.Array,[1,2,5]],min_interval:[s.Number,0],max_interval:[s.Number]})},e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=o.nth(this.mantissas,-1)/this.base,n=o.nth(this.mantissas,0)*this.base;this.extended_mantissas=[e].concat(this.mantissas,[n]),this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()},e.prototype.get_interval=function(t,e,n){var i,r,s,a=e-t,l=this.get_ideal_interval(t,e,n),c=Math.floor(function(t,e){return void 0===e&&(e=Math.E),Math.log(t)/Math.log(e)}(l/this.base_factor,this.base)),h=Math.pow(this.base,c)*this.base_factor,u=this.extended_mantissas,_=u.map(function(t){return Math.abs(n-a/(t*h))}),d=u[o.argmin(_)],p=d*h;return i=p,r=this.get_min_interval(),s=this.get_max_interval(),Math.max(r,Math.min(s,i))},e.__name__="AdaptiveTicker",e}(r.ContinuousTicker);n.AdaptiveTicker=a,a.initClass()},function(t,e,n){var i=t(421),r=t(224),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="BasicTicker",e}(r.AdaptiveTicker);n.BasicTicker=o},function(t,e,n){var i=t(421),r=t(237),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.get_ticks=function(t,e,n,i,r){var o=this._collect(n.factors,n,t,e),s=this._collect(n.tops||[],n,t,e),a=this._collect(n.mids||[],n,t,e);return{major:o,minor:[],tops:s,mids:a}},e.prototype._collect=function(t,e,n,i){for(var r=[],o=0,s=t;o<s.length;o++){var a=s[o],l=e.synthetic(a);l>n&&l<i&&r.push(a)}return r},e.__name__="CategoricalTicker",e}(r.Ticker);n.CategoricalTicker=o},function(t,e,n){var i=t(421),r=t(228),o=t(18),s=t(24),a=t(35),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({tickers:[o.Array,[]]})},Object.defineProperty(e.prototype,"min_intervals",{get:function(){return this.tickers.map(function(t){return t.get_min_interval()})},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_intervals",{get:function(){return this.tickers.map(function(t){return t.get_max_interval()})},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"min_interval",{get:function(){return this.min_intervals[0]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_interval",{get:function(){return this.max_intervals[0]},enumerable:!0,configurable:!0}),e.prototype.get_best_ticker=function(t,e,n){var i,r=e-t,o=this.get_ideal_interval(t,e,n),l=[s.sorted_index(this.min_intervals,o)-1,s.sorted_index(this.max_intervals,o)],c=[this.min_intervals[l[0]],this.max_intervals[l[1]]],h=c.map(function(t){return Math.abs(n-r/t)});if(a.isEmpty(h.filter(function(t){return!isNaN(t)})))i=this.tickers[0];else{var u=s.argmin(h),_=l[u];i=this.tickers[_]}return i},e.prototype.get_interval=function(t,e,n){var i=this.get_best_ticker(t,e,n);return i.get_interval(t,e,n)},e.prototype.get_ticks_no_defaults=function(t,e,n,i){var r=this.get_best_ticker(t,e,i);return r.get_ticks_no_defaults(t,e,n,i)},e.__name__="CompositeTicker",e}(r.ContinuousTicker);n.CompositeTicker=l,l.initClass()},function(t,e,n){var i=t(421),r=t(237),o=t(18),s=t(24),a=t(46),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({num_minor_ticks:[o.Number,5],desired_num_ticks:[o.Number,6]})},e.prototype.get_ticks=function(t,e,n,i,r){return this.get_ticks_no_defaults(t,e,i,this.desired_num_ticks)},e.prototype.get_ticks_no_defaults=function(t,e,n,i){var r=this.get_interval(t,e,i),o=Math.floor(t/r),l=Math.ceil(e/r),c=(a.isStrictNaN(o)||a.isStrictNaN(l)?[]:s.range(o,l+1)).map(function(t){return t*r}).filter(function(n){return t<=n&&n<=e}),h=this.num_minor_ticks,u=[];if(h>0&&c.length>0){for(var _=r/h,d=s.range(0,h).map(function(t){return t*_}),p=0,f=d.slice(1);p<f.length;p++){var m=f[p],v=c[0]-m;t<=v&&v<=e&&u.push(v)}for(var g=0,y=c;g<y.length;g++)for(var b=y[g],w=0,x=d;w<x.length;w++){var m=x[w],v=b+m;t<=v&&v<=e&&u.push(v)}}return{major:c,minor:u}},e.prototype.get_min_interval=function(){return this.min_interval},e.prototype.get_max_interval=function(){return null!=this.max_interval?this.max_interval:1/0},e.prototype.get_ideal_interval=function(t,e,n){var i=e-t;return i/n},e.__name__="ContinuousTicker",e}(r.Ticker);n.ContinuousTicker=l,l.initClass()},function(t,e,n){var i=t(421),r=t(24),o=t(224),s=t(227),a=t(230),l=t(235),c=t(239),h=t(238),u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.override({num_minor_ticks:0,tickers:function(){return[new o.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*h.ONE_MILLI,num_minor_ticks:0}),new o.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:h.ONE_SECOND,max_interval:30*h.ONE_MINUTE,num_minor_ticks:0}),new o.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:h.ONE_HOUR,max_interval:12*h.ONE_HOUR,num_minor_ticks:0}),new a.DaysTicker({days:r.range(1,32)}),new a.DaysTicker({days:r.range(1,31,3)}),new a.DaysTicker({days:[1,8,15,22]}),new a.DaysTicker({days:[1,15]}),new l.MonthsTicker({months:r.range(0,12,1)}),new l.MonthsTicker({months:r.range(0,12,2)}),new l.MonthsTicker({months:r.range(0,12,4)}),new l.MonthsTicker({months:r.range(0,12,6)}),new c.YearsTicker({})]}})},e.__name__="DatetimeTicker",e}(s.CompositeTicker);n.DatetimeTicker=u,u.initClass()},function(t,e,n){var i=t(421),r=t(236),o=t(238),s=t(18),a=t(24),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({days:[s.Array,[]]}),this.override({num_minor_ticks:0})},e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=this.days;e.length>1?this.interval=(e[1]-e[0])*o.ONE_DAY:this.interval=31*o.ONE_DAY},e.prototype.get_ticks_no_defaults=function(t,e,n,i){var r=function(t,e){var n=o.last_month_no_later_than(new Date(t)),i=o.last_month_no_later_than(new Date(e));i.setUTCMonth(i.getUTCMonth()+1);for(var r=[],s=n;r.push(o.copy_date(s)),s.setUTCMonth(s.getUTCMonth()+1),!(s>i););return r}(t,e),s=this.days,l=this.interval,c=a.concat(r.map(function(t){return function(t,e){for(var n=t.getUTCMonth(),i=[],r=0,a=s;r<a.length;r++){var l=a[r],c=o.copy_date(t);c.setUTCDate(l);var h=new Date(c.getTime()+e/2);h.getUTCMonth()==n&&i.push(c)}return i}(t,l)})),h=c.map(function(t){return t.getTime()}),u=h.filter(function(n){return t<=n&&n<=e});return{major:u,minor:[]}},e.__name__="DaysTicker",e}(r.SingleIntervalTicker);n.DaysTicker=l,l.initClass()},function(t,e,n){var i=t(421),r=t(228),o=t(18),s=function(t){function e(e){var n=t.call(this,e)||this;return n.min_interval=0,n.max_interval=0,n}return i.__extends(e,t),e.initClass=function(){this.define({ticks:[o.Array,[]],minor_ticks:[o.Array,[]]})},e.prototype.get_ticks_no_defaults=function(t,e,n,i){return{major:this.ticks,minor:this.minor_ticks}},e.prototype.get_interval=function(t,e,n){return 0},e.__name__="FixedTicker",e}(r.ContinuousTicker);n.FixedTicker=s,s.initClass()},function(t,e,n){var i=t(224);n.AdaptiveTicker=i.AdaptiveTicker;var r=t(225);n.BasicTicker=r.BasicTicker;var o=t(226);n.CategoricalTicker=o.CategoricalTicker;var s=t(227);n.CompositeTicker=s.CompositeTicker;var a=t(228);n.ContinuousTicker=a.ContinuousTicker;var l=t(229);n.DatetimeTicker=l.DatetimeTicker;var c=t(230);n.DaysTicker=c.DaysTicker;var h=t(231);n.FixedTicker=h.FixedTicker;var u=t(233);n.LogTicker=u.LogTicker;var _=t(234);n.MercatorTicker=_.MercatorTicker;var d=t(235);n.MonthsTicker=d.MonthsTicker;var p=t(236);n.SingleIntervalTicker=p.SingleIntervalTicker;var f=t(237);n.Ticker=f.Ticker;var m=t(239);n.YearsTicker=m.YearsTicker},function(t,e,n){var i=t(421),r=t(224),o=t(24),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.override({mantissas:[1,5]})},e.prototype.get_ticks_no_defaults=function(t,e,n,i){var r,s=this.num_minor_ticks,a=[],l=this.base,c=Math.log(t)/Math.log(l),h=Math.log(e)/Math.log(l),u=h-c;if(isFinite(u))if(u<2){var _=this.get_interval(t,e,i),d=Math.floor(t/_),p=Math.ceil(e/_);if(r=o.range(d,p+1).filter(function(t){return 0!=t}).map(function(t){return t*_}).filter(function(n){return t<=n&&n<=e}),s>0&&r.length>0){for(var f=_/s,m=o.range(0,s).map(function(t){return t*f}),v=0,g=m.slice(1);v<g.length;v++){var y=g[v];a.push(r[0]-y)}for(var b=0,w=r;b<w.length;b++)for(var x=w[b],A=0,k=m;A<k.length;A++){var y=k[A];a.push(x+y)}}}else{var C=Math.ceil(.999999*c),T=Math.floor(1.000001*h),S=Math.ceil((T-C)/9);if(r=o.range(C-1,T+1,S).map(function(t){return Math.pow(l,t)}),s>0&&r.length>0){for(var M=Math.pow(l,S)/s,m=o.range(1,s+1).map(function(t){return t*M}),E=0,z=m;E<z.length;E++){var y=z[E];a.push(r[0]/y)}a.push(r[0]);for(var O=0,P=r;O<P.length;O++)for(var x=P[O],j=0,N=m;j<N.length;j++){var y=N[j];a.push(x*y)}}}else r=[];return{major:r.filter(function(n){return t<=n&&n<=e}),minor:a.filter(function(n){return t<=n&&n<=e})}},e.__name__="LogTicker",e}(r.AdaptiveTicker);n.LogTicker=s,s.initClass()},function(t,e,n){var i=t(421),r=t(225),o=t(18),s=t(36),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({dimension:[o.LatLon]})},e.prototype.get_ticks_no_defaults=function(e,n,i,r){var o,a,l,c,h,u,_,d;if(null==this.dimension)throw new Error("MercatorTicker.dimension not configured");o=s.clip_mercator(e,n,this.dimension),e=o[0],n=o[1],"lon"===this.dimension?(a=s.wgs84_mercator.inverse([e,i]),u=a[0],d=a[1],l=s.wgs84_mercator.inverse([n,i]),_=l[0],d=l[1]):(c=s.wgs84_mercator.inverse([i,e]),d=c[0],u=c[1],h=s.wgs84_mercator.inverse([i,n]),d=h[0],_=h[1]);var p=t.prototype.get_ticks_no_defaults.call(this,u,_,i,r),f=[],m=[];if("lon"===this.dimension){for(var v=0,g=p.major;v<g.length;v++){var y=g[v];if(s.in_bounds(y,"lon")){var b=s.wgs84_mercator.forward([y,d])[0];f.push(b)}}for(var w=0,x=p.minor;w<x.length;w++){var y=x[w];if(s.in_bounds(y,"lon")){var b=s.wgs84_mercator.forward([y,d])[0];m.push(b)}}}else{for(var A=0,k=p.major;A<k.length;A++){var y=k[A];if(s.in_bounds(y,"lat")){var C=s.wgs84_mercator.forward([d,y]),T=C[1];f.push(T)}}for(var S=0,M=p.minor;S<M.length;S++){var y=M[S];if(s.in_bounds(y,"lat")){var E=s.wgs84_mercator.forward([d,y]),T=E[1];m.push(T)}}}return{major:f,minor:m}},e.__name__="MercatorTicker",e}(r.BasicTicker);n.MercatorTicker=a,a.initClass()},function(t,e,n){var i=t(421),r=t(236),o=t(238),s=t(18),a=t(24),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({months:[s.Array,[]]})},e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=this.months;e.length>1?this.interval=(e[1]-e[0])*o.ONE_MONTH:this.interval=12*o.ONE_MONTH},e.prototype.get_ticks_no_defaults=function(t,e,n,i){var r=function(t,e){var n=o.last_year_no_later_than(new Date(t)),i=o.last_year_no_later_than(new Date(e));i.setUTCFullYear(i.getUTCFullYear()+1);for(var r=[],s=n;r.push(o.copy_date(s)),s.setUTCFullYear(s.getUTCFullYear()+1),!(s>i););return r}(t,e),s=this.months,l=a.concat(r.map(function(t){return s.map(function(e){var n=o.copy_date(t);return n.setUTCMonth(e),n})})),c=l.map(function(t){return t.getTime()}),h=c.filter(function(n){return t<=n&&n<=e});return{major:h,minor:[]}},e.__name__="MonthsTicker",e}(r.SingleIntervalTicker);n.MonthsTicker=l,l.initClass()},function(t,e,n){var i=t(421),r=t(228),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({interval:[o.Number]})},e.prototype.get_interval=function(t,e,n){return this.interval},Object.defineProperty(e.prototype,"min_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),e.__name__="SingleIntervalTicker",e}(r.ContinuousTicker);n.SingleIntervalTicker=s,s.initClass()},function(t,e,n){var i=t(421),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="Ticker",e}(r.Model);n.Ticker=o},function(t,e,n){function i(t){return new Date(t.getTime())}function r(t){var e=i(t);return e.setUTCDate(1),e.setUTCHours(0),e.setUTCMinutes(0),e.setUTCSeconds(0),e.setUTCMilliseconds(0),e}n.ONE_MILLI=1,n.ONE_SECOND=1e3,n.ONE_MINUTE=60*n.ONE_SECOND,n.ONE_HOUR=60*n.ONE_MINUTE,n.ONE_DAY=24*n.ONE_HOUR,n.ONE_MONTH=30*n.ONE_DAY,n.ONE_YEAR=365*n.ONE_DAY,n.copy_date=i,n.last_month_no_later_than=r,n.last_year_no_later_than=function(t){var e=r(t);return e.setUTCMonth(0),e}},function(t,e,n){var i=t(421),r=t(225),o=t(236),s=t(238),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.interval=s.ONE_YEAR,this.basic_ticker=new r.BasicTicker({num_minor_ticks:0})},e.prototype.get_ticks_no_defaults=function(t,e,n,i){var r=s.last_year_no_later_than(new Date(t)).getUTCFullYear(),o=s.last_year_no_later_than(new Date(e)).getUTCFullYear(),a=this.basic_ticker.get_ticks_no_defaults(r,o,n,i).major,l=a.map(function(t){return Date.UTC(t,0,1)}),c=l.filter(function(n){return t<=n&&n<=e});return{major:c,minor:[]}},e.__name__="YearsTicker",e}(o.SingleIntervalTicker);n.YearsTicker=a},function(t,e,n){var i=t(421),r=t(243),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({use_latlon:[o.Boolean,!1]})},e.prototype.get_image_url=function(t,e,n){var i,r,o,s,a,l,c=this.string_lookup_replace(this.url,this.extra_url_vars);return this.use_latlon?(i=this.get_tile_geographic_bounds(t,e,n),s=i[0],l=i[1],o=i[2],a=i[3]):(r=this.get_tile_meter_bounds(t,e,n),s=r[0],l=r[1],o=r[2],a=r[3]),c.replace("{XMIN}",s.toString()).replace("{YMIN}",l.toString()).replace("{XMAX}",o.toString()).replace("{YMAX}",a.toString())},e.__name__="BBoxTileSource",e}(r.MercatorTileSource);n.BBoxTileSource=s,s.initClass()},function(t,e,n){var i=t(46),r=function(){function t(){this.images=[]}return t.prototype.pop=function(){var t=this.images.pop();return null!=t?t:new Image},t.prototype.push=function(t){var e;this.images.length>50||(i.isArray(t)?(e=this.images).push.apply(e,t):this.images.push(t))},t.__name__="ImagePool",t}();n.ImagePool=r},function(t,e,n){var i=t(240);n.BBoxTileSource=i.BBoxTileSource;var r=t(243);n.MercatorTileSource=r.MercatorTileSource;var o=t(244);n.QUADKEYTileSource=o.QUADKEYTileSource;var s=t(245);n.TileRenderer=s.TileRenderer;var a=t(246);n.TileSource=a.TileSource;var l=t(248);n.TMSTileSource=l.TMSTileSource;var c=t(249);n.WMTSTileSource=c.WMTSTileSource},function(t,e,n){var i=t(421),r=t(246),o=t(18),s=t(24),a=t(247),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({snap_to_zoom:[o.Boolean,!1],wrap_around:[o.Boolean,!0]}),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this._resolutions=s.range(this.min_zoom,this.max_zoom+1).map(function(t){return e.get_resolution(t)})},e.prototype._computed_initial_resolution=function(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size},e.prototype.is_valid_tile=function(t,e,n){return!(!this.wrap_around&&(t<0||t>=Math.pow(2,n))||e<0||e>=Math.pow(2,n))},e.prototype.parent_by_tile_xyz=function(t,e,n){var i=this.tile_xyz_to_quadkey(t,e,n),r=i.substring(0,i.length-1);return this.quadkey_to_tile_xyz(r)},e.prototype.get_resolution=function(t){return this._computed_initial_resolution()/Math.pow(2,t)},e.prototype.get_resolution_by_extent=function(t,e,n){var i=(t[2]-t[0])/n,r=(t[3]-t[1])/e;return[i,r]},e.prototype.get_level_by_extent=function(t,e,n){for(var i=(t[2]-t[0])/n,r=(t[3]-t[1])/e,o=Math.max(i,r),s=0,a=0,l=this._resolutions;a<l.length;a++){var c=l[a];if(o>c){if(0==s)return 0;if(s>0)return s-1}s+=1}return s-1},e.prototype.get_closest_level_by_extent=function(t,e,n){var i=(t[2]-t[0])/n,r=(t[3]-t[1])/e,o=Math.max(i,r),s=this._resolutions.reduce(function(t,e){return Math.abs(e-o)<Math.abs(t-o)?e:t});return this._resolutions.indexOf(s)},e.prototype.snap_to_zoom_level=function(t,e,n,i){var r=t[0],o=t[1],s=t[2],a=t[3],l=this._resolutions[i],c=n*l,h=e*l;if(!this.snap_to_zoom){var u=(s-r)/c,_=(a-o)/h;u>_?(c=s-r,h*=u):(c*=_,h=a-o)}var d=(c-(s-r))/2,p=(h-(a-o))/2;return[r-d,o-p,s+d,a+p]},e.prototype.tms_to_wmts=function(t,e,n){return[t,Math.pow(2,n)-1-e,n]},e.prototype.wmts_to_tms=function(t,e,n){return[t,Math.pow(2,n)-1-e,n]},e.prototype.pixels_to_meters=function(t,e,n){var i=this.get_resolution(n),r=t*i-this.x_origin_offset,o=e*i-this.y_origin_offset;return[r,o]},e.prototype.meters_to_pixels=function(t,e,n){var i=this.get_resolution(n),r=(t+this.x_origin_offset)/i,o=(e+this.y_origin_offset)/i;return[r,o]},e.prototype.pixels_to_tile=function(t,e){var n=Math.ceil(t/this.tile_size);n=0===n?n:n-1;var i=Math.max(Math.ceil(e/this.tile_size)-1,0);return[n,i]},e.prototype.pixels_to_raster=function(t,e,n){var i=this.tile_size<<n;return[t,i-e]},e.prototype.meters_to_tile=function(t,e,n){var i=this.meters_to_pixels(t,e,n),r=i[0],o=i[1];return this.pixels_to_tile(r,o)},e.prototype.get_tile_meter_bounds=function(t,e,n){var i=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,n),r=i[0],o=i[1],s=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,n),a=s[0],l=s[1];return[r,o,a,l]},e.prototype.get_tile_geographic_bounds=function(t,e,n){var i=this.get_tile_meter_bounds(t,e,n),r=a.meters_extent_to_geographic(i),o=r[0],s=r[1],l=r[2],c=r[3];return[o,s,l,c]},e.prototype.get_tiles_by_extent=function(t,e,n){void 0===n&&(n=1);var i=t[0],r=t[1],o=t[2],s=t[3],a=this.meters_to_tile(i,r,e),l=a[0],c=a[1],h=this.meters_to_tile(o,s,e),u=h[0],_=h[1];l-=n,c-=n,u+=n;for(var d=[],p=_+=n;p>=c;p--)for(var f=l;f<=u;f++)this.is_valid_tile(f,p,e)&&d.push([f,p,e,this.get_tile_meter_bounds(f,p,e)]);return this.sort_tiles_from_center(d,[l,c,u,_]),d},e.prototype.quadkey_to_tile_xyz=function(t){for(var e=0,n=0,i=t.length,r=i;r>0;r--){var o=t.charAt(i-r),s=1<<r-1;switch(o){case"0":continue;case"1":e|=s;break;case"2":n|=s;break;case"3":e|=s,n|=s;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,n,i]},e.prototype.tile_xyz_to_quadkey=function(t,e,n){for(var i="",r=n;r>0;r--){var o=1<<r-1,s=0;0!=(t&o)&&(s+=1),0!=(e&o)&&(s+=2),i+=s.toString()}return i},e.prototype.children_by_tile_xyz=function(t,e,n){for(var i=this.tile_xyz_to_quadkey(t,e,n),r=[],o=0;o<=3;o++){var s=this.quadkey_to_tile_xyz(i+o.toString()),a=s[0],l=s[1],c=s[2],h=this.get_tile_meter_bounds(a,l,c);r.push([a,l,c,h])}return r},e.prototype.get_closest_parent_by_tile_xyz=function(t,e,n){var i,r,o,s=this.calculate_world_x_by_tile_xyz(t,e,n);i=this.normalize_xyz(t,e,n),t=i[0],e=i[1],n=i[2];for(var a=this.tile_xyz_to_quadkey(t,e,n);a.length>0;)if(a=a.substring(0,a.length-1),r=this.quadkey_to_tile_xyz(a),t=r[0],e=r[1],n=r[2],o=this.denormalize_xyz(t,e,n,s),t=o[0],e=o[1],n=o[2],this.tile_xyz_to_key(t,e,n)in this.tiles)return[t,e,n];return[0,0,0]},e.prototype.normalize_xyz=function(t,e,n){if(this.wrap_around){var i=Math.pow(2,n);return[(t%i+i)%i,e,n]}return[t,e,n]},e.prototype.denormalize_xyz=function(t,e,n,i){return[t+i*Math.pow(2,n),e,n]},e.prototype.denormalize_meters=function(t,e,n,i){return[t+2*i*Math.PI*6378137,e]},e.prototype.calculate_world_x_by_tile_xyz=function(t,e,n){return Math.floor(t/Math.pow(2,n))},e.__name__="MercatorTileSource",e}(r.TileSource);n.MercatorTileSource=l,l.initClass()},function(t,e,n){var i=t(421),r=t(243),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.get_image_url=function(t,e,n){var i=this.string_lookup_replace(this.url,this.extra_url_vars),r=this.tms_to_wmts(t,e,n),o=r[0],s=r[1],a=r[2],l=this.tile_xyz_to_quadkey(o,s,a);return i.replace("{Q}",l)},e.__name__="QUADKEYTileSource",e}(r.MercatorTileSource);n.QUADKEYTileSource=o},function(t,e,n){var i=t(421),r=t(241),o=t(249),s=t(196),a=t(195),l=t(5),c=t(18),h=t(24),u=t(46),_=t(20),d=t(212),p=t(313),f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){this._tiles=[],t.prototype.initialize.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.request_render()}),this.connect(this.model.tile_source.change,function(){return e.request_render()})},e.prototype.get_extent=function(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]},Object.defineProperty(e.prototype,"map_plot",{get:function(){return this.plot_model},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"map_canvas",{get:function(){return this.plot_view.canvas_view.ctx},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"map_frame",{get:function(){return this.plot_view.frame},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"x_range",{get:function(){return this.map_plot.x_range},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"y_range",{get:function(){return this.map_plot.y_range},enumerable:!0,configurable:!0}),e.prototype._set_data=function(){this.pool=new r.ImagePool,this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0},e.prototype._update_attribution=function(){null!=this.attribution_el&&l.removeElement(this.attribution_el);var t=this.model.tile_source.attribution;if(u.isString(t)&&t.length>0){var e=this.plot_view,n=e.layout,i=e.frame,r=n._width.value-i._right.value,o=n._height.value-i._bottom.value,s=i._width.value;this.attribution_el=l.div({class:p.bk_tile_attribution,style:{position:"absolute",right:r+"px",bottom:o+"px","max-width":s-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"7pt","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}});var a=this.plot_view.canvas_view.events_el;a.appendChild(this.attribution_el),this.attribution_el.innerHTML=t,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}},e.prototype._map_data=function(){this.initial_extent=this.get_extent();var t=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value),e=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value,t);this.x_range.start=e[0],this.y_range.start=e[1],this.x_range.end=e[2],this.y_range.end=e[3],this.x_range instanceof a.Range1d&&(this.x_range.reset_start=e[0],this.x_range.reset_end=e[2]),this.y_range instanceof a.Range1d&&(this.y_range.reset_start=e[1],this.y_range.reset_end=e[3]),this._update_attribution()},e.prototype._on_tile_load=function(t,e){t.img=e.target,t.loaded=!0,this.request_render()},e.prototype._on_tile_cache_load=function(t,e){t.img=e.target,t.loaded=!0,t.finished=!0,this.notify_finished()},e.prototype._on_tile_error=function(t){t.finished=!0},e.prototype._create_tile=function(t,e,n,i,r){void 0===r&&(r=!1);var o=this.model.tile_source.normalize_xyz(t,e,n),s=o[0],a=o[1],l=o[2],c=this.pool.pop(),h={img:c,tile_coords:[t,e,n],normalized_coords:[s,a,l],quadkey:this.model.tile_source.tile_xyz_to_quadkey(t,e,n),cache_key:this.model.tile_source.tile_xyz_to_key(t,e,n),bounds:i,loaded:!1,finished:!1,x_coord:i[0],y_coord:i[3]};c.onload=r?this._on_tile_cache_load.bind(this,h):this._on_tile_load.bind(this,h),c.onerror=this._on_tile_error.bind(this,h),c.alt="",c.src=this.model.tile_source.get_image_url(s,a,l),this.model.tile_source.tiles[h.cache_key]=h,this._tiles.push(h)},e.prototype._enforce_aspect_ratio=function(){if(this._last_height!==this.map_frame._height.value||this._last_width!==this.map_frame._width.value){var t=this.get_extent(),e=this.model.tile_source.get_level_by_extent(t,this.map_frame._height.value,this.map_frame._width.value),n=this.model.tile_source.snap_to_zoom_level(t,this.map_frame._height.value,this.map_frame._width.value,e);this.x_range.setv({start:n[0],end:n[2]}),this.y_range.setv({start:n[1],end:n[3]}),this.extent=n,this._last_height=this.map_frame._height.value,this._last_width=this.map_frame._width.value}},e.prototype.has_finished=function(){if(!t.prototype.has_finished.call(this))return!1;if(0===this._tiles.length)return!1;for(var e=0,n=this._tiles;e<n.length;e++){var i=n[e];if(!i.finished)return!1}return!0},e.prototype.render=function(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()},e.prototype._draw_tile=function(t){var e=this.model.tile_source.tiles[t];if(null!=e){var n=this.plot_view.map_to_screen([e.bounds[0]],[e.bounds[3]]),i=n[0][0],r=n[1][0],o=this.plot_view.map_to_screen([e.bounds[2]],[e.bounds[1]]),s=o[0][0],a=o[1][0],l=s-i,c=a-r,h=i,u=r,_=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(e.img,h,u,l,c),this.map_canvas.setImageSmoothingEnabled(_),e.finished=!0}},e.prototype._set_rect=function(){var t=this.plot_model.properties.outline_line_width.value(),e=this.map_frame._left.value+t/2,n=this.map_frame._top.value+t/2,i=this.map_frame._width.value-t,r=this.map_frame._height.value-t;this.map_canvas.rect(e,n,i,r),this.map_canvas.clip()},e.prototype._render_tiles=function(t){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(var e=0,n=t;e<n.length;e++){var i=n[e];this._draw_tile(i)}this.map_canvas.restore()},e.prototype._prefetch_tiles=function(){for(var t=this.model.tile_source,e=this.get_extent(),n=this.map_frame._height.value,i=this.map_frame._width.value,r=this.model.tile_source.get_level_by_extent(e,n,i),o=this.model.tile_source.get_tiles_by_extent(e,r),s=0,a=Math.min(10,o.length);s<a;s++)for(var l=o[s],c=l[0],h=l[1],u=l[2],_=this.model.tile_source.children_by_tile_xyz(c,h,u),d=0,p=_;d<p.length;d++){var f=p[d],m=f[0],v=f[1],g=f[2],y=f[3];t.tile_xyz_to_key(m,v,g)in t.tiles||this._create_tile(m,v,g,y,!0)}},e.prototype._fetch_tiles=function(t){for(var e=0,n=t;e<n.length;e++){var i=n[e],r=i[0],o=i[1],s=i[2],a=i[3];this._create_tile(r,o,s,a)}},e.prototype._update=function(){var t=this,e=this.model.tile_source,n=e.min_zoom,i=e.max_zoom,r=this.get_extent(),o=this.extent[2]-this.extent[0]<r[2]-r[0],s=this.map_frame._height.value,a=this.map_frame._width.value,l=e.get_level_by_extent(r,s,a),c=!1;l<n?(r=this.extent,l=n,c=!0):l>i&&(r=this.extent,l=i,c=!0),c&&(this.x_range.setv({x_range:{start:r[0],end:r[2]}}),this.y_range.setv({start:r[1],end:r[3]}),this.extent=r),this.extent=r;for(var u=e.get_tiles_by_extent(r,l),_=[],d=[],p=[],f=[],m=0,v=u;m<v.length;m++){var g=v[m],y=g[0],b=g[1],w=g[2],x=e.tile_xyz_to_key(y,b,w),A=e.tiles[x];if(null!=A&&A.loaded)d.push(x);else if(this.model.render_parents){var k=e.get_closest_parent_by_tile_xyz(y,b,w),C=k[0],T=k[1],S=k[2],M=e.tile_xyz_to_key(C,T,S),E=e.tiles[M];if(null!=E&&E.loaded&&!h.includes(p,M)&&p.push(M),o)for(var z=e.children_by_tile_xyz(y,b,w),O=0,P=z;O<P.length;O++){var j=P[O],N=j[0],I=j[1],B=j[2],R=e.tile_xyz_to_key(N,I,B);R in e.tiles&&f.push(R)}}null==A&&_.push(g)}this._render_tiles(p),this._render_tiles(f),this._render_tiles(d),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout(function(){return t._fetch_tiles(_)},65)},e.__name__="TileRendererView",e}(s.DataRendererView);n.TileRendererView=f;var m=function(t){function e(e){var n=t.call(this,e)||this;return n._selection_manager=new _.SelectionManager({source:new d.ColumnDataSource}),n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=f,this.define({alpha:[c.Number,1],smoothing:[c.Boolean,!0],tile_source:[c.Instance,function(){return new o.WMTSTileSource}],render_parents:[c.Boolean,!0]})},e.prototype.get_selection_manager=function(){return this._selection_manager},e.__name__="TileRenderer",e}(s.DataRenderer);n.TileRenderer=m,m.initClass()},function(t,e,n){var i=t(421),r=t(62),o=t(241),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({url:[s.String,""],tile_size:[s.Number,256],max_zoom:[s.Number,30],min_zoom:[s.Number,0],extra_url_vars:[s.Any,{}],attribution:[s.String,""],x_origin_offset:[s.Number],y_origin_offset:[s.Number],initial_resolution:[s.Number]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.tiles={},this.pool=new o.ImagePool,this._normalize_case()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,function(){return e._clear_cache()})},e.prototype.string_lookup_replace=function(t,e){var n=t;for(var i in e){var r=e[i];n=n.replace("{"+i+"}",r)}return n},e.prototype._normalize_case=function(){var t=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=t},e.prototype._clear_cache=function(){this.tiles={}},e.prototype.tile_xyz_to_key=function(t,e,n){return t+":"+e+":"+n},e.prototype.key_to_tile_xyz=function(t){var e=t.split(":").map(function(t){return parseInt(t)}),n=e[0],i=e[1],r=e[2];return[n,i,r]},e.prototype.sort_tiles_from_center=function(t,e){var n=e[0],i=e[1],r=e[2],o=e[3],s=(r-n)/2+n,a=(o-i)/2+i;t.sort(function(t,e){var n=Math.sqrt(Math.pow(s-t[0],2)+Math.pow(a-t[1],2)),i=Math.sqrt(Math.pow(s-e[0],2)+Math.pow(a-e[1],2));return n-i})},e.prototype.get_image_url=function(t,e,n){var i=this.string_lookup_replace(this.url,this.extra_url_vars);return i.replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",n.toString())},e.__name__="TileSource",e}(r.Model);n.TileSource=a,a.initClass()},function(t,e,n){var i=t(36);function r(t,e){return i.wgs84_mercator.forward([t,e])}function o(t,e){return i.wgs84_mercator.inverse([t,e])}n.geographic_to_meters=r,n.meters_to_geographic=o,n.geographic_extent_to_meters=function(t){var e=t[0],n=t[1],i=t[2],o=t[3],s=r(e,n),a=s[0],l=s[1],c=r(i,o),h=c[0],u=c[1];return[a,l,h,u]},n.meters_extent_to_geographic=function(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=o(e,n),a=s[0],l=s[1],c=o(i,r),h=c[0],u=c[1];return[a,l,h,u]}},function(t,e,n){var i=t(421),r=t(243),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.get_image_url=function(t,e,n){var i=this.string_lookup_replace(this.url,this.extra_url_vars);return i.replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",n.toString())},e.__name__="TMSTileSource",e}(r.MercatorTileSource);n.TMSTileSource=o},function(t,e,n){var i=t(421),r=t(243),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.get_image_url=function(t,e,n){var i=this.string_lookup_replace(this.url,this.extra_url_vars),r=this.tms_to_wmts(t,e,n),o=r[0],s=r[1],a=r[2];return i.replace("{X}",o.toString()).replace("{Y}",s.toString()).replace("{Z}",a.toString())},e.__name__="WMTSTileSource",e}(r.MercatorTileSource);n.WMTSTileSource=o},function(t,e,n){var i=t(421),r=t(259),o=t(22),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._clicked=function(){this.model.do.emit()},e.__name__="ActionToolButtonView",e}(r.ButtonToolButtonView);n.ActionToolButtonView=s;var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.do,function(){return e.doit()})},e.__name__="ActionToolView",e}(r.ButtonToolView);n.ActionToolView=a;var l=function(t){function e(e){var n=t.call(this,e)||this;return n.button_view=s,n.do=new o.Signal0(n,"do"),n}return i.__extends(e,t),e.__name__="ActionTool",e}(r.ButtonTool);n.ActionTool=l},function(t,e,n){var i=t(421),r=t(250),o=t(18),s=t(314),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(s.bk_toolbar_button_custom_action)},e.__name__="CustomActionButtonView",e}(r.ActionToolButtonView);n.CustomActionButtonView=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.doit=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},e.__name__="CustomActionView",e}(r.ActionToolView);n.CustomActionView=l;var c=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Custom Action",n.button_view=a,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({action_tooltip:[o.String,"Perform a Custom Action"],callback:[o.Any],icon:[o.String]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.action_tooltip},enumerable:!0,configurable:!0}),e.__name__="CustomAction",e}(r.ActionTool);n.CustomAction=c,c.initClass()},function(t,e,n){var i=t(421),r=t(250),o=t(18),s=t(306),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.doit=function(){window.open(this.model.redirect)},e.__name__="HelpToolView",e}(r.ActionToolView);n.HelpToolView=a;var l=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Help",n.icon=s.bk_tool_icon_help,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({help_tooltip:[o.String,"Click the question mark to learn more about Bokeh plot tools."],redirect:[o.String,"https://bokeh.pydata.org/en/latest/docs/user_guide/tools.html#built-in-tools"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.help_tooltip},enumerable:!0,configurable:!0}),e.__name__="HelpTool",e}(r.ActionTool);n.HelpTool=l,l.initClass()},function(t,e,n){var i=t(421),r=t(250),o=t(306),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,function(){return e.model.disabled=!e.plot_view.can_redo()})},e.prototype.doit=function(){this.plot_view.redo()},e.__name__="RedoToolView",e}(r.ActionToolView);n.RedoToolView=s;var a=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Redo",n.icon=o.bk_tool_icon_redo,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s,this.override({disabled:!0})},e.__name__="RedoTool",e}(r.ActionTool);n.RedoTool=a,a.initClass()},function(t,e,n){var i=t(421),r=t(250),o=t(306),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.doit=function(){this.plot_view.reset()},e.__name__="ResetToolView",e}(r.ActionToolView);n.ResetToolView=s;var a=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Reset",n.icon=o.bk_tool_icon_reset,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s},e.__name__="ResetTool",e}(r.ActionTool);n.ResetTool=a,a.initClass()},function(t,e,n){var i=t(421),r=t(250),o=t(306),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.doit=function(){this.plot_view.save("bokeh_plot")},e.__name__="SaveToolView",e}(r.ActionToolView);n.SaveToolView=s;var a=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Save",n.icon=o.bk_tool_icon_save,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s},e.__name__="SaveTool",e}(r.ActionTool);n.SaveTool=a,a.initClass()},function(t,e,n){var i=t(421),r=t(250),o=t(306),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,function(){return e.model.disabled=!e.plot_view.can_undo()})},e.prototype.doit=function(){this.plot_view.undo()},e.__name__="UndoToolView",e}(r.ActionToolView);n.UndoToolView=s;var a=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Undo",n.icon=o.bk_tool_icon_undo,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s,this.override({disabled:!0})},e.__name__="UndoTool",e}(r.ActionTool);n.UndoTool=a,a.initClass()},function(t,e,n){var i=t(421),r=t(250),o=t(48),s=t(18),a=t(306),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.doit=function(){var t=this.plot_view.frame,e=this.model.dimensions,n="width"==e||"both"==e,i="height"==e||"both"==e,r=o.scale_range(t,this.model.factor,n,i);this.plot_view.push_state("zoom_out",{range:r}),this.plot_view.update_range(r,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)},e.__name__="ZoomInToolView",e}(r.ActionToolView);n.ZoomInToolView=l;var c=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Zoom In",n.icon=a.bk_tool_icon_zoom_in,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({factor:[s.Percent,.1],dimensions:[s.Dimensions,"both"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e.__name__="ZoomInTool",e}(r.ActionTool);n.ZoomInTool=c,c.initClass()},function(t,e,n){var i=t(421),r=t(250),o=t(48),s=t(18),a=t(306),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.doit=function(){var t=this.plot_view.frame,e=this.model.dimensions,n="width"==e||"both"==e,i="height"==e||"both"==e,r=o.scale_range(t,-this.model.factor,n,i);this.plot_view.push_state("zoom_out",{range:r}),this.plot_view.update_range(r,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)},e.__name__="ZoomOutToolView",e}(r.ActionToolView);n.ZoomOutToolView=l;var c=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Zoom Out",n.icon=a.bk_tool_icon_zoom_out,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({factor:[s.Percent,.1],dimensions:[s.Dimensions,"both"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e.__name__="ZoomOutTool",e}(r.ActionTool);n.ZoomOutTool=c,c.initClass()},function(t,e,n){var i=t(421),r=t(6),o=t(284),s=t(5),a=t(18),l=t(40),c=t(46),h=t(314),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.change,function(){return e.render()}),this.el.addEventListener("click",function(){return e._clicked()}),this.render()},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(h.bk_toolbar_button)},e.prototype.render=function(){s.empty(this.el);var t=this.model.computed_icon;c.isString(t)&&(l.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip},e.__name__="ButtonToolButtonView",e}(r.DOMView);n.ButtonToolButtonView=u;var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="ButtonToolView",e}(o.ToolView);n.ButtonToolView=_;var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.internal({disabled:[a.Boolean,!1]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),e.__name__="ButtonTool",e}(o.Tool);n.ButtonTool=d,d.initClass()},function(t,e,n){var i=t(421),r=t(5),o=t(18),s=t(261),a=t(306),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._tap=function(t){if(null==this._draw_basepoint&&null==this._basepoint){var e=t.shiftKey;this._select_event(t,e,this.model.renderers)}},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];if(t.keyCode===r.Keys.Backspace)this._delete_selected(i);else if(t.keyCode==r.Keys.Esc){var o=i.data_source;o.selection_manager.clear()}}},e.prototype._set_extent=function(t,e,n,i){var r=t[0],o=t[1],s=e[0],a=e[1];void 0===i&&(i=!1);var l=this.model.renderers[0],c=this.plot_view.frame,h=l.glyph,u=l.data_source,_=c.xscales[l.x_range_name],d=c.yscales[l.y_range_name],p=_.r_invert(r,o),f=p[0],m=p[1],v=d.r_invert(s,a),g=v[0],y=v[1],b=[(f+m)/2,(g+y)/2],w=b[0],x=b[1],A=[m-f,y-g],k=A[0],C=A[1],T=[h.x.field,h.y.field],S=T[0],M=T[1],E=[h.width.field,h.height.field],z=E[0],O=E[1];if(n)this._pop_glyphs(u,this.model.num_objects),S&&u.get_array(S).push(w),M&&u.get_array(M).push(x),z&&u.get_array(z).push(k),O&&u.get_array(O).push(C),this._pad_empty_columns(u,[S,M,z,O]);else{var P=u.data[S].length-1;S&&(u.data[S][P]=w),M&&(u.data[M][P]=x),z&&(u.data[z][P]=k),O&&(u.data[O][P]=C)}this._emit_cds_changes(u,!0,!1,i)},e.prototype._update_box=function(t,e,n){if(void 0===e&&(e=!1),void 0===n&&(n=!1),null!=this._draw_basepoint){var i=[t.sx,t.sy],r=this.plot_view.frame,o=this.model.dimensions,s=this.model._get_dim_limits(this._draw_basepoint,i,r,o);if(null!=s){var a=s[0],l=s[1];this._set_extent(a,l,e,n)}}},e.prototype._doubletap=function(t){this.model.active&&(null!=this._draw_basepoint?(this._update_box(t,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[t.sx,t.sy],this._select_event(t,!0,this.model.renderers),this._update_box(t,!0,!1)))},e.prototype._move=function(t){this._update_box(t,!1,!1)},e.prototype._pan_start=function(t){if(t.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[t.sx,t.sy],this._update_box(t,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy]}},e.prototype._pan=function(t,e,n){if(void 0===e&&(e=!1),void 0===n&&(n=!1),t.shiftKey){if(null==this._draw_basepoint)return;this._update_box(t,e,n)}else{if(null==this._basepoint)return;this._drag_points(t,this.model.renderers)}},e.prototype._pan_end=function(t){if(this._pan(t,!1,!0),t.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];this._emit_cds_changes(i.data_source,!1,!0,!0)}}},e.__name__="BoxEditToolView",e}(s.EditToolView);n.BoxEditToolView=l;var c=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Box Edit Tool",n.icon=a.bk_tool_icon_box_edit,n.event_type=["tap","pan","move"],n.default_order=1,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({dimensions:[o.Dimensions,"both"],num_objects:[o.Int,0]})},e.__name__="BoxEditTool",e}(s.EditTool);n.BoxEditTool=c,c.initClass()},function(t,e,n){var i=t(421),r=t(18),o=t(24),s=t(46),a=t(269),l=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._mouse_in_frame=!0,e}return i.__extends(e,t),e.prototype._move_enter=function(t){this._mouse_in_frame=!0},e.prototype._move_exit=function(t){this._mouse_in_frame=!1},e.prototype._map_drag=function(t,e,n){var i=this.plot_view.frame;if(!i.bbox.contains(t,e))return null;var r=i.xscales[n.x_range_name].invert(t),o=i.yscales[n.y_range_name].invert(e);return[r,o]},e.prototype._delete_selected=function(t){var e=t.data_source,n=e.selected.indices;n.sort();for(var i=0,r=e.columns();i<r.length;i++)for(var o=r[i],s=e.get_array(o),a=0;a<n.length;a++){var l=n[a];s.splice(l-a,1)}this._emit_cds_changes(e)},e.prototype._pop_glyphs=function(t,e){var n=t.columns();if(e&&n.length)for(var i=0,r=n;i<r.length;i++){var o=r[i],a=t.get_array(o),l=a.length-e+1;l<1||(s.isArray(a)||(a=Array.from(a),t.data[o]=a),a.splice(0,l))}},e.prototype._emit_cds_changes=function(t,e,n,i){void 0===e&&(e=!0),void 0===n&&(n=!0),void 0===i&&(i=!0),n&&t.selection_manager.clear(),e&&t.change.emit(),i&&(t.data=t.data,t.properties.data.change.emit())},e.prototype._drag_points=function(t,e){if(null!=this._basepoint){for(var n=this._basepoint,i=n[0],r=n[1],o=0,s=e;o<s.length;o++){var a=s[o],l=this._map_drag(i,r,a),c=this._map_drag(t.sx,t.sy,a);if(null!=c&&null!=l){for(var h=c[0],u=c[1],_=l[0],d=l[1],p=[h-_,u-d],f=p[0],m=p[1],v=a.glyph,g=a.data_source,y=[v.x.field,v.y.field],b=y[0],w=y[1],x=0,A=g.selected.indices;x<A.length;x++){var k=A[x];b&&(g.data[b][k]+=f),w&&(g.data[w][k]+=m)}g.change.emit()}}this._basepoint=[t.sx,t.sy]}},e.prototype._pad_empty_columns=function(t,e){for(var n=0,i=t.columns();n<i.length;n++){var r=i[n];o.includes(e,r)||t.get_array(r).push(this.model.empty_value)}},e.prototype._select_event=function(t,e,n){var i=this.plot_view.frame,r=t.sx,o=t.sy;if(!i.bbox.contains(r,o))return[];for(var s={type:"point",sx:r,sy:o},a=[],l=0,c=n;l<c.length;l++){var h=c[l],u=h.get_selection_manager(),_=h.data_source,d=[this.plot_view.renderer_views[h.id]],p=u.select(d,s,!0,e);p&&a.push(h),_.properties.selected.change.emit()}return a},e.__name__="EditToolView",e}(a.GestureToolView);n.EditToolView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({custom_icon:[r.String],custom_tooltip:[r.String],empty_value:[r.Any],renderers:[r.Array,[]]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.custom_tooltip||this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.custom_icon||this.icon},enumerable:!0,configurable:!0}),e.__name__="EditTool",e}(a.GestureTool);n.EditTool=c,c.initClass()},function(t,e,n){var i=t(421),r=t(5),o=t(18),s=t(46),a=t(261),l=t(306),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._draw=function(t,e,n){if(void 0===n&&(n=!1),this.model.active){var i=this.model.renderers[0],r=this._map_drag(t.sx,t.sy,i);if(null!=r){var o=r[0],a=r[1],l=i.data_source,c=i.glyph,h=[c.xs.field,c.ys.field],u=h[0],_=h[1];if("new"==e)this._pop_glyphs(l,this.model.num_objects),u&&l.get_array(u).push([o]),_&&l.get_array(_).push([a]),this._pad_empty_columns(l,[u,_]);else if("add"==e){if(u){var d=l.data[u].length-1,p=l.get_array(u)[d];s.isArray(p)||(p=Array.from(p),l.data[u][d]=p),p.push(o)}if(_){var f=l.data[_].length-1,m=l.get_array(_)[f];s.isArray(m)||(m=Array.from(m),l.data[_][f]=m),m.push(a)}}this._emit_cds_changes(l,!0,!0,n)}}},e.prototype._pan_start=function(t){this._draw(t,"new")},e.prototype._pan=function(t){this._draw(t,"add")},e.prototype._pan_end=function(t){this._draw(t,"add",!0)},e.prototype._tap=function(t){this._select_event(t,t.shiftKey,this.model.renderers)},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];t.keyCode===r.Keys.Esc?i.data_source.selection_manager.clear():t.keyCode===r.Keys.Backspace&&this._delete_selected(i)}},e.__name__="FreehandDrawToolView",e}(a.EditToolView);n.FreehandDrawToolView=c;var h=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Freehand Draw Tool",n.icon=l.bk_tool_icon_freehand_draw,n.event_type=["pan","tap"],n.default_order=3,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({num_objects:[o.Int,0]})},e.__name__="FreehandDrawTool",e}(a.EditTool);n.FreehandDrawTool=h,h.initClass()},function(t,e,n){var i=t(421),r=t(5),o=t(18),s=t(261),a=t(306),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._tap=function(t){var e=t.shiftKey,n=this._select_event(t,e,this.model.renderers);if(!n.length&&this.model.add){var i=this.model.renderers[0],r=this._map_drag(t.sx,t.sy,i);if(null!=r){var o=i.glyph,s=i.data_source,a=[o.x.field,o.y.field],l=a[0],c=a[1],h=r[0],u=r[1];this._pop_glyphs(s,this.model.num_objects),l&&s.get_array(l).push(h),c&&s.get_array(c).push(u),this._pad_empty_columns(s,[l,c]),s.change.emit(),s.data=s.data,s.properties.data.change.emit()}}},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];t.keyCode===r.Keys.Backspace?this._delete_selected(i):t.keyCode==r.Keys.Esc&&i.data_source.selection_manager.clear()}},e.prototype._pan_start=function(t){this.model.drag&&(this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy])},e.prototype._pan=function(t){this.model.drag&&null!=this._basepoint&&this._drag_points(t,this.model.renderers)},e.prototype._pan_end=function(t){if(this.model.drag){this._pan(t);for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];this._emit_cds_changes(i.data_source,!1,!0,!0)}this._basepoint=null}},e.__name__="PointDrawToolView",e}(s.EditToolView);n.PointDrawToolView=l;var c=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Point Draw Tool",n.icon=a.bk_tool_icon_point_draw,n.event_type=["tap","pan","move"],n.default_order=2,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({add:[o.Boolean,!0],drag:[o.Boolean,!0],num_objects:[o.Int,0]})},e.__name__="PointDrawTool",e}(s.EditTool);n.PointDrawTool=c,c.initClass()},function(t,e,n){var i=t(421),r=t(5),o=t(18),s=t(46),a=t(266),l=t(306),c=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._drawing=!1,e._initialized=!1,e}return i.__extends(e,t),e.prototype._tap=function(t){this._drawing?this._draw(t,"add",!0):this._select_event(t,t.shiftKey,this.model.renderers)},e.prototype._draw=function(t,e,n){void 0===n&&(n=!1);var i=this.model.renderers[0],r=this._map_drag(t.sx,t.sy,i);if(this._initialized||this.activate(),null!=r){var o=this._snap_to_vertex.apply(this,[t].concat(r)),a=o[0],l=o[1],c=i.data_source,h=i.glyph,u=[h.xs.field,h.ys.field],_=u[0],d=u[1];if("new"==e)this._pop_glyphs(c,this.model.num_objects),_&&c.get_array(_).push([a,a]),d&&c.get_array(d).push([l,l]),this._pad_empty_columns(c,[_,d]);else if("edit"==e){if(_){var p=c.data[_][c.data[_].length-1];p[p.length-1]=a}if(d){var f=c.data[d][c.data[d].length-1];f[f.length-1]=l}}else if("add"==e){if(_){var m=c.data[_].length-1,p=c.get_array(_)[m],v=p[p.length-1];p[p.length-1]=a,s.isArray(p)||(p=Array.from(p),c.data[_][m]=p),p.push(v)}if(d){var g=c.data[d].length-1,f=c.get_array(d)[g],y=f[f.length-1];f[f.length-1]=l,s.isArray(f)||(f=Array.from(f),c.data[d][g]=f),f.push(y)}}this._emit_cds_changes(c,!0,!1,n)}},e.prototype._show_vertices=function(){if(this.model.active){for(var t=[],e=[],n=0;n<this.model.renderers.length;n++){var i=this.model.renderers[n],r=i.data_source,o=i.glyph,s=[o.xs.field,o.ys.field],a=s[0],l=s[1];if(a)for(var c=0,h=r.get_array(a);c<h.length;c++){var u=h[c];Array.prototype.push.apply(t,u)}if(l)for(var _=0,d=r.get_array(l);_<d.length;_++){var u=d[_];Array.prototype.push.apply(e,u)}this._drawing&&n==this.model.renderers.length-1&&(t.splice(t.length-1,1),e.splice(e.length-1,1))}this._set_vertices(t,e)}},e.prototype._doubletap=function(t){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(t,"edit",!0)):(this._drawing=!0,this._draw(t,"new",!0)))},e.prototype._move=function(t){this._drawing&&this._draw(t,"edit")},e.prototype._remove=function(){var t=this.model.renderers[0],e=t.data_source,n=t.glyph,i=[n.xs.field,n.ys.field],r=i[0],o=i[1];if(r){var s=e.data[r].length-1,a=e.get_array(r)[s];a.splice(a.length-1,1)}if(o){var l=e.data[o].length-1,c=e.get_array(o)[l];c.splice(c.length-1,1)}this._emit_cds_changes(e)},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];t.keyCode===r.Keys.Backspace?this._delete_selected(i):t.keyCode==r.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),i.data_source.selection_manager.clear())}},e.prototype._pan_start=function(t){this.model.drag&&(this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy])},e.prototype._pan=function(t){if(null!=this._basepoint&&this.model.drag){for(var e=this._basepoint,n=e[0],i=e[1],r=0,o=this.model.renderers;r<o.length;r++){var s=o[r],a=this._map_drag(n,i,s),l=this._map_drag(t.sx,t.sy,s);if(null!=l&&null!=a){var c=s.data_source,h=s.glyph,u=[h.xs.field,h.ys.field],_=u[0],d=u[1];if(_||d){for(var p=l[0],f=l[1],m=a[0],v=a[1],g=[p-m,f-v],y=g[0],b=g[1],w=0,x=c.selected.indices;w<x.length;w++){var A=x[w],k=void 0,C=void 0,T=void 0;_&&(C=c.data[_][A]),d?(T=c.data[d][A],k=T.length):k=C.length;for(var S=0;S<k;S++)C&&(C[S]+=y),T&&(T[S]+=b)}c.change.emit()}}}this._basepoint=[t.sx,t.sy]}},e.prototype._pan_end=function(t){if(this.model.drag){this._pan(t);for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e];this._emit_cds_changes(i.data_source)}this._basepoint=null}},e.prototype.activate=function(){var t=this;if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(var e=0,n=this.model.renderers;e<n.length;e++){var i=n[e],r=i.data_source;r.connect(r.properties.data.change,function(){return t._show_vertices()})}this._initialized=!0}},e.prototype.deactivate=function(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()},e.__name__="PolyDrawToolView",e}(a.PolyToolView);n.PolyDrawToolView=c;var h=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Polygon Draw Tool",n.icon=l.bk_tool_icon_poly_draw,n.event_type=["pan","tap","move"],n.default_order=3,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({drag:[o.Boolean,!0],num_objects:[o.Int,0]})},e.__name__="PolyDrawTool",e}(a.PolyTool);n.PolyDrawTool=h,h.initClass()},function(t,e,n){var i=t(421),r=t(5),o=t(46),s=t(266),a=t(306),l=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._drawing=!1,e}return i.__extends(e,t),e.prototype._doubletap=function(t){if(this.model.active){var e=this._map_drag(t.sx,t.sy,this.model.vertex_renderer);if(null!=e){var n=e[0],i=e[1],r=this._select_event(t,!1,[this.model.vertex_renderer]),o=this.model.vertex_renderer.data_source,s=this.model.vertex_renderer.glyph,a=[s.x.field,s.y.field],l=a[0],c=a[1];if(r.length&&null!=this._selected_renderer){var h=o.selected.indices[0];this._drawing?(this._drawing=!1,o.selection_manager.clear()):(o.selected.indices=[h+1],l&&o.get_array(l).splice(h+1,0,n),c&&o.get_array(c).splice(h+1,0,i),this._drawing=!0),o.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(t)}}},e.prototype._show_vertices=function(t){if(this.model.active){var e=this._select_event(t,!1,this.model.renderers);if(!e.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);var n,i,r=e[0],s=r.glyph,a=r.data_source,l=a.selected.indices[0],c=[s.xs.field,s.ys.field],h=c[0],u=c[1];h?(n=a.data[h][l],o.isArray(n)||(a.data[h][l]=n=Array.from(n))):n=s.xs.value,u?(i=a.data[u][l],o.isArray(i)||(a.data[u][l]=i=Array.from(i))):i=s.ys.value,this._selected_renderer=r,this._set_vertices(n,i)}},e.prototype._move=function(t){var e;if(this._drawing&&null!=this._selected_renderer){var n=this.model.vertex_renderer,i=n.data_source,r=n.glyph,o=this._map_drag(t.sx,t.sy,n);if(null==o)return;var s=o[0],a=o[1],l=i.selected.indices;e=this._snap_to_vertex(t,s,a),s=e[0],a=e[1],i.selected.indices=l;var c=[r.x.field,r.y.field],h=c[0],u=c[1],_=l[0];h&&(i.data[h][_]=s),u&&(i.data[u][_]=a),i.change.emit(),this._selected_renderer.data_source.change.emit()}},e.prototype._tap=function(t){var e,n=this.model.vertex_renderer,i=this._map_drag(t.sx,t.sy,n);if(null!=i){if(this._drawing&&this._selected_renderer){var r=i[0],o=i[1],s=n.data_source,a=n.glyph,l=[a.x.field,a.y.field],c=l[0],h=l[1],u=s.selected.indices;e=this._snap_to_vertex(t,r,o),r=e[0],o=e[1];var _=u[0];if(s.selected.indices=[_+1],c){var d=s.get_array(c),p=d[_];d[_]=r,d.splice(_+1,0,p)}if(h){var f=s.get_array(h),m=f[_];f[_]=o,f.splice(_+1,0,m)}return s.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}var v=t.shiftKey;this._select_event(t,v,[n]),this._select_event(t,v,this.model.renderers)}},e.prototype._remove_vertex=function(){if(this._drawing&&this._selected_renderer){var t=this.model.vertex_renderer,e=t.data_source,n=t.glyph,i=e.selected.indices[0],r=[n.x.field,n.y.field],o=r[0],s=r[1];o&&e.get_array(o).splice(i,1),s&&e.get_array(s).splice(i,1),e.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}},e.prototype._pan_start=function(t){this._select_event(t,!0,[this.model.vertex_renderer]),this._basepoint=[t.sx,t.sy]},e.prototype._pan=function(t){null!=this._basepoint&&(this._drag_points(t,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},e.prototype._pan_end=function(t){null!=this._basepoint&&(this._drag_points(t,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame){var e;e=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(var n=0,i=e;n<i.length;n++){var o=i[n];t.keyCode===r.Keys.Backspace?(this._delete_selected(o),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):t.keyCode==r.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),o.data_source.selection_manager.clear())}}},e.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())},e.__name__="PolyEditToolView",e}(s.PolyToolView);n.PolyEditToolView=l;var c=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Poly Edit Tool",n.icon=a.bk_tool_icon_poly_edit,n.event_type=["tap","pan","move"],n.default_order=4,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l},e.__name__="PolyEditTool",e}(s.PolyTool);n.PolyEditTool=c,c.initClass()},function(t,e,n){var i=t(421),r=t(18),o=t(46),s=t(261),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._set_vertices=function(t,e){var n=this.model.vertex_renderer.glyph,i=this.model.vertex_renderer.data_source,r=[n.x.field,n.y.field],s=r[0],a=r[1];s&&(o.isArray(t)?i.data[s]=t:n.x={value:t}),a&&(o.isArray(e)?i.data[a]=e:n.y={value:e}),this._emit_cds_changes(i,!0,!0,!1)},e.prototype._hide_vertices=function(){this._set_vertices([],[])},e.prototype._snap_to_vertex=function(t,e,n){if(this.model.vertex_renderer){var i=this._select_event(t,!1,[this.model.vertex_renderer]),r=this.model.vertex_renderer.data_source,o=this.model.vertex_renderer.glyph,s=[o.x.field,o.y.field],a=s[0],l=s[1];if(i.length){var c=r.selected.indices[0];a&&(e=r.data[a][c]),l&&(n=r.data[l][c]),r.selection_manager.clear()}}return[e,n]},e.__name__="PolyToolView",e}(s.EditToolView);n.PolyToolView=a;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({vertex_renderer:[r.Instance]})},e.__name__="PolyTool",e}(s.EditTool);n.PolyTool=l,l.initClass()},function(t,e,n){var i=t(421),r=t(274),o=t(67),s=t(18),a=t(306),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._compute_limits=function(t){var e=this.plot_view.frame,n=this.model.dimensions,i=this._base_point;if("center"==this.model.origin){var r=i[0],o=i[1],s=t[0],a=t[1];i=[r-(s-r),o-(a-o)]}return this.model._get_dim_limits(i,t,e,n)},e.prototype._pan_start=function(t){var e=t.sx,n=t.sy;this._base_point=[e,n]},e.prototype._pan=function(t){var e=t.sx,n=t.sy,i=[e,n],r=this._compute_limits(i),o=r[0],s=r[1];if(this.model.overlay.update({left:o[0],right:o[1],top:s[0],bottom:s[1]}),this.model.select_every_mousemove){var a=t.shiftKey;this._do_select(o,s,!1,a)}},e.prototype._pan_end=function(t){var e=t.sx,n=t.sy,i=[e,n],r=this._compute_limits(i),o=r[0],s=r[1],a=t.shiftKey;this._do_select(o,s,!0,a),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})},e.prototype._do_select=function(t,e,n,i){var r=t[0],o=t[1],s=e[0],a=e[1];void 0===i&&(i=!1);var l={type:"rect",sx0:r,sx1:o,sy0:s,sy1:a};this._select(l,n,i)},e.prototype._emit_callback=function(t){var e=this.computed_renderers[0],n=this.plot_view.frame,r=n.xscales[e.x_range_name],o=n.yscales[e.y_range_name],s=t.sx0,a=t.sx1,l=t.sy0,c=t.sy1,h=r.r_invert(s,a),u=h[0],_=h[1],d=o.r_invert(l,c),p=d[0],f=d[1],m=i.__assign({x0:u,y0:p,x1:_,y1:f},t);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:m})},e.__name__="BoxSelectToolView",e}(r.SelectToolView);n.BoxSelectToolView=l;var c=function(){return new o.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},h=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Box Select",n.icon=a.bk_tool_icon_box_select,n.event_type="pan",n.default_order=30,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({dimensions:[s.Dimensions,"both"],select_every_mousemove:[s.Boolean,!1],callback:[s.Any],overlay:[s.Instance,c],origin:[s.BoxOrigin,"corner"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e.__name__="BoxSelectTool",e}(r.SelectTool);n.BoxSelectTool=h,h.initClass()},function(t,e,n){var i=t(421),r=t(269),o=t(67),s=t(18),a=t(306),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._match_aspect=function(t,e,n){var i,r,o,s,a=n.bbox.aspect,l=n.bbox.h_range.end,c=n.bbox.h_range.start,h=n.bbox.v_range.end,u=n.bbox.v_range.start,_=Math.abs(t[0]-e[0]),d=Math.abs(t[1]-e[1]),p=0==d?0:_/d,f=(p>=a?[1,p/a]:[a/p,1])[0];return t[0]<=e[0]?(i=t[0],(r=t[0]+_*f)>l&&(r=l)):(r=t[0],(i=t[0]-_*f)<c&&(i=c)),_=Math.abs(r-i),t[1]<=e[1]?(s=t[1],(o=t[1]+_/a)>h&&(o=h)):(o=t[1],(s=t[1]-_/a)<u&&(s=u)),d=Math.abs(o-s),t[0]<=e[0]?r=t[0]+a*d:i=t[0]-a*d,[[i,r],[s,o]]},e.prototype._compute_limits=function(t){var e,n,i,r,o=this.plot_view.frame,s=this.model.dimensions,a=this._base_point;if("center"==this.model.origin){var l=a[0],c=a[1],h=t[0],u=t[1];a=[l-(h-l),c-(u-c)]}return this.model.match_aspect&&"both"==s?(e=this._match_aspect(a,t,o),i=e[0],r=e[1]):(n=this.model._get_dim_limits(a,t,o,s),i=n[0],r=n[1]),[i,r]},e.prototype._pan_start=function(t){this._base_point=[t.sx,t.sy]},e.prototype._pan=function(t){var e=[t.sx,t.sy],n=this._compute_limits(e),i=n[0],r=n[1];this.model.overlay.update({left:i[0],right:i[1],top:r[0],bottom:r[1]})},e.prototype._pan_end=function(t){var e=[t.sx,t.sy],n=this._compute_limits(e),i=n[0],r=n[1];this._update(i,r),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null},e.prototype._update=function(t,e){var n=t[0],i=t[1],r=e[0],o=e[1];if(!(Math.abs(i-n)<=5||Math.abs(o-r)<=5)){var s=this.plot_view.frame,a=s.xscales,l=s.yscales,c={};for(var h in a){var u=a[h],_=u.r_invert(n,i),d=_[0],p=_[1];c[h]={start:d,end:p}}var f={};for(var m in l){var u=l[m],v=u.r_invert(r,o),d=v[0],p=v[1];f[m]={start:d,end:p}}var g={xrs:c,yrs:f};this.plot_view.push_state("box_zoom",{range:g}),this.plot_view.update_range(g)}},e.__name__="BoxZoomToolView",e}(r.GestureToolView);n.BoxZoomToolView=l;var c=function(){return new o.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},h=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Box Zoom",n.icon=a.bk_tool_icon_box_zoom,n.event_type="pan",n.default_order=20,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({dimensions:[s.Dimensions,"both"],overlay:[s.Instance,c],match_aspect:[s.Boolean,!1],origin:[s.BoxOrigin,"corner"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e.__name__="BoxZoomTool",e}(r.GestureTool);n.BoxZoomTool=h,h.initClass()},function(t,e,n){var i=t(421),r=t(259),o=t(283),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="GestureToolView",e}(r.ButtonToolView);n.GestureToolView=s;var a=function(t){function e(e){var n=t.call(this,e)||this;return n.button_view=o.OnOffButtonView,n}return i.__extends(e,t),e.__name__="GestureTool",e}(r.ButtonTool);n.GestureTool=a},function(t,e,n){var i=t(421),r=t(274),o=t(74),s=t(5),a=t(18),l=t(306),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data=null},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){return e._active_change()})},e.prototype._active_change=function(){this.model.active||this._clear_overlay()},e.prototype._keyup=function(t){t.keyCode==s.Keys.Enter&&this._clear_overlay()},e.prototype._pan_start=function(t){var e=t.sx,n=t.sy;this.data={sx:[e],sy:[n]}},e.prototype._pan=function(t){var e=t.sx,n=t.sy,i=this.plot_view.frame.bbox.clip(e,n),r=i[0],o=i[1];this.data.sx.push(r),this.data.sy.push(o);var s=this.model.overlay;if(s.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove){var a=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!1,a)}},e.prototype._pan_end=function(t){this._clear_overlay();var e=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,e),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})},e.prototype._clear_overlay=function(){this.model.overlay.update({xs:[],ys:[]})},e.prototype._do_select=function(t,e,n,i){var r={type:"poly",sx:t,sy:e};this._select(r,n,i)},e.prototype._emit_callback=function(t){var e=this.computed_renderers[0],n=this.plot_view.frame,r=n.xscales[e.x_range_name],o=n.yscales[e.y_range_name],s=r.v_invert(t.sx),a=o.v_invert(t.sy),l=i.__assign({x:s,y:a},t);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:l})},e.__name__="LassoSelectToolView",e}(r.SelectToolView);n.LassoSelectToolView=c;var h=function(){return new o.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},u=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Lasso Select",n.icon=l.bk_tool_icon_lasso_select,n.event_type="pan",n.default_order=12,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({select_every_mousemove:[a.Boolean,!0],callback:[a.Any],overlay:[a.Instance,h]})},e.__name__="LassoSelectTool",e}(r.SelectTool);n.LassoSelectTool=u,u.initClass()},function(t,e,n){var i=t(421),r=t(269),o=t(18),s=t(306),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=t.sx,n=t.sy,i=this.plot_view.frame.bbox;if(!i.contains(e,n)){var r=i.h_range,o=i.v_range;(e<r.start||e>r.end)&&(this.v_axis_only=!0),(n<o.start||n>o.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},e.prototype._pan=function(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},e.prototype._pan_end=function(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})},e.prototype._update=function(t,e){var n,i,r,o,s,a,l=this.plot_view.frame,c=t-this.last_dx,h=e-this.last_dy,u=l.bbox.h_range,_=u.start-c,d=u.end-c,p=l.bbox.v_range,f=p.start-h,m=p.end-h,v=this.model.dimensions;"width"!=v&&"both"!=v||this.v_axis_only?(n=u.start,i=u.end,r=0):(n=_,i=d,r=-c),"height"!=v&&"both"!=v||this.h_axis_only?(o=p.start,s=p.end,a=0):(o=f,s=m,a=-h),this.last_dx=t,this.last_dy=e;var g=l.xscales,y=l.yscales,b={};for(var w in g){var x=g[w],A=x.r_invert(n,i),k=A[0],C=A[1];b[w]={start:k,end:C}}var T={};for(var S in y){var x=y[S],M=x.r_invert(o,s),k=M[0],C=M[1];T[S]={start:k,end:C}}this.pan_info={xrs:b,yrs:T,sdx:r,sdy:a},this.plot_view.update_range(this.pan_info,!0)},e.__name__="PanToolView",e}(r.GestureToolView);n.PanToolView=a;var l=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Pan",n.event_type="pan",n.default_order=10,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({dimensions:[o.Dimensions,"both"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Pan",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"icon",{get:function(){switch(this.dimensions){case"both":return s.bk_tool_icon_pan;case"width":return s.bk_tool_icon_xpan;case"height":return s.bk_tool_icon_ypan}},enumerable:!0,configurable:!0}),e.__name__="PanTool",e}(r.GestureTool);n.PanTool=l,l.initClass()},function(t,e,n){var i=t(421),r=t(274),o=t(74),s=t(5),a=t(18),l=t(24),c=t(306),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data={sx:[],sy:[]}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){return e._active_change()})},e.prototype._active_change=function(){this.model.active||this._clear_data()},e.prototype._keyup=function(t){t.keyCode==s.Keys.Enter&&this._clear_data()},e.prototype._doubletap=function(t){var e=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,e),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()},e.prototype._clear_data=function(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})},e.prototype._tap=function(t){var e=t.sx,n=t.sy,i=this.plot_view.frame;i.bbox.contains(e,n)&&(this.data.sx.push(e),this.data.sy.push(n),this.model.overlay.update({xs:l.copy(this.data.sx),ys:l.copy(this.data.sy)}))},e.prototype._do_select=function(t,e,n,i){var r={type:"poly",sx:t,sy:e};this._select(r,n,i)},e.prototype._emit_callback=function(t){var e=this.computed_renderers[0],n=this.plot_view.frame,r=n.xscales[e.x_range_name],o=n.yscales[e.y_range_name],s=r.v_invert(t.sx),a=o.v_invert(t.sy),l=i.__assign({x:s,y:a},t);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:l})},e.__name__="PolySelectToolView",e}(r.SelectToolView);n.PolySelectToolView=h;var u=function(){return new o.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},_=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Poly Select",n.icon=c.bk_tool_icon_polygon_select,n.event_type="tap",n.default_order=11,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=h,this.define({callback:[a.Any],overlay:[a.Instance,u]})},e.__name__="PolySelectTool",e}(r.SelectTool);n.PolySelectTool=_,_.initClass()},function(t,e,n){var i=t(421),r=t(67),o=t(17),s=t(18),a=t(269),l=t(306);function c(t){switch(t){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return t}}function h(t,e,n,i){if(null==e)return!1;var r=n.compute(e);return Math.abs(t-r)<i}function u(t,e,n,i,r){var o=!0;if(null!=r.left&&null!=r.right){var s=n.invert(t);(s<r.left||s>r.right)&&(o=!1)}if(null!=r.bottom&&null!=r.top){var a=i.invert(e);(a<r.bottom||a>r.top)&&(o=!1)}return o}function _(t,e,n){var i=0;return t>=n.start&&t<=n.end&&(i+=1),e>=n.start&&e<=n.end&&(i+=1),i}function d(t,e,n,i){var r=e.compute(t),o=e.invert(r+n);return o>=i.start&&o<=i.end?o:t}function p(t,e,n){return t>e.start?(e.end=t,n):(e.end=e.start,e.start=t,c(n))}function f(t,e,n){return t<e.end?(e.start=t,n):(e.start=e.end,e.end=t,c(n))}function m(t,e,n,i){var r=e.r_compute(t.start,t.end),o=r[0],s=r[1],a=e.r_invert(o+n,s+n),l=a[0],c=a[1],h=_(t.start,t.end,i),u=_(l,c,i);u>=h&&(t.start=l,t.end=c)}n.flip_side=c,n.is_near=h,n.is_inside=u,n.sides_inside=_,n.compute_value=d,n.compute_end_side=p,n.compute_start_side=f,n.update_range=m;var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.side=0,this.model.update_overlay_from_ranges()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),null!=this.model.x_range&&this.connect(this.model.x_range.change,function(){return e.model.update_overlay_from_ranges()}),null!=this.model.y_range&&this.connect(this.model.y_range.change,function(){return e.model.update_overlay_from_ranges()})},e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=this.model.x_range,n=this.model.y_range,i=this.plot_view.frame,o=i.xscales.default,s=i.yscales.default,a=this.model.overlay,l=a.left,c=a.right,_=a.top,d=a.bottom,p=this.model.overlay.properties.line_width.value()+r.EDGE_TOLERANCE;null!=e&&this.model.x_interaction&&(h(t.sx,l,o,p)?this.side=1:h(t.sx,c,o,p)?this.side=2:u(t.sx,t.sy,o,s,a)&&(this.side=3)),null!=n&&this.model.y_interaction&&(0==this.side&&h(t.sy,d,s,p)&&(this.side=4),0==this.side&&h(t.sy,_,s,p)?this.side=5:u(t.sx,t.sy,o,s,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))},e.prototype._pan=function(t){var e=this.plot_view.frame,n=t.deltaX-this.last_dx,i=t.deltaY-this.last_dy,r=this.model.x_range,o=this.model.y_range,s=e.xscales.default,a=e.yscales.default;if(null!=r)if(3==this.side||7==this.side)m(r,s,n,e.x_range);else if(1==this.side){var l=d(r.start,s,n,e.x_range);this.side=f(l,r,this.side)}else if(2==this.side){var c=d(r.end,s,n,e.x_range);this.side=p(c,r,this.side)}if(null!=o)if(6==this.side||7==this.side)m(o,a,i,e.y_range);else if(4==this.side){o.start=d(o.start,a,i,e.y_range);var l=d(o.start,a,i,e.y_range);this.side=f(l,o,this.side)}else if(5==this.side){o.end=d(o.end,a,i,e.y_range);var c=d(o.end,a,i,e.y_range);this.side=p(c,o,this.side)}this.last_dx=t.deltaX,this.last_dy=t.deltaY},e.prototype._pan_end=function(t){this.side=0},e.__name__="RangeToolView",e}(a.GestureToolView);n.RangeToolView=v;var g=function(){return new r.BoxAnnotation({level:"overlay",render_mode:"canvas",fill_color:"lightgrey",fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:.5},line_dash:[2,2]})},y=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Range Tool",n.icon=l.bk_tool_icon_range,n.event_type="pan",n.default_order=1,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=v,this.define({x_range:[s.Instance,null],x_interaction:[s.Boolean,!0],y_range:[s.Instance,null],y_interaction:[s.Boolean,!0],overlay:[s.Instance,g]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null},e.prototype.update_overlay_from_ranges=function(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,o.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)},e.__name__="RangeTool",e}(a.GestureTool);n.RangeTool=y,y.initClass()},function(t,e,n){var i=t(421),r=t(269),o=t(197),s=t(198),a=t(289),l=t(18),c=t(5),h=t(3),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"computed_renderers",{get:function(){var t=this.model.renderers,e=this.plot_model.renderers,n=this.model.names;return a.compute_renderers(t,e,n)},enumerable:!0,configurable:!0}),e.prototype._computed_renderers_by_data_source=function(){for(var t={},e=0,n=this.computed_renderers;e<n.length;e++){var i=n[e],r=void 0;if(i instanceof o.GlyphRenderer)r=i.data_source.id;else{if(!(i instanceof s.GraphRenderer))continue;r=i.node_renderer.data_source.id}r in t||(t[r]=[]),t[r].push(i)}return t},e.prototype._keyup=function(t){if(t.keyCode==c.Keys.Esc){for(var e=0,n=this.computed_renderers;e<n.length;e++){var i=n[e];i.get_selection_manager().clear()}this.plot_view.request_render()}},e.prototype._select=function(t,e,n){var i=this._computed_renderers_by_data_source();for(var r in i){for(var o=i[r],s=o[0].get_selection_manager(),a=[],l=0,c=o;l<c.length;l++){var h=c[l];h.id in this.plot_view.renderer_views&&a.push(this.plot_view.renderer_views[h.id])}s.select(a,t,e,n)}null!=this.model.callback&&this._emit_callback(t),this._emit_selection_event(t,e)},e.prototype._emit_selection_event=function(t,e){void 0===e&&(e=!0);var n,r=this.plot_view.frame,o=r.xscales.default,s=r.yscales.default;switch(t.type){case"point":var a=t.sx,l=t.sy,c=o.invert(a),u=s.invert(l);n=i.__assign({},t,{x:c,y:u});break;case"rect":var _=t.sx0,d=t.sx1,p=t.sy0,f=t.sy1,m=o.r_invert(_,d),v=m[0],g=m[1],y=s.r_invert(p,f),b=y[0],w=y[1];n=i.__assign({},t,{x0:v,y0:b,x1:g,y1:w});break;case"poly":var a=t.sx,l=t.sy,c=o.v_invert(a),u=s.v_invert(l);n=i.__assign({},t,{x:c,y:u});break;default:throw new Error("Unrecognized selection geometry type: '"+t.type+"'")}this.plot_model.trigger_event(new h.SelectionGeometry(n,e))},e.__name__="SelectToolView",e}(r.GestureToolView);n.SelectToolView=u;var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({renderers:[l.Any,"auto"],names:[l.Array,[]]})},e.__name__="SelectTool",e}(r.GestureTool);n.SelectTool=_,_.initClass()},function(t,e,n){var i=t(421),r=t(274),o=t(18),s=t(306),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._tap=function(t){var e=t.sx,n=t.sy,i={type:"point",sx:e,sy:n},r=t.shiftKey;this._select(i,!0,r)},e.prototype._select=function(t,e,n){var r=this,o=this.model.callback;if("select"==this.model.behavior){var s=this._computed_renderers_by_data_source();for(var a in s){var l=s[a],c=l[0].get_selection_manager(),h=l.map(function(t){return r.plot_view.renderer_views[t.id]}),u=c.select(h,t,e,n);if(u&&null!=o){var _=this.plot_view.frame,d=_.xscales[l[0].x_range_name],p=_.yscales[l[0].y_range_name],f=d.invert(t.sx),m=p.invert(t.sy),v={geometries:i.__assign({},t,{x:f,y:m}),source:c.source};o.execute(this.model,v)}}this._emit_selection_event(t),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else for(var g=0,y=this.computed_renderers;g<y.length;g++){var b=y[g],c=b.get_selection_manager(),u=c.inspect(this.plot_view.renderer_views[b.id],t);if(u&&null!=o){var _=this.plot_view.frame,d=_.xscales[b.x_range_name],p=_.yscales[b.y_range_name],f=d.invert(t.sx),m=p.invert(t.sy),v={geometries:i.__assign({},t,{x:f,y:m}),source:c.source};o.execute(this.model,v)}}},e.__name__="TapToolView",e}(r.SelectToolView);n.TapToolView=a;var l=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Tap",n.icon=s.bk_tool_icon_tap_select,n.event_type="tap",n.default_order=10,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({behavior:[o.TapBehavior,"select"],callback:[o.Any]})},e.__name__="TapTool",e}(r.SelectTool);n.TapTool=l,l.initClass()},function(t,e,n){var i=t(421),r=t(269),o=t(18),s=t(306),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._scroll=function(t){var e=this.model.speed*t.delta;e>.9?e=.9:e<-.9&&(e=-.9),this._update_ranges(e)},e.prototype._update_ranges=function(t){var e,n,i,r,o=this.plot_view.frame,s=o.bbox.h_range,a=o.bbox.v_range,l=[s.start,s.end],c=l[0],h=l[1],u=[a.start,a.end],_=u[0],d=u[1];switch(this.model.dimension){case"height":var p=Math.abs(d-_);e=c,n=h,i=_-p*t,r=d-p*t;break;case"width":var f=Math.abs(h-c);e=c-f*t,n=h-f*t,i=_,r=d;break;default:throw new Error("this shouldn't have happened")}var m=o.xscales,v=o.yscales,g={};for(var y in m){var b=m[y],w=b.r_invert(e,n),x=w[0],A=w[1];g[y]={start:x,end:A}}var k={};for(var C in v){var b=v[C],T=b.r_invert(i,r),x=T[0],A=T[1];k[C]={start:x,end:A}}var S={xrs:g,yrs:k,factor:t};this.plot_view.push_state("wheel_pan",{range:S}),this.plot_view.update_range(S,!1,!0),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},e.__name__="WheelPanToolView",e}(r.GestureToolView);n.WheelPanToolView=a;var l=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Wheel Pan",n.icon=s.bk_tool_icon_wheel_pan,n.event_type="scroll",n.default_order=12,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({dimension:[o.Dimension,"width"]}),this.internal({speed:[o.Number,.001]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimension)},enumerable:!0,configurable:!0}),e.__name__="WheelPanTool",e}(r.GestureTool);n.WheelPanTool=l,l.initClass()},function(t,e,n){var i=t(421),r=t(269),o=t(48),s=t(18),a=t(31),l=t(306),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._pinch=function(t){var e,n=t.sx,i=t.sy,r=t.scale;e=r>=1?20*(r-1):-20/r,this._scroll({type:"wheel",sx:n,sy:i,delta:e})},e.prototype._scroll=function(t){var e=this.plot_view.frame,n=e.bbox.h_range,i=e.bbox.v_range,r=t.sx,s=t.sy,a=this.model.dimensions,l=("width"==a||"both"==a)&&n.start<r&&r<n.end,c=("height"==a||"both"==a)&&i.start<s&&s<i.end;if(l&&c||this.model.zoom_on_axis){var h=this.model.speed*t.delta,u=o.scale_range(e,h,l,c,{x:r,y:s});this.plot_view.push_state("wheel_zoom",{range:u}),this.plot_view.update_range(u,!1,!0,this.model.maintain_focus),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}},e.__name__="WheelZoomToolView",e}(r.GestureToolView);n.WheelZoomToolView=c;var h=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Wheel Zoom",n.icon=l.bk_tool_icon_wheel_zoom,n.event_type=a.is_mobile?"pinch":"scroll",n.default_order=10,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({dimensions:[s.Dimensions,"both"],maintain_focus:[s.Boolean,!0],zoom_on_axis:[s.Boolean,!0],speed:[s.Number,1/600]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e.__name__="WheelZoomTool",e}(r.GestureTool);n.WheelZoomTool=h,h.initClass()},function(t,e,n){var i=t(250);n.ActionTool=i.ActionTool;var r=t(251);n.CustomAction=r.CustomAction;var o=t(252);n.HelpTool=o.HelpTool;var s=t(253);n.RedoTool=s.RedoTool;var a=t(254);n.ResetTool=a.ResetTool;var l=t(255);n.SaveTool=l.SaveTool;var c=t(256);n.UndoTool=c.UndoTool;var h=t(257);n.ZoomInTool=h.ZoomInTool;var u=t(258);n.ZoomOutTool=u.ZoomOutTool;var _=t(259);n.ButtonTool=_.ButtonTool;var d=t(261);n.EditTool=d.EditTool;var p=t(260);n.BoxEditTool=p.BoxEditTool;var f=t(262);n.FreehandDrawTool=f.FreehandDrawTool;var m=t(263);n.PointDrawTool=m.PointDrawTool;var v=t(264);n.PolyDrawTool=v.PolyDrawTool;var g=t(266);n.PolyTool=g.PolyTool;var y=t(265);n.PolyEditTool=y.PolyEditTool;var b=t(267);n.BoxSelectTool=b.BoxSelectTool;var w=t(268);n.BoxZoomTool=w.BoxZoomTool;var x=t(269);n.GestureTool=x.GestureTool;var A=t(270);n.LassoSelectTool=A.LassoSelectTool;var k=t(271);n.PanTool=k.PanTool;var C=t(272);n.PolySelectTool=C.PolySelectTool;var T=t(273);n.RangeTool=T.RangeTool;var S=t(274);n.SelectTool=S.SelectTool;var M=t(275);n.TapTool=M.TapTool;var E=t(276);n.WheelPanTool=E.WheelPanTool;var z=t(277);n.WheelZoomTool=z.WheelZoomTool;var O=t(279);n.CrosshairTool=O.CrosshairTool;var P=t(280);n.CustomJSHover=P.CustomJSHover;var j=t(281);n.HoverTool=j.HoverTool;var N=t(282);n.InspectTool=N.InspectTool;var I=t(284);n.Tool=I.Tool;var B=t(285);n.ToolProxy=B.ToolProxy;var R=t(286);n.Toolbar=R.Toolbar;var D=t(287);n.ToolbarBase=D.ToolbarBase;var F=t(288);n.ProxyToolbar=F.ProxyToolbar;var V=t(288);n.ToolbarBox=V.ToolbarBox},function(t,e,n){var i=t(421),r=t(282),o=t(76),s=t(18),a=t(35),l=t(306),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._move=function(t){if(this.model.active){var e=t.sx,n=t.sy;this.plot_view.frame.bbox.contains(e,n)?this._update_spans(e,n):this._update_spans(null,null)}},e.prototype._move_exit=function(t){this._update_spans(null,null)},e.prototype._update_spans=function(t,e){var n=this.model.dimensions;"width"!=n&&"both"!=n||(this.model.spans.width.computed_location=e),"height"!=n&&"both"!=n||(this.model.spans.height.computed_location=t)},e.__name__="CrosshairToolView",e}(r.InspectToolView);n.CrosshairToolView=c;var h=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Crosshair",n.icon=l.bk_tool_icon_crosshair,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({dimensions:[s.Dimensions,"both"],line_color:[s.Color,"black"],line_width:[s.Number,1],line_alpha:[s.Number,1]}),this.internal({location_units:[s.SpatialUnits,"screen"],render_mode:[s.RenderMode,"css"],spans:[s.Any]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Crosshair",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return a.values(this.spans)},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.spans={width:new o.Span({for_hover:!0,dimension:"width",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha}),height:new o.Span({for_hover:!0,dimension:"height",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha})}},e.__name__="CrosshairTool",e}(r.InspectTool);n.CrosshairTool=h,h.initClass()},function(t,e,n){var i=t(421),r=t(62),o=t(18),s=t(35),a=t(40),l=function(e){function r(t){return e.call(this,t)||this}return i.__extends(r,e),r.initClass=function(){this.define({args:[o.Any,{}],code:[o.String,""]})},Object.defineProperty(r.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),r.prototype._make_code=function(t,e,n,i){return new(Function.bind.apply(Function,[void 0].concat(s.keys(this.args),[t,e,n,"require","exports",a.use_strict(i)])))},r.prototype.format=function(e,i,r){var o=this._make_code("value","format","special_vars",this.code);return o.apply(void 0,this.values.concat([e,i,r,t,n]))},r.__name__="CustomJSHover",r}(r.Model);n.CustomJSHover=l,l.initClass()},function(t,e,n){var i=t(421),r=t(282),o=t(80),s=t(197),a=t(198),l=t(289),c=t(9),h=t(42),u=t(5),_=t(18),d=t(30),p=t(35),f=t(46),m=t(4),v=t(306),g=t(315);function y(t,e,n,i,r,o){var s,a,l={x:r[t],y:o[t]},h={x:r[t+1],y:o[t+1]};if("span"==e.type)"h"==e.direction?(s=Math.abs(l.x-n),a=Math.abs(h.x-n)):(s=Math.abs(l.y-i),a=Math.abs(h.y-i));else{var u={x:n,y:i};s=c.dist_2_pts(l,u),a=c.dist_2_pts(h,u)}return s<a?[[l.x,l.y],t]:[[h.x,h.y],t+1]}function b(t,e,n){return[[t[n],e[n]],n]}n._nearest_line_hit=y,n._line_hit=b;var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.ttviews={}},e.prototype.remove=function(){m.remove_views(this.ttviews),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);for(var n=0,i=this.computed_renderers;n<i.length;n++){var r=i[n];r instanceof s.GlyphRenderer?this.connect(r.data_source.inspect,this._update):r instanceof a.GraphRenderer&&(this.connect(r.node_renderer.data_source.inspect,this._update),this.connect(r.edge_renderer.data_source.inspect,this._update))}this.connect(this.model.properties.renderers.change,function(){return e._computed_renderers=e._ttmodels=null}),this.connect(this.model.properties.names.change,function(){return e._computed_renderers=e._ttmodels=null}),this.connect(this.model.properties.tooltips.change,function(){return e._ttmodels=null})},e.prototype._compute_ttmodels=function(){var t={},e=this.model.tooltips;if(null!=e)for(var n=0,i=this.computed_renderers;n<i.length;n++){var r=i[n];if(r instanceof s.GlyphRenderer){var l=new o.Tooltip({custom:f.isString(e)||f.isFunction(e),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t[r.id]=l}else if(r instanceof a.GraphRenderer){var l=new o.Tooltip({custom:f.isString(e)||f.isFunction(e),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t[r.node_renderer.id]=l,t[r.edge_renderer.id]=l}}return m.build_views(this.ttviews,p.values(t),{parent:this.plot_view}),t},Object.defineProperty(e.prototype,"computed_renderers",{get:function(){if(null==this._computed_renderers){var t=this.model.renderers,e=this.plot_model.renderers,n=this.model.names;this._computed_renderers=l.compute_renderers(t,e,n)}return this._computed_renderers},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"ttmodels",{get:function(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels},enumerable:!0,configurable:!0}),e.prototype._clear=function(){for(var t in this._inspect(1/0,1/0),this.ttmodels){var e=this.ttmodels[t];e.clear()}},e.prototype._move=function(t){if(this.model.active){var e=t.sx,n=t.sy;this.plot_view.frame.bbox.contains(e,n)?this._inspect(e,n):this._clear()}},e.prototype._move_exit=function(){this._clear()},e.prototype._inspect=function(t,e){var n;if("mouse"==this.model.mode)n={type:"point",sx:t,sy:e};else{var i="vline"==this.model.mode?"h":"v";n={type:"span",direction:i,sx:t,sy:e}}for(var r=0,o=this.computed_renderers;r<o.length;r++){var s=o[r],a=s.get_selection_manager();a.inspect(this.plot_view.renderer_views[s.id],n)}null!=this.model.callback&&this._emit_callback(n)},e.prototype._update=function(t){var e,n,i,r,o,l,c,h,u,_,d,f,m,v,g,w,x=t[0],A=t[1].geometry;if(this.model.active&&(x instanceof s.GlyphRendererView||x instanceof a.GraphRendererView)){var k=x.model,C=this.ttmodels[k.id];if(null!=C){C.clear();var T=k.get_selection_manager(),S=T.inspectors[k.id];if(k instanceof s.GlyphRenderer&&(S=k.view.convert_selection_to_subset(S)),!S.is_empty()){for(var M=T.source,E=this.plot_view.frame,z=A.sx,O=A.sy,P=E.xscales[k.x_range_name],j=E.yscales[k.y_range_name],N=P.invert(z),I=j.invert(O),B=x.glyph,R=0,D=S.line_indices;R<D.length;R++){var F=D[R],V=B._x[F+1],L=B._y[F+1],U=F,G=void 0,H=void 0;switch(this.model.line_policy){case"interp":e=B.get_interpolation_hit(F,A),V=e[0],L=e[1],G=P.compute(V),H=j.compute(L);break;case"prev":n=b(B.sx,B.sy,F),i=n[0],G=i[0],H=i[1],U=n[1];break;case"next":r=b(B.sx,B.sy,F+1),o=r[0],G=o[0],H=o[1],U=r[1];break;case"nearest":l=y(F,A,z,O,B.sx,B.sy),c=l[0],G=c[0],H=c[1],U=l[1],V=B._x[U],L=B._y[U];break;default:G=(h=[z,O])[0],H=h[1]}var Y={index:U,x:N,y:I,sx:z,sy:O,data_x:V,data_y:L,rx:G,ry:H,indices:S.line_indices,name:x.model.name};C.add(G,H,this._render_tooltips(M,U,Y))}for(var W=0,J=S.image_indices;W<J.length;W++){var X=J[W],Y={index:X.index,x:N,y:I,sx:z,sy:O},q=this._render_tooltips(M,X,Y);C.add(z,O,q)}for(var Z=0,K=S.indices;Z<K.length;Z++){var F=K[Z];if(p.isEmpty(S.multiline_indices)){var V=null!=B._x?B._x[F]:void 0,L=null!=B._y?B._y[F]:void 0,G=void 0,H=void 0;if("snap_to_data"==this.model.point_policy){var Q=B.get_anchor_point(this.model.anchor,F,[z,O]);null==Q&&(Q=B.get_anchor_point("center",F,[z,O])),G=Q.x,H=Q.y}else G=(w=[z,O])[0],H=w[1];var $=void 0,Y={index:$=k instanceof s.GlyphRenderer?k.view.convert_indices_from_subset([F])[0]:F,x:N,y:I,sx:z,sy:O,data_x:V,data_y:L,indices:S.indices,name:x.model.name};C.add(G,H,this._render_tooltips(M,$,Y))}else for(var tt=0,et=S.multiline_indices[F.toString()];tt<et.length;tt++){var nt=et[tt],V=B._xs[F][nt],L=B._ys[F][nt],it=nt,G=void 0,H=void 0;switch(this.model.line_policy){case"interp":u=B.get_interpolation_hit(F,nt,A),V=u[0],L=u[1],G=P.compute(V),H=j.compute(L);break;case"prev":_=b(B.sxs[F],B.sys[F],nt),d=_[0],G=d[0],H=d[1],it=_[1];break;case"next":f=b(B.sxs[F],B.sys[F],nt+1),m=f[0],G=m[0],H=m[1],it=f[1];break;case"nearest":v=y(nt,A,z,O,B.sxs[F],B.sys[F]),g=v[0],G=g[0],H=g[1],it=v[1],V=B._xs[F][it],L=B._ys[F][it];break;default:throw new Error("should't have happened")}var $=void 0,Y={index:$=k instanceof s.GlyphRenderer?k.view.convert_indices_from_subset([F])[0]:F,x:N,y:I,sx:z,sy:O,data_x:V,data_y:L,segment_index:it,indices:S.multiline_indices,name:x.model.name};C.add(G,H,this._render_tooltips(M,$,Y))}}}}}},e.prototype._emit_callback=function(t){for(var e=0,n=this.computed_renderers;e<n.length;e++){var r=n[e],o=r.data_source.inspected,s=this.plot_view.frame,a=s.xscales[r.x_range_name],l=s.yscales[r.y_range_name],c=a.invert(t.sx),h=l.invert(t.sy),u=i.__assign({x:c,y:h},t);this.model.callback.execute(this.model,{index:o,geometry:u,renderer:r})}},e.prototype._render_tooltips=function(t,e,n){var i=this.model.tooltips;if(f.isString(i)){var r=u.div();return r.innerHTML=h.replace_placeholders(i,t,e,this.model.formatters,n),r}if(f.isFunction(i))return i(t,n);for(var o=u.div({style:{display:"table",borderSpacing:"2px"}}),s=0,a=i;s<a.length;s++){var l=a[s],c=l[0],_=l[1],p=u.div({style:{display:"table-row"}});o.appendChild(p);var m=void 0;if(m=u.div({style:{display:"table-cell"},class:g.bk_tooltip_row_label},0!=c.length?c+": ":""),p.appendChild(m),m=u.div({style:{display:"table-cell"},class:g.bk_tooltip_row_value}),p.appendChild(m),_.indexOf("$color")>=0){var v=_.match(/\$color(\[.*\])?:(\w*)/),y=v[1],b=void 0===y?"":y,w=v[2],x=t.get_column(w);if(null==x){var A=u.span({},w+" unknown");m.appendChild(A);continue}var k=b.indexOf("hex")>=0,C=b.indexOf("swatch")>=0,T=f.isNumber(e)?x[e]:null;if(null==T){var S=u.span({},"(null)");m.appendChild(S);continue}k&&(T=d.color2hex(T));var r=u.span({},T);m.appendChild(r),C&&(r=u.span({class:g.bk_tooltip_color_block,style:{backgroundColor:T}}," "),m.appendChild(r))}else{var r=u.span();r.innerHTML=h.replace_placeholders(_.replace("$~","$data_"),t,e,this.model.formatters,n),m.appendChild(r)}}return o},e.__name__="HoverToolView",e}(r.InspectToolView);n.HoverToolView=w;var x=function(t){function e(e){var n=t.call(this,e)||this;return n.tool_name="Hover",n.icon=v.bk_tool_icon_hover,n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=w,this.define({tooltips:[_.Any,[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[_.Any,{}],renderers:[_.Any,"auto"],names:[_.Array,[]],mode:[_.HoverMode,"mouse"],point_policy:[_.PointPolicy,"snap_to_data"],line_policy:[_.LinePolicy,"nearest"],show_arrow:[_.Boolean,!0],anchor:[_.Anchor,"center"],attachment:[_.TooltipAttachment,"horizontal"],callback:[_.Any]})},e.__name__="HoverTool",e}(r.InspectTool);n.HoverTool=x,x.initClass()},function(t,e,n){var i=t(421),r=t(259),o=t(283),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="InspectToolView",e}(r.ButtonToolView);n.InspectToolView=a;var l=function(t){function e(e){var n=t.call(this,e)||this;return n.event_type="move",n}return i.__extends(e,t),e.initClass=function(){this.prototype.button_view=o.OnOffButtonView,this.define({toggleable:[s.Boolean,!0]}),this.override({active:!0})},e.__name__="InspectTool",e}(r.ButtonTool);n.InspectTool=l,l.initClass()},function(t,e,n){var i=t(421),r=t(259),o=t(309),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.model.active?this.el.classList.add(o.bk_active):this.el.classList.remove(o.bk_active)},e.prototype._clicked=function(){var t=this.model.active;this.model.active=!t},e.__name__="OnOffButtonView",e}(r.ButtonToolButtonView);n.OnOffButtonView=s},function(t,e,n){var i=t(421),r=t(18),o=t(50),s=t(24),a=t(62),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!0,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){e.model.active?e.activate():e.deactivate()})},e.prototype.activate=function(){},e.prototype.deactivate=function(){},e.__name__="ToolView",e}(o.View);n.ToolView=l;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.internal({active:[r.Boolean,!1]})},Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._get_dim_tooltip=function(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}},e.prototype._get_dim_limits=function(t,e,n,i){var r,o=t[0],a=t[1],l=e[0],c=e[1],h=n.bbox.h_range;"width"==i||"both"==i?(r=[s.min([o,l]),s.max([o,l])],r=[s.max([r[0],h.start]),s.min([r[1],h.end])]):r=[h.start,h.end];var u,_=n.bbox.v_range;return"height"==i||"both"==i?(u=[s.min([a,c]),s.max([a,c])],u=[s.max([u[0],_.start]),s.min([u[1],_.end])]):u=[_.start,_.end],[r,u]},e.__name__="Tool",e}(a.Model);n.Tool=c,c.initClass()},function(t,e,n){var i=t(421),r=t(18),o=t(22),s=t(62),a=t(282),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({tools:[r.Array,[]],active:[r.Boolean,!1],disabled:[r.Boolean,!1]})},Object.defineProperty(e.prototype,"button_view",{get:function(){return this.tools[0].button_view},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"event_type",{get:function(){return this.tools[0].event_type},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tools[0].tooltip},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"tool_name",{get:function(){return this.tools[0].tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"icon",{get:function(){return this.tools[0].computed_icon},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"toggleable",{get:function(){var t=this.tools[0];return t instanceof a.InspectTool&&t.toggleable},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.do=new o.Signal0(this,"do")},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.do,function(){return e.doit()}),this.connect(this.properties.active.change,function(){return e.set_active()})},e.prototype.doit=function(){for(var t=0,e=this.tools;t<e.length;t++){var n=e[t];n.do.emit()}},e.prototype.set_active=function(){for(var t=0,e=this.tools;t<e.length;t++){var n=e[t];n.active=this.active}},e.__name__="ToolProxy",e}(s.Model);n.ToolProxy=l,l.initClass()},function(t,e,n){var i=t(421),r=t(18),o=t(46),s=t(24),a=t(282),l=t(287),c=function(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},h=function(t){return"tap"==t||"pan"==t},u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l.ToolbarBaseView,this.define({active_drag:[r.Any,"auto"],active_inspect:[r.Any,"auto"],active_scroll:[r.Any,"auto"],active_tap:[r.Any,"auto"],active_multi:[r.Any,null]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.tools.change,function(){return e._init_tools()})},e.prototype._init_tools=function(){var e=this;if(t.prototype._init_tools.call(this),"auto"==this.active_inspect);else if(this.active_inspect instanceof a.InspectTool){for(var n=!1,i=0,r=this.inspectors;i<r.length;i++){var l=r[i];l!=this.active_inspect?l.active=!1:n=!0}n||(this.active_inspect=null)}else if(o.isArray(this.active_inspect)){var u=s.intersection(this.active_inspect,this.inspectors);u.length!=this.active_inspect.length&&(this.active_inspect=u);for(var _=0,d=this.inspectors;_<d.length;_++){var l=d[_];s.includes(this.active_inspect,l)||(l.active=!1)}}else if(null==this.active_inspect)for(var p=0,f=this.inspectors;p<f.length;p++){var l=f[p];l.active=!1}var m=function(t){t.active?e._active_change(t):t.active=!0};for(var v in this.gestures){var g=this.gestures[v];g.tools=s.sort_by(g.tools,function(t){return t.default_order});for(var y=0,b=g.tools;y<b.length;y++){var w=b[y];this.connect(w.properties.active.change,this._active_change.bind(this,w))}}for(var v in this.gestures){var x=c(v);if(x){var A=this[x];if("auto"==A){var g=this.gestures[v];0!=g.tools.length&&h(v)&&m(g.tools[0])}else null!=A&&(s.includes(this.tools,A)?m(A):this[x]=null)}}},e.__name__="Toolbar",e}(l.ToolbarBase);n.Toolbar=u,u.initClass()},function(t,e,n){var i=t(421),r=t(17),o=t(5),s=t(4),a=t(18),l=t(6),c=t(24),h=t(32),u=t(46),_=t(62),d=t(269),p=t(250),f=t(252),m=t(282),v=t(314),g=t(307),y=t(309),b=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({_visible:[a.Any,null],autohide:[a.Boolean,!1]})},Object.defineProperty(e.prototype,"visible",{get:function(){return!this.autohide||null!=this._visible&&this._visible},enumerable:!0,configurable:!0}),e.__name__="ToolbarViewModel",e}(_.Model);n.ToolbarViewModel=b,b.initClass();var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._tool_button_views={},this._build_tool_button_views(),this._toolbar_view_model=new b({autohide:this.model.autohide})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tools.change,function(){e._build_tool_button_views(),e.render()}),this.connect(this.model.properties.autohide.change,function(){e._toolbar_view_model.autohide=e.model.autohide,e._on_visible_change()}),this.connect(this._toolbar_view_model.properties._visible.change,function(){return e._on_visible_change()})},e.prototype.remove=function(){s.remove_views(this._tool_button_views),t.prototype.remove.call(this)},e.prototype._build_tool_button_views=function(){var t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;s.build_views(this._tool_button_views,t,{parent:this},function(t){return t.button_view})},e.prototype.set_visibility=function(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)},e.prototype._on_visible_change=function(){var t=this._toolbar_view_model.visible,e=v.bk_toolbar_hidden;this.el.classList.contains(e)&&t?this.el.classList.remove(e):t||this.el.classList.add(e)},e.prototype.render=function(){var t=this;if(o.empty(this.el),this.el.classList.add(v.bk_toolbar),this.el.classList.add(y.bk_side(this.model.toolbar_location)),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){var e="grey"===this.model.logo?g.bk_grey:null,n=o.a({href:"https://bokeh.pydata.org/",target:"_blank",class:[g.bk_logo,g.bk_logo_small,e]});this.el.appendChild(n)}var i=[],r=function(e){return t._tool_button_views[e.id].el},s=this.model.gestures;for(var a in s)i.push(s[a].tools.map(r));i.push(this.model.actions.map(r)),i.push(this.model.inspectors.filter(function(t){return t.toggleable}).map(r)),i.push(this.model.help.map(r));for(var l=0,c=i;l<c.length;l++){var h=c[l];if(0!==h.length){var u=o.div({class:v.bk_button_bar},h);this.el.appendChild(u)}}},e.prototype.update_layout=function(){},e.prototype.update_position=function(){},e.prototype.after_layout=function(){this._has_finished=!0},e.__name__="ToolbarBaseView",e}(l.DOMView);function x(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}n.ToolbarBaseView=w;var A=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=w,this.define({tools:[a.Array,[]],logo:[a.Logo,"normal"],autohide:[a.Boolean,!1]}),this.internal({gestures:[a.Any,x],actions:[a.Array,[]],inspectors:[a.Array,[]],help:[a.Array,[]],toolbar_location:[a.Location,"right"]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_tools()},e.prototype._init_tools=function(){var t=this,e=function(t,e){if(t.length!=e.length)return!0;var n=new h.Set(e.map(function(t){return t.id}));return c.some(t,function(t){return!n.has(t.id)})},n=this.tools.filter(function(t){return t instanceof m.InspectTool});e(this.inspectors,n)&&(this.inspectors=n);var i=this.tools.filter(function(t){return t instanceof f.HelpTool});e(this.help,i)&&(this.help=i);var o=this.tools.filter(function(t){return t instanceof p.ActionTool});e(this.actions,o)&&(this.actions=o);for(var s=function(e,n){e in t.gestures||r.logger.warn("Toolbar: unknown event type '"+e+"' for tool: "+n.type+" ("+n.id+")")},a={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}},l=0,_=this.tools;l<_.length;l++){var v=_[l];if(v instanceof d.GestureTool&&v.event_type)if(u.isString(v.event_type))a[v.event_type].tools.push(v),s(v.event_type,v);else{a.multi.tools.push(v);for(var g=0,y=v.event_type;g<y.length;g++){var b=y[g];s(b,v)}}}for(var w=function(t){var n=x.gestures[t];e(n.tools,a[t].tools)&&(n.tools=a[t].tools),n.active&&c.every(n.tools,function(t){return t.id!=n.active.id})&&(n.active=null)},x=this,A=0,k=Object.keys(a);A<k.length;A++){var b=k[A];w(b)}},Object.defineProperty(e.prototype,"horizontal",{get:function(){return"above"===this.toolbar_location||"below"===this.toolbar_location},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"vertical",{get:function(){return"left"===this.toolbar_location||"right"===this.toolbar_location},enumerable:!0,configurable:!0}),e.prototype._active_change=function(t){var e=t.event_type;if(null!=e)for(var n=u.isString(e)?[e]:e,i=0,o=n;i<o.length;i++){var s=o[i];if(t.active){var a=this.gestures[s].active;null!=a&&t!=a&&(r.logger.debug("Toolbar: deactivating tool: "+a.type+" ("+a.id+") for event type '"+s+"'"),a.active=!1),this.gestures[s].active=t,r.logger.debug("Toolbar: activating tool: "+t.type+" ("+t.id+") for event type '"+s+"'")}else this.gestures[s].active=null}},e.__name__="ToolbarBase",e}(_.Model);n.ToolbarBase=A,A.initClass()},function(t,e,n){var i=t(421),r=t(18),o=t(24),s=t(287),a=t(285),l=t(166),c=t(13),h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._merge_tools()},e.prototype._merge_tools=function(){var t,e=this;this._proxied_tools=[];for(var n={},i={},r={},s=[],l=[],c=0,h=this.help;c<h.length;c++){var u=h[c];o.includes(l,u.redirect)||(s.push(u),l.push(u.redirect))}for(var _ in(t=this._proxied_tools).push.apply(t,s),this.help=s,this.gestures){var d=this.gestures[_];_ in r||(r[_]={});for(var p=0,f=d.tools;p<f.length;p++){var m=f[p];m.type in r[_]||(r[_][m.type]=[]),r[_][m.type].push(m)}}for(var v=0,g=this.inspectors;v<g.length;v++){var m=g[v];m.type in n||(n[m.type]=[]),n[m.type].push(m)}for(var y=0,b=this.actions;y<b.length;y++){var m=b[y];m.type in i||(i[m.type]=[]),i[m.type].push(m)}var w=function(t,n){void 0===n&&(n=!1);var i=new a.ToolProxy({tools:t,active:n});return e._proxied_tools.push(i),i};for(var _ in r){var d=this.gestures[_];for(var x in d.tools=[],r[_]){var A=r[_][x];if(A.length>0)if("multi"==_)for(var k=0,C=A;k<C.length;k++){var m=C[k],T=w([m]);d.tools.push(T),this.connect(T.properties.active.change,this._active_change.bind(this,T))}else{var T=w(A);d.tools.push(T),this.connect(T.properties.active.change,this._active_change.bind(this,T))}}}for(var x in this.actions=[],i){var A=i[x];if("CustomAction"==x)for(var S=0,M=A;S<M.length;S++){var m=M[S];this.actions.push(w([m]))}else A.length>0&&this.actions.push(w(A))}for(var x in this.inspectors=[],n){var A=n[x];A.length>0&&this.inspectors.push(w(A,!0))}for(var E in this.gestures){var d=this.gestures[E];0!=d.tools.length&&(d.tools=o.sort_by(d.tools,function(t){return t.default_order}),"pinch"!=E&&"scroll"!=E&&"multi"!=E&&(d.tools[0].active=!0))}},e.__name__="ProxyToolbar",e}(s.ToolbarBase);n.ProxyToolbar=h;var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){this.model.toolbar.toolbar_location=this.model.toolbar_location,t.prototype.initialize.call(this)},Object.defineProperty(e.prototype,"child_models",{get:function(){return[this.model.toolbar]},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new c.ContentBox(this.child_views[0].el);var t=this.model.toolbar;t.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})},e.__name__="ToolbarBoxView",e}(l.LayoutDOMView);n.ToolbarBoxView=u;var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=u,this.define({toolbar:[r.Instance],toolbar_location:[r.Location,"right"]})},e.__name__="ToolbarBox",e}(l.LayoutDOM);n.ToolbarBox=_,_.initClass()},function(t,e,n){var i=t(24);n.compute_renderers=function(t,e,n){if(null==t)return[];var r="auto"==t?e:t;return n.length>0&&(r=r.filter(function(t){return i.includes(n,t.name)})),r}},function(t,e,n){var i=t(421),r=t(297),o=t(18),s=t(35),a=t(40),l=function(e){function n(t){return e.call(this,t)||this}return i.__extends(n,e),n.initClass=function(){this.define({args:[o.Any,{}],func:[o.String,""],v_func:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(n.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),n.prototype._make_transform=function(t,e){var n=this.use_strict?a.use_strict(e):e;return new(Function.bind.apply(Function,[void 0].concat(this.names,[t,"require","exports",n])))},Object.defineProperty(n.prototype,"scalar_transform",{get:function(){return this._make_transform("x",this.func)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"vector_transform",{get:function(){return this._make_transform("xs",this.v_func)},enumerable:!0,configurable:!0}),n.prototype.compute=function(e){return this.scalar_transform.apply(this,this.values.concat([e,t,{}]))},n.prototype.v_compute=function(e){return this.vector_transform.apply(this,this.values.concat([e,t,{}]))},n.__name__="CustomJSTransform",n}(r.Transform);n.CustomJSTransform=l,l.initClass()},function(t,e,n){var i=t(421),r=t(297),o=t(192),s=t(18),a=t(46),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({value:[s.Number,0],range:[s.Instance]})},e.prototype.v_compute=function(t){var e;if(this.range instanceof o.FactorRange)e=this.range.v_synthetic(t);else{if(!a.isArrayableOf(t,a.isNumber))throw new Error("unexpected");e=t}for(var n=new Float64Array(e.length),i=0;i<e.length;i++){var r=e[i];n[i]=this._compute(r)}return n},e.prototype.compute=function(t){if(this.range instanceof o.FactorRange)return this._compute(this.range.synthetic(t));if(a.isNumber(t))return this._compute(t);throw new Error("unexpected")},e.prototype._compute=function(t){return t+this.value},e.__name__="Dodge",e}(r.Transform);n.Dodge=l,l.initClass()},function(t,e,n){var i=t(290);n.CustomJSTransform=i.CustomJSTransform;var r=t(291);n.Dodge=r.Dodge;var o=t(293);n.Interpolator=o.Interpolator;var s=t(294);n.Jitter=s.Jitter;var a=t(295);n.LinearInterpolator=a.LinearInterpolator;var l=t(296);n.StepInterpolator=l.StepInterpolator;var c=t(297);n.Transform=c.Transform},function(t,e,n){var i=t(421),r=t(297),o=t(18),s=t(24),a=t(46),l=function(t){function e(e){var n=t.call(this,e)||this;return n._sorted_dirty=!0,n}return i.__extends(e,t),e.initClass=function(){this.define({x:[o.Any],y:[o.Any],data:[o.Any],clip:[o.Boolean,!0]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,function(){return e._sorted_dirty=!0})},e.prototype.v_compute=function(t){for(var e=new Float64Array(t.length),n=0;n<t.length;n++){var i=t[n];e[n]=this.compute(i)}return e},e.prototype.sort=function(t){if(void 0===t&&(t=!1),this._sorted_dirty){var e,n;if(a.isString(this.x)&&a.isString(this.y)&&null!=this.data){var i=this.data.columns();if(!s.includes(i,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!s.includes(i,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),n=this.data.get_column(this.y)}else{if(!a.isArray(this.x)||!a.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,n=this.y}if(e.length!==n.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");var r=[];for(var o in e)r.push({x:e[o],y:n[o]});t?r.sort(function(t,e){return t.x>e.x?-1:t.x==e.x?0:1}):r.sort(function(t,e){return t.x<e.x?-1:t.x==e.x?0:1}),this._x_sorted=[],this._y_sorted=[];for(var l=0,c=r;l<c.length;l++){var h=c[l],u=h.x,_=h.y;this._x_sorted.push(u),this._y_sorted.push(_)}this._sorted_dirty=!1}},e.__name__="Interpolator",e}(r.Transform);n.Interpolator=l,l.initClass()},function(t,e,n){var i=t(421),r=t(297),o=t(192),s=t(46),a=t(18),l=t(34),c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({mean:[a.Number,0],width:[a.Number,1],distribution:[a.Distribution,"uniform"],range:[a.Instance]}),this.internal({previous_values:[a.Array]})},e.prototype.v_compute=function(t){if(null!=this.previous_values&&this.previous_values.length==t.length)return this.previous_values;var e;if(this.range instanceof o.FactorRange)e=this.range.v_synthetic(t);else{if(!s.isArrayableOf(t,s.isNumber))throw new Error("unexpected");e=t}for(var n=new Float64Array(e.length),i=0;i<e.length;i++){var r=e[i];n[i]=this._compute(r)}return this.previous_values=n,n},e.prototype.compute=function(t){if(this.range instanceof o.FactorRange)return this._compute(this.range.synthetic(t));if(s.isNumber(t))return this._compute(t);throw new Error("unexpected")},e.prototype._compute=function(t){switch(this.distribution){case"uniform":return t+this.mean+(l.random()-.5)*this.width;case"normal":return t+l.rnorm(this.mean,this.width)}},e.__name__="Jitter",e}(r.Transform);n.Jitter=c,c.initClass()},function(t,e,n){var i=t(421),r=t(24),o=t(293),s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];var e=r.find_last_index(this._x_sorted,function(e){return e<t}),n=this._x_sorted[e],i=this._x_sorted[e+1],o=this._y_sorted[e],s=this._y_sorted[e+1];return o+(t-n)/(i-n)*(s-o)},e.__name__="LinearInterpolator",e}(o.Interpolator);n.LinearInterpolator=s},function(t,e,n){var i=t(421),r=t(293),o=t(18),s=t(24),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({mode:[o.StepMode,"after"]})},e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}var e;switch(this.mode){case"after":e=s.find_last_index(this._x_sorted,function(e){return t>=e});break;case"before":e=s.find_index(this._x_sorted,function(e){return t<=e});break;case"center":var n=this._x_sorted.map(function(e){return Math.abs(e-t)}),i=s.min(n);e=s.find_index(n,function(t){return i===t});break;default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN},e.__name__="StepInterpolator",e}(r.Interpolator);n.StepInterpolator=a,a.initClass()},function(t,e,n){var i=t(421),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="Transform",e}(r.Model);n.Transform=o},function(t,e,n){var i,r,o,s;"undefined"==typeof Map&&t(372),"undefined"==typeof WeakMap&&t(384),"undefined"==typeof Promise&&t(378).polyfill(),void 0===Math.log10&&(Math.log10=function(t){return Math.log(t)*Math.LOG10E}),void 0===Number.isInteger&&(Number.isInteger=function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t}),void 0===String.prototype.repeat&&(String.prototype.repeat=function(t){if(null==this)throw new TypeError("can't convert "+this+" to object");var e=""+this;if((t=+t)!=t&&(t=0),t<0)throw new RangeError("repeat count must be non-negative");if(t==1/0)throw new RangeError("repeat count must be less than infinity");if(t=Math.floor(t),0==e.length||0==t)return"";if(e.length*t>=1<<28)throw new RangeError("repeat count must not overflow maximum string size");for(var n="";1==(1&t)&&(n+=e),0!=(t>>>=1);)e+=e;return n}),void 0===Array.from&&(Array.from=(i=Object.prototype.toString,r=function(t){return"function"==typeof t||"[object Function]"===i.call(t)},o=Math.pow(2,53)-1,s=function(t){var e=function(t){var e=Number(t);return isNaN(e)?0:0!==e&&isFinite(e)?(e>0?1:-1)*Math.floor(Math.abs(e)):e}(t);return Math.min(Math.max(e,0),o)},function(t){var e=Object(t);if(null==t)throw new TypeError("Array.from requires an array-like object - not null or undefined");var n,i=arguments.length>1?arguments[1]:void 0;if(void 0!==i){if(!r(i))throw new TypeError("Array.from: when provided, the second argument must be a function");arguments.length>2&&(n=arguments[2])}for(var o=s(e.length),a=r(this)?Object(new this(o)):new Array(o),l=0
// 13. If IsConstructor(C) is true, then
;l<o;){var c=e[l];a[l]=i?void 0===n?i(c,l):i.call(n,c,l):c,l+=1}return a.length=o,a}))},function(t,e,n){var i=t(421);i.__exportStar(t(300),n),i.__exportStar(t(301),n)},function(t,e,n){var i=t(40),r=function(){function t(t,e,n){this.header=t,this.metadata=e,this.content=n,this.buffers=[]}return t.assemble=function(e,n,i){var r=JSON.parse(e),o=JSON.parse(n),s=JSON.parse(i);return new t(r,o,s)},t.prototype.assemble_buffer=function(t,e){var n=null!=this.header.num_buffers?this.header.num_buffers:0;if(n<=this.buffers.length)throw new Error("too many buffers received, expecting #{nb}");this.buffers.push([t,e])},t.create=function(e,n,i){void 0===i&&(i={});var r=t.create_header(e);return new t(r,n,i)},t.create_header=function(t){return{msgid:i.uniqueId(),msgtype:t}},t.prototype.complete=function(){return!(null==this.header||null==this.metadata||null==this.content||"num_buffers"in this.header&&this.buffers.length!==this.header.num_buffers)},t.prototype.send=function(t){var e=null!=this.header.num_buffers?this.header.num_buffers:0;if(e>0)throw new Error("BokehJS only supports receiving buffers, not sending");var n=JSON.stringify(this.header),i=JSON.stringify(this.metadata),r=JSON.stringify(this.content);t.send(n),t.send(i),t.send(r)},t.prototype.msgid=function(){return this.header.msgid},t.prototype.msgtype=function(){return this.header.msgtype},t.prototype.reqid=function(){return this.header.reqid},t.prototype.problem=function(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"},t.__name__="Message",t}();n.Message=r},function(t,e,n){var i=t(300),r=function(){function t(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}return t.prototype.consume=function(t){this._current_consumer(t)},t.prototype._HEADER=function(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA},t.prototype._METADATA=function(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT},t.prototype._CONTENT=function(t){this._assume_text(t),this._fragments.push(t);var e=this._fragments.slice(0,3),n=e[0],r=e[1],o=e[2];this._partial=i.Message.assemble(n,r,o),this._check_complete()},t.prototype._BUFFER_HEADER=function(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD},t.prototype._BUFFER_PAYLOAD=function(t){this._assume_binary(t),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()},t.prototype._assume_text=function(t){if(t instanceof ArrayBuffer)throw new Error("Expected text fragment but received binary fragment")},t.prototype._assume_binary=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")},t.prototype._check_complete=function(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER},t.__name__="Receiver",t}();n.Receiver=r},function(t,e,n){n.safely=function(t,e){void 0===e&&(e=!1);try{return t()}catch(t){if(function(t){var e=document.createElement("div");e.style.backgroundColor="#f2dede",e.style.border="1px solid #a94442",e.style.borderRadius="4px",e.style.display="inline-block",e.style.fontFamily="sans-serif",e.style.marginTop="5px",e.style.minWidth="200px",e.style.padding="5px 5px 5px 10px",e.classList.add("bokeh-error-box-into-flames");var n=document.createElement("span");n.style.backgroundColor="#a94442",n.style.borderRadius="0px 4px 0px 0px",n.style.color="white",n.style.cursor="pointer",n.style.cssFloat="right",n.style.fontSize="0.8em",n.style.margin="-6px -6px 0px 0px",n.style.padding="2px 5px 4px 5px",n.title="close",n.setAttribute("aria-label","close"),n.appendChild(document.createTextNode("x")),n.addEventListener("click",function(){return s.removeChild(e)});var i=document.createElement("h3");i.style.color="#a94442",i.style.margin="8px 0px 0px 0px",i.style.padding="0px",i.appendChild(document.createTextNode("Bokeh Error"));var r=document.createElement("pre");r.style.whiteSpace="unset",r.style.overflowX="auto";var o=t instanceof Error?t.message:t;r.appendChild(document.createTextNode(o)),e.appendChild(n),e.appendChild(i),e.appendChild(r);var s=document.getElementsByTagName("body")[0];s.insertBefore(e,s.firstChild)}(t),e)return;throw t}}},function(t,e,n){t(311);var i=t(5);i.styles.append(".bk-root .bk-shading {\n  position: absolute;\n  display: block;\n  border: 1px dashed green;\n}\n"),n.bk_annotation="bk-annotation",n.bk_shading="bk-shading",n.bk_annotation_child="bk-annotation-child"},function(t,e,n){t(311);var i=t(5);i.styles.append(".bk-root .bk-btn {\n  height: 100%;\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  white-space: nowrap;\n  cursor: pointer;\n  padding: 6px 12px;\n  font-size: 12px;\n  border: 1px solid transparent;\n  border-radius: 4px;\n  outline: 0;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-btn:hover,\n.bk-root .bk-btn:focus {\n  text-decoration: none;\n}\n.bk-root .bk-btn:active,\n.bk-root .bk-btn.bk-active {\n  background-image: none;\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.bk-root .bk-btn[disabled] {\n  cursor: not-allowed;\n  pointer-events: none;\n  opacity: 0.65;\n  box-shadow: none;\n}\n.bk-root .bk-btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-default:hover {\n  background-color: #f5f5f5;\n  border-color: #b8b8b8;\n}\n.bk-root .bk-btn-default.bk-active {\n  background-color: #ebebeb;\n  border-color: #adadad;\n}\n.bk-root .bk-btn-default[disabled],\n.bk-root .bk-btn-default[disabled]:hover,\n.bk-root .bk-btn-default[disabled]:focus,\n.bk-root .bk-btn-default[disabled]:active,\n.bk-root .bk-btn-default[disabled].bk-active {\n  background-color: #e6e6e6;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-primary {\n  color: #fff;\n  background-color: #428bca;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-primary:hover {\n  background-color: #3681c1;\n  border-color: #2c699e;\n}\n.bk-root .bk-btn-primary.bk-active {\n  background-color: #3276b1;\n  border-color: #285e8e;\n}\n.bk-root .bk-btn-primary[disabled],\n.bk-root .bk-btn-primary[disabled]:hover,\n.bk-root .bk-btn-primary[disabled]:focus,\n.bk-root .bk-btn-primary[disabled]:active,\n.bk-root .bk-btn-primary[disabled].bk-active {\n  background-color: #506f89;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-success:hover {\n  background-color: #4eb24e;\n  border-color: #409240;\n}\n.bk-root .bk-btn-success.bk-active {\n  background-color: #47a447;\n  border-color: #398439;\n}\n.bk-root .bk-btn-success[disabled],\n.bk-root .bk-btn-success[disabled]:hover,\n.bk-root .bk-btn-success[disabled]:focus,\n.bk-root .bk-btn-success[disabled]:active,\n.bk-root .bk-btn-success[disabled].bk-active {\n  background-color: #667b66;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-warning:hover {\n  background-color: #eea43b;\n  border-color: #e89014;\n}\n.bk-root .bk-btn-warning.bk-active {\n  background-color: #ed9c28;\n  border-color: #d58512;\n}\n.bk-root .bk-btn-warning[disabled],\n.bk-root .bk-btn-warning[disabled]:hover,\n.bk-root .bk-btn-warning[disabled]:focus,\n.bk-root .bk-btn-warning[disabled]:active,\n.bk-root .bk-btn-warning[disabled].bk-active {\n  background-color: #c89143;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-danger:hover {\n  background-color: #d5433e;\n  border-color: #bd2d29;\n}\n.bk-root .bk-btn-danger.bk-active {\n  background-color: #d2322d;\n  border-color: #ac2925;\n}\n.bk-root .bk-btn-danger[disabled],\n.bk-root .bk-btn-danger[disabled]:hover,\n.bk-root .bk-btn-danger[disabled]:focus,\n.bk-root .bk-btn-danger[disabled]:active,\n.bk-root .bk-btn-danger[disabled].bk-active {\n  background-color: #a55350;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-group {\n  height: 100%;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-btn-group > .bk-btn {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n}\n.bk-root .bk-btn-group > .bk-btn + .bk-btn {\n  margin-left: -1px;\n}\n.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.bk-root .bk-btn-group .bk-dropdown-toggle {\n  flex: 0 0 0;\n  -webkit-flex: 0 0 0;\n  padding: 6px 6px;\n}\n"),n.bk_btn="bk-btn",n.bk_btn_group="bk-btn-group",n.bk_btn_default="bk-btn-default",n.bk_btn_primary="bk-btn-primary",n.bk_btn_success="bk-btn-success",n.bk_btn_warning="bk-btn-warning",n.bk_btn_danger="bk-btn-danger",n.bk_btn_type=function(t){switch(t){case"default":return n.bk_btn_default;case"primary":return n.bk_btn_primary;case"success":return n.bk_btn_success;case"warning":return n.bk_btn_warning;case"danger":return n.bk_btn_danger}},n.bk_dropdown_toggle="bk-dropdown-toggle"},function(t,e,n){t(311),n.bk_canvas="bk-canvas",n.bk_canvas_map="bk-canvas-map",n.bk_canvas_overlays="bk-canvas-overlays",n.bk_canvas_events="bk-canvas-events"},function(t,e,n){t(311);var i=t(5);i.styles.append('.bk-root .bk-tool-icon-box-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-box-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-zoom-in {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-zoom-out {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-help {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-hover {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-crosshair {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-lasso-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-pan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-xpan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-ypan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-range {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-polygon-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-redo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-reset {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-save {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-tap-select {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-undo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-wheel-pan {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-wheel-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-box-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-freehand-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-point-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");\n}\n'),n.bk_tool_icon_box_select="bk-tool-icon-box-select",n.bk_tool_icon_box_zoom="bk-tool-icon-box-zoom",n.bk_tool_icon_zoom_in="bk-tool-icon-zoom-in",n.bk_tool_icon_zoom_out="bk-tool-icon-zoom-out",n.bk_tool_icon_help="bk-tool-icon-help",n.bk_tool_icon_hover="bk-tool-icon-hover",n.bk_tool_icon_crosshair="bk-tool-icon-crosshair",n.bk_tool_icon_lasso_select="bk-tool-icon-lasso-select",n.bk_tool_icon_pan="bk-tool-icon-pan",n.bk_tool_icon_xpan="bk-tool-icon-xpan",n.bk_tool_icon_ypan="bk-tool-icon-ypan",n.bk_tool_icon_range="bk-tool-icon-range",n.bk_tool_icon_polygon_select="bk-tool-icon-polygon-select",n.bk_tool_icon_redo="bk-tool-icon-redo",n.bk_tool_icon_reset="bk-tool-icon-reset",n.bk_tool_icon_save="bk-tool-icon-save",n.bk_tool_icon_tap_select="bk-tool-icon-tap-select",n.bk_tool_icon_undo="bk-tool-icon-undo",n.bk_tool_icon_wheel_pan="bk-tool-icon-wheel-pan",n.bk_tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",n.bk_tool_icon_box_edit="bk-tool-icon-box-edit",n.bk_tool_icon_freehand_draw="bk-tool-icon-freehand-draw",n.bk_tool_icon_poly_draw="bk-tool-icon-poly-draw",n.bk_tool_icon_point_draw="bk-tool-icon-point-draw",n.bk_tool_icon_poly_edit="bk-tool-icon-poly-edit"},function(t,e,n){t(311);var i=t(5);i.styles.append(".bk-root .bk-logo {\n  margin: 5px;\n  position: relative;\n  display: block;\n  background-repeat: no-repeat;\n}\n.bk-root .bk-logo.bk-grey {\n  filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\\'http://www.w3.org/2000/svg\\'><filter id=\\'grayscale\\'><feColorMatrix type=\\'matrix\\' values=\\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\\'/></filter></svg>#grayscale\");\n  /* Firefox 10+, Firefox on Android */\n  filter: gray;\n  /* IE6-9 */\n  -webkit-filter: grayscale(100%);\n  /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n.bk-root .bk-logo-small {\n  width: 20px;\n  height: 20px;\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);\n}\n.bk-root .bk-logo-notebook {\n  display: inline-block;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n"),n.bk_logo="bk-logo",n.bk_logo_notebook="bk-logo-notebook",n.bk_logo_small="bk-logo-small",n.bk_grey="bk-grey"},function(t,e,n){t(311);var i=t(5);i.styles.append(".bk-root .bk-menu {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-menu.bk-above {\n  bottom: 100%;\n}\n.bk-root .bk-menu.bk-below {\n  top: 100%;\n}\n.bk-root .bk-menu > .bk-divider {\n  height: 1px;\n  margin: 7.5px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-menu > :not(.bk-divider) {\n  padding: 6px 12px;\n}\n.bk-root .bk-menu > :not(.bk-divider):hover,\n.bk-root .bk-menu > :not(.bk-divider).bk-active {\n  background-color: #e6e6e6;\n}\n.bk-root .bk-caret {\n  display: inline-block;\n  vertical-align: middle;\n  width: 0;\n  height: 0;\n  margin: 0 5px;\n}\n.bk-root .bk-caret.bk-down {\n  border-top: 4px solid;\n}\n.bk-root .bk-caret.bk-up {\n  border-bottom: 4px solid;\n}\n.bk-root .bk-caret.bk-down,\n.bk-root .bk-caret.bk-up {\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.bk-root .bk-caret.bk-left {\n  border-right: 4px solid;\n}\n.bk-root .bk-caret.bk-right {\n  border-left: 4px solid;\n}\n.bk-root .bk-caret.bk-left,\n.bk-root .bk-caret.bk-right {\n  border-top: 4px solid transparent;\n  border-bottom: 4px solid transparent;\n}\n"),n.bk_menu="bk-menu",n.bk_caret="bk-caret",n.bk_divider="bk-divider"},function(t,e,n){var i=t(5);i.styles.append(""),n.bk_active="bk-active",n.bk_inline="bk-inline",n.bk_left="bk-left",n.bk_right="bk-right",n.bk_above="bk-above",n.bk_below="bk-below",n.bk_up="bk-up",n.bk_down="bk-down",n.bk_side=function(t){switch(t){case"above":return n.bk_above;case"below":return n.bk_below;case"left":return n.bk_left;case"right":return n.bk_right}}},function(t,e,n){t(311);var i=t(5);i.styles.append("/* notebook specific tweaks so no black outline and matching padding\n/* can't be wrapped inside bk-root. here are the offending jupyter lines:\n/* https://github.com/jupyter/notebook/blob/master/notebook/static/notebook/less/renderedhtml.less#L59-L76 */\n.rendered_html .bk-root .bk-tooltip table,\n.rendered_html .bk-root .bk-tooltip tr,\n.rendered_html .bk-root .bk-tooltip th,\n.rendered_html .bk-root .bk-tooltip td {\n  border: none;\n  padding: 1px;\n}\n")},function(t,e,n){var i=t(5);i.styles.append(".bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 10pt;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n"),n.bk_root="bk-root"},function(t,e,n){t(311);var i=t(5);i.styles.append('.bk-root .bk-tabs-header {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  overflow: hidden;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-tabs-header .bk-btn-group {\n  height: auto;\n  margin-right: 5px;\n}\n.bk-root .bk-tabs-header .bk-btn-group > .bk-btn {\n  flex-grow: 0;\n  -webkit-flex-grow: 0;\n  height: auto;\n  padding: 4px 4px;\n}\n.bk-root .bk-tabs-header .bk-headers-wrapper {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  overflow: hidden;\n  color: #666666;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper {\n  border-bottom: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper {\n  border-left: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper {\n  border-top: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper {\n  border-right: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-above,\n.bk-root .bk-tabs-header.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers,\n.bk-root .bk-tabs-header.bk-below .bk-headers {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-left,\n.bk-root .bk-tabs-header.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers,\n.bk-root .bk-tabs-header.bk-right .bk-headers {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header .bk-headers {\n  position: relative;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n}\n.bk-root .bk-tabs-header .bk-tab {\n  padding: 4px 8px;\n  border: solid transparent;\n  white-space: nowrap;\n  cursor: pointer;\n}\n.bk-root .bk-tabs-header .bk-tab:hover {\n  background-color: #f2f2f2;\n}\n.bk-root .bk-tabs-header .bk-tab.bk-active {\n  color: #4d4d4d;\n  background-color: white;\n  border-color: #e6e6e6;\n}\n.bk-root .bk-tabs-header .bk-tab .bk-close {\n  margin-left: 10px;\n}\n.bk-root .bk-tabs-header.bk-above .bk-tab {\n  border-width: 3px 1px 0px 1px;\n  border-radius: 4px 4px 0 0;\n}\n.bk-root .bk-tabs-header.bk-right .bk-tab {\n  border-width: 1px 3px 1px 0px;\n  border-radius: 0 4px 4px 0;\n}\n.bk-root .bk-tabs-header.bk-below .bk-tab {\n  border-width: 0px 1px 3px 1px;\n  border-radius: 0 0 4px 4px;\n}\n.bk-root .bk-tabs-header.bk-left .bk-tab {\n  border-width: 1px 0px 1px 3px;\n  border-radius: 4px 0 0 4px;\n}\n.bk-root .bk-close {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  vertical-align: middle;\n  background-image: url(\'data:image/svg+xml;utf8,\\\n      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">\\\n        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>\\\n        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>\\\n      </svg>\');\n}\n.bk-root .bk-close:hover {\n  background-image: url(\'data:image/svg+xml;utf8,\\\n      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">\\\n        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>\\\n        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>\\\n      </svg>\');\n}\n'),n.bk_tabs_header="bk-tabs-header",n.bk_headers_wrapper="bk-headers-wrapper",n.bk_headers="bk-headers",n.bk_tab="bk-tab",n.bk_close="bk-close"},function(t,e,n){t(311);var i=t(5);i.styles.append(".bk-root .bk-tile-attribution a {\n  color: black;\n}\n"),n.bk_tile_attribution="bk-tile-attribution"},function(t,e,n){t(311);var i=t(5);i.styles.append('.bk-root .bk-toolbar-hidden {\n  visibility: hidden;\n  opacity: 0;\n  transition: visibility 0.3s linear, opacity 0.3s linear;\n}\n.bk-root .bk-toolbar,\n.bk-root .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-toolbar .bk-logo {\n  flex-shrink: 0;\n  -webkit-flex-shrink: 0;\n}\n.bk-root .bk-toolbar.bk-above,\n.bk-root .bk-toolbar.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n  justify-content: flex-end;\n  -webkit-justify-content: flex-end;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar,\n.bk-root .bk-toolbar.bk-below .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-toolbar.bk-above .bk-logo,\n.bk-root .bk-toolbar.bk-below .bk-logo {\n  order: 1;\n  -webkit-order: 1;\n  margin-left: 5px;\n  margin-right: 0px;\n}\n.bk-root .bk-toolbar.bk-left,\n.bk-root .bk-toolbar.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  justify-content: flex-start;\n  -webkit-justify-content: flex-start;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar,\n.bk-root .bk-toolbar.bk-right .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-toolbar.bk-left .bk-logo,\n.bk-root .bk-toolbar.bk-right .bk-logo {\n  order: 0;\n  -webkit-order: 0;\n  margin-bottom: 5px;\n  margin-top: 0px;\n}\n.bk-root .bk-toolbar-button {\n  width: 30px;\n  height: 30px;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-toolbar-button:hover {\n  background-color: #f9f9f9;\n}\n.bk-root .bk-toolbar-button:focus {\n  outline: none;\n}\n.bk-root .bk-toolbar-button::-moz-focus-inner {\n  border: 0;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button {\n  border-bottom: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {\n  border-bottom-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button {\n  border-top: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {\n  border-top-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button {\n  border-left: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {\n  border-left-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button {\n  border-right: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {\n  border-right-color: #26aae1;\n}\n.bk-root .bk-button-bar + .bk-button-bar:before {\n  content: " ";\n  display: inline-block;\n  background-color: lightgray;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {\n  height: 10px;\n  width: 1px;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {\n  height: 1px;\n  width: 10px;\n}\n'),n.bk_toolbar="bk-toolbar",n.bk_toolbar_hidden="bk-toolbar-hidden",n.bk_toolbar_button="bk-toolbar-button",n.bk_button_bar="bk-button-bar",n.bk_toolbar_button_custom_action="bk-toolbar-button-custom-action"},function(t,e,n){t(311);var i=t(5);i.styles.append('.bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n'),n.bk_tooltip="bk-tooltip",n.bk_tooltip_arrow="bk-tooltip-arrow",n.bk_tooltip_custom="bk-tooltip-custom",n.bk_tooltip_row_label="bk-tooltip-row-label",n.bk_tooltip_row_value="bk-tooltip-row-value",n.bk_tooltip_color_block="bk-tooltip-color-block"},function(t,e,n){function i(){var t=document.getElementsByTagName("body")[0],e=document.getElementsByClassName("bokeh-test-div");1==e.length&&(t.removeChild(e[0]),delete e[0]);var n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",t.insertBefore(n,t.firstChild)}n.results={},n.init=function(){i()},n.record=function(t,e){n.results[t]=e,i()},n.count=function(t){null==n.results[t]&&(n.results[t]=0),n.results[t]+=1,i()},n.clear=function(){for(var t=0,e=Object.keys(n.results);t<e.length;t++){var r=e[t];delete n.results[r]}i()}},function(t,e,n){n.version="1.3.0"},function(t,e,n){!function(){"use strict";var t,n,i,r,o;function s(t,e){var n,i=Object.keys(e);for(n=0;n<i.length;n++)t=t.replace(new RegExp("\\{"+i[n]+"\\}","gi"),e[i[n]]);return t}function a(t){var e,n,i;if(!t)throw new Error("cannot create a random attribute name for an undefined object");e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz",n="";do{for(n="",i=0;i<12;i++)n+=e[Math.floor(Math.random()*e.length)]}while(t[n]);return n}function l(t){var e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return e[t]||e.alphabetic}o=function(t,e){var n,i,r,o={};for(t=t.split(","),e=e||10,n=0;n<t.length;n+=2)i="&"+t[n+1]+";",r=parseInt(t[n],e),o[i]="&#"+r+";";return o["\\xa0"]="&#160;",o}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),t={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}},(i=function(t,e){this.__root=t,this.__ctx=e}).prototype.addColorStop=function(t,e){var n,i=this.__ctx.__createElement("stop");i.setAttribute("offset",t),-1!==e.indexOf("rgba")?(n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),i.setAttribute("stop-color",s("rgb({r},{g},{b})",{r:n[1],g:n[2],b:n[3]})),i.setAttribute("stop-opacity",n[4])):i.setAttribute("stop-color",e),this.__root.appendChild(i)},r=function(t,e){this.__root=t,this.__ctx=e},(n=function(t){var e,i={width:500,height:500,enableMirroring:!1};if(arguments.length>1?((e=i).width=arguments[0],e.height=arguments[1]):e=t||i,!(this instanceof n))return new n(e);this.width=e.width||i.width,this.height=e.height||i.height,this.enableMirroring=void 0!==e.enableMirroring?e.enableMirroring:i.enableMirroring,this.canvas=this,this.__document=e.document||document,e.ctx?this.__ctx=e.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[this.__getStyleState()],this.__groupStack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version",1.1),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.__root.setAttribute("width",this.width),this.__root.setAttribute("height",this.height),this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs),this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g"),this.__root.appendChild(this.__currentElement)}).prototype.__createElement=function(t,e,n){void 0===e&&(e={});var i,r,o=this.__document.createElementNS("http://www.w3.org/2000/svg",t),s=Object.keys(e);for(n&&(o.setAttribute("fill","none"),o.setAttribute("stroke","none")),i=0;i<s.length;i++)r=s[i],o.setAttribute(r,e[r]);return o},n.prototype.__setDefaultStyles=function(){var e,n,i=Object.keys(t);for(e=0;e<i.length;e++)this[n=i[e]]=t[n].canvas},n.prototype.__applyStyleState=function(t){var e,n,i=Object.keys(t);for(e=0;e<i.length;e++)this[n=i[e]]=t[n]},n.prototype.__getStyleState=function(){var e,n,i={},r=Object.keys(t);for(e=0;e<r.length;e++)n=r[e],i[n]=this[n];return i},n.prototype.__applyStyleToCurrentElement=function(e){var n=this.__currentElement,o=this.__currentElementsToStyle;o&&(n.setAttribute(e,""),n=o.element,o.children.forEach(function(t){t.setAttribute(e,"")}));var a,l,c,h,u,_=Object.keys(t);for(a=0;a<_.length;a++)if(l=t[_[a]],c=this[_[a]],l.apply)if(c instanceof r){if(c.__ctx)for(;c.__ctx.__defs.childNodes.length;)h=c.__ctx.__defs.childNodes[0].getAttribute("id"),this.__ids[h]=h,this.__defs.appendChild(c.__ctx.__defs.childNodes[0]);n.setAttribute(l.apply,s("url(#{id})",{id:c.__root.getAttribute("id")}))}else if(c instanceof i)n.setAttribute(l.apply,s("url(#{id})",{id:c.__root.getAttribute("id")}));else if(-1!==l.apply.indexOf(e)&&l.svg!==c)if("stroke"!==l.svgAttr&&"fill"!==l.svgAttr||-1===c.indexOf("rgba")){var d=l.svgAttr;if("globalAlpha"===_[a]&&(d=e+"-"+l.svgAttr,n.getAttribute(d)))continue;n.setAttribute(d,c)}else{u=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(c),n.setAttribute(l.svgAttr,s("rgb({r},{g},{b})",{r:u[1],g:u[2],b:u[3]}));var p=u[4],f=this.globalAlpha;null!=f&&(p*=f),n.setAttribute(l.svgAttr+"-opacity",p)}},n.prototype.__closestGroupOrSvg=function(t){return"g"===(t=t||this.__currentElement).nodeName||"svg"===t.nodeName?t:this.__closestGroupOrSvg(t.parentNode)},n.prototype.getSerializedSvg=function(t){var e,n,i,r,s,a=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(a)&&(a=a.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(e=Object.keys(o),n=0;n<e.length;n++)i=e[n],r=o[i],(s=new RegExp(i,"gi")).test(a)&&(a=a.replace(s,r));return a},n.prototype.getSvg=function(){return this.__root},n.prototype.save=function(){var t=this.__createElement("g"),e=this.__closestGroupOrSvg();this.__groupStack.push(e),e.appendChild(t),this.__currentElement=t,this.__stack.push(this.__getStyleState())},n.prototype.restore=function(){this.__currentElement=this.__groupStack.pop(),this.__currentElementsToStyle=null,this.__currentElement||(this.__currentElement=this.__root.childNodes[1]);var t=this.__stack.pop();this.__applyStyleState(t)},n.prototype.__addTransform=function(t){var e=this.__closestGroupOrSvg();if(e.childNodes.length>0){"path"===this.__currentElement.nodeName&&(this.__currentElementsToStyle||(this.__currentElementsToStyle={element:e,children:[]}),this.__currentElementsToStyle.children.push(this.__currentElement),this.__applyCurrentDefaultPath());var n=this.__createElement("g");e.appendChild(n),this.__currentElement=n}var i=this.__currentElement.getAttribute("transform");i?i+=" ":i="",i+=t,this.__currentElement.setAttribute("transform",i)},n.prototype.scale=function(t,e){void 0===e&&(e=t),this.__addTransform(s("scale({x},{y})",{x:t,y:e}))},n.prototype.rotate=function(t){var e=180*t/Math.PI;this.__addTransform(s("rotate({angle},{cx},{cy})",{angle:e,cx:0,cy:0}))},n.prototype.translate=function(t,e){this.__addTransform(s("translate({x},{y})",{x:t,y:e}))},n.prototype.transform=function(t,e,n,i,r,o){this.__addTransform(s("matrix({a},{b},{c},{d},{e},{f})",{a:t,b:e,c:n,d:i,e:r,f:o}))},n.prototype.beginPath=function(){var t;this.__currentDefaultPath="",this.__currentPosition={},t=this.__createElement("path",{},!0),this.__closestGroupOrSvg().appendChild(t),this.__currentElement=t},n.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},n.prototype.__addPathCommand=function(t){this.__currentDefaultPath+=" ",this.__currentDefaultPath+=t},n.prototype.moveTo=function(t,e){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.__currentPosition={x:t,y:e},this.__addPathCommand(s("M {x} {y}",{x:t,y:e}))},n.prototype.closePath=function(){this.__currentDefaultPath&&this.__addPathCommand("Z")},n.prototype.lineTo=function(t,e){this.__currentPosition={x:t,y:e},this.__currentDefaultPath.indexOf("M")>-1?this.__addPathCommand(s("L {x} {y}",{x:t,y:e})):this.__addPathCommand(s("M {x} {y}",{x:t,y:e}))},n.prototype.bezierCurveTo=function(t,e,n,i,r,o){this.__currentPosition={x:r,y:o},this.__addPathCommand(s("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:t,cp1y:e,cp2x:n,cp2y:i,x:r,y:o}))},n.prototype.quadraticCurveTo=function(t,e,n,i){this.__currentPosition={x:n,y:i},this.__addPathCommand(s("Q {cpx} {cpy} {x} {y}",{cpx:t,cpy:e,x:n,y:i}))};var c=function(t){var e=Math.sqrt(t[0]*t[0]+t[1]*t[1]);return[t[0]/e,t[1]/e]};n.prototype.arcTo=function(t,e,n,i,r){var o=this.__currentPosition&&this.__currentPosition.x,s=this.__currentPosition&&this.__currentPosition.y;if(void 0!==o&&void 0!==s){if(r<0)throw new Error("IndexSizeError: The radius provided ("+r+") is negative.");if(o===t&&s===e||t===n&&e===i||0===r)this.lineTo(t,e);else{var a=c([o-t,s-e]),l=c([n-t,i-e]);if(a[0]*l[1]!=a[1]*l[0]){var h=a[0]*l[0]+a[1]*l[1],u=Math.acos(Math.abs(h)),_=c([a[0]+l[0],a[1]+l[1]]),d=r/Math.sin(u/2),p=t+d*_[0],f=e+d*_[1],m=[-a[1],a[0]],v=[l[1],-l[0]],g=function(t){var e=t[0],n=t[1];return n>=0?Math.acos(e):-Math.acos(e)},y=g(m),b=g(v);this.lineTo(p+m[0]*r,f+m[1]*r),this.arc(p,f,r,y,b)}else this.lineTo(t,e)}}},n.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill stroke markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke")},n.prototype.fill=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke fill markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill")},n.prototype.rect=function(t,e,n,i){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+n,e),this.lineTo(t+n,e+i),this.lineTo(t,e+i),this.lineTo(t,e),this.closePath()},n.prototype.fillRect=function(t,e,n,i){var r;r=this.__createElement("rect",{x:t,y:e,width:n,height:i},!0),this.__closestGroupOrSvg().appendChild(r),this.__currentElement=r,this.__applyStyleToCurrentElement("fill")},n.prototype.strokeRect=function(t,e,n,i){var r;r=this.__createElement("rect",{x:t,y:e,width:n,height:i},!0),this.__closestGroupOrSvg().appendChild(r),this.__currentElement=r,this.__applyStyleToCurrentElement("stroke")},n.prototype.__clearCanvas=function(){for(var t=this.__closestGroupOrSvg(),e=t.getAttribute("transform"),n=this.__root.childNodes[1],i=n.childNodes,r=i.length-1;r>=0;r--)i[r]&&n.removeChild(i[r]);this.__currentElement=n,this.__groupStack=[],e&&this.__addTransform(e)},n.prototype.clearRect=function(t,e,n,i){if(0!==t||0!==e||n!==this.width||i!==this.height){var r,o=this.__closestGroupOrSvg();r=this.__createElement("rect",{x:t,y:e,width:n,height:i,fill:"#FFFFFF"},!0),o.appendChild(r)}else this.__clearCanvas()},n.prototype.createLinearGradient=function(t,e,n,r){var o=this.__createElement("linearGradient",{id:a(this.__ids),x1:t+"px",x2:n+"px",y1:e+"px",y2:r+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(o),new i(o,this)},n.prototype.createRadialGradient=function(t,e,n,r,o,s){var l=this.__createElement("radialGradient",{id:a(this.__ids),cx:r+"px",cy:o+"px",r:s+"px",fx:t+"px",fy:e+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(l),new i(l,this)},n.prototype.__parseFont=function(){var t=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),e={style:t[1]||"normal",size:t[4]||"10px",family:t[6]||"sans-serif",weight:t[3]||"normal",decoration:t[2]||"normal",href:null};return"underline"===this.__fontUnderline&&(e.decoration="underline"),this.__fontHref&&(e.href=this.__fontHref),e},n.prototype.__wrapTextLink=function(t,e){if(t.href){var n=this.__createElement("a");return n.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),n.appendChild(e),n}return e},n.prototype.__applyText=function(t,e,n,i){var r,o,s=this.__parseFont(),a=this.__closestGroupOrSvg(),c=this.__createElement("text",{"font-family":s.family,"font-size":s.size,"font-style":s.style,"font-weight":s.weight,"text-decoration":s.decoration,x:e,y:n,"text-anchor":(r=this.textAlign,o={left:"start",right:"end",center:"middle",start:"start",end:"end"},o[r]||o.start),"dominant-baseline":l(this.textBaseline)},!0);c.appendChild(this.__document.createTextNode(t)),this.__currentElement=c,this.__applyStyleToCurrentElement(i),a.appendChild(this.__wrapTextLink(s,c))},n.prototype.fillText=function(t,e,n){this.__applyText(t,e,n,"fill")},n.prototype.strokeText=function(t,e,n){this.__applyText(t,e,n,"stroke")},n.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},n.prototype.arc=function(t,e,n,i,r,o){if(i!==r){i%=2*Math.PI,r%=2*Math.PI,i===r&&(r=(r+2*Math.PI-.001*(o?-1:1))%(2*Math.PI));var a=t+n*Math.cos(r),l=e+n*Math.sin(r),c=t+n*Math.cos(i),h=e+n*Math.sin(i),u=o?0:1,_=0,d=r-i;d<0&&(d+=2*Math.PI),_=o?d>Math.PI?0:1:d>Math.PI?1:0,this.lineTo(c,h),this.__addPathCommand(s("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:n,ry:n,xAxisRotation:0,largeArcFlag:_,sweepFlag:u,endX:a,endY:l})),this.__currentPosition={x:a,y:l}}},n.prototype.clip=function(){var t=this.__closestGroupOrSvg(),e=this.__createElement("clipPath"),n=a(this.__ids),i=this.__createElement("g");this.__applyCurrentDefaultPath(),t.removeChild(this.__currentElement),e.setAttribute("id",n),e.appendChild(this.__currentElement),this.__defs.appendChild(e),t.setAttribute("clip-path",s("url(#{id})",{id:n})),t.appendChild(i),this.__currentElement=i},n.prototype.drawImage=function(){var t,e,i,r,o,s,a,l,c,h,u,_,d,p,f=Array.prototype.slice.call(arguments),m=f[0],v=0,g=0;if(3===f.length)t=f[1],e=f[2],o=m.width,s=m.height,i=o,r=s;else if(5===f.length)t=f[1],e=f[2],i=f[3],r=f[4],o=m.width,s=m.height;else{if(9!==f.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);v=f[1],g=f[2],o=f[3],s=f[4],t=f[5],e=f[6],i=f[7],r=f[8]}a=this.__closestGroupOrSvg(),this.__currentElement;var y="translate("+t+", "+e+")";if(m instanceof n){if((l=m.getSvg().cloneNode(!0)).childNodes&&l.childNodes.length>1){for(c=l.childNodes[0];c.childNodes.length;)p=c.childNodes[0].getAttribute("id"),this.__ids[p]=p,this.__defs.appendChild(c.childNodes[0]);if(h=l.childNodes[1]){var b,w=h.getAttribute("transform");b=w?w+" "+y:y,h.setAttribute("transform",b),a.appendChild(h)}}}else"IMG"===m.nodeName?((u=this.__createElement("image")).setAttribute("width",i),u.setAttribute("height",r),u.setAttribute("preserveAspectRatio","none"),(v||g||o!==m.width||s!==m.height)&&((_=this.__document.createElement("canvas")).width=i,_.height=r,(d=_.getContext("2d")).drawImage(m,v,g,o,s,0,0,i,r),m=_),u.setAttribute("transform",y),u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===m.nodeName?m.toDataURL():m.getAttribute("src")),a.appendChild(u)):"CANVAS"===m.nodeName&&((u=this.__createElement("image")).setAttribute("width",i),u.setAttribute("height",r),u.setAttribute("preserveAspectRatio","none"),(_=this.__document.createElement("canvas")).width=i,_.height=r,(d=_.getContext("2d")).imageSmoothingEnabled=!1,d.mozImageSmoothingEnabled=!1,d.oImageSmoothingEnabled=!1,d.webkitImageSmoothingEnabled=!1,d.drawImage(m,v,g,o,s,0,0,i,r),m=_,u.setAttribute("transform",y),u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.toDataURL()),a.appendChild(u))},n.prototype.createPattern=function(t,e){var i,o=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=a(this.__ids);return o.setAttribute("id",s),o.setAttribute("width",t.width),o.setAttribute("height",t.height),"CANVAS"===t.nodeName||"IMG"===t.nodeName?((i=this.__document.createElementNS("http://www.w3.org/2000/svg","image")).setAttribute("width",t.width),i.setAttribute("height",t.height),i.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===t.nodeName?t.toDataURL():t.getAttribute("src")),o.appendChild(i),this.__defs.appendChild(o)):t instanceof n&&(o.appendChild(t.__root.childNodes[1]),this.__defs.appendChild(o)),new r(o,this)},n.prototype.setLineDash=function(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null},n.prototype.drawFocusRing=function(){},n.prototype.createImageData=function(){},n.prototype.getImageData=function(){},n.prototype.putImageData=function(){},n.prototype.globalCompositeOperation=function(){},n.prototype.setTransform=function(){},"object"==typeof window&&(window.C2S=n),"object"==typeof e&&"object"==typeof e.exports&&(e.exports=n)}()},function(t,e,n){var i,r=t(342),o=t(352),s=t(357),a=t(351),l=t(357),c=t(359),h=Function.prototype.bind,u=Object.defineProperty,_=Object.prototype.hasOwnProperty;i=function(t,e,n){var i,o=c(e)&&l(e.value);return delete(i=r(e)).writable,delete i.value,i.get=function(){return!n.overwriteDefinition&&_.call(this,t)?o:(e.value=h.call(o,n.resolveContext?n.resolveContext(this):this),u(this,t,e),this[t])},i},e.exports=function(t){var e=o(arguments[1]);return null!=e.resolveContext&&s(e.resolveContext),a(t,function(t,n){return i(n,t,e)})}},function(t,e,n){var i=t(339),r=t(352),o=t(345),s=t(360);(e.exports=function(t,e){var n,o,a,l,c;return arguments.length<2||"string"!=typeof t?(l=e,e=t,t=null):l=arguments[2],null==t?(n=a=!0,o=!1):(n=s.call(t,"c"),o=s.call(t,"e"),a=s.call(t,"w")),c={value:e,configurable:n,enumerable:o,writable:a},l?i(r(l),c):c}).gs=function(t,e,n){var a,l,c,h;return"string"!=typeof t?(c=n,n=e,e=t,t=null):c=arguments[3],null==e?e=void 0:o(e)?null==n?n=void 0:o(n)||(c=n,n=void 0):(c=e,e=n=void 0),null==t?(a=!0,l=!1):(a=s.call(t,"c"),l=s.call(t,"e")),h={get:e,set:n,configurable:a,enumerable:l},c?i(r(c),h):h}},function(t,e,n){var i=t(359);e.exports=function(){return i(this).length=0,this}},function(t,e,n){var i=t(333),r=t(337),o=t(359),s=Array.prototype.indexOf,a=Object.prototype.hasOwnProperty,l=Math.abs,c=Math.floor;e.exports=function(t){var e,n,h,u;if(!i(t))return s.apply(this,arguments);for(n=r(o(this).length),h=arguments[1],h=isNaN(h)?0:h>=0?c(h):r(this.length)-c(l(h)),e=h;e<n;++e)if(a.call(this,e)&&(u=this[e],i(u)))return e;return-1}},function(t,e,n){e.exports=t(324)()?Array.from:t(325)},function(t,e,n){e.exports=function(){var t,e,n=Array.from;return"function"==typeof n&&(e=n(t=["raz","dwa"]),Boolean(e&&e!==t&&"dwa"===e[1]))}},function(t,e,n){var i=t(379).iterator,r=t(326),o=t(327),s=t(337),a=t(357),l=t(359),c=t(347),h=t(363),u=Array.isArray,_=Function.prototype.call,d={configurable:!0,enumerable:!0,writable:!0,value:null},p=Object.defineProperty;e.exports=function(t){var e,n,f,m,v,g,y,b,w,x,A=arguments[1],k=arguments[2];if(t=Object(l(t)),c(A)&&a(A),this&&this!==Array&&o(this))e=this;else{if(!A){if(r(t))return 1!==(v=t.length)?Array.apply(null,t):((m=new Array(1))[0]=t[0],m);if(u(t)){for(m=new Array(v=t.length),n=0;n<v;++n)m[n]=t[n];return m}}m=[]}if(!u(t))if(void 0!==(w=t[i])){for(y=a(w).call(t),e&&(m=new e),b=y.next(),n=0;!b.done;)x=A?_.call(A,k,b.value,n):b.value,e?(d.value=x,p(m,n,d)):m[n]=x,b=y.next(),++n;v=n}else if(h(t)){for(v=t.length,e&&(m=new e),n=0,f=0;n<v;++n)x=t[n],n+1<v&&(g=x.charCodeAt(0))>=55296&&g<=56319&&(x+=t[++n]),x=A?_.call(A,k,x,f):x,e?(d.value=x,p(m,f,d)):m[f]=x,++f;v=f}if(void 0===v)for(v=s(t.length),e&&(m=new e(v)),n=0;n<v;++n)x=A?_.call(A,k,t[n],n):t[n],e?(d.value=x,p(m,n,d)):m[n]=x;return e&&(d.value=null,m.length=v),m}},function(t,e,n){var i=Object.prototype.toString,r=i.call(function(){return arguments}());e.exports=function(t){return i.call(t)===r}},function(t,e,n){var i=Object.prototype.toString,r=i.call(t(328));e.exports=function(t){return"function"==typeof t&&i.call(t)===r}},function(t,e,n){e.exports=function(){}},function(t,e,n){e.exports=function(){return this}()},function(t,e,n){e.exports=t(331)()?Math.sign:t(332)},function(t,e,n){e.exports=function(){var t=Math.sign;return"function"==typeof t&&1===t(10)&&-1===t(-20)}},function(t,e,n){e.exports=function(t){return t=Number(t),isNaN(t)||0===t?t:t>0?1:-1}},function(t,e,n){e.exports=t(334)()?Number.isNaN:t(335)},function(t,e,n){e.exports=function(){var t=Number.isNaN;return"function"==typeof t&&!t({})&&t(NaN)&&!t(34)}},function(t,e,n){e.exports=function(t){return t!=t}},function(t,e,n){var i=t(330),r=Math.abs,o=Math.floor;e.exports=function(t){return isNaN(t)?0:0!==(t=Number(t))&&isFinite(t)?i(t)*o(r(t)):t}},function(t,e,n){var i=t(336),r=Math.max;e.exports=function(t){return r(0,i(t))}},function(t,e,n){var i=t(357),r=t(359),o=Function.prototype.bind,s=Function.prototype.call,a=Object.keys,l=Object.prototype.propertyIsEnumerable;e.exports=function(t,e){return function(n,c){var h,u=arguments[2],_=arguments[3];return n=Object(r(n)),i(c),h=a(n),_&&h.sort("function"==typeof _?o.call(_,n):void 0),"function"!=typeof t&&(t=h[t]),s.call(t,h,function(t,i){return l.call(n,t)?s.call(c,u,n[t],t,n,i):e})}}},function(t,e,n){e.exports=t(340)()?Object.assign:t(341)},function(t,e,n){e.exports=function(){var t,e=Object.assign;return"function"==typeof e&&(e(t={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),t.foo+t.bar+t.trzy==="razdwatrzy")}},function(t,e,n){var i=t(348),r=t(359),o=Math.max;e.exports=function(t,e){var n,s,a,l=o(arguments.length,2);for(t=Object(r(t)),a=function(i){try{t[i]=e[i]}catch(t){n||(n=t)}},s=1;s<l;++s)e=arguments[s],i(e).forEach(a);if(void 0!==n)throw n;return t}},function(t,e,n){var i=t(323),r=t(339),o=t(359);e.exports=function(t){var e=Object(o(t)),n=arguments[1],s=Object(arguments[2]);if(e!==t&&!n)return e;var a={};return n?i(n,function(e){(s.ensure||e in t)&&(a[e]=t[e])}):r(a,t),a}},function(t,e,n){var i,r,o,s,a=Object.create;t(355)()||(i=t(356)),e.exports=i?1!==i.level?a:(r={},o={},s={configurable:!1,enumerable:!1,writable:!0,value:void 0},Object.getOwnPropertyNames(Object.prototype).forEach(function(t){o[t]="__proto__"!==t?s:{configurable:!0,enumerable:!1,writable:!0,value:void 0}}),Object.defineProperties(r,o),Object.defineProperty(i,"nullPolyfill",{configurable:!1,enumerable:!1,writable:!1,value:r}),function(t,e){return a(null===t?r:t,e)}):a},function(t,e,n){e.exports=t(338)("forEach")},function(t,e,n){e.exports=function(t){return"function"==typeof t}},function(t,e,n){var i=t(347),r={function:!0,object:!0};e.exports=function(t){return i(t)&&r[typeof t]||!1}},function(t,e,n){var i=t(328)();e.exports=function(t){return t!==i&&null!==t}},function(t,e,n){e.exports=t(349)()?Object.keys:t(350)},function(t,e,n){e.exports=function(){try{return Object.keys("primitive"),!0}catch(t){return!1}}},function(t,e,n){var i=t(347),r=Object.keys;e.exports=function(t){return r(i(t)?Object(t):t)}},function(t,e,n){var i=t(357),r=t(344),o=Function.prototype.call;e.exports=function(t,e){var n={},s=arguments[2];return i(e),r(t,function(t,i,r,a){n[i]=o.call(e,s,t,i,r,a)}),n}},function(t,e,n){var i=t(347),r=Array.prototype.forEach,o=Object.create;e.exports=function(t){var e=o(null);return r.call(arguments,function(t){i(t)&&function(t,e){var n;for(n in t)e[n]=t[n]}(Object(t),e)}),e}},function(t,e,n){var i=Array.prototype.forEach,r=Object.create;e.exports=function(t){var e=r(null);return i.call(arguments,function(t){e[t]=!0}),e}},function(t,e,n){e.exports=t(355)()?Object.setPrototypeOf:t(356)},function(t,e,n){var i=Object.create,r=Object.getPrototypeOf,o={};e.exports=function(){var t=Object.setPrototypeOf,e=arguments[0]||i;return"function"==typeof t&&r(t(e(null),o))===o}},function(t,e,n){var i,r,o,s,a=t(346),l=t(359),c=Object.prototype.isPrototypeOf,h=Object.defineProperty,u={configurable:!0,enumerable:!1,writable:!0,value:void 0};i=function(t,e){if(l(t),null===e||a(e))return t;throw new TypeError("Prototype must be null or an object")},e.exports=(r=function(){var t,e=Object.create(null),n={},i=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__");if(i){try{(t=i.set).call(e,n)}catch(t){}if(Object.getPrototypeOf(e)===n)return{set:t,level:2}}return e.__proto__=n,Object.getPrototypeOf(e)===n?{level:2}:((e={}).__proto__=n,Object.getPrototypeOf(e)===n&&{level:1})}())?(2===r.level?r.set?(s=r.set,o=function(t,e){return s.call(i(t,e),e),t}):o=function(t,e){return i(t,e).__proto__=e,t}:o=function t(e,n){var r;return i(e,n),(r=c.call(t.nullPolyfill,e))&&delete t.nullPolyfill.__proto__,null===n&&(n=t.nullPolyfill),e.__proto__=n,r&&h(t.nullPolyfill,"__proto__",u),e},Object.defineProperty(o,"level",{configurable:!1,enumerable:!1,writable:!1,value:r.level})):null,t(343)},function(t,e,n){e.exports=function(t){if("function"!=typeof t)throw new TypeError(t+" is not a function");return t}},function(t,e,n){var i=t(346);e.exports=function(t){if(!i(t))throw new TypeError(t+" is not an Object");return t}},function(t,e,n){var i=t(347);e.exports=function(t){if(!i(t))throw new TypeError("Cannot use null or undefined");return t}},function(t,e,n){e.exports=t(361)()?String.prototype.contains:t(362)},function(t,e,n){var i="razdwatrzy";e.exports=function(){return"function"==typeof i.contains&&!0===i.contains("dwa")&&!1===i.contains("foo")}},function(t,e,n){var i=String.prototype.indexOf;e.exports=function(t){return i.call(this,t,arguments[1])>-1}},function(t,e,n){var i=Object.prototype.toString,r=i.call("");e.exports=function(t){return"string"==typeof t||t&&"object"==typeof t&&(t instanceof String||i.call(t)===r)||!1}},function(t,e,n){var i=Object.create(null),r=Math.random;e.exports=function(){var t;do{t=r().toString(36).slice(2)}while(i[t]);return t}},function(t,e,n){var i,r=t(354),o=t(360),s=t(320),a=t(379),l=t(368),c=Object.defineProperty;i=e.exports=function(t,e){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");l.call(this,t),e=e?o.call(e,"key+value")?"key+value":o.call(e,"key")?"key":"value":"value",c(this,"__kind__",s("",e))},r&&r(i,l),delete i.prototype.constructor,i.prototype=Object.create(l.prototype,{_resolve:s(function(t){return"value"===this.__kind__?this.__list__[t]:"key+value"===this.__kind__?[t,this.__list__[t]]:t})}),c(i.prototype,a.toStringTag,s("c","Array Iterator"))},function(t,e,n){var i=t(326),r=t(357),o=t(363),s=t(367),a=Array.isArray,l=Function.prototype.call,c=Array.prototype.some;e.exports=function(t,e){var n,h,u,_,d,p,f,m,v=arguments[2];if(a(t)||i(t)?n="array":o(t)?n="string":t=s(t),r(e),u=function(){_=!0},"array"!==n)if("string"!==n)for(h=t.next();!h.done;){if(l.call(e,v,h.value,u),_)return;h=t.next()}else for(p=t.length,d=0;d<p&&(f=t[d],d+1<p&&(m=f.charCodeAt(0))>=55296&&m<=56319&&(f+=t[++d]),l.call(e,v,f,u),!_);++d);else c.call(t,function(t){return l.call(e,v,t,u),_})}},function(t,e,n){var i=t(326),r=t(363),o=t(365),s=t(370),a=t(371),l=t(379).iterator;e.exports=function(t){return"function"==typeof a(t)[l]?t[l]():i(t)?new o(t):r(t)?new s(t):new o(t)}},function(t,e,n){var i,r=t(321),o=t(339),s=t(357),a=t(359),l=t(320),c=t(319),h=t(379),u=Object.defineProperty,_=Object.defineProperties;e.exports=i=function(t,e){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");_(this,{__list__:l("w",a(t)),__context__:l("w",e),__nextIndex__:l("w",0)}),e&&(s(e.on),e.on("_add",this._onAdd),e.on("_delete",this._onDelete),e.on("_clear",this._onClear))},delete i.prototype.constructor,_(i.prototype,o({_next:l(function(){var t;if(this.__list__)return this.__redo__&&void 0!==(t=this.__redo__.shift())?t:this.__nextIndex__<this.__list__.length?this.__nextIndex__++:void this._unBind()}),next:l(function(){return this._createResult(this._next())}),_createResult:l(function(t){return void 0===t?{done:!0,value:void 0}:{done:!1,value:this._resolve(t)}}),_resolve:l(function(t){return this.__list__[t]}),_unBind:l(function(){this.__list__=null,delete this.__redo__,this.__context__&&(this.__context__.off("_add",this._onAdd),this.__context__.off("_delete",this._onDelete),this.__context__.off("_clear",this._onClear),this.__context__=null)}),toString:l(function(){return"[object "+(this[h.toStringTag]||"Object")+"]"})},c({_onAdd:l(function(t){t>=this.__nextIndex__||(++this.__nextIndex__,this.__redo__?(this.__redo__.forEach(function(e,n){e>=t&&(this.__redo__[n]=++e)},this),this.__redo__.push(t)):u(this,"__redo__",l("c",[t])))}),_onDelete:l(function(t){var e;t>=this.__nextIndex__||(--this.__nextIndex__,this.__redo__&&(-1!==(e=this.__redo__.indexOf(t))&&this.__redo__.splice(e,1),this.__redo__.forEach(function(e,n){e>t&&(this.__redo__[n]=--e)},this)))}),_onClear:l(function(){this.__redo__&&r.call(this.__redo__),this.__nextIndex__=0})}))),u(i.prototype,h.iterator,l(function(){return this}))},function(t,e,n){var i=t(326),r=t(347),o=t(363),s=t(379).iterator,a=Array.isArray;e.exports=function(t){return!(!r(t)||!a(t)&&!o(t)&&!i(t)&&"function"!=typeof t[s])}},function(t,e,n){var i,r=t(354),o=t(320),s=t(379),a=t(368),l=Object.defineProperty;i=e.exports=function(t){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");t=String(t),a.call(this,t),l(this,"__length__",o("",t.length))},r&&r(i,a),delete i.prototype.constructor,i.prototype=Object.create(a.prototype,{_next:o(function(){if(this.__list__)return this.__nextIndex__<this.__length__?this.__nextIndex__++:void this._unBind()}),_resolve:o(function(t){var e,n=this.__list__[t];return this.__nextIndex__===this.__length__?n:(e=n.charCodeAt(0))>=55296&&e<=56319?n+this.__list__[this.__nextIndex__++]:n})}),l(i.prototype,s.toStringTag,o("c","String Iterator"))},function(t,e,n){var i=t(369);e.exports=function(t){if(!i(t))throw new TypeError(t+" is not iterable");return t}},function(t,e,n){t(373)()||Object.defineProperty(t(329),"Map",{value:t(377),configurable:!0,enumerable:!1,writable:!0})},function(t,e,n){e.exports=function(){var t,e,n;if("function"!=typeof Map)return!1;try{t=new Map([["raz","one"],["dwa","two"],["trzy","three"]])}catch(t){return!1}return"[object Map]"===String(t)&&3===t.size&&"function"==typeof t.clear&&"function"==typeof t.delete&&"function"==typeof t.entries&&"function"==typeof t.forEach&&"function"==typeof t.get&&"function"==typeof t.has&&"function"==typeof t.keys&&"function"==typeof t.set&&"function"==typeof t.values&&(e=t.entries(),!1===(n=e.next()).done&&!!n.value&&"raz"===n.value[0]&&"one"===n.value[1])}},function(t,e,n){e.exports="undefined"!=typeof Map&&"[object Map]"===Object.prototype.toString.call(new Map)},function(t,e,n){e.exports=t(353)("key","value","key+value")},function(t,e,n){var i,r=t(354),o=t(320),s=t(368),a=t(379).toStringTag,l=t(375),c=Object.defineProperties,h=s.prototype._unBind;i=e.exports=function(t,e){if(!(this instanceof i))return new i(t,e);s.call(this,t.__mapKeysData__,t),e&&l[e]||(e="key+value"),c(this,{__kind__:o("",e),__values__:o("w",t.__mapValuesData__)})},r&&r(i,s),i.prototype=Object.create(s.prototype,{constructor:o(i),_resolve:o(function(t){return"value"===this.__kind__?this.__values__[t]:"key"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__values__[t]]}),_unBind:o(function(){this.__values__=null,h.call(this)}),toString:o(function(){return"[object Map Iterator]"})}),Object.defineProperty(i.prototype,a,o("c","Map Iterator"))},function(t,e,n){var i,r=t(321),o=t(322),s=t(354),a=t(357),l=t(359),c=t(320),h=t(388),u=t(379),_=t(371),d=t(366),p=t(376),f=t(374),m=Function.prototype.call,v=Object.defineProperties,g=Object.getPrototypeOf;e.exports=i=function(){var t,e,n,r=arguments[0];if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");return n=f&&s&&Map!==i?s(new Map,g(this)):this,null!=r&&_(r),v(n,{__mapKeysData__:c("c",t=[]),__mapValuesData__:c("c",e=[])}),r?(d(r,function(n){var i=l(n)[0];n=n[1],-1===o.call(t,i)&&(t.push(i),e.push(n))},n),n):n},f&&(s&&s(i,Map),i.prototype=Object.create(Map.prototype,{constructor:c(i)})),h(v(i.prototype,{clear:c(function(){this.__mapKeysData__.length&&(r.call(this.__mapKeysData__),r.call(this.__mapValuesData__),this.emit("_clear"))}),delete:c(function(t){var e=o.call(this.__mapKeysData__,t);return-1!==e&&(this.__mapKeysData__.splice(e,1),this.__mapValuesData__.splice(e,1),this.emit("_delete",e,t),!0)}),entries:c(function(){return new p(this,"key+value")}),forEach:c(function(t){var e,n,i=arguments[1];for(a(t),e=this.entries(),n=e._next();void 0!==n;)m.call(t,i,this.__mapValuesData__[n],this.__mapKeysData__[n],this),n=e._next()}),get:c(function(t){var e=o.call(this.__mapKeysData__,t);if(-1!==e)return this.__mapValuesData__[e]}),has:c(function(t){return-1!==o.call(this.__mapKeysData__,t)}),keys:c(function(){return new p(this,"key")}),set:c(function(t,e){var n,i=o.call(this.__mapKeysData__,t);return-1===i&&(i=this.__mapKeysData__.push(t)-1,n=!0),this.__mapValuesData__[i]=e,n&&this.emit("_add",i,t),this}),size:c.gs(function(){return this.__mapKeysData__.length}),values:c(function(){return new p(this,"value")}),toString:c(function(){return"[object Map]"})})),Object.defineProperty(i.prototype,u.iterator,c(function(){return this.entries()})),Object.defineProperty(i.prototype,u.toStringTag,c("c","Map"))},function(t,e,n){
/*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.6+9869a4bc
     */
!function(t,i){"object"==typeof n&&void 0!==e?e.exports=i():t.ES6Promise=i()}(this,function(){"use strict";function e(t){return"function"==typeof t}var n=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},i=0,r=void 0,o=void 0,s=function(t,e){d[i]=t,d[i+1]=e,2===(i+=2)&&(o?o(p):y())},a="undefined"!=typeof window?window:void 0,l=a||{},c=l.MutationObserver||l.WebKitMutationObserver,h="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),u="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function _(){var t=setTimeout;return function(){return t(p,1)}}var d=new Array(1e3);function p(){for(var t=0;t<i;t+=2){var e=d[t],n=d[t+1];e(n),d[t]=void 0,d[t+1]=void 0}i=0}var f,m,v,g,y=void 0;function b(t,e){var n=this,i=new this.constructor(A);void 0===i[x]&&D(i);var r=n._state;if(r){var o=arguments[r-1];s(function(){return B(r,i,o,n._result)})}else N(n,i,t,e);return i}function w(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(A);return z(e,t),e}h?y=function(){return process.nextTick(p)}:c?(m=0,v=new c(p),g=document.createTextNode(""),v.observe(g,{characterData:!0}),y=function(){g.data=m=++m%2}):u?((f=new MessageChannel).port1.onmessage=p,y=function(){return f.port2.postMessage(0)}):y=void 0===a&&"function"==typeof t?function(){try{var t=Function("return this")().require("vertx");return void 0!==(r=t.runOnLoop||t.runOnContext)?function(){r(p)}:_()}catch(t){return _()}}():_();var x=Math.random().toString(36).substring(2);function A(){}var k=void 0,C=1,T=2,S={error:null};function M(t){try{return t.then}catch(t){return S.error=t,S}}function E(t,n,i){n.constructor===t.constructor&&i===b&&n.constructor.resolve===w?function(t,e){e._state===C?P(t,e._result):e._state===T?j(t,e._result):N(e,void 0,function(e){return z(t,e)},function(e){return j(t,e)})}(t,n):i===S?(j(t,S.error),S.error=null):void 0===i?P(t,n):e(i)?function(t,e,n){s(function(t){var i=!1,r=function(t,e,n,i){try{t.call(e,n,i)}catch(t){return t}}(n,e,function(n){i||(i=!0,e!==n?z(t,n):P(t,n))},function(e){i||(i=!0,j(t,e))},t._label);!i&&r&&(i=!0,j(t,r))},t)}(t,n,i):P(t,n)}function z(t,e){var n,i;t===e?j(t,new TypeError("You cannot resolve a promise with itself")):(i=typeof(n=e),null===n||"object"!==i&&"function"!==i?P(t,e):E(t,e,M(e)))}function O(t){t._onerror&&t._onerror(t._result),I(t)}function P(t,e){t._state===k&&(t._result=e,t._state=C,0!==t._subscribers.length&&s(I,t))}function j(t,e){t._state===k&&(t._state=T,t._result=e,s(O,t))}function N(t,e,n,i){var r=t._subscribers,o=r.length;t._onerror=null,r[o]=e,r[o+C]=n,r[o+T]=i,0===o&&t._state&&s(I,t)}function I(t){var e=t._subscribers,n=t._state;if(0!==e.length){for(var i=void 0,r=void 0,o=t._result,s=0;s<e.length;s+=3)i=e[s],r=e[s+n],i?B(n,i,r,o):r(o);t._subscribers.length=0}}function B(t,n,i,r){var o=e(i),s=void 0,a=void 0,l=void 0,c=void 0;if(o){if((s=function(t,e){try{return t(e)}catch(t){return S.error=t,S}}(i,r))===S?(c=!0,a=s.error,s.error=null):l=!0,n===s)return void j(n,new TypeError("A promises callback cannot return that same promise."))}else s=r,l=!0;n._state!==k||(o&&l?z(n,s):c?j(n,a):t===C?P(n,s):t===T&&j(n,s))}var R=0;function D(t){t[x]=R++,t._state=void 0,t._result=void 0,t._subscribers=[]}var F=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(A),this.promise[x]||D(this.promise),n(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?P(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&P(this.promise,this._result))):j(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;this._state===k&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(t,e){var n=this._instanceConstructor,i=n.resolve;if(i===w){var r=M(t);if(r===b&&t._state!==k)this._settledAt(t._state,e,t._result);else if("function"!=typeof r)this._remaining--,this._result[e]=t;else if(n===V){var o=new n(A);E(o,t,r),this._willSettleAt(o,e)}else this._willSettleAt(new n(function(e){return e(t)}),e)}else this._willSettleAt(i(t),e)},t.prototype._settledAt=function(t,e,n){var i=this.promise;i._state===k&&(this._remaining--,t===T?j(i,n):this._result[e]=n),0===this._remaining&&P(i,this._result)},t.prototype._willSettleAt=function(t,e){var n=this;N(t,void 0,function(t){return n._settledAt(C,e,t)},function(t){return n._settledAt(T,e,t)})},t}(),V=function(){function t(e){this[x]=R++,this._result=this._state=void 0,this._subscribers=[],A!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof t?function(t,e){try{e(function(e){z(t,e)},function(e){j(t,e)})}catch(e){j(t,e)}}(this,e):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return t.prototype.catch=function(t){return this.then(null,t)},t.prototype.finally=function(t){var n=this.constructor;return e(t)?this.then(function(e){return n.resolve(t()).then(function(){return e})},function(e){return n.resolve(t()).then(function(){throw e})}):this.then(t,t)},t}();return V.prototype.then=b,V.all=function(t){return new F(this,t).promise},V.race=function(t){var e=this;return n(t)?new e(function(n,i){for(var r=t.length,o=0;o<r;o++)e.resolve(t[o]).then(n,i)}):new e(function(t,e){return e(new TypeError("You must pass an array to race."))})},V.resolve=w,V.reject=function(t){var e=new this(A);return j(e,t),e},V._setScheduler=function(t){o=t},V._setAsap=function(t){s=t},V._asap=s,V.polyfill=function(){var t=void 0;if("undefined"!=typeof global)t=global;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var n=null;try{n=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===n&&!e.cast)return}t.Promise=V},V.Promise=V,V})},function(t,e,n){e.exports=t(380)()?Symbol:t(382)},function(t,e,n){var i={object:!0,symbol:!0};e.exports=function(){var t;if("function"!=typeof Symbol)return!1;t=Symbol("test symbol");try{String(t)}catch(t){return!1}return!!i[typeof Symbol.iterator]&&!!i[typeof Symbol.toPrimitive]&&!!i[typeof Symbol.toStringTag]}},function(t,e,n){e.exports=function(t){return!!t&&("symbol"==typeof t||!!t.constructor&&"Symbol"===t.constructor.name&&"Symbol"===t[t.constructor.toStringTag])}},function(t,e,n){var i,r,o,s,a=t(320),l=t(383),c=Object.create,h=Object.defineProperties,u=Object.defineProperty,_=Object.prototype,d=c(null);if("function"==typeof Symbol){i=Symbol;try{String(i()),s=!0}catch(t){}}var p,f=(p=c(null),function(t){for(var e,n,i=0;p[t+(i||"")];)++i;return p[t+=i||""]=!0,u(_,e="@@"+t,a.gs(null,function(t){n||(n=!0,u(this,e,a(t)),n=!1)})),e});o=function(t){if(this instanceof o)throw new TypeError("Symbol is not a constructor");return r(t)},e.exports=r=function t(e){var n;if(this instanceof t)throw new TypeError("Symbol is not a constructor");return s?i(e):(n=c(o.prototype),e=void 0===e?"":String(e),h(n,{__description__:a("",e),__name__:a("",f(e))}))},h(r,{for:a(function(t){return d[t]?d[t]:d[t]=r(String(t))}),keyFor:a(function(t){var e;for(e in l(t),d)if(d[e]===t)return e}),hasInstance:a("",i&&i.hasInstance||r("hasInstance")),isConcatSpreadable:a("",i&&i.isConcatSpreadable||r("isConcatSpreadable")),iterator:a("",i&&i.iterator||r("iterator")),match:a("",i&&i.match||r("match")),replace:a("",i&&i.replace||r("replace")),search:a("",i&&i.search||r("search")),species:a("",i&&i.species||r("species")),split:a("",i&&i.split||r("split")),toPrimitive:a("",i&&i.toPrimitive||r("toPrimitive")),toStringTag:a("",i&&i.toStringTag||r("toStringTag")),unscopables:a("",i&&i.unscopables||r("unscopables"))}),h(o.prototype,{constructor:a(r),toString:a("",function(){return this.__name__})}),h(r.prototype,{toString:a(function(){return"Symbol ("+l(this).__description__+")"}),valueOf:a(function(){return l(this)})}),u(r.prototype,r.toPrimitive,a("",function(){var t=l(this);return"symbol"==typeof t?t:t.toString()})),u(r.prototype,r.toStringTag,a("c","Symbol")),u(o.prototype,r.toStringTag,a("c",r.prototype[r.toStringTag])),u(o.prototype,r.toPrimitive,a("c",r.prototype[r.toPrimitive]))},function(t,e,n){var i=t(381);e.exports=function(t){if(!i(t))throw new TypeError(t+" is not a symbol");return t}},function(t,e,n){t(385)()||Object.defineProperty(t(329),"WeakMap",{value:t(387),configurable:!0,enumerable:!1,writable:!0})},function(t,e,n){e.exports=function(){var t,e;if("function"!=typeof WeakMap)return!1;try{t=new WeakMap([[e={},"one"],[{},"two"],[{},"three"]])}catch(t){return!1}return"[object WeakMap]"===String(t)&&"function"==typeof t.set&&t.set({},1)===t&&"function"==typeof t.delete&&"function"==typeof t.has&&"one"===t.get(e)}},function(t,e,n){e.exports="function"==typeof WeakMap&&"[object WeakMap]"===Object.prototype.toString.call(new WeakMap)},function(t,e,n){var i,r=t(354),o=t(358),s=t(359),a=t(364),l=t(320),c=t(367),h=t(366),u=t(379).toStringTag,_=t(386),d=Array.isArray,p=Object.defineProperty,f=Object.prototype.hasOwnProperty,m=Object.getPrototypeOf;e.exports=i=function(){var t,e=arguments[0];if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");return t=_&&r&&WeakMap!==i?r(new WeakMap,m(this)):this,null!=e&&(d(e)||(e=c(e))),p(t,"__weakMapData__",l("c","$weakMap$"+a())),e?(h(e,function(e){s(e),t.set(e[0],e[1])}),t):t},_&&(r&&r(i,WeakMap),i.prototype=Object.create(WeakMap.prototype,{constructor:l(i)})),Object.defineProperties(i.prototype,{delete:l(function(t){return!!f.call(o(t),this.__weakMapData__)&&(delete t[this.__weakMapData__],!0)}),get:l(function(t){if(f.call(o(t),this.__weakMapData__))return t[this.__weakMapData__]}),has:l(function(t){return f.call(o(t),this.__weakMapData__)}),set:l(function(t,e){return p(o(t),this.__weakMapData__,l("c",e)),this}),toString:l(function(){return"[object WeakMap]"})}),p(i.prototype,u,l("c","WeakMap"))},function(t,e,n){var i,r,o,s,a,l,c,h=t(320),u=t(357),_=Function.prototype.apply,d=Function.prototype.call,p=Object.create,f=Object.defineProperty,m=Object.defineProperties,v=Object.prototype.hasOwnProperty,g={configurable:!0,enumerable:!1,writable:!0};r=function(t,e){var n,r;return u(e),r=this,i.call(this,t,n=function(){o.call(r,t,n),_.call(e,this,arguments)}),n.__eeOnceListener__=e,this},a={on:i=function(t,e){var n;return u(e),v.call(this,"__ee__")?n=this.__ee__:(n=g.value=p(null),f(this,"__ee__",g),g.value=null),n[t]?"object"==typeof n[t]?n[t].push(e):n[t]=[n[t],e]:n[t]=e,this},once:r,off:o=function(t,e){var n,i,r,o;if(u(e),!v.call(this,"__ee__"))return this;if(!(n=this.__ee__)[t])return this;if("object"==typeof(i=n[t]))for(o=0;r=i[o];++o)r!==e&&r.__eeOnceListener__!==e||(2===i.length?n[t]=i[o?0:1]:i.splice(o,1));else i!==e&&i.__eeOnceListener__!==e||delete n[t];return this},emit:s=function(t){var e,n,i,r,o;if(v.call(this,"__ee__")&&(r=this.__ee__[t]))if("object"==typeof r){for(n=arguments.length,o=new Array(n-1),e=1;e<n;++e)o[e-1]=arguments[e];for(r=r.slice(),e=0;i=r[e];++e)_.call(i,this,o)}else switch(arguments.length){case 1:d.call(r,this);break;case 2:d.call(r,this,arguments[1]);break;case 3:d.call(r,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,o=new Array(n-1),e=1;e<n;++e)o[e-1]=arguments[e];_.call(r,this,o)}}},l={on:h(i),once:h(r),off:h(o),emit:h(s)},c=m({},l),e.exports=n=function(t){return null==t?p(c):m(Object(t),l)},n.methods=a},function(t,e,n){var i,r;i=this,r=function(){"use strict";var t=function(){this.ids=[],this.values=[],this.length=0};t.prototype.clear=function(){this.length=this.ids.length=this.values.length=0},t.prototype.push=function(t,e){this.ids.push(t),this.values.push(e);for(var n=this.length++;n>0;){var i=n-1>>1,r=this.values[i];if(e>=r)break;this.ids[n]=this.ids[i],this.values[n]=r,n=i}this.ids[n]=t,this.values[n]=e},t.prototype.pop=function(){if(0!==this.length){var t=this.ids[0];if(this.length--,this.length>0){for(var e=this.ids[0]=this.ids[this.length],n=this.values[0]=this.values[this.length],i=this.length>>1,r=0;r<i;){var o=1+(r<<1),s=o+1,a=this.ids[o],l=this.values[o],c=this.values[s];if(s<this.length&&c<l&&(o=s,a=this.ids[s],l=c),l>=n)break;this.ids[r]=a,this.values[r]=l,r=o}this.ids[r]=e,this.values[r]=n}return this.ids.pop(),this.values.pop(),t}},t.prototype.peek=function(){return this.ids[0]},t.prototype.peekValue=function(){return this.values[0]};var e=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],n=function(n,i,r,o){if(void 0===i&&(i=16),void 0===r&&(r=Float64Array),void 0===n)throw new Error("Missing required argument: numItems.");if(isNaN(n)||n<=0)throw new Error("Unpexpected numItems value: "+n+".");this.numItems=+n,this.nodeSize=Math.min(Math.max(+i,2),65535);var s=n,a=s;this._levelBounds=[4*s];do{s=Math.ceil(s/this.nodeSize),a+=s,this._levelBounds.push(4*a)}while(1!==s);this.ArrayType=r||Float64Array,this.IndexArrayType=a<16384?Uint16Array:Uint32Array;var l=e.indexOf(this.ArrayType),c=4*a*this.ArrayType.BYTES_PER_ELEMENT;if(l<0)throw new Error("Unexpected typed array class: "+r+".");o&&o instanceof ArrayBuffer?(this.data=o,this._boxes=new this.ArrayType(this.data,8,4*a),this._indices=new this.IndexArrayType(this.data,8+c,a),this._pos=4*a,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+c+a*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*a),this._indices=new this.IndexArrayType(this.data,8+c,a),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+l]),new Uint16Array(this.data,2,1)[0]=i,new Uint32Array(this.data,4,1)[0]=n),this._queue=new t};function i(t,e,n){return t<e?e-t:t<=n?0:t-n}function r(t,e){for(var n=0,i=e.length-1;n<i;){var r=n+i>>1;e[r]>t?i=r:n=r+1}return e[n]}function o(t,e,n,i,r){var o=t[i];t[i]=t[r],t[r]=o;var s=4*i,a=4*r,l=e[s],c=e[s+1],h=e[s+2],u=e[s+3];e[s]=e[a],e[s+1]=e[a+1],e[s+2]=e[a+2],e[s+3]=e[a+3],e[a]=l,e[a+1]=c,e[a+2]=h,e[a+3]=u;var _=n[i];n[i]=n[r],n[r]=_}function s(t,e){var n=t^e,i=65535^n,r=65535^(t|e),o=t&(65535^e),s=n|i>>1,a=n>>1^n,l=r>>1^i&o>>1^r,c=n&r>>1^o>>1^o;a=(n=s)&(i=a)>>2^i&(n^i)>>2,l^=n&(r=l)>>2^i&(o=c)>>2,c^=i&r>>2^(n^i)&o>>2,a=(n=s=n&n>>2^i&i>>2)&(i=a)>>4^i&(n^i)>>4,l^=n&(r=l)>>4^i&(o=c)>>4,c^=i&r>>4^(n^i)&o>>4,l^=(n=s=n&n>>4^i&i>>4)&(r=l)>>8^(i=a)&(o=c)>>8;var h=t^e,u=(i=(c^=i&r>>8^(n^i)&o>>8)^c>>1)|65535^(h|(n=l^l>>1));return((u=1431655765&((u=858993459&((u=252645135&((u=16711935&(u|u<<8))|u<<4))|u<<2))|u<<1))<<1|(h=1431655765&((h=858993459&((h=252645135&((h=16711935&(h|h<<8))|h<<4))|h<<2))|h<<1)))>>>0}return n.from=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var i=new Uint8Array(t,0,2),r=i[0],o=i[1];if(251!==r)throw new Error("Data does not appear to be in a Flatbush format.");if(o>>4!=3)throw new Error("Got v"+(o>>4)+" data when expected v3.");var s=new Uint16Array(t,2,1),a=s[0],l=new Uint32Array(t,4,1),c=l[0];return new n(c,a,e[15&o],t)},n.prototype.add=function(t,e,n,i){var r=this._pos>>2;this._indices[r]=r,this._boxes[this._pos++]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=n,this._boxes[this._pos++]=i,t<this.minX&&(this.minX=t),e<this.minY&&(this.minY=e),n>this.maxX&&(this.maxX=n),i>this.maxY&&(this.maxY=i)},n.prototype.finish=function(){if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");for(var t=this.maxX-this.minX,e=this.maxY-this.minY,n=new Uint32Array(this.numItems),i=0;i<this.numItems;i++){var r=4*i,a=this._boxes[r++],l=this._boxes[r++],c=this._boxes[r++],h=this._boxes[r++],u=Math.floor(65535*((a+c)/2-this.minX)/t),_=Math.floor(65535*((l+h)/2-this.minY)/e);n[i]=s(u,_)}!function t(e,n,i,r,s){if(!(r>=s)){for(var a=e[r+s>>1],l=r-1,c=s+1;;){do{l++}while(e[l]<a);do{c--}while(e[c]>a);if(l>=c)break;o(e,n,i,l,c)}t(e,n,i,r,c),t(e,n,i,c+1,s)}}(n,this._boxes,this._indices,0,this.numItems-1);for(var d=0,p=0;d<this._levelBounds.length-1;d++)for(var f=this._levelBounds[d];p<f;){for(var m=1/0,v=1/0,g=-1/0,y=-1/0,b=p,w=0;w<this.nodeSize&&p<f;w++){var x=this._boxes[p++],A=this._boxes[p++],k=this._boxes[p++],C=this._boxes[p++];x<m&&(m=x),A<v&&(v=A),k>g&&(g=k),C>y&&(y=C)}this._indices[this._pos>>2]=b,this._boxes[this._pos++]=m,this._boxes[this._pos++]=v,this._boxes[this._pos++]=g,this._boxes[this._pos++]=y}},n.prototype.search=function(t,e,n,i,r){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var o=this._boxes.length-4,s=this._levelBounds.length-1,a=[],l=[];void 0!==o;){for(var c=Math.min(o+4*this.nodeSize,this._levelBounds[s]),h=o;h<c;h+=4){var u=0|this._indices[h>>2];n<this._boxes[h]||i<this._boxes[h+1]||t>this._boxes[h+2]||e>this._boxes[h+3]||(o<4*this.numItems?(void 0===r||r(u))&&l.push(u):(a.push(u),a.push(s-1)))}s=a.pop(),o=a.pop()}return l},n.prototype.neighbors=function(t,e,n,o,s){if(void 0===n&&(n=1/0),void 0===o&&(o=1/0),this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var a=this._boxes.length-4,l=this._queue,c=[],h=o*o;void 0!==a;){for(var u=Math.min(a+4*this.nodeSize,r(a,this._levelBounds)),_=a;_<u;_+=4){var d=0|this._indices[_>>2],p=i(t,this._boxes[_],this._boxes[_+2]),f=i(e,this._boxes[_+1],this._boxes[_+3]),m=p*p+f*f;a<4*this.numItems?(void 0===s||s(d))&&l.push(-d-1,m):l.push(d,m)}for(;l.length&&l.peek()<0;){var v=l.peekValue();if(v>h)return l.clear(),c;if(c.push(-l.pop()-1),c.length===n)return l.clear(),c}a=l.pop()}return l.clear(),c},n},"object"==typeof n&&void 0!==e?e.exports=r():(i=i||self).Flatbush=r()},function(t,e,n){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,n,i,r){"use strict";var o,s=["","webkit","Moz","MS","ms","o"],a=n.createElement("div"),l="function",c=Math.round,h=Math.abs,u=Date.now;function _(t,e,n){return setTimeout(y(t,n),e)}function d(t,e,n){return!!Array.isArray(t)&&(p(t,n[e],n),!0)}function p(t,e,n){var i;if(t)if(t.forEach)t.forEach(e,n);else if(t.length!==r)for(i=0;i<t.length;)e.call(n,t[i],i,t),i++;else for(i in t)t.hasOwnProperty(i)&&e.call(n,t[i],i,t)}function f(e,n,i){var r="DEPRECATED METHOD: "+n+"\n"+i+" AT \n";return function(){var n=new Error("get-stack-trace"),i=n&&n.stack?n.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",o=t.console&&(t.console.warn||t.console.log);return o&&o.call(t.console,r,i),e.apply(this,arguments)}}o="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),n=1;n<arguments.length;n++){var i=arguments[n];if(i!==r&&null!==i)for(var o in i)i.hasOwnProperty(o)&&(e[o]=i[o])}return e}:Object.assign;var m=f(function(t,e,n){for(var i=Object.keys(e),o=0;o<i.length;)(!n||n&&t[i[o]]===r)&&(t[i[o]]=e[i[o]]),o++;return t},"extend","Use `assign`."),v=f(function(t,e){return m(t,e,!0)},"merge","Use `assign`.");function g(t,e,n){var i,r=e.prototype;(i=t.prototype=Object.create(r)).constructor=t,i._super=r,n&&o(i,n)}function y(t,e){return function(){return t.apply(e,arguments)}}function b(t,e){return typeof t==l?t.apply(e&&e[0]||r,e):t}function w(t,e){return t===r?e:t}function x(t,e,n){p(T(e),function(e){t.addEventListener(e,n,!1)})}function A(t,e,n){p(T(e),function(e){t.removeEventListener(e,n,!1)})}function k(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function T(t){return t.trim().split(/\s+/g)}function S(t,e,n){if(t.indexOf&&!n)return t.indexOf(e);for(var i=0;i<t.length;){if(n&&t[i][n]==e||!n&&t[i]===e)return i;i++}return-1}function M(t){return Array.prototype.slice.call(t,0)}function E(t,e,n){for(var i=[],r=[],o=0;o<t.length;){var s=e?t[o][e]:t[o];S(r,s)<0&&i.push(t[o]),r[o]=s,o++}return n&&(i=e?i.sort(function(t,n){return t[e]>n[e]}):i.sort()),i}function z(t,e){for(var n,i,o=e[0].toUpperCase()+e.slice(1),a=0;a<s.length;){if(n=s[a],(i=n?n+o:e)in t)return i;a++}return r}var O=1;function P(e){var n=e.ownerDocument||e;return n.defaultView||n.parentWindow||t}var j="ontouchstart"in t,N=z(t,"PointerEvent")!==r,I=j&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),B=25,R=1,D=2,F=4,V=8,L=1,U=2,G=4,H=8,Y=16,W=U|G,J=H|Y,X=W|J,q=["x","y"],Z=["clientX","clientY"];function K(t,e){var n=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){b(t.options.enable,[t])&&n.handler(e)},this.init()}function Q(t,e,n){var i=n.pointers.length,o=n.changedPointers.length,s=e&R&&i-o==0,a=e&(F|V)&&i-o==0;n.isFirst=!!s,n.isFinal=!!a,s&&(t.session={}),n.eventType=e,function(t,e){var n=t.session,i=e.pointers,o=i.length;n.firstInput||(n.firstInput=$(e)),o>1&&!n.firstMultiple?n.firstMultiple=$(e):1===o&&(n.firstMultiple=!1);var s=n.firstInput,a=n.firstMultiple,l=a?a.center:s.center,c=e.center=tt(i);e.timeStamp=u(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=rt(l,c),e.distance=it(l,c),function(t,e){var n=e.center,i=t.offsetDelta||{},r=t.prevDelta||{},o=t.prevInput||{};e.eventType!==R&&o.eventType!==F||(r=t.prevDelta={x:o.deltaX||0,y:o.deltaY||0},i=t.offsetDelta={x:n.x,y:n.y}),e.deltaX=r.x+(n.x-i.x),e.deltaY=r.y+(n.y-i.y)}(n,e),e.offsetDirection=nt(e.deltaX,e.deltaY);var _,d,p=et(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=h(p.x)>h(p.y)?p.x:p.y,e.scale=a?(_=a.pointers,it((d=i)[0],d[1],Z)/it(_[0],_[1],Z)):1,e.rotation=a?function(t,e){return rt(e[1],e[0],Z)+rt(t[1],t[0],Z)}(a.pointers,i):0,e.maxPointers=n.prevInput?e.pointers.length>n.prevInput.maxPointers?e.pointers.length:n.prevInput.maxPointers:e.pointers.length,function(t,e){var n,i,o,s,a=t.lastInterval||e,l=e.timeStamp-a.timeStamp;if(e.eventType!=V&&(l>B||a.velocity===r)){var c=e.deltaX-a.deltaX,u=e.deltaY-a.deltaY,_=et(l,c,u);i=_.x,o=_.y,n=h(_.x)>h(_.y)?_.x:_.y,s=nt(c,u),t.lastInterval=e}else n=a.velocity,i=a.velocityX,o=a.velocityY,s=a.direction;e.velocity=n,e.velocityX=i,e.velocityY=o,e.direction=s}(n,e);var f=t.element;k(e.srcEvent.target,f)&&(f=e.srcEvent.target),e.target=f}(t,n),t.emit("hammer.input",n),t.recognize(n),t.session.prevInput=n}function $(t){for(var e=[],n=0;n<t.pointers.length;)e[n]={clientX:c(t.pointers[n].clientX),clientY:c(t.pointers[n].clientY)},n++;return{timeStamp:u(),pointers:e,center:tt(e),deltaX:t.deltaX,deltaY:t.deltaY}}function tt(t){var e=t.length;if(1===e)return{x:c(t[0].clientX),y:c(t[0].clientY)};for(var n=0,i=0,r=0;r<e;)n+=t[r].clientX,i+=t[r].clientY,r++;return{x:c(n/e),y:c(i/e)}}function et(t,e,n){return{x:e/t||0,y:n/t||0}}function nt(t,e){return t===e?L:h(t)>=h(e)?t<0?U:G:e<0?H:Y}function it(t,e,n){n||(n=q);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return Math.sqrt(i*i+r*r)}function rt(t,e,n){n||(n=q);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return 180*Math.atan2(r,i)/Math.PI}K.prototype={handler:function(){},init:function(){this.evEl&&x(this.element,this.evEl,this.domHandler),this.evTarget&&x(this.target,this.evTarget,this.domHandler),this.evWin&&x(P(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(P(this.element),this.evWin,this.domHandler)}};var ot={mousedown:R,mousemove:D,mouseup:F},st="mousedown",at="mousemove mouseup";function lt(){this.evEl=st,this.evWin=at,this.pressed=!1,K.apply(this,arguments)}g(lt,K,{handler:function(t){var e=ot[t.type];e&R&&0===t.button&&(this.pressed=!0),e&D&&1!==t.which&&(e=F),this.pressed&&(e&F&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var ct={pointerdown:R,pointermove:D,pointerup:F,pointercancel:V,pointerout:V},ht={2:"touch",3:"pen",4:"mouse",5:"kinect"},ut="pointerdown",_t="pointermove pointerup pointercancel";function dt(){this.evEl=ut,this.evWin=_t,K.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(ut="MSPointerDown",_t="MSPointerMove MSPointerUp MSPointerCancel"),g(dt,K,{handler:function(t){var e=this.store,n=!1,i=t.type.toLowerCase().replace("ms",""),r=ct[i],o=ht[t.pointerType]||t.pointerType,s="touch"==o,a=S(e,t.pointerId,"pointerId");r&R&&(0===t.button||s)?a<0&&(e.push(t),a=e.length-1):r&(F|V)&&(n=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:o,srcEvent:t}),n&&e.splice(a,1))}});var pt={touchstart:R,touchmove:D,touchend:F,touchcancel:V},ft="touchstart",mt="touchstart touchmove touchend touchcancel";function vt(){this.evTarget=ft,this.evWin=mt,this.started=!1,K.apply(this,arguments)}g(vt,K,{handler:function(t){var e=pt[t.type];if(e===R&&(this.started=!0),this.started){var n=function(t,e){var n=M(t.touches),i=M(t.changedTouches);return e&(F|V)&&(n=E(n.concat(i),"identifier",!0)),[n,i]}.call(this,t,e);e&(F|V)&&n[0].length-n[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}}});var gt={touchstart:R,touchmove:D,touchend:F,touchcancel:V},yt="touchstart touchmove touchend touchcancel";function bt(){this.evTarget=yt,this.targetIds={},K.apply(this,arguments)}g(bt,K,{handler:function(t){var e=gt[t.type],n=function(t,e){var n=M(t.touches),i=this.targetIds;if(e&(R|D)&&1===n.length)return i[n[0].identifier]=!0,[n,n];var r,o,s=M(t.changedTouches),a=[],l=this.target;if(o=n.filter(function(t){return k(t.target,l)}),e===R)for(r=0;r<o.length;)i[o[r].identifier]=!0,r++;for(r=0;r<s.length;)i[s[r].identifier]&&a.push(s[r]),e&(F|V)&&delete i[s[r].identifier],r++;return a.length?[E(o.concat(a),"identifier",!0),a]:void 0}.call(this,t,e);n&&this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}});var wt=2500,xt=25;function At(){K.apply(this,arguments);var t=y(this.handler,this);this.touch=new bt(this.manager,t),this.mouse=new lt(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function kt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var n={x:e.clientX,y:e.clientY};this.lastTouches.push(n);var i=this.lastTouches;setTimeout(function(){var t=i.indexOf(n);t>-1&&i.splice(t,1)},wt)}}g(At,K,{handler:function(t,e,n){var i="touch"==n.pointerType,r="mouse"==n.pointerType;if(!(r&&n.sourceCapabilities&&n.sourceCapabilities.firesTouchEvents)){if(i)(function(t,e){t&R?(this.primaryTouch=e.changedPointers[0].identifier,kt.call(this,e)):t&(F|V)&&kt.call(this,e)}).call(this,e,n);else if(r&&function(t){for(var e=t.srcEvent.clientX,n=t.srcEvent.clientY,i=0;i<this.lastTouches.length;i++){var r=this.lastTouches[i],o=Math.abs(e-r.x),s=Math.abs(n-r.y);if(o<=xt&&s<=xt)return!0}return!1}.call(this,n))return;this.callback(t,e,n)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var Ct=z(a.style,"touchAction"),Tt=Ct!==r,St="auto",Mt="manipulation",Et="none",zt="pan-x",Ot="pan-y",Pt=function(){if(!Tt)return!1;var e={},n=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(i){e[i]=!n||t.CSS.supports("touch-action",i)}),e}();function jt(t,e){this.manager=t,this.set(e)}jt.prototype={set:function(t){"compute"==t&&(t=this.compute()),Tt&&this.manager.element.style&&Pt[t]&&(this.manager.element.style[Ct]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return p(this.manager.recognizers,function(e){b(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))}),function(t){if(C(t,Et))return Et;var e=C(t,zt),n=C(t,Ot);return e&&n?Et:e||n?e?zt:Ot:C(t,Mt)?Mt:St}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,n=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var i=this.actions,r=C(i,Et)&&!Pt[Et],o=C(i,Ot)&&!Pt[Ot],s=C(i,zt)&&!Pt[zt];if(r){var a=1===t.pointers.length,l=t.distance<2,c=t.deltaTime<250;if(a&&l&&c)return}if(!s||!o)return r||o&&n&W||s&&n&J?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var Nt=1,It=2,Bt=4,Rt=8,Dt=Rt,Ft=16;function Vt(t){this.options=o({},this.defaults,t||{}),this.id=O++,this.manager=null,this.options.enable=w(this.options.enable,!0),this.state=Nt,this.simultaneous={},this.requireFail=[]}function Lt(t){return t&Ft?"cancel":t&Rt?"end":t&Bt?"move":t&It?"start":""}function Ut(t){return t==Y?"down":t==H?"up":t==U?"left":t==G?"right":""}function Gt(t,e){var n=e.manager;return n?n.get(t):t}function Ht(){Vt.apply(this,arguments)}function Yt(){Ht.apply(this,arguments),this.pX=null,this.pY=null}function Wt(){Ht.apply(this,arguments)}function Jt(){Vt.apply(this,arguments),this._timer=null,this._input=null}function Xt(){Ht.apply(this,arguments)}function qt(){Ht.apply(this,arguments)}function Zt(){Vt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Kt(t,e){return(e=e||{}).recognizers=w(e.recognizers,Kt.defaults.preset),new Qt(t,e)}function Qt(t,e){var n;this.options=o({},Kt.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((n=this).options.inputClass||(N?dt:I?bt:j?At:lt))(n,Q),this.touchAction=new jt(this,this.options.touchAction),$t(this,!0),p(this.options.recognizers,function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}function $t(t,e){var n,i=t.element;i.style&&(p(t.options.cssProps,function(r,o){n=z(i.style,o),e?(t.oldCssProps[n]=i.style[n],i.style[n]=r):i.style[n]=t.oldCssProps[n]||""}),e||(t.oldCssProps={}))}Vt.prototype={defaults:{},set:function(t){return o(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(d(t,"recognizeWith",this))return this;var e=this.simultaneous;return t=Gt(t,this),e[t.id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return d(t,"dropRecognizeWith",this)?this:(t=Gt(t,this),delete this.simultaneous[t.id],this)},requireFailure:function(t){if(d(t,"requireFailure",this))return this;var e=this.requireFail;return t=Gt(t,this),-1===S(e,t)&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(d(t,"dropRequireFailure",this))return this;t=Gt(t,this);var e=S(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,n=this.state;function i(n){e.manager.emit(n,t)}n<Rt&&i(e.options.event+Lt(n)),i(e.options.event),t.additionalEvent&&i(t.additionalEvent),n>=Rt&&i(e.options.event+Lt(n))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(this.requireFail[t].state&(32|Nt)))return!1;t++}return!0},recognize:function(t){var e=o({},t);if(!b(this.options.enable,[this,e]))return this.reset(),void(this.state=32);this.state&(Dt|Ft|32)&&(this.state=Nt),this.state=this.process(e),this.state&(It|Bt|Rt|Ft)&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Ht,Vt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,n=t.eventType,i=e&(It|Bt),r=this.attrTest(t);return i&&(n&V||!r)?e|Ft:i||r?n&F?e|Rt:e&It?e|Bt:It:32}}),g(Yt,Ht,{defaults:{event:"pan",threshold:10,pointers:1,direction:X},getTouchAction:function(){var t=this.options.direction,e=[];return t&W&&e.push(Ot),t&J&&e.push(zt),e},directionTest:function(t){var e=this.options,n=!0,i=t.distance,r=t.direction,o=t.deltaX,s=t.deltaY;return r&e.direction||(e.direction&W?(r=0===o?L:o<0?U:G,n=o!=this.pX,i=Math.abs(t.deltaX)):(r=0===s?L:s<0?H:Y,n=s!=this.pY,i=Math.abs(t.deltaY))),t.direction=r,n&&i>e.threshold&&r&e.direction},attrTest:function(t){return Ht.prototype.attrTest.call(this,t)&&(this.state&It||!(this.state&It)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=Ut(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Wt,Ht,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[Et]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||this.state&It)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(Jt,Vt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[St]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!i||!n||t.eventType&(F|V)&&!r)this.reset();else if(t.eventType&R)this.reset(),this._timer=_(function(){this.state=Dt,this.tryEmit()},e.time,this);else if(t.eventType&F)return Dt;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){this.state===Dt&&(t&&t.eventType&F?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=u(),this.manager.emit(this.options.event,this._input)))}}),g(Xt,Ht,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[Et]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||this.state&It)}}),g(qt,Ht,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:W|J,pointers:1},getTouchAction:function(){return Yt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,n=this.options.direction;return n&(W|J)?e=t.overallVelocity:n&W?e=t.overallVelocityX:n&J&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&n&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&h(e)>this.options.velocity&&t.eventType&F},emit:function(t){var e=Ut(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Zt,Vt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Mt]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),t.eventType&R&&0===this.count)return this.failTimeout();if(i&&r&&n){if(t.eventType!=F)return this.failTimeout();var o=!this.pTime||t.timeStamp-this.pTime<e.interval,s=!this.pCenter||it(this.pCenter,t.center)<e.posThreshold;this.pTime=t.timeStamp,this.pCenter=t.center,s&&o?this.count+=1:this.count=1,this._input=t;var a=this.count%e.taps;if(0===a)return this.hasRequireFailures()?(this._timer=_(function(){this.state=Dt,this.tryEmit()},e.interval,this),It):Dt}return 32},failTimeout:function(){return this._timer=_(function(){this.state=32},this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){this.state==Dt&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Kt.VERSION="2.0.7",Kt.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[Xt,{enable:!1}],[Wt,{enable:!1},["rotate"]],[qt,{direction:W}],[Yt,{direction:W},["swipe"]],[Zt],[Zt,{event:"doubletap",taps:2},["tap"]],[Jt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},Qt.prototype={set:function(t){return o(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var n;this.touchAction.preventDefaults(t);var i=this.recognizers,r=e.curRecognizer;(!r||r&&r.state&Dt)&&(r=e.curRecognizer=null);for(var o=0;o<i.length;)n=i[o],2===e.stopped||r&&n!=r&&!n.canRecognizeWith(r)?n.reset():n.recognize(t),!r&&n.state&(It|Bt|Rt)&&(r=e.curRecognizer=n),o++}},get:function(t){if(t instanceof Vt)return t;for(var e=this.recognizers,n=0;n<e.length;n++)if(e[n].options.event==t)return e[n];return null},add:function(t){if(d(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(d(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,n=S(e,t);-1!==n&&(e.splice(n,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var n=this.handlers;return p(T(t),function(t){n[t]=n[t]||[],n[t].push(e)}),this}},off:function(t,e){if(t!==r){var n=this.handlers;return p(T(t),function(t){e?n[t]&&n[t].splice(S(n[t],e),1):delete n[t]}),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var i=n.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e,e.target.dispatchEvent(i)}(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<i.length;)i[r](e),r++}},destroy:function(){this.element&&$t(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},o(Kt,{INPUT_START:R,INPUT_MOVE:D,INPUT_END:F,INPUT_CANCEL:V,STATE_POSSIBLE:Nt,STATE_BEGAN:It,STATE_CHANGED:Bt,STATE_ENDED:Rt,STATE_RECOGNIZED:Dt,STATE_CANCELLED:Ft,STATE_FAILED:32,DIRECTION_NONE:L,DIRECTION_LEFT:U,DIRECTION_RIGHT:G,DIRECTION_UP:H,DIRECTION_DOWN:Y,DIRECTION_HORIZONTAL:W,DIRECTION_VERTICAL:J,DIRECTION_ALL:X,Manager:Qt,Input:K,TouchAction:jt,TouchInput:bt,MouseInput:lt,PointerEventInput:dt,TouchMouseInput:At,SingleTouchInput:vt,Recognizer:Vt,AttrRecognizer:Ht,Tap:Zt,Pan:Yt,Swipe:qt,Pinch:Wt,Rotate:Xt,Press:Jt,on:x,off:A,each:p,merge:v,extend:m,assign:o,inherit:g,bindFn:y,prefixed:z});var te=void 0!==t?t:"undefined"!=typeof self?self:{};te.Hammer=Kt,void 0!==e&&e.exports?e.exports=Kt:t.Hammer=Kt}(window,document)},function(t,e,n){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var i,r={},o=r,s="en-US",a=null,l="0,0";function c(t){this._value=t}function h(t){var e,n="";for(e=0;e<t;e++)n+="0";return n}function u(t,e,n,i){var r,o,s=Math.pow(10,e);return o=t.toFixed(0).search("e")>-1?function(t,e){var n,i,r,o,s;return s=t.toString(),n=s.split("e")[0],o=s.split("e")[1],i=n.split(".")[0],r=n.split(".")[1]||"",s=i+r+h(o-r.length),e>0&&(s+="."+h(e)),s}(t,e):(n(t*s)/s).toFixed(e),i&&(r=new RegExp("0{1,"+i+"}$"),o=o.replace(r,"")),o}function _(t,e,n){return e.indexOf("$")>-1?function(t,e,n){var i,o,a=e,l=a.indexOf("$"),c=a.indexOf("("),h=a.indexOf("+"),u=a.indexOf("-"),_="",p="";if(-1===a.indexOf("$")?"infix"===r[s].currency.position?(p=r[s].currency.symbol,r[s].currency.spaceSeparated&&(p=" "+p+" ")):r[s].currency.spaceSeparated&&(_=" "):a.indexOf(" $")>-1?(_=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(_=" ",a=a.replace("$ ","")):a=a.replace("$",""),o=d(t,a,n,p),-1===e.indexOf("$"))switch(r[s].currency.position){case"postfix":o.indexOf(")")>-1?((o=o.split("")).splice(-1,0,_+r[s].currency.symbol),o=o.join("")):o=o+_+r[s].currency.symbol;break;case"infix":break;case"prefix":o.indexOf("(")>-1||o.indexOf("-")>-1?(o=o.split(""),i=Math.max(c,u)+1,o.splice(i,0,r[s].currency.symbol+_),o=o.join("")):o=r[s].currency.symbol+_+o;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?o.indexOf("(")>-1||o.indexOf("+")>-1||o.indexOf("-")>-1?(o=o.split(""),i=1,(l<c||l<h||l<u)&&(i=0),o.splice(i,0,r[s].currency.symbol+_),o=o.join("")):o=r[s].currency.symbol+_+o:o.indexOf(")")>-1?((o=o.split("")).splice(-1,0,_+r[s].currency.symbol),o=o.join("")):o=o+_+r[s].currency.symbol;return o}(t,e,n):e.indexOf("%")>-1?function(t,e,n){var i,r="";return t*=100,e.indexOf(" %")>-1?(r=" ",e=e.replace(" %","")):e=e.replace("%",""),(i=d(t,e,n)).indexOf(")")>-1?((i=i.split("")).splice(-1,0,r+"%"),i=i.join("")):i=i+r+"%",i}(t,e,n):e.indexOf(":")>-1?function(t){var e=Math.floor(t/60/60),n=Math.floor((t-60*e*60)/60),i=Math.round(t-60*e*60-60*n);return e+":"+(n<10?"0"+n:n)+":"+(i<10?"0"+i:i)}(t):d(t,e,n)}function d(t,e,n,i){var o,l,c,h,_,d,p,f,m,v,g,y,b,w,x,A,k,C,T,S=!1,M=!1,E=!1,z="",O=!1,P=!1,j=!1,N=!1,I=!1,B="",R="",D=Math.abs(t),F=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],V=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],L="",U=!1,G=!1;if(0===t&&null!==a)return a;if(!isFinite(t))return""+t;if(0===e.indexOf("{")){var H=e.indexOf("}");if(-1===H)throw Error('Format should also contain a "}"');y=e.slice(1,H),e=e.slice(H+1)}else y="";if(e.indexOf("}")===e.length-1){var Y=e.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');b=e.slice(Y+1,-1),e=e.slice(0,Y+1)}else b="";if(T=-1===e.indexOf(".")?e.match(/([0-9]+).*/):e.match(/([0-9]+)\..*/),C=null===T?-1:T[1].length,-1!==e.indexOf("-")&&(U=!0),e.indexOf("(")>-1?(S=!0,e=e.slice(1,-1)):e.indexOf("+")>-1&&(M=!0,e=e.replace(/\+/g,"")),e.indexOf("a")>-1){if(v=e.split(".")[0].match(/[0-9]+/g)||["0"],v=parseInt(v[0],10),O=e.indexOf("aK")>=0,P=e.indexOf("aM")>=0,j=e.indexOf("aB")>=0,N=e.indexOf("aT")>=0,I=O||P||j||N,e.indexOf(" a")>-1?(z=" ",e=e.replace(" a","")):e=e.replace("a",""),_=Math.floor(Math.log(D)/Math.LN10)+1,p=0==(p=_%3)?3:p,v&&0!==D&&(d=Math.floor(Math.log(D)/Math.LN10)+1-v,f=3*~~((Math.min(v,_)-p)/3),D/=Math.pow(10,f),-1===e.indexOf(".")&&v>3))for(e+="[.]",A=(A=0===d?0:3*~~(d/3)-d)<0?A+3:A,o=0;o<A;o++)e+="0";Math.floor(Math.log(Math.abs(t))/Math.LN10)+1!==v&&(D>=Math.pow(10,12)&&!I||N?(z+=r[s].abbreviations.trillion,t/=Math.pow(10,12)):D<Math.pow(10,12)&&D>=Math.pow(10,9)&&!I||j?(z+=r[s].abbreviations.billion,t/=Math.pow(10,9)):D<Math.pow(10,9)&&D>=Math.pow(10,6)&&!I||P?(z+=r[s].abbreviations.million,t/=Math.pow(10,6)):(D<Math.pow(10,6)&&D>=Math.pow(10,3)&&!I||O)&&(z+=r[s].abbreviations.thousand,t/=Math.pow(10,3)))}if(e.indexOf("b")>-1)for(e.indexOf(" b")>-1?(B=" ",e=e.replace(" b","")):e=e.replace("b",""),h=0;h<=F.length;h++)if(l=Math.pow(1024,h),c=Math.pow(1024,h+1),t>=l&&t<c){B+=F[h],l>0&&(t/=l);break}if(e.indexOf("d")>-1)for(e.indexOf(" d")>-1?(B=" ",e=e.replace(" d","")):e=e.replace("d",""),h=0;h<=V.length;h++)if(l=Math.pow(1e3,h),c=Math.pow(1e3,h+1),t>=l&&t<c){B+=V[h],l>0&&(t/=l);break}if(e.indexOf("o")>-1&&(e.indexOf(" o")>-1?(R=" ",e=e.replace(" o","")):e=e.replace("o",""),r[s].ordinal&&(R+=r[s].ordinal(t))),e.indexOf("[.]")>-1&&(E=!0,e=e.replace("[.]",".")),m=t.toString().split(".")[0],g=e.split(".")[1],w=e.indexOf(","),g){if(-1!==g.indexOf("*")?L=u(t,t.toString().split(".")[1].length,n):g.indexOf("[")>-1?(g=(g=g.replace("]","")).split("["),L=u(t,g[0].length+g[1].length,n,g[1].length)):L=u(t,g.length,n),m=L.split(".")[0],L.split(".")[1].length){var W=i?z+i:r[s].delimiters.decimal;L=W+L.split(".")[1]}else L="";E&&0===Number(L.slice(1))&&(L="")}else m=u(t,null,n);return m.indexOf("-")>-1&&(m=m.slice(1),G=!0),m.length<C&&(m=new Array(C-m.length+1).join("0")+m),w>-1&&(m=m.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+r[s].delimiters.thousands)),0===e.indexOf(".")&&(m=""),x=e.indexOf("("),k=e.indexOf("-"),y+(x<k?(S&&G?"(":"")+(U&&G||!S&&G?"-":""):(U&&G||!S&&G?"-":"")+(S&&G?"(":""))+(!G&&M&&0!==t?"+":"")+m+L+(R||"")+(z&&!i?z:"")+(B||"")+(S&&G?")":"")+b}function p(t,e){r[t]=e}function f(t){s=t;var e=r[t].defaults;e&&e.format&&i.defaultFormat(e.format),e&&e.currencyFormat&&i.defaultCurrencyFormat(e.currencyFormat)}void 0!==e&&e.exports,(i=function(t){return i.isNumbro(t)?t=t.value():0===t||void 0===t?t=0:Number(t)||(t=i.fn.unformat(t)),new c(Number(t))}).version="1.6.2",i.isNumbro=function(t){return t instanceof c},i.setLanguage=function(t,e){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var n=t,i=t.split("-")[0],r=null;o[n]||(Object.keys(o).forEach(function(t){r||t.split("-")[0]!==i||(r=t)}),n=r||e||"en-US"),f(n)},i.setCulture=function(t,e){var n=t,i=t.split("-")[1],o=null;r[n]||(i&&Object.keys(r).forEach(function(t){o||t.split("-")[1]!==i||(o=t)}),n=o||e||"en-US"),f(n)},i.language=function(t,e){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!t)return s;if(t&&!e){if(!o[t])throw new Error("Unknown language : "+t);f(t)}return!e&&o[t]||p(t,e),i},i.culture=function(t,e){if(!t)return s;if(t&&!e){if(!r[t])throw new Error("Unknown culture : "+t);f(t)}return!e&&r[t]||p(t,e),i},i.languageData=function(t){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!t)return o[s];if(!o[t])throw new Error("Unknown language : "+t);return o[t]},i.cultureData=function(t){if(!t)return r[s];if(!r[t])throw new Error("Unknown culture : "+t);return r[t]},i.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(t){var e=t%10;return 1==~~(t%100/10)?"th":1===e?"st":2===e?"nd":3===e?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),i.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),o},i.cultures=function(){return r},i.zeroFormat=function(t){a="string"==typeof t?t:null},i.defaultFormat=function(t){l="string"==typeof t?t:"0.0"},i.defaultCurrencyFormat=function(t){},i.validate=function(t,e){var n,r,o,s,a,l,c,h;if("string"!=typeof t&&(t+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",t)),(t=t.trim()).match(/^\d+$/))return!0;if(""===t)return!1;try{c=i.cultureData(e)}catch(t){c=i.cultureData(i.culture())}return o=c.currency.symbol,a=c.abbreviations,n=c.delimiters.decimal,r="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,!(null!==(h=t.match(/^[^\d]+/))&&(t=t.substr(1),h[0]!==o)||null!==(h=t.match(/[^\d]+$/))&&(t=t.slice(0,-1),h[0]!==a.thousand&&h[0]!==a.million&&h[0]!==a.billion&&h[0]!==a.trillion)||(l=new RegExp(r+"{2}"),t.match(/[^\d.,]/g)||(s=t.split(n)).length>2||(s.length<2?!s[0].match(/^\d+.*\d$/)||s[0].match(l):1===s[0].length?!s[0].match(/^\d+$/)||s[0].match(l)||!s[1].match(/^\d+$/):!s[0].match(/^\d+.*\d$/)||s[0].match(l)||!s[1].match(/^\d+$/))))},e.exports={format:function(t,e,n,r){return null!=n&&n!==i.culture()&&i.setCulture(n),_(Number(t),null!=e?e:l,null==r?Math.round:r)}}},function(t,e,n){var i=t(412),r=t(410),o=t(414),s=t(409),a=t(400),l=t(405);function c(t,e){if(!(this instanceof c))return new c(t);e=e||function(t){if(t)throw t};var n=i(t);if("object"==typeof n){var o=c.projections.get(n.projName);if(o){if(n.datumCode&&"none"!==n.datumCode){var h=a[n.datumCode];h&&(n.datum_params=h.towgs84?h.towgs84.split(","):null,n.ellps=h.ellipse,n.datumName=h.datumName?h.datumName:n.datumCode)}n.k0=n.k0||1,n.axis=n.axis||"enu";var u=s.sphere(n.a,n.b,n.rf,n.ellps,n.sphere),_=s.eccentricity(u.a,u.b,u.rf,n.R_A),d=n.datum||l(n.datumCode,n.datum_params,u.a,u.b,_.es,_.ep2);r(this,n),r(this,o),this.a=u.a,this.b=u.b,this.rf=u.rf,this.sphere=u.sphere,this.es=_.es,this.e=_.e,this.ep2=_.ep2,this.datum=d,this.init(),e(null,this)}else e(t)}else e(t)}c.projections=o,c.projections.start(),e.exports=c},function(t,e,n){e.exports=function(t,e,n){var i,r,o,s=n.x,a=n.y,l=n.z||0,c={};for(o=0;o<3;o++)if(!e||2!==o||void 0!==n.z)switch(0===o?(i=s,r="x"):1===o?(i=a,r="y"):(i=l,r="z"),t.axis[o]){case"e":c[r]=i;break;case"w":c[r]=-i;break;case"n":c[r]=i;break;case"s":c[r]=-i;break;case"u":void 0!==n[r]&&(c.z=i);break;case"d":void 0!==n[r]&&(c.z=-i);break;default:return null}return c}},function(t,e,n){var i=2*Math.PI,r=t(397);e.exports=function(t){return Math.abs(t)<=3.14159265359?t:t-r(t)*i}},function(t,e,n){e.exports=function(t,e,n){var i=t*e;return n/Math.sqrt(1-i*i)}},function(t,e,n){var i=Math.PI/2;e.exports=function(t,e){for(var n,r,o=.5*t,s=i-2*Math.atan(e),a=0;a<=15;a++)if(n=t*Math.sin(s),r=i-2*Math.atan(e*Math.pow((1-n)/(1+n),o))-s,s+=r,Math.abs(r)<=1e-10)return s;return-9999}},function(t,e,n){e.exports=function(t){return t<0?-1:1}},function(t,e,n){e.exports=function(t){var e={x:t[0],y:t[1]};return t.length>2&&(e.z=t[2]),t.length>3&&(e.m=t[3]),e}},function(t,e,n){var i=Math.PI/2;e.exports=function(t,e,n){var r=t*n,o=.5*t;return r=Math.pow((1-r)/(1+r),o),Math.tan(.5*(i-e))/r}},function(t,e,n){n.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},n.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},n.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},n.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},n.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},n.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},n.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},n.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},n.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},n.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},n.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},n.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},n.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},n.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},n.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},n.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},function(t,e,n){n.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},n.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},n.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},n.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},n.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},n.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},n.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},n.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},n.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},n.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},n.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},n.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},n.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},n.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},n.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},n.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},n.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},n.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},n.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},n.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},n.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},n.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},n.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},n.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},n.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},n.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},n.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},n.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},n.hough={a:6378270,rf:297,ellipseName:"Hough"},n.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},n.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},n.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},n.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},n.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},n.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},n.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},n.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},n.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},n.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},n.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},n.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},n.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},n.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},function(t,e,n){n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},function(t,e,n){n.ft={to_meter:.3048},n["us-ft"]={to_meter:1200/3937}},function(t,e,n){var i=t(392),r=t(417),o=i("WGS84");function s(t,e,n){var i;return Array.isArray(n)?(i=r(t,e,n),3===n.length?[i.x,i.y,i.z]:[i.x,i.y]):r(t,e,n)}function a(t){return t instanceof i?t:t.oProj?t.oProj:i(t)}e.exports=function(t,e,n){t=a(t);var i,r=!1;return void 0===e?(e=t,t=o,r=!0):(void 0!==e.x||Array.isArray(e))&&(n=e,e=t,t=o,r=!0),e=a(e),n?s(t,e,n):(i={forward:function(n){return s(t,e,n)},inverse:function(n){return s(e,t,n)}},r&&(i.oProj=e),i)}},function(t,e,n){var i=1,r=2,o=4,s=5,a=484813681109536e-20;e.exports=function(t,e,n,l,c,h){var u={};return u.datum_type=o,t&&"none"===t&&(u.datum_type=s),e&&(u.datum_params=e.map(parseFloat),0===u.datum_params[0]&&0===u.datum_params[1]&&0===u.datum_params[2]||(u.datum_type=i),u.datum_params.length>3&&(0===u.datum_params[3]&&0===u.datum_params[4]&&0===u.datum_params[5]&&0===u.datum_params[6]||(u.datum_type=r,u.datum_params[3]*=a,u.datum_params[4]*=a,u.datum_params[5]*=a,u.datum_params[6]=u.datum_params[6]/1e6+1))),u.a=n,u.b=l,u.es=c,u.ep2=h,u}},function(t,e,n){var i=Math.PI/2;n.compareDatums=function(t,e){return t.datum_type===e.datum_type&&!(t.a!==e.a||Math.abs(this.es-e.es)>5e-11)&&(1===t.datum_type?this.datum_params[0]===e.datum_params[0]&&t.datum_params[1]===e.datum_params[1]&&t.datum_params[2]===e.datum_params[2]:2!==t.datum_type||t.datum_params[0]===e.datum_params[0]&&t.datum_params[1]===e.datum_params[1]&&t.datum_params[2]===e.datum_params[2]&&t.datum_params[3]===e.datum_params[3]&&t.datum_params[4]===e.datum_params[4]&&t.datum_params[5]===e.datum_params[5]&&t.datum_params[6]===e.datum_params[6])},n.geodeticToGeocentric=function(t,e,n){var r,o,s,a,l=t.x,c=t.y,h=t.z?t.z:0;if(c<-i&&c>-1.001*i)c=-i;else if(c>i&&c<1.001*i)c=i;else if(c<-i||c>i)return null;return l>Math.PI&&(l-=2*Math.PI),o=Math.sin(c),a=Math.cos(c),s=o*o,{x:((r=n/Math.sqrt(1-e*s))+h)*a*Math.cos(l),y:(r+h)*a*Math.sin(l),z:(r*(1-e)+h)*o}},n.geocentricToGeodetic=function(t,e,n,r){var o,s,a,l,c,h,u,_,d,p,f,m,v,g,y,b,w=t.x,x=t.y,A=t.z?t.z:0;if(o=Math.sqrt(w*w+x*x),s=Math.sqrt(w*w+x*x+A*A),o/n<1e-12){if(g=0,s/n<1e-12)return y=i,b=-r,{x:t.x,y:t.y,z:t.z}}else g=Math.atan2(x,w);a=A/s,l=o/s,c=1/Math.sqrt(1-e*(2-e)*l*l),_=l*(1-e)*c,d=a*c,v=0;do{v++,u=n/Math.sqrt(1-e*d*d),h=e*u/(u+(b=o*_+A*d-u*(1-e*d*d))),c=1/Math.sqrt(1-h*(2-h)*l*l),m=(f=a*c)*_-(p=l*(1-h)*c)*d,_=p,d=f}while(m*m>1e-24&&v<30);return y=Math.atan(f/Math.abs(p)),{x:g,y:y,z:b}},n.geocentricToWgs84=function(t,e,n){if(1===e)return{x:t.x+n[0],y:t.y+n[1],z:t.z+n[2]};if(2===e){var i=n[0],r=n[1],o=n[2],s=n[3],a=n[4],l=n[5],c=n[6];return{x:c*(t.x-l*t.y+a*t.z)+i,y:c*(l*t.x+t.y-s*t.z)+r,z:c*(-a*t.x+s*t.y+t.z)+o}}},n.geocentricFromWgs84=function(t,e,n){if(1===e)return{x:t.x-n[0],y:t.y-n[1],z:t.z-n[2]};if(2===e){var i=n[0],r=n[1],o=n[2],s=n[3],a=n[4],l=n[5],c=n[6],h=(t.x-i)/c,u=(t.y-r)/c,_=(t.z-o)/c;return{x:h+l*u-a*_,y:-l*h+u+s*_,z:a*h-s*u+_}}}},function(t,e,n){var i=1,r=2,o=t(406);function s(t){return t===i||t===r}e.exports=function(t,e,n){return o.compareDatums(t,e)?n:5===t.datum_type||5===e.datum_type?n:t.es!==e.es||t.a!==e.a||s(t.datum_type)||s(e.datum_type)?(n=o.geodeticToGeocentric(n,t.es,t.a),s(t.datum_type)&&(n=o.geocentricToWgs84(n,t.datum_type,t.datum_params)),s(e.datum_type)&&(n=o.geocentricFromWgs84(n,e.datum_type,e.datum_params)),o.geocentricToGeodetic(n,e.es,e.a,e.b)):n}},function(t,e,n){var i=t(411),r=t(413),o=t(418);function s(t){var e=this;if(2===arguments.length){var n=arguments[1];"string"==typeof n?"+"===n.charAt(0)?s[t]=r(arguments[1]):s[t]=o(arguments[1]):s[t]=n}else if(1===arguments.length){if(Array.isArray(t))return t.map(function(t){Array.isArray(t)?s.apply(e,t):s(t)});if("string"==typeof t){if(t in s)return s[t]}else"EPSG"in t?s["EPSG:"+t.EPSG]=t:"ESRI"in t?s["ESRI:"+t.ESRI]=t:"IAU2000"in t?s["IAU2000:"+t.IAU2000]=t:console.log(t);return}}i(s),e.exports=s},function(t,e,n){var i=t(401);n.eccentricity=function(t,e,n,i){var r=t*t,o=e*e,s=(r-o)/r,a=0;i?(r=(t*=1-s*(.16666666666666666+s*(.04722222222222222+.022156084656084655*s)))*t,s=0):a=Math.sqrt(s);var l=(r-o)/o;return{es:s,e:a,ep2:l}},n.sphere=function(t,e,n,r,o){if(!t){var s=i[r];s||(s=i.WGS84),t=s.a,e=s.b,n=s.rf}return n&&!e&&(e=(1-1/n)*t),(0===n||Math.abs(t-e)<1e-10)&&(o=!0,e=t),{a:t,b:e,rf:n,sphere:o}}},function(t,e,n){e.exports=function(t,e){var n,i;if(t=t||{},!e)return t;for(i in e)void 0!==(n=e[i])&&(t[i]=n);return t}},function(t,e,n){e.exports=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},function(t,e,n){var i=t(408),r=t(418),o=t(413),s=["GEOGCS","GEOCCS","PROJCS","LOCAL_CS"];e.exports=function(t){return function(t){return"string"==typeof t}(t)?function(t){return t in i}(t)?i[t]:function(t){return s.some(function(e){return t.indexOf(e)>-1})}(t)?r(t):function(t){return"+"===t[0]}(t)?o(t):void 0:t}},function(t,e,n){var i=.017453292519943295,r=t(402),o=t(403);e.exports=function(t){var e,n,s,a={},l=t.split("+").map(function(t){return t.trim()}).filter(function(t){return t}).reduce(function(t,e){var n=e.split("=");return n.push(!0),t[n[0].toLowerCase()]=n[1],t},{}),c={proj:"projName",datum:"datumCode",rf:function(t){a.rf=parseFloat(t)},lat_0:function(t){a.lat0=t*i},lat_1:function(t){a.lat1=t*i},lat_2:function(t){a.lat2=t*i},lat_ts:function(t){a.lat_ts=t*i},lon_0:function(t){a.long0=t*i},lon_1:function(t){a.long1=t*i},lon_2:function(t){a.long2=t*i},alpha:function(t){a.alpha=parseFloat(t)*i},lonc:function(t){a.longc=t*i},x_0:function(t){a.x0=parseFloat(t)},y_0:function(t){a.y0=parseFloat(t)},k_0:function(t){a.k0=parseFloat(t)},k:function(t){a.k0=parseFloat(t)},a:function(t){a.a=parseFloat(t)},b:function(t){a.b=parseFloat(t)},r_a:function(){a.R_A=!0},zone:function(t){a.zone=parseInt(t,10)},south:function(){a.utmSouth=!0},towgs84:function(t){a.datum_params=t.split(",").map(function(t){return parseFloat(t)})},to_meter:function(t){a.to_meter=parseFloat(t)},units:function(t){a.units=t,o[t]&&(a.to_meter=o[t].to_meter)},from_greenwich:function(t){a.from_greenwich=t*i},pm:function(t){a.from_greenwich=(r[t]?r[t]:parseFloat(t))*i},nadgrids:function(t){"@null"===t?a.datumCode="none":a.nadgrids=t},axis:function(t){3===t.length&&-1!=="ewnsud".indexOf(t.substr(0,1))&&-1!=="ewnsud".indexOf(t.substr(1,1))&&-1!=="ewnsud".indexOf(t.substr(2,1))&&(a.axis=t)}};for(e in l)n=l[e],e in c?"function"==typeof(s=c[e])?s(n):a[s]=n:a[e]=n;return"string"==typeof a.datumCode&&"WGS84"!==a.datumCode&&(a.datumCode=a.datumCode.toLowerCase()),a}},function(t,e,n){var i=[t(416),t(415)],r={},o=[];function s(t,e){var n=o.length;return t.names?(o[n]=t,t.names.forEach(function(t){r[t.toLowerCase()]=n}),this):(console.log(e),!0)}n.add=s,n.get=function(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==r[e]&&o[r[e]]?o[r[e]]:void 0},n.start=function(){i.forEach(s)}},function(t,e,n){function i(t){return t}n.init=function(){},n.forward=i,n.inverse=i,n.names=["longlat","identity"]},function(t,e,n){var i=t(395),r=Math.PI/2,o=57.29577951308232,s=t(394),a=Math.PI/4,l=t(399),c=t(396);n.init=function(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=i(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)},n.forward=function(t){var e,n,i=t.x,c=t.y;if(c*o>90&&c*o<-90&&i*o>180&&i*o<-180)return null;if(Math.abs(Math.abs(c)-r)<=1e-10)return null;if(this.sphere)e=this.x0+this.a*this.k0*s(i-this.long0),n=this.y0+this.a*this.k0*Math.log(Math.tan(a+.5*c));else{var h=Math.sin(c),u=l(this.e,c,h);e=this.x0+this.a*this.k0*s(i-this.long0),n=this.y0-this.a*this.k0*Math.log(u)}return t.x=e,t.y=n,t},n.inverse=function(t){var e,n,i=t.x-this.x0,o=t.y-this.y0;if(this.sphere)n=r-2*Math.atan(Math.exp(-o/(this.a*this.k0)));else{var a=Math.exp(-o/(this.a*this.k0));if(-9999===(n=c(this.e,a)))return null}return e=s(this.long0+i/(this.a*this.k0)),t.x=e,t.y=n,t},n.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"]},function(t,e,n){var i=.017453292519943295,r=57.29577951308232,o=1,s=2,a=t(407),l=t(393),c=t(392),h=t(398);e.exports=function t(e,n,u){var _;return Array.isArray(u)&&(u=h(u)),e.datum&&n.datum&&function(t,e){return(t.datum.datum_type===o||t.datum.datum_type===s)&&"WGS84"!==e.datumCode||(e.datum.datum_type===o||e.datum.datum_type===s)&&"WGS84"!==t.datumCode}(e,n)&&(_=new c("WGS84"),u=t(e,_,u),e=_),"enu"!==e.axis&&(u=l(e,!1,u)),"longlat"===e.projName?u={x:u.x*i,y:u.y*i}:(e.to_meter&&(u={x:u.x*e.to_meter,y:u.y*e.to_meter}),u=e.inverse(u)),e.from_greenwich&&(u.x+=e.from_greenwich),u=a(e.datum,n.datum,u),n.from_greenwich&&(u={x:u.x-n.grom_greenwich,y:u.y}),"longlat"===n.projName?u={x:u.x*r,y:u.y*r}:(u=n.forward(u),n.to_meter&&(u={x:u.x/n.to_meter,y:u.y/n.to_meter})),"enu"!==n.axis?l(n,!0,u):u}},function(t,e,n){var i=.017453292519943295,r=t(410);function o(t,e,n){t[e]=n.map(function(t){var e={};return s(t,e),e}).reduce(function(t,e){return r(t,e)},{})}function s(t,e){var n;Array.isArray(t)?("PARAMETER"===(n=t.shift())&&(n=t.shift()),1===t.length?Array.isArray(t[0])?(e[n]={},s(t[0],e[n])):e[n]=t[0]:t.length?"TOWGS84"===n?e[n]=t:(e[n]={},["UNIT","PRIMEM","VERT_DATUM"].indexOf(n)>-1?(e[n]={name:t[0].toLowerCase(),convert:t[1]},3===t.length&&(e[n].auth=t[2])):"SPHEROID"===n?(e[n]={name:t[0],a:t[1],rf:t[2]},4===t.length&&(e[n].auth=t[3])):["GEOGCS","GEOCCS","DATUM","VERT_CS","COMPD_CS","LOCAL_CS","FITTED_CS","LOCAL_DATUM"].indexOf(n)>-1?(t[0]=["name",t[0]],o(e,n,t)):t.every(function(t){return Array.isArray(t)})?o(e,n,t):s(t,e[n])):e[n]=!0):e[t]=!0}function a(t){return t*i}e.exports=function(t,e){var n=JSON.parse((","+t).replace(/\s*\,\s*([A-Z_0-9]+?)(\[)/g,',["$1",').slice(1).replace(/\s*\,\s*([A-Z_0-9]+?)\]/g,',"$1"]').replace(/,\["VERTCS".+/,"")),i=n.shift(),o=n.shift();n.unshift(["name",o]),n.unshift(["type",i]),n.unshift("output");var l={};return s(n,l),function(t){function e(e){var n=t.to_meter||1;return parseFloat(e,10)*n}"GEOGCS"===t.type?t.projName="longlat":"LOCAL_CS"===t.type?(t.projName="identity",t.local=!0):"object"==typeof t.PROJECTION?t.projName=Object.keys(t.PROJECTION)[0]:t.projName=t.PROJECTION,t.UNIT&&(t.units=t.UNIT.name.toLowerCase(),"metre"===t.units&&(t.units="meter"),t.UNIT.convert&&("GEOGCS"===t.type?t.DATUM&&t.DATUM.SPHEROID&&(t.to_meter=parseFloat(t.UNIT.convert,10)*t.DATUM.SPHEROID.a):t.to_meter=parseFloat(t.UNIT.convert,10))),t.GEOGCS&&(t.GEOGCS.DATUM?t.datumCode=t.GEOGCS.DATUM.name.toLowerCase():t.datumCode=t.GEOGCS.name.toLowerCase(),"d_"===t.datumCode.slice(0,2)&&(t.datumCode=t.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==t.datumCode&&"new_zealand_1949"!==t.datumCode||(t.datumCode="nzgd49"),"wgs_1984"===t.datumCode&&("Mercator_Auxiliary_Sphere"===t.PROJECTION&&(t.sphere=!0),t.datumCode="wgs84"),"_ferro"===t.datumCode.slice(-6)&&(t.datumCode=t.datumCode.slice(0,-6)),"_jakarta"===t.datumCode.slice(-8)&&(t.datumCode=t.datumCode.slice(0,-8)),~t.datumCode.indexOf("belge")&&(t.datumCode="rnb72"),t.GEOGCS.DATUM&&t.GEOGCS.DATUM.SPHEROID&&(t.ellps=t.GEOGCS.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===t.ellps.toLowerCase().slice(0,13)&&(t.ellps="intl"),t.a=t.GEOGCS.DATUM.SPHEROID.a,t.rf=parseFloat(t.GEOGCS.DATUM.SPHEROID.rf,10)),~t.datumCode.indexOf("osgb_1936")&&(t.datumCode="osgb36")),t.b&&!isFinite(t.b)&&(t.b=t.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",a],["longitude_of_center","Longitude_Of_Center"],["longc","longitude_of_center",a],["x0","false_easting",e],["y0","false_northing",e],["long0","central_meridian",a],["lat0","latitude_of_origin",a],["lat0","standard_parallel_1",a],["lat1","standard_parallel_1",a],["lat2","standard_parallel_2",a],["alpha","azimuth",a],["srsCode","name"]].forEach(function(e){return n=t,r=(i=e)[0],o=i[1],void(!(r in n)&&o in n&&(n[r]=n[o],3===i.length&&(n[r]=i[2](n[r]))));var n,i,r,o}),t.long0||!t.longc||"Albers_Conic_Equal_Area"!==t.projName&&"Lambert_Azimuthal_Equal_Area"!==t.projName||(t.long0=t.longc),t.lat_ts||!t.lat1||"Stereographic_South_Pole"!==t.projName&&"Polar Stereographic (variant B)"!==t.projName||(t.lat0=a(t.lat1>0?90:-90),t.lat_ts=t.lat1)}(l.output),r(e,l.output)}},function(t,e,n){!function(){"use strict";var t={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function e(n){return function(n,i){var r,o,s,a,l,c,h,u,_,d=1,p=n.length,f="";for(o=0;o<p;o++)if("string"==typeof n[o])f+=n[o];else if("object"==typeof n[o]){if((a=n[o]).keys)for(r=i[d],s=0;s<a.keys.length;s++){if(null==r)throw new Error(e('[sprintf] Cannot access property "%s" of undefined value "%s"',a.keys[s],a.keys[s-1]));r=r[a.keys[s]]}else r=a.param_no?i[a.param_no]:i[d++];if(t.not_type.test(a.type)&&t.not_primitive.test(a.type)&&r instanceof Function&&(r=r()),t.numeric_arg.test(a.type)&&"number"!=typeof r&&isNaN(r))throw new TypeError(e("[sprintf] expecting number but found %T",r));switch(t.number.test(a.type)&&(u=r>=0),a.type){case"b":r=parseInt(r,10).toString(2);break;case"c":r=String.fromCharCode(parseInt(r,10));break;case"d":case"i":r=parseInt(r,10);break;case"j":r=JSON.stringify(r,null,a.width?parseInt(a.width):0);break;case"e":r=a.precision?parseFloat(r).toExponential(a.precision):parseFloat(r).toExponential();break;case"f":r=a.precision?parseFloat(r).toFixed(a.precision):parseFloat(r);break;case"g":r=a.precision?String(Number(r.toPrecision(a.precision))):parseFloat(r);break;case"o":r=(parseInt(r,10)>>>0).toString(8);break;case"s":r=String(r),r=a.precision?r.substring(0,a.precision):r;break;case"t":r=String(!!r),r=a.precision?r.substring(0,a.precision):r;break;case"T":r=Object.prototype.toString.call(r).slice(8,-1).toLowerCase(),r=a.precision?r.substring(0,a.precision):r;break;case"u":r=parseInt(r,10)>>>0;break;case"v":r=r.valueOf(),r=a.precision?r.substring(0,a.precision):r;break;case"x":r=(parseInt(r,10)>>>0).toString(16);break;case"X":r=(parseInt(r,10)>>>0).toString(16).toUpperCase()}t.json.test(a.type)?f+=r:(!t.number.test(a.type)||u&&!a.sign?_="":(_=u?"+":"-",r=r.toString().replace(t.sign,"")),c=a.pad_char?"0"===a.pad_char?"0":a.pad_char.charAt(1):" ",h=a.width-(_+r).length,l=a.width&&h>0?c.repeat(h):"",f+=a.align?_+r+l:"0"===c?_+l+r:l+_+r)}return f}(function(e){if(r[e])return r[e];for(var n,i=e,o=[],s=0;i;){if(null!==(n=t.text.exec(i)))o.push(n[0]);else if(null!==(n=t.modulo.exec(i)))o.push("%");else{if(null===(n=t.placeholder.exec(i)))throw new SyntaxError("[sprintf] unexpected placeholder");if(n[2]){s|=1;var a=[],l=n[2],c=[];if(null===(c=t.key.exec(l)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(a.push(c[1]);""!==(l=l.substring(c[0].length));)if(null!==(c=t.key_access.exec(l)))a.push(c[1]);else{if(null===(c=t.index_access.exec(l)))throw new SyntaxError("[sprintf] failed to parse named argument key");a.push(c[1])}n[2]=a}else s|=2;if(3===s)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");o.push({placeholder:n[0],param_no:n[1],keys:n[2],sign:n[3],pad_char:n[4],align:n[5],width:n[6],precision:n[7],type:n[8]})}i=i.substring(n[0].length)}return r[e]=o}(n),arguments)}function i(t,n){return e.apply(null,[t].concat(n||[]))}var r=Object.create(null);void 0!==n&&(n.sprintf=e,n.vsprintf=i),"undefined"!=typeof window&&(window.sprintf=e,window.vsprintf=i)}()},function(t,e,n){!function(t){"object"==typeof e&&e.exports?e.exports=t():this.tz=t()}(function(){function t(t,e,n){var i,r=e.day[1];do{i=new Date(Date.UTC(n,e.month,Math.abs(r++)))}while(e.day[0]<7&&i.getUTCDay()!=e.day[0]);return(i={clock:e.clock,sort:i.getTime(),rule:e,save:6e4*e.save,offset:t.offset})[i.clock]=i.sort+6e4*e.time,i.posix?i.wallclock=i[i.clock]+(t.offset+e.saved):i.posix=i[i.clock]-(t.offset+e.saved),i}function e(e,n,i){var r,o,s,a,l,c,h,u=e[e.zone],_=[],d=new Date(i).getUTCFullYear(),p=1;for(r=1,o=u.length;r<o&&!(u[r][n]<=i);r++);if((s=u[r]).rules){for(c=e[s.rules],h=d+1;h>=d-p;--h)for(r=0,o=c.length;r<o;r++)c[r].from<=h&&h<=c[r].to?_.push(t(s,c[r],h)):c[r].to<h&&1==p&&(p=h-c[r].to);for(_.sort(function(t,e){return t.sort-e.sort}),r=0,o=_.length;r<o;r++)i>=_[r][n]&&_[r][_[r].clock]>s[_[r].clock]&&(a=_[r])}return a&&((l=/^(.*)\/(.*)$/.exec(s.format))?a.abbrev=l[a.save?2:1]:a.abbrev=s.format.replace(/%s/,a.rule.letter)),a||s}function n(t,n){return"UTC"==t.zone?n:(t.entry=e(t,"posix",n),n+t.entry.offset+t.entry.save)}function i(t,n){return"UTC"==t.zone?n:(t.entry=i=e(t,"wallclock",n),0<(r=n-i.wallclock)&&r<i.save?null:n-i.offset-i.save);var i,r}function r(t,e,r){var o,a=+(r[1]+1),c=r[2]*a,h=s.indexOf(r[3].toLowerCase());if(h>9)e+=c*l[h-10];else{if(o=new Date(n(t,e)),h<7)for(;c;)o.setUTCDate(o.getUTCDate()+a),o.getUTCDay()==h&&(c-=a);else 7==h?o.setUTCFullYear(o.getUTCFullYear()+c):8==h?o.setUTCMonth(o.getUTCMonth()+c):o.setUTCDate(o.getUTCDate()+c);null==(e=i(t,o.getTime()))&&(e=i(t,o.getTime()+864e5*a)-864e5*a)}return e}var o={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(t,e,n,i){var r,o,s=this.entry.offset+this.entry.save,a=Math.abs(s/1e3),l=[],c=3600;for(r=0;r<3;r++)l.push(("0"+Math.floor(a/c)).slice(-2)),a%=c,c/=60;return"^"!=n||s?("^"==n&&(i=3),3==i?(o=(o=l.join(":")).replace(/:00$/,""),"^"!=n&&(o=o.replace(/:00$/,""))):i?(o=l.slice(0,i+1).join(":"),"^"==n&&(o=o.replace(/:00$/,""))):o=l.slice(0,2).join(""),o=(o=(s<0?"-":"+")+o).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(t){return"%"},n:function(t){return"\n"},t:function(t){return"\t"},U:function(t){return c(t,0)},W:function(t){return c(t,1)},V:function(t){return h(t)[0]},G:function(t){return h(t)[1]},g:function(t){return h(t)[1]%100},j:function(t){return Math.floor((t.getTime()-Date.UTC(t.getUTCFullYear(),0))/864e5)+1},s:function(t){return Math.floor(t.getTime()/1e3)},C:function(t){return Math.floor(t.getUTCFullYear()/100)},N:function(t){return t.getTime()%1e3*1e6},m:function(t){return t.getUTCMonth()+1},Y:function(t){return t.getUTCFullYear()},y:function(t){return t.getUTCFullYear()%100},H:function(t){return t.getUTCHours()},M:function(t){return t.getUTCMinutes()},S:function(t){return t.getUTCSeconds()},e:function(t){return t.getUTCDate()},d:function(t){return t.getUTCDate()},u:function(t){return t.getUTCDay()||7},w:function(t){return t.getUTCDay()},l:function(t){return t.getUTCHours()%12||12},I:function(t){return t.getUTCHours()%12||12},k:function(t){return t.getUTCHours()},Z:function(t){return this.entry.abbrev},a:function(t){return this[this.locale].day.abbrev[t.getUTCDay()]},A:function(t){return this[this.locale].day.full[t.getUTCDay()]},h:function(t){return this[this.locale].month.abbrev[t.getUTCMonth()]},b:function(t){return this[this.locale].month.abbrev[t.getUTCMonth()]},B:function(t){return this[this.locale].month.full[t.getUTCMonth()]},P:function(t){return this[this.locale].meridiem[Math.floor(t.getUTCHours()/12)].toLowerCase()},p:function(t){return this[this.locale].meridiem[Math.floor(t.getUTCHours()/12)]},R:function(t,e){return this.convert([e,"%H:%M"])},T:function(t,e){return this.convert([e,"%H:%M:%S"])},D:function(t,e){return this.convert([e,"%m/%d/%y"])},F:function(t,e){return this.convert([e,"%Y-%m-%d"])},x:function(t,e){return this.convert([e,this[this.locale].date])},r:function(t,e){return this.convert([e,this[this.locale].time12||"%I:%M:%S"])},X:function(t,e){return this.convert([e,this[this.locale].time24])},c:function(t,e){return this.convert([e,this[this.locale].dateTime])},convert:function(t){if(!t.length)return"1.0.22";var e,o,s,l,c,h=Object.create(this),u=[];for(e=0;e<t.length;e++)if(l=t[e],Array.isArray(l))e||isNaN(l[1])?l.splice.apply(t,[e--,1].concat(l)):c=l;else if(isNaN(l)){if("string"==(s=typeof l))~l.indexOf("%")?h.format=l:e||"*"!=l?!e&&(s=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((c=[]).push.apply(c,s.slice(1,8)),s[9]?(c.push(s[10]+1),c.push.apply(c,s[11].split(/:/))):s[8]&&c.push(1)):/^\w{2,3}_\w{2}$/.test(l)?h.locale=l:(s=a.exec(l))?u.push(s):h.zone=l:c=l;else if("function"==s){if(s=l.call(h))return s}else if(/^\w{2,3}_\w{2}$/.test(l.name))h[l.name]=l;else if(l.zones){for(s in l.zones)h[s]=l.zones[s];for(s in l.rules)h[s]=l.rules[s]}}else e||(c=l);if(h[h.locale]||delete h.locale,h[h.zone]||delete h.zone,null!=c){if("*"==c)c=h.clock();else if(Array.isArray(c)){for(s=[],o=!c[7],e=0;e<11;e++)s[e]=+(c[e]||0);--s[1],c=Date.UTC.apply(Date.UTC,s)+-s[7]*(36e5*s[8]+6e4*s[9]+1e3*s[10])}else c=Math.floor(c);if(!isNaN(c)){if(o&&(c=i(h,c)),null==c)return c;for(e=0,o=u.length;e<o;e++)c=r(h,c,u[e]);return h.format?(s=new Date(n(h,c)),h.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,function(t,e,n,i,r){var o,a,l="0";if(o=h[r]){for(t=String(o.call(h,s,c,e,n.length)),"_"==(e||o.style)&&(l=" "),a="-"==e?0:o.pad||0;t.length<a;)t=l+t;for(a="-"==e?0:i||o.pad;t.length<a;)t=l+t;"N"==r&&a<t.length&&(t=t.slice(0,a)),"^"==e&&(t=t.toUpperCase())}return t})):c}}return function(){return h.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},s="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",a=new RegExp("^\\s*([+-])(\\d+)\\s+("+s+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function c(t,e){var n,i,r;return i=new Date(Date.UTC(t.getUTCFullYear(),0)),n=Math.floor((t.getTime()-i.getTime())/864e5),i.getUTCDay()==e?r=0:8==(r=7-i.getUTCDay()+e)&&(r=1),n>=r?Math.floor((n-r)/7)+1:0}function h(t){var e,n,i;return n=t.getUTCFullYear(),e=new Date(Date.UTC(n,0)).getUTCDay(),(i=c(t,1)+(e>1&&e<=4?1:0))?53!=i||4==e||3==e&&29==new Date(n,1,29).getDate()?[i,t.getUTCFullYear()]:[1,t.getUTCFullYear()+1]:(n=t.getUTCFullYear()-1,e=new Date(Date.UTC(n,0)).getUTCDay(),[i=4==e||3==e&&29==new Date(n,1,29).getDate()?53:52,t.getUTCFullYear()-1])}return s=s.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,function(t){o[t].pad=2}),o.N.pad=9,o.j.pad=3,o.k.style="_",o.l.style="_",o.e.style="_",function(){return o.convert(arguments)}})},function(t,e,n){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0
    
    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.
    
    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
var i,r,o,s,a,l,c,h,u,_,d,p,f,m,v,g,y,b,w;!function(t){var n="object"==typeof global?global:"object"==typeof self?self:"object"==typeof this?this:{};function i(t,e){return t!==n&&("function"==typeof Object.create?Object.defineProperty(t,"__esModule",{value:!0}):t.__esModule=!0),function(n,i){return t[n]=e?e(n,i):i}}"object"==typeof e&&"object"==typeof e.exports?t(i(n,i(e.exports))):t(i(n))}(function(t){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])};i=function(t,n){function i(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(i.prototype=n.prototype,new i)},r=Object.assign||function(t){for(var e,n=1,i=arguments.length;n<i;n++)for(var r in e=arguments[n])Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r]);return t},o=function(t,e){var n={};for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&e.indexOf(i)<0&&(n[i]=t[i]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols)for(var r=0,i=Object.getOwnPropertySymbols(t);r<i.length;r++)e.indexOf(i[r])<0&&(n[i[r]]=t[i[r]]);return n},s=function(t,e,n,i){var r,o=arguments.length,s=o<3?e:null===i?i=Object.getOwnPropertyDescriptor(e,n):i;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(t,e,n,i);else for(var a=t.length-1;a>=0;a--)(r=t[a])&&(s=(o<3?r(s):o>3?r(e,n,s):r(e,n))||s);return o>3&&s&&Object.defineProperty(e,n,s),s},a=function(t,e){return function(n,i){e(n,i,t)}},l=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},c=function(t,e,n,i){return new(n||(n=Promise))(function(r,o){function s(t){try{l(i.next(t))}catch(t){o(t)}}function a(t){try{l(i.throw(t))}catch(t){o(t)}}function l(t){t.done?r(t.value):new n(function(e){e(t.value)}).then(s,a)}l((i=i.apply(t,e||[])).next())})},h=function(t,e){var n,i,r,o,s={label:0,sent:function(){if(1&r[0])throw r[1];return r[1]},trys:[],ops:[]};return o={next:a(0),throw:a(1),return:a(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function a(o){return function(a){return function(o){if(n)throw new TypeError("Generator is already executing.");for(;s;)try{if(n=1,i&&(r=2&o[0]?i.return:o[0]?i.throw||((r=i.return)&&r.call(i),0):i.next)&&!(r=r.call(i,o[1])).done)return r;switch(i=0,r&&(o=[2&o[0],r.value]),o[0]){case 0:case 1:r=o;break;case 4:return s.label++,{value:o[1],done:!1};case 5:s.label++,i=o[1],o=[0];continue;case 7:o=s.ops.pop(),s.trys.pop();continue;default:if(!(r=(r=s.trys).length>0&&r[r.length-1])&&(6===o[0]||2===o[0])){s=0;continue}if(3===o[0]&&(!r||o[1]>r[0]&&o[1]<r[3])){s.label=o[1];break}if(6===o[0]&&s.label<r[1]){s.label=r[1],r=o;break}if(r&&s.label<r[2]){s.label=r[2],s.ops.push(o);break}r[2]&&s.ops.pop(),s.trys.pop();continue}o=e.call(t,s)}catch(t){o=[6,t],i=0}finally{n=r=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,a])}}},u=function(t,e){for(var n in t)e.hasOwnProperty(n)||(e[n]=t[n])},_=function(t){var e="function"==typeof Symbol&&t[Symbol.iterator],n=0;return e?e.call(t):{next:function(){return t&&n>=t.length&&(t=void 0),{value:t&&t[n++],done:!t}}}},d=function(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var i,r,o=n.call(t),s=[];try{for(;(void 0===e||e-- >0)&&!(i=o.next()).done;)s.push(i.value)}catch(t){r={error:t}}finally{try{i&&!i.done&&(n=o.return)&&n.call(o)}finally{if(r)throw r.error}}return s},p=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(d(arguments[e]));return t},f=function(t){return this instanceof f?(this.v=t,this):new f(t)},m=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var i,r=n.apply(t,e||[]),o=[];return i={},s("next"),s("throw"),s("return"),i[Symbol.asyncIterator]=function(){return this},i;function s(t){r[t]&&(i[t]=function(e){return new Promise(function(n,i){o.push([t,e,n,i])>1||a(t,e)})})}function a(t,e){try{(n=r[t](e)).value instanceof f?Promise.resolve(n.value.v).then(l,c):h(o[0][2],n)}catch(t){h(o[0][3],t)}var n}function l(t){a("next",t)}function c(t){a("throw",t)}function h(t,e){t(e),o.shift(),o.length&&a(o[0][0],o[0][1])}},v=function(t){var e,n;return e={},i("next"),i("throw",function(t){throw t}),i("return"),e[Symbol.iterator]=function(){return this},e;function i(i,r){e[i]=t[i]?function(e){return(n=!n)?{value:f(t[i](e)),done:"return"===i}:r?r(e):e}:r}},g=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=_(t),e={},i("next"),i("throw"),i("return"),e[Symbol.asyncIterator]=function(){return this},e);function i(n){e[n]=t[n]&&function(e){return new Promise(function(i,r){e=t[n](e),function(t,e,n,i){Promise.resolve(i).then(function(e){t({value:e,done:n})},e)}(i,r,e.done,e.value)})}}},y=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t},b=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)Object.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e.default=t,e},w=function(t){return t&&t.__esModule?t:{default:t}},t("__extends",i),t("__assign",r),t("__rest",o),t("__decorate",s),t("__param",a),t("__metadata",l),t("__awaiter",c),t("__generator",h),t("__exportStar",u),t("__values",_),t("__read",d),t("__spread",p),t("__await",f),t("__asyncGenerator",m),t("__asyncDelegator",v),t("__asyncValues",g),t("__makeTemplateObject",y),t("__importStar",b),t("__importDefault",w)})}],i={base:0,"client/connection":1,"client/session":2,"core/bokeh_events":3,"core/build_views":4,"core/dom":5,"core/dom_view":6,"core/enums":7,"core/has_props":8,"core/hittest":9,"core/layout/alignments":10,"core/layout/grid":11,"core/layout/html":12,"core/layout/index":13,"core/layout/layoutable":14,"core/layout/side_panel":15,"core/layout/types":16,"core/logging":17,"core/properties":18,"core/property_mixins":19,"core/selection_manager":20,"core/settings":21,"core/signaling":22,"core/ui_events":23,"core/util/array":24,"core/util/arrayable":25,"core/util/assert":26,"core/util/bbox":27,"core/util/callback":28,"core/util/canvas":29,"core/util/color":30,"core/util/compat":31,"core/util/data_structures":32,"core/util/eq":33,"core/util/math":34,"core/util/object":35,"core/util/projections":36,"core/util/refs":37,"core/util/serialization":38,"core/util/spatial":39,"core/util/string":40,"core/util/svg_colors":41,"core/util/templating":42,"core/util/text":43,"core/util/throttle":44,"core/util/typed_array":45,"core/util/types":46,"core/util/wheel":47,"core/util/zoom":48,"core/vectorization":49,"core/view":50,"core/visuals":51,"document/document":52,"document/events":53,"document/index":54,"embed/dom":55,"embed/index":56,"embed/notebook":57,"embed/server":58,"embed/standalone":59,index:60,main:61,model:62,"models/annotations/annotation":63,"models/annotations/arrow":64,"models/annotations/arrow_head":65,"models/annotations/band":66,"models/annotations/box_annotation":67,"models/annotations/color_bar":68,"models/annotations/index":69,"models/annotations/label":70,"models/annotations/label_set":71,"models/annotations/legend":72,"models/annotations/legend_item":73,"models/annotations/poly_annotation":74,"models/annotations/slope":75,"models/annotations/span":76,"models/annotations/text_annotation":77,"models/annotations/title":78,"models/annotations/toolbar_panel":79,"models/annotations/tooltip":80,"models/annotations/whisker":81,"models/axes/axis":82,"models/axes/categorical_axis":83,"models/axes/continuous_axis":84,"models/axes/datetime_axis":85,"models/axes/index":86,"models/axes/linear_axis":87,"models/axes/log_axis":88,"models/axes/mercator_axis":89,"models/callbacks/callback":90,"models/callbacks/customjs":91,"models/callbacks/index":92,"models/callbacks/open_url":93,"models/canvas/canvas":94,"models/canvas/cartesian_frame":95,"models/canvas/index":96,"models/expressions/cumsum":97,"models/expressions/expression":98,"models/expressions/index":99,"models/expressions/stack":100,"models/filters/boolean_filter":101,"models/filters/customjs_filter":102,"models/filters/filter":103,"models/filters/group_filter":104,"models/filters/index":105,"models/filters/index_filter":106,"models/formatters/basic_tick_formatter":107,"models/formatters/categorical_tick_formatter":108,"models/formatters/datetime_tick_formatter":109,"models/formatters/func_tick_formatter":110,"models/formatters/index":111,"models/formatters/log_tick_formatter":112,"models/formatters/mercator_tick_formatter":113,"models/formatters/numeral_tick_formatter":114,"models/formatters/printf_tick_formatter":115,"models/formatters/tick_formatter":116,"models/glyphs/annular_wedge":117,"models/glyphs/annulus":118,"models/glyphs/arc":119,"models/glyphs/area":120,"models/glyphs/bezier":121,"models/glyphs/box":122,"models/glyphs/center_rotatable":123,"models/glyphs/circle":124,"models/glyphs/ellipse":125,"models/glyphs/ellipse_oval":126,"models/glyphs/glyph":127,"models/glyphs/harea":128,"models/glyphs/hbar":129,"models/glyphs/hex_tile":130,"models/glyphs/image":131,"models/glyphs/image_base":132,"models/glyphs/image_rgba":133,"models/glyphs/image_url":134,"models/glyphs/index":135,"models/glyphs/line":136,"models/glyphs/multi_line":137,"models/glyphs/multi_polygons":138,"models/glyphs/oval":139,"models/glyphs/patch":140,"models/glyphs/patches":141,"models/glyphs/quad":142,"models/glyphs/quadratic":143,"models/glyphs/ray":144,"models/glyphs/rect":145,"models/glyphs/segment":146,"models/glyphs/step":147,"models/glyphs/text":148,"models/glyphs/utils":149,"models/glyphs/varea":150,"models/glyphs/vbar":151,"models/glyphs/wedge":152,"models/glyphs/xy_glyph":153,"models/graphs/graph_hit_test_policy":154,"models/graphs/index":155,"models/graphs/layout_provider":156,"models/graphs/static_layout_provider":157,"models/grids/grid":158,"models/grids/index":159,"models/index":160,"models/layouts/box":161,"models/layouts/column":162,"models/layouts/grid_box":163,"models/layouts/html_box":164,"models/layouts/index":165,"models/layouts/layout_dom":166,"models/layouts/row":167,"models/layouts/spacer":168,"models/layouts/tabs":169,"models/layouts/widget_box":170,"models/mappers/categorical_color_mapper":171,"models/mappers/categorical_mapper":172,"models/mappers/categorical_marker_mapper":173,"models/mappers/categorical_pattern_mapper":174,"models/mappers/color_mapper":175,"models/mappers/continuous_color_mapper":176,"models/mappers/index":177,"models/mappers/linear_color_mapper":178,"models/mappers/log_color_mapper":179,"models/mappers/mapper":180,"models/markers/defs":181,"models/markers/index":182,"models/markers/marker":183,"models/markers/scatter":184,"models/plots/gmap_plot":185,"models/plots/gmap_plot_canvas":186,"models/plots/index":187,"models/plots/plot":188,"models/plots/plot_canvas":189,"models/ranges/data_range":190,"models/ranges/data_range1d":191,"models/ranges/factor_range":192,"models/ranges/index":193,"models/ranges/range":194,"models/ranges/range1d":195,"models/renderers/data_renderer":196,"models/renderers/glyph_renderer":197,"models/renderers/graph_renderer":198,"models/renderers/guide_renderer":199,"models/renderers/index":200,"models/renderers/renderer":201,"models/scales/categorical_scale":202,"models/scales/index":203,"models/scales/linear_scale":204,"models/scales/log_scale":205,"models/scales/scale":206,"models/selections/index":207,"models/selections/interaction_policy":208,"models/selections/selection":209,"models/sources/ajax_data_source":210,"models/sources/cds_view":211,"models/sources/column_data_source":212,"models/sources/columnar_data_source":213,"models/sources/data_source":214,"models/sources/geojson_data_source":215,"models/sources/index":216,"models/sources/remote_data_source":217,"models/sources/server_sent_data_source":218,"models/sources/web_data_source":219,"models/textures/canvas_texture":220,"models/textures/image_url_texture":221,"models/textures/index":222,"models/textures/texture":223,"models/tickers/adaptive_ticker":224,"models/tickers/basic_ticker":225,"models/tickers/categorical_ticker":226,"models/tickers/composite_ticker":227,"models/tickers/continuous_ticker":228,"models/tickers/datetime_ticker":229,"models/tickers/days_ticker":230,"models/tickers/fixed_ticker":231,"models/tickers/index":232,"models/tickers/log_ticker":233,"models/tickers/mercator_ticker":234,"models/tickers/months_ticker":235,"models/tickers/single_interval_ticker":236,"models/tickers/ticker":237,"models/tickers/util":238,"models/tickers/years_ticker":239,"models/tiles/bbox_tile_source":240,"models/tiles/image_pool":241,"models/tiles/index":242,"models/tiles/mercator_tile_source":243,"models/tiles/quadkey_tile_source":244,"models/tiles/tile_renderer":245,"models/tiles/tile_source":246,"models/tiles/tile_utils":247,"models/tiles/tms_tile_source":248,"models/tiles/wmts_tile_source":249,"models/tools/actions/action_tool":250,"models/tools/actions/custom_action":251,"models/tools/actions/help_tool":252,"models/tools/actions/redo_tool":253,"models/tools/actions/reset_tool":254,"models/tools/actions/save_tool":255,"models/tools/actions/undo_tool":256,"models/tools/actions/zoom_in_tool":257,"models/tools/actions/zoom_out_tool":258,"models/tools/button_tool":259,"models/tools/edit/box_edit_tool":260,"models/tools/edit/edit_tool":261,"models/tools/edit/freehand_draw_tool":262,"models/tools/edit/point_draw_tool":263,"models/tools/edit/poly_draw_tool":264,"models/tools/edit/poly_edit_tool":265,"models/tools/edit/poly_tool":266,"models/tools/gestures/box_select_tool":267,"models/tools/gestures/box_zoom_tool":268,"models/tools/gestures/gesture_tool":269,"models/tools/gestures/lasso_select_tool":270,"models/tools/gestures/pan_tool":271,"models/tools/gestures/poly_select_tool":272,"models/tools/gestures/range_tool":273,"models/tools/gestures/select_tool":274,"models/tools/gestures/tap_tool":275,"models/tools/gestures/wheel_pan_tool":276,"models/tools/gestures/wheel_zoom_tool":277,"models/tools/index":278,"models/tools/inspectors/crosshair_tool":279,"models/tools/inspectors/customjs_hover":280,"models/tools/inspectors/hover_tool":281,"models/tools/inspectors/inspect_tool":282,"models/tools/on_off_button":283,"models/tools/tool":284,"models/tools/tool_proxy":285,"models/tools/toolbar":286,"models/tools/toolbar_base":287,"models/tools/toolbar_box":288,"models/tools/util":289,"models/transforms/customjs_transform":290,"models/transforms/dodge":291,"models/transforms/index":292,"models/transforms/interpolator":293,"models/transforms/jitter":294,"models/transforms/linear_interpolator":295,"models/transforms/step_interpolator":296,"models/transforms/transform":297,polyfill:298,"protocol/index":299,"protocol/message":300,"protocol/receiver":301,safely:302,"styles/annotations":303,"styles/buttons":304,"styles/canvas":305,"styles/icons":306,"styles/logo":307,"styles/menus":308,"styles/mixins":309,"styles/notebook":310,"styles/root":311,"styles/tabs":312,"styles/tiles":313,"styles/toolbar":314,"styles/tooltips":315,testing:316,version:317},r={},(s=(o=function(t){var e=r[t];if(!e){var s=function(t){if("number"==typeof t)return t;if("bokehjs"===t)return 61;"@bokehjs/"===t.slice(0,"@bokehjs/".length)&&(t=t.slice("@bokehjs/".length));var e=i[t];if(null!=e)return e;var n=t.length>0&&"/"===t[t.lenght-1],r=i[t+(n?"":"/")+"index"];return null!=r?r:t}(t);if(e=r[s])r[t]=e;else{if(!n[s]){var a=new Error("Cannot find module '"+t+"'");throw a.code="MODULE_NOT_FOUND",a}e={exports:{}},r[s]=e,r[t]=e,n[s].call(e.exports,o,e,e.exports)}}return e.exports})(61)).require=o,s.register_plugin=function(t,e,r){for(var a in t)n[a]=t[a];for(var a in e)i[a]=e[a];var l=o(r);for(var a in l)s[a]=l[a];return l},s)}(this);
//# sourceMappingURL=bokeh.min.js.map