/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(t,e){var i,n,r,o,s;t.Bokeh=(i=[function(t,e,i){var n=t(160),r=t(35);i.overrides={};var o=r.clone(n);i.Models=function(t){var e=i.overrides[t]||o[t];if(null==e)throw new Error("Model '"+t+"' does not exist. This could be due to a widget\n                     or a custom model not being registered before first usage.");return e},i.Models.register=function(t,e){i.overrides[t]=e},i.Models.unregister=function(t){delete i.overrides[t]},i.Models.register_models=function(t,e,i){if(void 0===e&&(e=!1),null!=t)for(var n in t){var r=t[n];e||!o.hasOwnProperty(n)?o[n]=r:null!=i?i(n):console.warn("Model '"+n+"' was already registered")}},i.register_models=i.Models.register_models,i.Models.registered_names=function(){return Object.keys(o)}},function(t,e,i){var n=t(17),r=t(54),o=t(300),s=t(301),a=t(2);i.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",i.DEFAULT_SESSION_ID="default";var l=0,h=function(){function t(t,e,r,o,a){void 0===t&&(t=i.DEFAULT_SERVER_WEBSOCKET_URL),void 0===e&&(e=i.DEFAULT_SESSION_ID),void 0===r&&(r=null),void 0===o&&(o=null),void 0===a&&(a=null),this.url=t,this.id=e,this.args_string=r,this._on_have_session_hook=o,this._on_closed_permanently_hook=a,this._number=l++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_ack=null,this._pending_replies={},this._receiver=new s.Receiver,n.logger.debug("Creating websocket "+this._number+" to '"+this.url+"' session '"+this.id+"'")}return t.prototype.connect=function(){var t=this;if(this.closed_permanently)return Promise.reject(new Error("Cannot connect() a closed ClientConnection"));if(null!=this.socket)return Promise.reject(new Error("Already connected"));this._pending_replies={},this._current_handler=null;try{var e=this.url+"?bokeh-protocol-version=1.0&bokeh-session-id="+this.id;return null!=this.args_string&&this.args_string.length>0&&(e+="&"+this.args_string),this.socket=new WebSocket(e),new Promise(function(e,i){t.socket.binaryType="arraybuffer",t.socket.onopen=function(){return t._on_open(e,i)},t.socket.onmessage=function(e){return t._on_message(e)},t.socket.onclose=function(e){return t._on_close(e)},t.socket.onerror=function(){return t._on_error(i)}})}catch(t){return n.logger.error("websocket creation failed to url: "+this.url),n.logger.error(" - "+t),Promise.reject(t)}},t.prototype.close=function(){this.closed_permanently||(n.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed(),null!=this._on_closed_permanently_hook&&(this._on_closed_permanently_hook(),this._on_closed_permanently_hook=null))},t.prototype._schedule_reconnect=function(t){var e=this;setTimeout(function(){e.closed_permanently||n.logger.info("Websocket connection "+e._number+" disconnected, will not attempt to reconnect")},t)},t.prototype.send=function(t){if(null==this.socket)throw new Error("not connected so cannot send "+t);t.send(this.socket)},t.prototype.send_with_reply=function(t){var e=this,i=new Promise(function(i,n){e._pending_replies[t.msgid()]=[i,n],e.send(t)});return i.then(function(t){if("ERROR"===t.msgtype())throw new Error("Error reply "+t.content.text);return t},function(t){throw t})},t.prototype._pull_doc_json=function(){var t=o.Message.create("PULL-DOC-REQ",{}),e=this.send_with_reply(t);return e.then(function(t){if(!("doc"in t.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return t.content.doc},function(t){throw t})},t.prototype._repull_session_doc=function(){var t=this;null==this.session?n.logger.debug("Pulling session for first time"):n.logger.debug("Repulling session"),this._pull_doc_json().then(function(e){if(null==t.session)if(t.closed_permanently)n.logger.debug("Got new document after connection was already closed");else{var i=r.Document.from_json(e),s=r.Document._compute_patch_since_json(e,i);if(s.events.length>0){n.logger.debug("Sending "+s.events.length+" changes from model construction back to server");var l=o.Message.create("PATCH-DOC",{},s);t.send(l)}t.session=new a.ClientSession(t,i,t.id),n.logger.debug("Created a new session from new pulled doc"),null!=t._on_have_session_hook&&(t._on_have_session_hook(t.session),t._on_have_session_hook=null)}else t.session.document.replace_with_json(e),n.logger.debug("Updated existing session with new pulled doc")},function(t){throw t}).catch(function(t){null!=console.trace&&console.trace(t),n.logger.error("Failed to repull session "+t)})},t.prototype._on_open=function(t,e){var i=this;n.logger.info("Websocket connection "+this._number+" is now open"),this._pending_ack=[t,e],this._current_handler=function(t){i._awaiting_ack_handler(t)}},t.prototype._on_message=function(t){null==this._current_handler&&n.logger.error("Got a message with no current handler set");try{this._receiver.consume(t.data)}catch(t){this._close_bad_protocol(t.toString())}if(null!=this._receiver.message){var e=this._receiver.message,i=e.problem();null!=i&&this._close_bad_protocol(i),this._current_handler(e)}},t.prototype._on_close=function(t){var e=this;n.logger.info("Lost websocket "+this._number+" connection, "+t.code+" ("+t.reason+")"),this.socket=null,null!=this._pending_ack&&(this._pending_ack[1](new Error("Lost websocket connection, "+t.code+" ("+t.reason+")")),this._pending_ack=null);for(var i=function(){for(var t in e._pending_replies){var i=e._pending_replies[t];return delete e._pending_replies[t],i}return null},r=i();null!=r;)r[1]("Disconnected"),r=i();this.closed_permanently||this._schedule_reconnect(2e3)},t.prototype._on_error=function(t){n.logger.debug("Websocket error on socket "+this._number),t(new Error("Could not open websocket"))},t.prototype._close_bad_protocol=function(t){n.logger.error("Closing connection: "+t),null!=this.socket&&this.socket.close(1002,t)},t.prototype._awaiting_ack_handler=function(t){var e=this;"ACK"===t.msgtype()?(this._current_handler=function(t){return e._steady_state_handler(t)},this._repull_session_doc(),null!=this._pending_ack&&(this._pending_ack[0](this),this._pending_ack=null)):this._close_bad_protocol("First message was not an ACK")},t.prototype._steady_state_handler=function(t){if(t.reqid()in this._pending_replies){var e=this._pending_replies[t.reqid()];delete this._pending_replies[t.reqid()],e[0](t)}else this.session.handle(t)},t}();i.ClientConnection=h,i.pull_session=function(t,e,i){return new Promise(function(r,o){var s=new h(t,e,i,function(t){try{r(t)}catch(e){throw n.logger.error("Promise handler threw an error, closing session "+e),t.close(),e}},function(){o(new Error("Connection was closed before we successfully pulled a session"))});s.connect().then(function(t){},function(t){throw n.logger.error("Failed to connect to Bokeh server "+t),t})})}},function(t,e,i){var n=t(54),r=t(300),o=t(17),s=function(){function t(t,e,i){var n=this;this._connection=t,this.document=e,this.id=i,this._document_listener=function(t){return n._document_changed(t)},this.document.on_change(this._document_listener),this.event_manager=this.document.event_manager,this.event_manager.session=this}return t.prototype.handle=function(t){var e=t.msgtype();"PATCH-DOC"===e?this._handle_patch(t):"OK"===e?this._handle_ok(t):"ERROR"===e?this._handle_error(t):o.logger.debug("Doing nothing with message "+t.msgtype())},t.prototype.close=function(){this._connection.close()},t.prototype.send_event=function(t){var e=r.Message.create("EVENT",{},JSON.stringify(t.to_json()));this._connection.send(e)},t.prototype._connection_closed=function(){this.document.remove_on_change(this._document_listener)},t.prototype.request_server_info=function(){var t=r.Message.create("SERVER-INFO-REQ",{}),e=this._connection.send_with_reply(t);return e.then(function(t){return t.content})},t.prototype.force_roundtrip=function(){return this.request_server_info().then(function(t){})},t.prototype._document_changed=function(t){if(t.setter_id!==this.id&&(!(t instanceof n.ModelChangedEvent)||t.attr in t.model.serializable_attributes())){var e=r.Message.create("PATCH-DOC",{},this.document.create_json_patch([t]));this._connection.send(e)}},t.prototype._handle_patch=function(t){this.document.apply_json_patch(t.content,t.buffers,this.id)},t.prototype._handle_ok=function(t){o.logger.trace("Unhandled OK reply to "+t.reqid())},t.prototype._handle_error=function(t){o.logger.error("Unhandled ERROR reply to "+t.reqid()+": "+t.content.text)},t}();i.ClientSession=s},function(t,e,i){var n=t(408);function r(t){return function(e){e.prototype.event_name=t}}var o=function(){function t(){}return t.prototype.to_json=function(){var t=this.event_name;return{event_name:t,event_values:this._to_json()}},t.prototype._to_json=function(){var t=this.origin;return{model_id:null!=t?t.id:null}},t}();i.BokehEvent=o;var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("button_click")],e)}(o);i.ButtonClick=s;var a=function(t){function e(e){var i=t.call(this)||this;return i.item=e,i}return n.__extends(e,t),e.prototype._to_json=function(){var e=this.item;return n.__assign({},t.prototype._to_json.call(this),{item:e})},e=n.__decorate([r("menu_item_click")],e)}(o);i.MenuItemClick=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(o);i.UIEvent=l;var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("lodstart")],e)}(l);i.LODStart=h;var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("lodend")],e)}(l);i.LODEnd=u;var c=function(t){function e(e,i){var n=t.call(this)||this;return n.geometry=e,n.final=i,n}return n.__extends(e,t),e.prototype._to_json=function(){var e=this.geometry,i=this.final;return n.__assign({},t.prototype._to_json.call(this),{geometry:e,final:i})},e=n.__decorate([r("selectiongeometry")],e)}(l);i.SelectionGeometry=c;var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("reset")],e)}(l);i.Reset=_;var p=function(t){function e(e,i,n,r){var o=t.call(this)||this;return o.sx=e,o.sy=i,o.x=n,o.y=r,o}return n.__extends(e,t),e.prototype._to_json=function(){var e=this.sx,i=this.sy,r=this.x,o=this.y;return n.__assign({},t.prototype._to_json.call(this),{sx:e,sy:i,x:r,y:o})},e}(l);i.PointEvent=p;var d=function(t){function e(e,i,n,r,o,s){var a=t.call(this,e,i,n,r)||this;return a.sx=e,a.sy=i,a.x=n,a.y=r,a.delta_x=o,a.delta_y=s,a}return n.__extends(e,t),e.prototype._to_json=function(){var e=this.delta_x,i=this.delta_y;return n.__assign({},t.prototype._to_json.call(this),{delta_x:e,delta_y:i})},e=n.__decorate([r("pan")],e)}(p);i.Pan=d;var f=function(t){function e(e,i,n,r,o){var s=t.call(this,e,i,n,r)||this;return s.sx=e,s.sy=i,s.x=n,s.y=r,s.scale=o,s}return n.__extends(e,t),e.prototype._to_json=function(){var e=this.scale;return n.__assign({},t.prototype._to_json.call(this),{scale:e})},e=n.__decorate([r("pinch")],e)}(p);i.Pinch=f;var v=function(t){function e(e,i,n,r,o){var s=t.call(this,e,i,n,r)||this;return s.sx=e,s.sy=i,s.x=n,s.y=r,s.delta=o,s}return n.__extends(e,t),e.prototype._to_json=function(){var e=this.delta;return n.__assign({},t.prototype._to_json.call(this),{delta:e})},e=n.__decorate([r("wheel")],e)}(p);i.MouseWheel=v;var m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("mousemove")],e)}(p);i.MouseMove=m;var g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("mouseenter")],e)}(p);i.MouseEnter=g;var y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("mouseleave")],e)}(p);i.MouseLeave=y;var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("tap")],e)}(p);i.Tap=b;var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("doubletap")],e)}(p);i.DoubleTap=x;var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("press")],e)}(p);i.Press=w;var k=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("panstart")],e)}(p);i.PanStart=k;var T=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("panend")],e)}(p);i.PanEnd=T;var C=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("pinchstart")],e)}(p);i.PinchStart=C;var S=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([r("pinchend")],e)}(p);i.PinchEnd=S},function(t,e,i){var n=t(408),r=t(24);i.build_views=function(t,e,i,o){void 0===o&&(o=function(t){return t.default_view});for(var s=r.difference(Object.keys(t),e.map(function(t){return t.id})),a=0,l=s;a<l.length;a++){var h=l[a];t[h].remove(),delete t[h]}for(var u=[],c=e.filter(function(e){return null==t[e.id]}),_=0,p=c;_<p.length;_++){var d=p[_],f=o(d),v=n.__assign({},i,{model:d,connect_signals:!1}),m=new f(v);t[d.id]=m,u.push(m)}for(var g=0,y=u;g<y.length;g++){var m=y[g];m.connect_signals()}return u},i.remove_views=function(t){for(var e in t)t[e].remove(),delete t[e]}},function(t,e,i){var n=t(46),r=function(t){return function(e){void 0===e&&(e={});for(var i=[],r=1;r<arguments.length;r++)i[r-1]=arguments[r];var o=document.createElement(t);for(var s in o.classList.add("bk"),e){var a=e[s];if(null!=a&&(!n.isBoolean(a)||a))if("class"===s&&(n.isString(a)&&(a=a.split(/\s+/)),n.isArray(a)))for(var l=0,h=a;l<h.length;l++){var u=h[l];null!=u&&o.classList.add(u)}else if("style"===s&&n.isPlainObject(a))for(var c in a)o.style[c]=a[c];else if("data"===s&&n.isPlainObject(a))for(var _ in a)o.dataset[_]=a[_];else o.setAttribute(s,a)}function p(t){if(t instanceof HTMLElement)o.appendChild(t);else if(n.isString(t))o.appendChild(document.createTextNode(t));else if(null!=t&&!1!==t)throw new Error("expected an HTMLElement, string, false or null, got "+JSON.stringify(t))}for(var d=0,f=i;d<f.length;d++){var v=f[d];if(n.isArray(v))for(var m=0,g=v;m<g.length;m++){var y=g[m];p(y)}else p(v)}return o}};function o(t,e){var i=Element.prototype,n=i.matches||i.webkitMatchesSelector||i.mozMatchesSelector||i.msMatchesSelector;return n.call(t,e)}function s(t){return parseFloat(t)||0}function a(t){var e=getComputedStyle(t);return{border:{top:s(e.borderTopWidth),bottom:s(e.borderBottomWidth),left:s(e.borderLeftWidth),right:s(e.borderRightWidth)},margin:{top:s(e.marginTop),bottom:s(e.marginBottom),left:s(e.marginLeft),right:s(e.marginRight)},padding:{top:s(e.paddingTop),bottom:s(e.paddingBottom),left:s(e.paddingLeft),right:s(e.paddingRight)}}}function l(t){var e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}function h(t){return Array.from(t.children)}i.createElement=function(t,e){for(var i=[],n=2;n<arguments.length;n++)i[n-2]=arguments[n];return r(t).apply(void 0,[e].concat(i))},i.div=r("div"),i.span=r("span"),i.canvas=r("canvas"),i.link=r("link"),i.style=r("style"),i.a=r("a"),i.p=r("p"),i.i=r("i"),i.pre=r("pre"),i.button=r("button"),i.label=r("label"),i.input=r("input"),i.select=r("select"),i.option=r("option"),i.optgroup=r("optgroup"),i.textarea=r("textarea"),i.nbsp=function(){return document.createTextNode(" ")},i.removeElement=function(t){var e=t.parentNode;null!=e&&e.removeChild(t)},i.replaceWith=function(t,e){var i=t.parentNode;null!=i&&i.replaceChild(e,t)},i.prepend=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];for(var n=t.firstChild,r=0,o=e;r<o.length;r++){var s=o[r];t.insertBefore(s,n)}},i.empty=function(t){for(var e;e=t.firstChild;)t.removeChild(e)},i.display=function(t){t.style.display=""},i.undisplay=function(t){t.style.display="none"},i.show=function(t){t.style.visibility=""},i.hide=function(t){t.style.visibility="hidden"},i.offset=function(t){var e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},i.matches=o,i.parent=function(t,e){for(var i=t;i=i.parentElement;)if(o(i,e))return i;return null},i.extents=a,i.size=l,i.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},i.outer_size=function(t){var e=a(t).margin,i=e.left,n=e.right,r=e.top,o=e.bottom,s=l(t),h=s.width,u=s.height;return{width:Math.ceil(h+i+n),height:Math.ceil(u+r+o)}},i.content_size=function(t){for(var e=t.getBoundingClientRect(),i=e.left,n=e.top,r=a(t).padding,o=0,s=0,l=0,u=h(t);l<u.length;l++){var c=u[l],_=c.getBoundingClientRect();o=Math.max(o,Math.ceil(_.left-i-r.left+_.width)),s=Math.max(s,Math.ceil(_.top-n-r.top+_.height))}return{width:o,height:s}},i.position=function(t,e,i){var n=t.style;if(n.left=e.left+"px",n.top=e.top+"px",n.width=e.width+"px",n.height=e.height+"px",null==i)n.margin="";else{var r=i.top,o=i.right,s=i.bottom,a=i.left;n.margin=r+"px "+o+"px "+s+"px "+a+"px"}},i.children=h;var u=function(){function t(t){this.el=t,this.classList=t.classList}return Object.defineProperty(t.prototype,"values",{get:function(){for(var t=[],e=0;e<this.classList.length;e++){var i=this.classList.item(e);null!=i&&t.push(i)}return t},enumerable:!0,configurable:!0}),t.prototype.has=function(t){return this.classList.contains(t)},t.prototype.add=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];for(var i=0,n=t;i<n.length;i++){var r=n[i];this.classList.add(r)}return this},t.prototype.remove=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];for(var i=0,n=t;i<n.length;i++){var r=n[i];this.classList.remove(r)}return this},t.prototype.clear=function(){for(var t=0,e=this.values;t<e.length;t++){var i=e[t];"bk"!=i&&this.classList.remove(i)}return this},t.prototype.toggle=function(t,e){var i=null!=e?e:!this.has(t);return i?this.add(t):this.remove(t),this},t}();function c(t,e,i){var n=t.style,r=n.width,o=n.height,s=n.position,a=n.display;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return i()}finally{t.style.position=s,t.style.display=a,t.style.width=r,t.style.height=o}}i.ClassList=u,i.classes=function(t){return new u(t)},function(t){t[t.Backspace=8]="Backspace",t[t.Tab=9]="Tab",t[t.Enter=13]="Enter",t[t.Esc=27]="Esc",t[t.PageUp=33]="PageUp",t[t.PageDown=34]="PageDown",t[t.Left=37]="Left",t[t.Up=38]="Up",t[t.Right=39]="Right",t[t.Down=40]="Down",t[t.Delete=46]="Delete"}(i.Keys||(i.Keys={})),i.undisplayed=function(t,e){var i=t.style.display;t.style.display="none";try{return e()}finally{t.style.display=i}},i.unsized=function(t,e){return c(t,{},e)},i.sized=c},function(t,e,i){var n=t(408),r=t(50),o=t(5),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._has_finished=!1,this.el=this._createElement()},e.prototype.remove=function(){o.removeElement(this.el),t.prototype.remove.call(this)},e.prototype.css_classes=function(){return[]},e.prototype.cursor=function(t,e){return null},e.prototype.render=function(){},e.prototype.renderTo=function(t){t.appendChild(this.el),this.render()},e.prototype.has_finished=function(){return this._has_finished},Object.defineProperty(e.prototype,"_root_element",{get:function(){return o.parent(this.el,".bk-root")||document.body},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_idle",{get:function(){return this.has_finished()},enumerable:!0,configurable:!0}),e.prototype._createElement=function(){return o.createElement(this.tagName,{class:this.css_classes()})},e}(r.View);i.DOMView=s,s.prototype.tagName="div"},function(t,e,i){i.Align=["start","center","end"],i.Anchor=["top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"],i.AngleUnits=["deg","rad"],i.BoxOrigin=["corner","center"],i.ButtonType=["default","primary","success","warning","danger"],i.Dimension=["width","height"],i.Dimensions=["width","height","both"],i.Direction=["clock","anticlock"],i.Distribution=["uniform","normal"],i.FontStyle=["normal","italic","bold","bold italic"],i.HatchPatternType=["blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"],i.HTTPMethod=["POST","GET"],i.HexTileOrientation=["pointytop","flattop"],i.HoverMode=["mouse","hline","vline"],i.LatLon=["lat","lon"],i.LegendClickPolicy=["none","hide","mute"],i.LegendLocation=i.Anchor,i.LineCap=["butt","round","square"],i.LineJoin=["miter","round","bevel"],i.LinePolicy=["prev","next","nearest","interp","none"],i.Location=["above","below","left","right"],i.Logo=["normal","grey"],i.MarkerType=["asterisk","circle","circle_cross","circle_x","cross","dash","diamond","diamond_cross","hex","inverted_triangle","square","square_cross","square_x","triangle","x"],i.Orientation=["vertical","horizontal"],i.OutputBackend=["canvas","svg","webgl"],i.PaddingUnits=["percent","absolute"],i.Place=["above","below","left","right","center"],i.PointPolicy=["snap_to_data","follow_mouse","none"],i.RadiusDimension=["x","y","max","min"],i.RenderLevel=["image","underlay","glyph","annotation","overlay"],i.RenderMode=["canvas","css"],i.ResetPolicy=["standard","event_only"],i.RoundingFunction=["round","nearest","floor","rounddown","ceil","roundup"],i.Side=["above","below","left","right"],i.SizingMode=["stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"],i.SliderCallbackPolicy=["continuous","throttle","mouseup"],i.Sort=["ascending","descending"],i.SpatialUnits=["screen","data"],i.StartEnd=["start","end"],i.StepMode=["after","before","center"],i.TapBehavior=["select","inspect"],i.TextAlign=["left","right","center"],i.TextBaseline=["top","middle","bottom","alphabetic","hanging","ideographic"],i.TextureRepetition=["repeat","repeat_x","repeat_y","no_repeat"],i.TickLabelOrientation=["vertical","horizontal","parallel","normal"],i.TooltipAttachment=["horizontal","vertical","left","right","above","below"],i.UpdateMode=["replace","append"],i.VerticalAlign=["top","middle","bottom"]},function(t,e,i){var n=t(408),r=t(22),o=t(19),s=t(37),a=t(18),l=t(40),h=t(24),u=t(35),c=t(46),_=t(33),p=function(t){function e(e){void 0===e&&(e={});var i=t.call(this)||this;for(var n in i._subtype=void 0,i.document=null,i.destroyed=new r.Signal0(i,"destroyed"),i.change=new r.Signal0(i,"change"),i.transformchange=new r.Signal0(i,"transformchange"),i.attributes={},i.properties={},i._set_after_defaults={},i._pending=!1,i._changing=!1,i.props){var o=i.props[n],s=o.type,a=o.default_value;if(null==s)throw new Error("undefined property type for "+i.type+"."+n);i.properties[n]=new s(i,n,a)}null==e.id&&i.setv({id:l.uniqueId()},{silent:!0});var h=e.__deferred__||!1;return h&&delete(e=u.clone(e)).__deferred__,i.setv(e,{silent:!0}),h||i.finalize(),i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="HasProps",this.prototype.props={},this.prototype.mixins=[],this.define({id:[a.Any]})},e._fix_default=function(t,e){return void 0===t?void 0:c.isFunction(t)?t:c.isObject(t)?c.isArray(t)?function(){return h.copy(t)}:function(){return u.clone(t)}:function(){return t}},e.define=function(t){var e=function(e){var n=t[e];if(null!=i.prototype.props[e])throw new Error("attempted to redefine property '"+i.prototype.type+"."+e+"'");if(null!=i.prototype[e])throw new Error("attempted to redefine attribute '"+i.prototype.type+"."+e+"'");Object.defineProperty(i.prototype,e,{get:function(){var t=this.getv(e);return t},set:function(t){var i;return this.setv(((i={})[e]=t,i)),this},configurable:!1,enumerable:!0});var r=n,o=r[0],s=r[1],a=r[2],l={type:o,default_value:i._fix_default(s,e),internal:a||!1},h=u.clone(i.prototype.props);h[e]=l,i.prototype.props=h},i=this;for(var n in t)e(n)},e.internal=function(t){var e={};for(var i in t){var n=t[i],r=n[0],o=n[1];e[i]=[r,o,!0]}this.define(e)},e.mixin=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.define(o.create(t));var i=this.prototype.mixins.concat(t);this.prototype.mixins=i},e.mixins=function(t){this.mixin.apply(this,t)},e.override=function(t){for(var e in t){var i=this._fix_default(t[e],e),r=this.prototype.props[e];if(null==r)throw new Error("attempted to override nonexistent '"+this.prototype.type+"."+e+"'");var o=u.clone(this.prototype.props);o[e]=n.__assign({},r,{default_value:i}),this.prototype.props=o}},e.prototype.toString=function(){return this.type+"("+this.id+")"},e.prototype.finalize=function(){var t=this;for(var e in this.properties){var i=this.properties[e];i.update(),null!=i.spec.transform&&this.connect(i.spec.transform.change,function(){return t.transformchange.emit()})}this.initialize(),this.connect_signals()},e.prototype.initialize=function(){},e.prototype.connect_signals=function(){},e.prototype.disconnect_signals=function(){r.Signal.disconnectReceiver(this)},e.prototype.destroy=function(){this.disconnect_signals(),this.destroyed.emit()},e.prototype.clone=function(){return new this.constructor(this.attributes)},e.prototype._setv=function(t,e){var i=e.check_eq,n=e.silent,r=[],o=this._changing;this._changing=!0;var s=this.attributes;for(var a in t){var l=t[a];!1!==i&&_.isEqual(s[a],l)||r.push(a),s[a]=l}if(!n){r.length>0&&(this._pending=!0);for(var h=0;h<r.length;h++)this.properties[r[h]].change.emit()}if(!o){if(!n&&!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}},e.prototype.setv=function(t,e){for(var i in void 0===e&&(e={}),t)if(t.hasOwnProperty(i)){var n=i;if(null==this.props[n])throw new Error("property "+this.type+"."+n+" wasn't declared");null!=e&&e.defaults||(this._set_after_defaults[i]=!0)}if(!u.isEmpty(t)){var r={};for(var i in t)r[i]=this.getv(i);this._setv(t,e);var o=e.silent;if(null==o||!o)for(var i in t)this._tell_document_about_change(i,r[i],this.getv(i),e)}},e.prototype.getv=function(t){if(null==this.props[t])throw new Error("property "+this.type+"."+t+" wasn't declared");return this.attributes[t]},e.prototype.ref=function(){return s.create_ref(this)},e.prototype.set_subtype=function(t){this._subtype=t},e.prototype.attribute_is_serializable=function(t){var e=this.props[t];if(null==e)throw new Error(this.type+".attribute_is_serializable('"+t+"'): "+t+" wasn't declared");return!e.internal},e.prototype.serializable_attributes=function(){var t={};for(var e in this.attributes){var i=this.attributes[e];this.attribute_is_serializable(e)&&(t[e]=i)}return t},e._value_to_json=function(t,i,n){if(i instanceof e)return i.ref();if(c.isArray(i)){for(var r=[],o=0;o<i.length;o++){var s=i[o];r.push(e._value_to_json(o.toString(),s,i))}return r}if(c.isPlainObject(i)){var a={};for(var l in i)i.hasOwnProperty(l)&&(a[l]=e._value_to_json(l,i[l],i));return a}return i},e.prototype.attributes_as_json=function(t,i){void 0===t&&(t=!0),void 0===i&&(i=e._value_to_json);var n=this.serializable_attributes(),r={};for(var o in n)if(n.hasOwnProperty(o)){var s=n[o];t?r[o]=s:o in this._set_after_defaults&&(r[o]=s)}return i("attributes",r,this)},e._json_record_references=function(t,i,n,r){if(null==i);else if(s.is_ref(i)){if(!(i.id in n)){var o=t.get_model_by_id(i.id);e._value_record_references(o,n,r)}}else if(c.isArray(i))for(var a=0,l=i;a<l.length;a++){var h=l[a];e._json_record_references(t,h,n,r)}else if(c.isPlainObject(i))for(var u in i)if(i.hasOwnProperty(u)){var h=i[u];e._json_record_references(t,h,n,r)}},e._value_record_references=function(t,i,n){if(null==t);else if(t instanceof e){if(!(t.id in i)&&(i[t.id]=t,n))for(var r=t._immediate_references(),o=0,s=r;o<s.length;o++){var a=s[o];e._value_record_references(a,i,!0)}}else if(t.buffer instanceof ArrayBuffer);else if(c.isArray(t))for(var l=0,h=t;l<h.length;l++){var u=h[l];e._value_record_references(u,i,n)}else if(c.isPlainObject(t))for(var _ in t)if(t.hasOwnProperty(_)){var u=t[_];e._value_record_references(u,i,n)}},e.prototype._immediate_references=function(){var t={},i=this.serializable_attributes();for(var n in i){var r=i[n];e._value_record_references(r,t,!1)}return u.values(t)},e.prototype.references=function(){var t={};return e._value_record_references(this,t,!0),u.values(t)},e.prototype._doc_attached=function(){},e.prototype.attach_document=function(t){if(null!=this.document&&this.document!=t)throw new Error("models must be owned by only a single document");this.document=t,this._doc_attached()},e.prototype.detach_document=function(){this.document=null},e.prototype._tell_document_about_change=function(t,i,n,r){if(this.attribute_is_serializable(t)&&null!=this.document){var o={};e._value_record_references(n,o,!1);var s={};e._value_record_references(i,s,!1);var a=!1;for(var l in o)if(!(l in s)){a=!0;break}if(!a)for(var h in s)if(!(h in o)){a=!0;break}a&&this.document._invalidate_all_models(),this.document._notify_change(this,t,i,n,r)}},e.prototype.materialize_dataspecs=function(t){var e={};for(var i in this.properties){var n=this.properties[i];if(n instanceof a.VectorSpec&&(!n.optional||null!=n.spec.value||i in this._set_after_defaults)){var r=n.array(t);e["_"+i]=r,null!=n.spec.field&&n.spec.field in t._shapes&&(e["_"+i+"_shape"]=t._shapes[n.spec.field]),n instanceof a.DistanceSpec&&(e["max_"+i]=h.max(r))}}return e},e}(r.Signalable());i.HasProps=p,p.initClass()},function(t,e,i){var n=t(24),r=t(209);function o(t){return t*t}function s(t,e){return o(t.x-e.x)+o(t.y-e.y)}function a(t,e,i){var n=s(e,i);if(0==n)return s(t,e);var r=((t.x-e.x)*(i.x-e.x)+(t.y-e.y)*(i.y-e.y))/n;if(r<0)return s(t,e);if(r>1)return s(t,i);var o={x:e.x+r*(i.x-e.x),y:e.y+r*(i.y-e.y)};return s(t,o)}i.point_in_poly=function(t,e,i,n){for(var r=!1,o=i[i.length-1],s=n[n.length-1],a=0;a<i.length;a++){var l=i[a],h=n[a];s<e!=h<e&&o+(e-s)/(h-s)*(l-o)<t&&(r=!r),o=l,s=h}return r},i.point_in_ellipse=function(t,e,i,n,r,o,s){var a=Math.pow(Math.cos(i)/r,2)+Math.pow(Math.sin(i)/n,2),l=2*Math.cos(i)*Math.sin(i)*(Math.pow(1/r,2)-Math.pow(1/n,2)),h=Math.pow(Math.cos(i)/n,2)+Math.pow(Math.sin(i)/r,2);return a*Math.pow(t-o,2)+l*(t-o)*(e-s)+h*Math.pow(e-s,2)<=1},i.create_empty_hit_test_result=function(){return new r.Selection},i.create_hit_test_result_from_hits=function(t){var e=new r.Selection;return e.indices=n.sort_by(t,function(t){return t[0],t[1]}).map(function(t){var e=t[0];return t[1],e}),e},i.validate_bbox_coords=function(t,e){var i,n,r=t[0],o=t[1],s=e[0],a=e[1];return r>o&&(r=(i=[o,r])[0],o=i[1]),s>a&&(s=(n=[a,s])[0],a=n[1]),{minX:r,minY:s,maxX:o,maxY:a}},i.dist_2_pts=s,i.dist_to_segment_squared=a,i.dist_to_segment=function(t,e,i){return Math.sqrt(a(t,e,i))},i.check_2_segments_intersect=function(t,e,i,n,r,o,s,a){var l=(a-o)*(i-t)-(s-r)*(n-e);if(0==l)return{hit:!1,x:null,y:null};var h=e-o,u=t-r,c=(s-r)*h-(a-o)*u,_=(i-t)*h-(n-e)*u;u=_/l;var p=t+(h=c/l)*(i-t),d=e+h*(n-e);return{hit:h>0&&h<1&&u>0&&u<1,x:p,y:d}}},function(t,e,i){var n=t(408),r=t(14),o=t(27),s=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.children=[],e}return n.__extends(e,t),e}(r.Layoutable);i.Stack=s;var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._measure=function(t){for(var e=0,i=0,n=0,r=this.children;n<r.length;n++){var o=r[n],s=o.measure({width:0,height:0});e+=s.width,i=Math.max(i,s.height)}return{width:e,height:i}},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i);for(var n=e.top,r=e.bottom,s=e.left,a=0,l=this.children;a<l.length;a++){var h=l[a],u=h.measure({width:0,height:0}).width;h.set_geometry(new o.BBox({left:s,width:u,top:n,bottom:r})),s+=u}},e}(s);i.HStack=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._measure=function(t){for(var e=0,i=0,n=0,r=this.children;n<r.length;n++){var o=r[n],s=o.measure({width:0,height:0});e=Math.max(e,s.width),i+=s.height}return{width:e,height:i}},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i);for(var n=e.left,r=e.right,s=e.top,a=0,l=this.children;a<l.length;a++){var h=l[a],u=h.measure({width:0,height:0}).height;h.set_geometry(new o.BBox({top:s,height:u,left:n,right:r})),s+=u}},e}(s);i.VStack=l;var h=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.children=[],e}return n.__extends(e,t),e.prototype._measure=function(t){for(var e=0,i=0,n=0,r=this.children;n<r.length;n++){var o=r[n].layout,s=o.measure(t);e=Math.max(e,s.width),i=Math.max(i,s.height)}return{width:e,height:i}},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i);for(var n=0,r=this.children;n<r.length;n++){var s=r[n],a=s.layout,l=s.anchor,h=s.margin,u=e.left,c=e.right,_=e.top,p=e.bottom,d=e.hcenter,f=e.vcenter,v=a.measure(e),m=v.width,g=v.height,y=void 0;switch(l){case"top_left":y=new o.BBox({left:u+h,top:_+h,width:m,height:g});break;case"top_center":y=new o.BBox({hcenter:d,top:_+h,width:m,height:g});break;case"top_right":y=new o.BBox({right:c-h,top:_+h,width:m,height:g});break;case"bottom_right":y=new o.BBox({right:c-h,bottom:p-h,width:m,height:g});break;case"bottom_center":y=new o.BBox({hcenter:d,bottom:p-h,width:m,height:g});break;case"bottom_left":y=new o.BBox({left:u+h,bottom:p-h,width:m,height:g});break;case"center_left":y=new o.BBox({left:u+h,vcenter:f,width:m,height:g});break;case"center":y=new o.BBox({hcenter:d,vcenter:f,width:m,height:g});break;case"center_right":y=new o.BBox({right:c-h,vcenter:f,width:m,height:g});break;default:throw new Error("unreachable")}a.set_geometry(y)}},e}(r.Layoutable);i.AnchorLayout=h},function(t,e,i){var n=t(408),r=t(16),o=t(14),s=t(46),a=t(27),l=t(24),h=Math.max,u=Math.round,c=function(){function t(t){this.def=t,this._map=new Map}return t.prototype.get=function(t){var e=this._map.get(t);return void 0===e&&(e=this.def(),this._map.set(t,e)),e},t.prototype.apply=function(t,e){var i=this.get(t);this._map.set(t,e(i))},t}(),_=function(){function t(){this._items=[],this._nrows=0,this._ncols=0}return Object.defineProperty(t.prototype,"nrows",{get:function(){return this._nrows},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ncols",{get:function(){return this._ncols},enumerable:!0,configurable:!0}),t.prototype.add=function(t,e){var i=t.r1,n=t.c1;this._nrows=h(this._nrows,i+1),this._ncols=h(this._ncols,n+1),this._items.push({span:t,data:e})},t.prototype.at=function(t,e){var i=this._items.filter(function(i){var n=i.span;return n.r0<=t&&t<=n.r1&&n.c0<=e&&e<=n.c1});return i.map(function(t){var e=t.data;return e})},t.prototype.row=function(t){var e=this._items.filter(function(e){var i=e.span;return i.r0<=t&&t<=i.r1});return e.map(function(t){var e=t.data;return e})},t.prototype.col=function(t){var e=this._items.filter(function(e){var i=e.span;return i.c0<=t&&t<=i.c1});return e.map(function(t){var e=t.data;return e})},t.prototype.foreach=function(t){for(var e=0,i=this._items;e<i.length;e++){var n=i[e],r=n.span,o=n.data;t(r,o)}},t.prototype.map=function(e){for(var i=new t,n=0,r=this._items;n<r.length;n++){var o=r[n],s=o.span,a=o.data;i.add(s,e(s,a))}return i},t}(),p=function(t){function e(e){void 0===e&&(e=[]);var i=t.call(this)||this;return i.items=e,i.rows="auto",i.cols="auto",i.spacing=0,i.absolute=!1,i}return n.__extends(e,t),e.prototype.is_width_expanding=function(){if(t.prototype.is_width_expanding.call(this))return!0;if("fixed"==this.sizing.width_policy)return!1;var e=this._state.cols;return l.some(e,function(t){return"max"==t.policy})},e.prototype.is_height_expanding=function(){if(t.prototype.is_height_expanding.call(this))return!0;if("fixed"==this.sizing.height_policy)return!1;var e=this._state.rows;return l.some(e,function(t){return"max"==t.policy})},e.prototype._init=function(){var e=this;t.prototype._init.call(this);for(var i=new _,n=0,r=this.items;n<r.length;n++){var o=r[n],a=o.layout,h=o.row,u=o.col,c=o.row_span,p=o.col_span;if(a.sizing.visible){var d=h,f=u,v=h+(null!=c?c:1)-1,m=u+(null!=p?p:1)-1;i.add({r0:d,c0:f,r1:v,c1:m},a)}}for(var g=i.nrows,y=i.ncols,b=new Array(g),x=function(t){var n,r=null==(n=s.isPlainObject(e.rows)?e.rows[t]||e.rows["*"]:e.rows)?{policy:"auto"}:s.isNumber(n)?{policy:"fixed",height:n}:s.isString(n)?{policy:n}:n,o=r.align||"auto";if("fixed"==r.policy)b[t]={policy:"fixed",height:r.height,align:o};else if("min"==r.policy)b[t]={policy:"min",align:o};else if("fit"==r.policy||"max"==r.policy)b[t]={policy:r.policy,flex:r.flex||1,align:o};else{if("auto"!=r.policy)throw new Error("unrechable");l.some(i.row(t),function(t){return t.is_height_expanding()})?b[t]={policy:"max",flex:1,align:o}:b[t]={policy:"min",align:o}}},w=0;w<g;w++)x(w);for(var k=new Array(y),T=function(t){var n,r=null==(n=s.isPlainObject(e.cols)?e.cols[t]||e.cols["*"]:e.cols)?{policy:"auto"}:s.isNumber(n)?{policy:"fixed",width:n}:s.isString(n)?{policy:n}:n,o=r.align||"auto";if("fixed"==r.policy)k[t]={policy:"fixed",width:r.width,align:o};else if("min"==r.policy)k[t]={policy:"min",align:o};else if("fit"==r.policy||"max"==r.policy)k[t]={policy:r.policy,flex:r.flex||1,align:o};else{if("auto"!=r.policy)throw new Error("unrechable");l.some(i.col(t),function(t){return t.is_width_expanding()})?k[t]={policy:"max",flex:1,align:o}:k[t]={policy:"min",align:o}}},C=0;C<y;C++)T(C);var S=s.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing,A=S[0],M=S[1];this._state={items:i,nrows:g,ncols:y,rows:b,cols:k,rspacing:A,cspacing:M}},e.prototype._measure_totals=function(t,e){var i=this._state,n=i.nrows,r=i.ncols,o=i.rspacing,s=i.cspacing;return{height:l.sum(t)+(n-1)*o,width:l.sum(e)+(r-1)*s}},e.prototype._measure_cells=function(t){for(var e=this._state,i=e.items,n=e.nrows,o=e.ncols,s=e.rows,a=e.cols,l=e.rspacing,c=e.cspacing,p=new Array(n),d=0;d<n;d++){var f=s[d];p[d]="fixed"==f.policy?f.height:0}for(var v=new Array(o),m=0;m<o;m++){var g=a[m];v[m]="fixed"==g.policy?g.width:0}var y=new _;i.foreach(function(e,i){for(var n=e.r0,o=e.c0,_=e.r1,d=e.c1,f=(_-n)*l,m=(d-o)*c,g=0,b=n;b<=_;b++)g+=t(b,o).height;g+=f;for(var x=0,w=o;w<=d;w++)x+=t(n,w).width;x+=m;var k=i.measure({width:x,height:g});y.add(e,{layout:i,size_hint:k});var T=new r.Sizeable(k).grow_by(i.sizing.margin);T.height-=f,T.width-=m;for(var C=[],b=n;b<=_;b++){var S=s[b];"fixed"==S.policy?T.height-=S.height:C.push(b)}if(T.height>0)for(var A=u(T.height/C.length),M=0,E=C;M<E.length;M++){var b=E[M];p[b]=h(p[b],A)}for(var z=[],w=o;w<=d;w++){var O=a[w];"fixed"==O.policy?T.width-=O.width:z.push(w)}if(T.width>0)for(var P=u(T.width/z.length),j=0,N=z;j<N.length;j++){var w=N[j];v[w]=h(v[w],P)}});var b=this._measure_totals(p,v);return{size:b,row_heights:p,col_widths:v,size_hints:y}},e.prototype._measure_grid=function(t){var e,i=this._state,n=i.nrows,r=i.ncols,o=i.rows,s=i.cols,a=i.rspacing,l=i.cspacing,c=this._measure_cells(function(t,e){var i=o[t],n=s[e];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==i.policy?i.height:1/0}});e="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:c.size.height;for(var _,p=0,d=0;d<n;d++){var f=o[d];"fit"==f.policy||"max"==f.policy?p+=f.flex:e-=c.row_heights[d]}if(e-=(n-1)*a,0!=p&&e>0)for(var d=0;d<n;d++){var f=o[d];if("fit"==f.policy||"max"==f.policy){var v=u(e*(f.flex/p));e-=v,c.row_heights[d]=v,p-=f.flex}}else if(e<0){for(var m=0,d=0;d<n;d++){var f=o[d];"fixed"!=f.policy&&m++}for(var g=-e,d=0;d<n;d++){var f=o[d];if("fixed"!=f.policy){var v=c.row_heights[d],y=u(g/m);c.row_heights[d]=h(v-y,0),g-=y>v?v:y,m--}}}_="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:c.size.width;for(var b=0,x=0;x<r;x++){var w=s[x];"fit"==w.policy||"max"==w.policy?b+=w.flex:_-=c.col_widths[x]}if(_-=(r-1)*l,0!=b&&_>0)for(var x=0;x<r;x++){var w=s[x];if("fit"==w.policy||"max"==w.policy){var k=u(_*(w.flex/b));_-=k,c.col_widths[x]=k,b-=w.flex}}else if(_<0){for(var m=0,x=0;x<r;x++){var w=s[x];"fixed"!=w.policy&&m++}for(var T=-_,x=0;x<r;x++){var w=s[x];if("fixed"!=w.policy){var k=c.col_widths[x],y=u(T/m);c.col_widths[x]=h(k-y,0),T-=y>k?k:y,m--}}}var C=this._measure_cells(function(t,e){return{width:c.col_widths[e],height:c.row_heights[t]}}),S=C.row_heights,A=C.col_widths,M=C.size_hints,E=this._measure_totals(S,A);return{size:E,row_heights:S,col_widths:A,size_hints:M}},e.prototype._measure=function(t){var e=this._measure_grid(t).size;return e},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i);for(var r=this._state,o=r.nrows,s=r.ncols,l=r.rspacing,_=r.cspacing,p=this._measure_grid(e),d=p.row_heights,f=p.col_widths,v=p.size_hints,m=this._state.rows.map(function(t,e){return n.__assign({},t,{top:0,height:d[e],get bottom(){return this.top+this.height}})}),g=this._state.cols.map(function(t,e){return n.__assign({},t,{left:0,width:f[e],get right(){return this.left+this.width}})}),y=v.map(function(t,e){return n.__assign({},e,{outer:new a.BBox,inner:new a.BBox})}),b=0,x=this.absolute?e.top:0;b<o;b++){var w=m[b];w.top=x,x+=w.height+l}for(var k=0,T=this.absolute?e.left:0;k<s;k++){var C=g[k];C.left=T,T+=C.width+_}function S(t,e){for(var i=(e-t)*_,n=t;n<=e;n++)i+=g[n].width;return i}function A(t,e){for(var i=(e-t)*l,n=t;n<=e;n++)i+=m[n].height;return i}y.foreach(function(t,e){var i=t.r0,n=t.c0,r=t.r1,o=t.c1,s=e.layout,l=e.size_hint,h=s.sizing,c=l.width,_=l.height,p={width:S(n,o),height:A(i,r)},d=n==o&&"auto"!=g[n].align?g[n].align:h.halign,f=i==r&&"auto"!=m[i].align?m[i].align:h.valign,v=g[n].left;"start"==d?v+=h.margin.left:"center"==d?v+=u((p.width-c)/2):"end"==d&&(v+=p.width-h.margin.right-c);var y=m[i].top;"start"==f?y+=h.margin.top:"center"==f?y+=u((p.height-_)/2):"end"==f&&(y+=p.height-h.margin.bottom-_),e.outer=new a.BBox({left:v,top:y,width:c,height:_})});var M=m.map(function(){return{start:new c(function(){return 0}),end:new c(function(){return 0})}}),E=g.map(function(){return{start:new c(function(){return 0}),end:new c(function(){return 0})}});y.foreach(function(t,e){var i=t.r0,n=t.c0,r=t.r1,o=t.c1,s=e.size_hint,a=e.outer,l=s.inner;null!=l&&(M[i].start.apply(a.top,function(t){return h(t,l.top)}),M[r].end.apply(m[r].bottom-a.bottom,function(t){return h(t,l.bottom)}),E[n].start.apply(a.left,function(t){return h(t,l.left)}),E[o].end.apply(g[o].right-a.right,function(t){return h(t,l.right)}))}),y.foreach(function(t,e){var i=t.r0,n=t.c0,r=t.r1,o=t.c1,s=e.size_hint,l=e.outer;function h(t){var e=t.left,i=t.right,n=t.top,r=t.bottom,o=l.width-e-i,s=l.height-n-r;return new a.BBox({left:e,top:n,width:o,height:s})}if(null!=s.inner){var u=h(s.inner);if(!1!==s.align){var c=M[i].start.get(l.top),_=M[r].end.get(m[r].bottom-l.bottom),p=E[n].start.get(l.left),d=E[o].end.get(g[o].right-l.right);try{u=h({top:c,bottom:_,left:p,right:d})}catch(t){}}e.inner=u}else e.inner=l}),y.foreach(function(t,e){var i=e.layout,n=e.outer,r=e.inner;i.set_geometry(n,r)})},e}(o.Layoutable);i.Grid=p;var d=function(t){function e(e){var i=t.call(this)||this;return i.items=e.map(function(t,e){return{layout:t,row:0,col:e}}),i.rows="fit",i}return n.__extends(e,t),e}(p);i.Row=d;var f=function(t){function e(e){var i=t.call(this)||this;return i.items=e.map(function(t,e){return{layout:t,row:e,col:0}}),i.cols="fit",i}return n.__extends(e,t),e}(p);i.Column=f},function(t,e,i){var n=t(408),r=t(14),o=t(16),s=t(5),a=function(t){function e(e){var i=t.call(this)||this;return i.content_size=s.unsized(e,function(){return new o.Sizeable(s.size(e))}),i}return n.__extends(e,t),e.prototype._content_size=function(){return this.content_size},e}(r.ContentLayoutable);i.ContentBox=a;var l=function(t){function e(e){var i=t.call(this)||this;return i.el=e,i}return n.__extends(e,t),e.prototype._measure=function(t){var e=this,i=new o.Sizeable(t).bounded_to(this.sizing.size);return s.sized(this.el,i,function(){var t=new o.Sizeable(s.content_size(e.el)),i=s.extents(e.el),n=i.border,r=i.padding;return t.grow_by(n).grow_by(r).map(Math.ceil)})},e}(r.Layoutable);i.VariadicBox=l},function(t,e,i){var n=t(16);i.Sizeable=n.Sizeable;var r=t(14);i.Layoutable=r.Layoutable,i.LayoutItem=r.LayoutItem;var o=t(10);i.HStack=o.HStack,i.VStack=o.VStack,i.AnchorLayout=o.AnchorLayout;var s=t(11);i.Grid=s.Grid,i.Row=s.Row,i.Column=s.Column;var a=t(12);i.ContentBox=a.ContentBox,i.VariadicBox=a.VariadicBox},function(t,e,i){var n=t(408),r=t(16),o=t(27),s=Math.min,a=Math.max,l=Math.round,h=function(){function t(){this._bbox=new o.BBox,this._inner_bbox=new o.BBox;var t=this;this._top={get value(){return t.bbox.top}},this._left={get value(){return t.bbox.left}},this._width={get value(){return t.bbox.width}},this._height={get value(){return t.bbox.height}},this._right={get value(){return t.bbox.right}},this._bottom={get value(){return t.bbox.bottom}},this._hcenter={get value(){return t.bbox.hcenter}},this._vcenter={get value(){return t.bbox.vcenter}}}return Object.defineProperty(t.prototype,"bbox",{get:function(){return this._bbox},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"inner_bbox",{get:function(){return this._inner_bbox},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"sizing",{get:function(){return this._sizing},enumerable:!0,configurable:!0}),t.prototype.set_sizing=function(t){var e=t.width_policy||"fit",i=t.width,n=null!=t.min_width?t.min_width:0,r=null!=t.max_width?t.max_width:1/0,o=t.height_policy||"fit",s=t.height,a=null!=t.min_height?t.min_height:0,l=null!=t.max_height?t.max_height:1/0,h=t.aspect,u=t.margin||{top:0,right:0,bottom:0,left:0},c=!1!==t.visible,_=t.halign||"start",p=t.valign||"start";this._sizing={width_policy:e,min_width:n,width:i,max_width:r,height_policy:o,min_height:a,height:s,max_height:l,aspect:h,margin:u,visible:c,halign:_,valign:p,size:{width:i,height:s},min_size:{width:n,height:a},max_size:{width:r,height:l}},this._init()},t.prototype._init=function(){},t.prototype._set_geometry=function(t,e){this._bbox=t,this._inner_bbox=e},t.prototype.set_geometry=function(t,e){this._set_geometry(t,e||t)},t.prototype.is_width_expanding=function(){return"max"==this.sizing.width_policy},t.prototype.is_height_expanding=function(){return"max"==this.sizing.height_policy},t.prototype.apply_aspect=function(t,e){var i=e.width,n=e.height,r=this.sizing.aspect;if(null!=r){var o=this.sizing,s=o.width_policy,a=o.height_policy;if("fixed"!=s&&"fixed"!=a)if(s==a){var h=i,u=l(i/r),c=l(n*r),_=n,p=Math.abs(t.width-h)+Math.abs(t.height-u),d=Math.abs(t.width-c)+Math.abs(t.height-_);p<=d?(i=h,n=u):(i=c,n=_)}else!function(t,e){var i={max:4,fit:3,min:2,fixed:1};return i[t]>i[e]}(s,a)?i=l(n*r):n=l(i/r);else"fixed"==s?n=l(i/r):"fixed"==a&&(i=l(n*r))}return{width:i,height:n}},t.prototype.measure=function(t){var e=this;if(!this.sizing.visible)return{width:0,height:0};var i=function(t){return"fixed"==e.sizing.width_policy&&null!=e.sizing.width?e.sizing.width:t},o=function(t){return"fixed"==e.sizing.height_policy&&null!=e.sizing.height?e.sizing.height:t},s=new r.Sizeable(t).shrink_by(this.sizing.margin).map(i,o),a=this._measure(s),l=this.clip_size(a),h=i(l.width),u=o(l.height),c=this.apply_aspect(s,{width:h,height:u});return n.__assign({},a,c)},t.prototype.compute=function(t){void 0===t&&(t={});var e=this.measure({width:null!=t.width&&this.is_width_expanding()?t.width:1/0,height:null!=t.height&&this.is_height_expanding()?t.height:1/0}),i=e.width,n=e.height,r=new o.BBox({left:0,top:0,width:i,height:n}),s=void 0;if(null!=e.inner){var a=e.inner,l=a.left,h=a.top,u=a.right,c=a.bottom;s=new o.BBox({left:l,top:h,right:i-u,bottom:n-c})}this.set_geometry(r,s)},Object.defineProperty(t.prototype,"xview",{get:function(){return this.bbox.xview},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){return this.bbox.yview},enumerable:!0,configurable:!0}),t.prototype.clip_width=function(t){return a(this.sizing.min_width,s(t,this.sizing.max_width))},t.prototype.clip_height=function(t){return a(this.sizing.min_height,s(t,this.sizing.max_height))},t.prototype.clip_size=function(t){var e=t.width,i=t.height;return{width:this.clip_width(e),height:this.clip_height(i)}},t}();i.Layoutable=h;var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._measure=function(t){var e,i,n=this.sizing,r=n.width_policy,o=n.height_policy;if(t.width==1/0)e=null!=this.sizing.width?this.sizing.width:0;else if("fixed"==r)e=null!=this.sizing.width?this.sizing.width:0;else if("min"==r)e=null!=this.sizing.width?s(t.width,this.sizing.width):0;else if("fit"==r)e=null!=this.sizing.width?s(t.width,this.sizing.width):t.width;else{if("max"!=r)throw new Error("unrechable");e=null!=this.sizing.width?a(t.width,this.sizing.width):t.width}if(t.height==1/0)i=null!=this.sizing.height?this.sizing.height:0;else if("fixed"==o)i=null!=this.sizing.height?this.sizing.height:0;else if("min"==o)i=null!=this.sizing.height?s(t.height,this.sizing.height):0;else if("fit"==o)i=null!=this.sizing.height?s(t.height,this.sizing.height):t.height;else{if("max"!=o)throw new Error("unrechable");i=null!=this.sizing.height?a(t.height,this.sizing.height):t.height}return{width:e,height:i}},e}(h);i.LayoutItem=u;var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._measure=function(t){var e=this,i=this._content_size(),n=t.bounded_to(this.sizing.size).bounded_to(i),r=function(){switch(e.sizing.width_policy){case"fixed":return null!=e.sizing.width?e.sizing.width:i.width;case"min":return i.width;case"fit":return n.width;case"max":return Math.max(i.width,n.width);default:throw new Error("unexpected")}}(),o=function(){switch(e.sizing.height_policy){case"fixed":return null!=e.sizing.height?e.sizing.height:i.height;case"min":return i.height;case"fit":return n.height;case"max":return Math.max(i.height,n.height);default:throw new Error("unexpected")}}();return{width:r,height:o}},e}(h);i.ContentLayoutable=c},function(t,e,i){var n=t(408),r=t(16),o=t(14),s=t(46),a=Math.PI/2,l="left",h="center",u={above:{parallel:0,normal:-a,horizontal:0,vertical:-a},below:{parallel:0,normal:a,horizontal:0,vertical:a},left:{parallel:-a,normal:0,horizontal:0,vertical:-a},right:{parallel:a,normal:0,horizontal:0,vertical:a}},c={above:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"alphabetic",vertical:"middle"},below:{justified:"bottom",parallel:"hanging",normal:"middle",horizontal:"hanging",vertical:"middle"},left:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"},right:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"}},_={above:{justified:h,parallel:h,normal:l,horizontal:h,vertical:l},below:{justified:h,parallel:h,normal:l,horizontal:h,vertical:l},left:{justified:h,parallel:h,normal:"right",horizontal:"right",vertical:h},right:{justified:h,parallel:h,normal:l,horizontal:l,vertical:h}},p={above:"right",below:l,left:"right",right:l},d={above:l,below:"right",left:"right",right:l},f=function(t){function e(e,i){var n=t.call(this)||this;switch(n.side=e,n.obj=i,n.side){case"above":n._dim=0,n._normals=[0,-1];break;case"below":n._dim=0,n._normals=[0,1];break;case"left":n._dim=1,n._normals=[-1,0];break;case"right":n._dim=1,n._normals=[1,0];break;default:throw new Error("unreachable")}return n.is_horizontal?n.set_sizing({width_policy:"max",height_policy:"fixed"}):n.set_sizing({width_policy:"fixed",height_policy:"max"}),n}return n.__extends(e,t),e.prototype._content_size=function(){return new r.Sizeable(this.get_oriented_size())},e.prototype.get_oriented_size=function(){var t=this.obj.get_size(),e=t.width,i=t.height;return!this.obj.rotate||this.is_horizontal?{width:e,height:i}:{width:i,height:e}},e.prototype.has_size_changed=function(){var t=this.get_oriented_size(),e=t.width,i=t.height;return this.is_horizontal?this.bbox.height!=i:this.bbox.width!=e},Object.defineProperty(e.prototype,"dimension",{get:function(){return this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"normals",{get:function(){return this._normals},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_horizontal",{get:function(){return 0==this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_vertical",{get:function(){return 1==this._dim},enumerable:!0,configurable:!0}),e.prototype.apply_label_text_heuristics=function(t,e){var i,n,r=this.side;s.isString(e)?(i=c[r][e],n=_[r][e]):0===e?(i="whatever",n="whatever"):e<0?(i="middle",n=p[r]):(i="middle",n=d[r]),t.textBaseline=i,t.textAlign=n},e.prototype.get_label_angle_heuristic=function(t){return u[this.side][t]},e}(o.ContentLayoutable);i.SidePanel=f},function(t,e,i){var n=Math.min,r=Math.max,o=function(){function t(t){void 0===t&&(t={}),this.width=null!=t.width?t.width:0,this.height=null!=t.height?t.height:0}return t.prototype.bounded_to=function(e){var i=e.width,n=e.height;return new t({width:this.width==1/0&&null!=i?i:this.width,height:this.height==1/0&&null!=n?n:this.height})},t.prototype.expanded_to=function(e){var i=e.width,n=e.height;return new t({width:i!=1/0?r(this.width,i):this.width,height:n!=1/0?r(this.height,n):this.height})},t.prototype.expand_to=function(t){var e=t.width,i=t.height;this.width=r(this.width,e),this.height=r(this.height,i)},t.prototype.narrowed_to=function(e){var i=e.width,r=e.height;return new t({width:n(this.width,i),height:n(this.height,r)})},t.prototype.narrow_to=function(t){var e=t.width,i=t.height;this.width=n(this.width,e),this.height=n(this.height,i)},t.prototype.grow_by=function(e){var i=e.left,n=e.right,r=e.top,o=e.bottom,s=this.width+i+n,a=this.height+r+o;return new t({width:s,height:a})},t.prototype.shrink_by=function(e){var i=e.left,n=e.right,o=e.top,s=e.bottom,a=r(this.width-i-n,0),l=r(this.height-o-s,0);return new t({width:a,height:l})},t.prototype.map=function(e,i){return new t({width:e(this.width),height:(null!=i?i:e)(this.height)})},t}();i.Sizeable=o},function(t,e,i){var n=t(46),r={},o=function(t,e){this.name=t,this.level=e};i.LogLevel=o;var s=function(){function t(e,i){void 0===i&&(i=t.INFO),this._name=e,this.set_level(i)}return Object.defineProperty(t,"levels",{get:function(){return Object.keys(t.log_levels)},enumerable:!0,configurable:!0}),t.get=function(e,i){if(void 0===i&&(i=t.INFO),e.length>0){var n=r[e];return null==n&&(r[e]=n=new t(e,i)),n}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")},Object.defineProperty(t.prototype,"level",{get:function(){return this.get_level()},enumerable:!0,configurable:!0}),t.prototype.get_level=function(){return this._log_level},t.prototype.set_level=function(e){if(e instanceof o)this._log_level=e;else{if(!n.isString(e)||null==t.log_levels[e])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=t.log_levels[e]}var i="["+this._name+"]";for(var r in t.log_levels){var s=t.log_levels[r];s.level<this._log_level.level||this._log_level.level===t.OFF.level?this[r]=function(){}:this[r]=a(r,i)}},t.prototype.trace=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.prototype.debug=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.prototype.info=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.prototype.warn=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.prototype.error=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},t.TRACE=new o("trace",0),t.DEBUG=new o("debug",1),t.INFO=new o("info",2),t.WARN=new o("warn",6),t.ERROR=new o("error",7),t.FATAL=new o("fatal",8),t.OFF=new o("off",9),t.log_levels={trace:t.TRACE,debug:t.DEBUG,info:t.INFO,warn:t.WARN,error:t.ERROR,fatal:t.FATAL,off:t.OFF},t}();function a(t,e){return null!=console[t]?console[t].bind(console,e):null!=console.log?console.log.bind(console,e):function(){}}i.Logger=s,i.logger=s.get("bokeh"),i.set_log_level=function(t){null==s.log_levels[t]?(console.log("[bokeh] unrecognized logging level '"+t+"' passed to Bokeh.set_log_level(), ignoring"),console.log("[bokeh] valid log levels are: "+s.levels.join(", "))):(console.log("[bokeh] setting log level to: '"+t+"'"),i.logger.set_level(t))}},function(t,e,i){var n=t(408),r=t(22),o=t(7),s=t(24),a=t(25),l=t(30),h=t(46);function u(t){try{return JSON.stringify(t)}catch(e){return t.toString()}}function c(t){return h.isPlainObject(t)&&(void 0===t.value?0:1)+(void 0===t.field?0:1)+(void 0===t.expr?0:1)==1}r.Signal,i.isSpec=c;var _=function(t){function e(e,i,n){var o=t.call(this)||this;return o.obj=e,o.attr=i,o.default_value=n,o.optional=!1,o.change=new r.Signal0(o.obj,"change"),o._init(),o.connect(o.change,function(){return o._init()}),o}return n.__extends(e,t),e.prototype.update=function(){this._init()},e.prototype.init=function(){},e.prototype.transform=function(t){return t},e.prototype.validate=function(t){if(!this.valid(t))throw new Error(this.obj.type+"."+this.attr+" given invalid value: "+u(t))},e.prototype.valid=function(t){return!0},e.prototype.value=function(t){if(void 0===t&&(t=!0),void 0===this.spec.value)throw new Error("attempted to retrieve property value for property without value specification");var e=this.transform([this.spec.value])[0];return null!=this.spec.transform&&t&&(e=this.spec.transform.compute(e)),e},e.prototype._init=function(){var t,e=this.obj,i=this.attr,n=e.getv(i);if(void 0===n){var r=this.default_value;n=void 0!==r?r(e):null,e.setv(((t={})[i]=n,t),{silent:!0,defaults:!0})}h.isArray(n)?this.spec={value:n}:c(n)?this.spec=n:this.spec={value:n},null!=this.spec.value&&this.validate(this.spec.value),this.init()},e.prototype.toString=function(){return"Prop("+this.obj+"."+this.attr+", spec: "+u(this.spec)+")"},e}(r.Signalable());i.Property=_;var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(_);i.Any=p;var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.valid=function(t){return h.isArray(t)||t instanceof Float64Array},e}(_);i.Array=d;var f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.valid=function(t){return h.isBoolean(t)},e}(_);i.Boolean=f;var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.valid=function(t){return h.isString(t)&&l.is_color(t)},e}(_);i.Color=v;var m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(_);i.Instance=m;var g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.valid=function(t){return h.isNumber(t)},e}(_);i.Number=g;var y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.valid=function(t){return h.isNumber(t)&&(0|t)==t},e}(g);i.Int=y;var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(g);i.Angle=b;var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.valid=function(t){return h.isNumber(t)&&0<=t&&t<=1},e}(g);i.Percent=x;var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.valid=function(t){return h.isString(t)},e}(_);i.String=w;var k=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(w);i.FontSize=k;var T=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(w);i.Font=T;var C=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.valid=function(t){return h.isString(t)&&s.includes(this.enum_values,t)},e}(_);function S(t){return function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(i,e),Object.defineProperty(i.prototype,"enum_values",{get:function(){return t},enumerable:!0,configurable:!0}),i}(C)}i.EnumProperty=C,i.Enum=S;var A=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"enum_values",{get:function(){return o.Direction},enumerable:!0,configurable:!0}),e.prototype.transform=function(t){for(var e=new Uint8Array(t.length),i=0;i<t.length;i++)switch(t[i]){case"clock":e[i]=0;break;case"anticlock":e[i]=1}return e},e}(C);i.Direction=A,i.Anchor=S(o.Anchor),i.AngleUnits=S(o.AngleUnits),i.BoxOrigin=S(o.BoxOrigin),i.ButtonType=S(o.ButtonType),i.Dimension=S(o.Dimension),i.Dimensions=S(o.Dimensions),i.Distribution=S(o.Distribution),i.FontStyle=S(o.FontStyle),i.HatchPatternType=S(o.HatchPatternType),i.HTTPMethod=S(o.HTTPMethod),i.HexTileOrientation=S(o.HexTileOrientation),i.HoverMode=S(o.HoverMode),i.LatLon=S(o.LatLon),i.LegendClickPolicy=S(o.LegendClickPolicy),i.LegendLocation=S(o.LegendLocation),i.LineCap=S(o.LineCap),i.LineJoin=S(o.LineJoin),i.LinePolicy=S(o.LinePolicy),i.Location=S(o.Location),i.Logo=S(o.Logo),i.MarkerType=S(o.MarkerType),i.Orientation=S(o.Orientation),i.OutputBackend=S(o.OutputBackend),i.PaddingUnits=S(o.PaddingUnits),i.Place=S(o.Place),i.PointPolicy=S(o.PointPolicy),i.RadiusDimension=S(o.RadiusDimension),i.RenderLevel=S(o.RenderLevel),i.RenderMode=S(o.RenderMode),i.ResetPolicy=S(o.ResetPolicy),i.RoundingFunction=S(o.RoundingFunction),i.Side=S(o.Side),i.SizingMode=S(o.SizingMode),i.SliderCallbackPolicy=S(o.SliderCallbackPolicy),i.Sort=S(o.Sort),i.SpatialUnits=S(o.SpatialUnits),i.StartEnd=S(o.StartEnd),i.StepMode=S(o.StepMode),i.TapBehavior=S(o.TapBehavior),i.TextAlign=S(o.TextAlign),i.TextBaseline=S(o.TextBaseline),i.TextureRepetition=S(o.TextureRepetition),i.TickLabelOrientation=S(o.TickLabelOrientation),i.TooltipAttachment=S(o.TooltipAttachment),i.UpdateMode=S(o.UpdateMode),i.VerticalAlign=S(o.VerticalAlign);var M=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(_);i.ScalarSpec=M;var E=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.array=function(t){var e;if(null!=this.spec.field){if(null==(e=this.transform(t.get_column(this.spec.field))))throw new Error("attempted to retrieve property array for nonexistent field '"+this.spec.field+"'")}else if(null!=this.spec.expr)e=this.transform(this.spec.expr.v_compute(t));else{var i=t.get_length();null==i&&(i=1);var n=this.value(!1);e=s.repeat(n,i)}return null!=this.spec.transform&&(e=this.spec.transform.v_compute(e)),e},e}(_);i.VectorSpec=E;var z=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(E);i.DataSpec=z;var O=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.init=function(){null==this.spec.units&&(this.spec.units=this.default_units);var t=this.spec.units;if(!s.includes(this.valid_units,t))throw new Error("units must be one of "+this.valid_units.join(", ")+"; got: "+t)},Object.defineProperty(e.prototype,"units",{get:function(){return this.spec.units},set:function(t){this.spec.units=t},enumerable:!0,configurable:!0}),e}(E);i.UnitsSpec=O;var P=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"default_units",{get:function(){return"rad"},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"valid_units",{get:function(){return o.AngleUnits},enumerable:!0,configurable:!0}),e.prototype.transform=function(e){return"deg"==this.spec.units&&(e=a.map(e,function(t){return t*Math.PI/180})),e=a.map(e,function(t){return-t}),t.prototype.transform.call(this,e)},e}(O);i.AngleSpec=P;var j=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.BooleanSpec=j;var N=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.ColorSpec=N;var D=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.CoordinateSpec=D;var F=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.CoordinateSeqSpec=F;var B=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"default_units",{get:function(){return"data"},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"valid_units",{get:function(){return o.SpatialUnits},enumerable:!0,configurable:!0}),e}(O);i.DistanceSpec=B;var R=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.FontSizeSpec=R;var I=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.MarkerSpec=I;var L=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.NumberSpec=L;var V=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.StringSpec=V;var G=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(z);i.NullStringSpec=G},function(t,e,i){var n=t(18),r=t(35);function o(t,e){var i={};for(var n in t){var r=t[n];i[e+n]=r}return i}var s={line_color:[n.ColorSpec,"black"],line_width:[n.NumberSpec,1],line_alpha:[n.NumberSpec,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[n.Array,[]],line_dash_offset:[n.Number,0]};i.line=function(t){return void 0===t&&(t=""),o(s,t)};var a={fill_color:[n.ColorSpec,"gray"],fill_alpha:[n.NumberSpec,1]};i.fill=function(t){return void 0===t&&(t=""),o(a,t)};var l={hatch_color:[n.ColorSpec,"black"],hatch_alpha:[n.NumberSpec,1],hatch_scale:[n.NumberSpec,12],hatch_pattern:[n.StringSpec,null],hatch_weight:[n.NumberSpec,1],hatch_extra:[n.Any,{}]};i.hatch=function(t){return void 0===t&&(t=""),o(l,t)};var h={text_font:[n.Font,"helvetica"],text_font_size:[n.FontSizeSpec,"12pt"],text_font_style:[n.FontStyle,"normal"],text_color:[n.ColorSpec,"#444444"],text_alpha:[n.NumberSpec,1],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[n.Number,1.2]};i.text=function(t){return void 0===t&&(t=""),o(h,t)},i.create=function(t){for(var e={},n=0,o=t;n<o.length;n++){var s=o[n],a=s.split(":"),l=a[0],h=a[1],u=void 0;switch(l){case"line":u=i.line;break;case"fill":u=i.fill;break;case"hatch":u=i.hatch;break;case"text":u=i.text;break;default:throw new Error("Unknown property mixin kind '"+l+"'")}r.extend(e,u(h))}return e}},function(t,e,i){var n=t(408),r=t(8),o=t(209),s=t(197),a=t(198),l=t(18),h=function(t){function e(e){var i=t.call(this,e)||this;return i.inspectors={},i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="SelectionManager",this.internal({source:[l.Any]})},e.prototype.select=function(t,e,i,n){void 0===n&&(n=!1);for(var r=[],o=[],l=0,h=t;l<h.length;l++){var u=h[l];u instanceof s.GlyphRendererView?r.push(u):u instanceof a.GraphRendererView&&o.push(u)}for(var c=!1,_=0,p=o;_<p.length;_++){var u=p[_],d=u.model.selection_policy.hit_test(e,u);c=c||u.model.selection_policy.do_selection(d,u.model,i,n)}if(r.length>0){var d=this.source.selection_policy.hit_test(e,r);c=c||this.source.selection_policy.do_selection(d,this.source,i,n)}return c},e.prototype.inspect=function(t,e){var i=!1;if(t instanceof s.GlyphRendererView){var n=t.hit_test(e);if(null!=n){i=!n.is_empty();var r=this.get_or_create_inspector(t.model);r.update(n,!0,!1),this.source.setv({inspected:r},{silent:!0}),this.source.inspect.emit([t,{geometry:e}])}}else if(t instanceof a.GraphRendererView){var n=t.model.inspection_policy.hit_test(e,t);i=i||t.model.inspection_policy.do_inspection(n,e,t,!1,!1)}return i},e.prototype.clear=function(t){this.source.selected.clear(),null!=t&&this.get_or_create_inspector(t.model).clear()},e.prototype.get_or_create_inspector=function(t){return null==this.inspectors[t.id]&&(this.inspectors[t.id]=new o.Selection),this.inspectors[t.id]},e}(r.HasProps);i.SelectionManager=h,h.initClass()},function(t,e,i){var n=function(){function t(){this._dev=!1}return Object.defineProperty(t.prototype,"dev",{get:function(){return this._dev},set:function(t){this._dev=t},enumerable:!0,configurable:!0}),t}();i.Settings=n,i.settings=new n},function(t,e,i){var n=t(408),r=t(32),o=t(28),s=t(24),a=function(){function t(t,e){this.sender=t,this.name=e}return t.prototype.connect=function(t,e){void 0===e&&(e=null),h.has(this.sender)||h.set(this.sender,[]);var i=h.get(this.sender);if(null!=c(i,this,t,e))return!1;var n=e||t;u.has(n)||u.set(n,[]);var r=u.get(n),o={signal:this,slot:t,context:e};return i.push(o),r.push(o),!0},t.prototype.disconnect=function(t,e){void 0===e&&(e=null);var i=h.get(this.sender);if(null==i||0===i.length)return!1;var n=c(i,this,t,e);if(null==n)return!1;var r=e||t,o=u.get(r);return n.signal=null,p(i),p(o),!0},t.prototype.emit=function(t){for(var e=h.get(this.sender)||[],i=0,n=e;i<n.length;i++){var r=n[i],o=r.signal,s=r.slot,a=r.context;o===this&&s.call(a,t,this.sender)}},t}();i.Signal=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.emit=function(){t.prototype.emit.call(this,void 0)},e}(a);i.Signal0=l,function(t){t.disconnectBetween=function(t,e){var i=h.get(t);if(null!=i&&0!==i.length){var n=u.get(e);if(null!=n&&0!==n.length){for(var r=0,o=n;r<o.length;r++){var s=o[r];if(null==s.signal)return;s.signal.sender===t&&(s.signal=null)}p(i),p(n)}}},t.disconnectSender=function(t){var e=h.get(t);if(null!=e&&0!==e.length){for(var i=0,n=e;i<n.length;i++){var r=n[i];if(null==r.signal)return;var o=r.context||r.slot;r.signal=null,p(u.get(o))}p(e)}},t.disconnectReceiver=function(t){var e=u.get(t);if(null!=e&&0!==e.length){for(var i=0,n=e;i<n.length;i++){var r=n[i];if(null==r.signal)return;var o=r.signal.sender;r.signal=null,p(h.get(o))}p(e)}},t.disconnectAll=function(t){var e=h.get(t);if(null!=e&&0!==e.length){for(var i=0,n=e;i<n.length;i++){var r=n[i];r.signal=null}p(e)}var o=u.get(t);if(null!=o&&0!==o.length){for(var s=0,a=o;s<a.length;s++){var r=a[s];r.signal=null}p(o)}}}(a=i.Signal||(i.Signal={})),i.Signal=a,i.Signalable=function(t){return null!=t?function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect=function(t,e){return t.connect(e,this)},e.prototype.disconnect=function(t,e){return t.disconnect(e,this)},e}(t):function(){function t(){}return t.prototype.connect=function(t,e){return t.connect(e,this)},t.prototype.disconnect=function(t,e){return t.disconnect(e,this)},t}()},function(t){t.connect=function(t,e){return t.connect(e,this)},t.disconnect=function(t,e){return t.disconnect(e,this)}}(i._Signalable||(i._Signalable={}));var h=new WeakMap,u=new WeakMap;function c(t,e,i,n){return s.find(t,function(t){return t.signal===e&&t.slot===i&&t.context===n})}var _=new r.Set;function p(t){0===_.size&&o.defer(d),_.add(t)}function d(){_.forEach(function(t){s.remove_by(t,function(t){return null==t.signal})}),_.clear()}},function(t,e,i){var n=t(408),r=t(377),o=t(22),s=t(17),a=t(5),l=t(47),h=t(24),u=t(35),c=t(46),_=t(31),p=t(3),d=function(){function t(t,e,i){var n=this;this.plot_view=t,this.toolbar=e,this.hit_area=i,this.pan_start=new o.Signal(this,"pan:start"),this.pan=new o.Signal(this,"pan"),this.pan_end=new o.Signal(this,"pan:end"),this.pinch_start=new o.Signal(this,"pinch:start"),this.pinch=new o.Signal(this,"pinch"),this.pinch_end=new o.Signal(this,"pinch:end"),this.rotate_start=new o.Signal(this,"rotate:start"),this.rotate=new o.Signal(this,"rotate"),this.rotate_end=new o.Signal(this,"rotate:end"),this.tap=new o.Signal(this,"tap"),this.doubletap=new o.Signal(this,"doubletap"),this.press=new o.Signal(this,"press"),this.move_enter=new o.Signal(this,"move:enter"),this.move=new o.Signal(this,"move"),this.move_exit=new o.Signal(this,"move:exit"),this.scroll=new o.Signal(this,"scroll"),this.keydown=new o.Signal(this,"keydown"),this.keyup=new o.Signal(this,"keyup"),this.hammer=new r(this.hit_area,{touchAction:"auto"}),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",function(t){return n._mouse_move(t)}),this.hit_area.addEventListener("mouseenter",function(t){return n._mouse_enter(t)}),this.hit_area.addEventListener("mouseleave",function(t){return n._mouse_exit(t)}),this.hit_area.addEventListener("wheel",function(t){return n._mouse_wheel(t)}),document.addEventListener("keydown",this),document.addEventListener("keyup",this)}return t.prototype.destroy=function(){this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)},t.prototype.handleEvent=function(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)},t.prototype._configure_hammerjs=function(){var t=this;this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",function(e){return t._doubletap(e)}),this.hammer.on("tap",function(e){return t._tap(e)}),this.hammer.on("press",function(e){return t._press(e)}),this.hammer.get("pan").set({direction:r.DIRECTION_ALL}),this.hammer.on("panstart",function(e){return t._pan_start(e)}),this.hammer.on("pan",function(e){return t._pan(e)}),this.hammer.on("panend",function(e){return t._pan_end(e)}),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",function(e){return t._pinch_start(e)}),this.hammer.on("pinch",function(e){return t._pinch(e)}),this.hammer.on("pinchend",function(e){return t._pinch_end(e)}),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",function(e){return t._rotate_start(e)}),this.hammer.on("rotate",function(e){return t._rotate(e)}),this.hammer.on("rotateend",function(e){return t._rotate_end(e)})},t.prototype.register_tool=function(t){var e=this,i=t.model.event_type;null!=i&&(c.isString(i)?this._register_tool(t,i):i.forEach(function(i,n){return e._register_tool(t,i,n<1)}))},t.prototype._register_tool=function(t,e,i){void 0===i&&(i=!0);var n=t,r=n.model.id,o=function(t){return function(e){e.id==r&&t(e.e)}},a=function(t){return function(e){t(e.e)}};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,o(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,o(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,o(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,o(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,o(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,o(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,o(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,o(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,o(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,o(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,o(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,o(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,o(n._tap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,o(n._press.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,o(n._scroll.bind(n)));break;default:throw new Error("unsupported event_type: "+e)}i&&(null!=n._doubletap&&n.connect(this.doubletap,a(n._doubletap.bind(n))),null!=n._keydown&&n.connect(this.keydown,a(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,a(n._keyup.bind(n))),_.is_mobile&&null!=n._scroll&&"pinch"==e&&(s.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,o(n._scroll.bind(n)))))},t.prototype._hit_test_renderers=function(t,e){for(var i=this.plot_view.get_renderer_views(),n=0,r=h.reversed(i);n<r.length;n++){var o=r[n],s=o.model.level;if(("annotation"==s||"overlay"==s)&&null!=o.interactive_hit&&o.interactive_hit(t,e))return o}return null},t.prototype._hit_test_frame=function(t,e){return this.plot_view.frame.bbox.contains(t,e)},t.prototype._hit_test_canvas=function(t,e){return this.plot_view.layout.bbox.contains(t,e)},t.prototype._trigger=function(t,e,i){var n=this,r=this.toolbar.gestures,o=t.name,s=o.split(":")[0],a=this._hit_test_renderers(e.sx,e.sy),l=this._hit_test_canvas(e.sx,e.sy);switch(s){case"move":var h=r[s].active;null!=h&&this.trigger(t,e,h.id);var c=this.toolbar.inspectors.filter(function(t){return t.active}),p="default";null!=a?(p=a.cursor(e.sx,e.sy)||p,u.isEmpty(c)||(t=this.move_exit,o=t.name)):this._hit_test_frame(e.sx,e.sy)&&(u.isEmpty(c)||(p="crosshair")),this.plot_view.set_cursor(p),this.plot_view.set_toolbar_visibility(l),c.map(function(i){return n.trigger(t,e,i.id)});break;case"tap":var d=i.target;if(null!=d&&d!=this.hit_area)return;null!=a&&null!=a.on_hit&&a.on_hit(e.sx,e.sy);var h=r[s].active;null!=h&&this.trigger(t,e,h.id);break;case"scroll":var f=_.is_mobile?"pinch":"scroll",h=r[f].active;null!=h&&(i.preventDefault(),i.stopPropagation(),this.trigger(t,e,h.id));break;case"pan":var h=r[s].active;null!=h&&(i.preventDefault(),this.trigger(t,e,h.id));break;default:var h=r[s].active;null!=h&&this.trigger(t,e,h.id)}this._trigger_bokeh_event(e)},t.prototype.trigger=function(t,e,i){void 0===i&&(i=null),t.emit({id:i,e:e})},t.prototype._trigger_bokeh_event=function(t){var e=this,i=function(){var i=e.plot_view.frame.xscales.default,n=e.plot_view.frame.yscales.default,r=t.sx,o=t.sy,s=i.invert(r),a=n.invert(o);switch(t.type){case"wheel":return new p.MouseWheel(r,o,s,a,t.delta);case"mousemove":return new p.MouseMove(r,o,s,a);case"mouseenter":return new p.MouseEnter(r,o,s,a);case"mouseleave":return new p.MouseLeave(r,o,s,a);case"tap":return new p.Tap(r,o,s,a);case"doubletap":return new p.DoubleTap(r,o,s,a);case"press":return new p.Press(r,o,s,a);case"pan":return new p.Pan(r,o,s,a,t.deltaX,t.deltaY);case"panstart":return new p.PanStart(r,o,s,a);case"panend":return new p.PanEnd(r,o,s,a);case"pinch":return new p.Pinch(r,o,s,a,t.scale);case"pinchstart":return new p.PinchStart(r,o,s,a);case"pinchend":return new p.PinchEnd(r,o,s,a);default:throw new Error("unreachable")}}();this.plot_view.model.trigger_event(i)},t.prototype._get_sxy=function(t){var e=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,i=e.pageX,n=e.pageY,r=a.offset(this.hit_area),o=r.left,s=r.top;return{sx:i-o,sy:n-s}},t.prototype._gesture_event=function(t){return n.__assign({type:t.type},this._get_sxy(t.srcEvent),{deltaX:t.deltaX,deltaY:t.deltaY,scale:t.scale,shiftKey:t.srcEvent.shiftKey})},t.prototype._tap_event=function(t){return n.__assign({type:t.type},this._get_sxy(t.srcEvent),{shiftKey:t.srcEvent.shiftKey})},t.prototype._move_event=function(t){return n.__assign({type:t.type},this._get_sxy(t))},t.prototype._scroll_event=function(t){return n.__assign({type:t.type},this._get_sxy(t),{delta:l.getDeltaY(t)})},t.prototype._key_event=function(t){return{type:t.type,keyCode:t.keyCode}},t.prototype._pan_start=function(t){var e=this._gesture_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)},t.prototype._pan=function(t){this._trigger(this.pan,this._gesture_event(t),t.srcEvent)},t.prototype._pan_end=function(t){this._trigger(this.pan_end,this._gesture_event(t),t.srcEvent)},t.prototype._pinch_start=function(t){this._trigger(this.pinch_start,this._gesture_event(t),t.srcEvent)},t.prototype._pinch=function(t){this._trigger(this.pinch,this._gesture_event(t),t.srcEvent)},t.prototype._pinch_end=function(t){this._trigger(this.pinch_end,this._gesture_event(t),t.srcEvent)},t.prototype._rotate_start=function(t){this._trigger(this.rotate_start,this._gesture_event(t),t.srcEvent)},t.prototype._rotate=function(t){this._trigger(this.rotate,this._gesture_event(t),t.srcEvent)},t.prototype._rotate_end=function(t){this._trigger(this.rotate_end,this._gesture_event(t),t.srcEvent)},t.prototype._tap=function(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)},t.prototype._doubletap=function(t){var e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)},t.prototype._press=function(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)},t.prototype._mouse_enter=function(t){this._trigger(this.move_enter,this._move_event(t),t)},t.prototype._mouse_move=function(t){this._trigger(this.move,this._move_event(t),t)},t.prototype._mouse_exit=function(t){this._trigger(this.move_exit,this._move_event(t),t)},t.prototype._mouse_wheel=function(t){this._trigger(this.scroll,this._scroll_event(t),t)},t.prototype._key_down=function(t){this.trigger(this.keydown,this._key_event(t))},t.prototype._key_up=function(t){this.trigger(this.keyup,this._key_event(t))},t}();i.UIEvents=d},function(t,e,i){var n=t(34),r=t(26),o=t(25);i.map=o.map,i.reduce=o.reduce,i.min=o.min,i.min_by=o.min_by,i.max=o.max,i.max_by=o.max_by,i.sum=o.sum,i.cumsum=o.cumsum,i.every=o.every,i.some=o.some,i.find=o.find,i.find_last=o.find_last,i.find_index=o.find_index,i.find_last_index=o.find_last_index,i.sorted_index=o.sorted_index;var s=Array.prototype.slice;function a(t){return s.call(t)}function l(t){var e;return(e=[]).concat.apply(e,t)}function h(t,e){return-1!==t.indexOf(e)}function u(t,e,i){void 0===i&&(i=1),r.assert(i>0,"'step' must be a positive number"),null==e&&(e=t,t=0);for(var n=Math.max,o=Math.ceil,s=Math.abs,a=t<=e?i:-i,l=n(o(s(e-t)/i),0),h=Array(l),u=0;u<l;u++,t+=a)h[u]=t;return h}function c(t){for(var e=[],i=0,n=t;i<n.length;i++){var r=n[i];h(e,r)||e.push(r)}return e}i.head=function(t){return t[0]},i.tail=function(t){return t[t.length-1]},i.last=function(t){return t[t.length-1]},i.copy=a,i.concat=l,i.includes=h,i.contains=h,i.nth=function(t,e){return t[e>=0?e:t.length+e]},i.zip=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];if(0==t.length)return[];for(var i=o.min(t.map(function(t){return t.length})),n=t.length,r=new Array(i),s=0;s<i;s++){r[s]=new Array(n);for(var a=0;a<n;a++)r[s][a]=t[a][s]}return r},i.unzip=function(t){for(var e=t.length,i=o.min(t.map(function(t){return t.length})),n=Array(i),r=0;r<i;r++)n[r]=new Array(e);for(var s=0;s<e;s++)for(var r=0;r<i;r++)n[r][s]=t[s][r];return n},i.range=u,i.linspace=function(t,e,i){void 0===i&&(i=100);for(var n=(e-t)/(i-1),r=new Array(i),o=0;o<i;o++)r[o]=t+n*o;return r},i.transpose=function(t){for(var e=t.length,i=t[0].length,n=[],r=0;r<i;r++){n[r]=[];for(var o=0;o<e;o++)n[r][o]=t[o][r]}return n},i.argmin=function(t){return o.min_by(u(t.length),function(e){return t[e]})},i.argmax=function(t){return o.max_by(u(t.length),function(e){return t[e]})},i.sort_by=function(t,e){var i=t.map(function(t,i){return{value:t,index:i,key:e(t)}});return i.sort(function(t,e){var i=t.key,n=e.key;if(i!==n){if(i>n||void 0===i)return 1;if(i<n||void 0===n)return-1}return t.index-e.index}),i.map(function(t){return t.value})},i.uniq=c,i.uniq_by=function(t,e){for(var i=[],n=[],r=0,o=t;r<o.length;r++){var s=o[r],a=e(s);h(n,a)||(n.push(a),i.push(s))}return i},i.union=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];return c(l(t))},i.intersection=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];var n=[];t:for(var r=0,o=t;r<o.length;r++){var s=o[r];if(!h(n,s)){for(var a=0,l=e;a<l.length;a++){var u=l[a];if(!h(u,s))continue t}n.push(s)}}return n},i.difference=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];var n=l(e);return t.filter(function(t){return!h(n,t)})},i.remove_at=function(t,e){var i=a(t);return i.splice(e,1),i},i.remove_by=function(t,e){for(var i=0;i<t.length;)e(t[i])?t.splice(i,1):i++},i.shuffle=function(t){for(var e=t.length,i=new Array(e),r=0;r<e;r++){var o=n.randomIn(0,r);o!==r&&(i[r]=i[o]),i[o]=t[r]}return i},i.pairwise=function(t,e){for(var i=t.length,n=new Array(i-1),r=0;r<i-1;r++)n[r]=e(t[r],t[r+1]);return n},i.reversed=function(t){for(var e=t.length,i=new Array(e),n=0;n<e;n++)i[e-n-1]=t[n];return i},i.repeat=function(t,e){for(var i=new Array(e),n=0;n<e;n++)i[n]=t;return i}},function(t,e,i){function n(t,e,i){for(var n=[],r=3;r<arguments.length;r++)n[r-3]=arguments[r];var o=t.length;e<0&&(e+=o),e<0?e=0:e>o&&(e=o),null==i||i>o-e?i=o-e:i<0&&(i=0);for(var s=o-i+n.length,a=new t.constructor(s),l=0;l<e;l++)a[l]=t[l];for(var h=0,u=n;h<u.length;h++){var c=u[h];a[l++]=c}for(var _=e+i;_<o;_++)a[l++]=t[_];return a}function r(t,e,i){var n,r,o=t.length;if(void 0===i&&0==o)throw new Error("can't reduce an empty array without an initial value");for(void 0===i?(n=t[0],r=1):(n=i,r=0);r<o;r++)n=e(n,t[r],r,t);return n}function o(t){return function(e,i){for(var n=e.length,r=t>0?0:n-1;r>=0&&r<n;r+=t)if(i(e[r]))return r;return-1}}i.splice=n,i.insert=function(t,e,i){return n(t,i,0,e)},i.append=function(t,e){return n(t,t.length,0,e)},i.prepend=function(t,e){return n(t,0,0,e)},i.indexOf=function(t,e){for(var i=0,n=t.length;i<n;i++)if(t[i]===e)return i;return-1},i.map=function(t,e){for(var i=t.length,n=new t.constructor(i),r=0;r<i;r++)n[r]=e(t[r],r,t);return n},i.reduce=r,i.min=function(t){for(var e,i=1/0,n=0,r=t.length;n<r;n++)(e=t[n])<i&&(i=e);return i},i.min_by=function(t,e){if(0==t.length)throw new Error("min_by() called with an empty array");for(var i=t[0],n=e(i),r=1,o=t.length;r<o;r++){var s=t[r],a=e(s);a<n&&(i=s,n=a)}return i},i.max=function(t){for(var e,i=-1/0,n=0,r=t.length;n<r;n++)(e=t[n])>i&&(i=e);return i},i.max_by=function(t,e){if(0==t.length)throw new Error("max_by() called with an empty array");for(var i=t[0],n=e(i),r=1,o=t.length;r<o;r++){var s=t[r],a=e(s);a>n&&(i=s,n=a)}return i},i.sum=function(t){for(var e=0,i=0,n=t.length;i<n;i++)e+=t[i];return e},i.cumsum=function(t){var e=new t.constructor(t.length);return r(t,function(t,i,n){return e[n]=t+i},0),e},i.every=function(t,e){for(var i=0,n=t.length;i<n;i++)if(!e(t[i]))return!1;return!0},i.some=function(t,e){for(var i=0,n=t.length;i<n;i++)if(e(t[i]))return!0;return!1},i.index_of=function(t,e){for(var i=0,n=t.length;i<n;i++)if(t[i]===e)return i;return-1},i.find_index=o(1),i.find_last_index=o(-1),i.find=function(t,e){var n=i.find_index(t,e);return-1==n?void 0:t[n]},i.find_last=function(t,e){var n=i.find_last_index(t,e);return-1==n?void 0:t[n]},i.sorted_index=function(t,e){for(var i=0,n=t.length;i<n;){var r=Math.floor((i+n)/2);t[r]<e?i=r+1:n=r}return i}},function(t,e,i){var n=t(408),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(Error);i.AssertionError=r,i.assert=function(t,e){if(!(!0===t||!1!==t&&t()))throw new r(e||"Assertion failed")}},function(t,e,i){var n=Math.min,r=Math.max;i.empty=function(){return{minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}},i.positive_x=function(){return{minX:Number.MIN_VALUE,minY:-1/0,maxX:1/0,maxY:1/0}},i.positive_y=function(){return{minX:-1/0,minY:Number.MIN_VALUE,maxX:1/0,maxY:1/0}},i.union=function(t,e){return{minX:n(t.minX,e.minX),maxX:r(t.maxX,e.maxX),minY:n(t.minY,e.minY),maxY:r(t.maxY,e.maxY)}};var o=function(){function t(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){var e=t,i=e.x0,n=e.y0,r=e.x1,o=e.y1;if(!(i<=r&&n<=o))throw new Error("invalid bbox {x0: "+i+", y0: "+n+", x1: "+r+", y1: "+o+"}");this.x0=i,this.y0=n,this.x1=r,this.y1=o}else if("x"in t){var s=t,a=s.left,l=s.top,h=s.width,u=s.height;if(!(h>=0&&u>=0))throw new Error("invalid bbox {left: "+a+", top: "+l+", width: "+h+", height: "+u+"}");this.x0=a,this.y0=l,this.x1=a+h,this.y1=l+u}else{var c,a=void 0,_=void 0,p=void 0;if("width"in t)if("left"in t)a=t.left,_=a+t.width;else if("right"in t)_=t.right,a=_-t.width;else{var d=t.width/2;a=t.hcenter-d,_=t.hcenter+d}else a=t.left,_=t.right;if("height"in t)if("top"in t)c=t.top,p=c+t.height;else if("bottom"in t)p=t.bottom,c=p-t.height;else{var f=t.height/2;c=t.vcenter-f,p=t.vcenter+f}else c=t.top,p=t.bottom;if(!(a<=_&&c<=p))throw new Error("invalid bbox {left: "+a+", top: "+c+", right: "+_+", bottom: "+p+"}");this.x0=a,this.y0=c,this.x1=_,this.y1=p}}return t.prototype.toString=function(){return"BBox({left: "+this.left+", top: "+this.top+", width: "+this.width+", height: "+this.height+"})"},Object.defineProperty(t.prototype,"minX",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"minY",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"maxX",{get:function(){return this.x1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"maxY",{get:function(){return this.y1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"left",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"top",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return this.x1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"bottom",{get:function(){return this.y1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"p0",{get:function(){return[this.x0,this.y0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"p1",{get:function(){return[this.x1,this.y1]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this.x1-this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.y1-this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rect",{get:function(){return{left:this.left,top:this.top,width:this.width,height:this.height}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"h_range",{get:function(){return{start:this.x0,end:this.x1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"v_range",{get:function(){return{start:this.y0,end:this.y1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){return[this.h_range,this.v_range]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"aspect",{get:function(){return this.width/this.height},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hcenter",{get:function(){return(this.left+this.right)/2},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"vcenter",{get:function(){return(this.top+this.bottom)/2},enumerable:!0,configurable:!0}),t.prototype.contains=function(t,e){return t>=this.x0&&t<=this.x1&&e>=this.y0&&e<=this.y1},t.prototype.clip=function(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]},t.prototype.union=function(e){return new t({x0:n(this.x0,e.x0),y0:n(this.y0,e.y0),x1:r(this.x1,e.x1),y1:r(this.y1,e.y1)})},t.prototype.equals=function(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1},Object.defineProperty(t.prototype,"xview",{get:function(){var t=this;return{compute:function(e){return t.left+e},v_compute:function(e){for(var i=new Float64Array(e.length),n=t.left,r=0;r<e.length;r++)i[r]=n+e[r];return i}}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){var t=this;return{compute:function(e){return t.bottom-e},v_compute:function(e){for(var i=new Float64Array(e.length),n=t.bottom,r=0;r<e.length;r++)i[r]=n-e[r];return i}}},enumerable:!0,configurable:!0}),t}();i.BBox=o},function(t,e,i){i.delay=function(t,e){return setTimeout(t,e)};var n="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;i.defer=function(t){return n(t)},i.throttle=function(t,e,i){void 0===i&&(i={});var n,r,o,s=null,a=0,l=function(){a=!1===i.leading?0:Date.now(),s=null,o=t.apply(n,r),s||(n=r=null)};return function(){var h=Date.now();a||!1!==i.leading||(a=h);var u=e-(h-a);return n=this,r=arguments,u<=0||u>e?(s&&(clearTimeout(s),s=null),a=h,o=t.apply(n,r),s||(n=r=null)):s||!1===i.trailing||(s=setTimeout(l,u)),o}},i.once=function(t){var e,i=!1;return function(){return i||(i=!0,e=t()),e}}},function(t,e,i){i.fixup_ctx=function(t){(function(t){t.setLineDash||(t.setLineDash=function(e){t.mozDash=e,t.webkitLineDash=e}),t.getLineDash||(t.getLineDash=function(){return t.mozDash})})(t),function(t){t.setLineDashOffset=function(e){t.lineDashOffset=e,t.mozDashOffset=e,t.webkitLineDashOffset=e},t.getLineDashOffset=function(){return t.mozDashOffset}}(t),function(t){t.setImageSmoothingEnabled=function(e){t.imageSmoothingEnabled=e,t.mozImageSmoothingEnabled=e,t.oImageSmoothingEnabled=e,t.webkitImageSmoothingEnabled=e,t.msImageSmoothingEnabled=e},t.getImageSmoothingEnabled=function(){var e=t.imageSmoothingEnabled;return null==e||e}}(t),function(t){t.measureText&&null==t.html5MeasureText&&(t.html5MeasureText=t.measureText,t.measureText=function(e){var i=t.html5MeasureText(e);return i.ascent=1.6*t.html5MeasureText("m").width,i})}(t),function(t){t.ellipse||(t.ellipse=function(e,i,n,r,o,s,a,l){void 0===l&&(l=!1);var h=.551784;t.translate(e,i),t.rotate(o);var u=n,c=r;l&&(u=-n,c=-r),t.moveTo(-u,0),t.bezierCurveTo(-u,c*h,-u*h,c,0,c),t.bezierCurveTo(u*h,c,u,c*h,u,0),t.bezierCurveTo(u,-c*h,u*h,-c,0,-c),t.bezierCurveTo(-u*h,-c,-u,-c*h,-u,0),t.rotate(-o),t.translate(-e,-i)})}(t)},i.get_scale_ratio=function(t,e,i){if("svg"==i)return 1;if(e){var n=window.devicePixelRatio||1,r=t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1;return n/r}return 1}},function(t,e,i){var n=t(41),r=t(24);function o(t){var e=Number(t).toString(16);return 1==e.length?"0"+e:e}function s(t){if(0==(t+="").indexOf("#"))return t;if(n.is_svg_color(t))return n.svg_colors[t];if(0==t.indexOf("rgb")){var e=t.replace(/^rgba?\(|\s+|\)$/g,"").split(","),i=e.slice(0,3).map(o).join("");return 4==e.length&&(i+=o(Math.floor(255*parseFloat(e[3])))),"#"+i.slice(0,8)}return t}function a(t){var e;switch(t.substring(0,4)){case"rgba":e={start:"rgba(",len:4,alpha:!0};break;case"rgb(":e={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(t))throw new Error("color expects integers for rgb in rgb/rgba tuple, received "+t);var i=t.replace(e.start,"").replace(")","").split(",").map(parseFloat);if(i.length!=e.len)throw new Error("color expects rgba "+e.len+"-tuple, received "+t);if(e.alpha&&!(0<=i[3]&&i[3]<=1))throw new Error("color expects rgba 4-tuple to have alpha value between 0 and 1");if(r.includes(i.slice(0,3).map(function(t){return 0<=t&&t<=255}),!1))throw new Error("color expects rgb to have value between 0 and 255");return!0}i.is_color=function(t){return n.is_svg_color(t.toLowerCase())||"#"==t.substring(0,1)||a(t)},i.rgb2hex=function(t,e,i){var n=o(255&t),r=o(255&e),s=o(255&i);return"#"+n+r+s},i.color2hex=s,i.color2rgba=function(t,e){if(void 0===e&&(e=1),!t)return[0,0,0,0];var i=s(t);(i=i.replace(/ |#/g,"")).length<=4&&(i=i.replace(/(.)/g,"$1$1"));for(var n=i.match(/../g).map(function(t){return parseInt(t,16)/255});n.length<3;)n.push(0);return n.length<4&&n.push(e),n.slice(0,4)},i.valid_rgb=a},function(t,e,i){var n;i.is_ie=(n="undefined"!=typeof navigator?navigator.userAgent:"").indexOf("MSIE")>=0||n.indexOf("Trident")>0||n.indexOf("Edge")>0,i.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),i.is_little_endian=function(){var t=new ArrayBuffer(4),e=new Uint8Array(t),i=new Uint32Array(t);i[1]=168496141;var n=!0;return 10==e[4]&&11==e[5]&&12==e[6]&&13==e[7]&&(n=!1),n}()},function(t,e,i){var n=t(24),r=t(33),o=t(46),s=function(){function t(){this._dict={}}return t.prototype._existing=function(t){return t in this._dict?this._dict[t]:null},t.prototype.add_value=function(t,e){var i=this._existing(t);null==i?this._dict[t]=e:o.isArray(i)?i.push(e):this._dict[t]=[i,e]},t.prototype.remove_value=function(t,e){var i=this._existing(t);if(o.isArray(i)){var s=n.difference(i,[e]);s.length>0?this._dict[t]=s:delete this._dict[t]}else r.isEqual(i,e)&&delete this._dict[t]},t.prototype.get_one=function(t,e){var i=this._existing(t);if(o.isArray(i)){if(1===i.length)return i[0];throw new Error(e)}return i},t}();i.MultiDict=s;var a=function(){function t(e){if(null==e)this._values=[];else if(e instanceof t)this._values=n.copy(e._values);else{this._values=[];for(var i=0,r=e;i<r.length;i++){var o=r[i];this.add(o)}}}return Object.defineProperty(t.prototype,"values",{get:function(){return n.copy(this._values).sort()},enumerable:!0,configurable:!0}),t.prototype.toString=function(){return"Set(["+this.values.join(",")+"])"},Object.defineProperty(t.prototype,"size",{get:function(){return this._values.length},enumerable:!0,configurable:!0}),t.prototype.has=function(t){return-1!==this._values.indexOf(t)},t.prototype.add=function(t){this.has(t)||this._values.push(t)},t.prototype.remove=function(t){var e=this._values.indexOf(t);-1!==e&&this._values.splice(e,1)},t.prototype.toggle=function(t){var e=this._values.indexOf(t);-1===e?this._values.push(t):this._values.splice(e,1)},t.prototype.clear=function(){this._values=[]},t.prototype.union=function(e){return e=new t(e),new t(this._values.concat(e._values))},t.prototype.intersect=function(e){e=new t(e);for(var i=new t,n=0,r=e._values;n<r.length;n++){var o=r[n];this.has(o)&&e.has(o)&&i.add(o)}return i},t.prototype.diff=function(e){e=new t(e);for(var i=new t,n=0,r=this._values;n<r.length;n++){var o=r[n];e.has(o)||i.add(o)}return i},t.prototype.forEach=function(t,e){for(var i=0,n=this._values;i<n.length;i++){var r=n[i];t.call(e||this,r,r,this)}},t}();i.Set=a;var l=function(){function t(t,e,i){this.nrows=t,this.ncols=e,this._matrix=new Array(t);for(var n=0;n<t;n++){this._matrix[n]=new Array(e);for(var r=0;r<e;r++)this._matrix[n][r]=i(n,r)}}return t.prototype.at=function(t,e){return this._matrix[t][e]},t.prototype.map=function(e){var i=this;return new t(this.nrows,this.ncols,function(t,n){return e(i.at(t,n),t,n)})},t.prototype.apply=function(e){var i=this,n=t.from(e),r=this.nrows,o=this.ncols;if(r==n.nrows&&o==n.ncols)return new t(r,o,function(t,e){return n.at(t,e)(i.at(t,e),t,e)});throw new Error("dimensions don't match")},t.prototype.to_sparse=function(){for(var t=[],e=0;e<this.nrows;e++)for(var i=0;i<this.ncols;i++){var n=this._matrix[e][i];t.push([n,e,i])}return t},t.from=function(e){if(e instanceof t)return e;var i=e.length,r=n.min(e.map(function(t){return t.length}));return new t(i,r,function(t,i){return e[t][i]})},t}();i.Matrix=l},function(t,e,i){var n=t(46),r=Object.prototype.toString;i.isEqual=function(t,e){return function t(e,i,o,s){if(e===i)return 0!==e||1/e==1/i;if(null==e||null==i)return e===i;var a=r.call(e);if(a!==r.call(i))return!1;switch(a){case"[object RegExp]":case"[object String]":return""+e==""+i;case"[object Number]":return+e!=+e?+i!=+i:0==+e?1/+e==1/i:+e==+i;case"[object Date]":case"[object Boolean]":return+e==+i}var l="[object Array]"===a;if(!l){if("object"!=typeof e||"object"!=typeof i)return!1;var h=e.constructor,u=i.constructor;if(h!==u&&!(n.isFunction(h)&&h instanceof h&&n.isFunction(u)&&u instanceof u)&&"constructor"in e&&"constructor"in i)return!1}s=s||[];for(var c=(o=o||[]).length;c--;)if(o[c]===e)return s[c]===i;if(o.push(e),s.push(i),l){if((c=e.length)!==i.length)return!1;for(;c--;)if(!t(e[c],i[c],o,s))return!1}else{var _=Object.keys(e),p=void 0;if(c=_.length,Object.keys(i).length!==c)return!1;for(;c--;)if(p=_[c],!i.hasOwnProperty(p)||!t(e[p],i[p],o,s))return!1}return o.pop(),s.pop(),!0}(t,e)}},function(t,e,i){function n(t){for(;t<0;)t+=2*Math.PI;for(;t>2*Math.PI;)t-=2*Math.PI;return t}function r(t,e){return Math.abs(n(t-e))}function o(){return Math.random()}i.angle_norm=n,i.angle_dist=r,i.angle_between=function(t,e,i,o){var s=r(e,i);if(0==s)return!1;var a=n(t),l=r(e,a)<=s&&r(a,i)<=s;return 0==o?l:!l},i.random=o,i.randomIn=function(t,e){return null==e&&(e=t,t=0),t+Math.floor(Math.random()*(e-t+1))},i.atan2=function(t,e){return Math.atan2(e[1]-t[1],e[0]-t[0])},i.rnorm=function(t,e){for(var i,n;i=o(),n=(2*(n=o())-1)*Math.sqrt(1/Math.E*2),!(-4*i*i*Math.log(i)>=n*n););var r=n/i;return r=t+e*r},i.clamp=function(t,e,i){return t>i?i:t<e?e:t}},function(t,e,i){var n=t(408),r=t(24);function o(t,e){return n.__assign(t,e)}function s(t){return Object.keys(t).length}i.keys=Object.keys,i.values=function(t){for(var e=Object.keys(t),i=e.length,n=new Array(i),r=0;r<i;r++)n[r]=t[e[r]];return n},i.extend=o,i.clone=function(t){return o({},t)},i.merge=function(t,e){for(var i=Object.create(Object.prototype),n=r.concat([Object.keys(t),Object.keys(e)]),o=0,s=n;o<s.length;o++){var a=s[o],l=t.hasOwnProperty(a)?t[a]:[],h=e.hasOwnProperty(a)?e[a]:[];i[a]=r.union(l,h)}return i},i.size=s,i.isEmpty=function(t){return 0===s(t)}},function(t,e,i){var n=t(391),r=t(379),o=new r("GOOGLE"),s=new r("WGS84");i.wgs84_mercator=n(s,o);var a={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},l={lon:[-180,180],lat:[-85.06,85.06]};function h(t,e){for(var n=Math.min(t.length,e.length),r=new Array(n),o=new Array(n),s=0;s<n;s++){var a=i.wgs84_mercator.forward([t[s],e[s]]),l=a[0],h=a[1];r[s]=l,o[s]=h}return[r,o]}i.clip_mercator=function(t,e,i){var n=a[i],r=n[0],o=n[1];return[Math.max(t,r),Math.min(e,o)]},i.in_bounds=function(t,e){return t>l[e][0]&&t<l[e][1]},i.project_xy=h,i.project_xsys=function(t,e){for(var i=Math.min(t.length,e.length),n=new Array(i),r=new Array(i),o=0;o<i;o++){var s=h(t[o],e[o]),a=s[0],l=s[1];n[o]=a,r[o]=l}return[n,r]}},function(t,e,i){var n=t(46);i.create_ref=function(t){var e={type:t.type,id:t.id};return null!=t._subtype&&(e.subtype=t._subtype),e},i.is_ref=function(t){if(n.isObject(t)){var e=Object.keys(t).sort();if(2==e.length)return"id"==e[0]&&"type"==e[1];if(3==e.length)return"id"==e[0]&&"subtype"==e[1]&&"type"==e[2]}return!1}},function(t,e,i){var n=t(46),r=t(31);function o(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,2*t.length),i=0,n=e.length;i<n;i+=2){var r=e[i];e[i]=e[i+1],e[i+1]=r}}function s(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,4*t.length),i=0,n=e.length;i<n;i+=4){var r=e[i];e[i]=e[i+3],e[i+3]=r,r=e[i+1],e[i+1]=e[i+2],e[i+2]=r}}function a(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,8*t.length),i=0,n=e.length;i<n;i+=8){var r=e[i];e[i]=e[i+7],e[i+7]=r,r=e[i+1],e[i+1]=e[i+6],e[i+6]=r,r=e[i+2],e[i+2]=e[i+5],e[i+5]=r,r=e[i+3],e[i+3]=e[i+4],e[i+4]=r}}function l(t,e){for(var n=t.order!==i.BYTE_ORDER,r=t.shape,l=null,h=0,u=e;h<u.length;h++){var c=u[h],_=JSON.parse(c[0]);if(_.id===t.__buffer__){l=c[1];break}}var p=new i.ARRAY_TYPES[t.dtype](l);return n&&(2===p.BYTES_PER_ELEMENT?o(p):4===p.BYTES_PER_ELEMENT?s(p):8===p.BYTES_PER_ELEMENT&&a(p)),[p,r]}function h(t,e){return n.isObject(t)&&"__ndarray__"in t?_(t):n.isObject(t)&&"__buffer__"in t?l(t,e):n.isArray(t)||n.isTypedArray(t)?[t,[]]:void 0}function u(t){var e=new Uint8Array(t),i=Array.from(e).map(function(t){return String.fromCharCode(t)});return btoa(i.join(""))}function c(t){for(var e=atob(t),i=e.length,n=new Uint8Array(i),r=0,o=i;r<o;r++)n[r]=e.charCodeAt(r);return n.buffer}function _(t){var e=c(t.__ndarray__),n=t.dtype,r=t.shape;if(!(n in i.ARRAY_TYPES))throw new Error("unknown dtype: "+n);return[new i.ARRAY_TYPES[n](e),r]}function p(t,e){var n,r=u(t.buffer),o=function(t){if("name"in t.constructor)return t.constructor.name;switch(!0){case t instanceof Uint8Array:return"Uint8Array";case t instanceof Int8Array:return"Int8Array";case t instanceof Uint16Array:return"Uint16Array";case t instanceof Int16Array:return"Int16Array";case t instanceof Uint32Array:return"Uint32Array";case t instanceof Int32Array:return"Int32Array";case t instanceof Float32Array:return"Float32Array";case t instanceof Float64Array:return"Float64Array";default:throw new Error("unsupported typed array")}}(t);if(!(o in i.DTYPES))throw new Error("unknown array type: "+o);n=i.DTYPES[o];var s={__ndarray__:r,shape:e,dtype:n};return s}function d(t,e){if(0==t.length||!n.isObject(t[0])&&!n.isArray(t[0]))return[t,[]];for(var i=[],r=[],o=0,s=t;o<s.length;o++){var a=s[o],l=n.isArray(a)?d(a,e):h(a,e),u=l[0],c=l[1];i.push(u),r.push(c)}var _=r.map(function(t){return t.filter(function(t){return 0!=t.length})});return[i,_]}function f(t,e){for(var i=[],r=0,o=t.length;r<o;r++){var s=t[r];if(n.isTypedArray(s)){var a=e[r]?e[r]:void 0;i.push(p(s,a))}else n.isArray(s)?i.push(f(s,e?e[r]:[])):i.push(s)}return i}i.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},i.DTYPES={Uint8Array:"uint8",Int8Array:"int8",Uint16Array:"uint16",Int16Array:"int16",Uint32Array:"uint32",Int32Array:"int32",Float32Array:"float32",Float64Array:"float64"},i.BYTE_ORDER=r.is_little_endian?"little":"big",i.swap16=o,i.swap32=s,i.swap64=a,i.process_buffer=l,i.process_array=h,i.arrayBufferToBase64=u,i.base64ToArrayBuffer=c,i.decode_base64=_,i.encode_base64=p,i.decode_column_data=function(t,e){void 0===e&&(e=[]);var i={},r={};for(var o in t){var s=t[o];if(n.isArray(s)){if(0==s.length||!n.isObject(s[0])&&!n.isArray(s[0])){i[o]=s;continue}var a=d(s,e),l=a[0],u=a[1];i[o]=l,r[o]=u}else{var c=h(s,e),_=c[0],p=c[1];i[o]=_,r[o]=p}}return[i,r]},i.encode_column_data=function(t,e){var i={};for(var r in t){var o=t[r],s=null!=e?e[r]:void 0,a=void 0;a=n.isTypedArray(o)?p(o,s):n.isArray(o)?f(o,s||[]):o,i[r]=a}return i}},function(t,e,i){var n=t(376),r=t(27),o=function(){function t(t){if(this.points=t,this.index=null,t.length>0){this.index=new n(t.length);for(var e=0,i=t;e<i.length;e++){var r=i[e],o=r.minX,s=r.minY,a=r.maxX,l=r.maxY;this.index.add(o,s,a,l)}this.index.finish()}}return t.prototype._normalize=function(t){var e,i,n=t.minX,r=t.minY,o=t.maxX,s=t.maxY;return n>o&&(n=(e=[o,n])[0],o=e[1]),r>s&&(r=(i=[s,r])[0],s=i[1]),{minX:n,minY:r,maxX:o,maxY:s}},Object.defineProperty(t.prototype,"bbox",{get:function(){if(null==this.index)return r.empty();var t=this.index,e=t.minX,i=t.minY,n=t.maxX,o=t.maxY;return{minX:e,minY:i,maxX:n,maxY:o}},enumerable:!0,configurable:!0}),t.prototype.search=function(t){var e=this;if(null==this.index)return[];var i=this._normalize(t),n=i.minX,r=i.minY,o=i.maxX,s=i.maxY,a=this.index.search(n,r,o,s);return a.map(function(t){return e.points[t]})},t.prototype.indices=function(t){return this.search(t).map(function(t){var e=t.i;return e})},t}();i.SpatialIndex=o},function(t,e,i){var n=t(21);function r(){for(var t=new Array(32),e=0;e<32;e++)t[e]="0123456789ABCDEF".substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]="0123456789ABCDEF".substr(3&t[16].charCodeAt(0)|8,1),t.join("")}i.startsWith=function(t,e,i){return void 0===i&&(i=0),t.substr(i,e.length)==e},i.uuid4=r;var o=1e3;i.uniqueId=function(t){var e=n.settings.dev?"j"+o++:r();return null!=t?t+"-"+e:e},i.escape=function(t){return t.replace(/(?:[&<>"'`])/g,function(t){switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}})},i.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,function(t,e){switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}})},i.use_strict=function(t){return"'use strict';\n"+t}},function(t,e,i){i.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},i.is_svg_color=function(t){return t in i.svg_colors}},function(t,e,i){var n=t(406),r=t(378),o=t(407),s=t(40),a=t(46);function l(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];return n.sprintf.apply(void 0,[t].concat(e))}function h(t,e,i){if(a.isNumber(t)){var n=function(){switch(!1){case Math.floor(t)!=t:return"%d";case!(Math.abs(t)>.1&&Math.abs(t)<1e3):return"%0.3f";default:return"%0.3e"}}();return l(n,t)}return""+t}function u(t,e,n,r){if(null==n)return h;if(null!=r&&(t in r||e in r)){var o=e in r?e:t,s=r[o];if(a.isString(s)){if(s in i.DEFAULT_FORMATTERS)return i.DEFAULT_FORMATTERS[s];throw new Error("Unknown tooltip field formatter type '"+s+"'")}return function(t,e,i){return s.format(t,e,i)}}return i.DEFAULT_FORMATTERS.numeral}function c(t,e,i,n){if("$"==t[0]){if(t.substring(1)in n)return n[t.substring(1)];throw new Error("Unknown special variable '"+t+"'")}var r=e.get_column(t);if(null==r)return null;if(a.isNumber(i))return r[i];var o=r[i.index];if(a.isTypedArray(o)||a.isArray(o)){if(a.isArray(o[0])){var s=o[i.dim2];return s[i.dim1]}return o[i.flat_index]}return o}i.sprintf=l,i.DEFAULT_FORMATTERS={numeral:function(t,e,i){return r.format(t,e)},datetime:function(t,e,i){return o(t,e)},printf:function(t,e,i){return l(e,t)}},i.basic_formatter=h,i.get_formatter=u,i.get_value=c,i.replace_placeholders=function(t,e,i,n,r){void 0===r&&(r={});var o=t.replace(/(?:^|[^@])([@|\$](?:\w+|{[^{}]+}))(?:{[^{}]+})?/g,function(t,e,i){return""+e});return t=(t=(t=t.replace(/@\$name/g,function(t){return"@{"+r.name+"}"})).replace(/(^|[^\$])\$(\w+)/g,function(t,e,i){return e+"@$"+i})).replace(/(^|[^@])@(?:(\$?\w+)|{([^{}]+)})(?:{([^{}]+)})?/g,function(t,a,l,h,_){var p=c(l=null!=h?h:l,e,i,r);if(null==p)return""+a+s.escape("???");if("safe"==_)return""+a+p;var d=u(l,o,_,n);return""+a+s.escape(d(p,_,r))})}},function(t,e,i){var n=t(5),r={};i.measure_font=function(t){if(null!=r[t])return r[t];var e=n.span({style:{font:t}},"Hg"),i=n.div({style:{display:"inline-block",width:"1px",height:"0px"}}),o=n.div({},e,i);document.body.appendChild(o);try{i.style.verticalAlign="baseline";var s=n.offset(i).top-n.offset(e).top;i.style.verticalAlign="bottom";var a=n.offset(i).top-n.offset(e).top,l={height:a,ascent:s,descent:a-s};return r[t]=l,l}finally{document.body.removeChild(o)}};var o={};i.measure_text=function(t,e){var i=o[e];if(null!=i){var r=i[t];if(null!=r)return r}else o[e]={};var s=n.div({style:{display:"inline-block","white-space":"nowrap",font:e}},t);document.body.appendChild(s);try{var a=s.getBoundingClientRect(),l=a.width,h=a.height;return o[e][t]={width:l,height:h},{width:l,height:h}}finally{document.body.removeChild(s)}}},function(t,e,i){var n=("undefined"!=typeof window?window.requestAnimationFrame:void 0)||("undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.msRequestAnimationFrame:void 0)||function(t){return t(Date.now()),-1};i.throttle=function(t,e){var i=null,r=0,o=!1,s=function(){r=Date.now(),i=null,o=!1,t()};return function(){var t=Date.now(),a=e-(t-r);a<=0&&!o?(null!=i&&clearTimeout(i),o=!0,n(s)):i||o||(i=setTimeout(function(){return n(s)},a))}}},function(t,e,i){i.concat=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];for(var n=t.length,r=0,o=e;r<o.length;r++){var s=o[r];n+=s.length}var a=new t.constructor(n);a.set(t,0);for(var l=t.length,h=0,u=e;h<u.length;h++){var s=u[h];a.set(s,l),l+=s.length}return a}},function(t,e,i){var n=t(24),r=Object.prototype.toString;function o(t){return"[object Number]"===r.call(t)}function s(t){var e=typeof t;return"function"===e||"object"===e&&!!t}i.isBoolean=function(t){return!0===t||!1===t||"[object Boolean]"===r.call(t)},i.isNumber=o,i.isInteger=function(t){return o(t)&&isFinite(t)&&Math.floor(t)===t},i.isString=function(t){return"[object String]"===r.call(t)},i.isStrictNaN=function(t){return o(t)&&t!==+t},i.isFunction=function(t){return"[object Function]"===r.call(t)},i.isArray=function(t){return Array.isArray(t)},i.isArrayOf=function(t,e){return n.every(t,e)},i.isArrayableOf=function(t,e){for(var i=0,n=t.length;i<n;i++)if(!e(t[i]))return!1;return!0},i.isTypedArray=function(t){return null!=t&&t.buffer instanceof ArrayBuffer},i.isObject=s,i.isPlainObject=function(t){return s(t)&&(null==t.constructor||t.constructor===Object)}},function(t,e,i){function n(t){var e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}i.getDeltaY=function(t){var e,i=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:i*=n((e=t.target).offsetParent||document.body)||n(e)||16;break;case t.DOM_DELTA_PAGE:i*=function(t){return t.clientHeight}(t.target)}return i}},function(t,e,i){var n=t(34);function r(t,e,i){var n=[t.start,t.end],r=n[0],o=n[1],s=null!=i?i:(o+r)/2,a=r-(r-s)*e,l=o-(o-s)*e;return[a,l]}function o(t,e){var i=e[0],n=e[1],r={};for(var o in t){var s=t[o],a=s.r_invert(i,n),l=a[0],h=a[1];r[o]={start:l,end:h}}return r}i.scale_highlow=r,i.get_info=o,i.scale_range=function(t,e,i,s,a){void 0===i&&(i=!0),void 0===s&&(s=!0),e=n.clamp(e,-.9,.9);var l=i?e:0,h=r(t.bbox.h_range,l,null!=a?a.x:void 0),u=h[0],c=h[1],_=o(t.xscales,[u,c]),p=s?e:0,d=r(t.bbox.v_range,p,null!=a?a.y:void 0),f=d[0],v=d[1],m=o(t.yscales,[f,v]);return{xrs:_,yrs:m,factor:e}}},function(t,e,i){var n=t(46);i.isValue=function(t){return n.isPlainObject(t)&&"value"in t},i.isField=function(t){return n.isPlainObject(t)&&"field"in t}},function(t,e,i){var n=t(408),r=t(22),o=t(46),s=t(40),a=function(t){function e(e){var i=t.call(this)||this;if(i.removed=new r.Signal0(i,"removed"),null==e.model)throw new Error("model of a view wasn't configured");return i.model=e.model,i._parent=e.parent,i.id=e.id||s.uniqueId(),i.initialize(),!1!==e.connect_signals&&i.connect_signals(),i}return n.__extends(e,t),e.prototype.initialize=function(){},e.prototype.remove=function(){this._parent=void 0,this.disconnect_signals(),this.removed.emit()},e.prototype.toString=function(){return this.model.type+"View("+this.id+")"},e.prototype.serializable_state=function(){return{type:this.model.type}},Object.defineProperty(e.prototype,"parent",{get:function(){if(void 0!==this._parent)return this._parent;throw new Error("parent of a view wasn't configured")},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_root",{get:function(){return null===this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"root",{get:function(){return this.is_root?this:this.parent.root},enumerable:!0,configurable:!0}),e.prototype.assert_root=function(){if(!this.is_root)throw new Error(this.toString()+" is not a root layout")},e.prototype.connect_signals=function(){},e.prototype.disconnect_signals=function(){r.Signal.disconnectReceiver(this)},e.prototype.on_change=function(t,e){for(var i=0,n=o.isArray(t)?t:[t];i<n.length;i++){var r=n[i];this.connect(r.change,e)}},e}(r.Signalable());i.View=a},function(t,e,i){var n=t(408),r=t(19),o=t(30);function s(t,e,i){t.moveTo(0,i+.5),t.lineTo(e,i+.5),t.stroke()}function a(t,e,i){t.moveTo(i+.5,0),t.lineTo(i+.5,e),t.stroke()}function l(t,e){t.moveTo(0,e),t.lineTo(e,0),t.stroke(),t.moveTo(0,0),t.lineTo(e,e),t.stroke()}function h(t,e,i,n){var r=i,o=r/2,h=o/2,u=function(t){var e=document.createElement("canvas");return e.width=t,e.height=t,e}(i),c=u.getContext("2d");switch(c.strokeStyle=e,c.lineCap="square",c.fillStyle=e,c.lineWidth=n,t){case" ":case"blank":break;case".":case"dot":c.arc(o,o,o/2,0,2*Math.PI,!0),c.fill();break;case"o":case"ring":c.arc(o,o,o/2,0,2*Math.PI,!0),c.stroke();break;case"-":case"horizontal_line":s(c,r,o);break;case"|":case"vertical_line":a(c,r,o);break;case"+":case"cross":s(c,r,o),a(c,r,o);break;case'"':case"horizontal_dash":s(c,o,o);break;case":":case"vertical_dash":a(c,o,o);break;case"@":case"spiral":var _=r/30;c.moveTo(o,o);for(var p=0;p<360;p++){var d=.1*p,f=o+_*d*Math.cos(d),v=o+_*d*Math.sin(d);c.lineTo(f,v)}c.stroke();break;case"/":case"right_diagonal_line":c.moveTo(.5-h,r),c.lineTo(h+.5,0),c.stroke(),c.moveTo(h+.5,r),c.lineTo(3*h+.5,0),c.stroke(),c.moveTo(3*h+.5,r),c.lineTo(5*h+.5,0),c.stroke(),c.stroke();break;case"\\":case"left_diagonal_line":c.moveTo(h+.5,r),c.lineTo(.5-h,0),c.stroke(),c.moveTo(3*h+.5,r),c.lineTo(h+.5,0),c.stroke(),c.moveTo(5*h+.5,r),c.lineTo(3*h+.5,0),c.stroke(),c.stroke();break;case"x":case"diagonal_cross":l(c,r);break;case",":case"right_diagonal_dash":c.moveTo(h+.5,3*h+.5),c.lineTo(3*h+.5,h+.5),c.stroke();break;case"`":case"left_diagonal_dash":c.moveTo(h+.5,h+.5),c.lineTo(3*h+.5,3*h+.5),c.stroke();break;case"v":case"horizontal_wave":c.moveTo(0,h),c.lineTo(o,3*h),c.lineTo(r,h),c.stroke();break;case">":case"vertical_wave":c.moveTo(h,0),c.lineTo(3*h,o),c.lineTo(h,r),c.stroke();break;case"*":case"criss_cross":l(c,r),s(c,r,o),a(c,r,o)}return u}var u=function(){function t(t,e){void 0===e&&(e=""),this.obj=t,this.prefix=e,this.cache={};for(var i=0,n=this.attrs;i<n.length;i++){var r=n[i];this[r]=t.properties[e+r]}}return t.prototype.warm_cache=function(t){for(var e=0,i=this.attrs;e<i.length;e++){var n=i[e],r=this.obj.properties[this.prefix+n];if(void 0!==r.spec.value)this.cache[n]=r.spec.value;else{if(null==t)throw new Error("source is required with a vectorized visual property");this.cache[n+"_array"]=r.array(t)}}},t.prototype.cache_select=function(t,e){var i,n=this.obj.properties[this.prefix+t];return void 0!==n.spec.value?this.cache[t]=i=n.spec.value:this.cache[t]=i=this.cache[t+"_array"][e],i},t.prototype.set_vectorize=function(t,e){null!=this.all_indices?this._set_vectorize(t,this.all_indices[e]):this._set_vectorize(t,e)},t}();i.ContextProperties=u;var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.set_value=function(t){t.strokeStyle=this.line_color.value(),t.globalAlpha=this.line_alpha.value(),t.lineWidth=this.line_width.value(),t.lineJoin=this.line_join.value(),t.lineCap=this.line_cap.value(),t.setLineDash(this.line_dash.value()),t.setLineDashOffset(this.line_dash_offset.value())},Object.defineProperty(e.prototype,"doit",{get:function(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)},enumerable:!0,configurable:!0}),e.prototype._set_vectorize=function(t,e){this.cache_select("line_color",e),t.strokeStyle!==this.cache.line_color&&(t.strokeStyle=this.cache.line_color),this.cache_select("line_alpha",e),t.globalAlpha!==this.cache.line_alpha&&(t.globalAlpha=this.cache.line_alpha),this.cache_select("line_width",e),t.lineWidth!==this.cache.line_width&&(t.lineWidth=this.cache.line_width),this.cache_select("line_join",e),t.lineJoin!==this.cache.line_join&&(t.lineJoin=this.cache.line_join),this.cache_select("line_cap",e),t.lineCap!==this.cache.line_cap&&(t.lineCap=this.cache.line_cap),this.cache_select("line_dash",e),t.getLineDash()!==this.cache.line_dash&&t.setLineDash(this.cache.line_dash),this.cache_select("line_dash_offset",e),t.getLineDashOffset()!==this.cache.line_dash_offset&&t.setLineDashOffset(this.cache.line_dash_offset)},e.prototype.color_value=function(){var t=o.color2rgba(this.line_color.value(),this.line_alpha.value()),e=t[0],i=t[1],n=t[2],r=t[3];return"rgba("+255*e+","+255*i+","+255*n+","+r+")"},e}(u);i.Line=c,c.prototype.attrs=Object.keys(r.line());var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.set_value=function(t){t.fillStyle=this.fill_color.value(),t.globalAlpha=this.fill_alpha.value()},Object.defineProperty(e.prototype,"doit",{get:function(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)},enumerable:!0,configurable:!0}),e.prototype._set_vectorize=function(t,e){this.cache_select("fill_color",e),t.fillStyle!==this.cache.fill_color&&(t.fillStyle=this.cache.fill_color),this.cache_select("fill_alpha",e),t.globalAlpha!==this.cache.fill_alpha&&(t.globalAlpha=this.cache.fill_alpha)},e.prototype.color_value=function(){var t=o.color2rgba(this.fill_color.value(),this.fill_alpha.value()),e=t[0],i=t[1],n=t[2],r=t[3];return"rgba("+255*e+","+255*i+","+255*n+","+r+")"},e}(u);i.Fill=_,_.prototype.attrs=Object.keys(r.fill());var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.cache_select=function(e,i){var n;if("pattern"==e){this.cache_select("hatch_color",i),this.cache_select("hatch_scale",i),this.cache_select("hatch_pattern",i),this.cache_select("hatch_weight",i);var r=this.cache,o=r.hatch_color,s=r.hatch_scale,a=r.hatch_pattern,l=r.hatch_weight,u=r.hatch_extra;if(null!=u&&u.hasOwnProperty(a)){var c=u[a];this.cache.pattern=c.get_pattern(o,s,l)}else this.cache.pattern=function(t){var e=h(a,o,s,l);return t.createPattern(e,"repeat")}}else n=t.prototype.cache_select.call(this,e,i);return n},e.prototype._try_defer=function(t){var e=this.cache,i=e.hatch_pattern,n=e.hatch_extra;if(null!=n&&n.hasOwnProperty(i)){var r=n[i];r.onload(t)}},Object.defineProperty(e.prototype,"doit",{get:function(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)},enumerable:!0,configurable:!0}),e.prototype.doit2=function(t,e,i,n){if(this.doit){this.cache_select("pattern",e);var r=this.cache.pattern(t);null==r?this._try_defer(n):(this.set_vectorize(t,e),i())}},e.prototype._set_vectorize=function(t,e){this.cache_select("pattern",e),t.fillStyle=this.cache.pattern(t),this.cache_select("hatch_alpha",e),t.globalAlpha!==this.cache.hatch_alpha&&(t.globalAlpha=this.cache.hatch_alpha)},e.prototype.color_value=function(){var t=o.color2rgba(this.hatch_color.value(),this.hatch_alpha.value()),e=t[0],i=t[1],n=t[2],r=t[3];return"rgba("+255*e+","+255*i+","+255*n+","+r+")"},e}(u);i.Hatch=p,p.prototype.attrs=Object.keys(r.hatch());var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.cache_select=function(e,i){var n;if("font"==e){t.prototype.cache_select.call(this,"text_font_style",i),t.prototype.cache_select.call(this,"text_font_size",i),t.prototype.cache_select.call(this,"text_font",i);var r=this.cache,o=r.text_font_style,s=r.text_font_size,a=r.text_font;this.cache.font=n=o+" "+s+" "+a}else n=t.prototype.cache_select.call(this,e,i);return n},e.prototype.font_value=function(){var t=this.text_font.value(),e=this.text_font_size.value(),i=this.text_font_style.value();return i+" "+e+" "+t},e.prototype.color_value=function(){var t=o.color2rgba(this.text_color.value(),this.text_alpha.value()),e=t[0],i=t[1],n=t[2],r=t[3];return"rgba("+255*e+","+255*i+","+255*n+","+r+")"},e.prototype.set_value=function(t){t.font=this.font_value(),t.fillStyle=this.text_color.value(),t.globalAlpha=this.text_alpha.value(),t.textAlign=this.text_align.value(),t.textBaseline=this.text_baseline.value()},Object.defineProperty(e.prototype,"doit",{get:function(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)},enumerable:!0,configurable:!0}),e.prototype._set_vectorize=function(t,e){this.cache_select("font",e),t.font!==this.cache.font&&(t.font=this.cache.font),this.cache_select("text_color",e),t.fillStyle!==this.cache.text_color&&(t.fillStyle=this.cache.text_color),this.cache_select("text_alpha",e),t.globalAlpha!==this.cache.text_alpha&&(t.globalAlpha=this.cache.text_alpha),this.cache_select("text_align",e),t.textAlign!==this.cache.text_align&&(t.textAlign=this.cache.text_align),this.cache_select("text_baseline",e),t.textBaseline!==this.cache.text_baseline&&(t.textBaseline=this.cache.text_baseline)},e}(u);i.Text=d,d.prototype.attrs=Object.keys(r.text());var f=function(){function t(t){for(var e=0,i=t.mixins;e<i.length;e++){var n=i[e],r=n.split(":"),o=r[0],s=r[1],a=void 0===s?"":s,l=void 0;switch(o){case"line":l=c;break;case"fill":l=_;break;case"hatch":l=p;break;case"text":l=d;break;default:throw new Error("unknown visual: "+o)}this[a+o]=new l(t,a)}}return t.prototype.warm_cache=function(t){for(var e in this)if(this.hasOwnProperty(e)){var i=this[e];i instanceof u&&i.warm_cache(t)}},t.prototype.set_all_indices=function(t){for(var e in this)if(this.hasOwnProperty(e)){var i=this[e];i instanceof u&&(i.all_indices=t)}},t}();i.Visuals=f},function(t,e,i){var n=t(408),r=t(0),o=t(304),s=t(17),a=t(3),l=t(8),h=t(22),u=t(37),c=t(38),_=t(32),p=t(24),d=t(35),f=t(33),v=t(46),m=t(166),g=t(212),y=t(62),b=t(53),x=function(){function t(t){this.document=t,this.session=null,this.subscribed_models=new _.Set}return t.prototype.send_event=function(t){null!=this.session&&this.session.send_event(t)},t.prototype.trigger=function(t){for(var e=0,i=this.subscribed_models.values;e<i.length;e++){var n=i[e];if(null==t.origin||t.origin.id===n){var r=this.document._all_models[n];null!=r&&r instanceof y.Model&&r._process_event(t)}}},t}();i.EventManager=x,i.documents=[],i.DEFAULT_TITLE="Bokeh Application";var w=function(){function t(){i.documents.push(this),this._init_timestamp=Date.now(),this._title=i.DEFAULT_TITLE,this._roots=[],this._all_models={},this._all_models_by_name=new _.MultiDict,this._all_models_freeze_count=0,this._callbacks=[],this.event_manager=new x(this),this.idle=new h.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}return Object.defineProperty(t.prototype,"layoutables",{get:function(){return this._roots.filter(function(t){return t instanceof m.LayoutDOM})},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_idle",{get:function(){for(var t=0,e=this.layoutables;t<e.length;t++){var i=e[t];if(!this._idle_roots.has(i))return!1}return!0},enumerable:!0,configurable:!0}),t.prototype.notify_idle=function(t){this._idle_roots.set(t,!0),this.is_idle&&(s.logger.info("document idle at "+(Date.now()-this._init_timestamp)+" ms"),this.idle.emit())},t.prototype.clear=function(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}},t.prototype.interactive_start=function(t){null==this._interactive_plot&&(this._interactive_plot=t,this._interactive_plot.trigger_event(new a.LODStart)),this._interactive_timestamp=Date.now()},t.prototype.interactive_stop=function(t){null!=this._interactive_plot&&this._interactive_plot.id===t.id&&this._interactive_plot.trigger_event(new a.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null},t.prototype.interactive_duration=function(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp},t.prototype.destructively_move=function(t){if(t===this)throw new Error("Attempted to overwrite a document with itself");t.clear();var e=p.copy(this._roots);this.clear();for(var i=0,n=e;i<n.length;i++){var r=n[i];if(null!=r.document)throw new Error("Somehow we didn't detach "+r)}if(0!==Object.keys(this._all_models).length)throw new Error("this._all_models still had stuff in it: "+this._all_models);for(var o=0,s=e;o<s.length;o++){var r=s[o];t.add_root(r)}t.set_title(this._title)},t.prototype._push_all_models_freeze=function(){this._all_models_freeze_count+=1},t.prototype._pop_all_models_freeze=function(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()},t.prototype._invalidate_all_models=function(){s.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()},t.prototype._recompute_all_models=function(){for(var t=new _.Set,e=0,i=this._roots;e<i.length;e++){var n=i[e];t=t.union(n.references())}for(var r=new _.Set(d.values(this._all_models)),o=r.diff(t),s=t.diff(r),a={},l=0,h=t.values;l<h.length;l++){var u=h[l];a[u.id]=u}for(var c=0,p=o.values;c<p.length;c++){var f=p[c];f.detach_document(),f instanceof y.Model&&null!=f.name&&this._all_models_by_name.remove_value(f.name,f)}for(var v=0,m=s.values;v<m.length;v++){var g=m[v];g.attach_document(this),g instanceof y.Model&&null!=g.name&&this._all_models_by_name.add_value(g.name,g)}this._all_models=a},t.prototype.roots=function(){return this._roots},t.prototype.add_root=function(t,e){if(s.logger.debug("Adding root: "+t),!p.includes(this._roots,t)){this._push_all_models_freeze();try{this._roots.push(t)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new b.RootAddedEvent(this,t,e))}},t.prototype.remove_root=function(t,e){var i=this._roots.indexOf(t);if(!(i<0)){this._push_all_models_freeze();try{this._roots.splice(i,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new b.RootRemovedEvent(this,t,e))}},t.prototype.title=function(){return this._title},t.prototype.set_title=function(t,e){t!==this._title&&(this._title=t,this._trigger_on_change(new b.TitleChangedEvent(this,t,e)))},t.prototype.get_model_by_id=function(t){return t in this._all_models?this._all_models[t]:null},t.prototype.get_model_by_name=function(t){return this._all_models_by_name.get_one(t,"Multiple models are named '"+t+"'")},t.prototype.on_change=function(t){p.includes(this._callbacks,t)||this._callbacks.push(t)},t.prototype.remove_on_change=function(t){var e=this._callbacks.indexOf(t);e>=0&&this._callbacks.splice(e,1)},t.prototype._trigger_on_change=function(t){for(var e=0,i=this._callbacks;e<i.length;e++){var n=i[e];n(t)}},t.prototype._notify_change=function(t,e,i,n,r){"name"===e&&(this._all_models_by_name.remove_value(i,t),null!=n&&this._all_models_by_name.add_value(n,t));var o=null!=r?r.setter_id:void 0,s=null!=r?r.hint:void 0;this._trigger_on_change(new b.ModelChangedEvent(this,t,e,i,n,o,s))},t._references_json=function(t,e){void 0===e&&(e=!0);for(var i=[],n=0,r=t;n<r.length;n++){var o=r[n],s=o.ref();s.attributes=o.attributes_as_json(e),delete s.attributes.id,i.push(s)}return i},t._instantiate_object=function(t,e,i){var o=n.__assign({},i,{id:t,__deferred__:!0}),s=r.Models(e);return new s(o)},t._instantiate_references_json=function(e,i){for(var n={},r=0,o=e;r<o.length;r++){var s=o[r],a=s.id,l=s.type,h=s.attributes||{},u=void 0;a in i?u=i[a]:(u=t._instantiate_object(a,l,h),null!=s.subtype&&u.set_subtype(s.subtype)),n[u.id]=u}return n},t._resolve_refs=function(t,e,i){function n(t){if(u.is_ref(t)){if(t.id in e)return e[t.id];if(t.id in i)return i[t.id];throw new Error("reference "+JSON.stringify(t)+" isn't known (not in Document?)")}return v.isArray(t)?function(t){for(var e=[],i=0,r=t;i<r.length;i++){var o=r[i];e.push(n(o))}return e}(t):v.isPlainObject(t)?function(t){var e={};for(var i in t){var r=t[i];e[i]=n(r)}return e}(t):t}return n(t)},t._initialize_references_json=function(e,i,n){for(var r={},o=0,s=e;o<s.length;o++){var a=s[o],h=a.id,u=a.attributes,c=!(h in i),_=c?n[h]:i[h],p=t._resolve_refs(u,i,n);r[_.id]=[_,p,c]}function d(t,e){var i={};function n(r){if(r instanceof l.HasProps){if(!(r.id in i)&&r.id in t){i[r.id]=!0;var o=t[r.id],s=o[1],a=o[2];for(var h in s){var u=s[h];n(u)}e(r,s,a)}}else if(v.isArray(r))for(var c=0,_=r;c<_.length;c++){var u=_[c];n(u)}else if(v.isPlainObject(r))for(var p in r){var u=r[p];n(u)}}for(var r in t){var o=t[r],s=o[0];n(s)}}d(r,function(t,e,i){i&&t.setv(e,{silent:!0})}),d(r,function(t,e,i){i&&t.finalize()})},t._event_for_attribute_change=function(t,e,i,n,r){var o=n.get_model_by_id(t.id);if(o.attribute_is_serializable(e)){var s={kind:"ModelChanged",model:{id:t.id,type:t.type},attr:e,new:i};return l.HasProps._json_record_references(n,i,r,!0),s}return null},t._events_to_sync_objects=function(e,i,n,r){for(var o=Object.keys(e.attributes),a=Object.keys(i.attributes),l=p.difference(o,a),h=p.difference(a,o),u=p.intersection(o,a),c=[],_=0,d=l;_<d.length;_++){var v=d[_];s.logger.warn("Server sent key "+v+" but we don't seem to have it in our JSON")}for(var m=0,g=h;m<g.length;m++){var v=g[m],y=i.attributes[v];c.push(t._event_for_attribute_change(e,v,y,n,r))}for(var b=0,x=u;b<x.length;b++){var v=x[b],w=e.attributes[v],y=i.attributes[v];null==w&&null==y||(null==w||null==y?c.push(t._event_for_attribute_change(e,v,y,n,r)):f.isEqual(w,y)||c.push(t._event_for_attribute_change(e,v,y,n,r)))}return c.filter(function(t){return null!=t})},t._compute_patch_since_json=function(e,i){var n=i.to_json(!1);function r(t){for(var e={},i=0,n=t.roots.references;i<n.length;i++){var r=n[i];e[r.id]=r}return e}for(var o=r(e),s={},a=[],l=0,h=e.roots.root_ids;l<h.length;l++){var u=h[l];s[u]=o[u],a.push(u)}for(var c=r(n),_={},f=[],v=0,m=n.roots.root_ids;v<m.length;v++){var u=m[v];_[u]=c[u],f.push(u)}if(a.sort(),f.sort(),p.difference(a,f).length>0||p.difference(f,a).length>0)throw new Error("Not implemented: computing add/remove of document roots");var g={},y=[];for(var b in i._all_models)if(b in o){var x=t._events_to_sync_objects(o[b],c[b],i,g);y=y.concat(x)}return{references:t._references_json(d.values(g),!1),events:y}},t.prototype.to_json_string=function(t){return void 0===t&&(t=!0),JSON.stringify(this.to_json(t))},t.prototype.to_json=function(e){void 0===e&&(e=!0);var i=this._roots.map(function(t){return t.id}),n=d.values(this._all_models);return{version:o.version,title:this._title,roots:{root_ids:i,references:t._references_json(n,e)}}},t.from_json_string=function(e){var i=JSON.parse(e);return t.from_json(i)},t.from_json=function(e){s.logger.debug("Creating Document from JSON");var i=e.version,n=-1!==i.indexOf("+")||-1!==i.indexOf("-"),r="Library versions: JS ("+o.version+") / Python ("+i+")";n||o.version===i?s.logger.debug(r):(s.logger.warn("JS/Python version mismatch"),s.logger.warn(r));var a=e.roots,l=a.root_ids,h=a.references,u=t._instantiate_references_json(h,{});t._initialize_references_json(h,{},u);for(var c=new t,_=0,p=l;_<p.length;_++){var d=p[_];c.add_root(u[d])}return c.set_title(e.title),c},t.prototype.replace_with_json=function(e){var i=t.from_json(e);i.destructively_move(this)},t.prototype.create_json_patch_string=function(t){return JSON.stringify(this.create_json_patch(t))},t.prototype.create_json_patch=function(e){for(var i={},n=[],r=0,o=e;r<o.length;r++){var a=o[r];if(a.document!==this)throw s.logger.warn("Cannot create a patch using events from a different document, event had ",a.document," we are ",this),new Error("Cannot create a patch using events from a different document");n.push(a.json(i))}return{events:n,references:t._references_json(d.values(i))}},t.prototype.apply_json_patch=function(e,i,n){var r;void 0===i&&(i=[]);for(var o=e.references,a=e.events,l=t._instantiate_references_json(o,this._all_models),h=0,u=a;h<u.length;h++){var _=u[h];switch(_.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":var p=_.model.id;if(p in this._all_models)l[p]=this._all_models[p];else if(!(p in l))throw s.logger.warn("Got an event for unknown model ",_.model),new Error("event model wasn't known")}}var d={},f={};for(var v in l){var m=l[v];v in this._all_models?d[v]=m:f[v]=m}t._initialize_references_json(o,d,f);for(var y=0,b=a;y<b.length;y++){var _=b[y];switch(_.kind){case"ModelChanged":var x=_.model.id;if(!(x in this._all_models))throw new Error("Cannot apply patch to "+x+" which is not in the document");var w=this._all_models[x],k=_.attr,T=_.model.type;if("data"===k&&"ColumnDataSource"===T){var C=c.decode_column_data(_.new,i),S=C[0],A=C[1];w.setv({_shapes:A,data:S},{setter_id:n})}else{var m=t._resolve_refs(_.new,d,f);w.setv(((r={})[k]=m,r),{setter_id:n})}break;case"ColumnDataChanged":var M=_.column_source.id;if(!(M in this._all_models))throw new Error("Cannot stream to "+M+" which is not in the document");var E=this._all_models[M],z=c.decode_column_data(_.new,i),S=z[0],A=z[1];if(null!=_.cols){for(var O in E.data)O in S||(S[O]=E.data[O]);for(var O in E._shapes)O in A||(A[O]=E._shapes[O])}E.setv({_shapes:A,data:S},{setter_id:n,check_eq:!1});break;case"ColumnsStreamed":var M=_.column_source.id;if(!(M in this._all_models))throw new Error("Cannot stream to "+M+" which is not in the document");var E=this._all_models[M];if(!(E instanceof g.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");var S=_.data,P=_.rollover;E.stream(S,P,n);break;case"ColumnsPatched":var M=_.column_source.id;if(!(M in this._all_models))throw new Error("Cannot patch "+M+" which is not in the document");var E=this._all_models[M];if(!(E instanceof g.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");var j=_.patches;E.patch(j,n);break;case"RootAdded":var N=_.model.id,D=l[N];this.add_root(D,n);break;case"RootRemoved":var N=_.model.id,D=l[N];this.remove_root(D,n);break;case"TitleChanged":this.set_title(_.title,n);break;default:throw new Error("Unknown patch event "+JSON.stringify(_))}}},t}();i.Document=w},function(t,e,i){var n=t(408),r=t(8),o=function(t){this.document=t};i.DocumentChangedEvent=o;var s=function(t){function e(e,i,n,r,o,s,a){var l=t.call(this,e)||this;return l.model=i,l.attr=n,l.old=r,l.new_=o,l.setter_id=s,l.hint=a,l}return n.__extends(e,t),e.prototype.json=function(t){if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(t);var e=this.new_,i=r.HasProps._value_to_json(this.attr,e,this.model),n={};for(var o in r.HasProps._value_record_references(e,n,!0),this.model.id in n&&this.model!==e&&delete n[this.model.id],n)t[o]=n[o];return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:i}},e}(o);i.ModelChangedEvent=s;var a=function(t){function e(e,i,n){var r=t.call(this,e)||this;return r.column_source=i,r.patches=n,r}return n.__extends(e,t),e.prototype.json=function(t){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}},e}(o);i.ColumnsPatchedEvent=a;var l=function(t){function e(e,i,n,r){var o=t.call(this,e)||this;return o.column_source=i,o.data=n,o.rollover=r,o}return n.__extends(e,t),e.prototype.json=function(t){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}},e}(o);i.ColumnsStreamedEvent=l;var h=function(t){function e(e,i,n){var r=t.call(this,e)||this;return r.title=i,r.setter_id=n,r}return n.__extends(e,t),e.prototype.json=function(t){return{kind:"TitleChanged",title:this.title}},e}(o);i.TitleChangedEvent=h;var u=function(t){function e(e,i,n){var r=t.call(this,e)||this;return r.model=i,r.setter_id=n,r}return n.__extends(e,t),e.prototype.json=function(t){return r.HasProps._value_record_references(this.model,t,!0),{kind:"RootAdded",model:this.model.ref()}},e}(o);i.RootAddedEvent=u;var c=function(t){function e(e,i,n){var r=t.call(this,e)||this;return r.model=i,r.setter_id=n,r}return n.__extends(e,t),e.prototype.json=function(t){return{kind:"RootRemoved",model:this.model.ref()}},e}(o);i.RootRemovedEvent=c},function(t,e,i){var n=t(408);n.__exportStar(t(52),i),n.__exportStar(t(53),i)},function(t,e,i){var n=t(5);function r(t){var e=document.getElementById(t);if(null==e)throw new Error("Error rendering Bokeh model: could not find #"+t+" HTML tag");if(!document.body.contains(e))throw new Error("Error rendering Bokeh model: element #"+t+" must be under <body>");if("SCRIPT"==e.tagName){var r=n.div({class:i.BOKEH_ROOT});n.replaceWith(e,r),e=r}return e}i.BOKEH_ROOT="bk-root",i._resolve_element=function(t){var e=t.elementid;return null!=e?r(e):document.body},i._resolve_root_elements=function(t){var e={};if(null!=t.roots)for(var i in t.roots)e[i]=r(t.roots[i]);return e}},function(t,e,i){var n=t(54),r=t(17),o=t(28),s=t(40),a=t(46),l=t(59),h=t(58),u=t(55),c=t(59);i.add_document_standalone=c.add_document_standalone,i.index=c.index;var _=t(58);i.add_document_from_session=_.add_document_from_session;var p=t(57);i.embed_items_notebook=p.embed_items_notebook,i.kernels=p.kernels;var d=t(55);function f(t,e,i,o){a.isString(t)&&(t=JSON.parse(s.unescape(t)));var c={};for(var _ in t){var p=t[_];c[_]=n.Document.from_json(p)}for(var d=0,f=e;d<f.length;d++){var v=f[d],m=u._resolve_element(v),g=u._resolve_root_elements(v);if(null!=v.docid)l.add_document_standalone(c[v.docid],m,g,v.use_for_title);else{if(null==v.sessionid)throw new Error("Error rendering Bokeh items: either 'docid' or 'sessionid' was expected.");var y=h._get_ws_url(i,o);r.logger.debug("embed: computed ws url: "+y);var b=h.add_document_from_session(y,v.sessionid,m,g,v.use_for_title);b.then(function(){console.log("Bokeh items were rendered successfully")},function(t){console.log("Error rendering Bokeh items:",t)})}}}i.BOKEH_ROOT=d.BOKEH_ROOT,i.embed_item=function(t,e){var i,n={},r=s.uuid4();n[r]=t.doc,null==e&&(e=t.target_id);var a=document.getElementById(e);null!=a&&a.classList.add(u.BOKEH_ROOT);var l={roots:((i={})[t.root_id]=e,i),docid:r};o.defer(function(){return f(n,[l])})},i.embed_items=function(t,e,i,n){o.defer(function(){return f(t,e,i,n)})}},function(t,e,i){var n=t(54),r=t(301),o=t(17),s=t(35),a=t(59),l=t(55);function h(t,e){e.buffers.length>0?t.consume(e.buffers[0].buffer):t.consume(e.content.data);var i=t.message;null!=i&&this.apply_json_patch(i.content,i.buffers)}function u(t,e){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){o.logger.info("Registering Jupyter comms for target "+t);var n=Jupyter.notebook.kernel.comm_manager;try{n.register_target(t,function(i){o.logger.info("Registering Jupyter comms for target "+t);var n=new r.Receiver;i.on_msg(h.bind(e,n))})}catch(t){o.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+t+")")}}else if(e.roots()[0].id in i.kernels){o.logger.info("Registering JupyterLab comms for target "+t);var s=i.kernels[e.roots()[0].id];try{s.registerCommTarget(t,function(i){o.logger.info("Registering JupyterLab comms for target "+t);var n=new r.Receiver;i.onMsg=h.bind(e,n)})}catch(t){o.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+t+")")}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest jupyterlab_bokeh extension is installed. In an exported notebook this warning is expected.")}i.kernels={},i.embed_items_notebook=function(t,e){if(1!=s.size(t))throw new Error("embed_items_notebook expects exactly one document in docs_json");for(var i=n.Document.from_json(s.values(t)[0]),r=0,o=e;r<o.length;r++){var h=o[r];null!=h.notebook_comms_target&&u(h.notebook_comms_target,i);var c=l._resolve_element(h),_=l._resolve_root_elements(h);a.add_document_standalone(i,c,_)}}},function(t,e,i){var n=t(1),r=t(17),o=t(59);i._get_ws_url=function(t,e){var i,n="ws:";return"https:"==window.location.protocol&&(n="wss:"),null!=e?(i=document.createElement("a")).href=e:i=window.location,null!=t?"/"==t&&(t=""):t=i.pathname.replace(/\/+$/,""),n+"//"+i.host+t+"/ws"};var s={};i.add_document_from_session=function(t,e,i,a,l){void 0===a&&(a={}),void 0===l&&(l=!1);var h=window.location.search.substr(1);return function(t,e,i){t in s||(s[t]={});var r=s[t];return e in r||(r[e]=n.pull_session(t,e,i)),r[e]}(t,e,h).then(function(t){return o.add_document_standalone(t.document,i,a,l)},function(t){throw r.logger.error("Failed to load Bokeh session "+e+": "+t),t})}},function(t,e,i){var n=t(54),r=t(5),o=t(55);i.index={},i.add_document_standalone=function(t,e,s,a){void 0===s&&(s={}),void 0===a&&(a=!1);var l={};function h(t){var n;t.id in s?n=s[t.id]:e.classList.contains(o.BOKEH_ROOT)?n=e:(n=r.div({class:o.BOKEH_ROOT}),e.appendChild(n));var a=function(t){var e=new t.default_view({model:t,parent:null});return i.index[t.id]=e,e}(t);a.renderTo(n),l[t.id]=a}for(var u=0,c=t.roots();u<c.length;u++){var _=c[u];h(_)}return a&&(window.document.title=t.title()),t.on_change(function(t){t instanceof n.RootAddedEvent?h(t.model):t instanceof n.RootRemovedEvent?function(t){var e=t.id;if(e in l){var n=l[e];n.remove(),delete l[e],delete i.index[e]}}(t.model):a&&t instanceof n.TitleChangedEvent&&(window.document.title=t.title)}),l}},function(t,e,i){t(298);var n=t(304);i.version=n.version;var r=t(56);i.embed=r;var o=t(56);i.index=o.index;var s=t(299);i.protocol=s;var a=t(303);i._testing=a;var l=t(17);i.logger=l.logger,i.set_log_level=l.set_log_level;var h=t(21);i.settings=h.settings;var u=t(0);i.Models=u.Models;var c=t(54);i.documents=c.documents;var _=t(302);i.safely=_.safely},function(t,e,i){var n=t(408);n.__exportStar(t(60),i)},function(t,e,i){var n=t(408),r=t(8),o=t(18),s=t(46),a=t(35),l=t(17),h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Model",this.define({tags:[o.Array,[]],name:[o.String],js_property_callbacks:[o.Any,{}],js_event_callbacks:[o.Any,{}],subscribed_events:[o.Array,[]]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,function(){return e._update_property_callbacks()}),this.connect(this.properties.js_event_callbacks.change,function(){return e._update_event_callbacks()}),this.connect(this.properties.subscribed_events.change,function(){return e._update_event_callbacks()})},e.prototype._process_event=function(t){for(var e=0,i=this.js_event_callbacks[t.event_name]||[];e<i.length;e++){var n=i[e];n.execute(t)}null!=this.document&&this.subscribed_events.some(function(e){return e==t.event_name})&&this.document.event_manager.send_event(t)},e.prototype.trigger_event=function(t){null!=this.document&&(t.origin=this,this.document.event_manager.trigger(t))},e.prototype._update_event_callbacks=function(){null!=this.document?this.document.event_manager.subscribed_models.add(this.id):l.logger.warn("WARNING: Document not defined for updating event callbacks")},e.prototype._update_property_callbacks=function(){var t=this,e=function(e){var i=e.split(":"),n=i[0],r=i[1],o=void 0===r?null:r;return null!=o?t.properties[o][n]:t[n]};for(var i in this._js_callbacks)for(var n=this._js_callbacks[i],r=e(i),o=0,s=n;o<s.length;o++){var a=s[o];this.disconnect(r,a)}for(var l in this._js_callbacks={},this.js_property_callbacks){var n=this.js_property_callbacks[l],h=n.map(function(e){return function(){return e.execute(t)}});this._js_callbacks[l]=h;for(var r=e(l),u=0,c=h;u<c.length;u++){var a=c[u];this.connect(r,a)}}},e.prototype._doc_attached=function(){a.isEmpty(this.js_event_callbacks)&&a.isEmpty(this.subscribed_events)||this._update_event_callbacks()},e.prototype.select=function(t){if(s.isString(t))return this.references().filter(function(i){return i instanceof e&&i.name===t});if(t.prototype instanceof r.HasProps)return this.references().filter(function(e){return e instanceof t});throw new Error("invalid selector")},e.prototype.select_one=function(t){var e=this.select(t);switch(e.length){case 0:return null;case 1:return e[0];default:throw new Error("found more than one object matching given selector")}},e}(r.HasProps);i.Model=h,h.initClass()},function(t,e,i){var n=t(408),r=t(36),o=t(35),s=t(201),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"panel",{get:function(){return this.layout},enumerable:!0,configurable:!0}),e.prototype.get_size=function(){if(this.model.visible){var t=this._get_size(),e=t.width,i=t.height;return{width:Math.round(e),height:Math.round(i)}}return{width:0,height:0}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var i=this.model.properties;this.on_change(i.visible,function(){return e.plot_view.request_layout()})},e.prototype._get_size=function(){throw new Error("not implemented")},Object.defineProperty(e.prototype,"ctx",{get:function(){return this.plot_view.canvas_view.ctx},enumerable:!0,configurable:!0}),e.prototype.set_data=function(t){var e,i,n=this.model.materialize_dataspecs(t);o.extend(this,n),this.plot_model.use_map&&(null!=this._x&&(e=r.project_xy(this._x,this._y),this._x=e[0],this._y=e[1]),null!=this._xs&&(i=r.project_xsys(this._xs,this._ys),this._xs=i[0],this._ys=i[1]))},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null==this.layout},enumerable:!0,configurable:!0}),e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this);return null==this.layout?e:n.__assign({},e,{bbox:this.layout.bbox.rect})},e}(s.RendererView);i.AnnotationView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Annotation",this.override({level:"annotation"})},e}(s.Renderer);i.Annotation=l,l.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(65),s=t(212),a=t(18),l=t(34),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.model.source&&(this.model.source=new s.ColumnDataSource),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.streaming,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.patching,function(){return e.set_data(e.model.source)})},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,i,n,r=this.plot_view.frame;return"data"==this.model.start_units?(t=r.xscales[this.model.x_range_name].v_compute(this._x_start),e=r.yscales[this.model.y_range_name].v_compute(this._y_start)):(t=r.xview.v_compute(this._x_start),e=r.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=r.xscales[this.model.x_range_name].v_compute(this._x_end),n=r.yscales[this.model.y_range_name].v_compute(this._y_end)):(i=r.xview.v_compute(this._x_end),n=r.yview.v_compute(this._y_end)),[[t,e],[i,n]]},e.prototype.render=function(){if(this.model.visible){var t=this.plot_view.canvas_view.ctx;t.save();var e=this._map_data(),i=e[0],n=e[1];null!=this.model.end&&this._arrow_head(t,"render",this.model.end,i,n),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,n,i),t.beginPath();var r=this.plot_view.layout.bbox.rect,o=r.left,s=r.top,a=r.width,l=r.height;t.rect(o,s,a,l),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,i,n),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,n,i),t.closePath(),t.clip(),this._arrow_body(t,i,n),t.restore()}},e.prototype._arrow_head=function(t,e,i,n,r){for(var o=0,s=this._x_start.length;o<s;o++){var a=Math.PI/2+l.atan2([n[0][o],n[1][o]],[r[0][o],r[1][o]]);t.save(),t.translate(r[0][o],r[1][o]),t.rotate(a),"render"==e?i.render(t,o):"clip"==e&&i.clip(t,o),t.restore()}},e.prototype._arrow_body=function(t,e,i){if(this.visuals.line.doit)for(var n=0,r=this._x_start.length;n<r;n++)this.visuals.line.set_vectorize(t,n),t.beginPath(),t.moveTo(e[0][n],e[1][n]),t.lineTo(i[0][n],i[1][n]),t.stroke()},e}(r.AnnotationView);i.ArrowView=h;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Arrow",this.prototype.default_view=h,this.mixins(["line"]),this.define({x_start:[a.NumberSpec],y_start:[a.NumberSpec],start_units:[a.SpatialUnits,"data"],start:[a.Instance,null],x_end:[a.NumberSpec],y_end:[a.NumberSpec],end_units:[a.SpatialUnits,"data"],end:[a.Instance,function(){return new o.OpenHead({})}],source:[a.Instance],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]})},e}(r.Annotation);i.Arrow=u,u.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(51),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ArrowHead",this.define({size:[s.Number,25]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals=new o.Visuals(this)},e}(r.Annotation);i.ArrowHead=a,a.initClass();var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="OpenHead",this.mixins(["line"])},e.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(0,0),t.lineTo(.5*this.size,this.size)},e.prototype.render=function(t,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.stroke())},e}(a);i.OpenHead=l,l.initClass();var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="NormalHead",this.mixins(["line","fill"]),this.override({fill_color:"black"})},e.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(.5*this.size,this.size)},e.prototype.render=function(t,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,e),this._normal(t,e),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),this._normal(t,e),t.stroke())},e.prototype._normal=function(t,e){t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.closePath()},e}(a);i.NormalHead=h,h.initClass();var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="VeeHead",this.mixins(["line","fill"]),this.override({fill_color:"black"})},e.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(0,.5*this.size),t.lineTo(.5*this.size,this.size)},e.prototype.render=function(t,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,e),this._vee(t,e),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),this._vee(t,e),t.stroke())},e.prototype._vee=function(t,e){t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.lineTo(0,.5*this.size),t.closePath()},e}(a);i.VeeHead=u,u.initClass();var c=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="TeeHead",this.mixins(["line"])},e.prototype.render=function(t,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(.5*this.size,0),t.lineTo(-.5*this.size,0),t.stroke())},e.prototype.clip=function(t,e){},e}(a);i.TeeHead=c,c.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(212),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.patching,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.change,function(){return e.set_data(e.model.source)})},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,i,n=this.plot_view.frame,r=this.model.dimension,o=n.xscales[this.model.x_range_name],s=n.yscales[this.model.y_range_name],a="height"==r?s:o,l="height"==r?o:s,h="height"==r?n.yview:n.xview,u="height"==r?n.xview:n.yview;t="data"==this.model.properties.lower.units?a.v_compute(this._lower):h.v_compute(this._lower),e="data"==this.model.properties.upper.units?a.v_compute(this._upper):h.v_compute(this._upper),i="data"==this.model.properties.base.units?l.v_compute(this._base):u.v_compute(this._base);var c="height"==r?[1,0]:[0,1],_=c[0],p=c[1],d=[t,i],f=[e,i];this._lower_sx=d[_],this._lower_sy=d[p],this._upper_sx=f[_],this._upper_sy=f[p]},e.prototype.render=function(){if(this.model.visible){this._map_data();var t=this.plot_view.canvas_view.ctx;t.beginPath(),t.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var e=0,i=this._lower_sx.length;e<i;e++)t.lineTo(this._lower_sx[e],this._lower_sy[e]);for(var n=this._upper_sx.length-1,e=n;e>=0;e--)t.lineTo(this._upper_sx[e],this._upper_sy[e]);t.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(t),t.fill()),t.beginPath(),t.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var e=0,i=this._lower_sx.length;e<i;e++)t.lineTo(this._lower_sx[e],this._lower_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke()),t.beginPath(),t.moveTo(this._upper_sx[0],this._upper_sy[0]);for(var e=0,i=this._upper_sx.length;e<i;e++)t.lineTo(this._upper_sx[e],this._upper_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke())}},e}(r.AnnotationView);i.BandView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Band",this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({lower:[s.DistanceSpec],upper:[s.DistanceSpec],base:[s.DistanceSpec],dimension:[s.Dimension,"height"],source:[s.Instance,function(){return new o.ColumnDataSource}],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e}(r.Annotation);i.Band=l,l.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(22),s=t(5),a=t(18),l=t(27);i.EDGE_TOLERANCE=2.5;var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_overlays.appendChild(this.el),this.el.classList.add("bk-shading"),s.undisplay(this.el)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.data_update,function(){return e.render()})):(this.connect(this.model.change,function(){return e.plot_view.request_render()}),this.connect(this.model.data_update,function(){return e.plot_view.request_render()}))},e.prototype.render=function(){var t=this;if(this.model.visible||"css"!=this.model.render_mode||s.undisplay(this.el),this.model.visible)if(null!=this.model.left||null!=this.model.right||null!=this.model.top||null!=this.model.bottom){var e=this.plot_view.frame,i=e.xscales[this.model.x_range_name],n=e.yscales[this.model.y_range_name],r=function(e,i,n,r,o){return null!=e?t.model.screen?e:"data"==i?n.compute(e):r.compute(e):o};this.sleft=r(this.model.left,this.model.left_units,i,e.xview,e._left.value),this.sright=r(this.model.right,this.model.right_units,i,e.xview,e._right.value),this.stop=r(this.model.top,this.model.top_units,n,e.yview,e._top.value),this.sbottom=r(this.model.bottom,this.model.bottom_units,n,e.yview,e._bottom.value);var o="css"==this.model.render_mode?this._css_box.bind(this):this._canvas_box.bind(this);o(this.sleft,this.sright,this.sbottom,this.stop)}else s.undisplay(this.el)},e.prototype._css_box=function(t,e,i,n){var r=this.model.properties.line_width.value(),o=Math.floor(e-t)-r,a=Math.floor(i-n)-r;this.el.style.left=t+"px",this.el.style.width=o+"px",this.el.style.top=n+"px",this.el.style.height=a+"px",this.el.style.borderWidth=r+"px",this.el.style.borderColor=this.model.properties.line_color.value(),this.el.style.backgroundColor=this.model.properties.fill_color.value(),this.el.style.opacity=this.model.properties.fill_alpha.value();var l=this.model.properties.line_dash.value().length<2?"solid":"dashed";this.el.style.borderStyle=l,s.display(this.el)},e.prototype._canvas_box=function(t,e,i,n){var r=this.plot_view.canvas_view.ctx;r.save(),r.beginPath(),r.rect(t,n,e-t,i-n),this.visuals.fill.set_value(r),r.fill(),this.visuals.line.set_value(r),r.stroke(),r.restore()},e.prototype.interactive_bbox=function(){var t=this.model.properties.line_width.value()+i.EDGE_TOLERANCE;return new l.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})},e.prototype.interactive_hit=function(t,e){if(null==this.model.in_cursor)return!1;var i=this.interactive_bbox();return i.contains(t,e)},e.prototype.cursor=function(t,e){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(e-this.sbottom)<3||Math.abs(e-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&e>this.stop&&e<this.sbottom?this.model.in_cursor:null},e}(r.AnnotationView);i.BoxAnnotationView=h;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="BoxAnnotation",this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({render_mode:[a.RenderMode,"canvas"],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"],top:[a.Number,null],top_units:[a.SpatialUnits,"data"],bottom:[a.Number,null],bottom_units:[a.SpatialUnits,"data"],left:[a.Number,null],left_units:[a.SpatialUnits,"data"],right:[a.Number,null],right_units:[a.SpatialUnits,"data"]}),this.internal({screen:[a.Boolean,!1],ew_cursor:[a.String,null],ns_cursor:[a.String,null],in_cursor:[a.String,null]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new o.Signal0(this,"data_update")},e.prototype.update=function(t){var e=t.left,i=t.right,n=t.top,r=t.bottom;this.setv({left:e,right:i,top:n,bottom:r,screen:!0},{silent:!0}),this.data_update.emit()},e}(r.Annotation);i.BoxAnnotation=u,u.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(225),s=t(107),a=t(178),l=t(204),h=t(205),u=t(195),c=t(18),_=t(43),p=t(24),d=t(25),f=t(35),v=t(46),m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._set_canvas_image()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.visible.change,function(){return e.plot_view.request_render()}),this.connect(this.model.ticker.change,function(){return e.plot_view.request_render()}),this.connect(this.model.formatter.change,function(){return e.plot_view.request_render()}),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,function(){e._set_canvas_image(),e.plot_view.request_render()})},e.prototype._get_size=function(){if(null==this.model.color_mapper)return{width:0,height:0};var t=this.compute_legend_dimensions(),e=t.width,i=t.height;return{width:e,height:i}},e.prototype._set_canvas_image=function(){var t,e;if(null!=this.model.color_mapper){var i,n,r=this.model.color_mapper.palette;switch("vertical"==this.model.orientation&&(r=p.reversed(r)),this.model.orientation){case"vertical":t=[1,r.length],i=t[0],n=t[1];break;case"horizontal":e=[r.length,1],i=e[0],n=e[1];break;default:throw new Error("unreachable code")}var o=document.createElement("canvas");o.width=i,o.height=n;var s=o.getContext("2d"),l=s.getImageData(0,0,i,n),h=new a.LinearColorMapper({palette:r}).rgba_mapper,u=h.v_compute(p.range(0,r.length));l.data.set(u),s.putImageData(l,0,0),this.image=o}},e.prototype.compute_legend_dimensions=function(){var t,e,i=this._computed_image_dimensions(),n=[i.height,i.width],r=n[0],o=n[1],s=this._get_label_extent(),a=this._title_extent(),l=this._tick_extent(),h=this.model.padding;switch(this.model.orientation){case"vertical":t=r+a+2*h,e=o+l+s+2*h;break;case"horizontal":t=r+a+l+s+2*h,e=o+2*h;break;default:throw new Error("unreachable code")}return{width:e,height:t}},e.prototype.compute_legend_location=function(){var t,e,i=this.compute_legend_dimensions(),n=[i.height,i.width],r=n[0],o=n[1],s=this.model.margin,a=null!=this.panel?this.panel:this.plot_view.frame,l=a.bbox.ranges,h=l[0],u=l[1],c=this.model.location;if(v.isString(c))switch(c){case"top_left":t=h.start+s,e=u.start+s;break;case"top_center":t=(h.end+h.start)/2-o/2,e=u.start+s;break;case"top_right":t=h.end-s-o,e=u.start+s;break;case"bottom_right":t=h.end-s-o,e=u.end-s-r;break;case"bottom_center":t=(h.end+h.start)/2-o/2,e=u.end-s-r;break;case"bottom_left":t=h.start+s,e=u.end-s-r;break;case"center_left":t=h.start+s,e=(u.end+u.start)/2-r/2;break;case"center":t=(h.end+h.start)/2-o/2,e=(u.end+u.start)/2-r/2;break;case"center_right":t=h.end-s-o,e=(u.end+u.start)/2-r/2;break;default:throw new Error("unreachable code")}else{if(!v.isArray(c)||2!=c.length)throw new Error("unreachable code");var _=c[0],p=c[1];t=a.xview.compute(_),e=a.yview.compute(p)-r}return{sx:t,sy:e}},e.prototype.render=function(){if(this.model.visible&&null!=this.model.color_mapper){var t=this.plot_view.canvas_view.ctx;t.save();var e=this.compute_legend_location(),i=e.sx,n=e.sy;t.translate(i,n),this._draw_bbox(t);var r=this._get_image_offset();if(t.translate(r.x,r.y),this._draw_image(t),null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high){var o=this.tick_info();this._draw_major_ticks(t,o),this._draw_minor_ticks(t,o),this._draw_major_labels(t,o)}this.model.title&&this._draw_title(t),t.restore()}},e.prototype._draw_bbox=function(t){var e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_image=function(t){var e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_major_ticks=function(t,e){if(this.visuals.major_tick_line.doit){var i=this._normals(),n=i[0],r=i[1],o=this._computed_image_dimensions(),s=[o.width*n,o.height*r],a=s[0],l=s[1],h=e.coords.major,u=h[0],c=h[1],_=this.model.major_tick_in,p=this.model.major_tick_out;t.save(),t.translate(a,l),this.visuals.major_tick_line.set_value(t);for(var d=0,f=u.length;d<f;d++)t.beginPath(),t.moveTo(Math.round(u[d]+n*p),Math.round(c[d]+r*p)),t.lineTo(Math.round(u[d]-n*_),Math.round(c[d]-r*_)),t.stroke();t.restore()}},e.prototype._draw_minor_ticks=function(t,e){if(this.visuals.minor_tick_line.doit){var i=this._normals(),n=i[0],r=i[1],o=this._computed_image_dimensions(),s=[o.width*n,o.height*r],a=s[0],l=s[1],h=e.coords.minor,u=h[0],c=h[1],_=this.model.minor_tick_in,p=this.model.minor_tick_out;t.save(),t.translate(a,l),this.visuals.minor_tick_line.set_value(t);for(var d=0,f=u.length;d<f;d++)t.beginPath(),t.moveTo(Math.round(u[d]+n*p),Math.round(c[d]+r*p)),t.lineTo(Math.round(u[d]-n*_),Math.round(c[d]-r*_)),t.stroke();t.restore()}},e.prototype._draw_major_labels=function(t,e){if(this.visuals.major_label_text.doit){var i=this._normals(),n=i[0],r=i[1],o=this._computed_image_dimensions(),s=[o.width*n,o.height*r],a=s[0],l=s[1],h=this.model.label_standoff+this._tick_extent(),u=[h*n,h*r],c=u[0],_=u[1],p=e.coords.major,d=p[0],f=p[1],v=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(a+c,l+_);for(var m=0,g=d.length;m<g;m++)t.fillText(v[m],Math.round(d[m]+n*this.model.label_standoff),Math.round(f[m]+r*this.model.label_standoff));t.restore()}},e.prototype._draw_title=function(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())},e.prototype._get_label_extent=function(){var t,e=this.tick_info().labels.major;if(null==this.model.color_mapper.low||null==this.model.color_mapper.high||f.isEmpty(e))t=0;else{var i=this.plot_view.canvas_view.ctx;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":t=p.max(e.map(function(t){return i.measureText(t.toString()).width}));break;case"horizontal":t=_.measure_font(this.visuals.major_label_text.font_value()).height;break;default:throw new Error("unreachable code")}t+=this.model.label_standoff,i.restore()}return t},e.prototype._get_image_offset=function(){var t=this.model.padding,e=this.model.padding+this._title_extent();return{x:t,y:e}},e.prototype._normals=function(){return"vertical"==this.model.orientation?[1,0]:[0,1]},e.prototype._title_extent=function(){var t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style,e=this.model.title?_.measure_font(t).height+this.model.title_standoff:0;return e},e.prototype._tick_extent=function(){return null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high?p.max([this.model.major_tick_out,this.model.minor_tick_out]):0},e.prototype._computed_image_dimensions=function(){var t,e,i=this.plot_view.frame._height.value,n=this.plot_view.frame._width.value,r=this._title_extent();switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?t=i-2*this.model.padding-r:(t=p.max([25*this.model.color_mapper.palette.length,.3*i]),t=p.min([t,.8*i-2*this.model.padding-r])):t=this.model.height,e="auto"==this.model.width?25:this.model.width;break;case"horizontal":t="auto"==this.model.height?25:this.model.height,"auto"==this.model.width?null!=this.panel?e=n-2*this.model.padding:(e=p.max([25*this.model.color_mapper.palette.length,.3*n]),e=p.min([e,.8*n-2*this.model.padding])):e=this.model.width;break;default:throw new Error("unreachable code")}return{width:e,height:t}},e.prototype._tick_coordinate_scale=function(t){var e={source_range:new u.Range1d({start:this.model.color_mapper.low,end:this.model.color_mapper.high}),target_range:new u.Range1d({start:0,end:t})};switch(this.model.color_mapper.type){case"LinearColorMapper":return new l.LinearScale(e);case"LogColorMapper":return new h.LogScale(e);default:throw new Error("unreachable code")}},e.prototype._format_major_labels=function(t,e){for(var i=this.model.formatter.doFormat(t,null),n=0,r=e.length;n<r;n++)e[n]in this.model.major_label_overrides&&(i[n]=this.model.major_label_overrides[e[n]]);return i},e.prototype.tick_info=function(){var t,e=this._computed_image_dimensions();switch(this.model.orientation){case"vertical":t=e.height;break;case"horizontal":t=e.width;break;default:throw new Error("unreachable code")}for(var i=this._tick_coordinate_scale(t),n=this._normals(),r=n[0],o=n[1],s=[this.model.color_mapper.low,this.model.color_mapper.high],a=s[0],l=s[1],h=this.model.ticker.get_ticks(a,l,null,null,this.model.ticker.desired_num_ticks),u=h.major,c=h.minor,_=[[],[]],p=[[],[]],f=0,v=u.length;f<v;f++)u[f]<a||u[f]>l||(_[r].push(u[f]),_[o].push(0));for(var f=0,v=c.length;f<v;f++)c[f]<a||c[f]>l||(p[r].push(c[f]),p[o].push(0));var m={major:this._format_major_labels(_[r],u)},g={major:[[],[]],minor:[[],[]]};return g.major[r]=i.v_compute(_[r]),g.minor[r]=i.v_compute(p[r]),g.major[o]=_[o],g.minor[o]=p[o],"vertical"==this.model.orientation&&(g.major[r]=d.map(g.major[r],function(e){return t-e}),g.minor[r]=d.map(g.minor[r],function(e){return t-e})),{coords:g,labels:m}},e}(r.AnnotationView);i.ColorBarView=m;var g=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ColorBar",this.prototype.default_view=m,this.mixins(["text:major_label_","text:title_","line:major_tick_","line:minor_tick_","line:border_","line:bar_","fill:background_"]),this.define({location:[c.Any,"top_right"],orientation:[c.Orientation,"vertical"],title:[c.String],title_standoff:[c.Number,2],width:[c.Any,"auto"],height:[c.Any,"auto"],scale_alpha:[c.Number,1],ticker:[c.Instance,function(){return new o.BasicTicker}],formatter:[c.Instance,function(){return new s.BasicTickFormatter}],major_label_overrides:[c.Any,{}],color_mapper:[c.Instance],label_standoff:[c.Number,5],margin:[c.Number,30],padding:[c.Number,10],major_tick_in:[c.Number,5],major_tick_out:[c.Number,0],minor_tick_in:[c.Number,0],minor_tick_out:[c.Number,0]}),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"8pt",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"10pt",title_text_font_style:"italic"})},e}(r.Annotation);i.ColorBar=g,g.initClass()},function(t,e,i){var n=t(63);i.Annotation=n.Annotation;var r=t(64);i.Arrow=r.Arrow;var o=t(65);i.ArrowHead=o.ArrowHead;var s=t(65);i.OpenHead=s.OpenHead;var a=t(65);i.NormalHead=a.NormalHead;var l=t(65);i.TeeHead=l.TeeHead;var h=t(65);i.VeeHead=h.VeeHead;var u=t(66);i.Band=u.Band;var c=t(67);i.BoxAnnotation=c.BoxAnnotation;var _=t(68);i.ColorBar=_.ColorBar;var p=t(70);i.Label=p.Label;var d=t(71);i.LabelSet=d.LabelSet;var f=t(72);i.Legend=f.Legend;var v=t(73);i.LegendItem=v.LegendItem;var m=t(74);i.PolyAnnotation=m.PolyAnnotation;var g=t(75);i.Slope=g.Slope;var y=t(76);i.Span=y.Span;var b=t(77);i.TextAnnotation=b.TextAnnotation;var x=t(78);i.Title=x.Title;var w=t(79);i.ToolbarPanel=w.ToolbarPanel;var k=t(80);i.Tooltip=k.Tooltip;var T=t(81);i.Whisker=T.Whisker},function(t,e,i){var n=t(408),r=t(77),o=t(5),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals.warm_cache()},e.prototype._get_size=function(){var t=this.plot_view.canvas_view.ctx;this.visuals.text.set_value(t);var e=t.measureText(this.model.text),i=e.width,n=e.ascent;return{width:i,height:n}},e.prototype.render=function(){if(this.model.visible||"css"!=this.model.render_mode||o.undisplay(this.el),this.model.visible){var t;switch(this.model.angle_units){case"rad":t=-this.model.angle;break;case"deg":t=-this.model.angle*Math.PI/180;break;default:throw new Error("unreachable code")}var e=null!=this.panel?this.panel:this.plot_view.frame,i=this.plot_view.frame.xscales[this.model.x_range_name],n=this.plot_view.frame.yscales[this.model.y_range_name],r="data"==this.model.x_units?i.compute(this.model.x):e.xview.compute(this.model.x),s="data"==this.model.y_units?n.compute(this.model.y):e.yview.compute(this.model.y);r+=this.model.x_offset,s-=this.model.y_offset;var a="canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this);a(this.plot_view.canvas_view.ctx,this.model.text,r,s,t)}},e}(r.TextAnnotationView);i.LabelView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Label",this.prototype.default_view=a,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[s.Number],x_units:[s.SpatialUnits,"data"],y:[s.Number],y_units:[s.SpatialUnits,"data"],text:[s.String],angle:[s.Angle,0],angle_units:[s.AngleUnits,"rad"],x_offset:[s.Number,0],y_offset:[s.Number,0],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})},e}(r.TextAnnotation);i.Label=l,l.initClass()},function(t,e,i){var n=t(408),r=t(77),o=t(212),s=t(5),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){if(t.prototype.initialize.call(this),this.set_data(this.model.source),"css"==this.model.render_mode)for(var e=0,i=this._text.length;e<i;e++){var n=s.div({class:"bk-annotation-child",style:{display:"none"}});this.el.appendChild(n)}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,function(){e.set_data(e.model.source),e.render()}),this.connect(this.model.source.streaming,function(){e.set_data(e.model.source),e.render()}),this.connect(this.model.source.patching,function(){e.set_data(e.model.source),e.render()}),this.connect(this.model.source.change,function(){e.set_data(e.model.source),e.render()})):(this.connect(this.model.change,function(){e.set_data(e.model.source),e.plot_view.request_render()}),this.connect(this.model.source.streaming,function(){e.set_data(e.model.source),e.plot_view.request_render()}),this.connect(this.model.source.patching,function(){e.set_data(e.model.source),e.plot_view.request_render()}),this.connect(this.model.source.change,function(){e.set_data(e.model.source),e.plot_view.request_render()}))},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e)},e.prototype._map_data=function(){var t=this.plot_view.frame.xscales[this.model.x_range_name],e=this.plot_view.frame.yscales[this.model.y_range_name],i=null!=this.panel?this.panel:this.plot_view.frame,n="data"==this.model.x_units?t.v_compute(this._x):i.xview.v_compute(this._x),r="data"==this.model.y_units?e.v_compute(this._y):i.yview.v_compute(this._y);return[n,r]},e.prototype.render=function(){if(this.model.visible||"css"!=this.model.render_mode||s.undisplay(this.el),this.model.visible)for(var t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),e=this.plot_view.canvas_view.ctx,i=this._map_data(),n=i[0],r=i[1],o=0,a=this._text.length;o<a;o++)t(e,o,this._text[o],n[o]+this._x_offset[o],r[o]-this._y_offset[o],this._angle[o])},e.prototype._get_size=function(){var t=this.plot_view.canvas_view.ctx;this.visuals.text.set_value(t);var e=t.measureText(this._text[0]),i=e.width,n=e.ascent;return{width:i,height:n}},e.prototype._v_canvas_text=function(t,e,i,n,r,o){this.visuals.text.set_vectorize(t,e);var s=this._calculate_bounding_box_dimensions(t,i);t.save(),t.beginPath(),t.translate(n,r),t.rotate(o),t.rect(s[0],s[1],s[2],s[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(i,0,0)),t.restore()},e.prototype._v_css_text=function(t,e,i,n,r,o){var a=this.el.children[e];a.textContent=i,this.visuals.text.set_vectorize(t,e);var l=this._calculate_bounding_box_dimensions(t,i),h=this.visuals.border_line.line_dash.value(),u=h.length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),a.style.position="absolute",a.style.left=n+l[0]+"px",a.style.top=r+l[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",o&&(a.style.transform="rotate("+o+"rad)"),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+u,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),s.display(a)},e}(r.TextAnnotationView);i.LabelSetView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LabelSet",this.prototype.default_view=l,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[a.NumberSpec],y:[a.NumberSpec],x_units:[a.SpatialUnits,"data"],y_units:[a.SpatialUnits,"data"],text:[a.StringSpec,{field:"text"}],angle:[a.AngleSpec,0],x_offset:[a.NumberSpec,{value:0}],y_offset:[a.NumberSpec,{value:0}],source:[a.Instance,function(){return new o.ColumnDataSource}],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})},e}(r.TextAnnotation);i.LabelSet=h,h.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(18),s=t(22),a=t(43),l=t(27),h=t(24),u=t(35),c=t(46),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.cursor=function(t,e){return"none"==this.model.click_policy?null:"pointer"},Object.defineProperty(e.prototype,"legend_padding",{get:function(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0},enumerable:!0,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.plot_view.request_render()}),this.connect(this.model.item_change,function(){return e.plot_view.request_render()})},e.prototype.compute_legend_bbox=function(){var t=this.model.get_legend_names(),e=this.model,i=e.glyph_height,n=e.glyph_width,r=this.model,o=r.label_height,s=r.label_width;this.max_label_height=h.max([a.measure_font(this.visuals.label_text.font_value()).height,o,i]);var _=this.plot_view.canvas_view.ctx;_.save(),this.visuals.label_text.set_value(_),this.text_widths={};for(var p=0,d=t;p<d.length;p++){var f=d[p];this.text_widths[f]=h.max([_.measureText(f).width,s])}this.visuals.title_text.set_value(_),this.title_height=this.model.title?a.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?_.measureText(this.model.title).width:0,_.restore();var v,m,g=Math.max(h.max(u.values(this.text_widths)),0),y=this.model.margin,b=this.legend_padding,x=this.model.spacing,w=this.model.label_standoff;if("vertical"==this.model.orientation)v=t.length*this.max_label_height+Math.max(t.length-1,0)*x+2*b+this.title_height,m=h.max([g+n+w+2*b,this.title_width+2*b]);else{var k=2*b+Math.max(t.length-1,0)*x;for(var T in this.text_widths){var C=this.text_widths[T];k+=h.max([C,s])+n+w}m=h.max([this.title_width+2*b,k]),v=this.max_label_height+this.title_height+2*b}var S,A,M=null!=this.panel?this.panel:this.plot_view.frame,E=M.bbox.ranges,z=E[0],O=E[1],P=this.model.location;if(c.isString(P))switch(P){case"top_left":S=z.start+y,A=O.start+y;break;case"top_center":S=(z.end+z.start)/2-m/2,A=O.start+y;break;case"top_right":S=z.end-y-m,A=O.start+y;break;case"bottom_right":S=z.end-y-m,A=O.end-y-v;break;case"bottom_center":S=(z.end+z.start)/2-m/2,A=O.end-y-v;break;case"bottom_left":S=z.start+y,A=O.end-y-v;break;case"center_left":S=z.start+y,A=(O.end+O.start)/2-v/2;break;case"center":S=(z.end+z.start)/2-m/2,A=(O.end+O.start)/2-v/2;break;case"center_right":S=z.end-y-m,A=(O.end+O.start)/2-v/2;break;default:throw new Error("unreachable code")}else{if(!c.isArray(P)||2!=P.length)throw new Error("unreachable code");var j=P[0],N=P[1];S=M.xview.compute(j),A=M.yview.compute(N)-v}return new l.BBox({left:S,top:A,width:m,height:v})},e.prototype.interactive_bbox=function(){return this.compute_legend_bbox()},e.prototype.interactive_hit=function(t,e){var i=this.interactive_bbox();return i.contains(t,e)},e.prototype.on_hit=function(t,e){for(var i,n,r,o=this.model.glyph_width,s=this.legend_padding,a=this.model.spacing,h=this.model.label_standoff,u=r=s,c=this.compute_legend_bbox(),_="vertical"==this.model.orientation,p=0,d=this.model.items;p<d.length;p++)for(var f=d[p],v=f.get_labels_list_from_label_prop(),m=0,g=v;m<g.length;m++){var y=g[m],b=c.x+u,x=c.y+r+this.title_height,w=void 0,k=void 0;_?(i=[c.width-2*s,this.max_label_height],w=i[0],k=i[1]):(n=[this.text_widths[y]+o+h,this.max_label_height],w=n[0],k=n[1]);var T=new l.BBox({left:b,top:x,width:w,height:k});if(T.contains(t,e)){switch(this.model.click_policy){case"hide":for(var C=0,S=f.renderers;C<S.length;C++){var A=S[C];A.visible=!A.visible}break;case"mute":for(var M=0,E=f.renderers;M<E.length;M++){var A=E[M];A.muted=!A.muted}}return!0}_?r+=this.max_label_height+a:u+=this.text_widths[y]+o+h+a}return!1},e.prototype.render=function(){if(this.model.visible&&0!=this.model.items.length){for(var t=0,e=this.model.items;t<e.length;t++){var i=e[t];i.legend=this.model}var n=this.plot_view.canvas_view.ctx,r=this.compute_legend_bbox();n.save(),this._draw_legend_box(n,r),this._draw_legend_items(n,r),this.model.title&&this._draw_title(n,r),n.restore()}},e.prototype._draw_legend_box=function(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())},e.prototype._draw_legend_items=function(t,e){for(var i=this,n=this.model,r=n.glyph_width,o=n.glyph_height,s=this.legend_padding,a=this.model.spacing,l=this.model.label_standoff,u=s,c=s,_="vertical"==this.model.orientation,p=function(n){var p,f,v=n.get_labels_list_from_label_prop(),m=n.get_field_from_label_prop();if(0==v.length)return"continue";for(var g=function(){switch(i.model.click_policy){case"none":return!0;case"hide":return h.every(n.renderers,function(t){return t.visible});case"mute":return h.every(n.renderers,function(t){return!t.muted})}}(),y=0,b=v;y<b.length;y++){var x=b[y],w=e.x+u,k=e.y+c+d.title_height,T=w+r,C=k+o;_?c+=d.max_label_height+a:u+=d.text_widths[x]+r+l+a,d.visuals.label_text.set_value(t),t.fillText(x,T+l,k+d.max_label_height/2);for(var S=0,A=n.renderers;S<A.length;S++){var M=A[S],E=d.plot_view.renderer_views[M.id];E.draw_legend(t,w,T,k,C,m,x,n.index)}if(!g){var z=void 0,O=void 0;_?(p=[e.width-2*s,d.max_label_height],z=p[0],O=p[1]):(f=[d.text_widths[x]+r+l,d.max_label_height],z=f[0],O=f[1]),t.beginPath(),t.rect(w,k,z,O),d.visuals.inactive_fill.set_value(t),t.fill()}}},d=this,f=0,v=this.model.items;f<v.length;f++){var m=v[f];p(m)}},e.prototype._draw_title=function(t,e){this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())},e.prototype._get_size=function(){var t=this.compute_legend_bbox(),e=t.width,i=t.height;return{width:e+2*this.model.margin,height:i+2*this.model.margin}},e}(r.AnnotationView);i.LegendView=_;var p=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.item_change=new s.Signal0(this,"item_change")},e.initClass=function(){this.prototype.type="Legend",this.prototype.default_view=_,this.mixins(["text:label_","text:title_","fill:inactive_","line:border_","fill:background_"]),this.define({orientation:[o.Orientation,"vertical"],location:[o.Any,"top_right"],title:[o.String],title_standoff:[o.Number,5],label_standoff:[o.Number,5],glyph_height:[o.Number,20],glyph_width:[o.Number,20],label_height:[o.Number,20],label_width:[o.Number,20],margin:[o.Number,10],padding:[o.Number,10],spacing:[o.Number,3],items:[o.Array,[]],click_policy:[o.Any,"none"]}),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"10pt",label_text_baseline:"middle",title_text_font_size:"10pt",title_text_font_style:"italic"})},e.prototype.get_legend_names=function(){for(var t=[],e=0,i=this.items;e<i.length;e++){var n=i[e],r=n.get_labels_list_from_label_prop();t.push.apply(t,r)}return t},e}(r.Annotation);i.Legend=p,p.initClass()},function(t,e,i){var n=t(408),r=t(62),o=t(213),s=t(49),a=t(18),l=t(17),h=t(24),u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LegendItem",this.define({label:[a.StringSpec,null],renderers:[a.Array,[]],index:[a.Number,null]})},e.prototype._check_data_sources_on_renderers=function(){var t=this.get_field_from_label_prop();if(null!=t){if(this.renderers.length<1)return!1;var e=this.renderers[0].data_source;if(null!=e)for(var i=0,n=this.renderers;i<n.length;i++){var r=n[i];if(r.data_source!=e)return!1}}return!0},e.prototype._check_field_label_on_data_source=function(){var t=this.get_field_from_label_prop();if(null!=t){if(this.renderers.length<1)return!1;var e=this.renderers[0].data_source;if(null!=e&&!h.includes(e.columns(),t))return!1}return!0},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.legend=null,this.connect(this.change,function(){null!=e.legend&&e.legend.item_change.emit()});var i=this._check_data_sources_on_renderers();i||l.logger.error("Non matching data sources on legend item renderers");var n=this._check_field_label_on_data_source();n||l.logger.error("Bad column name on label: "+this.label)},e.prototype.get_field_from_label_prop=function(){var t=this.label;return s.isField(t)?t.field:null},e.prototype.get_labels_list_from_label_prop=function(){if(s.isValue(this.label)){var t=this.label.value;return null!=t?[t]:[]}var e=this.get_field_from_label_prop();if(null!=e){var i=void 0;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((i=this.renderers[0].data_source)instanceof o.ColumnarDataSource){var n=i.get_column(e);return null!=n?h.uniq(Array.from(n)):["Invalid field"]}}return[]},e}(r.Model);i.LegendItem=u,u.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(22),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.plot_view.request_render()}),this.connect(this.model.data_update,function(){return e.plot_view.request_render()})},e.prototype.render=function(){if(this.model.visible){var t=this.model,e=t.xs,i=t.ys;if(e.length==i.length&&!(e.length<3||i.length<3)){for(var n=this.plot_view.frame,r=this.plot_view.canvas_view.ctx,o=0,s=e.length;o<s;o++){var a=void 0;if("screen"!=this.model.xs_units)throw new Error("not implemented");a=this.model.screen?e[o]:n.xview.compute(e[o]);var l=void 0;if("screen"!=this.model.ys_units)throw new Error("not implemented");l=this.model.screen?i[o]:n.yview.compute(i[o]),0==o?(r.beginPath(),r.moveTo(a,l)):r.lineTo(a,l)}r.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(r),r.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(r),r.fill())}}},e}(r.AnnotationView);i.PolyAnnotationView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="PolyAnnotation",this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({xs:[s.Array,[]],xs_units:[s.SpatialUnits,"data"],ys:[s.Array,[]],ys_units:[s.SpatialUnits,"data"],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.internal({screen:[s.Boolean,!1]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new o.Signal0(this,"data_update")},e.prototype.update=function(t){var e=t.xs,i=t.ys;this.setv({xs:e,ys:i,screen:!0},{silent:!0}),this.data_update.emit()},e}(r.Annotation);i.PolyAnnotation=l,l.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.plot_view.request_render()})},e.prototype.render=function(){this.model.visible&&this._draw_slope()},e.prototype._draw_slope=function(){var t=this.model.gradient,e=this.model.y_intercept;if(null!=t&&null!=e){var i=this.plot_view.frame,n=i.xscales[this.model.x_range_name],r=i.yscales[this.model.y_range_name],o=i._top.value,s=o+i._height.value,a=r.invert(o),l=r.invert(s),h=(a-e)/t,u=(l-e)/t,c=n.compute(h),_=n.compute(u),p=this.plot_view.canvas_view.ctx;p.save(),p.beginPath(),this.visuals.line.set_value(p),p.moveTo(c,o),p.lineTo(_,s),p.stroke(),p.restore()}},e}(r.AnnotationView);i.SlopeView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Slope",this.prototype.default_view=s,this.mixins(["line"]),this.define({gradient:[o.Number,null],y_intercept:[o.Number,null],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({line_color:"black"})},e}(r.Annotation);i.Slope=a,a.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(5),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_overlays.appendChild(this.el),this.el.style.position="absolute",o.undisplay(this.el)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.model.for_hover?this.connect(this.model.properties.computed_location.change,function(){return e._draw_span()}):"canvas"==this.model.render_mode?(this.connect(this.model.change,function(){return e.plot_view.request_render()}),this.connect(this.model.properties.location.change,function(){return e.plot_view.request_render()})):(this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.properties.location.change,function(){return e._draw_span()}))},e.prototype.render=function(){this.model.visible||"css"!=this.model.render_mode||o.undisplay(this.el),this.model.visible&&this._draw_span()},e.prototype._draw_span=function(){var t=this,e=this.model.for_hover?this.model.computed_location:this.model.location;if(null!=e){var i,n,r,s,a=this.plot_view.frame,l=a.xscales[this.model.x_range_name],h=a.yscales[this.model.y_range_name],u=function(i,n){return t.model.for_hover?t.model.computed_location:"data"==t.model.location_units?i.compute(e):n.compute(e)};if("width"==this.model.dimension?(r=u(h,a.yview),n=a._left.value,s=a._width.value,i=this.model.properties.line_width.value()):(r=a._top.value,n=u(l,a.xview),s=this.model.properties.line_width.value(),i=a._height.value),"css"==this.model.render_mode)this.el.style.top=r+"px",this.el.style.left=n+"px",this.el.style.width=s+"px",this.el.style.height=i+"px",this.el.style.backgroundColor=this.model.properties.line_color.value(),this.el.style.opacity=this.model.properties.line_alpha.value(),o.display(this.el);else if("canvas"==this.model.render_mode){var c=this.plot_view.canvas_view.ctx;c.save(),c.beginPath(),this.visuals.line.set_value(c),c.moveTo(n,r),"width"==this.model.dimension?c.lineTo(n+s,r):c.lineTo(n,r+i),c.stroke(),c.restore()}}else o.undisplay(this.el)},e}(r.AnnotationView);i.SpanView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Span",this.prototype.default_view=a,this.mixins(["line"]),this.define({render_mode:[s.RenderMode,"canvas"],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"],location:[s.Number,null],location_units:[s.SpatialUnits,"data"],dimension:[s.Dimension,"width"]}),this.override({line_color:"black"}),this.internal({for_hover:[s.Boolean,!1],computed_location:[s.Number,null]})},e}(r.Annotation);i.Span=l,l.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(5),s=t(18),a=t(43),l=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.rotate=!0,e}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),"css"==this.model.render_mode&&(this.el.classList.add("bk-annotation"),this.plot_view.canvas_overlays.appendChild(this.el))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?this.connect(this.model.change,function(){return e.render()}):this.connect(this.model.change,function(){return e.plot_view.request_render()})},e.prototype._calculate_text_dimensions=function(t,e){var i=t.measureText(e).width,n=a.measure_font(this.visuals.text.font_value()).height;return[i,n]},e.prototype._calculate_bounding_box_dimensions=function(t,e){var i,n,r=this._calculate_text_dimensions(t,e),o=r[0],s=r[1];switch(t.textAlign){case"left":i=0;break;case"center":i=-o/2;break;case"right":i=-o;break;default:throw new Error("unreachable code")}switch(t.textBaseline){case"top":n=0;break;case"middle":n=-.5*s;break;case"bottom":n=-1*s;break;case"alphabetic":n=-.8*s;break;case"hanging":n=-.17*s;break;case"ideographic":n=-.83*s;break;default:throw new Error("unreachable code")}return[i,n,o,s]},e.prototype._canvas_text=function(t,e,i,n,r){this.visuals.text.set_value(t);var o=this._calculate_bounding_box_dimensions(t,e);t.save(),t.beginPath(),t.translate(i,n),r&&t.rotate(r),t.rect(o[0],o[1],o[2],o[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(t),t.fillText(e,0,0)),t.restore()},e.prototype._css_text=function(t,e,i,n,r){o.undisplay(this.el),this.visuals.text.set_value(t);var s=this._calculate_bounding_box_dimensions(t,e),a=this.visuals.border_line.line_dash.value(),l=a.length<2?"solid":"dashed";this.visuals.border_line.set_value(t),this.visuals.background_fill.set_value(t),this.el.style.position="absolute",this.el.style.left=i+s[0]+"px",this.el.style.top=n+s[1]+"px",this.el.style.color=""+this.visuals.text.text_color.value(),this.el.style.opacity=""+this.visuals.text.text_alpha.value(),this.el.style.font=""+this.visuals.text.font_value(),this.el.style.lineHeight="normal",r&&(this.el.style.transform="rotate("+r+"rad)"),this.visuals.background_fill.doit&&(this.el.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(this.el.style.borderStyle=""+l,this.el.style.borderWidth=this.visuals.border_line.line_width.value()+"px",this.el.style.borderColor=""+this.visuals.border_line.color_value()),this.el.textContent=e,o.display(this.el)},e}(r.AnnotationView);i.TextAnnotationView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="TextAnnotation",this.define({render_mode:[s.RenderMode,"canvas"]})},e}(r.Annotation);i.TextAnnotation=h,h.initClass()},function(t,e,i){var n=t(408),r=t(77),o=t(5),s=t(51),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals.text=new s.Text(this.model)},e.prototype._get_location=function(){var t,e,i=this.panel,n=this.model.offset;switch(i.side){case"above":case"below":switch(this.model.vertical_align){case"top":e=i._top.value+5;break;case"middle":e=i._vcenter.value;break;case"bottom":e=i._bottom.value-5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":t=i._left.value+n;break;case"center":t=i._hcenter.value;break;case"right":t=i._right.value-n;break;default:throw new Error("unreachable code")}break;case"left":switch(this.model.vertical_align){case"top":t=i._left.value-5;break;case"middle":t=i._hcenter.value;break;case"bottom":t=i._right.value+5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":e=i._bottom.value-n;break;case"center":e=i._vcenter.value;break;case"right":e=i._top.value+n;break;default:throw new Error("unreachable code")}break;case"right":switch(this.model.vertical_align){case"top":t=i._right.value-5;break;case"middle":t=i._hcenter.value;break;case"bottom":t=i._left.value+5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":e=i._top.value+n;break;case"center":e=i._vcenter.value;break;case"right":e=i._bottom.value-n;break;default:throw new Error("unreachable code")}break;default:throw new Error("unreachable code")}return[t,e]},e.prototype.render=function(){if(this.model.visible){var t=this.model.text;if(null!=t&&0!=t.length){this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;var e=this._get_location(),i=e[0],n=e[1],r=this.panel.get_label_angle_heuristic("parallel"),s="canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this);s(this.plot_view.canvas_view.ctx,t,i,n,r)}}else"css"==this.model.render_mode&&o.undisplay(this.el)},e.prototype._get_size=function(){var t=this.model.text;if(null==t||0==t.length)return{width:0,height:0};this.visuals.text.set_value(this.ctx);var e=this.ctx.measureText(t),i=e.width,n=e.ascent;return{width:i,height:n+10}},e}(r.TextAnnotationView);i.TitleView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Title",this.prototype.default_view=l,this.mixins(["line:border_","fill:background_"]),this.define({text:[a.String],text_font:[a.Font,"helvetica"],text_font_size:[a.FontSizeSpec,"10pt"],text_font_style:[a.FontStyle,"bold"],text_color:[a.ColorSpec,"#444444"],text_alpha:[a.NumberSpec,1],vertical_align:[a.VerticalAlign,"bottom"],align:[a.TextAlign,"left"],offset:[a.Number,0]}),this.override({background_fill_color:null,border_line_color:null}),this.internal({text_align:[a.TextAlign,"left"],text_baseline:[a.TextBaseline,"bottom"]})},e}(r.TextAnnotation);i.Title=h,h.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(4),s=t(5),a=t(18),l=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.rotate=!0,e}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_events.appendChild(this.el),this._toolbar_views={},o.build_views(this._toolbar_views,[this.model.toolbar],{parent:this});var e=this._toolbar_views[this.model.toolbar.id];this.plot_view.visibility_callbacks.push(function(t){return e.set_visibility(t)})},e.prototype.remove=function(){o.remove_views(this._toolbar_views),t.prototype.remove.call(this)},e.prototype.render=function(){if(t.prototype.render.call(this),this.model.visible){this.el.style.position="absolute",this.el.style.overflow="hidden",s.position(this.el,this.panel.bbox);var e=this._toolbar_views[this.model.toolbar.id];e.render(),s.empty(this.el),this.el.appendChild(e.el),s.display(this.el)}else s.undisplay(this.el)},e.prototype._get_size=function(){var t=this.model.toolbar,e=t.tools,i=t.logo;return{width:30*e.length+(null!=i?25:0),height:30}},e}(r.AnnotationView);i.ToolbarPanelView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ToolbarPanel",this.prototype.default_view=l,this.define({toolbar:[a.Instance]})},e}(r.Annotation);i.ToolbarPanel=h,h.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(5),s=t(18);function a(t,e,i,n,r){var o;switch(t){case"horizontal":o=e<n?"right":"left";break;case"vertical":o=i<r?"below":"above";break;default:o=t}return o}i.compute_side=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_overlays.appendChild(this.el),o.undisplay(this.el)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.data.change,function(){return e._draw_tips()})},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-tooltip")},e.prototype.render=function(){this.model.visible&&this._draw_tips()},e.prototype._draw_tips=function(){var t=this.model.data;if(o.empty(this.el),o.undisplay(this.el),this.model.custom?this.el.classList.add("bk-tooltip-custom"):this.el.classList.remove("bk-tooltip-custom"),0!=t.length){for(var e=this.plot_view.frame,i=0,n=t;i<n.length;i++){var r=n[i],s=r[0],l=r[1],h=r[2];if(!this.model.inner_only||e.bbox.contains(s,l)){var u=o.div({},h);this.el.appendChild(u)}}var c,_,p=t[t.length-1],d=p[0],f=p[1],v=a(this.model.attachment,d,f,e._hcenter.value,e._vcenter.value);switch(this.el.classList.remove("bk-right"),this.el.classList.remove("bk-left"),this.el.classList.remove("bk-above"),this.el.classList.remove("bk-below"),o.display(this.el),v){case"right":this.el.classList.add("bk-left"),c=d+(this.el.offsetWidth-this.el.clientWidth)+10,_=f-this.el.offsetHeight/2;break;case"left":this.el.classList.add("bk-right"),c=d-this.el.offsetWidth-10,_=f-this.el.offsetHeight/2;break;case"below":this.el.classList.add("bk-above"),_=f+(this.el.offsetHeight-this.el.clientHeight)+10,c=Math.round(d-this.el.offsetWidth/2);break;case"above":this.el.classList.add("bk-below"),_=f-this.el.offsetHeight-10,c=Math.round(d-this.el.offsetWidth/2);break;default:throw new Error("unreachable code")}this.model.show_arrow&&this.el.classList.add("bk-tooltip-arrow"),this.el.childNodes.length>0?(this.el.style.top=_+"px",this.el.style.left=c+"px"):o.undisplay(this.el)}},e}(r.AnnotationView);i.TooltipView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Tooltip",this.prototype.default_view=l,this.define({attachment:[s.TooltipAttachment,"horizontal"],inner_only:[s.Boolean,!0],show_arrow:[s.Boolean,!0]}),this.override({level:"overlay"}),this.internal({data:[s.Any,[]],custom:[s.Any]})},e.prototype.clear=function(){this.data=[]},e.prototype.add=function(t,e,i){this.data=this.data.concat([[t,e,i]])},e}(r.Annotation);i.Tooltip=h,h.initClass()},function(t,e,i){var n=t(408),r=t(63),o=t(212),s=t(65),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.patching,function(){return e.set_data(e.model.source)}),this.connect(this.model.source.change,function(){return e.set_data(e.model.source)})},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,i,n=this.plot_view.frame,r=this.model.dimension,o=n.xscales[this.model.x_range_name],s=n.yscales[this.model.y_range_name],a="height"==r?s:o,l="height"==r?o:s,h="height"==r?n.yview:n.xview,u="height"==r?n.xview:n.yview;t="data"==this.model.properties.lower.units?a.v_compute(this._lower):h.v_compute(this._lower),e="data"==this.model.properties.upper.units?a.v_compute(this._upper):h.v_compute(this._upper),i="data"==this.model.properties.base.units?l.v_compute(this._base):u.v_compute(this._base);var c="height"==r?[1,0]:[0,1],_=c[0],p=c[1],d=[t,i],f=[e,i];this._lower_sx=d[_],this._lower_sy=d[p],this._upper_sx=f[_],this._upper_sy=f[p]},e.prototype.render=function(){if(this.model.visible){this._map_data();var t=this.plot_view.canvas_view.ctx;if(this.visuals.line.doit)for(var e=0,i=this._lower_sx.length;e<i;e++)this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(this._lower_sx[e],this._lower_sy[e]),t.lineTo(this._upper_sx[e],this._upper_sy[e]),t.stroke();var n="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(var e=0,i=this._lower_sx.length;e<i;e++)t.save(),t.translate(this._lower_sx[e],this._lower_sy[e]),t.rotate(n+Math.PI),this.model.lower_head.render(t,e),t.restore();if(null!=this.model.upper_head)for(var e=0,i=this._upper_sx.length;e<i;e++)t.save(),t.translate(this._upper_sx[e],this._upper_sy[e]),t.rotate(n),this.model.upper_head.render(t,e),t.restore()}},e}(r.AnnotationView);i.WhiskerView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Whisker",this.prototype.default_view=l,this.mixins(["line"]),this.define({lower:[a.DistanceSpec],lower_head:[a.Instance,function(){return new s.TeeHead({level:"underlay",size:10})}],upper:[a.DistanceSpec],upper_head:[a.Instance,function(){return new s.TeeHead({level:"underlay",size:10})}],base:[a.DistanceSpec],dimension:[a.Dimension,"height"],source:[a.Instance,function(){return new o.ColumnDataSource}],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({level:"underlay"})},e}(r.Annotation);i.Whisker=h,h.initClass()},function(t,e,i){var n=t(408),r=t(199),o=t(18),s=t(24),a=t(46),l=t(192),h=Math.abs,u=Math.min,c=Math.max,_=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.rotate=!0,e}return n.__extends(e,t),Object.defineProperty(e.prototype,"panel",{get:function(){return this.layout},enumerable:!0,configurable:!0}),e.prototype.render=function(){if(this.model.visible){var t={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},e=this.tick_coords,i=this.plot_view.canvas_view.ctx;i.save(),this._draw_rule(i,t),this._draw_major_ticks(i,t,e),this._draw_minor_ticks(i,t,e),this._draw_major_labels(i,t,e),this._draw_axis_label(i,t,e),null!=this._render&&this._render(i,t,e),i.restore()}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.plot_view.request_paint()});var i=this.model.properties;this.on_change(i.visible,function(){return e.plot_view.request_layout()})},e.prototype.get_size=function(){if(this.model.visible&&null==this.model.fixed_location){var t=this._get_size();return{width:0,height:Math.round(t)}}return{width:0,height:0}},e.prototype._get_size=function(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null!=this.model.fixed_location},enumerable:!0,configurable:!0}),e.prototype._draw_rule=function(t,e){if(this.visuals.axis_line.doit){var i=this.rule_coords,n=i[0],r=i[1],o=this.plot_view.map_to_screen(n,r,this.model.x_range_name,this.model.y_range_name),s=o[0],a=o[1],l=this.normals,h=l[0],u=l[1],c=this.offsets,_=c[0],p=c[1];this.visuals.axis_line.set_value(t),t.beginPath(),t.moveTo(Math.round(s[0]+h*_),Math.round(a[0]+u*p));for(var d=1;d<s.length;d++){var f=Math.round(s[d]+h*_),v=Math.round(a[d]+u*p);t.lineTo(f,v)}t.stroke()}},e.prototype._draw_major_ticks=function(t,e,i){var n=this.model.major_tick_in,r=this.model.major_tick_out,o=this.visuals.major_tick_line;this._draw_ticks(t,i.major,n,r,o)},e.prototype._draw_minor_ticks=function(t,e,i){var n=this.model.minor_tick_in,r=this.model.minor_tick_out,o=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,n,r,o)},e.prototype._draw_major_labels=function(t,e,i){var n=i.major,r=this.compute_labels(n[this.dimension]),o=this.model.major_label_orientation,s=e.tick+this.model.major_label_standoff,a=this.visuals.major_label_text;this._draw_oriented_labels(t,r,n,o,this.panel.side,s,a)},e.prototype._draw_axis_label=function(t,e,i){if(null!=this.model.axis_label&&0!=this.model.axis_label.length&&null==this.model.fixed_location){var n,r;switch(this.panel.side){case"above":n=this.panel._hcenter.value,r=this.panel._bottom.value;break;case"below":n=this.panel._hcenter.value,r=this.panel._top.value;break;case"left":n=this.panel._right.value,r=this.panel._vcenter.value;break;case"right":n=this.panel._left.value,r=this.panel._vcenter.value;break;default:throw new Error("unknown side: "+this.panel.side)}var o=[[n],[r]],a=e.tick+s.sum(e.tick_label)+this.model.axis_label_standoff,l=this.visuals.axis_label_text;this._draw_oriented_labels(t,[this.model.axis_label],o,"parallel",this.panel.side,a,l,"screen")}},e.prototype._draw_ticks=function(t,e,i,n,r){if(r.doit){var o=e[0],s=e[1],a=this.plot_view.map_to_screen(o,s,this.model.x_range_name,this.model.y_range_name),l=a[0],h=a[1],u=this.normals,c=u[0],_=u[1],p=this.offsets,d=p[0],f=p[1],v=[c*(d-i),_*(f-i)],m=v[0],g=v[1],y=[c*(d+n),_*(f+n)],b=y[0],x=y[1];r.set_value(t);for(var w=0;w<l.length;w++){var k=Math.round(l[w]+b),T=Math.round(h[w]+x),C=Math.round(l[w]+m),S=Math.round(h[w]+g);t.beginPath(),t.moveTo(k,T),t.lineTo(C,S),t.stroke()}}},e.prototype._draw_oriented_labels=function(t,e,i,n,r,o,s,l){var h,u,c;if(void 0===l&&(l="data"),s.doit&&0!=e.length){var _,p,d,f;if("screen"==l)_=i[0],p=i[1],d=(h=[0,0])[0],f=h[1];else{var v=i[0],m=i[1];u=this.plot_view.map_to_screen(v,m,this.model.x_range_name,this.model.y_range_name),_=u[0],p=u[1],c=this.offsets,d=c[0],f=c[1]}var g,y=this.normals,b=y[0],x=y[1],w=b*(d+o),k=x*(f+o);s.set_value(t),this.panel.apply_label_text_heuristics(t,n),g=a.isString(n)?this.panel.get_label_angle_heuristic(n):-n;for(var T=0;T<_.length;T++){var C=Math.round(_[T]+w),S=Math.round(p[T]+k);t.translate(C,S),t.rotate(g),t.fillText(e[T],0,0),t.rotate(-g),t.translate(-C,-S)}}},e.prototype._axis_label_extent=function(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;var t=this.model.axis_label_standoff,e=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,t,e)},e.prototype._tick_extent=function(){return this.model.major_tick_out},e.prototype._tick_label_extent=function(){return s.sum(this._tick_label_extents())},e.prototype._tick_label_extents=function(){var t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,n=this.model.major_label_standoff,r=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,this.panel.side,n,r)]},e.prototype._oriented_labels_extent=function(t,e,i,n,r){if(0==t.length)return 0;var o,s,l=this.plot_view.canvas_view.ctx;r.set_value(l),a.isString(e)?(o=1,s=this.panel.get_label_angle_heuristic(e)):(o=2,s=-e),s=Math.abs(s);for(var h=Math.cos(s),u=Math.sin(s),c=0,_=0;_<t.length;_++){var p=1.1*l.measureText(t[_]).width,d=.9*l.measureText(t[_]).ascent,f=void 0;(f="above"==i||"below"==i?p*u+d/o*h:p*h+d/o*u)>c&&(c=f)}return c>0&&(c+=n),c},Object.defineProperty(e.prototype,"normals",{get:function(){return this.panel.normals},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"dimension",{get:function(){return this.panel.dimension},enumerable:!0,configurable:!0}),e.prototype.compute_labels=function(t){for(var e=this.model.formatter.doFormat(t,this),i=0;i<t.length;i++)t[i]in this.model.major_label_overrides&&(e[i]=this.model.major_label_overrides[t[i]]);return e},Object.defineProperty(e.prototype,"offsets",{get:function(){if(null!=this.model.fixed_location)return[0,0];var t=this.plot_view.frame,e=[0,0],i=e[0],n=e[1];switch(this.panel.side){case"below":n=h(this.panel._top.value-t._bottom.value);break;case"above":n=h(this.panel._bottom.value-t._top.value);break;case"right":i=h(this.panel._left.value-t._right.value);break;case"left":i=h(this.panel._right.value-t._left.value)}return[i,n]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"ranges",{get:function(){var t=this.dimension,e=(t+1)%2,i=this.plot_view.frame,n=[i.x_ranges[this.model.x_range_name],i.y_ranges[this.model.y_range_name]];return[n[t],n[e]]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_bounds",{get:function(){var t=this.ranges[0],e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];if(a.isArray(e)){var n=void 0,r=void 0,o=e[0],s=e[1],l=i[0],_=i[1];return h(o-s)>h(l-_)?(n=c(u(o,s),l),r=u(c(o,s),_)):(n=u(o,s),r=c(o,s)),[n,r]}throw new Error("user bounds '"+e+"' not understood")},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"rule_coords",{get:function(){var t=this.dimension,e=(t+1)%2,i=this.ranges[0],n=this.computed_bounds,r=n[0],o=n[1],s=new Array(2),a=new Array(2),l=[s,a];return l[t][0]=Math.max(r,i.min),l[t][1]=Math.min(o,i.max),l[t][0]>l[t][1]&&(l[t][0]=l[t][1]=NaN),l[e][0]=this.loc,l[e][1]=this.loc,l},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"tick_coords",{get:function(){for(var t=this.dimension,e=(t+1)%2,i=this.ranges[0],n=this.computed_bounds,r=n[0],o=n[1],s=this.model.ticker.get_ticks(r,o,i,this.loc,{}),a=s.major,l=s.minor,h=[[],[]],u=[[],[]],c=[i.min,i.max],_=c[0],p=c[1],d=0;d<a.length;d++)a[d]<_||a[d]>p||(h[t].push(a[d]),h[e].push(this.loc));for(var d=0;d<l.length;d++)l[d]<_||l[d]>p||(u[t].push(l[d]),u[e].push(this.loc));return{major:h,minor:u}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"loc",{get:function(){var t=this.model.fixed_location;if(null!=t){if(a.isNumber(t))return t;var e=this.ranges,i=e[1];if(i instanceof l.FactorRange)return i.synthetic(t);throw new Error("unexpected")}var n=this.ranges,r=n[1];switch(this.panel.side){case"left":case"below":return r.start;case"right":case"above":return r.end}},enumerable:!0,configurable:!0}),e.prototype.serializable_state=function(){return n.__assign({},t.prototype.serializable_state.call(this),{bbox:this.layout.bbox.rect})},e}(r.GuideRendererView);i.AxisView=_;var p=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Axis",this.prototype.default_view=_,this.mixins(["line:axis_","line:major_tick_","line:minor_tick_","text:major_label_","text:axis_label_"]),this.define({bounds:[o.Any,"auto"],ticker:[o.Instance],formatter:[o.Instance],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"],axis_label:[o.String,""],axis_label_standoff:[o.Int,5],major_label_standoff:[o.Int,5],major_label_orientation:[o.Any,"horizontal"],major_label_overrides:[o.Any,{}],major_tick_in:[o.Number,2],major_tick_out:[o.Number,6],minor_tick_in:[o.Number,0],minor_tick_out:[o.Number,4],fixed_location:[o.Any,null]}),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"8pt",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"10pt",axis_label_text_font_style:"italic"})},e}(r.GuideRenderer);i.Axis=p,p.initClass()},function(t,e,i){var n=t(408),r=t(82),o=t(226),s=t(108),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){this._draw_group_separators(t,e,i)},e.prototype._draw_group_separators=function(t,e,i){var n,r=this.ranges[0],o=this.computed_bounds,s=o[0],a=o[1];if(r.tops&&!(r.tops.length<2)&&this.visuals.separator_line.doit){for(var l=this.dimension,h=(l+1)%2,u=[[],[]],c=0,_=0;_<r.tops.length-1;_++){for(var p=void 0,d=void 0,f=c;f<r.factors.length;f++)if(r.factors[f][0]==r.tops[_+1]){n=[r.factors[f-1],r.factors[f]],p=n[0],d=n[1],c=f;break}var v=(r.synthetic(p)+r.synthetic(d))/2;v>s&&v<a&&(u[l].push(v),u[h].push(this.loc))}var m=this._tick_label_extent();this._draw_ticks(t,u,-3,m-6,this.visuals.separator_line)}},e.prototype._draw_major_labels=function(t,e,i){for(var n=this._get_factor_info(),r=e.tick+this.model.major_label_standoff,o=0;o<n.length;o++){var s=n[o],a=s[0],l=s[1],h=s[2],u=s[3];this._draw_oriented_labels(t,a,l,h,this.panel.side,r,u),r+=e.tick_label[o]}},e.prototype._tick_label_extents=function(){for(var t=this._get_factor_info(),e=[],i=0,n=t;i<n.length;i++){var r=n[i],o=r[0],s=r[2],a=r[3],l=this._oriented_labels_extent(o,s,this.panel.side,this.model.major_label_standoff,a);e.push(l)}return e},e.prototype._get_factor_info=function(){var t=this.ranges[0],e=this.computed_bounds,i=e[0],n=e[1],r=this.loc,o=this.model.ticker.get_ticks(i,n,t,r,{}),s=this.tick_coords,a=[];if(1==t.levels){var l=o.major,h=this.model.formatter.doFormat(l,this);a.push([h,s.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){var l=o.major.map(function(t){return t[1]}),h=this.model.formatter.doFormat(l,this);a.push([h,s.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([o.tops,s.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){var l=o.major.map(function(t){return t[2]}),h=this.model.formatter.doFormat(l,this),u=o.mids.map(function(t){return t[1]});a.push([h,s.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([u,s.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([o.tops,s.tops,this.model.group_label_orientation,this.visuals.group_text])}return a},Object.defineProperty(e.prototype,"tick_coords",{get:function(){var t=this,e=this.dimension,i=(e+1)%2,n=this.ranges[0],r=this.computed_bounds,o=r[0],s=r[1],a=this.model.ticker.get_ticks(o,s,n,this.loc,{}),l={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return l.major[e]=a.major,l.major[i]=a.major.map(function(e){return t.loc}),3==n.levels&&(l.mids[e]=a.mids),l.mids[i]=a.mids.map(function(e){return t.loc}),n.levels>1&&(l.tops[e]=a.tops),l.tops[i]=a.tops.map(function(e){return t.loc}),l},enumerable:!0,configurable:!0}),e}(r.AxisView);i.CategoricalAxisView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CategoricalAxis",this.prototype.default_view=l,this.mixins(["line:separator_","text:group_","text:subgroup_"]),this.define({group_label_orientation:[a.Any,"parallel"],subgroup_label_orientation:[a.Any,"parallel"]}),this.override({ticker:function(){return new o.CategoricalTicker},formatter:function(){return new s.CategoricalTickFormatter},separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"8pt",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"8pt"})},e}(r.Axis);i.CategoricalAxis=h,h.initClass()},function(t,e,i){var n=t(408),r=t(82),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ContinuousAxis"},e}(r.Axis);i.ContinuousAxis=o,o.initClass()},function(t,e,i){var n=t(408),r=t(87),o=t(109),s=t(229),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.LinearAxisView);i.DatetimeAxisView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="DatetimeAxis",this.prototype.default_view=a,this.override({ticker:function(){return new s.DatetimeTicker},formatter:function(){return new o.DatetimeTickFormatter}})},e}(r.LinearAxis);i.DatetimeAxis=l,l.initClass()},function(t,e,i){var n=t(82);i.Axis=n.Axis;var r=t(83);i.CategoricalAxis=r.CategoricalAxis;var o=t(84);i.ContinuousAxis=o.ContinuousAxis;var s=t(85);i.DatetimeAxis=s.DatetimeAxis;var a=t(87);i.LinearAxis=a.LinearAxis;var l=t(88);i.LogAxis=l.LogAxis;var h=t(89);i.MercatorAxis=h.MercatorAxis},function(t,e,i){var n=t(408),r=t(82),o=t(84),s=t(107),a=t(225),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.AxisView);i.LinearAxisView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LinearAxis",this.prototype.default_view=l,this.override({ticker:function(){return new a.BasicTicker},formatter:function(){return new s.BasicTickFormatter}})},e}(o.ContinuousAxis);i.LinearAxis=h,h.initClass()},function(t,e,i){var n=t(408),r=t(82),o=t(84),s=t(112),a=t(233),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.AxisView);i.LogAxisView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LogAxis",this.prototype.default_view=l,this.override({ticker:function(){return new a.LogTicker},formatter:function(){return new s.LogTickFormatter}})},e}(o.ContinuousAxis);i.LogAxis=h,h.initClass()},function(t,e,i){var n=t(408),r=t(82),o=t(87),s=t(113),a=t(234),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.AxisView);i.MercatorAxisView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="MercatorAxis",this.prototype.default_view=l,this.override({ticker:function(){return new a.MercatorTicker({dimension:"lat"})},formatter:function(){return new s.MercatorTickFormatter({dimension:"lat"})}})},e}(o.LinearAxis);i.MercatorAxis=h,h.initClass()},function(t,e,i){var n=t(408),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Callback"},e}(r.Model);i.Callback=o,o.initClass()},function(t,e,i){var n=t(408),r=t(90),o=t(18),s=t(35),a=t(40),l=function(e){function i(t){return e.call(this,t)||this}return n.__extends(i,e),i.initClass=function(){this.prototype.type="CustomJS",this.define({args:[o.Any,{}],code:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(i.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"func",{get:function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0].concat(this.names,["cb_obj","cb_data","require","exports",t])))},enumerable:!0,configurable:!0}),i.prototype.execute=function(e,i){return void 0===i&&(i={}),this.func.apply(e,this.values.concat(e,i,t,{}))},i}(r.Callback);i.CustomJS=l,l.initClass()},function(t,e,i){var n=t(91);i.CustomJS=n.CustomJS;var r=t(93);i.OpenURL=r.OpenURL},function(t,e,i){var n=t(408),r=t(90),o=t(42),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="OpenURL",this.define({url:[s.String,"http://"],same_tab:[s.Boolean,!1]})},e.prototype.execute=function(t,e){for(var i=this,n=e.source,r=function(t){var e=o.replace_placeholders(i.url,n,t);i.same_tab?window.location.href=e:window.open(e)},s=n.selected,a=0,l=s.indices;a<l.length;a++){var h=l[a];r(h)}for(var u=0,c=s.line_indices;u<c.length;u++){var h=c[u];r(h)}},e}(r.Callback);i.OpenURL=a,a.initClass()},function(t,e,i){var n=t(408),r=t(8),o=t(6),s=t(17),a=t(18),l=t(5),h=t(27),u=t(31),c=t(29);u.is_ie&&"undefined"!=typeof CanvasPixelArray&&(CanvasPixelArray.prototype.set=function(t){for(var e=0;e<this.length;e++)this[e]=t[e]});var _=t(305),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"ctx",{get:function(){return this._ctx},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.map_el=this.model.map?this.el.appendChild(l.div({class:"bk-canvas-map"})):null;var e={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};switch(this.model.output_backend){case"canvas":case"webgl":this.canvas_el=this.el.appendChild(l.canvas({class:"bk-canvas",style:e}));var i=this.canvas_el.getContext("2d");if(null==i)throw new Error("unable to obtain 2D rendering context");this._ctx=i;break;case"svg":var i=new _;this._ctx=i,this.canvas_el=this.el.appendChild(i.getSvg())}this.overlays_el=this.el.appendChild(l.div({class:"bk-canvas-overlays",style:e})),this.events_el=this.el.appendChild(l.div({class:"bk-canvas-events",style:e})),c.fixup_ctx(this._ctx),s.logger.debug("CanvasView initialized")},e.prototype.get_canvas_element=function(){return this.canvas_el},e.prototype.prepare_canvas=function(t,e){this.bbox=new h.BBox({left:0,top:0,width:t,height:e}),this.el.style.width=t+"px",this.el.style.height=e+"px";var i=c.get_scale_ratio(this.ctx,this.model.use_hidpi,this.model.output_backend);this.model.pixel_ratio=i,this.canvas_el.style.width=t+"px",this.canvas_el.style.height=e+"px",this.canvas_el.setAttribute("width",""+t*i),this.canvas_el.setAttribute("height",""+e*i),s.logger.debug("Rendering CanvasView with width: "+t+", height: "+e+", pixel ratio: "+i)},e}(o.DOMView);i.CanvasView=p;var d=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Canvas",this.prototype.default_view=p,this.internal({map:[a.Boolean,!1],use_hidpi:[a.Boolean,!0],pixel_ratio:[a.Number,1],output_backend:[a.OutputBackend,"canvas"]})},e}(r.HasProps);i.Canvas=d,d.initClass()},function(t,e,i){var n=t(408),r=t(202),o=t(204),s=t(205),a=t(195),l=t(191),h=t(192),u=t(13),c=function(t){function e(e,i,n,r,o,s){void 0===o&&(o={}),void 0===s&&(s={});var a=t.call(this)||this;return a.x_scale=e,a.y_scale=i,a.x_range=n,a.y_range=r,a.extra_x_ranges=o,a.extra_y_ranges=s,a._configure_scales(),a}return n.__extends(e,t),e.prototype.map_to_screen=function(t,e,i,n){void 0===i&&(i="default"),void 0===n&&(n="default");var r=this.xscales[i].v_compute(t),o=this.yscales[n].v_compute(e);return[r,o]},e.prototype._get_ranges=function(t,e){var i={};if(i.default=t,null!=e)for(var n in e)i[n]=e[n];return i},e.prototype._get_scales=function(t,e,i){var n={};for(var u in e){var c=e[u];if(c instanceof l.DataRange1d||c instanceof a.Range1d){if(!(t instanceof s.LogScale||t instanceof o.LinearScale))throw new Error("Range "+c.type+" is incompatible is Scale "+t.type);if(t instanceof r.CategoricalScale)throw new Error("Range "+c.type+" is incompatible is Scale "+t.type)}if(c instanceof h.FactorRange&&!(t instanceof r.CategoricalScale))throw new Error("Range "+c.type+" is incompatible is Scale "+t.type);t instanceof s.LogScale&&c instanceof l.DataRange1d&&(c.scale_hint="log");var _=t.clone();_.setv({source_range:c,target_range:i}),n[u]=_}return n},e.prototype._configure_frame_ranges=function(){this._h_target=new a.Range1d({start:this._left.value,end:this._right.value}),this._v_target=new a.Range1d({start:this._bottom.value,end:this._top.value})},e.prototype._configure_scales=function(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._xscales=this._get_scales(this.x_scale,this._x_ranges,this._h_target),this._yscales=this._get_scales(this.y_scale,this._y_ranges,this._v_target)},e.prototype._update_scales=function(){for(var t in this._configure_frame_ranges(),this._xscales){var e=this._xscales[t];e.target_range=this._h_target}for(var i in this._yscales){var e=this._yscales[i];e.target_range=this._v_target}},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i),this._update_scales()},Object.defineProperty(e.prototype,"x_ranges",{get:function(){return this._x_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"y_ranges",{get:function(){return this._y_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"xscales",{get:function(){return this._xscales},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"yscales",{get:function(){return this._yscales},enumerable:!0,configurable:!0}),e}(u.LayoutItem);i.CartesianFrame=c},function(t,e,i){var n=t(94);i.Canvas=n.Canvas;var r=t(95);i.CartesianFrame=r.CartesianFrame},function(t,e,i){var n=t(408),r=t(98),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CumSum",this.define({field:[o.String],include_zero:[o.Boolean,!1]})},e.prototype._v_compute=function(t){var e=new Float64Array(t.get_length()||0),i=t.data[this.field],n=this.include_zero?1:0;e[0]=this.include_zero?0:i[0];for(var r=1;r<e.length;r++)e[r]=e[r-1]+i[r-n];return e},e}(r.Expression);i.CumSum=s,s.initClass()},function(t,e,i){var n=t(408),r=t(62),o=function(t){function e(e){var i=t.call(this,e)||this;return i._connected={},i._result={},i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Expression"},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._connected={},this._result={}},e.prototype.v_compute=function(t){var e=this;null==this._connected[t.id]&&(this.connect(t.change,function(){return delete e._result[t.id]}),this.connect(t.patching,function(){return delete e._result[t.id]}),this.connect(t.streaming,function(){return delete e._result[t.id]}),this._connected[t.id]=!0);var i=this._result[t.id];return null==i&&(this._result[t.id]=i=this._v_compute(t)),i},e}(r.Model);i.Expression=o,o.initClass()},function(t,e,i){var n=t(98);i.Expression=n.Expression;var r=t(100);i.Stack=r.Stack;var o=t(97);i.CumSum=o.CumSum},function(t,e,i){var n=t(408),r=t(98),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Stack",this.define({fields:[o.Array,[]]})},e.prototype._v_compute=function(t){for(var e=new Float64Array(t.get_length()||0),i=0,n=this.fields;i<n.length;i++)for(var r=n[i],o=0;o<t.data[r].length;o++){var s=t.data[r][o];e[o]+=s}return e},e}(r.Expression);i.Stack=s,s.initClass()},function(t,e,i){var n=t(408),r=t(103),o=t(18),s=t(17),a=t(24),l=t(46),h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="BooleanFilter",this.define({booleans:[o.Array,null]})},e.prototype.compute_indices=function(t){var e=this.booleans;return null!=e&&e.length>0?a.every(e,l.isBoolean)?(e.length!==t.get_length()&&s.logger.warn("BooleanFilter "+this.id+": length of booleans doesn't match data source"),a.range(0,e.length).filter(function(t){return!0===e[t]})):(s.logger.warn("BooleanFilter "+this.id+": booleans should be array of booleans, defaulting to no filtering"),null):(null!=e&&0==e.length?s.logger.warn("BooleanFilter "+this.id+": booleans is empty, defaulting to no filtering"):s.logger.warn("BooleanFilter "+this.id+": booleans was not set, defaulting to no filtering"),null)},e}(r.Filter);i.BooleanFilter=h,h.initClass()},function(t,e,i){var n=t(408),r=t(103),o=t(18),s=t(35),a=t(40),l=function(e){function i(t){return e.call(this,t)||this}return n.__extends(i,e),i.initClass=function(){this.prototype.type="CustomJSFilter",this.define({args:[o.Any,{}],code:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(i.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"func",{get:function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0].concat(this.names,["source","require","exports",t])))},enumerable:!0,configurable:!0}),i.prototype.compute_indices=function(i){return this.filter=this.func.apply(this,this.values.concat([i,t,{}])),e.prototype.compute_indices.call(this,i)},i}(r.Filter);i.CustomJSFilter=l,l.initClass()},function(t,e,i){var n=t(408),r=t(62),o=t(18),s=t(46),a=t(24),l=t(17),h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Filter",this.define({filter:[o.Array,null]})},e.prototype.compute_indices=function(t){var e=this.filter;return null!=e&&e.length>=0?s.isArrayOf(e,s.isBoolean)?a.range(0,e.length).filter(function(t){return!0===e[t]}):s.isArrayOf(e,s.isInteger)?e:(l.logger.warn("Filter "+this.id+": filter should either be array of only booleans or only integers, defaulting to no filtering"),null):(l.logger.warn("Filter "+this.id+": filter was not set to be an array, defaulting to no filtering"),null)},e}(r.Model);i.Filter=h,h.initClass()},function(t,e,i){var n=t(408),r=t(103),o=t(18),s=t(17),a=t(24),l=function(t){function e(e){var i=t.call(this,e)||this;return i.indices=null,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GroupFilter",this.define({column_name:[o.String],group:[o.String]})},e.prototype.compute_indices=function(t){var e=this,i=t.get_column(this.column_name);return null==i?(s.logger.warn("group filter: groupby column not found in data source"),null):(this.indices=a.range(0,t.get_length()||0).filter(function(t){return i[t]===e.group}),0===this.indices.length&&s.logger.warn("group filter: group '"+this.group+"' did not match any values in column '"+this.column_name+"'"),this.indices)},e}(r.Filter);i.GroupFilter=l,l.initClass()},function(t,e,i){var n=t(101);i.BooleanFilter=n.BooleanFilter;var r=t(102);i.CustomJSFilter=r.CustomJSFilter;var o=t(103);i.Filter=o.Filter;var s=t(104);i.GroupFilter=s.GroupFilter;var a=t(106);i.IndexFilter=a.IndexFilter},function(t,e,i){var n=t(408),r=t(103),o=t(18),s=t(17),a=t(46),l=t(24),h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="IndexFilter",this.define({indices:[o.Array,null]})},e.prototype.compute_indices=function(t){return null!=this.indices&&this.indices.length>=0?l.every(this.indices,a.isInteger)?this.indices:(s.logger.warn("IndexFilter "+this.id+": indices should be array of integers, defaulting to no filtering"),null):(s.logger.warn("IndexFilter "+this.id+": indices was not set, defaulting to no filtering"),null)},e}(r.Filter);i.IndexFilter=h,h.initClass()},function(t,e,i){var n=t(408),r=t(116),o=t(18),s=t(46),a=function(t){function e(e){var i=t.call(this,e)||this;return i.last_precision=3,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="BasicTickFormatter",this.define({precision:[o.Any,"auto"],use_scientific:[o.Boolean,!0],power_limit_high:[o.Number,5],power_limit_low:[o.Number,-3]})},Object.defineProperty(e.prototype,"scientific_limit_low",{get:function(){return Math.pow(10,this.power_limit_low)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"scientific_limit_high",{get:function(){return Math.pow(10,this.power_limit_high)},enumerable:!0,configurable:!0}),e.prototype.doFormat=function(t,e){if(0==t.length)return[];var i=0;t.length>=2&&(i=Math.abs(t[1]-t[0])/1e4);var n=!1;if(this.use_scientific)for(var r=0,o=t;r<o.length;r++){var a=o[r],l=Math.abs(a);if(l>i&&(l>=this.scientific_limit_high||l<=this.scientific_limit_low)){n=!0;break}}var h=new Array(t.length),u=this.precision;if(null==u||s.isNumber(u))if(n)for(var c=0,_=t.length;c<_;c++)h[c]=t[c].toExponential(u||void 0);else for(var c=0,_=t.length;c<_;c++)h[c]=t[c].toFixed(u||void 0).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");else for(var p=this.last_precision,d=this.last_precision<=15;d?p<=15:p>=15;d?p++:p--){var f=!0;if(n){for(var c=0,_=t.length;c<_;c++)if(h[c]=t[c].toExponential(p),c>0&&h[c]===h[c-1]){f=!1;break}if(f)break}else{for(var c=0,_=t.length;c<_;c++)if(h[c]=t[c].toFixed(p).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),c>0&&h[c]==h[c-1]){f=!1;break}if(f)break}if(f){this.last_precision=p;break}}return h},e}(r.TickFormatter);i.BasicTickFormatter=a,a.initClass()},function(t,e,i){var n=t(408),r=t(116),o=t(24),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CategoricalTickFormatter"},e.prototype.doFormat=function(t,e){return o.copy(t)},e}(r.TickFormatter);i.CategoricalTickFormatter=s,s.initClass()},function(t,e,i){var n=t(408),r=t(407),o=t(116),s=t(17),a=t(18),l=t(42),h=t(24),u=t(46);function c(t){return r(t,"%Y %m %d %H %M %S").split(/\s+/).map(function(t){return parseInt(t,10)})}function _(t,e){if(u.isFunction(e))return e(t);var i=l.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(e=e.replace(/((^|[^%])(%%)*)%f/,i)).indexOf("%")?e:r(t,e)}var p=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],d=function(t){function e(e){var i=t.call(this,e)||this;return i.strip_leading_zeros=!0,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="DatetimeTickFormatter",this.define({microseconds:[a.Array,["%fus"]],milliseconds:[a.Array,["%3Nms","%S.%3Ns"]],seconds:[a.Array,["%Ss"]],minsec:[a.Array,[":%M:%S"]],minutes:[a.Array,[":%M","%Mm"]],hourmin:[a.Array,["%H:%M"]],hours:[a.Array,["%Hh","%H:%M"]],days:[a.Array,["%m/%d","%a%d"]],months:[a.Array,["%m/%Y","%b %Y"]],years:[a.Array,["%Y"]]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._update_width_formats()},e.prototype._update_width_formats=function(){var t=+r(new Date),e=function(e){var i=e.map(function(e){return _(t,e).length}),n=h.sort_by(h.zip(i,e),function(t){var e=t[0];return e});return h.unzip(n)};this._width_formats={microseconds:e(this.microseconds),milliseconds:e(this.milliseconds),seconds:e(this.seconds),minsec:e(this.minsec),minutes:e(this.minutes),hourmin:e(this.hourmin),hours:e(this.hours),days:e(this.days),months:e(this.months),years:e(this.years)}},e.prototype._get_resolution_str=function(t,e){var i=1.1*t;switch(!1){case!(i<.001):return"microseconds";case!(i<1):return"milliseconds";case!(i<60):return e>=60?"minsec":"seconds";case!(i<3600):return e>=3600?"hourmin":"minutes";case!(i<86400):return"hours";case!(i<2678400):return"days";case!(i<31536e3):return"months";default:return"years"}},e.prototype.doFormat=function(t,e){if(0==t.length)return[];for(var i=Math.abs(t[t.length-1]-t[0])/1e3,n=i/(t.length-1),r=this._get_resolution_str(n,i),o=this._width_formats[r],a=o[1][0],l=[],h=p.indexOf(r),u={},d=0,f=p;d<f.length;d++){var v=f[d];u[v]=0}u.seconds=5,u.minsec=4,u.minutes=4,u.hourmin=3,u.hours=3;for(var m=0,g=t;m<g.length;m++){var y=g[m],b=void 0,x=void 0;try{x=c(y),b=_(y,a)}catch(t){s.logger.warn("unable to format tick for timestamp value "+y),s.logger.warn(" - "+t),l.push("ERR");continue}for(var w=!1,k=h;0==x[u[p[k]]];){var T=void 0;if((k+=1)==p.length)break;if(("minsec"==r||"hourmin"==r)&&!w){if("minsec"==r&&0==x[4]&&0!=x[5]||"hourmin"==r&&0==x[3]&&0!=x[4]){T=this._width_formats[p[h-1]][1][0],b=_(y,T);break}w=!0}T=this._width_formats[p[k]][1][0],b=_(y,T)}if(this.strip_leading_zeros){var C=b.replace(/^0+/g,"");C!=b&&isNaN(parseInt(C))&&(C="0"+C),l.push(C)}else l.push(b)}return l},e}(o.TickFormatter);i.DatetimeTickFormatter=d,d.initClass()},function(t,e,i){var n=t(408),r=t(116),o=t(18),s=t(35),a=t(40),l=function(e){function i(t){return e.call(this,t)||this}return n.__extends(i,e),i.initClass=function(){this.prototype.type="FuncTickFormatter",this.define({args:[o.Any,{}],code:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(i.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),i.prototype._make_func=function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0,"tick","index","ticks"].concat(this.names,["require","exports",t])))},i.prototype.doFormat=function(e,i){var n=this,r=this._make_func().bind({});return e.map(function(e,i,o){return r.apply(void 0,[e,i,o].concat(n.values,[t,{}]))})},i}(r.TickFormatter);i.FuncTickFormatter=l,l.initClass()},function(t,e,i){var n=t(107);i.BasicTickFormatter=n.BasicTickFormatter;var r=t(108);i.CategoricalTickFormatter=r.CategoricalTickFormatter;var o=t(109);i.DatetimeTickFormatter=o.DatetimeTickFormatter;var s=t(110);i.FuncTickFormatter=s.FuncTickFormatter;var a=t(112);i.LogTickFormatter=a.LogTickFormatter;var l=t(113);i.MercatorTickFormatter=l.MercatorTickFormatter;var h=t(114);i.NumeralTickFormatter=h.NumeralTickFormatter;var u=t(115);i.PrintfTickFormatter=u.PrintfTickFormatter;var c=t(116);i.TickFormatter=c.TickFormatter},function(t,e,i){var n=t(408),r=t(116),o=t(107),s=t(17),a=t(18),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LogTickFormatter",this.define({ticker:[a.Instance,null]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.basic_formatter=new o.BasicTickFormatter,null==this.ticker&&s.logger.warn("LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)")},e.prototype.doFormat=function(t,e){if(0==t.length)return[];for(var i=null!=this.ticker?this.ticker.base:10,n=!1,r=new Array(t.length),o=0,s=t.length;o<s;o++)if(r[o]=i+"^"+Math.round(Math.log(t[o])/Math.log(i)),o>0&&r[o]==r[o-1]){n=!0;break}return n?this.basic_formatter.doFormat(t,e):r},e}(r.TickFormatter);i.LogTickFormatter=l,l.initClass()},function(t,e,i){var n=t(408),r=t(107),o=t(18),s=t(36),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="MercatorTickFormatter",this.define({dimension:[o.LatLon]})},e.prototype.doFormat=function(e,i){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==e.length)return[];var n=e.length,r=new Array(n);if("lon"==this.dimension)for(var o=0;o<n;o++){var a=s.wgs84_mercator.inverse([e[o],i.loc])[0];r[o]=a}else for(var o=0;o<n;o++){var l=s.wgs84_mercator.inverse([i.loc,e[o]]),h=l[1];r[o]=h}return t.prototype.doFormat.call(this,r,i)},e}(r.BasicTickFormatter);i.MercatorTickFormatter=a,a.initClass()},function(t,e,i){var n=t(408),r=t(378),o=t(116),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="NumeralTickFormatter",this.define({format:[s.String,"0,0"],language:[s.String,"en"],rounding:[s.RoundingFunction,"round"]})},Object.defineProperty(e.prototype,"_rounding_fn",{get:function(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}},enumerable:!0,configurable:!0}),e.prototype.doFormat=function(t,e){var i=this.format,n=this.language,o=this._rounding_fn;return t.map(function(t){return r.format(t,i,n,o)})},e}(o.TickFormatter);i.NumeralTickFormatter=a,a.initClass()},function(t,e,i){var n=t(408),r=t(116),o=t(42),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="PrintfTickFormatter",this.define({format:[s.String,"%s"]})},e.prototype.doFormat=function(t,e){var i=this;return t.map(function(t){return o.sprintf(i.format,t)})},e}(r.TickFormatter);i.PrintfTickFormatter=a,a.initClass()},function(t,e,i){var n=t(408),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="TickFormatter"},e}(r.Model);i.TickFormatter=o,o.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(149),s=t(9),a=t(18),l=t(34),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new Float32Array(this._start_angle.length);for(var t=0,e=this._start_angle.length;t<e;t++)this._angle[t]=this._end_angle[t]-this._start_angle[t]},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i._start_angle,s=i._angle,a=i.sinner_radius,l=i.souter_radius,h=this.model.properties.direction.value(),u=0,c=e;u<c.length;u++){var _=c[u];isNaN(n[_]+r[_]+a[_]+l[_]+o[_]+s[_])||(t.translate(n[_],r[_]),t.rotate(o[_]),t.moveTo(l[_],0),t.beginPath(),t.arc(0,0,l[_],0,s[_],h),t.rotate(s[_]),t.lineTo(a[_],0),t.arc(0,0,a[_],0,-s[_],!h),t.closePath(),t.rotate(-s[_]-o[_]),t.translate(-n[_],-r[_]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,_),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,_),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,n,r,o,a,h=t.sx,u=t.sy,c=this.renderer.xscale.invert(h),_=this.renderer.yscale.invert(u);if("data"==this.model.properties.outer_radius.units)n=c-this.max_outer_radius,o=c+this.max_outer_radius,r=_-this.max_outer_radius,a=_+this.max_outer_radius;else{var p=h-this.max_outer_radius,d=h+this.max_outer_radius;e=this.renderer.xscale.r_invert(p,d),n=e[0],o=e[1];var f=u-this.max_outer_radius,v=u+this.max_outer_radius;i=this.renderer.yscale.r_invert(f,v),r=i[0],a=i[1]}for(var m=[],g=s.validate_bbox_coords([n,o],[r,a]),y=0,b=this.index.indices(g);y<b.length;y++){var x=b[y],w=Math.pow(this.souter_radius[x],2),k=Math.pow(this.sinner_radius[x],2),T=this.renderer.xscale.r_compute(c,this._x[x]),p=T[0],d=T[1],C=this.renderer.yscale.r_compute(_,this._y[x]),f=C[0],v=C[1],S=Math.pow(p-d,2)+Math.pow(f-v,2);S<=w&&S>=k&&m.push([x,S])}for(var A=this.model.properties.direction.value(),M=[],E=0,z=m;E<z.length;E++){var O=z[E],x=O[0],S=O[1],P=Math.atan2(u-this.sy[x],h-this.sx[x]);l.angle_between(-P,-this._start_angle[x],-this._end_angle[x],A)&&M.push([x,S])}return s.create_hit_test_result_from_hits(M)},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e.prototype._scenterxy=function(t){var e=(this.sinner_radius[t]+this.souter_radius[t])/2,i=(this._start_angle[t]+this._end_angle[t])/2;return{x:this.sx[t]+e*Math.cos(i),y:this.sy[t]+e*Math.sin(i)}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e}(r.XYGlyphView);i.AnnularWedgeView=h;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="AnnularWedge",this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({direction:[a.Direction,"anticlock"],inner_radius:[a.DistanceSpec],outer_radius:[a.DistanceSpec],start_angle:[a.AngleSpec],end_angle:[a.AngleSpec]})},e}(r.XYGlyph);i.AnnularWedge=u,u.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(9),s=t(18),a=t(31),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.sinner_radius,s=i.souter_radius,l=0,h=e;l<h.length;l++){var u=h[l];if(!isNaN(n[u]+r[u]+o[u]+s[u])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(t,u),t.beginPath(),a.is_ie)for(var c=0,_=[!1,!0];c<_.length;c++){var p=_[c];t.arc(n[u],r[u],o[u],0,Math.PI,p),t.arc(n[u],r[u],s[u],Math.PI,0,!p)}else t.arc(n[u],r[u],o[u],0,2*Math.PI,!0),t.arc(n[u],r[u],s[u],2*Math.PI,0,!1);t.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,u),t.beginPath(),t.arc(n[u],r[u],o[u],0,2*Math.PI),t.moveTo(n[u]+s[u],r[u]),t.arc(n[u],r[u],s[u],0,2*Math.PI),t.stroke())}}},e.prototype._hit_point=function(t){var e,i,n,r,s,a,l=t.sx,h=t.sy,u=this.renderer.xscale.invert(l),c=this.renderer.yscale.invert(h);if("data"==this.model.properties.outer_radius.units)n=u-this.max_outer_radius,s=u+this.max_outer_radius,r=c-this.max_outer_radius,a=c+this.max_outer_radius;else{var _=l-this.max_outer_radius,p=l+this.max_outer_radius;e=this.renderer.xscale.r_invert(_,p),n=e[0],s=e[1];var d=h-this.max_outer_radius,f=h+this.max_outer_radius;i=this.renderer.yscale.r_invert(d,f),r=i[0],a=i[1]}for(var v=[],m=o.validate_bbox_coords([n,s],[r,a]),g=0,y=this.index.indices(m);g<y.length;g++){var b=y[g],x=Math.pow(this.souter_radius[b],2),w=Math.pow(this.sinner_radius[b],2),k=this.renderer.xscale.r_compute(u,this._x[b]),_=k[0],p=k[1],T=this.renderer.yscale.r_compute(c,this._y[b]),d=T[0],f=T[1],C=Math.pow(_-p,2)+Math.pow(d-f,2);C<=x&&C>=w&&v.push([b,C])}return o.create_hit_test_result_from_hits(v)},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.y0,o=e.x1,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+o)/2;var h=new Array(a);h[i]=(r+s)/2;var u=.5*Math.min(Math.abs(o-n),Math.abs(s-r)),c=new Array(a);c[i]=.4*u;var _=new Array(a);_[i]=.8*u,this._render(t,[i],{sx:l,sy:h,sinner_radius:c,souter_radius:_})},e}(r.XYGlyphView);i.AnnulusView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Annulus",this.prototype.default_view=l,this.mixins(["line","fill"]),this.define({inner_radius:[s.DistanceSpec],outer_radius:[s.DistanceSpec]})},e}(r.XYGlyph);i.Annulus=h,h.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(149),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=i.sradius,s=i._start_angle,a=i._end_angle;if(this.visuals.line.doit)for(var l=this.model.properties.direction.value(),h=0,u=e;h<u.length;h++){var c=u[h];isNaN(n[c]+r[c]+o[c]+s[c]+a[c])||(t.beginPath(),t.arc(n[c],r[c],o[c],s[c],a[c],l),this.visuals.line.set_vectorize(t,c),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.ArcView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Arc",this.prototype.default_view=a,this.mixins(["line"]),this.define({direction:[s.Direction,"anticlock"],radius:[s.DistanceSpec],start_angle:[s.AngleSpec],end_angle:[s.AngleSpec]})},e}(r.XYGlyph);i.Arc=l,l.initClass()},function(t,e,i){var n=t(408),r=t(127),o=t(149),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e}(r.GlyphView);i.AreaView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Area",this.mixins(["fill","hatch"])},e}(r.Glyph);i.Area=a,a.initClass()},function(t,e,i){var n=t(408),r=t(39),o=t(127),s=t(149);function a(t,e,i,n,r,o,s,a){for(var l=[],h=[[],[]],u=0;u<=2;u++){var c=void 0,_=void 0,p=void 0;if(0===u?(_=6*t-12*i+6*r,c=-3*t+9*i-9*r+3*s,p=3*i-3*t):(_=6*e-12*n+6*o,c=-3*e+9*n-9*o+3*a,p=3*n-3*e),Math.abs(c)<1e-12){if(Math.abs(_)<1e-12)continue;var d=-p/_;0<d&&d<1&&l.push(d)}else{var f=_*_-4*p*c,v=Math.sqrt(f);if(!(f<0)){var m=(-_+v)/(2*c);0<m&&m<1&&l.push(m);var g=(-_-v)/(2*c);0<g&&g<1&&l.push(g)}}}for(var y=l.length,b=y;y--;){var d=l[y],x=1-d,w=x*x*x*t+3*x*x*d*i+3*x*d*d*r+d*d*d*s;h[0][y]=w;var k=x*x*x*e+3*x*x*d*n+3*x*d*d*o+d*d*d*a;h[1][y]=k}return h[0][b]=t,h[1][b]=e,h[0][b+1]=s,h[1][b+1]=a,[Math.min.apply(Math,h[0]),Math.max.apply(Math,h[1]),Math.max.apply(Math,h[0]),Math.min.apply(Math,h[1])]}var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x0.length;e<i;e++)if(!isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx0[e]+this._cy0[e]+this._cx1[e]+this._cy1[e])){var n=a(this._x0[e],this._y0[e],this._x1[e],this._y1[e],this._cx0[e],this._cy0[e],this._cx1[e],this._cy1[e]),o=n[0],s=n[1],l=n[2],h=n[3];t.push({minX:o,minY:s,maxX:l,maxY:h,i:e})}return new r.SpatialIndex(t)},e.prototype._render=function(t,e,i){var n=i.sx0,r=i.sy0,o=i.sx1,s=i.sy1,a=i.scx0,l=i.scy0,h=i.scx1,u=i.scy1;if(this.visuals.line.doit)for(var c=0,_=e;c<_.length;c++){var p=_[c];isNaN(n[p]+r[p]+o[p]+s[p]+a[p]+l[p]+h[p]+u[p])||(t.beginPath(),t.moveTo(n[p],r[p]),t.bezierCurveTo(a[p],l[p],h[p],u[p],o[p],s[p]),this.visuals.line.set_vectorize(t,p),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,i){s.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e}(o.GlyphView);i.BezierView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Bezier",this.prototype.default_view=l,this.coords([["x0","y0"],["x1","y1"],["cx0","cy0"],["cx1","cy1"]]),this.mixins(["line"])},e}(o.Glyph);i.Bezier=h,h.initClass()},function(t,e,i){var n=t(408),r=t(39),o=t(127),s=t(149),a=t(9),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_box=function(t){for(var e=[],i=0;i<t;i++){var n=this._lrtb(i),o=n[0],s=n[1],a=n[2],l=n[3];!isNaN(o+s+a+l)&&isFinite(o+s+a+l)&&e.push({minX:Math.min(o,s),minY:Math.min(a,l),maxX:Math.max(s,o),maxY:Math.max(a,l),i:i})}return new r.SpatialIndex(e)},e.prototype._render=function(t,e,i){for(var n=this,r=i.sleft,o=i.sright,s=i.stop,a=i.sbottom,l=function(e){if(isNaN(r[e]+s[e]+o[e]+a[e]))return"continue";t.rect(r[e],s[e],o[e]-r[e],a[e]-s[e]),h.visuals.fill.doit&&(h.visuals.fill.set_vectorize(t,e),t.beginPath(),t.rect(r[e],s[e],o[e]-r[e],a[e]-s[e]),t.fill()),h.visuals.hatch.doit2(t,e,function(){t.beginPath(),t.rect(r[e],s[e],o[e]-r[e],a[e]-s[e]),t.fill()},function(){return n.renderer.request_render()}),h.visuals.line.doit&&(h.visuals.line.set_vectorize(t,e),t.beginPath(),t.rect(r[e],s[e],o[e]-r[e],a[e]-s[e]),t.stroke())},h=this,u=0,c=e;u<c.length;u++){var _=c[u];l(_)}},e.prototype._clamp_viewport=function(){for(var t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,i=this.stop.length,n=0;n<i;n++)this.stop[n]=Math.max(this.stop[n],e.start),this.sbottom[n]=Math.min(this.sbottom[n],e.end),this.sleft[n]=Math.max(this.sleft[n],t.start),this.sright[n]=Math.min(this.sright[n],t.end)},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=this.index.indices({minX:n,minY:r,maxX:n,maxY:r}),s=a.create_empty_hit_test_result();return s.indices=o,s},e.prototype._hit_span=function(t){var e,i=t.sx,n=t.sy;if("v"==t.direction){var r=this.renderer.yscale.invert(n),o=this.renderer.plot_view.frame.bbox.h_range,s=this.renderer.xscale.r_invert(o.start,o.end),l=s[0],h=s[1];e=this.index.indices({minX:l,minY:r,maxX:h,maxY:r})}else{var u=this.renderer.xscale.invert(i),c=this.renderer.plot_view.frame.bbox.v_range,_=this.renderer.yscale.r_invert(c.start,c.end),p=_[0],d=_[1];e=this.index.indices({minX:u,minY:p,maxX:u,maxY:d})}var f=a.create_empty_hit_test_result();return f.indices=e,f},e.prototype.draw_legend_for_index=function(t,e,i){s.generic_area_legend(this.visuals,t,e,i)},e}(o.GlyphView);i.BoxView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Box",this.mixins(["line","fill","hatch"])},e}(o.Glyph);i.Box=h,h.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.XYGlyphView);i.CenterRotatableView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CenterRotatable",this.mixins(["line","fill"]),this.define({angle:[o.AngleSpec,0],width:[o.DistanceSpec],height:[o.DistanceSpec]})},e}(r.XYGlyph);i.CenterRotatable=a,a.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(9),s=t(18),a=t(24),l=t(25),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){if(null!=this._radius)if("data"==this.model.properties.radius.spec.units){var t=this.model.properties.radius_dimension.spec.value;switch(t){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":var e=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=l.map(e,function(t,e){return Math.max(t,i[e])});break;case"min":var e=this.sdist(this.renderer.xscale,this._x,this._radius),n=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=l.map(e,function(t,e){return Math.min(t,n[e])})}}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=l.map(this._size,function(t){return t/2})},e.prototype._mask_data=function(){var t,e,i,n,r,s,a,l,h=this.renderer.plot_view.frame.bbox.ranges,u=h[0],c=h[1];if(null!=this._radius&&"data"==this.model.properties.radius.units){var _=u.start,p=u.end;t=this.renderer.xscale.r_invert(_,p),r=t[0],a=t[1],r-=this.max_radius,a+=this.max_radius;var d=c.start,f=c.end;e=this.renderer.yscale.r_invert(d,f),s=e[0],l=e[1],s-=this.max_radius,l+=this.max_radius}else{var _=u.start-this.max_size,p=u.end+this.max_size;i=this.renderer.xscale.r_invert(_,p),r=i[0],a=i[1];var d=c.start-this.max_size,f=c.end+this.max_size;n=this.renderer.yscale.r_invert(d,f),s=n[0],l=n[1]}var v=o.validate_bbox_coords([r,a],[s,l]);return this.index.indices(v)},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.sradius,s=0,a=e;s<a.length;s++){var l=a[s];isNaN(n[l]+r[l]+o[l])||(t.beginPath(),t.arc(n[l],r[l],o[l],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,l),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,l),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,n,r,s,a,l,h,u,c,_,p,d,f,v,m,g=t.sx,y=t.sy,b=this.renderer.xscale.invert(g),x=this.renderer.yscale.invert(y);null!=this._radius&&"data"==this.model.properties.radius.units?(d=b-this.max_radius,f=b+this.max_radius,v=x-this.max_radius,m=x+this.max_radius):(u=g-this.max_size,c=g+this.max_size,e=this.renderer.xscale.r_invert(u,c),d=e[0],f=e[1],i=[Math.min(d,f),Math.max(d,f)],d=i[0],f=i[1],_=y-this.max_size,p=y+this.max_size,n=this.renderer.yscale.r_invert(_,p),v=n[0],m=n[1],r=[Math.min(v,m),Math.max(v,m)],v=r[0],m=r[1]);var w=o.validate_bbox_coords([d,f],[v,m]),k=this.index.indices(w),T=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)for(var C=0,S=k;C<S.length;C++){var A=S[C];h=Math.pow(this.sradius[A],2),s=this.renderer.xscale.r_compute(b,this._x[A]),u=s[0],c=s[1],a=this.renderer.yscale.r_compute(x,this._y[A]),_=a[0],p=a[1],(l=Math.pow(u-c,2)+Math.pow(_-p,2))<=h&&T.push([A,l])}else for(var M=0,E=k;M<E.length;M++){var A=E[M];h=Math.pow(this.sradius[A],2),(l=Math.pow(this.sx[A]-g,2)+Math.pow(this.sy[A]-y,2))<=h&&T.push([A,l])}return o.create_hit_test_result_from_hits(T)},e.prototype._hit_span=function(t){var e,i,n,r,s,a,l,h,u,c=t.sx,_=t.sy,p=this.bounds(),d=p.minX,f=p.minY,v=p.maxX,m=p.maxY,g=o.create_empty_hit_test_result();if("h"==t.direction){var y=void 0,b=void 0;h=f,u=m,null!=this._radius&&"data"==this.model.properties.radius.units?(y=c-this.max_radius,b=c+this.max_radius,e=this.renderer.xscale.r_invert(y,b),a=e[0],l=e[1]):(s=this.max_size/2,y=c-s,b=c+s,i=this.renderer.xscale.r_invert(y,b),a=i[0],l=i[1])}else{var x=void 0,w=void 0;a=d,l=v,null!=this._radius&&"data"==this.model.properties.radius.units?(x=_-this.max_radius,w=_+this.max_radius,n=this.renderer.yscale.r_invert(x,w),h=n[0],u=n[1]):(s=this.max_size/2,x=_-s,w=_+s,r=this.renderer.yscale.r_invert(x,w),h=r[0],u=r[1])}var k=o.validate_bbox_coords([a,l],[h,u]),T=this.index.indices(k);return g.indices=T,g},e.prototype._hit_rect=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,r=t.sy1,s=this.renderer.xscale.r_invert(e,i),a=s[0],l=s[1],h=this.renderer.yscale.r_invert(n,r),u=h[0],c=h[1],_=o.validate_bbox_coords([a,l],[u,c]),p=o.create_empty_hit_test_result();return p.indices=this.index.indices(_),p},e.prototype._hit_poly=function(t){for(var e=t.sx,i=t.sy,n=a.range(0,this.sx.length),r=[],s=0,l=n.length;s<l;s++){var h=n[s];o.point_in_poly(this.sx[s],this.sy[s],e,i)&&r.push(h)}var u=o.create_empty_hit_test_result();return u.indices=r,u},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.y0,o=e.x1,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+o)/2;var h=new Array(a);h[i]=(r+s)/2;var u=new Array(a);u[i]=.2*Math.min(Math.abs(o-n),Math.abs(s-r)),this._render(t,[i],{sx:l,sy:h,sradius:u})},e}(r.XYGlyphView);i.CircleView=h;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Circle",this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({angle:[s.AngleSpec,0],size:[s.DistanceSpec,{units:"screen",value:4}],radius:[s.DistanceSpec],radius_dimension:[s.RadiusDimension,"x"]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.properties.radius.optional=!0},e}(r.XYGlyph);i.Circle=u,u.initClass()},function(t,e,i){var n=t(408),r=t(126),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.EllipseOvalView);i.EllipseView=o;var s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Ellipse",this.prototype.default_view=o},e}(r.EllipseOval);i.Ellipse=s,s.initClass()},function(t,e,i){var n=t(408),r=t(123),o=t(9),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.sw,s=i.sh,a=i._angle,l=0,h=e;l<h.length;l++){var u=h[l];isNaN(n[u]+r[u]+o[u]+s[u]+a[u])||(t.beginPath(),t.ellipse(n[u],r[u],o[u]/2,s[u]/2,a[u],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,u),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,u),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,n,r,s,a,l,h,u,c,_,p,d,f=t.sx,v=t.sy,m=this.renderer.xscale.invert(f),g=this.renderer.yscale.invert(v);"data"==this.model.properties.width.units?(s=m-this.max_width,a=m+this.max_width):(c=f-this.max_width,_=f+this.max_width,e=this.renderer.xscale.r_invert(c,_),s=e[0],a=e[1]),"data"==this.model.properties.height.units?(l=g-this.max_height,h=g+this.max_height):(p=v-this.max_height,d=v+this.max_height,i=this.renderer.yscale.r_invert(p,d),l=i[0],h=i[1]);for(var y=o.validate_bbox_coords([s,a],[l,h]),b=this.index.indices(y),x=[],w=0,k=b;w<k.length;w++){var T=k[w];o.point_in_ellipse(f,v,this._angle[T],this.sh[T]/2,this.sw[T]/2,this.sx[T],this.sy[T])&&(n=this.renderer.xscale.r_compute(m,this._x[T]),c=n[0],_=n[1],r=this.renderer.yscale.r_compute(g,this._y[T]),p=r[0],d=r[1],u=Math.pow(c-_,2)+Math.pow(p-d,2),x.push([T,u]))}return o.create_hit_test_result_from_hits(x)},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.y0,o=e.x1,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+o)/2;var h=new Array(a);h[i]=(r+s)/2;var u=this.sw[i]/this.sh[i],c=.8*Math.min(Math.abs(o-n),Math.abs(s-r)),_=new Array(a),p=new Array(a);u>1?(_[i]=c,p[i]=c/u):(_[i]=c*u,p[i]=c),this._render(t,[i],{sx:l,sy:h,sw:_,sh:p,_angle:[0]})},e.prototype._bounds=function(t){var e=t.minX,i=t.maxX,n=t.minY,r=t.maxY;return{minX:e-this.max_w2,maxX:i+this.max_w2,minY:n-this.max_h2,maxY:r+this.max_h2}},e}(r.CenterRotatableView);i.EllipseOvalView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="EllipseOval"},e}(r.CenterRotatable);i.EllipseOval=a,a.initClass()},function(t,e,i){var n=t(408),r=t(9),o=t(18),s=t(27),a=t(36),l=t(51),h=t(50),u=t(62),c=t(17),_=t(25),p=t(35),d=t(46),f=t(136),v=t(192),m=function(e){function i(){var t=null!==e&&e.apply(this,arguments)||this;return t._nohit_warned={},t}return n.__extends(i,e),Object.defineProperty(i.prototype,"renderer",{get:function(){return this.parent},enumerable:!0,configurable:!0}),i.prototype.initialize=function(){e.prototype.initialize.call(this),this._nohit_warned={},this.visuals=new l.Visuals(this.model);var i=this.renderer.plot_view.gl;if(null!=i){var n=null;try{n=t(474)}catch(t){if("MODULE_NOT_FOUND"!==t.code)throw t;c.logger.warn("WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.")}if(null!=n){var r=n[this.model.type+"GLGlyph"];null!=r&&(this.glglyph=new r(i.ctx,this))}}},i.prototype.set_visuals=function(t){this.visuals.warm_cache(t),null!=this.glglyph&&this.glglyph.set_visuals_changed()},i.prototype.render=function(t,e,i){t.beginPath(),null!=this.glglyph&&this.glglyph.render(t,e,i)||this._render(t,e,i)},i.prototype.has_finished=function(){return!0},i.prototype.notify_finished=function(){this.renderer.notify_finished()},i.prototype._bounds=function(t){return t},i.prototype.bounds=function(){return this._bounds(this.index.bbox)},i.prototype.log_bounds=function(){for(var t=s.empty(),e=this.index.search(s.positive_x()),i=0,n=e;i<n.length;i++){var r=n[i];r.minX<t.minX&&(t.minX=r.minX),r.maxX>t.maxX&&(t.maxX=r.maxX)}for(var o=this.index.search(s.positive_y()),a=0,l=o;a<l.length;a++){var h=l[a];h.minY<t.minY&&(t.minY=h.minY),h.maxY>t.maxY&&(t.maxY=h.maxY)}return this._bounds(t)},i.prototype.get_anchor_point=function(t,e,i){var n=i[0],r=i[1];switch(t){case"center":return{x:this.scenterx(e,n,r),y:this.scentery(e,n,r)};default:return null}},i.prototype.sdist=function(t,e,i,n,r){var o,s;void 0===n&&(n="edge"),void 0===r&&(r=!1);var a=e.length;if("center"==n){var l=_.map(i,function(t){return t/2});o=new Float64Array(a);for(var h=0;h<a;h++)o[h]=e[h]-l[h];s=new Float64Array(a);for(var h=0;h<a;h++)s[h]=e[h]+l[h]}else{o=e,s=new Float64Array(a);for(var h=0;h<a;h++)s[h]=o[h]+i[h]}var u=t.v_compute(o),c=t.v_compute(s);return r?_.map(u,function(t,e){return Math.ceil(Math.abs(c[e]-u[e]))}):_.map(u,function(t,e){return Math.abs(c[e]-u[e])})},i.prototype.draw_legend_for_index=function(t,e,i){},i.prototype.hit_test=function(t){var e=null,i="_hit_"+t.type;return null!=this[i]?e=this[i](t):null==this._nohit_warned[t.type]&&(c.logger.debug("'"+t.type+"' selection not available for "+this.model.type),this._nohit_warned[t.type]=!0),e},i.prototype._hit_rect_against_index=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,o=t.sy1,s=this.renderer.xscale.r_invert(e,i),a=s[0],l=s[1],h=this.renderer.yscale.r_invert(n,o),u=h[0],c=h[1],_=r.validate_bbox_coords([a,l],[u,c]),p=r.create_empty_hit_test_result();return p.indices=this.index.indices(_),p},i.prototype.set_data=function(t,e,i){var n,r,o,s,l=this.model.materialize_dataspecs(t);if(this.visuals.set_all_indices(e),e&&!(this instanceof f.LineView)){var h={},u=function(t){var i=l[t];"_"===t.charAt(0)?h[t]=e.map(function(t){return i[t]}):h[t]=i};for(var c in l)u(c);l=h}if(p.extend(this,l),this.renderer.plot_view.model.use_map&&(null!=this._x&&(n=a.project_xy(this._x,this._y),this._x=n[0],this._y=n[1]),null!=this._xs&&(r=a.project_xsys(this._xs,this._ys),this._xs=r[0],this._ys=r[1]),null!=this._x0&&(o=a.project_xy(this._x0,this._y0),this._x0=o[0],this._y0=o[1]),null!=this._x1&&(s=a.project_xy(this._x1,this._y1),this._x1=s[0],this._y1=s[1])),null!=this.renderer.plot_view.frame.x_ranges)for(var d=this.renderer.plot_view.frame.x_ranges[this.model.x_range_name],m=this.renderer.plot_view.frame.y_ranges[this.model.y_range_name],g=0,y=this.model._coords;g<y.length;g++){var b=y[g],x=b[0],w=b[1];x="_"+x,w="_"+w,null!=this._xs?(d instanceof v.FactorRange&&(this[x]=_.map(this[x],function(t){return d.v_synthetic(t)})),m instanceof v.FactorRange&&(this[w]=_.map(this[w],function(t){return m.v_synthetic(t)}))):(d instanceof v.FactorRange&&(this[x]=d.v_synthetic(this[x])),m instanceof v.FactorRange&&(this[w]=m.v_synthetic(this[w])))}null!=this.glglyph&&this.glglyph.set_data_changed(this._x.length),this._set_data(i),this.index_data()},i.prototype._set_data=function(t){},i.prototype.index_data=function(){this.index=this._index_data()},i.prototype.mask_data=function(t){return null!=this.glglyph||null==this._mask_data?t:this._mask_data()},i.prototype.map_data=function(){for(var t,e=0,i=this.model._coords;e<i.length;e++){var n=i[e],r=n[0],o=n[1],s="s"+r,a="s"+o;if(o="_"+o,null!=this[r="_"+r]&&(d.isArray(this[r][0])||d.isTypedArray(this[r][0]))){var l=this[r].length;this[s]=new Array(l),this[a]=new Array(l);for(var h=0;h<l;h++){var u=this.map_to_screen(this[r][h],this[o][h]),c=u[0],_=u[1];this[s][h]=c,this[a][h]=_}}else t=this.map_to_screen(this[r],this[o]),this[s]=t[0],this[a]=t[1]}this._map_data()},i.prototype._map_data=function(){},i.prototype.map_to_screen=function(t,e){return this.renderer.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)},i}(h.View);i.GlyphView=m;var g=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Glyph",this.prototype._coords=[],this.internal({x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]})},e.coords=function(t){var e=this.prototype._coords.concat(t);this.prototype._coords=e;for(var i={},n=0,r=t;n<r.length;n++){var s=r[n],a=s[0],l=s[1];i[a]=[o.CoordinateSpec],i[l]=[o.CoordinateSpec]}this.define(i)},e}(u.Model);i.Glyph=g,g.initClass()},function(t,e,i){var n=t(408),r=t(120),o=t(39),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x1.length;e<i;e++){var n=this._x1[e],r=this._x2[e],s=this._y[e];!isNaN(n+r+s)&&isFinite(n+r+s)&&t.push({minX:Math.min(n,r),minY:s,maxX:Math.max(n,r),maxY:s,i:e})}return new o.SpatialIndex(t)},e.prototype._inner=function(t,e,i,n,r){t.beginPath();for(var o=0,s=e.length;o<s;o++)t.lineTo(e[o],n[o]);for(var a=i.length-1,o=a;o>=0;o--)t.lineTo(i[o],n[o]);t.closePath(),r.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sx1,o=i.sx2,s=i.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,r,o,s,t.fill)),this.visuals.hatch.doit2(t,0,function(){return n._inner(t,r,o,s,t.fill)},function(){return n.renderer.request_render()})},e.prototype.scenterx=function(t){return(this.sx1[t]+this.sx2[t])/2},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._map_data=function(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)},e}(r.AreaView);i.HAreaView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="HArea",this.prototype.default_view=a,this.define({x1:[s.CoordinateSpec],x2:[s.CoordinateSpec],y:[s.CoordinateSpec]})},e}(r.Area);i.HArea=l,l.initClass()},function(t,e,i){var n=t(408),r=t(122),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.scenterx=function(t){return(this.sleft[t]+this.sright[t])/2},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._index_data=function(){return this._index_box(this._y.length)},e.prototype._lrtb=function(t){var e=Math.min(this._left[t],this._right[t]),i=Math.max(this._left[t],this._right[t]),n=this._y[t]+.5*this._height[t],r=this._y[t]-.5*this._height[t];return[e,i,n,r]},e.prototype._map_data=function(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);var t=this.sy.length;this.stop=new Float64Array(t),this.sbottom=new Float64Array(t);for(var e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()},e}(r.BoxView);i.HBarView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="HBar",this.prototype.default_view=s,this.coords([["left","y"]]),this.define({height:[o.DistanceSpec],right:[o.CoordinateSpec]}),this.override({left:0})},e}(r.Box);i.HBar=a,a.initClass()},function(t,e,i){var n=t(408),r=t(127),o=t(9),s=t(18),a=t(39),l=t(149),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._set_data=function(){var t=this._q.length,e=this.model.size,i=this.model.aspect_scale;if(this._x=new Float64Array(t),this._y=new Float64Array(t),"pointytop"==this.model.orientation)for(var n=0;n<t;n++)this._x[n]=e*Math.sqrt(3)*(this._q[n]+this._r[n]/2)/i,this._y[n]=3*-e/2*this._r[n];else for(var n=0;n<t;n++)this._x[n]=3*e/2*this._q[n],this._y[n]=-e*Math.sqrt(3)*(this._r[n]+this._q[n]/2)*i},e.prototype._index_data=function(){var t,e=this.model.size,i=Math.sqrt(3)*e/2;"flattop"==this.model.orientation?(i=(t=[e,i])[0],e=t[1],e*=this.model.aspect_scale):i/=this.model.aspect_scale;for(var n=[],r=0;r<this._x.length;r++){var o=this._x[r],s=this._y[r];!isNaN(o+s)&&isFinite(o+s)&&n.push({minX:o-i,minY:s-e,maxX:o+i,maxY:s+e,i:r})}return new a.SpatialIndex(n)},e.prototype.map_data=function(){var t,e;t=this.map_to_screen(this._x,this._y),this.sx=t[0],this.sy=t[1],e=this._get_unscaled_vertices(),this.svx=e[0],this.svy=e[1]},e.prototype._get_unscaled_vertices=function(){var t=this.model.size,e=this.model.aspect_scale;if("pointytop"==this.model.orientation){var i=this.renderer.yscale,n=this.renderer.xscale,r=Math.abs(i.compute(0)-i.compute(t)),o=Math.sqrt(3)/2*Math.abs(n.compute(0)-n.compute(t))/e,s=r/2,a=[0,-o,-o,0,o,o],l=[r,s,-s,-r,-s,s];return[a,l]}var i=this.renderer.xscale,n=this.renderer.yscale,r=Math.abs(i.compute(0)-i.compute(t)),o=Math.sqrt(3)/2*Math.abs(n.compute(0)-n.compute(t))*e,s=r/2,a=[r,s,-s,-r,-s,s],l=[0,-o,-o,0,o,o];return[a,l]},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.svx,s=i.svy,a=i._scale,l=0,h=e;l<h.length;l++){var u=h[l];if(!isNaN(n[u]+r[u]+a[u])){t.translate(n[u],r[u]),t.beginPath();for(var c=0;c<6;c++)t.lineTo(o[c]*a[u],s[c]*a[u]);t.closePath(),t.translate(-n[u],-r[u]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,u),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,u),t.stroke())}}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),s=this.index.indices({minX:n,minY:r,maxX:n,maxY:r}),a=[],l=0,h=s;l<h.length;l++){var u=h[l];o.point_in_poly(e-this.sx[u],i-this.sy[u],this.svx,this.svy)&&a.push(u)}var c=o.create_empty_hit_test_result();return c.indices=a,c},e.prototype._hit_span=function(t){var e,i=t.sx,n=t.sy;if("v"==t.direction){var r=this.renderer.yscale.invert(n),s=this.renderer.plot_view.frame.bbox.h_range,a=this.renderer.xscale.r_invert(s.start,s.end),l=a[0],h=a[1];e=this.index.indices({minX:l,minY:r,maxX:h,maxY:r})}else{var u=this.renderer.xscale.invert(i),c=this.renderer.plot_view.frame.bbox.v_range,_=this.renderer.yscale.r_invert(c.start,c.end),p=_[0],d=_[1];e=this.index.indices({minX:u,minY:p,maxX:u,maxY:d})}var f=o.create_empty_hit_test_result();return f.indices=e,f},e.prototype._hit_rect=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,r=t.sy1,s=this.renderer.xscale.r_invert(e,i),a=s[0],l=s[1],h=this.renderer.yscale.r_invert(n,r),u=h[0],c=h[1],_=o.validate_bbox_coords([a,l],[u,c]),p=o.create_empty_hit_test_result();return p.indices=this.index.indices(_),p},e.prototype.draw_legend_for_index=function(t,e,i){l.generic_area_legend(this.visuals,t,e,i)},e}(r.GlyphView);i.HexTileView=h;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="HexTile",this.prototype.default_view=h,this.coords([["r","q"]]),this.mixins(["line","fill"]),this.define({size:[s.Number,1],aspect_scale:[s.Number,1],scale:[s.NumberSpec,1],orientation:[s.HexTileOrientation,"pointytop"]}),this.override({line_color:null})},e}(r.Glyph);i.HexTile=u,u.initClass()},function(t,e,i){var n=t(408),r=t(132),o=t(178),s=t(18),a=t(24),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.color_mapper.change,function(){return e._update_image()}),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},e.prototype._update_image=function(){null!=this.image_data&&(this._set_data(),this.renderer.plot_view.request_render())},e.prototype._set_data=function(){this._set_width_heigh_data();for(var t=this.model.color_mapper.rgba_mapper,e=0,i=this._image.length;e<i;e++){var n=void 0;if(null!=this._image_shape&&this._image_shape[e].length>0){n=this._image[e];var r=this._image_shape[e];this._height[e]=r[0],this._width[e]=r[1]}else{var o=this._image[e];n=a.concat(o),this._height[e]=o.length,this._width[e]=o[0].length}var s=t.v_compute(n);this._set_image_data_from_buffer(e,s)}},e.prototype._render=function(t,e,i){var n=i.image_data,r=i.sx,o=i.sy,s=i.sw,a=i.sh,l=t.getImageSmoothingEnabled();t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.global_alpha;for(var h=0,u=e;h<u.length;h++){var c=u[h];if(null!=n[c]&&!isNaN(r[c]+o[c]+s[c]+a[c])){var _=o[c];t.translate(0,_),t.scale(1,-1),t.translate(0,-_),t.drawImage(n[c],0|r[c],0|o[c],s[c],a[c]),t.translate(0,_),t.scale(1,-1),t.translate(0,-_)}}t.setImageSmoothingEnabled(l)},e}(r.ImageBaseView);i.ImageView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Image",this.prototype.default_view=l,this.define({color_mapper:[s.Instance,function(){return new o.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})}]})},e}(r.ImageBase);i.Image=h,h.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(18),s=t(9),a=t(39),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){},e.prototype._index_data=function(){for(var t=[],e=0,i=this._x.length;e<i;e++){var n=this._lrtb(e),r=n[0],o=n[1],s=n[2],l=n[3];!isNaN(r+o+s+l)&&isFinite(r+o+s+l)&&t.push({minX:r,minY:l,maxX:o,maxY:s,i:e})}return new a.SpatialIndex(t)},e.prototype._lrtb=function(t){var e=this.renderer.xscale.source_range,i=this._x[t],n=e.is_reversed?i-this._dw[t]:i+this._dw[t],r=this.renderer.yscale.source_range,o=this._y[t],s=r.is_reversed?o-this._dh[t]:o+this._dh[t],a=i<n?[i,n]:[n,i],l=a[0],h=a[1],u=o<s?[o,s]:[s,o],c=u[0],_=u[1];return[l,h,_,c]},e.prototype._set_width_heigh_data=function(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new Array(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new Array(this._image.length))},e.prototype._get_or_create_canvas=function(t){var e=this.image_data[t];if(null!=e&&e.width==this._width[t]&&e.height==this._height[t])return e;var i=document.createElement("canvas");return i.width=this._width[t],i.height=this._height[t],i},e.prototype._set_image_data_from_buffer=function(t,e){var i=this._get_or_create_canvas(t),n=i.getContext("2d"),r=n.getImageData(0,0,this._width[t],this._height[t]);r.data.set(e),n.putImageData(r,0,0),this.image_data[t]=i},e.prototype._map_data=function(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}},e.prototype._image_index=function(t,e,i){var n=this._lrtb(t),r=n[0],o=n[1],s=n[2],a=n[3],l=this._width[t],h=this._height[t],u=(o-r)/l,c=(s-a)/h,_=Math.floor((e-r)/u),p=Math.floor((i-a)/c);return{index:t,dim1:_,dim2:p,flat_index:p*l+_}},e.prototype._hit_point=function(t){var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=s.validate_bbox_coords([n,n],[r,r]),a=this.index.indices(o),l=s.create_empty_hit_test_result();l.image_indices=[];for(var h=0,u=a;h<u.length;h++){var c=u[h];e!=1/0&&i!=1/0&&l.image_indices.push(this._image_index(c,n,r))}return l},e}(r.XYGlyphView);i.ImageBaseView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ImageBase",this.prototype.default_view=l,this.define({image:[o.NumberSpec],dw:[o.DistanceSpec],dh:[o.DistanceSpec],dilate:[o.Boolean,!1],global_alpha:[o.Number,1]})},e}(r.XYGlyph);i.ImageBase=h,h.initClass()},function(t,e,i){var n=t(408),r=t(132),o=t(24),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},e.prototype._set_data=function(t){this._set_width_heigh_data();for(var e=0,i=this._image.length;e<i;e++)if(!(null!=t&&t.indexOf(e)<0)){var n=void 0;if(null!=this._image_shape&&this._image_shape[e].length>0){n=this._image[e].buffer;var r=this._image_shape[e];this._height[e]=r[0],this._width[e]=r[1]}else{var s=this._image[e],a=o.concat(s);n=new ArrayBuffer(4*a.length);for(var l=new Uint32Array(n),h=0,u=a.length;h<u;h++)l[h]=a[h];this._height[e]=s.length,this._width[e]=s[0].length}var c=new Uint8Array(n);this._set_image_data_from_buffer(e,c)}},e.prototype._render=function(t,e,i){var n=i.image_data,r=i.sx,o=i.sy,s=i.sw,a=i.sh,l=t.getImageSmoothingEnabled();t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.global_alpha;for(var h=0,u=e;h<u.length;h++){var c=u[h];if(!isNaN(r[c]+o[c]+s[c]+a[c])){var _=o[c];t.translate(0,_),t.scale(1,-1),t.translate(0,-_),t.drawImage(n[c],0|r[c],0|o[c],s[c],a[c]),t.translate(0,_),t.scale(1,-1),t.translate(0,-_)}}t.setImageSmoothingEnabled(l)},e}(r.ImageBaseView);i.ImageRGBAView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ImageRGBA",this.prototype.default_view=s},e}(r.ImageBase);i.ImageRGBA=a,a.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(17),s=t(18),a=t(25),l=t(39),h=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._images_rendered=!1,e}return n.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},e.prototype._index_data=function(){return new l.SpatialIndex([])},e.prototype._set_data=function(){var t=this;null!=this.image&&this.image.length==this._url.length||(this.image=a.map(this._url,function(){return null}));var e=this.model,i=e.retry_attempts,n=e.retry_timeout;this.retries=a.map(this._url,function(){return i});for(var r=function(e,r){var a=s._url[e];if(null==a||""==a)return"continue";var l=new Image;l.onerror=function(){t.retries[e]>0?(o.logger.trace("ImageURL failed to load "+a+" image, retrying in "+n+" ms"),setTimeout(function(){return l.src=a},n)):o.logger.warn("ImageURL unable to load "+a+" image after "+i+" retries"),t.retries[e]-=1},l.onload=function(){t.image[e]=l,t.renderer.request_render()},l.src=a},s=this,l=0,h=this._url.length;l<h;l++)r(l,h);for(var u="data"==this.model.properties.w.units,c="data"==this.model.properties.h.units,_=this._x.length,p=new Array(u?2*_:_),d=new Array(c?2*_:_),l=0;l<_;l++)p[l]=this._x[l],d[l]=this._y[l];if(u)for(var l=0;l<_;l++)p[_+l]=this._x[l]+this._w[l];if(c)for(var l=0;l<_;l++)d[_+l]=this._y[l]+this._h[l];var f=a.min(p),v=a.max(p),m=a.min(d),g=a.max(d);this._bounds_rect={minX:f,maxX:v,minY:m,maxY:g}},e.prototype.has_finished=function(){return t.prototype.has_finished.call(this)&&1==this._images_rendered},e.prototype._map_data=function(){var t=null!=this.model.w?this._w:a.map(this._x,function(){return NaN}),e=null!=this.model.h?this._h:a.map(this._x,function(){return NaN});switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,t,"edge",this.model.dilate);break;case"screen":this.sw=t}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,e,"edge",this.model.dilate);break;case"screen":this.sh=e}},e.prototype._render=function(t,e,i){var n=i.image,r=i.sx,o=i.sy,s=i.sw,a=i.sh,l=i._angle,h=this.renderer.plot_view.frame;t.rect(h._left.value+1,h._top.value+1,h._width.value-2,h._height.value-2),t.clip();for(var u=!0,c=0,_=e;c<_.length;c++){var p=_[c];if(!isNaN(r[p]+o[p]+l[p])){var d=n[p];null!=d?this._render_image(t,p,d,r,o,s,a,l):u=!1}}u&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())},e.prototype._final_sx_sy=function(t,e,i,n,r){switch(t){case"top_left":return[e,i];case"top_center":return[e-n/2,i];case"top_right":return[e-n,i];case"center_right":return[e-n,i-r/2];case"bottom_right":return[e-n,i-r];case"bottom_center":return[e-n/2,i-r];case"bottom_left":return[e,i-r];case"center_left":return[e,i-r/2];case"center":return[e-n/2,i-r/2]}},e.prototype._render_image=function(t,e,i,n,r,o,s,a){isNaN(o[e])&&(o[e]=i.width),isNaN(s[e])&&(s[e]=i.height);var l=this.model.anchor,h=this._final_sx_sy(l,n[e],r[e],o[e],s[e]),u=h[0],c=h[1];t.save(),t.globalAlpha=this.model.global_alpha,a[e]?(t.translate(u,c),t.rotate(a[e]),t.drawImage(i,0,0,o[e],s[e]),t.rotate(-a[e]),t.translate(-u,-c)):t.drawImage(i,u,c,o[e],s[e]),t.restore()},e.prototype.bounds=function(){return this._bounds_rect},e}(r.XYGlyphView);i.ImageURLView=h;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ImageURL",this.prototype.default_view=h,this.define({url:[s.StringSpec],anchor:[s.Anchor,"top_left"],global_alpha:[s.Number,1],angle:[s.AngleSpec,0],w:[s.DistanceSpec],h:[s.DistanceSpec],dilate:[s.Boolean,!1],retry_attempts:[s.Number,0],retry_timeout:[s.Number,0]})},e}(r.XYGlyph);i.ImageURL=u,u.initClass()},function(t,e,i){var n=t(117);i.AnnularWedge=n.AnnularWedge;var r=t(118);i.Annulus=r.Annulus;var o=t(119);i.Arc=o.Arc;var s=t(121);i.Bezier=s.Bezier;var a=t(124);i.Circle=a.Circle;var l=t(123);i.CenterRotatable=l.CenterRotatable;var h=t(125);i.Ellipse=h.Ellipse;var u=t(126);i.EllipseOval=u.EllipseOval;var c=t(127);i.Glyph=c.Glyph;var _=t(128);i.HArea=_.HArea;var p=t(129);i.HBar=p.HBar;var d=t(130);i.HexTile=d.HexTile;var f=t(131);i.Image=f.Image;var v=t(133);i.ImageRGBA=v.ImageRGBA;var m=t(134);i.ImageURL=m.ImageURL;var g=t(136);i.Line=g.Line;var y=t(137);i.MultiLine=y.MultiLine;var b=t(138);i.MultiPolygons=b.MultiPolygons;var x=t(139);i.Oval=x.Oval;var w=t(140);i.Patch=w.Patch;var k=t(141);i.Patches=k.Patches;var T=t(142);i.Quad=T.Quad;var C=t(143);i.Quadratic=C.Quadratic;var S=t(144);i.Ray=S.Ray;var A=t(145);i.Rect=A.Rect;var M=t(146);i.Segment=M.Segment;var E=t(147);i.Step=E.Step;var z=t(148);i.Text=z.Text;var O=t(150);i.VArea=O.VArea;var P=t(151);i.VBar=P.VBar;var j=t(152);i.Wedge=j.Wedge;var N=t(153);i.XYGlyph=N.XYGlyph},function(t,e,i){var n=t(408),r=t(153),o=t(149),s=t(9),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=!1,s=null;this.visuals.line.set_value(t);for(var a=0,l=e;a<l.length;a++){var h=l[a];if(o){if(!isFinite(n[h]+r[h])){t.stroke(),t.beginPath(),o=!1,s=h;continue}null!=s&&h-s>1&&(t.stroke(),o=!1)}o?t.lineTo(n[h],r[h]):(t.beginPath(),t.moveTo(n[h],r[h]),o=!0),s=h}o&&t.stroke()},e.prototype._hit_point=function(t){for(var e=this,i=s.create_empty_hit_test_result(),n={x:t.sx,y:t.sy},r=9999,o=Math.max(2,this.visuals.line.line_width.value()/2),a=0,l=this.sx.length-1;a<l;a++){var h={x:this.sx[a],y:this.sy[a]},u={x:this.sx[a+1],y:this.sy[a+1]},c=s.dist_to_segment(n,h,u);c<o&&c<r&&(r=c,i.add_to_selected_glyphs(this.model),i.get_view=function(){return e},i.line_indices=[a])}return i},e.prototype._hit_span=function(t){var e,i,n=this,r=t.sx,o=t.sy,a=s.create_empty_hit_test_result();"v"==t.direction?(e=this.renderer.yscale.invert(o),i=this._y):(e=this.renderer.xscale.invert(r),i=this._x);for(var l=0,h=i.length-1;l<h;l++)(i[l]<=e&&e<=i[l+1]||i[l+1]<=e&&e<=i[l])&&(a.add_to_selected_glyphs(this.model),a.get_view=function(){return n},a.line_indices.push(l));return a},e.prototype.get_interpolation_hit=function(t,e){var i=[this._x[t],this._y[t],this._x[t+1],this._y[t+1]],n=i[0],r=i[1],s=i[2],a=i[3];return o.line_interpolation(this.renderer,e,n,r,s,a)},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.LineView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Line",this.prototype.default_view=a,this.mixins(["line"])},e}(r.XYGlyph);i.Line=l,l.initClass()},function(t,e,i){var n=t(408),r=t(39),o=t(9),s=t(35),a=t(24),l=t(46),h=t(127),u=t(149),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)if(null!=this._xs[e]&&0!==this._xs[e].length){for(var n=this._xs[e],o=[],s=0,h=n.length;s<h;s++){var u=n[s];l.isStrictNaN(u)||o.push(u)}for(var c=this._ys[e],_=[],s=0,h=c.length;s<h;s++){var p=c[s];l.isStrictNaN(p)||_.push(p)}var d=[a.min(o),a.max(o)],f=d[0],v=d[1],m=[a.min(_),a.max(_)],g=m[0],y=m[1];t.push({minX:f,minY:g,maxX:v,maxY:y,i:e})}return new r.SpatialIndex(t)},e.prototype._render=function(t,e,i){for(var n=i.sxs,r=i.sys,o=0,s=e;o<s.length;o++){var a=s[o],l=[n[a],r[a]],h=l[0],u=l[1];this.visuals.line.set_vectorize(t,a);for(var c=0,_=h.length;c<_;c++)0!=c?isNaN(h[c])||isNaN(u[c])?(t.stroke(),t.beginPath()):t.lineTo(h[c],u[c]):(t.beginPath(),t.moveTo(h[c],u[c]));t.stroke()}},e.prototype._hit_point=function(t){for(var e=o.create_empty_hit_test_result(),i={x:t.sx,y:t.sy},n=9999,r={},a=0,l=this.sxs.length;a<l;a++){for(var h=Math.max(2,this.visuals.line.cache_select("line_width",a)/2),u=null,c=0,_=this.sxs[a].length-1;c<_;c++){var p={x:this.sxs[a][c],y:this.sys[a][c]},d={x:this.sxs[a][c+1],y:this.sys[a][c+1]},f=o.dist_to_segment(i,p,d);f<h&&f<n&&(n=f,u=[c])}u&&(r[a]=u)}return e.indices=s.keys(r).map(function(t){return parseInt(t,10)}),e.multiline_indices=r,e},e.prototype._hit_span=function(t){var e,i,n=t.sx,r=t.sy,a=o.create_empty_hit_test_result();"v"===t.direction?(e=this.renderer.yscale.invert(r),i=this._ys):(e=this.renderer.xscale.invert(n),i=this._xs);for(var l={},h=0,u=i.length;h<u;h++){for(var c=[],_=0,p=i[h].length-1;_<p;_++)i[h][_]<=e&&e<=i[h][_+1]&&c.push(_);c.length>0&&(l[h]=c)}return a.indices=s.keys(l).map(function(t){return parseInt(t,10)}),a.multiline_indices=l,a},e.prototype.get_interpolation_hit=function(t,e,i){var n=[this._xs[t][e],this._ys[t][e],this._xs[t][e+1],this._ys[t][e+1]],r=n[0],o=n[1],s=n[2],a=n[3];return u.line_interpolation(this.renderer,i,r,o,s,a)},e.prototype.draw_legend_for_index=function(t,e,i){u.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e}(h.GlyphView);i.MultiLineView=c;var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="MultiLine",this.prototype.default_view=c,this.coords([["xs","ys"]]),this.mixins(["line"])},e}(h.Glyph);i.MultiLine=_,_.initClass()},function(t,e,i){var n=t(408),r=t(39),o=t(127),s=t(149),a=t(24),l=t(25),h=t(9),u=t(46),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)for(var n=0,o=this._xs[e].length;n<o;n++){var s=this._xs[e][n][0],l=this._ys[e][n][0];0!=s.length&&t.push({minX:a.min(s),minY:a.min(l),maxX:a.max(s),maxY:a.max(l),i:e})}return this.hole_index=this._index_hole_data(),new r.SpatialIndex(t)},e.prototype._index_hole_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)for(var n=0,o=this._xs[e].length;n<o;n++)if(this._xs[e][n].length>1)for(var s=1,l=this._xs[e][n].length;s<l;s++){var h=this._xs[e][n][s],u=this._ys[e][n][s];0!=h.length&&t.push({minX:a.min(h),minY:a.min(u),maxX:a.max(h),maxY:a.max(u),i:e})}return new r.SpatialIndex(t)},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.x_ranges.default,e=[t.min,t.max],i=e[0],n=e[1],r=this.renderer.plot_view.frame.y_ranges.default,o=[r.min,r.max],s=o[0],a=o[1],l=h.validate_bbox_coords([i,n],[s,a]),u=this.index.indices(l);return u.sort(function(t,e){return t-e}).filter(function(t,e,i){return 0===e||t!==i[e-1]})},e.prototype._inner_loop=function(t,e,i){t.beginPath();for(var n=0,r=e.length;n<r;n++)for(var o=0,s=e[n].length;o<s;o++){for(var a=e[n][o],l=i[n][o],h=0,u=a.length;h<u;h++)0!=h?t.lineTo(a[h],l[h]):t.moveTo(a[h],l[h]);t.closePath()}},e.prototype._render=function(t,e,i){var n=this,r=i.sxs,o=i.sys;if(this.visuals.fill.doit||this.visuals.line.doit)for(var s=function(e){var i=[r[e],o[e]],s=i[0],l=i[1];a.visuals.fill.doit&&(a.visuals.fill.set_vectorize(t,e),a._inner_loop(t,s,l),t.fill("evenodd")),a.visuals.hatch.doit2(t,e,function(){n._inner_loop(t,s,l),t.fill("evenodd")},function(){return n.renderer.request_render()}),a.visuals.line.doit&&(a.visuals.line.set_vectorize(t,e),a._inner_loop(t,s,l),t.stroke())},a=this,l=0,h=e;l<h.length;l++){var u=h[l];s(u)}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=this.index.indices({minX:n,minY:r,maxX:n,maxY:r}),s=this.hole_index.indices({minX:n,minY:r,maxX:n,maxY:r}),a=[],l=0,u=o.length;l<u;l++)for(var c=o[l],_=this.sxs[c],p=this.sys[c],d=0,f=_.length;d<f;d++){var v=_[d].length;if(h.point_in_poly(e,i,_[d][0],p[d][0]))if(1==v)a.push(c);else if(-1==s.indexOf(c))a.push(c);else if(v>1){for(var m=!1,g=1;g<v;g++){var y=_[d][g],b=p[d][g];if(h.point_in_poly(e,i,y,b)){m=!0;break}}m||a.push(c)}}var x=h.create_empty_hit_test_result();return x.indices=a,x},e.prototype._get_snap_coord=function(t){return l.sum(t)/t.length},e.prototype.scenterx=function(t,e,i){if(1==this.sxs[t].length)return this._get_snap_coord(this.sxs[t][0][0]);for(var n=this.sxs[t],r=this.sys[t],o=0,s=n.length;o<s;o++)if(h.point_in_poly(e,i,n[o][0],r[o][0]))return this._get_snap_coord(n[o][0]);throw new Error("unreachable code")},e.prototype.scentery=function(t,e,i){if(1==this.sys[t].length)return this._get_snap_coord(this.sys[t][0][0]);for(var n=this.sxs[t],r=this.sys[t],o=0,s=n.length;o<s;o++)if(h.point_in_poly(e,i,n[o][0],r[o][0]))return this._get_snap_coord(r[o][0]);throw new Error("unreachable code")},e.prototype.map_data=function(){for(var t=0,e=this.model._coords;t<e.length;t++){var i=e[t],n=i[0],r=i[1],o="s"+n,s="s"+r;if(r="_"+r,null!=this[n="_"+n]&&(u.isArray(this[n][0])||u.isTypedArray(this[n][0]))){var a=this[n].length;this[o]=new Array(a),this[s]=new Array(a);for(var l=0;l<a;l++){var h=this[n][l].length;this[o][l]=new Array(h),this[s][l]=new Array(h);for(var c=0;c<h;c++){var _=this[n][l][c].length;this[o][l][c]=new Array(_),this[s][l][c]=new Array(_);for(var p=0;p<_;p++){var d=this.map_to_screen(this[n][l][c][p],this[r][l][c][p]),f=d[0],v=d[1];this[o][l][c][p]=f,this[s][l][c][p]=v}}}}}},e.prototype.draw_legend_for_index=function(t,e,i){s.generic_area_legend(this.visuals,t,e,i)},e}(o.GlyphView);i.MultiPolygonsView=c;var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="MultiPolygons",this.prototype.default_view=c,this.coords([["xs","ys"]]),this.mixins(["line","fill","hatch"])},e}(o.Glyph);i.MultiPolygons=_,_.initClass()},function(t,e,i){var n=t(408),r=t(126),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){var t,e=this._x.length;this.sw=new Float64Array(e),t="data"==this.model.properties.width.units?this.sdist(this.renderer.xscale,this._x,this._width,"center"):this._width;for(var i=0;i<e;i++)this.sw[i]=.75*t[i];"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},e}(r.EllipseOvalView);i.OvalView=o;var s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Oval",this.prototype.default_view=o},e}(r.EllipseOval);i.Oval=s,s.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(149),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._inner_loop=function(t,e,i,n,r){for(var o=0,s=e;o<s.length;o++){var a=s[o];0!=a?isNaN(i[a]+n[a])?(t.closePath(),r.apply(t),t.beginPath()):t.lineTo(i[a],n[a]):(t.beginPath(),t.moveTo(i[a],n[a]))}t.closePath(),r.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sx,o=i.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner_loop(t,e,r,o,t.fill)),this.visuals.hatch.doit2(t,0,function(){return n._inner_loop(t,e,r,o,t.fill)},function(){return n.renderer.request_render()}),this.visuals.line.doit&&(this.visuals.line.set_value(t),this._inner_loop(t,e,r,o,t.stroke))},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.PatchView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Patch",this.prototype.default_view=s,this.mixins(["line","fill","hatch"])},e}(r.XYGlyph);i.Patch=a,a.initClass()},function(t,e,i){var n=t(408),r=t(39),o=t(127),s=t(149),a=t(24),l=t(25),h=t(46),u=t(9),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._build_discontinuous_object=function(t){for(var e=[],i=0,n=t.length;i<n;i++){e[i]=[];for(var r=a.copy(t[i]);r.length>0;){var o=a.find_last_index(r,function(t){return h.isStrictNaN(t)}),s=void 0;o>=0?s=r.splice(o):(s=r,r=[]);var l=s.filter(function(t){return!h.isStrictNaN(t)});e[i].push(l)}}return e},e.prototype._index_data=function(){for(var t=this._build_discontinuous_object(this._xs),e=this._build_discontinuous_object(this._ys),i=[],n=0,o=this._xs.length;n<o;n++)for(var s=0,l=t[n].length;s<l;s++){var h=t[n][s],u=e[n][s];0!=h.length&&i.push({minX:a.min(h),minY:a.min(u),maxX:a.max(h),maxY:a.max(u),i:n})}return new r.SpatialIndex(i)},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.x_ranges.default,e=[t.min,t.max],i=e[0],n=e[1],r=this.renderer.plot_view.frame.y_ranges.default,o=[r.min,r.max],s=o[0],a=o[1],l=u.validate_bbox_coords([i,n],[s,a]),h=this.index.indices(l);return h.sort(function(t,e){return t-e})},e.prototype._inner_loop=function(t,e,i,n){for(var r=0,o=e.length;r<o;r++)0!=r?isNaN(e[r]+i[r])?(t.closePath(),n.apply(t),t.beginPath()):t.lineTo(e[r],i[r]):(t.beginPath(),t.moveTo(e[r],i[r]));t.closePath(),n.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sxs,o=i.sys;this.sxss=this._build_discontinuous_object(r),this.syss=this._build_discontinuous_object(o);for(var s=function(e){var i=[r[e],o[e]],s=i[0],l=i[1];a.visuals.fill.doit&&(a.visuals.fill.set_vectorize(t,e),a._inner_loop(t,s,l,t.fill)),a.visuals.hatch.doit2(t,e,function(){return n._inner_loop(t,s,l,t.fill)},function(){return n.renderer.request_render()}),a.visuals.line.doit&&(a.visuals.line.set_vectorize(t,e),a._inner_loop(t,s,l,t.stroke))},a=this,l=0,h=e;l<h.length;l++){var u=h[l];s(u)}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=this.index.indices({minX:n,minY:r,maxX:n,maxY:r}),s=[],a=0,l=o.length;a<l;a++)for(var h=o[a],c=this.sxss[h],_=this.syss[h],p=0,d=c.length;p<d;p++)u.point_in_poly(e,i,c[p],_[p])&&s.push(h);var f=u.create_empty_hit_test_result();return f.indices=s,f},e.prototype._get_snap_coord=function(t){return l.sum(t)/t.length},e.prototype.scenterx=function(t,e,i){if(1==this.sxss[t].length)return this._get_snap_coord(this.sxs[t]);for(var n=this.sxss[t],r=this.syss[t],o=0,s=n.length;o<s;o++)if(u.point_in_poly(e,i,n[o],r[o]))return this._get_snap_coord(n[o]);throw new Error("unreachable code")},e.prototype.scentery=function(t,e,i){if(1==this.syss[t].length)return this._get_snap_coord(this.sys[t]);for(var n=this.sxss[t],r=this.syss[t],o=0,s=n.length;o<s;o++)if(u.point_in_poly(e,i,n[o],r[o]))return this._get_snap_coord(r[o]);throw new Error("unreachable code")},e.prototype.draw_legend_for_index=function(t,e,i){s.generic_area_legend(this.visuals,t,e,i)},e}(o.GlyphView);i.PatchesView=c;var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Patches",this.prototype.default_view=c,this.coords([["xs","ys"]]),this.mixins(["line","fill","hatch"])},e}(o.Glyph);i.Patches=_,_.initClass()},function(t,e,i){var n=t(408),r=t(122),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.get_anchor_point=function(t,e,i){var n=Math.min(this.sleft[e],this.sright[e]),r=Math.max(this.sright[e],this.sleft[e]),o=Math.min(this.stop[e],this.sbottom[e]),s=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:n,y:o};case"top_center":return{x:(n+r)/2,y:o};case"top_right":return{x:r,y:o};case"center_right":return{x:r,y:(o+s)/2};case"bottom_right":return{x:r,y:s};case"bottom_center":return{x:(n+r)/2,y:s};case"bottom_left":return{x:n,y:s};case"center_left":return{x:n,y:(o+s)/2};case"center":return{x:(n+r)/2,y:(o+s)/2};default:return null}},e.prototype.scenterx=function(t){return(this.sleft[t]+this.sright[t])/2},e.prototype.scentery=function(t){return(this.stop[t]+this.sbottom[t])/2},e.prototype._index_data=function(){return this._index_box(this._right.length)},e.prototype._lrtb=function(t){var e=this._left[t],i=this._right[t],n=this._top[t],r=this._bottom[t];return[e,i,n,r]},e}(r.BoxView);i.QuadView=o;var s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Quad",this.prototype.default_view=o,this.coords([["right","bottom"],["left","top"]])},e}(r.Box);i.Quad=s,s.initClass()},function(t,e,i){var n=t(408),r=t(39),o=t(127),s=t(149);function a(t,e,i){if(e==(t+i)/2)return[t,i];var n=(t-e)/(t-2*e+i),r=t*Math.pow(1-n,2)+2*e*(1-n)*n+i*Math.pow(n,2);return[Math.min(t,i,r),Math.max(t,i,r)]}var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x0.length;e<i;e++)if(!isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx[e]+this._cy[e])){var n=a(this._x0[e],this._cx[e],this._x1[e]),o=n[0],s=n[1],l=a(this._y0[e],this._cy[e],this._y1[e]),h=l[0],u=l[1];t.push({minX:o,minY:h,maxX:s,maxY:u,i:e})}return new r.SpatialIndex(t)},e.prototype._render=function(t,e,i){var n=i.sx0,r=i.sy0,o=i.sx1,s=i.sy1,a=i.scx,l=i.scy;if(this.visuals.line.doit)for(var h=0,u=e;h<u.length;h++){var c=u[h];isNaN(n[c]+r[c]+o[c]+s[c]+a[c]+l[c])||(t.beginPath(),t.moveTo(n[c],r[c]),t.quadraticCurveTo(a[c],l[c],o[c],s[c]),this.visuals.line.set_vectorize(t,c),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,i){s.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e}(o.GlyphView);i.QuadraticView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Quadratic",this.prototype.default_view=l,this.coords([["x0","y0"],["x1","y1"],["cx","cy"]]),this.mixins(["line"])},e}(o.Glyph);i.Quadratic=h,h.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(149),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length},e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=i.slength,s=i._angle;if(this.visuals.line.doit){for(var a=this.renderer.plot_view.frame._width.value,l=this.renderer.plot_view.frame._height.value,h=2*(a+l),u=0,c=o.length;u<c;u++)0==o[u]&&(o[u]=h);for(var _=0,p=e;_<p.length;_++){var u=p[_];isNaN(n[u]+r[u]+s[u]+o[u])||(t.translate(n[u],r[u]),t.rotate(s[u]),t.beginPath(),t.moveTo(0,0),t.lineTo(o[u],0),this.visuals.line.set_vectorize(t,u),t.stroke(),t.rotate(-s[u]),t.translate(-n[u],-r[u]))}}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.RayView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Ray",this.prototype.default_view=a,this.mixins(["line"]),this.define({length:[s.DistanceSpec],angle:[s.AngleSpec]})},e}(r.XYGlyph);i.Ray=l,l.initClass()},function(t,e,i){var n=t(408),r=t(123),o=t(149),s=t(9),a=t(18),l=t(25),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){var t,e;if("data"==this.model.properties.width.units)t=this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale),this.sw=t[0],this.sx0=t[1];else{this.sw=this._width;var i=this.sx.length;this.sx0=new Float64Array(i);for(var n=0;n<i;n++)this.sx0[n]=this.sx[n]-this.sw[n]/2}if("data"==this.model.properties.height.units)e=this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale),this.sh=e[0],this.sy1=e[1];else{this.sh=this._height;var r=this.sy.length;this.sy1=new Float64Array(r);for(var n=0;n<r;n++)this.sy1[n]=this.sy[n]-this.sh[n]/2}var o=this.sw.length;this.ssemi_diag=new Float64Array(o);for(var n=0;n<o;n++)this.ssemi_diag[n]=Math.sqrt(this.sw[n]/2*this.sw[n]/2+this.sh[n]/2*this.sh[n]/2)},e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=i.sx0,s=i.sy1,a=i.sw,l=i.sh,h=i._angle;if(this.visuals.fill.doit)for(var u=0,c=e;u<c.length;u++){var _=c[u];isNaN(n[_]+r[_]+o[_]+s[_]+a[_]+l[_]+h[_])||(this.visuals.fill.set_vectorize(t,_),h[_]?(t.translate(n[_],r[_]),t.rotate(h[_]),t.fillRect(-a[_]/2,-l[_]/2,a[_],l[_]),t.rotate(-h[_]),t.translate(-n[_],-r[_])):t.fillRect(o[_],s[_],a[_],l[_]))}if(this.visuals.line.doit){t.beginPath();for(var p=0,d=e;p<d.length;p++){var _=d[p];isNaN(n[_]+r[_]+o[_]+s[_]+a[_]+l[_]+h[_])||0!=a[_]&&0!=l[_]&&(h[_]?(t.translate(n[_],r[_]),t.rotate(h[_]),t.rect(-a[_]/2,-l[_]/2,a[_],l[_]),t.rotate(-h[_]),t.translate(-n[_],-r[_])):t.rect(o[_],s[_],a[_],l[_]),this.visuals.line.set_vectorize(t,_),t.stroke(),t.beginPath())}t.stroke()}},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=[],a=0,h=this.sx0.length;a<h;a++)o.push(this.sx0[a]+this.sw[a]/2);for(var u=[],a=0,h=this.sy1.length;a<h;a++)u.push(this.sy1[a]+this.sh[a]/2);for(var c=l.max(this._ddist(0,o,this.ssemi_diag)),_=l.max(this._ddist(1,u,this.ssemi_diag)),p=n-c,d=n+c,f=r-_,v=r+_,m=[],g=s.validate_bbox_coords([p,d],[f,v]),y=0,b=this.index.indices(g);y<b.length;y++){var a=b[y],x=void 0,w=void 0;if(this._angle[a]){var k=Math.sin(-this._angle[a]),T=Math.cos(-this._angle[a]),C=T*(e-this.sx[a])-k*(i-this.sy[a])+this.sx[a],S=k*(e-this.sx[a])+T*(i-this.sy[a])+this.sy[a];e=C,i=S,w=Math.abs(this.sx[a]-e)<=this.sw[a]/2,x=Math.abs(this.sy[a]-i)<=this.sh[a]/2}else w=e-this.sx0[a]<=this.sw[a]&&e-this.sx0[a]>=0,x=i-this.sy1[a]<=this.sh[a]&&i-this.sy1[a]>=0;x&&w&&m.push(a)}var A=s.create_empty_hit_test_result();return A.indices=m,A},e.prototype._map_dist_corner_for_data_side_length=function(t,e,i){for(var n=t.length,r=new Float64Array(n),o=new Float64Array(n),s=0;s<n;s++)r[s]=Number(t[s])-e[s]/2,o[s]=Number(t[s])+e[s]/2;for(var a=i.v_compute(r),l=i.v_compute(o),h=this.sdist(i,r,e,"edge",this.model.dilate),u=a,s=0,c=a.length;s<c;s++)if(a[s]!=l[s]){u=a[s]<l[s]?a:l;break}return[h,u]},e.prototype._ddist=function(t,e,i){for(var n=0==t?this.renderer.xscale:this.renderer.yscale,r=e,o=r.length,s=new Float64Array(o),a=0;a<o;a++)s[a]=r[a]+i[a];for(var l=n.v_invert(r),h=n.v_invert(s),u=l.length,c=new Float64Array(u),a=0;a<u;a++)c[a]=Math.abs(h[a]-l[a]);return c},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e.prototype._bounds=function(t){var e=t.minX,i=t.maxX,n=t.minY,r=t.maxY;return{minX:e-this.max_w2,maxX:i+this.max_w2,minY:n-this.max_h2,maxY:r+this.max_h2}},e}(r.CenterRotatableView);i.RectView=h;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Rect",this.prototype.default_view=h,this.define({dilate:[a.Boolean,!1]})},e}(r.CenterRotatable);i.Rect=u,u.initClass()},function(t,e,i){var n=t(408),r=t(9),o=t(39),s=t(127),a=t(149),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x0.length;e<i;e++){var n=this._x0[e],r=this._x1[e],s=this._y0[e],a=this._y1[e];isNaN(n+r+s+a)||t.push({minX:Math.min(n,r),minY:Math.min(s,a),maxX:Math.max(n,r),maxY:Math.max(s,a),i:e})}return new o.SpatialIndex(t)},e.prototype._render=function(t,e,i){var n=i.sx0,r=i.sy0,o=i.sx1,s=i.sy1;if(this.visuals.line.doit)for(var a=0,l=e;a<l.length;a++){var h=l[a];isNaN(n[h]+r[h]+o[h]+s[h])||(t.beginPath(),t.moveTo(n[h],r[h]),t.lineTo(o[h],s[h]),this.visuals.line.set_vectorize(t,h),t.stroke())}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n={x:e,y:i},o=[],s=this.renderer.xscale.r_invert(e-2,e+2),a=s[0],l=s[1],h=this.renderer.yscale.r_invert(i-2,i+2),u=h[0],c=h[1],_=this.index.indices({minX:a,minY:u,maxX:l,maxY:c}),p=0,d=_;p<d.length;p++){var f=d[p],v=Math.pow(Math.max(2,this.visuals.line.cache_select("line_width",f)/2),2),m={x:this.sx0[f],y:this.sy0[f]},g={x:this.sx1[f],y:this.sy1[f]},y=r.dist_to_segment_squared(n,m,g);y<v&&o.push(f)}var b=r.create_empty_hit_test_result();return b.indices=o,b},e.prototype._hit_span=function(t){var e,i,n,o,s,a=this.renderer.plot_view.frame.bbox.ranges,l=a[0],h=a[1],u=t.sx,c=t.sy;"v"==t.direction?(s=this.renderer.yscale.invert(c),e=[this._y0,this._y1],n=e[0],o=e[1]):(s=this.renderer.xscale.invert(u),i=[this._x0,this._x1],n=i[0],o=i[1]);for(var _=[],p=this.renderer.xscale.r_invert(l.start,l.end),d=p[0],f=p[1],v=this.renderer.yscale.r_invert(h.start,h.end),m=v[0],g=v[1],y=this.index.indices({minX:d,minY:m,maxX:f,maxY:g}),b=0,x=y;b<x.length;b++){var w=x[b];(n[w]<=s&&s<=o[w]||o[w]<=s&&s<=n[w])&&_.push(w)}var k=r.create_empty_hit_test_result();return k.indices=_,k},e.prototype.scenterx=function(t){return(this.sx0[t]+this.sx1[t])/2},e.prototype.scentery=function(t){return(this.sy0[t]+this.sy1[t])/2},e.prototype.draw_legend_for_index=function(t,e,i){a.generic_line_legend(this.visuals,t,e,i)},e}(s.GlyphView);i.SegmentView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Segment",this.prototype.default_view=l,this.coords([["x0","y0"],["x1","y1"]]),this.mixins(["line"])},e}(s.Glyph);i.Segment=h,h.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(149),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){var n,r,o,s,a,l,h=i.sx,u=i.sy,c=!1,_=null;this.visuals.line.set_value(t);var p=e.length;if(!(p<2)){t.beginPath(),t.moveTo(h[0],u[0]);for(var d=0,f=e;d<f.length;d++){var v=f[d],m=void 0,g=void 0,y=void 0,b=void 0;switch(this.model.mode){case"before":n=[h[v-1],u[v]],m=n[0],y=n[1],r=[h[v],u[v]],g=r[0],b=r[1];break;case"after":o=[h[v],u[v-1]],m=o[0],y=o[1],s=[h[v],u[v]],g=s[0],b=s[1];break;case"center":var x=(h[v-1]+h[v])/2;a=[x,u[v-1]],m=a[0],y=a[1],l=[x,u[v]],g=l[0],b=l[1];break;default:throw new Error("unexpected")}if(c){if(!isFinite(h[v]+u[v])){t.stroke(),t.beginPath(),c=!1,_=v;continue}null!=_&&v-_>1&&(t.stroke(),c=!1)}c?(t.lineTo(m,y),t.lineTo(g,b)):(t.beginPath(),t.moveTo(h[v],u[v]),c=!0),_=v}t.lineTo(h[p-1],u[p-1]),t.stroke()}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.StepView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Step",this.prototype.default_view=a,this.mixins(["line"]),this.define({mode:[s.StepMode,"before"]})},e}(r.XYGlyph);i.Step=l,l.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(9),s=t(18),a=t(43),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._rotate_point=function(t,e,i,n,r){var o=(t-i)*Math.cos(r)-(e-n)*Math.sin(r)+i,s=(t-i)*Math.sin(r)+(e-n)*Math.cos(r)+n;return[o,s]},e.prototype._text_bounds=function(t,e,i,n){var r=[t,t+i,t+i,t,t],o=[e,e,e-n,e-n,e];return[r,o]},e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=i._x_offset,s=i._y_offset,l=i._angle,h=i._text;this._sys=[],this._sxs=[];for(var u=0,c=e;u<c.length;u++){var _=c[u];if(!isNaN(n[_]+r[_]+o[_]+s[_]+l[_])&&null!=h[_]&&(this._sxs[_]=[],this._sys[_]=[],this.visuals.text.doit)){var p=""+h[_];t.save(),t.translate(n[_]+o[_],r[_]+s[_]),t.rotate(l[_]),this.visuals.text.set_vectorize(t,_);var d=this.visuals.text.cache_select("font",_),f=a.measure_font(d).height,v=this.visuals.text.text_line_height.value()*f;if(-1==p.indexOf("\n")){t.fillText(p,0,0);var m=n[_]+o[_],g=r[_]+s[_],y=t.measureText(p).width,b=this._text_bounds(m,g,y,v),x=b[0],w=b[1];this._sxs[_].push(x),this._sys[_].push(w)}else{var k=p.split("\n"),T=v*k.length,C=this.visuals.text.cache_select("text_baseline",_),S=void 0;switch(C){case"top":S=0;break;case"middle":S=-T/2+v/2;break;case"bottom":S=-T+v;break;default:S=0,console.warn("'"+C+"' baseline not supported with multi line text")}for(var A=0,M=k;A<M.length;A++){var E=M[A];t.fillText(E,0,S);var m=n[_]+o[_],g=S+r[_]+s[_],y=t.measureText(E).width,z=this._text_bounds(m,g,y,v),x=z[0],w=z[1];this._sxs[_].push(x),this._sys[_].push(w),S+=v}}t.restore()}}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=[],r=0;r<this._sxs.length;r++)for(var s=this._sxs[r],a=this._sys[r],l=s.length,h=0,u=l;h<u;h++){var c=this._rotate_point(e,i,s[l-1][0],a[l-1][0],-this._angle[r]),_=c[0],p=c[1];o.point_in_poly(_,p,s[h],a[h])&&n.push(r)}var d=o.create_empty_hit_test_result();return d.indices=n,d},e.prototype._scenterxy=function(t){var e=this._sxs[t][0][0],i=this._sys[t][0][0],n=(this._sxs[t][0][2]+e)/2,r=(this._sys[t][0][2]+i)/2,o=this._rotate_point(n,r,e,i,this._angle[t]),s=o[0],a=o[1];return{x:s,y:a}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e}(r.XYGlyphView);i.TextView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Text",this.prototype.default_view=l,this.mixins(["text"]),this.define({text:[s.NullStringSpec,{field:"text"}],angle:[s.AngleSpec,0],x_offset:[s.NumberSpec,0],y_offset:[s.NumberSpec,0]})},e}(r.XYGlyph);i.Text=h,h.initClass()},function(t,e,i){var n=t(9);i.generic_line_legend=function(t,e,i,n){var r=i.x0,o=i.x1,s=i.y0,a=i.y1;e.save(),e.beginPath(),e.moveTo(r,(s+a)/2),e.lineTo(o,(s+a)/2),t.line.doit&&(t.line.set_vectorize(e,n),e.stroke()),e.restore()},i.generic_area_legend=function(t,e,i,n){var r=i.x0,o=i.x1,s=i.y0,a=i.y1,l=.1*Math.abs(o-r),h=.1*Math.abs(a-s),u=r+l,c=o-l,_=s+h,p=a-h;t.fill.doit&&(t.fill.set_vectorize(e,n),e.fillRect(u,_,c-u,p-_)),null!=t.hatch&&t.hatch.doit&&(t.hatch.set_vectorize(e,n),e.fillRect(u,_,c-u,p-_)),t.line&&t.line.doit&&(e.beginPath(),e.rect(u,_,c-u,p-_),t.line.set_vectorize(e,n),e.stroke())},i.line_interpolation=function(t,e,i,r,o,s){var a,l,h,u,c,_,p,d,f,v,m=e.sx,g=e.sy;"point"==e.type?(a=t.yscale.r_invert(g-1,g+1),f=a[0],v=a[1],l=t.xscale.r_invert(m-1,m+1),p=l[0],d=l[1]):"v"==e.direction?(h=t.yscale.r_invert(g,g),f=h[0],v=h[1],u=[Math.min(i-1,o-1),Math.max(i+1,o+1)],p=u[0],d=u[1]):(c=t.xscale.r_invert(m,m),p=c[0],d=c[1],_=[Math.min(r-1,s-1),Math.max(r+1,s+1)],f=_[0],v=_[1]);var y=n.check_2_segments_intersect(p,f,d,v,i,r,o,s),b=y.x,x=y.y;return[b,x]}},function(t,e,i){var n=t(408),r=t(120),o=t(39),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x.length;e<i;e++){var n=this._x[e],r=this._y1[e],s=this._y2[e];!isNaN(n+r+s)&&isFinite(n+r+s)&&t.push({minX:n,minY:Math.min(r,s),maxX:n,maxY:Math.max(r,s),i:e})}return new o.SpatialIndex(t)},e.prototype._inner=function(t,e,i,n,r){t.beginPath();for(var o=0,s=i.length;o<s;o++)t.lineTo(e[o],i[o]);for(var a=n.length-1,o=a;o>=0;o--)t.lineTo(e[o],n[o]);t.closePath(),r.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sx,o=i.sy1,s=i.sy2;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,r,o,s,t.fill)),this.visuals.hatch.doit2(t,0,function(){return n._inner(t,r,o,s,t.fill)},function(){return n.renderer.request_render()})},e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return(this.sy1[t]+this.sy2[t])/2},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)},e}(r.AreaView);i.VAreaView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="VArea",this.prototype.default_view=a,this.define({x:[s.CoordinateSpec],y1:[s.CoordinateSpec],y2:[s.CoordinateSpec]})},e}(r.Area);i.VArea=l,l.initClass()},function(t,e,i){var n=t(408),r=t(122),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return(this.stop[t]+this.sbottom[t])/2},e.prototype._index_data=function(){return this._index_box(this._x.length)},e.prototype._lrtb=function(t){var e=this._x[t]-this._width[t]/2,i=this._x[t]+this._width[t]/2,n=Math.max(this._top[t],this._bottom[t]),r=Math.min(this._top[t],this._bottom[t]);return[e,i,n,r]},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);var t=this.sx.length;this.sleft=new Float64Array(t),this.sright=new Float64Array(t);for(var e=0;e<t;e++)this.sleft[e]=this.sx[e]-this.sw[e]/2,this.sright[e]=this.sx[e]+this.sw[e]/2;this._clamp_viewport()},e}(r.BoxView);i.VBarView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="VBar",this.prototype.default_view=s,this.coords([["x","bottom"]]),this.define({width:[o.DistanceSpec],top:[o.CoordinateSpec]}),this.override({bottom:0})},e}(r.Box);i.VBar=a,a.initClass()},function(t,e,i){var n=t(408),r=t(153),o=t(149),s=t(9),a=t(18),l=t(34),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.sradius,s=i._start_angle,a=i._end_angle,l=this.model.properties.direction.value(),h=0,u=e;h<u.length;h++){var c=u[h];isNaN(n[c]+r[c]+o[c]+s[c]+a[c])||(t.beginPath(),t.arc(n[c],r[c],o[c],s[c],a[c],l),t.lineTo(n[c],r[c]),t.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,c),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,c),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,n,r,o,a,h,u,c,_,p,d,f,v=t.sx,m=t.sy,g=this.renderer.xscale.invert(v),y=this.renderer.yscale.invert(m),b=2*this.max_radius;"data"===this.model.properties.radius.units?(_=g-b,p=g+b,d=y-b,f=y+b):(a=v-b,h=v+b,e=this.renderer.xscale.r_invert(a,h),_=e[0],p=e[1],u=m-b,c=m+b,i=this.renderer.yscale.r_invert(u,c),d=i[0],f=i[1]);for(var x=[],w=s.validate_bbox_coords([_,p],[d,f]),k=0,T=this.index.indices(w);k<T.length;k++){var C=T[k],S=Math.pow(this.sradius[C],2);n=this.renderer.xscale.r_compute(g,this._x[C]),a=n[0],h=n[1],r=this.renderer.yscale.r_compute(y,this._y[C]),u=r[0],c=r[1],(o=Math.pow(a-h,2)+Math.pow(u-c,2))<=S&&x.push([C,o])}for(var A=this.model.properties.direction.value(),M=[],E=0,z=x;E<z.length;E++){var O=z[E],C=O[0],P=O[1],j=Math.atan2(m-this.sy[C],v-this.sx[C]);l.angle_between(-j,-this._start_angle[C],-this._end_angle[C],A)&&M.push([C,P])}return s.create_hit_test_result_from_hits(M)},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e.prototype._scenterxy=function(t){var e=this.sradius[t]/2,i=(this._start_angle[t]+this._end_angle[t])/2;return{x:this.sx[t]+e*Math.cos(i),y:this.sy[t]+e*Math.sin(i)}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e}(r.XYGlyphView);i.WedgeView=h;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Wedge",this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({direction:[a.Direction,"anticlock"],radius:[a.DistanceSpec],start_angle:[a.AngleSpec],end_angle:[a.AngleSpec]})},e}(r.XYGlyph);i.Wedge=u,u.initClass()},function(t,e,i){var n=t(408),r=t(39),o=t(127),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x.length;e<i;e++){var n=this._x[e],o=this._y[e];!isNaN(n+o)&&isFinite(n+o)&&t.push({minX:n,minY:o,maxX:n,maxY:o,i:e})}return new r.SpatialIndex(t)},e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return this.sy[t]},e}(o.GlyphView);i.XYGlyphView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="XYGlyph",this.coords([["x","y"]])},e}(o.Glyph);i.XYGlyph=a,a.initClass()},function(t,e,i){var n=t(408),r=t(62),o=t(25),s=t(24),a=t(9),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GraphHitTestPolicy"},e.prototype._hit_test_nodes=function(t,e){if(!e.model.visible)return null;var i=e.node_view.glyph.hit_test(t);return null==i?null:e.node_view.model.view.convert_selection_from_subset(i)},e.prototype._hit_test_edges=function(t,e){if(!e.model.visible)return null;var i=e.edge_view.glyph.hit_test(t);return null==i?null:e.edge_view.model.view.convert_selection_from_subset(i)},e}(r.Model);i.GraphHitTestPolicy=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="NodesOnly"},e.prototype.hit_test=function(t,e){return this._hit_test_nodes(t,e)},e.prototype.do_selection=function(t,e,i,n){if(null==t)return!1;var r=e.node_renderer.data_source.selected;return r.update(t,i,n),e.node_renderer.data_source._select.emit(),!r.is_empty()},e.prototype.do_inspection=function(t,e,i,n,r){if(null==t)return!1;var o=i.model.get_selection_manager().get_or_create_inspector(i.node_view.model);return o.update(t,n,r),i.node_view.model.data_source.setv({inspected:o},{silent:!0}),i.node_view.model.data_source.inspect.emit([i.node_view,{geometry:e}]),!o.is_empty()},e}(l);i.NodesOnly=h,h.initClass();var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="NodesAndLinkedEdges"},e.prototype.hit_test=function(t,e){return this._hit_test_nodes(t,e)},e.prototype.get_linked_edges=function(t,e,i){var n=[];"selection"==i?n=t.selected.indices.map(function(e){return t.data.index[e]}):"inspection"==i&&(n=t.inspected.indices.map(function(e){return t.data.index[e]}));for(var r=[],o=0;o<e.data.start.length;o++)(s.contains(n,e.data.start[o])||s.contains(n,e.data.end[o]))&&r.push(o);for(var l=a.create_empty_hit_test_result(),h=0,u=r;h<u.length;h++){var o=u[h];l.multiline_indices[o]=[0]}return l.indices=r,l},e.prototype.do_selection=function(t,e,i,n){if(null==t)return!1;var r=e.node_renderer.data_source.selected;r.update(t,i,n);var o=e.edge_renderer.data_source.selected,s=this.get_linked_edges(e.node_renderer.data_source,e.edge_renderer.data_source,"selection");return o.update(s,i,n),e.node_renderer.data_source._select.emit(),!r.is_empty()},e.prototype.do_inspection=function(t,e,i,n,r){if(null==t)return!1;var o=i.node_view.model.data_source.selection_manager.get_or_create_inspector(i.node_view.model);o.update(t,n,r),i.node_view.model.data_source.setv({inspected:o},{silent:!0});var s=i.edge_view.model.data_source.selection_manager.get_or_create_inspector(i.edge_view.model),a=this.get_linked_edges(i.node_view.model.data_source,i.edge_view.model.data_source,"inspection");return s.update(a,n,r),i.edge_view.model.data_source.setv({inspected:s},{silent:!0}),i.node_view.model.data_source.inspect.emit([i.node_view,{geometry:e}]),!o.is_empty()},e}(l);i.NodesAndLinkedEdges=u,u.initClass();var c=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="EdgesAndLinkedNodes"},e.prototype.hit_test=function(t,e){return this._hit_test_edges(t,e)},e.prototype.get_linked_nodes=function(t,e,i){var n=[];"selection"==i?n=e.selected.indices:"inspection"==i&&(n=e.inspected.indices);for(var r=[],l=0,h=n;l<h.length;l++){var u=h[l];r.push(e.data.start[u]),r.push(e.data.end[u])}var c=s.uniq(r).map(function(e){return o.indexOf(t.data.index,e)}),_=a.create_empty_hit_test_result();return _.indices=c,_},e.prototype.do_selection=function(t,e,i,n){if(null==t)return!1;var r=e.edge_renderer.data_source.selected;r.update(t,i,n);var o=e.node_renderer.data_source.selected,s=this.get_linked_nodes(e.node_renderer.data_source,e.edge_renderer.data_source,"selection");return o.update(s,i,n),e.edge_renderer.data_source._select.emit(),!r.is_empty()},e.prototype.do_inspection=function(t,e,i,n,r){if(null==t)return!1;var o=i.edge_view.model.data_source.selection_manager.get_or_create_inspector(i.edge_view.model);o.update(t,n,r),i.edge_view.model.data_source.setv({inspected:o},{silent:!0});var s=i.node_view.model.data_source.selection_manager.get_or_create_inspector(i.node_view.model),a=this.get_linked_nodes(i.node_view.model.data_source,i.edge_view.model.data_source,"inspection");return s.update(a,n,r),i.node_view.model.data_source.setv({inspected:s},{silent:!0}),i.edge_view.model.data_source.inspect.emit([i.edge_view,{geometry:e}]),!o.is_empty()},e}(l);i.EdgesAndLinkedNodes=c,c.initClass()},function(t,e,i){var n=t(408);n.__exportStar(t(154),i),n.__exportStar(t(156),i),n.__exportStar(t(157),i)},function(t,e,i){var n=t(408),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LayoutProvider"},e}(r.Model);i.LayoutProvider=o,o.initClass()},function(t,e,i){var n=t(408),r=t(156),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="StaticLayoutProvider",this.define({graph_layout:[o.Any,{}]})},e.prototype.get_node_coordinates=function(t){for(var e=[],i=[],n=t.data.index,r=0,o=n.length;r<o;r++){var s=this.graph_layout[n[r]],a=null!=s?s:[NaN,NaN],l=a[0],h=a[1];e.push(l),i.push(h)}return[e,i]},e.prototype.get_edge_coordinates=function(t){for(var e,i,n=[],r=[],o=t.data.start,s=t.data.end,a=null!=t.data.xs&&null!=t.data.ys,l=0,h=o.length;l<h;l++){var u=null!=this.graph_layout[o[l]]&&null!=this.graph_layout[s[l]];if(a&&u)n.push(t.data.xs[l]),r.push(t.data.ys[l]);else{var c=void 0,_=void 0;u?(e=[this.graph_layout[o[l]],this.graph_layout[s[l]]],_=e[0],c=e[1]):(_=(i=[[NaN,NaN],[NaN,NaN]])[0],c=i[1]),n.push([_[0],c[0]]),r.push([_[1],c[1]])}}return[n,r]},e}(r.LayoutProvider);i.StaticLayoutProvider=s,s.initClass()},function(t,e,i){var n=t(408),r=t(199),o=t(18),s=t(46),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"_x_range_name",{get:function(){return this.model.x_range_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_y_range_name",{get:function(){return this.model.y_range_name},enumerable:!0,configurable:!0}),e.prototype.render=function(){if(this.model.visible){var t=this.plot_view.canvas_view.ctx;t.save(),this._draw_regions(t),this._draw_minor_grids(t),this._draw_grids(t),t.restore()}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.request_render()})},e.prototype._draw_regions=function(t){var e=this;if(this.visuals.band_fill.doit||this.visuals.band_hatch.doit){this.visuals.band_fill.set_value(t);for(var i=this.grid_coords("major",!1),n=i[0],r=i[1],o=function(i){if(i%2!=1)return"continue";var o=s.plot_view.map_to_screen(n[i],r[i],s._x_range_name,s._y_range_name),a=o[0],l=o[1],h=s.plot_view.map_to_screen(n[i+1],r[i+1],s._x_range_name,s._y_range_name),u=h[0],c=h[1];s.visuals.band_fill.doit&&t.fillRect(a[0],l[0],u[1]-a[0],c[1]-l[0]),s.visuals.band_hatch.doit2(t,i,function(){t.fillRect(a[0],l[0],u[1]-a[0],c[1]-l[0])},function(){return e.request_render()})},s=this,a=0;a<n.length-1;a++)o(a)}},e.prototype._draw_grids=function(t){if(this.visuals.grid_line.doit){var e=this.grid_coords("major"),i=e[0],n=e[1];this._draw_grid_helper(t,this.visuals.grid_line,i,n)}},e.prototype._draw_minor_grids=function(t){if(this.visuals.minor_grid_line.doit){var e=this.grid_coords("minor"),i=e[0],n=e[1];this._draw_grid_helper(t,this.visuals.minor_grid_line,i,n)}},e.prototype._draw_grid_helper=function(t,e,i,n){e.set_value(t);for(var r=0;r<i.length;r++){var o=this.plot_view.map_to_screen(i[r],n[r],this._x_range_name,this._y_range_name),s=o[0],a=o[1];t.beginPath(),t.moveTo(Math.round(s[0]),Math.round(a[0]));for(var l=1;l<s.length;l++)t.lineTo(Math.round(s[l]),Math.round(a[l]));t.stroke()}},e.prototype.ranges=function(){var t=this.model.dimension,e=(t+1)%2,i=this.plot_view.frame,n=[i.x_ranges[this.model.x_range_name],i.y_ranges[this.model.y_range_name]];return[n[t],n[e]]},e.prototype.computed_bounds=function(){var t,e,i,n=this.ranges()[0],r=this.model.bounds,o=[n.min,n.max];if(s.isArray(r))e=Math.min(r[0],r[1]),i=Math.max(r[0],r[1]),e<o[0]&&(e=o[0]),i>o[1]&&(i=o[1]);else{e=o[0],i=o[1];for(var a=0,l=this.plot_view.axis_views;a<l.length;a++){var h=l[a];h.dimension==this.model.dimension&&h.model.x_range_name==this.model.x_range_name&&h.model.y_range_name==this.model.y_range_name&&(t=h.computed_bounds,e=t[0],i=t[1])}}return[e,i]},e.prototype.grid_coords=function(t,e){var i;void 0===e&&(e=!0);var n=this.model.dimension,r=(n+1)%2,o=this.ranges(),s=o[0],a=o[1],l=this.computed_bounds(),h=l[0],u=l[1];i=[Math.min(h,u),Math.max(h,u)],h=i[0],u=i[1];var c=this.model.ticker.get_ticks(h,u,s,a.min,{})[t],_=s.min,p=s.max,d=a.min,f=a.max,v=[[],[]];e||(c[0]!=_&&c.splice(0,0,_),c[c.length-1]!=p&&c.push(p));for(var m=0;m<c.length;m++)if(c[m]!=_&&c[m]!=p||!e){for(var g=[],y=[],b=0;b<2;b++){var x=d+(f-d)/1*b;g.push(c[m]),y.push(x)}v[n].push(g),v[r].push(y)}return v},e}(r.GuideRendererView);i.GridView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Grid",this.prototype.default_view=a,this.mixins(["line:grid_","line:minor_grid_","fill:band_","hatch:band_"]),this.define({bounds:[o.Any,"auto"],dimension:[o.Any,0],ticker:[o.Instance],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},e}(r.GuideRenderer);i.Grid=l,l.initClass()},function(t,e,i){var n=t(158);i.Grid=n.Grid},function(t,e,i){var n=t(408);n.__exportStar(t(69),i),n.__exportStar(t(86),i),n.__exportStar(t(92),i),n.__exportStar(t(96),i),n.__exportStar(t(99),i),n.__exportStar(t(105),i),n.__exportStar(t(111),i),n.__exportStar(t(135),i),n.__exportStar(t(155),i),n.__exportStar(t(159),i),n.__exportStar(t(165),i),n.__exportStar(t(177),i),n.__exportStar(t(292),i),n.__exportStar(t(182),i),n.__exportStar(t(187),i),n.__exportStar(t(193),i),n.__exportStar(t(200),i),n.__exportStar(t(203),i),n.__exportStar(t(207),i),n.__exportStar(t(216),i),n.__exportStar(t(232),i),n.__exportStar(t(242),i),n.__exportStar(t(222),i),n.__exportStar(t(278),i)},function(t,e,i){var n=t(408),r=t(166),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,function(){return e.rebuild()})},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.children},enumerable:!0,configurable:!0}),e}(r.LayoutDOMView);i.BoxView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Box",this.define({children:[o.Array,[]],spacing:[o.Number,0]})},e}(r.LayoutDOM);i.Box=a,a.initClass()},function(t,e,i){var n=t(408),r=t(161),o=t(11),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._update_layout=function(){var t=this.child_views.map(function(t){return t.layout});this.layout=new o.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())},e}(r.BoxView);i.ColumnView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Column",this.prototype.default_view=a,this.define({rows:[s.Any,"auto"]})},e}(r.Box);i.Column=l,l.initClass()},function(t,e,i){var n=t(408),r=t(166),o=t(11),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,function(){return e.rebuild()})},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.children.map(function(t){var e=t[0];return e})},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new o.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(var t=0,e=this.model.children;t<e.length;t++){var i=e[t],n=i[0],r=i[1],s=i[2],a=i[3],l=i[4],h=this._child_views[n.id];this.layout.items.push({layout:h.layout,row:r,col:s,row_span:a,col_span:l})}this.layout.set_sizing(this.box_sizing())},e}(r.LayoutDOMView);i.GridBoxView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GridBox",this.prototype.default_view=a,this.define({children:[s.Array,[]],rows:[s.Any,"auto"],cols:[s.Any,"auto"],spacing:[s.Any,0]})},e}(r.LayoutDOM);i.GridBox=l,l.initClass()},function(t,e,i){var n=t(408),r=t(166),o=t(13),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new o.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())},e}(r.LayoutDOMView);i.HTMLBoxView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="HTMLBox"},e}(r.LayoutDOM);i.HTMLBox=a,a.initClass()},function(t,e,i){var n=t(161);i.Box=n.Box;var r=t(162);i.Column=r.Column;var o=t(163);i.GridBox=o.GridBox;var s=t(164);i.HTMLBox=s.HTMLBox;var a=t(166);i.LayoutDOM=a.LayoutDOM;var l=t(167);i.Row=l.Row;var h=t(168);i.Spacer=h.Spacer;var u=t(169);i.Panel=u.Panel,i.Tabs=u.Tabs;var c=t(170);i.WidgetBox=c.WidgetBox},function(t,e,i){var n=t(408),r=t(62),o=t(5),s=t(17),a=t(46),l=t(18),h=t(4),u=t(6),c=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._idle_notified=!1,e._offset_parent=null,e._viewport={},e}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el.style.position=this.is_root?"relative":"absolute",this._child_views={},this.build_child_views()},e.prototype.remove=function(){for(var e=0,i=this.child_views;e<i.length;e++){var n=i[e];n.remove()}this._child_views={},t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.is_root&&(this._on_resize=function(){return e.resize_layout()},window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval(function(){var t=e.el.offsetParent;e._offset_parent!=t&&(e._offset_parent=t,null!=t&&(e.compute_viewport(),e.invalidate_layout()))},250));var i=this.model.properties;this.on_change([i.width,i.height,i.min_width,i.min_height,i.max_width,i.max_height,i.margin,i.width_policy,i.height_policy,i.sizing_mode,i.aspect_ratio,i.visible,i.background],function(){return e.invalidate_layout()}),this.on_change([i.css_classes],function(){return e.invalidate_render()})},e.prototype.disconnect_signals=function(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),t.prototype.disconnect_signals.call(this)},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(this.model.css_classes)},Object.defineProperty(e.prototype,"child_views",{get:function(){var t=this;return this.child_models.map(function(e){return t._child_views[e.id]})},enumerable:!0,configurable:!0}),e.prototype.build_child_views=function(){h.build_views(this._child_views,this.child_models,{parent:this})},e.prototype.render=function(){var e;t.prototype.render.call(this),o.empty(this.el);var i=this.model.background;this.el.style.backgroundColor=null!=i?i:"",(e=o.classes(this.el).clear()).add.apply(e,this.css_classes());for(var n=0,r=this.child_views;n<r.length;n++){var s=r[n];this.el.appendChild(s.el),s.render()}},e.prototype.update_layout=function(){for(var t=0,e=this.child_views;t<e.length;t++){var i=e[t];i.update_layout()}this._update_layout()},e.prototype.update_position=function(){this.el.style.display=this.model.visible?"block":"none";var t=this.is_root?this.layout.sizing.margin:void 0;o.position(this.el,this.layout.bbox,t);for(var e=0,i=this.child_views;e<i.length;e++){var n=i[e];n.update_position()}},e.prototype.after_layout=function(){for(var t=0,e=this.child_views;t<e.length;t++){var i=e[t];i.after_layout()}this._has_finished=!0},e.prototype.compute_viewport=function(){this._viewport=this._viewport_size()},e.prototype.renderTo=function(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()},e.prototype.build=function(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this},e.prototype.rebuild=function(){this.build_child_views(),this.invalidate_render()},e.prototype.compute_layout=function(){var t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),s.logger.debug("layout computed in "+(Date.now()-t)+" ms"),this.notify_finished()},e.prototype.resize_layout=function(){this.root.compute_viewport(),this.root.compute_layout()},e.prototype.invalidate_layout=function(){this.root.update_layout(),this.root.compute_layout()},e.prototype.invalidate_render=function(){this.render(),this.invalidate_layout()},e.prototype.has_finished=function(){if(!t.prototype.has_finished.call(this))return!1;for(var e=0,i=this.child_views;e<i.length;e++){var n=i[e];if(!n.has_finished())return!1}return!0},e.prototype.notify_finished=function(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()},e.prototype._width_policy=function(){return null!=this.model.width?"fixed":"fit"},e.prototype._height_policy=function(){return null!=this.model.height?"fixed":"fit"},e.prototype.box_sizing=function(){var t=this.model,e=t.width_policy,i=t.height_policy,n=t.aspect_ratio;"auto"==e&&(e=this._width_policy()),"auto"==i&&(i=this._height_policy());var r=this.model.sizing_mode;if(null!=r)if("fixed"==r)e=i="fixed";else if("stretch_both"==r)e=i="max";else if("stretch_width"==r)e="max";else if("stretch_height"==r)i="max";else switch(null==n&&(n="auto"),r){case"scale_width":e="max",i="min";break;case"scale_height":e="min",i="max";break;case"scale_both":e="max",i="max";break;default:throw new Error("unreachable")}var o={width_policy:e,height_policy:i},s=this.model,l=s.min_width,h=s.min_height;null!=l&&(o.min_width=l),null!=h&&(o.min_height=h);var u=this.model,c=u.width,_=u.height;null!=c&&(o.width=c),null!=_&&(o.height=_);var p=this.model,d=p.max_width,f=p.max_height;null!=d&&(o.max_width=d),null!=f&&(o.max_height=f),"auto"==n&&null!=c&&null!=_?o.aspect=c/_:a.isNumber(n)&&(o.aspect=n);var v=this.model.margin;if(null!=v)if(a.isNumber(v))o.margin={top:v,right:v,bottom:v,left:v};else if(2==v.length){var m=v[0],g=v[1];o.margin={top:m,right:g,bottom:m,left:g}}else{var y=v[0],b=v[1],x=v[2],w=v[3];o.margin={top:y,right:b,bottom:x,left:w}}o.visible=this.model.visible;var k=this.model.align;return a.isArray(k)?(o.halign=k[0],o.valign=k[1]):o.halign=o.valign=k,o},e.prototype._viewport_size=function(){var t=this;return o.undisplayed(this.el,function(){for(var e=t.el;e=e.parentElement;)if(!e.classList.contains("bk-root")){if(e==document.body){var i=o.extents(document.body).margin,n=i.left,r=i.right,s=i.top,a=i.bottom,l=Math.ceil(document.documentElement.clientWidth-n-r),h=Math.ceil(document.documentElement.clientHeight-s-a);return{width:l,height:h}}var u=o.extents(e).padding,c=u.left,_=u.right,p=u.top,d=u.bottom,f=e.getBoundingClientRect(),v=f.width,m=f.height,g=Math.ceil(v-c-_),y=Math.ceil(m-p-d);if(g>0||y>0)return{width:g>0?g:void 0,height:y>0?y:void 0}}return{}})},e.prototype.serializable_state=function(){return n.__assign({},t.prototype.serializable_state.call(this),{bbox:this.layout.bbox.rect,children:this.child_views.map(function(t){return t.serializable_state()})})},e}(u.DOMView);i.LayoutDOMView=c;var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LayoutDOM",this.define({width:[l.Number,null],height:[l.Number,null],min_width:[l.Number,null],min_height:[l.Number,null],max_width:[l.Number,null],max_height:[l.Number,null],margin:[l.Any,[0,0,0,0]],width_policy:[l.Any,"auto"],height_policy:[l.Any,"auto"],aspect_ratio:[l.Any,null],sizing_mode:[l.SizingMode,null],visible:[l.Boolean,!0],disabled:[l.Boolean,!1],align:[l.Any,"start"],background:[l.Color,null],css_classes:[l.Array,[]]})},e}(r.Model);i.LayoutDOM=_,_.initClass()},function(t,e,i){var n=t(408),r=t(161),o=t(11),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._update_layout=function(){var t=this.child_views.map(function(t){return t.layout});this.layout=new o.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())},e}(r.BoxView);i.RowView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Row",this.prototype.default_view=a,this.define({cols:[s.Any,"auto"]})},e}(r.Box);i.Row=l,l.initClass()},function(t,e,i){var n=t(408),r=t(166),o=t(13),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new o.LayoutItem,this.layout.set_sizing(this.box_sizing())},e}(r.LayoutDOMView);i.SpacerView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Spacer",this.prototype.default_view=s},e}(r.LayoutDOM);i.Spacer=a,a.initClass()},function(t,e,i){var n=t(408),r=t(13),o=t(5),s=t(24),a=t(18),l=t(166),h=t(62),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tabs.change,function(){return e.rebuild()}),this.connect(this.model.properties.active.change,function(){return e.on_active_change()})},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.tabs.map(function(t){return t.child})},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){var t=this.model.tabs_location,e="above"==t||"below"==t,i=this.scroll_el,a=this.headers_el;this.header=new(function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(r,t),r.prototype._measure=function(n){var r=o.size(i),l=o.children(a).slice(0,3).map(function(t){return o.size(t)}),h=t.prototype._measure.call(this,n),u=h.width,c=h.height;if(e){var _=r.width+s.sum(l.map(function(t){return t.width}));return{width:n.width!=1/0?n.width:_,height:c}}var p=r.height+s.sum(l.map(function(t){return t.height}));return{width:u,height:n.height!=1/0?n.height:p}},r}(r.ContentBox))(this.header_el),e?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});var l=1,h=1;switch(t){case"above":l-=1;break;case"below":l+=1;break;case"left":h-=1;break;case"right":h+=1}var u={layout:this.header,row:l,col:h},c=this.child_views.map(function(t){return{layout:t.layout,row:1,col:1}});this.layout=new r.Grid([u].concat(c)),this.layout.set_sizing(this.box_sizing())},e.prototype.update_position=function(){t.prototype.update_position.call(this),this.header_el.style.position="absolute",o.position(this.header_el,this.header.bbox);var e=this.model.tabs_location,i="above"==e||"below"==e,n=o.size(this.scroll_el),r=o.scroll_size(this.headers_el);if(i){var s=this.header.bbox.width;r.width>s?(this.wrapper_el.style.maxWidth=s-n.width+"px",o.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",o.undisplay(this.scroll_el))}else{var a=this.header.bbox.height;r.height>a?(this.wrapper_el.style.maxHeight=a-n.height+"px",o.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",o.undisplay(this.scroll_el))}for(var l=this.child_views,h=0,u=l;h<u.length;h++){var c=u[h];o.hide(c.el)}var _=l[this.model.active];null!=_&&o.show(_.el)},e.prototype.render=function(){var e=this;t.prototype.render.call(this);var i=this.model.active,n=this.model.tabs_location,r="above"==n||"below"==n,a="bk-"+n,l=this.model.tabs.map(function(t,n){var r=o.div({class:["bk-tab",n==i?"bk-active":null]},t.title);if(r.addEventListener("click",function(t){t.target==t.currentTarget&&e.change_active(n)}),t.closable){var a=o.div({class:"bk-close"});a.addEventListener("click",function(t){if(t.target==t.currentTarget){e.model.tabs=s.remove_at(e.model.tabs,n);var i=e.model.tabs.length;e.model.active>i-1&&(e.model.active=i-1)}}),r.appendChild(a)}return r});this.headers_el=o.div({class:["bk-headers"]},l),this.wrapper_el=o.div({class:"bk-headers-wrapper"},this.headers_el);var h=o.div({class:["bk-btn","bk-btn-default"],disabled:""},o.div({class:["bk-caret","bk-left"]})),u=o.div({class:["bk-btn","bk-btn-default"]},o.div({class:["bk-caret","bk-right"]})),c=0,_=function(t){return function(){var i=e.model.tabs.length;0==(c="left"==t?Math.max(c-1,0):Math.min(c+1,i-1))?h.setAttribute("disabled",""):h.removeAttribute("disabled"),c==i-1?u.setAttribute("disabled",""):u.removeAttribute("disabled");var n=o.children(e.headers_el).slice(0,c).map(function(t){return t.getBoundingClientRect()});if(r){var a=-s.sum(n.map(function(t){return t.width}));e.headers_el.style.left=a+"px"}else{var l=-s.sum(n.map(function(t){return t.height}));e.headers_el.style.top=l+"px"}}};h.addEventListener("click",_("left")),u.addEventListener("click",_("right")),this.scroll_el=o.div({class:"bk-btn-group"},h,u),this.header_el=o.div({class:["bk-tabs-header",a]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)},e.prototype.change_active=function(t){t!=this.model.active&&(this.model.active=t,null!=this.model.callback&&this.model.callback.execute(this.model))},e.prototype.on_active_change=function(){for(var t=this.model.active,e=o.children(this.headers_el),i=0,n=e;i<n.length;i++){var r=n[i];r.classList.remove("bk-active")}e[t].classList.add("bk-active");for(var s=this.child_views,a=0,l=s;a<l.length;a++){var h=l[a];o.hide(h.el)}o.show(s[t].el)},e}(l.LayoutDOMView);i.TabsView=u;var c=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Tabs",this.prototype.default_view=u,this.define({tabs:[a.Array,[]],tabs_location:[a.Location,"above"],active:[a.Number,0],callback:[a.Any]})},e}(l.LayoutDOM);i.Tabs=c,c.initClass();var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Panel",this.define({title:[a.String,""],child:[a.Instance],closable:[a.Boolean,!1]})},e}(h.Model);i.Panel=_,_.initClass()},function(t,e,i){var n=t(408),r=t(162),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.ColumnView);i.WidgetBoxView=o;var s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="WidgetBox",this.prototype.default_view=o},e}(r.Column);i.WidgetBox=s,s.initClass()},function(t,e,i){var n=t(408),r=t(172),o=t(175),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CategoricalColorMapper",this.define({factors:[s.Array],start:[s.Number,0],end:[s.Number]})},e.prototype._v_compute=function(t,e,i,n){var o=n.nan_color;r.cat_v_compute(t,this.factors,i,e,this.start,this.end,o)},e}(o.ColorMapper);i.CategoricalColorMapper=a,a.initClass()},function(t,e,i){var n=t(25),r=t(46);function o(t,e){if(t.length!=e.length)return!1;for(var i=0,n=t.length;i<n;i++)if(t[i]!==e[i])return!1;return!0}i._cat_equals=o,i.cat_v_compute=function(t,e,i,s,a,l,h){for(var u=function(u,c){var _=t[u],p=void 0;r.isString(_)?p=n.index_of(e,_):(null!=a?_=null!=l?_.slice(a,l):_.slice(a):null!=l&&(_=_.slice(0,l)),p=1==_.length?n.index_of(e,_[0]):n.find_index(e,function(t){return o(t,_)}));var d=void 0;d=p<0||p>=i.length?h:i[p],s[u]=d},c=0,_=t.length;c<_;c++)u(c,_)}},function(t,e,i){var n=t(408),r=t(172),o=t(180),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CategoricalMarkerMapper",this.define({factors:[s.Array],markers:[s.Array],start:[s.Number,0],end:[s.Number],default_value:[s.MarkerType,"circle"]})},e.prototype.v_compute=function(t){var e=new Array(t.length);return r.cat_v_compute(t,this.factors,this.markers,e,this.start,this.end,this.default_value),e},e}(o.Mapper);i.CategoricalMarkerMapper=a,a.initClass()},function(t,e,i){var n=t(408),r=t(172),o=t(180),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CategoricalPatternMapper",this.define({factors:[s.Array],patterns:[s.Array],start:[s.Number,0],end:[s.Number],default_value:[s.HatchPatternType," "]})},e.prototype.v_compute=function(t){var e=new Array(t.length);return r.cat_v_compute(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e},e}(o.Mapper);i.CategoricalPatternMapper=a,a.initClass()},function(t,e,i){var n=t(408),r=t(180),o=t(18),s=t(46),a=t(30),l=t(31);function h(t){return s.isNumber(t)?t:("#"!=t[0]&&(t=a.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16))}function u(t){for(var e=new Uint32Array(t.length),i=0,n=t.length;i<n;i++)e[i]=h(t[i]);return e}function c(t){if(l.is_little_endian)for(var e=new DataView(t.buffer),i=0,n=t.length;i<n;i++)e.setUint32(4*i,t[i]);return new Uint8Array(t.buffer)}i._convert_color=h,i._convert_palette=u,i._uint32_to_rgba=c;var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ColorMapper",this.define({palette:[o.Any],nan_color:[o.Color,"gray"]})},e.prototype.v_compute=function(t){var e=new Array(t.length);return this._v_compute(t,e,this.palette,this._colors(function(t){return t})),e},Object.defineProperty(e.prototype,"rgba_mapper",{get:function(){var t=this,e=u(this.palette),i=this._colors(h);return{v_compute:function(n){var r=new Uint32Array(n.length);return t._v_compute(n,r,e,i),c(r)}}},enumerable:!0,configurable:!0}),e.prototype._colors=function(t){return{nan_color:t(this.nan_color)}},e}(r.Mapper);i.ColorMapper=_,_.initClass()},function(t,e,i){var n=t(408),r=t(175),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ContinuousColorMapper",this.define({high:[o.Number],low:[o.Number],high_color:[o.Color],low_color:[o.Color]})},e.prototype._colors=function(e){return n.__assign({},t.prototype._colors.call(this,e),{low_color:null!=this.low_color?e(this.low_color):void 0,high_color:null!=this.high_color?e(this.high_color):void 0})},e}(r.ColorMapper);i.ContinuousColorMapper=s,s.initClass()},function(t,e,i){var n=t(171);i.CategoricalColorMapper=n.CategoricalColorMapper;var r=t(173);i.CategoricalMarkerMapper=r.CategoricalMarkerMapper;var o=t(174);i.CategoricalPatternMapper=o.CategoricalPatternMapper;var s=t(176);i.ContinuousColorMapper=s.ContinuousColorMapper;var a=t(175);i.ColorMapper=a.ColorMapper;var l=t(178);i.LinearColorMapper=l.LinearColorMapper;var h=t(179);i.LogColorMapper=h.LogColorMapper},function(t,e,i){var n=t(408),r=t(176),o=t(25),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LinearColorMapper"},e.prototype._v_compute=function(t,e,i,n){for(var r=n.nan_color,s=n.low_color,a=n.high_color,l=null!=this.low?this.low:o.min(t),h=null!=this.high?this.high:o.max(t),u=i.length-1,c=1/(h-l),_=1/i.length,p=0,d=t.length;p<d;p++){var f=t[p];if(isNaN(f))e[p]=r;else if(f!=h){var v=(f-l)*c,m=Math.floor(v/_);e[p]=m<0?null!=s?s:i[0]:m>u?null!=a?a:i[u]:i[m]}else e[p]=i[u]}},e}(r.ContinuousColorMapper);i.LinearColorMapper=s,s.initClass()},function(t,e,i){var n=t(408),r=t(176),o=t(25),s=null!=Math.log1p?Math.log1p:function(t){return Math.log(1+t)},a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LogColorMapper"},e.prototype._v_compute=function(t,e,i,n){for(var r=n.nan_color,a=n.low_color,l=n.high_color,h=i.length,u=null!=this.low?this.low:o.min(t),c=null!=this.high?this.high:o.max(t),_=h/(s(c)-s(u)),p=i.length-1,d=0,f=t.length;d<f;d++){var v=t[d];if(isNaN(v))e[d]=r;else if(v>c)e[d]=null!=l?l:i[p];else if(v!=c)if(v<u)e[d]=null!=a?a:i[0];else{var m=s(v)-s(u),g=Math.floor(m*_);g>p&&(g=p),e[d]=i[g]}else e[d]=i[p]}},e}(r.ContinuousColorMapper);i.LogColorMapper=a,a.initClass()},function(t,e,i){var n=t(408),r=t(297),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Mapper"},e.prototype.compute=function(t){throw new Error("mapping single values is not supported")},e}(r.Transform);i.Mapper=o,o.initClass()},function(t,e,i){var n=t(408),r=t(183),o=Math.sqrt(3);function s(t,e){t.moveTo(-e,e),t.lineTo(e,-e),t.moveTo(-e,-e),t.lineTo(e,e)}function a(t,e){t.moveTo(0,e),t.lineTo(0,-e),t.moveTo(-e,0),t.lineTo(e,0)}function l(t,e){t.moveTo(0,e),t.lineTo(e/1.5,0),t.lineTo(0,-e),t.lineTo(-e/1.5,0),t.closePath()}function h(t,e){var i=e*o,n=i/3;t.moveTo(-e,n),t.lineTo(e,n),t.lineTo(0,n-i),t.closePath()}function u(t,e,i,n,r){var o=.65*i;a(t,i),s(t,o),n.doit&&(n.set_vectorize(t,e),t.stroke())}function c(t,e,i,n,r){t.arc(0,0,i,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),a(t,i),t.stroke())}function _(t,e,i,n,r){t.arc(0,0,i,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),s(t,i),t.stroke())}function p(t,e,i,n,r){a(t,i),n.doit&&(n.set_vectorize(t,e),t.stroke())}function d(t,e,i,n,r){l(t,i),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function f(t,e,i,n,r){l(t,i),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),a(t,i),t.stroke())}function v(t,e,i,n,r){!function(t,e){var i=e/2,n=o*i;t.moveTo(e,0),t.lineTo(i,-n),t.lineTo(-i,-n),t.lineTo(-e,0),t.lineTo(-i,n),t.lineTo(i,n),t.closePath()}(t,i),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function m(t,e,i,n,r){t.rotate(Math.PI),h(t,i),t.rotate(-Math.PI),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function g(t,e,i,n,r){var o=2*i;t.rect(-i,-i,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function y(t,e,i,n,r){var o=2*i;t.rect(-i,-i,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),a(t,i),t.stroke())}function b(t,e,i,n,r){var o=2*i;t.rect(-i,-i,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),s(t,i),t.stroke())}function x(t,e,i,n,r){h(t,i),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function w(t,e,i,n,r){!function(t,e){t.moveTo(-e,0),t.lineTo(e,0)}(t,i),n.doit&&(n.set_vectorize(t,e),t.stroke())}function k(t,e,i,n,r){s(t,i),n.doit&&(n.set_vectorize(t,e),t.stroke())}function T(t,e){var i=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.initClass=function(){this.prototype._render_one=e},i}(r.MarkerView);i.initClass();var o=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(r,e),r.initClass=function(){this.prototype.default_view=i,this.prototype.type=t},r}(r.Marker);return o.initClass(),o}i.Asterisk=T("Asterisk",u),i.CircleCross=T("CircleCross",c),i.CircleX=T("CircleX",_),i.Cross=T("Cross",p),i.Dash=T("Dash",w),i.Diamond=T("Diamond",d),i.DiamondCross=T("DiamondCross",f),i.Hex=T("Hex",v),i.InvertedTriangle=T("InvertedTriangle",m),i.Square=T("Square",g),i.SquareCross=T("SquareCross",y),i.SquareX=T("SquareX",b),i.Triangle=T("Triangle",x),i.X=T("X",k),i.marker_funcs={asterisk:u,circle:function(t,e,i,n,r){t.arc(0,0,i,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())},circle_cross:c,circle_x:_,cross:p,diamond:d,diamond_cross:f,hex:v,inverted_triangle:m,square:g,square_cross:y,square_x:b,triangle:x,dash:w,x:k}},function(t,e,i){var n=t(408);n.__exportStar(t(181),i);var r=t(183);i.Marker=r.Marker;var o=t(184);i.Scatter=o.Scatter},function(t,e,i){var n=t(408),r=t(153),o=t(9),s=t(18),a=t(24),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i._size,s=i._angle,a=0,l=e;a<l.length;a++){var h=l[a];if(!isNaN(n[h]+r[h]+o[h]+s[h])){var u=o[h]/2;t.beginPath(),t.translate(n[h],r[h]),s[h]&&t.rotate(s[h]),this._render_one(t,h,u,this.visuals.line,this.visuals.fill),s[h]&&t.rotate(-s[h]),t.translate(-n[h],-r[h])}}},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.bbox.h_range,e=t.start-this.max_size,i=t.end+this.max_size,n=this.renderer.xscale.r_invert(e,i),r=n[0],s=n[1],a=this.renderer.plot_view.frame.bbox.v_range,l=a.start-this.max_size,h=a.end+this.max_size,u=this.renderer.yscale.r_invert(l,h),c=u[0],_=u[1],p=o.validate_bbox_coords([r,s],[c,_]);return this.index.indices(p)},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=e-this.max_size,r=e+this.max_size,s=this.renderer.xscale.r_invert(n,r),a=s[0],l=s[1],h=i-this.max_size,u=i+this.max_size,c=this.renderer.yscale.r_invert(h,u),_=c[0],p=c[1],d=o.validate_bbox_coords([a,l],[_,p]),f=this.index.indices(d),v=[],m=0,g=f;m<g.length;m++){var y=g[m],b=this._size[y]/2,x=Math.abs(this.sx[y]-e)+Math.abs(this.sy[y]-i);Math.abs(this.sx[y]-e)<=b&&Math.abs(this.sy[y]-i)<=b&&v.push([y,x])}return o.create_hit_test_result_from_hits(v)},e.prototype._hit_span=function(t){var e,i,n,r,s,a,l=t.sx,h=t.sy,u=this.bounds(),c=u.minX,_=u.minY,p=u.maxX,d=u.maxY,f=o.create_empty_hit_test_result();if("h"==t.direction){s=_,a=d;var v=this.max_size/2,m=l-v,g=l+v;e=this.renderer.xscale.r_invert(m,g),n=e[0],r=e[1]}else{n=c,r=p;var v=this.max_size/2,y=h-v,b=h+v;i=this.renderer.yscale.r_invert(y,b),s=i[0],a=i[1]}var x=o.validate_bbox_coords([n,r],[s,a]),w=this.index.indices(x);return f.indices=w,f},e.prototype._hit_rect=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,r=t.sy1,s=this.renderer.xscale.r_invert(e,i),a=s[0],l=s[1],h=this.renderer.yscale.r_invert(n,r),u=h[0],c=h[1],_=o.validate_bbox_coords([a,l],[u,c]),p=o.create_empty_hit_test_result();return p.indices=this.index.indices(_),p},e.prototype._hit_poly=function(t){for(var e=t.sx,i=t.sy,n=a.range(0,this.sx.length),r=[],s=0,l=n.length;s<l;s++){var h=n[s];o.point_in_poly(this.sx[s],this.sy[s],e,i)&&r.push(h)}var u=o.create_empty_hit_test_result();return u.indices=r,u},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.x1,o=e.y0,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+r)/2;var h=new Array(a);h[i]=(o+s)/2;var u=new Array(a);u[i]=.4*Math.min(Math.abs(r-n),Math.abs(s-o));var c=new Array(a);c[i]=0,this._render(t,[i],{sx:l,sy:h,_size:u,_angle:c})},e}(r.XYGlyphView);i.MarkerView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.mixins(["line","fill"]),this.define({size:[s.DistanceSpec,{units:"screen",value:4}],angle:[s.AngleSpec,0]})},e}(r.XYGlyph);i.Marker=h,h.initClass()},function(t,e,i){var n=t(408),r=t(183),o=t(181),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,s=i._size,a=i._angle,l=i._marker,h=0,u=e;h<u.length;h++){var c=u[h];if(!isNaN(n[c]+r[c]+s[c]+a[c])&&null!=l[c]){var _=s[c]/2;t.beginPath(),t.translate(n[c],r[c]),a[c]&&t.rotate(a[c]),o.marker_funcs[l[c]](t,c,_,this.visuals.line,this.visuals.fill),a[c]&&t.rotate(-a[c]),t.translate(-n[c],-r[c])}}},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.x1,o=e.y0,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+r)/2;var h=new Array(a);h[i]=(o+s)/2;var u=new Array(a);u[i]=.4*Math.min(Math.abs(r-n),Math.abs(s-o));var c=new Array(a);c[i]=0;var _=new Array(a);_[i]=this._marker[i],this._render(t,[i],{sx:l,sy:h,_size:u,_angle:c,_marker:_})},e}(r.MarkerView);i.ScatterView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Scatter",this.prototype.default_view=a,this.define({marker:[s.MarkerSpec,{value:"circle"}]})},e}(r.Marker);i.Scatter=l,l.initClass()},function(t,e,i){var n=t(408),r=t(17),o=t(188),s=t(18),a=t(62),l=t(195),h=t(186);i.GMapPlotView=h.GMapPlotView;var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="MapOptions",this.define({lat:[s.Number],lng:[s.Number],zoom:[s.Number,12]})},e}(a.Model);i.MapOptions=u,u.initClass();var c=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GMapOptions",this.define({map_type:[s.String,"roadmap"],scale_control:[s.Boolean,!1],styles:[s.String],tilt:[s.Int,45]})},e}(u);i.GMapOptions=c,c.initClass();var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GMapPlot",this.prototype.default_view=h.GMapPlotView,this.define({map_options:[s.Instance],api_key:[s.String]}),this.override({x_range:function(){return new l.Range1d},y_range:function(){return new l.Range1d}})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.use_map=!0,this.api_key||r.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")},e}(o.Plot);i.GMapPlot=_,_.initClass()},function(t,e,i){var n=t(408),r=t(22),o=t(36),s=t(189),a=new r.Signal0({},"gmaps_ready"),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this._tiles_loaded=!1,this.zoom_count=0;var i=this.model.map_options,n=i.zoom,r=i.lat,o=i.lng;this.initial_zoom=n,this.initial_lat=r,this.initial_lng=o,this.canvas_view.map_el.style.position="absolute","undefined"!=typeof google&&null!=google.maps||(void 0===window._bokeh_gmaps_callback&&function(t){window._bokeh_gmaps_callback=function(){return a.emit()};var e=document.createElement("script");e.type="text/javascript",e.src="https://maps.googleapis.com/maps/api/js?key="+t+"&callback=_bokeh_gmaps_callback",document.body.appendChild(e)}(this.model.api_key),a.connect(function(){return e.request_render()})),this.unpause()},e.prototype.update_range=function(e){if(null==e)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),t.prototype.update_range.call(this,null);else if(null!=e.sdx||null!=e.sdy)this.map.panBy(e.sdx||0,e.sdy||0),t.prototype.update_range.call(this,e);else if(null!=e.factor){var i=void 0;if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),t.prototype.update_range.call(this,e),i=e.factor<0?-1:1;var n=this.map.getZoom(),r=n+i;if(r>=2){this.map.setZoom(r);var o=this._get_projected_bounds(),s=o[0],a=o[1];a-s<0&&this.map.setZoom(n)}this.unpause()}this._set_bokeh_ranges()},e.prototype._build_map=function(){var t=this,e=google.maps;this.map_types={satellite:e.MapTypeId.SATELLITE,terrain:e.MapTypeId.TERRAIN,roadmap:e.MapTypeId.ROADMAP,hybrid:e.MapTypeId.HYBRID};var i=this.model.map_options,n={center:new e.LatLng(i.lat,i.lng),zoom:i.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[i.map_type],scaleControl:i.scale_control,tilt:i.tilt};null!=i.styles&&(n.styles=JSON.parse(i.styles)),this.map=new e.Map(this.canvas_view.map_el,n),e.event.addListener(this.map,"idle",function(){return t._set_bokeh_ranges()}),e.event.addListener(this.map,"bounds_changed",function(){return t._set_bokeh_ranges()}),e.event.addListenerOnce(this.map,"tilesloaded",function(){return t._render_finished()}),this.connect(this.model.properties.map_options.change,function(){return t._update_options()}),this.connect(this.model.map_options.properties.styles.change,function(){return t._update_styles()}),this.connect(this.model.map_options.properties.lat.change,function(){return t._update_center("lat")}),this.connect(this.model.map_options.properties.lng.change,function(){return t._update_center("lng")}),this.connect(this.model.map_options.properties.zoom.change,function(){return t._update_zoom()}),this.connect(this.model.map_options.properties.map_type.change,function(){return t._update_map_type()}),this.connect(this.model.map_options.properties.scale_control.change,function(){return t._update_scale_control()}),this.connect(this.model.map_options.properties.tilt.change,function(){return t._update_tilt()})},e.prototype._render_finished=function(){this._tiles_loaded=!0,this.notify_finished()},e.prototype.has_finished=function(){return t.prototype.has_finished.call(this)&&!0===this._tiles_loaded},e.prototype._get_latlon_bounds=function(){var t=this.map.getBounds(),e=t.getNorthEast(),i=t.getSouthWest(),n=i.lng(),r=e.lng(),o=i.lat(),s=e.lat();return[n,r,o,s]},e.prototype._get_projected_bounds=function(){var t=this._get_latlon_bounds(),e=t[0],i=t[1],n=t[2],r=t[3],s=o.wgs84_mercator.forward([e,n]),a=s[0],l=s[1],h=o.wgs84_mercator.forward([i,r]),u=h[0],c=h[1];return[a,u,l,c]},e.prototype._set_bokeh_ranges=function(){var t=this._get_projected_bounds(),e=t[0],i=t[1],n=t[2],r=t[3];this.frame.x_range.setv({start:e,end:i}),this.frame.y_range.setv({start:n,end:r})},e.prototype._update_center=function(t){var e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()},e.prototype._update_map_type=function(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})},e.prototype._update_scale_control=function(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})},e.prototype._update_tilt=function(){this.map.setOptions({tilt:this.model.map_options.tilt})},e.prototype._update_options=function(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()},e.prototype._update_styles=function(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})},e.prototype._update_zoom=function(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()},e.prototype._map_hook=function(t,e){var i=e[0],n=e[1],r=e[2],o=e[3];this.canvas_view.map_el.style.top=n+"px",this.canvas_view.map_el.style.left=i+"px",this.canvas_view.map_el.style.width=r+"px",this.canvas_view.map_el.style.height=o+"px",null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map()},e.prototype._paint_empty=function(t,e){var i=this.layout._width.value,n=this.layout._height.value,r=e[0],o=e[1],s=e[2],a=e[3];t.clearRect(0,0,i,n),t.beginPath(),t.moveTo(0,0),t.lineTo(0,n),t.lineTo(i,n),t.lineTo(i,0),t.lineTo(0,0),t.moveTo(r,o),t.lineTo(r+s,o),t.lineTo(r+s,o+a),t.lineTo(r,o+a),t.lineTo(r,o),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())},e}(s.PlotView);i.GMapPlotView=l},function(t,e,i){var n=t(185);i.MapOptions=n.MapOptions;var r=t(185);i.GMapOptions=r.GMapOptions;var o=t(185);i.GMapPlot=o.GMapPlot;var s=t(188);i.Plot=s.Plot},function(t,e,i){var n=t(408),r=t(18),o=t(22),s=t(24),a=t(35),l=t(46),h=t(166),u=t(78),c=t(204),_=t(286),p=t(212),d=t(197),f=t(191),v=t(189);i.PlotView=v.PlotView;var m=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Plot",this.prototype.default_view=v.PlotView,this.mixins(["line:outline_","fill:background_","fill:border_"]),this.define({toolbar:[r.Instance,function(){return new _.Toolbar}],toolbar_location:[r.Location,"right"],toolbar_sticky:[r.Boolean,!0],plot_width:[r.Number,600],plot_height:[r.Number,600],frame_width:[r.Number,null],frame_height:[r.Number,null],title:[r.Any,function(){return new u.Title({text:""})}],title_location:[r.Location,"above"],above:[r.Array,[]],below:[r.Array,[]],left:[r.Array,[]],right:[r.Array,[]],center:[r.Array,[]],renderers:[r.Array,[]],x_range:[r.Instance,function(){return new f.DataRange1d}],extra_x_ranges:[r.Any,{}],y_range:[r.Instance,function(){return new f.DataRange1d}],extra_y_ranges:[r.Any,{}],x_scale:[r.Instance,function(){return new c.LinearScale}],y_scale:[r.Instance,function(){return new c.LinearScale}],lod_factor:[r.Number,10],lod_interval:[r.Number,300],lod_threshold:[r.Number,2e3],lod_timeout:[r.Number,500],hidpi:[r.Boolean,!0],output_backend:[r.OutputBackend,"canvas"],min_border:[r.Number,5],min_border_top:[r.Number,null],min_border_left:[r.Number,null],min_border_bottom:[r.Number,null],min_border_right:[r.Number,null],inner_width:[r.Number],inner_height:[r.Number],outer_width:[r.Number],outer_height:[r.Number],match_aspect:[r.Boolean,!1],aspect_scale:[r.Number,1],reset_policy:[r.ResetPolicy,"standard"]}),this.override({outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},Object.defineProperty(e.prototype,"width",{get:function(){var t=this.getv("width");return null!=t?t:this.plot_width},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"height",{get:function(){var t=this.getv("height");return null!=t?t:this.plot_height},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.reset=new o.Signal0(this,"reset");for(var e=0,i=a.values(this.extra_x_ranges).concat(this.x_range);e<i.length;e++){var n=i[e],r=n.plots;l.isArray(r)&&(r=r.concat(this),n.setv({plots:r},{silent:!0}))}for(var s=0,h=a.values(this.extra_y_ranges).concat(this.y_range);s<h.length;s++){var u=h[s],r=u.plots;l.isArray(r)&&(r=r.concat(this),u.setv({plots:r},{silent:!0}))}},e.prototype.add_layout=function(t,e){void 0===e&&(e="center");var i=this.getv(e);i.push(t)},e.prototype.remove_layout=function(t){var e=function(e){s.remove_by(e,function(e){return e==t})};e(this.left),e(this.right),e(this.above),e(this.below),e(this.center)},e.prototype.add_renderers=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.renderers=this.renderers.concat(t)},e.prototype.add_glyph=function(t,e,i){void 0===e&&(e=new p.ColumnDataSource),void 0===i&&(i={});var r=n.__assign({},i,{data_source:e,glyph:t}),o=new d.GlyphRenderer(r);return this.add_renderers(o),o},e.prototype.add_tools=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.toolbar.tools=this.toolbar.tools.concat(t)},Object.defineProperty(e.prototype,"panels",{get:function(){return this.side_panels.concat(this.center)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"side_panels",{get:function(){var t=this.above,e=this.below,i=this.left,n=this.right;return s.concat([t,e,i,n])},enumerable:!0,configurable:!0}),e}(h.LayoutDOM);i.Plot=m,m.initClass()},function(t,e,i){var n=t(408),r=t(95),o=t(94),s=t(191),a=t(197),l=t(166),h=t(78),u=t(82),c=t(79),_=t(3),p=t(22),d=t(4),f=t(51),v=t(17),m=t(44),g=t(46),y=t(24),b=t(35),x=t(13),w=t(10),k=t(15),T=t(11),C=t(27),S=null,A=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.min_border={left:0,top:0,right:0,bottom:0},e}return n.__extends(e,t),e.prototype._measure=function(t){var e=this;t=new x.Sizeable(t).bounded_to(this.sizing.size);var i,n,r,o=this.left_panel.measure({width:0,height:t.height}),s=Math.max(o.width,this.min_border.left),a=this.right_panel.measure({width:0,height:t.height}),l=Math.max(a.width,this.min_border.right),h=this.top_panel.measure({width:t.width,height:0}),u=Math.max(h.height,this.min_border.top),c=this.bottom_panel.measure({width:t.width,height:0}),_=Math.max(c.height,this.min_border.bottom),p=new x.Sizeable(t).shrink_by({left:s,right:l,top:u,bottom:_}),d=this.center_panel.measure(p),f=s+d.width+l,v=u+d.height+_,m=(i=e.center_panel.sizing,n=i.width_policy,r=i.height_policy,"fixed"!=n&&"fixed"!=r);return{width:f,height:v,inner:{left:s,right:l,top:u,bottom:_},align:m}},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i),this.center_panel.set_geometry(i);var n=this.left_panel.measure({width:0,height:e.height}),r=this.right_panel.measure({width:0,height:e.height}),o=this.top_panel.measure({width:e.width,height:0}),s=this.bottom_panel.measure({width:e.width,height:0}),a=i.left,l=i.top,h=i.right,u=i.bottom;this.top_panel.set_geometry(new C.BBox({left:a,right:h,bottom:l,height:o.height})),this.bottom_panel.set_geometry(new C.BBox({left:a,right:h,top:u,height:s.height})),this.left_panel.set_geometry(new C.BBox({top:l,bottom:u,right:a,width:n.width})),this.right_panel.set_geometry(new C.BBox({top:l,bottom:u,left:h,width:r.width}))},e}(x.Layoutable);i.PlotLayout=A;var M=function(e){function i(){var t=null!==e&&e.apply(this,arguments)||this;return t._outer_bbox=new C.BBox,t._inner_bbox=new C.BBox,t._needs_paint=!0,t._needs_layout=!1,t}return n.__extends(i,e),Object.defineProperty(i.prototype,"canvas_overlays",{get:function(){return this.canvas_view.overlays_el},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"canvas_events",{get:function(){return this.canvas_view.events_el},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"is_paused",{get:function(){return null!=this._is_paused&&0!==this._is_paused},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),i.prototype.pause=function(){null==this._is_paused?this._is_paused=1:this._is_paused+=1},i.prototype.unpause=function(t){if(void 0===t&&(t=!1),null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_paint()},i.prototype.request_render=function(){this.request_paint()},i.prototype.request_paint=function(){this.is_paused||this.throttled_paint()},i.prototype.request_layout=function(){this._needs_layout=!0,this.request_paint()},i.prototype.reset=function(){"standard"==this.model.reset_policy&&(this.clear_state(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new _.Reset)},i.prototype.remove=function(){this.ui_event_bus.destroy(),d.remove_views(this.renderer_views),d.remove_views(this.tool_views),this.canvas_view.remove(),e.prototype.remove.call(this)},i.prototype.render=function(){e.prototype.render.call(this),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()},i.prototype.initialize=function(){var i=this;this.pause(),e.prototype.initialize.call(this),this.force_paint=new p.Signal0(this,"force_paint"),this.state_changed=new p.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new f.Visuals(this.model),this._initial_state_info={selection:{},dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.state={history:[],index:-1},this.canvas=new o.Canvas({map:this.model.use_map||!1,use_hidpi:this.model.hidpi,output_backend:this.model.output_backend}),this.frame=new r.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this.canvas_view=new this.canvas.default_view({model:this.canvas,parent:this}),"webgl"==this.model.output_backend&&this.init_webgl(),this.throttled_paint=m.throttle(function(){return i.force_paint.emit()},15);var n=t(23).UIEvents;this.ui_event_bus=new n(this,this.model.toolbar,this.canvas_view.events_el);var s=this.model,a=s.title_location,l=s.title;null!=a&&null!=l&&(this._title=l instanceof h.Title?l:new h.Title({text:l}));var u=this.model,_=u.toolbar_location,d=u.toolbar;null!=_&&null!=d&&(this._toolbar=new c.ToolbarPanel({toolbar:d}),d.toolbar_location=_),this.renderer_views={},this.tool_views={},this.build_renderer_views(),this.build_tool_views(),this.update_dataranges(),this.unpause(!0),v.logger.debug("PlotView initialized")},i.prototype._width_policy=function(){return null==this.model.frame_width?e.prototype._width_policy.call(this):"min"},i.prototype._height_policy=function(){return null==this.model.frame_height?e.prototype._height_policy.call(this):"min"},i.prototype._update_layout=function(){var t=this;this.layout=new A,this.layout.set_sizing(this.box_sizing());var e=this.model,i=e.frame_width,r=e.frame_height;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(n.__assign({},null!=i?{width_policy:"fixed",width:i}:{width_policy:"fit"},null!=r?{height_policy:"fixed",height:r}:{height_policy:"fit"}));var o=y.copy(this.model.above),s=y.copy(this.model.below),a=y.copy(this.model.left),l=y.copy(this.model.right),u=function(t){switch(t){case"above":return o;case"below":return s;case"left":return a;case"right":return l}},_=this.model,p=_.title_location,d=_.title;null!=p&&null!=d&&u(p).push(this._title);var f=this.model,v=f.toolbar_location,m=f.toolbar;if(null!=v&&null!=m){var b=u(v),x=!0;if(this.model.toolbar_sticky)for(var C=0;C<b.length;C++){var S=b[C];if(S instanceof h.Title){b[C]="above"==v||"below"==v?[S,this._toolbar]:[this._toolbar,S],x=!1;break}}x&&b.push(this._toolbar)}var M=function(e,i){var n=t.renderer_views[i.id];return n.layout=new k.SidePanel(e,n)},E=function(t,e){for(var i="above"==t||"below"==t,r=[],o=0,s=e;o<s.length;o++){var a=s[o];if(g.isArray(a)){var l=a.map(function(e){var r,o=M(t,e);if(e instanceof c.ToolbarPanel){var s=i?"width_policy":"height_policy";o.set_sizing(n.__assign({},o.sizing,((r={})[s]="min",r)))}return o}),h=void 0;i?(h=new T.Row(l)).set_sizing({width_policy:"max",height_policy:"min"}):(h=new T.Column(l)).set_sizing({width_policy:"min",height_policy:"max"}),h.absolute=!0,r.push(h)}else r.push(M(t,a))}return r},z=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:z,top:null!=this.model.min_border_top?this.model.min_border_top:z,right:null!=this.model.min_border_right?this.model.min_border_right:z,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:z};var O=new w.VStack,P=new w.VStack,j=new w.HStack,N=new w.HStack;O.children=y.reversed(E("above",o)),P.children=E("below",s),j.children=y.reversed(E("left",a)),N.children=E("right",l),O.set_sizing({width_policy:"fit",height_policy:"min"}),P.set_sizing({width_policy:"fit",height_policy:"min"}),j.set_sizing({width_policy:"min",height_policy:"fit"}),N.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=O,this.layout.bottom_panel=P,this.layout.left_panel=j,this.layout.right_panel=N},Object.defineProperty(i.prototype,"axis_views",{get:function(){var t=[];for(var e in this.renderer_views){var i=this.renderer_views[e];i instanceof u.AxisView&&t.push(i)}return t},enumerable:!0,configurable:!0}),i.prototype.set_cursor=function(t){void 0===t&&(t="default"),this.canvas_view.el.style.cursor=t},i.prototype.set_toolbar_visibility=function(t){for(var e=0,i=this.visibility_callbacks;e<i.length;e++){var n=i[e];n(t)}},i.prototype.init_webgl=function(){if(null==S){var t=document.createElement("canvas"),e={premultipliedAlpha:!0},i=t.getContext("webgl",e)||t.getContext("experimental-webgl",e);null!=i&&(S={canvas:t,ctx:i})}null!=S?this.gl=S:v.logger.warn("WebGL is not supported, falling back to 2D canvas.")},i.prototype.prepare_webgl=function(t,e){if(null!=this.gl){var i=this.canvas_view.get_canvas_element();this.gl.canvas.width=i.width,this.gl.canvas.height=i.height;var n=this.gl.ctx;n.enable(n.SCISSOR_TEST);var r=e[0],o=e[1],s=e[2],a=e[3],l=this.canvas_view.bbox,h=l.xview,u=l.yview,c=h.compute(r),_=u.compute(o+a);n.scissor(t*c,t*_,t*s,t*a),n.enable(n.BLEND),n.blendFuncSeparate(n.SRC_ALPHA,n.ONE_MINUS_SRC_ALPHA,n.ONE_MINUS_DST_ALPHA,n.ONE)}},i.prototype.clear_webgl=function(){if(null!=this.gl){var t=this.gl.ctx;t.viewport(0,0,this.gl.canvas.width,this.gl.canvas.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT||t.DEPTH_BUFFER_BIT)}},i.prototype.blit_webgl=function(){var t=this.canvas_view.ctx;if(null!=this.gl){v.logger.debug("drawing with WebGL"),t.restore(),t.drawImage(this.gl.canvas,0,0),t.save();var e=this.canvas.pixel_ratio;t.scale(e,e),t.translate(.5,.5)}},i.prototype.update_dataranges=function(){for(var t={},e={},i=!1,n=0,r=b.values(this.frame.x_ranges).concat(b.values(this.frame.y_ranges));n<r.length;n++){var o=r[n];o instanceof s.DataRange1d&&"log"==o.scale_hint&&(i=!0)}for(var l in this.renderer_views){var h=this.renderer_views[l];if(h instanceof a.GlyphRendererView){var u=h.glyph.bounds();if(null!=u&&(t[l]=u),i){var c=h.glyph.log_bounds();null!=c&&(e[l]=c)}}}var _,p=!1,d=!1,f=this.frame.bbox,m=f.width,g=f.height;!1!==this.model.match_aspect&&0!=m&&0!=g&&(_=1/this.model.aspect_scale*(m/g));for(var y=0,x=b.values(this.frame.x_ranges);y<x.length;y++){var w=x[y];if(w instanceof s.DataRange1d){var k="log"==w.scale_hint?e:t;w.update(k,0,this.model.id,_),w.follow&&(p=!0)}null!=w.bounds&&(d=!0)}for(var T=0,C=b.values(this.frame.y_ranges);T<C.length;T++){var S=C[T];if(S instanceof s.DataRange1d){var k="log"==S.scale_hint?e:t;S.update(k,1,this.model.id,_),S.follow&&(p=!0)}null!=S.bounds&&(d=!0)}if(p&&d){v.logger.warn("Follow enabled so bounds are unset.");for(var A=0,M=b.values(this.frame.x_ranges);A<M.length;A++){var w=M[A];w.bounds=null}for(var E=0,z=b.values(this.frame.y_ranges);E<z.length;E++){var S=z[E];S.bounds=null}}this.range_update_timestamp=Date.now()},i.prototype.map_to_screen=function(t,e,i,n){return void 0===i&&(i="default"),void 0===n&&(n="default"),this.frame.map_to_screen(t,e,i,n)},i.prototype.push_state=function(t,e){var i=this.state,r=i.history,o=i.index,s=null!=r[o]?r[o].info:{},a=n.__assign({},this._initial_state_info,s,e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:a}),this.state.index=this.state.history.length-1,this.state_changed.emit()},i.prototype.clear_state=function(){this.state={history:[],index:-1},this.state_changed.emit()},i.prototype.can_undo=function(){return this.state.index>=0},i.prototype.can_redo=function(){return this.state.index<this.state.history.length-1},i.prototype.undo=function(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())},i.prototype.redo=function(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())},i.prototype._do_state_change=function(t){var e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)},i.prototype.get_selection=function(){for(var t={},e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];if(n instanceof a.GlyphRenderer){var r=n.data_source.selected;t[n.id]=r}}return t},i.prototype.update_selection=function(t){for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];if(n instanceof a.GlyphRenderer){var r=n.data_source;null!=t?null!=t[n.id]&&r.selected.update(t[n.id],!0,!1):r.selection_manager.clear()}}},i.prototype.reset_selection=function(){this.update_selection(null)},i.prototype._update_ranges_together=function(t){for(var e=1,i=0,n=t;i<n.length;i++){var r=n[i],o=r[0],s=r[1];e=Math.min(e,this._get_weight_to_constrain_interval(o,s))}if(e<1)for(var a=0,l=t;a<l.length;a++){var h=l[a],o=h[0],s=h[1];s.start=e*s.start+(1-e)*o.start,s.end=e*s.end+(1-e)*o.end}},i.prototype._update_ranges_individually=function(t,e,i,n){for(var r=!1,o=0,s=t;o<s.length;o++){var a=s[o],l=a[0],h=a[1];if(!i){var u=this._get_weight_to_constrain_interval(l,h);u<1&&(h.start=u*h.start+(1-u)*l.start,h.end=u*h.end+(1-u)*l.end)}if(null!=l.bounds&&"auto"!=l.bounds){var c=l.bounds,_=c[0],p=c[1],d=Math.abs(h.end-h.start);l.is_reversed?(null!=_&&_>=h.end&&(r=!0,h.end=_,(e||i)&&(h.start=_+d)),null!=p&&p<=h.start&&(r=!0,h.start=p,(e||i)&&(h.end=p-d))):(null!=_&&_>=h.start&&(r=!0,h.start=_,(e||i)&&(h.end=_+d)),null!=p&&p<=h.end&&(r=!0,h.end=p,(e||i)&&(h.start=p-d)))}}if(!(i&&r&&n))for(var f=0,v=t;f<v.length;f++){var m=v[f],l=m[0],h=m[1];l.have_updated_interactively=!0,l.start==h.start&&l.end==h.end||l.setv(h)}},i.prototype._get_weight_to_constrain_interval=function(t,e){var i=t.min_interval,n=t.max_interval;if(null!=t.bounds&&"auto"!=t.bounds){var r=t.bounds,o=r[0],s=r[1];if(null!=o&&null!=s){var a=Math.abs(s-o);n=null!=n?Math.min(n,a):a}}var l=1;if(null!=i||null!=n){var h=Math.abs(t.end-t.start),u=Math.abs(e.end-e.start);i>0&&u<i&&(l=(h-i)/(h-u)),n>0&&u>n&&(l=(n-h)/(u-h)),l=Math.max(0,Math.min(1,l))}return l},i.prototype.update_range=function(t,e,i,n){void 0===e&&(e=!1),void 0===i&&(i=!1),void 0===n&&(n=!0),this.pause();var r=this.frame,o=r.x_ranges,s=r.y_ranges;if(null==t){for(var a in o){var l=o[a];l.reset()}for(var h in s){var l=s[h];l.reset()}this.update_dataranges()}else{var u=[];for(var c in o){var l=o[c];u.push([l,t.xrs[c]])}for(var _ in s){var l=s[_];u.push([l,t.yrs[_]])}i&&this._update_ranges_together(u),this._update_ranges_individually(u,e,i,n)}this.unpause()},i.prototype.reset_range=function(){this.update_range(null)},i.prototype._invalidate_layout=function(){var t=this;(function(){for(var e=0,i=t.model.side_panels;e<i.length;e++){var n=i[e],r=t.renderer_views[n.id];if(r.layout.has_size_changed())return!0}return!1})()&&this.root.compute_layout()},i.prototype.build_renderer_views=function(){var t,e,i,n,r,o,s;this.computed_renderers=[],(t=this.computed_renderers).push.apply(t,this.model.above),(e=this.computed_renderers).push.apply(e,this.model.below),(i=this.computed_renderers).push.apply(i,this.model.left),(n=this.computed_renderers).push.apply(n,this.model.right),(r=this.computed_renderers).push.apply(r,this.model.center),(o=this.computed_renderers).push.apply(o,this.model.renderers),null!=this._title&&this.computed_renderers.push(this._title),null!=this._toolbar&&this.computed_renderers.push(this._toolbar);for(var a=0,l=this.model.toolbar.tools;a<l.length;a++){var h=l[a];null!=h.overlay&&this.computed_renderers.push(h.overlay),(s=this.computed_renderers).push.apply(s,h.synthetic_renderers)}d.build_views(this.renderer_views,this.computed_renderers,{parent:this})},i.prototype.get_renderer_views=function(){var t=this;return this.computed_renderers.map(function(e){return t.renderer_views[e.id]})},i.prototype.build_tool_views=function(){var t=this,e=this.model.toolbar.tools,i=d.build_views(this.tool_views,e,{parent:this});i.map(function(e){return t.ui_event_bus.register_tool(e)})},i.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.force_paint,function(){return t.repaint()});var i=this.frame,n=i.x_ranges,r=i.y_ranges;for(var o in n){var s=n[o];this.connect(s.change,function(){t._needs_layout=!0,t.request_paint()})}for(var a in r){var s=r[a];this.connect(s.change,function(){t._needs_layout=!0,t.request_paint()})}this.connect(this.model.properties.renderers.change,function(){return t.build_renderer_views()}),this.connect(this.model.toolbar.properties.tools.change,function(){t.build_renderer_views(),t.build_tool_views()}),this.connect(this.model.change,function(){return t.request_paint()}),this.connect(this.model.reset,function(){return t.reset()})},i.prototype.set_initial_range=function(){var t=!0,e=this.frame,i=e.x_ranges,n=e.y_ranges,r={},o={};for(var s in i){var a=i[s],l=a.start,h=a.end;if(null==l||null==h||g.isStrictNaN(l+h)){t=!1;break}r[s]={start:l,end:h}}if(t)for(var u in n){var c=n[u],l=c.start,h=c.end;if(null==l||null==h||g.isStrictNaN(l+h)){t=!1;break}o[u]={start:l,end:h}}t?(this._initial_state_info.range={xrs:r,yrs:o},v.logger.debug("initial ranges set")):v.logger.warn("could not set initial ranges")},i.prototype.has_finished=function(){if(!e.prototype.has_finished.call(this))return!1;for(var t in this.renderer_views){var i=this.renderer_views[t];if(!i.has_finished())return!1}return!0},i.prototype.after_layout=function(){if(e.prototype.after_layout.call(this),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame._width.value),inner_height:Math.round(this.frame._height.value),outer_width:Math.round(this.layout._width.value),outer_height:Math.round(this.layout._height.value)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){var t=this.layout.bbox,i=t.width,n=t.height;this.canvas_view.prepare_canvas(i,n),this._outer_bbox=this.layout.bbox,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&(this._needs_paint=!1,this.paint())},i.prototype.repaint=function(){this._needs_layout&&this._invalidate_layout(),this.paint()},i.prototype.paint=function(){var t=this;if(!this.is_paused){v.logger.trace("PlotView.paint() for "+this.model.id);var e=this.model.document;if(null!=e){var i=e.interactive_duration();i>=0&&i<this.model.lod_interval?setTimeout(function(){e.interactive_duration()>t.model.lod_timeout&&e.interactive_stop(t.model),t.request_paint()},this.model.lod_timeout):e.interactive_stop(this.model)}for(var n in this.renderer_views){var r=this.renderer_views[n];if(null==this.range_update_timestamp||r instanceof a.GlyphRendererView&&r.set_data_timestamp>this.range_update_timestamp){this.update_dataranges();break}}var o=this.canvas_view.ctx,s=this.canvas.pixel_ratio;o.save(),o.scale(s,s),o.translate(.5,.5);var l=[this.frame._left.value,this.frame._top.value,this.frame._width.value,this.frame._height.value];if(this._map_hook(o,l),this._paint_empty(o,l),this.prepare_webgl(s,l),this.clear_webgl(),this.visuals.outline_line.doit){o.save(),this.visuals.outline_line.set_value(o);var h=l[0],u=l[1],c=l[2],_=l[3];h+c==this.layout._width.value&&(c-=1),u+_==this.layout._height.value&&(_-=1),o.strokeRect(h,u,c,_),o.restore()}this._paint_levels(o,["image","underlay","glyph"],l,!0),this._paint_levels(o,["annotation"],l,!1),this._paint_levels(o,["overlay"],l,!1),null==this._initial_state_info.range&&this.set_initial_range(),o.restore()}},i.prototype._paint_levels=function(t,e,i,n){for(var r=0,o=e;r<o.length;r++)for(var s=o[r],a=0,l=this.computed_renderers;a<l.length;a++){var h=l[a];if(h.level==s){var u=this.renderer_views[h.id];t.save(),(n||u.needs_clip)&&(t.beginPath(),t.rect.apply(t,i),t.clip()),u.render(),t.restore(),u.has_webgl&&(this.blit_webgl(),this.clear_webgl())}}},i.prototype._map_hook=function(t,e){},i.prototype._paint_empty=function(t,e){var i=[0,0,this.layout._width.value,this.layout._height.value],n=i[0],r=i[1],o=i[2],s=i[3],a=e[0],l=e[1],h=e[2],u=e[3];t.clearRect(n,r,o,s),this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(n,r,o,s),t.clearRect(a,l,h,u)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(a,l,h,u))},i.prototype.save=function(t){switch(this.model.output_backend){case"canvas":case"webgl":var e=this.canvas_view.get_canvas_element();if(null!=e.msToBlob){var i=e.msToBlob();window.navigator.msSaveBlob(i,t)}else{var n=document.createElement("a");n.href=e.toDataURL("image/png"),n.download=t+".png",n.target="_blank",n.dispatchEvent(new MouseEvent("click"))}break;case"svg":var r=this.canvas_view._ctx,o=r.getSerializedSvg(!0),s=new Blob([o],{type:"text/plain"}),a=document.createElement("a");a.download=t+".svg",a.innerHTML="Download svg",a.href=window.URL.createObjectURL(s),a.onclick=function(t){return document.body.removeChild(t.target)},a.style.display="none",document.body.appendChild(a),a.click()}},i.prototype.serializable_state=function(){var t=e.prototype.serializable_state.call(this),i=t.children,r=n.__rest(t,["children"]),o=this.get_renderer_views().map(function(t){return t.serializable_state()}).filter(function(t){return"bbox"in t});return n.__assign({},r,{children:i.concat(o)})},i}(l.LayoutDOMView);i.PlotView=M},function(t,e,i){var n=t(408),r=t(194),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="DataRange",this.define({names:[o.Array,[]],renderers:[o.Array,[]]})},e}(r.Range);i.DataRange=s,s.initClass()},function(t,e,i){var n=t(408),r=t(190),o=t(197),s=t(17),a=t(18),l=t(27),h=t(24),u=function(t){function e(e){var i=t.call(this,e)||this;return i._plot_bounds={},i.have_updated_interactively=!1,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="DataRange1d",this.define({start:[a.Number],end:[a.Number],range_padding:[a.Number,.1],range_padding_units:[a.PaddingUnits,"percent"],flipped:[a.Boolean,!1],follow:[a.StartEnd],follow_interval:[a.Number],default_span:[a.Number,2]}),this.internal({scale_hint:[a.String,"auto"]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),e.prototype.computed_renderers=function(){var t=this.names,e=this.renderers;if(0==e.length)for(var i=0,n=this.plots;i<n.length;i++){var r=n[i],a=r.renderers.filter(function(t){return t instanceof o.GlyphRenderer});e=e.concat(a)}t.length>0&&(e=e.filter(function(e){return h.includes(t,e.name)})),s.logger.debug("computed "+e.length+" renderers for DataRange1d "+this.id);for(var l=0,u=e;l<u.length;l++){var c=u[l];s.logger.trace(" - "+c.type+" "+c.id)}return e},e.prototype._compute_plot_bounds=function(t,e){for(var i=l.empty(),n=0,r=t;n<r.length;n++){var o=r[n];null!=e[o.id]&&(i=l.union(i,e[o.id]))}return i},e.prototype.adjust_bounds_for_aspect=function(t,e){var i=l.empty(),n=t.maxX-t.minX;n<=0&&(n=1);var r=t.maxY-t.minY;r<=0&&(r=1);var o=.5*(t.maxX+t.minX),s=.5*(t.maxY+t.minY);return n<e*r?n=e*r:r=n/e,i.maxX=o+.5*n,i.minX=o-.5*n,i.maxY=s+.5*r,i.minY=s-.5*r,i},e.prototype._compute_min_max=function(t,e){var i,n,r,o,s=l.empty();for(var a in t){var h=t[a];s=l.union(s,h)}return 0==e?(i=[s.minX,s.maxX],r=i[0],o=i[1]):(n=[s.minY,s.maxY],r=n[0],o=n[1]),[r,o]},e.prototype._compute_range=function(t,e){var i,n,r,o=this.range_padding;if("log"==this.scale_hint){(isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(e)||!isFinite(e)||e<=0?.1:e/100,s.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(e)||!isFinite(e)||e<=0)&&(e=isNaN(t)||!isFinite(t)||t<=0?10:100*t,s.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+e));var a=void 0,l=void 0;if(e==t)l=this.default_span+.001,a=Math.log(t)/Math.log(10);else{var h=void 0,u=void 0;"percent"==this.range_padding_units?(h=Math.log(t)/Math.log(10),u=Math.log(e)/Math.log(10),l=(u-h)*(1+o)):(h=Math.log(t-o)/Math.log(10),u=Math.log(e+o)/Math.log(10),l=u-h),a=(h+u)/2}n=Math.pow(10,a-l/2),r=Math.pow(10,a+l/2)}else{var l=void 0;l=e==t?this.default_span:"percent"==this.range_padding_units?(e-t)*(1+o):e-t+2*o;var a=(e+t)/2;n=a-l/2,r=a+l/2}var c=1;this.flipped&&(n=(i=[r,n])[0],r=i[1],c=-1);var _=this.follow_interval;return null!=_&&Math.abs(n-r)>_&&("start"==this.follow?r=n+c*_:"end"==this.follow&&(n=r-c*_)),[n,r]},e.prototype.update=function(t,e,i,n){if(!this.have_updated_interactively){var r=this.computed_renderers(),o=this._compute_plot_bounds(r,t);null!=n&&(o=this.adjust_bounds_for_aspect(o,n)),this._plot_bounds[i]=o;var s=this._compute_min_max(this._plot_bounds,e),a=s[0],l=s[1],h=this._compute_range(a,l),u=h[0],c=h[1];null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(u=this._initial_start):u=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(c=this._initial_end):c=this._initial_end);var _=[this.start,this.end],p=_[0],d=_[1];if(u!=p||c!=d){var f={};u!=p&&(f.start=u),c!=d&&(f.end=c),this.setv(f)}"auto"==this.bounds&&this.setv({bounds:[u,c]},{silent:!0}),this.change.emit()}},e.prototype.reset=function(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()},e}(r.DataRange);i.DataRange1d=u,u.initClass()},function(t,e,i){var n=t(408),r=t(194),o=t(18),s=t(25),a=t(24),l=t(46);function h(t,e,i){void 0===i&&(i=0);for(var n={},r=0;r<t.length;r++){var o=t[r];if(o in n)throw new Error("duplicate factor or subfactor: "+o);n[o]={value:.5+r*(1+e)+i}}return[n,(t.length-1)*e]}function u(t,e,i,n){void 0===n&&(n=0);for(var r={},o={},s=[],l=0,u=t;l<u.length;l++){var c=u[l],_=c[0],p=c[1];_ in o||(o[_]=[],s.push(_)),o[_].push(p)}for(var d=n,f=0,v=function(t){var n=o[t].length,s=h(o[t],i,d),l=s[0],u=s[1];f+=u;var c=a.sum(o[t].map(function(t){return l[t].value}));r[t]={value:c/n,mapping:l},d+=n+e+u},m=0,g=s;m<g.length;m++){var _=g[m];v(_)}return[r,s,(s.length-1)*e+f]}function c(t,e,i,n,r){void 0===r&&(r=0);for(var o={},s={},l=[],h=0,c=t;h<c.length;h++){var _=c[h],p=_[0],d=_[1],f=_[2];p in s||(s[p]=[],l.push(p)),s[p].push([d,f])}for(var v=[],m=r,g=0,y=function(t){for(var r=s[t].length,l=u(s[t],i,n,m),h=l[0],c=l[1],_=l[2],p=0,d=c;p<d.length;p++){var f=d[p];v.push([t,f])}g+=_;var y=a.sum(s[t].map(function(t){var e=t[0];return h[e].value}));o[t]={value:y/r,mapping:h},m+=r+e+_},b=0,x=l;b<x.length;b++){var p=x[b];y(p)}return[o,l,v,(l.length-1)*e+g]}i.map_one_level=h,i.map_two_levels=u,i.map_three_levels=c;var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="FactorRange",this.define({factors:[o.Array,[]],factor_padding:[o.Number,0],subgroup_padding:[o.Number,.8],group_padding:[o.Number,1.4],range_padding:[o.Number,0],range_padding_units:[o.PaddingUnits,"percent"],start:[o.Number],end:[o.Number]}),this.internal({levels:[o.Number],mids:[o.Array],tops:[o.Array],tops_groups:[o.Array]})},Object.defineProperty(e.prototype,"min",{get:function(){return this.start},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return this.end},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init(!0)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.factors.change,function(){return e.reset()}),this.connect(this.properties.factor_padding.change,function(){return e.reset()}),this.connect(this.properties.group_padding.change,function(){return e.reset()}),this.connect(this.properties.subgroup_padding.change,function(){return e.reset()}),this.connect(this.properties.range_padding.change,function(){return e.reset()}),this.connect(this.properties.range_padding_units.change,function(){return e.reset()})},e.prototype.reset=function(){this._init(!1),this.change.emit()},e.prototype._lookup=function(t){if(1==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])?e[t[0]].value:NaN}if(2==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])&&e[t[0]].mapping.hasOwnProperty(t[1])?e[t[0]].mapping[t[1]].value:NaN}if(3==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])&&e[t[0]].mapping.hasOwnProperty(t[1])&&e[t[0]].mapping[t[1]].mapping.hasOwnProperty(t[2])?e[t[0]].mapping[t[1]].mapping[t[2]].value:NaN}throw new Error("unreachable code")},e.prototype.synthetic=function(t){if(l.isNumber(t))return t;if(l.isString(t))return this._lookup([t]);var e=0,i=t[t.length-1];return l.isNumber(i)&&(e=i,t=t.slice(0,-1)),this._lookup(t)+e},e.prototype.v_synthetic=function(t){var e=this;return s.map(t,function(t){return e.synthetic(t)})},e.prototype._init=function(t){var e,i,n,r,o;if(a.every(this.factors,l.isString))r=1,e=h(this.factors,this.factor_padding),this._mapping=e[0],o=e[1];else if(a.every(this.factors,function(t){return l.isArray(t)&&2==t.length&&l.isString(t[0])&&l.isString(t[1])}))r=2,i=u(this.factors,this.group_padding,this.factor_padding),this._mapping=i[0],this.tops=i[1],o=i[2];else{if(!a.every(this.factors,function(t){return l.isArray(t)&&3==t.length&&l.isString(t[0])&&l.isString(t[1])&&l.isString(t[2])}))throw new Error("???");r=3,n=c(this.factors,this.group_padding,this.subgroup_padding,this.factor_padding),this._mapping=n[0],this.tops=n[1],this.mids=n[2],o=n[3]}var s=0,_=this.factors.length+o;if("percent"==this.range_padding_units){var p=(_-s)*this.range_padding/2;s-=p,_+=p}else s-=this.range_padding,_+=this.range_padding;this.setv({start:s,end:_,levels:r},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[s,_]},{silent:!0})},e}(r.Range);i.FactorRange=_,_.initClass()},function(t,e,i){var n=t(190);i.DataRange=n.DataRange;var r=t(191);i.DataRange1d=r.DataRange1d;var o=t(192);i.FactorRange=o.FactorRange;var s=t(194);i.Range=s.Range;var a=t(195);i.Range1d=a.Range1d},function(t,e,i){var n=t(408),r=t(62),o=t(18),s=t(46),a=function(t){function e(e){var i=t.call(this,e)||this;return i.have_updated_interactively=!1,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Range",this.define({callback:[o.Any],bounds:[o.Any],min_interval:[o.Any],max_interval:[o.Any]}),this.internal({plots:[o.Array,[]]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,function(){return e._emit_callback()})},e.prototype._emit_callback=function(){null!=this.callback&&(s.isFunction(this.callback)?this.callback(this):this.callback.execute(this,{}))},Object.defineProperty(e.prototype,"is_reversed",{get:function(){return this.start>this.end},enumerable:!0,configurable:!0}),e}(r.Model);i.Range=a,a.initClass()},function(t,e,i){var n=t(408),r=t(194),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Range1d",this.define({start:[o.Number,0],end:[o.Number,1],reset_start:[o.Number],reset_end:[o.Number]})},e.prototype._set_auto_bounds=function(){if("auto"==this.bounds){var t=Math.min(this.reset_start,this.reset_end),e=Math.max(this.reset_start,this.reset_end);this.setv({bounds:[t,e]},{silent:!0})}},e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.reset_start&&(this.reset_start=this.start),null==this.reset_end&&(this.reset_end=this.end),this._set_auto_bounds()},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),e.prototype.reset=function(){this._set_auto_bounds(),this.start!=this.reset_start||this.end!=this.reset_end?this.setv({start:this.reset_start,end:this.reset_end}):this.change.emit()},e}(r.Range);i.Range1d=s,s.initClass()},function(t,e,i){var n=t(408),r=t(201),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.RendererView);i.DataRendererView=s;var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="DataRenderer",this.define({x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({level:"glyph"})},e}(r.Renderer);i.DataRenderer=a,a.initClass()},function(t,e,i){var n=t(408),r=t(196),o=t(136),s=t(211),a=t(17),l=t(18),h=t(25),u=t(24),c=t(35),_=t(192),p={fill:{},line:{}},d={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},f={fill:{fill_alpha:.2},line:{}},v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=this.model.glyph,i=u.includes(e.mixins,"fill"),n=u.includes(e.mixins,"line"),r=c.clone(e.attributes);function o(t){var o=c.clone(r);return i&&c.extend(o,t.fill),n&&c.extend(o,t.line),new e.constructor(o)}delete r.id,this.glyph=this.build_glyph_view(e);var s=this.model.selection_glyph;null==s?s=o({fill:{},line:{}}):"auto"===s&&(s=o(p)),this.selection_glyph=this.build_glyph_view(s);var a=this.model.nonselection_glyph;null==a?a=o({fill:{},line:{}}):"auto"===a&&(a=o(f)),this.nonselection_glyph=this.build_glyph_view(a);var l=this.model.hover_glyph;null!=l&&(this.hover_glyph=this.build_glyph_view(l));var h=this.model.muted_glyph;null!=h&&(this.muted_glyph=this.build_glyph_view(h));var _=o(d);this.decimated_glyph=this.build_glyph_view(_),this.xscale=this.plot_view.frame.xscales[this.model.x_range_name],this.yscale=this.plot_view.frame.yscales[this.model.y_range_name],this.set_data(!1)},e.prototype.build_glyph_view=function(t){return new t.default_view({model:t,parent:this})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.request_render()}),this.connect(this.model.glyph.change,function(){return e.set_data()}),this.connect(this.model.data_source.change,function(){return e.set_data()}),this.connect(this.model.data_source.streaming,function(){return e.set_data()}),this.connect(this.model.data_source.patching,function(t){return e.set_data(!0,t)}),this.connect(this.model.data_source.selected.change,function(){return e.request_render()}),this.connect(this.model.data_source._select,function(){return e.request_render()}),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,function(){return e.request_render()}),this.connect(this.model.properties.view.change,function(){return e.set_data()}),this.connect(this.model.view.change,function(){return e.set_data()});var i=this.plot_view.frame,n=i.x_ranges,r=i.y_ranges;for(var o in n){var s=n[o];s instanceof _.FactorRange&&this.connect(s.change,function(){return e.set_data()})}for(var a in r){var s=r[a];s instanceof _.FactorRange&&this.connect(s.change,function(){return e.set_data()})}this.connect(this.model.glyph.transformchange,function(){return e.set_data()})},e.prototype.have_selection_glyphs=function(){return null!=this.selection_glyph&&null!=this.nonselection_glyph},e.prototype.set_data=function(t,e){void 0===t&&(t=!0),void 0===e&&(e=null);var i=Date.now(),n=this.model.data_source;this.all_indices=this.model.view.indices,this.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.glyph.set_data(n,this.all_indices,e),this.glyph.set_visuals(n),this.decimated_glyph.set_visuals(n),this.have_selection_glyphs()&&(this.selection_glyph.set_visuals(n),this.nonselection_glyph.set_visuals(n)),null!=this.hover_glyph&&this.hover_glyph.set_visuals(n),null!=this.muted_glyph&&this.muted_glyph.set_visuals(n);var r=this.plot_model.lod_factor;this.decimated=[];for(var o=0,s=Math.floor(this.all_indices.length/r);o<s;o++)this.decimated.push(o*r);var l=Date.now()-i;a.logger.debug(this.glyph.model.type+" GlyphRenderer ("+this.model.id+"): set_data finished in "+l+"ms"),this.set_data_timestamp=Date.now(),t&&this.request_render()},Object.defineProperty(e.prototype,"has_webgl",{get:function(){return null!=this.glyph.glglyph},enumerable:!0,configurable:!0}),e.prototype.render=function(){var t=this;if(this.model.visible){var e=Date.now(),i=this.has_webgl;this.glyph.map_data();var n=Date.now()-e,r=Date.now(),s=this.glyph.mask_data(this.all_indices);s.length===this.all_indices.length&&(s=u.range(0,this.all_indices.length));var l=Date.now()-r,h=this.plot_view.canvas_view.ctx;h.save();var c,_=this.model.data_source.selected;c=!_||_.is_empty()?[]:this.glyph instanceof o.LineView&&_.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(s):_.indices;var p,d=this.model.data_source.inspected;p=d&&0!==d.length?d["0d"].glyph?this.model.view.convert_indices_from_subset(s):d["1d"].indices.length>0?d["1d"].indices:function(){for(var t=[],e=0,i=Object.keys(d["2d"].indices);e<i.length;e++){var n=i[e];t.push(parseInt(n))}return t}():[];var f,v,m,g=function(){for(var e=[],i=0,n=s;i<n.length;i++){var r=n[i];u.includes(p,t.all_indices[r])&&e.push(r)}return e}(),y=this.plot_model.lod_threshold;null!=this.model.document&&this.model.document.interactive_duration()>0&&!i&&null!=y&&this.all_indices.length>y?(s=this.decimated,f=this.decimated_glyph,v=this.decimated_glyph,m=this.selection_glyph):(f=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,v=this.nonselection_glyph,m=this.selection_glyph),null!=this.hover_glyph&&g.length&&(s=u.difference(s,g));var b,x=null;if(c.length&&this.have_selection_glyphs()){for(var w=Date.now(),k={},T=0,C=c;T<C.length;T++){var S=C[T];k[S]=!0}var A=new Array,M=new Array;if(this.glyph instanceof o.LineView)for(var E=0,z=this.all_indices;E<z.length;E++){var S=z[E];null!=k[S]?A.push(S):M.push(S)}else for(var O=0,P=s;O<P.length;O++){var S=P[O];null!=k[this.all_indices[S]]?A.push(S):M.push(S)}x=Date.now()-w,b=Date.now(),v.render(h,M,this.glyph),m.render(h,A,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof o.LineView?this.hover_glyph.render(h,this.model.view.convert_indices_from_subset(g),this.glyph):this.hover_glyph.render(h,g,this.glyph))}else b=Date.now(),this.glyph instanceof o.LineView?this.hover_glyph&&g.length?this.hover_glyph.render(h,this.model.view.convert_indices_from_subset(g),this.glyph):f.render(h,this.all_indices,this.glyph):(f.render(h,s,this.glyph),this.hover_glyph&&g.length&&this.hover_glyph.render(h,g,this.glyph));var j=Date.now()-b;this.last_dtrender=j;var N=Date.now()-e;a.logger.debug(this.glyph.model.type+" GlyphRenderer ("+this.model.id+"): render finished in "+N+"ms"),a.logger.trace(" - map_data finished in       : "+n+"ms"),a.logger.trace(" - mask_data finished in      : "+l+"ms"),null!=x&&a.logger.trace(" - selection mask finished in : "+x+"ms"),a.logger.trace(" - glyph renders finished in  : "+j+"ms"),h.restore()}},e.prototype.draw_legend=function(t,e,i,n,r,o,s,a){null==a&&(a=this.model.get_reference_point(o,s)),this.glyph.draw_legend_for_index(t,{x0:e,x1:i,y0:n,y1:r},a)},e.prototype.hit_test=function(t){if(!this.model.visible)return null;var e=this.glyph.hit_test(t);return null==e?null:this.model.view.convert_selection_from_subset(e)},e}(r.DataRendererView);i.GlyphRendererView=v;var m=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GlyphRenderer",this.prototype.default_view=v,this.define({data_source:[l.Instance],view:[l.Instance,function(){return new s.CDSView}],glyph:[l.Instance],hover_glyph:[l.Instance],nonselection_glyph:[l.Any,"auto"],selection_glyph:[l.Any,"auto"],muted_glyph:[l.Instance],muted:[l.Boolean,!1]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.data_source,this.view.compute_indices())},e.prototype.get_reference_point=function(t,e){var i=0;if(null!=t){var n=this.data_source.get_column(t);if(null!=n){var r=h.indexOf(n,e);-1!=r&&(i=r)}}return i},e.prototype.get_selection_manager=function(){return this.data_source.selection_manager},e}(r.DataRenderer);i.GlyphRenderer=m,m.initClass()},function(t,e,i){var n=t(408),r=t(196),o=t(154),s=t(18),a=t(4),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){var e;t.prototype.initialize.call(this),this.xscale=this.plot_view.frame.xscales.default,this.yscale=this.plot_view.frame.yscales.default,this._renderer_views={},e=a.build_views(this._renderer_views,[this.model.node_renderer,this.model.edge_renderer],{parent:this.parent}),this.node_view=e[0],this.edge_view=e[1],this.set_data()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.layout_provider.change,function(){return e.set_data()}),this.connect(this.model.node_renderer.data_source._select,function(){return e.set_data()}),this.connect(this.model.node_renderer.data_source.inspect,function(){return e.set_data()}),this.connect(this.model.node_renderer.data_source.change,function(){return e.set_data()}),this.connect(this.model.edge_renderer.data_source._select,function(){return e.set_data()}),this.connect(this.model.edge_renderer.data_source.inspect,function(){return e.set_data()}),this.connect(this.model.edge_renderer.data_source.change,function(){return e.set_data()});var i=this.plot_view.frame,n=i.x_ranges,r=i.y_ranges;for(var o in n){var s=n[o];this.connect(s.change,function(){return e.set_data()})}for(var a in r){var s=r[a];this.connect(s.change,function(){return e.set_data()})}},e.prototype.set_data=function(t){var e,i;void 0===t&&(t=!0),this.node_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.edge_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0});var n=this.node_view.glyph;e=this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source),n._x=e[0],n._y=e[1];var r=this.edge_view.glyph;i=this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source),r._xs=i[0],r._ys=i[1],n.index_data(),r.index_data(),t&&this.request_render()},e.prototype.render=function(){this.edge_view.render(),this.node_view.render()},e}(r.DataRendererView);i.GraphRendererView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GraphRenderer",this.prototype.default_view=l,this.define({layout_provider:[s.Instance],node_renderer:[s.Instance],edge_renderer:[s.Instance],selection_policy:[s.Instance,function(){return new o.NodesOnly}],inspection_policy:[s.Instance,function(){return new o.NodesOnly}]})},e.prototype.get_selection_manager=function(){return this.node_renderer.data_source.selection_manager},e}(r.DataRenderer);i.GraphRenderer=h,h.initClass()},function(t,e,i){var n=t(408),r=t(201),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.RendererView);i.GuideRendererView=o;var s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GuideRenderer",this.override({level:"overlay"})},e}(r.Renderer);i.GuideRenderer=s,s.initClass()},function(t,e,i){var n=t(197);i.GlyphRenderer=n.GlyphRenderer;var r=t(198);i.GraphRenderer=r.GraphRenderer;var o=t(199);i.GuideRenderer=o.GuideRenderer;var s=t(201);i.Renderer=s.Renderer},function(t,e,i){var n=t(408),r=t(6),o=t(51),s=t(18),a=t(62),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals=new o.Visuals(this.model),this._has_finished=!0},Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!0,configurable:!0}),e.prototype.request_render=function(){this.plot_view.request_render()},e.prototype.map_to_screen=function(t,e){return this.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return!1},enumerable:!0,configurable:!0}),e.prototype.notify_finished=function(){this.plot_view.notify_finished()},Object.defineProperty(e.prototype,"has_webgl",{get:function(){return!1},enumerable:!0,configurable:!0}),e}(r.DOMView);i.RendererView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Renderer",this.define({level:[s.RenderLevel],visible:[s.Boolean,!0]})},e}(a.Model);i.Renderer=h,h.initClass()},function(t,e,i){var n=t(408),r=t(204),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CategoricalScale"},e.prototype.compute=function(e){return t.prototype.compute.call(this,this.source_range.synthetic(e))},e.prototype.v_compute=function(e){return t.prototype.v_compute.call(this,this.source_range.v_synthetic(e))},e}(r.LinearScale);i.CategoricalScale=o,o.initClass()},function(t,e,i){var n=t(202);i.CategoricalScale=n.CategoricalScale;var r=t(204);i.LinearScale=r.LinearScale;var o=t(205);i.LogScale=o.LogScale;var s=t(206);i.Scale=s.Scale},function(t,e,i){var n=t(408),r=t(206),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LinearScale"},e.prototype.compute=function(t){var e=this._compute_state(),i=e[0],n=e[1];return i*t+n},e.prototype.v_compute=function(t){for(var e=this._compute_state(),i=e[0],n=e[1],r=new Float64Array(t.length),o=0;o<t.length;o++)r[o]=i*t[o]+n;return r},e.prototype.invert=function(t){var e=this._compute_state(),i=e[0],n=e[1];return(t-n)/i},e.prototype.v_invert=function(t){for(var e=this._compute_state(),i=e[0],n=e[1],r=new Float64Array(t.length),o=0;o<t.length;o++)r[o]=(t[o]-n)/i;return r},e.prototype._compute_state=function(){var t=this.source_range.start,e=this.source_range.end,i=this.target_range.start,n=this.target_range.end,r=(n-i)/(e-t),o=-r*t+i;return[r,o]},e}(r.Scale);i.LinearScale=o,o.initClass()},function(t,e,i){var n=t(408),r=t(206),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LogScale"},e.prototype.compute=function(t){var e,i=this._compute_state(),n=i[0],r=i[1],o=i[2],s=i[3];if(0==o)e=0;else{var a=(Math.log(t)-s)/o;e=isFinite(a)?a*n+r:NaN}return e},e.prototype.v_compute=function(t){var e=this._compute_state(),i=e[0],n=e[1],r=e[2],o=e[3],s=new Float64Array(t.length);if(0==r)for(var a=0;a<t.length;a++)s[a]=0;else for(var a=0;a<t.length;a++){var l=(Math.log(t[a])-o)/r,h=void 0;h=isFinite(l)?l*i+n:NaN,s[a]=h}return s},e.prototype.invert=function(t){var e=this._compute_state(),i=e[0],n=e[1],r=e[2],o=e[3],s=(t-n)/i;return Math.exp(r*s+o)},e.prototype.v_invert=function(t){for(var e=this._compute_state(),i=e[0],n=e[1],r=e[2],o=e[3],s=new Float64Array(t.length),a=0;a<t.length;a++){var l=(t[a]-n)/i;s[a]=Math.exp(r*l+o)}return s},e.prototype._get_safe_factor=function(t,e){var i,n=t<0?0:t,r=e<0?0:e;if(n==r)if(0==n)n=(i=[1,10])[0],r=i[1];else{var o=Math.log(n)/Math.log(10);n=Math.pow(10,Math.floor(o)),r=Math.ceil(o)!=Math.floor(o)?Math.pow(10,Math.ceil(o)):Math.pow(10,Math.ceil(o)+1)}return[n,r]},e.prototype._compute_state=function(){var t,e,i=this.source_range.start,n=this.source_range.end,r=this.target_range.start,o=this.target_range.end,s=o-r,a=this._get_safe_factor(i,n),l=a[0],h=a[1];0==l?(t=Math.log(h),e=0):(t=Math.log(h)-Math.log(l),e=Math.log(l));var u=s,c=r;return[u,c,t,e]},e}(r.Scale);i.LogScale=o,o.initClass()},function(t,e,i){var n=t(408),r=t(292),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Scale",this.internal({source_range:[o.Any],target_range:[o.Any]})},e.prototype.r_compute=function(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]},e.prototype.r_invert=function(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]},e}(r.Transform);i.Scale=s,s.initClass()},function(t,e,i){var n=t(408);n.__exportStar(t(208),i);var r=t(209);i.Selection=r.Selection},function(t,e,i){var n=t(408),r=t(62),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.do_selection=function(t,e,i,n){return null!==t&&(e.selected.update(t,i,n),e._select.emit(),!e.selected.is_empty())},e}(r.Model);i.SelectionPolicy=o,o.prototype.type="SelectionPolicy";var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.hit_test=function(t,e){for(var i=[],n=0,r=e;n<r.length;n++){var o=r[n],s=o.hit_test(t);null!==s&&i.push(s)}if(i.length>0){for(var a=i[0],l=0,h=i;l<h.length;l++){var u=h[l];a.update_through_intersection(u)}return a}return null},e}(o);i.IntersectRenderers=s,s.prototype.type="IntersectRenderers";var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.hit_test=function(t,e){for(var i=[],n=0,r=e;n<r.length;n++){var o=r[n],s=o.hit_test(t);null!==s&&i.push(s)}if(i.length>0){for(var a=i[0],l=0,h=i;l<h.length;l++){var u=h[l];a.update_through_union(u)}return a}return null},e}(o);i.UnionRenderers=a,a.prototype.type="UnionRenderers"},function(t,e,i){var n=t(408),r=t(62),o=t(18),s=t(24),a=t(35),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Selection",this.define({indices:[o.Array,[]],line_indices:[o.Array,[]],multiline_indices:[o.Any,{}]}),this.internal({final:[o.Boolean],selected_glyphs:[o.Array,[]],get_view:[o.Any],image_indices:[o.Array,[]]})},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this["0d"]={glyph:null,indices:[],flag:!1,get_view:function(){return null}},this["2d"]={indices:{}},this["1d"]={indices:this.indices},this.get_view=function(){return null},this.connect(this.properties.indices.change,function(){return e["1d"].indices=e.indices}),this.connect(this.properties.line_indices.change,function(){e["0d"].indices=e.line_indices,0==e.line_indices.length?e["0d"].flag=!1:e["0d"].flag=!0}),this.connect(this.properties.selected_glyphs.change,function(){return e["0d"].glyph=e.selected_glyph}),this.connect(this.properties.get_view.change,function(){return e["0d"].get_view=e.get_view}),this.connect(this.properties.multiline_indices.change,function(){return e["2d"].indices=e.multiline_indices})},Object.defineProperty(e.prototype,"selected_glyph",{get:function(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null},enumerable:!0,configurable:!0}),e.prototype.add_to_selected_glyphs=function(t){this.selected_glyphs.push(t)},e.prototype.update=function(t,e,i){this.final=e,i?this.update_through_union(t):(this.indices=t.indices,this.line_indices=t.line_indices,this.selected_glyphs=t.selected_glyphs,this.get_view=t.get_view,this.multiline_indices=t.multiline_indices,this.image_indices=t.image_indices)},e.prototype.clear=function(){this.final=!0,this.indices=[],this.line_indices=[],this.multiline_indices={},this.get_view=function(){return null},this.selected_glyphs=[]},e.prototype.is_empty=function(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length},e.prototype.update_through_union=function(t){this.indices=s.union(t.indices,this.indices),this.selected_glyphs=s.union(t.selected_glyphs,this.selected_glyphs),this.line_indices=s.union(t.line_indices,this.line_indices),this.get_view()||(this.get_view=t.get_view),this.multiline_indices=a.merge(t.multiline_indices,this.multiline_indices)},e.prototype.update_through_intersection=function(t){this.indices=s.intersection(t.indices,this.indices),this.selected_glyphs=s.union(t.selected_glyphs,this.selected_glyphs),this.line_indices=s.union(t.line_indices,this.line_indices),this.get_view()||(this.get_view=t.get_view),this.multiline_indices=a.merge(t.multiline_indices,this.multiline_indices)},e}(r.Model);i.Selection=l,l.initClass()},function(t,e,i){var n=t(408),r=t(217),o=t(17),s=t(18),a=function(t){function e(e){var i=t.call(this,e)||this;return i.initialized=!1,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="AjaxDataSource",this.define({content_type:[s.String,"application/json"],http_headers:[s.Any,{}],method:[s.HTTPMethod,"POST"],if_modified:[s.Boolean,!1]})},e.prototype.destroy=function(){null!=this.interval&&clearInterval(this.interval),t.prototype.destroy.call(this)},e.prototype.setup=function(){var t=this;!this.initialized&&(this.initialized=!0,this.get_data(this.mode),this.polling_interval)&&(this.interval=setInterval(function(){return t.get_data(t.mode,t.max_size,t.if_modified)},this.polling_interval))},e.prototype.get_data=function(t,e,i){var n=this;void 0===e&&(e=0),void 0===i&&(i=!1);var r=this.prepare_request();r.addEventListener("load",function(){return n.do_load(r,t,e)}),r.addEventListener("error",function(){return n.do_error(r)}),r.send()},e.prototype.prepare_request=function(){var t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);var e=this.http_headers;for(var i in e){var n=e[i];t.setRequestHeader(i,n)}return t},e.prototype.do_load=function(t,e,i){if(200===t.status){var n=JSON.parse(t.responseText);this.load_data(n,e,i)}},e.prototype.do_error=function(t){o.logger.error("Failed to fetch JSON from "+this.data_url+" with code "+t.status)},e}(r.RemoteDataSource);i.AjaxDataSource=a,a.initClass()},function(t,e,i){var n=t(408),r=t(62),o=t(18),s=t(209),a=t(24),l=t(213),h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CDSView",this.define({filters:[o.Array,[]],source:[o.Instance]}),this.internal({indices:[o.Array,[]],indices_map:[o.Any,{}]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.compute_indices()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.filters.change,function(){e.compute_indices(),e.change.emit()});var i=function(){var t=function(){return e.compute_indices()};null!=e.source&&(e.connect(e.source.change,t),e.source instanceof l.ColumnarDataSource&&(e.connect(e.source.streaming,t),e.connect(e.source.patching,t)))},n=null!=this.source;n?i():this.connect(this.properties.source.change,function(){n||(i(),n=!0)})},e.prototype.compute_indices=function(){var t=this,e=this.filters.map(function(e){return e.compute_indices(t.source)}).filter(function(t){return null!=t});e.length>0?this.indices=a.intersection.apply(this,e):this.source instanceof l.ColumnarDataSource&&(this.indices=this.source.get_indices()),this.indices_map_to_subset()},e.prototype.indices_map_to_subset=function(){this.indices_map={};for(var t=0;t<this.indices.length;t++)this.indices_map[this.indices[t]]=t},e.prototype.convert_selection_from_subset=function(t){var e=this,i=new s.Selection;i.update_through_union(t);var n=t.indices.map(function(t){return e.indices[t]});return i.indices=n,i.image_indices=t.image_indices,i},e.prototype.convert_selection_to_subset=function(t){var e=this,i=new s.Selection;i.update_through_union(t);var n=t.indices.map(function(t){return e.indices_map[t]});return i.indices=n,i.image_indices=t.image_indices,i},e.prototype.convert_indices_from_subset=function(t){var e=this;return t.map(function(t){return e.indices[t]})},e}(r.Model);i.CDSView=h,h.initClass()},function(t,e,i){var n=t(408),r=t(213),o=t(8),s=t(18),a=t(32),l=t(38),h=t(46),u=t(45),c=t(35),_=t(53);function p(t,e,i){if(h.isArray(t)){var n=t.concat(e);return null!=i&&n.length>i?n.slice(-i):n}if(h.isTypedArray(t)){var r=t.length+e.length;if(null!=i&&r>i){var o=r-i,s=t.length,n=void 0;t.length<i?(n=new t.constructor(i)).set(t,0):n=t;for(var a=o,l=s;a<l;a++)n[a-o]=n[a];for(var a=0,l=e.length;a<l;a++)n[a+(s-o)]=e[a];return n}var c=new t.constructor(e);return u.concat(t,c)}throw new Error("unsupported array types")}function d(t,e){var i,n,r;return h.isNumber(t)?(i=t,r=t+1,n=1):(i=null!=t.start?t.start:0,r=null!=t.stop?t.stop:e,n=null!=t.step?t.step:1),[i,r,n]}function f(t,e,i){for(var n=new a.Set,r=!1,o=0,s=e;o<s.length;o++){var l=s[o],u=l[0],c=l[1],_=void 0,p=void 0,f=void 0,v=void 0;if(h.isArray(u)){var m=u[0];n.add(m),p=i[m],_=t[m],v=c,2===u.length?(p=[1,p[0]],f=[u[0],0,u[1]]):f=u}else h.isNumber(u)?(v=[c],n.add(u)):(v=c,r=!0),f=[0,0,u],p=[1,t.length],_=t;for(var g=0,y=d(f[1],p[0]),b=y[0],x=y[1],w=y[2],k=d(f[2],p[1]),T=k[0],C=k[1],S=k[2],m=b;m<x;m+=w)for(var A=T;A<C;A+=S)r&&n.add(A),_[m*p[1]+A]=v[g],g++}return n}i.stream_to_column=p,i.slice=d,i.patch_to_column=f;var v=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ColumnDataSource",this.define({data:[s.Any,{}]})},e.prototype.initialize=function(){var e;t.prototype.initialize.call(this),e=l.decode_column_data(this.data),this.data=e[0],this._shapes=e[1]},e.prototype.attributes_as_json=function(t,i){void 0===t&&(t=!0),void 0===i&&(i=e._value_to_json);for(var n={},r=this.serializable_attributes(),o=0,s=c.keys(r);o<s.length;o++){var a=s[o],h=r[a];"data"===a&&(h=l.encode_column_data(h,this._shapes)),t?n[a]=h:a in this._set_after_defaults&&(n[a]=h)}return i("attributes",n,this)},e._value_to_json=function(t,e,i){return h.isPlainObject(e)&&"data"===t?l.encode_column_data(e,i._shapes):o.HasProps._value_to_json(t,e,i)},e.prototype.stream=function(t,e,i){var n=this.data;for(var r in t)n[r]=p(n[r],t[r],e);if(this.setv({data:n},{silent:!0}),this.streaming.emit(),null!=this.document){var o=new _.ColumnsStreamedEvent(this.document,this.ref(),t,e);this.document._notify_change(this,"data",null,null,{setter_id:i,hint:o})}},e.prototype.patch=function(t,e){var i=this.data,n=new a.Set;for(var r in t){var o=t[r];n=n.union(f(i[r],o,this._shapes[r]))}if(this.setv({data:i},{silent:!0}),this.patching.emit(n.values),null!=this.document){var s=new _.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}},e}(r.ColumnarDataSource);i.ColumnDataSource=v,v.initClass()},function(t,e,i){var n=t(408),r=t(214),o=t(22),s=t(17),a=t(20),l=t(18),h=t(46),u=t(24),c=t(35),_=t(209),p=t(208),d=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.prototype.get_array=function(t){var e=this.data[t];return null==e?this.data[t]=e=[]:h.isArray(e)||(this.data[t]=e=Array.from(e)),e},e.initClass=function(){this.prototype.type="ColumnarDataSource",this.define({selection_policy:[l.Instance,function(){return new p.UnionRenderers}]}),this.internal({selection_manager:[l.Instance,function(t){return new a.SelectionManager({source:t})}],inspected:[l.Instance,function(){return new _.Selection}],_shapes:[l.Any,{}]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._select=new o.Signal0(this,"select"),this.inspect=new o.Signal(this,"inspect"),this.streaming=new o.Signal0(this,"streaming"),this.patching=new o.Signal(this,"patching")},e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:null},e.prototype.columns=function(){return c.keys(this.data)},e.prototype.get_length=function(t){void 0===t&&(t=!0);var e=u.uniq(c.values(this.data).map(function(t){return t.length}));switch(e.length){case 0:return null;case 1:return e[0];default:var i="data source has columns of inconsistent lengths";if(t)return s.logger.warn(i),e.sort()[0];throw new Error(i)}},e.prototype.get_indices=function(){var t=this.get_length();return u.range(0,null!=t?t:1)},e.prototype.clear=function(){for(var t={},e=0,i=this.columns();e<i.length;e++){var n=i[e];t[n]=new this.data[n].constructor(0)}this.data=t},e}(r.DataSource);i.ColumnarDataSource=d,d.initClass()},function(t,e,i){var n=t(408),r=t(62),o=t(209),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="DataSource",this.define({selected:[s.Instance,function(){return new o.Selection}],callback:[s.Any]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.selected.change,function(){null!=e.callback&&e.callback.execute(e)})},e}(r.Model);i.DataSource=a,a.initClass()},function(t,e,i){var n=t(408),r=t(213),o=t(17),s=t(18),a=t(24),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GeoJSONDataSource",this.define({geojson:[s.Any]}),this.internal({data:[s.Any,{}]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._update_data()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.geojson.change,function(){return e._update_data()})},e.prototype._update_data=function(){this.data=this.geojson_to_column_data()},e.prototype._get_new_list_array=function(t){return a.range(0,t).map(function(t){return[]})},e.prototype._get_new_nan_array=function(t){return a.range(0,t).map(function(t){return NaN})},e.prototype._add_properties=function(t,e,i,n){var r=t.properties||{};for(var o in r)e.hasOwnProperty(o)||(e[o]=this._get_new_nan_array(n)),e[o][i]=r[o]},e.prototype._add_geometry=function(t,e,i){function n(t){return null!=t?t:NaN}function r(t,e){return t.concat([[NaN,NaN,NaN]]).concat(e)}switch(t.type){case"Point":var s=t.coordinates,a=s[0],l=s[1],h=s[2];e.x[i]=a,e.y[i]=l,e.z[i]=n(h);break;case"LineString":for(var u=t.coordinates,c=0;c<u.length;c++){var _=u[c],a=_[0],l=_[1],h=_[2];e.xs[i][c]=a,e.ys[i][c]=l,e.zs[i][c]=n(h)}break;case"Polygon":t.coordinates.length>1&&o.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");for(var p=t.coordinates[0],c=0;c<p.length;c++){var d=p[c],a=d[0],l=d[1],h=d[2];e.xs[i][c]=a,e.ys[i][c]=l,e.zs[i][c]=n(h)}break;case"MultiPoint":o.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":for(var u=t.coordinates.reduce(r),c=0;c<u.length;c++){var f=u[c],a=f[0],l=f[1],h=f[2];e.xs[i][c]=a,e.ys[i][c]=l,e.zs[i][c]=n(h)}break;case"MultiPolygon":for(var v=[],m=0,g=t.coordinates;m<g.length;m++){var y=g[m];y.length>1&&o.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),v.push(y[0])}for(var u=v.reduce(r),c=0;c<u.length;c++){var b=u[c],a=b[0],l=b[1],h=b[2];e.xs[i][c]=a,e.ys[i][c]=l,e.zs[i][c]=n(h)}break;default:throw new Error("Invalid GeoJSON geometry type: "+t.type)}},e.prototype.geojson_to_column_data=function(){var t,e=JSON.parse(this.geojson);switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}for(var i=0,n=0,r=t;n<r.length;n++){var o=r[n],s="Feature"===o.type?o.geometry:o;"GeometryCollection"==s.type?i+=s.geometries.length:i+=1}for(var a={x:this._get_new_nan_array(i),y:this._get_new_nan_array(i),z:this._get_new_nan_array(i),xs:this._get_new_list_array(i),ys:this._get_new_list_array(i),zs:this._get_new_list_array(i)},l=0,h=0,u=t;h<u.length;h++){var o=u[h],s="Feature"==o.type?o.geometry:o;if("GeometryCollection"==s.type)for(var c=0,_=s.geometries;c<_.length;c++){var p=_[c];this._add_geometry(p,a,l),"Feature"===o.type&&this._add_properties(o,a,l,i),l+=1}else this._add_geometry(s,a,l),"Feature"===o.type&&this._add_properties(o,a,l,i),l+=1}return a},e}(r.ColumnarDataSource);i.GeoJSONDataSource=l,l.initClass()},function(t,e,i){var n=t(218);i.ServerSentDataSource=n.ServerSentDataSource;var r=t(210);i.AjaxDataSource=r.AjaxDataSource;var o=t(212);i.ColumnDataSource=o.ColumnDataSource;var s=t(213);i.ColumnarDataSource=s.ColumnarDataSource;var a=t(211);i.CDSView=a.CDSView;var l=t(214);i.DataSource=l.DataSource;var h=t(215);i.GeoJSONDataSource=h.GeoJSONDataSource;var u=t(217);i.RemoteDataSource=u.RemoteDataSource},function(t,e,i){var n=t(408),r=t(219),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:[]},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.setup()},e.initClass=function(){this.prototype.type="RemoteDataSource",this.define({polling_interval:[o.Number]})},e}(r.WebDataSource);i.RemoteDataSource=s,s.initClass()},function(t,e,i){var n=t(408),r=t(219),o=function(t){function e(e){var i=t.call(this,e)||this;return i.initialized=!1,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ServerSentDataSource"},e.prototype.destroy=function(){t.prototype.destroy.call(this)},e.prototype.setup=function(){var t=this;if(!this.initialized){this.initialized=!0;var e=new EventSource(this.data_url);e.onmessage=function(e){t.load_data(JSON.parse(e.data),t.mode,t.max_size)}}},e}(r.WebDataSource);i.ServerSentDataSource=o,o.initClass()},function(t,e,i){var n=t(408),r=t(212),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:[]},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.setup()},e.prototype.load_data=function(t,e,i){var n,r=this.adapter;switch(n=null!=r?r.execute(this,{response:t}):t,e){case"replace":this.data=n;break;case"append":for(var o=this.data,s=0,a=this.columns();s<a.length;s++){var l=a[s],h=Array.from(o[l]),u=Array.from(n[l]);n[l]=h.concat(u).slice(-i)}this.data=n}},e.initClass=function(){this.prototype.type="WebDataSource",this.define({mode:[o.UpdateMode,"replace"],max_size:[o.Number],adapter:[o.Any,null],data_url:[o.String]})},e}(r.ColumnDataSource);i.WebDataSource=s,s.initClass()},function(t,e,i){var n=t(408),r=t(223),o=t(18),s=t(40),a=function(e){function i(t){return e.call(this,t)||this}return n.__extends(i,e),i.initClass=function(){this.prototype.type="CanvasTexture",this.define({code:[o.String]})},Object.defineProperty(i.prototype,"func",{get:function(){var t=s.use_strict(this.code);return new Function("ctx","color","scale","weight","require","exports",t)},enumerable:!0,configurable:!0}),i.prototype.get_pattern=function(e,i,n){var r=this;return function(o){var s=document.createElement("canvas");s.width=i,s.height=i;var a=s.getContext("2d");return r.func.call(r,a,e,i,n,t,{}),o.createPattern(s,r.repetition)}},i}(r.Texture);i.CanvasTexture=a,a.initClass()},function(t,e,i){var n=t(408),r=t(223),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ImageURLTexture",this.define({url:[o.String]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.image=new Image,this.image.src=this.url},e.prototype.get_pattern=function(t,e,i){var n=this;return function(t){return n.image.complete?t.createPattern(n.image,n.repetition):null}},e.prototype.onload=function(t){this.image.complete?t():this.image.onload=function(){t()}},e}(r.Texture);i.ImageURLTexture=s,s.initClass()},function(t,e,i){var n=t(220);i.CanvasTexture=n.CanvasTexture;var r=t(221);i.ImageURLTexture=r.ImageURLTexture;var o=t(223);i.Texture=o.Texture},function(t,e,i){var n=t(408),r=t(62),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Texture",this.define({repetition:[o.TextureRepetition,"repeat"]})},e.prototype.onload=function(t){t()},e}(r.Model);i.Texture=s,s.initClass()},function(t,e,i){var n=t(408),r=t(228),o=t(24),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="AdaptiveTicker",this.define({base:[s.Number,10],mantissas:[s.Array,[1,2,5]],min_interval:[s.Number,0],max_interval:[s.Number]})},e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=o.nth(this.mantissas,-1)/this.base,i=o.nth(this.mantissas,0)*this.base;this.extended_mantissas=[e].concat(this.mantissas,[i]),this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()},e.prototype.get_interval=function(t,e,i){var n,r,s,a=e-t,l=this.get_ideal_interval(t,e,i),h=Math.floor(function(t,e){return void 0===e&&(e=Math.E),Math.log(t)/Math.log(e)}(l/this.base_factor,this.base)),u=Math.pow(this.base,h)*this.base_factor,c=this.extended_mantissas,_=c.map(function(t){return Math.abs(i-a/(t*u))}),p=c[o.argmin(_)],d=p*u;return n=d,r=this.get_min_interval(),s=this.get_max_interval(),Math.max(r,Math.min(s,n))},e}(r.ContinuousTicker);i.AdaptiveTicker=a,a.initClass()},function(t,e,i){var n=t(408),r=t(224),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="BasicTicker"},e}(r.AdaptiveTicker);i.BasicTicker=o,o.initClass()},function(t,e,i){var n=t(408),r=t(237),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CategoricalTicker"},e.prototype.get_ticks=function(t,e,i,n,r){var o=this._collect(i.factors,i,t,e),s=this._collect(i.tops||[],i,t,e),a=this._collect(i.mids||[],i,t,e);return{major:o,minor:[],tops:s,mids:a}},e.prototype._collect=function(t,e,i,n){for(var r=[],o=0,s=t;o<s.length;o++){var a=s[o],l=e.synthetic(a);l>i&&l<n&&r.push(a)}return r},e}(r.Ticker);i.CategoricalTicker=o,o.initClass()},function(t,e,i){var n=t(408),r=t(228),o=t(18),s=t(24),a=t(35),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CompositeTicker",this.define({tickers:[o.Array,[]]})},Object.defineProperty(e.prototype,"min_intervals",{get:function(){return this.tickers.map(function(t){return t.get_min_interval()})},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_intervals",{get:function(){return this.tickers.map(function(t){return t.get_max_interval()})},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"min_interval",{get:function(){return this.min_intervals[0]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_interval",{get:function(){return this.max_intervals[0]},enumerable:!0,configurable:!0}),e.prototype.get_best_ticker=function(t,e,i){var n,r=e-t,o=this.get_ideal_interval(t,e,i),l=[s.sorted_index(this.min_intervals,o)-1,s.sorted_index(this.max_intervals,o)],h=[this.min_intervals[l[0]],this.max_intervals[l[1]]],u=h.map(function(t){return Math.abs(i-r/t)});if(a.isEmpty(u.filter(function(t){return!isNaN(t)})))n=this.tickers[0];else{var c=s.argmin(u),_=l[c];n=this.tickers[_]}return n},e.prototype.get_interval=function(t,e,i){var n=this.get_best_ticker(t,e,i);return n.get_interval(t,e,i)},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=this.get_best_ticker(t,e,n);return r.get_ticks_no_defaults(t,e,i,n)},e}(r.ContinuousTicker);i.CompositeTicker=l,l.initClass()},function(t,e,i){var n=t(408),r=t(237),o=t(18),s=t(24),a=t(46),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ContinuousTicker",this.define({num_minor_ticks:[o.Number,5],desired_num_ticks:[o.Number,6]})},e.prototype.get_ticks=function(t,e,i,n,r){return this.get_ticks_no_defaults(t,e,n,this.desired_num_ticks)},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=this.get_interval(t,e,n),o=Math.floor(t/r),l=Math.ceil(e/r),h=(a.isStrictNaN(o)||a.isStrictNaN(l)?[]:s.range(o,l+1)).map(function(t){return t*r}).filter(function(i){return t<=i&&i<=e}),u=this.num_minor_ticks,c=[];if(u>0&&h.length>0){for(var _=r/u,p=s.range(0,u).map(function(t){return t*_}),d=0,f=p.slice(1);d<f.length;d++){var v=f[d],m=h[0]-v;t<=m&&m<=e&&c.push(m)}for(var g=0,y=h;g<y.length;g++)for(var b=y[g],x=0,w=p;x<w.length;x++){var v=w[x],m=b+v;t<=m&&m<=e&&c.push(m)}}return{major:h,minor:c}},e.prototype.get_min_interval=function(){return this.min_interval},e.prototype.get_max_interval=function(){return null!=this.max_interval?this.max_interval:1/0},e.prototype.get_ideal_interval=function(t,e,i){var n=e-t;return n/i},e}(r.Ticker);i.ContinuousTicker=l,l.initClass()},function(t,e,i){var n=t(408),r=t(24),o=t(224),s=t(227),a=t(230),l=t(235),h=t(239),u=t(238),c=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="DatetimeTicker",this.override({num_minor_ticks:0,tickers:function(){return[new o.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*u.ONE_MILLI,num_minor_ticks:0}),new o.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:u.ONE_SECOND,max_interval:30*u.ONE_MINUTE,num_minor_ticks:0}),new o.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:u.ONE_HOUR,max_interval:12*u.ONE_HOUR,num_minor_ticks:0}),new a.DaysTicker({days:r.range(1,32)}),new a.DaysTicker({days:r.range(1,31,3)}),new a.DaysTicker({days:[1,8,15,22]}),new a.DaysTicker({days:[1,15]}),new l.MonthsTicker({months:r.range(0,12,1)}),new l.MonthsTicker({months:r.range(0,12,2)}),new l.MonthsTicker({months:r.range(0,12,4)}),new l.MonthsTicker({months:r.range(0,12,6)}),new h.YearsTicker({})]}})},e}(s.CompositeTicker);i.DatetimeTicker=c,c.initClass()},function(t,e,i){var n=t(408),r=t(236),o=t(238),s=t(18),a=t(24),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="DaysTicker",this.define({days:[s.Array,[]]}),this.override({num_minor_ticks:0})},e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=this.days;e.length>1?this.interval=(e[1]-e[0])*o.ONE_DAY:this.interval=31*o.ONE_DAY},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=function(t,e){var i=o.last_month_no_later_than(new Date(t)),n=o.last_month_no_later_than(new Date(e));n.setUTCMonth(n.getUTCMonth()+1);for(var r=[],s=i;r.push(o.copy_date(s)),s.setUTCMonth(s.getUTCMonth()+1),!(s>n););return r}(t,e),s=this.days,l=this.interval,h=a.concat(r.map(function(t){return function(t,e){for(var i=t.getUTCMonth(),n=[],r=0,a=s;r<a.length;r++){var l=a[r],h=o.copy_date(t);h.setUTCDate(l);var u=new Date(h.getTime()+e/2);u.getUTCMonth()==i&&n.push(h)}return n}(t,l)})),u=h.map(function(t){return t.getTime()}),c=u.filter(function(i){return t<=i&&i<=e});return{major:c,minor:[]}},e}(r.SingleIntervalTicker);i.DaysTicker=l,l.initClass()},function(t,e,i){var n=t(408),r=t(228),o=t(18),s=function(t){function e(e){var i=t.call(this,e)||this;return i.min_interval=0,i.max_interval=0,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="FixedTicker",this.define({ticks:[o.Array,[]],minor_ticks:[o.Array,[]]})},e.prototype.get_ticks_no_defaults=function(t,e,i,n){return{major:this.ticks,minor:this.minor_ticks}},e.prototype.get_interval=function(t,e,i){return 0},e}(r.ContinuousTicker);i.FixedTicker=s,s.initClass()},function(t,e,i){var n=t(224);i.AdaptiveTicker=n.AdaptiveTicker;var r=t(225);i.BasicTicker=r.BasicTicker;var o=t(226);i.CategoricalTicker=o.CategoricalTicker;var s=t(227);i.CompositeTicker=s.CompositeTicker;var a=t(228);i.ContinuousTicker=a.ContinuousTicker;var l=t(229);i.DatetimeTicker=l.DatetimeTicker;var h=t(230);i.DaysTicker=h.DaysTicker;var u=t(231);i.FixedTicker=u.FixedTicker;var c=t(233);i.LogTicker=c.LogTicker;var _=t(234);i.MercatorTicker=_.MercatorTicker;var p=t(235);i.MonthsTicker=p.MonthsTicker;var d=t(236);i.SingleIntervalTicker=d.SingleIntervalTicker;var f=t(237);i.Ticker=f.Ticker;var v=t(239);i.YearsTicker=v.YearsTicker},function(t,e,i){var n=t(408),r=t(224),o=t(24),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LogTicker",this.override({mantissas:[1,5]})},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r,s=this.num_minor_ticks,a=[],l=this.base,h=Math.log(t)/Math.log(l),u=Math.log(e)/Math.log(l),c=u-h;if(isFinite(c))if(c<2){var _=this.get_interval(t,e,n),p=Math.floor(t/_),d=Math.ceil(e/_);if(r=o.range(p,d+1).filter(function(t){return 0!=t}).map(function(t){return t*_}).filter(function(i){return t<=i&&i<=e}),s>0&&r.length>0){for(var f=_/s,v=o.range(0,s).map(function(t){return t*f}),m=0,g=v.slice(1);m<g.length;m++){var y=g[m];a.push(r[0]-y)}for(var b=0,x=r;b<x.length;b++)for(var w=x[b],k=0,T=v;k<T.length;k++){var y=T[k];a.push(w+y)}}}else{var C=Math.ceil(.999999*h),S=Math.floor(1.000001*u),A=Math.ceil((S-C)/9);if(r=o.range(C-1,S+1,A).map(function(t){return Math.pow(l,t)}),s>0&&r.length>0){for(var M=Math.pow(l,A)/s,v=o.range(1,s+1).map(function(t){return t*M}),E=0,z=v;E<z.length;E++){var y=z[E];a.push(r[0]/y)}a.push(r[0]);for(var O=0,P=r;O<P.length;O++)for(var w=P[O],j=0,N=v;j<N.length;j++){var y=N[j];a.push(w*y)}}}else r=[];return{major:r.filter(function(i){return t<=i&&i<=e}),minor:a.filter(function(i){return t<=i&&i<=e})}},e}(r.AdaptiveTicker);i.LogTicker=s,s.initClass()},function(t,e,i){var n=t(408),r=t(225),o=t(18),s=t(36),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="MercatorTicker",this.define({dimension:[o.LatLon]})},e.prototype.get_ticks_no_defaults=function(e,i,n,r){var o,a,l,h,u,c,_,p;if(null==this.dimension)throw new Error("MercatorTicker.dimension not configured");o=s.clip_mercator(e,i,this.dimension),e=o[0],i=o[1],"lon"===this.dimension?(a=s.wgs84_mercator.inverse([e,n]),c=a[0],p=a[1],l=s.wgs84_mercator.inverse([i,n]),_=l[0],p=l[1]):(h=s.wgs84_mercator.inverse([n,e]),p=h[0],c=h[1],u=s.wgs84_mercator.inverse([n,i]),p=u[0],_=u[1]);var d=t.prototype.get_ticks_no_defaults.call(this,c,_,n,r),f=[],v=[];if("lon"===this.dimension){for(var m=0,g=d.major;m<g.length;m++){var y=g[m];if(s.in_bounds(y,"lon")){var b=s.wgs84_mercator.forward([y,p])[0];f.push(b)}}for(var x=0,w=d.minor;x<w.length;x++){var y=w[x];if(s.in_bounds(y,"lon")){var b=s.wgs84_mercator.forward([y,p])[0];v.push(b)}}}else{for(var k=0,T=d.major;k<T.length;k++){var y=T[k];if(s.in_bounds(y,"lat")){var C=s.wgs84_mercator.forward([p,y]),S=C[1];f.push(S)}}for(var A=0,M=d.minor;A<M.length;A++){var y=M[A];if(s.in_bounds(y,"lat")){var E=s.wgs84_mercator.forward([p,y]),S=E[1];v.push(S)}}}return{major:f,minor:v}},e}(r.BasicTicker);i.MercatorTicker=a,a.initClass()},function(t,e,i){var n=t(408),r=t(236),o=t(238),s=t(18),a=t(24),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="MonthsTicker",this.define({months:[s.Array,[]]})},e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=this.months;e.length>1?this.interval=(e[1]-e[0])*o.ONE_MONTH:this.interval=12*o.ONE_MONTH},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=function(t,e){var i=o.last_year_no_later_than(new Date(t)),n=o.last_year_no_later_than(new Date(e));n.setUTCFullYear(n.getUTCFullYear()+1);for(var r=[],s=i;r.push(o.copy_date(s)),s.setUTCFullYear(s.getUTCFullYear()+1),!(s>n););return r}(t,e),s=this.months,l=a.concat(r.map(function(t){return s.map(function(e){var i=o.copy_date(t);return i.setUTCMonth(e),i})})),h=l.map(function(t){return t.getTime()}),u=h.filter(function(i){return t<=i&&i<=e});return{major:u,minor:[]}},e}(r.SingleIntervalTicker);i.MonthsTicker=l,l.initClass()},function(t,e,i){var n=t(408),r=t(228),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="SingleIntervalTicker",this.define({interval:[o.Number]})},e.prototype.get_interval=function(t,e,i){return this.interval},Object.defineProperty(e.prototype,"min_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),e}(r.ContinuousTicker);i.SingleIntervalTicker=s,s.initClass()},function(t,e,i){var n=t(408),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Ticker"},e}(r.Model);i.Ticker=o,o.initClass()},function(t,e,i){function n(t){return new Date(t.getTime())}function r(t){var e=n(t);return e.setUTCDate(1),e.setUTCHours(0),e.setUTCMinutes(0),e.setUTCSeconds(0),e.setUTCMilliseconds(0),e}i.ONE_MILLI=1,i.ONE_SECOND=1e3,i.ONE_MINUTE=60*i.ONE_SECOND,i.ONE_HOUR=60*i.ONE_MINUTE,i.ONE_DAY=24*i.ONE_HOUR,i.ONE_MONTH=30*i.ONE_DAY,i.ONE_YEAR=365*i.ONE_DAY,i.copy_date=n,i.last_month_no_later_than=r,i.last_year_no_later_than=function(t){var e=r(t);return e.setUTCMonth(0),e}},function(t,e,i){var n=t(408),r=t(225),o=t(236),s=t(238),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="YearsTicker"},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.interval=s.ONE_YEAR,this.basic_ticker=new r.BasicTicker({num_minor_ticks:0})},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=s.last_year_no_later_than(new Date(t)).getUTCFullYear(),o=s.last_year_no_later_than(new Date(e)).getUTCFullYear(),a=this.basic_ticker.get_ticks_no_defaults(r,o,i,n).major,l=a.map(function(t){return Date.UTC(t,0,1)}),h=l.filter(function(i){return t<=i&&i<=e});return{major:h,minor:[]}},e}(o.SingleIntervalTicker);i.YearsTicker=a,a.initClass()},function(t,e,i){var n=t(408),r=t(243),o=t(18),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="BBoxTileSource",this.define({use_latlon:[o.Boolean,!1]})},e.prototype.get_image_url=function(t,e,i){var n,r,o,s,a,l,h=this.string_lookup_replace(this.url,this.extra_url_vars);return this.use_latlon?(n=this.get_tile_geographic_bounds(t,e,i),s=n[0],l=n[1],o=n[2],a=n[3]):(r=this.get_tile_meter_bounds(t,e,i),s=r[0],l=r[1],o=r[2],a=r[3]),h.replace("{XMIN}",s.toString()).replace("{YMIN}",l.toString()).replace("{XMAX}",o.toString()).replace("{YMAX}",a.toString())},e}(r.MercatorTileSource);i.BBoxTileSource=s,s.initClass()},function(t,e,i){var n=t(46),r=function(){function t(){this.images=[]}return t.prototype.pop=function(){var t=this.images.pop();return null!=t?t:new Image},t.prototype.push=function(t){var e;this.images.length>50||(n.isArray(t)?(e=this.images).push.apply(e,t):this.images.push(t))},t}();i.ImagePool=r},function(t,e,i){var n=t(240);i.BBoxTileSource=n.BBoxTileSource;var r=t(243);i.MercatorTileSource=r.MercatorTileSource;var o=t(244);i.QUADKEYTileSource=o.QUADKEYTileSource;var s=t(245);i.TileRenderer=s.TileRenderer;var a=t(246);i.TileSource=a.TileSource;var l=t(248);i.TMSTileSource=l.TMSTileSource;var h=t(249);i.WMTSTileSource=h.WMTSTileSource},function(t,e,i){var n=t(408),r=t(246),o=t(18),s=t(24),a=t(247),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="MercatorTileSource",this.define({snap_to_zoom:[o.Boolean,!1],wrap_around:[o.Boolean,!0]}),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this._resolutions=s.range(this.min_zoom,this.max_zoom+1).map(function(t){return e.get_resolution(t)})},e.prototype._computed_initial_resolution=function(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size},e.prototype.is_valid_tile=function(t,e,i){return!(!this.wrap_around&&(t<0||t>=Math.pow(2,i))||e<0||e>=Math.pow(2,i))},e.prototype.parent_by_tile_xyz=function(t,e,i){var n=this.tile_xyz_to_quadkey(t,e,i),r=n.substring(0,n.length-1);return this.quadkey_to_tile_xyz(r)},e.prototype.get_resolution=function(t){return this._computed_initial_resolution()/Math.pow(2,t)},e.prototype.get_resolution_by_extent=function(t,e,i){var n=(t[2]-t[0])/i,r=(t[3]-t[1])/e;return[n,r]},e.prototype.get_level_by_extent=function(t,e,i){for(var n=(t[2]-t[0])/i,r=(t[3]-t[1])/e,o=Math.max(n,r),s=0,a=0,l=this._resolutions;a<l.length;a++){var h=l[a];if(o>h){if(0==s)return 0;if(s>0)return s-1}s+=1}return s-1},e.prototype.get_closest_level_by_extent=function(t,e,i){var n=(t[2]-t[0])/i,r=(t[3]-t[1])/e,o=Math.max(n,r),s=this._resolutions.reduce(function(t,e){return Math.abs(e-o)<Math.abs(t-o)?e:t});return this._resolutions.indexOf(s)},e.prototype.snap_to_zoom_level=function(t,e,i,n){var r=t[0],o=t[1],s=t[2],a=t[3],l=this._resolutions[n],h=i*l,u=e*l;if(!this.snap_to_zoom){var c=(s-r)/h,_=(a-o)/u;c>_?(h=s-r,u*=c):(h*=_,u=a-o)}var p=(h-(s-r))/2,d=(u-(a-o))/2;return[r-p,o-d,s+p,a+d]},e.prototype.tms_to_wmts=function(t,e,i){return[t,Math.pow(2,i)-1-e,i]},e.prototype.wmts_to_tms=function(t,e,i){return[t,Math.pow(2,i)-1-e,i]},e.prototype.pixels_to_meters=function(t,e,i){var n=this.get_resolution(i),r=t*n-this.x_origin_offset,o=e*n-this.y_origin_offset;return[r,o]},e.prototype.meters_to_pixels=function(t,e,i){var n=this.get_resolution(i),r=(t+this.x_origin_offset)/n,o=(e+this.y_origin_offset)/n;return[r,o]},e.prototype.pixels_to_tile=function(t,e){var i=Math.ceil(t/this.tile_size);i=0===i?i:i-1;var n=Math.max(Math.ceil(e/this.tile_size)-1,0);return[i,n]},e.prototype.pixels_to_raster=function(t,e,i){var n=this.tile_size<<i;return[t,n-e]},e.prototype.meters_to_tile=function(t,e,i){var n=this.meters_to_pixels(t,e,i),r=n[0],o=n[1];return this.pixels_to_tile(r,o)},e.prototype.get_tile_meter_bounds=function(t,e,i){var n=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),r=n[0],o=n[1],s=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i),a=s[0],l=s[1];return[r,o,a,l]},e.prototype.get_tile_geographic_bounds=function(t,e,i){var n=this.get_tile_meter_bounds(t,e,i),r=a.meters_extent_to_geographic(n),o=r[0],s=r[1],l=r[2],h=r[3];return[o,s,l,h]},e.prototype.get_tiles_by_extent=function(t,e,i){void 0===i&&(i=1);var n=t[0],r=t[1],o=t[2],s=t[3],a=this.meters_to_tile(n,r,e),l=a[0],h=a[1],u=this.meters_to_tile(o,s,e),c=u[0],_=u[1];l-=i,h-=i,c+=i;for(var p=[],d=_+=i;d>=h;d--)for(var f=l;f<=c;f++)this.is_valid_tile(f,d,e)&&p.push([f,d,e,this.get_tile_meter_bounds(f,d,e)]);return this.sort_tiles_from_center(p,[l,h,c,_]),p},e.prototype.quadkey_to_tile_xyz=function(t){for(var e=0,i=0,n=t.length,r=n;r>0;r--){var o=t.charAt(n-r),s=1<<r-1;switch(o){case"0":continue;case"1":e|=s;break;case"2":i|=s;break;case"3":e|=s,i|=s;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,i,n]},e.prototype.tile_xyz_to_quadkey=function(t,e,i){for(var n="",r=i;r>0;r--){var o=1<<r-1,s=0;0!=(t&o)&&(s+=1),0!=(e&o)&&(s+=2),n+=s.toString()}return n},e.prototype.children_by_tile_xyz=function(t,e,i){for(var n=this.tile_xyz_to_quadkey(t,e,i),r=[],o=0;o<=3;o++){var s=this.quadkey_to_tile_xyz(n+o.toString()),a=s[0],l=s[1],h=s[2],u=this.get_tile_meter_bounds(a,l,h);r.push([a,l,h,u])}return r},e.prototype.get_closest_parent_by_tile_xyz=function(t,e,i){var n,r,o,s=this.calculate_world_x_by_tile_xyz(t,e,i);n=this.normalize_xyz(t,e,i),t=n[0],e=n[1],i=n[2];for(var a=this.tile_xyz_to_quadkey(t,e,i);a.length>0;)if(a=a.substring(0,a.length-1),r=this.quadkey_to_tile_xyz(a),t=r[0],e=r[1],i=r[2],o=this.denormalize_xyz(t,e,i,s),t=o[0],e=o[1],i=o[2],this.tile_xyz_to_key(t,e,i)in this.tiles)return[t,e,i];return[0,0,0]},e.prototype.normalize_xyz=function(t,e,i){if(this.wrap_around){var n=Math.pow(2,i);return[(t%n+n)%n,e,i]}return[t,e,i]},e.prototype.denormalize_xyz=function(t,e,i,n){return[t+n*Math.pow(2,i),e,i]},e.prototype.denormalize_meters=function(t,e,i,n){return[t+2*n*Math.PI*6378137,e]},e.prototype.calculate_world_x_by_tile_xyz=function(t,e,i){return Math.floor(t/Math.pow(2,i))},e}(r.TileSource);i.MercatorTileSource=l,l.initClass()},function(t,e,i){var n=t(408),r=t(243),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="QUADKEYTileSource"},e.prototype.get_image_url=function(t,e,i){var n=this.string_lookup_replace(this.url,this.extra_url_vars),r=this.tms_to_wmts(t,e,i),o=r[0],s=r[1],a=r[2],l=this.tile_xyz_to_quadkey(o,s,a);return n.replace("{Q}",l)},e}(r.MercatorTileSource);i.QUADKEYTileSource=o,o.initClass()},function(t,e,i){var n=t(408),r=t(241),o=t(249),s=t(196),a=t(195),l=t(5),h=t(18),u=t(24),c=t(46),_=t(20),p=t(212),d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){this._tiles=[],t.prototype.initialize.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.request_render()}),this.connect(this.model.tile_source.change,function(){return e.request_render()})},e.prototype.get_extent=function(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]},Object.defineProperty(e.prototype,"map_plot",{get:function(){return this.plot_model},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"map_canvas",{get:function(){return this.plot_view.canvas_view.ctx},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"map_frame",{get:function(){return this.plot_view.frame},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"x_range",{get:function(){return this.map_plot.x_range},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"y_range",{get:function(){return this.map_plot.y_range},enumerable:!0,configurable:!0}),e.prototype._set_data=function(){this.pool=new r.ImagePool,this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0},e.prototype._update_attribution=function(){null!=this.attribution_el&&l.removeElement(this.attribution_el);var t=this.model.tile_source.attribution;if(c.isString(t)&&t.length>0){var e=this.plot_view,i=e.layout,n=e.frame,r=i._width.value-n._right.value,o=i._height.value-n._bottom.value,s=n._width.value;this.attribution_el=l.div({class:"bk-tile-attribution",style:{position:"absolute",right:r+"px",bottom:o+"px","max-width":s-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"7pt","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}});var a=this.plot_view.canvas_view.events_el;a.appendChild(this.attribution_el),this.attribution_el.innerHTML=t,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}},e.prototype._map_data=function(){this.initial_extent=this.get_extent();var t=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value),e=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value,t);this.x_range.start=e[0],this.y_range.start=e[1],this.x_range.end=e[2],this.y_range.end=e[3],this.x_range instanceof a.Range1d&&(this.x_range.reset_start=e[0],this.x_range.reset_end=e[2]),this.y_range instanceof a.Range1d&&(this.y_range.reset_start=e[1],this.y_range.reset_end=e[3]),this._update_attribution()},e.prototype._on_tile_load=function(t,e){t.img=e.target,t.loaded=!0,this.request_render()},e.prototype._on_tile_cache_load=function(t,e){t.img=e.target,t.loaded=!0,t.finished=!0,this.notify_finished()},e.prototype._on_tile_error=function(t){t.finished=!0},e.prototype._create_tile=function(t,e,i,n,r){void 0===r&&(r=!1);var o=this.model.tile_source.normalize_xyz(t,e,i),s=o[0],a=o[1],l=o[2],h=this.pool.pop(),u={img:h,tile_coords:[t,e,i],normalized_coords:[s,a,l],quadkey:this.model.tile_source.tile_xyz_to_quadkey(t,e,i),cache_key:this.model.tile_source.tile_xyz_to_key(t,e,i),bounds:n,loaded:!1,finished:!1,x_coord:n[0],y_coord:n[3]};h.onload=r?this._on_tile_cache_load.bind(this,u):this._on_tile_load.bind(this,u),h.onerror=this._on_tile_error.bind(this,u),h.alt="",h.src=this.model.tile_source.get_image_url(s,a,l),this.model.tile_source.tiles[u.cache_key]=u,this._tiles.push(u)},e.prototype._enforce_aspect_ratio=function(){if(this._last_height!==this.map_frame._height.value||this._last_width!==this.map_frame._width.value){var t=this.get_extent(),e=this.model.tile_source.get_level_by_extent(t,this.map_frame._height.value,this.map_frame._width.value),i=this.model.tile_source.snap_to_zoom_level(t,this.map_frame._height.value,this.map_frame._width.value,e);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame._height.value,this._last_width=this.map_frame._width.value}},e.prototype.has_finished=function(){if(!t.prototype.has_finished.call(this))return!1;if(0===this._tiles.length)return!1;for(var e=0,i=this._tiles;e<i.length;e++){var n=i[e];if(!n.finished)return!1}return!0},e.prototype.render=function(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()},e.prototype._draw_tile=function(t){var e=this.model.tile_source.tiles[t];if(null!=e){var i=this.plot_view.map_to_screen([e.bounds[0]],[e.bounds[3]]),n=i[0][0],r=i[1][0],o=this.plot_view.map_to_screen([e.bounds[2]],[e.bounds[1]]),s=o[0][0],a=o[1][0],l=s-n,h=a-r,u=n,c=r,_=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(e.img,u,c,l,h),this.map_canvas.setImageSmoothingEnabled(_),e.finished=!0}},e.prototype._set_rect=function(){var t=this.plot_model.properties.outline_line_width.value(),e=this.map_frame._left.value+t/2,i=this.map_frame._top.value+t/2,n=this.map_frame._width.value-t,r=this.map_frame._height.value-t;this.map_canvas.rect(e,i,n,r),this.map_canvas.clip()},e.prototype._render_tiles=function(t){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(var e=0,i=t;e<i.length;e++){var n=i[e];this._draw_tile(n)}this.map_canvas.restore()},e.prototype._prefetch_tiles=function(){for(var t=this.model.tile_source,e=this.get_extent(),i=this.map_frame._height.value,n=this.map_frame._width.value,r=this.model.tile_source.get_level_by_extent(e,i,n),o=this.model.tile_source.get_tiles_by_extent(e,r),s=0,a=Math.min(10,o.length);s<a;s++)for(var l=o[s],h=l[0],u=l[1],c=l[2],_=this.model.tile_source.children_by_tile_xyz(h,u,c),p=0,d=_;p<d.length;p++){var f=d[p],v=f[0],m=f[1],g=f[2],y=f[3];t.tile_xyz_to_key(v,m,g)in t.tiles||this._create_tile(v,m,g,y,!0)}},e.prototype._fetch_tiles=function(t){for(var e=0,i=t;e<i.length;e++){var n=i[e],r=n[0],o=n[1],s=n[2],a=n[3];this._create_tile(r,o,s,a)}},e.prototype._update=function(){var t=this,e=this.model.tile_source,i=e.min_zoom,n=e.max_zoom,r=this.get_extent(),o=this.extent[2]-this.extent[0]<r[2]-r[0],s=this.map_frame._height.value,a=this.map_frame._width.value,l=e.get_level_by_extent(r,s,a),h=!1;l<i?(r=this.extent,l=i,h=!0):l>n&&(r=this.extent,l=n,h=!0),h&&(this.x_range.setv({x_range:{start:r[0],end:r[2]}}),this.y_range.setv({start:r[1],end:r[3]}),this.extent=r),this.extent=r;for(var c=e.get_tiles_by_extent(r,l),_=[],p=[],d=[],f=[],v=0,m=c;v<m.length;v++){var g=m[v],y=g[0],b=g[1],x=g[2],w=e.tile_xyz_to_key(y,b,x),k=e.tiles[w];if(null!=k&&k.loaded)p.push(w);else if(this.model.render_parents){var T=e.get_closest_parent_by_tile_xyz(y,b,x),C=T[0],S=T[1],A=T[2],M=e.tile_xyz_to_key(C,S,A),E=e.tiles[M];if(null!=E&&E.loaded&&!u.includes(d,M)&&d.push(M),o)for(var z=e.children_by_tile_xyz(y,b,x),O=0,P=z;O<P.length;O++){var j=P[O],N=j[0],D=j[1],F=j[2],B=e.tile_xyz_to_key(N,D,F);B in e.tiles&&f.push(B)}}null==k&&_.push(g)}this._render_tiles(d),this._render_tiles(f),this._render_tiles(p),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout(function(){return t._fetch_tiles(_)},65)},e}(s.DataRendererView);i.TileRendererView=d;var f=function(t){function e(e){var i=t.call(this,e)||this;return i._selection_manager=new _.SelectionManager({source:new p.ColumnDataSource}),i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="TileRenderer",this.prototype.default_view=d,this.define({alpha:[h.Number,1],smoothing:[h.Boolean,!0],tile_source:[h.Instance,function(){return new o.WMTSTileSource}],render_parents:[h.Boolean,!0]})},e.prototype.get_selection_manager=function(){return this._selection_manager},e}(s.DataRenderer);i.TileRenderer=f,f.initClass()},function(t,e,i){var n=t(408),r=t(62),o=t(241),s=t(18),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="TileSource",this.define({url:[s.String,""],tile_size:[s.Number,256],max_zoom:[s.Number,30],min_zoom:[s.Number,0],extra_url_vars:[s.Any,{}],attribution:[s.String,""],x_origin_offset:[s.Number],y_origin_offset:[s.Number],initial_resolution:[s.Number]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.tiles={},this.pool=new o.ImagePool,this._normalize_case()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,function(){return e._clear_cache()})},e.prototype.string_lookup_replace=function(t,e){var i=t;for(var n in e){var r=e[n];i=i.replace("{"+n+"}",r)}return i},e.prototype._normalize_case=function(){var t=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=t},e.prototype._clear_cache=function(){this.tiles={}},e.prototype.tile_xyz_to_key=function(t,e,i){return t+":"+e+":"+i},e.prototype.key_to_tile_xyz=function(t){var e=t.split(":").map(function(t){return parseInt(t)}),i=e[0],n=e[1],r=e[2];return[i,n,r]},e.prototype.sort_tiles_from_center=function(t,e){var i=e[0],n=e[1],r=e[2],o=e[3],s=(r-i)/2+i,a=(o-n)/2+n;t.sort(function(t,e){var i=Math.sqrt(Math.pow(s-t[0],2)+Math.pow(a-t[1],2)),n=Math.sqrt(Math.pow(s-e[0],2)+Math.pow(a-e[1],2));return i-n})},e.prototype.get_image_url=function(t,e,i){var n=this.string_lookup_replace(this.url,this.extra_url_vars);return n.replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",i.toString())},e}(r.Model);i.TileSource=a,a.initClass()},function(t,e,i){var n=t(36);function r(t,e){return n.wgs84_mercator.forward([t,e])}function o(t,e){return n.wgs84_mercator.inverse([t,e])}i.geographic_to_meters=r,i.meters_to_geographic=o,i.geographic_extent_to_meters=function(t){var e=t[0],i=t[1],n=t[2],o=t[3],s=r(e,i),a=s[0],l=s[1],h=r(n,o),u=h[0],c=h[1];return[a,l,u,c]},i.meters_extent_to_geographic=function(t){var e=t[0],i=t[1],n=t[2],r=t[3],s=o(e,i),a=s[0],l=s[1],h=o(n,r),u=h[0],c=h[1];return[a,l,u,c]}},function(t,e,i){var n=t(408),r=t(243),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="TMSTileSource"},e.prototype.get_image_url=function(t,e,i){var n=this.string_lookup_replace(this.url,this.extra_url_vars);return n.replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",i.toString())},e}(r.MercatorTileSource);i.TMSTileSource=o,o.initClass()},function(t,e,i){var n=t(408),r=t(243),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="WMTSTileSource"},e.prototype.get_image_url=function(t,e,i){var n=this.string_lookup_replace(this.url,this.extra_url_vars),r=this.tms_to_wmts(t,e,i),o=r[0],s=r[1],a=r[2];return n.replace("{X}",o.toString()).replace("{Y}",s.toString()).replace("{Z}",a.toString())},e}(r.MercatorTileSource);i.WMTSTileSource=o,o.initClass()},function(t,e,i){var n=t(408),r=t(259),o=t(22),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._clicked=function(){this.model.do.emit()},e}(r.ButtonToolButtonView);i.ActionToolButtonView=s;var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.do,function(){return e.doit()})},e}(r.ButtonToolView);i.ActionToolView=a;var l=function(t){function e(e){var i=t.call(this,e)||this;return i.button_view=s,i.do=new o.Signal0(i,"do"),i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ActionTool"},e}(r.ButtonTool);i.ActionTool=l,l.initClass()},function(t,e,i){var n=t(408),r=t(250),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-toolbar-button-custom-action")},e}(r.ActionToolButtonView);i.CustomActionButtonView=s;var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},e}(r.ActionToolView);i.CustomActionView=a;var l=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Custom Action",i.button_view=s,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CustomAction",this.prototype.default_view=a,this.define({action_tooltip:[o.String,"Perform a Custom Action"],callback:[o.Any],icon:[o.String]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.action_tooltip},enumerable:!0,configurable:!0}),e}(r.ActionTool);i.CustomAction=l,l.initClass()},function(t,e,i){var n=t(408),r=t(250),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){window.open(this.model.redirect)},e}(r.ActionToolView);i.HelpToolView=s;var a=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Help",i.icon="bk-tool-icon-help",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="HelpTool",this.prototype.default_view=s,this.define({help_tooltip:[o.String,"Click the question mark to learn more about Bokeh plot tools."],redirect:[o.String,"https://bokeh.pydata.org/en/latest/docs/user_guide/tools.html#built-in-tools"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.help_tooltip},enumerable:!0,configurable:!0}),e}(r.ActionTool);i.HelpTool=a,a.initClass()},function(t,e,i){var n=t(408),r=t(250),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,function(){return e.model.disabled=!e.plot_view.can_redo()})},e.prototype.doit=function(){this.plot_view.redo()},e}(r.ActionToolView);i.RedoToolView=o;var s=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Redo",i.icon="bk-tool-icon-redo",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="RedoTool",this.prototype.default_view=o,this.override({disabled:!0})},e}(r.ActionTool);i.RedoTool=s,s.initClass()},function(t,e,i){var n=t(408),r=t(250),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){this.plot_view.reset()},e}(r.ActionToolView);i.ResetToolView=o;var s=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Reset",i.icon="bk-tool-icon-reset",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ResetTool",this.prototype.default_view=o},e}(r.ActionTool);i.ResetTool=s,s.initClass()},function(t,e,i){var n=t(408),r=t(250),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){this.plot_view.save("bokeh_plot")},e}(r.ActionToolView);i.SaveToolView=o;var s=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Save",i.icon="bk-tool-icon-save",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="SaveTool",this.prototype.default_view=o},e}(r.ActionTool);i.SaveTool=s,s.initClass()},function(t,e,i){var n=t(408),r=t(250),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,function(){return e.model.disabled=!e.plot_view.can_undo()})},e.prototype.doit=function(){this.plot_view.undo()},e}(r.ActionToolView);i.UndoToolView=o;var s=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Undo",i.icon="bk-tool-icon-undo",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="UndoTool",this.prototype.default_view=o,this.override({disabled:!0})},e}(r.ActionTool);i.UndoTool=s,s.initClass()},function(t,e,i){var n=t(408),r=t(250),o=t(48),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){var t=this.plot_view.frame,e=this.model.dimensions,i="width"==e||"both"==e,n="height"==e||"both"==e,r=o.scale_range(t,this.model.factor,i,n);this.plot_view.push_state("zoom_out",{range:r}),this.plot_view.update_range(r,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)},e}(r.ActionToolView);i.ZoomInToolView=a;var l=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Zoom In",i.icon="bk-tool-icon-zoom-in",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ZoomInTool",this.prototype.default_view=a,this.define({factor:[s.Percent,.1],dimensions:[s.Dimensions,"both"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e}(r.ActionTool);i.ZoomInTool=l,l.initClass()},function(t,e,i){var n=t(408),r=t(250),o=t(48),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){var t=this.plot_view.frame,e=this.model.dimensions,i="width"==e||"both"==e,n="height"==e||"both"==e,r=o.scale_range(t,-this.model.factor,i,n);this.plot_view.push_state("zoom_out",{range:r}),this.plot_view.update_range(r,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)},e}(r.ActionToolView);i.ZoomOutToolView=a;var l=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Zoom Out",i.icon="bk-tool-icon-zoom-out",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ZoomOutTool",this.prototype.default_view=a,this.define({factor:[s.Percent,.1],dimensions:[s.Dimensions,"both"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e}(r.ActionTool);i.ZoomOutTool=l,l.initClass()},function(t,e,i){var n=t(408),r=t(6),o=t(284),s=t(5),a=t(18),l=t(40),h=t(46),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.change,function(){return e.render()}),this.el.addEventListener("click",function(){return e._clicked()}),this.render()},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-toolbar-button")},e.prototype.render=function(){s.empty(this.el);var t=this.model.computed_icon;h.isString(t)&&(l.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip},e}(r.DOMView);i.ButtonToolButtonView=u;var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(o.ToolView);i.ButtonToolView=c;var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ButtonTool",this.internal({disabled:[a.Boolean,!1]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),e}(o.Tool);i.ButtonTool=_,_.initClass()},function(t,e,i){var n=t(408),r=t(5),o=t(18),s=t(261),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._tap=function(t){if(null==this._draw_basepoint&&null==this._basepoint){var e=t.shiftKey;this._select_event(t,e,this.model.renderers)}},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];if(t.keyCode===r.Keys.Backspace)this._delete_selected(n);else if(t.keyCode==r.Keys.Esc){var o=n.data_source;o.selection_manager.clear()}}},e.prototype._set_extent=function(t,e,i,n){var r=t[0],o=t[1],s=e[0],a=e[1];void 0===n&&(n=!1);var l=this.model.renderers[0],h=this.plot_view.frame,u=l.glyph,c=l.data_source,_=h.xscales[l.x_range_name],p=h.yscales[l.y_range_name],d=_.r_invert(r,o),f=d[0],v=d[1],m=p.r_invert(s,a),g=m[0],y=m[1],b=[(f+v)/2,(g+y)/2],x=b[0],w=b[1],k=[v-f,y-g],T=k[0],C=k[1],S=[u.x.field,u.y.field],A=S[0],M=S[1],E=[u.width.field,u.height.field],z=E[0],O=E[1];if(i)this._pop_glyphs(c,this.model.num_objects),A&&c.get_array(A).push(x),M&&c.get_array(M).push(w),z&&c.get_array(z).push(T),O&&c.get_array(O).push(C),this._pad_empty_columns(c,[A,M,z,O]);else{var P=c.data[A].length-1;A&&(c.data[A][P]=x),M&&(c.data[M][P]=w),z&&(c.data[z][P]=T),O&&(c.data[O][P]=C)}this._emit_cds_changes(c,!0,!1,n)},e.prototype._update_box=function(t,e,i){if(void 0===e&&(e=!1),void 0===i&&(i=!1),null!=this._draw_basepoint){var n=[t.sx,t.sy],r=this.plot_view.frame,o=this.model.dimensions,s=this.model._get_dim_limits(this._draw_basepoint,n,r,o);if(null!=s){var a=s[0],l=s[1];this._set_extent(a,l,e,i)}}},e.prototype._doubletap=function(t){this.model.active&&(null!=this._draw_basepoint?(this._update_box(t,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[t.sx,t.sy],this._select_event(t,!0,this.model.renderers),this._update_box(t,!0,!1)))},e.prototype._move=function(t){this._update_box(t,!1,!1)},e.prototype._pan_start=function(t){if(t.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[t.sx,t.sy],this._update_box(t,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy]}},e.prototype._pan=function(t,e,i){if(void 0===e&&(e=!1),void 0===i&&(i=!1),t.shiftKey){if(null==this._draw_basepoint)return;this._update_box(t,e,i)}else{if(null==this._basepoint)return;this._drag_points(t,this.model.renderers)}},e.prototype._pan_end=function(t){if(this._pan(t,!1,!0),t.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];this._emit_cds_changes(n.data_source,!1,!0,!0)}}},e}(s.EditToolView);i.BoxEditToolView=a;var l=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Box Edit Tool",i.icon="bk-tool-icon-box-edit",i.event_type=["tap","pan","move"],i.default_order=1,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="BoxEditTool",this.prototype.default_view=a,this.define({dimensions:[o.Dimensions,"both"],num_objects:[o.Int,0]})},e}(s.EditTool);i.BoxEditTool=l,l.initClass()},function(t,e,i){var n=t(408),r=t(18),o=t(24),s=t(46),a=t(269),l=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._mouse_in_frame=!0,e}return n.__extends(e,t),e.prototype._move_enter=function(t){this._mouse_in_frame=!0},e.prototype._move_exit=function(t){this._mouse_in_frame=!1},e.prototype._map_drag=function(t,e,i){var n=this.plot_view.frame;if(!n.bbox.contains(t,e))return null;var r=n.xscales[i.x_range_name].invert(t),o=n.yscales[i.y_range_name].invert(e);return[r,o]},e.prototype._delete_selected=function(t){var e=t.data_source,i=e.selected.indices;i.sort();for(var n=0,r=e.columns();n<r.length;n++)for(var o=r[n],s=e.get_array(o),a=0;a<i.length;a++){var l=i[a];s.splice(l-a,1)}this._emit_cds_changes(e)},e.prototype._pop_glyphs=function(t,e){var i=t.columns();if(e&&i.length)for(var n=0,r=i;n<r.length;n++){var o=r[n],a=t.get_array(o),l=a.length-e+1;l<1||(s.isArray(a)||(a=Array.from(a),t.data[o]=a),a.splice(0,l))}},e.prototype._emit_cds_changes=function(t,e,i,n){void 0===e&&(e=!0),void 0===i&&(i=!0),void 0===n&&(n=!0),i&&t.selection_manager.clear(),e&&t.change.emit(),n&&(t.data=t.data,t.properties.data.change.emit())},e.prototype._drag_points=function(t,e){if(null!=this._basepoint){for(var i=this._basepoint,n=i[0],r=i[1],o=0,s=e;o<s.length;o++){var a=s[o],l=this._map_drag(n,r,a),h=this._map_drag(t.sx,t.sy,a);if(null!=h&&null!=l){for(var u=h[0],c=h[1],_=l[0],p=l[1],d=[u-_,c-p],f=d[0],v=d[1],m=a.glyph,g=a.data_source,y=[m.x.field,m.y.field],b=y[0],x=y[1],w=0,k=g.selected.indices;w<k.length;w++){var T=k[w];b&&(g.data[b][T]+=f),x&&(g.data[x][T]+=v)}g.change.emit()}}this._basepoint=[t.sx,t.sy]}},e.prototype._pad_empty_columns=function(t,e){for(var i=0,n=t.columns();i<n.length;i++){var r=n[i];o.includes(e,r)||t.get_array(r).push(this.model.empty_value)}},e.prototype._select_event=function(t,e,i){var n=this.plot_view.frame,r=t.sx,o=t.sy;if(!n.bbox.contains(r,o))return[];for(var s={type:"point",sx:r,sy:o},a=[],l=0,h=i;l<h.length;l++){var u=h[l],c=u.get_selection_manager(),_=u.data_source,p=[this.plot_view.renderer_views[u.id]],d=c.select(p,s,!0,e);d&&a.push(u),_.properties.selected.change.emit()}return a},e}(a.GestureToolView);i.EditToolView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="EditTool",this.define({custom_icon:[r.String],custom_tooltip:[r.String],empty_value:[r.Any],renderers:[r.Array,[]]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.custom_tooltip||this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.custom_icon||this.icon},enumerable:!0,configurable:!0}),e}(a.GestureTool);i.EditTool=h,h.initClass()},function(t,e,i){var n=t(408),r=t(5),o=t(18),s=t(46),a=t(261),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._draw=function(t,e,i){if(void 0===i&&(i=!1),this.model.active){var n=this.model.renderers[0],r=this._map_drag(t.sx,t.sy,n);if(null!=r){var o=r[0],a=r[1],l=n.data_source,h=n.glyph,u=[h.xs.field,h.ys.field],c=u[0],_=u[1];if("new"==e)this._pop_glyphs(l,this.model.num_objects),c&&l.get_array(c).push([o]),_&&l.get_array(_).push([a]),this._pad_empty_columns(l,[c,_]);else if("add"==e){if(c){var p=l.data[c].length-1,d=l.get_array(c)[p];s.isArray(d)||(d=Array.from(d),l.data[c][p]=d),d.push(o)}if(_){var f=l.data[_].length-1,v=l.get_array(_)[f];s.isArray(v)||(v=Array.from(v),l.data[_][f]=v),v.push(a)}}this._emit_cds_changes(l,!0,!0,i)}}},e.prototype._pan_start=function(t){this._draw(t,"new")},e.prototype._pan=function(t){this._draw(t,"add")},e.prototype._pan_end=function(t){this._draw(t,"add",!0)},e.prototype._tap=function(t){this._select_event(t,t.shiftKey,this.model.renderers)},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];t.keyCode===r.Keys.Esc?n.data_source.selection_manager.clear():t.keyCode===r.Keys.Backspace&&this._delete_selected(n)}},e}(a.EditToolView);i.FreehandDrawToolView=l;var h=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Freehand Draw Tool",i.icon="bk-tool-icon-freehand-draw",i.event_type=["pan","tap"],i.default_order=3,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="FreehandDrawTool",this.prototype.default_view=l,this.define({num_objects:[o.Int,0]})},e}(a.EditTool);i.FreehandDrawTool=h,h.initClass()},function(t,e,i){var n=t(408),r=t(5),o=t(18),s=t(261),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._tap=function(t){var e=t.shiftKey,i=this._select_event(t,e,this.model.renderers);if(!i.length&&this.model.add){var n=this.model.renderers[0],r=this._map_drag(t.sx,t.sy,n);if(null!=r){var o=n.glyph,s=n.data_source,a=[o.x.field,o.y.field],l=a[0],h=a[1],u=r[0],c=r[1];this._pop_glyphs(s,this.model.num_objects),l&&s.get_array(l).push(u),h&&s.get_array(h).push(c),this._pad_empty_columns(s,[l,h]),s.change.emit(),s.data=s.data,s.properties.data.change.emit()}}},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];t.keyCode===r.Keys.Backspace?this._delete_selected(n):t.keyCode==r.Keys.Esc&&n.data_source.selection_manager.clear()}},e.prototype._pan_start=function(t){this.model.drag&&(this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy])},e.prototype._pan=function(t){this.model.drag&&null!=this._basepoint&&this._drag_points(t,this.model.renderers)},e.prototype._pan_end=function(t){if(this.model.drag){this._pan(t);for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];this._emit_cds_changes(n.data_source,!1,!0,!0)}this._basepoint=null}},e}(s.EditToolView);i.PointDrawToolView=a;var l=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Point Draw Tool",i.icon="bk-tool-icon-point-draw",i.event_type=["tap","pan","move"],i.default_order=2,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="PointDrawTool",this.prototype.default_view=a,this.define({add:[o.Boolean,!0],drag:[o.Boolean,!0],num_objects:[o.Int,0]})},e}(s.EditTool);i.PointDrawTool=l,l.initClass()},function(t,e,i){var n=t(408),r=t(5),o=t(18),s=t(46),a=t(266),l=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._drawing=!1,e._initialized=!1,e}return n.__extends(e,t),e.prototype._tap=function(t){this._drawing?this._draw(t,"add",!0):this._select_event(t,t.shiftKey,this.model.renderers)},e.prototype._draw=function(t,e,i){void 0===i&&(i=!1);var n=this.model.renderers[0],r=this._map_drag(t.sx,t.sy,n);if(this._initialized||this.activate(),null!=r){var o=this._snap_to_vertex.apply(this,[t].concat(r)),a=o[0],l=o[1],h=n.data_source,u=n.glyph,c=[u.xs.field,u.ys.field],_=c[0],p=c[1];if("new"==e)this._pop_glyphs(h,this.model.num_objects),_&&h.get_array(_).push([a,a]),p&&h.get_array(p).push([l,l]),this._pad_empty_columns(h,[_,p]);else if("edit"==e){if(_){var d=h.data[_][h.data[_].length-1];d[d.length-1]=a}if(p){var f=h.data[p][h.data[p].length-1];f[f.length-1]=l}}else if("add"==e){if(_){var v=h.data[_].length-1,d=h.get_array(_)[v],m=d[d.length-1];d[d.length-1]=a,s.isArray(d)||(d=Array.from(d),h.data[_][v]=d),d.push(m)}if(p){var g=h.data[p].length-1,f=h.get_array(p)[g],y=f[f.length-1];f[f.length-1]=l,s.isArray(f)||(f=Array.from(f),h.data[p][g]=f),f.push(y)}}this._emit_cds_changes(h,!0,!1,i)}},e.prototype._show_vertices=function(){if(this.model.active){for(var t=[],e=[],i=0;i<this.model.renderers.length;i++){var n=this.model.renderers[i],r=n.data_source,o=n.glyph,s=[o.xs.field,o.ys.field],a=s[0],l=s[1];if(a)for(var h=0,u=r.get_array(a);h<u.length;h++){var c=u[h];Array.prototype.push.apply(t,c)}if(l)for(var _=0,p=r.get_array(l);_<p.length;_++){var c=p[_];Array.prototype.push.apply(e,c)}this._drawing&&i==this.model.renderers.length-1&&(t.splice(t.length-1,1),e.splice(e.length-1,1))}this._set_vertices(t,e)}},e.prototype._doubletap=function(t){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(t,"edit",!0)):(this._drawing=!0,this._draw(t,"new",!0)))},e.prototype._move=function(t){this._drawing&&this._draw(t,"edit")},e.prototype._remove=function(){var t=this.model.renderers[0],e=t.data_source,i=t.glyph,n=[i.xs.field,i.ys.field],r=n[0],o=n[1];if(r){var s=e.data[r].length-1,a=e.get_array(r)[s];a.splice(a.length-1,1)}if(o){var l=e.data[o].length-1,h=e.get_array(o)[l];h.splice(h.length-1,1)}this._emit_cds_changes(e)},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];t.keyCode===r.Keys.Backspace?this._delete_selected(n):t.keyCode==r.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),n.data_source.selection_manager.clear())}},e.prototype._pan_start=function(t){this.model.drag&&(this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy])},e.prototype._pan=function(t){if(null!=this._basepoint&&this.model.drag){for(var e=this._basepoint,i=e[0],n=e[1],r=0,o=this.model.renderers;r<o.length;r++){var s=o[r],a=this._map_drag(i,n,s),l=this._map_drag(t.sx,t.sy,s);if(null!=l&&null!=a){var h=s.data_source,u=s.glyph,c=[u.xs.field,u.ys.field],_=c[0],p=c[1];if(_||p){for(var d=l[0],f=l[1],v=a[0],m=a[1],g=[d-v,f-m],y=g[0],b=g[1],x=0,w=h.selected.indices;x<w.length;x++){var k=w[x],T=void 0,C=void 0,S=void 0;_&&(C=h.data[_][k]),p?(S=h.data[p][k],T=S.length):T=C.length;for(var A=0;A<T;A++)C&&(C[A]+=y),S&&(S[A]+=b)}h.change.emit()}}}this._basepoint=[t.sx,t.sy]}},e.prototype._pan_end=function(t){if(this.model.drag){this._pan(t);for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];this._emit_cds_changes(n.data_source)}this._basepoint=null}},e.prototype.activate=function(){var t=this;if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e],r=n.data_source;r.connect(r.properties.data.change,function(){return t._show_vertices()})}this._initialized=!0}},e.prototype.deactivate=function(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()},e}(a.PolyToolView);i.PolyDrawToolView=l;var h=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Polygon Draw Tool",i.icon="bk-tool-icon-poly-draw",i.event_type=["pan","tap","move"],i.default_order=3,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="PolyDrawTool",this.prototype.default_view=l,this.define({drag:[o.Boolean,!0],num_objects:[o.Int,0]})},e}(a.PolyTool);i.PolyDrawTool=h,h.initClass()},function(t,e,i){var n=t(408),r=t(5),o=t(46),s=t(266),a=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._drawing=!1,e}return n.__extends(e,t),e.prototype._doubletap=function(t){if(this.model.active){var e=this._map_drag(t.sx,t.sy,this.model.vertex_renderer);if(null!=e){var i=e[0],n=e[1],r=this._select_event(t,!1,[this.model.vertex_renderer]),o=this.model.vertex_renderer.data_source,s=this.model.vertex_renderer.glyph,a=[s.x.field,s.y.field],l=a[0],h=a[1];if(r.length&&null!=this._selected_renderer){var u=o.selected.indices[0];this._drawing?(this._drawing=!1,o.selection_manager.clear()):(o.selected.indices=[u+1],l&&o.get_array(l).splice(u+1,0,i),h&&o.get_array(h).splice(u+1,0,n),this._drawing=!0),o.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(t)}}},e.prototype._show_vertices=function(t){if(this.model.active){var e=this._select_event(t,!1,this.model.renderers);if(!e.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);var i,n,r=e[0],s=r.glyph,a=r.data_source,l=a.selected.indices[0],h=[s.xs.field,s.ys.field],u=h[0],c=h[1];u?(i=a.data[u][l],o.isArray(i)||(a.data[u][l]=i=Array.from(i))):i=s.xs.value,c?(n=a.data[c][l],o.isArray(n)||(a.data[c][l]=n=Array.from(n))):n=s.ys.value,this._selected_renderer=r,this._set_vertices(i,n)}},e.prototype._move=function(t){var e;if(this._drawing&&null!=this._selected_renderer){var i=this.model.vertex_renderer,n=i.data_source,r=i.glyph,o=this._map_drag(t.sx,t.sy,i);if(null==o)return;var s=o[0],a=o[1],l=n.selected.indices;e=this._snap_to_vertex(t,s,a),s=e[0],a=e[1],n.selected.indices=l;var h=[r.x.field,r.y.field],u=h[0],c=h[1],_=l[0];u&&(n.data[u][_]=s),c&&(n.data[c][_]=a),n.change.emit(),this._selected_renderer.data_source.change.emit()}},e.prototype._tap=function(t){var e,i=this.model.vertex_renderer,n=this._map_drag(t.sx,t.sy,i);if(null!=n){if(this._drawing&&this._selected_renderer){var r=n[0],o=n[1],s=i.data_source,a=i.glyph,l=[a.x.field,a.y.field],h=l[0],u=l[1],c=s.selected.indices;e=this._snap_to_vertex(t,r,o),r=e[0],o=e[1];var _=c[0];if(s.selected.indices=[_+1],h){var p=s.get_array(h),d=p[_];p[_]=r,p.splice(_+1,0,d)}if(u){var f=s.get_array(u),v=f[_];f[_]=o,f.splice(_+1,0,v)}return s.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}var m=t.shiftKey;this._select_event(t,m,[i]),this._select_event(t,m,this.model.renderers)}},e.prototype._remove_vertex=function(){if(this._drawing&&this._selected_renderer){var t=this.model.vertex_renderer,e=t.data_source,i=t.glyph,n=e.selected.indices[0],r=[i.x.field,i.y.field],o=r[0],s=r[1];o&&e.get_array(o).splice(n,1),s&&e.get_array(s).splice(n,1),e.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}},e.prototype._pan_start=function(t){this._select_event(t,!0,[this.model.vertex_renderer]),this._basepoint=[t.sx,t.sy]},e.prototype._pan=function(t){null!=this._basepoint&&(this._drag_points(t,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},e.prototype._pan_end=function(t){null!=this._basepoint&&(this._drag_points(t,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame){var e;e=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(var i=0,n=e;i<n.length;i++){var o=n[i];t.keyCode===r.Keys.Backspace?(this._delete_selected(o),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):t.keyCode==r.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),o.data_source.selection_manager.clear())}}},e.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())},e}(s.PolyToolView);i.PolyEditToolView=a;var l=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Poly Edit Tool",i.icon="bk-tool-icon-poly-edit",i.event_type=["tap","pan","move"],i.default_order=4,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="PolyEditTool",this.prototype.default_view=a},e}(s.PolyTool);i.PolyEditTool=l,l.initClass()},function(t,e,i){var n=t(408),r=t(18),o=t(46),s=t(261),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._set_vertices=function(t,e){var i=this.model.vertex_renderer.glyph,n=this.model.vertex_renderer.data_source,r=[i.x.field,i.y.field],s=r[0],a=r[1];s&&(o.isArray(t)?n.data[s]=t:i.x={value:t}),a&&(o.isArray(e)?n.data[a]=e:i.y={value:e}),this._emit_cds_changes(n,!0,!0,!1)},e.prototype._hide_vertices=function(){this._set_vertices([],[])},e.prototype._snap_to_vertex=function(t,e,i){if(this.model.vertex_renderer){var n=this._select_event(t,!1,[this.model.vertex_renderer]),r=this.model.vertex_renderer.data_source,o=this.model.vertex_renderer.glyph,s=[o.x.field,o.y.field],a=s[0],l=s[1];if(n.length){var h=r.selected.indices[0];a&&(e=r.data[a][h]),l&&(i=r.data[l][h]),r.selection_manager.clear()}}return[e,i]},e}(s.EditToolView);i.PolyToolView=a;var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="PolyTool",this.prototype.default_view=a,this.define({vertex_renderer:[r.Instance]})},e}(s.EditTool);i.PolyTool=l,l.initClass()},function(t,e,i){var n=t(408),r=t(274),o=t(67),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._compute_limits=function(t){var e=this.plot_view.frame,i=this.model.dimensions,n=this._base_point;if("center"==this.model.origin){var r=n[0],o=n[1],s=t[0],a=t[1];n=[r-(s-r),o-(a-o)]}return this.model._get_dim_limits(n,t,e,i)},e.prototype._pan_start=function(t){var e=t.sx,i=t.sy;this._base_point=[e,i]},e.prototype._pan=function(t){var e=t.sx,i=t.sy,n=[e,i],r=this._compute_limits(n),o=r[0],s=r[1];if(this.model.overlay.update({left:o[0],right:o[1],top:s[0],bottom:s[1]}),this.model.select_every_mousemove){var a=t.shiftKey;this._do_select(o,s,!1,a)}},e.prototype._pan_end=function(t){var e=t.sx,i=t.sy,n=[e,i],r=this._compute_limits(n),o=r[0],s=r[1],a=t.shiftKey;this._do_select(o,s,!0,a),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})},e.prototype._do_select=function(t,e,i,n){var r=t[0],o=t[1],s=e[0],a=e[1];void 0===n&&(n=!1);var l={type:"rect",sx0:r,sx1:o,sy0:s,sy1:a};this._select(l,i,n)},e.prototype._emit_callback=function(t){var e=this.computed_renderers[0],i=this.plot_view.frame,r=i.xscales[e.x_range_name],o=i.yscales[e.y_range_name],s=t.sx0,a=t.sx1,l=t.sy0,h=t.sy1,u=r.r_invert(s,a),c=u[0],_=u[1],p=o.r_invert(l,h),d=p[0],f=p[1],v=n.__assign({x0:c,y0:d,x1:_,y1:f},t);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:v})},e}(r.SelectToolView);i.BoxSelectToolView=a;var l=function(){return new o.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},h=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Box Select",i.icon="bk-tool-icon-box-select",i.event_type="pan",i.default_order=30,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="BoxSelectTool",this.prototype.default_view=a,this.define({dimensions:[s.Dimensions,"both"],select_every_mousemove:[s.Boolean,!1],callback:[s.Any],overlay:[s.Instance,l],origin:[s.BoxOrigin,"corner"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e}(r.SelectTool);i.BoxSelectTool=h,h.initClass()},function(t,e,i){var n=t(408),r=t(269),o=t(67),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._match_aspect=function(t,e,i){var n,r,o,s,a=i.bbox.aspect,l=i.bbox.h_range.end,h=i.bbox.h_range.start,u=i.bbox.v_range.end,c=i.bbox.v_range.start,_=Math.abs(t[0]-e[0]),p=Math.abs(t[1]-e[1]),d=0==p?0:_/p,f=(d>=a?[1,d/a]:[a/d,1])[0];return t[0]<=e[0]?(n=t[0],(r=t[0]+_*f)>l&&(r=l)):(r=t[0],(n=t[0]-_*f)<h&&(n=h)),_=Math.abs(r-n),t[1]<=e[1]?(s=t[1],(o=t[1]+_/a)>u&&(o=u)):(o=t[1],(s=t[1]-_/a)<c&&(s=c)),p=Math.abs(o-s),t[0]<=e[0]?r=t[0]+a*p:n=t[0]-a*p,[[n,r],[s,o]]},e.prototype._compute_limits=function(t){var e,i,n,r,o=this.plot_view.frame,s=this.model.dimensions,a=this._base_point;if("center"==this.model.origin){var l=a[0],h=a[1],u=t[0],c=t[1];a=[l-(u-l),h-(c-h)]}return this.model.match_aspect&&"both"==s?(e=this._match_aspect(a,t,o),n=e[0],r=e[1]):(i=this.model._get_dim_limits(a,t,o,s),n=i[0],r=i[1]),[n,r]},e.prototype._pan_start=function(t){this._base_point=[t.sx,t.sy]},e.prototype._pan=function(t){var e=[t.sx,t.sy],i=this._compute_limits(e),n=i[0],r=i[1];this.model.overlay.update({left:n[0],right:n[1],top:r[0],bottom:r[1]})},e.prototype._pan_end=function(t){var e=[t.sx,t.sy],i=this._compute_limits(e),n=i[0],r=i[1];this._update(n,r),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null},e.prototype._update=function(t,e){var i=t[0],n=t[1],r=e[0],o=e[1];if(!(Math.abs(n-i)<=5||Math.abs(o-r)<=5)){var s=this.plot_view.frame,a=s.xscales,l=s.yscales,h={};for(var u in a){var c=a[u],_=c.r_invert(i,n),p=_[0],d=_[1];h[u]={start:p,end:d}}var f={};for(var v in l){var c=l[v],m=c.r_invert(r,o),p=m[0],d=m[1];f[v]={start:p,end:d}}var g={xrs:h,yrs:f};this.plot_view.push_state("box_zoom",{range:g}),this.plot_view.update_range(g)}},e}(r.GestureToolView);i.BoxZoomToolView=a;var l=function(){return new o.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},h=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Box Zoom",i.icon="bk-tool-icon-box-zoom",i.event_type="pan",i.default_order=20,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="BoxZoomTool",this.prototype.default_view=a,this.define({dimensions:[s.Dimensions,"both"],overlay:[s.Instance,l],match_aspect:[s.Boolean,!1],origin:[s.BoxOrigin,"corner"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e}(r.GestureTool);i.BoxZoomTool=h,h.initClass()},function(t,e,i){var n=t(408),r=t(259),o=t(283),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.ButtonToolView);i.GestureToolView=s;var a=function(t){function e(e){var i=t.call(this,e)||this;return i.button_view=o.OnOffButtonView,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="GestureTool"},e}(r.ButtonTool);i.GestureTool=a,a.initClass()},function(t,e,i){var n=t(408),r=t(274),o=t(74),s=t(5),a=t(18),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data=null},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){return e._active_change()})},e.prototype._active_change=function(){this.model.active||this._clear_overlay()},e.prototype._keyup=function(t){t.keyCode==s.Keys.Enter&&this._clear_overlay()},e.prototype._pan_start=function(t){var e=t.sx,i=t.sy;this.data={sx:[e],sy:[i]}},e.prototype._pan=function(t){var e=t.sx,i=t.sy,n=this.plot_view.frame.bbox.clip(e,i),r=n[0],o=n[1];this.data.sx.push(r),this.data.sy.push(o);var s=this.model.overlay;if(s.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove){var a=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!1,a)}},e.prototype._pan_end=function(t){this._clear_overlay();var e=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,e),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})},e.prototype._clear_overlay=function(){this.model.overlay.update({xs:[],ys:[]})},e.prototype._do_select=function(t,e,i,n){var r={type:"poly",sx:t,sy:e};this._select(r,i,n)},e.prototype._emit_callback=function(t){var e=this.computed_renderers[0],i=this.plot_view.frame,r=i.xscales[e.x_range_name],o=i.yscales[e.y_range_name],s=r.v_invert(t.sx),a=o.v_invert(t.sy),l=n.__assign({x:s,y:a},t);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:l})},e}(r.SelectToolView);i.LassoSelectToolView=l;var h=function(){return new o.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},u=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Lasso Select",i.icon="bk-tool-icon-lasso-select",i.event_type="pan",i.default_order=12,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LassoSelectTool",this.prototype.default_view=l,this.define({select_every_mousemove:[a.Boolean,!0],callback:[a.Any],overlay:[a.Instance,h]})},e}(r.SelectTool);i.LassoSelectTool=u,u.initClass()},function(t,e,i){var n=t(408),r=t(269),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=t.sx,i=t.sy,n=this.plot_view.frame.bbox;if(!n.contains(e,i)){var r=n.h_range,o=n.v_range;(e<r.start||e>r.end)&&(this.v_axis_only=!0),(i<o.start||i>o.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},e.prototype._pan=function(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},e.prototype._pan_end=function(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})},e.prototype._update=function(t,e){var i,n,r,o,s,a,l=this.plot_view.frame,h=t-this.last_dx,u=e-this.last_dy,c=l.bbox.h_range,_=c.start-h,p=c.end-h,d=l.bbox.v_range,f=d.start-u,v=d.end-u,m=this.model.dimensions;"width"!=m&&"both"!=m||this.v_axis_only?(i=c.start,n=c.end,r=0):(i=_,n=p,r=-h),"height"!=m&&"both"!=m||this.h_axis_only?(o=d.start,s=d.end,a=0):(o=f,s=v,a=-u),this.last_dx=t,this.last_dy=e;var g=l.xscales,y=l.yscales,b={};for(var x in g){var w=g[x],k=w.r_invert(i,n),T=k[0],C=k[1];b[x]={start:T,end:C}}var S={};for(var A in y){var w=y[A],M=w.r_invert(o,s),T=M[0],C=M[1];S[A]={start:T,end:C}}this.pan_info={xrs:b,yrs:S,sdx:r,sdy:a},this.plot_view.update_range(this.pan_info,!0)},e}(r.GestureToolView);i.PanToolView=s;var a=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Pan",i.event_type="pan",i.default_order=10,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="PanTool",this.prototype.default_view=s,this.define({dimensions:[o.Dimensions,"both"]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Pan",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"icon",{get:function(){switch(this.dimensions){case"both":return"bk-tool-icon-pan";case"width":return"bk-tool-icon-xpan";case"height":return"bk-tool-icon-ypan"}},enumerable:!0,configurable:!0}),e}(r.GestureTool);i.PanTool=a,a.initClass()},function(t,e,i){var n=t(408),r=t(274),o=t(74),s=t(5),a=t(18),l=t(24),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data={sx:[],sy:[]}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){return e._active_change()})},e.prototype._active_change=function(){this.model.active||this._clear_data()},e.prototype._keyup=function(t){t.keyCode==s.Keys.Enter&&this._clear_data()},e.prototype._doubletap=function(t){var e=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,e),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()},e.prototype._clear_data=function(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})},e.prototype._tap=function(t){var e=t.sx,i=t.sy,n=this.plot_view.frame;n.bbox.contains(e,i)&&(this.data.sx.push(e),this.data.sy.push(i),this.model.overlay.update({xs:l.copy(this.data.sx),ys:l.copy(this.data.sy)}))},e.prototype._do_select=function(t,e,i,n){var r={type:"poly",sx:t,sy:e};this._select(r,i,n)},e.prototype._emit_callback=function(t){var e=this.computed_renderers[0],i=this.plot_view.frame,r=i.xscales[e.x_range_name],o=i.yscales[e.y_range_name],s=r.v_invert(t.sx),a=o.v_invert(t.sy),l=n.__assign({x:s,y:a},t);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:l})},e}(r.SelectToolView);i.PolySelectToolView=h;var u=function(){return new o.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},c=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Poly Select",i.icon="bk-tool-icon-polygon-select",i.event_type="tap",i.default_order=11,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="PolySelectTool",this.prototype.default_view=h,this.define({callback:[a.Any],overlay:[a.Instance,u]})},e}(r.SelectTool);i.PolySelectTool=c,c.initClass()},function(t,e,i){var n=t(408),r=t(67),o=t(17),s=t(18),a=t(269);function l(t){switch(t){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return t}}function h(t,e,i,n){if(null==e)return!1;var r=i.compute(e);return Math.abs(t-r)<n}function u(t,e,i,n,r){var o=!0;if(null!=r.left&&null!=r.right){var s=i.invert(t);(s<r.left||s>r.right)&&(o=!1)}if(null!=r.bottom&&null!=r.top){var a=n.invert(e);(a<r.bottom||a>r.top)&&(o=!1)}return o}function c(t,e,i){var n=0;return t>=i.start&&t<=i.end&&(n+=1),e>=i.start&&e<=i.end&&(n+=1),n}function _(t,e,i,n){var r=e.compute(t),o=e.invert(r+i);return o>=n.start&&o<=n.end?o:t}function p(t,e,i){return t>e.start?(e.end=t,i):(e.end=e.start,e.start=t,l(i))}function d(t,e,i){return t<e.end?(e.start=t,i):(e.start=e.end,e.end=t,l(i))}function f(t,e,i,n){var r=e.r_compute(t.start,t.end),o=r[0],s=r[1],a=e.r_invert(o+i,s+i),l=a[0],h=a[1],u=c(t.start,t.end,n),_=c(l,h,n);_>=u&&(t.start=l,t.end=h)}i.flip_side=l,i.is_near=h,i.is_inside=u,i.sides_inside=c,i.compute_value=_,i.compute_end_side=p,i.compute_start_side=d,i.update_range=f;var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.side=0,this.model.update_overlay_from_ranges()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),null!=this.model.x_range&&this.connect(this.model.x_range.change,function(){return e.model.update_overlay_from_ranges()}),null!=this.model.y_range&&this.connect(this.model.y_range.change,function(){return e.model.update_overlay_from_ranges()})},e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=this.model.x_range,i=this.model.y_range,n=this.plot_view.frame,o=n.xscales.default,s=n.yscales.default,a=this.model.overlay,l=a.left,c=a.right,_=a.top,p=a.bottom,d=this.model.overlay.properties.line_width.value()+r.EDGE_TOLERANCE;null!=e&&this.model.x_interaction&&(h(t.sx,l,o,d)?this.side=1:h(t.sx,c,o,d)?this.side=2:u(t.sx,t.sy,o,s,a)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&h(t.sy,p,s,d)&&(this.side=4),0==this.side&&h(t.sy,_,s,d)?this.side=5:u(t.sx,t.sy,o,s,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))},e.prototype._pan=function(t){var e=this.plot_view.frame,i=t.deltaX-this.last_dx,n=t.deltaY-this.last_dy,r=this.model.x_range,o=this.model.y_range,s=e.xscales.default,a=e.yscales.default;if(null!=r)if(3==this.side||7==this.side)f(r,s,i,e.x_range);else if(1==this.side){var l=_(r.start,s,i,e.x_range);this.side=d(l,r,this.side)}else if(2==this.side){var h=_(r.end,s,i,e.x_range);this.side=p(h,r,this.side)}if(null!=o)if(6==this.side||7==this.side)f(o,a,n,e.y_range);else if(4==this.side){o.start=_(o.start,a,n,e.y_range);var l=_(o.start,a,n,e.y_range);this.side=d(l,o,this.side)}else if(5==this.side){o.end=_(o.end,a,n,e.y_range);var h=_(o.end,a,n,e.y_range);this.side=p(h,o,this.side)}this.last_dx=t.deltaX,this.last_dy=t.deltaY},e.prototype._pan_end=function(t){this.side=0},e}(a.GestureToolView);i.RangeToolView=v;var m=function(){return new r.BoxAnnotation({level:"overlay",render_mode:"canvas",fill_color:"lightgrey",fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:.5},line_dash:[2,2]})},g=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Range Tool",i.icon="bk-tool-icon-range",i.event_type="pan",i.default_order=1,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="RangeTool",this.prototype.default_view=v,this.define({x_range:[s.Instance,null],x_interaction:[s.Boolean,!0],y_range:[s.Instance,null],y_interaction:[s.Boolean,!0],overlay:[s.Instance,m]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null},e.prototype.update_overlay_from_ranges=function(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,o.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)},e}(a.GestureTool);i.RangeTool=g,g.initClass()},function(t,e,i){var n=t(408),r=t(269),o=t(197),s=t(198),a=t(289),l=t(18),h=t(5),u=t(3),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"computed_renderers",{get:function(){var t=this.model.renderers,e=this.plot_model.renderers,i=this.model.names;return a.compute_renderers(t,e,i)},enumerable:!0,configurable:!0}),e.prototype._computed_renderers_by_data_source=function(){for(var t={},e=0,i=this.computed_renderers;e<i.length;e++){var n=i[e],r=void 0;if(n instanceof o.GlyphRenderer)r=n.data_source.id;else{if(!(n instanceof s.GraphRenderer))continue;r=n.node_renderer.data_source.id}r in t||(t[r]=[]),t[r].push(n)}return t},e.prototype._keyup=function(t){if(t.keyCode==h.Keys.Esc){for(var e=0,i=this.computed_renderers;e<i.length;e++){var n=i[e];n.get_selection_manager().clear()}this.plot_view.request_render()}},e.prototype._select=function(t,e,i){var n=this._computed_renderers_by_data_source();for(var r in n){for(var o=n[r],s=o[0].get_selection_manager(),a=[],l=0,h=o;l<h.length;l++){var u=h[l];u.id in this.plot_view.renderer_views&&a.push(this.plot_view.renderer_views[u.id])}s.select(a,t,e,i)}null!=this.model.callback&&this._emit_callback(t),this._emit_selection_event(t,e)},e.prototype._emit_selection_event=function(t,e){void 0===e&&(e=!0);var i,r=this.plot_view.frame,o=r.xscales.default,s=r.yscales.default;switch(t.type){case"point":var a=t.sx,l=t.sy,h=o.invert(a),c=s.invert(l);i=n.__assign({},t,{x:h,y:c});break;case"rect":var _=t.sx0,p=t.sx1,d=t.sy0,f=t.sy1,v=o.r_invert(_,p),m=v[0],g=v[1],y=s.r_invert(d,f),b=y[0],x=y[1];i=n.__assign({},t,{x0:m,y0:b,x1:g,y1:x});break;case"poly":var a=t.sx,l=t.sy,h=o.v_invert(a),c=s.v_invert(l);i=n.__assign({},t,{x:h,y:c});break;default:throw new Error("Unrecognized selection geometry type: '"+t.type+"'")}this.plot_model.trigger_event(new u.SelectionGeometry(i,e))},e}(r.GestureToolView);i.SelectToolView=c;var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="SelectTool",this.define({renderers:[l.Any,"auto"],names:[l.Array,[]]})},e}(r.GestureTool);i.SelectTool=_,_.initClass()},function(t,e,i){var n=t(408),r=t(274),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._tap=function(t){var e=t.sx,i=t.sy,n={type:"point",sx:e,sy:i},r=t.shiftKey;this._select(n,!0,r)},e.prototype._select=function(t,e,i){var r=this,o=this.model.callback;if("select"==this.model.behavior){var s=this._computed_renderers_by_data_source();for(var a in s){var l=s[a],h=l[0].get_selection_manager(),u=l.map(function(t){return r.plot_view.renderer_views[t.id]}),c=h.select(u,t,e,i);if(c&&null!=o){var _=this.plot_view.frame,p=_.xscales[l[0].x_range_name],d=_.yscales[l[0].y_range_name],f=p.invert(t.sx),v=d.invert(t.sy),m={geometries:n.__assign({},t,{x:f,y:v}),source:h.source};o.execute(this.model,m)}}this._emit_selection_event(t),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else for(var g=0,y=this.computed_renderers;g<y.length;g++){var b=y[g],h=b.get_selection_manager(),c=h.inspect(this.plot_view.renderer_views[b.id],t);if(c&&null!=o){var _=this.plot_view.frame,p=_.xscales[b.x_range_name],d=_.yscales[b.y_range_name],f=p.invert(t.sx),v=d.invert(t.sy),m={geometries:n.__assign({},t,{x:f,y:v}),source:h.source};o.execute(this.model,m)}}},e}(r.SelectToolView);i.TapToolView=s;var a=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Tap",i.icon="bk-tool-icon-tap-select",i.event_type="tap",i.default_order=10,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="TapTool",this.prototype.default_view=s,this.define({behavior:[o.TapBehavior,"select"],callback:[o.Any]})},e}(r.SelectTool);i.TapTool=a,a.initClass()},function(t,e,i){var n=t(408),r=t(269),o=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._scroll=function(t){var e=this.model.speed*t.delta;e>.9?e=.9:e<-.9&&(e=-.9),this._update_ranges(e)},e.prototype._update_ranges=function(t){var e,i,n,r,o=this.plot_view.frame,s=o.bbox.h_range,a=o.bbox.v_range,l=[s.start,s.end],h=l[0],u=l[1],c=[a.start,a.end],_=c[0],p=c[1];switch(this.model.dimension){case"height":var d=Math.abs(p-_);e=h,i=u,n=_-d*t,r=p-d*t;break;case"width":var f=Math.abs(u-h);e=h-f*t,i=u-f*t,n=_,r=p;break;default:throw new Error("this shouldn't have happened")}var v=o.xscales,m=o.yscales,g={};for(var y in v){var b=v[y],x=b.r_invert(e,i),w=x[0],k=x[1];g[y]={start:w,end:k}}var T={};for(var C in m){var b=m[C],S=b.r_invert(n,r),w=S[0],k=S[1];T[C]={start:w,end:k}}var A={xrs:g,yrs:T,factor:t};this.plot_view.push_state("wheel_pan",{range:A}),this.plot_view.update_range(A,!1,!0),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},e}(r.GestureToolView);i.WheelPanToolView=s;var a=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Wheel Pan",i.icon="bk-tool-icon-wheel-pan",i.event_type="scroll",i.default_order=12,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="WheelPanTool",this.prototype.default_view=s,this.define({dimension:[o.Dimension,"width"]}),this.internal({speed:[o.Number,.001]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimension)},enumerable:!0,configurable:!0}),e}(r.GestureTool);i.WheelPanTool=a,a.initClass()},function(t,e,i){var n=t(408),r=t(269),o=t(48),s=t(18),a=t(31),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._pinch=function(t){var e,i=t.sx,n=t.sy,r=t.scale;e=r>=1?20*(r-1):-20/r,this._scroll({type:"wheel",sx:i,sy:n,delta:e})},e.prototype._scroll=function(t){var e=this.plot_view.frame,i=e.bbox.h_range,n=e.bbox.v_range,r=t.sx,s=t.sy,a=this.model.dimensions,l=("width"==a||"both"==a)&&i.start<r&&r<i.end,h=("height"==a||"both"==a)&&n.start<s&&s<n.end;if(l&&h||this.model.zoom_on_axis){var u=this.model.speed*t.delta,c=o.scale_range(e,u,l,h,{x:r,y:s});this.plot_view.push_state("wheel_zoom",{range:c}),this.plot_view.update_range(c,!1,!0,this.model.maintain_focus),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}},e}(r.GestureToolView);i.WheelZoomToolView=l;var h=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Wheel Zoom",i.icon="bk-tool-icon-wheel-zoom",i.event_type=a.is_mobile?"pinch":"scroll",i.default_order=10,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="WheelZoomTool",this.prototype.default_view=l,this.define({dimensions:[s.Dimensions,"both"],maintain_focus:[s.Boolean,!0],zoom_on_axis:[s.Boolean,!0],speed:[s.Number,1/600]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e}(r.GestureTool);i.WheelZoomTool=h,h.initClass()},function(t,e,i){var n=t(250);i.ActionTool=n.ActionTool;var r=t(251);i.CustomAction=r.CustomAction;var o=t(252);i.HelpTool=o.HelpTool;var s=t(253);i.RedoTool=s.RedoTool;var a=t(254);i.ResetTool=a.ResetTool;var l=t(255);i.SaveTool=l.SaveTool;var h=t(256);i.UndoTool=h.UndoTool;var u=t(257);i.ZoomInTool=u.ZoomInTool;var c=t(258);i.ZoomOutTool=c.ZoomOutTool;var _=t(259);i.ButtonTool=_.ButtonTool;var p=t(261);i.EditTool=p.EditTool;var d=t(260);i.BoxEditTool=d.BoxEditTool;var f=t(262);i.FreehandDrawTool=f.FreehandDrawTool;var v=t(263);i.PointDrawTool=v.PointDrawTool;var m=t(264);i.PolyDrawTool=m.PolyDrawTool;var g=t(266);i.PolyTool=g.PolyTool;var y=t(265);i.PolyEditTool=y.PolyEditTool;var b=t(267);i.BoxSelectTool=b.BoxSelectTool;var x=t(268);i.BoxZoomTool=x.BoxZoomTool;var w=t(269);i.GestureTool=w.GestureTool;var k=t(270);i.LassoSelectTool=k.LassoSelectTool;var T=t(271);i.PanTool=T.PanTool;var C=t(272);i.PolySelectTool=C.PolySelectTool;var S=t(273);i.RangeTool=S.RangeTool;var A=t(274);i.SelectTool=A.SelectTool;var M=t(275);i.TapTool=M.TapTool;var E=t(276);i.WheelPanTool=E.WheelPanTool;var z=t(277);i.WheelZoomTool=z.WheelZoomTool;var O=t(279);i.CrosshairTool=O.CrosshairTool;var P=t(280);i.CustomJSHover=P.CustomJSHover;var j=t(281);i.HoverTool=j.HoverTool;var N=t(282);i.InspectTool=N.InspectTool;var D=t(284);i.Tool=D.Tool;var F=t(285);i.ToolProxy=F.ToolProxy;var B=t(286);i.Toolbar=B.Toolbar;var R=t(287);i.ToolbarBase=R.ToolbarBase;var I=t(288);i.ProxyToolbar=I.ProxyToolbar;var L=t(288);i.ToolbarBox=L.ToolbarBox},function(t,e,i){var n=t(408),r=t(282),o=t(76),s=t(18),a=t(35),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._move=function(t){if(this.model.active){var e=t.sx,i=t.sy;this.plot_view.frame.bbox.contains(e,i)?this._update_spans(e,i):this._update_spans(null,null)}},e.prototype._move_exit=function(t){this._update_spans(null,null)},e.prototype._update_spans=function(t,e){var i=this.model.dimensions;"width"!=i&&"both"!=i||(this.model.spans.width.computed_location=e),"height"!=i&&"both"!=i||(this.model.spans.height.computed_location=t)},e}(r.InspectToolView);i.CrosshairToolView=l;var h=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Crosshair",i.icon="bk-tool-icon-crosshair",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="CrosshairTool",this.prototype.default_view=l,this.define({dimensions:[s.Dimensions,"both"],line_color:[s.Color,"black"],line_width:[s.Number,1],line_alpha:[s.Number,1]}),this.internal({location_units:[s.SpatialUnits,"screen"],render_mode:[s.RenderMode,"css"],spans:[s.Any]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Crosshair",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return a.values(this.spans)},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.spans={width:new o.Span({for_hover:!0,dimension:"width",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha}),height:new o.Span({for_hover:!0,dimension:"height",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha})}},e}(r.InspectTool);i.CrosshairTool=h,h.initClass()},function(t,e,i){var n=t(408),r=t(62),o=t(18),s=t(35),a=t(40),l=function(e){function r(t){return e.call(this,t)||this}return n.__extends(r,e),r.initClass=function(){this.prototype.type="CustomJSHover",this.define({args:[o.Any,{}],code:[o.String,""]})},Object.defineProperty(r.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),r.prototype._make_code=function(t,e,i,n){return new(Function.bind.apply(Function,[void 0].concat(s.keys(this.args),[t,e,i,"require","exports",a.use_strict(n)])))},r.prototype.format=function(e,n,r){var o=this._make_code("value","format","special_vars",this.code);return o.apply(void 0,this.values.concat([e,n,r,t,i]))},r}(r.Model);i.CustomJSHover=l,l.initClass()},function(t,e,i){var n=t(408),r=t(282),o=t(80),s=t(197),a=t(198),l=t(289),h=t(9),u=t(42),c=t(5),_=t(18),p=t(30),d=t(35),f=t(46),v=t(4);function m(t,e,i,n,r,o){var s,a,l={x:r[t],y:o[t]},u={x:r[t+1],y:o[t+1]};if("span"==e.type)"h"==e.direction?(s=Math.abs(l.x-i),a=Math.abs(u.x-i)):(s=Math.abs(l.y-n),a=Math.abs(u.y-n));else{var c={x:i,y:n};s=h.dist_2_pts(l,c),a=h.dist_2_pts(u,c)}return s<a?[[l.x,l.y],t]:[[u.x,u.y],t+1]}function g(t,e,i){return[[t[i],e[i]],i]}i._nearest_line_hit=m,i._line_hit=g;var y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.ttviews={}},e.prototype.remove=function(){v.remove_views(this.ttviews),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);for(var i=0,n=this.computed_renderers;i<n.length;i++){var r=n[i];r instanceof s.GlyphRenderer?this.connect(r.data_source.inspect,this._update):r instanceof a.GraphRenderer&&(this.connect(r.node_renderer.data_source.inspect,this._update),this.connect(r.edge_renderer.data_source.inspect,this._update))}this.connect(this.model.properties.renderers.change,function(){return e._computed_renderers=e._ttmodels=null}),this.connect(this.model.properties.names.change,function(){return e._computed_renderers=e._ttmodels=null}),this.connect(this.model.properties.tooltips.change,function(){return e._ttmodels=null})},e.prototype._compute_ttmodels=function(){var t={},e=this.model.tooltips;if(null!=e)for(var i=0,n=this.computed_renderers;i<n.length;i++){var r=n[i];if(r instanceof s.GlyphRenderer){var l=new o.Tooltip({custom:f.isString(e)||f.isFunction(e),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t[r.id]=l}else if(r instanceof a.GraphRenderer){var l=new o.Tooltip({custom:f.isString(e)||f.isFunction(e),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t[r.node_renderer.id]=l,t[r.edge_renderer.id]=l}}return v.build_views(this.ttviews,d.values(t),{parent:this.plot_view}),t},Object.defineProperty(e.prototype,"computed_renderers",{get:function(){if(null==this._computed_renderers){var t=this.model.renderers,e=this.plot_model.renderers,i=this.model.names;this._computed_renderers=l.compute_renderers(t,e,i)}return this._computed_renderers},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"ttmodels",{get:function(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels},enumerable:!0,configurable:!0}),e.prototype._clear=function(){for(var t in this._inspect(1/0,1/0),this.ttmodels){var e=this.ttmodels[t];e.clear()}},e.prototype._move=function(t){if(this.model.active){var e=t.sx,i=t.sy;this.plot_view.frame.bbox.contains(e,i)?this._inspect(e,i):this._clear()}},e.prototype._move_exit=function(){this._clear()},e.prototype._inspect=function(t,e){var i;if("mouse"==this.model.mode)i={type:"point",sx:t,sy:e};else{var n="vline"==this.model.mode?"h":"v";i={type:"span",direction:n,sx:t,sy:e}}for(var r=0,o=this.computed_renderers;r<o.length;r++){var s=o[r],a=s.get_selection_manager();a.inspect(this.plot_view.renderer_views[s.id],i)}null!=this.model.callback&&this._emit_callback(i)},e.prototype._update=function(t){var e,i,n,r,o,l,h,u,c,_,p,f,v,y,b,x,w=t[0],k=t[1].geometry;if(this.model.active&&(w instanceof s.GlyphRendererView||w instanceof a.GraphRendererView)){var T=w.model,C=this.ttmodels[T.id];if(null!=C){C.clear();var S=T.get_selection_manager(),A=S.inspectors[T.id];if(T instanceof s.GlyphRenderer&&(A=T.view.convert_selection_to_subset(A)),!A.is_empty()){for(var M=S.source,E=this.plot_view.frame,z=k.sx,O=k.sy,P=E.xscales[T.x_range_name],j=E.yscales[T.y_range_name],N=P.invert(z),D=j.invert(O),F=w.glyph,B=0,R=A.line_indices;B<R.length;B++){var I=R[B],L=F._x[I+1],V=F._y[I+1],G=I,U=void 0,Y=void 0;switch(this.model.line_policy){case"interp":e=F.get_interpolation_hit(I,k),L=e[0],V=e[1],U=P.compute(L),Y=j.compute(V);break;case"prev":i=g(F.sx,F.sy,I),n=i[0],U=n[0],Y=n[1],G=i[1];break;case"next":r=g(F.sx,F.sy,I+1),o=r[0],U=o[0],Y=o[1],G=r[1];break;case"nearest":l=m(I,k,z,O,F.sx,F.sy),h=l[0],U=h[0],Y=h[1],G=l[1],L=F._x[G],V=F._y[G];break;default:U=(u=[z,O])[0],Y=u[1]}var q={index:G,x:N,y:D,sx:z,sy:O,data_x:L,data_y:V,rx:U,ry:Y,indices:A.line_indices,name:w.model.name};C.add(U,Y,this._render_tooltips(M,G,q))}for(var X=0,H=A.image_indices;X<H.length;X++){var W=H[X],q={index:W.index,x:N,y:D,sx:z,sy:O},J=this._render_tooltips(M,W,q);C.add(z,O,J)}for(var K=0,$=A.indices;K<$.length;K++){var I=$[K];if(d.isEmpty(A.multiline_indices)){var L=null!=F._x?F._x[I]:void 0,V=null!=F._y?F._y[I]:void 0,U=void 0,Y=void 0;if("snap_to_data"==this.model.point_policy){var Z=F.get_anchor_point(this.model.anchor,I,[z,O]);null==Z&&(Z=F.get_anchor_point("center",I,[z,O])),U=Z.x,Y=Z.y}else U=(x=[z,O])[0],Y=x[1];var Q=void 0,q={index:Q=T instanceof s.GlyphRenderer?T.view.convert_indices_from_subset([I])[0]:I,x:N,y:D,sx:z,sy:O,data_x:L,data_y:V,indices:A.indices,name:w.model.name};C.add(U,Y,this._render_tooltips(M,Q,q))}else for(var tt=0,et=A.multiline_indices[I.toString()];tt<et.length;tt++){var it=et[tt],L=F._xs[I][it],V=F._ys[I][it],nt=it,U=void 0,Y=void 0;switch(this.model.line_policy){case"interp":c=F.get_interpolation_hit(I,it,k),L=c[0],V=c[1],U=P.compute(L),Y=j.compute(V);break;case"prev":_=g(F.sxs[I],F.sys[I],it),p=_[0],U=p[0],Y=p[1],nt=_[1];break;case"next":f=g(F.sxs[I],F.sys[I],it+1),v=f[0],U=v[0],Y=v[1],nt=f[1];break;case"nearest":y=m(it,k,z,O,F.sxs[I],F.sys[I]),b=y[0],U=b[0],Y=b[1],nt=y[1],L=F._xs[I][nt],V=F._ys[I][nt];break;default:throw new Error("should't have happened")}var Q=void 0,q={index:Q=T instanceof s.GlyphRenderer?T.view.convert_indices_from_subset([I])[0]:I,x:N,y:D,sx:z,sy:O,data_x:L,data_y:V,segment_index:nt,indices:A.multiline_indices,name:w.model.name};C.add(U,Y,this._render_tooltips(M,Q,q))}}}}}},e.prototype._emit_callback=function(t){for(var e=0,i=this.computed_renderers;e<i.length;e++){var r=i[e],o=r.data_source.inspected,s=this.plot_view.frame,a=s.xscales[r.x_range_name],l=s.yscales[r.y_range_name],h=a.invert(t.sx),u=l.invert(t.sy),c=n.__assign({x:h,y:u},t);this.model.callback.execute(this.model,{index:o,geometry:c,renderer:r})}},e.prototype._render_tooltips=function(t,e,i){var n=this.model.tooltips;if(f.isString(n)){var r=c.div();return r.innerHTML=u.replace_placeholders(n,t,e,this.model.formatters,i),r}if(f.isFunction(n))return n(t,i);for(var o=c.div({style:{display:"table",borderSpacing:"2px"}}),s=0,a=n;s<a.length;s++){var l=a[s],h=l[0],_=l[1],d=c.div({style:{display:"table-row"}});o.appendChild(d);var v=void 0;if(v=c.div({style:{display:"table-cell"},class:"bk-tooltip-row-label"},0!=h.length?h+": ":""),d.appendChild(v),v=c.div({style:{display:"table-cell"},class:"bk-tooltip-row-value"}),d.appendChild(v),_.indexOf("$color")>=0){var m=_.match(/\$color(\[.*\])?:(\w*)/),g=m[1],y=void 0===g?"":g,b=m[2],x=t.get_column(b);if(null==x){var w=c.span({},b+" unknown");v.appendChild(w);continue}var k=y.indexOf("hex")>=0,T=y.indexOf("swatch")>=0,C=f.isNumber(e)?x[e]:null;if(null==C){var S=c.span({},"(null)");v.appendChild(S);continue}k&&(C=p.color2hex(C));var r=c.span({},C);v.appendChild(r),T&&(r=c.span({class:"bk-tooltip-color-block",style:{backgroundColor:C}}," "),v.appendChild(r))}else{var r=c.span();r.innerHTML=u.replace_placeholders(_.replace("$~","$data_"),t,e,this.model.formatters,i),v.appendChild(r)}}return o},e}(r.InspectToolView);i.HoverToolView=y;var b=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Hover",i.icon="bk-tool-icon-hover",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="HoverTool",this.prototype.default_view=y,this.define({tooltips:[_.Any,[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[_.Any,{}],renderers:[_.Any,"auto"],names:[_.Array,[]],mode:[_.HoverMode,"mouse"],point_policy:[_.PointPolicy,"snap_to_data"],line_policy:[_.LinePolicy,"nearest"],show_arrow:[_.Boolean,!0],anchor:[_.Anchor,"center"],attachment:[_.TooltipAttachment,"horizontal"],callback:[_.Any]})},e}(r.InspectTool);i.HoverTool=b,b.initClass()},function(t,e,i){var n=t(408),r=t(259),o=t(283),s=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.ButtonToolView);i.InspectToolView=a;var l=function(t){function e(e){var i=t.call(this,e)||this;return i.event_type="move",i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="InspectTool",this.prototype.button_view=o.OnOffButtonView,this.define({toggleable:[s.Boolean,!0]}),this.override({active:!0})},e}(r.ButtonTool);i.InspectTool=l,l.initClass()},function(t,e,i){var n=t(408),r=t(259),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.model.active?this.el.classList.add("bk-active"):this.el.classList.remove("bk-active")},e.prototype._clicked=function(){var t=this.model.active;this.model.active=!t},e}(r.ButtonToolButtonView);i.OnOffButtonView=o},function(t,e,i){var n=t(408),r=t(18),o=t(50),s=t(24),a=t(62),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!0,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){e.model.active?e.activate():e.deactivate()})},e.prototype.activate=function(){},e.prototype.deactivate=function(){},e}(o.View);i.ToolView=l;var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Tool",this.internal({active:[r.Boolean,!1]})},Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._get_dim_tooltip=function(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}},e.prototype._get_dim_limits=function(t,e,i,n){var r,o=t[0],a=t[1],l=e[0],h=e[1],u=i.bbox.h_range;"width"==n||"both"==n?(r=[s.min([o,l]),s.max([o,l])],r=[s.max([r[0],u.start]),s.min([r[1],u.end])]):r=[u.start,u.end];var c,_=i.bbox.v_range;return"height"==n||"both"==n?(c=[s.min([a,h]),s.max([a,h])],c=[s.max([c[0],_.start]),s.min([c[1],_.end])]):c=[_.start,_.end],[r,c]},e}(a.Model);i.Tool=h,h.initClass()},function(t,e,i){var n=t(408),r=t(18),o=t(22),s=t(62),a=t(282),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ToolProxy",this.define({tools:[r.Array,[]],active:[r.Boolean,!1],disabled:[r.Boolean,!1]})},Object.defineProperty(e.prototype,"button_view",{get:function(){return this.tools[0].button_view},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"event_type",{get:function(){return this.tools[0].event_type},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tools[0].tooltip},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"tool_name",{get:function(){return this.tools[0].tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"icon",{get:function(){return this.tools[0].computed_icon},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"toggleable",{get:function(){var t=this.tools[0];return t instanceof a.InspectTool&&t.toggleable},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.do=new o.Signal0(this,"do")},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.do,function(){return e.doit()}),this.connect(this.properties.active.change,function(){return e.set_active()})},e.prototype.doit=function(){for(var t=0,e=this.tools;t<e.length;t++){var i=e[t];i.do.emit()}},e.prototype.set_active=function(){for(var t=0,e=this.tools;t<e.length;t++){var i=e[t];i.active=this.active}},e}(s.Model);i.ToolProxy=l,l.initClass()},function(t,e,i){var n=t(408),r=t(18),o=t(17),s=t(46),a=t(24),l=t(250),h=t(252),u=t(269),c=t(282),_=t(287),p=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Toolbar",this.prototype.default_view=_.ToolbarBaseView,this.define({active_drag:[r.Any,"auto"],active_inspect:[r.Any,"auto"],active_scroll:[r.Any,"auto"],active_tap:[r.Any,"auto"],active_multi:[r.Any,null]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_tools()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.tools.change,function(){return e._init_tools()})},e.prototype._init_tools=function(){for(var t=this,e=function(t){if(t instanceof c.InspectTool)a.some(i.inspectors,function(e){return e.id==t.id})||(i.inspectors=i.inspectors.concat([t]));else if(t instanceof h.HelpTool)a.some(i.help,function(e){return e.id==t.id})||(i.help=i.help.concat([t]));else if(t instanceof l.ActionTool)a.some(i.actions,function(e){return e.id==t.id})||(i.actions=i.actions.concat([t]));else if(t instanceof u.GestureTool){var e=void 0,n=void 0;s.isString(t.event_type)?(e=[t.event_type],n=!1):(e=t.event_type||[],n=!0);for(var r=0,_=e;r<_.length;r++){var p=_[r];p in i.gestures?(n&&(p="multi"),a.some(i.gestures[p].tools,function(e){return e.id==t.id})||(i.gestures[p].tools=i.gestures[p].tools.concat([t])),i.connect(t.properties.active.change,i._active_change.bind(i,t))):o.logger.warn("Toolbar: unknown event type '"+p+"' for tool: "+t.type+" ("+t.id+")")}}},i=this,n=0,r=this.tools;n<r.length;n++){var _=r[n];e(_)}if("auto"==this.active_inspect);else if(this.active_inspect instanceof c.InspectTool)for(var p=0,d=this.inspectors;p<d.length;p++){var f=d[p];f!=this.active_inspect&&(f.active=!1)}else if(s.isArray(this.active_inspect))for(var v=0,m=this.inspectors;v<m.length;v++){var f=m[v];a.includes(this.active_inspect,f)||(f.active=!1)}else if(null==this.active_inspect)for(var g=0,y=this.inspectors;g<y.length;g++){var f=y[g];f.active=!1}var b=function(e){e.active?t._active_change(e):e.active=!0};for(var x in this.gestures){var w=this.gestures[x];if(0!=w.tools.length){if(w.tools=a.sort_by(w.tools,function(t){return t.default_order}),"tap"==x){if(null==this.active_tap)continue;"auto"==this.active_tap?b(w.tools[0]):b(this.active_tap)}if("pan"==x){if(null==this.active_drag)continue;"auto"==this.active_drag?b(w.tools[0]):b(this.active_drag)}if("pinch"==x||"scroll"==x){if(null==this.active_scroll||"auto"==this.active_scroll)continue;b(this.active_scroll)}null!=this.active_multi&&b(this.active_multi)}}},e}(_.ToolbarBase);i.Toolbar=p,p.initClass()},function(t,e,i){var n=t(408),r=t(17),o=t(5),s=t(4),a=t(18),l=t(6),h=t(46),u=t(62),c=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ToolbarBase",this.define({_visible:[a.Any,null],autohide:[a.Boolean,!1]})},Object.defineProperty(e.prototype,"visible",{get:function(){return!this.autohide||null!=this._visible&&this._visible},enumerable:!0,configurable:!0}),e}(u.Model);i.ToolbarViewModel=c,c.initClass();var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._tool_button_views={},this._build_tool_button_views(),this._toolbar_view_model=new c({autohide:this.model.autohide})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tools.change,function(){return e._build_tool_button_views()}),this.connect(this.model.properties.autohide.change,function(){e._toolbar_view_model.autohide=e.model.autohide,e._on_visible_change()}),this.connect(this._toolbar_view_model.properties._visible.change,function(){return e._on_visible_change()})},e.prototype.remove=function(){s.remove_views(this._tool_button_views),t.prototype.remove.call(this)},e.prototype._build_tool_button_views=function(){var t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;s.build_views(this._tool_button_views,t,{parent:this},function(t){return t.button_view})},e.prototype.set_visibility=function(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)},e.prototype._on_visible_change=function(){var t=this._toolbar_view_model.visible;this.el.classList.contains("bk-toolbar-hidden")&&t?this.el.classList.remove("bk-toolbar-hidden"):t||this.el.classList.add("bk-toolbar-hidden")},e.prototype.render=function(){var t=this;if(o.empty(this.el),this.el.classList.add("bk-toolbar"),this.el.classList.add("bk-toolbar-"+this.model.toolbar_location),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){var e="grey"===this.model.logo?"bk-grey":null,i=o.a({href:"https://bokeh.pydata.org/",target:"_blank",class:["bk-logo","bk-logo-small",e]});this.el.appendChild(i)}var n=[],r=function(e){return t._tool_button_views[e.id].el},s=this.model.gestures;for(var a in s)n.push(s[a].tools.map(r));n.push(this.model.actions.map(r)),n.push(this.model.inspectors.filter(function(t){return t.toggleable}).map(r)),n.push(this.model.help.map(r));for(var l=0,h=n;l<h.length;l++){var u=h[l];if(0!==u.length){var c=o.div({class:"bk-button-bar"},u);this.el.appendChild(c)}}},e.prototype.update_layout=function(){},e.prototype.update_position=function(){},e.prototype.after_layout=function(){this._has_finished=!0},e}(l.DOMView);i.ToolbarBaseView=_;var p=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ToolbarBase",this.prototype.default_view=_,this.define({tools:[a.Array,[]],logo:[a.Logo,"normal"],autohide:[a.Boolean,!1]}),this.internal({gestures:[a.Any,function(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}],actions:[a.Array,[]],inspectors:[a.Array,[]],help:[a.Array,[]],toolbar_location:[a.Location,"right"]})},Object.defineProperty(e.prototype,"horizontal",{get:function(){return"above"===this.toolbar_location||"below"===this.toolbar_location},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"vertical",{get:function(){return"left"===this.toolbar_location||"right"===this.toolbar_location},enumerable:!0,configurable:!0}),e.prototype._active_change=function(t){var e=t.event_type;if(null!=e)for(var i=h.isString(e)?[e]:e,n=0,o=i;n<o.length;n++){var s=o[n];if(t.active){var a=this.gestures[s].active;null!=a&&t!=a&&(r.logger.debug("Toolbar: deactivating tool: "+a.type+" ("+a.id+") for event type '"+s+"'"),a.active=!1),this.gestures[s].active=t,r.logger.debug("Toolbar: activating tool: "+t.type+" ("+t.id+") for event type '"+s+"'")}else this.gestures[s].active=null}},e}(u.Model);i.ToolbarBase=p,p.initClass()},function(t,e,i){var n=t(408),r=t(18),o=t(17),s=t(46),a=t(24),l=t(250),h=t(252),u=t(269),c=t(282),_=t(287),p=t(285),d=t(166),f=t(13),v=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ProxyToolbar"},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_tools(),this._merge_tools()},e.prototype._init_tools=function(){for(var t=function(t){if(t instanceof c.InspectTool)a.some(e.inspectors,function(e){return e.id==t.id})||(e.inspectors=e.inspectors.concat([t]));else if(t instanceof h.HelpTool)a.some(e.help,function(e){return e.id==t.id})||(e.help=e.help.concat([t]));else if(t instanceof l.ActionTool)a.some(e.actions,function(e){return e.id==t.id})||(e.actions=e.actions.concat([t]));else if(t instanceof u.GestureTool){var i=void 0,n=void 0;s.isString(t.event_type)?(i=[t.event_type],n=!1):(i=t.event_type||[],n=!0);for(var r=0,_=i;r<_.length;r++){var p=_[r];p in e.gestures?(n&&(p="multi"),a.some(e.gestures[p].tools,function(e){return e.id==t.id})||(e.gestures[p].tools=e.gestures[p].tools.concat([t]))):o.logger.warn("Toolbar: unknown event type '"+p+"' for tool: "+t.type+" ("+t.id+")")}}},e=this,i=0,n=this.tools;i<n.length;i++){var r=n[i];t(r)}},e.prototype._merge_tools=function(){var t,e=this;this._proxied_tools=[];for(var i={},n={},r={},o=[],s=[],l=0,h=this.help;l<h.length;l++){var u=h[l];a.includes(s,u.redirect)||(o.push(u),s.push(u.redirect))}for(var c in(t=this._proxied_tools).push.apply(t,o),this.help=o,this.gestures){var _=this.gestures[c];c in r||(r[c]={});for(var d=0,f=_.tools;d<f.length;d++){var v=f[d];v.type in r[c]||(r[c][v.type]=[]),r[c][v.type].push(v)}}for(var m=0,g=this.inspectors;m<g.length;m++){var v=g[m];v.type in i||(i[v.type]=[]),i[v.type].push(v)}for(var y=0,b=this.actions;y<b.length;y++){var v=b[y];v.type in n||(n[v.type]=[]),n[v.type].push(v)}var x=function(t,i){void 0===i&&(i=!1);var n=new p.ToolProxy({tools:t,active:i});return e._proxied_tools.push(n),n};for(var c in r){var _=this.gestures[c];for(var w in _.tools=[],r[c]){var k=r[c][w];if(k.length>0)if("multi"==c)for(var T=0,C=k;T<C.length;T++){var v=C[T],S=x([v]);_.tools.push(S),this.connect(S.properties.active.change,this._active_change.bind(this,S))}else{var S=x(k);_.tools.push(S),this.connect(S.properties.active.change,this._active_change.bind(this,S))}}}for(var w in this.actions=[],n){var k=n[w];if("CustomAction"==w)for(var A=0,M=k;A<M.length;A++){var v=M[A];this.actions.push(x([v]))}else k.length>0&&this.actions.push(x(k))}for(var w in this.inspectors=[],i){var k=i[w];k.length>0&&this.inspectors.push(x(k,!0))}for(var E in this.gestures){var _=this.gestures[E];0!=_.tools.length&&(_.tools=a.sort_by(_.tools,function(t){return t.default_order}),"pinch"!=E&&"scroll"!=E&&"multi"!=E&&(_.tools[0].active=!0))}},e}(_.ToolbarBase);i.ProxyToolbar=v,v.initClass();var m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){this.model.toolbar.toolbar_location=this.model.toolbar_location,t.prototype.initialize.call(this)},Object.defineProperty(e.prototype,"child_models",{get:function(){return[this.model.toolbar]},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new f.ContentBox(this.child_views[0].el);var t=this.model.toolbar;t.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})},e}(d.LayoutDOMView);i.ToolbarBoxView=m;var g=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="ToolbarBox",this.prototype.default_view=m,this.define({toolbar:[r.Instance],toolbar_location:[r.Location,"right"]})},e}(d.LayoutDOM);i.ToolbarBox=g,g.initClass()},function(t,e,i){var n=t(24);i.compute_renderers=function(t,e,i){if(null==t)return[];var r="auto"==t?e:t;return i.length>0&&(r=r.filter(function(t){return n.includes(i,t.name)})),r}},function(t,e,i){var n=t(408),r=t(297),o=t(18),s=t(35),a=t(40),l=function(e){function i(t){return e.call(this,t)||this}return n.__extends(i,e),i.initClass=function(){this.prototype.type="CustomJSTransform",this.define({args:[o.Any,{}],func:[o.String,""],v_func:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(i.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),i.prototype._make_transform=function(t,e){var i=this.use_strict?a.use_strict(e):e;return new(Function.bind.apply(Function,[void 0].concat(this.names,[t,"require","exports",i])))},Object.defineProperty(i.prototype,"scalar_transform",{get:function(){return this._make_transform("x",this.func)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"vector_transform",{get:function(){return this._make_transform("xs",this.v_func)},enumerable:!0,configurable:!0}),i.prototype.compute=function(e){return this.scalar_transform.apply(this,this.values.concat([e,t,{}]))},i.prototype.v_compute=function(e){return this.vector_transform.apply(this,this.values.concat([e,t,{}]))},i}(r.Transform);i.CustomJSTransform=l,l.initClass()},function(t,e,i){var n=t(408),r=t(297),o=t(192),s=t(18),a=t(46),l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Dodge",this.define({value:[s.Number,0],range:[s.Instance]})},e.prototype.v_compute=function(t){var e;if(this.range instanceof o.FactorRange)e=this.range.v_synthetic(t);else{if(!a.isArrayableOf(t,a.isNumber))throw new Error("unexpected");e=t}for(var i=new Float64Array(e.length),n=0;n<e.length;n++){var r=e[n];i[n]=this._compute(r)}return i},e.prototype.compute=function(t){if(this.range instanceof o.FactorRange)return this._compute(this.range.synthetic(t));if(a.isNumber(t))return this._compute(t);throw new Error("unexpected")},e.prototype._compute=function(t){return t+this.value},e}(r.Transform);i.Dodge=l,l.initClass()},function(t,e,i){var n=t(290);i.CustomJSTransform=n.CustomJSTransform;var r=t(291);i.Dodge=r.Dodge;var o=t(293);i.Interpolator=o.Interpolator;var s=t(294);i.Jitter=s.Jitter;var a=t(295);i.LinearInterpolator=a.LinearInterpolator;var l=t(296);i.StepInterpolator=l.StepInterpolator;var h=t(297);i.Transform=h.Transform},function(t,e,i){var n=t(408),r=t(297),o=t(18),s=t(24),a=t(46),l=function(t){function e(e){var i=t.call(this,e)||this;return i._sorted_dirty=!0,i}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Interpolator",this.define({x:[o.Any],y:[o.Any],data:[o.Any],clip:[o.Boolean,!0]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,function(){return e._sorted_dirty=!0})},e.prototype.v_compute=function(t){for(var e=new Float64Array(t.length),i=0;i<t.length;i++){var n=t[i];e[i]=this.compute(n)}return e},e.prototype.sort=function(t){if(void 0===t&&(t=!1),this._sorted_dirty){var e,i;if(a.isString(this.x)&&a.isString(this.y)&&null!=this.data){var n=this.data.columns();if(!s.includes(n,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!s.includes(n,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),i=this.data.get_column(this.y)}else{if(!a.isArray(this.x)||!a.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,i=this.y}if(e.length!==i.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");var r=[];for(var o in e)r.push({x:e[o],y:i[o]});t?r.sort(function(t,e){return t.x>e.x?-1:t.x==e.x?0:1}):r.sort(function(t,e){return t.x<e.x?-1:t.x==e.x?0:1}),this._x_sorted=[],this._y_sorted=[];for(var l=0,h=r;l<h.length;l++){var u=h[l],c=u.x,_=u.y;this._x_sorted.push(c),this._y_sorted.push(_)}this._sorted_dirty=!1}},e}(r.Transform);i.Interpolator=l,l.initClass()},function(t,e,i){var n=t(408),r=t(297),o=t(192),s=t(46),a=t(18),l=t(34),h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Jitter",this.define({mean:[a.Number,0],width:[a.Number,1],distribution:[a.Distribution,"uniform"],range:[a.Instance]}),this.internal({previous_values:[a.Array]})},e.prototype.v_compute=function(t){if(null!=this.previous_values&&this.previous_values.length==t.length)return this.previous_values;var e;if(this.range instanceof o.FactorRange)e=this.range.v_synthetic(t);else{if(!s.isArrayableOf(t,s.isNumber))throw new Error("unexpected");e=t}for(var i=new Float64Array(e.length),n=0;n<e.length;n++){var r=e[n];i[n]=this._compute(r)}return this.previous_values=i,i},e.prototype.compute=function(t){if(this.range instanceof o.FactorRange)return this._compute(this.range.synthetic(t));if(s.isNumber(t))return this._compute(t);throw new Error("unexpected")},e.prototype._compute=function(t){switch(this.distribution){case"uniform":return t+this.mean+(l.random()-.5)*this.width;case"normal":return t+l.rnorm(this.mean,this.width)}},e}(r.Transform);i.Jitter=h,h.initClass()},function(t,e,i){var n=t(408),r=t(24),o=t(293),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="LinearInterpolator"},e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];var e=r.find_last_index(this._x_sorted,function(e){return e<t}),i=this._x_sorted[e],n=this._x_sorted[e+1],o=this._y_sorted[e],s=this._y_sorted[e+1];return o+(t-i)/(n-i)*(s-o)},e}(o.Interpolator);i.LinearInterpolator=s,s.initClass()},function(t,e,i){var n=t(408),r=t(293),o=t(18),s=t(24),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="StepInterpolator",this.define({mode:[o.StepMode,"after"]})},e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}var e;switch(this.mode){case"after":e=s.find_last_index(this._x_sorted,function(e){return t>=e});break;case"before":e=s.find_index(this._x_sorted,function(e){return t<=e});break;case"center":var i=this._x_sorted.map(function(e){return Math.abs(e-t)}),n=s.min(i);e=s.find_index(i,function(t){return n===t});break;default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN},e}(r.Interpolator);i.StepInterpolator=a,a.initClass()},function(t,e,i){var n=t(408),r=t(62),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="Transform"},e}(r.Model);i.Transform=o,o.initClass()},function(t,e,i){var n,r,o,s;"undefined"==typeof Map&&t(359),"undefined"==typeof WeakMap&&t(371),"undefined"==typeof Promise&&t(365).polyfill(),void 0===Math.log10&&(Math.log10=function(t){return Math.log(t)*Math.LOG10E}),void 0===Number.isInteger&&(Number.isInteger=function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t}),void 0===String.prototype.repeat&&(String.prototype.repeat=function(t){if(null==this)throw new TypeError("can't convert "+this+" to object");var e=""+this;if((t=+t)!=t&&(t=0),t<0)throw new RangeError("repeat count must be non-negative");if(t==1/0)throw new RangeError("repeat count must be less than infinity");if(t=Math.floor(t),0==e.length||0==t)return"";if(e.length*t>=1<<28)throw new RangeError("repeat count must not overflow maximum string size");for(var i="";1==(1&t)&&(i+=e),0!=(t>>>=1);)e+=e;return i}),void 0===Array.from&&(Array.from=(n=Object.prototype.toString,r=function(t){return"function"==typeof t||"[object Function]"===n.call(t)},o=Math.pow(2,53)-1,s=function(t){var e=function(t){var e=Number(t);return isNaN(e)?0:0!==e&&isFinite(e)?(e>0?1:-1)*Math.floor(Math.abs(e)):e}(t);return Math.min(Math.max(e,0),o)},function(t){var e=Object(t);if(null==t)throw new TypeError("Array.from requires an array-like object - not null or undefined");var i,n=arguments.length>1?arguments[1]:void 0;if(void 0!==n){if(!r(n))throw new TypeError("Array.from: when provided, the second argument must be a function");arguments.length>2&&(i=arguments[2])}for(var o=s(e.length),a=r(this)?Object(new this(o)):new Array(o),l=0
// 13. If IsConstructor(C) is true, then
;l<o;){var h=e[l];a[l]=n?void 0===i?n(h,l):n.call(i,h,l):h,l+=1}return a.length=o,a}))},function(t,e,i){var n=t(408);n.__exportStar(t(300),i),n.__exportStar(t(301),i)},function(t,e,i){var n=t(40),r=function(){function t(t,e,i){this.header=t,this.metadata=e,this.content=i,this.buffers=[]}return t.assemble=function(e,i,n){var r=JSON.parse(e),o=JSON.parse(i),s=JSON.parse(n);return new t(r,o,s)},t.prototype.assemble_buffer=function(t,e){var i=null!=this.header.num_buffers?this.header.num_buffers:0;if(i<=this.buffers.length)throw new Error("too many buffers received, expecting #{nb}");this.buffers.push([t,e])},t.create=function(e,i,n){void 0===n&&(n={});var r=t.create_header(e);return new t(r,i,n)},t.create_header=function(t){return{msgid:n.uniqueId(),msgtype:t}},t.prototype.complete=function(){return!(null==this.header||null==this.metadata||null==this.content||"num_buffers"in this.header&&this.buffers.length!==this.header.num_buffers)},t.prototype.send=function(t){var e=null!=this.header.num_buffers?this.header.num_buffers:0;if(e>0)throw new Error("BokehJS only supports receiving buffers, not sending");var i=JSON.stringify(this.header),n=JSON.stringify(this.metadata),r=JSON.stringify(this.content);t.send(i),t.send(n),t.send(r)},t.prototype.msgid=function(){return this.header.msgid},t.prototype.msgtype=function(){return this.header.msgtype},t.prototype.reqid=function(){return this.header.reqid},t.prototype.problem=function(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"},t}();i.Message=r},function(t,e,i){var n=t(300),r=function(){function t(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}return t.prototype.consume=function(t){this._current_consumer(t)},t.prototype._HEADER=function(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA},t.prototype._METADATA=function(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT},t.prototype._CONTENT=function(t){this._assume_text(t),this._fragments.push(t);var e=this._fragments.slice(0,3),i=e[0],r=e[1],o=e[2];this._partial=n.Message.assemble(i,r,o),this._check_complete()},t.prototype._BUFFER_HEADER=function(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD},t.prototype._BUFFER_PAYLOAD=function(t){this._assume_binary(t),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()},t.prototype._assume_text=function(t){if(t instanceof ArrayBuffer)throw new Error("Expected text fragment but received binary fragment")},t.prototype._assume_binary=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")},t.prototype._check_complete=function(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER},t}();i.Receiver=r},function(t,e,i){i.safely=function(t,e){void 0===e&&(e=!1);try{return t()}catch(t){if(function(t){var e=document.createElement("div");e.style.backgroundColor="#f2dede",e.style.border="1px solid #a94442",e.style.borderRadius="4px",e.style.display="inline-block",e.style.fontFamily="sans-serif",e.style.marginTop="5px",e.style.minWidth="200px",e.style.padding="5px 5px 5px 10px",e.classList.add("bokeh-error-box-into-flames");var i=document.createElement("span");i.style.backgroundColor="#a94442",i.style.borderRadius="0px 4px 0px 0px",i.style.color="white",i.style.cursor="pointer",i.style.cssFloat="right",i.style.fontSize="0.8em",i.style.margin="-6px -6px 0px 0px",i.style.padding="2px 5px 4px 5px",i.title="close",i.setAttribute("aria-label","close"),i.appendChild(document.createTextNode("x")),i.addEventListener("click",function(){return s.removeChild(e)});var n=document.createElement("h3");n.style.color="#a94442",n.style.margin="8px 0px 0px 0px",n.style.padding="0px",n.appendChild(document.createTextNode("Bokeh Error"));var r=document.createElement("pre");r.style.whiteSpace="unset",r.style.overflowX="auto";var o=t instanceof Error?t.message:t;r.appendChild(document.createTextNode(o)),e.appendChild(i),e.appendChild(n),e.appendChild(r);var s=document.getElementsByTagName("body")[0];s.insertBefore(e,s.firstChild)}(t),e)return;throw t}}},function(t,e,i){function n(){var t=document.getElementsByTagName("body")[0],e=document.getElementsByClassName("bokeh-test-div");1==e.length&&(t.removeChild(e[0]),delete e[0]);var i=document.createElement("div");i.classList.add("bokeh-test-div"),i.style.display="none",t.insertBefore(i,t.firstChild)}i.results={},i.init=function(){n()},i.record=function(t,e){i.results[t]=e,n()},i.count=function(t){null==i.results[t]&&(i.results[t]=0),i.results[t]+=1,n()},i.clear=function(){for(var t=0,e=Object.keys(i.results);t<e.length;t++){var r=e[t];delete i.results[r]}n()}},function(t,e,i){i.version="1.2.0"},function(t,e,i){!function(){"use strict";var t,i,n,r,o;function s(t,e){var i,n=Object.keys(e);for(i=0;i<n.length;i++)t=t.replace(new RegExp("\\{"+n[i]+"\\}","gi"),e[n[i]]);return t}function a(t){var e,i,n;if(!t)throw new Error("cannot create a random attribute name for an undefined object");e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz",i="";do{for(i="",n=0;n<12;n++)i+=e[Math.floor(Math.random()*e.length)]}while(t[i]);return i}function l(t){var e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return e[t]||e.alphabetic}o=function(t,e){var i,n,r,o={};for(t=t.split(","),e=e||10,i=0;i<t.length;i+=2)n="&"+t[i+1]+";",r=parseInt(t[i],e),o[n]="&#"+r+";";return o["\\xa0"]="&#160;",o}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),t={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}},(n=function(t,e){this.__root=t,this.__ctx=e}).prototype.addColorStop=function(t,e){var i,n=this.__ctx.__createElement("stop");n.setAttribute("offset",t),-1!==e.indexOf("rgba")?(i=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),n.setAttribute("stop-color",s("rgb({r},{g},{b})",{r:i[1],g:i[2],b:i[3]})),n.setAttribute("stop-opacity",i[4])):n.setAttribute("stop-color",e),this.__root.appendChild(n)},r=function(t,e){this.__root=t,this.__ctx=e},(i=function(t){var e,n={width:500,height:500,enableMirroring:!1};if(arguments.length>1?((e=n).width=arguments[0],e.height=arguments[1]):e=t||n,!(this instanceof i))return new i(e);this.width=e.width||n.width,this.height=e.height||n.height,this.enableMirroring=void 0!==e.enableMirroring?e.enableMirroring:n.enableMirroring,this.canvas=this,this.__document=e.document||document,e.ctx?this.__ctx=e.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[this.__getStyleState()],this.__groupStack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version",1.1),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.__root.setAttribute("width",this.width),this.__root.setAttribute("height",this.height),this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs),this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g"),this.__root.appendChild(this.__currentElement)}).prototype.__createElement=function(t,e,i){void 0===e&&(e={});var n,r,o=this.__document.createElementNS("http://www.w3.org/2000/svg",t),s=Object.keys(e);for(i&&(o.setAttribute("fill","none"),o.setAttribute("stroke","none")),n=0;n<s.length;n++)r=s[n],o.setAttribute(r,e[r]);return o},i.prototype.__setDefaultStyles=function(){var e,i,n=Object.keys(t);for(e=0;e<n.length;e++)this[i=n[e]]=t[i].canvas},i.prototype.__applyStyleState=function(t){var e,i,n=Object.keys(t);for(e=0;e<n.length;e++)this[i=n[e]]=t[i]},i.prototype.__getStyleState=function(){var e,i,n={},r=Object.keys(t);for(e=0;e<r.length;e++)i=r[e],n[i]=this[i];return n},i.prototype.__applyStyleToCurrentElement=function(e){var i=this.__currentElement,o=this.__currentElementsToStyle;o&&(i.setAttribute(e,""),i=o.element,o.children.forEach(function(t){t.setAttribute(e,"")}));var a,l,h,u,c,_=Object.keys(t);for(a=0;a<_.length;a++)if(l=t[_[a]],h=this[_[a]],l.apply)if(h instanceof r){if(h.__ctx)for(;h.__ctx.__defs.childNodes.length;)u=h.__ctx.__defs.childNodes[0].getAttribute("id"),this.__ids[u]=u,this.__defs.appendChild(h.__ctx.__defs.childNodes[0]);i.setAttribute(l.apply,s("url(#{id})",{id:h.__root.getAttribute("id")}))}else if(h instanceof n)i.setAttribute(l.apply,s("url(#{id})",{id:h.__root.getAttribute("id")}));else if(-1!==l.apply.indexOf(e)&&l.svg!==h)if("stroke"!==l.svgAttr&&"fill"!==l.svgAttr||-1===h.indexOf("rgba")){var p=l.svgAttr;if("globalAlpha"===_[a]&&(p=e+"-"+l.svgAttr,i.getAttribute(p)))continue;i.setAttribute(p,h)}else{c=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(h),i.setAttribute(l.svgAttr,s("rgb({r},{g},{b})",{r:c[1],g:c[2],b:c[3]}));var d=c[4],f=this.globalAlpha;null!=f&&(d*=f),i.setAttribute(l.svgAttr+"-opacity",d)}},i.prototype.__closestGroupOrSvg=function(t){return"g"===(t=t||this.__currentElement).nodeName||"svg"===t.nodeName?t:this.__closestGroupOrSvg(t.parentNode)},i.prototype.getSerializedSvg=function(t){var e,i,n,r,s,a=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(a)&&(a=a.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(e=Object.keys(o),i=0;i<e.length;i++)n=e[i],r=o[n],(s=new RegExp(n,"gi")).test(a)&&(a=a.replace(s,r));return a},i.prototype.getSvg=function(){return this.__root},i.prototype.save=function(){var t=this.__createElement("g"),e=this.__closestGroupOrSvg();this.__groupStack.push(e),e.appendChild(t),this.__currentElement=t,this.__stack.push(this.__getStyleState())},i.prototype.restore=function(){this.__currentElement=this.__groupStack.pop(),this.__currentElementsToStyle=null,this.__currentElement||(this.__currentElement=this.__root.childNodes[1]);var t=this.__stack.pop();this.__applyStyleState(t)},i.prototype.__addTransform=function(t){var e=this.__closestGroupOrSvg();if(e.childNodes.length>0){"path"===this.__currentElement.nodeName&&(this.__currentElementsToStyle||(this.__currentElementsToStyle={element:e,children:[]}),this.__currentElementsToStyle.children.push(this.__currentElement),this.__applyCurrentDefaultPath());var i=this.__createElement("g");e.appendChild(i),this.__currentElement=i}var n=this.__currentElement.getAttribute("transform");n?n+=" ":n="",n+=t,this.__currentElement.setAttribute("transform",n)},i.prototype.scale=function(t,e){void 0===e&&(e=t),this.__addTransform(s("scale({x},{y})",{x:t,y:e}))},i.prototype.rotate=function(t){var e=180*t/Math.PI;this.__addTransform(s("rotate({angle},{cx},{cy})",{angle:e,cx:0,cy:0}))},i.prototype.translate=function(t,e){this.__addTransform(s("translate({x},{y})",{x:t,y:e}))},i.prototype.transform=function(t,e,i,n,r,o){this.__addTransform(s("matrix({a},{b},{c},{d},{e},{f})",{a:t,b:e,c:i,d:n,e:r,f:o}))},i.prototype.beginPath=function(){var t;this.__currentDefaultPath="",this.__currentPosition={},t=this.__createElement("path",{},!0),this.__closestGroupOrSvg().appendChild(t),this.__currentElement=t},i.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},i.prototype.__addPathCommand=function(t){this.__currentDefaultPath+=" ",this.__currentDefaultPath+=t},i.prototype.moveTo=function(t,e){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.__currentPosition={x:t,y:e},this.__addPathCommand(s("M {x} {y}",{x:t,y:e}))},i.prototype.closePath=function(){this.__currentDefaultPath&&this.__addPathCommand("Z")},i.prototype.lineTo=function(t,e){this.__currentPosition={x:t,y:e},this.__currentDefaultPath.indexOf("M")>-1?this.__addPathCommand(s("L {x} {y}",{x:t,y:e})):this.__addPathCommand(s("M {x} {y}",{x:t,y:e}))},i.prototype.bezierCurveTo=function(t,e,i,n,r,o){this.__currentPosition={x:r,y:o},this.__addPathCommand(s("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:t,cp1y:e,cp2x:i,cp2y:n,x:r,y:o}))},i.prototype.quadraticCurveTo=function(t,e,i,n){this.__currentPosition={x:i,y:n},this.__addPathCommand(s("Q {cpx} {cpy} {x} {y}",{cpx:t,cpy:e,x:i,y:n}))};var h=function(t){var e=Math.sqrt(t[0]*t[0]+t[1]*t[1]);return[t[0]/e,t[1]/e]};i.prototype.arcTo=function(t,e,i,n,r){var o=this.__currentPosition&&this.__currentPosition.x,s=this.__currentPosition&&this.__currentPosition.y;if(void 0!==o&&void 0!==s){if(r<0)throw new Error("IndexSizeError: The radius provided ("+r+") is negative.");if(o===t&&s===e||t===i&&e===n||0===r)this.lineTo(t,e);else{var a=h([o-t,s-e]),l=h([i-t,n-e]);if(a[0]*l[1]!=a[1]*l[0]){var u=a[0]*l[0]+a[1]*l[1],c=Math.acos(Math.abs(u)),_=h([a[0]+l[0],a[1]+l[1]]),p=r/Math.sin(c/2),d=t+p*_[0],f=e+p*_[1],v=[-a[1],a[0]],m=[l[1],-l[0]],g=function(t){var e=t[0],i=t[1];return i>=0?Math.acos(e):-Math.acos(e)},y=g(v),b=g(m);this.lineTo(d+v[0]*r,f+v[1]*r),this.arc(d,f,r,y,b)}else this.lineTo(t,e)}}},i.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill stroke markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke")},i.prototype.fill=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke fill markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill")},i.prototype.rect=function(t,e,i,n){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+n),this.lineTo(t,e+n),this.lineTo(t,e),this.closePath()},i.prototype.fillRect=function(t,e,i,n){var r;r=this.__createElement("rect",{x:t,y:e,width:i,height:n},!0),this.__closestGroupOrSvg().appendChild(r),this.__currentElement=r,this.__applyStyleToCurrentElement("fill")},i.prototype.strokeRect=function(t,e,i,n){var r;r=this.__createElement("rect",{x:t,y:e,width:i,height:n},!0),this.__closestGroupOrSvg().appendChild(r),this.__currentElement=r,this.__applyStyleToCurrentElement("stroke")},i.prototype.__clearCanvas=function(){for(var t=this.__closestGroupOrSvg(),e=t.getAttribute("transform"),i=this.__root.childNodes[1],n=i.childNodes,r=n.length-1;r>=0;r--)n[r]&&i.removeChild(n[r]);this.__currentElement=i,this.__groupStack=[],e&&this.__addTransform(e)},i.prototype.clearRect=function(t,e,i,n){if(0!==t||0!==e||i!==this.width||n!==this.height){var r,o=this.__closestGroupOrSvg();r=this.__createElement("rect",{x:t,y:e,width:i,height:n,fill:"#FFFFFF"},!0),o.appendChild(r)}else this.__clearCanvas()},i.prototype.createLinearGradient=function(t,e,i,r){var o=this.__createElement("linearGradient",{id:a(this.__ids),x1:t+"px",x2:i+"px",y1:e+"px",y2:r+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(o),new n(o,this)},i.prototype.createRadialGradient=function(t,e,i,r,o,s){var l=this.__createElement("radialGradient",{id:a(this.__ids),cx:r+"px",cy:o+"px",r:s+"px",fx:t+"px",fy:e+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(l),new n(l,this)},i.prototype.__parseFont=function(){var t=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),e={style:t[1]||"normal",size:t[4]||"10px",family:t[6]||"sans-serif",weight:t[3]||"normal",decoration:t[2]||"normal",href:null};return"underline"===this.__fontUnderline&&(e.decoration="underline"),this.__fontHref&&(e.href=this.__fontHref),e},i.prototype.__wrapTextLink=function(t,e){if(t.href){var i=this.__createElement("a");return i.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),i.appendChild(e),i}return e},i.prototype.__applyText=function(t,e,i,n){var r,o,s=this.__parseFont(),a=this.__closestGroupOrSvg(),h=this.__createElement("text",{"font-family":s.family,"font-size":s.size,"font-style":s.style,"font-weight":s.weight,"text-decoration":s.decoration,x:e,y:i,"text-anchor":(r=this.textAlign,o={left:"start",right:"end",center:"middle",start:"start",end:"end"},o[r]||o.start),"dominant-baseline":l(this.textBaseline)},!0);h.appendChild(this.__document.createTextNode(t)),this.__currentElement=h,this.__applyStyleToCurrentElement(n),a.appendChild(this.__wrapTextLink(s,h))},i.prototype.fillText=function(t,e,i){this.__applyText(t,e,i,"fill")},i.prototype.strokeText=function(t,e,i){this.__applyText(t,e,i,"stroke")},i.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},i.prototype.arc=function(t,e,i,n,r,o){if(n!==r){n%=2*Math.PI,r%=2*Math.PI,n===r&&(r=(r+2*Math.PI-.001*(o?-1:1))%(2*Math.PI));var a=t+i*Math.cos(r),l=e+i*Math.sin(r),h=t+i*Math.cos(n),u=e+i*Math.sin(n),c=o?0:1,_=0,p=r-n;p<0&&(p+=2*Math.PI),_=o?p>Math.PI?0:1:p>Math.PI?1:0,this.lineTo(h,u),this.__addPathCommand(s("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:i,ry:i,xAxisRotation:0,largeArcFlag:_,sweepFlag:c,endX:a,endY:l})),this.__currentPosition={x:a,y:l}}},i.prototype.clip=function(){var t=this.__closestGroupOrSvg(),e=this.__createElement("clipPath"),i=a(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath(),t.removeChild(this.__currentElement),e.setAttribute("id",i),e.appendChild(this.__currentElement),this.__defs.appendChild(e),t.setAttribute("clip-path",s("url(#{id})",{id:i})),t.appendChild(n),this.__currentElement=n},i.prototype.drawImage=function(){var t,e,n,r,o,s,a,l,h,u,c,_,p,d,f=Array.prototype.slice.call(arguments),v=f[0],m=0,g=0;if(3===f.length)t=f[1],e=f[2],o=v.width,s=v.height,n=o,r=s;else if(5===f.length)t=f[1],e=f[2],n=f[3],r=f[4],o=v.width,s=v.height;else{if(9!==f.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);m=f[1],g=f[2],o=f[3],s=f[4],t=f[5],e=f[6],n=f[7],r=f[8]}a=this.__closestGroupOrSvg(),this.__currentElement;var y="translate("+t+", "+e+")";if(v instanceof i){if((l=v.getSvg().cloneNode(!0)).childNodes&&l.childNodes.length>1){for(h=l.childNodes[0];h.childNodes.length;)d=h.childNodes[0].getAttribute("id"),this.__ids[d]=d,this.__defs.appendChild(h.childNodes[0]);if(u=l.childNodes[1]){var b,x=u.getAttribute("transform");b=x?x+" "+y:y,u.setAttribute("transform",b),a.appendChild(u)}}}else"IMG"===v.nodeName?((c=this.__createElement("image")).setAttribute("width",n),c.setAttribute("height",r),c.setAttribute("preserveAspectRatio","none"),(m||g||o!==v.width||s!==v.height)&&((_=this.__document.createElement("canvas")).width=n,_.height=r,(p=_.getContext("2d")).drawImage(v,m,g,o,s,0,0,n,r),v=_),c.setAttribute("transform",y),c.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===v.nodeName?v.toDataURL():v.getAttribute("src")),a.appendChild(c)):"CANVAS"===v.nodeName&&((c=this.__createElement("image")).setAttribute("width",n),c.setAttribute("height",r),c.setAttribute("preserveAspectRatio","none"),(_=this.__document.createElement("canvas")).width=n,_.height=r,(p=_.getContext("2d")).imageSmoothingEnabled=!1,p.mozImageSmoothingEnabled=!1,p.oImageSmoothingEnabled=!1,p.webkitImageSmoothingEnabled=!1,p.drawImage(v,m,g,o,s,0,0,n,r),v=_,c.setAttribute("transform",y),c.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",v.toDataURL()),a.appendChild(c))},i.prototype.createPattern=function(t,e){var n,o=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=a(this.__ids);return o.setAttribute("id",s),o.setAttribute("width",t.width),o.setAttribute("height",t.height),"CANVAS"===t.nodeName||"IMG"===t.nodeName?((n=this.__document.createElementNS("http://www.w3.org/2000/svg","image")).setAttribute("width",t.width),n.setAttribute("height",t.height),n.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===t.nodeName?t.toDataURL():t.getAttribute("src")),o.appendChild(n),this.__defs.appendChild(o)):t instanceof i&&(o.appendChild(t.__root.childNodes[1]),this.__defs.appendChild(o)),new r(o,this)},i.prototype.setLineDash=function(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null},i.prototype.drawFocusRing=function(){},i.prototype.createImageData=function(){},i.prototype.getImageData=function(){},i.prototype.putImageData=function(){},i.prototype.globalCompositeOperation=function(){},i.prototype.setTransform=function(){},"object"==typeof window&&(window.C2S=i),"object"==typeof e&&"object"==typeof e.exports&&(e.exports=i)}()},function(t,e,i){var n,r=t(329),o=t(339),s=t(344),a=t(338),l=t(344),h=t(346),u=Function.prototype.bind,c=Object.defineProperty,_=Object.prototype.hasOwnProperty;n=function(t,e,i){var n,o=h(e)&&l(e.value);return delete(n=r(e)).writable,delete n.value,n.get=function(){return!i.overwriteDefinition&&_.call(this,t)?o:(e.value=u.call(o,i.resolveContext?i.resolveContext(this):this),c(this,t,e),this[t])},n},e.exports=function(t){var e=o(arguments[1]);return null!=e.resolveContext&&s(e.resolveContext),a(t,function(t,i){return n(i,t,e)})}},function(t,e,i){var n=t(326),r=t(339),o=t(332),s=t(347);(e.exports=function(t,e){var i,o,a,l,h;return arguments.length<2||"string"!=typeof t?(l=e,e=t,t=null):l=arguments[2],null==t?(i=a=!0,o=!1):(i=s.call(t,"c"),o=s.call(t,"e"),a=s.call(t,"w")),h={value:e,configurable:i,enumerable:o,writable:a},l?n(r(l),h):h}).gs=function(t,e,i){var a,l,h,u;return"string"!=typeof t?(h=i,i=e,e=t,t=null):h=arguments[3],null==e?e=void 0:o(e)?null==i?i=void 0:o(i)||(h=i,i=void 0):(h=e,e=i=void 0),null==t?(a=!0,l=!1):(a=s.call(t,"c"),l=s.call(t,"e")),u={get:e,set:i,configurable:a,enumerable:l},h?n(r(h),u):u}},function(t,e,i){var n=t(346);e.exports=function(){return n(this).length=0,this}},function(t,e,i){var n=t(320),r=t(324),o=t(346),s=Array.prototype.indexOf,a=Object.prototype.hasOwnProperty,l=Math.abs,h=Math.floor;e.exports=function(t){var e,i,u,c;if(!n(t))return s.apply(this,arguments);for(i=r(o(this).length),u=arguments[1],u=isNaN(u)?0:u>=0?h(u):r(this.length)-h(l(u)),e=u;e<i;++e)if(a.call(this,e)&&(c=this[e],n(c)))return e;return-1}},function(t,e,i){e.exports=t(311)()?Array.from:t(312)},function(t,e,i){e.exports=function(){var t,e,i=Array.from;return"function"==typeof i&&(e=i(t=["raz","dwa"]),Boolean(e&&e!==t&&"dwa"===e[1]))}},function(t,e,i){var n=t(366).iterator,r=t(313),o=t(314),s=t(324),a=t(344),l=t(346),h=t(334),u=t(350),c=Array.isArray,_=Function.prototype.call,p={configurable:!0,enumerable:!0,writable:!0,value:null},d=Object.defineProperty;e.exports=function(t){var e,i,f,v,m,g,y,b,x,w,k=arguments[1],T=arguments[2];if(t=Object(l(t)),h(k)&&a(k),this&&this!==Array&&o(this))e=this;else{if(!k){if(r(t))return 1!==(m=t.length)?Array.apply(null,t):((v=new Array(1))[0]=t[0],v);if(c(t)){for(v=new Array(m=t.length),i=0;i<m;++i)v[i]=t[i];return v}}v=[]}if(!c(t))if(void 0!==(x=t[n])){for(y=a(x).call(t),e&&(v=new e),b=y.next(),i=0;!b.done;)w=k?_.call(k,T,b.value,i):b.value,e?(p.value=w,d(v,i,p)):v[i]=w,b=y.next(),++i;m=i}else if(u(t)){for(m=t.length,e&&(v=new e),i=0,f=0;i<m;++i)w=t[i],i+1<m&&(g=w.charCodeAt(0))>=55296&&g<=56319&&(w+=t[++i]),w=k?_.call(k,T,w,f):w,e?(p.value=w,d(v,f,p)):v[f]=w,++f;m=f}if(void 0===m)for(m=s(t.length),e&&(v=new e(m)),i=0;i<m;++i)w=k?_.call(k,T,t[i],i):t[i],e?(p.value=w,d(v,i,p)):v[i]=w;return e&&(p.value=null,v.length=m),v}},function(t,e,i){var n=Object.prototype.toString,r=n.call(function(){return arguments}());e.exports=function(t){return n.call(t)===r}},function(t,e,i){var n=Object.prototype.toString,r=n.call(t(315));e.exports=function(t){return"function"==typeof t&&n.call(t)===r}},function(t,e,i){e.exports=function(){}},function(t,e,i){e.exports=function(){return this}()},function(t,e,i){e.exports=t(318)()?Math.sign:t(319)},function(t,e,i){e.exports=function(){var t=Math.sign;return"function"==typeof t&&1===t(10)&&-1===t(-20)}},function(t,e,i){e.exports=function(t){return t=Number(t),isNaN(t)||0===t?t:t>0?1:-1}},function(t,e,i){e.exports=t(321)()?Number.isNaN:t(322)},function(t,e,i){e.exports=function(){var t=Number.isNaN;return"function"==typeof t&&!t({})&&t(NaN)&&!t(34)}},function(t,e,i){e.exports=function(t){return t!=t}},function(t,e,i){var n=t(317),r=Math.abs,o=Math.floor;e.exports=function(t){return isNaN(t)?0:0!==(t=Number(t))&&isFinite(t)?n(t)*o(r(t)):t}},function(t,e,i){var n=t(323),r=Math.max;e.exports=function(t){return r(0,n(t))}},function(t,e,i){var n=t(344),r=t(346),o=Function.prototype.bind,s=Function.prototype.call,a=Object.keys,l=Object.prototype.propertyIsEnumerable;e.exports=function(t,e){return function(i,h){var u,c=arguments[2],_=arguments[3];return i=Object(r(i)),n(h),u=a(i),_&&u.sort("function"==typeof _?o.call(_,i):void 0),"function"!=typeof t&&(t=u[t]),s.call(t,u,function(t,n){return l.call(i,t)?s.call(h,c,i[t],t,i,n):e})}}},function(t,e,i){e.exports=t(327)()?Object.assign:t(328)},function(t,e,i){e.exports=function(){var t,e=Object.assign;return"function"==typeof e&&(e(t={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),t.foo+t.bar+t.trzy==="razdwatrzy")}},function(t,e,i){var n=t(335),r=t(346),o=Math.max;e.exports=function(t,e){var i,s,a,l=o(arguments.length,2);for(t=Object(r(t)),a=function(n){try{t[n]=e[n]}catch(t){i||(i=t)}},s=1;s<l;++s)e=arguments[s],n(e).forEach(a);if(void 0!==i)throw i;return t}},function(t,e,i){var n=t(310),r=t(326),o=t(346);e.exports=function(t){var e=Object(o(t)),i=arguments[1],s=Object(arguments[2]);if(e!==t&&!i)return e;var a={};return i?n(i,function(e){(s.ensure||e in t)&&(a[e]=t[e])}):r(a,t),a}},function(t,e,i){var n,r,o,s,a=Object.create;t(342)()||(n=t(343)),e.exports=n?1!==n.level?a:(r={},o={},s={configurable:!1,enumerable:!1,writable:!0,value:void 0},Object.getOwnPropertyNames(Object.prototype).forEach(function(t){o[t]="__proto__"!==t?s:{configurable:!0,enumerable:!1,writable:!0,value:void 0}}),Object.defineProperties(r,o),Object.defineProperty(n,"nullPolyfill",{configurable:!1,enumerable:!1,writable:!1,value:r}),function(t,e){return a(null===t?r:t,e)}):a},function(t,e,i){e.exports=t(325)("forEach")},function(t,e,i){e.exports=function(t){return"function"==typeof t}},function(t,e,i){var n=t(334),r={function:!0,object:!0};e.exports=function(t){return n(t)&&r[typeof t]||!1}},function(t,e,i){var n=t(315)();e.exports=function(t){return t!==n&&null!==t}},function(t,e,i){e.exports=t(336)()?Object.keys:t(337)},function(t,e,i){e.exports=function(){try{return Object.keys("primitive"),!0}catch(t){return!1}}},function(t,e,i){var n=t(334),r=Object.keys;e.exports=function(t){return r(n(t)?Object(t):t)}},function(t,e,i){var n=t(344),r=t(331),o=Function.prototype.call;e.exports=function(t,e){var i={},s=arguments[2];return n(e),r(t,function(t,n,r,a){i[n]=o.call(e,s,t,n,r,a)}),i}},function(t,e,i){var n=t(334),r=Array.prototype.forEach,o=Object.create;e.exports=function(t){var e=o(null);return r.call(arguments,function(t){n(t)&&function(t,e){var i;for(i in t)e[i]=t[i]}(Object(t),e)}),e}},function(t,e,i){var n=Array.prototype.forEach,r=Object.create;e.exports=function(t){var e=r(null);return n.call(arguments,function(t){e[t]=!0}),e}},function(t,e,i){e.exports=t(342)()?Object.setPrototypeOf:t(343)},function(t,e,i){var n=Object.create,r=Object.getPrototypeOf,o={};e.exports=function(){var t=Object.setPrototypeOf,e=arguments[0]||n;return"function"==typeof t&&r(t(e(null),o))===o}},function(t,e,i){var n,r,o,s,a=t(333),l=t(346),h=Object.prototype.isPrototypeOf,u=Object.defineProperty,c={configurable:!0,enumerable:!1,writable:!0,value:void 0};n=function(t,e){if(l(t),null===e||a(e))return t;throw new TypeError("Prototype must be null or an object")},e.exports=(r=function(){var t,e=Object.create(null),i={},n=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__");if(n){try{(t=n.set).call(e,i)}catch(t){}if(Object.getPrototypeOf(e)===i)return{set:t,level:2}}return e.__proto__=i,Object.getPrototypeOf(e)===i?{level:2}:((e={}).__proto__=i,Object.getPrototypeOf(e)===i&&{level:1})}())?(2===r.level?r.set?(s=r.set,o=function(t,e){return s.call(n(t,e),e),t}):o=function(t,e){return n(t,e).__proto__=e,t}:o=function t(e,i){var r;return n(e,i),(r=h.call(t.nullPolyfill,e))&&delete t.nullPolyfill.__proto__,null===i&&(i=t.nullPolyfill),e.__proto__=i,r&&u(t.nullPolyfill,"__proto__",c),e},Object.defineProperty(o,"level",{configurable:!1,enumerable:!1,writable:!1,value:r.level})):null,t(330)},function(t,e,i){e.exports=function(t){if("function"!=typeof t)throw new TypeError(t+" is not a function");return t}},function(t,e,i){var n=t(333);e.exports=function(t){if(!n(t))throw new TypeError(t+" is not an Object");return t}},function(t,e,i){var n=t(334);e.exports=function(t){if(!n(t))throw new TypeError("Cannot use null or undefined");return t}},function(t,e,i){e.exports=t(348)()?String.prototype.contains:t(349)},function(t,e,i){var n="razdwatrzy";e.exports=function(){return"function"==typeof n.contains&&!0===n.contains("dwa")&&!1===n.contains("foo")}},function(t,e,i){var n=String.prototype.indexOf;e.exports=function(t){return n.call(this,t,arguments[1])>-1}},function(t,e,i){var n=Object.prototype.toString,r=n.call("");e.exports=function(t){return"string"==typeof t||t&&"object"==typeof t&&(t instanceof String||n.call(t)===r)||!1}},function(t,e,i){var n=Object.create(null),r=Math.random;e.exports=function(){var t;do{t=r().toString(36).slice(2)}while(n[t]);return t}},function(t,e,i){var n,r=t(341),o=t(347),s=t(307),a=t(366),l=t(355),h=Object.defineProperty;n=e.exports=function(t,e){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");l.call(this,t),e=e?o.call(e,"key+value")?"key+value":o.call(e,"key")?"key":"value":"value",h(this,"__kind__",s("",e))},r&&r(n,l),delete n.prototype.constructor,n.prototype=Object.create(l.prototype,{_resolve:s(function(t){return"value"===this.__kind__?this.__list__[t]:"key+value"===this.__kind__?[t,this.__list__[t]]:t})}),h(n.prototype,a.toStringTag,s("c","Array Iterator"))},function(t,e,i){var n=t(313),r=t(344),o=t(350),s=t(354),a=Array.isArray,l=Function.prototype.call,h=Array.prototype.some;e.exports=function(t,e){var i,u,c,_,p,d,f,v,m=arguments[2];if(a(t)||n(t)?i="array":o(t)?i="string":t=s(t),r(e),c=function(){_=!0},"array"!==i)if("string"!==i)for(u=t.next();!u.done;){if(l.call(e,m,u.value,c),_)return;u=t.next()}else for(d=t.length,p=0;p<d&&(f=t[p],p+1<d&&(v=f.charCodeAt(0))>=55296&&v<=56319&&(f+=t[++p]),l.call(e,m,f,c),!_);++p);else h.call(t,function(t){return l.call(e,m,t,c),_})}},function(t,e,i){var n=t(313),r=t(350),o=t(352),s=t(357),a=t(358),l=t(366).iterator;e.exports=function(t){return"function"==typeof a(t)[l]?t[l]():n(t)?new o(t):r(t)?new s(t):new o(t)}},function(t,e,i){var n,r=t(308),o=t(326),s=t(344),a=t(346),l=t(307),h=t(306),u=t(366),c=Object.defineProperty,_=Object.defineProperties;e.exports=n=function(t,e){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");_(this,{__list__:l("w",a(t)),__context__:l("w",e),__nextIndex__:l("w",0)}),e&&(s(e.on),e.on("_add",this._onAdd),e.on("_delete",this._onDelete),e.on("_clear",this._onClear))},delete n.prototype.constructor,_(n.prototype,o({_next:l(function(){var t;if(this.__list__)return this.__redo__&&void 0!==(t=this.__redo__.shift())?t:this.__nextIndex__<this.__list__.length?this.__nextIndex__++:void this._unBind()}),next:l(function(){return this._createResult(this._next())}),_createResult:l(function(t){return void 0===t?{done:!0,value:void 0}:{done:!1,value:this._resolve(t)}}),_resolve:l(function(t){return this.__list__[t]}),_unBind:l(function(){this.__list__=null,delete this.__redo__,this.__context__&&(this.__context__.off("_add",this._onAdd),this.__context__.off("_delete",this._onDelete),this.__context__.off("_clear",this._onClear),this.__context__=null)}),toString:l(function(){return"[object "+(this[u.toStringTag]||"Object")+"]"})},h({_onAdd:l(function(t){t>=this.__nextIndex__||(++this.__nextIndex__,this.__redo__?(this.__redo__.forEach(function(e,i){e>=t&&(this.__redo__[i]=++e)},this),this.__redo__.push(t)):c(this,"__redo__",l("c",[t])))}),_onDelete:l(function(t){var e;t>=this.__nextIndex__||(--this.__nextIndex__,this.__redo__&&(-1!==(e=this.__redo__.indexOf(t))&&this.__redo__.splice(e,1),this.__redo__.forEach(function(e,i){e>t&&(this.__redo__[i]=--e)},this)))}),_onClear:l(function(){this.__redo__&&r.call(this.__redo__),this.__nextIndex__=0})}))),c(n.prototype,u.iterator,l(function(){return this}))},function(t,e,i){var n=t(313),r=t(334),o=t(350),s=t(366).iterator,a=Array.isArray;e.exports=function(t){return!(!r(t)||!a(t)&&!o(t)&&!n(t)&&"function"!=typeof t[s])}},function(t,e,i){var n,r=t(341),o=t(307),s=t(366),a=t(355),l=Object.defineProperty;n=e.exports=function(t){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");t=String(t),a.call(this,t),l(this,"__length__",o("",t.length))},r&&r(n,a),delete n.prototype.constructor,n.prototype=Object.create(a.prototype,{_next:o(function(){if(this.__list__)return this.__nextIndex__<this.__length__?this.__nextIndex__++:void this._unBind()}),_resolve:o(function(t){var e,i=this.__list__[t];return this.__nextIndex__===this.__length__?i:(e=i.charCodeAt(0))>=55296&&e<=56319?i+this.__list__[this.__nextIndex__++]:i})}),l(n.prototype,s.toStringTag,o("c","String Iterator"))},function(t,e,i){var n=t(356);e.exports=function(t){if(!n(t))throw new TypeError(t+" is not iterable");return t}},function(t,e,i){t(360)()||Object.defineProperty(t(316),"Map",{value:t(364),configurable:!0,enumerable:!1,writable:!0})},function(t,e,i){e.exports=function(){var t,e,i;if("function"!=typeof Map)return!1;try{t=new Map([["raz","one"],["dwa","two"],["trzy","three"]])}catch(t){return!1}return"[object Map]"===String(t)&&3===t.size&&"function"==typeof t.clear&&"function"==typeof t.delete&&"function"==typeof t.entries&&"function"==typeof t.forEach&&"function"==typeof t.get&&"function"==typeof t.has&&"function"==typeof t.keys&&"function"==typeof t.set&&"function"==typeof t.values&&(e=t.entries(),!1===(i=e.next()).done&&!!i.value&&"raz"===i.value[0]&&"one"===i.value[1])}},function(t,e,i){e.exports="undefined"!=typeof Map&&"[object Map]"===Object.prototype.toString.call(new Map)},function(t,e,i){e.exports=t(340)("key","value","key+value")},function(t,e,i){var n,r=t(341),o=t(307),s=t(355),a=t(366).toStringTag,l=t(362),h=Object.defineProperties,u=s.prototype._unBind;n=e.exports=function(t,e){if(!(this instanceof n))return new n(t,e);s.call(this,t.__mapKeysData__,t),e&&l[e]||(e="key+value"),h(this,{__kind__:o("",e),__values__:o("w",t.__mapValuesData__)})},r&&r(n,s),n.prototype=Object.create(s.prototype,{constructor:o(n),_resolve:o(function(t){return"value"===this.__kind__?this.__values__[t]:"key"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__values__[t]]}),_unBind:o(function(){this.__values__=null,u.call(this)}),toString:o(function(){return"[object Map Iterator]"})}),Object.defineProperty(n.prototype,a,o("c","Map Iterator"))},function(t,e,i){var n,r=t(308),o=t(309),s=t(341),a=t(344),l=t(346),h=t(307),u=t(375),c=t(366),_=t(358),p=t(353),d=t(363),f=t(361),v=Function.prototype.call,m=Object.defineProperties,g=Object.getPrototypeOf;e.exports=n=function(){var t,e,i,r=arguments[0];if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");return i=f&&s&&Map!==n?s(new Map,g(this)):this,null!=r&&_(r),m(i,{__mapKeysData__:h("c",t=[]),__mapValuesData__:h("c",e=[])}),r?(p(r,function(i){var n=l(i)[0];i=i[1],-1===o.call(t,n)&&(t.push(n),e.push(i))},i),i):i},f&&(s&&s(n,Map),n.prototype=Object.create(Map.prototype,{constructor:h(n)})),u(m(n.prototype,{clear:h(function(){this.__mapKeysData__.length&&(r.call(this.__mapKeysData__),r.call(this.__mapValuesData__),this.emit("_clear"))}),delete:h(function(t){var e=o.call(this.__mapKeysData__,t);return-1!==e&&(this.__mapKeysData__.splice(e,1),this.__mapValuesData__.splice(e,1),this.emit("_delete",e,t),!0)}),entries:h(function(){return new d(this,"key+value")}),forEach:h(function(t){var e,i,n=arguments[1];for(a(t),e=this.entries(),i=e._next();void 0!==i;)v.call(t,n,this.__mapValuesData__[i],this.__mapKeysData__[i],this),i=e._next()}),get:h(function(t){var e=o.call(this.__mapKeysData__,t);if(-1!==e)return this.__mapValuesData__[e]}),has:h(function(t){return-1!==o.call(this.__mapKeysData__,t)}),keys:h(function(){return new d(this,"key")}),set:h(function(t,e){var i,n=o.call(this.__mapKeysData__,t);return-1===n&&(n=this.__mapKeysData__.push(t)-1,i=!0),this.__mapValuesData__[n]=e,i&&this.emit("_add",n,t),this}),size:h.gs(function(){return this.__mapKeysData__.length}),values:h(function(){return new d(this,"value")}),toString:h(function(){return"[object Map]"})})),Object.defineProperty(n.prototype,c.iterator,h(function(){return this.entries()})),Object.defineProperty(n.prototype,c.toStringTag,h("c","Map"))},function(t,e,i){
/*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.6+9869a4bc
     */
!function(t,n){"object"==typeof i&&void 0!==e?e.exports=n():t.ES6Promise=n()}(this,function(){"use strict";function e(t){return"function"==typeof t}var i=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},n=0,r=void 0,o=void 0,s=function(t,e){p[n]=t,p[n+1]=e,2===(n+=2)&&(o?o(d):y())},a="undefined"!=typeof window?window:void 0,l=a||{},h=l.MutationObserver||l.WebKitMutationObserver,u="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),c="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function _(){var t=setTimeout;return function(){return t(d,1)}}var p=new Array(1e3);function d(){for(var t=0;t<n;t+=2){var e=p[t],i=p[t+1];e(i),p[t]=void 0,p[t+1]=void 0}n=0}var f,v,m,g,y=void 0;function b(t,e){var i=this,n=new this.constructor(k);void 0===n[w]&&R(n);var r=i._state;if(r){var o=arguments[r-1];s(function(){return F(r,n,o,i._result)})}else N(i,n,t,e);return n}function x(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(k);return z(e,t),e}u?y=function(){return process.nextTick(d)}:h?(v=0,m=new h(d),g=document.createTextNode(""),m.observe(g,{characterData:!0}),y=function(){g.data=v=++v%2}):c?((f=new MessageChannel).port1.onmessage=d,y=function(){return f.port2.postMessage(0)}):y=void 0===a&&"function"==typeof t?function(){try{var t=Function("return this")().require("vertx");return void 0!==(r=t.runOnLoop||t.runOnContext)?function(){r(d)}:_()}catch(t){return _()}}():_();var w=Math.random().toString(36).substring(2);function k(){}var T=void 0,C=1,S=2,A={error:null};function M(t){try{return t.then}catch(t){return A.error=t,A}}function E(t,i,n){i.constructor===t.constructor&&n===b&&i.constructor.resolve===x?function(t,e){e._state===C?P(t,e._result):e._state===S?j(t,e._result):N(e,void 0,function(e){return z(t,e)},function(e){return j(t,e)})}(t,i):n===A?(j(t,A.error),A.error=null):void 0===n?P(t,i):e(n)?function(t,e,i){s(function(t){var n=!1,r=function(t,e,i,n){try{t.call(e,i,n)}catch(t){return t}}(i,e,function(i){n||(n=!0,e!==i?z(t,i):P(t,i))},function(e){n||(n=!0,j(t,e))},t._label);!n&&r&&(n=!0,j(t,r))},t)}(t,i,n):P(t,i)}function z(t,e){var i,n;t===e?j(t,new TypeError("You cannot resolve a promise with itself")):(n=typeof(i=e),null===i||"object"!==n&&"function"!==n?P(t,e):E(t,e,M(e)))}function O(t){t._onerror&&t._onerror(t._result),D(t)}function P(t,e){t._state===T&&(t._result=e,t._state=C,0!==t._subscribers.length&&s(D,t))}function j(t,e){t._state===T&&(t._state=S,t._result=e,s(O,t))}function N(t,e,i,n){var r=t._subscribers,o=r.length;t._onerror=null,r[o]=e,r[o+C]=i,r[o+S]=n,0===o&&t._state&&s(D,t)}function D(t){var e=t._subscribers,i=t._state;if(0!==e.length){for(var n=void 0,r=void 0,o=t._result,s=0;s<e.length;s+=3)n=e[s],r=e[s+i],n?F(i,n,r,o):r(o);t._subscribers.length=0}}function F(t,i,n,r){var o=e(n),s=void 0,a=void 0,l=void 0,h=void 0;if(o){if((s=function(t,e){try{return t(e)}catch(t){return A.error=t,A}}(n,r))===A?(h=!0,a=s.error,s.error=null):l=!0,i===s)return void j(i,new TypeError("A promises callback cannot return that same promise."))}else s=r,l=!0;i._state!==T||(o&&l?z(i,s):h?j(i,a):t===C?P(i,s):t===S&&j(i,s))}var B=0;function R(t){t[w]=B++,t._state=void 0,t._result=void 0,t._subscribers=[]}var I=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(k),this.promise[w]||R(this.promise),i(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?P(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&P(this.promise,this._result))):j(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;this._state===T&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(t,e){var i=this._instanceConstructor,n=i.resolve;if(n===x){var r=M(t);if(r===b&&t._state!==T)this._settledAt(t._state,e,t._result);else if("function"!=typeof r)this._remaining--,this._result[e]=t;else if(i===L){var o=new i(k);E(o,t,r),this._willSettleAt(o,e)}else this._willSettleAt(new i(function(e){return e(t)}),e)}else this._willSettleAt(n(t),e)},t.prototype._settledAt=function(t,e,i){var n=this.promise;n._state===T&&(this._remaining--,t===S?j(n,i):this._result[e]=i),0===this._remaining&&P(n,this._result)},t.prototype._willSettleAt=function(t,e){var i=this;N(t,void 0,function(t){return i._settledAt(C,e,t)},function(t){return i._settledAt(S,e,t)})},t}(),L=function(){function t(e){this[w]=B++,this._result=this._state=void 0,this._subscribers=[],k!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof t?function(t,e){try{e(function(e){z(t,e)},function(e){j(t,e)})}catch(e){j(t,e)}}(this,e):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return t.prototype.catch=function(t){return this.then(null,t)},t.prototype.finally=function(t){var i=this.constructor;return e(t)?this.then(function(e){return i.resolve(t()).then(function(){return e})},function(e){return i.resolve(t()).then(function(){throw e})}):this.then(t,t)},t}();return L.prototype.then=b,L.all=function(t){return new I(this,t).promise},L.race=function(t){var e=this;return i(t)?new e(function(i,n){for(var r=t.length,o=0;o<r;o++)e.resolve(t[o]).then(i,n)}):new e(function(t,e){return e(new TypeError("You must pass an array to race."))})},L.resolve=x,L.reject=function(t){var e=new this(k);return j(e,t),e},L._setScheduler=function(t){o=t},L._setAsap=function(t){s=t},L._asap=s,L.polyfill=function(){var t=void 0;if("undefined"!=typeof global)t=global;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var i=null;try{i=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===i&&!e.cast)return}t.Promise=L},L.Promise=L,L})},function(t,e,i){e.exports=t(367)()?Symbol:t(369)},function(t,e,i){var n={object:!0,symbol:!0};e.exports=function(){var t;if("function"!=typeof Symbol)return!1;t=Symbol("test symbol");try{String(t)}catch(t){return!1}return!!n[typeof Symbol.iterator]&&!!n[typeof Symbol.toPrimitive]&&!!n[typeof Symbol.toStringTag]}},function(t,e,i){e.exports=function(t){return!!t&&("symbol"==typeof t||!!t.constructor&&"Symbol"===t.constructor.name&&"Symbol"===t[t.constructor.toStringTag])}},function(t,e,i){var n,r,o,s,a=t(307),l=t(370),h=Object.create,u=Object.defineProperties,c=Object.defineProperty,_=Object.prototype,p=h(null);if("function"==typeof Symbol){n=Symbol;try{String(n()),s=!0}catch(t){}}var d,f=(d=h(null),function(t){for(var e,i,n=0;d[t+(n||"")];)++n;return d[t+=n||""]=!0,c(_,e="@@"+t,a.gs(null,function(t){i||(i=!0,c(this,e,a(t)),i=!1)})),e});o=function(t){if(this instanceof o)throw new TypeError("Symbol is not a constructor");return r(t)},e.exports=r=function t(e){var i;if(this instanceof t)throw new TypeError("Symbol is not a constructor");return s?n(e):(i=h(o.prototype),e=void 0===e?"":String(e),u(i,{__description__:a("",e),__name__:a("",f(e))}))},u(r,{for:a(function(t){return p[t]?p[t]:p[t]=r(String(t))}),keyFor:a(function(t){var e;for(e in l(t),p)if(p[e]===t)return e}),hasInstance:a("",n&&n.hasInstance||r("hasInstance")),isConcatSpreadable:a("",n&&n.isConcatSpreadable||r("isConcatSpreadable")),iterator:a("",n&&n.iterator||r("iterator")),match:a("",n&&n.match||r("match")),replace:a("",n&&n.replace||r("replace")),search:a("",n&&n.search||r("search")),species:a("",n&&n.species||r("species")),split:a("",n&&n.split||r("split")),toPrimitive:a("",n&&n.toPrimitive||r("toPrimitive")),toStringTag:a("",n&&n.toStringTag||r("toStringTag")),unscopables:a("",n&&n.unscopables||r("unscopables"))}),u(o.prototype,{constructor:a(r),toString:a("",function(){return this.__name__})}),u(r.prototype,{toString:a(function(){return"Symbol ("+l(this).__description__+")"}),valueOf:a(function(){return l(this)})}),c(r.prototype,r.toPrimitive,a("",function(){var t=l(this);return"symbol"==typeof t?t:t.toString()})),c(r.prototype,r.toStringTag,a("c","Symbol")),c(o.prototype,r.toStringTag,a("c",r.prototype[r.toStringTag])),c(o.prototype,r.toPrimitive,a("c",r.prototype[r.toPrimitive]))},function(t,e,i){var n=t(368);e.exports=function(t){if(!n(t))throw new TypeError(t+" is not a symbol");return t}},function(t,e,i){t(372)()||Object.defineProperty(t(316),"WeakMap",{value:t(374),configurable:!0,enumerable:!1,writable:!0})},function(t,e,i){e.exports=function(){var t,e;if("function"!=typeof WeakMap)return!1;try{t=new WeakMap([[e={},"one"],[{},"two"],[{},"three"]])}catch(t){return!1}return"[object WeakMap]"===String(t)&&"function"==typeof t.set&&t.set({},1)===t&&"function"==typeof t.delete&&"function"==typeof t.has&&"one"===t.get(e)}},function(t,e,i){e.exports="function"==typeof WeakMap&&"[object WeakMap]"===Object.prototype.toString.call(new WeakMap)},function(t,e,i){var n,r=t(341),o=t(345),s=t(346),a=t(351),l=t(307),h=t(354),u=t(353),c=t(366).toStringTag,_=t(373),p=Array.isArray,d=Object.defineProperty,f=Object.prototype.hasOwnProperty,v=Object.getPrototypeOf;e.exports=n=function(){var t,e=arguments[0];if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");return t=_&&r&&WeakMap!==n?r(new WeakMap,v(this)):this,null!=e&&(p(e)||(e=h(e))),d(t,"__weakMapData__",l("c","$weakMap$"+a())),e?(u(e,function(e){s(e),t.set(e[0],e[1])}),t):t},_&&(r&&r(n,WeakMap),n.prototype=Object.create(WeakMap.prototype,{constructor:l(n)})),Object.defineProperties(n.prototype,{delete:l(function(t){return!!f.call(o(t),this.__weakMapData__)&&(delete t[this.__weakMapData__],!0)}),get:l(function(t){if(f.call(o(t),this.__weakMapData__))return t[this.__weakMapData__]}),has:l(function(t){return f.call(o(t),this.__weakMapData__)}),set:l(function(t,e){return d(o(t),this.__weakMapData__,l("c",e)),this}),toString:l(function(){return"[object WeakMap]"})}),d(n.prototype,c,l("c","WeakMap"))},function(t,e,i){var n,r,o,s,a,l,h,u=t(307),c=t(344),_=Function.prototype.apply,p=Function.prototype.call,d=Object.create,f=Object.defineProperty,v=Object.defineProperties,m=Object.prototype.hasOwnProperty,g={configurable:!0,enumerable:!1,writable:!0};r=function(t,e){var i,r;return c(e),r=this,n.call(this,t,i=function(){o.call(r,t,i),_.call(e,this,arguments)}),i.__eeOnceListener__=e,this},a={on:n=function(t,e){var i;return c(e),m.call(this,"__ee__")?i=this.__ee__:(i=g.value=d(null),f(this,"__ee__",g),g.value=null),i[t]?"object"==typeof i[t]?i[t].push(e):i[t]=[i[t],e]:i[t]=e,this},once:r,off:o=function(t,e){var i,n,r,o;if(c(e),!m.call(this,"__ee__"))return this;if(!(i=this.__ee__)[t])return this;if("object"==typeof(n=i[t]))for(o=0;r=n[o];++o)r!==e&&r.__eeOnceListener__!==e||(2===n.length?i[t]=n[o?0:1]:n.splice(o,1));else n!==e&&n.__eeOnceListener__!==e||delete i[t];return this},emit:s=function(t){var e,i,n,r,o;if(m.call(this,"__ee__")&&(r=this.__ee__[t]))if("object"==typeof r){for(i=arguments.length,o=new Array(i-1),e=1;e<i;++e)o[e-1]=arguments[e];for(r=r.slice(),e=0;n=r[e];++e)_.call(n,this,o)}else switch(arguments.length){case 1:p.call(r,this);break;case 2:p.call(r,this,arguments[1]);break;case 3:p.call(r,this,arguments[1],arguments[2]);break;default:for(i=arguments.length,o=new Array(i-1),e=1;e<i;++e)o[e-1]=arguments[e];_.call(r,this,o)}}},l={on:u(n),once:u(r),off:u(o),emit:u(s)},h=v({},l),e.exports=i=function(t){return null==t?d(h):v(Object(t),l)},i.methods=a},function(t,e,i){var n,r;n=this,r=function(){"use strict";var t=function(){this.ids=[],this.values=[],this.length=0};t.prototype.clear=function(){this.length=this.ids.length=this.values.length=0},t.prototype.push=function(t,e){this.ids.push(t),this.values.push(e);for(var i=this.length++;i>0;){var n=i-1>>1,r=this.values[n];if(e>=r)break;this.ids[i]=this.ids[n],this.values[i]=r,i=n}this.ids[i]=t,this.values[i]=e},t.prototype.pop=function(){if(0!==this.length){var t=this.ids[0];if(this.length--,this.length>0){for(var e=this.ids[0]=this.ids[this.length],i=this.values[0]=this.values[this.length],n=this.length>>1,r=0;r<n;){var o=1+(r<<1),s=o+1,a=this.ids[o],l=this.values[o],h=this.values[s];if(s<this.length&&h<l&&(o=s,a=this.ids[s],l=h),l>=i)break;this.ids[r]=a,this.values[r]=l,r=o}this.ids[r]=e,this.values[r]=i}return this.ids.pop(),this.values.pop(),t}},t.prototype.peek=function(){return this.ids[0]},t.prototype.peekValue=function(){return this.values[0]};var e=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],i=function(i,n,r,o){if(void 0===n&&(n=16),void 0===r&&(r=Float64Array),void 0===i)throw new Error("Missing required argument: numItems.");if(isNaN(i)||i<=0)throw new Error("Unpexpected numItems value: "+i+".");this.numItems=+i,this.nodeSize=Math.min(Math.max(+n,2),65535);var s=i,a=s;this._levelBounds=[4*s];do{s=Math.ceil(s/this.nodeSize),a+=s,this._levelBounds.push(4*a)}while(1!==s);this.ArrayType=r||Float64Array,this.IndexArrayType=a<16384?Uint16Array:Uint32Array;var l=e.indexOf(this.ArrayType),h=4*a*this.ArrayType.BYTES_PER_ELEMENT;if(l<0)throw new Error("Unexpected typed array class: "+r+".");o&&o instanceof ArrayBuffer?(this.data=o,this._boxes=new this.ArrayType(this.data,8,4*a),this._indices=new this.IndexArrayType(this.data,8+h,a),this._pos=4*a,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+h+a*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*a),this._indices=new this.IndexArrayType(this.data,8+h,a),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+l]),new Uint16Array(this.data,2,1)[0]=n,new Uint32Array(this.data,4,1)[0]=i),this._queue=new t};function n(t,e,i){return t<e?e-t:t<=i?0:t-i}function r(t,e){for(var i=0,n=e.length-1;i<n;){var r=i+n>>1;e[r]>t?n=r:i=r+1}return e[i]}function o(t,e,i,n,r){var o=t[n];t[n]=t[r],t[r]=o;var s=4*n,a=4*r,l=e[s],h=e[s+1],u=e[s+2],c=e[s+3];e[s]=e[a],e[s+1]=e[a+1],e[s+2]=e[a+2],e[s+3]=e[a+3],e[a]=l,e[a+1]=h,e[a+2]=u,e[a+3]=c;var _=i[n];i[n]=i[r],i[r]=_}function s(t,e){var i=t^e,n=65535^i,r=65535^(t|e),o=t&(65535^e),s=i|n>>1,a=i>>1^i,l=r>>1^n&o>>1^r,h=i&r>>1^o>>1^o;a=(i=s)&(n=a)>>2^n&(i^n)>>2,l^=i&(r=l)>>2^n&(o=h)>>2,h^=n&r>>2^(i^n)&o>>2,a=(i=s=i&i>>2^n&n>>2)&(n=a)>>4^n&(i^n)>>4,l^=i&(r=l)>>4^n&(o=h)>>4,h^=n&r>>4^(i^n)&o>>4,l^=(i=s=i&i>>4^n&n>>4)&(r=l)>>8^(n=a)&(o=h)>>8;var u=t^e,c=(n=(h^=n&r>>8^(i^n)&o>>8)^h>>1)|65535^(u|(i=l^l>>1));return((c=1431655765&((c=858993459&((c=252645135&((c=16711935&(c|c<<8))|c<<4))|c<<2))|c<<1))<<1|(u=1431655765&((u=858993459&((u=252645135&((u=16711935&(u|u<<8))|u<<4))|u<<2))|u<<1)))>>>0}return i.from=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var n=new Uint8Array(t,0,2),r=n[0],o=n[1];if(251!==r)throw new Error("Data does not appear to be in a Flatbush format.");if(o>>4!=3)throw new Error("Got v"+(o>>4)+" data when expected v3.");var s=new Uint16Array(t,2,1),a=s[0],l=new Uint32Array(t,4,1),h=l[0];return new i(h,a,e[15&o],t)},i.prototype.add=function(t,e,i,n){var r=this._pos>>2;this._indices[r]=r,this._boxes[this._pos++]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=i,this._boxes[this._pos++]=n,t<this.minX&&(this.minX=t),e<this.minY&&(this.minY=e),i>this.maxX&&(this.maxX=i),n>this.maxY&&(this.maxY=n)},i.prototype.finish=function(){if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");for(var t=this.maxX-this.minX,e=this.maxY-this.minY,i=new Uint32Array(this.numItems),n=0;n<this.numItems;n++){var r=4*n,a=this._boxes[r++],l=this._boxes[r++],h=this._boxes[r++],u=this._boxes[r++],c=Math.floor(65535*((a+h)/2-this.minX)/t),_=Math.floor(65535*((l+u)/2-this.minY)/e);i[n]=s(c,_)}!function t(e,i,n,r,s){if(!(r>=s)){for(var a=e[r+s>>1],l=r-1,h=s+1;;){do{l++}while(e[l]<a);do{h--}while(e[h]>a);if(l>=h)break;o(e,i,n,l,h)}t(e,i,n,r,h),t(e,i,n,h+1,s)}}(i,this._boxes,this._indices,0,this.numItems-1);for(var p=0,d=0;p<this._levelBounds.length-1;p++)for(var f=this._levelBounds[p];d<f;){for(var v=1/0,m=1/0,g=-1/0,y=-1/0,b=d,x=0;x<this.nodeSize&&d<f;x++){var w=this._boxes[d++],k=this._boxes[d++],T=this._boxes[d++],C=this._boxes[d++];w<v&&(v=w),k<m&&(m=k),T>g&&(g=T),C>y&&(y=C)}this._indices[this._pos>>2]=b,this._boxes[this._pos++]=v,this._boxes[this._pos++]=m,this._boxes[this._pos++]=g,this._boxes[this._pos++]=y}},i.prototype.search=function(t,e,i,n,r){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var o=this._boxes.length-4,s=this._levelBounds.length-1,a=[],l=[];void 0!==o;){for(var h=Math.min(o+4*this.nodeSize,this._levelBounds[s]),u=o;u<h;u+=4){var c=0|this._indices[u>>2];i<this._boxes[u]||n<this._boxes[u+1]||t>this._boxes[u+2]||e>this._boxes[u+3]||(o<4*this.numItems?(void 0===r||r(c))&&l.push(c):(a.push(c),a.push(s-1)))}s=a.pop(),o=a.pop()}return l},i.prototype.neighbors=function(t,e,i,o,s){if(void 0===i&&(i=1/0),void 0===o&&(o=1/0),this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var a=this._boxes.length-4,l=this._queue,h=[],u=o*o;void 0!==a;){for(var c=Math.min(a+4*this.nodeSize,r(a,this._levelBounds)),_=a;_<c;_+=4){var p=0|this._indices[_>>2],d=n(t,this._boxes[_],this._boxes[_+2]),f=n(e,this._boxes[_+1],this._boxes[_+3]),v=d*d+f*f;a<4*this.numItems?(void 0===s||s(p))&&l.push(-p-1,v):l.push(p,v)}for(;l.length&&l.peek()<0;){var m=l.peekValue();if(m>u)return l.clear(),h;if(h.push(-l.pop()-1),h.length===i)return l.clear(),h}a=l.pop()}return l.clear(),h},i},"object"==typeof i&&void 0!==e?e.exports=r():(n=n||self).Flatbush=r()},function(t,e,i){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var o,s=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),l="function",h=Math.round,u=Math.abs,c=Date.now;function _(t,e,i){return setTimeout(y(t,i),e)}function p(t,e,i){return!!Array.isArray(t)&&(d(t,i[e],i),!0)}function d(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function f(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",o=t.console&&(t.console.warn||t.console.log);return o&&o.call(t.console,r,n),e.apply(this,arguments)}}o="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var o in n)n.hasOwnProperty(o)&&(e[o]=n[o])}return e}:Object.assign;var v=f(function(t,e,i){for(var n=Object.keys(e),o=0;o<n.length;)(!i||i&&t[n[o]]===r)&&(t[n[o]]=e[n[o]]),o++;return t},"extend","Use `assign`."),m=f(function(t,e){return v(t,e,!0)},"merge","Use `assign`.");function g(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&o(n,i)}function y(t,e){return function(){return t.apply(e,arguments)}}function b(t,e){return typeof t==l?t.apply(e&&e[0]||r,e):t}function x(t,e){return t===r?e:t}function w(t,e,i){d(S(e),function(e){t.addEventListener(e,i,!1)})}function k(t,e,i){d(S(e),function(e){t.removeEventListener(e,i,!1)})}function T(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function A(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function M(t){return Array.prototype.slice.call(t,0)}function E(t,e,i){for(var n=[],r=[],o=0;o<t.length;){var s=e?t[o][e]:t[o];A(r,s)<0&&n.push(t[o]),r[o]=s,o++}return i&&(n=e?n.sort(function(t,i){return t[e]>i[e]}):n.sort()),n}function z(t,e){for(var i,n,o=e[0].toUpperCase()+e.slice(1),a=0;a<s.length;){if(i=s[a],(n=i?i+o:e)in t)return n;a++}return r}var O=1;function P(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var j="ontouchstart"in t,N=z(t,"PointerEvent")!==r,D=j&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),F=25,B=1,R=2,I=4,L=8,V=1,G=2,U=4,Y=8,q=16,X=G|U,H=Y|q,W=X|H,J=["x","y"],K=["clientX","clientY"];function $(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){b(t.options.enable,[t])&&i.handler(e)},this.init()}function Z(t,e,i){var n=i.pointers.length,o=i.changedPointers.length,s=e&B&&n-o==0,a=e&(I|L)&&n-o==0;i.isFirst=!!s,i.isFinal=!!a,s&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,o=n.length;i.firstInput||(i.firstInput=Q(e)),o>1&&!i.firstMultiple?i.firstMultiple=Q(e):1===o&&(i.firstMultiple=!1);var s=i.firstInput,a=i.firstMultiple,l=a?a.center:s.center,h=e.center=tt(n);e.timeStamp=c(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=rt(l,h),e.distance=nt(l,h),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},o=t.prevInput||{};e.eventType!==B&&o.eventType!==I||(r=t.prevDelta={x:o.deltaX||0,y:o.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y}),e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=it(e.deltaX,e.deltaY);var _,p,d=et(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=d.x,e.overallVelocityY=d.y,e.overallVelocity=u(d.x)>u(d.y)?d.x:d.y,e.scale=a?(_=a.pointers,nt((p=n)[0],p[1],K)/nt(_[0],_[1],K)):1,e.rotation=a?function(t,e){return rt(e[1],e[0],K)+rt(t[1],t[0],K)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,o,s,a=t.lastInterval||e,l=e.timeStamp-a.timeStamp;if(e.eventType!=L&&(l>F||a.velocity===r)){var h=e.deltaX-a.deltaX,c=e.deltaY-a.deltaY,_=et(l,h,c);n=_.x,o=_.y,i=u(_.x)>u(_.y)?_.x:_.y,s=it(h,c),t.lastInterval=e}else i=a.velocity,n=a.velocityX,o=a.velocityY,s=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=o,e.direction=s}(i,e);var f=t.element;T(e.srcEvent.target,f)&&(f=e.srcEvent.target),e.target=f}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function Q(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:c(),pointers:e,center:tt(e),deltaX:t.deltaX,deltaY:t.deltaY}}function tt(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function et(t,e,i){return{x:e/t||0,y:i/t||0}}function it(t,e){return t===e?V:u(t)>=u(e)?t<0?G:U:e<0?Y:q}function nt(t,e,i){i||(i=J);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function rt(t,e,i){i||(i=J);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}$.prototype={handler:function(){},init:function(){this.evEl&&w(this.element,this.evEl,this.domHandler),this.evTarget&&w(this.target,this.evTarget,this.domHandler),this.evWin&&w(P(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&k(this.element,this.evEl,this.domHandler),this.evTarget&&k(this.target,this.evTarget,this.domHandler),this.evWin&&k(P(this.element),this.evWin,this.domHandler)}};var ot={mousedown:B,mousemove:R,mouseup:I},st="mousedown",at="mousemove mouseup";function lt(){this.evEl=st,this.evWin=at,this.pressed=!1,$.apply(this,arguments)}g(lt,$,{handler:function(t){var e=ot[t.type];e&B&&0===t.button&&(this.pressed=!0),e&R&&1!==t.which&&(e=I),this.pressed&&(e&I&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var ht={pointerdown:B,pointermove:R,pointerup:I,pointercancel:L,pointerout:L},ut={2:"touch",3:"pen",4:"mouse",5:"kinect"},ct="pointerdown",_t="pointermove pointerup pointercancel";function pt(){this.evEl=ct,this.evWin=_t,$.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(ct="MSPointerDown",_t="MSPointerMove MSPointerUp MSPointerCancel"),g(pt,$,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=ht[n],o=ut[t.pointerType]||t.pointerType,s="touch"==o,a=A(e,t.pointerId,"pointerId");r&B&&(0===t.button||s)?a<0&&(e.push(t),a=e.length-1):r&(I|L)&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:o,srcEvent:t}),i&&e.splice(a,1))}});var dt={touchstart:B,touchmove:R,touchend:I,touchcancel:L},ft="touchstart",vt="touchstart touchmove touchend touchcancel";function mt(){this.evTarget=ft,this.evWin=vt,this.started=!1,$.apply(this,arguments)}g(mt,$,{handler:function(t){var e=dt[t.type];if(e===B&&(this.started=!0),this.started){var i=function(t,e){var i=M(t.touches),n=M(t.changedTouches);return e&(I|L)&&(i=E(i.concat(n),"identifier",!0)),[i,n]}.call(this,t,e);e&(I|L)&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:"touch",srcEvent:t})}}});var gt={touchstart:B,touchmove:R,touchend:I,touchcancel:L},yt="touchstart touchmove touchend touchcancel";function bt(){this.evTarget=yt,this.targetIds={},$.apply(this,arguments)}g(bt,$,{handler:function(t){var e=gt[t.type],i=function(t,e){var i=M(t.touches),n=this.targetIds;if(e&(B|R)&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,o,s=M(t.changedTouches),a=[],l=this.target;if(o=i.filter(function(t){return T(t.target,l)}),e===B)for(r=0;r<o.length;)n[o[r].identifier]=!0,r++;for(r=0;r<s.length;)n[s[r].identifier]&&a.push(s[r]),e&(I|L)&&delete n[s[r].identifier],r++;return a.length?[E(o.concat(a),"identifier",!0),a]:void 0}.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:"touch",srcEvent:t})}});var xt=2500,wt=25;function kt(){$.apply(this,arguments);var t=y(this.handler,this);this.touch=new bt(this.manager,t),this.mouse=new lt(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function Tt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout(function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)},xt)}}g(kt,$,{handler:function(t,e,i){var n="touch"==i.pointerType,r="mouse"==i.pointerType;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)(function(t,e){t&B?(this.primaryTouch=e.changedPointers[0].identifier,Tt.call(this,e)):t&(I|L)&&Tt.call(this,e)}).call(this,e,i);else if(r&&function(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],o=Math.abs(e-r.x),s=Math.abs(i-r.y);if(o<=wt&&s<=wt)return!0}return!1}.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var Ct=z(a.style,"touchAction"),St=Ct!==r,At="auto",Mt="manipulation",Et="none",zt="pan-x",Ot="pan-y",Pt=function(){if(!St)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(n){e[n]=!i||t.CSS.supports("touch-action",n)}),e}();function jt(t,e){this.manager=t,this.set(e)}jt.prototype={set:function(t){"compute"==t&&(t=this.compute()),St&&this.manager.element.style&&Pt[t]&&(this.manager.element.style[Ct]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return d(this.manager.recognizers,function(e){b(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))}),function(t){if(C(t,Et))return Et;var e=C(t,zt),i=C(t,Ot);return e&&i?Et:e||i?e?zt:Ot:C(t,Mt)?Mt:At}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=C(n,Et)&&!Pt[Et],o=C(n,Ot)&&!Pt[Ot],s=C(n,zt)&&!Pt[zt];if(r){var a=1===t.pointers.length,l=t.distance<2,h=t.deltaTime<250;if(a&&l&&h)return}if(!s||!o)return r||o&&i&X||s&&i&H?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var Nt=1,Dt=2,Ft=4,Bt=8,Rt=Bt,It=16;function Lt(t){this.options=o({},this.defaults,t||{}),this.id=O++,this.manager=null,this.options.enable=x(this.options.enable,!0),this.state=Nt,this.simultaneous={},this.requireFail=[]}function Vt(t){return t&It?"cancel":t&Bt?"end":t&Ft?"move":t&Dt?"start":""}function Gt(t){return t==q?"down":t==Y?"up":t==G?"left":t==U?"right":""}function Ut(t,e){var i=e.manager;return i?i.get(t):t}function Yt(){Lt.apply(this,arguments)}function qt(){Yt.apply(this,arguments),this.pX=null,this.pY=null}function Xt(){Yt.apply(this,arguments)}function Ht(){Lt.apply(this,arguments),this._timer=null,this._input=null}function Wt(){Yt.apply(this,arguments)}function Jt(){Yt.apply(this,arguments)}function Kt(){Lt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function $t(t,e){return(e=e||{}).recognizers=x(e.recognizers,$t.defaults.preset),new Zt(t,e)}function Zt(t,e){var i;this.options=o({},$t.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(N?pt:D?bt:j?kt:lt))(i,Z),this.touchAction=new jt(this,this.options.touchAction),Qt(this,!0),d(this.options.recognizers,function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}function Qt(t,e){var i,n=t.element;n.style&&(d(t.options.cssProps,function(r,o){i=z(n.style,o),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""}),e||(t.oldCssProps={}))}Lt.prototype={defaults:{},set:function(t){return o(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return t=Ut(t,this),e[t.id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)?this:(t=Ut(t,this),delete this.simultaneous[t.id],this)},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return t=Ut(t,this),-1===A(e,t)&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=Ut(t,this);var e=A(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<Bt&&n(e.options.event+Vt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=Bt&&n(e.options.event+Vt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(this.requireFail[t].state&(32|Nt)))return!1;t++}return!0},recognize:function(t){var e=o({},t);if(!b(this.options.enable,[this,e]))return this.reset(),void(this.state=32);this.state&(Rt|It|32)&&(this.state=Nt),this.state=this.process(e),this.state&(Dt|Ft|Bt|It)&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Yt,Lt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=e&(Dt|Ft),r=this.attrTest(t);return n&&(i&L||!r)?e|It:n||r?i&I?e|Bt:e&Dt?e|Ft:Dt:32}}),g(qt,Yt,{defaults:{event:"pan",threshold:10,pointers:1,direction:W},getTouchAction:function(){var t=this.options.direction,e=[];return t&X&&e.push(Ot),t&H&&e.push(zt),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,o=t.deltaX,s=t.deltaY;return r&e.direction||(e.direction&X?(r=0===o?V:o<0?G:U,i=o!=this.pX,n=Math.abs(t.deltaX)):(r=0===s?V:s<0?Y:q,i=s!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Yt.prototype.attrTest.call(this,t)&&(this.state&Dt||!(this.state&Dt)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=Gt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Xt,Yt,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[Et]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||this.state&Dt)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(Ht,Lt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[At]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||t.eventType&(I|L)&&!r)this.reset();else if(t.eventType&B)this.reset(),this._timer=_(function(){this.state=Rt,this.tryEmit()},e.time,this);else if(t.eventType&I)return Rt;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){this.state===Rt&&(t&&t.eventType&I?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Wt,Yt,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[Et]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||this.state&Dt)}}),g(Jt,Yt,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:X|H,pointers:1},getTouchAction:function(){return qt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return i&(X|H)?e=t.overallVelocity:i&X?e=t.overallVelocityX:i&H&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&t.eventType&I},emit:function(t){var e=Gt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Kt,Lt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Mt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),t.eventType&B&&0===this.count)return this.failTimeout();if(n&&r&&i){if(t.eventType!=I)return this.failTimeout();var o=!this.pTime||t.timeStamp-this.pTime<e.interval,s=!this.pCenter||nt(this.pCenter,t.center)<e.posThreshold;this.pTime=t.timeStamp,this.pCenter=t.center,s&&o?this.count+=1:this.count=1,this._input=t;var a=this.count%e.taps;if(0===a)return this.hasRequireFailures()?(this._timer=_(function(){this.state=Rt,this.tryEmit()},e.interval,this),Dt):Rt}return 32},failTimeout:function(){return this._timer=_(function(){this.state=32},this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){this.state==Rt&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),$t.VERSION="2.0.7",$t.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[Wt,{enable:!1}],[Xt,{enable:!1},["rotate"]],[Jt,{direction:X}],[qt,{direction:X},["swipe"]],[Kt],[Kt,{event:"doubletap",taps:2},["tap"]],[Ht]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},Zt.prototype={set:function(t){return o(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&r.state&Rt)&&(r=e.curRecognizer=null);for(var o=0;o<n.length;)i=n[o],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&i.state&(Dt|Ft|Bt)&&(r=e.curRecognizer=i),o++}},get:function(t){if(t instanceof Lt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=A(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return d(S(t),function(t){i[t]=i[t]||[],i[t].push(e)}),this}},off:function(t,e){if(t!==r){var i=this.handlers;return d(S(t),function(t){e?i[t]&&i[t].splice(A(i[t],e),1):delete i[t]}),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&Qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},o($t,{INPUT_START:B,INPUT_MOVE:R,INPUT_END:I,INPUT_CANCEL:L,STATE_POSSIBLE:Nt,STATE_BEGAN:Dt,STATE_CHANGED:Ft,STATE_ENDED:Bt,STATE_RECOGNIZED:Rt,STATE_CANCELLED:It,STATE_FAILED:32,DIRECTION_NONE:V,DIRECTION_LEFT:G,DIRECTION_RIGHT:U,DIRECTION_UP:Y,DIRECTION_DOWN:q,DIRECTION_HORIZONTAL:X,DIRECTION_VERTICAL:H,DIRECTION_ALL:W,Manager:Zt,Input:$,TouchAction:jt,TouchInput:bt,MouseInput:lt,PointerEventInput:pt,TouchMouseInput:kt,SingleTouchInput:mt,Recognizer:Lt,AttrRecognizer:Yt,Tap:Kt,Pan:qt,Swipe:Jt,Pinch:Xt,Rotate:Wt,Press:Ht,on:w,off:k,each:d,merge:m,extend:v,assign:o,inherit:g,bindFn:y,prefixed:z});var te=void 0!==t?t:"undefined"!=typeof self?self:{};te.Hammer=$t,void 0!==e&&e.exports?e.exports=$t:t.Hammer=$t}(window,document)},function(t,e,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var n,r={},o=r,s="en-US",a=null,l="0,0";function h(t){this._value=t}function u(t){var e,i="";for(e=0;e<t;e++)i+="0";return i}function c(t,e,i,n){var r,o,s=Math.pow(10,e);return o=t.toFixed(0).search("e")>-1?function(t,e){var i,n,r,o,s;return s=t.toString(),i=s.split("e")[0],o=s.split("e")[1],n=i.split(".")[0],r=i.split(".")[1]||"",s=n+r+u(o-r.length),e>0&&(s+="."+u(e)),s}(t,e):(i(t*s)/s).toFixed(e),n&&(r=new RegExp("0{1,"+n+"}$"),o=o.replace(r,"")),o}function _(t,e,i){return e.indexOf("$")>-1?function(t,e,i){var n,o,a=e,l=a.indexOf("$"),h=a.indexOf("("),u=a.indexOf("+"),c=a.indexOf("-"),_="",d="";if(-1===a.indexOf("$")?"infix"===r[s].currency.position?(d=r[s].currency.symbol,r[s].currency.spaceSeparated&&(d=" "+d+" ")):r[s].currency.spaceSeparated&&(_=" "):a.indexOf(" $")>-1?(_=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(_=" ",a=a.replace("$ ","")):a=a.replace("$",""),o=p(t,a,i,d),-1===e.indexOf("$"))switch(r[s].currency.position){case"postfix":o.indexOf(")")>-1?((o=o.split("")).splice(-1,0,_+r[s].currency.symbol),o=o.join("")):o=o+_+r[s].currency.symbol;break;case"infix":break;case"prefix":o.indexOf("(")>-1||o.indexOf("-")>-1?(o=o.split(""),n=Math.max(h,c)+1,o.splice(n,0,r[s].currency.symbol+_),o=o.join("")):o=r[s].currency.symbol+_+o;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?o.indexOf("(")>-1||o.indexOf("+")>-1||o.indexOf("-")>-1?(o=o.split(""),n=1,(l<h||l<u||l<c)&&(n=0),o.splice(n,0,r[s].currency.symbol+_),o=o.join("")):o=r[s].currency.symbol+_+o:o.indexOf(")")>-1?((o=o.split("")).splice(-1,0,_+r[s].currency.symbol),o=o.join("")):o=o+_+r[s].currency.symbol;return o}(t,e,i):e.indexOf("%")>-1?function(t,e,i){var n,r="";return t*=100,e.indexOf(" %")>-1?(r=" ",e=e.replace(" %","")):e=e.replace("%",""),(n=p(t,e,i)).indexOf(")")>-1?((n=n.split("")).splice(-1,0,r+"%"),n=n.join("")):n=n+r+"%",n}(t,e,i):e.indexOf(":")>-1?function(t){var e=Math.floor(t/60/60),i=Math.floor((t-60*e*60)/60),n=Math.round(t-60*e*60-60*i);return e+":"+(i<10?"0"+i:i)+":"+(n<10?"0"+n:n)}(t):p(t,e,i)}function p(t,e,i,n){var o,l,h,u,_,p,d,f,v,m,g,y,b,x,w,k,T,C,S,A=!1,M=!1,E=!1,z="",O=!1,P=!1,j=!1,N=!1,D=!1,F="",B="",R=Math.abs(t),I=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],L=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],V="",G=!1,U=!1;if(0===t&&null!==a)return a;if(!isFinite(t))return""+t;if(0===e.indexOf("{")){var Y=e.indexOf("}");if(-1===Y)throw Error('Format should also contain a "}"');y=e.slice(1,Y),e=e.slice(Y+1)}else y="";if(e.indexOf("}")===e.length-1){var q=e.indexOf("{");if(-1===q)throw Error('Format should also contain a "{"');b=e.slice(q+1,-1),e=e.slice(0,q+1)}else b="";if(S=-1===e.indexOf(".")?e.match(/([0-9]+).*/):e.match(/([0-9]+)\..*/),C=null===S?-1:S[1].length,-1!==e.indexOf("-")&&(G=!0),e.indexOf("(")>-1?(A=!0,e=e.slice(1,-1)):e.indexOf("+")>-1&&(M=!0,e=e.replace(/\+/g,"")),e.indexOf("a")>-1){if(m=e.split(".")[0].match(/[0-9]+/g)||["0"],m=parseInt(m[0],10),O=e.indexOf("aK")>=0,P=e.indexOf("aM")>=0,j=e.indexOf("aB")>=0,N=e.indexOf("aT")>=0,D=O||P||j||N,e.indexOf(" a")>-1?(z=" ",e=e.replace(" a","")):e=e.replace("a",""),_=Math.floor(Math.log(R)/Math.LN10)+1,d=0==(d=_%3)?3:d,m&&0!==R&&(p=Math.floor(Math.log(R)/Math.LN10)+1-m,f=3*~~((Math.min(m,_)-d)/3),R/=Math.pow(10,f),-1===e.indexOf(".")&&m>3))for(e+="[.]",k=(k=0===p?0:3*~~(p/3)-p)<0?k+3:k,o=0;o<k;o++)e+="0";Math.floor(Math.log(Math.abs(t))/Math.LN10)+1!==m&&(R>=Math.pow(10,12)&&!D||N?(z+=r[s].abbreviations.trillion,t/=Math.pow(10,12)):R<Math.pow(10,12)&&R>=Math.pow(10,9)&&!D||j?(z+=r[s].abbreviations.billion,t/=Math.pow(10,9)):R<Math.pow(10,9)&&R>=Math.pow(10,6)&&!D||P?(z+=r[s].abbreviations.million,t/=Math.pow(10,6)):(R<Math.pow(10,6)&&R>=Math.pow(10,3)&&!D||O)&&(z+=r[s].abbreviations.thousand,t/=Math.pow(10,3)))}if(e.indexOf("b")>-1)for(e.indexOf(" b")>-1?(F=" ",e=e.replace(" b","")):e=e.replace("b",""),u=0;u<=I.length;u++)if(l=Math.pow(1024,u),h=Math.pow(1024,u+1),t>=l&&t<h){F+=I[u],l>0&&(t/=l);break}if(e.indexOf("d")>-1)for(e.indexOf(" d")>-1?(F=" ",e=e.replace(" d","")):e=e.replace("d",""),u=0;u<=L.length;u++)if(l=Math.pow(1e3,u),h=Math.pow(1e3,u+1),t>=l&&t<h){F+=L[u],l>0&&(t/=l);break}if(e.indexOf("o")>-1&&(e.indexOf(" o")>-1?(B=" ",e=e.replace(" o","")):e=e.replace("o",""),r[s].ordinal&&(B+=r[s].ordinal(t))),e.indexOf("[.]")>-1&&(E=!0,e=e.replace("[.]",".")),v=t.toString().split(".")[0],g=e.split(".")[1],x=e.indexOf(","),g){if(-1!==g.indexOf("*")?V=c(t,t.toString().split(".")[1].length,i):g.indexOf("[")>-1?(g=(g=g.replace("]","")).split("["),V=c(t,g[0].length+g[1].length,i,g[1].length)):V=c(t,g.length,i),v=V.split(".")[0],V.split(".")[1].length){var X=n?z+n:r[s].delimiters.decimal;V=X+V.split(".")[1]}else V="";E&&0===Number(V.slice(1))&&(V="")}else v=c(t,null,i);return v.indexOf("-")>-1&&(v=v.slice(1),U=!0),v.length<C&&(v=new Array(C-v.length+1).join("0")+v),x>-1&&(v=v.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+r[s].delimiters.thousands)),0===e.indexOf(".")&&(v=""),w=e.indexOf("("),T=e.indexOf("-"),y+(w<T?(A&&U?"(":"")+(G&&U||!A&&U?"-":""):(G&&U||!A&&U?"-":"")+(A&&U?"(":""))+(!U&&M&&0!==t?"+":"")+v+V+(B||"")+(z&&!n?z:"")+(F||"")+(A&&U?")":"")+b}function d(t,e){r[t]=e}function f(t){s=t;var e=r[t].defaults;e&&e.format&&n.defaultFormat(e.format),e&&e.currencyFormat&&n.defaultCurrencyFormat(e.currencyFormat)}void 0!==e&&e.exports,(n=function(t){return n.isNumbro(t)?t=t.value():0===t||void 0===t?t=0:Number(t)||(t=n.fn.unformat(t)),new h(Number(t))}).version="1.6.2",n.isNumbro=function(t){return t instanceof h},n.setLanguage=function(t,e){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var i=t,n=t.split("-")[0],r=null;o[i]||(Object.keys(o).forEach(function(t){r||t.split("-")[0]!==n||(r=t)}),i=r||e||"en-US"),f(i)},n.setCulture=function(t,e){var i=t,n=t.split("-")[1],o=null;r[i]||(n&&Object.keys(r).forEach(function(t){o||t.split("-")[1]!==n||(o=t)}),i=o||e||"en-US"),f(i)},n.language=function(t,e){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!t)return s;if(t&&!e){if(!o[t])throw new Error("Unknown language : "+t);f(t)}return!e&&o[t]||d(t,e),n},n.culture=function(t,e){if(!t)return s;if(t&&!e){if(!r[t])throw new Error("Unknown culture : "+t);f(t)}return!e&&r[t]||d(t,e),n},n.languageData=function(t){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!t)return o[s];if(!o[t])throw new Error("Unknown language : "+t);return o[t]},n.cultureData=function(t){if(!t)return r[s];if(!r[t])throw new Error("Unknown culture : "+t);return r[t]},n.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(t){var e=t%10;return 1==~~(t%100/10)?"th":1===e?"st":2===e?"nd":3===e?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),n.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),o},n.cultures=function(){return r},n.zeroFormat=function(t){a="string"==typeof t?t:null},n.defaultFormat=function(t){l="string"==typeof t?t:"0.0"},n.defaultCurrencyFormat=function(t){},n.validate=function(t,e){var i,r,o,s,a,l,h,u;if("string"!=typeof t&&(t+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",t)),(t=t.trim()).match(/^\d+$/))return!0;if(""===t)return!1;try{h=n.cultureData(e)}catch(t){h=n.cultureData(n.culture())}return o=h.currency.symbol,a=h.abbreviations,i=h.delimiters.decimal,r="."===h.delimiters.thousands?"\\.":h.delimiters.thousands,!(null!==(u=t.match(/^[^\d]+/))&&(t=t.substr(1),u[0]!==o)||null!==(u=t.match(/[^\d]+$/))&&(t=t.slice(0,-1),u[0]!==a.thousand&&u[0]!==a.million&&u[0]!==a.billion&&u[0]!==a.trillion)||(l=new RegExp(r+"{2}"),t.match(/[^\d.,]/g)||(s=t.split(i)).length>2||(s.length<2?!s[0].match(/^\d+.*\d$/)||s[0].match(l):1===s[0].length?!s[0].match(/^\d+$/)||s[0].match(l)||!s[1].match(/^\d+$/):!s[0].match(/^\d+.*\d$/)||s[0].match(l)||!s[1].match(/^\d+$/))))},e.exports={format:function(t,e,i,r){return null!=i&&i!==n.culture()&&n.setCulture(i),_(Number(t),null!=e?e:l,null==r?Math.round:r)}}},function(t,e,i){var n=t(399),r=t(397),o=t(401),s=t(396),a=t(387),l=t(392);function h(t,e){if(!(this instanceof h))return new h(t);e=e||function(t){if(t)throw t};var i=n(t);if("object"==typeof i){var o=h.projections.get(i.projName);if(o){if(i.datumCode&&"none"!==i.datumCode){var u=a[i.datumCode];u&&(i.datum_params=u.towgs84?u.towgs84.split(","):null,i.ellps=u.ellipse,i.datumName=u.datumName?u.datumName:i.datumCode)}i.k0=i.k0||1,i.axis=i.axis||"enu";var c=s.sphere(i.a,i.b,i.rf,i.ellps,i.sphere),_=s.eccentricity(c.a,c.b,c.rf,i.R_A),p=i.datum||l(i.datumCode,i.datum_params,c.a,c.b,_.es,_.ep2);r(this,i),r(this,o),this.a=c.a,this.b=c.b,this.rf=c.rf,this.sphere=c.sphere,this.es=_.es,this.e=_.e,this.ep2=_.ep2,this.datum=p,this.init(),e(null,this)}else e(t)}else e(t)}h.projections=o,h.projections.start(),e.exports=h},function(t,e,i){e.exports=function(t,e,i){var n,r,o,s=i.x,a=i.y,l=i.z||0,h={};for(o=0;o<3;o++)if(!e||2!==o||void 0!==i.z)switch(0===o?(n=s,r="x"):1===o?(n=a,r="y"):(n=l,r="z"),t.axis[o]){case"e":h[r]=n;break;case"w":h[r]=-n;break;case"n":h[r]=n;break;case"s":h[r]=-n;break;case"u":void 0!==i[r]&&(h.z=n);break;case"d":void 0!==i[r]&&(h.z=-n);break;default:return null}return h}},function(t,e,i){var n=2*Math.PI,r=t(384);e.exports=function(t){return Math.abs(t)<=3.14159265359?t:t-r(t)*n}},function(t,e,i){e.exports=function(t,e,i){var n=t*e;return i/Math.sqrt(1-n*n)}},function(t,e,i){var n=Math.PI/2;e.exports=function(t,e){for(var i,r,o=.5*t,s=n-2*Math.atan(e),a=0;a<=15;a++)if(i=t*Math.sin(s),r=n-2*Math.atan(e*Math.pow((1-i)/(1+i),o))-s,s+=r,Math.abs(r)<=1e-10)return s;return-9999}},function(t,e,i){e.exports=function(t){return t<0?-1:1}},function(t,e,i){e.exports=function(t){var e={x:t[0],y:t[1]};return t.length>2&&(e.z=t[2]),t.length>3&&(e.m=t[3]),e}},function(t,e,i){var n=Math.PI/2;e.exports=function(t,e,i){var r=t*i,o=.5*t;return r=Math.pow((1-r)/(1+r),o),Math.tan(.5*(n-e))/r}},function(t,e,i){i.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},i.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},i.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},i.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},i.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},i.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},i.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},i.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},i.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},i.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},i.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},i.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},i.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},i.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},i.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},i.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},function(t,e,i){i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},function(t,e,i){i.greenwich=0,i.lisbon=-9.131906111111,i.paris=2.337229166667,i.bogota=-74.080916666667,i.madrid=-3.687938888889,i.rome=12.452333333333,i.bern=7.439583333333,i.jakarta=106.807719444444,i.ferro=-17.666666666667,i.brussels=4.367975,i.stockholm=18.058277777778,i.athens=23.7163375,i.oslo=10.722916666667},function(t,e,i){i.ft={to_meter:.3048},i["us-ft"]={to_meter:1200/3937}},function(t,e,i){var n=t(379),r=t(404),o=n("WGS84");function s(t,e,i){var n;return Array.isArray(i)?(n=r(t,e,i),3===i.length?[n.x,n.y,n.z]:[n.x,n.y]):r(t,e,i)}function a(t){return t instanceof n?t:t.oProj?t.oProj:n(t)}e.exports=function(t,e,i){t=a(t);var n,r=!1;return void 0===e?(e=t,t=o,r=!0):(void 0!==e.x||Array.isArray(e))&&(i=e,e=t,t=o,r=!0),e=a(e),i?s(t,e,i):(n={forward:function(i){return s(t,e,i)},inverse:function(i){return s(e,t,i)}},r&&(n.oProj=e),n)}},function(t,e,i){var n=1,r=2,o=4,s=5,a=484813681109536e-20;e.exports=function(t,e,i,l,h,u){var c={};return c.datum_type=o,t&&"none"===t&&(c.datum_type=s),e&&(c.datum_params=e.map(parseFloat),0===c.datum_params[0]&&0===c.datum_params[1]&&0===c.datum_params[2]||(c.datum_type=n),c.datum_params.length>3&&(0===c.datum_params[3]&&0===c.datum_params[4]&&0===c.datum_params[5]&&0===c.datum_params[6]||(c.datum_type=r,c.datum_params[3]*=a,c.datum_params[4]*=a,c.datum_params[5]*=a,c.datum_params[6]=c.datum_params[6]/1e6+1))),c.a=i,c.b=l,c.es=h,c.ep2=u,c}},function(t,e,i){var n=Math.PI/2;i.compareDatums=function(t,e){return t.datum_type===e.datum_type&&!(t.a!==e.a||Math.abs(this.es-e.es)>5e-11)&&(1===t.datum_type?this.datum_params[0]===e.datum_params[0]&&t.datum_params[1]===e.datum_params[1]&&t.datum_params[2]===e.datum_params[2]:2!==t.datum_type||t.datum_params[0]===e.datum_params[0]&&t.datum_params[1]===e.datum_params[1]&&t.datum_params[2]===e.datum_params[2]&&t.datum_params[3]===e.datum_params[3]&&t.datum_params[4]===e.datum_params[4]&&t.datum_params[5]===e.datum_params[5]&&t.datum_params[6]===e.datum_params[6])},i.geodeticToGeocentric=function(t,e,i){var r,o,s,a,l=t.x,h=t.y,u=t.z?t.z:0;if(h<-n&&h>-1.001*n)h=-n;else if(h>n&&h<1.001*n)h=n;else if(h<-n||h>n)return null;return l>Math.PI&&(l-=2*Math.PI),o=Math.sin(h),a=Math.cos(h),s=o*o,{x:((r=i/Math.sqrt(1-e*s))+u)*a*Math.cos(l),y:(r+u)*a*Math.sin(l),z:(r*(1-e)+u)*o}},i.geocentricToGeodetic=function(t,e,i,r){var o,s,a,l,h,u,c,_,p,d,f,v,m,g,y,b,x=t.x,w=t.y,k=t.z?t.z:0;if(o=Math.sqrt(x*x+w*w),s=Math.sqrt(x*x+w*w+k*k),o/i<1e-12){if(g=0,s/i<1e-12)return y=n,b=-r,{x:t.x,y:t.y,z:t.z}}else g=Math.atan2(w,x);a=k/s,l=o/s,h=1/Math.sqrt(1-e*(2-e)*l*l),_=l*(1-e)*h,p=a*h,m=0;do{m++,c=i/Math.sqrt(1-e*p*p),u=e*c/(c+(b=o*_+k*p-c*(1-e*p*p))),h=1/Math.sqrt(1-u*(2-u)*l*l),v=(f=a*h)*_-(d=l*(1-u)*h)*p,_=d,p=f}while(v*v>1e-24&&m<30);return y=Math.atan(f/Math.abs(d)),{x:g,y:y,z:b}},i.geocentricToWgs84=function(t,e,i){if(1===e)return{x:t.x+i[0],y:t.y+i[1],z:t.z+i[2]};if(2===e){var n=i[0],r=i[1],o=i[2],s=i[3],a=i[4],l=i[5],h=i[6];return{x:h*(t.x-l*t.y+a*t.z)+n,y:h*(l*t.x+t.y-s*t.z)+r,z:h*(-a*t.x+s*t.y+t.z)+o}}},i.geocentricFromWgs84=function(t,e,i){if(1===e)return{x:t.x-i[0],y:t.y-i[1],z:t.z-i[2]};if(2===e){var n=i[0],r=i[1],o=i[2],s=i[3],a=i[4],l=i[5],h=i[6],u=(t.x-n)/h,c=(t.y-r)/h,_=(t.z-o)/h;return{x:u+l*c-a*_,y:-l*u+c+s*_,z:a*u-s*c+_}}}},function(t,e,i){var n=1,r=2,o=t(393);function s(t){return t===n||t===r}e.exports=function(t,e,i){return o.compareDatums(t,e)?i:5===t.datum_type||5===e.datum_type?i:t.es!==e.es||t.a!==e.a||s(t.datum_type)||s(e.datum_type)?(i=o.geodeticToGeocentric(i,t.es,t.a),s(t.datum_type)&&(i=o.geocentricToWgs84(i,t.datum_type,t.datum_params)),s(e.datum_type)&&(i=o.geocentricFromWgs84(i,e.datum_type,e.datum_params)),o.geocentricToGeodetic(i,e.es,e.a,e.b)):i}},function(t,e,i){var n=t(398),r=t(400),o=t(405);function s(t){var e=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?s[t]=r(arguments[1]):s[t]=o(arguments[1]):s[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map(function(t){Array.isArray(t)?s.apply(e,t):s(t)});if("string"==typeof t){if(t in s)return s[t]}else"EPSG"in t?s["EPSG:"+t.EPSG]=t:"ESRI"in t?s["ESRI:"+t.ESRI]=t:"IAU2000"in t?s["IAU2000:"+t.IAU2000]=t:console.log(t);return}}n(s),e.exports=s},function(t,e,i){var n=t(388);i.eccentricity=function(t,e,i,n){var r=t*t,o=e*e,s=(r-o)/r,a=0;n?(r=(t*=1-s*(.16666666666666666+s*(.04722222222222222+.022156084656084655*s)))*t,s=0):a=Math.sqrt(s);var l=(r-o)/o;return{es:s,e:a,ep2:l}},i.sphere=function(t,e,i,r,o){if(!t){var s=n[r];s||(s=n.WGS84),t=s.a,e=s.b,i=s.rf}return i&&!e&&(e=(1-1/i)*t),(0===i||Math.abs(t-e)<1e-10)&&(o=!0,e=t),{a:t,b:e,rf:i,sphere:o}}},function(t,e,i){e.exports=function(t,e){var i,n;if(t=t||{},!e)return t;for(n in e)void 0!==(i=e[n])&&(t[n]=i);return t}},function(t,e,i){e.exports=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},function(t,e,i){var n=t(395),r=t(405),o=t(400),s=["GEOGCS","GEOCCS","PROJCS","LOCAL_CS"];e.exports=function(t){return function(t){return"string"==typeof t}(t)?function(t){return t in n}(t)?n[t]:function(t){return s.some(function(e){return t.indexOf(e)>-1})}(t)?r(t):function(t){return"+"===t[0]}(t)?o(t):void 0:t}},function(t,e,i){var n=.017453292519943295,r=t(389),o=t(390);e.exports=function(t){var e,i,s,a={},l=t.split("+").map(function(t){return t.trim()}).filter(function(t){return t}).reduce(function(t,e){var i=e.split("=");return i.push(!0),t[i[0].toLowerCase()]=i[1],t},{}),h={proj:"projName",datum:"datumCode",rf:function(t){a.rf=parseFloat(t)},lat_0:function(t){a.lat0=t*n},lat_1:function(t){a.lat1=t*n},lat_2:function(t){a.lat2=t*n},lat_ts:function(t){a.lat_ts=t*n},lon_0:function(t){a.long0=t*n},lon_1:function(t){a.long1=t*n},lon_2:function(t){a.long2=t*n},alpha:function(t){a.alpha=parseFloat(t)*n},lonc:function(t){a.longc=t*n},x_0:function(t){a.x0=parseFloat(t)},y_0:function(t){a.y0=parseFloat(t)},k_0:function(t){a.k0=parseFloat(t)},k:function(t){a.k0=parseFloat(t)},a:function(t){a.a=parseFloat(t)},b:function(t){a.b=parseFloat(t)},r_a:function(){a.R_A=!0},zone:function(t){a.zone=parseInt(t,10)},south:function(){a.utmSouth=!0},towgs84:function(t){a.datum_params=t.split(",").map(function(t){return parseFloat(t)})},to_meter:function(t){a.to_meter=parseFloat(t)},units:function(t){a.units=t,o[t]&&(a.to_meter=o[t].to_meter)},from_greenwich:function(t){a.from_greenwich=t*n},pm:function(t){a.from_greenwich=(r[t]?r[t]:parseFloat(t))*n},nadgrids:function(t){"@null"===t?a.datumCode="none":a.nadgrids=t},axis:function(t){3===t.length&&-1!=="ewnsud".indexOf(t.substr(0,1))&&-1!=="ewnsud".indexOf(t.substr(1,1))&&-1!=="ewnsud".indexOf(t.substr(2,1))&&(a.axis=t)}};for(e in l)i=l[e],e in h?"function"==typeof(s=h[e])?s(i):a[s]=i:a[e]=i;return"string"==typeof a.datumCode&&"WGS84"!==a.datumCode&&(a.datumCode=a.datumCode.toLowerCase()),a}},function(t,e,i){var n=[t(403),t(402)],r={},o=[];function s(t,e){var i=o.length;return t.names?(o[i]=t,t.names.forEach(function(t){r[t.toLowerCase()]=i}),this):(console.log(e),!0)}i.add=s,i.get=function(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==r[e]&&o[r[e]]?o[r[e]]:void 0},i.start=function(){n.forEach(s)}},function(t,e,i){function n(t){return t}i.init=function(){},i.forward=n,i.inverse=n,i.names=["longlat","identity"]},function(t,e,i){var n=t(382),r=Math.PI/2,o=57.29577951308232,s=t(381),a=Math.PI/4,l=t(386),h=t(383);i.init=function(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=n(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)},i.forward=function(t){var e,i,n=t.x,h=t.y;if(h*o>90&&h*o<-90&&n*o>180&&n*o<-180)return null;if(Math.abs(Math.abs(h)-r)<=1e-10)return null;if(this.sphere)e=this.x0+this.a*this.k0*s(n-this.long0),i=this.y0+this.a*this.k0*Math.log(Math.tan(a+.5*h));else{var u=Math.sin(h),c=l(this.e,h,u);e=this.x0+this.a*this.k0*s(n-this.long0),i=this.y0-this.a*this.k0*Math.log(c)}return t.x=e,t.y=i,t},i.inverse=function(t){var e,i,n=t.x-this.x0,o=t.y-this.y0;if(this.sphere)i=r-2*Math.atan(Math.exp(-o/(this.a*this.k0)));else{var a=Math.exp(-o/(this.a*this.k0));if(-9999===(i=h(this.e,a)))return null}return e=s(this.long0+n/(this.a*this.k0)),t.x=e,t.y=i,t},i.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"]},function(t,e,i){var n=.017453292519943295,r=57.29577951308232,o=1,s=2,a=t(394),l=t(380),h=t(379),u=t(385);e.exports=function t(e,i,c){var _;return Array.isArray(c)&&(c=u(c)),e.datum&&i.datum&&function(t,e){return(t.datum.datum_type===o||t.datum.datum_type===s)&&"WGS84"!==e.datumCode||(e.datum.datum_type===o||e.datum.datum_type===s)&&"WGS84"!==t.datumCode}(e,i)&&(_=new h("WGS84"),c=t(e,_,c),e=_),"enu"!==e.axis&&(c=l(e,!1,c)),"longlat"===e.projName?c={x:c.x*n,y:c.y*n}:(e.to_meter&&(c={x:c.x*e.to_meter,y:c.y*e.to_meter}),c=e.inverse(c)),e.from_greenwich&&(c.x+=e.from_greenwich),c=a(e.datum,i.datum,c),i.from_greenwich&&(c={x:c.x-i.grom_greenwich,y:c.y}),"longlat"===i.projName?c={x:c.x*r,y:c.y*r}:(c=i.forward(c),i.to_meter&&(c={x:c.x/i.to_meter,y:c.y/i.to_meter})),"enu"!==i.axis?l(i,!0,c):c}},function(t,e,i){var n=.017453292519943295,r=t(397);function o(t,e,i){t[e]=i.map(function(t){var e={};return s(t,e),e}).reduce(function(t,e){return r(t,e)},{})}function s(t,e){var i;Array.isArray(t)?("PARAMETER"===(i=t.shift())&&(i=t.shift()),1===t.length?Array.isArray(t[0])?(e[i]={},s(t[0],e[i])):e[i]=t[0]:t.length?"TOWGS84"===i?e[i]=t:(e[i]={},["UNIT","PRIMEM","VERT_DATUM"].indexOf(i)>-1?(e[i]={name:t[0].toLowerCase(),convert:t[1]},3===t.length&&(e[i].auth=t[2])):"SPHEROID"===i?(e[i]={name:t[0],a:t[1],rf:t[2]},4===t.length&&(e[i].auth=t[3])):["GEOGCS","GEOCCS","DATUM","VERT_CS","COMPD_CS","LOCAL_CS","FITTED_CS","LOCAL_DATUM"].indexOf(i)>-1?(t[0]=["name",t[0]],o(e,i,t)):t.every(function(t){return Array.isArray(t)})?o(e,i,t):s(t,e[i])):e[i]=!0):e[t]=!0}function a(t){return t*n}e.exports=function(t,e){var i=JSON.parse((","+t).replace(/\s*\,\s*([A-Z_0-9]+?)(\[)/g,',["$1",').slice(1).replace(/\s*\,\s*([A-Z_0-9]+?)\]/g,',"$1"]').replace(/,\["VERTCS".+/,"")),n=i.shift(),o=i.shift();i.unshift(["name",o]),i.unshift(["type",n]),i.unshift("output");var l={};return s(i,l),function(t){function e(e){var i=t.to_meter||1;return parseFloat(e,10)*i}"GEOGCS"===t.type?t.projName="longlat":"LOCAL_CS"===t.type?(t.projName="identity",t.local=!0):"object"==typeof t.PROJECTION?t.projName=Object.keys(t.PROJECTION)[0]:t.projName=t.PROJECTION,t.UNIT&&(t.units=t.UNIT.name.toLowerCase(),"metre"===t.units&&(t.units="meter"),t.UNIT.convert&&("GEOGCS"===t.type?t.DATUM&&t.DATUM.SPHEROID&&(t.to_meter=parseFloat(t.UNIT.convert,10)*t.DATUM.SPHEROID.a):t.to_meter=parseFloat(t.UNIT.convert,10))),t.GEOGCS&&(t.GEOGCS.DATUM?t.datumCode=t.GEOGCS.DATUM.name.toLowerCase():t.datumCode=t.GEOGCS.name.toLowerCase(),"d_"===t.datumCode.slice(0,2)&&(t.datumCode=t.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==t.datumCode&&"new_zealand_1949"!==t.datumCode||(t.datumCode="nzgd49"),"wgs_1984"===t.datumCode&&("Mercator_Auxiliary_Sphere"===t.PROJECTION&&(t.sphere=!0),t.datumCode="wgs84"),"_ferro"===t.datumCode.slice(-6)&&(t.datumCode=t.datumCode.slice(0,-6)),"_jakarta"===t.datumCode.slice(-8)&&(t.datumCode=t.datumCode.slice(0,-8)),~t.datumCode.indexOf("belge")&&(t.datumCode="rnb72"),t.GEOGCS.DATUM&&t.GEOGCS.DATUM.SPHEROID&&(t.ellps=t.GEOGCS.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===t.ellps.toLowerCase().slice(0,13)&&(t.ellps="intl"),t.a=t.GEOGCS.DATUM.SPHEROID.a,t.rf=parseFloat(t.GEOGCS.DATUM.SPHEROID.rf,10)),~t.datumCode.indexOf("osgb_1936")&&(t.datumCode="osgb36")),t.b&&!isFinite(t.b)&&(t.b=t.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",a],["longitude_of_center","Longitude_Of_Center"],["longc","longitude_of_center",a],["x0","false_easting",e],["y0","false_northing",e],["long0","central_meridian",a],["lat0","latitude_of_origin",a],["lat0","standard_parallel_1",a],["lat1","standard_parallel_1",a],["lat2","standard_parallel_2",a],["alpha","azimuth",a],["srsCode","name"]].forEach(function(e){return i=t,r=(n=e)[0],o=n[1],void(!(r in i)&&o in i&&(i[r]=i[o],3===n.length&&(i[r]=n[2](i[r]))));var i,n,r,o}),t.long0||!t.longc||"Albers_Conic_Equal_Area"!==t.projName&&"Lambert_Azimuthal_Equal_Area"!==t.projName||(t.long0=t.longc),t.lat_ts||!t.lat1||"Stereographic_South_Pole"!==t.projName&&"Polar Stereographic (variant B)"!==t.projName||(t.lat0=a(t.lat1>0?90:-90),t.lat_ts=t.lat1)}(l.output),r(e,l.output)}},function(t,e,i){!function(){"use strict";var t={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function e(i){return function(i,n){var r,o,s,a,l,h,u,c,_,p=1,d=i.length,f="";for(o=0;o<d;o++)if("string"==typeof i[o])f+=i[o];else if("object"==typeof i[o]){if((a=i[o]).keys)for(r=n[p],s=0;s<a.keys.length;s++){if(null==r)throw new Error(e('[sprintf] Cannot access property "%s" of undefined value "%s"',a.keys[s],a.keys[s-1]));r=r[a.keys[s]]}else r=a.param_no?n[a.param_no]:n[p++];if(t.not_type.test(a.type)&&t.not_primitive.test(a.type)&&r instanceof Function&&(r=r()),t.numeric_arg.test(a.type)&&"number"!=typeof r&&isNaN(r))throw new TypeError(e("[sprintf] expecting number but found %T",r));switch(t.number.test(a.type)&&(c=r>=0),a.type){case"b":r=parseInt(r,10).toString(2);break;case"c":r=String.fromCharCode(parseInt(r,10));break;case"d":case"i":r=parseInt(r,10);break;case"j":r=JSON.stringify(r,null,a.width?parseInt(a.width):0);break;case"e":r=a.precision?parseFloat(r).toExponential(a.precision):parseFloat(r).toExponential();break;case"f":r=a.precision?parseFloat(r).toFixed(a.precision):parseFloat(r);break;case"g":r=a.precision?String(Number(r.toPrecision(a.precision))):parseFloat(r);break;case"o":r=(parseInt(r,10)>>>0).toString(8);break;case"s":r=String(r),r=a.precision?r.substring(0,a.precision):r;break;case"t":r=String(!!r),r=a.precision?r.substring(0,a.precision):r;break;case"T":r=Object.prototype.toString.call(r).slice(8,-1).toLowerCase(),r=a.precision?r.substring(0,a.precision):r;break;case"u":r=parseInt(r,10)>>>0;break;case"v":r=r.valueOf(),r=a.precision?r.substring(0,a.precision):r;break;case"x":r=(parseInt(r,10)>>>0).toString(16);break;case"X":r=(parseInt(r,10)>>>0).toString(16).toUpperCase()}t.json.test(a.type)?f+=r:(!t.number.test(a.type)||c&&!a.sign?_="":(_=c?"+":"-",r=r.toString().replace(t.sign,"")),h=a.pad_char?"0"===a.pad_char?"0":a.pad_char.charAt(1):" ",u=a.width-(_+r).length,l=a.width&&u>0?h.repeat(u):"",f+=a.align?_+r+l:"0"===h?_+l+r:l+_+r)}return f}(function(e){if(r[e])return r[e];for(var i,n=e,o=[],s=0;n;){if(null!==(i=t.text.exec(n)))o.push(i[0]);else if(null!==(i=t.modulo.exec(n)))o.push("%");else{if(null===(i=t.placeholder.exec(n)))throw new SyntaxError("[sprintf] unexpected placeholder");if(i[2]){s|=1;var a=[],l=i[2],h=[];if(null===(h=t.key.exec(l)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(a.push(h[1]);""!==(l=l.substring(h[0].length));)if(null!==(h=t.key_access.exec(l)))a.push(h[1]);else{if(null===(h=t.index_access.exec(l)))throw new SyntaxError("[sprintf] failed to parse named argument key");a.push(h[1])}i[2]=a}else s|=2;if(3===s)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");o.push({placeholder:i[0],param_no:i[1],keys:i[2],sign:i[3],pad_char:i[4],align:i[5],width:i[6],precision:i[7],type:i[8]})}n=n.substring(i[0].length)}return r[e]=o}(i),arguments)}function n(t,i){return e.apply(null,[t].concat(i||[]))}var r=Object.create(null);void 0!==i&&(i.sprintf=e,i.vsprintf=n),"undefined"!=typeof window&&(window.sprintf=e,window.vsprintf=n)}()},function(t,e,i){!function(t){"object"==typeof e&&e.exports?e.exports=t():this.tz=t()}(function(){function t(t,e,i){var n,r=e.day[1];do{n=new Date(Date.UTC(i,e.month,Math.abs(r++)))}while(e.day[0]<7&&n.getUTCDay()!=e.day[0]);return(n={clock:e.clock,sort:n.getTime(),rule:e,save:6e4*e.save,offset:t.offset})[n.clock]=n.sort+6e4*e.time,n.posix?n.wallclock=n[n.clock]+(t.offset+e.saved):n.posix=n[n.clock]-(t.offset+e.saved),n}function e(e,i,n){var r,o,s,a,l,h,u,c=e[e.zone],_=[],p=new Date(n).getUTCFullYear(),d=1;for(r=1,o=c.length;r<o&&!(c[r][i]<=n);r++);if((s=c[r]).rules){for(h=e[s.rules],u=p+1;u>=p-d;--u)for(r=0,o=h.length;r<o;r++)h[r].from<=u&&u<=h[r].to?_.push(t(s,h[r],u)):h[r].to<u&&1==d&&(d=u-h[r].to);for(_.sort(function(t,e){return t.sort-e.sort}),r=0,o=_.length;r<o;r++)n>=_[r][i]&&_[r][_[r].clock]>s[_[r].clock]&&(a=_[r])}return a&&((l=/^(.*)\/(.*)$/.exec(s.format))?a.abbrev=l[a.save?2:1]:a.abbrev=s.format.replace(/%s/,a.rule.letter)),a||s}function i(t,i){return"UTC"==t.zone?i:(t.entry=e(t,"posix",i),i+t.entry.offset+t.entry.save)}function n(t,i){return"UTC"==t.zone?i:(t.entry=n=e(t,"wallclock",i),0<(r=i-n.wallclock)&&r<n.save?null:i-n.offset-n.save);var n,r}function r(t,e,r){var o,a=+(r[1]+1),h=r[2]*a,u=s.indexOf(r[3].toLowerCase());if(u>9)e+=h*l[u-10];else{if(o=new Date(i(t,e)),u<7)for(;h;)o.setUTCDate(o.getUTCDate()+a),o.getUTCDay()==u&&(h-=a);else 7==u?o.setUTCFullYear(o.getUTCFullYear()+h):8==u?o.setUTCMonth(o.getUTCMonth()+h):o.setUTCDate(o.getUTCDate()+h);null==(e=n(t,o.getTime()))&&(e=n(t,o.getTime()+864e5*a)-864e5*a)}return e}var o={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(t,e,i,n){var r,o,s=this.entry.offset+this.entry.save,a=Math.abs(s/1e3),l=[],h=3600;for(r=0;r<3;r++)l.push(("0"+Math.floor(a/h)).slice(-2)),a%=h,h/=60;return"^"!=i||s?("^"==i&&(n=3),3==n?(o=(o=l.join(":")).replace(/:00$/,""),"^"!=i&&(o=o.replace(/:00$/,""))):n?(o=l.slice(0,n+1).join(":"),"^"==i&&(o=o.replace(/:00$/,""))):o=l.slice(0,2).join(""),o=(o=(s<0?"-":"+")+o).replace(/([-+])(0)/,{_:" $1","-":"$1"}[i]||"$1$2")):"Z"},"%":function(t){return"%"},n:function(t){return"\n"},t:function(t){return"\t"},U:function(t){return h(t,0)},W:function(t){return h(t,1)},V:function(t){return u(t)[0]},G:function(t){return u(t)[1]},g:function(t){return u(t)[1]%100},j:function(t){return Math.floor((t.getTime()-Date.UTC(t.getUTCFullYear(),0))/864e5)+1},s:function(t){return Math.floor(t.getTime()/1e3)},C:function(t){return Math.floor(t.getUTCFullYear()/100)},N:function(t){return t.getTime()%1e3*1e6},m:function(t){return t.getUTCMonth()+1},Y:function(t){return t.getUTCFullYear()},y:function(t){return t.getUTCFullYear()%100},H:function(t){return t.getUTCHours()},M:function(t){return t.getUTCMinutes()},S:function(t){return t.getUTCSeconds()},e:function(t){return t.getUTCDate()},d:function(t){return t.getUTCDate()},u:function(t){return t.getUTCDay()||7},w:function(t){return t.getUTCDay()},l:function(t){return t.getUTCHours()%12||12},I:function(t){return t.getUTCHours()%12||12},k:function(t){return t.getUTCHours()},Z:function(t){return this.entry.abbrev},a:function(t){return this[this.locale].day.abbrev[t.getUTCDay()]},A:function(t){return this[this.locale].day.full[t.getUTCDay()]},h:function(t){return this[this.locale].month.abbrev[t.getUTCMonth()]},b:function(t){return this[this.locale].month.abbrev[t.getUTCMonth()]},B:function(t){return this[this.locale].month.full[t.getUTCMonth()]},P:function(t){return this[this.locale].meridiem[Math.floor(t.getUTCHours()/12)].toLowerCase()},p:function(t){return this[this.locale].meridiem[Math.floor(t.getUTCHours()/12)]},R:function(t,e){return this.convert([e,"%H:%M"])},T:function(t,e){return this.convert([e,"%H:%M:%S"])},D:function(t,e){return this.convert([e,"%m/%d/%y"])},F:function(t,e){return this.convert([e,"%Y-%m-%d"])},x:function(t,e){return this.convert([e,this[this.locale].date])},r:function(t,e){return this.convert([e,this[this.locale].time12||"%I:%M:%S"])},X:function(t,e){return this.convert([e,this[this.locale].time24])},c:function(t,e){return this.convert([e,this[this.locale].dateTime])},convert:function(t){if(!t.length)return"1.0.22";var e,o,s,l,h,u=Object.create(this),c=[];for(e=0;e<t.length;e++)if(l=t[e],Array.isArray(l))e||isNaN(l[1])?l.splice.apply(t,[e--,1].concat(l)):h=l;else if(isNaN(l)){if("string"==(s=typeof l))~l.indexOf("%")?u.format=l:e||"*"!=l?!e&&(s=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((h=[]).push.apply(h,s.slice(1,8)),s[9]?(h.push(s[10]+1),h.push.apply(h,s[11].split(/:/))):s[8]&&h.push(1)):/^\w{2,3}_\w{2}$/.test(l)?u.locale=l:(s=a.exec(l))?c.push(s):u.zone=l:h=l;else if("function"==s){if(s=l.call(u))return s}else if(/^\w{2,3}_\w{2}$/.test(l.name))u[l.name]=l;else if(l.zones){for(s in l.zones)u[s]=l.zones[s];for(s in l.rules)u[s]=l.rules[s]}}else e||(h=l);if(u[u.locale]||delete u.locale,u[u.zone]||delete u.zone,null!=h){if("*"==h)h=u.clock();else if(Array.isArray(h)){for(s=[],o=!h[7],e=0;e<11;e++)s[e]=+(h[e]||0);--s[1],h=Date.UTC.apply(Date.UTC,s)+-s[7]*(36e5*s[8]+6e4*s[9]+1e3*s[10])}else h=Math.floor(h);if(!isNaN(h)){if(o&&(h=n(u,h)),null==h)return h;for(e=0,o=c.length;e<o;e++)h=r(u,h,c[e]);return u.format?(s=new Date(i(u,h)),u.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,function(t,e,i,n,r){var o,a,l="0";if(o=u[r]){for(t=String(o.call(u,s,h,e,i.length)),"_"==(e||o.style)&&(l=" "),a="-"==e?0:o.pad||0;t.length<a;)t=l+t;for(a="-"==e?0:n||o.pad;t.length<a;)t=l+t;"N"==r&&a<t.length&&(t=t.slice(0,a)),"^"==e&&(t=t.toUpperCase())}return t})):h}}return function(){return u.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},s="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",a=new RegExp("^\\s*([+-])(\\d+)\\s+("+s+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function h(t,e){var i,n,r;return n=new Date(Date.UTC(t.getUTCFullYear(),0)),i=Math.floor((t.getTime()-n.getTime())/864e5),n.getUTCDay()==e?r=0:8==(r=7-n.getUTCDay()+e)&&(r=1),i>=r?Math.floor((i-r)/7)+1:0}function u(t){var e,i,n;return i=t.getUTCFullYear(),e=new Date(Date.UTC(i,0)).getUTCDay(),(n=h(t,1)+(e>1&&e<=4?1:0))?53!=n||4==e||3==e&&29==new Date(i,1,29).getDate()?[n,t.getUTCFullYear()]:[1,t.getUTCFullYear()+1]:(i=t.getUTCFullYear()-1,e=new Date(Date.UTC(i,0)).getUTCDay(),[n=4==e||3==e&&29==new Date(i,1,29).getDate()?53:52,t.getUTCFullYear()-1])}return s=s.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,function(t){o[t].pad=2}),o.N.pad=9,o.j.pad=3,o.k.style="_",o.l.style="_",o.e.style="_",function(){return o.convert(arguments)}})},function(t,e,i){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0
    
    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.
    
    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
var n,r,o,s,a,l,h,u,c,_,p,d,f,v,m,g,y,b,x;!function(t){var i="object"==typeof global?global:"object"==typeof self?self:"object"==typeof this?this:{};function n(t,e){return t!==i&&("function"==typeof Object.create?Object.defineProperty(t,"__esModule",{value:!0}):t.__esModule=!0),function(i,n){return t[i]=e?e(i,n):n}}"object"==typeof e&&"object"==typeof e.exports?t(n(i,n(e.exports))):t(n(i))}(function(t){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])};n=function(t,i){function n(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(n.prototype=i.prototype,new n)},r=Object.assign||function(t){for(var e,i=1,n=arguments.length;i<n;i++)for(var r in e=arguments[i])Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r]);return t},o=function(t,e){var i={};for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&e.indexOf(n)<0&&(i[n]=t[n]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols)for(var r=0,n=Object.getOwnPropertySymbols(t);r<n.length;r++)e.indexOf(n[r])<0&&(i[n[r]]=t[n[r]]);return i},s=function(t,e,i,n){var r,o=arguments.length,s=o<3?e:null===n?n=Object.getOwnPropertyDescriptor(e,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(t,e,i,n);else for(var a=t.length-1;a>=0;a--)(r=t[a])&&(s=(o<3?r(s):o>3?r(e,i,s):r(e,i))||s);return o>3&&s&&Object.defineProperty(e,i,s),s},a=function(t,e){return function(i,n){e(i,n,t)}},l=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},h=function(t,e,i,n){return new(i||(i=Promise))(function(r,o){function s(t){try{l(n.next(t))}catch(t){o(t)}}function a(t){try{l(n.throw(t))}catch(t){o(t)}}function l(t){t.done?r(t.value):new i(function(e){e(t.value)}).then(s,a)}l((n=n.apply(t,e||[])).next())})},u=function(t,e){var i,n,r,o,s={label:0,sent:function(){if(1&r[0])throw r[1];return r[1]},trys:[],ops:[]};return o={next:a(0),throw:a(1),return:a(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function a(o){return function(a){return function(o){if(i)throw new TypeError("Generator is already executing.");for(;s;)try{if(i=1,n&&(r=2&o[0]?n.return:o[0]?n.throw||((r=n.return)&&r.call(n),0):n.next)&&!(r=r.call(n,o[1])).done)return r;switch(n=0,r&&(o=[2&o[0],r.value]),o[0]){case 0:case 1:r=o;break;case 4:return s.label++,{value:o[1],done:!1};case 5:s.label++,n=o[1],o=[0];continue;case 7:o=s.ops.pop(),s.trys.pop();continue;default:if(!(r=(r=s.trys).length>0&&r[r.length-1])&&(6===o[0]||2===o[0])){s=0;continue}if(3===o[0]&&(!r||o[1]>r[0]&&o[1]<r[3])){s.label=o[1];break}if(6===o[0]&&s.label<r[1]){s.label=r[1],r=o;break}if(r&&s.label<r[2]){s.label=r[2],s.ops.push(o);break}r[2]&&s.ops.pop(),s.trys.pop();continue}o=e.call(t,s)}catch(t){o=[6,t],n=0}finally{i=r=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,a])}}},c=function(t,e){for(var i in t)e.hasOwnProperty(i)||(e[i]=t[i])},_=function(t){var e="function"==typeof Symbol&&t[Symbol.iterator],i=0;return e?e.call(t):{next:function(){return t&&i>=t.length&&(t=void 0),{value:t&&t[i++],done:!t}}}},p=function(t,e){var i="function"==typeof Symbol&&t[Symbol.iterator];if(!i)return t;var n,r,o=i.call(t),s=[];try{for(;(void 0===e||e-- >0)&&!(n=o.next()).done;)s.push(n.value)}catch(t){r={error:t}}finally{try{n&&!n.done&&(i=o.return)&&i.call(o)}finally{if(r)throw r.error}}return s},d=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(p(arguments[e]));return t},f=function(t){return this instanceof f?(this.v=t,this):new f(t)},v=function(t,e,i){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n,r=i.apply(t,e||[]),o=[];return n={},s("next"),s("throw"),s("return"),n[Symbol.asyncIterator]=function(){return this},n;function s(t){r[t]&&(n[t]=function(e){return new Promise(function(i,n){o.push([t,e,i,n])>1||a(t,e)})})}function a(t,e){try{(i=r[t](e)).value instanceof f?Promise.resolve(i.value.v).then(l,h):u(o[0][2],i)}catch(t){u(o[0][3],t)}var i}function l(t){a("next",t)}function h(t){a("throw",t)}function u(t,e){t(e),o.shift(),o.length&&a(o[0][0],o[0][1])}},m=function(t){var e,i;return e={},n("next"),n("throw",function(t){throw t}),n("return"),e[Symbol.iterator]=function(){return this},e;function n(n,r){e[n]=t[n]?function(e){return(i=!i)?{value:f(t[n](e)),done:"return"===n}:r?r(e):e}:r}},g=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,i=t[Symbol.asyncIterator];return i?i.call(t):(t=_(t),e={},n("next"),n("throw"),n("return"),e[Symbol.asyncIterator]=function(){return this},e);function n(i){e[i]=t[i]&&function(e){return new Promise(function(n,r){e=t[i](e),function(t,e,i,n){Promise.resolve(n).then(function(e){t({value:e,done:i})},e)}(n,r,e.done,e.value)})}}},y=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t},b=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var i in t)Object.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e.default=t,e},x=function(t){return t&&t.__esModule?t:{default:t}},t("__extends",n),t("__assign",r),t("__rest",o),t("__decorate",s),t("__param",a),t("__metadata",l),t("__awaiter",h),t("__generator",u),t("__exportStar",c),t("__values",_),t("__read",p),t("__spread",d),t("__await",f),t("__asyncGenerator",v),t("__asyncDelegator",m),t("__asyncValues",g),t("__makeTemplateObject",y),t("__importStar",b),t("__importDefault",x)})}],n={base:0,"client/connection":1,"client/session":2,"core/bokeh_events":3,"core/build_views":4,"core/dom":5,"core/dom_view":6,"core/enums":7,"core/has_props":8,"core/hittest":9,"core/layout/alignments":10,"core/layout/grid":11,"core/layout/html":12,"core/layout/index":13,"core/layout/layoutable":14,"core/layout/side_panel":15,"core/layout/types":16,"core/logging":17,"core/properties":18,"core/property_mixins":19,"core/selection_manager":20,"core/settings":21,"core/signaling":22,"core/ui_events":23,"core/util/array":24,"core/util/arrayable":25,"core/util/assert":26,"core/util/bbox":27,"core/util/callback":28,"core/util/canvas":29,"core/util/color":30,"core/util/compat":31,"core/util/data_structures":32,"core/util/eq":33,"core/util/math":34,"core/util/object":35,"core/util/projections":36,"core/util/refs":37,"core/util/serialization":38,"core/util/spatial":39,"core/util/string":40,"core/util/svg_colors":41,"core/util/templating":42,"core/util/text":43,"core/util/throttle":44,"core/util/typed_array":45,"core/util/types":46,"core/util/wheel":47,"core/util/zoom":48,"core/vectorization":49,"core/view":50,"core/visuals":51,"document/document":52,"document/events":53,"document/index":54,"embed/dom":55,"embed/index":56,"embed/notebook":57,"embed/server":58,"embed/standalone":59,index:60,main:61,model:62,"models/annotations/annotation":63,"models/annotations/arrow":64,"models/annotations/arrow_head":65,"models/annotations/band":66,"models/annotations/box_annotation":67,"models/annotations/color_bar":68,"models/annotations/index":69,"models/annotations/label":70,"models/annotations/label_set":71,"models/annotations/legend":72,"models/annotations/legend_item":73,"models/annotations/poly_annotation":74,"models/annotations/slope":75,"models/annotations/span":76,"models/annotations/text_annotation":77,"models/annotations/title":78,"models/annotations/toolbar_panel":79,"models/annotations/tooltip":80,"models/annotations/whisker":81,"models/axes/axis":82,"models/axes/categorical_axis":83,"models/axes/continuous_axis":84,"models/axes/datetime_axis":85,"models/axes/index":86,"models/axes/linear_axis":87,"models/axes/log_axis":88,"models/axes/mercator_axis":89,"models/callbacks/callback":90,"models/callbacks/customjs":91,"models/callbacks/index":92,"models/callbacks/open_url":93,"models/canvas/canvas":94,"models/canvas/cartesian_frame":95,"models/canvas/index":96,"models/expressions/cumsum":97,"models/expressions/expression":98,"models/expressions/index":99,"models/expressions/stack":100,"models/filters/boolean_filter":101,"models/filters/customjs_filter":102,"models/filters/filter":103,"models/filters/group_filter":104,"models/filters/index":105,"models/filters/index_filter":106,"models/formatters/basic_tick_formatter":107,"models/formatters/categorical_tick_formatter":108,"models/formatters/datetime_tick_formatter":109,"models/formatters/func_tick_formatter":110,"models/formatters/index":111,"models/formatters/log_tick_formatter":112,"models/formatters/mercator_tick_formatter":113,"models/formatters/numeral_tick_formatter":114,"models/formatters/printf_tick_formatter":115,"models/formatters/tick_formatter":116,"models/glyphs/annular_wedge":117,"models/glyphs/annulus":118,"models/glyphs/arc":119,"models/glyphs/area":120,"models/glyphs/bezier":121,"models/glyphs/box":122,"models/glyphs/center_rotatable":123,"models/glyphs/circle":124,"models/glyphs/ellipse":125,"models/glyphs/ellipse_oval":126,"models/glyphs/glyph":127,"models/glyphs/harea":128,"models/glyphs/hbar":129,"models/glyphs/hex_tile":130,"models/glyphs/image":131,"models/glyphs/image_base":132,"models/glyphs/image_rgba":133,"models/glyphs/image_url":134,"models/glyphs/index":135,"models/glyphs/line":136,"models/glyphs/multi_line":137,"models/glyphs/multi_polygons":138,"models/glyphs/oval":139,"models/glyphs/patch":140,"models/glyphs/patches":141,"models/glyphs/quad":142,"models/glyphs/quadratic":143,"models/glyphs/ray":144,"models/glyphs/rect":145,"models/glyphs/segment":146,"models/glyphs/step":147,"models/glyphs/text":148,"models/glyphs/utils":149,"models/glyphs/varea":150,"models/glyphs/vbar":151,"models/glyphs/wedge":152,"models/glyphs/xy_glyph":153,"models/graphs/graph_hit_test_policy":154,"models/graphs/index":155,"models/graphs/layout_provider":156,"models/graphs/static_layout_provider":157,"models/grids/grid":158,"models/grids/index":159,"models/index":160,"models/layouts/box":161,"models/layouts/column":162,"models/layouts/grid_box":163,"models/layouts/html_box":164,"models/layouts/index":165,"models/layouts/layout_dom":166,"models/layouts/row":167,"models/layouts/spacer":168,"models/layouts/tabs":169,"models/layouts/widget_box":170,"models/mappers/categorical_color_mapper":171,"models/mappers/categorical_mapper":172,"models/mappers/categorical_marker_mapper":173,"models/mappers/categorical_pattern_mapper":174,"models/mappers/color_mapper":175,"models/mappers/continuous_color_mapper":176,"models/mappers/index":177,"models/mappers/linear_color_mapper":178,"models/mappers/log_color_mapper":179,"models/mappers/mapper":180,"models/markers/defs":181,"models/markers/index":182,"models/markers/marker":183,"models/markers/scatter":184,"models/plots/gmap_plot":185,"models/plots/gmap_plot_canvas":186,"models/plots/index":187,"models/plots/plot":188,"models/plots/plot_canvas":189,"models/ranges/data_range":190,"models/ranges/data_range1d":191,"models/ranges/factor_range":192,"models/ranges/index":193,"models/ranges/range":194,"models/ranges/range1d":195,"models/renderers/data_renderer":196,"models/renderers/glyph_renderer":197,"models/renderers/graph_renderer":198,"models/renderers/guide_renderer":199,"models/renderers/index":200,"models/renderers/renderer":201,"models/scales/categorical_scale":202,"models/scales/index":203,"models/scales/linear_scale":204,"models/scales/log_scale":205,"models/scales/scale":206,"models/selections/index":207,"models/selections/interaction_policy":208,"models/selections/selection":209,"models/sources/ajax_data_source":210,"models/sources/cds_view":211,"models/sources/column_data_source":212,"models/sources/columnar_data_source":213,"models/sources/data_source":214,"models/sources/geojson_data_source":215,"models/sources/index":216,"models/sources/remote_data_source":217,"models/sources/server_sent_data_source":218,"models/sources/web_data_source":219,"models/textures/canvas_texture":220,"models/textures/image_url_texture":221,"models/textures/index":222,"models/textures/texture":223,"models/tickers/adaptive_ticker":224,"models/tickers/basic_ticker":225,"models/tickers/categorical_ticker":226,"models/tickers/composite_ticker":227,"models/tickers/continuous_ticker":228,"models/tickers/datetime_ticker":229,"models/tickers/days_ticker":230,"models/tickers/fixed_ticker":231,"models/tickers/index":232,"models/tickers/log_ticker":233,"models/tickers/mercator_ticker":234,"models/tickers/months_ticker":235,"models/tickers/single_interval_ticker":236,"models/tickers/ticker":237,"models/tickers/util":238,"models/tickers/years_ticker":239,"models/tiles/bbox_tile_source":240,"models/tiles/image_pool":241,"models/tiles/index":242,"models/tiles/mercator_tile_source":243,"models/tiles/quadkey_tile_source":244,"models/tiles/tile_renderer":245,"models/tiles/tile_source":246,"models/tiles/tile_utils":247,"models/tiles/tms_tile_source":248,"models/tiles/wmts_tile_source":249,"models/tools/actions/action_tool":250,"models/tools/actions/custom_action":251,"models/tools/actions/help_tool":252,"models/tools/actions/redo_tool":253,"models/tools/actions/reset_tool":254,"models/tools/actions/save_tool":255,"models/tools/actions/undo_tool":256,"models/tools/actions/zoom_in_tool":257,"models/tools/actions/zoom_out_tool":258,"models/tools/button_tool":259,"models/tools/edit/box_edit_tool":260,"models/tools/edit/edit_tool":261,"models/tools/edit/freehand_draw_tool":262,"models/tools/edit/point_draw_tool":263,"models/tools/edit/poly_draw_tool":264,"models/tools/edit/poly_edit_tool":265,"models/tools/edit/poly_tool":266,"models/tools/gestures/box_select_tool":267,"models/tools/gestures/box_zoom_tool":268,"models/tools/gestures/gesture_tool":269,"models/tools/gestures/lasso_select_tool":270,"models/tools/gestures/pan_tool":271,"models/tools/gestures/poly_select_tool":272,"models/tools/gestures/range_tool":273,"models/tools/gestures/select_tool":274,"models/tools/gestures/tap_tool":275,"models/tools/gestures/wheel_pan_tool":276,"models/tools/gestures/wheel_zoom_tool":277,"models/tools/index":278,"models/tools/inspectors/crosshair_tool":279,"models/tools/inspectors/customjs_hover":280,"models/tools/inspectors/hover_tool":281,"models/tools/inspectors/inspect_tool":282,"models/tools/on_off_button":283,"models/tools/tool":284,"models/tools/tool_proxy":285,"models/tools/toolbar":286,"models/tools/toolbar_base":287,"models/tools/toolbar_box":288,"models/tools/util":289,"models/transforms/customjs_transform":290,"models/transforms/dodge":291,"models/transforms/index":292,"models/transforms/interpolator":293,"models/transforms/jitter":294,"models/transforms/linear_interpolator":295,"models/transforms/step_interpolator":296,"models/transforms/transform":297,polyfill:298,"protocol/index":299,"protocol/message":300,"protocol/receiver":301,safely:302,testing:303,version:304},r={},(s=(o=function(t){var e=r[t];if(!e){var s=function(t){if("number"==typeof t)return t;if("bokehjs"===t)return 61;"@bokehjs/"===t.slice(0,"@bokehjs/".length)&&(t=t.slice("@bokehjs/".length));var e=n[t];if(null!=e)return e;var i=t.length>0&&"/"===t[t.lenght-1],r=n[t+(i?"":"/")+"index"];return null!=r?r:t}(t);if(e=r[s])r[t]=e;else{if(!i[s]){var a=new Error("Cannot find module '"+t+"'");throw a.code="MODULE_NOT_FOUND",a}e={exports:{}},r[s]=e,r[t]=e,i[s].call(e.exports,o,e,e.exports)}}return e.exports})(61)).require=o,s.register_plugin=function(t,e,r){for(var a in t)i[a]=t[a];for(var a in e)n[a]=e[a];var l=o(r);for(var a in l)s[a]=l[a];return l},s)}(this);
//# sourceMappingURL=bokeh.min.js.map