Bokeh
=====

*Bokeh is a fiscally sponsored project of [NumFOCUS](http://numfocus.org), a nonprofit dedicated to supporting the open-source scientific computing community. If you like Bokeh and would like to support our mission, please consider [making a donation](https://numfocus.salsalabs.org/donate-to-bokeh/index.html).*

<table>

<tr>
  <td>Latest Release</td>
  <td>
    <img src="https://badge.fury.io/gh/bokeh%2Fbokeh.svg" alt="Latest release version" />
    <a href="https://badge.fury.io/js/bokehjs">
      <img src="https://badge.fury.io/js/bokehjs.svg" alt="npm version">
    </a>
  </td>

  <td>Conda</td>
  <td>
    <a href="https://bokeh.pydata.org/en/latest/docs/installation.html">
    <img src="https://s3.amazonaws.com/pubbadges/bokeh_current.svg"
         alt="Conda downloads per month" />
    </a>
  </td>
</tr>

<tr>
  <td>License</td>
  <td>
    <a href="https://github.com/bokeh/bokeh/blob/master/LICENSE.txt">
    <img src="https://img.shields.io/github/license/bokeh/bokeh.svg"
         alt="Bokeh license (BSD 3-clause)" />
    </a>
  </td>

  <td>PyPI</td>
  <td>
    <img src="https://badges.bokeh.org/pip-downloads-30-day.svg"
         alt="PyPI downloads per month" />
  </td>
</tr>

<tr>
  <td>Sponsorship</td>
  <td>
    <a href="http://numfocus.org">
    <img src="https://img.shields.io/badge/powered%20by-NumFOCUS-black.svg?style=flat&colorA=5B5B5B&colorB=007D8A"
         alt="Powered by NumFOCUS" />
    </a>
  </td>

  <td>Live Tutorial</td>
  <td>
    <a href="https://mybinder.org/v2/gh/bokeh/bokeh-notebooks/master?filepath=tutorial%2F00%20-%20Introduction%20and%20Setup.ipynb">
    <img src="https://mybinder.org/badge.svg"
         alt="Live Bokeh tutorial notebooks on MyBinder" />
    </a>
  </td>
</tr>

<tr>
  <td>Build Status</td>
  <td>
    <a href="https://travis-ci.org/bokeh/bokeh">
    <img src="https://travis-ci.org/bokeh/bokeh.svg?branch=master"
         alt="Current TravisCI build status" />
    </a>
    <a href="https://ci.appveyor.com/project/bokeh-integrations/bokeh">
    <img src="https://ci.appveyor.com/api/projects/status/u4idf25dhp219mho?svg=true"
         alt="Current Appveyor build status" />
    </a>
  </td>

  <td>Gitter</td>
  <td>
    <a href="https://gitter.im/bokeh/bokeh?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge">
    <img src="https://badges.gitter.im/bokeh/bokeh.svg"
         alt="Chat on the Bokeh Gitter channel" />
    </a>
  </td>
</tr>

<tr>
  <td>Static Analyis</td>
  <td>
    <a href="https://bettercodehub.com/edge/badge/bokeh/bokeh?branch=master">
    <img src="https://bettercodehub.com/edge/badge/bokeh/bokeh?branch=master"
         alt="BetterCodeHub static analysis" >
    </a>
  </td>

  <td>Twitter</td>
  <td>
    <a href="https://twitter.com/BokehPlots">
    <img src="https://img.shields.io/twitter/follow/bokehplots.svg?style=social&label=Follow"
         alt="Follow BokehPlots on Twitter" />
    </a>
  </td>
</tr>

</table>

Bokeh is an interactive visualization library for Python that enables beautiful
and meaningful visual presentation of data in modern web browsers. With Bokeh,
you can quickly and easily create interactive plots, dashboards, and data
applications.

Bokeh provides an elegant and concise way to construct versatile graphics while
delivering **high-performance** interactivity for large or streamed datasets.

[Interactive gallery](https://bokeh.pydata.org/en/latest/docs/gallery.html)
---------------------------------------------------------------------------

<p>
<table cellspacing="20">
<tr>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/image.html">
  <img alt="colormapped image plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/image_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/anscombe.html">
  <img alt="anscombe plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/anscombe_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/stocks.html">
  <img alt="stocks plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/stocks_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/lorenz.html">
  <img alt="lorenz attractor plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/lorenz_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/candlestick.html">
  <img alt="candlestick plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/candlestick_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/color_scatter.html">
  <img alt="scatter plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/scatter_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/iris_splom.html">
  <img alt="SPLOM plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/splom_t.png" />
  </a>
  </td>

</tr>
<tr>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/iris.html">
  <img alt="iris dataset plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/iris_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/histogram.html">
  <img alt="histogram plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/histogram_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/periodic.html">
  <img alt="periodic table plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/periodic_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/texas.html">
  <img alt="choropleth plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/choropleth_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/burtin.html">
  <img alt="burtin antibiotic data plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/burtin_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/streamline.html">
  <img alt="streamline plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/streamline_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/image_rgba.html">
  <img alt="RGBA image plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/image_rgba_t.png" />
  </a>
  </td>

</tr>
<tr>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/brewer.html">
  <img alt="stacked bars plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/stacked_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/quiver.html">
  <img alt="quiver plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/quiver_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/elements.html">
  <img alt="elements data plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/elements_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/boxplot.html">
  <img alt="boxplot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/boxplot_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/categorical.html">
  <img alt="categorical plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/categorical_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/unemployment.html">
  <img alt="unemployment data plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/unemployment_t.png" />
  </a>
  </td>

  <td>
  <a href="https://bokeh.pydata.org/en/latest/docs/gallery/les_mis.html">
  <img alt="Les Mis co-occurrence plot thumbnail" src="https://bokeh.pydata.org/en/latest/_images/les_mis_t.png" />
  </a>
  </td>

</tr>
</table>
</p>

Installation
------------
The easiest way to install Bokeh is using the [Anaconda Python distribution](https://www.anaconda.com/what-is-anaconda/) and its included *Conda* package management system. To install Bokeh and its required dependencies, enter the following command at a Bash or Windows command prompt:

```
conda install bokeh
```

To install using pip, enter the following command at a Bash or Windows command prompt:
```
pip install bokeh
```
For more information, refer to the [installation documentation](https://bokeh.pydata.org/en/latest/docs/user_guide/quickstart.html#quick-installation).

Once Bokeh is installed, check out the [Getting Started](https://bokeh.pydata.org/en/latest/docs/user_guide/quickstart.html#getting-started) section of the [Quickstart guide](https://bokeh.pydata.org/en/latest/docs/user_guide/quickstart.html).

Documentation
-------------
Visit the [Bokeh site](https://bokeh.pydata.org/en/latest) for information and full documentation, or [launch the Bokeh tutorial](https://mybinder.org/v2/gh/bokeh/bokeh-notebooks/master?filepath=tutorial%2F00%20-%20Introduction%20and%20Setup.ipynb) to learn about Bokeh in live Jupyter Notebooks.

Contribute to Bokeh
-------------------
If you would like to contribute to Bokeh, please review the [Developer Guide](https://bokeh.pydata.org/en/latest/docs/dev_guide.html).

Follow us
---------
Follow us on Twitter [@bokehplots](https://twitter.com/BokehPlots)

<p align="center">
  <a href="https://www.numfocus.org/">
  <img src="https://github.com/bokeh/bokeh/blob/master/sphinx/source/_images/NumFocus_2C_CMYK.svg"
       alt="NumFocus Logo" width="400"/>
  </a>
</p>
