/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(e,t){t(e.Bokeh)}(this,function(Bokeh){var define;return function(e,t,n){if(null!=Bokeh)return Bokeh.register_plugin(e,{"models/widgets/tables/cell_editors":446,"models/widgets/tables/cell_formatters":447,"models/widgets/tables/data_table":448,"models/widgets/tables/index":449,"models/widgets/tables/main":450,"models/widgets/tables/table_column":451,"models/widgets/tables/table_widget":452,"models/widgets/widget":453},450);throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.")}({446:function(e,t,n){var o=e(400),r=e(18),i=e(5),l=e(6),a=e(62),s=e(448),c=function(e){function t(t){var n=e.call(this,o.__assign({model:t.column.model},t))||this;return n.args=t,n.render(),n}return o.__extends(t,e),Object.defineProperty(t.prototype,"emptyValue",{get:function(){return null},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.inputEl=this._createInput(),this.defaultValue=null},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat("bk-cell-editor")},t.prototype.render=function(){e.prototype.render.call(this),this.args.container.appendChild(this.el),this.el.appendChild(this.inputEl),this.renderEditor(),this.disableNavigation()},t.prototype.renderEditor=function(){},t.prototype.disableNavigation=function(){this.inputEl.addEventListener("keydown",function(e){switch(e.keyCode){case i.Keys.Left:case i.Keys.Right:case i.Keys.Up:case i.Keys.Down:case i.Keys.PageUp:case i.Keys.PageDown:e.stopImmediatePropagation()}})},t.prototype.destroy=function(){this.remove()},t.prototype.focus=function(){this.inputEl.focus()},t.prototype.show=function(){},t.prototype.hide=function(){},t.prototype.position=function(){},t.prototype.getValue=function(){return this.inputEl.value},t.prototype.setValue=function(e){this.inputEl.value=e},t.prototype.serializeValue=function(){return this.getValue()},t.prototype.isValueChanged=function(){return!(""==this.getValue()&&null==this.defaultValue)&&this.getValue()!==this.defaultValue},t.prototype.applyValue=function(e,t){var n=this.args.grid.getData(),o=n.index.indexOf(e[s.DTINDEX_NAME]);n.setField(o,this.args.column.field,t)},t.prototype.loadValue=function(e){var t=e[this.args.column.field];this.defaultValue=null!=t?t:this.emptyValue,this.setValue(this.defaultValue)},t.prototype.validateValue=function(e){if(this.args.column.validator){var t=this.args.column.validator(e);if(!t.valid)return t}return{valid:!0,msg:null}},t.prototype.validate=function(){return this.validateValue(this.getValue())},t}(l.DOMView);n.CellEditorView=c;var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="CellEditor"},t}(a.Model);n.CellEditor=u,u.initClass();var d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),Object.defineProperty(t.prototype,"emptyValue",{get:function(){return""},enumerable:!0,configurable:!0}),t.prototype._createInput=function(){return i.input({type:"text"})},t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.loadValue=function(t){e.prototype.loadValue.call(this,t),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},t}(c);n.StringEditorView=d;var p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="StringEditor",this.prototype.default_view=d,this.define({completions:[r.Array,[]]})},t}(u);n.StringEditor=p,p.initClass();var f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.textarea()},t}(c);n.TextEditorView=f;var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="TextEditor",this.prototype.default_view=f},t}(u);n.TextEditor=h,h.initClass();var g=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.select()},t.prototype.renderEditor=function(){for(var e=0,t=this.model.options;e<t.length;e++){var n=t[e];this.inputEl.appendChild(i.option({value:n},n))}this.focus()},t}(c);n.SelectEditorView=g;var m=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="SelectEditor",this.prototype.default_view=g,this.define({options:[r.Array,[]]})},t}(u);n.SelectEditor=m,m.initClass();var v=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t}(c);n.PercentEditorView=v;var w=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="PercentEditor",this.prototype.default_view=v},t}(u);n.PercentEditor=w,w.initClass();var C=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"checkbox",value:"true"})},t.prototype.renderEditor=function(){this.focus()},t.prototype.loadValue=function(e){this.defaultValue=!!e[this.args.column.field],this.inputEl.checked=this.defaultValue},t.prototype.serializeValue=function(){return this.inputEl.checked},t}(c);n.CheckboxEditorView=C;var y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="CheckboxEditor",this.prototype.default_view=C},t}(u);n.CheckboxEditor=y,y.initClass();var b=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.remove=function(){e.prototype.remove.call(this)},t.prototype.serializeValue=function(){return parseInt(this.getValue(),10)||0},t.prototype.loadValue=function(t){e.prototype.loadValue.call(this,t),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},t.prototype.validateValue=function(t){return isNaN(t)?{valid:!1,msg:"Please enter a valid integer"}:e.prototype.validateValue.call(this,t)},t}(c);n.IntEditorView=b;var x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="IntEditor",this.prototype.default_view=b,this.define({step:[r.Number,1]})},t}(u);n.IntEditor=x,x.initClass();var R=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.remove=function(){e.prototype.remove.call(this)},t.prototype.serializeValue=function(){return parseFloat(this.getValue())||0},t.prototype.loadValue=function(t){e.prototype.loadValue.call(this,t),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},t.prototype.validateValue=function(t){return isNaN(t)?{valid:!1,msg:"Please enter a valid number"}:e.prototype.validateValue.call(this,t)},t}(c);n.NumberEditorView=R;var S=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="NumberEditor",this.prototype.default_view=R,this.define({step:[r.Number,.01]})},t}(u);n.NumberEditor=S,S.initClass();var E=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},t}(c);n.TimeEditorView=E;var k=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="TimeEditor",this.prototype.default_view=E},t}(u);n.TimeEditor=k,k.initClass();var T=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._createInput=function(){return i.input({type:"text"})},Object.defineProperty(t.prototype,"emptyValue",{get:function(){return new Date},enumerable:!0,configurable:!0}),t.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},t.prototype.destroy=function(){e.prototype.destroy.call(this)},t.prototype.show=function(){e.prototype.show.call(this)},t.prototype.hide=function(){e.prototype.hide.call(this)},t.prototype.position=function(){return e.prototype.position.call(this)},t.prototype.getValue=function(){},t.prototype.setValue=function(e){},t}(c);n.DateEditorView=T;var P=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="DateEditor",this.prototype.default_view=T},t}(u);n.DateEditor=P,P.initClass()},447:function(e,t,n){var o=e(400),r=e(370),i=e(463),l=e(399),a=e(18),s=e(5),c=e(46),u=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.prototype.doFormat=function(e,t,n,o,r){return null==n?"":(n+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},t}(e(62).Model);n.CellFormatter=u;var d=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="StringFormatter",this.define({font_style:[a.FontStyle,"normal"],text_align:[a.TextAlign,"left"],text_color:[a.Color]})},t.prototype.doFormat=function(e,t,n,o,r){var i=this.font_style,l=this.text_align,a=this.text_color,c=s.div({},null==n?"":""+n);switch(i){case"bold":c.style.fontWeight="bold";break;case"italic":c.style.fontStyle="italic"}return null!=l&&(c.style.textAlign=l),null!=a&&(c.style.color=a),c.outerHTML},t}(u);n.StringFormatter=d,d.initClass();var p=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="NumberFormatter",this.define({format:[a.String,"0,0"],language:[a.String,"en"],rounding:[a.RoundingFunction,"round"]})},t.prototype.doFormat=function(t,n,o,i,l){var a=this,s=this.format,c=this.language,u=function(){switch(a.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}();return o=r.format(o,s,c,u),e.prototype.doFormat.call(this,t,n,o,i,l)},t}(d);n.NumberFormatter=p,p.initClass();var f=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="BooleanFormatter",this.define({icon:[a.String,"check"]})},t.prototype.doFormat=function(e,t,n,o,r){return n?s.i({class:this.icon}).outerHTML:""},t}(u);n.BooleanFormatter=f,f.initClass();var h=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="DateFormatter",this.define({format:[a.String,"ISO-8601"]})},t.prototype.getFormat=function(){switch(this.format){case"ATOM":case"W3C":case"RFC-3339":case"ISO-8601":return"%Y-%m-%d";case"COOKIE":return"%a, %d %b %Y";case"RFC-850":return"%A, %d-%b-%y";case"RFC-1123":case"RFC-2822":return"%a, %e %b %Y";case"RSS":case"RFC-822":case"RFC-1036":return"%a, %e %b %y";case"TIMESTAMP":return;default:return this.format}},t.prototype.doFormat=function(t,n,o,r,i){o=c.isString(o)?parseInt(o,10):o;var a=l(o,this.getFormat());return e.prototype.doFormat.call(this,t,n,a,r,i)},t}(u);n.DateFormatter=h,h.initClass();var g=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="HTMLTemplateFormatter",this.define({template:[a.String,"<%= value %>"]})},t.prototype.doFormat=function(e,t,n,r,l){var a=this.template;return null==n?"":i(a)(o.__assign({},l,{value:n}))},t}(u);n.HTMLTemplateFormatter=g,g.initClass()},448:function(e,t,n){var o=e(400),r=e(461).Grid,i=e(459).RowSelectionModel,l=e(458).CheckboxSelectColumn,a=e(457).CellExternalCopyManager,s=e(18),c=e(40),u=e(46),d=e(24),p=e(35),f=e(17),h=e(13),g=e(452),m=e(453);n.DTINDEX_NAME="__bkdt_internal_index__";var v=function(){function e(e,t){if(this.source=e,this.view=t,n.DTINDEX_NAME in this.source.data)throw new Error("special name "+n.DTINDEX_NAME+" cannot be used as a data table column");this.index=this.view.indices}return e.prototype.getLength=function(){return this.index.length},e.prototype.getItem=function(e){for(var t={},o=0,r=p.keys(this.source.data);o<r.length;o++){var i=r[o];t[i]=this.source.data[i][this.index[e]]}return t[n.DTINDEX_NAME]=this.index[e],t},e.prototype.getField=function(e,t){return t==n.DTINDEX_NAME?this.index[e]:this.source.data[t][this.index[e]]},e.prototype.setField=function(e,t,n){var o,r=this.index[e];this.source.patch(((o={})[t]=[[r,n]],o))},e.prototype.getItemMetadata=function(e){return null},e.prototype.getRecords=function(){var e=this;return d.range(0,this.getLength()).map(function(t){return e.getItem(t)})},e.prototype.sort=function(e){var t=e.map(function(e){return[e.sortCol.field,e.sortAsc?1:-1]});0==t.length&&(t=[[n.DTINDEX_NAME,1]]);var o=this.getRecords(),r=this.index.slice();this.index.sort(function(e,n){for(var i=0,l=t;i<l.length;i++){var a=l[i],s=a[0],c=a[1],u=o[r.indexOf(e)][s],d=o[r.indexOf(n)][s],p=u==d?0:u>d?c:-c;if(0!=p)return p}return 0})},e}();n.DataProvider=v;var w=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._in_selection_update=!1,t._warned_not_reorderable=!1,t}return o.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()}),this.connect(this.model.source.streaming,function(){return t.updateGrid()}),this.connect(this.model.source.patching,function(){return t.updateGrid()}),this.connect(this.model.source.change,function(){return t.updateGrid()}),this.connect(this.model.source.properties.data.change,function(){return t.updateGrid()}),this.connect(this.model.source.selected.change,function(){return t.updateSelection()}),this.connect(this.model.source.selected.properties.indices.change,function(){return t.updateSelection()})},t.prototype._update_layout=function(){this.layout=new h.LayoutItem,this.layout.set_sizing(this.box_sizing())},t.prototype.update_position=function(){e.prototype.update_position.call(this),this.grid.resizeCanvas()},t.prototype.updateGrid=function(){var e=this;this.model.view.compute_indices(),this.data.constructor(this.model.source,this.model.view);var t=this.grid.getColumns(),n=this.grid.getSortColumns().map(function(n){return{sortCol:{field:t[e.grid.getColumnIndex(n.columnId)].field},sortAsc:n.sortAsc}});this.data.sort(n),this.grid.invalidate(),this.grid.render()},t.prototype.updateSelection=function(){var e=this;if(!this._in_selection_update){var t=this.model.source.selected.indices.map(function(t){return e.data.index.indexOf(t)});this._in_selection_update=!0,this.grid.setSelectedRows(t),this._in_selection_update=!1;var n=this.grid.getViewport(),o=this.model.get_scroll_index(n,t);null!=o&&this.grid.scrollRowToTop(o)}},t.prototype.newIndexColumn=function(){return{id:c.uniqueId(),name:this.model.index_header,field:n.DTINDEX_NAME,width:this.model.index_width,behavior:"select",cannotTriggerInsert:!0,resizable:!1,selectable:!1,sortable:!0,cssClass:"bk-cell-index",headerCssClass:"bk-header-index"}},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat("bk-data-table")},t.prototype.render=function(){var e,t=this,n=this.model.columns.map(function(e){return e.toColumn()});if("checkbox"==this.model.selectable&&(e=new l({cssClass:"bk-cell-select"}),n.unshift(e.getColumnDefinition())),null!=this.model.index_position){var o=this.model.index_position,s=this.newIndexColumn();-1==o?n.push(s):o<-1?n.splice(o+1,0,s):n.splice(o,0,s)}var c=this.model.reorderable;!c||"undefined"!=typeof $&&null!=$.fn&&null!=$.fn.sortable||(this._warned_not_reorderable||(f.logger.warn("jquery-ui is required to enable DataTable.reorderable"),this._warned_not_reorderable=!0),c=!1);var d={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:c,forceFitColumns:this.model.fit_columns,multiColumnSort:this.model.sortable,editable:this.model.editable,autoEdit:!1,rowHeight:this.model.row_height};if(this.data=new v(this.model.source,this.model.view),this.grid=new r(this.el,this.data,n,d),this.grid.onSort.subscribe(function(e,o){n=o.sortCols,t.data.sort(n),t.grid.invalidate(),t.updateSelection(),t.grid.render(),t.model.header_row||t._hide_header(),t.model.update_sort_columns(n)}),!1!==this.model.selectable){this.grid.setSelectionModel(new i({selectActiveRow:null==e})),null!=e&&this.grid.registerPlugin(e);var p={dataItemColumnValueExtractor:function(e,t){var n=e[t.field];return u.isString(n)&&(n=n.replace(/\n/g,"\\n")),n},includeHeaderWhenCopying:!1};this.grid.registerPlugin(new a(p)),this.grid.onSelectedRowsChanged.subscribe(function(e,n){t._in_selection_update||(t.model.source.selected.indices=n.rows.map(function(e){return t.data.index[e]}))}),this.updateSelection(),this.model.header_row||this._hide_header()}},t.prototype._hide_header=function(){for(var e=0,t=Array.from(this.el.querySelectorAll(".slick-header-columns"));e<t.length;e++){t[e].style.height="0px"}this.grid.resizeCanvas()},t}(m.WidgetView);n.DataTableView=w;var C=function(e){function t(t){var n=e.call(this,t)||this;return n._sort_columns=[],n}return o.__extends(t,e),Object.defineProperty(t.prototype,"sort_columns",{get:function(){return this._sort_columns},enumerable:!0,configurable:!0}),t.initClass=function(){this.prototype.type="DataTable",this.prototype.default_view=w,this.define({columns:[s.Array,[]],fit_columns:[s.Boolean,!0],sortable:[s.Boolean,!0],reorderable:[s.Boolean,!0],editable:[s.Boolean,!1],selectable:[s.Any,!0],index_position:[s.Int,0],index_header:[s.String,"#"],index_width:[s.Int,40],scroll_to_selection:[s.Boolean,!0],header_row:[s.Boolean,!0],row_height:[s.Int,25]}),this.override({width:600,height:400})},t.prototype.update_sort_columns=function(e){return this._sort_columns=e.map(function(e){return{field:e.sortCol.field,sortAsc:e.sortAsc}}),null},t.prototype.get_scroll_index=function(e,t){return this.scroll_to_selection&&0!=t.length?d.some(t,function(t){return e.top<=t&&t<=e.bottom})?null:Math.max(0,Math.min.apply(Math,t)-1):null},t}(g.TableWidget);n.DataTable=C,C.initClass()},449:function(e,t,n){var o=e(400);o.__exportStar(e(446),n),o.__exportStar(e(447),n);var r=e(448);n.DataTable=r.DataTable;var i=e(451);n.TableColumn=i.TableColumn;var l=e(452);n.TableWidget=l.TableWidget},450:function(e,t,n){var o=e(449);n.Tables=o,e(0).register_models(o)},451:function(e,t,n){var o=e(400),r=e(447),i=e(446),l=e(18),a=e(40),s=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="TableColumn",this.define({field:[l.String],title:[l.String],width:[l.Number,300],formatter:[l.Instance,function(){return new r.StringFormatter}],editor:[l.Instance,function(){return new i.StringEditor}],sortable:[l.Boolean,!0],default_sort:[l.Sort,"ascending"]})},t.prototype.toColumn=function(){return{id:a.uniqueId(),field:this.field,name:this.title,width:this.width,formatter:null!=this.formatter?this.formatter.doFormat.bind(this.formatter):void 0,model:this.editor,editor:this.editor.default_view,sortable:this.sortable,defaultSortAsc:"ascending"==this.default_sort}},t}(e(62).Model);n.TableColumn=s,s.initClass()},452:function(e,t,n){var o=e(400),r=e(453),i=e(207),l=e(18),a=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="TableWidget",this.define({source:[l.Instance],view:[l.Instance,function(){return new i.CDSView}]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.source,this.view.compute_indices())},t}(r.Widget);n.TableWidget=a,a.initClass()},453:function(e,t,n){var o=e(400),r=e(161),i=e(18),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._width_policy=function(){return"horizontal"==this.model.orientation?e.prototype._width_policy.call(this):"fixed"},t.prototype._height_policy=function(){return"horizontal"==this.model.orientation?"fixed":e.prototype._height_policy.call(this)},t.prototype.box_sizing=function(){var t=e.prototype.box_sizing.call(this);return"horizontal"==this.model.orientation?null==t.width&&(t.width=this.model.default_size):null==t.height&&(t.height=this.model.default_size),t},t}(r.HTMLBoxView);n.WidgetView=l;var a=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.initClass=function(){this.prototype.type="Widget",this.define({orientation:[i.Orientation,"horizontal"],default_size:[i.Number,300]}),this.override({margin:[5,5,5,5]})},t}(r.HTMLBox);n.Widget=a,a.initClass()},454:function(e,t,n){
/*!
     * jQuery JavaScript Library v3.2.1
     * https://jquery.com/
     *
     * Includes Sizzle.js
     * https://sizzlejs.com/
     *
     * Copyright JS Foundation and other contributors
     * Released under the MIT license
     * https://jquery.org/license
     *
     * Date: 2017-03-20T18:59Z
     */
!function(e,n){"use strict";"object"==typeof t&&"object"==typeof t.exports?t.exports=e.document?n(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return n(e)}:n(e)}("undefined"!=typeof window?window:this,function(e,t){"use strict";var n=[],o=e.document,r=Object.getPrototypeOf,i=n.slice,l=n.concat,a=n.push,s=n.indexOf,c={},u=c.toString,d=c.hasOwnProperty,p=d.toString,f=p.call(Object),h={};function g(e,t){var n=(t=t||o).createElement("script");n.text=e,t.head.appendChild(n).parentNode.removeChild(n)}var m=function(e,t){return new m.fn.init(e,t)},v=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,w=/^-ms-/,C=/-([a-z])/g,y=function(e,t){return t.toUpperCase()};function b(e){var t=!!e&&"length"in e&&e.length,n=m.type(e);return"function"!==n&&!m.isWindow(e)&&("array"===n||0===t||"number"==typeof t&&t>0&&t-1 in e)}m.fn=m.prototype={jquery:"3.2.1",constructor:m,length:0,toArray:function(){return i.call(this)},get:function(e){return null==e?i.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=m.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return m.each(this,e)},map:function(e){return this.pushStack(m.map(this,function(t,n){return e.call(t,n,t)}))},slice:function(){return this.pushStack(i.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(n>=0&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:a,sort:n.sort,splice:n.splice},m.extend=m.fn.extend=function(){var e,t,n,o,r,i,l=arguments[0]||{},a=1,s=arguments.length,c=!1;for("boolean"==typeof l&&(c=l,l=arguments[a]||{},a++),"object"==typeof l||m.isFunction(l)||(l={}),a===s&&(l=this,a--);a<s;a++)if(null!=(e=arguments[a]))for(t in e)n=l[t],l!==(o=e[t])&&(c&&o&&(m.isPlainObject(o)||(r=Array.isArray(o)))?(r?(r=!1,i=n&&Array.isArray(n)?n:[]):i=n&&m.isPlainObject(n)?n:{},l[t]=m.extend(c,i,o)):void 0!==o&&(l[t]=o));return l},m.extend({expando:"jQuery"+("3.2.1"+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isFunction:function(e){return"function"===m.type(e)},isWindow:function(e){return null!=e&&e===e.window},isNumeric:function(e){var t=m.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==u.call(e))&&(!(t=r(e))||"function"==typeof(n=d.call(t,"constructor")&&t.constructor)&&p.call(n)===f)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},type:function(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?c[u.call(e)]||"object":typeof e},globalEval:function(e){g(e)},camelCase:function(e){return e.replace(w,"ms-").replace(C,y)},each:function(e,t){var n,o=0;if(b(e))for(n=e.length;o<n&&!1!==t.call(e[o],o,e[o]);o++);else for(o in e)if(!1===t.call(e[o],o,e[o]))break;return e},trim:function(e){return null==e?"":(e+"").replace(v,"")},makeArray:function(e,t){var n=t||[];return null!=e&&(b(Object(e))?m.merge(n,"string"==typeof e?[e]:e):a.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:s.call(t,e,n)},merge:function(e,t){for(var n=+t.length,o=0,r=e.length;o<n;o++)e[r++]=t[o];return e.length=r,e},grep:function(e,t,n){for(var o=[],r=0,i=e.length,l=!n;r<i;r++)!t(e[r],r)!==l&&o.push(e[r]);return o},map:function(e,t,n){var o,r,i=0,a=[];if(b(e))for(o=e.length;i<o;i++)null!=(r=t(e[i],i,n))&&a.push(r);else for(i in e)null!=(r=t(e[i],i,n))&&a.push(r);return l.apply([],a)},guid:1,proxy:function(e,t){var n,o,r;if("string"==typeof t&&(n=e[t],t=e,e=n),m.isFunction(e))return o=i.call(arguments,2),(r=function(){return e.apply(t||this,o.concat(i.call(arguments)))}).guid=e.guid=e.guid||m.guid++,r},now:Date.now,support:h}),"function"==typeof Symbol&&(m.fn[Symbol.iterator]=n[Symbol.iterator]),m.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){c["[object "+t+"]"]=t.toLowerCase()});var x=
/*!
         * Sizzle CSS Selector Engine v2.3.3
         * https://sizzlejs.com/
         *
         * Copyright jQuery Foundation and other contributors
         * Released under the MIT license
         * http://jquery.org/license
         *
         * Date: 2016-08-08
         */
function(e){var t,n,o,r,i,l,a,s,c,u,d,p,f,h,g,m,v,w,C,y="sizzle"+1*new Date,b=e.document,x=0,R=0,S=le(),E=le(),k=le(),T=function(e,t){return e===t&&(d=!0),0},P={}.hasOwnProperty,D=[],A=D.pop,N=D.push,H=D.push,$=D.slice,I=function(e,t){for(var n=0,o=e.length;n<o;n++)if(e[n]===t)return n;return-1},L="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",_="[\\x20\\t\\r\\n\\f]",F="(?:\\\\.|[\\w-]|[^\0-\\xa0])+",M="\\["+_+"*("+F+")(?:"+_+"*([*^$|!~]?=)"+_+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+F+"))|)"+_+"*\\]",W=":("+F+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+M+")*)|.*)\\)|)",V=new RegExp(_+"+","g"),j=new RegExp("^"+_+"+|((?:^|[^\\\\])(?:\\\\.)*)"+_+"+$","g"),B=new RegExp("^"+_+"*,"+_+"*"),O=new RegExp("^"+_+"*([>+~]|"+_+")"+_+"*"),z=new RegExp("="+_+"*([^\\]'\"]*?)"+_+"*\\]","g"),q=new RegExp(W),X=new RegExp("^"+F+"$"),K={ID:new RegExp("^#("+F+")"),CLASS:new RegExp("^\\.("+F+")"),TAG:new RegExp("^("+F+"|[*])"),ATTR:new RegExp("^"+M),PSEUDO:new RegExp("^"+W),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+_+"*(even|odd|(([+-]|)(\\d*)n|)"+_+"*(?:([+-]|)"+_+"*(\\d+)|))"+_+"*\\)|)","i"),bool:new RegExp("^(?:"+L+")$","i"),needsContext:new RegExp("^"+_+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+_+"*((?:-\\d)?\\d*)"+_+"*\\)|)(?=[^-]|$)","i")},U=/^(?:input|select|textarea|button)$/i,G=/^h\d$/i,Y=/^[^{]+\{\s*\[native \w/,Q=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,J=/[+~]/,Z=new RegExp("\\\\([\\da-f]{1,6}"+_+"?|("+_+")|.)","ig"),ee=function(e,t,n){var o="0x"+t-65536;return o!=o||n?t:o<0?String.fromCharCode(o+65536):String.fromCharCode(o>>10|55296,1023&o|56320)},te=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ne=function(e,t){return t?"\0"===e?"�":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){p()},re=we(function(e){return!0===e.disabled&&("form"in e||"label"in e)},{dir:"parentNode",next:"legend"});try{H.apply(D=$.call(b.childNodes),b.childNodes),D[b.childNodes.length].nodeType}catch(e){H={apply:D.length?function(e,t){N.apply(e,$.call(t))}:function(e,t){for(var n=e.length,o=0;e[n++]=t[o++];);e.length=n-1}}}function ie(e,t,o,r){var i,a,c,u,d,h,v,w=t&&t.ownerDocument,x=t?t.nodeType:9;if(o=o||[],"string"!=typeof e||!e||1!==x&&9!==x&&11!==x)return o;if(!r&&((t?t.ownerDocument||t:b)!==f&&p(t),t=t||f,g)){if(11!==x&&(d=Q.exec(e)))if(i=d[1]){if(9===x){if(!(c=t.getElementById(i)))return o;if(c.id===i)return o.push(c),o}else if(w&&(c=w.getElementById(i))&&C(t,c)&&c.id===i)return o.push(c),o}else{if(d[2])return H.apply(o,t.getElementsByTagName(e)),o;if((i=d[3])&&n.getElementsByClassName&&t.getElementsByClassName)return H.apply(o,t.getElementsByClassName(i)),o}if(n.qsa&&!k[e+" "]&&(!m||!m.test(e))){if(1!==x)w=t,v=e;else if("object"!==t.nodeName.toLowerCase()){for((u=t.getAttribute("id"))?u=u.replace(te,ne):t.setAttribute("id",u=y),a=(h=l(e)).length;a--;)h[a]="#"+u+" "+ve(h[a]);v=h.join(","),w=J.test(e)&&ge(t.parentNode)||t}if(v)try{return H.apply(o,w.querySelectorAll(v)),o}catch(e){}finally{u===y&&t.removeAttribute("id")}}}return s(e.replace(j,"$1"),t,o,r)}function le(){var e=[];return function t(n,r){return e.push(n+" ")>o.cacheLength&&delete t[e.shift()],t[n+" "]=r}}function ae(e){return e[y]=!0,e}function se(e){var t=f.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function ce(e,t){for(var n=e.split("|"),r=n.length;r--;)o.attrHandle[n[r]]=t}function ue(e,t){var n=t&&e,o=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(o)return o;if(n)for(;n=n.nextSibling;)if(n===t)return-1;return e?1:-1}function de(e){return function(t){return"input"===t.nodeName.toLowerCase()&&t.type===e}}function pe(e){return function(t){var n=t.nodeName.toLowerCase();return("input"===n||"button"===n)&&t.type===e}}function fe(e){return function(t){return"form"in t?t.parentNode&&!1===t.disabled?"label"in t?"label"in t.parentNode?t.parentNode.disabled===e:t.disabled===e:t.isDisabled===e||t.isDisabled!==!e&&re(t)===e:t.disabled===e:"label"in t&&t.disabled===e}}function he(e){return ae(function(t){return t=+t,ae(function(n,o){for(var r,i=e([],n.length,t),l=i.length;l--;)n[r=i[l]]&&(n[r]=!(o[r]=n[r]))})})}function ge(e){return e&&void 0!==e.getElementsByTagName&&e}for(t in n=ie.support={},i=ie.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return!!t&&"HTML"!==t.nodeName},p=ie.setDocument=function(e){var t,r,l=e?e.ownerDocument||e:b;return l!==f&&9===l.nodeType&&l.documentElement?(h=(f=l).documentElement,g=!i(f),b!==f&&(r=f.defaultView)&&r.top!==r&&(r.addEventListener?r.addEventListener("unload",oe,!1):r.attachEvent&&r.attachEvent("onunload",oe)),n.attributes=se(function(e){return e.className="i",!e.getAttribute("className")}),n.getElementsByTagName=se(function(e){return e.appendChild(f.createComment("")),!e.getElementsByTagName("*").length}),n.getElementsByClassName=Y.test(f.getElementsByClassName),n.getById=se(function(e){return h.appendChild(e).id=y,!f.getElementsByName||!f.getElementsByName(y).length}),n.getById?(o.filter.ID=function(e){var t=e.replace(Z,ee);return function(e){return e.getAttribute("id")===t}},o.find.ID=function(e,t){if(void 0!==t.getElementById&&g){var n=t.getElementById(e);return n?[n]:[]}}):(o.filter.ID=function(e){var t=e.replace(Z,ee);return function(e){var n=void 0!==e.getAttributeNode&&e.getAttributeNode("id");return n&&n.value===t}},o.find.ID=function(e,t){if(void 0!==t.getElementById&&g){var n,o,r,i=t.getElementById(e);if(i){if((n=i.getAttributeNode("id"))&&n.value===e)return[i];for(r=t.getElementsByName(e),o=0;i=r[o++];)if((n=i.getAttributeNode("id"))&&n.value===e)return[i]}return[]}}),o.find.TAG=n.getElementsByTagName?function(e,t){return void 0!==t.getElementsByTagName?t.getElementsByTagName(e):n.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,o=[],r=0,i=t.getElementsByTagName(e);if("*"===e){for(;n=i[r++];)1===n.nodeType&&o.push(n);return o}return i},o.find.CLASS=n.getElementsByClassName&&function(e,t){if(void 0!==t.getElementsByClassName&&g)return t.getElementsByClassName(e)},v=[],m=[],(n.qsa=Y.test(f.querySelectorAll))&&(se(function(e){h.appendChild(e).innerHTML="<a id='"+y+"'></a><select id='"+y+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&m.push("[*^$]="+_+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||m.push("\\["+_+"*(?:value|"+L+")"),e.querySelectorAll("[id~="+y+"-]").length||m.push("~="),e.querySelectorAll(":checked").length||m.push(":checked"),e.querySelectorAll("a#"+y+"+*").length||m.push(".#.+[+~]")}),se(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=f.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&m.push("name"+_+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&m.push(":enabled",":disabled"),h.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&m.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),m.push(",.*:")})),(n.matchesSelector=Y.test(w=h.matches||h.webkitMatchesSelector||h.mozMatchesSelector||h.oMatchesSelector||h.msMatchesSelector))&&se(function(e){n.disconnectedMatch=w.call(e,"*"),w.call(e,"[s!='']:x"),v.push("!=",W)}),m=m.length&&new RegExp(m.join("|")),v=v.length&&new RegExp(v.join("|")),t=Y.test(h.compareDocumentPosition),C=t||Y.test(h.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,o=t&&t.parentNode;return e===o||!(!o||1!==o.nodeType||!(n.contains?n.contains(o):e.compareDocumentPosition&&16&e.compareDocumentPosition(o)))}:function(e,t){if(t)for(;t=t.parentNode;)if(t===e)return!0;return!1},T=t?function(e,t){if(e===t)return d=!0,0;var o=!e.compareDocumentPosition-!t.compareDocumentPosition;return o||(1&(o=(e.ownerDocument||e)===(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!n.sortDetached&&t.compareDocumentPosition(e)===o?e===f||e.ownerDocument===b&&C(b,e)?-1:t===f||t.ownerDocument===b&&C(b,t)?1:u?I(u,e)-I(u,t):0:4&o?-1:1)}:function(e,t){if(e===t)return d=!0,0;var n,o=0,r=e.parentNode,i=t.parentNode,l=[e],a=[t];if(!r||!i)return e===f?-1:t===f?1:r?-1:i?1:u?I(u,e)-I(u,t):0;if(r===i)return ue(e,t);for(n=e;n=n.parentNode;)l.unshift(n);for(n=t;n=n.parentNode;)a.unshift(n);for(;l[o]===a[o];)o++;return o?ue(l[o],a[o]):l[o]===b?-1:a[o]===b?1:0},f):f},ie.matches=function(e,t){return ie(e,null,null,t)},ie.matchesSelector=function(e,t){if((e.ownerDocument||e)!==f&&p(e),t=t.replace(z,"='$1']"),n.matchesSelector&&g&&!k[t+" "]&&(!v||!v.test(t))&&(!m||!m.test(t)))try{var o=w.call(e,t);if(o||n.disconnectedMatch||e.document&&11!==e.document.nodeType)return o}catch(e){}return ie(t,f,null,[e]).length>0},ie.contains=function(e,t){return(e.ownerDocument||e)!==f&&p(e),C(e,t)},ie.attr=function(e,t){(e.ownerDocument||e)!==f&&p(e);var r=o.attrHandle[t.toLowerCase()],i=r&&P.call(o.attrHandle,t.toLowerCase())?r(e,t,!g):void 0;return void 0!==i?i:n.attributes||!g?e.getAttribute(t):(i=e.getAttributeNode(t))&&i.specified?i.value:null},ie.escape=function(e){return(e+"").replace(te,ne)},ie.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},ie.uniqueSort=function(e){var t,o=[],r=0,i=0;if(d=!n.detectDuplicates,u=!n.sortStable&&e.slice(0),e.sort(T),d){for(;t=e[i++];)t===e[i]&&(r=o.push(i));for(;r--;)e.splice(o[r],1)}return u=null,e},r=ie.getText=function(e){var t,n="",o=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=r(e)}else if(3===i||4===i)return e.nodeValue}else for(;t=e[o++];)n+=r(t);return n},(o=ie.selectors={cacheLength:50,createPseudo:ae,match:K,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(Z,ee),e[3]=(e[3]||e[4]||e[5]||"").replace(Z,ee),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||ie.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&ie.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return K.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&q.test(n)&&(t=l(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(Z,ee).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=S[e+" "];return t||(t=new RegExp("(^|"+_+")"+e+"("+_+"|$)"))&&S(e,function(e){return t.test("string"==typeof e.className&&e.className||void 0!==e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(e,t,n){return function(o){var r=ie.attr(o,e);return null==r?"!="===t:!t||(r+="","="===t?r===n:"!="===t?r!==n:"^="===t?n&&0===r.indexOf(n):"*="===t?n&&r.indexOf(n)>-1:"$="===t?n&&r.slice(-n.length)===n:"~="===t?(" "+r.replace(V," ")+" ").indexOf(n)>-1:"|="===t&&(r===n||r.slice(0,n.length+1)===n+"-"))}},CHILD:function(e,t,n,o,r){var i="nth"!==e.slice(0,3),l="last"!==e.slice(-4),a="of-type"===t;return 1===o&&0===r?function(e){return!!e.parentNode}:function(t,n,s){var c,u,d,p,f,h,g=i!==l?"nextSibling":"previousSibling",m=t.parentNode,v=a&&t.nodeName.toLowerCase(),w=!s&&!a,C=!1;if(m){if(i){for(;g;){for(p=t;p=p[g];)if(a?p.nodeName.toLowerCase()===v:1===p.nodeType)return!1;h=g="only"===e&&!h&&"nextSibling"}return!0}if(h=[l?m.firstChild:m.lastChild],l&&w){for(C=(f=(c=(u=(d=(p=m)[y]||(p[y]={}))[p.uniqueID]||(d[p.uniqueID]={}))[e]||[])[0]===x&&c[1])&&c[2],p=f&&m.childNodes[f];p=++f&&p&&p[g]||(C=f=0)||h.pop();)if(1===p.nodeType&&++C&&p===t){u[e]=[x,f,C];break}}else if(w&&(C=f=(c=(u=(d=(p=t)[y]||(p[y]={}))[p.uniqueID]||(d[p.uniqueID]={}))[e]||[])[0]===x&&c[1]),!1===C)for(;(p=++f&&p&&p[g]||(C=f=0)||h.pop())&&((a?p.nodeName.toLowerCase()!==v:1!==p.nodeType)||!++C||(w&&((u=(d=p[y]||(p[y]={}))[p.uniqueID]||(d[p.uniqueID]={}))[e]=[x,C]),p!==t)););return(C-=r)===o||C%o==0&&C/o>=0}}},PSEUDO:function(e,t){var n,r=o.pseudos[e]||o.setFilters[e.toLowerCase()]||ie.error("unsupported pseudo: "+e);return r[y]?r(t):r.length>1?(n=[e,e,"",t],o.setFilters.hasOwnProperty(e.toLowerCase())?ae(function(e,n){for(var o,i=r(e,t),l=i.length;l--;)e[o=I(e,i[l])]=!(n[o]=i[l])}):function(e){return r(e,0,n)}):r}},pseudos:{not:ae(function(e){var t=[],n=[],o=a(e.replace(j,"$1"));return o[y]?ae(function(e,t,n,r){for(var i,l=o(e,null,r,[]),a=e.length;a--;)(i=l[a])&&(e[a]=!(t[a]=i))}):function(e,r,i){return t[0]=e,o(t,null,i,n),t[0]=null,!n.pop()}}),has:ae(function(e){return function(t){return ie(e,t).length>0}}),contains:ae(function(e){return e=e.replace(Z,ee),function(t){return(t.textContent||t.innerText||r(t)).indexOf(e)>-1}}),lang:ae(function(e){return X.test(e||"")||ie.error("unsupported lang: "+e),e=e.replace(Z,ee).toLowerCase(),function(t){var n;do{if(n=g?t.lang:t.getAttribute("xml:lang")||t.getAttribute("lang"))return(n=n.toLowerCase())===e||0===n.indexOf(e+"-")}while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===h},focus:function(e){return e===f.activeElement&&(!f.hasFocus||f.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:fe(!1),disabled:fe(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!o.pseudos.empty(e)},header:function(e){return G.test(e.nodeName)},input:function(e){return U.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:he(function(){return[0]}),last:he(function(e,t){return[t-1]}),eq:he(function(e,t,n){return[n<0?n+t:n]}),even:he(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:he(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:he(function(e,t,n){for(var o=n<0?n+t:n;--o>=0;)e.push(o);return e}),gt:he(function(e,t,n){for(var o=n<0?n+t:n;++o<t;)e.push(o);return e})}}).pseudos.nth=o.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})o.pseudos[t]=de(t);for(t in{submit:!0,reset:!0})o.pseudos[t]=pe(t);function me(){}function ve(e){for(var t=0,n=e.length,o="";t<n;t++)o+=e[t].value;return o}function we(e,t,n){var o=t.dir,r=t.next,i=r||o,l=n&&"parentNode"===i,a=R++;return t.first?function(t,n,r){for(;t=t[o];)if(1===t.nodeType||l)return e(t,n,r);return!1}:function(t,n,s){var c,u,d,p=[x,a];if(s){for(;t=t[o];)if((1===t.nodeType||l)&&e(t,n,s))return!0}else for(;t=t[o];)if(1===t.nodeType||l)if(u=(d=t[y]||(t[y]={}))[t.uniqueID]||(d[t.uniqueID]={}),r&&r===t.nodeName.toLowerCase())t=t[o]||t;else{if((c=u[i])&&c[0]===x&&c[1]===a)return p[2]=c[2];if(u[i]=p,p[2]=e(t,n,s))return!0}return!1}}function Ce(e){return e.length>1?function(t,n,o){for(var r=e.length;r--;)if(!e[r](t,n,o))return!1;return!0}:e[0]}function ye(e,t,n,o,r){for(var i,l=[],a=0,s=e.length,c=null!=t;a<s;a++)(i=e[a])&&(n&&!n(i,o,r)||(l.push(i),c&&t.push(a)));return l}function be(e,t,n,o,r,i){return o&&!o[y]&&(o=be(o)),r&&!r[y]&&(r=be(r,i)),ae(function(i,l,a,s){var c,u,d,p=[],f=[],h=l.length,g=i||function(e,t,n){for(var o=0,r=t.length;o<r;o++)ie(e,t[o],n);return n}(t||"*",a.nodeType?[a]:a,[]),m=!e||!i&&t?g:ye(g,p,e,a,s),v=n?r||(i?e:h||o)?[]:l:m;if(n&&n(m,v,a,s),o)for(c=ye(v,f),o(c,[],a,s),u=c.length;u--;)(d=c[u])&&(v[f[u]]=!(m[f[u]]=d));if(i){if(r||e){if(r){for(c=[],u=v.length;u--;)(d=v[u])&&c.push(m[u]=d);r(null,v=[],c,s)}for(u=v.length;u--;)(d=v[u])&&(c=r?I(i,d):p[u])>-1&&(i[c]=!(l[c]=d))}}else v=ye(v===l?v.splice(h,v.length):v),r?r(null,l,v,s):H.apply(l,v)})}function xe(e){for(var t,n,r,i=e.length,l=o.relative[e[0].type],a=l||o.relative[" "],s=l?1:0,u=we(function(e){return e===t},a,!0),d=we(function(e){return I(t,e)>-1},a,!0),p=[function(e,n,o){var r=!l&&(o||n!==c)||((t=n).nodeType?u(e,n,o):d(e,n,o));return t=null,r}];s<i;s++)if(n=o.relative[e[s].type])p=[we(Ce(p),n)];else{if((n=o.filter[e[s].type].apply(null,e[s].matches))[y]){for(r=++s;r<i&&!o.relative[e[r].type];r++);return be(s>1&&Ce(p),s>1&&ve(e.slice(0,s-1).concat({value:" "===e[s-2].type?"*":""})).replace(j,"$1"),n,s<r&&xe(e.slice(s,r)),r<i&&xe(e=e.slice(r)),r<i&&ve(e))}p.push(n)}return Ce(p)}return me.prototype=o.filters=o.pseudos,o.setFilters=new me,l=ie.tokenize=function(e,t){var n,r,i,l,a,s,c,u=E[e+" "];if(u)return t?0:u.slice(0);for(a=e,s=[],c=o.preFilter;a;){for(l in n&&!(r=B.exec(a))||(r&&(a=a.slice(r[0].length)||a),s.push(i=[])),n=!1,(r=O.exec(a))&&(n=r.shift(),i.push({value:n,type:r[0].replace(j," ")}),a=a.slice(n.length)),o.filter)!(r=K[l].exec(a))||c[l]&&!(r=c[l](r))||(n=r.shift(),i.push({value:n,type:l,matches:r}),a=a.slice(n.length));if(!n)break}return t?a.length:a?ie.error(e):E(e,s).slice(0)},a=ie.compile=function(e,t){var n,r=[],i=[],a=k[e+" "];if(!a){for(t||(t=l(e)),n=t.length;n--;)(a=xe(t[n]))[y]?r.push(a):i.push(a);(a=k(e,function(e,t){var n=t.length>0,r=e.length>0,i=function(i,l,a,s,u){var d,h,m,v=0,w="0",C=i&&[],y=[],b=c,R=i||r&&o.find.TAG("*",u),S=x+=null==b?1:Math.random()||.1,E=R.length;for(u&&(c=l===f||l||u);w!==E&&null!=(d=R[w]);w++){if(r&&d){for(h=0,l||d.ownerDocument===f||(p(d),a=!g);m=e[h++];)if(m(d,l||f,a)){s.push(d);break}u&&(x=S)}n&&((d=!m&&d)&&v--,i&&C.push(d))}if(v+=w,n&&w!==v){for(h=0;m=t[h++];)m(C,y,l,a);if(i){if(v>0)for(;w--;)C[w]||y[w]||(y[w]=A.call(s));y=ye(y)}H.apply(s,y),u&&!i&&y.length>0&&v+t.length>1&&ie.uniqueSort(s)}return u&&(x=S,c=b),C};return n?ae(i):i}(i,r))).selector=e}return a},s=ie.select=function(e,t,n,r){var i,s,c,u,d,p="function"==typeof e&&e,f=!r&&l(e=p.selector||e);if(n=n||[],1===f.length){if((s=f[0]=f[0].slice(0)).length>2&&"ID"===(c=s[0]).type&&9===t.nodeType&&g&&o.relative[s[1].type]){if(!(t=(o.find.ID(c.matches[0].replace(Z,ee),t)||[])[0]))return n;p&&(t=t.parentNode),e=e.slice(s.shift().value.length)}for(i=K.needsContext.test(e)?0:s.length;i--&&(c=s[i],!o.relative[u=c.type]);)if((d=o.find[u])&&(r=d(c.matches[0].replace(Z,ee),J.test(s[0].type)&&ge(t.parentNode)||t))){if(s.splice(i,1),!(e=r.length&&ve(s)))return H.apply(n,r),n;break}}return(p||a(e,f))(r,t,!g,n,!t||J.test(e)&&ge(t.parentNode)||t),n},n.sortStable=y.split("").sort(T).join("")===y,n.detectDuplicates=!!d,p(),n.sortDetached=se(function(e){return 1&e.compareDocumentPosition(f.createElement("fieldset"))}),se(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||ce("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),n.attributes&&se(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||ce("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),se(function(e){return null==e.getAttribute("disabled")})||ce(L,function(e,t,n){var o;if(!n)return!0===e[t]?t.toLowerCase():(o=e.getAttributeNode(t))&&o.specified?o.value:null}),ie}(e);m.find=x,m.expr=x.selectors,m.expr[":"]=m.expr.pseudos,m.uniqueSort=m.unique=x.uniqueSort,m.text=x.getText,m.isXMLDoc=x.isXML,m.contains=x.contains,m.escapeSelector=x.escape;var R=function(e,t,n){for(var o=[],r=void 0!==n;(e=e[t])&&9!==e.nodeType;)if(1===e.nodeType){if(r&&m(e).is(n))break;o.push(e)}return o},S=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},E=m.expr.match.needsContext;function k(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var T=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i,P=/^.[^:#\[\.,]*$/;function D(e,t,n){return m.isFunction(t)?m.grep(e,function(e,o){return!!t.call(e,o,e)!==n}):t.nodeType?m.grep(e,function(e){return e===t!==n}):"string"!=typeof t?m.grep(e,function(e){return s.call(t,e)>-1!==n}):P.test(t)?m.filter(t,e,n):(t=m.filter(t,e),m.grep(e,function(e){return s.call(t,e)>-1!==n&&1===e.nodeType}))}m.filter=function(e,t,n){var o=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===o.nodeType?m.find.matchesSelector(o,e)?[o]:[]:m.find.matches(e,m.grep(t,function(e){return 1===e.nodeType}))},m.fn.extend({find:function(e){var t,n,o=this.length,r=this;if("string"!=typeof e)return this.pushStack(m(e).filter(function(){for(t=0;t<o;t++)if(m.contains(r[t],this))return!0}));for(n=this.pushStack([]),t=0;t<o;t++)m.find(e,r[t],n);return o>1?m.uniqueSort(n):n},filter:function(e){return this.pushStack(D(this,e||[],!1))},not:function(e){return this.pushStack(D(this,e||[],!0))},is:function(e){return!!D(this,"string"==typeof e&&E.test(e)?m(e):e||[],!1).length}});var A,N=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(m.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||A,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&e.length>=3?[null,e,null]:N.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof m?t[0]:t,m.merge(this,m.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:o,!0)),T.test(r[1])&&m.isPlainObject(t))for(r in t)m.isFunction(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=o.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):m.isFunction(e)?void 0!==n.ready?n.ready(e):e(m):m.makeArray(e,this)}).prototype=m.fn,A=m(o);var H=/^(?:parents|prev(?:Until|All))/,$={children:!0,contents:!0,next:!0,prev:!0};function I(e,t){for(;(e=e[t])&&1!==e.nodeType;);return e}m.fn.extend({has:function(e){var t=m(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(m.contains(this,t[e]))return!0})},closest:function(e,t){var n,o=0,r=this.length,i=[],l="string"!=typeof e&&m(e);if(!E.test(e))for(;o<r;o++)for(n=this[o];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(l?l.index(n)>-1:1===n.nodeType&&m.find.matchesSelector(n,e))){i.push(n);break}return this.pushStack(i.length>1?m.uniqueSort(i):i)},index:function(e){return e?"string"==typeof e?s.call(m(e),this[0]):s.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(m.uniqueSort(m.merge(this.get(),m(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),m.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return R(e,"parentNode")},parentsUntil:function(e,t,n){return R(e,"parentNode",n)},next:function(e){return I(e,"nextSibling")},prev:function(e){return I(e,"previousSibling")},nextAll:function(e){return R(e,"nextSibling")},prevAll:function(e){return R(e,"previousSibling")},nextUntil:function(e,t,n){return R(e,"nextSibling",n)},prevUntil:function(e,t,n){return R(e,"previousSibling",n)},siblings:function(e){return S((e.parentNode||{}).firstChild,e)},children:function(e){return S(e.firstChild)},contents:function(e){return k(e,"iframe")?e.contentDocument:(k(e,"template")&&(e=e.content||e),m.merge([],e.childNodes))}},function(e,t){m.fn[e]=function(n,o){var r=m.map(this,t,n);return"Until"!==e.slice(-5)&&(o=n),o&&"string"==typeof o&&(r=m.filter(o,r)),this.length>1&&($[e]||m.uniqueSort(r),H.test(e)&&r.reverse()),this.pushStack(r)}});var L=/[^\x20\t\r\n\f]+/g;function _(e){return e}function F(e){throw e}function M(e,t,n,o){var r;try{e&&m.isFunction(r=e.promise)?r.call(e).done(t).fail(n):e&&m.isFunction(r=e.then)?r.call(e,t,n):t.apply(void 0,[e].slice(o))}catch(e){n.apply(void 0,[e])}}m.Callbacks=function(e){e="string"==typeof e?function(e){var t={};return m.each(e.match(L)||[],function(e,n){t[n]=!0}),t}(e):m.extend({},e);var t,n,o,r,i=[],l=[],a=-1,s=function(){for(r=r||e.once,o=t=!0;l.length;a=-1)for(n=l.shift();++a<i.length;)!1===i[a].apply(n[0],n[1])&&e.stopOnFalse&&(a=i.length,n=!1);e.memory||(n=!1),t=!1,r&&(i=n?[]:"")},c={add:function(){return i&&(n&&!t&&(a=i.length-1,l.push(n)),function t(n){m.each(n,function(n,o){m.isFunction(o)?e.unique&&c.has(o)||i.push(o):o&&o.length&&"string"!==m.type(o)&&t(o)})}(arguments),n&&!t&&s()),this},remove:function(){return m.each(arguments,function(e,t){for(var n;(n=m.inArray(t,i,n))>-1;)i.splice(n,1),n<=a&&a--}),this},has:function(e){return e?m.inArray(e,i)>-1:i.length>0},empty:function(){return i&&(i=[]),this},disable:function(){return r=l=[],i=n="",this},disabled:function(){return!i},lock:function(){return r=l=[],n||t||(i=n=""),this},locked:function(){return!!r},fireWith:function(e,n){return r||(n=[e,(n=n||[]).slice?n.slice():n],l.push(n),t||s()),this},fire:function(){return c.fireWith(this,arguments),this},fired:function(){return!!o}};return c},m.extend({Deferred:function(t){var n=[["notify","progress",m.Callbacks("memory"),m.Callbacks("memory"),2],["resolve","done",m.Callbacks("once memory"),m.Callbacks("once memory"),0,"resolved"],["reject","fail",m.Callbacks("once memory"),m.Callbacks("once memory"),1,"rejected"]],o="pending",r={state:function(){return o},always:function(){return i.done(arguments).fail(arguments),this},catch:function(e){return r.then(null,e)},pipe:function(){var e=arguments;return m.Deferred(function(t){m.each(n,function(n,o){var r=m.isFunction(e[o[4]])&&e[o[4]];i[o[1]](function(){var e=r&&r.apply(this,arguments);e&&m.isFunction(e.promise)?e.promise().progress(t.notify).done(t.resolve).fail(t.reject):t[o[0]+"With"](this,r?[e]:arguments)})}),e=null}).promise()},then:function(t,o,r){var i=0;function l(t,n,o,r){return function(){var a=this,s=arguments,c=function(){var e,c;if(!(t<i)){if((e=o.apply(a,s))===n.promise())throw new TypeError("Thenable self-resolution");c=e&&("object"==typeof e||"function"==typeof e)&&e.then,m.isFunction(c)?r?c.call(e,l(i,n,_,r),l(i,n,F,r)):(i++,c.call(e,l(i,n,_,r),l(i,n,F,r),l(i,n,_,n.notifyWith))):(o!==_&&(a=void 0,s=[e]),(r||n.resolveWith)(a,s))}},u=r?c:function(){try{c()}catch(e){m.Deferred.exceptionHook&&m.Deferred.exceptionHook(e,u.stackTrace),t+1>=i&&(o!==F&&(a=void 0,s=[e]),n.rejectWith(a,s))}};t?u():(m.Deferred.getStackHook&&(u.stackTrace=m.Deferred.getStackHook()),e.setTimeout(u))}}return m.Deferred(function(e){n[0][3].add(l(0,e,m.isFunction(r)?r:_,e.notifyWith)),n[1][3].add(l(0,e,m.isFunction(t)?t:_)),n[2][3].add(l(0,e,m.isFunction(o)?o:F))}).promise()},promise:function(e){return null!=e?m.extend(e,r):r}},i={};return m.each(n,function(e,t){var l=t[2],a=t[5];r[t[1]]=l.add,a&&l.add(function(){o=a},n[3-e][2].disable,n[0][2].lock),l.add(t[3].fire),i[t[0]]=function(){return i[t[0]+"With"](this===i?void 0:this,arguments),this},i[t[0]+"With"]=l.fireWith}),r.promise(i),t&&t.call(i,i),i},when:function(e){var t=arguments.length,n=t,o=Array(n),r=i.call(arguments),l=m.Deferred(),a=function(e){return function(n){o[e]=this,r[e]=arguments.length>1?i.call(arguments):n,--t||l.resolveWith(o,r)}};if(t<=1&&(M(e,l.done(a(n)).resolve,l.reject,!t),"pending"===l.state()||m.isFunction(r[n]&&r[n].then)))return l.then();for(;n--;)M(r[n],a(n),l.reject);return l.promise()}});var W=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;m.Deferred.exceptionHook=function(t,n){e.console&&e.console.warn&&t&&W.test(t.name)&&e.console.warn("jQuery.Deferred exception: "+t.message,t.stack,n)},m.readyException=function(t){e.setTimeout(function(){throw t})};var V=m.Deferred();function j(){o.removeEventListener("DOMContentLoaded",j),e.removeEventListener("load",j),m.ready()}m.fn.ready=function(e){return V.then(e).catch(function(e){m.readyException(e)}),this},m.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--m.readyWait:m.isReady)||(m.isReady=!0,!0!==e&&--m.readyWait>0||V.resolveWith(o,[m]))}}),m.ready.then=V.then,"complete"===o.readyState||"loading"!==o.readyState&&!o.documentElement.doScroll?e.setTimeout(m.ready):(o.addEventListener("DOMContentLoaded",j),e.addEventListener("load",j));var B=function(e,t,n,o,r,i,l){var a=0,s=e.length,c=null==n;if("object"===m.type(n))for(a in r=!0,n)B(e,t,a,n[a],!0,i,l);else if(void 0!==o&&(r=!0,m.isFunction(o)||(l=!0),c&&(l?(t.call(e,o),t=null):(c=t,t=function(e,t,n){return c.call(m(e),n)})),t))for(;a<s;a++)t(e[a],n,l?o:o.call(e[a],a,t(e[a],n)));return r?e:c?t.call(e):s?t(e[0],n):i},O=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function z(){this.expando=m.expando+z.uid++}z.uid=1,z.prototype={cache:function(e){var t=e[this.expando];return t||(t={},O(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var o,r=this.cache(e);if("string"==typeof t)r[m.camelCase(t)]=n;else for(o in t)r[m.camelCase(o)]=t[o];return r},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][m.camelCase(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,o=e[this.expando];if(void 0!==o){if(void 0!==t){n=(t=Array.isArray(t)?t.map(m.camelCase):(t=m.camelCase(t))in o?[t]:t.match(L)||[]).length;for(;n--;)delete o[t[n]]}(void 0===t||m.isEmptyObject(o))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!m.isEmptyObject(t)}};var q=new z,X=new z,K=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,U=/[A-Z]/g;function G(e,t,n){var o;if(void 0===n&&1===e.nodeType)if(o="data-"+t.replace(U,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(o))){try{n=function(e){return"true"===e||"false"!==e&&("null"===e?null:e===+e+""?+e:K.test(e)?JSON.parse(e):e)}(n)}catch(e){}X.set(e,t,n)}else n=void 0;return n}m.extend({hasData:function(e){return X.hasData(e)||q.hasData(e)},data:function(e,t,n){return X.access(e,t,n)},removeData:function(e,t){X.remove(e,t)},_data:function(e,t,n){return q.access(e,t,n)},_removeData:function(e,t){q.remove(e,t)}}),m.fn.extend({data:function(e,t){var n,o,r,i=this[0],l=i&&i.attributes;if(void 0===e){if(this.length&&(r=X.get(i),1===i.nodeType&&!q.get(i,"hasDataAttrs"))){for(n=l.length;n--;)l[n]&&0===(o=l[n].name).indexOf("data-")&&(o=m.camelCase(o.slice(5)),G(i,o,r[o]));q.set(i,"hasDataAttrs",!0)}return r}return"object"==typeof e?this.each(function(){X.set(this,e)}):B(this,function(t){var n;if(i&&void 0===t)return void 0!==(n=X.get(i,e))?n:void 0!==(n=G(i,e))?n:void 0;this.each(function(){X.set(this,e,t)})},null,t,arguments.length>1,null,!0)},removeData:function(e){return this.each(function(){X.remove(this,e)})}}),m.extend({queue:function(e,t,n){var o;if(e)return t=(t||"fx")+"queue",o=q.get(e,t),n&&(!o||Array.isArray(n)?o=q.access(e,t,m.makeArray(n)):o.push(n)),o||[]},dequeue:function(e,t){t=t||"fx";var n=m.queue(e,t),o=n.length,r=n.shift(),i=m._queueHooks(e,t);"inprogress"===r&&(r=n.shift(),o--),r&&("fx"===t&&n.unshift("inprogress"),delete i.stop,r.call(e,function(){m.dequeue(e,t)},i)),!o&&i&&i.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return q.get(e,n)||q.access(e,n,{empty:m.Callbacks("once memory").add(function(){q.remove(e,[t+"queue",n])})})}}),m.fn.extend({queue:function(e,t){var n=2;return"string"!=typeof e&&(t=e,e="fx",n--),arguments.length<n?m.queue(this[0],e):void 0===t?this:this.each(function(){var n=m.queue(this,e,t);m._queueHooks(this,e),"fx"===e&&"inprogress"!==n[0]&&m.dequeue(this,e)})},dequeue:function(e){return this.each(function(){m.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,o=1,r=m.Deferred(),i=this,l=this.length,a=function(){--o||r.resolveWith(i,[i])};for("string"!=typeof e&&(t=e,e=void 0),e=e||"fx";l--;)(n=q.get(i[l],e+"queueHooks"))&&n.empty&&(o++,n.empty.add(a));return a(),r.promise(t)}});var Y=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,Q=new RegExp("^(?:([+-])=|)("+Y+")([a-z%]*)$","i"),J=["Top","Right","Bottom","Left"],Z=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&m.contains(e.ownerDocument,e)&&"none"===m.css(e,"display")},ee=function(e,t,n,o){var r,i,l={};for(i in t)l[i]=e.style[i],e.style[i]=t[i];for(i in r=n.apply(e,o||[]),t)e.style[i]=l[i];return r};function te(e,t,n,o){var r,i=1,l=20,a=o?function(){return o.cur()}:function(){return m.css(e,t,"")},s=a(),c=n&&n[3]||(m.cssNumber[t]?"":"px"),u=(m.cssNumber[t]||"px"!==c&&+s)&&Q.exec(m.css(e,t));if(u&&u[3]!==c){c=c||u[3],n=n||[],u=+s||1;do{u/=i=i||".5",m.style(e,t,u+c)}while(i!==(i=a()/s)&&1!==i&&--l)}return n&&(u=+u||+s||0,r=n[1]?u+(n[1]+1)*n[2]:+n[2],o&&(o.unit=c,o.start=u,o.end=r)),r}var ne={};function oe(e){var t,n=e.ownerDocument,o=e.nodeName,r=ne[o];return r||(t=n.body.appendChild(n.createElement(o)),r=m.css(t,"display"),t.parentNode.removeChild(t),"none"===r&&(r="block"),ne[o]=r,r)}function re(e,t){for(var n,o,r=[],i=0,l=e.length;i<l;i++)(o=e[i]).style&&(n=o.style.display,t?("none"===n&&(r[i]=q.get(o,"display")||null,r[i]||(o.style.display="")),""===o.style.display&&Z(o)&&(r[i]=oe(o))):"none"!==n&&(r[i]="none",q.set(o,"display",n)));for(i=0;i<l;i++)null!=r[i]&&(e[i].style.display=r[i]);return e}m.fn.extend({show:function(){return re(this,!0)},hide:function(){return re(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){Z(this)?m(this).show():m(this).hide()})}});var ie=/^(?:checkbox|radio)$/i,le=/<([a-z][^\/\0>\x20\t\r\n\f]+)/i,ae=/^$|\/(?:java|ecma)script/i,se={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ce(e,t){var n;return n=void 0!==e.getElementsByTagName?e.getElementsByTagName(t||"*"):void 0!==e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&k(e,t)?m.merge([e],n):n}function ue(e,t){for(var n=0,o=e.length;n<o;n++)q.set(e[n],"globalEval",!t||q.get(t[n],"globalEval"))}se.optgroup=se.option,se.tbody=se.tfoot=se.colgroup=se.caption=se.thead,se.th=se.td;var de,pe,fe=/<|&#?\w+;/;function he(e,t,n,o,r){for(var i,l,a,s,c,u,d=t.createDocumentFragment(),p=[],f=0,h=e.length;f<h;f++)if((i=e[f])||0===i)if("object"===m.type(i))m.merge(p,i.nodeType?[i]:i);else if(fe.test(i)){for(l=l||d.appendChild(t.createElement("div")),a=(le.exec(i)||["",""])[1].toLowerCase(),s=se[a]||se._default,l.innerHTML=s[1]+m.htmlPrefilter(i)+s[2],u=s[0];u--;)l=l.lastChild;m.merge(p,l.childNodes),(l=d.firstChild).textContent=""}else p.push(t.createTextNode(i));for(d.textContent="",f=0;i=p[f++];)if(o&&m.inArray(i,o)>-1)r&&r.push(i);else if(c=m.contains(i.ownerDocument,i),l=ce(d.appendChild(i),"script"),c&&ue(l),n)for(u=0;i=l[u++];)ae.test(i.type||"")&&n.push(i);return d}de=o.createDocumentFragment().appendChild(o.createElement("div")),(pe=o.createElement("input")).setAttribute("type","radio"),pe.setAttribute("checked","checked"),pe.setAttribute("name","t"),de.appendChild(pe),h.checkClone=de.cloneNode(!0).cloneNode(!0).lastChild.checked,de.innerHTML="<textarea>x</textarea>",h.noCloneChecked=!!de.cloneNode(!0).lastChild.defaultValue;var ge=o.documentElement,me=/^key/,ve=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,we=/^([^.]*)(?:\.(.+)|)/;function Ce(){return!0}function ye(){return!1}function be(){try{return o.activeElement}catch(e){}}function xe(e,t,n,o,r,i){var l,a;if("object"==typeof t){for(a in"string"!=typeof n&&(o=o||n,n=void 0),t)xe(e,a,n,o,t[a],i);return e}if(null==o&&null==r?(r=n,o=n=void 0):null==r&&("string"==typeof n?(r=o,o=void 0):(r=o,o=n,n=void 0)),!1===r)r=ye;else if(!r)return e;return 1===i&&(l=r,(r=function(e){return m().off(e),l.apply(this,arguments)}).guid=l.guid||(l.guid=m.guid++)),e.each(function(){m.event.add(this,t,r,o,n)})}m.event={global:{},add:function(e,t,n,o,r){var i,l,a,s,c,u,d,p,f,h,g,v=q.get(e);if(v)for(n.handler&&(n=(i=n).handler,r=i.selector),r&&m.find.matchesSelector(ge,r),n.guid||(n.guid=m.guid++),(s=v.events)||(s=v.events={}),(l=v.handle)||(l=v.handle=function(t){return void 0!==m&&m.event.triggered!==t.type?m.event.dispatch.apply(e,arguments):void 0}),c=(t=(t||"").match(L)||[""]).length;c--;)f=g=(a=we.exec(t[c])||[])[1],h=(a[2]||"").split(".").sort(),f&&(d=m.event.special[f]||{},f=(r?d.delegateType:d.bindType)||f,d=m.event.special[f]||{},u=m.extend({type:f,origType:g,data:o,handler:n,guid:n.guid,selector:r,needsContext:r&&m.expr.match.needsContext.test(r),namespace:h.join(".")},i),(p=s[f])||((p=s[f]=[]).delegateCount=0,d.setup&&!1!==d.setup.call(e,o,h,l)||e.addEventListener&&e.addEventListener(f,l)),d.add&&(d.add.call(e,u),u.handler.guid||(u.handler.guid=n.guid)),r?p.splice(p.delegateCount++,0,u):p.push(u),m.event.global[f]=!0)},remove:function(e,t,n,o,r){var i,l,a,s,c,u,d,p,f,h,g,v=q.hasData(e)&&q.get(e);if(v&&(s=v.events)){for(c=(t=(t||"").match(L)||[""]).length;c--;)if(f=g=(a=we.exec(t[c])||[])[1],h=(a[2]||"").split(".").sort(),f){for(d=m.event.special[f]||{},p=s[f=(o?d.delegateType:d.bindType)||f]||[],a=a[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),l=i=p.length;i--;)u=p[i],!r&&g!==u.origType||n&&n.guid!==u.guid||a&&!a.test(u.namespace)||o&&o!==u.selector&&("**"!==o||!u.selector)||(p.splice(i,1),u.selector&&p.delegateCount--,d.remove&&d.remove.call(e,u));l&&!p.length&&(d.teardown&&!1!==d.teardown.call(e,h,v.handle)||m.removeEvent(e,f,v.handle),delete s[f])}else for(f in s)m.event.remove(e,f+t[c],n,o,!0);m.isEmptyObject(s)&&q.remove(e,"handle events")}},dispatch:function(e){var t,n,o,r,i,l,a=m.event.fix(e),s=new Array(arguments.length),c=(q.get(this,"events")||{})[a.type]||[],u=m.event.special[a.type]||{};for(s[0]=a,t=1;t<arguments.length;t++)s[t]=arguments[t];if(a.delegateTarget=this,!u.preDispatch||!1!==u.preDispatch.call(this,a)){for(l=m.event.handlers.call(this,a,c),t=0;(r=l[t++])&&!a.isPropagationStopped();)for(a.currentTarget=r.elem,n=0;(i=r.handlers[n++])&&!a.isImmediatePropagationStopped();)a.rnamespace&&!a.rnamespace.test(i.namespace)||(a.handleObj=i,a.data=i.data,void 0!==(o=((m.event.special[i.origType]||{}).handle||i.handler).apply(r.elem,s))&&!1===(a.result=o)&&(a.preventDefault(),a.stopPropagation()));return u.postDispatch&&u.postDispatch.call(this,a),a.result}},handlers:function(e,t){var n,o,r,i,l,a=[],s=t.delegateCount,c=e.target;if(s&&c.nodeType&&!("click"===e.type&&e.button>=1))for(;c!==this;c=c.parentNode||this)if(1===c.nodeType&&("click"!==e.type||!0!==c.disabled)){for(i=[],l={},n=0;n<s;n++)void 0===l[r=(o=t[n]).selector+" "]&&(l[r]=o.needsContext?m(r,this).index(c)>-1:m.find(r,this,null,[c]).length),l[r]&&i.push(o);i.length&&a.push({elem:c,handlers:i})}return c=this,s<t.length&&a.push({elem:c,handlers:t.slice(s)}),a},addProp:function(e,t){Object.defineProperty(m.Event.prototype,e,{enumerable:!0,configurable:!0,get:m.isFunction(t)?function(){if(this.originalEvent)return t(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[e]},set:function(t){Object.defineProperty(this,e,{enumerable:!0,configurable:!0,writable:!0,value:t})}})},fix:function(e){return e[m.expando]?e:new m.Event(e)},special:{load:{noBubble:!0},focus:{trigger:function(){if(this!==be()&&this.focus)return this.focus(),!1},delegateType:"focusin"},blur:{trigger:function(){if(this===be()&&this.blur)return this.blur(),!1},delegateType:"focusout"},click:{trigger:function(){if("checkbox"===this.type&&this.click&&k(this,"input"))return this.click(),!1},_default:function(e){return k(e.target,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},m.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},m.Event=function(e,t){if(!(this instanceof m.Event))return new m.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?Ce:ye,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&m.extend(this,t),this.timeStamp=e&&e.timeStamp||m.now(),this[m.expando]=!0},m.Event.prototype={constructor:m.Event,isDefaultPrevented:ye,isPropagationStopped:ye,isImmediatePropagationStopped:ye,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=Ce,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=Ce,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=Ce,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},m.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,char:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&me.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&ve.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},m.event.addProp),m.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,t){m.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,o=e.relatedTarget,r=e.handleObj;return o&&(o===this||m.contains(this,o))||(e.type=r.origType,n=r.handler.apply(this,arguments),e.type=t),n}}}),m.fn.extend({on:function(e,t,n,o){return xe(this,e,t,n,o)},one:function(e,t,n,o){return xe(this,e,t,n,o,1)},off:function(e,t,n){var o,r;if(e&&e.preventDefault&&e.handleObj)return o=e.handleObj,m(e.delegateTarget).off(o.namespace?o.origType+"."+o.namespace:o.origType,o.selector,o.handler),this;if("object"==typeof e){for(r in e)this.off(r,t,e[r]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=ye),this.each(function(){m.event.remove(this,e,n,t)})}});var Re=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,Se=/<script|<style|<link/i,Ee=/checked\s*(?:[^=]|=\s*.checked.)/i,ke=/^true\/(.*)/,Te=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function Pe(e,t){return k(e,"table")&&k(11!==t.nodeType?t:t.firstChild,"tr")&&m(">tbody",e)[0]||e}function De(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function Ae(e){var t=ke.exec(e.type);return t?e.type=t[1]:e.removeAttribute("type"),e}function Ne(e,t){var n,o,r,i,l,a,s,c;if(1===t.nodeType){if(q.hasData(e)&&(i=q.access(e),l=q.set(t,i),c=i.events))for(r in delete l.handle,l.events={},c)for(n=0,o=c[r].length;n<o;n++)m.event.add(t,r,c[r][n]);X.hasData(e)&&(a=X.access(e),s=m.extend({},a),X.set(t,s))}}function He(e,t,n,o){t=l.apply([],t);var r,i,a,s,c,u,d=0,p=e.length,f=p-1,v=t[0],w=m.isFunction(v);if(w||p>1&&"string"==typeof v&&!h.checkClone&&Ee.test(v))return e.each(function(r){var i=e.eq(r);w&&(t[0]=v.call(this,r,i.html())),He(i,t,n,o)});if(p&&(i=(r=he(t,e[0].ownerDocument,!1,e,o)).firstChild,1===r.childNodes.length&&(r=i),i||o)){for(s=(a=m.map(ce(r,"script"),De)).length;d<p;d++)c=r,d!==f&&(c=m.clone(c,!0,!0),s&&m.merge(a,ce(c,"script"))),n.call(e[d],c,d);if(s)for(u=a[a.length-1].ownerDocument,m.map(a,Ae),d=0;d<s;d++)c=a[d],ae.test(c.type||"")&&!q.access(c,"globalEval")&&m.contains(u,c)&&(c.src?m._evalUrl&&m._evalUrl(c.src):g(c.textContent.replace(Te,""),u))}return e}function $e(e,t,n){for(var o,r=t?m.filter(t,e):e,i=0;null!=(o=r[i]);i++)n||1!==o.nodeType||m.cleanData(ce(o)),o.parentNode&&(n&&m.contains(o.ownerDocument,o)&&ue(ce(o,"script")),o.parentNode.removeChild(o));return e}m.extend({htmlPrefilter:function(e){return e.replace(Re,"<$1></$2>")},clone:function(e,t,n){var o,r,i,l,a,s,c,u=e.cloneNode(!0),d=m.contains(e.ownerDocument,e);if(!(h.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||m.isXMLDoc(e)))for(l=ce(u),o=0,r=(i=ce(e)).length;o<r;o++)a=i[o],s=l[o],c=void 0,"input"===(c=s.nodeName.toLowerCase())&&ie.test(a.type)?s.checked=a.checked:"input"!==c&&"textarea"!==c||(s.defaultValue=a.defaultValue);if(t)if(n)for(i=i||ce(e),l=l||ce(u),o=0,r=i.length;o<r;o++)Ne(i[o],l[o]);else Ne(e,u);return(l=ce(u,"script")).length>0&&ue(l,!d&&ce(e,"script")),u},cleanData:function(e){for(var t,n,o,r=m.event.special,i=0;void 0!==(n=e[i]);i++)if(O(n)){if(t=n[q.expando]){if(t.events)for(o in t.events)r[o]?m.event.remove(n,o):m.removeEvent(n,o,t.handle);n[q.expando]=void 0}n[X.expando]&&(n[X.expando]=void 0)}}}),m.fn.extend({detach:function(e){return $e(this,e,!0)},remove:function(e){return $e(this,e)},text:function(e){return B(this,function(e){return void 0===e?m.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return He(this,arguments,function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||Pe(this,e).appendChild(e)})},prepend:function(){return He(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=Pe(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return He(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return He(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(m.cleanData(ce(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return m.clone(this,e,t)})},html:function(e){return B(this,function(e){var t=this[0]||{},n=0,o=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!Se.test(e)&&!se[(le.exec(e)||["",""])[1].toLowerCase()]){e=m.htmlPrefilter(e);try{for(;n<o;n++)1===(t=this[n]||{}).nodeType&&(m.cleanData(ce(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var e=[];return He(this,arguments,function(t){var n=this.parentNode;m.inArray(this,e)<0&&(m.cleanData(ce(this)),n&&n.replaceChild(t,this))},e)}}),m.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,t){m.fn[e]=function(e){for(var n,o=[],r=m(e),i=r.length-1,l=0;l<=i;l++)n=l===i?this:this.clone(!0),m(r[l])[t](n),a.apply(o,n.get());return this.pushStack(o)}});var Ie=/^margin/,Le=new RegExp("^("+Y+")(?!px)[a-z%]+$","i"),_e=function(t){var n=t.ownerDocument.defaultView;return n&&n.opener||(n=e),n.getComputedStyle(t)};function Fe(e,t,n){var o,r,i,l,a=e.style;return(n=n||_e(e))&&(""!==(l=n.getPropertyValue(t)||n[t])||m.contains(e.ownerDocument,e)||(l=m.style(e,t)),!h.pixelMarginRight()&&Le.test(l)&&Ie.test(t)&&(o=a.width,r=a.minWidth,i=a.maxWidth,a.minWidth=a.maxWidth=a.width=l,l=n.width,a.width=o,a.minWidth=r,a.maxWidth=i)),void 0!==l?l+"":l}function Me(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function t(){if(s){s.style.cssText="box-sizing:border-box;position:relative;display:block;margin:auto;border:1px;padding:1px;top:1%;width:50%",s.innerHTML="",ge.appendChild(a);var t=e.getComputedStyle(s);n="1%"!==t.top,l="2px"===t.marginLeft,r="4px"===t.width,s.style.marginRight="50%",i="4px"===t.marginRight,ge.removeChild(a),s=null}}var n,r,i,l,a=o.createElement("div"),s=o.createElement("div");s.style&&(s.style.backgroundClip="content-box",s.cloneNode(!0).style.backgroundClip="",h.clearCloneStyle="content-box"===s.style.backgroundClip,a.style.cssText="border:0;width:8px;height:0;top:0;left:-9999px;padding:0;margin-top:1px;position:absolute",a.appendChild(s),m.extend(h,{pixelPosition:function(){return t(),n},boxSizingReliable:function(){return t(),r},pixelMarginRight:function(){return t(),i},reliableMarginLeft:function(){return t(),l}}))}();var We=/^(none|table(?!-c[ea]).+)/,Ve=/^--/,je={position:"absolute",visibility:"hidden",display:"block"},Be={letterSpacing:"0",fontWeight:"400"},Oe=["Webkit","Moz","ms"],ze=o.createElement("div").style;function qe(e){var t=m.cssProps[e];return t||(t=m.cssProps[e]=function(e){if(e in ze)return e;for(var t=e[0].toUpperCase()+e.slice(1),n=Oe.length;n--;)if((e=Oe[n]+t)in ze)return e}(e)||e),t}function Xe(e,t,n){var o=Q.exec(t);return o?Math.max(0,o[2]-(n||0))+(o[3]||"px"):t}function Ke(e,t,n,o,r){var i,l=0;for(i=n===(o?"border":"content")?4:"width"===t?1:0;i<4;i+=2)"margin"===n&&(l+=m.css(e,n+J[i],!0,r)),o?("content"===n&&(l-=m.css(e,"padding"+J[i],!0,r)),"margin"!==n&&(l-=m.css(e,"border"+J[i]+"Width",!0,r))):(l+=m.css(e,"padding"+J[i],!0,r),"padding"!==n&&(l+=m.css(e,"border"+J[i]+"Width",!0,r)));return l}function Ue(e,t,n){var o,r=_e(e),i=Fe(e,t,r),l="border-box"===m.css(e,"boxSizing",!1,r);return Le.test(i)?i:(o=l&&(h.boxSizingReliable()||i===e.style[t]),"auto"===i&&(i=e["offset"+t[0].toUpperCase()+t.slice(1)]),(i=parseFloat(i)||0)+Ke(e,t,n||(l?"border":"content"),o,r)+"px")}function Ge(e,t,n,o,r){return new Ge.prototype.init(e,t,n,o,r)}m.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Fe(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{float:"cssFloat"},style:function(e,t,n,o){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var r,i,l,a=m.camelCase(t),s=Ve.test(t),c=e.style;if(s||(t=qe(a)),l=m.cssHooks[t]||m.cssHooks[a],void 0===n)return l&&"get"in l&&void 0!==(r=l.get(e,!1,o))?r:c[t];"string"===(i=typeof n)&&(r=Q.exec(n))&&r[1]&&(n=te(e,t,r),i="number"),null!=n&&n==n&&("number"===i&&(n+=r&&r[3]||(m.cssNumber[a]?"":"px")),h.clearCloneStyle||""!==n||0!==t.indexOf("background")||(c[t]="inherit"),l&&"set"in l&&void 0===(n=l.set(e,n,o))||(s?c.setProperty(t,n):c[t]=n))}},css:function(e,t,n,o){var r,i,l,a=m.camelCase(t);return Ve.test(t)||(t=qe(a)),(l=m.cssHooks[t]||m.cssHooks[a])&&"get"in l&&(r=l.get(e,!0,n)),void 0===r&&(r=Fe(e,t,o)),"normal"===r&&t in Be&&(r=Be[t]),""===n||n?(i=parseFloat(r),!0===n||isFinite(i)?i||0:r):r}}),m.each(["height","width"],function(e,t){m.cssHooks[t]={get:function(e,n,o){if(n)return!We.test(m.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?Ue(e,t,o):ee(e,je,function(){return Ue(e,t,o)})},set:function(e,n,o){var r,i=o&&_e(e),l=o&&Ke(e,t,o,"border-box"===m.css(e,"boxSizing",!1,i),i);return l&&(r=Q.exec(n))&&"px"!==(r[3]||"px")&&(e.style[t]=n,n=m.css(e,t)),Xe(0,n,l)}}}),m.cssHooks.marginLeft=Me(h.reliableMarginLeft,function(e,t){if(t)return(parseFloat(Fe(e,"marginLeft"))||e.getBoundingClientRect().left-ee(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),m.each({margin:"",padding:"",border:"Width"},function(e,t){m.cssHooks[e+t]={expand:function(n){for(var o=0,r={},i="string"==typeof n?n.split(" "):[n];o<4;o++)r[e+J[o]+t]=i[o]||i[o-2]||i[0];return r}},Ie.test(e)||(m.cssHooks[e+t].set=Xe)}),m.fn.extend({css:function(e,t){return B(this,function(e,t,n){var o,r,i={},l=0;if(Array.isArray(t)){for(o=_e(e),r=t.length;l<r;l++)i[t[l]]=m.css(e,t[l],!1,o);return i}return void 0!==n?m.style(e,t,n):m.css(e,t)},e,t,arguments.length>1)}}),m.Tween=Ge,Ge.prototype={constructor:Ge,init:function(e,t,n,o,r,i){this.elem=e,this.prop=n,this.easing=r||m.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=o,this.unit=i||(m.cssNumber[n]?"":"px")},cur:function(){var e=Ge.propHooks[this.prop];return e&&e.get?e.get(this):Ge.propHooks._default.get(this)},run:function(e){var t,n=Ge.propHooks[this.prop];return this.options.duration?this.pos=t=m.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):Ge.propHooks._default.set(this),this}},Ge.prototype.init.prototype=Ge.prototype,Ge.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=m.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){m.fx.step[e.prop]?m.fx.step[e.prop](e):1!==e.elem.nodeType||null==e.elem.style[m.cssProps[e.prop]]&&!m.cssHooks[e.prop]?e.elem[e.prop]=e.now:m.style(e.elem,e.prop,e.now+e.unit)}}},Ge.propHooks.scrollTop=Ge.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},m.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},m.fx=Ge.prototype.init,m.fx.step={};var Ye,Qe,Je=/^(?:toggle|show|hide)$/,Ze=/queueHooks$/;function et(){Qe&&(!1===o.hidden&&e.requestAnimationFrame?e.requestAnimationFrame(et):e.setTimeout(et,m.fx.interval),m.fx.tick())}function tt(){return e.setTimeout(function(){Ye=void 0}),Ye=m.now()}function nt(e,t){var n,o=0,r={height:e};for(t=t?1:0;o<4;o+=2-t)r["margin"+(n=J[o])]=r["padding"+n]=e;return t&&(r.opacity=r.width=e),r}function ot(e,t,n){for(var o,r=(rt.tweeners[t]||[]).concat(rt.tweeners["*"]),i=0,l=r.length;i<l;i++)if(o=r[i].call(n,t,e))return o}function rt(e,t,n){var o,r,i=0,l=rt.prefilters.length,a=m.Deferred().always(function(){delete s.elem}),s=function(){if(r)return!1;for(var t=Ye||tt(),n=Math.max(0,c.startTime+c.duration-t),o=1-(n/c.duration||0),i=0,l=c.tweens.length;i<l;i++)c.tweens[i].run(o);return a.notifyWith(e,[c,o,n]),o<1&&l?n:(l||a.notifyWith(e,[c,1,0]),a.resolveWith(e,[c]),!1)},c=a.promise({elem:e,props:m.extend({},t),opts:m.extend(!0,{specialEasing:{},easing:m.easing._default},n),originalProperties:t,originalOptions:n,startTime:Ye||tt(),duration:n.duration,tweens:[],createTween:function(t,n){var o=m.Tween(e,c.opts,t,n,c.opts.specialEasing[t]||c.opts.easing);return c.tweens.push(o),o},stop:function(t){var n=0,o=t?c.tweens.length:0;if(r)return this;for(r=!0;n<o;n++)c.tweens[n].run(1);return t?(a.notifyWith(e,[c,1,0]),a.resolveWith(e,[c,t])):a.rejectWith(e,[c,t]),this}}),u=c.props;for(!function(e,t){var n,o,r,i,l;for(n in e)if(r=t[o=m.camelCase(n)],i=e[n],Array.isArray(i)&&(r=i[1],i=e[n]=i[0]),n!==o&&(e[o]=i,delete e[n]),(l=m.cssHooks[o])&&"expand"in l)for(n in i=l.expand(i),delete e[o],i)n in e||(e[n]=i[n],t[n]=r);else t[o]=r}(u,c.opts.specialEasing);i<l;i++)if(o=rt.prefilters[i].call(c,e,u,c.opts))return m.isFunction(o.stop)&&(m._queueHooks(c.elem,c.opts.queue).stop=m.proxy(o.stop,o)),o;return m.map(u,ot,c),m.isFunction(c.opts.start)&&c.opts.start.call(e,c),c.progress(c.opts.progress).done(c.opts.done,c.opts.complete).fail(c.opts.fail).always(c.opts.always),m.fx.timer(m.extend(s,{elem:e,anim:c,queue:c.opts.queue})),c}m.Animation=m.extend(rt,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return te(n.elem,e,Q.exec(t),n),n}]},tweener:function(e,t){m.isFunction(e)?(t=e,e=["*"]):e=e.match(L);for(var n,o=0,r=e.length;o<r;o++)n=e[o],rt.tweeners[n]=rt.tweeners[n]||[],rt.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var o,r,i,l,a,s,c,u,d="width"in t||"height"in t,p=this,f={},h=e.style,g=e.nodeType&&Z(e),v=q.get(e,"fxshow");for(o in n.queue||(null==(l=m._queueHooks(e,"fx")).unqueued&&(l.unqueued=0,a=l.empty.fire,l.empty.fire=function(){l.unqueued||a()}),l.unqueued++,p.always(function(){p.always(function(){l.unqueued--,m.queue(e,"fx").length||l.empty.fire()})})),t)if(r=t[o],Je.test(r)){if(delete t[o],i=i||"toggle"===r,r===(g?"hide":"show")){if("show"!==r||!v||void 0===v[o])continue;g=!0}f[o]=v&&v[o]||m.style(e,o)}if((s=!m.isEmptyObject(t))||!m.isEmptyObject(f))for(o in d&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(c=v&&v.display)&&(c=q.get(e,"display")),"none"===(u=m.css(e,"display"))&&(c?u=c:(re([e],!0),c=e.style.display||c,u=m.css(e,"display"),re([e]))),("inline"===u||"inline-block"===u&&null!=c)&&"none"===m.css(e,"float")&&(s||(p.done(function(){h.display=c}),null==c&&(u=h.display,c="none"===u?"":u)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always(function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]})),s=!1,f)s||(v?"hidden"in v&&(g=v.hidden):v=q.access(e,"fxshow",{display:c}),i&&(v.hidden=!g),g&&re([e],!0),p.done(function(){for(o in g||re([e]),q.remove(e,"fxshow"),f)m.style(e,o,f[o])})),s=ot(g?v[o]:0,o,p),o in v||(v[o]=s.start,g&&(s.end=s.start,s.start=0))}],prefilter:function(e,t){t?rt.prefilters.unshift(e):rt.prefilters.push(e)}}),m.speed=function(e,t,n){var o=e&&"object"==typeof e?m.extend({},e):{complete:n||!n&&t||m.isFunction(e)&&e,duration:e,easing:n&&t||t&&!m.isFunction(t)&&t};return m.fx.off?o.duration=0:"number"!=typeof o.duration&&(o.duration in m.fx.speeds?o.duration=m.fx.speeds[o.duration]:o.duration=m.fx.speeds._default),null!=o.queue&&!0!==o.queue||(o.queue="fx"),o.old=o.complete,o.complete=function(){m.isFunction(o.old)&&o.old.call(this),o.queue&&m.dequeue(this,o.queue)},o},m.fn.extend({fadeTo:function(e,t,n,o){return this.filter(Z).css("opacity",0).show().end().animate({opacity:t},e,n,o)},animate:function(e,t,n,o){var r=m.isEmptyObject(e),i=m.speed(t,n,o),l=function(){var t=rt(this,m.extend({},e),i);(r||q.get(this,"finish"))&&t.stop(!0)};return l.finish=l,r||!1===i.queue?this.each(l):this.queue(i.queue,l)},stop:function(e,t,n){var o=function(e){var t=e.stop;delete e.stop,t(n)};return"string"!=typeof e&&(n=t,t=e,e=void 0),t&&!1!==e&&this.queue(e||"fx",[]),this.each(function(){var t=!0,r=null!=e&&e+"queueHooks",i=m.timers,l=q.get(this);if(r)l[r]&&l[r].stop&&o(l[r]);else for(r in l)l[r]&&l[r].stop&&Ze.test(r)&&o(l[r]);for(r=i.length;r--;)i[r].elem!==this||null!=e&&i[r].queue!==e||(i[r].anim.stop(n),t=!1,i.splice(r,1));!t&&n||m.dequeue(this,e)})},finish:function(e){return!1!==e&&(e=e||"fx"),this.each(function(){var t,n=q.get(this),o=n[e+"queue"],r=n[e+"queueHooks"],i=m.timers,l=o?o.length:0;for(n.finish=!0,m.queue(this,e,[]),r&&r.stop&&r.stop.call(this,!0),t=i.length;t--;)i[t].elem===this&&i[t].queue===e&&(i[t].anim.stop(!0),i.splice(t,1));for(t=0;t<l;t++)o[t]&&o[t].finish&&o[t].finish.call(this);delete n.finish})}}),m.each(["toggle","show","hide"],function(e,t){var n=m.fn[t];m.fn[t]=function(e,o,r){return null==e||"boolean"==typeof e?n.apply(this,arguments):this.animate(nt(t,!0),e,o,r)}}),m.each({slideDown:nt("show"),slideUp:nt("hide"),slideToggle:nt("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,t){m.fn[e]=function(e,n,o){return this.animate(t,e,n,o)}}),m.timers=[],m.fx.tick=function(){var e,t=0,n=m.timers;for(Ye=m.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||m.fx.stop(),Ye=void 0},m.fx.timer=function(e){m.timers.push(e),m.fx.start()},m.fx.interval=13,m.fx.start=function(){Qe||(Qe=!0,et())},m.fx.stop=function(){Qe=null},m.fx.speeds={slow:600,fast:200,_default:400},m.fn.delay=function(t,n){return t=m.fx&&m.fx.speeds[t]||t,n=n||"fx",this.queue(n,function(n,o){var r=e.setTimeout(n,t);o.stop=function(){e.clearTimeout(r)}})},function(){var e=o.createElement("input"),t=o.createElement("select").appendChild(o.createElement("option"));e.type="checkbox",h.checkOn=""!==e.value,h.optSelected=t.selected,(e=o.createElement("input")).value="t",e.type="radio",h.radioValue="t"===e.value}();var it,lt=m.expr.attrHandle;m.fn.extend({attr:function(e,t){return B(this,m.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){m.removeAttr(this,e)})}}),m.extend({attr:function(e,t,n){var o,r,i=e.nodeType;if(3!==i&&8!==i&&2!==i)return void 0===e.getAttribute?m.prop(e,t,n):(1===i&&m.isXMLDoc(e)||(r=m.attrHooks[t.toLowerCase()]||(m.expr.match.bool.test(t)?it:void 0)),void 0!==n?null===n?void m.removeAttr(e,t):r&&"set"in r&&void 0!==(o=r.set(e,n,t))?o:(e.setAttribute(t,n+""),n):r&&"get"in r&&null!==(o=r.get(e,t))?o:null==(o=m.find.attr(e,t))?void 0:o)},attrHooks:{type:{set:function(e,t){if(!h.radioValue&&"radio"===t&&k(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,o=0,r=t&&t.match(L);if(r&&1===e.nodeType)for(;n=r[o++];)e.removeAttribute(n)}}),it={set:function(e,t,n){return!1===t?m.removeAttr(e,n):e.setAttribute(n,n),n}},m.each(m.expr.match.bool.source.match(/\w+/g),function(e,t){var n=lt[t]||m.find.attr;lt[t]=function(e,t,o){var r,i,l=t.toLowerCase();return o||(i=lt[l],lt[l]=r,r=null!=n(e,t,o)?l:null,lt[l]=i),r}});var at=/^(?:input|select|textarea|button)$/i,st=/^(?:a|area)$/i;function ct(e){return(e.match(L)||[]).join(" ")}function ut(e){return e.getAttribute&&e.getAttribute("class")||""}m.fn.extend({prop:function(e,t){return B(this,m.prop,e,t,arguments.length>1)},removeProp:function(e){return this.each(function(){delete this[m.propFix[e]||e]})}}),m.extend({prop:function(e,t,n){var o,r,i=e.nodeType;if(3!==i&&8!==i&&2!==i)return 1===i&&m.isXMLDoc(e)||(t=m.propFix[t]||t,r=m.propHooks[t]),void 0!==n?r&&"set"in r&&void 0!==(o=r.set(e,n,t))?o:e[t]=n:r&&"get"in r&&null!==(o=r.get(e,t))?o:e[t]},propHooks:{tabIndex:{get:function(e){var t=m.find.attr(e,"tabindex");return t?parseInt(t,10):at.test(e.nodeName)||st.test(e.nodeName)&&e.href?0:-1}}},propFix:{for:"htmlFor",class:"className"}}),h.optSelected||(m.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),m.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){m.propFix[this.toLowerCase()]=this}),m.fn.extend({addClass:function(e){var t,n,o,r,i,l,a,s=0;if(m.isFunction(e))return this.each(function(t){m(this).addClass(e.call(this,t,ut(this)))});if("string"==typeof e&&e)for(t=e.match(L)||[];n=this[s++];)if(r=ut(n),o=1===n.nodeType&&" "+ct(r)+" "){for(l=0;i=t[l++];)o.indexOf(" "+i+" ")<0&&(o+=i+" ");r!==(a=ct(o))&&n.setAttribute("class",a)}return this},removeClass:function(e){var t,n,o,r,i,l,a,s=0;if(m.isFunction(e))return this.each(function(t){m(this).removeClass(e.call(this,t,ut(this)))});if(!arguments.length)return this.attr("class","");if("string"==typeof e&&e)for(t=e.match(L)||[];n=this[s++];)if(r=ut(n),o=1===n.nodeType&&" "+ct(r)+" "){for(l=0;i=t[l++];)for(;o.indexOf(" "+i+" ")>-1;)o=o.replace(" "+i+" "," ");r!==(a=ct(o))&&n.setAttribute("class",a)}return this},toggleClass:function(e,t){var n=typeof e;return"boolean"==typeof t&&"string"===n?t?this.addClass(e):this.removeClass(e):m.isFunction(e)?this.each(function(n){m(this).toggleClass(e.call(this,n,ut(this),t),t)}):this.each(function(){var t,o,r,i;if("string"===n)for(o=0,r=m(this),i=e.match(L)||[];t=i[o++];)r.hasClass(t)?r.removeClass(t):r.addClass(t);else void 0!==e&&"boolean"!==n||((t=ut(this))&&q.set(this,"__className__",t),this.setAttribute&&this.setAttribute("class",t||!1===e?"":q.get(this,"__className__")||""))})},hasClass:function(e){var t,n,o=0;for(t=" "+e+" ";n=this[o++];)if(1===n.nodeType&&(" "+ct(ut(n))+" ").indexOf(t)>-1)return!0;return!1}});var dt=/\r/g;m.fn.extend({val:function(e){var t,n,o,r=this[0];return arguments.length?(o=m.isFunction(e),this.each(function(n){var r;1===this.nodeType&&(null==(r=o?e.call(this,n,m(this).val()):e)?r="":"number"==typeof r?r+="":Array.isArray(r)&&(r=m.map(r,function(e){return null==e?"":e+""})),(t=m.valHooks[this.type]||m.valHooks[this.nodeName.toLowerCase()])&&"set"in t&&void 0!==t.set(this,r,"value")||(this.value=r))})):r?(t=m.valHooks[r.type]||m.valHooks[r.nodeName.toLowerCase()])&&"get"in t&&void 0!==(n=t.get(r,"value"))?n:"string"==typeof(n=r.value)?n.replace(dt,""):null==n?"":n:void 0}}),m.extend({valHooks:{option:{get:function(e){var t=m.find.attr(e,"value");return null!=t?t:ct(m.text(e))}},select:{get:function(e){var t,n,o,r=e.options,i=e.selectedIndex,l="select-one"===e.type,a=l?null:[],s=l?i+1:r.length;for(o=i<0?s:l?i:0;o<s;o++)if(((n=r[o]).selected||o===i)&&!n.disabled&&(!n.parentNode.disabled||!k(n.parentNode,"optgroup"))){if(t=m(n).val(),l)return t;a.push(t)}return a},set:function(e,t){for(var n,o,r=e.options,i=m.makeArray(t),l=r.length;l--;)((o=r[l]).selected=m.inArray(m.valHooks.option.get(o),i)>-1)&&(n=!0);return n||(e.selectedIndex=-1),i}}}}),m.each(["radio","checkbox"],function(){m.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=m.inArray(m(e).val(),t)>-1}},h.checkOn||(m.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})});var pt=/^(?:focusinfocus|focusoutblur)$/;m.extend(m.event,{trigger:function(t,n,r,i){var l,a,s,c,u,p,f,h=[r||o],g=d.call(t,"type")?t.type:t,v=d.call(t,"namespace")?t.namespace.split("."):[];if(a=s=r=r||o,3!==r.nodeType&&8!==r.nodeType&&!pt.test(g+m.event.triggered)&&(g.indexOf(".")>-1&&(v=g.split("."),g=v.shift(),v.sort()),u=g.indexOf(":")<0&&"on"+g,(t=t[m.expando]?t:new m.Event(g,"object"==typeof t&&t)).isTrigger=i?2:3,t.namespace=v.join("."),t.rnamespace=t.namespace?new RegExp("(^|\\.)"+v.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,t.result=void 0,t.target||(t.target=r),n=null==n?[t]:m.makeArray(n,[t]),f=m.event.special[g]||{},i||!f.trigger||!1!==f.trigger.apply(r,n))){if(!i&&!f.noBubble&&!m.isWindow(r)){for(c=f.delegateType||g,pt.test(c+g)||(a=a.parentNode);a;a=a.parentNode)h.push(a),s=a;s===(r.ownerDocument||o)&&h.push(s.defaultView||s.parentWindow||e)}for(l=0;(a=h[l++])&&!t.isPropagationStopped();)t.type=l>1?c:f.bindType||g,(p=(q.get(a,"events")||{})[t.type]&&q.get(a,"handle"))&&p.apply(a,n),(p=u&&a[u])&&p.apply&&O(a)&&(t.result=p.apply(a,n),!1===t.result&&t.preventDefault());return t.type=g,i||t.isDefaultPrevented()||f._default&&!1!==f._default.apply(h.pop(),n)||!O(r)||u&&m.isFunction(r[g])&&!m.isWindow(r)&&((s=r[u])&&(r[u]=null),m.event.triggered=g,r[g](),m.event.triggered=void 0,s&&(r[u]=s)),t.result}},simulate:function(e,t,n){var o=m.extend(new m.Event,n,{type:e,isSimulated:!0});m.event.trigger(o,null,t)}}),m.fn.extend({trigger:function(e,t){return this.each(function(){m.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return m.event.trigger(e,t,n,!0)}}),m.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,t){m.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),m.fn.extend({hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),h.focusin="onfocusin"in e,h.focusin||m.each({focus:"focusin",blur:"focusout"},function(e,t){var n=function(e){m.event.simulate(t,e.target,m.event.fix(e))};m.event.special[t]={setup:function(){var o=this.ownerDocument||this,r=q.access(o,t);r||o.addEventListener(e,n,!0),q.access(o,t,(r||0)+1)},teardown:function(){var o=this.ownerDocument||this,r=q.access(o,t)-1;r?q.access(o,t,r):(o.removeEventListener(e,n,!0),q.remove(o,t))}}});var ft=e.location,ht=m.now(),gt=/\?/;m.parseXML=function(t){var n;if(!t||"string"!=typeof t)return null;try{n=(new e.DOMParser).parseFromString(t,"text/xml")}catch(e){n=void 0}return n&&!n.getElementsByTagName("parsererror").length||m.error("Invalid XML: "+t),n};var mt=/\[\]$/,vt=/\r?\n/g,wt=/^(?:submit|button|image|reset|file)$/i,Ct=/^(?:input|select|textarea|keygen)/i;function yt(e,t,n,o){var r;if(Array.isArray(t))m.each(t,function(t,r){n||mt.test(e)?o(e,r):yt(e+"["+("object"==typeof r&&null!=r?t:"")+"]",r,n,o)});else if(n||"object"!==m.type(t))o(e,t);else for(r in t)yt(e+"["+r+"]",t[r],n,o)}m.param=function(e,t){var n,o=[],r=function(e,t){var n=m.isFunction(t)?t():t;o[o.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(Array.isArray(e)||e.jquery&&!m.isPlainObject(e))m.each(e,function(){r(this.name,this.value)});else for(n in e)yt(n,e[n],t,r);return o.join("&")},m.fn.extend({serialize:function(){return m.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=m.prop(this,"elements");return e?m.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!m(this).is(":disabled")&&Ct.test(this.nodeName)&&!wt.test(e)&&(this.checked||!ie.test(e))}).map(function(e,t){var n=m(this).val();return null==n?null:Array.isArray(n)?m.map(n,function(e){return{name:t.name,value:e.replace(vt,"\r\n")}}):{name:t.name,value:n.replace(vt,"\r\n")}}).get()}});var bt=/%20/g,xt=/#.*$/,Rt=/([?&])_=[^&]*/,St=/^(.*?):[ \t]*([^\r\n]*)$/gm,Et=/^(?:GET|HEAD)$/,kt=/^\/\//,Tt={},Pt={},Dt="*/".concat("*"),At=o.createElement("a");function Nt(e){return function(t,n){"string"!=typeof t&&(n=t,t="*");var o,r=0,i=t.toLowerCase().match(L)||[];if(m.isFunction(n))for(;o=i[r++];)"+"===o[0]?(o=o.slice(1)||"*",(e[o]=e[o]||[]).unshift(n)):(e[o]=e[o]||[]).push(n)}}function Ht(e,t,n,o){var r={},i=e===Pt;function l(a){var s;return r[a]=!0,m.each(e[a]||[],function(e,a){var c=a(t,n,o);return"string"!=typeof c||i||r[c]?i?!(s=c):void 0:(t.dataTypes.unshift(c),l(c),!1)}),s}return l(t.dataTypes[0])||!r["*"]&&l("*")}function $t(e,t){var n,o,r=m.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((r[n]?e:o||(o={}))[n]=t[n]);return o&&m.extend(!0,e,o),e}At.href=ft.href,m.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:ft.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(ft.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":Dt,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":m.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?$t($t(e,m.ajaxSettings),t):$t(m.ajaxSettings,e)},ajaxPrefilter:Nt(Tt),ajaxTransport:Nt(Pt),ajax:function(t,n){"object"==typeof t&&(n=t,t=void 0),n=n||{};var r,i,l,a,s,c,u,d,p,f,h=m.ajaxSetup({},n),g=h.context||h,v=h.context&&(g.nodeType||g.jquery)?m(g):m.event,w=m.Deferred(),C=m.Callbacks("once memory"),y=h.statusCode||{},b={},x={},R="canceled",S={readyState:0,getResponseHeader:function(e){var t;if(u){if(!a)for(a={};t=St.exec(l);)a[t[1].toLowerCase()]=t[2];t=a[e.toLowerCase()]}return null==t?null:t},getAllResponseHeaders:function(){return u?l:null},setRequestHeader:function(e,t){return null==u&&(e=x[e.toLowerCase()]=x[e.toLowerCase()]||e,b[e]=t),this},overrideMimeType:function(e){return null==u&&(h.mimeType=e),this},statusCode:function(e){var t;if(e)if(u)S.always(e[S.status]);else for(t in e)y[t]=[y[t],e[t]];return this},abort:function(e){var t=e||R;return r&&r.abort(t),E(0,t),this}};if(w.promise(S),h.url=((t||h.url||ft.href)+"").replace(kt,ft.protocol+"//"),h.type=n.method||n.type||h.method||h.type,h.dataTypes=(h.dataType||"*").toLowerCase().match(L)||[""],null==h.crossDomain){c=o.createElement("a");try{c.href=h.url,c.href=c.href,h.crossDomain=At.protocol+"//"+At.host!=c.protocol+"//"+c.host}catch(e){h.crossDomain=!0}}if(h.data&&h.processData&&"string"!=typeof h.data&&(h.data=m.param(h.data,h.traditional)),Ht(Tt,h,n,S),u)return S;for(p in(d=m.event&&h.global)&&0==m.active++&&m.event.trigger("ajaxStart"),h.type=h.type.toUpperCase(),h.hasContent=!Et.test(h.type),i=h.url.replace(xt,""),h.hasContent?h.data&&h.processData&&0===(h.contentType||"").indexOf("application/x-www-form-urlencoded")&&(h.data=h.data.replace(bt,"+")):(f=h.url.slice(i.length),h.data&&(i+=(gt.test(i)?"&":"?")+h.data,delete h.data),!1===h.cache&&(i=i.replace(Rt,"$1"),f=(gt.test(i)?"&":"?")+"_="+ht+++f),h.url=i+f),h.ifModified&&(m.lastModified[i]&&S.setRequestHeader("If-Modified-Since",m.lastModified[i]),m.etag[i]&&S.setRequestHeader("If-None-Match",m.etag[i])),(h.data&&h.hasContent&&!1!==h.contentType||n.contentType)&&S.setRequestHeader("Content-Type",h.contentType),S.setRequestHeader("Accept",h.dataTypes[0]&&h.accepts[h.dataTypes[0]]?h.accepts[h.dataTypes[0]]+("*"!==h.dataTypes[0]?", "+Dt+"; q=0.01":""):h.accepts["*"]),h.headers)S.setRequestHeader(p,h.headers[p]);if(h.beforeSend&&(!1===h.beforeSend.call(g,S,h)||u))return S.abort();if(R="abort",C.add(h.complete),S.done(h.success),S.fail(h.error),r=Ht(Pt,h,n,S)){if(S.readyState=1,d&&v.trigger("ajaxSend",[S,h]),u)return S;h.async&&h.timeout>0&&(s=e.setTimeout(function(){S.abort("timeout")},h.timeout));try{u=!1,r.send(b,E)}catch(e){if(u)throw e;E(-1,e)}}else E(-1,"No Transport");function E(t,n,o,a){var c,p,f,b,x,R=n;u||(u=!0,s&&e.clearTimeout(s),r=void 0,l=a||"",S.readyState=t>0?4:0,c=t>=200&&t<300||304===t,o&&(b=function(e,t,n){for(var o,r,i,l,a=e.contents,s=e.dataTypes;"*"===s[0];)s.shift(),void 0===o&&(o=e.mimeType||t.getResponseHeader("Content-Type"));if(o)for(r in a)if(a[r]&&a[r].test(o)){s.unshift(r);break}if(s[0]in n)i=s[0];else{for(r in n){if(!s[0]||e.converters[r+" "+s[0]]){i=r;break}l||(l=r)}i=i||l}if(i)return i!==s[0]&&s.unshift(i),n[i]}(h,S,o)),b=function(e,t,n,o){var r,i,l,a,s,c={},u=e.dataTypes.slice();if(u[1])for(l in e.converters)c[l.toLowerCase()]=e.converters[l];for(i=u.shift();i;)if(e.responseFields[i]&&(n[e.responseFields[i]]=t),!s&&o&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),s=i,i=u.shift())if("*"===i)i=s;else if("*"!==s&&s!==i){if(!(l=c[s+" "+i]||c["* "+i]))for(r in c)if((a=r.split(" "))[1]===i&&(l=c[s+" "+a[0]]||c["* "+a[0]])){!0===l?l=c[r]:!0!==c[r]&&(i=a[0],u.unshift(a[1]));break}if(!0!==l)if(l&&e.throws)t=l(t);else try{t=l(t)}catch(e){return{state:"parsererror",error:l?e:"No conversion from "+s+" to "+i}}}return{state:"success",data:t}}(h,b,S,c),c?(h.ifModified&&((x=S.getResponseHeader("Last-Modified"))&&(m.lastModified[i]=x),(x=S.getResponseHeader("etag"))&&(m.etag[i]=x)),204===t||"HEAD"===h.type?R="nocontent":304===t?R="notmodified":(R=b.state,p=b.data,c=!(f=b.error))):(f=R,!t&&R||(R="error",t<0&&(t=0))),S.status=t,S.statusText=(n||R)+"",c?w.resolveWith(g,[p,R,S]):w.rejectWith(g,[S,R,f]),S.statusCode(y),y=void 0,d&&v.trigger(c?"ajaxSuccess":"ajaxError",[S,h,c?p:f]),C.fireWith(g,[S,R]),d&&(v.trigger("ajaxComplete",[S,h]),--m.active||m.event.trigger("ajaxStop")))}return S},getJSON:function(e,t,n){return m.get(e,t,n,"json")},getScript:function(e,t){return m.get(e,void 0,t,"script")}}),m.each(["get","post"],function(e,t){m[t]=function(e,n,o,r){return m.isFunction(n)&&(r=r||o,o=n,n=void 0),m.ajax(m.extend({url:e,type:t,dataType:r,data:n,success:o},m.isPlainObject(e)&&e))}}),m._evalUrl=function(e){return m.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,throws:!0})},m.fn.extend({wrapAll:function(e){var t;return this[0]&&(m.isFunction(e)&&(e=e.call(this[0])),t=m(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){for(var e=this;e.firstElementChild;)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(e){return m.isFunction(e)?this.each(function(t){m(this).wrapInner(e.call(this,t))}):this.each(function(){var t=m(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=m.isFunction(e);return this.each(function(n){m(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(e){return this.parent(e).not("body").each(function(){m(this).replaceWith(this.childNodes)}),this}}),m.expr.pseudos.hidden=function(e){return!m.expr.pseudos.visible(e)},m.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},m.ajaxSettings.xhr=function(){try{return new e.XMLHttpRequest}catch(e){}};var It={0:200,1223:204},Lt=m.ajaxSettings.xhr();h.cors=!!Lt&&"withCredentials"in Lt,h.ajax=Lt=!!Lt,m.ajaxTransport(function(t){var n,o;if(h.cors||Lt&&!t.crossDomain)return{send:function(r,i){var l,a=t.xhr();if(a.open(t.type,t.url,t.async,t.username,t.password),t.xhrFields)for(l in t.xhrFields)a[l]=t.xhrFields[l];for(l in t.mimeType&&a.overrideMimeType&&a.overrideMimeType(t.mimeType),t.crossDomain||r["X-Requested-With"]||(r["X-Requested-With"]="XMLHttpRequest"),r)a.setRequestHeader(l,r[l]);n=function(e){return function(){n&&(n=o=a.onload=a.onerror=a.onabort=a.onreadystatechange=null,"abort"===e?a.abort():"error"===e?"number"!=typeof a.status?i(0,"error"):i(a.status,a.statusText):i(It[a.status]||a.status,a.statusText,"text"!==(a.responseType||"text")||"string"!=typeof a.responseText?{binary:a.response}:{text:a.responseText},a.getAllResponseHeaders()))}},a.onload=n(),o=a.onerror=n("error"),void 0!==a.onabort?a.onabort=o:a.onreadystatechange=function(){4===a.readyState&&e.setTimeout(function(){n&&o()})},n=n("abort");try{a.send(t.hasContent&&t.data||null)}catch(e){if(n)throw e}},abort:function(){n&&n()}}}),m.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),m.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return m.globalEval(e),e}}}),m.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),m.ajaxTransport("script",function(e){var t,n;if(e.crossDomain)return{send:function(r,i){t=m("<script>").prop({charset:e.scriptCharset,src:e.url}).on("load error",n=function(e){t.remove(),n=null,e&&i("error"===e.type?404:200,e.type)}),o.head.appendChild(t[0])},abort:function(){n&&n()}}});var _t,Ft=[],Mt=/(=)\?(?=&|$)|\?\?/;m.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Ft.pop()||m.expando+"_"+ht++;return this[e]=!0,e}}),m.ajaxPrefilter("json jsonp",function(t,n,o){var r,i,l,a=!1!==t.jsonp&&(Mt.test(t.url)?"url":"string"==typeof t.data&&0===(t.contentType||"").indexOf("application/x-www-form-urlencoded")&&Mt.test(t.data)&&"data");if(a||"jsonp"===t.dataTypes[0])return r=t.jsonpCallback=m.isFunction(t.jsonpCallback)?t.jsonpCallback():t.jsonpCallback,a?t[a]=t[a].replace(Mt,"$1"+r):!1!==t.jsonp&&(t.url+=(gt.test(t.url)?"&":"?")+t.jsonp+"="+r),t.converters["script json"]=function(){return l||m.error(r+" was not called"),l[0]},t.dataTypes[0]="json",i=e[r],e[r]=function(){l=arguments},o.always(function(){void 0===i?m(e).removeProp(r):e[r]=i,t[r]&&(t.jsonpCallback=n.jsonpCallback,Ft.push(r)),l&&m.isFunction(i)&&i(l[0]),l=i=void 0}),"script"}),h.createHTMLDocument=((_t=o.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===_t.childNodes.length),m.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(h.createHTMLDocument?((r=(t=o.implementation.createHTMLDocument("")).createElement("base")).href=o.location.href,t.head.appendChild(r)):t=o),l=!n&&[],(i=T.exec(e))?[t.createElement(i[1])]:(i=he([e],t,l),l&&l.length&&m(l).remove(),m.merge([],i.childNodes)));var r,i,l},m.fn.load=function(e,t,n){var o,r,i,l=this,a=e.indexOf(" ");return a>-1&&(o=ct(e.slice(a)),e=e.slice(0,a)),m.isFunction(t)?(n=t,t=void 0):t&&"object"==typeof t&&(r="POST"),l.length>0&&m.ajax({url:e,type:r||"GET",dataType:"html",data:t}).done(function(e){i=arguments,l.html(o?m("<div>").append(m.parseHTML(e)).find(o):e)}).always(n&&function(e,t){l.each(function(){n.apply(this,i||[e.responseText,t,e])})}),this},m.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){m.fn[t]=function(e){return this.on(t,e)}}),m.expr.pseudos.animated=function(e){return m.grep(m.timers,function(t){return e===t.elem}).length},m.offset={setOffset:function(e,t,n){var o,r,i,l,a,s,c=m.css(e,"position"),u=m(e),d={};"static"===c&&(e.style.position="relative"),a=u.offset(),i=m.css(e,"top"),s=m.css(e,"left"),("absolute"===c||"fixed"===c)&&(i+s).indexOf("auto")>-1?(l=(o=u.position()).top,r=o.left):(l=parseFloat(i)||0,r=parseFloat(s)||0),m.isFunction(t)&&(t=t.call(e,n,m.extend({},a))),null!=t.top&&(d.top=t.top-a.top+l),null!=t.left&&(d.left=t.left-a.left+r),"using"in t?t.using.call(e,d):u.css(d)}},m.fn.extend({offset:function(e){if(arguments.length)return void 0===e?this:this.each(function(t){m.offset.setOffset(this,e,t)});var t,n,o,r,i=this[0];return i?i.getClientRects().length?(o=i.getBoundingClientRect(),n=(t=i.ownerDocument).documentElement,r=t.defaultView,{top:o.top+r.pageYOffset-n.clientTop,left:o.left+r.pageXOffset-n.clientLeft}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n=this[0],o={top:0,left:0};return"fixed"===m.css(n,"position")?t=n.getBoundingClientRect():(e=this.offsetParent(),t=this.offset(),k(e[0],"html")||(o=e.offset()),o={top:o.top+m.css(e[0],"borderTopWidth",!0),left:o.left+m.css(e[0],"borderLeftWidth",!0)}),{top:t.top-o.top-m.css(n,"marginTop",!0),left:t.left-o.left-m.css(n,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){for(var e=this.offsetParent;e&&"static"===m.css(e,"position");)e=e.offsetParent;return e||ge})}}),m.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(e,t){var n="pageYOffset"===t;m.fn[e]=function(o){return B(this,function(e,o,r){var i;if(m.isWindow(e)?i=e:9===e.nodeType&&(i=e.defaultView),void 0===r)return i?i[t]:e[o];i?i.scrollTo(n?i.pageXOffset:r,n?r:i.pageYOffset):e[o]=r},e,o,arguments.length)}}),m.each(["top","left"],function(e,t){m.cssHooks[t]=Me(h.pixelPosition,function(e,n){if(n)return n=Fe(e,t),Le.test(n)?m(e).position()[t]+"px":n})}),m.each({Height:"height",Width:"width"},function(e,t){m.each({padding:"inner"+e,content:t,"":"outer"+e},function(n,o){m.fn[o]=function(r,i){var l=arguments.length&&(n||"boolean"!=typeof r),a=n||(!0===r||!0===i?"margin":"border");return B(this,function(t,n,r){var i;return m.isWindow(t)?0===o.indexOf("outer")?t["inner"+e]:t.document.documentElement["client"+e]:9===t.nodeType?(i=t.documentElement,Math.max(t.body["scroll"+e],i["scroll"+e],t.body["offset"+e],i["offset"+e],i["client"+e])):void 0===r?m.css(t,n,a):m.style(t,n,r,a)},t,l?r:void 0,l)}})}),m.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,o){return this.on(t,e,n,o)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)}}),m.holdReady=function(e){e?m.readyWait++:m.ready(!0)},m.isArray=Array.isArray,m.parseJSON=JSON.parse,m.nodeName=k,"function"==typeof define&&define.amd&&define("jquery",[],function(){return m});var Wt=e.jQuery,Vt=e.$;return m.noConflict=function(t){return e.$===m&&(e.$=Vt),t&&e.jQuery===m&&(e.jQuery=Wt),m},t||(e.jQuery=e.$=m),m})},455:function(e,t,n){
/*!
     * jquery.event.drag - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var o=e(462);o.fn.drag=function(e,t,n){var r="string"==typeof e?e:"",i=o.isFunction(e)?e:o.isFunction(t)?t:null;return 0!==r.indexOf("drag")&&(r="drag"+r),n=(e==i?t:n)||{},i?this.on(r,n,i):this.trigger(r)};var r=o.event,i=r.special,l=i.drag={defaults:{which:1,distance:0,not:":input",handle:null,relative:!1,drop:!0,click:!1},datakey:"dragdata",noBubble:!0,add:function(e){var t=o.data(this,l.datakey),n=e.data||{};t.related+=1,o.each(l.defaults,function(e,o){void 0!==n[e]&&(t[e]=n[e])})},remove:function(){o.data(this,l.datakey).related-=1},setup:function(){if(!o.data(this,l.datakey)){var e=o.extend({related:0},l.defaults);o.data(this,l.datakey,e),r.add(this,"touchstart mousedown",l.init,e),this.attachEvent&&this.attachEvent("ondragstart",l.dontstart)}},teardown:function(){(o.data(this,l.datakey)||{}).related||(o.removeData(this,l.datakey),r.remove(this,"touchstart mousedown",l.init),l.textselect(!0),this.detachEvent&&this.detachEvent("ondragstart",l.dontstart))},init:function(e){if(!l.touched){var t,n=e.data;if(!(0!=e.which&&n.which>0&&e.which!=n.which)&&!o(e.target).is(n.not)&&(!n.handle||o(e.target).closest(n.handle,e.currentTarget).length)&&(l.touched="touchstart"==e.type?this:null,n.propagates=1,n.mousedown=this,n.interactions=[l.interaction(this,n)],n.target=e.target,n.pageX=e.pageX,n.pageY=e.pageY,n.dragging=null,t=l.hijack(e,"draginit",n),n.propagates))return(t=l.flatten(t))&&t.length&&(n.interactions=[],o.each(t,function(){n.interactions.push(l.interaction(this,n))})),n.propagates=n.interactions.length,!1!==n.drop&&i.drop&&i.drop.handler(e,n),l.textselect(!1),l.touched?r.add(l.touched,"touchmove touchend",l.handler,n):r.add(document,"mousemove mouseup",l.handler,n),!(!l.touched||n.live)&&void 0}},interaction:function(e,t){var n=e&&e.ownerDocument&&o(e)[t.relative?"position":"offset"]()||{top:0,left:0};return{drag:e,callback:new l.callback,droppable:[],offset:n}},handler:function(e){var t=e.data;switch(e.type){case!t.dragging&&"touchmove":e.preventDefault();case!t.dragging&&"mousemove":if(Math.pow(e.pageX-t.pageX,2)+Math.pow(e.pageY-t.pageY,2)<Math.pow(t.distance,2))break;e.target=t.target,l.hijack(e,"dragstart",t),t.propagates&&(t.dragging=!0);case"touchmove":e.preventDefault();case"mousemove":if(t.dragging){if(l.hijack(e,"drag",t),t.propagates){!1!==t.drop&&i.drop&&i.drop.handler(e,t);break}e.type="mouseup"}case"touchend":case"mouseup":default:l.touched?r.remove(l.touched,"touchmove touchend",l.handler):r.remove(document,"mousemove mouseup",l.handler),t.dragging&&(!1!==t.drop&&i.drop&&i.drop.handler(e,t),l.hijack(e,"dragend",t)),l.textselect(!0),!1===t.click&&t.dragging&&o.data(t.mousedown,"suppress.click",(new Date).getTime()+5),t.dragging=l.touched=!1}},hijack:function(e,t,n,i,a){if(n){var s,c,u,d={event:e.originalEvent,type:e.type},p=t.indexOf("drop")?"drag":"drop",f=i||0,h=isNaN(i)?n.interactions.length:i;e.type=t;var g=function(){};e.originalEvent=new o.Event(d.event,{preventDefault:g,stopPropagation:g,stopImmediatePropagation:g}),n.results=[];do{if(c=n.interactions[f]){if("dragend"!==t&&c.cancelled)continue;u=l.properties(e,n,c),c.results=[],o(a||c[p]||n.droppable).each(function(i,a){if(u.target=a,e.isPropagationStopped=function(){return!1},!1===(s=a?r.dispatch.call(a,e,u):null)?("drag"==p&&(c.cancelled=!0,n.propagates-=1),"drop"==t&&(c[p][i]=null)):"dropinit"==t&&c.droppable.push(l.element(s)||a),"dragstart"==t&&(c.proxy=o(l.element(s)||c.drag)[0]),c.results.push(s),delete e.result,"dropinit"!==t)return s}),n.results[f]=l.flatten(c.results),"dropinit"==t&&(c.droppable=l.flatten(c.droppable)),"dragstart"!=t||c.cancelled||u.update()}}while(++f<h);return e.type=d.type,e.originalEvent=d.event,l.flatten(n.results)}},properties:function(e,t,n){var o=n.callback;return o.drag=n.drag,o.proxy=n.proxy||n.drag,o.startX=t.pageX,o.startY=t.pageY,o.deltaX=e.pageX-t.pageX,o.deltaY=e.pageY-t.pageY,o.originalX=n.offset.left,o.originalY=n.offset.top,o.offsetX=o.originalX+o.deltaX,o.offsetY=o.originalY+o.deltaY,o.drop=l.flatten((n.drop||[]).slice()),o.available=l.flatten((n.droppable||[]).slice()),o},element:function(e){if(e&&(e.jquery||1==e.nodeType))return e},flatten:function(e){return o.map(e,function(e){return e&&e.jquery?o.makeArray(e):e&&e.length?l.flatten(e):e})},textselect:function(e){o(document)[e?"off":"on"]("selectstart",l.dontstart).css("MozUserSelect",e?"":"none"),document.unselectable=e?"off":"on"},dontstart:function(){return!1},callback:function(){}};l.callback.prototype={update:function(){i.drop&&this.available.length&&o.each(this.available,function(e){i.drop.locate(this,e)})}};var a=r.dispatch;r.dispatch=function(e){if(!(o.data(this,"suppress."+e.type)-(new Date).getTime()>0))return a.apply(this,arguments);o.removeData(this,"suppress."+e.type)},i.draginit=i.dragstart=i.dragend=l},456:function(e,t,n){
/*!
     * jquery.event.drop - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var o=e(462);o.fn.drop=function(e,t,n){var r="string"==typeof e?e:"",i=o.isFunction(e)?e:o.isFunction(t)?t:null;return 0!==r.indexOf("drop")&&(r="drop"+r),n=(e==i?t:n)||{},i?this.on(r,n,i):this.trigger(r)},o.drop=function(e){e=e||{},i.multi=!0===e.multi?1/0:!1===e.multi?1:isNaN(e.multi)?i.multi:e.multi,i.delay=e.delay||i.delay,i.tolerance=o.isFunction(e.tolerance)?e.tolerance:null===e.tolerance?null:i.tolerance,i.mode=e.mode||i.mode||"intersect"};var r=o.event.special,i=o.event.special.drop={multi:1,delay:20,mode:"overlap",targets:[],datakey:"dropdata",noBubble:!0,add:function(e){o.data(this,i.datakey).related+=1},remove:function(){o.data(this,i.datakey).related-=1},setup:function(){if(!o.data(this,i.datakey)){o.data(this,i.datakey,{related:0,active:[],anyactive:0,winner:0,location:{}}),i.targets.push(this)}},teardown:function(){if(!(o.data(this,i.datakey)||{}).related){o.removeData(this,i.datakey);var e=this;i.targets=o.grep(i.targets,function(t){return t!==e})}},handler:function(e,t){var n;if(t)switch(e.type){case"mousedown":case"touchstart":n=o(i.targets),"string"==typeof t.drop&&(n=n.filter(t.drop)),n.each(function(){var e=o.data(this,i.datakey);e.active=[],e.anyactive=0,e.winner=0}),t.droppable=n,r.drag.hijack(e,"dropinit",t);break;case"mousemove":case"touchmove":i.event=e,i.timer||i.tolerate(t);break;case"mouseup":case"touchend":i.timer=clearTimeout(i.timer),t.propagates&&(r.drag.hijack(e,"drop",t),r.drag.hijack(e,"dropend",t))}},locate:function(e,t){var n=o.data(e,i.datakey),r=o(e),l=r.offset()||{},a=r.outerHeight(),s=r.outerWidth(),c={elem:e,width:s,height:a,top:l.top,left:l.left,right:l.left+s,bottom:l.top+a};return n&&(n.location=c,n.index=t,n.elem=e),c},contains:function(e,t){return(t[0]||t.left)>=e.left&&(t[0]||t.right)<=e.right&&(t[1]||t.top)>=e.top&&(t[1]||t.bottom)<=e.bottom},modes:{intersect:function(e,t,n){return this.contains(n,[e.pageX,e.pageY])?1e9:this.modes.overlap.apply(this,arguments)},overlap:function(e,t,n){return Math.max(0,Math.min(n.bottom,t.bottom)-Math.max(n.top,t.top))*Math.max(0,Math.min(n.right,t.right)-Math.max(n.left,t.left))},fit:function(e,t,n){return this.contains(n,t)?1:0},middle:function(e,t,n){return this.contains(n,[t.left+.5*t.width,t.top+.5*t.height])?1:0}},sort:function(e,t){return t.winner-e.winner||e.index-t.index},tolerate:function(e){var t,n,l,a,s,c,u,d,p=0,f=e.interactions.length,h=[i.event.pageX,i.event.pageY],g=i.tolerance||i.modes[i.mode];do{if(d=e.interactions[p]){if(!d)return;d.drop=[],s=[],c=d.droppable.length,g&&(l=i.locate(d.proxy)),t=0;do{if(u=d.droppable[t]){if(!(n=(a=o.data(u,i.datakey)).location))continue;a.winner=g?g.call(i,i.event,l,n):i.contains(n,h)?1:0,s.push(a)}}while(++t<c);s.sort(i.sort),t=0;do{(a=s[t])&&(a.winner&&d.drop.length<i.multi?(a.active[p]||a.anyactive||(!1!==r.drag.hijack(i.event,"dropstart",e,p,a.elem)[0]?(a.active[p]=1,a.anyactive+=1):a.winner=0),a.winner&&d.drop.push(a.elem)):a.active[p]&&1==a.anyactive&&(r.drag.hijack(i.event,"dropend",e,p,a.elem),a.active[p]=0,a.anyactive-=1))}while(++t<c)}}while(++p<f);i.last&&h[0]==i.last.pageX&&h[1]==i.last.pageY?delete i.timer:i.timer=setTimeout(function(){i.tolerate(e)},i.delay),i.last=i.event}};r.dropinit=r.dropstart=r.dropend=i},457:function(e,t,n){var o=e(462),r=e(460),i=r.keyCode;t.exports={CellExternalCopyManager:function(e){var t,n,l=this,a=e||{},s=a.copiedCellStyleLayerKey||"copy-manager",c=a.copiedCellStyle||"copied",u=0,d=a.bodyElement||document.body,p=a.onCopyInit||null,f=a.onCopySuccess||null;function h(e){if(a.headerColumnValueExtractor){var t=a.headerColumnValueExtractor(e);if(t)return t}return e.name}function g(e,n,r){if(a.dataItemColumnValueExtractor){var i=a.dataItemColumnValueExtractor(e,n);if(i)return i}var l="";if(n.editor){var s={container:o("<p>"),column:n,position:{top:0,left:0},grid:t,event:r},c=new n.editor(s);c.loadValue(e),l=c.serializeValue(),c.destroy()}else l=e[n.field];return l}function m(e,n,r){if(a.dataItemColumnValueSetter)return a.dataItemColumnValueSetter(e,n,r);if(n.editor){var i={container:o("body"),column:n,position:{top:0,left:0},grid:t},l=new n.editor(i);l.loadValue(e),l.applyValue(e,r),l.destroy()}else e[n.field]=r}function v(e){var t=document.createElement("textarea");return t.style.position="absolute",t.style.left="-1000px",t.style.top=document.body.scrollTop+"px",t.value=e,d.appendChild(t),t.select(),t}function w(e,o){var r;if(!t.getEditorLock().isActive()||t.getOptions().autoEdit){if(e.which==i.ESC&&n&&(e.preventDefault(),y(),l.onCopyCancelled.notify({ranges:n}),n=null),(e.which===i.C||e.which===i.INSERT)&&(e.ctrlKey||e.metaKey)&&!e.shiftKey&&(p&&p.call(),0!=(r=t.getSelectionModel().getSelectedRanges()).length)){n=r,C(r),l.onCopyCells.notify({ranges:r});for(var s=t.getColumns(),c="",u=0;u<r.length;u++){for(var w=r[u],b=[],x=w.fromRow;x<w.toRow+1;x++){var R=[],S=t.getDataItem(x);if(""==b&&a.includeHeaderWhenCopying){for(var E=[],k=w.fromCell;k<w.toCell+1;k++)s[k].name.length>0&&E.push(h(s[k]));b.push(E.join("\t"))}for(k=w.fromCell;k<w.toCell+1;k++)R.push(g(S,s[k],e));b.push(R.join("\t"))}c+=b.join("\r\n")+"\r\n"}if(window.clipboardData)return window.clipboardData.setData("Text",c),!0;var T=document.activeElement;if((D=v(c)).focus(),setTimeout(function(){d.removeChild(D),T?T.focus():console.log("Not element to restore focus to after copy?")},100),f){var P=0;P=1===r.length?r[0].toRow+1-r[0].fromRow:r.length,f.call(this,P)}return!1}if(!a.readOnlyMode&&(e.which===i.V&&(e.ctrlKey||e.metaKey)&&!e.shiftKey||e.which===i.INSERT&&e.shiftKey&&!e.ctrlKey)){var D=v("");return setTimeout(function(){!function(e,t){var n=e.getColumns(),o=t.value.split(/[\n\f\r]/);""==o[o.length-1]&&o.pop();var r=[],i=0;d.removeChild(t);for(var s=0;s<o.length;s++)""!=o[s]?r[i++]=o[s].split("\t"):r[s]=[""];var c=e.getActiveCell(),u=e.getSelectionModel().getSelectedRanges(),p=u&&u.length?u[0]:null,f=null,h=null;if(p)f=p.fromRow,h=p.fromCell;else{if(!c)return;f=c.row,h=c.cell}var g=!1,v=r.length,w=r.length?r[0].length:0;1==r.length&&1==r[0].length&&p&&(g=!0,v=p.toRow-p.fromRow+1,w=p.toCell-p.fromCell+1);var y=e.getData().length-f,b=0;if(y<v&&a.newRowCreator){var x=e.getData();for(b=1;b<=v-y;b++)x.push({});e.setData(x),e.render()}var R=f+v>e.getDataLength();if(a.newRowCreator&&R){var S=f+v-e.getDataLength();a.newRowCreator(S)}var E={isClipboardCommand:!0,clippedRange:r,oldValues:[],cellExternalCopyManager:l,_options:a,setDataItemValueForColumn:m,markCopySelection:C,oneCellToMultiple:g,activeRow:f,activeCell:h,destH:v,destW:w,maxDestY:e.getDataLength(),maxDestX:e.getColumns().length,h:0,w:0,execute:function(){this.h=0;for(var t=0;t<this.destH;t++){this.oldValues[t]=[],this.w=0,this.h++;for(var o=0;o<this.destW;o++){this.w++;var i=f+t,l=h+o;if(i<this.maxDestY&&l<this.maxDestX){e.getCellNode(i,l);var a=e.getDataItem(i);this.oldValues[t][o]=a[n[l].field],g?this.setDataItemValueForColumn(a,n[l],r[0][0]):this.setDataItemValueForColumn(a,n[l],r[t]?r[t][o]:""),e.updateCell(i,l),e.onCellChange.notify({row:i,cell:l,item:a,grid:e})}}}var s={fromCell:h,fromRow:f,toCell:h+this.w-1,toRow:f+this.h-1};this.markCopySelection([s]),e.getSelectionModel().setSelectedRanges([s]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[s]})},undo:function(){for(var t=0;t<this.destH;t++)for(var o=0;o<this.destW;o++){var r=f+t,i=h+o;if(r<this.maxDestY&&i<this.maxDestX){e.getCellNode(r,i);var l=e.getDataItem(r);g?this.setDataItemValueForColumn(l,n[i],this.oldValues[0][0]):this.setDataItemValueForColumn(l,n[i],this.oldValues[t][o]),e.updateCell(r,i),e.onCellChange.notify({row:r,cell:i,item:l,grid:e})}}var a={fromCell:h,fromRow:f,toCell:h+this.w-1,toRow:f+this.h-1};if(this.markCopySelection([a]),e.getSelectionModel().setSelectedRanges([a]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[a]}),b>1){for(var s=e.getData();b>1;b--)s.splice(s.length-1,1);e.setData(s),e.render()}}};a.clipboardCommandHandler?a.clipboardCommandHandler(E):E.execute()}(t,D)},100),!1}}}function C(e){y();for(var n=t.getColumns(),o={},r=0;r<e.length;r++)for(var i=e[r].fromRow;i<=e[r].toRow;i++){o[i]={};for(var a=e[r].fromCell;a<=e[r].toCell&&a<n.length;a++)o[i][n[a].id]=c}t.setCellCssStyles(s,o),clearTimeout(u),u=setTimeout(function(){l.clearCopySelection()},2e3)}function y(){t.removeCellCssStyles(s)}o.extend(this,{init:function(e){(t=e).onKeyDown.subscribe(w);var n=e.getSelectionModel();if(!n)throw new Error("Selection model is mandatory for this plugin. Please set a selection model on the grid before adding this plugin: grid.setSelectionModel(new Slick.CellSelectionModel())");n.onSelectedRangesChanged.subscribe(function(e,n){t.focus()})},destroy:function(){t.onKeyDown.unsubscribe(w)},clearCopySelection:y,handleKeyDown:w,onCopyCells:new r.Event,onCopyCancelled:new r.Event,onPasteCells:new r.Event,setIncludeHeaderWhenCopying:function(e){a.includeHeaderWhenCopying=e}})}}},458:function(e,t,n){var o=e(462),r=e(460);t.exports={CheckboxSelectColumn:function(e){var t,n=v(),i=new r.EventHandler,l={},a=!1,s=o.extend(!0,{},{columnId:"_checkbox_selector",cssClass:null,hideSelectAllCheckbox:!1,toolTip:"Select/Deselect All",width:30,hideInColumnTitleRow:!1,hideInFilterHeaderRow:!0},e);function c(){t.updateColumnHeader(s.columnId,"","")}function u(){o("#filter-checkbox-selectall-container").hide()}function d(e,r){var i,c,u=t.getSelectedRows(),d={};for(c=0;c<u.length;c++)d[i=u[c]]=!0,d[i]!==l[i]&&(t.invalidateRow(i),delete l[i]);for(c in l)t.invalidateRow(c);l=d,t.render(),a=u.length&&u.length==t.getDataLength(),s.hideInColumnTitleRow||s.hideSelectAllCheckbox||(a?t.updateColumnHeader(s.columnId,"<input id='header-selector"+n+"' type='checkbox' checked='checked'><label for='header-selector"+n+"'></label>",s.toolTip):t.updateColumnHeader(s.columnId,"<input id='header-selector"+n+"' type='checkbox'><label for='header-selector"+n+"'></label>",s.toolTip)),s.hideInFilterHeaderRow||o("#header-filter-selector"+n).prop("checked",a)}function p(e,n){32==e.which&&t.getColumns()[n.cell].id===s.columnId&&(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit()||h(n.row),e.preventDefault(),e.stopImmediatePropagation())}function f(e,n){if(t.getColumns()[n.cell].id===s.columnId&&o(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();h(n.row),e.stopPropagation(),e.stopImmediatePropagation()}}function h(e){l[e]?t.setSelectedRows(o.grep(t.getSelectedRows(),function(t){return t!=e})):t.setSelectedRows(t.getSelectedRows().concat(e)),t.setActiveCell(e,function(){if(null===m){m=0;for(var e=t.getColumns(),n=0;n<e.length;n++)e[n].id==s.columnId&&(m=n)}return m}()),t.focus()}function g(e,n){if(n.column.id==s.columnId&&o(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();if(o(e.target).is(":checked")){for(var r=[],i=0;i<t.getDataLength();i++)r.push(i);t.setSelectedRows(r)}else t.setSelectedRows([]);e.stopPropagation(),e.stopImmediatePropagation()}}var m=null;function v(){return Math.round(1e7*Math.random())}function w(e,t,n,o,r){var i=v()+e;return r?l[e]?"<input id='selector"+i+"' type='checkbox' checked='checked'><label for='selector"+i+"'></label>":"<input id='selector"+i+"' type='checkbox'><label for='selector"+i+"'></label>":null}o.extend(this,{init:function(e){t=e,i.subscribe(t.onSelectedRowsChanged,d).subscribe(t.onClick,f).subscribe(t.onKeyDown,p),s.hideInFilterHeaderRow||function(e){e.onHeaderRowCellRendered.subscribe(function(e,t){"sel"===t.column.field&&(o(t.node).empty(),o("<span id='filter-checkbox-selectall-container'><input id='header-filter-selector"+n+"' type='checkbox'><label for='header-filter-selector"+n+"'></label></span>").appendTo(t.node).on("click",function(e){g(e,t)}))})}(e),s.hideInColumnTitleRow||i.subscribe(t.onHeaderClick,g)},destroy:function(){i.unsubscribeAll()},deSelectRows:function(e){var n,r=e.length,i=[];for(n=0;n<r;n++)l[e[n]]&&(i[i.length]=e[n]);t.setSelectedRows(o.grep(t.getSelectedRows(),function(e){return i.indexOf(e)<0}))},selectRows:function(e){var n,o=e.length,r=[];for(n=0;n<o;n++)l[e[n]]||(r[r.length]=e[n]);t.setSelectedRows(t.getSelectedRows().concat(r))},getColumnDefinition:function(){return{id:s.columnId,name:s.hideSelectAllCheckbox||s.hideInColumnTitleRow?"":"<input id='header-selector"+n+"' type='checkbox'><label for='header-selector"+n+"'></label>",toolTip:s.toolTip,field:"sel",width:s.width,resizable:!1,sortable:!1,cssClass:s.cssClass,hideSelectAllCheckbox:s.hideSelectAllCheckbox,formatter:w}},getOptions:function(){return s},setOptions:function(e){if((s=o.extend(!0,{},s,e)).hideSelectAllCheckbox)c(),u();else if(s.hideInColumnTitleRow?c():(a?t.updateColumnHeader(s.columnId,"<input id='header-selector"+n+"' type='checkbox' checked='checked'><label for='header-selector"+n+"'></label>",s.toolTip):t.updateColumnHeader(s.columnId,"<input id='header-selector"+n+"' type='checkbox'><label for='header-selector"+n+"'></label>",s.toolTip),i.subscribe(t.onHeaderClick,g)),s.hideInFilterHeaderRow)u();else{var r=o("#filter-checkbox-selectall-container");r.show(),r.find('input[type="checkbox"]').prop("checked",a)}}})}}},459:function(e,t,n){var o=e(462),r=e(460);t.exports={RowSelectionModel:function(e){var t,n,i,l=[],a=this,s=new r.EventHandler,c={selectActiveRow:!0};function u(e){return function(){n||(n=!0,e.apply(this,arguments),n=!1)}}function d(e){for(var t=[],n=0;n<e.length;n++)for(var o=e[n].fromRow;o<=e[n].toRow;o++)t.push(o);return t}function p(e){for(var n=[],o=t.getColumns().length-1,i=0;i<e.length;i++)n.push(new r.Range(e[i],0,e[i],o));return n}function f(){return d(l)}function h(e){(l&&0!==l.length||e&&0!==e.length)&&(l=e,a.onSelectedRangesChanged.notify(l))}function g(e,n){i.selectActiveRow&&null!=n.row&&h([new r.Range(n.row,0,n.row,t.getColumns().length-1)])}function m(e){var n=t.getActiveCell();if(t.getOptions().multiSelect&&n&&e.shiftKey&&!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.which==r.keyCode.UP||e.which==r.keyCode.DOWN)){var o=f();o.sort(function(e,t){return e-t}),o.length||(o=[n.row]);var i,l=o[0],a=o[o.length-1];(i=e.which==r.keyCode.DOWN?n.row<a||l==a?++a:++l:n.row<a?--a:--l)>=0&&i<t.getDataLength()&&(t.scrollRowIntoView(i),h(p(function(e,t){var n,o=[];for(n=e;n<=t;n++)o.push(n);for(n=t;n<e;n++)o.push(n);return o}(l,a)))),e.preventDefault(),e.stopPropagation()}}function v(e){var n=t.getCellFromEvent(e);if(!n||!t.canCellBeActive(n.row,n.cell))return!1;if(!t.getOptions().multiSelect||!e.ctrlKey&&!e.shiftKey&&!e.metaKey)return!1;var r=d(l),i=o.inArray(n.row,r);if(-1===i&&(e.ctrlKey||e.metaKey))r.push(n.row),t.setActiveCell(n.row,n.cell);else if(-1!==i&&(e.ctrlKey||e.metaKey))r=o.grep(r,function(e,t){return e!==n.row}),t.setActiveCell(n.row,n.cell);else if(r.length&&e.shiftKey){var a=r.pop(),s=Math.min(n.row,a),c=Math.max(n.row,a);r=[];for(var u=s;u<=c;u++)u!==a&&r.push(u);r.push(a),t.setActiveCell(n.row,n.cell)}return h(p(r)),e.stopImmediatePropagation(),!0}o.extend(this,{getSelectedRows:f,setSelectedRows:function(e){h(p(e))},getSelectedRanges:function(){return l},setSelectedRanges:h,init:function(n){i=o.extend(!0,{},c,e),t=n,s.subscribe(t.onActiveCellChanged,u(g)),s.subscribe(t.onKeyDown,u(m)),s.subscribe(t.onClick,u(v))},destroy:function(){s.unsubscribeAll()},onSelectedRangesChanged:new r.Event})}}},460:function(e,t,n){function o(){var e=!1,t=!1;this.stopPropagation=function(){e=!0},this.isPropagationStopped=function(){return e},this.stopImmediatePropagation=function(){t=!0},this.isImmediatePropagationStopped=function(){return t}}function r(){this.__nonDataRow=!0}function i(){this.__group=!0,this.level=0,this.count=0,this.value=null,this.title=null,this.collapsed=!1,this.selectChecked=!1,this.totals=null,this.rows=[],this.groups=null,this.groupingKey=null}function l(){this.__groupTotals=!0,this.group=null,this.initialized=!1}function a(){var e=null;this.isActive=function(t){return t?e===t:null!==e},this.activate=function(t){if(t!==e){if(null!==e)throw new Error("SlickGrid.EditorLock.activate: an editController is still active, can't activate another editController");if(!t.commitCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .commitCurrentEdit()");if(!t.cancelCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .cancelCurrentEdit()");e=t}},this.deactivate=function(t){if(e!==t)throw new Error("SlickGrid.EditorLock.deactivate: specified editController is not the currently active one");e=null},this.commitCurrentEdit=function(){return!e||e.commitCurrentEdit()},this.cancelCurrentEdit=function(){return!e||e.cancelCurrentEdit()}}i.prototype=new r,i.prototype.equals=function(e){return this.value===e.value&&this.count===e.count&&this.collapsed===e.collapsed&&this.title===e.title},l.prototype=new r,t.exports={Event:function(){var e=[];this.subscribe=function(t){e.push(t)},this.unsubscribe=function(t){for(var n=e.length-1;n>=0;n--)e[n]===t&&e.splice(n,1)},this.notify=function(t,n,r){var i;n=n||new o,r=r||this;for(var l=0;l<e.length&&!n.isPropagationStopped()&&!n.isImmediatePropagationStopped();l++)i=e[l].call(r,n,t);return i}},EventData:o,EventHandler:function(){var e=[];this.subscribe=function(t,n){return e.push({event:t,handler:n}),t.subscribe(n),this},this.unsubscribe=function(t,n){for(var o=e.length;o--;)if(e[o].event===t&&e[o].handler===n)return e.splice(o,1),void t.unsubscribe(n);return this},this.unsubscribeAll=function(){for(var t=e.length;t--;)e[t].event.unsubscribe(e[t].handler);return e=[],this}},Range:function(e,t,n,o){void 0===n&&void 0===o&&(n=e,o=t),this.fromRow=Math.min(e,n),this.fromCell=Math.min(t,o),this.toRow=Math.max(e,n),this.toCell=Math.max(t,o),this.isSingleRow=function(){return this.fromRow==this.toRow},this.isSingleCell=function(){return this.fromRow==this.toRow&&this.fromCell==this.toCell},this.contains=function(e,t){return e>=this.fromRow&&e<=this.toRow&&t>=this.fromCell&&t<=this.toCell},this.toString=function(){return this.isSingleCell()?"("+this.fromRow+":"+this.fromCell+")":"("+this.fromRow+":"+this.fromCell+" - "+this.toRow+":"+this.toCell+")"}},NonDataRow:r,Group:i,GroupTotals:l,EditorLock:a,GlobalEditorLock:new a,keyCode:{BACKSPACE:8,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,ESC:27,HOME:36,INSERT:45,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,RIGHT:39,TAB:9,UP:38,C:67,V:86},preClickClassName:"slick-edit-preclick"}},461:function _(require,module,exports){
/**
     * @license
     * (c) 2009-2016 Michael Leibman
     * michael{dot}leibman{at}gmail{dot}com
     * http://github.com/mleibman/slickgrid
     *
     * Distributed under MIT license.
     * All rights reserved.
     *
     * SlickGrid v2.3
     *
     * NOTES:
     *     Cell/row DOM manipulations are done directly bypassing jQuery's DOM manipulation methods.
     *     This increases the speed dramatically, but can only be done safely because there are no event handlers
     *     or data associated with any cell/row DOM nodes.  Cell editors must make sure they implement .destroy()
     *     and do proper cleanup.
     */
var $=require(462),Slick=require(460),scrollbarDimensions,maxSupportedCssHeight;function SlickGrid(container,data,columns,options){$.fn.drag||require(455),$.fn.drop||require(456);var defaults={alwaysShowVerticalScroll:!1,explicitInitialization:!1,rowHeight:25,defaultColumnWidth:80,enableAddRow:!1,leaveSpaceForNewRows:!1,editable:!1,autoEdit:!0,suppressActiveCellChangeOnEdit:!1,enableCellNavigation:!0,enableColumnReorder:!0,asyncEditorLoading:!1,asyncEditorLoadDelay:100,forceFitColumns:!1,enableAsyncPostRender:!1,asyncPostRenderDelay:50,enableAsyncPostRenderCleanup:!1,asyncPostRenderCleanupDelay:40,autoHeight:!1,editorLock:Slick.GlobalEditorLock,showHeaderRow:!1,headerRowHeight:25,createFooterRow:!1,showFooterRow:!1,footerRowHeight:25,createPreHeaderPanel:!1,showPreHeaderPanel:!1,preHeaderPanelHeight:25,showTopPanel:!1,topPanelHeight:25,formatterFactory:null,editorFactory:null,cellFlashingCssClass:"flashing",selectedCellCssClass:"selected",multiSelect:!0,enableTextSelectionOnCells:!1,dataItemColumnValueExtractor:null,fullWidthRows:!1,multiColumnSort:!1,numberedMultiColumnSort:!1,tristateMultiColumnSort:!1,sortColNumberInSeparateSpan:!1,defaultFormatter:defaultFormatter,forceSyncScrolling:!1,addNewRowCssClass:"new-row",preserveCopiedSelectionOnPaste:!1,showCellSelection:!0,viewportClass:null,minRowBuffer:3,emulatePagingWhenScrolling:!0,editorCellNavOnLRKeys:!1},columnDefaults={name:"",resizable:!0,sortable:!1,minWidth:30,rerenderOnResize:!1,headerCssClass:null,defaultSortAsc:!0,focusable:!0,selectable:!0},th,h,ph,n,cj,page=0,offset=0,vScrollDir=1,initialized=!1,$container,uid="slickgrid_"+Math.round(1e6*Math.random()),self=this,$focusSink,$focusSink2,$headerScroller,$headers,$headerRow,$headerRowScroller,$headerRowSpacer,$footerRow,$footerRowScroller,$footerRowSpacer,$preHeaderPanel,$preHeaderPanelScroller,$preHeaderPanelSpacer,$topPanelScroller,$topPanel,$viewport,$canvas,$style,$boundAncestors,stylesheet,columnCssRulesL,columnCssRulesR,viewportH,viewportW,canvasWidth,viewportHasHScroll,viewportHasVScroll,headerColumnWidthDiff=0,headerColumnHeightDiff=0,cellWidthDiff=0,cellHeightDiff=0,jQueryNewWidthBehaviour=!1,absoluteColumnMinWidth,tabbingDirection=1,activePosX,activeRow,activeCell,activeCellNode=null,currentEditor=null,serializedEditorValue,editController,rowsCache={},renderedRows=0,numVisibleRows,prevScrollTop=0,scrollTop=0,lastRenderedScrollTop=0,lastRenderedScrollLeft=0,prevScrollLeft=0,scrollLeft=0,selectionModel,selectedRows=[],plugins=[],cellCssClasses={},columnsById={},sortColumns=[],columnPosLeft=[],columnPosRight=[],pagingActive=!1,pagingIsLastPage=!1,scrollThrottle=ActionThrottle(render,50),h_editorLoader=null,h_render=null,h_postrender=null,h_postrenderCleanup=null,postProcessedRows={},postProcessToRow=null,postProcessFromRow=null,postProcessedCleanupQueue=[],postProcessgroupId=0,counter_rows_rendered=0,counter_rows_removed=0,rowNodeFromLastMouseWheelEvent,zombieRowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent,cssShow={position:"absolute",visibility:"hidden",display:"block"},$hiddenParents,oldProps=[],columnResizeDragging=!1;function init(){if(($container=container instanceof $?container:$(container)).length<1)throw new Error("SlickGrid requires a valid container, "+container+" does not exist in the DOM.");cacheCssForHiddenInit(),maxSupportedCssHeight=maxSupportedCssHeight||getMaxSupportedCssHeight(),options=$.extend({},defaults,options),validateAndEnforceOptions(),columnDefaults.width=options.defaultColumnWidth,columnsById={};for(var e=0;e<columns.length;e++){var t=columns[e]=$.extend({},columnDefaults,columns[e]);columnsById[t.id]=e,t.minWidth&&t.width<t.minWidth&&(t.width=t.minWidth),t.maxWidth&&t.width>t.maxWidth&&(t.width=t.maxWidth)}if(options.enableColumnReorder&&!$.fn.sortable)throw new Error("SlickGrid's 'enableColumnReorder = true' option requires jquery-ui.sortable module to be loaded");editController={commitCurrentEdit:commitCurrentEdit,cancelCurrentEdit:cancelCurrentEdit},$container.empty().css("overflow","hidden").css("outline",0).addClass(uid).addClass("ui-widget"),/relative|absolute|fixed/.test($container.css("position"))||$container.css("position","relative"),$focusSink=$("<div tabIndex='0' hideFocus style='position:fixed;width:0;height:0;top:0;left:0;outline:0;'></div>").appendTo($container),options.createPreHeaderPanel&&($preHeaderPanelScroller=$("<div class='slick-preheader-panel ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),$preHeaderPanel=$("<div />").appendTo($preHeaderPanelScroller),$preHeaderPanelSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($preHeaderPanelScroller),options.showPreHeaderPanel||$preHeaderPanelScroller.hide()),$headerScroller=$("<div class='slick-header ui-state-default' />").appendTo($container),$headers=$("<div class='slick-header-columns' style='left:-1000px' />").appendTo($headerScroller),$headerRowScroller=$("<div class='slick-headerrow ui-state-default' />").appendTo($container),$headerRow=$("<div class='slick-headerrow-columns' />").appendTo($headerRowScroller),$headerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($headerRowScroller),$topPanelScroller=$("<div class='slick-top-panel-scroller ui-state-default' />").appendTo($container),$topPanel=$("<div class='slick-top-panel' style='width:10000px' />").appendTo($topPanelScroller),options.showTopPanel||$topPanelScroller.hide(),options.showHeaderRow||$headerRowScroller.hide(),($viewport=$("<div class='slick-viewport' style='width:100%;overflow:auto;outline:0;position:relative;;'>").appendTo($container)).css("overflow-y",options.alwaysShowVerticalScroll?"scroll":options.autoHeight?"hidden":"auto"),$viewport.css("overflow-x",options.forceFitColumns?"hidden":"auto"),options.viewportClass&&$viewport.toggleClass(options.viewportClass,!0),$canvas=$("<div class='grid-canvas' />").appendTo($viewport),scrollbarDimensions=scrollbarDimensions||measureScrollbar(),$preHeaderPanelSpacer&&$preHeaderPanelSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),$headers.width(getHeadersWidth()),$headerRowSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),options.createFooterRow&&($footerRowScroller=$("<div class='slick-footerrow ui-state-default' />").appendTo($container),$footerRow=$("<div class='slick-footerrow-columns' />").appendTo($footerRowScroller),$footerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($footerRowScroller),options.showFooterRow||$footerRowScroller.hide()),$focusSink2=$focusSink.clone().appendTo($container),options.explicitInitialization||finishInitialization()}function finishInitialization(){initialized||(initialized=!0,viewportW=parseFloat($.css($container[0],"width",!0)),measureCellPaddingAndBorder(),disableSelection($headers),options.enableTextSelectionOnCells||$viewport.on("selectstart.ui",function(e){return $(e.target).is("input,textarea")}),updateColumnCaches(),createColumnHeaders(),setupColumnSort(),createCssRules(),resizeCanvas(),bindAncestorScrollEvents(),$container.on("resize.slickgrid",resizeCanvas),$viewport.on("scroll",handleScroll),$headerScroller.on("contextmenu",handleHeaderContextMenu).on("click",handleHeaderClick).on("mouseenter",".slick-header-column",handleHeaderMouseEnter).on("mouseleave",".slick-header-column",handleHeaderMouseLeave),$headerRowScroller.on("scroll",handleHeaderRowScroll),options.createFooterRow&&$footerRowScroller.on("scroll",handleFooterRowScroll),options.createPreHeaderPanel&&$preHeaderPanelScroller.on("scroll",handlePreHeaderPanelScroll),$focusSink.add($focusSink2).on("keydown",handleKeyDown),$canvas.on("keydown",handleKeyDown).on("click",handleClick).on("dblclick",handleDblClick).on("contextmenu",handleContextMenu).on("draginit",handleDragInit).on("dragstart",{distance:3},handleDragStart).on("drag",handleDrag).on("dragend",handleDragEnd).on("mouseenter",".slick-cell",handleMouseEnter).on("mouseleave",".slick-cell",handleMouseLeave),navigator.userAgent.toLowerCase().match(/webkit/)&&navigator.userAgent.toLowerCase().match(/macintosh/)&&$canvas.on("mousewheel",handleMouseWheel),restoreCssFromHiddenInit())}function cacheCssForHiddenInit(){($hiddenParents=$container.parents().addBack().not(":visible")).each(function(){var e={};for(var t in cssShow)e[t]=this.style[t],this.style[t]=cssShow[t];oldProps.push(e)})}function restoreCssFromHiddenInit(){$hiddenParents.each(function(e){var t=oldProps[e];for(var n in cssShow)this.style[n]=t[n]})}function registerPlugin(e){plugins.unshift(e),e.init(self)}function unregisterPlugin(e){for(var t=plugins.length;t>=0;t--)if(plugins[t]===e){plugins[t].destroy&&plugins[t].destroy(),plugins.splice(t,1);break}}function setSelectionModel(e){selectionModel&&(selectionModel.onSelectedRangesChanged.unsubscribe(handleSelectedRangesChanged),selectionModel.destroy&&selectionModel.destroy()),(selectionModel=e)&&(selectionModel.init(self),selectionModel.onSelectedRangesChanged.subscribe(handleSelectedRangesChanged))}function getSelectionModel(){return selectionModel}function getCanvasNode(){return $canvas[0]}function measureScrollbar(){var e=$('<div class="'+$viewport.className+'" style="position:absolute; top:-10000px; left:-10000px; overflow:auto; width:100px; height:100px;"></div>').appendTo($viewport),t=$('<div style="width:200px; height:200px; overflow:auto;"></div>').appendTo(e),n={width:e[0].offsetWidth-e[0].clientWidth,height:e[0].offsetHeight-e[0].clientHeight};return t.remove(),e.remove(),n}function getColumnTotalWidth(e){for(var t=0,n=0,o=columns.length;n<o;n++){t+=columns[n].width}return e&&(t+=scrollbarDimensions.width),t}function getHeadersWidth(){var e=getColumnTotalWidth(!options.autoHeight);return Math.max(e,viewportW)+1e3}function getCanvasWidth(){for(var e=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW,t=0,n=columns.length;n--;)t+=columns[n].width;return options.fullWidthRows?Math.max(t,e):t}function updateCanvasWidth(e){var t=canvasWidth;(canvasWidth=getCanvasWidth())!=t&&($canvas.width(canvasWidth),$headerRow.width(canvasWidth),options.createFooterRow&&$footerRow.width(canvasWidth),options.createPreHeaderPanel&&$preHeaderPanel.width(canvasWidth),$headers.width(getHeadersWidth()),viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width);var n=canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0);$headerRowSpacer.width(n),options.createFooterRow&&$footerRowSpacer.width(n),options.createPreHeaderPanel&&$preHeaderPanelSpacer.width(n),(canvasWidth!=t||e)&&applyColumnWidths()}function disableSelection(e){e&&e.jquery&&e.attr("unselectable","on").css("MozUserSelect","none").on("selectstart.ui",function(){return!1})}function getMaxSupportedCssHeight(){for(var e=1e6,t=navigator.userAgent.toLowerCase().match(/firefox/)?6e6:1e9,n=$("<div style='display:none' />").appendTo(document.body);;){var o=2*e;if(n.css("height",o),o>t||n.height()!==o)break;e=o}return n.remove(),e}function getUID(){return uid}function getHeaderColumnWidthDiff(){return headerColumnWidthDiff}function getScrollbarDimensions(){return scrollbarDimensions}function bindAncestorScrollEvents(){for(var e=$canvas[0];(e=e.parentNode)!=document.body&&null!=e;)if(e==$viewport[0]||e.scrollWidth!=e.clientWidth||e.scrollHeight!=e.clientHeight){var t=$(e);$boundAncestors=$boundAncestors?$boundAncestors.add(t):t,t.on("scroll."+uid,handleActiveCellPositionChange)}}function unbindAncestorScrollEvents(){$boundAncestors&&($boundAncestors.off("scroll."+uid),$boundAncestors=null)}function updateColumnHeader(e,t,n){if(initialized){var o=getColumnIndex(e);if(null!=o){var r=columns[o],i=$headers.children().eq(o);i&&(void 0!==t&&(columns[o].name=t),void 0!==n&&(columns[o].toolTip=n),trigger(self.onBeforeHeaderCellDestroy,{node:i[0],column:r,grid:self}),i.attr("title",n||"").children().eq(0).html(t),trigger(self.onHeaderCellRendered,{node:i[0],column:r,grid:self}))}}}function getHeader(){return $headers[0]}function getHeaderColumn(e){var t="number"==typeof e?e:getColumnIndex(e),n=$headers.children().eq(t);return n&&n[0]}function getHeaderRow(){return $headerRow[0]}function getFooterRow(){return $footerRow[0]}function getPreHeaderPanel(){return $preHeaderPanel[0]}function getHeaderRowColumn(e){var t="number"==typeof e?e:getColumnIndex(e),n=$headerRow.children().eq(t);return n&&n[0]}function getFooterRowColumn(e){var t="number"==typeof e?e:getColumnIndex(e),n=$footerRow.children().eq(t);return n&&n[0]}function createColumnHeaders(){function e(){$(this).addClass("ui-state-hover")}function t(){$(this).removeClass("ui-state-hover")}$headers.find(".slick-header-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderCellDestroy,{node:this,column:e,grid:self})}),$headers.empty(),$headers.width(getHeadersWidth()),$headerRow.find(".slick-headerrow-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderRowCellDestroy,{node:this,column:e,grid:self})}),$headerRow.empty(),options.createFooterRow&&($footerRow.find(".slick-footerrow-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeFooterRowCellDestroy,{node:this,column:e})}),$footerRow.empty());for(var n=0;n<columns.length;n++){var o=columns[n],r=$("<div class='ui-state-default slick-header-column' />").html("<span class='slick-column-name'>"+o.name+"</span>").width(o.width-headerColumnWidthDiff).attr("id",""+uid+o.id).attr("title",o.toolTip||"").data("column",o).addClass(o.headerCssClass||"").appendTo($headers);if((options.enableColumnReorder||o.sortable)&&r.on("mouseenter",e).on("mouseleave",t),o.sortable&&(r.addClass("slick-header-sortable"),r.append("<span class='slick-sort-indicator"+(options.numberedMultiColumnSort&&!options.sortColNumberInSeparateSpan?" slick-sort-indicator-numbered":"")+"' />"),options.numberedMultiColumnSort&&options.sortColNumberInSeparateSpan&&r.append("<span class='slick-sort-indicator-numbered' />")),trigger(self.onHeaderCellRendered,{node:r[0],column:o,grid:self}),options.showHeaderRow){var i=$("<div class='ui-state-default slick-headerrow-column l"+n+" r"+n+"'></div>").data("column",o).appendTo($headerRow);trigger(self.onHeaderRowCellRendered,{node:i[0],column:o,grid:self})}if(options.createFooterRow&&options.showFooterRow){var l=$("<div class='ui-state-default slick-footerrow-column l"+n+" r"+n+"'></div>").data("column",o).appendTo($footerRow);trigger(self.onFooterRowCellRendered,{node:l[0],column:o})}}setSortColumns(sortColumns),setupColumnResize(),options.enableColumnReorder&&("function"==typeof options.enableColumnReorder?options.enableColumnReorder(self,$headers,headerColumnWidthDiff,setColumns,setupColumnResize,columns,getColumnIndex,uid,trigger):setupColumnReorder())}function setupColumnSort(){$headers.click(function(e){if(!columnResizeDragging&&(e.metaKey=e.metaKey||e.ctrlKey,!$(e.target).hasClass("slick-resizable-handle"))){var t=$(e.target).closest(".slick-header-column");if(t.length){var n=t.data("column");if(n.sortable){if(!getEditorLock().commitCurrentEdit())return;for(var o=null,r=0;r<sortColumns.length;r++)if(sortColumns[r].columnId==n.id){(o=sortColumns[r]).sortAsc=!o.sortAsc;break}var i=!!o;options.tristateMultiColumnSort?(o||(o={columnId:n.id,sortAsc:n.defaultSortAsc}),i&&o.sortAsc&&(sortColumns.splice(r,1),o=null),options.multiColumnSort||(sortColumns=[]),!o||i&&options.multiColumnSort||sortColumns.push(o)):e.metaKey&&options.multiColumnSort?o&&sortColumns.splice(r,1):((e.shiftKey||e.metaKey)&&options.multiColumnSort||(sortColumns=[]),o?0==sortColumns.length&&sortColumns.push(o):(o={columnId:n.id,sortAsc:n.defaultSortAsc},sortColumns.push(o))),setSortColumns(sortColumns),options.multiColumnSort?trigger(self.onSort,{multiColumnSort:!0,sortCols:$.map(sortColumns,function(e){return{sortCol:columns[getColumnIndex(e.columnId)],sortAsc:e.sortAsc}})},e):trigger(self.onSort,{multiColumnSort:!1,sortCol:sortColumns.length>0?n:null,sortAsc:!(sortColumns.length>0)||sortColumns[0].sortAsc},e)}}}})}function setupColumnReorder(){$headers.filter(":ui-sortable").sortable("destroy"),$headers.sortable({containment:"parent",distance:3,axis:"x",cursor:"default",tolerance:"intersection",helper:"clone",placeholder:"slick-sortable-placeholder ui-state-default slick-header-column",start:function(e,t){t.placeholder.width(t.helper.outerWidth()-headerColumnWidthDiff),$(t.helper).addClass("slick-header-column-active")},beforeStop:function(e,t){$(t.helper).removeClass("slick-header-column-active")},stop:function(e){if(getEditorLock().commitCurrentEdit()){for(var t=$headers.sortable("toArray"),n=[],o=0;o<t.length;o++)n.push(columns[getColumnIndex(t[o].replace(uid,""))]);setColumns(n),trigger(self.onColumnsReordered,{}),e.stopPropagation(),setupColumnResize()}else $(this).sortable("cancel")}})}function setupColumnResize(){var e,t,n,o,r,i,l,a;(o=$headers.children()).find(".slick-resizable-handle").remove(),o.each(function(e,t){e>=columns.length||columns[e].resizable&&(void 0===l&&(l=e),a=e)}),void 0!==l&&o.each(function(s,c){s>=columns.length||s<l||options.forceFitColumns&&s>=a||($(c),$("<div class='slick-resizable-handle' />").appendTo(c).on("dragstart",function(l,a){if(!getEditorLock().commitCurrentEdit())return!1;n=l.pageX,$(this).parent().addClass("slick-header-column-active");var c=null,u=null;if(o.each(function(e,t){e>=columns.length||(columns[e].previousWidth=$(t).outerWidth())}),options.forceFitColumns)for(c=0,u=0,e=s+1;e<columns.length;e++)(t=columns[e]).resizable&&(null!==u&&(t.maxWidth?u+=t.maxWidth-t.previousWidth:u=null),c+=t.previousWidth-Math.max(t.minWidth||0,absoluteColumnMinWidth));var d=0,p=0;for(e=0;e<=s;e++)(t=columns[e]).resizable&&(null!==p&&(t.maxWidth?p+=t.maxWidth-t.previousWidth:p=null),d+=t.previousWidth-Math.max(t.minWidth||0,absoluteColumnMinWidth));null===c&&(c=1e5),null===d&&(d=1e5),null===u&&(u=1e5),null===p&&(p=1e5),i=n+Math.min(c,p),r=n-Math.min(d,u)}).on("drag",function(o,l){columnResizeDragging=!0;var a,c,u=Math.min(i,Math.max(r,o.pageX))-n;if(u<0){for(c=u,e=s;e>=0;e--)(t=columns[e]).resizable&&(a=Math.max(t.minWidth||0,absoluteColumnMinWidth),c&&t.previousWidth+c<a?(c+=t.previousWidth-a,t.width=a):(t.width=t.previousWidth+c,c=0));if(options.forceFitColumns)for(c=-u,e=s+1;e<columns.length;e++)(t=columns[e]).resizable&&(c&&t.maxWidth&&t.maxWidth-t.previousWidth<c?(c-=t.maxWidth-t.previousWidth,t.width=t.maxWidth):(t.width=t.previousWidth+c,c=0))}else{for(c=u,e=s;e>=0;e--)(t=columns[e]).resizable&&(c&&t.maxWidth&&t.maxWidth-t.previousWidth<c?(c-=t.maxWidth-t.previousWidth,t.width=t.maxWidth):(t.width=t.previousWidth+c,c=0));if(options.forceFitColumns)for(c=-u,e=s+1;e<columns.length;e++)(t=columns[e]).resizable&&(a=Math.max(t.minWidth||0,absoluteColumnMinWidth),c&&t.previousWidth+c<a?(c+=t.previousWidth-a,t.width=a):(t.width=t.previousWidth+c,c=0))}applyColumnHeaderWidths(),options.syncColumnCellResize&&applyColumnWidths()}).on("dragend",function(n,r){var i;for($(this).parent().removeClass("slick-header-column-active"),e=0;e<columns.length;e++)t=columns[e],i=$(o[e]).outerWidth(),t.previousWidth!==i&&t.rerenderOnResize&&invalidateAllRows();updateCanvasWidth(!0),render(),trigger(self.onColumnsResized,{}),setTimeout(function(){columnResizeDragging=!1},300)}))})}function getVBoxDelta(e){var t=0;return $.each(["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],function(n,o){t+=parseFloat(e.css(o))||0}),t}function measureCellPaddingAndBorder(){var e,t=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],n=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],o=$.fn.jquery.split(".");jQueryNewWidthBehaviour=1==o[0]&&o[1]>=8||o[0]>=2,e=$("<div class='ui-state-default slick-header-column' style='visibility:hidden'>-</div>").appendTo($headers),headerColumnWidthDiff=headerColumnHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(t,function(t,n){headerColumnWidthDiff+=parseFloat(e.css(n))||0}),$.each(n,function(t,n){headerColumnHeightDiff+=parseFloat(e.css(n))||0})),e.remove();var r=$("<div class='slick-row' />").appendTo($canvas);e=$("<div class='slick-cell' id='' style='visibility:hidden'>-</div>").appendTo(r),cellWidthDiff=cellHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(t,function(t,n){cellWidthDiff+=parseFloat(e.css(n))||0}),$.each(n,function(t,n){cellHeightDiff+=parseFloat(e.css(n))||0})),r.remove(),absoluteColumnMinWidth=Math.max(headerColumnWidthDiff,cellWidthDiff)}function createCssRules(){$style=$("<style type='text/css' rel='stylesheet' />").appendTo($("head"));for(var e=options.rowHeight-cellHeightDiff,t=["."+uid+" .slick-header-column { left: 1000px; }","."+uid+" .slick-top-panel { height:"+options.topPanelHeight+"px; }","."+uid+" .slick-preheader-panel { height:"+options.preHeaderPanelHeight+"px; }","."+uid+" .slick-headerrow-columns { height:"+options.headerRowHeight+"px; }","."+uid+" .slick-footerrow-columns { height:"+options.footerRowHeight+"px; }","."+uid+" .slick-cell { height:"+e+"px; }","."+uid+" .slick-row { height:"+options.rowHeight+"px; }"],n=0;n<columns.length;n++)t.push("."+uid+" .l"+n+" { }"),t.push("."+uid+" .r"+n+" { }");$style[0].styleSheet?$style[0].styleSheet.cssText=t.join(" "):$style[0].appendChild(document.createTextNode(t.join(" ")))}function getColumnCssRules(e){var t;if(!stylesheet){var n=document.styleSheets;for(t=0;t<n.length;t++)if((n[t].ownerNode||n[t].owningElement)==$style[0]){stylesheet=n[t];break}if(!stylesheet)throw new Error("Cannot find stylesheet.");columnCssRulesL=[],columnCssRulesR=[];var o,r,i=stylesheet.cssRules||stylesheet.rules;for(t=0;t<i.length;t++){var l=i[t].selectorText;(o=/\.l\d+/.exec(l))?(r=parseInt(o[0].substr(2,o[0].length-2),10),columnCssRulesL[r]=i[t]):(o=/\.r\d+/.exec(l))&&(r=parseInt(o[0].substr(2,o[0].length-2),10),columnCssRulesR[r]=i[t])}}return{left:columnCssRulesL[e],right:columnCssRulesR[e]}}function removeCssRules(){$style.remove(),stylesheet=null}function destroy(){getEditorLock().cancelCurrentEdit(),trigger(self.onBeforeDestroy,{});for(var e=plugins.length;e--;)unregisterPlugin(plugins[e]);options.enableColumnReorder&&$headers.filter(":ui-sortable").sortable("destroy"),unbindAncestorScrollEvents(),$container.off(".slickgrid"),removeCssRules(),$canvas.off("draginit dragstart dragend drag"),$container.empty().removeClass(uid)}function trigger(e,t,n){return n=n||new Slick.EventData,(t=t||{}).grid=self,e.notify(t,n,self)}function getEditorLock(){return options.editorLock}function getEditController(){return editController}function getColumnIndex(e){return columnsById[e]}function autosizeColumns(){var e,t,n,o=[],r=0,i=0,l=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW;for(e=0;e<columns.length;e++)t=columns[e],o.push(t.width),i+=t.width,t.resizable&&(r+=t.width-Math.max(t.minWidth,absoluteColumnMinWidth));for(n=i;i>l&&r;){var a=(i-l)/r;for(e=0;e<columns.length&&i>l;e++){t=columns[e];var s=o[e];if(!(!t.resizable||s<=t.minWidth||s<=absoluteColumnMinWidth)){var c=Math.max(t.minWidth,absoluteColumnMinWidth),u=Math.floor(a*(s-c))||1;i-=u=Math.min(u,s-c),r-=u,o[e]-=u}}if(n<=i)break;n=i}for(n=i;i<l;){var d=l/i;for(e=0;e<columns.length&&i<l;e++){t=columns[e];var p,f=o[e];i+=p=!t.resizable||t.maxWidth<=f?0:Math.min(Math.floor(d*f)-f,t.maxWidth-f||1e6)||1,o[e]+=i<=l?p:0}if(n>=i)break;n=i}var h=!1;for(e=0;e<columns.length;e++)columns[e].rerenderOnResize&&columns[e].width!=o[e]&&(h=!0),columns[e].width=o[e];applyColumnHeaderWidths(),updateCanvasWidth(!0),trigger(self.onAutosizeColumns,{columns:columns}),h&&(invalidateAllRows(),render())}function applyColumnHeaderWidths(){if(initialized){for(var e,t=0,n=$headers.children(),o=columns.length;t<o;t++)e=$(n[t]),jQueryNewWidthBehaviour?e.outerWidth()!==columns[t].width&&e.outerWidth(columns[t].width):e.width()!==columns[t].width-headerColumnWidthDiff&&e.width(columns[t].width-headerColumnWidthDiff);updateColumnCaches()}}function applyColumnWidths(){for(var e,t,n=0,o=0;o<columns.length;o++)e=columns[o].width,(t=getColumnCssRules(o)).left.style.left=n+"px",t.right.style.right=canvasWidth-n-e+"px",n+=columns[o].width}function setSortColumn(e,t){setSortColumns([{columnId:e,sortAsc:t}])}function setSortColumns(e){sortColumns=e;var t=options.numberedMultiColumnSort&&sortColumns.length>1,n=$headers.children();n.removeClass("slick-header-column-sorted").find(".slick-sort-indicator").removeClass("slick-sort-indicator-asc slick-sort-indicator-desc"),n.find(".slick-sort-indicator-numbered").text(""),$.each(sortColumns,function(e,o){null==o.sortAsc&&(o.sortAsc=!0);var r=getColumnIndex(o.columnId);null!=r&&(n.eq(r).addClass("slick-header-column-sorted").find(".slick-sort-indicator").addClass(o.sortAsc?"slick-sort-indicator-asc":"slick-sort-indicator-desc"),t&&n.eq(r).find(".slick-sort-indicator-numbered").text(e+1))})}function getSortColumns(){return sortColumns}function handleSelectedRangesChanged(e,t){selectedRows=[];for(var n={},o=0;o<t.length;o++)for(var r=t[o].fromRow;r<=t[o].toRow;r++){n[r]||(selectedRows.push(r),n[r]={});for(var i=t[o].fromCell;i<=t[o].toCell;i++)canCellBeSelected(r,i)&&(n[r][columns[i].id]=options.selectedCellCssClass)}setCellCssStyles(options.selectedCellCssClass,n),trigger(self.onSelectedRowsChanged,{rows:getSelectedRows()},e)}function getColumns(){return columns}function updateColumnCaches(){columnPosLeft=[],columnPosRight=[];for(var e=0,t=0,n=columns.length;t<n;t++)columnPosLeft[t]=e,columnPosRight[t]=e+columns[t].width,e+=columns[t].width}function setColumns(e){columns=e,columnsById={};for(var t=0;t<columns.length;t++){var n=columns[t]=$.extend({},columnDefaults,columns[t]);columnsById[n.id]=t,n.minWidth&&n.width<n.minWidth&&(n.width=n.minWidth),n.maxWidth&&n.width>n.maxWidth&&(n.width=n.maxWidth)}updateColumnCaches(),initialized&&(invalidateAllRows(),createColumnHeaders(),removeCssRules(),createCssRules(),resizeCanvas(),applyColumnWidths(),handleScroll())}function getOptions(){return options}function setOptions(e,t){getEditorLock().commitCurrentEdit()&&(makeActiveCellNormal(),options.enableAddRow!==e.enableAddRow&&invalidateRow(getDataLength()),options=$.extend(options,e),validateAndEnforceOptions(),$viewport.css("overflow-y",options.autoHeight?"hidden":"auto"),t||render())}function validateAndEnforceOptions(){options.autoHeight&&(options.leaveSpaceForNewRows=!1)}function setData(e,t){data=e,invalidateAllRows(),updateRowCount(),t&&scrollTo(0)}function getData(){return data}function getDataLength(){return data.getLength?data.getLength():data.length}function getDataLengthIncludingAddNew(){return getDataLength()+(options.enableAddRow&&(!pagingActive||pagingIsLastPage)?1:0)}function getDataItem(e){return data.getItem?data.getItem(e):data[e]}function getTopPanel(){return $topPanel[0]}function setTopPanelVisibility(e){options.showTopPanel!=e&&(options.showTopPanel=e,e?$topPanelScroller.slideDown("fast",resizeCanvas):$topPanelScroller.slideUp("fast",resizeCanvas))}function setHeaderRowVisibility(e){options.showHeaderRow!=e&&(options.showHeaderRow=e,e?$headerRowScroller.slideDown("fast",resizeCanvas):$headerRowScroller.slideUp("fast",resizeCanvas))}function setFooterRowVisibility(e){options.showFooterRow!=e&&(options.showFooterRow=e,e?$footerRowScroller.slideDown("fast",resizeCanvas):$footerRowScroller.slideUp("fast",resizeCanvas))}function setPreHeaderPanelVisibility(e){options.showPreHeaderPanel!=e&&(options.showPreHeaderPanel=e,e?$preHeaderPanelScroller.slideDown("fast",resizeCanvas):$preHeaderPanelScroller.slideUp("fast",resizeCanvas))}function getContainerNode(){return $container.get(0)}function getRowTop(e){return options.rowHeight*e-offset}function getRowFromPosition(e){return Math.floor((e+offset)/options.rowHeight)}function scrollTo(e){e=Math.max(e,0),e=Math.min(e,th-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0));var t=offset;page=Math.min(n-1,Math.floor(e/ph));var o=e-(offset=Math.round(page*cj));offset!=t&&(cleanupRows(getVisibleRange(o)),updateRowPositions());prevScrollTop!=o&&(vScrollDir=prevScrollTop+t<o+offset?1:-1,$viewport[0].scrollTop=lastRenderedScrollTop=scrollTop=prevScrollTop=o,trigger(self.onViewportChanged,{}))}function defaultFormatter(e,t,n,o,r,i){return null==n?"":(n+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}function getFormatter(e,t){var n=data.getItemMetadata&&data.getItemMetadata(e),o=n&&n.columns&&(n.columns[t.id]||n.columns[getColumnIndex(t.id)]);return o&&o.formatter||n&&n.formatter||t.formatter||options.formatterFactory&&options.formatterFactory.getFormatter(t)||options.defaultFormatter}function getEditor(e,t){var n=columns[t],o=data.getItemMetadata&&data.getItemMetadata(e),r=o&&o.columns;return r&&r[n.id]&&void 0!==r[n.id].editor?r[n.id].editor:r&&r[t]&&void 0!==r[t].editor?r[t].editor:n.editor||options.editorFactory&&options.editorFactory.getEditor(n)}function getDataItemValueForColumn(e,t){return options.dataItemColumnValueExtractor?options.dataItemColumnValueExtractor(e,t):e[t.field]}function appendRowHtml(e,t,n,o){var r=getDataItem(t),i="slick-row"+(t<o&&!r?" loading":"")+(t===activeRow&&options.showCellSelection?" active":"")+(t%2==1?" odd":" even");r||(i+=" "+options.addNewRowCssClass);var l,a,s=data.getItemMetadata&&data.getItemMetadata(t);s&&s.cssClasses&&(i+=" "+s.cssClasses),e.push("<div class='ui-widget-content "+i+"' style='top:"+getRowTop(t)+"px'>");for(var c=0,u=columns.length;c<u;c++){if(a=columns[c],l=1,s&&s.columns){var d=s.columns[a.id]||s.columns[c];"*"===(l=d&&d.colspan||1)&&(l=u-c)}if(columnPosRight[Math.min(u-1,c+l-1)]>n.leftPx){if(columnPosLeft[c]>n.rightPx)break;appendCellHtml(e,t,c,l,r)}l>1&&(c+=l-1)}e.push("</div>")}function appendCellHtml(e,t,n,o,r){var i=columns[n],l="slick-cell l"+n+" r"+Math.min(columns.length-1,n+o-1)+(i.cssClass?" "+i.cssClass:"");for(var a in t===activeRow&&n===activeCell&&options.showCellSelection&&(l+=" active"),cellCssClasses)cellCssClasses[a][t]&&cellCssClasses[a][t][i.id]&&(l+=" "+cellCssClasses[a][t][i.id]);var s=null,c="";r&&(s=getDataItemValueForColumn(r,i),null==(c=getFormatter(t,i)(t,n,s,i,r,self))&&(c=""));var u=trigger(self.onBeforeAppendCell,{row:t,cell:n,value:s,dataContext:r})||"";u+=c&&c.addClasses?(u?" ":"")+c.addClasses:"",e.push("<div class='"+l+(u?" "+u:"")+"'>"),r&&e.push("[object Object]"!==Object.prototype.toString.call(c)?c:c.text),e.push("</div>"),rowsCache[t].cellRenderQueue.push(n),rowsCache[t].cellColSpans[n]=o}function cleanupRows(e){for(var t in rowsCache)(t=parseInt(t,10))!==activeRow&&(t<e.top||t>e.bottom)&&removeRowFromCache(t);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function invalidate(){updateRowCount(),invalidateAllRows(),render()}function invalidateAllRows(){for(var e in currentEditor&&makeActiveCellNormal(),rowsCache)removeRowFromCache(e);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function queuePostProcessedRowForCleanup(e,t,n){for(var o in postProcessgroupId++,t)t.hasOwnProperty(o)&&postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e.cellNodesByColumnIdx[0|o],columnIdx:0|o,rowIdx:n});postProcessedCleanupQueue.push({actionType:"R",groupId:postProcessgroupId,node:e.rowNode}),$(e.rowNode).detach()}function queuePostProcessedCellForCleanup(e,t,n){postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e,columnIdx:t,rowIdx:n}),$(e).detach()}function removeRowFromCache(e){var t=rowsCache[e];t&&(t.rowNode&&(rowNodeFromLastMouseWheelEvent===t.rowNode?(t.rowNode.style.display="none",zombieRowNodeFromLastMouseWheelEvent=rowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent=t,zombieRowPostProcessedFromLastMouseWheelEvent=postProcessedRows[e]):options.enableAsyncPostRenderCleanup&&postProcessedRows[e]?queuePostProcessedRowForCleanup(t,postProcessedRows[e],e):$canvas[0].removeChild(t.rowNode)),delete rowsCache[e],delete postProcessedRows[e],renderedRows--,counter_rows_removed++)}function invalidateRows(e){var t,n;if(e&&e.length){for(vScrollDir=0,n=e.length,t=0;t<n;t++)currentEditor&&activeRow===e[t]&&makeActiveCellNormal(),rowsCache[e[t]]&&removeRowFromCache(e[t]);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}}function invalidateRow(e){(e||0===e)&&invalidateRows([e])}function applyFormatResultToCellNode(e,t,n){null==e&&(e=""),"[object Object]"===Object.prototype.toString.call(e)?(t.innerHTML=e.text,e.removeClasses&&!n&&$(t).removeClass(e.removeClasses),e.addClasses&&$(t).addClass(e.addClasses)):t.innerHTML=e}function updateCell(e,t){var n=getCellNode(e,t);if(n){var o=columns[t],r=getDataItem(e);if(currentEditor&&activeRow===e&&activeCell===t)currentEditor.loadValue(r);else applyFormatResultToCellNode(r?getFormatter(e,o)(e,t,getDataItemValueForColumn(r,o),o,r,self):"",n),invalidatePostProcessingResults(e)}}function updateRow(e){var t=rowsCache[e];if(t){ensureCellNodesInRowsCache(e);var n=getDataItem(e);for(var o in t.cellNodesByColumnIdx)if(t.cellNodesByColumnIdx.hasOwnProperty(o)){var r=columns[o|=0],i=t.cellNodesByColumnIdx[o];e===activeRow&&o===activeCell&&currentEditor?currentEditor.loadValue(n):n?applyFormatResultToCellNode(getFormatter(e,r)(e,o,getDataItemValueForColumn(n,r),r,n,self),i):i.innerHTML=""}invalidatePostProcessingResults(e)}}function getViewportHeight(){return parseFloat($.css($container[0],"height",!0))-parseFloat($.css($container[0],"paddingTop",!0))-parseFloat($.css($container[0],"paddingBottom",!0))-parseFloat($.css($headerScroller[0],"height"))-getVBoxDelta($headerScroller)-(options.showTopPanel?options.topPanelHeight+getVBoxDelta($topPanelScroller):0)-(options.showHeaderRow?options.headerRowHeight+getVBoxDelta($headerRowScroller):0)-(options.createFooterRow&&options.showFooterRow?options.footerRowHeight+getVBoxDelta($footerRowScroller):0)-(options.createPreHeaderPanel&&options.showPreHeaderPanel?options.preHeaderPanelHeight+getVBoxDelta($preHeaderPanelScroller):0)}function resizeCanvas(){initialized&&(viewportH=options.autoHeight?options.rowHeight*getDataLengthIncludingAddNew():getViewportHeight(),numVisibleRows=Math.ceil(viewportH/options.rowHeight),viewportW=parseFloat($.css($container[0],"width",!0)),options.autoHeight||$viewport.height(viewportH),scrollbarDimensions&&scrollbarDimensions.width||(scrollbarDimensions=measureScrollbar()),options.forceFitColumns&&autosizeColumns(),updateRowCount(),handleScroll(),lastRenderedScrollLeft=-1,render())}function updatePagingStatusFromView(e){pagingActive=0!==e.pageSize,pagingIsLastPage=e.pageNum==e.totalPages-1}function updateRowCount(){if(initialized){var e=getDataLength(),t=getDataLengthIncludingAddNew()+(options.leaveSpaceForNewRows?numVisibleRows-1:0),o=viewportHasVScroll;viewportHasVScroll=options.alwaysShowVerticalScroll||!options.autoHeight&&t*options.rowHeight>viewportH,viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width,makeActiveCellNormal();var r=e-1;for(var i in rowsCache)i>r&&removeRowFromCache(i);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup(),activeCellNode&&activeRow>r&&resetActiveCell();var l=h;(th=Math.max(options.rowHeight*t,viewportH-scrollbarDimensions.height))<maxSupportedCssHeight?(h=ph=th,n=1,cj=0):(ph=(h=maxSupportedCssHeight)/100,n=Math.floor(th/ph),cj=(th-h)/(n-1)),h!==l&&($canvas.css("height",h),scrollTop=$viewport[0].scrollTop);var a=scrollTop+offset<=th-viewportH;0==th||0==scrollTop?page=offset=0:scrollTo(a?scrollTop+offset:th-viewportH),h!=l&&options.autoHeight&&resizeCanvas(),options.forceFitColumns&&o!=viewportHasVScroll&&autosizeColumns(),updateCanvasWidth(!1)}}function getVisibleRange(e,t){return null==e&&(e=scrollTop),null==t&&(t=scrollLeft),{top:getRowFromPosition(e),bottom:getRowFromPosition(e+viewportH)+1,leftPx:t,rightPx:t+viewportW}}function getRenderedRange(e,t){var n=getVisibleRange(e,t),o=Math.round(viewportH/options.rowHeight),r=options.minRowBuffer;return-1==vScrollDir?(n.top-=o,n.bottom+=r):1==vScrollDir?(n.top-=r,n.bottom+=o):(n.top-=r,n.bottom+=r),n.top=Math.max(0,n.top),n.bottom=Math.min(getDataLengthIncludingAddNew()-1,n.bottom),n.leftPx-=viewportW,n.rightPx+=viewportW,n.leftPx=Math.max(0,n.leftPx),n.rightPx=Math.min(canvasWidth,n.rightPx),n}function ensureCellNodesInRowsCache(e){var t=rowsCache[e];if(t&&t.cellRenderQueue.length)for(var n=t.rowNode.lastChild;t.cellRenderQueue.length;){var o=t.cellRenderQueue.pop();t.cellNodesByColumnIdx[o]=n,n=n.previousSibling}}function cleanUpCells(e,t){var n,o,r=rowsCache[t],i=[];for(var l in r.cellNodesByColumnIdx)if(r.cellNodesByColumnIdx.hasOwnProperty(l)){l|=0;var a=r.cellColSpans[l];(columnPosLeft[l]>e.rightPx||columnPosRight[Math.min(columns.length-1,l+a-1)]<e.leftPx)&&(t==activeRow&&l==activeCell||i.push(l))}for(postProcessgroupId++;null!=(n=i.pop());)o=r.cellNodesByColumnIdx[n],options.enableAsyncPostRenderCleanup&&postProcessedRows[t]&&postProcessedRows[t][n]?queuePostProcessedCellForCleanup(o,n,t):r.rowNode.removeChild(o),delete r.cellColSpans[n],delete r.cellNodesByColumnIdx[n],postProcessedRows[t]&&delete postProcessedRows[t][n],0}function cleanUpAndRenderCells(e){for(var t,n,o,r=[],i=[],l=e.top,a=e.bottom;l<=a;l++)if(t=rowsCache[l]){ensureCellNodesInRowsCache(l),cleanUpCells(e,l),n=0;var s=data.getItemMetadata&&data.getItemMetadata(l);s=s&&s.columns;for(var c=getDataItem(l),u=0,d=columns.length;u<d&&!(columnPosLeft[u]>e.rightPx);u++)if(null==(o=t.cellColSpans[u])){if(o=1,s){var p=s[columns[u].id]||s[u];"*"===(o=p&&p.colspan||1)&&(o=d-u)}columnPosRight[Math.min(d-1,u+o-1)]>e.leftPx&&(appendCellHtml(r,l,u,o,c),n++),u+=o>1?o-1:0}else u+=o>1?o-1:0;n&&(n,i.push(l))}if(r.length){var f,h,g=document.createElement("div");for(g.innerHTML=r.join("");null!=(f=i.pop());){var m;for(t=rowsCache[f];null!=(m=t.cellRenderQueue.pop());)h=g.lastChild,t.rowNode.appendChild(h),t.cellNodesByColumnIdx[m]=h}}}function renderRows(e){for(var t=$canvas[0],n=[],o=[],r=!1,i=getDataLength(),l=e.top,a=e.bottom;l<=a;l++)rowsCache[l]||(renderedRows++,o.push(l),rowsCache[l]={rowNode:null,cellColSpans:[],cellNodesByColumnIdx:[],cellRenderQueue:[]},appendRowHtml(n,l,e,i),activeCellNode&&activeRow===l&&(r=!0),counter_rows_rendered++);if(o.length){var s=document.createElement("div");s.innerHTML=n.join("");for(l=0,a=o.length;l<a;l++)rowsCache[o[l]].rowNode=t.appendChild(s.firstChild);r&&(activeCellNode=getCellNode(activeRow,activeCell))}}function startPostProcessing(){options.enableAsyncPostRender&&(clearTimeout(h_postrender),h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}function startPostProcessingCleanup(){options.enableAsyncPostRenderCleanup&&(clearTimeout(h_postrenderCleanup),h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay))}function invalidatePostProcessingResults(e){for(var t in postProcessedRows[e])postProcessedRows[e].hasOwnProperty(t)&&(postProcessedRows[e][t]="C");postProcessFromRow=Math.min(postProcessFromRow,e),postProcessToRow=Math.max(postProcessToRow,e),startPostProcessing()}function updateRowPositions(){for(var e in rowsCache)rowsCache[e].rowNode.style.top=getRowTop(e)+"px"}function render(){if(initialized){scrollThrottle.dequeue();var e=getVisibleRange(),t=getRenderedRange();cleanupRows(t),lastRenderedScrollLeft!=scrollLeft&&cleanUpAndRenderCells(t),renderRows(t),postProcessFromRow=e.top,postProcessToRow=Math.min(getDataLengthIncludingAddNew()-1,e.bottom),startPostProcessing(),lastRenderedScrollTop=scrollTop,lastRenderedScrollLeft=scrollLeft,h_render=null,trigger(self.onRendered,{startRow:e.top,endRow:e.bottom,grid:self})}}function handleHeaderScroll(){handleElementScroll($headerScroller[0])}function handleHeaderRowScroll(){handleElementScroll($headerRowScroller[0])}function handleFooterRowScroll(){handleElementScroll($footerRowScroller[0])}function handlePreHeaderPanelScroll(){handleElementScroll($preHeaderPanelScroller[0])}function handleElementScroll(e){var t=e.scrollLeft;t!=$viewport[0].scrollLeft&&($viewport[0].scrollLeft=t)}function handleScroll(){scrollTop=$viewport[0].scrollTop,scrollLeft=$viewport[0].scrollLeft;var e=Math.abs(scrollTop-prevScrollTop),t=Math.abs(scrollLeft-prevScrollLeft);if(t&&(prevScrollLeft=scrollLeft,$headerScroller[0].scrollLeft=scrollLeft,$topPanelScroller[0].scrollLeft=scrollLeft,$headerRowScroller[0].scrollLeft=scrollLeft,options.createFooterRow&&($footerRowScroller[0].scrollLeft=scrollLeft),options.createPreHeaderPanel&&($preHeaderPanelScroller[0].scrollLeft=scrollLeft)),e)if(vScrollDir=prevScrollTop<scrollTop?1:-1,prevScrollTop=scrollTop,e<viewportH)scrollTo(scrollTop+offset);else{var o=offset;page=h==viewportH?0:Math.min(n-1,Math.floor(scrollTop*((th-viewportH)/(h-viewportH))*(1/ph))),o!=(offset=Math.round(page*cj))&&invalidateAllRows()}if(t||e){var r=Math.abs(lastRenderedScrollLeft-scrollLeft),i=Math.abs(lastRenderedScrollTop-scrollTop);(r>20||i>20)&&(options.forceSyncScrolling||i<viewportH&&r<viewportW?render():scrollThrottle.enqueue(),trigger(self.onViewportChanged,{}))}trigger(self.onScroll,{scrollLeft:scrollLeft,scrollTop:scrollTop})}function ActionThrottle(e,t){var n=!1,o=!1;function r(){o=!1}function i(){n=!0,setTimeout(l,t),e()}function l(){o?(r(),i()):n=!1}return{enqueue:function(){n?o=!0:i()},dequeue:r}}function asyncPostProcessRows(){for(var e=getDataLength();postProcessFromRow<=postProcessToRow;){var t=vScrollDir>=0?postProcessFromRow++:postProcessToRow--,n=rowsCache[t];if(n&&!(t>=e)){for(var o in postProcessedRows[t]||(postProcessedRows[t]={}),ensureCellNodesInRowsCache(t),n.cellNodesByColumnIdx)if(n.cellNodesByColumnIdx.hasOwnProperty(o)){var r=columns[o|=0],i=postProcessedRows[t][o];if(r.asyncPostRender&&"R"!==i){var l=n.cellNodesByColumnIdx[o];l&&r.asyncPostRender(l,t,getDataItem(t),r,"C"===i),postProcessedRows[t][o]="R"}}return void(h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}}}function asyncPostProcessCleanupRows(){if(postProcessedCleanupQueue.length>0){for(var e=postProcessedCleanupQueue[0].groupId;postProcessedCleanupQueue.length>0&&postProcessedCleanupQueue[0].groupId==e;){var t=postProcessedCleanupQueue.shift();if("R"==t.actionType&&$(t.node).remove(),"C"==t.actionType){var n=columns[t.columnIdx];n.asyncPostRenderCleanup&&t.node&&n.asyncPostRenderCleanup(t.node,t.rowIdx,n)}}h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay)}}function updateCellCssStylesOnRenderedRows(e,t){var n,o,r,i;for(var l in rowsCache){if(i=t&&t[l],r=e&&e[l],i)for(o in i)r&&i[o]==r[o]||(n=getCellNode(l,getColumnIndex(o)))&&$(n).removeClass(i[o]);if(r)for(o in r)i&&i[o]==r[o]||(n=getCellNode(l,getColumnIndex(o)))&&$(n).addClass(r[o])}}function addCellCssStyles(e,t){if(cellCssClasses[e])throw new Error("addCellCssStyles: cell CSS hash with key '"+e+"' already exists.");cellCssClasses[e]=t,updateCellCssStylesOnRenderedRows(t,null),trigger(self.onCellCssStylesChanged,{key:e,hash:t,grid:self})}function removeCellCssStyles(e){cellCssClasses[e]&&(updateCellCssStylesOnRenderedRows(null,cellCssClasses[e]),delete cellCssClasses[e],trigger(self.onCellCssStylesChanged,{key:e,hash:null,grid:self}))}function setCellCssStyles(e,t){var n=cellCssClasses[e];cellCssClasses[e]=t,updateCellCssStylesOnRenderedRows(t,n),trigger(self.onCellCssStylesChanged,{key:e,hash:t,grid:self})}function getCellCssStyles(e){return cellCssClasses[e]}function flashCell(e,t,n){if(n=n||100,rowsCache[e]){var o=$(getCellNode(e,t)),r=function(e){e&&setTimeout(function(){o.queue(function(){o.toggleClass(options.cellFlashingCssClass).dequeue(),r(e-1)})},n)};r(4)}}function handleMouseWheel(e){var t=$(e.target).closest(".slick-row")[0];t!=rowNodeFromLastMouseWheelEvent&&(zombieRowNodeFromLastMouseWheelEvent&&zombieRowNodeFromLastMouseWheelEvent!=t&&(options.enableAsyncPostRenderCleanup&&zombieRowPostProcessedFromLastMouseWheelEvent?queuePostProcessedRowForCleanup(zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent):$canvas[0].removeChild(zombieRowNodeFromLastMouseWheelEvent),zombieRowNodeFromLastMouseWheelEvent=null,zombieRowCacheFromLastMouseWheelEvent=null,zombieRowPostProcessedFromLastMouseWheelEvent=null,options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()),rowNodeFromLastMouseWheelEvent=t)}function handleDragInit(e,t){var n=getCellFromEvent(e);if(!n||!cellExists(n.row,n.cell))return!1;var o=trigger(self.onDragInit,t,e);return!!e.isImmediatePropagationStopped()&&o}function handleDragStart(e,t){var n=getCellFromEvent(e);if(!n||!cellExists(n.row,n.cell))return!1;var o=trigger(self.onDragStart,t,e);return!!e.isImmediatePropagationStopped()&&o}function handleDrag(e,t){return trigger(self.onDrag,t,e)}function handleDragEnd(e,t){trigger(self.onDragEnd,t,e)}function handleKeyDown(e){trigger(self.onKeyDown,{row:activeRow,cell:activeCell},e);var t=e.isImmediatePropagationStopped(),n=Slick.keyCode;if(!t&&!e.shiftKey&&!e.altKey){if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;e.which==n.HOME?t=e.ctrlKey?navigateTop():navigateRowStart():e.which==n.END&&(t=e.ctrlKey?navigateBottom():navigateRowEnd())}if(!t)if(e.shiftKey||e.altKey||e.ctrlKey)e.which!=n.TAB||!e.shiftKey||e.ctrlKey||e.altKey||(t=navigatePrev());else{if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;if(e.which==n.ESCAPE){if(!getEditorLock().isActive())return;cancelEditAndSetFocus()}else e.which==n.PAGE_DOWN?(navigatePageDown(),t=!0):e.which==n.PAGE_UP?(navigatePageUp(),t=!0):e.which==n.LEFT?t=navigateLeft():e.which==n.RIGHT?t=navigateRight():e.which==n.UP?t=navigateUp():e.which==n.DOWN?t=navigateDown():e.which==n.TAB?t=navigateNext():e.which==n.ENTER&&(options.editable&&(currentEditor?activeRow===getDataLength()?navigateDown():commitEditAndSetFocus():getEditorLock().commitCurrentEdit()&&makeActiveCellEditable(void 0,void 0,e)),t=!0)}if(t){e.stopPropagation(),e.preventDefault();try{e.originalEvent.keyCode=0}catch(e){}}}function handleClick(e){currentEditor||(e.target!=document.activeElement||$(e.target).hasClass("slick-cell"))&&setFocus();var t=getCellFromEvent(e);if(t&&(null===currentEditor||activeRow!=t.row||activeCell!=t.cell)&&(trigger(self.onClick,{row:t.row,cell:t.cell},e),!e.isImmediatePropagationStopped()&&canCellBeActive(t.row,t.cell)&&(!getEditorLock().isActive()||getEditorLock().commitCurrentEdit()))){scrollRowIntoView(t.row,!1);var n=e.target&&e.target.className===Slick.preClickClassName,o=columns[t.cell],r=!!(options.editable&&o&&o.editor&&options.suppressActiveCellChangeOnEdit);setActiveCellInternal(getCellNode(t.row,t.cell),null,n,r,e)}}function handleContextMenu(e){var t=$(e.target).closest(".slick-cell",$canvas);0!==t.length&&(activeCellNode===t[0]&&null!==currentEditor||trigger(self.onContextMenu,{},e))}function handleDblClick(e){var t=getCellFromEvent(e);!t||null!==currentEditor&&activeRow==t.row&&activeCell==t.cell||(trigger(self.onDblClick,{row:t.row,cell:t.cell},e),e.isImmediatePropagationStopped()||options.editable&&gotoCell(t.row,t.cell,!0,e))}function handleHeaderMouseEnter(e){trigger(self.onHeaderMouseEnter,{column:$(this).data("column"),grid:self},e)}function handleHeaderMouseLeave(e){trigger(self.onHeaderMouseLeave,{column:$(this).data("column"),grid:self},e)}function handleHeaderContextMenu(e){var t=$(e.target).closest(".slick-header-column",".slick-header-columns"),n=t&&t.data("column");trigger(self.onHeaderContextMenu,{column:n},e)}function handleHeaderClick(e){if(!columnResizeDragging){var t=$(e.target).closest(".slick-header-column",".slick-header-columns"),n=t&&t.data("column");n&&trigger(self.onHeaderClick,{column:n},e)}}function handleMouseEnter(e){trigger(self.onMouseEnter,{},e)}function handleMouseLeave(e){trigger(self.onMouseLeave,{},e)}function cellExists(e,t){return!(e<0||e>=getDataLength()||t<0||t>=columns.length)}function getCellFromPoint(e,t){for(var n=getRowFromPosition(t),o=0,r=0,i=0;i<columns.length&&r<e;i++)r+=columns[i].width,o++;return o<0&&(o=0),{row:n,cell:o-1}}function getCellFromNode(e){var t=/l\d+/.exec(e.className);if(!t)throw new Error("getCellFromNode: cannot get cell - "+e.className);return parseInt(t[0].substr(1,t[0].length-1),10)}function getRowFromNode(e){for(var t in rowsCache)if(rowsCache[t].rowNode===e)return 0|t;return null}function getCellFromEvent(e){var t=$(e.target).closest(".slick-cell",$canvas);if(!t.length)return null;var n=getRowFromNode(t[0].parentNode),o=getCellFromNode(t[0]);return null==n||null==o?null:{row:n,cell:o}}function getCellNodeBox(e,t){if(!cellExists(e,t))return null;for(var n=getRowTop(e),o=n+options.rowHeight-1,r=0,i=0;i<t;i++)r+=columns[i].width;return{top:n,left:r,bottom:o,right:r+columns[t].width}}function resetActiveCell(){setActiveCellInternal(null,!1)}function setFocus(){-1==tabbingDirection?$focusSink[0].focus():$focusSink2[0].focus()}function scrollCellIntoView(e,t,n){scrollRowIntoView(e,n);var o=getColspan(e,t);internalScrollColumnIntoView(columnPosLeft[t],columnPosRight[t+(o>1?o-1:0)])}function internalScrollColumnIntoView(e,t){var n=scrollLeft+viewportW;e<scrollLeft?($viewport.scrollLeft(e),handleScroll(),render()):t>n&&($viewport.scrollLeft(Math.min(e,t-$viewport[0].clientWidth)),handleScroll(),render())}function scrollColumnIntoView(e){internalScrollColumnIntoView(columnPosLeft[e],columnPosRight[e])}function setActiveCellInternal(e,t,n,o,r){null!==activeCellNode&&(makeActiveCellNormal(),$(activeCellNode).removeClass("active"),rowsCache[activeRow]&&$(rowsCache[activeRow].rowNode).removeClass("active"));null!=(activeCellNode=e)?(activeRow=getRowFromNode(activeCellNode.parentNode),activeCell=activePosX=getCellFromNode(activeCellNode),null==t&&(t=activeRow==getDataLength()||options.autoEdit),options.showCellSelection&&($(activeCellNode).addClass("active"),$(rowsCache[activeRow].rowNode).addClass("active")),options.editable&&t&&isCellPotentiallyEditable(activeRow,activeCell)&&(clearTimeout(h_editorLoader),options.asyncEditorLoading?h_editorLoader=setTimeout(function(){makeActiveCellEditable(void 0,n,r)},options.asyncEditorLoadDelay):makeActiveCellEditable(void 0,n,r))):activeRow=activeCell=null,o||trigger(self.onActiveCellChanged,getActiveCell())}function clearTextSelection(){if(document.selection&&document.selection.empty)try{document.selection.empty()}catch(e){}else if(window.getSelection){var e=window.getSelection();e&&e.removeAllRanges&&e.removeAllRanges()}}function isCellPotentiallyEditable(e,t){var n=getDataLength();return!(e<n&&!getDataItem(e))&&(!(columns[t].cannotTriggerInsert&&e>=n)&&!!getEditor(e,t))}function makeActiveCellNormal(){if(currentEditor){if(trigger(self.onBeforeCellEditorDestroy,{editor:currentEditor}),currentEditor.destroy(),currentEditor=null,activeCellNode){var e=getDataItem(activeRow);if($(activeCellNode).removeClass("editable invalid"),e){var t=columns[activeCell];applyFormatResultToCellNode(getFormatter(activeRow,t)(activeRow,activeCell,getDataItemValueForColumn(e,t),t,e,self),activeCellNode),invalidatePostProcessingResults(activeRow)}}navigator.userAgent.toLowerCase().match(/msie/)&&clearTextSelection(),getEditorLock().deactivate(editController)}}function makeActiveCellEditable(e,t,n){if(activeCellNode){if(!options.editable)throw new Error("Grid : makeActiveCellEditable : should never get called when options.editable is false");if(clearTimeout(h_editorLoader),isCellPotentiallyEditable(activeRow,activeCell)){var o=columns[activeCell],r=getDataItem(activeRow);if(!1!==trigger(self.onBeforeEditCell,{row:activeRow,cell:activeCell,item:r,column:o})){getEditorLock().activate(editController),$(activeCellNode).addClass("editable");var i=e||getEditor(activeRow,activeCell);e||i.suppressClearOnEdit||(activeCellNode.innerHTML=""),currentEditor=new i({grid:self,gridPosition:absBox($container[0]),position:absBox(activeCellNode),container:activeCellNode,column:o,item:r||{},event:n,commitChanges:commitEditAndSetFocus,cancelChanges:cancelEditAndSetFocus}),r&&(currentEditor.loadValue(r),t&&currentEditor.preClick&&currentEditor.preClick()),serializedEditorValue=currentEditor.serializeValue(),currentEditor.position&&handleActiveCellPositionChange()}else setFocus()}}}function commitEditAndSetFocus(){getEditorLock().commitCurrentEdit()&&(setFocus(),options.autoEdit&&navigateDown())}function cancelEditAndSetFocus(){getEditorLock().cancelCurrentEdit()&&setFocus()}function absBox(e){var t={top:e.offsetTop,left:e.offsetLeft,bottom:0,right:0,width:$(e).outerWidth(),height:$(e).outerHeight(),visible:!0};t.bottom=t.top+t.height,t.right=t.left+t.width;for(var n=e.offsetParent;(e=e.parentNode)!=document.body&&null!=e;)t.visible&&e.scrollHeight!=e.offsetHeight&&"visible"!=$(e).css("overflowY")&&(t.visible=t.bottom>e.scrollTop&&t.top<e.scrollTop+e.clientHeight),t.visible&&e.scrollWidth!=e.offsetWidth&&"visible"!=$(e).css("overflowX")&&(t.visible=t.right>e.scrollLeft&&t.left<e.scrollLeft+e.clientWidth),t.left-=e.scrollLeft,t.top-=e.scrollTop,e===n&&(t.left+=e.offsetLeft,t.top+=e.offsetTop,n=e.offsetParent),t.bottom=t.top+t.height,t.right=t.left+t.width;return t}function getActiveCellPosition(){return absBox(activeCellNode)}function getGridPosition(){return absBox($container[0])}function handleActiveCellPositionChange(){if(activeCellNode&&(trigger(self.onActiveCellPositionChanged,{}),currentEditor)){var e=getActiveCellPosition();currentEditor.show&&currentEditor.hide&&(e.visible?currentEditor.show():currentEditor.hide()),currentEditor.position&&currentEditor.position(e)}}function getCellEditor(){return currentEditor}function getActiveCell(){return activeCellNode?{row:activeRow,cell:activeCell}:null}function getActiveCellNode(){return activeCellNode}function scrollRowIntoView(e,t){var n=e*options.rowHeight,o=(e+1)*options.rowHeight-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0);(e+1)*options.rowHeight>scrollTop+viewportH+offset?(scrollTo(t?n:o),render()):e*options.rowHeight<scrollTop+offset&&(scrollTo(t?o:n),render())}function scrollRowToTop(e){scrollTo(e*options.rowHeight),render()}function scrollPage(e){var t=e*numVisibleRows;if(scrollTo((getRowFromPosition(scrollTop)+t)*options.rowHeight),render(),options.enableCellNavigation&&null!=activeRow){var n=activeRow+t,o=getDataLengthIncludingAddNew();n>=o&&(n=o-1),n<0&&(n=0);for(var r=0,i=null,l=activePosX;r<=activePosX;)canCellBeActive(n,r)&&(i=r),r+=getColspan(n,r);null!==i?(setActiveCellInternal(getCellNode(n,i)),activePosX=l):resetActiveCell()}}function navigatePageDown(){scrollPage(1)}function navigatePageUp(){scrollPage(-1)}function navigateTop(){navigateToRow(0)}function navigateBottom(){navigateToRow(getDataLength()-1)}function navigateToRow(e){var t=getDataLength();if(!t)return!0;if(e<0?e=0:e>=t&&(e=t-1),scrollCellIntoView(e,0,!0),options.enableCellNavigation&&null!=activeRow){for(var n=0,o=null,r=activePosX;n<=activePosX;)canCellBeActive(e,n)&&(o=n),n+=getColspan(e,n);null!==o?(setActiveCellInternal(getCellNode(e,o)),activePosX=r):resetActiveCell()}return!0}function getColspan(e,t){var n=data.getItemMetadata&&data.getItemMetadata(e);if(!n||!n.columns)return 1;var o=n.columns[columns[t].id]||n.columns[t],r=o&&o.colspan;return r="*"===r?columns.length-t:r||1}function findFirstFocusableCell(e){for(var t=0;t<columns.length;){if(canCellBeActive(e,t))return t;t+=getColspan(e,t)}return null}function findLastFocusableCell(e){for(var t=0,n=null;t<columns.length;)canCellBeActive(e,t)&&(n=t),t+=getColspan(e,t);return n}function gotoRight(e,t,n){if(t>=columns.length)return null;do{t+=getColspan(e,t)}while(t<columns.length&&!canCellBeActive(e,t));return t<columns.length?{row:e,cell:t,posX:t}:null}function gotoLeft(e,t,n){if(t<=0)return null;var o=findFirstFocusableCell(e);if(null===o||o>=t)return null;for(var r,i={row:e,cell:o,posX:o};;){if(!(r=gotoRight(i.row,i.cell,i.posX)))return null;if(r.cell>=t)return i;i=r}}function gotoDown(e,t,n){for(var o,r=getDataLengthIncludingAddNew();;){if(++e>=r)return null;for(o=t=0;t<=n;)o=t,t+=getColspan(e,t);if(canCellBeActive(e,o))return{row:e,cell:o,posX:n}}}function gotoUp(e,t,n){for(var o;;){if(--e<0)return null;for(o=t=0;t<=n;)o=t,t+=getColspan(e,t);if(canCellBeActive(e,o))return{row:e,cell:o,posX:n}}}function gotoNext(e,t,n){if(null==e&&null==t&&canCellBeActive(e=t=n=0,t))return{row:e,cell:t,posX:t};var o=gotoRight(e,t,n);if(o)return o;var r=null,i=getDataLengthIncludingAddNew();for(e===i-1&&e--;++e<i;)if(null!==(r=findFirstFocusableCell(e)))return{row:e,cell:r,posX:r};return null}function gotoPrev(e,t,n){if(null==e&&null==t&&canCellBeActive(e=getDataLengthIncludingAddNew()-1,t=n=columns.length-1))return{row:e,cell:t,posX:t};for(var o,r;!o&&!(o=gotoLeft(e,t,n));){if(--e<0)return null;t=0,null!==(r=findLastFocusableCell(e))&&(o={row:e,cell:r,posX:r})}return o}function gotoRowStart(e,t,n){var o=findFirstFocusableCell(e);return null===o?null:{row:e,cell:o,posX:o}}function gotoRowEnd(e,t,n){var o=findLastFocusableCell(e);return null===o?null:{row:e,cell:o,posX:o}}function navigateRight(){return navigate("right")}function navigateLeft(){return navigate("left")}function navigateDown(){return navigate("down")}function navigateUp(){return navigate("up")}function navigateNext(){return navigate("next")}function navigatePrev(){return navigate("prev")}function navigateRowStart(){return navigate("home")}function navigateRowEnd(){return navigate("end")}function navigate(e){if(!options.enableCellNavigation)return!1;if(!activeCellNode&&"prev"!=e&&"next"!=e)return!1;if(!getEditorLock().commitCurrentEdit())return!0;setFocus();tabbingDirection={up:-1,down:1,left:-1,right:1,prev:-1,next:1,home:-1,end:1}[e];var t=(0,{up:gotoUp,down:gotoDown,left:gotoLeft,right:gotoRight,prev:gotoPrev,next:gotoNext,home:gotoRowStart,end:gotoRowEnd}[e])(activeRow,activeCell,activePosX);if(t){var n=t.row==getDataLength();return scrollCellIntoView(t.row,t.cell,!n&&options.emulatePagingWhenScrolling),setActiveCellInternal(getCellNode(t.row,t.cell)),activePosX=t.posX,!0}return setActiveCellInternal(getCellNode(activeRow,activeCell)),!1}function getCellNode(e,t){return rowsCache[e]?(ensureCellNodesInRowsCache(e),rowsCache[e].cellNodesByColumnIdx[t]):null}function setActiveCell(e,t,n,o,r){initialized&&(e>getDataLength()||e<0||t>=columns.length||t<0||options.enableCellNavigation&&(scrollCellIntoView(e,t,!1),setActiveCellInternal(getCellNode(e,t),n,o,r)))}function canCellBeActive(e,t){if(!options.enableCellNavigation||e>=getDataLengthIncludingAddNew()||e<0||t>=columns.length||t<0)return!1;var n=data.getItemMetadata&&data.getItemMetadata(e);if(n&&void 0!==n.focusable)return!!n.focusable;var o=n&&n.columns;return o&&o[columns[t].id]&&void 0!==o[columns[t].id].focusable?!!o[columns[t].id].focusable:o&&o[t]&&void 0!==o[t].focusable?!!o[t].focusable:!!columns[t].focusable}function canCellBeSelected(e,t){if(e>=getDataLength()||e<0||t>=columns.length||t<0)return!1;var n=data.getItemMetadata&&data.getItemMetadata(e);if(n&&void 0!==n.selectable)return!!n.selectable;var o=n&&n.columns&&(n.columns[columns[t].id]||n.columns[t]);return o&&void 0!==o.selectable?!!o.selectable:!!columns[t].selectable}function gotoCell(e,t,n,o){initialized&&(canCellBeActive(e,t)&&getEditorLock().commitCurrentEdit()&&(scrollCellIntoView(e,t,!1),setActiveCellInternal(getCellNode(e,t),n||e===getDataLength()||options.autoEdit,null,options.editable,o),currentEditor||setFocus()))}function commitCurrentEdit(){var e=getDataItem(activeRow),t=columns[activeCell];if(currentEditor){if(currentEditor.isValueChanged()){var n=currentEditor.validate();if(n.valid){if(activeRow<getDataLength()){var o={row:activeRow,cell:activeCell,editor:currentEditor,serializedValue:currentEditor.serializeValue(),prevSerializedValue:serializedEditorValue,execute:function(){this.editor.applyValue(e,this.serializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})},undo:function(){this.editor.applyValue(e,this.prevSerializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})}};options.editCommandHandler?(makeActiveCellNormal(),options.editCommandHandler(e,t,o)):(o.execute(),makeActiveCellNormal())}else{var r={};currentEditor.applyValue(r,currentEditor.serializeValue()),makeActiveCellNormal(),trigger(self.onAddNewRow,{item:r,column:t})}return!getEditorLock().isActive()}return $(activeCellNode).removeClass("invalid"),$(activeCellNode).width(),$(activeCellNode).addClass("invalid"),trigger(self.onValidationError,{editor:currentEditor,cellNode:activeCellNode,validationResults:n,row:activeRow,cell:activeCell,column:t}),currentEditor.focus(),!1}makeActiveCellNormal()}return!0}function cancelCurrentEdit(){return makeActiveCellNormal(),!0}function rowsToRanges(e){for(var t=[],n=columns.length-1,o=0;o<e.length;o++)t.push(new Slick.Range(e[o],0,e[o],n));return t}function getSelectedRows(){if(!selectionModel)throw new Error("Selection model is not set");return selectedRows}function setSelectedRows(e){if(!selectionModel)throw new Error("Selection model is not set");self&&self.getEditorLock&&!self.getEditorLock().isActive()&&selectionModel.setSelectedRanges(rowsToRanges(e))}this.debug=function(){var e="";e+="\ncounter_rows_rendered:  "+counter_rows_rendered,e+="\ncounter_rows_removed:  "+counter_rows_removed,e+="\nrenderedRows:  "+renderedRows,e+="\nnumVisibleRows:  "+numVisibleRows,e+="\nmaxSupportedCssHeight:  "+maxSupportedCssHeight,e+="\nn(umber of pages):  "+n,e+="\n(current) page:  "+page,e+="\npage height (ph):  "+ph,e+="\nvScrollDir:  "+vScrollDir,alert(e)},this.eval=function(expr){return eval(expr)},$.extend(this,{slickGridVersion:"2.3.23",onScroll:new Slick.Event,onSort:new Slick.Event,onHeaderMouseEnter:new Slick.Event,onHeaderMouseLeave:new Slick.Event,onHeaderContextMenu:new Slick.Event,onHeaderClick:new Slick.Event,onHeaderCellRendered:new Slick.Event,onBeforeHeaderCellDestroy:new Slick.Event,onHeaderRowCellRendered:new Slick.Event,onFooterRowCellRendered:new Slick.Event,onBeforeHeaderRowCellDestroy:new Slick.Event,onBeforeFooterRowCellDestroy:new Slick.Event,onMouseEnter:new Slick.Event,onMouseLeave:new Slick.Event,onClick:new Slick.Event,onDblClick:new Slick.Event,onContextMenu:new Slick.Event,onKeyDown:new Slick.Event,onAddNewRow:new Slick.Event,onBeforeAppendCell:new Slick.Event,onValidationError:new Slick.Event,onViewportChanged:new Slick.Event,onColumnsReordered:new Slick.Event,onColumnsResized:new Slick.Event,onCellChange:new Slick.Event,onBeforeEditCell:new Slick.Event,onBeforeCellEditorDestroy:new Slick.Event,onBeforeDestroy:new Slick.Event,onActiveCellChanged:new Slick.Event,onActiveCellPositionChanged:new Slick.Event,onDragInit:new Slick.Event,onDragStart:new Slick.Event,onDrag:new Slick.Event,onDragEnd:new Slick.Event,onSelectedRowsChanged:new Slick.Event,onCellCssStylesChanged:new Slick.Event,onAutosizeColumns:new Slick.Event,onRendered:new Slick.Event,registerPlugin:registerPlugin,unregisterPlugin:unregisterPlugin,getColumns:getColumns,setColumns:setColumns,getColumnIndex:getColumnIndex,updateColumnHeader:updateColumnHeader,setSortColumn:setSortColumn,setSortColumns:setSortColumns,getSortColumns:getSortColumns,autosizeColumns:autosizeColumns,getOptions:getOptions,setOptions:setOptions,getData:getData,getDataLength:getDataLength,getDataItem:getDataItem,setData:setData,getSelectionModel:getSelectionModel,setSelectionModel:setSelectionModel,getSelectedRows:getSelectedRows,setSelectedRows:setSelectedRows,getContainerNode:getContainerNode,updatePagingStatusFromView:updatePagingStatusFromView,render:render,invalidate:invalidate,invalidateRow:invalidateRow,invalidateRows:invalidateRows,invalidateAllRows:invalidateAllRows,updateCell:updateCell,updateRow:updateRow,getViewport:getVisibleRange,getRenderedRange:getRenderedRange,resizeCanvas:resizeCanvas,updateRowCount:updateRowCount,scrollRowIntoView:scrollRowIntoView,scrollRowToTop:scrollRowToTop,scrollCellIntoView:scrollCellIntoView,scrollColumnIntoView:scrollColumnIntoView,getCanvasNode:getCanvasNode,getUID:getUID,getHeaderColumnWidthDiff:getHeaderColumnWidthDiff,getScrollbarDimensions:getScrollbarDimensions,getHeadersWidth:getHeadersWidth,getCanvasWidth:getCanvasWidth,focus:setFocus,scrollTo:scrollTo,getCellFromPoint:getCellFromPoint,getCellFromEvent:getCellFromEvent,getActiveCell:getActiveCell,setActiveCell:setActiveCell,getActiveCellNode:getActiveCellNode,getActiveCellPosition:getActiveCellPosition,resetActiveCell:resetActiveCell,editActiveCell:makeActiveCellEditable,getCellEditor:getCellEditor,getCellNode:getCellNode,getCellNodeBox:getCellNodeBox,canCellBeSelected:canCellBeSelected,canCellBeActive:canCellBeActive,navigatePrev:navigatePrev,navigateNext:navigateNext,navigateUp:navigateUp,navigateDown:navigateDown,navigateLeft:navigateLeft,navigateRight:navigateRight,navigatePageUp:navigatePageUp,navigatePageDown:navigatePageDown,navigateTop:navigateTop,navigateBottom:navigateBottom,navigateRowStart:navigateRowStart,navigateRowEnd:navigateRowEnd,gotoCell:gotoCell,getTopPanel:getTopPanel,setTopPanelVisibility:setTopPanelVisibility,getPreHeaderPanel:getPreHeaderPanel,setPreHeaderPanelVisibility:setPreHeaderPanelVisibility,getHeader:getHeader,getHeaderColumn:getHeaderColumn,setHeaderRowVisibility:setHeaderRowVisibility,getHeaderRow:getHeaderRow,getHeaderRowColumn:getHeaderRowColumn,setFooterRowVisibility:setFooterRowVisibility,getFooterRow:getFooterRow,getFooterRowColumn:getFooterRowColumn,getGridPosition:getGridPosition,flashCell:flashCell,addCellCssStyles:addCellCssStyles,setCellCssStyles:setCellCssStyles,removeCellCssStyles:removeCellCssStyles,getCellCssStyles:getCellCssStyles,init:finishInitialization,destroy:destroy,getEditorLock:getEditorLock,getEditController:getEditController}),init()}module.exports={Grid:SlickGrid}},462:function(e,t,n){t.exports="undefined"!=typeof $?$:e(454)},463:function(e,t,n){var o=e(464),r=o.template;function i(e,t,n){return r(e,t,n)}i._=o,t.exports=i,"function"==typeof define&&define.amd?define(function(){return i}):"undefined"==typeof window&&"undefined"==typeof navigator||(window.UnderscoreTemplate=i)},464:function(e,t,n){
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var o={},r=Array.prototype,i=Object.prototype,l=r.slice,a=i.toString,s=i.hasOwnProperty,c=r.forEach,u=Object.keys,d=Array.isArray,p=function(){},f=p.each=p.forEach=function(e,t,n){if(null!=e)if(c&&e.forEach===c)e.forEach(t,n);else if(e.length===+e.length){for(var r=0,i=e.length;r<i;r++)if(t.call(n,e[r],r,e)===o)return}else{var l=p.keys(e);for(r=0,i=l.length;r<i;r++)if(t.call(n,e[l[r]],l[r],e)===o)return}};p.keys=u||function(e){if(e!==Object(e))throw new TypeError("Invalid object");var t=[];for(var n in e)p.has(e,n)&&t.push(n);return t},p.defaults=function(e){return f(l.call(arguments,1),function(t){if(t)for(var n in t)void 0===e[n]&&(e[n]=t[n])}),e},p.isArray=d||function(e){return"[object Array]"===a.call(e)},p.has=function(e,t){if(!p.isArray(t))return null!=e&&s.call(e,t);for(var n=t.length,o=0;o<n;o++){var r=t[o];if(null==e||!s.call(e,r))return!1;e=e[r]}return!!n};var h={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"}},g={escape:new RegExp("["+p.keys(h.escape).join("")+"]","g")};p.each(["escape"],function(e){p[e]=function(t){return null==t?"":(""+t).replace(g[e],function(t){return h[e][t]})}}),p.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var m=/(.)^/,v={"'":"'","\\":"\\","\r":"r","\n":"n","\t":"t","\u2028":"u2028","\u2029":"u2029"},w=/\\|'|\r|\n|\t|\u2028|\u2029/g;p.template=function(e,t,n){var o;n=p.defaults({},n,p.templateSettings);var r=new RegExp([(n.escape||m).source,(n.interpolate||m).source,(n.evaluate||m).source].join("|")+"|$","g"),i=0,l="__p+='";e.replace(r,function(t,n,o,r,a){return l+=e.slice(i,a).replace(w,function(e){return"\\"+v[e]}),n&&(l+="'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'"),o&&(l+="'+\n((__t=("+o+"))==null?'':__t)+\n'"),r&&(l+="';\n"+r+"\n__p+='"),i=a+t.length,t}),l+="';\n",n.variable||(l="with(obj||{}){\n"+l+"}\n"),l="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+l+"return __p;\n";try{o=new Function(n.variable||"obj","_",l)}catch(e){throw e.source=l,e}if(t)return o(t,p);var a=function(e){return o.call(this,e,p)};return a.source="function("+(n.variable||"obj")+"){\n"+l+"}",a},t.exports=p}},0,0)});
//# sourceMappingURL=bokeh-tables.min.js.map