/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

class PropertyLister {
    private static final String XML_HEADER = "<?xml version=\"1.0\" ?>";
    private static final String PLIST_DTD = "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">";
    private static final String PLIST_TAG = "plist";
    private static final String PLIST_VERSION_ATTRIBUTE = "version";
    private static final String DICT_TAG = "dict";
    private static final String KEY_TAG = "key";
    private static final String ARRAY_TAG = "array";
    private static final String STRING_TAG = "string";
    PrintWriter writer;
    String indentSpaces = "  ";
    Stack<String> elements = new Stack();

    public PropertyLister(OutputStream output) throws UnsupportedEncodingException {
        OutputStreamWriter osw = new OutputStreamWriter(output, "UTF-8");
        this.writer = new PrintWriter(osw);
    }

    void writeStartDocument() {
        this.writer.println(XML_HEADER);
        this.writer.println(PLIST_DTD);
        this.writeStartElement(PLIST_TAG, PLIST_VERSION_ATTRIBUTE, "1.0");
    }

    void writeEndDocument() {
        this.writeEndElement();
        this.writer.flush();
        this.writer.close();
    }

    void writeStartElement(String element, String ... args) {
        this.emitIndent();
        this.writer.print("<" + element);
        for (int i = 0; i < args.length; i += 2) {
            String attr = args[i];
            String value = args[i + 1];
            this.writer.print(" " + attr + "=\"" + value + "\"");
        }
        this.writer.println(">");
        this.elements.push(element);
    }

    void writeStartElement(String element) {
        this.emitIndent();
        this.writer.println("<" + element + ">");
        this.elements.push(element);
    }

    void writeStartDictElement() {
        this.writeStartElement(DICT_TAG);
    }

    void writeStartArrayElement() {
        this.writeStartElement(ARRAY_TAG);
    }

    void writeEndElement() {
        this.emitOutdent();
        this.writer.println("</" + this.elements.pop() + ">");
    }

    void writeKey(String key) {
        this.emitSingle(KEY_TAG, key);
    }

    void writeString(String value) {
        this.emitSingle(STRING_TAG, value);
    }

    void writeBoolean(boolean value) {
        this.emitIndent();
        this.writer.println("<" + (value ? "true" : "false") + "/>");
    }

    void writeProperty(String property, String value) {
        this.writeKey(property);
        this.writeString(value);
    }

    private void emitSingle(String tag, String content) {
        this.emitIndent();
        this.writer.println("<" + tag + ">" + content + "</" + tag + ">");
    }

    private void emitIndent() {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.writer.print(this.indentSpaces);
        }
    }

    private void emitOutdent() {
        for (int i = 0; i < this.elements.size() - 1; ++i) {
            this.writer.print(this.indentSpaces);
        }
    }
}

