@page CHANGES-UNRELEASED Unreleased changes

This page contains changes that will end up in 2.5

Changes from version 2.4 which are relevant for users:
- Changes leading to incompatible behavior:
  - \ref RMSD, \ref PATHMSD, \ref PROPERTYMAP, \ref PCAVARS, \ref PCARMSD, \ref FIT_TO_TEMPLATE and \ref DIPOLE now automatically make molecules whole.
    In case you do not want them to do it, use NOPBC flag,
  - There is some subtle change in the installation layout (see below). There should be no visible effect, however it is now compulsory
    to set correctly the `LD_LIBRARY_PATH` variable for the linux executable to work correctly. The procedure has been tested well on OSX and Linux,
    but could give problems on other platform. Please report possible problems on the mailing list.

- New actions:
  - \ref PAMM
  - \ref HBPAMM_MATRIX
  - \ref HBPAMM_SH

- Changes in the eABF/DRR module (contributed by Haochuan Chen and Haohao Fu):
  - \ref DRR now supports the extended generalized ABF(egABF) method.
  - \ref DRR accepts different GRID options for CVs and extended variables.
  - The MAXFACTOR option is added in \ref DRR to control the factor of biasing force.
  - \ref drr_tool can calculate the divergence of gradients now. (Maybe useful for future pABF)
  - Fix conflicts of output files in multiple replicas.

- Changes in the EDS module:
  - \ref EDS implements Levenberg-Marquardt optimization in addition to previous gradient descent. 
  - \ref EDS no longer automatically increases prefactor for bias parameter updates. This results in more stable optimization for the cases tested.
  - \ref EDS now has a larger default RANGE parameter to go with these other changes.

- Other changes:
  - \ref EXTERNAL can now SCALE the input grid. This allows for more flexibility without modifying the grid file.
  - \ref ALPHABETA can now combine dihedrals with different coefficients
  - \ref CS2BACKBONE (isdb module) is now mpi parallelised in particular with DOSCORE and CAMSHIFT
  - \ref SAXS (isdb module) there is an additional implementation based on bessel functions that can be faster for large systems (new keyword BESSEL) 
  - Libmatheval is not used anymore. \ref MATHEVAL (and \ref CUSTOM) are still available
    but employ an internal implementation of the lepton library. There should be no observable difference
    except from the fact that lepton does not support some of the inverse and hyperbolic functions supported
    by matheval (easily writable as a function of the available ones). Notice that \ref MATHEVAL (and \ref CUSTOM)
    switching functions using the lepton library have been further optimized with respect to PLUMED 2.4.
    Finally, notice that it is possible to use asmjit to optimize performance (see \ref Lepton).
  - Implemented bash autocompletion, see \ref BashAutocompletion.
  - \ref MOLINFO now allows selecting atoms from chains with a numeric ID (see \issue{320}).
  - Removed the patch for GMX 5.1.4
  - \ref RMSD calculation has been optimized. This should positively affect the performances of CVs where
     many RMSDs are computed on small groups of atoms, such as secondary structure variables.

Changes from version 2.4 which are relevant for developers:
- Code has been cleanup up replacing a number of pointers with `std::unique_ptr`. All `delete` statements
  in the core parts of the code have been eliminated.
- Exceptions cannot be disabled (`--disable-cxx-exceptions` option has been removed from `./configure`).
- Every exception thrown in PLUMED now also writes its message on PLUMED log.
- The installation layout of shared libraries has been modified. In particular,
  `libplumed.so` links to `libplumedKernel.so` and `plumed` links to `libplumed.so`.
  This reduces considerably the size of the installed package. In addition, it allows
  using two-level namespace on OSX. Notice that this implies that on Linux one should
  always set the `LD_LIBRARY_PATH` flag to have a working executable.
- On OSX, `./configure` uses `clang++` as first choice among non-MPI compilers.
- Added `--enable-static-archive` to `./configure` to build a `libplumed.a` static library.
- Stop setting `DYLD_LIBRARY_PATH` in `sourceme.sh` and in modulefile. Notice that as of PLUMED v2.3.3
  it should not be needed.
- Coverage scan is not anymore contained in developer manual. It can be found in a separate repository
  `github.com/coverage-branch` (see \issue{348}). In addition, coverage for third-party libraries included in PLUMED
  is reported as well.
- It is not possible anymore to use `make install prefix=/path`. Prefix can only be changed during `./configure` (see \issue{332}).
- Exception class has been rewritten to allow more extensive messaged.
- A small number of header files in installed
- When launching `plumed`, flags `--no-mpi` and `--mpi` can appear multiple times. The last appearence is the effective one.
- Internal blas and lapack libraries updated to gromacs 2018.
- Choosing `./configure --prefix=$PWD` does not lead anymore to deletion of all header files.
- Runtime loader in `Plumed.c` now works also when linked without `-rdynamic` (that is, 
  its names are not exported). Notice that all the combinations are expected to
  work, that is: `Plumed.c` from <=2.4 or >=2.5 combined with libplumedKernel
  from <=2.4 or >=2.5. In order to achieve this the following changes are implemented:
  - libplumedKernel does not depend anymore on `Plumed.c`. This allows loading it even
    in cases where names in the loader are not visible. The relevant function needed
    to be compatible with `Plumed.c` <=2.4 are found using `dlsym`.
  - `Plumed.c` does not need anymore libplumedKernel to register itself, but rather
    searches the relevant functions using `dlsym`. In addition, if it is not able to
    load `libplumedKernel` since the latter is <=2.4 and needs `Plumed.c` to be visible,
    it just uses as a fallback `libplumed`, which should load properly.
- A copy of `plumed-runtime` is installed in `prefix/lib/plumed` and can be used for testing.
