/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2007 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Paul Chandler <pestilence669@php.net>                        |
  +----------------------------------------------------------------------+
*/

/* $Id: php_xrange.h 326860 2012-07-28 23:40:19Z felipe $ */

#ifndef PHP_XRANGE_H
#define PHP_XRANGE_H

#define PHP_XRANGE_EXTNAME "xrange"
#define PHP_XRANGE_VERSION "1.3.2"

#include "zend_interfaces.h" /* for "Iterator" interface */

extern zend_module_entry xrange_module_entry;
#define phpext_xrange_ptr &xrange_module_entry

/* attached to each XRangeIterator (local storage). it may look wasteful,
   using a mix of "long long" and floating point math... it is, but it's
   not the bottleneck. */
typedef struct _xrange_module_storage {
	zend_object obj; /* mandatory */

	int type;
	double low;
	double high;
	double step;

#if defined(PHP_WIN32) && _MSC_VER < 1300
	__int64 iterations;
	__int64 iteration;
#else
	long long iterations;
	long long iteration;
#endif
} xrange_module_storage;

#ifdef PHP_WIN32
#define PHP_XRANGE_API __declspec(dllexport)
#else
#define PHP_XRANGE_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

#define PHP_XRANGE_XRI_NAME "XRangeIterator"
#define PHP_XRANGE_ODDFILTERITERATOR_NAME "OddFilterIterator"
#define PHP_XRANGE_EVENFILTERITERATOR_NAME "EvenFilterIterator"
#define PHP_XRANGE_NUMERICFILTERITERATOR_NAME "NumericFilterIterator"

PHP_MINIT_FUNCTION(xrange);
PHP_MSHUTDOWN_FUNCTION(xrange);
PHP_MINFO_FUNCTION(xrange);

PHP_FUNCTION(xrange);
PHP_METHOD(PHP_XRANGE_XRI_NAME, __construct);
PHP_METHOD(PHP_XRANGE_XRI_NAME, current);
PHP_METHOD(PHP_XRANGE_XRI_NAME, key);
PHP_METHOD(PHP_XRANGE_XRI_NAME, next);
PHP_METHOD(PHP_XRANGE_XRI_NAME, rewind);
PHP_METHOD(PHP_XRANGE_XRI_NAME, valid);
PHP_METHOD(PHP_XRANGE_XRI_NAME, seek);
PHP_METHOD(PHP_XRANGE_XRI_NAME, count);
PHP_METHOD(PHP_XRANGE_XRI_NAME, __toString);

PHP_METHOD(PHP_XRANGE_ODDFILTERITERATOR_NAME, accept);
PHP_METHOD(PHP_XRANGE_EVENFILTERITERATOR_NAME, accept);
PHP_METHOD(PHP_XRANGE_NUMERICFILTERITERATOR_NAME, accept);

/* "typing saving" macro */
#define PHP_XRANGE_ZOS_GET (xrange_module_storage*) \
zend_object_store_get_object(getThis() TSRMLS_CC)

#endif /* PHP_XRANGE_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
