/* Generated by re2c 1.0.2 */
// 1 "scanner.re"

/*
  +------------------------------------------------------------------------+
  | Phalcon Framework													   |
  +------------------------------------------------------------------------+
  | Copyright (c) 2011-present Phalcon Team (http://www.phalconphp.com)    |
  +------------------------------------------------------------------------+
  | This source file is subject to the New BSD License that is bundled	   |
  | with this package in the file docs/LICENSE.txt.					       |
  |																		   |
  | If you did not receive a copy of the license and are unable to		   |
  | obtain it through the world-wide-web, please send an email			   |
  | to license@phalconphp.com so we can send you a copy immediately.	   |
  +------------------------------------------------------------------------+
  | Authors: Andres Gutierrez <andres@phalconphp.com>					   |
  |		  Eduar Carvajal <eduar@phalconphp.com>						       |
  +------------------------------------------------------------------------+
*/

#include "php_phalcon.h"
#include "scanner.h"

#define VVCTYPE unsigned char
#define VVCURSOR (s->start)
#define VVLIMIT (s->end)
#define VVMARKER q

void phvolt_rtrim(phvolt_scanner_token *token) {

	char *cursor, *removed_str;
	int i;
	char ch;

	if (token->len > 0) {

		cursor = token->value;
		cursor += (token->len - 1);
		for (i = token->len; i > 0; i--) {
			ch = (*cursor);
			if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ' || ch == '\v') {
				cursor--;
				continue;
			}
			break;
		}

		if (i >= 0) {
			removed_str = emalloc(i + 1);
			memcpy(removed_str, token->value, i);
			removed_str[i] = '\0';

			efree(token->value);
			token->value = removed_str;
			token->len = i;
		}
	}

}

void phvolt_ltrim(phvolt_scanner_token *token) {

	char *cursor, *removed_str;
	int i;

	if (token->len > 0) {

		cursor = token->value;
		for (i = 0; i < token->len; i++) {
			char ch = (*cursor);
			if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ' || ch == '\v') {
				cursor++;
				continue;
			}
			break;
		}

		if (i >= 0) {
			removed_str = emalloc(token->len - i + 1);
			memcpy(removed_str, token->value + i, token->len - i);
			removed_str[token->len - i] = '\0';

			efree(token->value);
			token->value = removed_str;
			token->len = token->len - i;
		}
	}

}

int phvolt_get_token(phvolt_scanner_state *s, phvolt_scanner_token *token) {

	unsigned char next, double_next;
	char *q = VVCURSOR, *start = VVCURSOR;
	int status = PHVOLT_SCANNER_RETCODE_IMPOSSIBLE;

	while (PHVOLT_SCANNER_RETCODE_IMPOSSIBLE == status) {

		if (s->mode == PHVOLT_MODE_RAW || s->mode == PHVOLT_MODE_COMMENT) {

			next = '\0';
			double_next = '\0';

			if (*VVCURSOR == '\n') {
				s->active_line++;
			}

			if (*VVCURSOR != '\0') {
				next = *(VVCURSOR + 1);
				if (next != '\0') {
					double_next = *(VVCURSOR + 2);
				}
			}

			if (*VVCURSOR == '\0' || (*VVCURSOR == '{' && (next == '%' || next == '{' || next == '#'))) {

				if (next != '#') {

					s->mode = PHVOLT_MODE_CODE;

					if (s->raw_buffer_cursor > 0) {

						token->opcode = PHVOLT_T_RAW_FRAGMENT;
						token->value = emalloc(sizeof(char) * s->raw_buffer_cursor + 1);
						memcpy(token->value, s->raw_buffer, s->raw_buffer_cursor);
						token->value[s->raw_buffer_cursor] = 0;
						token->len = s->raw_buffer_cursor;

						if (s->whitespace_control == 1) {
							phvolt_ltrim(token);
							s->whitespace_control = 0;
						}

						if (double_next == '-') {
							phvolt_rtrim(token);
						}

						s->raw_buffer_cursor = 0;
						q = VVCURSOR;
					} else {
						token->opcode = PHVOLT_T_IGNORE;
					}

				} else {

					while ((next = *(++VVCURSOR))) {
						if (next == '#' && *(VVCURSOR + 1) == '}') {
							VVCURSOR += 2;
							token->opcode = PHVOLT_T_IGNORE;
							return 0;
						} else {
							if (next == '\n') {
								s->active_line++;
							}
						}
					}

					return PHVOLT_SCANNER_RETCODE_EOF;
				}

				return 0;

			} else {

				if (s->raw_buffer_cursor == s->raw_buffer_size) {
					s->raw_buffer_size += PHVOLT_RAW_BUFFER_SIZE;
					s->raw_buffer = erealloc(s->raw_buffer, s->raw_buffer_size);
				}

				memcpy(s->raw_buffer+s->raw_buffer_cursor, VVCURSOR, 1);
				s->raw_buffer_cursor++;

				++VVCURSOR;
			}

		} else {

		
// 181 "scanner.c"
		{
			VVCTYPE vvch;
			unsigned int vvaccept = 0;
			vvch = *VVCURSOR;
			switch (vvch) {
			case 0x00:	goto vv2;
			case '\t':
			case '\r':
			case ' ':	goto vv6;
			case '\n':	goto vv9;
			case '!':	goto vv11;
			case '"':	goto vv13;
			case '%':	goto vv14;
			case '\'':	goto vv16;
			case '(':	goto vv17;
			case ')':	goto vv19;
			case '*':	goto vv21;
			case '+':	goto vv23;
			case ',':	goto vv25;
			case '-':	goto vv27;
			case '.':	goto vv29;
			case '/':	goto vv31;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv33;
			case ':':	goto vv36;
			case '<':	goto vv38;
			case '=':	goto vv40;
			case '>':	goto vv42;
			case '?':	goto vv44;
			case 'A':
			case 'a':	goto vv46;
			case 'B':
			case 'b':	goto vv48;
			case 'C':
			case 'c':	goto vv49;
			case 'D':
			case 'd':	goto vv50;
			case 'E':
			case 'e':	goto vv51;
			case 'F':
			case 'f':	goto vv52;
			case 'G':
			case 'H':
			case 'J':
			case 'K':
			case 'L':
			case 'P':
			case 'Q':
			case 'U':
			case 'V':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'g':
			case 'h':
			case 'j':
			case 'k':
			case 'l':
			case 'p':
			case 'q':
			case 'u':
			case 'v':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			case 'I':	goto vv55;
			case 'M':
			case 'm':	goto vv56;
			case 'N':
			case 'n':	goto vv57;
			case 'O':
			case 'o':	goto vv58;
			case 'R':
			case 'r':	goto vv59;
			case 'S':
			case 's':	goto vv60;
			case 'T':
			case 't':	goto vv61;
			case 'W':
			case 'w':	goto vv62;
			case '[':	goto vv63;
			case '\\':	goto vv65;
			case ']':	goto vv66;
			case 'i':	goto vv68;
			case '{':	goto vv69;
			case '|':	goto vv71;
			case '}':	goto vv73;
			case '~':	goto vv75;
			default:	goto vv4;
			}
vv2:
			++VVCURSOR;
// 722 "scanner.re"
			{
			status = PHVOLT_SCANNER_RETCODE_EOF;
			break;
		}
// 288 "scanner.c"
vv4:
			++VVCURSOR;
vv5:
// 727 "scanner.re"
			{
			status = PHVOLT_SCANNER_RETCODE_ERR;
			break;
		}
// 297 "scanner.c"
vv6:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '\t':
			case '\r':
			case ' ':	goto vv6;
			default:	goto vv8;
			}
vv8:
// 711 "scanner.re"
			{
			token->opcode = PHVOLT_T_IGNORE;
			return 0;
		}
// 312 "scanner.c"
vv9:
			++VVCURSOR;
// 716 "scanner.re"
			{
			s->active_line++;
			token->opcode = PHVOLT_T_IGNORE;
			return 0;
		}
// 321 "scanner.c"
vv11:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '=':	goto vv77;
			default:	goto vv12;
			}
vv12:
// 681 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOT;
			return 0;
		}
// 334 "scanner.c"
vv13:
			vvaccept = 0;
			vvch = *(VVMARKER = ++VVCURSOR);
			if (vvch <= 0x00) goto vv5;
			goto vv80;
vv14:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '}':	goto vv85;
			default:	goto vv15;
			}
vv15:
// 556 "scanner.re"
			{
			token->opcode = PHVOLT_T_MOD;
			return 0;
		}
// 352 "scanner.c"
vv16:
			vvaccept = 0;
			vvch = *(VVMARKER = ++VVCURSOR);
			if (vvch <= 0x00) goto vv5;
			goto vv88;
vv17:
			++VVCURSOR;
// 591 "scanner.re"
			{
			token->opcode = PHVOLT_T_PARENTHESES_OPEN;
			return 0;
		}
// 365 "scanner.c"
vv19:
			++VVCURSOR;
// 596 "scanner.re"
			{
			token->opcode = PHVOLT_T_PARENTHESES_CLOSE;
			return 0;
		}
// 373 "scanner.c"
vv21:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '=':	goto vv90;
			default:	goto vv22;
			}
vv22:
// 546 "scanner.re"
			{
			token->opcode = PHVOLT_T_MUL;
			return 0;
		}
// 386 "scanner.c"
vv23:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '+':	goto vv92;
			case '=':	goto vv94;
			default:	goto vv24;
			}
vv24:
// 536 "scanner.re"
			{
			token->opcode = PHVOLT_T_ADD;
			return 0;
		}
// 400 "scanner.c"
vv25:
			++VVCURSOR;
// 586 "scanner.re"
			{
			token->opcode = PHVOLT_T_COMMA;
			return 0;
		}
// 408 "scanner.c"
vv27:
			vvaccept = 1;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case '%':	goto vv96;
			case '-':	goto vv97;
			case '=':	goto vv99;
			case '}':	goto vv101;
			default:	goto vv28;
			}
vv28:
// 541 "scanner.re"
			{
			token->opcode = PHVOLT_T_SUB;
			return 0;
		}
// 425 "scanner.c"
vv29:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '.':	goto vv102;
			default:	goto vv30;
			}
vv30:
// 581 "scanner.re"
			{
			token->opcode = PHVOLT_T_DOT;
			return 0;
		}
// 438 "scanner.c"
vv31:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '=':	goto vv104;
			default:	goto vv32;
			}
vv32:
// 551 "scanner.re"
			{
			token->opcode = PHVOLT_T_DIV;
			return 0;
		}
// 451 "scanner.c"
vv33:
			vvaccept = 2;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case '.':	goto vv106;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv33;
			default:	goto vv35;
			}
vv35:
// 182 "scanner.re"
			{
			token->opcode = PHVOLT_T_INTEGER;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 478 "scanner.c"
vv36:
			++VVCURSOR;
// 701 "scanner.re"
			{
			token->opcode = PHVOLT_T_COLON;
			return 0;
		}
// 486 "scanner.c"
vv38:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '=':	goto vv107;
			case '>':	goto vv109;
			default:	goto vv39;
			}
vv39:
// 686 "scanner.re"
			{
			token->opcode = PHVOLT_T_LESS;
			return 0;
		}
// 500 "scanner.c"
vv40:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '=':	goto vv111;
			default:	goto vv41;
			}
vv41:
// 626 "scanner.re"
			{
			token->opcode = PHVOLT_T_ASSIGN;
			return 0;
		}
// 513 "scanner.c"
vv42:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '=':	goto vv113;
			default:	goto vv43;
			}
vv43:
// 691 "scanner.re"
			{
			token->opcode = PHVOLT_T_GREATER;
			return 0;
		}
// 526 "scanner.c"
vv44:
			++VVCURSOR;
// 706 "scanner.re"
			{
			token->opcode = PHVOLT_T_QUESTION;
			return 0;
		}
// 534 "scanner.c"
vv46:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv115;
			case 'U':
			case 'u':	goto vv116;
			default:	goto vv54;
			}
vv47:
// 528 "scanner.re"
			{
			token->opcode = PHVOLT_T_IDENTIFIER;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 553 "scanner.c"
vv48:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv117;
			case 'R':
			case 'r':	goto vv118;
			default:	goto vv54;
			}
vv49:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv119;
			case 'O':
			case 'o':	goto vv120;
			default:	goto vv54;
			}
vv50:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv121;
			case 'O':
			case 'o':	goto vv122;
			default:	goto vv54;
			}
vv51:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv124;
			case 'M':
			case 'm':	goto vv125;
			case 'N':
			case 'n':	goto vv126;
			case 'V':
			case 'v':	goto vv127;
			case 'X':
			case 'x':	goto vv128;
			default:	goto vv54;
			}
vv52:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv129;
			case 'O':
			case 'o':	goto vv130;
			default:	goto vv54;
			}
vv53:
			vvch = *++VVCURSOR;
vv54:
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv47;
			}
vv55:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv131;
			case 'N':
			case 'n':	goto vv133;
			case 'S':
			case 's':	goto vv135;
			case 'T':
			case 't':	goto vv137;
			default:	goto vv54;
			}
vv56:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv138;
			default:	goto vv54;
			}
vv57:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv139;
			case 'U':
			case 'u':	goto vv140;
			default:	goto vv54;
			}
vv58:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv141;
			case 'R':
			case 'r':	goto vv142;
			default:	goto vv54;
			}
vv59:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv144;
			case 'E':
			case 'e':	goto vv145;
			default:	goto vv54;
			}
vv60:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv146;
			case 'E':
			case 'e':	goto vv147;
			case 'W':
			case 'w':	goto vv148;
			default:	goto vv54;
			}
vv61:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv149;
			default:	goto vv54;
			}
vv62:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv150;
			default:	goto vv54;
			}
vv63:
			++VVCURSOR;
// 601 "scanner.re"
			{
			token->opcode = PHVOLT_T_SBRACKET_OPEN;
			return 0;
		}
// 754 "scanner.c"
vv65:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv5;
			}
vv66:
			++VVCURSOR;
// 606 "scanner.re"
			{
			token->opcode = PHVOLT_T_SBRACKET_CLOSE;
			return 0;
		}
// 820 "scanner.c"
vv68:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv131;
			case 'N':
			case 'n':	goto vv133;
			case 'S':	goto vv135;
			case 'T':
			case 't':	goto vv137;
			case 's':	goto vv151;
			default:	goto vv54;
			}
vv69:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '%':	goto vv152;
			case '{':	goto vv154;
			default:	goto vv70;
			}
vv70:
// 611 "scanner.re"
			{
			token->opcode = PHVOLT_T_CBRACKET_OPEN;
			return 0;
		}
// 847 "scanner.c"
vv71:
			++VVCURSOR;
// 696 "scanner.re"
			{
			token->opcode = PHVOLT_T_PIPE;
			return 0;
		}
// 855 "scanner.c"
vv73:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '}':	goto vv156;
			default:	goto vv74;
			}
vv74:
// 616 "scanner.re"
			{
			token->opcode = PHVOLT_T_CBRACKET_CLOSE;
			return 0;
		}
// 868 "scanner.c"
vv75:
			++VVCURSOR;
// 571 "scanner.re"
			{
			token->opcode = PHVOLT_T_CONCAT;
			return 0;
		}
// 876 "scanner.c"
vv77:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '=':	goto vv158;
			default:	goto vv78;
			}
vv78:
// 661 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 889 "scanner.c"
vv79:
			vvch = *++VVCURSOR;
vv80:
			switch (vvch) {
			case 0x00:	goto vv81;
			case '"':	goto vv82;
			case '\\':	goto vv84;
			default:	goto vv79;
			}
vv81:
			VVCURSOR = VVMARKER;
			switch (vvaccept) {
			case 0: 	goto vv5;
			case 1: 	goto vv28;
			case 2: 	goto vv35;
			default:	goto vv136;
			}
vv82:
			++VVCURSOR;
// 519 "scanner.re"
			{
			token->opcode = PHVOLT_T_STRING;
			token->value = estrndup(q, VVCURSOR - q - 1);
			token->len = VVCURSOR - q - 1;
			q = VVCURSOR;
			return 0;
		}
// 917 "scanner.c"
vv84:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '\n':	goto vv81;
			default:	goto vv79;
			}
vv85:
			++VVCURSOR;
// 472 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			token->opcode = PHVOLT_T_CLOSE_DELIMITER;
			return 0;
		}
// 932 "scanner.c"
vv87:
			vvch = *++VVCURSOR;
vv88:
			switch (vvch) {
			case 0x00:	goto vv81;
			case '\'':	goto vv82;
			case '\\':	goto vv89;
			default:	goto vv87;
			}
vv89:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '\n':	goto vv81;
			default:	goto vv87;
			}
vv90:
			++VVCURSOR;
// 641 "scanner.re"
			{
			token->opcode = PHVOLT_T_MUL_ASSIGN;
			return 0;
		}
// 955 "scanner.c"
vv92:
			++VVCURSOR;
// 561 "scanner.re"
			{
			token->opcode = PHVOLT_T_INCR;
			return 0;
		}
// 963 "scanner.c"
vv94:
			++VVCURSOR;
// 631 "scanner.re"
			{
			token->opcode = PHVOLT_T_ADD_ASSIGN;
			return 0;
		}
// 971 "scanner.c"
vv96:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '}':	goto vv160;
			default:	goto vv81;
			}
vv97:
			++VVCURSOR;
// 566 "scanner.re"
			{
			token->opcode = PHVOLT_T_DECR;
			return 0;
		}
// 985 "scanner.c"
vv99:
			++VVCURSOR;
// 636 "scanner.re"
			{
			token->opcode = PHVOLT_T_SUB_ASSIGN;
			return 0;
		}
// 993 "scanner.c"
vv101:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '}':	goto vv162;
			default:	goto vv81;
			}
vv102:
			++VVCURSOR;
// 576 "scanner.re"
			{
			token->opcode = PHVOLT_T_RANGE;
			return 0;
		}
// 1007 "scanner.c"
vv104:
			++VVCURSOR;
// 646 "scanner.re"
			{
			token->opcode = PHVOLT_T_DIV_ASSIGN;
			return 0;
		}
// 1015 "scanner.c"
vv106:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv164;
			default:	goto vv81;
			}
vv107:
			++VVCURSOR;
// 621 "scanner.re"
			{
			token->opcode = PHVOLT_T_LESSEQUAL;
			return 0;
		}
// 1038 "scanner.c"
vv109:
			++VVCURSOR;
// 666 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 1046 "scanner.c"
vv111:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '=':	goto vv167;
			default:	goto vv112;
			}
vv112:
// 656 "scanner.re"
			{
			token->opcode = PHVOLT_T_EQUALS;
			return 0;
		}
// 1059 "scanner.c"
vv113:
			++VVCURSOR;
// 651 "scanner.re"
			{
			token->opcode = PHVOLT_T_GREATEREQUAL;
			return 0;
		}
// 1067 "scanner.c"
vv115:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv169;
			default:	goto vv54;
			}
vv116:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv171;
			default:	goto vv54;
			}
vv117:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv172;
			default:	goto vv54;
			}
vv118:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv173;
			default:	goto vv54;
			}
vv119:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv174;
			case 'L':
			case 'l':	goto vv175;
			case 'S':
			case 's':	goto vv176;
			default:	goto vv54;
			}
vv120:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv177;
			default:	goto vv54;
			}
vv121:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv178;
			default:	goto vv54;
			}
vv122:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv123;
			}
vv123:
// 424 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_DO;
			return 0;
		}
// 1197 "scanner.c"
vv124:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv179;
			default:	goto vv54;
			}
vv125:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv180;
			default:	goto vv54;
			}
vv126:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv181;
			default:	goto vv54;
			}
vv127:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv182;
			default:	goto vv54;
			}
vv128:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv183;
			default:	goto vv54;
			}
vv129:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv184;
			default:	goto vv54;
			}
vv130:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv185;
			default:	goto vv54;
			}
vv131:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv132;
			}
vv132:
// 199 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_IF;
			return 0;
		}
// 1323 "scanner.c"
vv133:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			case 'C':
			case 'c':	goto vv187;
			default:	goto vv134;
			}
vv134:
// 257 "scanner.re"
			{
			token->opcode = PHVOLT_T_IN;
			return 0;
		}
// 1399 "scanner.c"
vv135:
			vvaccept = 3;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case ' ':	goto vv188;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv136;
			}
vv136:
// 353 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_IS;
			return 0;
		}
// 1478 "scanner.c"
vv137:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv189;
			default:	goto vv54;
			}
vv138:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv190;
			default:	goto vv54;
			}
vv139:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv191;
			default:	goto vv54;
			}
vv140:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv193;
			case 'M':
			case 'm':	goto vv194;
			default:	goto vv54;
			}
vv141:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv195;
			default:	goto vv54;
			}
vv142:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv143;
			}
vv143:
// 287 "scanner.re"
			{
			token->opcode = PHVOLT_T_OR;
			return 0;
		}
// 1591 "scanner.c"
vv144:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'W':
			case 'w':	goto vv197;
			default:	goto vv54;
			}
vv145:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv199;
			default:	goto vv54;
			}
vv146:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv200;
			default:	goto vv54;
			}
vv147:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv201;
			default:	goto vv54;
			}
vv148:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv203;
			default:	goto vv54;
			}
vv149:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv204;
			default:	goto vv54;
			}
vv150:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv205;
			default:	goto vv54;
			}
vv151:
			vvaccept = 3;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case ' ':	goto vv206;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv136;
			}
vv152:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '-':	goto vv207;
			default:	goto vv153;
			}
vv153:
// 466 "scanner.re"
			{
			s->whitespace_control = 0;
			token->opcode = PHVOLT_T_OPEN_DELIMITER;
			return 0;
		}
// 1725 "scanner.c"
vv154:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '-':	goto vv209;
			default:	goto vv155;
			}
vv155:
// 491 "scanner.re"
			{
			s->whitespace_control = 0;
			s->statement_position++;
			token->opcode = PHVOLT_T_OPEN_EDELIMITER;
			return 0;
		}
// 1740 "scanner.c"
vv156:
			++VVCURSOR;
// 498 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			token->opcode = PHVOLT_T_CLOSE_EDELIMITER;
			return 0;
		}
// 1749 "scanner.c"
vv158:
			++VVCURSOR;
// 676 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTIDENTICAL;
			return 0;
		}
// 1757 "scanner.c"
vv160:
			++VVCURSOR;
// 484 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			s->whitespace_control = 1;
			token->opcode = PHVOLT_T_CLOSE_DELIMITER;
			return 0;
		}
// 1767 "scanner.c"
vv162:
			++VVCURSOR;
// 511 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			s->whitespace_control = 1;
			token->opcode = PHVOLT_T_CLOSE_EDELIMITER;
			return 0;
		}
// 1777 "scanner.c"
vv164:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv164;
			default:	goto vv166;
			}
vv166:
// 191 "scanner.re"
			{
			token->opcode = PHVOLT_T_DOUBLE;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 1802 "scanner.c"
vv167:
			++VVCURSOR;
// 671 "scanner.re"
			{
			token->opcode = PHVOLT_T_IDENTICAL;
			return 0;
		}
// 1810 "scanner.c"
vv169:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv170;
			}
vv170:
// 282 "scanner.re"
			{
			token->opcode = PHVOLT_T_AND;
			return 0;
		}
// 1886 "scanner.c"
vv171:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv211;
			default:	goto vv54;
			}
vv172:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv212;
			default:	goto vv54;
			}
vv173:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv213;
			default:	goto vv54;
			}
vv174:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv214;
			default:	goto vv54;
			}
vv175:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv215;
			default:	goto vv54;
			}
vv176:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv217;
			default:	goto vv54;
			}
vv177:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv219;
			default:	goto vv54;
			}
vv178:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv220;
			case 'I':
			case 'i':	goto vv221;
			default:	goto vv54;
			}
vv179:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv222;
			default:	goto vv54;
			}
vv180:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv224;
			default:	goto vv54;
			}
vv181:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv225;
			case 'B':
			case 'b':	goto vv226;
			case 'C':
			case 'c':	goto vv227;
			case 'F':
			case 'f':	goto vv228;
			case 'I':
			case 'i':	goto vv229;
			case 'M':
			case 'm':	goto vv230;
			case 'R':
			case 'r':	goto vv231;
			case 'S':
			case 's':	goto vv232;
			default:	goto vv54;
			}
vv182:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv233;
			default:	goto vv54;
			}
vv183:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv235;
			default:	goto vv54;
			}
vv184:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv236;
			default:	goto vv54;
			}
vv185:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv186;
			}
vv186:
// 225 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_FOR;
			return 0;
		}
// 2077 "scanner.c"
vv187:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv237;
			default:	goto vv54;
			}
vv188:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv238;
			default:	goto vv81;
			}
vv189:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv239;
			default:	goto vv54;
			}
vv190:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv240;
			default:	goto vv54;
			}
vv191:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv192;
			}
vv192:
// 359 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOT;
			return 0;
		}
// 2182 "scanner.c"
vv193:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv241;
			default:	goto vv54;
			}
vv194:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv243;
			default:	goto vv54;
			}
vv195:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv196;
			}
vv196:
// 389 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ODD;
			return 0;
		}
// 2273 "scanner.c"
vv197:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv198;
			}
vv198:
// 454 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_RAW;
			return 0;
		}
// 2350 "scanner.c"
vv199:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv244;
			default:	goto vv54;
			}
vv200:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv245;
			default:	goto vv54;
			}
vv201:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv202;
			}
vv202:
// 262 "scanner.re"
			{
			token->opcode = PHVOLT_T_SET;
			return 0;
		}
// 2440 "scanner.c"
vv203:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv246;
			default:	goto vv54;
			}
vv204:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv247;
			default:	goto vv54;
			}
vv205:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv249;
			default:	goto vv54;
			}
vv206:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv238;
			default:	goto vv252;
			}
vv207:
			++VVCURSOR;
// 478 "scanner.re"
			{
			s->whitespace_control = 0;
			token->opcode = PHVOLT_T_OPEN_DELIMITER;
			return 0;
		}
// 2477 "scanner.c"
vv209:
			++VVCURSOR;
// 504 "scanner.re"
			{
			s->whitespace_control = 0;
			s->statement_position++;
			token->opcode = PHVOLT_T_OPEN_EDELIMITER;
			return 0;
		}
// 2487 "scanner.c"
vv211:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv253;
			default:	goto vv54;
			}
vv212:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv254;
			default:	goto vv54;
			}
vv213:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv256;
			default:	goto vv54;
			}
vv214:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv258;
			default:	goto vv54;
			}
vv215:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv216;
			}
vv216:
// 314 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CALL;
			return 0;
		}
// 2592 "scanner.c"
vv217:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv218;
			}
vv218:
// 242 "scanner.re"
			{
			token->opcode = PHVOLT_T_CASE;
			return 0;
		}
// 2668 "scanner.c"
vv219:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv260;
			default:	goto vv54;
			}
vv220:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv261;
			default:	goto vv54;
			}
vv221:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv262;
			default:	goto vv54;
			}
vv222:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'G':
			case 'H':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'g':
			case 'h':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			case 'F':
			case 'f':	goto vv263;
			case 'I':
			case 'i':	goto vv264;
			default:	goto vv223;
			}
vv223:
// 205 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSE;
			return 0;
		}
// 2765 "scanner.c"
vv224:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'Y':
			case 'y':	goto vv265;
			default:	goto vv54;
			}
vv225:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv267;
			default:	goto vv54;
			}
vv226:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv268;
			default:	goto vv54;
			}
vv227:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv269;
			default:	goto vv54;
			}
vv228:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv270;
			default:	goto vv54;
			}
vv229:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv271;
			default:	goto vv54;
			}
vv230:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv273;
			default:	goto vv54;
			}
vv231:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv274;
			default:	goto vv54;
			}
vv232:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'W':
			case 'w':	goto vv275;
			default:	goto vv54;
			}
vv233:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv234;
			}
vv234:
// 383 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EVEN;
			return 0;
		}
// 2905 "scanner.c"
vv235:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv276;
			default:	goto vv54;
			}
vv236:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv277;
			default:	goto vv54;
			}
vv237:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv279;
			default:	goto vv54;
			}
vv238:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv280;
			default:	goto vv81;
			}
vv239:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv281;
			default:	goto vv54;
			}
vv240:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv282;
			default:	goto vv54;
			}
vv241:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv242;
			}
vv242:
// 267 "scanner.re"
			{
			token->opcode = PHVOLT_T_NULL;
			return 0;
		}
// 3023 "scanner.c"
vv243:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv284;
			default:	goto vv54;
			}
vv244:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv285;
			default:	goto vv54;
			}
vv245:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv286;
			default:	goto vv54;
			}
vv246:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv287;
			default:	goto vv54;
			}
vv247:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv248;
			}
vv248:
// 277 "scanner.re"
			{
			token->opcode = PHVOLT_T_TRUE;
			return 0;
		}
// 3127 "scanner.c"
vv249:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv250;
			}
vv250:
// 325 "scanner.re"
			{
			token->opcode = PHVOLT_T_WITH;
			return 0;
		}
// 3203 "scanner.c"
vv251:
			vvch = *++VVCURSOR;
vv252:
			switch (vvch) {
			case ' ':	goto vv251;
			case 'n':	goto vv288;
			default:	goto vv81;
			}
vv253:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv289;
			default:	goto vv54;
			}
vv254:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv255;
			}
vv255:
// 292 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_BLOCK;
			return 0;
		}
// 3295 "scanner.c"
vv256:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv257;
			}
vv257:
// 448 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_BREAK;
			return 0;
		}
// 3372 "scanner.c"
vv258:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv259;
			}
vv259:
// 413 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CACHE;
			return 0;
		}
// 3449 "scanner.c"
vv260:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv290;
			default:	goto vv54;
			}
vv261:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv291;
			default:	goto vv54;
			}
vv262:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv292;
			default:	goto vv54;
			}
vv263:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv293;
			default:	goto vv54;
			}
vv264:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv294;
			default:	goto vv54;
			}
vv265:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv266;
			}
vv266:
// 377 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EMPTY;
			return 0;
		}
// 3561 "scanner.c"
vv267:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv296;
			default:	goto vv54;
			}
vv268:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv297;
			default:	goto vv54;
			}
vv269:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv298;
			case 'L':
			case 'l':	goto vv299;
			default:	goto vv54;
			}
vv270:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv300;
			default:	goto vv54;
			}
vv271:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv272;
			}
vv272:
// 220 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDIF;
			return 0;
		}
// 3667 "scanner.c"
vv273:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv302;
			default:	goto vv54;
			}
vv274:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'W':
			case 'w':	goto vv303;
			default:	goto vv54;
			}
vv275:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv305;
			default:	goto vv54;
			}
vv276:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv306;
			default:	goto vv54;
			}
vv277:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv278;
			}
vv278:
// 272 "scanner.re"
			{
			token->opcode = PHVOLT_T_FALSE;
			return 0;
		}
// 3771 "scanner.c"
vv279:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv307;
			default:	goto vv54;
			}
vv280:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv308;
			default:	goto vv81;
			}
vv281:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'B':
			case 'b':	goto vv310;
			default:	goto vv54;
			}
vv282:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv283;
			}
vv283:
// 303 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_MACRO;
			return 0;
		}
// 3869 "scanner.c"
vv284:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv311;
			default:	goto vv54;
			}
vv285:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv312;
			default:	goto vv54;
			}
vv286:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv314;
			default:	goto vv54;
			}
vv287:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv316;
			default:	goto vv54;
			}
vv288:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'o':	goto vv318;
			default:	goto vv81;
			}
vv289:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv319;
			default:	goto vv54;
			}
vv290:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv320;
			default:	goto vv54;
			}
vv291:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv321;
			default:	goto vv54;
			}
vv292:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv323;
			default:	goto vv54;
			}
vv293:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv325;
			default:	goto vv54;
			}
vv294:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv295;
			}
vv295:
// 215 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSEIF;
			return 0;
		}
// 4014 "scanner.c"
vv296:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv327;
			default:	goto vv54;
			}
vv297:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv328;
			default:	goto vv54;
			}
vv298:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv329;
			default:	goto vv54;
			}
vv299:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv330;
			default:	goto vv54;
			}
vv300:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv301;
			}
vv301:
// 231 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDFOR;
			return 0;
		}
// 4118 "scanner.c"
vv302:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv332;
			default:	goto vv54;
			}
vv303:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv304;
			}
vv304:
// 460 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ENDRAW;
			return 0;
		}
// 4202 "scanner.c"
vv305:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv333;
			default:	goto vv54;
			}
vv306:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv334;
			default:	goto vv54;
			}
vv307:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv336;
			default:	goto vv54;
			}
vv308:
			++VVCURSOR;
// 341 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 4232 "scanner.c"
vv310:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv338;
			default:	goto vv54;
			}
vv311:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv339;
			default:	goto vv54;
			}
vv312:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv313;
			}
vv313:
// 330 "scanner.re"
			{
			token->opcode = PHVOLT_T_RETURN;
			return 0;
		}
// 4322 "scanner.c"
vv314:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv315;
			}
vv315:
// 401 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_SCALAR;
			return 0;
		}
// 4399 "scanner.c"
vv316:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv317;
			}
vv317:
// 236 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_SWITCH;
			return 0;
		}
// 4476 "scanner.c"
vv318:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 't':	goto vv341;
			default:	goto vv81;
			}
vv319:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv343;
			default:	goto vv54;
			}
vv320:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv344;
			default:	goto vv54;
			}
vv321:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv322;
			}
vv322:
// 247 "scanner.re"
			{
			token->opcode = PHVOLT_T_DEFAULT;
			return 0;
		}
// 4572 "scanner.c"
vv323:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv324;
			}
vv324:
// 365 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_DEFINED;
			return 0;
		}
// 4649 "scanner.c"
vv325:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv326;
			}
vv326:
// 210 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSEFOR;
			return 0;
		}
// 4725 "scanner.c"
vv327:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv346;
			default:	goto vv54;
			}
vv328:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv347;
			default:	goto vv54;
			}
vv329:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv349;
			default:	goto vv54;
			}
vv330:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv331;
			}
vv331:
// 320 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDCALL;
			return 0;
		}
// 4822 "scanner.c"
vv332:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv351;
			default:	goto vv54;
			}
vv333:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv353;
			default:	goto vv54;
			}
vv334:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv335;
			}
vv335:
// 335 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EXTENDS;
			return 0;
		}
// 4913 "scanner.c"
vv336:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv337;
			}
vv337:
// 371 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_INCLUDE;
			return 0;
		}
// 4990 "scanner.c"
vv338:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv354;
			default:	goto vv54;
			}
vv339:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv340;
			}
vv340:
// 395 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NUMERIC;
			return 0;
		}
// 5074 "scanner.c"
vv341:
			++VVCURSOR;
// 347 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 5083 "scanner.c"
vv343:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv356;
			default:	goto vv54;
			}
vv344:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv345;
			}
vv345:
// 442 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CONTINUE;
			return 0;
		}
// 5167 "scanner.c"
vv346:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv357;
			default:	goto vv54;
			}
vv347:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv348;
			}
vv348:
// 298 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDBLOCK;
			return 0;
		}
// 5250 "scanner.c"
vv349:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv350;
			}
vv350:
// 419 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDCACHE;
			return 0;
		}
// 5326 "scanner.c"
vv351:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv352;
			}
vv352:
// 309 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDMACRO;
			return 0;
		}
// 5402 "scanner.c"
vv353:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv358;
			default:	goto vv54;
			}
vv354:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv355;
			}
vv355:
// 407 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ITERABLE;
			return 0;
		}
// 5486 "scanner.c"
vv356:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv360;
			default:	goto vv54;
			}
vv357:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv362;
			default:	goto vv54;
			}
vv358:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv359;
			}
vv359:
// 252 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDSWITCH;
			return 0;
		}
// 5576 "scanner.c"
vv360:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv361;
			}
vv361:
// 430 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_AUTOESCAPE;
			return 0;
		}
// 5653 "scanner.c"
vv362:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv363;
			default:	goto vv54;
			}
vv363:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv364;
			default:	goto vv54;
			}
vv364:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv365;
			default:	goto vv54;
			}
vv365:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv53;
			default:	goto vv366;
			}
vv366:
// 436 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ENDAUTOESCAPE;
			return 0;
		}
// 5751 "scanner.c"
		}
// 732 "scanner.re"


		}
	}

	return status;
}
