#!/bin/sh

base_dir=./Mono.Security/Mono.Security

TLS_PATH=$TLS_PATH:$base_dir/Mono.Math:$base_dir/Mono.Math.Prime:$base_dir/Mono.Math.Prime.Generator
TLS_PATH=$TLS_PATH:$base_dir/Mono.Security:$base_dir/Mono.Security.Cryptography:$base_dir/Mono.Security.X509
TLS_PATH=$TLS_PATH:$base_dir/Mono.Security.Protocol.Tls
TLS_PATH=$TLS_PATH:$base_dir/Mono.Security.Protocol.Tls.Alerts:$base_dir/Mono.Security.Protocol.Tls.Handshake
TLS_PATH=$TLS_PATH:$base_dir/Mono.Security.Protocol.Tls.Handshake.Client:$base_dir/Mono.Security.Protocol.Tls.Handshake.Server

base_dir=./PostgreSql.Data.PgSqlClient/source

CLIENT_PATH=$base_dir/DbSchema:$base_dir/PgTypes:$base_dir/NPgClient
CLIENT_PATH=$CLIENT_PATH:$base_dir/Design/ParameterCollection

for dir in `echo ${TLS_PATH}:${CLIENT_PATH} | tr ":" " "`; do
    echo $dir
    for fi in `ls $dir/*.cs`;do
        dos2unix -U $fi
    done
done

dos2unix -U *.txt
dos2unix -U *.build
dos2unix -U *.bat
dos2unix -U *.html
