/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.NPgClient
{
	internal sealed class PgClientError
	{
		#region Fields

		private string	severity;
		private string	code;
		private string	message;			
		private string	detail;
		private string	hint;
		private string	where;
		private string	position;
		private string	file;
		private int		line;
		private string	routine;
		
		#endregion

		#region Properties

		public string Severity
		{
			get { return severity; }
			set { severity = value; }
		}
		
		public string Message
		{
			get { return message; }
			set { message = value; }
		}

		public string Code
		{
			get { return code; }
			set { code = value; }
		}

		public string Detail
		{
			get { return detail; }
			set { detail = value; }
		}

		public string Hint
		{
			get { return hint; }
			set { hint = value; }
		}

		public string Where
		{
			get { return where; }
			set { where = value; }
		}

		public string Position
		{
			get { return position; }
			set { position = value; }
		}

		public string File
		{
			get { return file; }
			set { file = value; }
		}

		public int Line
		{
			get { return line; }
			set { line = value; }
		}

		public string Routine
		{
			get { return routine; }
			set { routine = value; }
		}

		#endregion

		#region Constructors
		
		public PgClientError()
		{
		}

		public PgClientError(string message)
		{						
			this.message	= message;
		}

		public PgClientError(string severity, string code, string message)
		{
			this.severity	= severity;
			this.code		= code;
			this.message	= message;			
		}

		#endregion

		#region Methods

		#endregion
	}
}
