/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgUsersSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgUsersSchema() : base("Users")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_shadow");
		}

		public override void AddRestrictionColumns()
		{
			AddRestrictionColumn("pg_shadow.usename", "USER_NAME", null);			
		}

		public override void AddDataColumns()
		{
			AddDataColumn("pg_shadow.usecreatedb", "CREATE_DATABASE");
			AddDataColumn("pg_shadow.usesuper", "IS_SUPERUSER");
			AddDataColumn("pg_shadow.usecatupd", "UPDATE_SYSCATALOGS");
			AddDataColumn("pg_shadow.passwd", "PASSWORD");
			AddDataColumn("pg_shadow.useconfig", "CONFIGURATION");
		}

		public override void AddJoins()
		{
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_shadow.usename");
		}

		public override void AddWhereFilters()
		{			
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion
	}
}