#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.16';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 101 => 0x69 },
	'about' => { 447 => 'about' },
	'aboutcvterm' => { 439 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 439 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 439 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 439 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 439 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 108 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 453 => 'absPeakAudioFilePath' },
	'acceleration' => { 111 => 0x9404 },
	'accelerationtracking' => { 76 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 349 => 0x3 },
	'accelerometerx' => { 286 => 0x8d },
	'accelerometery' => { 286 => 0x8e },
	'accelerometerz' => { 286 => 0x8c },
	'accessoryserialnumber' => { 286 => 0x54 },
	'accessorytype' => { 286 => 0x53 },
	'acedemicfield' => { 443 => 'acedemicField' },
	'actionadvised' => { 119 => 0x2a },
	'activearea' => { 111 => 0xc68d },
	'actived-lighting' => { 202 => 0x22, 239 => 0x24 },
	'actived-lightingmode' => { 239 => 0x25 },
	'adaptervoltage' => { 125 => 0x407 },
	'addaspectratioinfo' => { 76 => 0x80e },
	'additionalmodelinformation' => { 439 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 76 => 0x80f, 77 => 0x11, 78 => 0x13, 81 => 0x14 },
	'address' => { 146 => 'Address' },
	'adjustmentmode' => { 356 => 0x15 },
	'adlbracketingstep' => { 220 => 0x883 },
	'adlbracketingtype' => { 220 => 0x884 },
	'adobe' => { 112 => 'Adobe' },
	'adultcontentwarning' => { 275 => 'AdultContentWarning', 446 => 'adultContentWarning' },
	'advancedfilter' => { 116 => 0x1201 },
	'advancedraw' => { 241 => 0x76a43203 },
	'advancedscenetype' => { 286 => 0x3d },
	'advisory' => { 451 => 'Advisory' },
	'ae_iso' => { 293 => 0x2, 294 => 0x4, 295 => 0x12 },
	'aeaperture' => { 293 => 0x1, 294 => 0x3, 295 => 0x11 },
	'aeaperturesteps' => { 293 => 0x8, 294 => 0xb },
	'aebautocancel' => { 76 => 0x104 },
	'aebbracketvalue' => { 70 => 0x11 },
	'aebracketingsteps' => { 219 => 0x174c, 220 => 0x87b, 228 => 0x1756 },
	'aebsequence' => { 76 => 0x105 },
	'aebsequenceautocancel' => { 74 => 0x9, 75 => 0x9, 77 => 0x8, 78 => 0x9, 81 => 0x9, 82 => 0x7 },
	'aebshotcount' => { 76 => 0x106 },
	'aebxv' => { 293 => 0x4, 294 => 0x6 },
	'aeerror' => { 294 => 0x8 },
	'aeexposuretime' => { 293 => 0x0, 294 => 0x2, 295 => 0x10 },
	'aelbutton' => { 168 => 0x45 },
	'aelexposureindicator' => { 168 => 0x51 },
	'aelock' => { 168 => 0x5b, 250 => '4.2', 259 => '4.2', 265 => 0x201, 320 => 0x48, 364 => 0x40, 365 => 0x40, 366 => [0x86,0x286] },
	'aelockbutton' => { 248 => '16.1', 250 => '4.1', 253 => '15.1', 254 => '16.1', 255 => '16.1', 257 => '30.1', 258 => '16.1', 259 => '4.1', 261 => '17.1', 263 => '17.1' },
	'aelockbuttonplusdials' => { 248 => '16.2', 257 => '32.1', 261 => '44.1' },
	'aelockformb-d80' => { 263 => '3.1' },
	'aemaxaperture' => { 293 => 0x9, 294 => 0x10, 295 => 0x1c },
	'aemaxaperture2' => { 293 => 0xa, 294 => 0x11, 295 => 0x1d },
	'aemeteringmode' => { 293 => 0xc },
	'aemeteringmode2' => { 293 => '13.1' },
	'aemeteringsegments' => { 171 => 0x628, 320 => 0x209 },
	'aemicroadjustment' => { 76 => 0x110 },
	'aeminaperture' => { 293 => 0xb, 294 => 0x12, 295 => 0x1e },
	'aeminexposuretime' => { 293 => 0x5, 294 => 0x13, 295 => 0x1f },
	'aeprogrammode' => { 293 => 0x6 },
	'aeprojectlink' => { 428 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 428 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 428 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 428 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 428 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 428 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 293 => 0xd },
	'aexv' => { 293 => 0x3, 294 => 0x5 },
	'af-cpriorityselection' => { 248 => '1.1', 249 => '1.1', 251 => '1.1', 252 => '1.1', 254 => '0.1', 255 => '0.1', 256 => '0.1', 257 => '1.1', 258 => '0.1', 261 => '1.1', 262 => '1.1' },
	'af-onbutton' => { 251 => '70.1', 252 => '70.1', 262 => '70.1' },
	'af-onformb-d10' => { 248 => '3.3', 257 => '3.2' },
	'af-onformb-d11' => { 258 => '2.2' },
	'af-onformb-d12' => { 261 => '50.1' },
	'af-spriorityselection' => { 248 => '1.2', 249 => '1.2', 251 => '1.4', 252 => '1.4', 256 => '0.2', 257 => '1.2', 258 => '0.2', 261 => '1.2', 262 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 248 => '2.1', 249 => '2.1', 251 => '78.3', 252 => '78.3', 257 => '2.1', 261 => '2.1', 262 => '78.3' },
	'afadjustment' => { 320 => 0x72, 329 => 0x267 },
	'afandmeteringbuttons' => { 76 => 0x701 },
	'afaperture' => { 198 => 0x5, 199 => 0x5 },
	'afareaheight' => { 177 => [0x1a,0x50] },
	'afareaillumination' => { 168 => 0x4b, 259 => '15.3' },
	'afareamode' => { 164 => 0x33, 168 => 0xe, 176 => 0x0, 177 => 0x5, 286 => 0xf, 346 => 0x1205, 357 => [0xa,0x3a], 364 => 0x11, 365 => 0x10, 366 => 0x24, 376 => 0xb043, 399 => 0x17 },
	'afareamodesetting' => { 250 => '11.1', 253 => '0.1', 259 => '16.1', 263 => '2.1', 376 => 0x201c },
	'afareas' => { 265 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 76 => 0x51b },
	'afareawidth' => { 177 => [0x18,0x4e] },
	'afareaxposition' => { 177 => [0x14,0x4a], 346 => 0x1203 },
	'afareaxposition1' => { 346 => 0x1201 },
	'afareayposition' => { 177 => [0x16,0x4c], 346 => 0x1204 },
	'afareayposition1' => { 346 => 0x1202 },
	'afassist' => { 74 => 0x5, 82 => 0x5, 168 => 0x48, 248 => '2.5', 250 => '0.2', 253 => '0.2', 254 => '1.1', 255 => '1.1', 256 => '1.3', 257 => '2.4', 258 => '1.3', 259 => '0.2', 261 => '2.4', 263 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 76 => 0x50e, 77 => 0x4, 78 => 0x5, 79 => 0x4, 80 => 0x4, 81 => 0x5 },
	'afassistlamp' => { 286 => 0x31 },
	'afbuttonpressed' => { 366 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 296 => 0x6 },
	'afduringliveview' => { 76 => 0x511 },
	'affinea' => { 422 => 'AffineA' },
	'affineb' => { 422 => 'AffineB' },
	'affinec' => { 422 => 'AffineC' },
	'affined' => { 422 => 'AffineD' },
	'affinetune' => { 178 => 0x0, 265 => 0x306 },
	'affinetuneadj' => { 178 => 0x2, 212 => 0x2d1, 213 => 0x2dc, 265 => 0x307 },
	'affinetuneindex' => { 178 => 0x1 },
	'affinex' => { 422 => 'AffineX' },
	'affiney' => { 422 => 'AffineY' },
	'afhold' => { 296 => 0x1fd },
	'afilluminator' => { 364 => 0x29, 376 => 0xb044 },
	'afimageheight' => { 177 => [0x12,0x48] },
	'afimagewidth' => { 177 => [0x10,0x46] },
	'afintegrationtime' => { 296 => 0x7 },
	'afmicroadj' => { 357 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 361 => 0x131 },
	'afmicroadjregisteredlenses' => { 361 => '305.1' },
	'afmicroadjustment' => { 76 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 361 => 0x130 },
	'afmode' => { 105 => 0x3009, 116 => 0x1022, 164 => 0x16, 356 => 0x5 },
	'afmoderestrictions' => { 249 => '50.3', 251 => '48.3', 252 => '48.3', 261 => '48.3', 262 => '48.3' },
	'afonaelockbuttonswitch' => { 76 => 0x702 },
	'afonbutton' => { 248 => '3.1', 249 => '47.1' },
	'afpoint' => { 33 => 0x13, 104 => 0x18, 164 => 0x15, 176 => 0x1, 268 => 0x308, 356 => 0x1f, 357 => [0x37,0x7], 361 => 0x19, 362 => 0x18, 363 => [0x18,0x20] },
	'afpointactivationarea' => { 75 => 0x11, 81 => 0x11 },
	'afpointareaexpansion' => { 76 => 0x508 },
	'afpointatshutterrelease' => { 357 => [0x39,0x9] },
	'afpointautoselection' => { 76 => 0x50b },
	'afpointbrightness' => { 76 => 0x50d, 248 => '2.4', 249 => '46.5', 251 => '2.2', 252 => '2.2', 261 => '2.3', 262 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 76 => 0x50c },
	'afpointillumination' => { 75 => 0xa, 248 => '2.3', 249 => '46.2', 251 => '47.2', 252 => '47.2', 256 => '1.2', 257 => '2.3', 258 => '1.2', 261 => '47.2', 262 => '47.2', 263 => '2.4' },
	'afpointinfocus' => { 357 => [0x38,0x8] },
	'afpointmode' => { 301 => 0x3 },
	'afpointposition' => { 105 => 0x2021, 286 => 0x4d },
	'afpointregistration' => { 74 => 0x7 },
	'afpoints' => { 167 => 0x10 },
	'afpointselected' => { 168 => 0xd, 265 => 0x305, 320 => 0xe, 361 => 0x15, 362 => 0x14, 363 => [0x14,0x1c], 376 => 0x201e },
	'afpointselected2' => { 301 => 0x4 },
	'afpointselection' => { 75 => 0xb, 248 => '1.3', 249 => '1.3', 257 => '1.3', 261 => '1.3', 262 => '1.3' },
	'afpointselectionmethod' => { 76 => 0x50f, 77 => 0xc, 78 => 0xd, 81 => 0xd },
	'afpointsetting' => { 364 => 0x12, 365 => 0x11 },
	'afpointsinfocus' => { 70 => 0xe, 176 => 0x2, 296 => 0xb, 297 => 0x4, 320 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 75 => 0xd },
	'afpointsselected' => { 297 => '4.1', 407 => 0x4 },
	'afpointsspecial' => { 297 => '4.2' },
	'afpointsunknown1' => { 296 => 0x0 },
	'afpointsunknown2' => { 296 => 0x2 },
	'afpointsused' => { 177 => 0x8, 357 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 296 => 0x4 },
	'afresponse' => { 202 => 0xad },
	'afresult' => { 270 => 0x1038 },
	'afsearch' => { 265 => 0x303 },
	'afsensoractive' => { 164 => 0x1 },
	'afstatus' => { 346 => 0x1200 },
	'afstatus_00_b4' => { 360 => 0x0 },
	'afstatus_01_c4' => { 360 => 0x2 },
	'afstatus_02_d4' => { 360 => 0x4 },
	'afstatus_03_e4' => { 360 => 0x6 },
	'afstatus_04_f4' => { 360 => 0x8 },
	'afstatus_05_g4' => { 360 => 0xa },
	'afstatus_06_h4' => { 360 => 0xc },
	'afstatus_07_b3' => { 360 => 0xe },
	'afstatus_08_c3' => { 360 => 0x10 },
	'afstatus_09_d3' => { 360 => 0x12 },
	'afstatus_10_e3' => { 360 => 0x14 },
	'afstatus_11_f3' => { 360 => 0x16 },
	'afstatus_12_g3' => { 360 => 0x18 },
	'afstatus_13_h3' => { 360 => 0x1a },
	'afstatus_14_b2' => { 360 => 0x1c },
	'afstatus_15_c2' => { 360 => 0x1e },
	'afstatus_16_d2' => { 360 => 0x20 },
	'afstatus_17_e2' => { 360 => 0x22 },
	'afstatus_18_f2' => { 360 => 0x24 },
	'afstatus_19_g2' => { 360 => 0x26 },
	'afstatus_20_h2' => { 360 => 0x28 },
	'afstatus_21_c1' => { 360 => 0x2a },
	'afstatus_22_d1' => { 360 => 0x2c },
	'afstatus_23_e1' => { 360 => 0x2e },
	'afstatus_24_f1' => { 360 => 0x30 },
	'afstatus_25_g1' => { 360 => 0x32 },
	'afstatus_26_a7_vertical' => { 360 => 0x34 },
	'afstatus_27_a6_vertical' => { 360 => 0x36 },
	'afstatus_28_a5_vertical' => { 360 => 0x38 },
	'afstatus_29_c7_vertical' => { 360 => 0x3a },
	'afstatus_30_c6_vertical' => { 360 => 0x3c },
	'afstatus_31_c5_vertical' => { 360 => 0x3e },
	'afstatus_32_e7_vertical' => { 360 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 360 => 0x42 },
	'afstatus_34_e5_vertical' => { 360 => 0x44 },
	'afstatus_35_g7_vertical' => { 360 => 0x46 },
	'afstatus_36_g6_vertical' => { 360 => 0x48 },
	'afstatus_37_g5_vertical' => { 360 => 0x4a },
	'afstatus_38_i7_vertical' => { 360 => 0x4c },
	'afstatus_39_i6_vertical' => { 360 => 0x4e },
	'afstatus_40_i5_vertical' => { 360 => 0x50 },
	'afstatus_41_a7' => { 360 => 0x52 },
	'afstatus_42_b7' => { 360 => 0x54 },
	'afstatus_43_c7' => { 360 => 0x56 },
	'afstatus_44_d7' => { 360 => 0x58 },
	'afstatus_45_e7' => { 360 => 0x5a },
	'afstatus_46_f7' => { 360 => 0x5c },
	'afstatus_47_g7' => { 360 => 0x5e },
	'afstatus_48_h7' => { 360 => 0x60 },
	'afstatus_49_i7' => { 360 => 0x62 },
	'afstatus_50_a6' => { 360 => 0x64 },
	'afstatus_51_b6' => { 360 => 0x66 },
	'afstatus_52_c6' => { 360 => 0x68 },
	'afstatus_53_d6' => { 360 => 0x6a },
	'afstatus_54_e6_center' => { 360 => 0x6c },
	'afstatus_55_f6' => { 360 => 0x6e },
	'afstatus_56_g6' => { 360 => 0x70 },
	'afstatus_57_h6' => { 360 => 0x72 },
	'afstatus_58_i6' => { 360 => 0x74 },
	'afstatus_59_a5' => { 360 => 0x76 },
	'afstatus_60_b5' => { 360 => 0x78 },
	'afstatus_61_c5' => { 360 => 0x7a },
	'afstatus_62_d5' => { 360 => 0x7c },
	'afstatus_63_e5' => { 360 => 0x7e },
	'afstatus_64_f5' => { 360 => 0x80 },
	'afstatus_65_g5' => { 360 => 0x82 },
	'afstatus_66_h5' => { 360 => 0x84 },
	'afstatus_67_i5' => { 360 => 0x86 },
	'afstatus_68_c11' => { 360 => 0x88 },
	'afstatus_69_d11' => { 360 => 0x8a },
	'afstatus_70_e11' => { 360 => 0x8c },
	'afstatus_71_f11' => { 360 => 0x8e },
	'afstatus_72_g11' => { 360 => 0x90 },
	'afstatus_73_b10' => { 360 => 0x92 },
	'afstatus_74_c10' => { 360 => 0x94 },
	'afstatus_75_d10' => { 360 => 0x96 },
	'afstatus_76_e10' => { 360 => 0x98 },
	'afstatus_77_f10' => { 360 => 0x9a },
	'afstatus_78_g10' => { 360 => 0x9c },
	'afstatus_79_h10' => { 360 => 0x9e },
	'afstatus_80_b9' => { 360 => 0xa0 },
	'afstatus_81_c9' => { 360 => 0xa2 },
	'afstatus_82_d9' => { 360 => 0xa4 },
	'afstatus_83_e9' => { 360 => 0xa6 },
	'afstatus_84_f9' => { 360 => 0xa8 },
	'afstatus_85_g9' => { 360 => 0xaa },
	'afstatus_86_h9' => { 360 => 0xac },
	'afstatus_87_b8' => { 360 => 0xae },
	'afstatus_88_c8' => { 360 => 0xb0 },
	'afstatus_89_d8' => { 360 => 0xb2 },
	'afstatus_90_e8' => { 360 => 0xb4 },
	'afstatus_91_f8' => { 360 => 0xb6 },
	'afstatus_92_g8' => { 360 => 0xb8 },
	'afstatus_93_h8' => { 360 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 360 => 0xbc },
	'afstatusactivesensor' => { 164 => 0x2, 357 => [0x4,0x3b], 361 => 0x1e, 362 => 0x1b, 363 => [0x1b,0x21] },
	'afstatusbottom' => { 164 => 0x8, 361 => 0x2a, 362 => 0x21, 363 => 0x21 },
	'afstatusbottom-left' => { 164 => 0x12, 362 => 0x2b, 363 => 0x2b },
	'afstatusbottom-right' => { 164 => 0x6, 362 => 0x1f, 363 => 0x1f },
	'afstatusbottomassist-left' => { 361 => 0x28 },
	'afstatusbottomassist-right' => { 361 => 0x2c },
	'afstatusbottomhorizontal' => { 358 => 0x10, 359 => 0x1c },
	'afstatusbottomvertical' => { 358 => 0x16, 359 => 0x26 },
	'afstatuscenter-10' => { 361 => 0x34 },
	'afstatuscenter-11' => { 361 => 0x36 },
	'afstatuscenter-12' => { 361 => 0x38 },
	'afstatuscenter-14' => { 361 => 0x3c },
	'afstatuscenter-7' => { 361 => 0x2e },
	'afstatuscenter-9' => { 361 => 0x32 },
	'afstatuscenter-horizontal' => { 361 => 0x30 },
	'afstatuscenter-vertical' => { 361 => 0x3a },
	'afstatuscenterf2-8' => { 361 => 0x4c },
	'afstatuscenterhorizontal' => { 164 => 0x2f, 358 => 0xc, 359 => 0x18, 362 => 0x2f, 363 => 0x2f },
	'afstatuscentervertical' => { 164 => 0xc, 358 => 0x14, 359 => 0x22, 362 => 0x25, 363 => 0x25 },
	'afstatusfarleft' => { 358 => 0x6, 361 => 0x26 },
	'afstatusfarlefthorizontal' => { 359 => 0x4 },
	'afstatusfarleftvertical' => { 359 => 0x12 },
	'afstatusfarright' => { 358 => 0x18, 361 => 0x44 },
	'afstatusfarrighthorizontal' => { 359 => 0x2c },
	'afstatusfarrightvertical' => { 359 => 0x34 },
	'afstatusleft' => { 164 => 0x2d, 358 => 0x2, 361 => 0x22, 362 => 0x2d, 363 => 0x2d },
	'afstatuslefthorizontal' => { 359 => 0x6 },
	'afstatusleftvertical' => { 359 => 0xe },
	'afstatuslower-left' => { 358 => 0x4, 361 => 0x24 },
	'afstatuslower-lefthorizontal' => { 359 => 0xa },
	'afstatuslower-leftvertical' => { 359 => 0x10 },
	'afstatuslower-middle' => { 358 => 0x22, 359 => 0x24 },
	'afstatuslower-right' => { 358 => 0x1e, 361 => 0x4a },
	'afstatuslower-righthorizontal' => { 359 => 0x32 },
	'afstatuslower-rightvertical' => { 359 => 0x3a },
	'afstatuslowerfarleft' => { 359 => 0x8 },
	'afstatuslowerfarright' => { 359 => 0x30 },
	'afstatusmiddlehorizontal' => { 164 => 0xa, 362 => 0x23, 363 => 0x23 },
	'afstatusnearleft' => { 358 => 0xe, 359 => 0x1a },
	'afstatusnearright' => { 358 => 0xa, 359 => 0x16 },
	'afstatusright' => { 164 => 0x31, 358 => 0x1c, 361 => 0x48, 362 => 0x31, 363 => 0x31 },
	'afstatusrighthorizontal' => { 359 => 0x2e },
	'afstatusrightvertical' => { 359 => 0x38 },
	'afstatustop' => { 164 => 0xe, 361 => 0x40, 362 => 0x27, 363 => 0x27 },
	'afstatustop-left' => { 164 => 0x10, 362 => 0x29, 363 => 0x29 },
	'afstatustop-right' => { 164 => 0x4, 362 => 0x1d, 363 => 0x1d },
	'afstatustopassist-left' => { 361 => 0x3e },
	'afstatustopassist-right' => { 361 => 0x42 },
	'afstatustophorizontal' => { 358 => 0x8, 359 => 0x14 },
	'afstatustopvertical' => { 358 => 0x12, 359 => 0x1e },
	'afstatusupper-left' => { 358 => 0x0, 361 => 0x20 },
	'afstatusupper-lefthorizontal' => { 359 => 0x2 },
	'afstatusupper-leftvertical' => { 359 => 0xc },
	'afstatusupper-middle' => { 358 => 0x20, 359 => 0x20 },
	'afstatusupper-right' => { 358 => 0x1a, 361 => 0x46 },
	'afstatusupper-righthorizontal' => { 359 => 0x2a },
	'afstatusupper-rightvertical' => { 359 => 0x36 },
	'afstatusupperfarleft' => { 359 => 0x0 },
	'afstatusupperfarright' => { 359 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 376 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 357 => 0x2 },
	'afwithshutter' => { 364 => 0x2a },
	'aggregateissuenumber' => { 443 => 'aggregateIssueNumber' },
	'aggregationtype' => { 443 => 'aggregationType' },
	'agreement' => { 446 => 'agreement' },
	'aiservocontinuousshooting' => { 75 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 76 => 0x519 },
	'aiservoimagepriority' => { 76 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 76 => 0x51a },
	'aiservotrackingmethod' => { 76 => 0x504 },
	'aiservotrackingsensitivity' => { 75 => 0x14, 76 => 0x502 },
	'album' => { 453 => 'album' },
	'alreadyapplied' => { 429 => 'AlreadyApplied' },
	'alternatetitle' => { 443 => 'alternateTitle' },
	'alternatetitlea-lang' => { 443 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 443 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 443 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 179 => 0x6 },
	'alttapename' => { 453 => 'altTapeName' },
	'alttimecode' => { 453 => 'altTimecode' },
	'alttimecodetimeformat' => { 453 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 453 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 453 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 111 => 0x9400, 341 => 0x14, 342 => 0x46, 399 => 0x4 },
	'ambienttemperaturefahrenheit' => { 341 => 0x13, 342 => 0x44 },
	'analogbalance' => { 111 => 0xc627 },
	'angleadj' => { 95 => 0x10003, 101 => 0x8b },
	'angleinforoll' => { 424 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 424 => 'AngleInfoYaw' },
	'anti-blur' => { 376 => 0xb04b },
	'antialiasstrength' => { 111 => 0xc632 },
	'aperturelock' => { 249 => '38.2', 251 => '38.2', 252 => '38.2', 261 => '38.2', 262 => '38.2' },
	'aperturerange' => { 76 => 0x10d },
	'apertureringuse' => { 301 => '1.4' },
	'aperturesetting' => { 168 => 0x7, 364 => 0x30, 365 => 0x29, 366 => 0x1 },
	'aperturevalue' => { 85 => 0x2, 111 => 0x9202, 270 => 0x1002, 329 => 0x401, 433 => 'ApertureValue' },
	'applekeywords' => { 274 => 'AAPL:Keywords' },
	'applicationnotes' => { 111 => 0x2bc, 290 => 0x2bc },
	'applicationrecordversion' => { 119 => 0x0 },
	'applyshootingmeteringmode' => { 76 => 0x10e },
	'approved' => { 435 => 'Approved' },
	'approvedby' => { 435 => 'ApprovedBy' },
	'approximatefnumber' => { 282 => 0x313, 288 => 0x3406 },
	'approximatefocusdistance' => { 425 => 'ApproximateFocusDistance' },
	'appversion' => { 437 => 'AppVersion' },
	'aquahsl' => { 95 => 0x20914 },
	'armidentifier' => { 120 => 0x78 },
	'armversion' => { 120 => 0x7a },
	'artfilter' => { 265 => 0x529 },
	'artfiltereffect' => { 265 => 0x52f },
	'artist' => { 111 => 0x13b, 278 => 'Artist', 320 => 0x22e, 449 => 'Artist', 453 => 'artist' },
	'artmode' => { 105 => 0x301b },
	'artmodeparameters' => { 105 => 0x310b },
	'artworkcircadatecreated' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 439 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 439 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 269 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 269 => 0x1112, 320 => 0x80, 364 => 0x55, 365 => 0x55, 366 => 0xa },
	'assetid' => { 419 => 'AssetID' },
	'asshoticcprofile' => { 111 => 0xc68f },
	'asshotneutral' => { 111 => 0xc628 },
	'asshotpreprofilematrix' => { 111 => 0xc690 },
	'asshotprofilename' => { 111 => 0xc6f6 },
	'asshotwhitexy' => { 111 => 0xc629 },
	'assignbktbutton' => { 248 => '4.2', 249 => '16.1', 251 => '16.1', 252 => '16.1', 261 => '16.1', 262 => '16.1' },
	'assignfuncbutton' => { 76 => 0x70b },
	'assignmb-d17af-onbutton' => { 252 => '79.1' },
	'assignmb-d17funcbutton' => { 252 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 252 => '68.1' },
	'assignmb-d18af-onbutton' => { 262 => '79.1' },
	'assignmb-d18funcbutton' => { 262 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 262 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 251 => '75.1', 252 => '75.1', 262 => '75.1' },
	'assignmoviefunc2button' => { 251 => '82.1', 252 => '82.1', 262 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 251 => '75.2', 252 => '75.2', 262 => '75.2' },
	'assignmovierecordbutton' => { 249 => '43.2', 261 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 251 => '45.1', 252 => '45.1', 262 => '45.1' },
	'assignmoviesubselector' => { 251 => '74.1', 252 => '74.1', 262 => '74.1' },
	'assignmoviesubselectorplusdials' => { 251 => '76.1', 252 => '76.1', 262 => '76.1' },
	'assignremotefnbutton' => { 249 => '54.1', 261 => '51.1' },
	'assistbuttonfunction' => { 74 => 0xd },
	'attributionname' => { 426 => 'attributionName' },
	'attributionurl' => { 426 => 'attributionURL' },
	'audio' => { 286 => 0x20 },
	'audiobitrate' => { 61 => 0x6c, 439 => 'audioBitRate' },
	'audiobitratemode' => { 439 => 'audioBitRateMode' },
	'audiochannelcount' => { 439 => 'audioChannelCount' },
	'audiochannels' => { 61 => 0x70 },
	'audiochanneltype' => { 453 => 'audioChannelType' },
	'audiocompression' => { 140 => 'Compression' },
	'audiocompressor' => { 453 => 'audioCompressor' },
	'audiodata' => { 413 => 'Data' },
	'audioduration' => { 119 => 0x99 },
	'audiomimetype' => { 413 => 'Mime' },
	'audiomoddate' => { 453 => 'audioModDate' },
	'audiooutcue' => { 119 => 0x9a },
	'audiosamplerate' => { 61 => 0x6e, 453 => 'audioSampleRate' },
	'audiosampletype' => { 453 => 'audioSampleType' },
	'audiosamplingrate' => { 119 => 0x97 },
	'audiosamplingresolution' => { 119 => 0x98 },
	'audiotype' => { 119 => 0x96 },
	'author' => { 142 => 'Author', 274 => 'Author', 278 => 'Author', 336 => 'Author', 423 => 'author', 440 => 'Author', 451 => 'Author' },
	'authorsposition' => { 441 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 76 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 311 => '0.1' },
	'autobracket' => { 356 => 0x19 },
	'autobracketing' => { 116 => 0x1100, 320 => 0x18, 346 => 0x1007 },
	'autobracketingmode' => { 260 => '12.3' },
	'autobracketingset' => { 260 => '12.1' },
	'autobracketmodem' => { 248 => '21.2', 249 => '13.3', 251 => '13.2', 252 => '13.2', 257 => '26.2', 261 => '13.3', 262 => '13.2' },
	'autobracketorder' => { 168 => 0x43, 248 => '21.3', 249 => '13.2', 251 => '13.1', 252 => '13.1', 257 => '26.3', 258 => '12.2', 259 => '2.2', 260 => '12.2', 261 => '13.2', 262 => '13.1', 263 => '13.2' },
	'autobracketset' => { 248 => '21.1', 249 => '13.1', 253 => '11.1', 254 => '12.1', 255 => '12.1', 257 => '26.1', 258 => '12.1', 259 => '2.1', 261 => '13.1', 263 => '13.1' },
	'autobrightness' => { 429 => 'AutoBrightness' },
	'autocontrast' => { 429 => 'AutoContrast' },
	'autodistortioncontrol' => { 187 => 0x4 },
	'autodynamicrange' => { 116 => 0x140b },
	'autoexposure' => { 429 => 'AutoExposure' },
	'autoexposurebracketing' => { 70 => 0x10 },
	'autoflashisosensitivity' => { 251 => '38.5', 252 => '38.5', 262 => '38.5' },
	'autofocus' => { 268 => 0x209 },
	'autofp' => { 259 => '7.3', 263 => '31.4' },
	'autoiso' => { 70 => 0x1, 105 => 0x3008, 250 => '1.1', 259 => '1.1' },
	'autoisomax' => { 250 => '1.2', 259 => '1.2' },
	'autoisominshutterspeed' => { 250 => '1.3', 259 => '1.3' },
	'autolateralca' => { 429 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 57 => 0x2, 76 => 0x204, 95 => 0x20500, 101 => 0x6f },
	'autolightingoptimizeron' => { 95 => '0x20500.0', 101 => 0x6e },
	'autoportraitframed' => { 376 => 0x2016 },
	'autoredeye' => { 241 => 0xfe28a44f },
	'autorotate' => { 70 => 0x1b },
	'autoshadows' => { 429 => 'AutoShadows' },
	'autowhiteversion' => { 429 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 202 => 0x82 },
	'avaperturesetting' => { 301 => 0x13 },
	'averageblacklevel' => { 40 => 0xe7, 42 => 0xfb, 43 => 0x114, 44 => 0x146 },
	'averagelv' => { 171 => 0x38 },
	'avsettingwithoutlens' => { 76 => 0x707 },
	'azimuth' => { 150 => 'Azimuth' },
	'babyage' => { 286 => [0x8010,0x33] },
	'babyname' => { 286 => 0x66 },
	'backgroundalpha' => { 448 => 'bgalpha' },
	'baseexposurecompensation' => { 301 => 0x15 },
	'baseiso' => { 70 => 0x2, 89 => 0x101c, 125 => 0x903, 288 => 0x312a, 405 => 0x6 },
	'baselineexposure' => { 111 => 0xc62a },
	'baselineexposureoffset' => { 111 => 0xc7a5 },
	'baselinenoise' => { 111 => 0xc62b },
	'baselinesharpness' => { 111 => 0xc62c },
	'baseurl' => { 451 => 'BaseURL' },
	'batterylevel' => { 364 => 0x51, 368 => 0xc, 369 => 0x4, 370 => 0x4, 406 => 0x7 },
	'batterylevelgrip1' => { 406 => 0x6 },
	'batterylevelgrip2' => { 406 => 0x8 },
	'batteryorder' => { 248 => '12.5', 257 => '13.2', 258 => '2.1', 261 => '3.1' },
	'batterystate' => { 168 => 0x60, 364 => 0x50, 370 => 0x14 },
	'batterytemperature' => { 368 => 0x1, 370 => 0x2, 406 => 0x5 },
	'batteryunknown' => { 368 => 0x2, 370 => 0x0 },
	'batteryvoltage' => { 125 => 0x408, 341 => 0x2a, 342 => 0x49, 368 => 0x8 },
	'batteryvoltage1' => { 370 => 0x6 },
	'batteryvoltage2' => { 370 => 0x8 },
	'bayergreensplit' => { 111 => 0xc62d },
	'bayerpattern' => { 124 => 0xf902, 172 => 0x17 },
	'beatspliceparams' => { 453 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 453 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 453 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 453 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 453 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 453 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 248 => '13.1', 249 => '5.4', 250 => '0.1', 253 => '2.1', 254 => '3.1', 255 => '3.1', 257 => '10.1', 259 => '0.1', 261 => '5.5', 263 => '4.1' },
	'beeppitch' => { 258 => '3.1' },
	'beepvolume' => { 258 => '4.5' },
	'bestqualityscale' => { 111 => 0xc65c },
	'bestshotmode' => { 105 => 0x3007 },
	'bitdepth' => { 147 => 'BitDepth', 172 => 0x11, 209 => 0x41 },
	'bitspercomponent' => { 121 => 0x87 },
	'bitspersample' => { 111 => 0x102, 290 => 0xa, 449 => 'BitsPerSample' },
	'blacklevel' => { 111 => 0xc61a, 202 => 0x3d, 270 => [0x401,0x1012], 329 => 0x21d },
	'blacklevel2' => { 269 => 0x600, 273 => 0x600 },
	'blacklevelblue' => { 290 => 0x1e },
	'blackleveldata' => { 329 => 0x223 },
	'blackleveldeltah' => { 111 => 0xc61b },
	'blackleveldeltav' => { 111 => 0xc61c },
	'blacklevelgreen' => { 290 => 0x1d },
	'blacklevelred' => { 290 => 0x1c },
	'blacklevelrepeatdim' => { 111 => 0xc619 },
	'blackpoint' => { 320 => 0x200 },
	'blacks2012' => { 429 => 'Blacks2012' },
	'bleachbypasstoning' => { 320 => 0x7f },
	'blockshotafresponse' => { 251 => '1.5', 252 => '1.5', 262 => '1.5' },
	'blogtitle' => { 443 => 'blogTitle' },
	'blogurl' => { 443 => 'blogURL' },
	'bluebalance' => { 185 => 0x271, 270 => 0x1018, 290 => 0x12, 320 => 0x1b },
	'bluecurvelimits' => { 100 => 0x1fe },
	'bluecurvepoints' => { 99 => 0x79, 100 => 0x1d4 },
	'bluehsl' => { 95 => 0x20915 },
	'bluehue' => { 429 => 'BlueHue' },
	'bluesaturation' => { 429 => 'BlueSaturation' },
	'bluratinfinity' => { 415 => 'BlurAtInfinity' },
	'blurcontrol' => { 320 => 0x82 },
	'blurwarning' => { 116 => 0x1300 },
	'bodybatteryadload' => { 299 => 0x3 },
	'bodybatteryadnoload' => { 299 => 0x2 },
	'bodybatterystate' => { 299 => '1.1' },
	'bodybatteryvoltage1' => { 299 => 0x2 },
	'bodybatteryvoltage2' => { 299 => 0x4 },
	'bodybatteryvoltage3' => { 299 => 0x6 },
	'bodybatteryvoltage4' => { 299 => 0x8 },
	'bodyfirmware' => { 347 => 0x0 },
	'bodyfirmwareversion' => { 266 => 0x104, 267 => 0x100, 270 => 0x104 },
	'bodyserialnumber' => { 347 => 0x10 },
	'bookedition' => { 443 => 'bookEdition' },
	'bootloaderversion' => { 342 => 0x26 },
	'bracketmode' => { 52 => 0x3 },
	'bracketsequence' => { 105 => 0x301d },
	'bracketsettings' => { 286 => 0x45 },
	'bracketshotnumber' => { 52 => 0x5, 301 => 0x9, 375 => 0x2b },
	'bracketshotnumber2' => { 375 => 0x2d },
	'bracketstep' => { 165 => 0xe },
	'bracketvalue' => { 52 => 0x4 },
	'brightness' => { 111 => 0xfe53, 141 => 'Brightness', 161 => 'Brightness', 165 => 0x2c, 204 => 0x34, 205 => 0x39, 341 => 0x25, 364 => 0x22, 376 => 0x2007, 429 => 'Brightness' },
	'brightnessadj' => { 100 => 0x114, 234 => 0x0, 244 => 0x2d, 409 => 0x8018 },
	'brightnessvalue' => { 111 => 0x9203, 171 => [0x691,0x49c3], 270 => 0x1003, 381 => 0x1e, 384 => 0x1140, 385 => 0x1140, 386 => 0x111c, 387 => 0x1198, 388 => 0x1174, 389 => 0x102c, 390 => 0x224, 391 => 0x224, 392 => 0x219, 433 => 'BrightnessValue' },
	'bulbduration' => { 70 => 0x18 },
	'burstmode' => { 127 => 0xa, 286 => 0x2a },
	'burstmode2' => { 127 => 0x18 },
	'burstshot' => { 356 => 0x34 },
	'burstspeed' => { 286 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 76 => 0x70a },
	'bwfilter' => { 165 => 0x2a, 173 => 0x39 },
	'bwmode' => { 270 => 0x203 },
	'by-line' => { 119 => 0x50 },
	'by-linetitle' => { 119 => 0x55 },
	'bytecount' => { 443 => 'byteCount' },
	'calibration' => { 356 => [0x24,0x30] },
	'calibrationilluminant1' => { 111 => 0xc65a },
	'calibrationilluminant2' => { 111 => 0xc65b },
	'callforimage' => { 419 => 'CallForImage' },
	'cameraangle' => { 453 => 'cameraAngle' },
	'cameracalibration1' => { 111 => 0xc623 },
	'cameracalibration2' => { 111 => 0xc624 },
	'cameracalibrationsig' => { 111 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 41 => 0xba },
	'cameracolorcalibration02' => { 35 => 0x4, 41 => 0xbf },
	'cameracolorcalibration03' => { 35 => 0x8, 41 => 0xc4 },
	'cameracolorcalibration04' => { 35 => 0xc, 41 => 0xc9 },
	'cameracolorcalibration05' => { 35 => 0x10, 41 => 0xce },
	'cameracolorcalibration06' => { 35 => 0x14, 41 => 0xd3 },
	'cameracolorcalibration07' => { 35 => 0x18, 41 => 0xd8 },
	'cameracolorcalibration08' => { 35 => 0x1c, 41 => 0xdd },
	'cameracolorcalibration09' => { 35 => 0x20, 41 => 0xe2 },
	'cameracolorcalibration10' => { 35 => 0x24, 41 => 0xe7 },
	'cameracolorcalibration11' => { 35 => 0x28, 41 => 0xec },
	'cameracolorcalibration12' => { 35 => 0x2c, 41 => 0xf1 },
	'cameracolorcalibration13' => { 35 => 0x30, 41 => 0xf6 },
	'cameracolorcalibration14' => { 35 => 0x34, 41 => 0xfb },
	'cameracolorcalibration15' => { 35 => 0x38, 41 => 0x100 },
	'camerae-mountversion' => { 408 => 0xb },
	'cameraelevationangle' => { 111 => 0x9405 },
	'camerafilename' => { 419 => 'CameraFilename' },
	'cameraid' => { 270 => 0x209, 355 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 111 => 0xc7a1, 453 => 'cameraLabel' },
	'cameramakemodel' => { 419 => 'CameraMakeModel' },
	'cameramodel' => { 329 => 0x410, 453 => 'cameraModel' },
	'cameramodelid' => { 161 => 'CameraModelID' },
	'cameramove' => { 453 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 286 => 0x8f, 324 => 0x1, 329 => 0x100, 370 => [0x16,0x18], 396 => 0x28, 397 => 0x24, 398 => 0x29 },
	'cameraowner' => { 128 => 0xc353 },
	'cameraparameters' => { 270 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 107 => 0x9 },
	'cameraprofile' => { 429 => 'CameraProfile' },
	'cameraprofiledigest' => { 429 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 101 => 0xe1 },
	'camerarawcontrast' => { 101 => 0xe3 },
	'camerarawhighlightpoint' => { 101 => 0xe6 },
	'camerarawlinear' => { 101 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 101 => 0xe8 },
	'camerarawoutputshadowpoint' => { 101 => 0xe9 },
	'camerarawsaturation' => { 101 => 0xe2 },
	'camerarawshadowpoint' => { 101 => 0xe7 },
	'camerarawsharpness' => { 101 => 0xe5 },
	'cameraroll' => { 107 => 0xb },
	'cameraserialnumber' => { 111 => 0xc62f, 163 => 'CameraSerialNumber', 419 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 265 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 70 => 0xc, 125 => 0x406, 269 => 0x1306, 282 => 0x320, 288 => 0x3402, 320 => 0x47, 353 => 0x43, 400 => 0x5 },
	'cameratemperature4' => { 325 => 0x14 },
	'cameratemperature5' => { 325 => 0x16 },
	'cameratemperaturerangemax' => { 113 => 0x5 },
	'cameratemperaturerangemin' => { 113 => 0x6 },
	'cameratype' => { 70 => 0x1a, 270 => 0x207 },
	'cameratype2' => { 266 => 0x100 },
	'camerayaw' => { 107 => 0xa },
	'canondr4' => { 112 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 89 => 0x805 },
	'canonfilelength' => { 58 => 0xe },
	'canonfirmwareversion' => { 58 => 0x7, 89 => 0x80b },
	'canonflashinfo' => { 89 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 58 => 0x6, 89 => 0x815 },
	'canonmodelid' => { 58 => 0x10, 89 => 0x1834 },
	'canonvrd' => { 112 => 'CanonVRD' },
	'caption' => { 423 => 'caption' },
	'caption-abstract' => { 119 => 0x78 },
	'captionsauthornames' => { 432 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 432 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 441 => 'CaptionWriter' },
	'captureframerate' => { 105 => 0x4001 },
	'capturesoftware' => { 417 => 'CaptureSoftware' },
	'cardshutterlock' => { 168 => 0x49 },
	'casioimagesize' => { 105 => 0x9 },
	'catalogsets' => { 119 => 0xff, 412 => 'CatalogSets', 421 => 'CatalogSets' },
	'categories' => { 58 => 0x23, 423 => 'categories' },
	'category' => { 119 => 0xf, 264 => 0x30, 441 => 'Category' },
	'cbcrgain' => { 353 => 0xa036 },
	'cbcrgaindefault' => { 353 => 0xa035 },
	'cbcrmatrix' => { 353 => 0xa034 },
	'cbcrmatrixdefault' => { 353 => 0xa033 },
	'ccdboardversion' => { 282 => 0x331 },
	'ccdscanmode' => { 270 => 0x1039 },
	'ccdsensitivity' => { 231 => 0x6 },
	'ccdversion' => { 282 => 0x330 },
	'cellglobalid' => { 427 => 'cgi' },
	'celllength' => { 111 => 0x109 },
	'cellr' => { 427 => 'r' },
	'celltowerid' => { 427 => 'cellid' },
	'cellwidth' => { 111 => 0x108 },
	'centerafarea' => { 259 => '15.1' },
	'centerfocuspoint' => { 263 => '2.2' },
	'centerweightedareasize' => { 248 => '7.1', 249 => '8.1', 251 => '8.1', 252 => '8.1', 256 => '7.1', 257 => '5.1', 258 => '7.1', 259 => '6.3', 261 => '8.1', 262 => '8.1', 263 => '8.1' },
	'certificate' => { 457 => 'Certificate' },
	'cfapattern' => { 111 => 0xa302, 290 => 0x9, 433 => 'CFAPattern' },
	'cfapattern2' => { 111 => 0x828e },
	'cfapatterncolumns' => { 433 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 433 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 433 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 111 => 0x828d },
	'channel' => { 443 => 'channel' },
	'channela-lang' => { 443 => [\'channel','channelA-lang'] },
	'channelchannel' => { 443 => [\'channel','channelChannel'] },
	'channels' => { 140 => 'Channels' },
	'channelsubchannel1' => { 443 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 443 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 443 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 443 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 95 => 0x10101, 100 => 0x26a },
	'checkmark2' => { 101 => 0x8e },
	'childfontfiles' => { 458 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 248 => '10.3', 249 => '11.2' },
	'chromablurradius' => { 111 => 0xc631 },
	'chromaticaberration' => { 95 => 0x20703, 101 => 0x66, 353 => 0xa051 },
	'chromaticaberrationb' => { 429 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 95 => 0x20708, 101 => 0x6b },
	'chromaticaberrationcorr' => { 72 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 310 => 0x1 },
	'chromaticaberrationcorrparams' => { 111 => 0x7035, 404 => 0x66a, 405 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 95 => '0x20703.0', 101 => 0x62 },
	'chromaticaberrationr' => { 429 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 95 => 0x20707, 101 => 0x6a },
	'chromaticaberrationsetting' => { 73 => 0x6 },
	'chrominancenoisereduction' => { 95 => 0x20601, 101 => 0x5e, 356 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 101 => 0x60 },
	'circadatecreated' => { 439 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 429 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 429 => 'CircularGradientBasedCorrections' },
	'city' => { 119 => 0x5a, 146 => 'City', 286 => 0x6d, 441 => 'City' },
	'city2' => { 286 => 0x80 },
	'clarity' => { 205 => 0x35, 429 => 'Clarity' },
	'clarity2012' => { 429 => 'Clarity2012' },
	'claritycontrol' => { 320 => 0x96 },
	'classifystate' => { 119 => 0xe1 },
	'clearretouch' => { 286 => 0x7c },
	'clearretouchvalue' => { 286 => 0xa3 },
	'client' => { 453 => 'client' },
	'clientname' => { 435 => 'ClientName' },
	'clmodeshootingspeed' => { 248 => '10.2', 249 => '11.3', 251 => '11.2', 252 => '11.2', 257 => '11.2', 258 => '10.2', 261 => '11.2', 262 => '11.2', 263 => '11.1' },
	'cmcontrast' => { 273 => 0x2022 },
	'cmexposurecompensation' => { 273 => 0x2000 },
	'cmhue' => { 273 => 0x2021 },
	'cmsaturation' => { 273 => 0x2020 },
	'cmsharpness' => { 273 => 0x2023 },
	'cmwhitebalance' => { 273 => 0x2001 },
	'cmwhitebalancecomp' => { 273 => 0x2002 },
	'cmwhitebalancegraypoint' => { 273 => 0x2010 },
	'codec' => { 154 => 'Codec' },
	'codedcharacterset' => { 120 => 0x5a },
	'collection' => { 278 => 'Collection' },
	'collectionname' => { 155 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 155 => 'Collections', 423 => 'collections' },
	'collectionuri' => { 155 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 442 => 'color' },
	'coloraberrationcontrol' => { 241 => 0xc89224b },
	'coloradjustment' => { 356 => 0x14 },
	'coloradjustmentmode' => { 355 => 0x210 },
	'coloranta' => { 458 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 458 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 458 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 458 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 458 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 458 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 458 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 458 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 458 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 458 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 458 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 458 => 'Colorants' },
	'colorantswatchname' => { 458 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 458 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 458 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 458 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 141 => 'ColorBalance' },
	'colorbalanceadj' => { 241 => 0x76a43202 },
	'colorbalanceblue' => { 165 => 0x1e },
	'colorbalancegreen' => { 165 => 0x1d },
	'colorbalancered' => { 165 => 0x1c },
	'colorbalanceversion' => { 186 => 0x0 },
	'colorblur' => { 101 => 0x65 },
	'colorbluron' => { 95 => 0x20704 },
	'colorbooster' => { 241 => 0x5f0e7d23 },
	'colorboostlevel' => { 235 => 0x1 },
	'colorboosttype' => { 235 => 0x0 },
	'colorclass' => { 331 => 0xde, 332 => 'ColorClass' },
	'colorcompensationfilter' => { 168 => [0x3a,0x5f], 170 => 0x111, 376 => 0xb022 },
	'colorcompensationfiltercustom' => { 364 => 0xd, 365 => 0xc },
	'colorcompensationfilterset' => { 364 => 0x8, 365 => 0x7, 366 => 0x18, 381 => 0xf },
	'colorcontrol' => { 270 => 0x102b },
	'colorcorrection' => { 409 => 0x8015 },
	'colorcreatoreffect' => { 265 => 0x532 },
	'colordataversion' => { 39 => 0x0, 40 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0 },
	'coloreffect' => { 286 => 0x28 },
	'colorfilter' => { 104 => 0x17, 105 => 0x3017, 165 => 0x29, 173 => [0x38,0x4d,0x4f], 327 => 0x17 },
	'colorgain' => { 209 => 0x51 },
	'colorhue' => { 95 => 0x20900, 202 => 0x8d },
	'colorimetricreference' => { 111 => 0xc6bf },
	'colorlabel' => { 432 => 'ColorLabel' },
	'colormatrix' => { 269 => 0x200, 270 => 0x1011, 353 => 0xa030 },
	'colormatrix1' => { 111 => 0xc621, 329 => 0x106 },
	'colormatrix2' => { 111 => 0xc622, 273 => 0x200, 329 => 0x226 },
	'colormatrixa' => { 320 => 0x203 },
	'colormatrixadobergb' => { 353 => 0xa032 },
	'colormatrixb' => { 320 => 0x204 },
	'colormatrixnumber' => { 270 => 0x1019 },
	'colormatrixsrgb' => { 353 => 0xa031 },
	'colormode' => { 105 => 0x3015, 116 => 0x1210, 127 => 0x66, 165 => 0x28, 168 => 0x16, 170 => 0x101, 171 => 0x36, 173 => 0x7, 202 => 0x3, 231 => 0x4, 286 => 0x32, 356 => 0x2c, 376 => 0xb029, 441 => 'ColorMode' },
	'colormoirereduction' => { 95 => 0x20670, 242 => 0x15 },
	'colormoirereductionmode' => { 242 => 0x5 },
	'colormoirereductionon' => { 95 => '0x20670.0' },
	'colornoisereduction' => { 409 => 0x8029, 429 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 429 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 242 => 0x18 },
	'colornoisereductionsharpness' => { 242 => 0x1c },
	'colornoisereductionsmoothness' => { 429 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 115 => 0x2 },
	'colorprofile' => { 165 => 0x33 },
	'colorprofilesettings' => { 265 => 0x539 },
	'colorrepresentation' => { 121 => 0x3c },
	'colorsaturationadj' => { 95 => 0x20305 },
	'colorsequence' => { 121 => 0x41 },
	'colorspace' => { 46 => 0x3, 58 => 0xb4, 89 => 0x10b4, 111 => 0xa001, 147 => 'ColorSpace', 166 => 0x2f, 167 => 0x25, 168 => 0x17, 202 => 0x1e, 265 => 0x507, 320 => 0x37, 353 => 0xa011, 356 => 0xb, 364 => 0x1b, 365 => 0x83, 366 => 0xe, 381 => 0x6, 433 => 'ColorSpace' },
	'colortempasshot' => { 36 => 0x4, 37 => 0x1d, 38 => 0x26, 39 => 0x43, 42 => 0x43, 43 => 0x43, 44 => 0x43, 45 => 0x4b },
	'colortempauto' => { 36 => 0x9, 37 => 0x22, 38 => 0x1c, 39 => 0x48, 42 => 0x48, 43 => 0x48, 44 => 0x48, 45 => 0x50 },
	'colortempcloudy' => { 36 => 0x22, 37 => 0x31, 38 => 0x35, 39 => 0x5c, 42 => 0x75, 43 => 0x8e, 44 => 0x93, 45 => 0x96, 320 => 0x55 },
	'colortempcustom' => { 39 => 0x84 },
	'colortempcustom1' => { 37 => 0x45 },
	'colortempcustom2' => { 37 => 0x4a },
	'colortempdaylight' => { 36 => 0x18, 37 => 0x27, 38 => 0x2b, 39 => 0x52, 42 => 0x6b, 43 => 0x84, 44 => 0x89, 45 => 0x8c, 320 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 58 => 0xae, 68 => 0x9, 89 => 0x10ae, 116 => 0x1005, 125 => 0x846, 141 => 'ColorTemperature', 166 => [0x6e,0x49], 167 => 0x3f, 168 => [0x39,0x5e], 170 => 0x10b, 173 => [0x3c,0x4c,0x4e], 282 => 0x321, 320 => 0x50, 346 => 0x1308, 376 => 0xb021, 429 => 'Temperature' },
	'colortemperatureadj' => { 409 => 0x8013 },
	'colortemperatureauto' => { 202 => 0x4f },
	'colortemperaturebg' => { 270 => 0x1013 },
	'colortemperaturecustom' => { 364 => 0xc, 365 => 0xb },
	'colortemperaturerg' => { 270 => 0x1014 },
	'colortemperatureset' => { 364 => 0x7, 365 => 0x6 },
	'colortemperaturesetting' => { 168 => 0x25, 366 => 0x17, 381 => 0xe },
	'colortempflash' => { 36 => 0x36, 37 => 0x40, 38 => 0x49, 39 => 0x70, 42 => 0x89, 43 => 0xa2, 44 => 0xa7, 45 => 0xaa, 320 => 0x5a },
	'colortempflashdata' => { 39 => 0x24a },
	'colortempfluorescent' => { 36 => 0x2c, 37 => 0x3b, 38 => 0x3f, 39 => 0x66, 42 => 0x7f, 43 => 0x98, 44 => 0x9d, 45 => 0xa0 },
	'colortempfluorescentd' => { 320 => 0x57 },
	'colortempfluorescentn' => { 320 => 0x58 },
	'colortempfluorescentw' => { 320 => 0x59 },
	'colortempkelvin' => { 36 => 0x31, 38 => 0x44, 39 => 0x6b, 42 => 0x84, 43 => 0x9d, 44 => 0xa2, 45 => 0xa5, 286 => 0x44, 346 => 0x1307 },
	'colortempmeasured' => { 36 => 0xe, 39 => 0x4d, 42 => 0x4d, 43 => 0x4d, 44 => 0x4d, 45 => 0x55 },
	'colortemppc1' => { 38 => 0x94, 39 => 0x75 },
	'colortemppc2' => { 38 => 0x99, 39 => 0x7a },
	'colortemppc3' => { 38 => 0x9e, 39 => 0x7f },
	'colortempshade' => { 36 => 0x1d, 37 => 0x2c, 38 => 0x30, 39 => 0x57, 42 => 0x70, 43 => 0x89, 44 => 0x8e, 45 => 0x91, 320 => 0x54 },
	'colortemptungsten' => { 36 => 0x27, 37 => 0x36, 38 => 0x3a, 39 => 0x61, 42 => 0x7a, 43 => 0x93, 44 => 0x98, 45 => 0x9b, 320 => 0x56 },
	'colortempunknown' => { 36 => 0x13, 38 => 0x21, 42 => 0x52, 43 => 0x52, 44 => 0x52, 45 => 0x5a },
	'colortempunknown10' => { 36 => 0x63, 38 => 0x76, 42 => 0xa2, 43 => 0x7f, 44 => 0x7f, 45 => 0x87 },
	'colortempunknown11' => { 36 => 0x68, 38 => 0x7b, 42 => 0xa7, 43 => 0xa7, 44 => 0x84, 45 => 0xaf },
	'colortempunknown12' => { 36 => 0x6d, 38 => 0x80, 42 => 0xac, 43 => 0xac, 44 => 0xac, 45 => 0xb4 },
	'colortempunknown13' => { 36 => 0x72, 38 => 0x85, 42 => 0xb1, 43 => 0xb1, 44 => 0xb1, 45 => 0xb9 },
	'colortempunknown14' => { 38 => 0x8a, 42 => 0xb6, 43 => 0xb6, 44 => 0xb6, 45 => 0xbe },
	'colortempunknown15' => { 38 => 0x8f, 42 => 0xbb, 43 => 0xbb, 44 => 0xbb, 45 => 0xc3 },
	'colortempunknown16' => { 38 => 0xa3, 43 => 0xc0, 44 => 0xc0, 45 => 0xc8 },
	'colortempunknown17' => { 43 => 0xc5, 44 => 0xc5, 45 => 0xcd },
	'colortempunknown18' => { 43 => 0xca, 44 => 0xca, 45 => 0xd2 },
	'colortempunknown19' => { 43 => 0xcf, 44 => 0xcf, 45 => 0xd7 },
	'colortempunknown2' => { 36 => 0x3b, 38 => 0x4e, 42 => 0x57, 43 => 0x57, 44 => 0x57, 45 => 0x5f },
	'colortempunknown20' => { 43 => 0xd4, 44 => 0xd4, 45 => 0xdc },
	'colortempunknown21' => { 44 => 0xd9, 45 => 0xe1 },
	'colortempunknown22' => { 44 => 0xde, 45 => 0xe6 },
	'colortempunknown23' => { 44 => 0xe3, 45 => 0xeb },
	'colortempunknown24' => { 44 => 0xe8, 45 => 0xf0 },
	'colortempunknown25' => { 44 => 0xed, 45 => 0xf5 },
	'colortempunknown26' => { 44 => 0xf2, 45 => 0xfa },
	'colortempunknown27' => { 44 => 0xf7, 45 => 0xff },
	'colortempunknown28' => { 44 => 0xfc, 45 => 0x104 },
	'colortempunknown29' => { 44 => 0x101, 45 => 0x109 },
	'colortempunknown3' => { 36 => 0x40, 38 => 0x53, 42 => 0x5c, 43 => 0x5c, 44 => 0x5c, 45 => 0x64 },
	'colortempunknown30' => { 44 => 0x106 },
	'colortempunknown4' => { 36 => 0x45, 38 => 0x58, 42 => 0x61, 43 => 0x61, 44 => 0x61, 45 => 0x69 },
	'colortempunknown5' => { 36 => 0x4a, 38 => 0x5d, 42 => 0x66, 43 => 0x66, 44 => 0x66, 45 => 0x6e },
	'colortempunknown6' => { 36 => 0x4f, 38 => 0x62, 42 => 0x8e, 43 => 0x6b, 44 => 0x6b, 45 => 0x73 },
	'colortempunknown7' => { 36 => 0x54, 38 => 0x67, 42 => 0x93, 43 => 0x70, 44 => 0x70, 45 => 0x78 },
	'colortempunknown8' => { 36 => 0x59, 38 => 0x6c, 42 => 0x98, 43 => 0x75, 44 => 0x75, 45 => 0x7d },
	'colortempunknown9' => { 36 => 0x5e, 38 => 0x71, 42 => 0x9d, 43 => 0x7a, 44 => 0x7a, 45 => 0x82 },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 46 => 0x2 },
	'colortoneadj' => { 95 => 0x20304, 100 => 0x11e },
	'colortoneauto' => { 65 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 64 => 0x6c, 65 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 64 => 0x3c, 65 => 0x3c },
	'colortonemonochrome' => { 64 => 0x84, 65 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 64 => 0x54, 65 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 64 => 0x24, 65 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 64 => 0xc, 65 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 64 => 0x9c, 65 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 64 => 0xb4, 65 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 64 => 0xcc, 65 => 0xe4 },
	'commanddials' => { 259 => '5.1' },
	'commanddialsaperturesetting' => { 248 => '17.3', 249 => '18.3', 251 => '18.3', 252 => '18.3', 257 => '33.3', 258 => '17.3', 261 => '18.3', 262 => '18.3' },
	'commanddialschangemainsub' => { 248 => '17.2', 249 => '18.1', 251 => '18.1', 252 => '18.1', 257 => '33.2', 258 => '17.2', 261 => '18.1', 262 => '18.1' },
	'commanddialsmenuandplayback' => { 248 => '17.4', 249 => '18.2', 251 => '18.2', 252 => '18.2', 257 => '33.4', 258 => '17.4', 261 => '18.2', 262 => '18.2' },
	'commanddialsreverserotation' => { 248 => '17.1', 249 => '6.4', 251 => '6.2', 252 => '6.2', 253 => '16.2', 254 => '17.2', 257 => '33.1', 258 => '17.1', 261 => '6.2', 262 => '6.2', 263 => '18.1' },
	'commanderchannel' => { 259 => '10.2', 260 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 259 => '13.1', 260 => '31.1' },
	'commandergroupa_ttlcomp' => { 263 => '32.1' },
	'commandergroupamanualoutput' => { 259 => '13.2', 260 => '28.2' },
	'commandergroupamode' => { 259 => '11.2', 260 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 259 => '14.1', 260 => '32.1' },
	'commandergroupb_ttlcomp' => { 263 => '33.1' },
	'commandergroupbmanualoutput' => { 259 => '14.2', 260 => '29.2' },
	'commandergroupbmode' => { 259 => '11.3', 260 => '29.1' },
	'commanderinternalflash' => { 259 => '11.1', 260 => '27.1' },
	'commanderinternalmanualoutput' => { 259 => '12.2', 260 => '27.2' },
	'commanderinternalttlchannel' => { 257 => '18.2' },
	'commanderinternalttlcomp' => { 259 => '12.1', 260 => '30.2', 263 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 257 => '20.1', 258 => '26.1' },
	'commanderinternalttlcompgroupa' => { 257 => '21.1', 258 => '27.1' },
	'commanderinternalttlcompgroupb' => { 257 => '22.1', 258 => '28.1' },
	'comment' => { 0 => 0x2, 112 => 'Comment', 142 => 'Comment', 278 => 'Comment' },
	'compass' => { 349 => 0x4 },
	'complianceprofile' => { 443 => 'complianceProfile' },
	'componentsconfiguration' => { 111 => 0x9101, 147 => 'Components', 433 => 'ComponentsConfiguration' },
	'componentversion' => { 89 => 0x80c },
	'composer' => { 453 => 'composer' },
	'composition' => { 419 => 'Composition' },
	'compositionadjust' => { 319 => '0.1' },
	'compositionadjustrotation' => { 319 => 0x7 },
	'compositionadjustx' => { 319 => 0x5 },
	'compositionadjusty' => { 319 => 0x6 },
	'compressedbitsperpixel' => { 111 => 0x9102, 433 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 170 => 0x40, 270 => 0x40 },
	'compression' => { 111 => 0x103, 290 => 0xb, 449 => 'Compression' },
	'compressionfactor' => { 265 => 0x50d },
	'compressionratio' => { 147 => 'Compression', 270 => 0x1034 },
	'confidence' => { 414 => 'Confidence' },
	'confidencelevel' => { 424 => 'ConfidenceLevel' },
	'confidencemime' => { 414 => 'ConfidenceMime' },
	'constrainedcropheight' => { 100 => 0x266, 331 => 0xd6 },
	'constrainedcropwidth' => { 100 => 0x262, 331 => 0xd5 },
	'contact' => { 119 => 0x76 },
	'contactinfo' => { 442 => 'contactInfo' },
	'containerformat' => { 439 => 'ContainerFormat' },
	'containerformatidentifier' => { 439 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 439 => [\'ContainerFormat','ContainerFormatName'] },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 119 => 0x1a },
	'contentlocationname' => { 119 => 0x1b },
	'contenttype' => { 443 => 'contentType' },
	'continuousbracketing' => { 168 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousmodeliveview' => { 262 => '77.2' },
	'continuousshootingspeed' => { 76 => 0x610 },
	'continuousshotlimit' => { 76 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 104 => 0xc, 105 => [0x3012,0x20], 111 => [0xa408,0xfe54], 116 => [0x1004,0x1006], 141 => 'Contrast', 161 => 'Contrast', 165 => 0x20, 166 => 0x31, 167 => 0x27, 168 => 0x19, 173 => 0x2, 204 => 0x33, 205 => 0x37, 270 => 0x1029, 286 => 0x39, 288 => 0x300a, 320 => 0x20, 327 => 0xc, 341 => 0x24, 346 => 0x1012, 356 => 0xd, 364 => 0x1d, 365 => 0x1a, 376 => 0x2004, 429 => 'Contrast', 433 => 'Contrast' },
	'contrast2012' => { 429 => 'Contrast2012' },
	'contrastadj' => { 95 => 0x20303, 100 => 0x115, 244 => 0x2c, 409 => 0x8017 },
	'contrastauto' => { 65 => 0x90 },
	'contrastcurve' => { 202 => 0x8c },
	'contrastdetectaf' => { 177 => 0x4 },
	'contrastdetectafarea' => { 320 => 0x231 },
	'contrastdetectafinfocus' => { 177 => [0x1c,0x52] },
	'contrastfaithful' => { 18 => 0xec, 64 => 0x60, 65 => 0x60 },
	'contrasthighlight' => { 320 => 0x6d },
	'contrasthighlightshadowadj' => { 320 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 64 => 0x30, 65 => 0x30 },
	'contrastmode' => { 286 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 64 => 0x78, 65 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 64 => 0x48, 65 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 64 => 0x18, 65 => 0x18 },
	'contrastsetting' => { 265 => 0x505, 273 => 0x1012, 366 => 0x10, 381 => 0x8 },
	'contrastshadow' => { 320 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 64 => 0x0, 65 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 64 => 0x90, 65 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 64 => 0xa8, 65 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 64 => 0xc0, 65 => 0xd8 },
	'contributedmedia' => { 453 => 'contributedMedia' },
	'contributedmediaduration' => { 453 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 453 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 453 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 453 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 453 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 453 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 453 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 453 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 453 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 453 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 430 => 'contributor', 439 => 'Contributor' },
	'contributoridentifier' => { 439 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 439 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 439 => [\'Contributor','ContributorRole'] },
	'contributors' => { 142 => 'Contributors' },
	'controldialset' => { 168 => 0x46 },
	'controlledvocabularyterm' => { 439 => 'CVterm' },
	'controllerboardversion' => { 282 => 0x332 },
	'controlmode' => { 70 => 0x12 },
	'conversionlens' => { 266 => 0x403, 286 => 0x35 },
	'converter' => { 111 => 0xfe4d, 231 => 0xb, 429 => 'Converter' },
	'converttograyscale' => { 429 => 'ConvertToGrayscale' },
	'cookingequipment' => { 445 => 'cookingEquipment' },
	'cookingmethod' => { 445 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 111 => 0x8298, 142 => 'Copyright', 278 => 'Copyright', 320 => 0x22f, 336 => 'Copyright', 440 => 'Copyright', 446 => 'copyright', 449 => 'Copyright', 453 => 'copyright' },
	'copyrightflag' => { 334 => 0x40a },
	'copyrightnotice' => { 119 => 0x74 },
	'copyrightowner' => { 275 => 'CopyrightOwner' },
	'copyrightownerid' => { 275 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 275 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 275 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 275 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 275 => 'CopyrightStatus' },
	'copyrightyear' => { 439 => 'CopyrightYear', 443 => 'copyrightYear' },
	'coringfilter' => { 269 => 0x310, 270 => 0x102d, 273 => 0x310 },
	'coringvalues' => { 269 => 0x311, 273 => 0x311 },
	'corporateentity' => { 443 => 'corporateEntity' },
	'country' => { 146 => 'Country', 286 => 0x69, 441 => 'Country' },
	'country-primarylocationcode' => { 119 => 0x64 },
	'country-primarylocationname' => { 119 => 0x65 },
	'countrycode' => { 201 => 0x5, 332 => 'CountryCode', 438 => 'CountryCode' },
	'course' => { 445 => 'course' },
	'coverage' => { 430 => 'coverage' },
	'coverdate' => { 443 => 'coverDate' },
	'coverdisplaydate' => { 443 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 320 => 0x28 },
	'crc32' => { 431 => 'crc32' },
	'createdate' => { 111 => 0x9004, 142 => 'CreateDate', 274 => 'CreationDate', 278 => 'create-date', 336 => 'CreationDate', 338 => 0x1, 451 => 'CreateDate' },
	'creationdate' => { 440 => 'CreationDate', 443 => 'creationDate' },
	'creationtime' => { 278 => 'Creation Time' },
	'creativestyle' => { 364 => 0x1a, 365 => 0x18, 375 => 0x41, 376 => 0xb020, 405 => 0x4a },
	'creativestylesetting' => { 366 => 0xf, 381 => 0x7 },
	'creativestylewaschanged' => { 409 => 0x8001 },
	'creator' => { 274 => 'Creator', 336 => 'Creator', 430 => 'creator', 439 => 'Creator', 440 => 'Creator' },
	'creatoraddress' => { 438 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 163 => 'CreatorAppId' },
	'creatorcity' => { 438 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 438 => 'CreatorContactInfo' },
	'creatorcountry' => { 438 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 439 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 439 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 163 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 438 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 438 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 439 => [\'Creator','CreatorRole'] },
	'creatortool' => { 451 => 'CreatorTool' },
	'creatorworkemail' => { 438 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 438 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 438 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 119 => 0x6e, 441 => 'Credit' },
	'creditline' => { 446 => 'creditLine' },
	'creditlinereq' => { 456 => 'CreditLineReq' },
	'creditlinerequired' => { 275 => 'CreditLineRequired' },
	'cropactive' => { 93 => 0x0, 100 => 0x244 },
	'cropangle' => { 429 => 'CropAngle' },
	'cropaspectratio' => { 95 => 0x30101, 100 => 0x260 },
	'cropaspectratiocustom' => { 95 => 0x30102 },
	'cropbottom' => { 115 => 0x9, 236 => 0x36, 290 => 0x31, 331 => 0xdc, 429 => 'CropBottom' },
	'cropbottommargin' => { 48 => 0x3 },
	'cropcircleactive' => { 101 => 0xd6 },
	'cropcircleradius' => { 101 => 0xd9 },
	'cropcirclex' => { 101 => 0xd7 },
	'cropcircley' => { 101 => 0xd8 },
	'cropconstraintowarp' => { 429 => 'CropConstrainToWarp' },
	'croph' => { 422 => 'CropH' },
	'cropheight' => { 93 => 0x6, 100 => 0x24c, 269 => 0x615, 273 => 0x615, 429 => 'CropHeight' },
	'crophispeed' => { 202 => 0x1b },
	'cropleft' => { 100 => 0x246, 115 => 0x6, 236 => 0x1e, 269 => 0x612, 273 => 0x612, 290 => 0x30, 331 => 0xd9, 429 => 'CropLeft' },
	'cropleftmargin' => { 48 => 0x0 },
	'cropmode35mm' => { 346 => 0x1018 },
	'croporiginalheight' => { 93 => 0xb },
	'croporiginalwidth' => { 93 => 0xa },
	'cropoutputheight' => { 236 => 0xce },
	'cropoutputheightinches' => { 236 => 0x96 },
	'cropoutputpixels' => { 236 => 0xd6 },
	'cropoutputresolution' => { 236 => 0xb6 },
	'cropoutputscale' => { 236 => 0xbe },
	'cropoutputwidth' => { 236 => 0xc6 },
	'cropoutputwidthinches' => { 236 => 0x8e },
	'croppedareaimageheightpixels' => { 417 => 'CroppedAreaImageHeightPixels', 418 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 417 => 'CroppedAreaImageWidthPixels', 418 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 417 => 'CroppedAreaLeftPixels', 418 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 417 => 'CroppedAreaTopPixels', 418 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 346 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 346 => 0x1603 },
	'cropright' => { 115 => 0x8, 236 => 0x2e, 290 => 0x32, 331 => 0xdb, 429 => 'CropRight' },
	'croprightmargin' => { 48 => 0x1 },
	'croprotatedoriginalheight' => { 93 => 0x2 },
	'croprotatedoriginalwidth' => { 93 => 0x1 },
	'croprotation' => { 93 => 0x8, 115 => 0xb },
	'cropscaledresolution' => { 236 => 0x9e },
	'cropsourceresolution' => { 236 => 0xae },
	'croptop' => { 100 => 0x248, 115 => 0x7, 236 => 0x26, 269 => 0x613, 273 => 0x613, 290 => 0x2f, 331 => 0xda, 429 => 'CropTop' },
	'croptopmargin' => { 48 => 0x2 },
	'cropunit' => { 429 => 'CropUnit' },
	'cropunits' => { 429 => 'CropUnits' },
	'cropw' => { 422 => 'CropW' },
	'cropwidth' => { 93 => 0x5, 100 => 0x24a, 269 => 0x614, 273 => 0x614, 429 => 'CropWidth' },
	'cropx' => { 93 => 0x3, 422 => 'CropX' },
	'cropy' => { 93 => 0x4, 422 => 'CropY' },
	'crossprocess' => { 320 => 0x7b },
	'crossprocessparams' => { 320 => 0x235 },
	'cuisine' => { 445 => 'cuisine' },
	'currenticcprofile' => { 111 => 0xc691 },
	'currentpreprofilematrix' => { 111 => 0xc692 },
	'currentversion' => { 409 => 0xd000 },
	'curve0x' => { 422 => 'Curve0x' },
	'curve0y' => { 422 => 'Curve0y' },
	'curve1x' => { 422 => 'Curve1x' },
	'curve1y' => { 422 => 'Curve1y' },
	'curve2x' => { 422 => 'Curve2x' },
	'curve2y' => { 422 => 'Curve2y' },
	'curve3x' => { 422 => 'Curve3x' },
	'curve3y' => { 422 => 'Curve3y' },
	'curve4x' => { 422 => 'Curve4x' },
	'curve4y' => { 422 => 'Curve4y' },
	'curves' => { 241 => 0x76a43201 },
	'custom1' => { 275 => 'Custom1' },
	'custom10' => { 275 => 'Custom10' },
	'custom2' => { 275 => 'Custom2' },
	'custom3' => { 275 => 'Custom3' },
	'custom4' => { 275 => 'Custom4' },
	'custom5' => { 275 => 'Custom5' },
	'custom6' => { 275 => 'Custom6' },
	'custom7' => { 275 => 'Custom7' },
	'custom8' => { 275 => 'Custom8' },
	'custom9' => { 275 => 'Custom9' },
	'customcolortone' => { 101 => 0x4c },
	'customcontrast' => { 101 => 0x4e },
	'customcontrols' => { 76 => 0x70c },
	'customdefaultunsharpfineness' => { 101 => 0xbe },
	'customdefaultunsharpstrength' => { 101 => 0xbc },
	'customdefaultunsharpthreshold' => { 101 => 0xc0 },
	'customlinear' => { 101 => 0x4f },
	'customoutputhighlightpoint' => { 101 => 0x53 },
	'customoutputshadowpoint' => { 101 => 0x54 },
	'custompicturestyle' => { 95 => 0x10021 },
	'custompicturestyledata' => { 95 => 0xf0500 },
	'custompicturestylefilename' => { 58 => 0x4010 },
	'customrawhighlight' => { 101 => 0x7c },
	'customrawhighlightpoint' => { 101 => 0x51 },
	'customrawshadow' => { 101 => 0x85 },
	'customrawshadowpoint' => { 101 => 0x52 },
	'customrendered' => { 111 => 0xa401, 433 => 'CustomRendered' },
	'customsaturation' => { 101 => 0x4d, 265 => 0x503 },
	'customsettingsalldefault' => { 248 => '0.2', 257 => '0.2' },
	'customsettingsbank' => { 248 => '0.1', 249 => '0.1', 251 => '0.1', 252 => '0.1', 257 => '0.1', 261 => '0.2', 262 => '0.2' },
	'customsharpness' => { 101 => 0x50 },
	'customunsharpmaskfineness' => { 101 => 0xb8 },
	'customunsharpmaskstrength' => { 101 => 0xb6 },
	'customunsharpmaskthreshold' => { 101 => 0xba },
	'customwb_rblevels' => { 381 => 0x1a },
	'customwb_rgblevels' => { 365 => 0x8, 366 => 0x19 },
	'customwbbluelevel' => { 168 => 0x36 },
	'customwberror' => { 168 => 0x37 },
	'customwbgreenlevel' => { 168 => 0x35 },
	'customwbredlevel' => { 168 => 0x34 },
	'customwbsetting' => { 168 => 0x26 },
	'd-lightinghq' => { 241 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 237 => 0x2 },
	'd-lightinghqhighlight' => { 237 => 0x1 },
	'd-lightinghqselected' => { 241 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 237 => 0x0 },
	'd-lightinghs' => { 241 => 0xce5554aa },
	'd-lightinghsadjustment' => { 238 => 0x0 },
	'd-lightinghscolorboost' => { 238 => 0x1 },
	'd-rangeoptimizerhighlight' => { 409 => 0x8024 },
	'd-rangeoptimizermode' => { 409 => 0x8022 },
	'd-rangeoptimizershadow' => { 409 => 0x802d },
	'd-rangeoptimizervalue' => { 409 => 0x8023 },
	'd810meteringmode' => { 228 => 0x175e },
	'data' => { 414 => 'Data' },
	'datacompressionmethod' => { 121 => 0x6e },
	'dataimprint' => { 165 => 0x34 },
	'dataonscreen' => { 439 => 'DataOnScreen' },
	'dataonscreenregion' => { 439 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 439 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 439 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 439 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 439 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 439 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 439 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 439 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 320 => 0x3d },
	'date' => { 320 => 0x6, 430 => 'date' },
	'dateacquired' => { 163 => 'DateAcquired' },
	'datecreated' => { 119 => 0x37, 441 => 'DateCreated' },
	'datedisplayformat' => { 233 => 0x3 },
	'dateidentified' => { 110 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 253 => '4.2' },
	'daterecieved' => { 443 => 'dateRecieved' },
	'datesent' => { 120 => 0x46 },
	'datestampmode' => { 58 => 0x1c },
	'datetime' => { 423 => 'datetime', 449 => 'DateTime' },
	'datetimedigitized' => { 433 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 92 => 0x0, 111 => 0x9003, 139 => 0x14, 142 => 'OriginalDate', 341 => 0xb, 342 => 0x3b, 433 => 'DateTimeOriginal' },
	'datetimestamp' => { 127 => 0x64 },
	'datetimeutc' => { 265 => 0x908 },
	'daylightsavings' => { 71 => 0x3, 233 => 0x2 },
	'dayofweek' => { 342 => 0x42 },
	'dccontinent' => { 110 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 110 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 110 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 110 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 110 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 110 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 110 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 110 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 110 => 'Event' },
	'dcfootprintspatialfit' => { 110 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 110 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 110 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 110 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 110 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 110 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 110 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 110 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 110 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 110 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 110 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 110 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 110 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 110 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 110 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 110 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 110 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 110 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 110 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 110 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 110 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 110 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 110 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 110 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 110 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 110 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 110 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 110 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 110 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 110 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 110 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 110 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 110 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 110 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 110 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 110 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 110 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 150 => 'Declination' },
	'decposition' => { 165 => 0x32 },
	'defaultautogray' => { 429 => 'DefaultAutoGray' },
	'defaultautotone' => { 429 => 'DefaultAutoTone' },
	'defaultblackrender' => { 111 => 0xc7a6 },
	'defaultcroporigin' => { 111 => 0xc61f },
	'defaultcropsize' => { 111 => 0xc620 },
	'defaulteraseoption' => { 76 => 0x813 },
	'defaultscale' => { 111 => 0xc61e },
	'defaultsspecifictoiso' => { 429 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 429 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 111 => 0xc7b5 },
	'defringe' => { 429 => 'Defringe' },
	'defringegreenamount' => { 429 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 429 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 429 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 429 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 429 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 429 => 'DefringePurpleHueLo' },
	'dehaze' => { 429 => 'Dehaze' },
	'deletedimagecount' => { 202 => 0xa6, 210 => 0x6e },
	'deprecatedon' => { 426 => 'deprecatedOn' },
	'derivedfrom' => { 454 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 454 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 454 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 454 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 454 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 454 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 454 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 454 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 454 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 454 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 454 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 454 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 454 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 454 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 454 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 454 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 454 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 454 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 454 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 454 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 454 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 454 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 454 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 454 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 278 => 'Description', 430 => 'description', 451 => 'Description' },
	'destination' => { 120 => 0x5 },
	'destinationcity' => { 320 => 0x24, 326 => 0x3 },
	'destinationcitycode' => { 327 => 0x1001 },
	'destinationdst' => { 320 => 0x26, 326 => '0.3' },
	'developmentdynamicrange' => { 116 => 0x1403 },
	'device' => { 443 => 'device' },
	'devicesettingdescription' => { 433 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 433 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 433 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 433 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 353 => 0x2 },
	'dialdirectiontvav' => { 76 => 0x706 },
	'dietaryneeds' => { 445 => 'dietaryNeeds' },
	'diffractioncorrection' => { 310 => 0x3 },
	'diffractioncorrectionon' => { 95 => 0x2070b },
	'digitalcreationdate' => { 119 => 0x3e },
	'digitalcreationtime' => { 119 => 0x3f },
	'digitaldeehighlightadj' => { 209 => 0x202 },
	'digitaldeeshadowadj' => { 209 => 0x200 },
	'digitaldeethreshold' => { 209 => 0x201 },
	'digitalfilter' => { 356 => 0x59 },
	'digitalfilter01' => { 307 => 0x5 },
	'digitalfilter02' => { 307 => 0x16 },
	'digitalfilter03' => { 307 => 0x27 },
	'digitalfilter04' => { 307 => 0x38 },
	'digitalfilter05' => { 307 => 0x49 },
	'digitalfilter06' => { 307 => 0x5a },
	'digitalfilter07' => { 307 => 0x6b },
	'digitalfilter08' => { 307 => 0x7c },
	'digitalfilter09' => { 307 => 0x8d },
	'digitalfilter10' => { 307 => 0x9e },
	'digitalfilter11' => { 307 => 0xaf },
	'digitalfilter12' => { 307 => 0xc0 },
	'digitalfilter13' => { 307 => 0xd1 },
	'digitalfilter14' => { 307 => 0xe2 },
	'digitalfilter15' => { 307 => 0xf3 },
	'digitalfilter16' => { 307 => 0x104 },
	'digitalfilter17' => { 307 => 0x115 },
	'digitalfilter18' => { 307 => 0x126 },
	'digitalfilter19' => { 307 => 0x137 },
	'digitalfilter20' => { 307 => 0x148 },
	'digitalgain' => { 68 => 0xb },
	'digitalgem' => { 194 => 0x0 },
	'digitalice' => { 209 => 0x100 },
	'digitalimageguid' => { 439 => 'DigImageGUID' },
	'digitalroc' => { 207 => 0x0 },
	'digitalsourcefiletype' => { 439 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 439 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 104 => 0xa, 116 => 0x1044, 127 => 0x68, 141 => 'DigitalZoom', 165 => 0xc, 202 => 0x86, 231 => 0xa, 270 => 0x204, 320 => 0x1e, 327 => 0xa, 355 => 0x204, 396 => 0x12, 397 => 0x12 },
	'digitalzoomon' => { 355 => 0x21b },
	'digitalzoomratio' => { 111 => 0xa404, 386 => 0x200, 388 => 0x21c, 433 => 'DigitalZoomRatio' },
	'director' => { 453 => 'director' },
	'directorphotography' => { 453 => 'directorPhotography' },
	'directory' => { 112 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 189 => 0x3 },
	'disclaimer' => { 278 => 'Disclaimer' },
	'discnumber' => { 453 => 'discNumber' },
	'dishtype' => { 445 => 'dishType' },
	'displayallafpoints' => { 76 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 335 => 0x2 },
	'displayedunitsy' => { 335 => 0x6 },
	'displayname' => { 442 => 'displayName' },
	'distance1' => { 127 => 0x28 },
	'distance2' => { 127 => 0x2c },
	'distance3' => { 127 => 0x30 },
	'distance4' => { 127 => 0x34 },
	'distortion' => { 353 => 0xa050 },
	'distortioncontrol' => { 210 => 0x10 },
	'distortioncorrection' => { 95 => 0x20705, 101 => 0x67, 265 => 0x50b, 289 => '7.1', 310 => 0x0, 404 => 0x601, 405 => 0x5b },
	'distortioncorrection2' => { 269 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 425 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 95 => '0x20705.0', 101 => 0x63 },
	'distortioncorrectionsetting' => { 376 => 0x2013 },
	'distortioncorrparams' => { 111 => 0x7037, 385 => 0x1a23, 388 => 0x1870, 390 => 0x189c, 391 => 0x18cc, 392 => 0x17d0, 404 => 0x6ca, 405 => 0x64 },
	'distortioncorrparamsnumber' => { 388 => 0x1899, 390 => 0x18c5, 391 => 0x18f5, 392 => 0x17f9 },
	'distortioncorrparamspresent' => { 388 => 0x1898, 390 => 0x18c4, 391 => 0x18f4, 392 => 0x17f8, 394 => 0x10b, 395 => 0x10b, 404 => 0x600, 405 => 0x5a },
	'distortioneffect' => { 95 => 0x20709 },
	'distortionn' => { 289 => 0xc },
	'distortionparam02' => { 289 => 0x2 },
	'distortionparam04' => { 289 => 0x4 },
	'distortionparam08' => { 289 => 0x8 },
	'distortionparam09' => { 289 => 0x9 },
	'distortionparam11' => { 289 => 0xb },
	'distortionscale' => { 289 => 0x5 },
	'distributor' => { 443 => 'distributor' },
	'distributorproductid' => { 442 => 'distributorProductID' },
	'dloon' => { 95 => '0x20706.0', 101 => 0xdc },
	'dlosetting' => { 95 => 0x20706, 101 => 0xdd },
	'dlosettingapplied' => { 94 => 0x4 },
	'dloshootingdistance' => { 101 => 0xde },
	'dloversion' => { 94 => 0x5 },
	'dmcomment' => { 453 => 'comment' },
	'dngadobedata' => { 111 => 0xc634 },
	'dngbackwardversion' => { 111 => 0xc613 },
	'dngignoresidecars' => { 429 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 111 => 0xc630 },
	'dngprivatedata' => { 111 => 0xc634 },
	'dngversion' => { 111 => 0xc612 },
	'document' => { 278 => 'Document' },
	'documentancestors' => { 441 => 'DocumentAncestors' },
	'documenthistory' => { 119 => 0xe7 },
	'documentid' => { 454 => 'DocumentID' },
	'documentname' => { 111 => 0x10d },
	'documentnotes' => { 119 => 0xe6 },
	'doi' => { 443 => 'doi' },
	'dopesheet' => { 439 => 'Dopesheet' },
	'dopesheetlink' => { 439 => 'DopesheetLink' },
	'dopesheetlinklink' => { 439 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 439 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'dpp' => { 423 => 'dpp' },
	'dr4cameramodel' => { 96 => 0x3 },
	'drivemode' => { 105 => 0x3103, 165 => 0x6, 168 => 0x1e, 171 => 0xe, 265 => 0x600, 320 => 0x34, 346 => 0x1002, 356 => 0x3, 364 => 0x4, 365 => 0x7e, 366 => 0x34 },
	'drivemode2' => { 168 => 0xa, 301 => 0x7, 375 => 0xe, 381 => 0x1 },
	'drivemodesetting' => { 366 => 0x4 },
	'dspfirmwareversion' => { 320 => 0x27 },
	'duration' => { 61 => 0x6a, 140 => 'Duration', 154 => 'Duration', 445 => 'duration', 453 => 'duration' },
	'durationscale' => { 453 => [\'duration','durationScale'] },
	'durationvalue' => { 453 => [\'duration','durationValue'] },
	'dustremovaldata' => { 58 => 0x97 },
	'dynamicafarea' => { 248 => '1.4', 257 => '1.4' },
	'dynamicareaafdisplay' => { 249 => '46.1', 251 => '47.1', 252 => '47.1', 261 => '47.1', 262 => '47.1' },
	'dynamicrange' => { 116 => 0x1400 },
	'dynamicrangeexpansion' => { 320 => 0x69, 346 => 0x100e },
	'dynamicrangemax' => { 100 => 0x7c },
	'dynamicrangemin' => { 100 => 0x7a },
	'dynamicrangeoptimizer' => { 168 => 0x15, 376 => [0xb025,0xb04f], 384 => 0x1144, 385 => [0x1144,0x324], 386 => [0x1120,0x300], 387 => [0x119c,0x37c], 388 => [0x1178,0x328], 389 => [0x1030,0x50], 390 => [0x228,0x50], 391 => [0x228,0x50], 392 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 375 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 364 => 0x19, 365 => 0x17, 366 => 0xd, 375 => 0x79, 381 => 0x5 },
	'dynamicrangeoptimizermode' => { 171 => 0x15, 364 => 0x18, 365 => 0x16, 375 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 168 => 0x27, 366 => 0xc, 381 => 0x4 },
	'dynamicrangesetting' => { 116 => 0x1402 },
	'e-dialinprogram' => { 301 => '1.3' },
	'earliestageorloweststage' => { 110 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 110 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 110 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 110 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 110 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 263 => '6.1' },
	'easyexposurecompensation' => { 248 => '6.4', 249 => '6.5', 251 => '6.3', 252 => '6.3', 256 => '5.1', 257 => '4.4', 258 => '5.2', 261 => '6.3', 262 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgenoisereduction' => { 242 => 0x4, 409 => 0x8028 },
	'edition' => { 443 => 'edition' },
	'editorialupdate' => { 119 => 0x8 },
	'editstatus' => { 119 => 0x7, 332 => 'EditStatus', 423 => 'EditStatus' },
	'editversionname' => { 241 => 0x3d136244 },
	'effectivelv' => { 320 => 0x2d },
	'effectivemaxaperture' => { 198 => 0x12, 199 => 0x13 },
	'eissn' => { 443 => 'eIssn' },
	'electronicfront-curtainshutter' => { 251 => '5.2', 252 => '5.2', 261 => '5.3', 262 => '5.2' },
	'electronicfrontcurtainshutter' => { 376 => 0x201a },
	'elevation' => { 150 => 'Elevation' },
	'email' => { 142 => 'EMail' },
	'embargodate' => { 446 => 'embargoDate' },
	'embdencrightsexpr' => { 439 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 439 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 439 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 439 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 441 => 'EmbeddedXMPDigest' },
	'emissivity' => { 113 => 0x3 },
	'encryptionkey' => { 353 => 0xa020 },
	'endingpage' => { 443 => 'endingPage' },
	'enduser' => { 275 => 'EndUser' },
	'enduserid' => { 275 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 275 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 453 => 'engineer' },
	'enhancedarktones' => { 234 => 0x8 },
	'enhancement' => { 104 => 0x16, 105 => 0x3016 },
	'enhancer' => { 269 => 0x300 },
	'enhancervalues' => { 269 => 0x301 },
	'envelopenumber' => { 120 => 0x28 },
	'envelopepriority' => { 120 => 0x3c },
	'enveloperecordversion' => { 120 => 0x0 },
	'episode' => { 439 => 'Episode' },
	'episodeidentifier' => { 439 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 439 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 439 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 270 => 0x20c },
	'epsonimagewidth' => { 270 => 0x20b },
	'epsonsoftware' => { 270 => 0x20d },
	'equipmentinstitution' => { 411 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 411 => 'EquipmentManufacturer' },
	'equipmentversion' => { 266 => 0x0 },
	'ettlii' => { 76 => 0x304, 77 => 0xd, 78 => 0xe, 79 => 0x7, 80 => 0x7, 81 => 0xe },
	'event' => { 412 => 'Event', 421 => 'Event', 439 => 'Event', 443 => 'event' },
	'eventalias' => { 442 => 'eventAlias' },
	'eventday' => { 110 => [\'Event','EventDay'] },
	'eventearliestdate' => { 110 => [\'Event','EventEarliestDate'] },
	'eventend' => { 442 => 'eventEnd' },
	'eventenddayofyear' => { 110 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 110 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 110 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 110 => [\'Event','EventHabitat'] },
	'eventid' => { 110 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 110 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 110 => [\'Event','EventMonth'] },
	'eventnumber' => { 341 => 0x9, 342 => 0x37 },
	'eventremarks' => { 110 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 110 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 110 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 442 => 'eventStart' },
	'eventstartdayofyear' => { 110 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 442 => 'eventSubtype' },
	'eventtime' => { 110 => [\'Event','EventEventTime'] },
	'eventtype' => { 442 => 'eventType' },
	'eventverbatimeventdate' => { 110 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 110 => [\'Event','EventYear'] },
	'evsteps' => { 301 => '1.2', 303 => 0x0 },
	'evstepsize' => { 253 => '5.1', 254 => '6.1', 255 => '6.1', 259 => '0.7' },
	'exclusivecoverage' => { 419 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 446 => 'exclusivityEndDate' },
	'excursiontolerance' => { 121 => 0x82 },
	'exif' => { 112 => 'EXIF' },
	'exifbyteorder' => { 112 => 'ExifByteOrder' },
	'exifcamerainfo' => { 119 => 0xe8 },
	'exifimageheight' => { 111 => 0xa003, 433 => 'PixelYDimension' },
	'exifimagewidth' => { 111 => 0xa002, 433 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 112 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 111 => 0x9000, 433 => 'ExifVersion' },
	'exitpupilposition' => { 198 => 0x4, 199 => 0x4 },
	'expirationdate' => { 119 => 0x25, 446 => 'expirationDate' },
	'expirationtime' => { 119 => 0x26 },
	'exposure' => { 111 => 0xfe51, 429 => 'Exposure' },
	'exposure2012' => { 429 => 'Exposure2012' },
	'exposureadj' => { 239 => 0x0 },
	'exposureadj2' => { 239 => 0x12 },
	'exposureadjust' => { 356 => 0xc },
	'exposurebracketingindicatorlast' => { 168 => 0x52 },
	'exposurebracketshotnumber' => { 171 => 0x2d, 375 => 0x2f },
	'exposurebracketstepsize' => { 301 => 0x8 },
	'exposurebracketvalue' => { 202 => 0x19 },
	'exposurecompensation' => { 70 => 0x6, 85 => 0x0, 111 => 0x9204, 127 => 0x24, 141 => 'ExposureComp', 161 => 'ExposureCompensation', 165 => 0xd, 166 => 0x53, 167 => 0x1e, 171 => 0x49c0, 270 => 0x1006, 320 => 0x16, 329 => 0x402, 353 => 0xa013, 356 => [0xc,0x35,0x4d], 384 => 0x114c, 385 => 0x114c, 386 => 0x1128, 388 => 0x1180, 389 => 0x1038, 390 => 0x230, 391 => 0x230, 392 => 0x223, 433 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 381 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 168 => 0x47, 171 => 0x2a },
	'exposurecompensationset' => { 364 => 0x3, 365 => 0x3, 366 => 0x3, 381 => 0x1e },
	'exposurecompensationsetting' => { 168 => 0x1 },
	'exposurecompstepsize' => { 248 => '6.3', 249 => '7.3', 251 => '7.3', 252 => '7.3', 257 => '4.3', 261 => '7.3', 262 => '7.3' },
	'exposurecontrolstep' => { 256 => '6.1', 258 => '6.1' },
	'exposurecontrolstepsize' => { 248 => '6.2', 249 => '7.1', 251 => '7.1', 252 => '7.1', 257 => '4.2', 261 => '7.1', 262 => '7.1', 263 => '7.1' },
	'exposurecount' => { 116 => 0x1032 },
	'exposuredelaymode' => { 248 => '10.1', 249 => '11.1', 251 => '11.1', 252 => '11.1', 253 => '9.1', 254 => '10.1', 255 => '10.1', 257 => '10.4', 258 => '10.1', 259 => '6.4', 261 => '11.1', 262 => '11.1', 263 => '11.2' },
	'exposuredifference' => { 202 => 0xe },
	'exposureindex' => { 111 => 0xa215, 433 => 'ExposureIndex' },
	'exposureindicator' => { 168 => 0x50 },
	'exposurelevelincrements' => { 74 => 0x6, 75 => 0x6, 76 => 0x101, 77 => 0x5, 78 => 0x6, 79 => 0x5, 80 => 0x5, 81 => 0x6, 82 => 0x4, 364 => 0x58, 365 => 0x58 },
	'exposurelockused' => { 417 => 'ExposureLockUsed' },
	'exposuremode' => { 111 => 0xa402, 141 => 'ExposureMode', 165 => 0x1, 166 => 0xa, 167 => 0x0, 168 => 0x0, 171 => 0x34, 265 => 0x200, 284 => 0x40d, 356 => 0x8, 376 => 0xb041, 433 => 'ExposureMode' },
	'exposuremodeinmanual' => { 76 => 0x10b },
	'exposureprogram' => { 111 => 0x8822, 346 => 0x1001, 357 => [0x17e,0x43], 364 => 0x3c, 365 => 0x3c, 366 => 0x5, 370 => 0x14, 375 => 0x3f, 381 => 0x2, 384 => 0x1175, 385 => 0x1179, 386 => 0x1155, 387 => 0x11d1, 388 => 0x11ad, 389 => 0x1065, 390 => 0x25d, 391 => 0x25d, 392 => 0x24c, 401 => 0xb, 402 => 0xc, 403 => 0xb, 405 => 0x48, 433 => 'ExposureProgram' },
	'exposureshift' => { 265 => 0x203 },
	'exposurestandardadjustment' => { 376 => 0x202d },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 70 => 0x16, 111 => 0x829a, 124 => 0xfd05, 127 => 0x20, 129 => 0xfa24, 131 => 0xf104, 134 => 0x12, 136 => 0x38, 139 => 0x10, 141 => 'ExposureTime', 165 => 0x9, 166 => 0x35, 167 => 0x48, 168 => 0x8, 171 => 0x49b8, 320 => 0x12, 353 => 0xa018, 356 => [0x32,0x4a], 364 => 0x0, 365 => 0x0, 381 => [0x21,0x23,0x27], 405 => 0x10, 433 => 'ExposureTime' },
	'exposuretime2' => { 356 => [0x33,0x4b] },
	'exposuretuning' => { 202 => 0x1c },
	'exposurevalue' => { 125 => 0x3 },
	'exposurewarning' => { 116 => 0x1302 },
	'exrauto' => { 116 => 0x1033 },
	'exrmode' => { 116 => 0x1034 },
	'extendedwbdetect' => { 265 => 0x902 },
	'extender' => { 266 => 0x301 },
	'extenderfirmwareversion' => { 266 => 0x304 },
	'extendermagnification' => { 143 => 'Magnification' },
	'extendermake' => { 143 => 'Make' },
	'extendermodel' => { 143 => 'Model', 266 => 0x303 },
	'extenderserialnumber' => { 143 => 'SerialNumber', 266 => 0x302 },
	'extenderstatus' => { 318 => 0x3 },
	'externalflash' => { 268 => 0x1201 },
	'externalflashae1' => { 270 => 0x101f },
	'externalflashae1_0' => { 270 => 0x101b },
	'externalflashae2' => { 270 => 0x1020 },
	'externalflashae2_0' => { 270 => 0x101c },
	'externalflashbounce' => { 268 => 0x1204, 270 => 0x1026, 308 => 0x1a },
	'externalflashcompensation' => { 192 => 0x1b },
	'externalflashexposurecomp' => { 202 => 0x17, 308 => 0x19 },
	'externalflashfirmware' => { 190 => 0x6, 191 => 0x6, 192 => 0x6, 193 => 0x6 },
	'externalflashflags' => { 190 => 0x8, 191 => 0x8, 192 => 0x8 },
	'externalflashguidenumber' => { 268 => 0x1203, 308 => '24.1' },
	'externalflashgvalue' => { 270 => 0x1025 },
	'externalflashmode' => { 270 => 0x1028, 308 => 0x2 },
	'externalflashreadystate' => { 193 => '9.1' },
	'externalflashstatus' => { 193 => '8.2' },
	'externalflashzoom' => { 268 => 0x1205, 270 => 0x1027 },
	'externalflashzoomoverride' => { 193 => '8.1' },
	'externalmetadatalink' => { 439 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 282 => 0x311, 288 => 0x3408 },
	'extrainfoversion' => { 368 => 0x1a },
	'eyestartaf' => { 168 => 0x40 },
	'face10position' => { 102 => 0x3f4, 103 => 0x1ec, 188 => 0x28, 305 => 0x12 },
	'face10size' => { 306 => 0x12 },
	'face11position' => { 188 => 0x2c, 305 => 0x14 },
	'face11size' => { 306 => 0x14 },
	'face12position' => { 188 => 0x30, 305 => 0x16 },
	'face12size' => { 306 => 0x16 },
	'face13position' => { 305 => 0x18 },
	'face13size' => { 306 => 0x18 },
	'face14position' => { 305 => 0x1a },
	'face14size' => { 306 => 0x1a },
	'face15position' => { 305 => 0x1c },
	'face15size' => { 306 => 0x1c },
	'face16position' => { 305 => 0x1e },
	'face16size' => { 306 => 0x1e },
	'face17position' => { 305 => 0x20 },
	'face17size' => { 306 => 0x20 },
	'face18position' => { 305 => 0x22 },
	'face18size' => { 306 => 0x22 },
	'face19position' => { 305 => 0x24 },
	'face19size' => { 306 => 0x24 },
	'face1position' => { 49 => 0x8, 102 => 0xd, 103 => 0x18, 188 => 0x4, 280 => 0x1, 305 => 0x0, 343 => 0xbc, 371 => 0x1, 372 => 0x0, 373 => 0x0, 374 => 0x5b },
	'face1size' => { 306 => 0x0 },
	'face20position' => { 305 => 0x26 },
	'face20size' => { 306 => 0x26 },
	'face21position' => { 305 => 0x28 },
	'face21size' => { 306 => 0x28 },
	'face22position' => { 305 => 0x2a },
	'face22size' => { 306 => 0x2a },
	'face23position' => { 305 => 0x2c },
	'face23size' => { 306 => 0x2c },
	'face24position' => { 305 => 0x2e },
	'face24size' => { 306 => 0x2e },
	'face25position' => { 305 => 0x30 },
	'face25size' => { 306 => 0x30 },
	'face26position' => { 305 => 0x32 },
	'face26size' => { 306 => 0x32 },
	'face27position' => { 305 => 0x34 },
	'face27size' => { 306 => 0x34 },
	'face28position' => { 305 => 0x36 },
	'face28size' => { 306 => 0x36 },
	'face29position' => { 305 => 0x38 },
	'face29size' => { 306 => 0x38 },
	'face2position' => { 49 => 0xa, 102 => 0x7c, 103 => 0x4c, 188 => 0x8, 280 => 0x5, 305 => 0x2, 343 => 0xc8, 371 => 0x6, 372 => 0x20, 373 => 0x25, 374 => 0x65 },
	'face2size' => { 306 => 0x2 },
	'face30position' => { 305 => 0x3a },
	'face30size' => { 306 => 0x3a },
	'face31position' => { 305 => 0x3c },
	'face31size' => { 306 => 0x3c },
	'face32position' => { 305 => 0x3e },
	'face32size' => { 306 => 0x3e },
	'face3position' => { 49 => 0xc, 102 => 0xeb, 103 => 0x80, 188 => 0xc, 280 => 0x9, 305 => 0x4, 343 => 0xd4, 371 => 0xb, 372 => 0x40, 373 => 0x4a, 374 => 0x6f },
	'face3size' => { 306 => 0x4 },
	'face4position' => { 49 => 0xe, 102 => 0x15a, 103 => 0xb4, 188 => 0x10, 280 => 0xd, 305 => 0x6, 343 => 0xe0, 371 => 0x10, 372 => 0x60, 373 => 0x6f, 374 => 0x79 },
	'face4size' => { 306 => 0x6 },
	'face5position' => { 49 => 0x10, 102 => 0x1c9, 103 => 0xe8, 188 => 0x14, 280 => 0x11, 305 => 0x8, 343 => 0xec, 371 => 0x15, 372 => 0x80, 373 => 0x94 },
	'face5size' => { 306 => 0x8 },
	'face6position' => { 49 => 0x12, 102 => 0x238, 103 => 0x11c, 188 => 0x18, 305 => 0xa, 343 => 0xf8, 371 => 0x1a, 372 => 0xa0, 373 => 0xb9 },
	'face6size' => { 306 => 0xa },
	'face7position' => { 49 => 0x14, 102 => 0x2a7, 103 => 0x150, 188 => 0x1c, 305 => 0xc, 343 => 0x104, 371 => 0x1f, 372 => 0xc0, 373 => 0xde },
	'face7size' => { 306 => 0xc },
	'face8position' => { 49 => 0x16, 102 => 0x316, 103 => 0x184, 188 => 0x20, 305 => 0xe, 343 => 0x110, 371 => 0x24, 372 => 0xe0, 373 => 0x103 },
	'face8size' => { 306 => 0xe },
	'face9position' => { 49 => 0x18, 102 => 0x385, 103 => 0x1b8, 188 => 0x24, 305 => 0x10 },
	'face9size' => { 306 => 0x10 },
	'facebalanceorigi' => { 422 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 422 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 422 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 422 => 'FaceBalanceWarmth' },
	'facedetect' => { 320 => 0x76, 353 => 0x100 },
	'facedetectarea' => { 269 => 0x1201 },
	'facedetectframecrop' => { 269 => 0x1207 },
	'facedetectframesize' => { 49 => 0x3, 102 => 0x1, 103 => 0x4, 188 => 0x1, 269 => 0x1203, 320 => 0x77, 343 => 0xb6 },
	'facedetection' => { 366 => 0x30, 381 => 0x19 },
	'faceelementpositions' => { 116 => 0x4203 },
	'faceelementtypes' => { 116 => 0x4201 },
	'faceid' => { 424 => 'FaceID' },
	'faceinfounknown' => { 105 => 0x2089 },
	'facename' => { 353 => 0x123 },
	'faceorientation' => { 103 => 0x8 },
	'faceposition' => { 304 => 0x2, 354 => 0x4 },
	'facepositions' => { 116 => 0x4103 },
	'facerecognition' => { 353 => 0x120 },
	'facesdetected' => { 49 => 0x2, 50 => 0x2, 51 => 0x3, 102 => 0x0, 103 => 0x2, 105 => 0x211c, 116 => 0x4100, 188 => 0x3, 269 => 0x1200, 286 => 0x3f, 304 => 0x0, 343 => 0xb5, 354 => 0x0, 371 => 0x0, 374 => 0x3, 383 => 0x30 },
	'facesrecognized' => { 281 => 0x0 },
	'facewidth' => { 50 => 0x1 },
	'faithfuloutputhighlightpoint' => { 101 => 0x38 },
	'faithfuloutputshadowpoint' => { 101 => 0x39 },
	'faithfulrawcolortone' => { 101 => 0x31 },
	'faithfulrawcontrast' => { 101 => 0x33 },
	'faithfulrawhighlight' => { 101 => 0x79 },
	'faithfulrawhighlightpoint' => { 101 => 0x36 },
	'faithfulrawlinear' => { 101 => 0x34 },
	'faithfulrawsaturation' => { 101 => 0x32 },
	'faithfulrawshadow' => { 101 => 0x82 },
	'faithfulrawshadowpoint' => { 101 => 0x37 },
	'faithfulrawsharpness' => { 101 => 0x35 },
	'faithfulunsharpmaskfineness' => { 101 => 0xac },
	'faithfulunsharpmaskstrength' => { 101 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 101 => 0xae },
	'far' => { 414 => 'Far' },
	'feedidentifier' => { 439 => 'FeedIdentifier' },
	'femicroadjustment' => { 76 => 0x111 },
	'ffid' => { 431 => 'ffid' },
	'field' => { 442 => 'field' },
	'fieldcount' => { 270 => 0x103f },
	'filecreatedate' => { 112 => 'FileCreateDate' },
	'filedatarate' => { 453 => 'fileDataRate' },
	'fileformat' => { 87 => 0x0, 120 => 0x14, 356 => [0x22,0x26], 376 => 0xb000 },
	'filegroupid' => { 112 => 'FileGroupID' },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 287 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 112 => 'FileModifyDate' },
	'filename' => { 112 => 'FileName' },
	'filenameasdelivered' => { 275 => 'FileNameAsDelivered' },
	'filenumber' => { 52 => 0x1, 58 => 0x8, 89 => 0x1817, 106 => 'FileNumber', 189 => 0x4 },
	'filenumbermemory' => { 165 => 0x1a },
	'filenumbersequence' => { 248 => '12.2', 253 => '3.1', 254 => '4.1', 255 => '4.1', 257 => '11.1', 258 => '4.3', 263 => '5.2' },
	'filepermissions' => { 112 => 'FilePermissions' },
	'filesource' => { 111 => 0xa300, 116 => 0x8000, 433 => 'FileSource' },
	'fileuserid' => { 112 => 'FileUserID' },
	'fileversion' => { 120 => 0x16 },
	'fillflashautoreduction' => { 74 => 0xe, 75 => 0xe, 82 => 0xa },
	'filllight' => { 429 => 'FillLight' },
	'fillorder' => { 111 => 0x10a },
	'filmgraineffect' => { 265 => 0x538 },
	'filmmode' => { 116 => 0x1401, 284 => 0x412, 286 => 0x42 },
	'filmtype' => { 209 => 0x2 },
	'filtereffect' => { 52 => 0xe, 204 => 0x37, 205 => 0x3f },
	'filtereffectauto' => { 65 => 0xa0 },
	'filtereffectfaithful' => { 64 => 0x70, 65 => 0x70 },
	'filtereffectlandscape' => { 64 => 0x40, 65 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 64 => 0x88, 65 => 0x88 },
	'filtereffectneutral' => { 64 => 0x58, 65 => 0x58 },
	'filtereffectportrait' => { 64 => 0x28, 65 => 0x28 },
	'filtereffectstandard' => { 64 => 0x10, 65 => 0x10 },
	'filtereffectuserdef1' => { 64 => 0xa0, 65 => 0xb8 },
	'filtereffectuserdef2' => { 64 => 0xb8, 65 => 0xd0 },
	'filtereffectuserdef3' => { 64 => 0xd0, 65 => 0xe8 },
	'finderdisplayduringexposure' => { 75 => 0x1 },
	'finesharpness' => { 320 => 0x70 },
	'finetuneoptcenterweighted' => { 248 => '7.2', 249 => '9.1', 251 => '9.1', 252 => '9.1', 256 => '8.1', 261 => '9.1', 262 => '9.1', 263 => '9.1' },
	'finetuneopthighlightweighted' => { 251 => '46.1', 252 => '46.1', 261 => '46.1', 262 => '46.1' },
	'finetuneoptmatrixmetering' => { 248 => '8.1', 249 => '8.2', 251 => '8.2', 252 => '8.2', 256 => '7.2', 257 => '6.1', 261 => '8.2', 262 => '8.2', 263 => '8.2' },
	'finetuneoptspotmetering' => { 248 => '8.2', 249 => '9.2', 251 => '9.2', 252 => '9.2', 256 => '8.2', 257 => '6.2', 261 => '9.2', 262 => '9.2', 263 => '9.2' },
	'firmware' => { 270 => 0x405, 356 => [0x17,0x3b,0x57], 425 => 'Firmware' },
	'firmwaredate' => { 104 => 0x15, 105 => 0x2001, 341 => 0x4 },
	'firmwareid' => { 172 => 0x0 },
	'firmwarename' => { 353 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 58 => 0x1e, 344 => 0x0 },
	'firmwarerevision2' => { 344 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 125 => 0xce5, 139 => 0x57, 141 => 'FirmwareVersion', 286 => 0x2, 288 => 0x3109, 320 => 0x230, 342 => 0x18, 346 => 0x2 },
	'firmwareversions' => { 329 => 0x301 },
	'firstphotodate' => { 417 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 275 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 119 => 0x16, 423 => 'FixtureIdentifier' },
	'flash' => { 106 => 'Flash', 111 => 0x9209, 166 => 0x1f, 167 => 0x15, 433 => 'Flash' },
	'flashaction' => { 364 => 0x3e, 365 => 0x3e, 376 => 0x2017, 381 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 364 => 0x4c, 365 => 0x4c, 381 => 0x77 },
	'flashactionexternal' => { 381 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 39 => 0x249 },
	'flashbias' => { 286 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 76 => 0x70e },
	'flashchargelevel' => { 270 => 0x1010 },
	'flashcolorfilter' => { 192 => 0x10 },
	'flashcommandermode' => { 190 => '9.1', 191 => '9.1', 192 => '9.1' },
	'flashcompensation' => { 190 => 0xa, 191 => 0xa, 192 => 0xa, 193 => 0xa, 425 => 'FlashCompensation' },
	'flashcontrol' => { 364 => 0x23, 365 => 0x1f, 366 => 0x21 },
	'flashcontrolbuilt-in' => { 257 => '16.1', 258 => '23.1', 260 => '23.1', 261 => '24.1' },
	'flashcontrolmode' => { 190 => '9.2', 191 => '9.2', 192 => '9.2', 265 => 0x404 },
	'flashcurtain' => { 286 => 0x48 },
	'flashdefault' => { 168 => 0x42 },
	'flashdevice' => { 270 => 0x1005 },
	'flashdistance' => { 105 => 0x2034 },
	'flashenergy' => { 111 => 0xa20b, 433 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 202 => 0x18 },
	'flashexposurecomp' => { 70 => 0xf, 116 => 0x1011, 144 => 'ExposureComp', 165 => 0x23, 170 => 0x104, 171 => 0x49c1, 202 => 0x12, 265 => 0x401, 270 => 0x1023, 320 => 0x4d, 346 => 0x100b, 356 => [0x3a,0x56], 376 => 0x104 },
	'flashexposurecomp2' => { 227 => 0x4d2 },
	'flashexposurecomp3' => { 192 => 0x1d },
	'flashexposurecomp4' => { 192 => 0x27 },
	'flashexposurecomparea' => { 249 => '38.4', 251 => '38.4', 252 => '38.4', 261 => '38.4', 262 => '38.4' },
	'flashexposurecompset' => { 168 => 0x10, 293 => 0xe, 364 => 0x14, 365 => 0x12, 366 => 0x23, 381 => 0x1f },
	'flashexposurecompset2' => { 381 => [0x26,0x2c] },
	'flashexposureindicator' => { 168 => 0x54 },
	'flashexposureindicatorlast' => { 168 => 0x56 },
	'flashexposureindicatornext' => { 168 => 0x55 },
	'flashexposurelock' => { 52 => 0x19 },
	'flashfired' => { 127 => 0x5d, 144 => 'Fired', 165 => 0x14, 226 => '590.3', 286 => 0x8007, 433 => [\'Flash','FlashFired'] },
	'flashfiring' => { 76 => 0x306, 77 => 0x6, 78 => 0x7, 81 => 0x7 },
	'flashfirmwareversion' => { 266 => 0x1002 },
	'flashfocallength' => { 190 => 0xb, 191 => 0xc, 192 => 0xc, 193 => 0xc },
	'flashfunction' => { 171 => 0x31, 433 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 190 => 0xe, 191 => 0xf, 192 => 0xf, 193 => 0xf },
	'flashgroupacompensation' => { 190 => 0x11, 191 => 0x12, 192 => 0x13 },
	'flashgroupacontrolmode' => { 190 => 0xf, 191 => '16.1', 192 => '17.1' },
	'flashgroupaoutput' => { 190 => 0x11, 191 => 0x12, 192 => 0x13 },
	'flashgroupbcompensation' => { 190 => 0x12, 191 => 0x13, 192 => 0x14 },
	'flashgroupbcontrolmode' => { 190 => 0x10, 191 => '17.1', 192 => '18.1' },
	'flashgroupboutput' => { 190 => 0x12, 191 => 0x13, 192 => 0x14 },
	'flashgroupccompensation' => { 191 => 0x14, 192 => 0x15 },
	'flashgroupccontrolmode' => { 191 => '17.2', 192 => '18.2' },
	'flashgroupcoutput' => { 191 => 0x14, 192 => 0x15 },
	'flashguidenumber' => { 70 => 0xd, 86 => 0x0, 144 => 'GuideNumber' },
	'flashintensity' => { 104 => [0x19,0x5], 265 => 0x405 },
	'flashlevel' => { 250 => 0x9, 376 => 0xb048 },
	'flashmake' => { 144 => 'Make' },
	'flashmanufacturer' => { 163 => 'FlashManufacturer' },
	'flashmetering' => { 165 => 0x3f, 168 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 320 => 0x20a },
	'flashmode' => { 104 => 0x4, 127 => 0x5c, 144 => 'Mode', 165 => 0x2, 166 => 0x20, 167 => 0x16, 168 => 0xf, 202 => 0x87, 265 => 0x400, 270 => 0x1004, 320 => 0xc, 327 => 0x4, 345 => 0x20, 346 => 0x100a, 355 => 0x225, 364 => 0x13, 365 => 0x7f, 366 => 0x20, 381 => 0x10, 384 => 0x1138, 385 => 0x1138, 386 => 0x1114, 387 => 0x1190, 388 => 0x116c, 389 => 0x1024, 390 => 0x21c, 391 => 0x21c, 392 => 0x211, 433 => [\'Flash','FlashMode'] },
	'flashmodel' => { 144 => 'Model', 163 => 'FlashModel', 266 => 0x1001 },
	'flashoptions' => { 301 => 0x2 },
	'flashoptions2' => { 301 => 0x10 },
	'flashoutput' => { 39 => 0x248, 70 => 0x21, 190 => 0xa, 191 => 0xa, 192 => 0xa },
	'flashpixversion' => { 111 => 0xa000, 433 => 'FlashpixVersion' },
	'flashredeyemode' => { 433 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 265 => 0x403 },
	'flashreturn' => { 433 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 144 => 'SerialNumber', 266 => 0x1003 },
	'flashsetting' => { 202 => 0x8 },
	'flashshutterspeed' => { 248 => '20.2', 249 => '23.2', 251 => '23.2', 252 => '23.2', 257 => '15.2', 258 => '22.2', 259 => '7.2', 260 => '22.2', 261 => '23.2', 262 => '23.2', 263 => '23.1' },
	'flashsource' => { 190 => 0x4, 191 => 0x4, 192 => 0x4, 193 => 0x4 },
	'flashstatus' => { 308 => 0x0, 381 => [0x82,0x86], 394 => 0x31, 395 => 0x39 },
	'flashstatusbuilt-in' => { 366 => [0x87,0x287] },
	'flashstatusexternal' => { 366 => [0x88,0x288] },
	'flashsyncspeed' => { 248 => '20.1', 249 => '23.1', 251 => '23.1', 252 => '23.1', 257 => '15.1', 258 => '22.1', 260 => '22.1', 261 => '23.1', 262 => '23.1' },
	'flashsyncspeedav' => { 74 => 0x3, 76 => 0x10f, 77 => 0x2, 78 => 0x3, 79 => 0x2, 80 => 0x2, 81 => 0x3, 82 => 0x6 },
	'flashthreshold' => { 86 => 0x1 },
	'flashtype' => { 144 => 'Type', 168 => 0x59, 202 => 0x9, 266 => 0x1000 },
	'flashwarning' => { 258 => '30.1', 259 => '7.1', 263 => '31.1', 286 => 0x62 },
	'flexiblespotposition' => { 376 => 0x201d },
	'flickerreduce' => { 355 => 0x218 },
	'flickerreduction' => { 220 => 0xe84 },
	'flickerreductionindicator' => { 220 => 0x5e2 },
	'flightpitchdegree' => { 108 => 'FlightPitchDegree' },
	'flightrolldegree' => { 108 => 'FlightRollDegree' },
	'flightyawdegree' => { 108 => 'FlightYawDegree' },
	'fliphorizontal' => { 241 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 70 => 0x15, 111 => 0x829d, 124 => 0xfd04, 127 => 0x1e, 129 => 0xfa23, 131 => 0xf103, 134 => 0x13, 136 => 0x3c, 139 => 0xc, 148 => 'FNumber', 165 => 0xa, 166 => 0x36, 167 => 0x47, 168 => 0x9, 171 => 0x49c7, 320 => 0x13, 353 => 0xa019, 356 => [0x31,0x49], 364 => 0x1, 365 => 0x1, 381 => [0x20,0x22,0x26], 433 => 'FNumber' },
	'focaldistance' => { 415 => 'FocalDistance' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 54 => 0x1, 105 => 0x1d, 111 => 0x920a, 134 => 0x1d, 148 => 'FocalLength', 165 => 0x12, 198 => 0xa, 199 => 0xb, 320 => 0x1d, 329 => 0x403, 346 => 0x1500, 363 => 0xe, 388 => 0x1278, 389 => 0x1134, 390 => 0x32c, 391 => 0x32c, 392 => 0x30a, 433 => 'FocalLength' },
	'focallength2' => { 381 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 111 => 0xa405, 353 => 0xa01a, 433 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 363 => 0x10 },
	'focalplaneafpointarea' => { 393 => 0x2 },
	'focalplaneafpointlocation1' => { 393 => 0x6 },
	'focalplaneafpointlocation10' => { 393 => 0x2a },
	'focalplaneafpointlocation11' => { 393 => 0x2e },
	'focalplaneafpointlocation12' => { 393 => 0x32 },
	'focalplaneafpointlocation13' => { 393 => 0x36 },
	'focalplaneafpointlocation14' => { 393 => 0x3a },
	'focalplaneafpointlocation15' => { 393 => 0x3e },
	'focalplaneafpointlocation2' => { 393 => 0xa },
	'focalplaneafpointlocation3' => { 393 => 0xe },
	'focalplaneafpointlocation4' => { 393 => 0x12 },
	'focalplaneafpointlocation5' => { 393 => 0x16 },
	'focalplaneafpointlocation6' => { 393 => 0x1a },
	'focalplaneafpointlocation7' => { 393 => 0x1e },
	'focalplaneafpointlocation8' => { 393 => 0x22 },
	'focalplaneafpointlocation9' => { 393 => 0x26 },
	'focalplaneafpointsused' => { 393 => 0x1 },
	'focalplanediagonal' => { 266 => 0x103, 270 => 0x205 },
	'focalplaneresolutionunit' => { 111 => 0xa210, 433 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 111 => 0xa20e, 433 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 54 => 0x2 },
	'focalplanexunknown' => { 54 => 0x2 },
	'focalplaneyresolution' => { 111 => 0xa20f, 433 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 54 => 0x3 },
	'focalplaneyunknown' => { 54 => 0x3 },
	'focalpointx' => { 415 => 'FocalPointX' },
	'focalpointy' => { 415 => 'FocalPointY' },
	'focaltype' => { 9 => 0x2d, 54 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 231 => 0x8 },
	'focusarea' => { 165 => 0x31 },
	'focusareaselection' => { 259 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 76 => 0x515 },
	'focusdistance' => { 148 => 'FocusDistance', 165 => 0x13, 171 => 0x49bb, 198 => 0x9, 199 => 0xa, 268 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 52 => 0x15, 70 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 52 => 0x14, 70 => 0x13 },
	'focusholdbutton' => { 168 => 0x44 },
	'focusinfoversion' => { 268 => 0x0 },
	'focusingscreen' => { 75 => 0x0, 76 => 0x80b, 81 => 0x0 },
	'focuslocation' => { 376 => 0x2027 },
	'focuslocked' => { 164 => 0x14 },
	'focusmode' => { 33 => 0x7, 104 => 0x3, 105 => [0x3003,0xd], 116 => 0x1021, 127 => 0x38, 141 => 'FocusMode', 165 => 0x30, 167 => 0xe, 168 => 0xc, 202 => 0x7, 265 => 0x301, 270 => 0x100b, 286 => 0x7, 320 => 0xd, 327 => 0x3, 346 => 0x1006, 357 => [0xb,0x5], 363 => [0x15,0x1d], 364 => 0x4d, 365 => 0x4d, 376 => [0xb042,0xb04e,0x201b], 381 => 0x13, 399 => 0x16 },
	'focusmode2' => { 301 => '3.1', 381 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 250 => '10.1', 361 => 0x14, 362 => 0x15, 364 => 0x10, 365 => 0xf, 366 => 0x6 },
	'focusmodeswitch' => { 168 => 0x58, 364 => 0x2e },
	'focuspixel' => { 116 => 0x1023 },
	'focuspointwrap' => { 248 => '2.2', 249 => '2.2', 251 => '2.1', 252 => '2.1', 256 => '1.1', 257 => '2.2', 258 => '1.1', 261 => '2.2', 262 => '2.1', 263 => '2.5' },
	'focusposition' => { 198 => 0x8, 199 => 0x8, 320 => 0x10, 375 => 0x9bb },
	'focusposition2' => { 381 => [0x29,0x2b,0x2f], 399 => 0x2d, 402 => 0x20 },
	'focusprocess' => { 265 => 0x302 },
	'focusrange' => { 33 => 0x12, 270 => 0x100a },
	'focusrangeindex' => { 311 => '3.1' },
	'focussetting' => { 356 => 0x6 },
	'focusstatus' => { 363 => 0x19, 364 => 0x53, 365 => 0x53 },
	'focusstepcount' => { 268 => 0x301, 270 => 0x100e },
	'focusstepinfinity' => { 268 => 0x303, 270 => 0x103b },
	'focusstepnear' => { 268 => 0x304, 270 => 0x103c },
	'focustrackinglockon' => { 248 => ['1.5','4.1'], 249 => '1.4', 256 => '0.4', 257 => '3.1', 258 => '0.4', 261 => '1.4' },
	'focuswarning' => { 116 => 0x1301 },
	'foldername' => { 165 => 0x27 },
	'foldernumber' => { 364 => 0x9a, 366 => [0x402,0x114,0x316] },
	'fontcomposite' => { 458 => [\'Fonts','FontsComposite'] },
	'fontface' => { 458 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 458 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 458 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 458 => [\'Fonts','FontsFontName'] },
	'fonts' => { 458 => 'Fonts' },
	'fonttype' => { 458 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 458 => [\'Fonts','FontsVersionString'] },
	'for' => { 336 => 'For' },
	'forcewrite' => { 112 => 'ForceWrite' },
	'format' => { 414 => 'Format', 430 => 'format', 451 => 'Format' },
	'forwardlock' => { 448 => 'forwardlock' },
	'forwardmatrix1' => { 111 => 0xc714 },
	'forwardmatrix2' => { 111 => 0xc715 },
	'framecount' => { 61 => [0x2,0x4] },
	'frameheight' => { 116 => 0x3822 },
	'framenum' => { 331 => 0xd7 },
	'framenumber' => { 116 => 0x8003, 171 => 0x3c, 320 => 0x29 },
	'framerate' => { 61 => [0x1,0x6], 111 => 0xc764, 116 => 0x3820 },
	'framewidth' => { 116 => 0x3821 },
	'framing' => { 442 => 'framing' },
	'freebytes' => { 89 => 0x1 },
	'freememorycardimages' => { 166 => [0x37,0x54], 167 => [0x2d,0x4a], 168 => 0x32 },
	'fujiflashmode' => { 116 => 0x1010 },
	'fullimagesize' => { 376 => 0xb02b },
	'fullpanoheightpixels' => { 417 => 'FullPanoHeightPixels', 418 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 417 => 'FullPanoWidthPixels', 418 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 346 => 0x100d },
	'fullsizeimage' => { 147 => 'data' },
	'fullsizeimagename' => { 147 => '1Name' },
	'fullsizeimagetype' => { 147 => '0Type' },
	'func1button' => { 251 => '14.1', 252 => '14.1', 262 => '14.1' },
	'func1buttonplusdials' => { 251 => '42.1', 252 => '42.1', 262 => '42.1' },
	'func2button' => { 251 => '80.1', 252 => '80.1', 262 => '80.1' },
	'func2buttonplusdials' => { 251 => '81.1' },
	'func3button' => { 251 => '83.1' },
	'funcbutton' => { 248 => ['14.1','15.1'], 249 => '14.1', 257 => '28.1', 258 => '13.1', 261 => '14.1', 263 => '14.1' },
	'funcbuttonplusdials' => { 248 => ['14.2','15.2'], 249 => '14.2', 257 => '31.1', 261 => '42.1' },
	'functionbutton' => { 255 => '13.1', 259 => '5.2' },
	'gainbase' => { 269 => 0x610 },
	'gaincontrol' => { 111 => 0xa407, 433 => 'GainControl' },
	'gamma' => { 111 => 0xa500, 434 => 'Gamma' },
	'gammablackpoint' => { 97 => 0xc },
	'gammacolortone' => { 97 => 0x3 },
	'gammacompensatedvalue' => { 121 => 0x91 },
	'gammacontrast' => { 97 => 0x2 },
	'gammacurveoutputrange' => { 97 => 0xf },
	'gammahighlight' => { 97 => 0xa },
	'gammalinear' => { 95 => 0x20200 },
	'gammamidpoint' => { 97 => 0xe },
	'gammasaturation' => { 97 => 0x4 },
	'gammashadow' => { 97 => 0x9 },
	'gammasharpnessstrength' => { 97 => 0x8 },
	'gammaunsharpmaskfineness' => { 97 => 0x6 },
	'gammaunsharpmaskstrength' => { 97 => 0x5 },
	'gammaunsharpmaskthreshold' => { 97 => 0x7 },
	'gammawhitepoint' => { 97 => 0xd },
	'geimagesize' => { 116 => 0x1304 },
	'gemake' => { 117 => 0x300 },
	'gemodel' => { 117 => 0x207 },
	'genre' => { 439 => 'Genre', 443 => 'genre', 453 => 'genre' },
	'genrecvid' => { 439 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 439 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 439 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 439 => [\'Genre','GenreCvTermRefinedAbout'] },
	'geography' => { 444 => 'geography' },
	'geologicalcontext' => { 110 => 'GeologicalContext' },
	'geologicalcontextbed' => { 110 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 110 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 110 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 110 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 110 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 112 => 'Geosync' },
	'geotag' => { 112 => 'Geotag' },
	'geotiffasciiparams' => { 111 => 0x87b1 },
	'geotiffdirectory' => { 111 => 0x87af },
	'geotiffdoubleparams' => { 111 => 0x87b0 },
	'geotime' => { 112 => 'Geotime' },
	'giftftppriority' => { 419 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 108 => 'GimbalPitchDegree' },
	'gimbalrolldegree' => { 108 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 108 => 'GimbalYawDegree' },
	'globalaltitude' => { 334 => 0x419 },
	'globalangle' => { 334 => 0x40d },
	'good' => { 453 => 'good' },
	'googleplusuploadcode' => { 111 => 0x9009 },
	'gpsaltitude' => { 118 => 0x6, 145 => 'Altitude', 433 => 'GPSAltitude' },
	'gpsaltituderef' => { 118 => 0x5, 433 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 118 => 0x1c, 433 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 118 => 0x1d },
	'gpsdatetime' => { 145 => 'DateTime', 433 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 118 => 0x18, 145 => 'Bearing', 433 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 118 => 0x17, 433 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 118 => 0x1a, 145 => 'Distance', 433 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 118 => 0x19, 433 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 118 => 0x14, 433 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 118 => 0x13 },
	'gpsdestlongitude' => { 118 => 0x16, 433 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 118 => 0x15 },
	'gpsdifferential' => { 118 => 0x1e, 145 => 'Differential', 433 => 'GPSDifferential' },
	'gpsdop' => { 118 => 0xb, 433 => 'GPSDOP' },
	'gpshpositioningerror' => { 118 => 0x1f, 433 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 118 => 0x11, 433 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 118 => 0x10, 433 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 118 => 0x2, 145 => 'Latitude', 433 => 'GPSLatitude' },
	'gpslatituderef' => { 118 => 0x1 },
	'gpslongitude' => { 118 => 0x4, 145 => 'Longitude', 433 => 'GPSLongitude' },
	'gpslongituderef' => { 118 => 0x3 },
	'gpsmapdatum' => { 118 => 0x12, 145 => 'Datum', 433 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 118 => 0xa, 145 => 'MeasureMode', 433 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 118 => 0x1b, 433 => 'GPSProcessingMethod' },
	'gpssatellites' => { 118 => 0x8, 145 => 'Satellites', 433 => 'GPSSatellites' },
	'gpsspeed' => { 118 => 0xd, 145 => 'Speed', 433 => 'GPSSpeed' },
	'gpsspeedref' => { 118 => 0xc, 433 => 'GPSSpeedRef' },
	'gpsstatus' => { 118 => 0x9, 433 => 'GPSStatus' },
	'gpstimestamp' => { 118 => 0x7 },
	'gpstrack' => { 118 => 0xf, 145 => 'Heading', 433 => 'GPSTrack' },
	'gpstrackref' => { 118 => 0xe, 433 => 'GPSTrackRef' },
	'gpsversionid' => { 118 => 0x0, 433 => 'GPSVersionID' },
	'gradation' => { 265 => 0x50f },
	'gradientbasedcorractive' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 429 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 429 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 429 => 'GrainAmount' },
	'grainfrequency' => { 429 => 'GrainFrequency' },
	'grainsize' => { 429 => 'GrainSize' },
	'graymixeraqua' => { 429 => 'GrayMixerAqua' },
	'graymixerblue' => { 429 => 'GrayMixerBlue' },
	'graymixergreen' => { 429 => 'GrayMixerGreen' },
	'graymixermagenta' => { 429 => 'GrayMixerMagenta' },
	'graymixerorange' => { 429 => 'GrayMixerOrange' },
	'graymixerpurple' => { 429 => 'GrayMixerPurple' },
	'graymixerred' => { 429 => 'GrayMixerRed' },
	'graymixeryellow' => { 429 => 'GrayMixerYellow' },
	'graypoint' => { 409 => 0x8021 },
	'grayresponseunit' => { 111 => 0x122 },
	'greencurvelimits' => { 100 => 0x1c4 },
	'greencurvepoints' => { 99 => 0x53, 100 => 0x19a },
	'greenhsl' => { 95 => 0x20913 },
	'greenhue' => { 429 => 'GreenHue' },
	'greensaturation' => { 429 => 'GreenSaturation' },
	'griddisplay' => { 248 => '13.3', 249 => '4.3', 251 => '4.2', 252 => '4.2', 253 => '2.2', 257 => '10.5', 258 => '3.4', 259 => '6.1', 261 => '4.4', 262 => '4.2', 263 => '4.2' },
	'gripbatteryadload' => { 299 => 0x5 },
	'gripbatteryadnoload' => { 299 => 0x4 },
	'gripbatterystate' => { 299 => '1.2' },
	'groupareaafillumination' => { 249 => '46.4', 252 => '47.4', 261 => '47.4' },
	'halftonehints' => { 111 => 0x141 },
	'hardlink' => { 112 => 'HardLink' },
	'hasalternative' => { 443 => 'hasAlternative' },
	'hascorrection' => { 443 => 'hasCorrection' },
	'hascorrectiona-lang' => { 443 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 443 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 443 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 429 => 'HasCrop' },
	'hasextendedxmp' => { 455 => 'HasExtendedXMP' },
	'hassettings' => { 429 => 'HasSettings' },
	'hastranslation' => { 443 => 'hasTranslation' },
	'hasvisibleoverprint' => { 458 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 458 => 'HasVisibleTransparency' },
	'hdr' => { 55 => 0x1, 195 => 0x4, 286 => 0x9e, 320 => 0x85, 376 => 0x200a },
	'hdreffect' => { 55 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 195 => 0x0 },
	'hdrlevel' => { 195 => 0x5, 366 => 0x2e, 381 => 0x17 },
	'hdrlevel2' => { 195 => 0x7 },
	'hdrsetting' => { 366 => 0x2d, 381 => 0x16, 384 => 0x1148, 385 => 0x1148, 386 => 0x1124, 387 => 0x11a0, 388 => 0x117c, 389 => 0x1034, 390 => 0x22c, 391 => 0x22c, 392 => 0x21f },
	'hdrsmoothing' => { 195 => 0x6 },
	'headline' => { 119 => 0x69, 439 => 'Headline', 441 => 'Headline' },
	'hierarchicalkeywords' => { 156 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 156 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 156 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 156 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 156 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 156 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 156 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 420 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 110 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 290 => 0x1a },
	'highisomultipliergreen' => { 290 => 0x19 },
	'highisomultiplierred' => { 290 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 57 => 0x5, 76 => 0x202, 116 => 0x100e, 202 => 0xb1, 320 => 0x71, 364 => 0x2c, 365 => 0x26, 366 => 0x26, 376 => 0x2009, 381 => 0x12, 405 => 0x42 },
	'highisonoisereduction2' => { 376 => 0xb050 },
	'highlight' => { 356 => 0xf },
	'highlightadj' => { 95 => 0x2030c },
	'highlightcolordistortreduct' => { 409 => 0x8026 },
	'highlightlinearitylimit' => { 353 => 0xa025 },
	'highlightprotection' => { 240 => 0x6 },
	'highlightrecovery' => { 429 => 'HighlightRecovery' },
	'highlights' => { 422 => 'Highlights' },
	'highlights2012' => { 429 => 'Highlights2012' },
	'highlighttone' => { 116 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 57 => 0x3, 76 => 0x203 },
	'highlowkeyadj' => { 320 => 0x6c },
	'highspeedsync' => { 168 => 0x5, 364 => 0x2, 365 => 0x2 },
	'histogramxml' => { 241 => 0x83a1a25 },
	'history' => { 441 => 'History', 454 => 'History' },
	'historyaction' => { 454 => [\'History','HistoryAction'] },
	'historychanged' => { 454 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 454 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 454 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 454 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 454 => [\'History','HistoryWhen'] },
	'hometowncity' => { 105 => 0x3006, 320 => 0x23, 326 => 0x2 },
	'hometowncitycode' => { 327 => 0x1000 },
	'hometowndst' => { 320 => 0x25, 326 => '0.2' },
	'hostcomputer' => { 111 => 0x13c },
	'hue' => { 173 => 0x3b, 205 => 0x3d, 320 => 0x67 },
	'hueadj' => { 244 => 0x2f, 409 => 0x8019 },
	'hueadjust' => { 346 => 0x1016 },
	'hueadjustment' => { 166 => 0x4a, 167 => 0x40, 202 => 0x92, 204 => 0x36 },
	'hueadjustmentaqua' => { 429 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 429 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 429 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 429 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 429 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 429 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 429 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 429 => 'HueAdjustmentYellow' },
	'huesetting' => { 273 => 0x1011 },
	'humidity' => { 111 => 0x9401 },
	'icc_profile' => { 112 => 'ICC_Profile' },
	'iccprofilename' => { 441 => 'ICCProfile' },
	'idccreativestyle' => { 409 => 0x8000 },
	'idcpreviewlength' => { 409 => 0x202 },
	'idcpreviewstart' => { 409 => 0x201 },
	'identification' => { 110 => 'Identification' },
	'identificationid' => { 110 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 110 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 110 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 110 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 110 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 110 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 430 => 'identifier', 451 => 'Identifier' },
	'illumination' => { 259 => '0.5', 342 => 0x48 },
	'imageadjustment' => { 202 => 0x80, 231 => 0x5 },
	'imagealterationconstraints' => { 275 => 'ImageAlterationConstraints' },
	'imagearea' => { 214 => 0x10, 217 => 0x10 },
	'imageareaoffset' => { 320 => 0x38 },
	'imageauthentication' => { 202 => 0x20 },
	'imageboundary' => { 202 => 0x16 },
	'imagecount' => { 116 => 0x1438, 202 => 0xa5, 379 => 0x11b, 394 => 0x32, 395 => 0x3a },
	'imagecount2' => { 394 => 0x4c, 395 => [0x52,0x58] },
	'imagecount3' => { 394 => [0x1a0,0x1aa,0x1bd], 395 => [0x19f,0x1cb,0x1cd] },
	'imagecreator' => { 275 => 'ImageCreator' },
	'imagecreatorid' => { 275 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 275 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 275 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedata' => { 416 => 'Data' },
	'imagedatasize' => { 202 => 0xa2 },
	'imagedescription' => { 111 => 0x10e, 449 => 'ImageDescription' },
	'imageduplicationconstraints' => { 275 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 241 => 0xfe443a45 },
	'imageeditcount' => { 320 => 0x41 },
	'imageediting' => { 320 => 0x32 },
	'imageeffects' => { 346 => 0x1010 },
	'imagefileconstraints' => { 275 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 275 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 275 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 116 => 0x1436 },
	'imageheight' => { 111 => 0x101, 172 => 0xc, 329 => 0x10d, 414 => 'ImageHeight', 449 => 'ImageLength' },
	'imagehistory' => { 111 => 0x9213, 432 => 'ImageHistory' },
	'imageidnumber' => { 282 => 0x340 },
	'imagemimetype' => { 416 => 'Mime' },
	'imagenumber' => { 111 => 0x9211, 141 => 'ImageNumber', 166 => 0xae, 167 => 0x5e, 329 => 0x113, 364 => 0x9b, 366 => [0x400,'276.1',0x314], 425 => 'ImageNumber' },
	'imagenumber2' => { 167 => 0x62 },
	'imageoptimization' => { 202 => 0xa9 },
	'imageorientation' => { 119 => 0x83 },
	'imageprocessing' => { 202 => 0x1a },
	'imageprocessingversion' => { 269 => 0x0 },
	'imagequality' => { 141 => 'ImageQuality', 216 => '723.2', 217 => '732.2', 226 => '708.1', 286 => 0x1 },
	'imagequality2' => { 265 => 0x603 },
	'imagerank' => { 419 => 'ImageRank' },
	'imageref' => { 437 => 'ImageRef' },
	'imagereview' => { 250 => '0.4', 259 => '0.4' },
	'imagereviewmonitorofftime' => { 249 => '21.1', 251 => '21.1', 252 => '21.1', 256 => '20.1', 261 => '21.1', 262 => '21.1' },
	'imagereviewtime' => { 248 => '25.1', 250 => '2.1', 253 => '19.1', 254 => '20.1', 255 => '20.1', 257 => '9.2', 258 => '20.1', 263 => '21.2' },
	'imagesize' => { 147 => 'ImageSize' },
	'imagesizerestriction' => { 446 => 'imageSizeRestriction' },
	'imagesourcedata' => { 111 => 0x935c },
	'imagestabilization' => { 33 => 0x22, 105 => 0x3020, 116 => 0x1422, 141 => 'ImageStabilization', 166 => 0xbd, 167 => 0x71, 168 => 0x57, 169 => 0x0, 170 => [0x18,0x107,0x113], 171 => 0x49c2, 202 => 0xac, 265 => 0x604, 268 => 0x1600, 286 => 0x1a, 369 => 0x12, 370 => 0x11, 376 => 0xb026 },
	'imagestabilization2' => { 368 => 0xa },
	'imagestabilizationsetting' => { 171 => 0x14, 364 => 0x3d, 365 => 0x3d, 375 => 0x14 },
	'imagestyle' => { 364 => 0x2d, 365 => 0x27 },
	'imagesupplier' => { 275 => 'ImageSupplier' },
	'imagesupplierid' => { 275 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 275 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 275 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 113 => 0x1 },
	'imagetemperaturemin' => { 113 => 0x2 },
	'imagetone' => { 320 => 0x4f },
	'imagetype' => { 119 => 0x82, 275 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 58 => 0x28, 111 => 0xa420, 432 => 'ImageUniqueID', 433 => 'ImageUniqueID' },
	'imagewidth' => { 111 => 0x100, 172 => 0xe, 329 => 0x10c, 414 => 'ImageWidth', 449 => 'ImageWidth' },
	'incrementaltemperature' => { 429 => 'IncrementalTemperature' },
	'incrementaltint' => { 429 => 'IncrementalTint' },
	'industry' => { 443 => 'industry', 444 => 'industry' },
	'infobuttonwhenshooting' => { 76 => 0x409 },
	'infraredilluminator' => { 341 => 0x28 },
	'ingredientexclusion' => { 445 => 'ingredientExclusion' },
	'ingredients' => { 454 => 'Ingredients' },
	'ingredientsalternatepaths' => { 454 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 454 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 454 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 454 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 454 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 454 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 454 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 454 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 454 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 454 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 454 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 454 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 454 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 454 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 454 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 454 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 454 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 454 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 454 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 454 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 454 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 454 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 454 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 76 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 417 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 417 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 417 => 'InitialViewHeadingDegrees', 418 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 417 => 'InitialViewPitchDegrees', 418 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 417 => 'InitialViewRollDegrees', 418 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 248 => '4.4' },
	'initialzoomsetting' => { 248 => '9.3', 257 => '27.3' },
	'inkset' => { 111 => 0x14c },
	'inputprofile' => { 125 => 0x1389 },
	'instanceid' => { 454 => 'InstanceID' },
	'instantplaybacksetup' => { 168 => 0x3e },
	'instantplaybacktime' => { 168 => 0x3d },
	'instructions' => { 441 => 'Instructions' },
	'instrument' => { 453 => 'instrument' },
	'intellectualgenre' => { 438 => 'IntellectualGenre' },
	'intelligentauto' => { 376 => 0xb052, 401 => 0xd, 402 => 0xe, 403 => 0xd },
	'intelligentcontrast' => { 47 => 0x4 },
	'intelligentd-range' => { 286 => 0x79 },
	'intelligentexposure' => { 286 => 0x5d },
	'intelligentresolution' => { 286 => 0x70 },
	'interchangecolorspace' => { 121 => 0x40 },
	'internalflash' => { 165 => 0x2b, 248 => '23.1', 250 => '8.1', 253 => '22.1', 255 => '23.1', 259 => '8.1', 263 => '24.1', 268 => 0x1208 },
	'internalflashae1' => { 270 => 0x1021 },
	'internalflashae1_0' => { 270 => 0x101d },
	'internalflashae2' => { 270 => 0x1022 },
	'internalflashae2_0' => { 270 => 0x101e },
	'internalflashmode' => { 308 => 0x1 },
	'internalflashstrength' => { 308 => 0x3 },
	'internalflashtable' => { 270 => 0x1024 },
	'internallensserialnumber' => { 353 => 0xa005 },
	'internalndfilter' => { 286 => 0x9d },
	'internalserialnumber' => { 58 => 0x96, 69 => 0x9, 116 => 0x10, 171 => 0x49dc, 264 => 0x18, 266 => 0x102, 284 => 0x500, 286 => 0x25, 300 => 0x4, 346 => 0x5, 394 => [0x7c,0xf0], 395 => 0x88 },
	'interopindex' => { 111 => 0x1, 434 => 'InteroperabilityIndex' },
	'interopversion' => { 111 => 0x2 },
	'intervallength' => { 165 => 0x10 },
	'intervalmode' => { 165 => 0x26 },
	'intervalnumber' => { 165 => 0x11 },
	'intervalshooting' => { 320 => 0x92 },
	'introtime' => { 453 => 'introTime' },
	'introtimescale' => { 453 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 453 => [\'introTime','introTimeValue'] },
	'iptc' => { 112 => 'IPTC' },
	'iptc-naa' => { 111 => 0x83bb, 290 => 0x83bb },
	'iptcbitspersample' => { 121 => 0x56 },
	'iptcdigest' => { 334 => 0x425 },
	'iptcimageheight' => { 121 => 0x1e },
	'iptcimagerotation' => { 121 => 0x66 },
	'iptcimagewidth' => { 121 => 0x14 },
	'iptclastedited' => { 439 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 121 => 0xa },
	'iptcpixelheight' => { 121 => 0x32 },
	'iptcpixelwidth' => { 121 => 0x28 },
	'isalternativeof' => { 443 => 'isAlternativeOf' },
	'isbn' => { 443 => 'isbn' },
	'iscorrectionof' => { 443 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 101 => 0x3 },
	'ismergedhdr' => { 425 => 'IsMergedHDR' },
	'ismergedpanorama' => { 425 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 104 => 0x14, 105 => [0x3014,0x14], 111 => 0x8827, 124 => 0xfd06, 125 => 0x1784, 127 => 0x60, 129 => [0xfa2e,0xfa46], 130 => [0x27,0x28], 131 => 0xf105, 134 => 0x14, 136 => 0x4e, 139 => 0x34, 141 => 'ISO', 165 => 0x8, 171 => 0x49ba, 196 => 0x0, 202 => 0x2, 290 => 0x17, 320 => [0x8b,0x14], 327 => 0x14, 329 => 0x105, 353 => 0xa014, 375 => 0x6f, 381 => [0x1f,0x21,0x25], 433 => 'ISOSpeedRatings' },
	'iso2' => { 196 => 0x6, 211 => 0x265, 212 => 0x25c, 213 => 0x265, 214 => 0x221, 215 => 0x25d, 216 => 0x256, 217 => 0x25d, 221 => 0x2b5, 224 => 0x265, 230 => 0x2b5 },
	'isoauto' => { 301 => '14.4' },
	'isoautohilimit' => { 219 => 0x18eb, 220 => 0xe82, 228 => 0x185d },
	'isoautoparameters' => { 320 => 0x7a },
	'isoautoshuttertime' => { 219 => 0x18ea, 220 => 0xe81, 228 => 0x185c },
	'isodisplay' => { 251 => '4.1', 252 => '4.1', 253 => '2.3', 254 => '3.3', 255 => '3.3', 258 => '3.3', 261 => '4.3', 262 => '4.1', 263 => '4.3' },
	'isoexpansion' => { 76 => 0x103, 77 => 0x7, 78 => 0x8, 81 => 0x8, 196 => 0x4 },
	'isoexpansion2' => { 196 => 0xa },
	'isofloor' => { 301 => 0x6 },
	'isoselection' => { 202 => 0xf },
	'isosensitivitystep' => { 256 => '6.2', 258 => '6.2' },
	'isosetting' => { 127 => 0x5e, 141 => 'ISOSetting', 165 => 0x24, 166 => 0x26, 167 => 0x1c, 168 => 0x13, 173 => 0x6, 202 => 0x13, 301 => '17.3', 345 => 0x27, 364 => 0x16, 365 => 0x14, 366 => 0x2, 375 => 0x6d },
	'isospeed' => { 111 => 0x8833, 434 => 'ISOSpeed' },
	'isospeedexpansion' => { 75 => 0x3 },
	'isospeedincrements' => { 76 => 0x102 },
	'isospeedlatitudeyyy' => { 111 => 0x8834, 434 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 111 => 0x8835, 434 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 76 => 0x103 },
	'isostepsize' => { 248 => '6.1', 249 => '7.2', 251 => '7.2', 252 => '7.2', 257 => '4.1', 261 => '7.2', 262 => '7.2' },
	'isovalue' => { 270 => 0x1001 },
	'issn' => { 443 => 'issn' },
	'issueidentifier' => { 443 => 'issueIdentifier' },
	'issuename' => { 443 => 'issueName' },
	'issueteaser' => { 443 => 'issueTeaser' },
	'issuetype' => { 443 => 'issueType' },
	'istranslationof' => { 443 => 'isTranslationOf' },
	'itemsubtype' => { 163 => 'ItemSubType' },
	'jobid' => { 119 => 0xb8 },
	'jobname' => { 435 => 'JobName' },
	'jobref' => { 452 => 'JobRef' },
	'jobrefid' => { 452 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 452 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 452 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 435 => 'JobStatus' },
	'jpeghandling' => { 429 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 288 => 0x3034, 376 => 0xb047 },
	'jpegsize' => { 288 => 0x303a },
	'jpgcompression' => { 220 => 0x7d4 },
	'jpgfromraw' => { 89 => 0x2007, 106 => 'JpgFromRaw', 290 => 0x2e },
	'jpgfromrawlength' => { 111 => [0x117,0x202] },
	'jpgfromrawstart' => { 111 => [0x111,0x201] },
	'jpgrecordedpixels' => { 301 => '14.1' },
	'jurisdiction' => { 426 => 'jurisdiction' },
	'kelvinwb_01' => { 309 => 0x5 },
	'kelvinwb_02' => { 309 => 0x9 },
	'kelvinwb_03' => { 309 => 0xd },
	'kelvinwb_04' => { 309 => 0x11 },
	'kelvinwb_05' => { 309 => 0x15 },
	'kelvinwb_06' => { 309 => 0x19 },
	'kelvinwb_07' => { 309 => 0x1d },
	'kelvinwb_08' => { 309 => 0x21 },
	'kelvinwb_09' => { 309 => 0x25 },
	'kelvinwb_10' => { 309 => 0x29 },
	'kelvinwb_11' => { 309 => 0x2d },
	'kelvinwb_12' => { 309 => 0x31 },
	'kelvinwb_13' => { 309 => 0x35 },
	'kelvinwb_14' => { 309 => 0x39 },
	'kelvinwb_15' => { 309 => 0x3d },
	'kelvinwb_16' => { 309 => 0x41 },
	'kelvinwb_daylight' => { 309 => 0x1 },
	'key' => { 453 => 'key' },
	'keystonecompensation' => { 269 => 0x1900 },
	'keystonedirection' => { 269 => 0x1901 },
	'keystonevalue' => { 269 => 0x1906 },
	'keyword' => { 443 => 'keyword' },
	'keywordinfo' => { 156 => 'Keywords' },
	'keywords' => { 119 => 0x19, 142 => 'Keywords', 274 => 'Keywords', 336 => 'Keywords', 423 => 'keywords', 440 => 'Keywords', 451 => 'Keywords' },
	'killdate' => { 443 => 'killDate' },
	'killdatea-platform' => { 443 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 443 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 124 => 0xf908, 127 => 0xe, 129 => [0xfa1e,0xfa52], 135 => 0x70 },
	'kodakimagewidth' => { 124 => 0xf907, 127 => 0xc, 129 => [0xfa1d,0xfa51], 135 => 0x6c },
	'kodakinfotype' => { 124 => 0xfa00 },
	'kodaklook' => { 125 => 0xe4c },
	'kodaklookprofile' => { 125 => 0x138a },
	'kodakmaker' => { 135 => 0x8 },
	'kodakmodel' => { 127 => 0x0, 135 => 0x28 },
	'label' => { 278 => 'Label', 451 => 'Label' },
	'labelname1' => { 437 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 437 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 286 => 0x6f },
	'landscapeoutputhighlightpoint' => { 101 => 0x26 },
	'landscapeoutputshadowpoint' => { 101 => 0x27 },
	'landscaperawcolortone' => { 101 => 0x1f },
	'landscaperawcontrast' => { 101 => 0x21 },
	'landscaperawhighlight' => { 101 => 0x77 },
	'landscaperawhighlightpoint' => { 101 => 0x24 },
	'landscaperawlinear' => { 101 => 0x22 },
	'landscaperawsaturation' => { 101 => 0x20 },
	'landscaperawshadow' => { 101 => 0x80 },
	'landscaperawshadowpoint' => { 101 => 0x25 },
	'landscaperawsharpness' => { 101 => 0x23 },
	'landscapeunsharpmaskfineness' => { 101 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 101 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 101 => 0xa2 },
	'language' => { 430 => 'language' },
	'languageidentifier' => { 119 => 0x87 },
	'largestvalidinteriorrectheight' => { 417 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 417 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 417 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 417 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 165 => 0x1b },
	'lastkeywordiptc' => { 163 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 163 => 'LastKeywordXMP' },
	'lastphotodate' => { 417 => 'LastPhotoDate' },
	'lasturl' => { 454 => 'LastURL' },
	'lateralchromaticaberration' => { 376 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 425 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 110 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 110 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 110 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 110 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 110 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 311 => 0x2 },
	'lc10' => { 311 => 0xb },
	'lc11' => { 311 => 0xc },
	'lc12' => { 311 => 0xd },
	'lc14' => { 311 => 0xf },
	'lc15' => { 311 => 0x10 },
	'lc3' => { 311 => 0x4 },
	'lc4' => { 311 => 0x5 },
	'lc5' => { 311 => 0x6 },
	'lc6' => { 311 => 0x7 },
	'lc7' => { 311 => 0x8 },
	'lc8' => { 311 => 0x9 },
	'lcddisplayatpoweron' => { 76 => 0x811, 80 => 0xa },
	'lcddisplayreturntoshoot' => { 81 => 0x12 },
	'lcdillumination' => { 248 => '17.5', 249 => '5.2', 251 => '5.1', 252 => '5.1', 257 => '10.3', 258 => '4.2', 261 => '5.2', 262 => '5.1', 263 => '5.4' },
	'lcdilluminationduringbulb' => { 76 => 0x408 },
	'lcdpanels' => { 75 => 0x8 },
	'lcheditor' => { 241 => 0x8ae85e },
	'legacyiptcdigest' => { 441 => 'LegacyIPTCDigest' },
	'legalcode' => { 426 => 'legalcode' },
	'lens' => { 111 => 0xfdea, 202 => 0x84, 425 => 'Lens' },
	'lensafstopbutton' => { 74 => 0x11, 75 => 0x13, 76 => 0x506, 77 => 0x10, 78 => 0x12, 81 => 0x13, 82 => 0x9 },
	'lensaperturerange' => { 356 => [0x30,0x48] },
	'lenscorrectionsettings' => { 432 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 425 => 'LensDistortInfo' },
	'lensdistortionparams' => { 270 => 0x206 },
	'lensdrivenoaf' => { 76 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 366 => 0x3f0, 408 => 0xd },
	'lensfirmware' => { 347 => 0x20, 353 => 0xa004 },
	'lensfirmwareversion' => { 266 => 0x204, 286 => 0x60, 366 => 0x3f3, 408 => 0x14 },
	'lensfocallength' => { 95 => 0xf0512, 311 => 0x9 },
	'lensfocalrange' => { 356 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 249 => '55.1', 251 => '52.1', 252 => '52.1', 261 => '52.1', 262 => '52.1' },
	'lensformat' => { 388 => 0x1891, 390 => 0x18bd, 391 => 0x18ed, 392 => 0x17f1, 394 => 0x106, 395 => 0x106, 404 => 0x603, 405 => 0x5d },
	'lensfstops' => { 197 => 0x7, 198 => 0xc, 199 => 0xd, 202 => 0x8b, 311 => '0.3' },
	'lensid' => { 425 => 'LensID' },
	'lensidnumber' => { 197 => 0x6, 198 => 0xb, 199 => 0xc },
	'lensinfo' => { 111 => 0xa432, 317 => 0x2a, 425 => 'LensInfo', 434 => 'LensSpecification' },
	'lenskind' => { 311 => 0x1 },
	'lensmake' => { 111 => 0xa433, 148 => 'Make', 434 => 'LensMake' },
	'lensmanualdistortionamount' => { 429 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 163 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 356 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 58 => 0x95, 111 => 0xa434, 148 => 'Model', 163 => 'LensModel', 200 => 0x18a, 266 => 0x203, 284 => 0x303, 317 => 0xc, 329 => 0x412, 434 => 'LensModel' },
	'lensmount' => { 366 => 0x99, 388 => 0x1892, 390 => 0x18be, 391 => 0x18ee, 392 => 0x17f2, 394 => 0x105, 395 => 0x105, 404 => 0x604, 405 => 0x5e },
	'lensmount2' => { 408 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 429 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 429 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 429 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 429 => 'LensProfileEnable' },
	'lensprofilefilename' => { 429 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 429 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 429 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 429 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 429 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 429 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 429 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 429 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 429 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 429 => 'LensProfileName' },
	'lensprofilesetup' => { 429 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 429 => 'LensProfileVignettingScale' },
	'lensproperties' => { 266 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 56 => 0x0, 111 => 0xa435, 148 => 'SerialNumber', 266 => 0x202, 286 => 0x52, 347 => 0x30, 425 => 'LensSerialNumber', 434 => 'LensSerialNumber' },
	'lensshutterlock' => { 168 => 0x4a },
	'lensspec' => { 361 => 0x0, 362 => 0x0, 363 => 0x0, 376 => 0xb02a },
	'lensspecfeatures' => { 394 => [0x115,0x116], 395 => [0x116,0x21c,0x21e] },
	'lenstemperature' => { 270 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 170 => 0x10c, 171 => 0x49bd, 202 => 0x83, 266 => 0x201, 279 => 0x16, 282 => 0x310, 285 => 0x303, 286 => 0x51, 288 => 0x3405, 312 => 0x0, 313 => 0x0, 314 => 0x1, 315 => 0x1, 316 => 0x1, 318 => 0x0, 353 => 0xa003, 356 => 0x27, 376 => 0xb027, 388 => 0x1896, 390 => 0x18c2, 391 => 0x18f2, 392 => 0x17f6, 394 => 0x109, 395 => 0x109, 404 => 0x608, 405 => 0x62 },
	'lenstype2' => { 366 => 0x3f7, 388 => 0x1893, 390 => 0x18bf, 391 => 0x18ef, 392 => 0x17f3, 394 => 0x107, 395 => 0x107, 404 => 0x605, 405 => 0x60 },
	'lenstype3' => { 408 => 0x9 },
	'lenszoomposition' => { 401 => 0x19, 402 => 0x1e, 405 => [0x342,0x35a] },
	'levelindicator' => { 293 => 0x15 },
	'levelorientation' => { 319 => 0x0 },
	'license' => { 426 => 'license' },
	'licensee' => { 275 => 'Licensee' },
	'licenseeid' => { 275 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 275 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 275 => 'LicenseeImageNotes' },
	'licenseename' => { 275 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 275 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 275 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 275 => 'LicenseeTransactionID' },
	'licenseid' => { 275 => 'LicenseID' },
	'licensestartdate' => { 275 => 'LicenseStartDate' },
	'licensetransactiondate' => { 275 => 'LicenseTransactionDate' },
	'licensetype' => { 431 => 'licensetype' },
	'licensor' => { 275 => 'Licensor' },
	'licensorcity' => { 275 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 275 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 275 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 275 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 275 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 275 => 'LicensorImageID' },
	'licensorname' => { 275 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 275 => 'LicensorNotes' },
	'licensorpostalcode' => { 275 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 275 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 275 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 275 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 275 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 275 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 275 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 275 => 'LicensorTransactionID' },
	'licensorurl' => { 275 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 270 => 0x1009 },
	'lightingmode' => { 105 => 0x302a },
	'lightreading' => { 320 => 0x15 },
	'lightsource' => { 111 => 0x9208, 202 => 0x90, 273 => 0x1000, 433 => 'LightSource' },
	'lightsourcespecial' => { 355 => 0x21d },
	'lightswitch' => { 261 => '0.1', 263 => '0.1' },
	'lightvaluecenter' => { 270 => 0x103d },
	'lightvalueperiphery' => { 270 => 0x103e },
	'limitafareamodeselection' => { 249 => '51.1', 251 => '49.1', 252 => '49.1', 261 => '49.1', 262 => '49.1' },
	'linearitylimitblue' => { 290 => 0x10 },
	'linearitylimitgreen' => { 290 => 0xf },
	'linearitylimitred' => { 290 => 0xe },
	'linearityuppermargin' => { 40 => [0x2ba,0x2d1,0x2d5], 42 => 0x1e5, 43 => [0x1fe,0x2de], 44 => [0x232,0x310], 45 => 0x31e },
	'linearizationtable' => { 111 => 0xc618 },
	'linearresponselimit' => { 111 => 0xc62e },
	'link' => { 443 => 'link' },
	'linkaetoafpoint' => { 301 => '14.2' },
	'linkedencodedrightsexpr' => { 439 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 439 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 439 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 439 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 110 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 253 => '32.1', 263 => '34.1' },
	'liveviewafareamode' => { 258 => '34.1' },
	'liveviewafmethod' => { 381 => 0x20 },
	'liveviewafmode' => { 258 => '34.2' },
	'liveviewafsetting' => { 366 => 0x36 },
	'liveviewbuttonoptions' => { 249 => '50.2', 251 => '48.2', 252 => '48.2', 261 => '48.2', 262 => '48.2' },
	'liveviewexposuresimulation' => { 76 => 0x810 },
	'liveviewfocusmode' => { 366 => [0x8b,0x28b] },
	'liveviewmetering' => { 366 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 249 => '21.2', 251 => '21.2', 252 => '21.2', 254 => '20.2', 255 => '20.2', 256 => '20.2', 258 => '20.2', 261 => '21.2', 262 => '21.2' },
	'liveviewshooting' => { 52 => 0x13 },
	'localcaption' => { 119 => 0x79 },
	'localizedcameramodel' => { 111 => 0xc615 },
	'locallocationname' => { 353 => 0x30 },
	'location' => { 201 => 0x9, 286 => 0x67, 421 => 'Location', 438 => 'Location', 442 => 'location', 443 => 'location' },
	'locationareacode' => { 427 => 'lac' },
	'locationcreated' => { 439 => 'LocationCreated' },
	'locationcreatedcity' => { 439 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 439 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 439 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 439 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 439 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 439 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 439 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 439 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 439 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 439 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 439 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 439 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 201 => 0x0 },
	'locationname' => { 353 => 0x31 },
	'locationshown' => { 439 => 'LocationShown' },
	'locationshowncity' => { 439 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 439 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 439 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 439 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 439 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 439 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 439 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 439 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 439 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 439 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 439 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 439 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 76 => 0x709 },
	'logcomment' => { 453 => 'logComment' },
	'longexposurenoisereduction' => { 57 => 0x4, 76 => 0x201, 77 => 0x1, 78 => 0x2, 79 => 0x1, 80 => 0x1, 81 => 0x2, 82 => 0x1, 286 => 0x49, 364 => 0x2b, 365 => 0x25, 366 => 0x25, 376 => 0x2008, 381 => 0x11, 405 => 0x44 },
	'longexposurenoisereduction2' => { 52 => 0x8 },
	'loop' => { 453 => 'loop' },
	'lowestbiostratigraphiczone' => { 110 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 429 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 429 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 429 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 429 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 429 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 429 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 429 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 429 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 100 => 0x150 },
	'luminancecurvepoints' => { 100 => 0x126 },
	'luminancenoisereduction' => { 95 => 0x20600, 101 => 0x5f, 356 => 0x1b },
	'luminancenoisereductioncontrast' => { 429 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 429 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 101 => 0x6d },
	'luminancesmoothing' => { 429 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 76 => [0x40b,0x40c] },
	'lyrics' => { 453 => 'lyrics' },
	'm16cversion' => { 282 => 0x333 },
	'macatom' => { 428 => 'macAtom' },
	'macatomapplicationcode' => { 428 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 428 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 428 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 116 => 0x1020, 117 => 0x202, 270 => 0x202, 345 => 0x21, 355 => 0x202, 376 => 0xb040 },
	'macroled' => { 268 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 52 => 0x10 },
	'macromode' => { 33 => 0x1, 165 => 0xb, 265 => 0x300, 286 => 0x1c, 346 => 0x1009 },
	'magentahsl' => { 95 => 0x20917 },
	'magicfilter' => { 265 => 0x52c },
	'magnifiedview' => { 78 => 0x11, 80 => 0x9 },
	'maindialexposurecomp' => { 259 => '0.6' },
	'mainingredient' => { 445 => 'mainIngredient' },
	'make' => { 90 => 0x0, 107 => 0x1, 111 => 0x10f, 141 => 'Make', 278 => 'Make', 290 => 0x10f, 442 => 'make', 449 => 'Make' },
	'makernote' => { 433 => 'MakerNote' },
	'makernoteapple' => { 109 => 'MakN', 111 => 0x927c },
	'makernotecanon' => { 109 => 'MakN', 111 => 0x927c },
	'makernotecasio' => { 109 => 'MakN', 111 => 0x927c },
	'makernotecasio2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotedji' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteflir' => { 109 => 'MakN', 111 => 0x927c },
	'makernotefujifilm' => { 109 => 'MakN', 111 => 0x927c },
	'makernotege' => { 109 => 'MakN', 111 => 0x927c },
	'makernotege2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotehasselblad' => { 109 => 'MakN', 111 => 0x927c },
	'makernotehp' => { 109 => 'MakN', 111 => 0x927c },
	'makernotehp2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotehp4' => { 109 => 'MakN', 111 => 0x927c },
	'makernotehp6' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteisl' => { 109 => 'MakN', 111 => 0x927c },
	'makernotejvc' => { 109 => 'MakN', 111 => 0x927c },
	'makernotejvctext' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak10' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak11' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak1a' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak1b' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak3' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak4' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak5' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak6a' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak6b' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak7' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak8a' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak8b' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak8c' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodak9' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekodakunknown' => { 109 => 'MakN', 111 => 0x927c },
	'makernotekyocera' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica2' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica3' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica4' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica5' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica6' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica7' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica8' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteleica9' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteminolta' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteminolta2' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteminolta3' => { 109 => 'MakN', 111 => 0x927c },
	'makernotemotorola' => { 109 => 'MakN', 111 => 0x927c },
	'makernotenikon' => { 109 => 'MakN', 111 => 0x927c },
	'makernotenikon2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotenikon3' => { 109 => 'MakN', 111 => 0x927c },
	'makernotenintendo' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteoffset' => { 355 => 0xff },
	'makernoteolympus' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteolympus2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotepanasonic' => { 109 => 'MakN', 111 => 0x927c },
	'makernotepanasonic2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotepentax' => { 109 => 'MakN', 111 => 0x927c },
	'makernotepentax2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotepentax3' => { 109 => 'MakN', 111 => 0x927c },
	'makernotepentax4' => { 109 => 'MakN', 111 => 0x927c },
	'makernotepentax5' => { 109 => 'MakN', 111 => 0x927c },
	'makernotepentax6' => { 109 => 'MakN', 111 => 0x927c },
	'makernotephaseone' => { 109 => 'MakN', 111 => 0x927c },
	'makernotereconyx' => { 109 => 'MakN', 111 => 0x927c },
	'makernotereconyx2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotericoh' => { 109 => 'MakN', 111 => 0x927c },
	'makernotericoh2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotericohtext' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesafety' => { 111 => 0xc635 },
	'makernotesamsung1a' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesamsung1b' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesamsung2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesanyo' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesanyoc4' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesanyopatch' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesigma' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesony' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesony2' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesony3' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesony4' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesony5' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesonyericsson' => { 109 => 'MakN', 111 => 0x927c },
	'makernotesonysrf' => { 109 => 'MakN', 111 => 0x927c },
	'makernotetype' => { 346 => 0x1 },
	'makernoteunknown' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteunknownbinary' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteunknowntext' => { 109 => 'MakN', 111 => 0x927c },
	'makernoteversion' => { 170 => 0x0, 202 => 0x1, 270 => 0x0, 286 => 0x8000, 350 => 0x0, 353 => 0x1, 356 => [0x1d,0x1f], 367 => 0x2000 },
	'managedfrom' => { 454 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 454 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 454 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 454 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 454 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 454 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 454 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 454 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 454 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 454 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 454 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 454 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 454 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 454 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 454 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 454 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 454 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 454 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 454 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 454 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 454 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 454 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 454 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 454 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 454 => 'Manager' },
	'managervariant' => { 454 => 'ManagerVariant' },
	'manageto' => { 454 => 'ManageTo' },
	'manageui' => { 454 => 'ManageUI' },
	'manifest' => { 454 => 'Manifest' },
	'manifestlinkform' => { 454 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 454 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 454 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 454 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 454 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 454 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 454 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 454 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 454 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 454 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 454 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 454 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 454 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 454 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 454 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 454 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 454 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 454 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 454 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 454 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 454 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 454 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 454 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 454 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 454 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 454 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 454 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 454 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 265 => 0x900, 286 => 0x86 },
	'manometerreading' => { 265 => 0x901 },
	'manualafpointselectpattern' => { 76 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 268 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 250 => '8.2', 253 => '22.2', 254 => '23.1', 255 => '23.2', 257 => '16.2', 258 => '23.2', 259 => '8.2', 260 => '23.2', 263 => '24.2', 346 => 0x100c },
	'manualflashstrength' => { 265 => 0x406 },
	'manualfocusdistance' => { 202 => 0x85, 270 => 0x100c, 355 => 0x223 },
	'manualtv' => { 75 => 0x5, 76 => 0x705 },
	'manufacturedate' => { 175 => 0x6705, 300 => 0x1 },
	'manufacturedate1' => { 348 => 0x4 },
	'manufacturedate2' => { 348 => 0x5 },
	'manufacturer' => { 414 => 'Manufacturer', 442 => 'manufacturer' },
	'marked' => { 440 => 'Marked', 457 => 'Marked' },
	'markers' => { 453 => 'markers' },
	'markerscomment' => { 453 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 453 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 453 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 453 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 453 => [\'markers','markersCuePointType'] },
	'markersduration' => { 453 => [\'markers','markersDuration'] },
	'markerslocation' => { 453 => [\'markers','markersLocation'] },
	'markersname' => { 453 => [\'markers','markersName'] },
	'markersprobability' => { 453 => [\'markers','markersProbability'] },
	'markersspeaker' => { 453 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 453 => [\'markers','markersStartTime'] },
	'markerstarget' => { 453 => [\'markers','markersTarget'] },
	'markerstype' => { 453 => [\'markers','markersType'] },
	'maskedareas' => { 111 => 0xc68e },
	'masterdocumentid' => { 119 => 0xb9 },
	'mastergain' => { 209 => 0x50 },
	'matrixmetering' => { 249 => '50.1', 251 => '48.1', 252 => '48.1', 261 => '48.1', 262 => '48.1' },
	'maxaperture' => { 33 => 0x1a, 131 => 0x6103, 148 => 'MaxAperture', 165 => 0x17, 171 => 0x49c5, 266 => 0x20a, 311 => '14.1' },
	'maxapertureatmaxfocal' => { 116 => 0x1407, 148 => 'MaxApertureAtMaxFocal', 197 => 0xb, 198 => 0x10, 199 => 0x11, 266 => 0x206 },
	'maxapertureatminfocal' => { 116 => 0x1406, 197 => 0xa, 198 => 0xf, 199 => 0x10, 266 => 0x205 },
	'maxaperturevalue' => { 111 => 0x9205, 329 => 0x414, 433 => 'MaxApertureValue' },
	'maxavailheight' => { 439 => 'MaxAvailHeight' },
	'maxavailwidth' => { 439 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 248 => 0xb, 249 => 0xc, 251 => '12.1', 252 => '12.1', 257 => 0xc, 258 => 0xb, 261 => '12.1', 262 => '12.1' },
	'maxfaces' => { 269 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 116 => 0x1405, 148 => 'MaxFocalLength', 197 => 0x9, 198 => 0xe, 199 => 0xf, 266 => 0x208, 388 => 0x127c, 389 => 0x1138, 390 => 0x330, 391 => 0x330, 392 => 0x30e },
	'maximumdensityrange' => { 121 => 0x8c },
	'maxpagesize' => { 458 => 'MaxPageSize' },
	'maxpagesizeh' => { 458 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 458 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 458 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 111 => 0x119 },
	'maxstorage' => { 448 => 'maxstorage' },
	'mb-d10batteries' => { 248 => '12.6' },
	'mb-d10batterytype' => { 257 => '13.3' },
	'mb-d11batterytype' => { 258 => '2.3' },
	'mb-d12batterytype' => { 261 => '3.2' },
	'mb-d80batteries' => { 259 => '6.5' },
	'mb-d80batterytype' => { 263 => '3.2' },
	'mcuversion' => { 197 => 0xc, 198 => 0x11, 199 => 0x12 },
	'md5digest' => { 149 => 'zmd5' },
	'mditemfindercomment' => { 158 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 158 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 158 => 'MDItemFSLabel' },
	'meal' => { 445 => 'meal' },
	'measuredev' => { 27 => 0x9, 70 => 0x3, 89 => 0x1814, 141 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 70 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 171 => 0x690, 282 => 0x312, 288 => 0x3407 },
	'measuredrggb' => { 59 => 0x1 },
	'measuredrggbdata' => { 39 => 0x287 },
	'measurementaccuracy' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 110 => 'MeasurementOrFact' },
	'measurementremarks' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 110 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 414 => 'MeasureType' },
	'mechanicalshuttercount' => { 202 => 0x37 },
	'mediaconstraints' => { 275 => 'MediaConstraints' },
	'mediacreatedate' => { 337 => 0x1 },
	'mediaeventiddate' => { 419 => 'MediaEventIdDate' },
	'mediamodifydate' => { 337 => 0x2 },
	'mediasummarycode' => { 275 => 'MediaSummaryCode' },
	'memoaudioquality' => { 76 => 0x812 },
	'memorycardconfiguration' => { 370 => 0x16 },
	'memorycardnumber' => { 189 => 0x2 },
	'menubuttondisplayposition' => { 74 => 0xb, 77 => 0xa, 78 => 0xb, 81 => 0xb },
	'menubuttonreturn' => { 82 => 0xb },
	'menumonitorofftime' => { 248 => '26.1', 249 => '22.1', 251 => '22.1', 252 => '22.1', 256 => '21.1', 257 => '8.2', 258 => '21.1', 261 => '22.1', 262 => '22.1', 263 => '22.1' },
	'metadatadate' => { 451 => 'MetadataDate' },
	'metadatamoddate' => { 453 => 'metadataModDate' },
	'metaversion' => { 383 => 0x34 },
	'meterinfo1row1' => { 377 => 0x0, 378 => 0x0 },
	'meterinfo1row2' => { 377 => 0x6c, 378 => 0x5a },
	'meterinfo1row3' => { 377 => 0xd8, 378 => 0xb4 },
	'meterinfo1row4' => { 377 => 0x144, 378 => 0x10e },
	'meterinfo1row5' => { 377 => 0x1b0, 378 => 0x168 },
	'meterinfo1row6' => { 377 => 0x21c, 378 => 0x1c2 },
	'meterinfo1row7' => { 377 => 0x288, 378 => 0x21c },
	'meterinfo2row1' => { 377 => 0x2f4, 378 => 0x276 },
	'meterinfo2row2' => { 377 => 0x378, 378 => 0x2e4 },
	'meterinfo2row3' => { 377 => 0x3fc, 378 => 0x352 },
	'meterinfo2row4' => { 377 => 0x480, 378 => 0x3c0 },
	'meterinfo2row5' => { 377 => 0x504, 378 => 0x42e },
	'meterinfo2row6' => { 377 => 0x588, 378 => 0x49c },
	'meterinfo2row7' => { 377 => 0x60c, 378 => 0x50a },
	'meterinfo2row8' => { 377 => 0x690, 378 => 0x578 },
	'meterinfo2row9' => { 377 => 0x714, 378 => 0x5e6 },
	'metering' => { 250 => '6.1' },
	'meteringmode' => { 33 => 0x11, 111 => 0x9207, 127 => 0x1c, 165 => 0x7, 166 => 0x25, 168 => 0x12, 265 => 0x202, 320 => 0x17, 356 => 0x9, 364 => 0x15, 365 => 0x13, 366 => 0x7, 381 => 0x3, 384 => 0x1174, 385 => 0x1178, 386 => 0x1154, 387 => 0x11d0, 388 => 0x11ac, 389 => 0x1064, 390 => 0x25c, 391 => 0x25c, 392 => 0x24b, 433 => 'MeteringMode' },
	'meteringmode2' => { 301 => '2.1', 376 => 0x202c },
	'meteringmode3' => { 301 => '16.1' },
	'meteringoffscaleindicator' => { 168 => 0x53 },
	'meteringtime' => { 248 => '22.2', 250 => '3.2', 253 => '17.1', 254 => '18.1', 257 => '7.3', 258 => '18.1', 259 => '3.2', 263 => '19.1' },
	'micro1version' => { 342 => 0x1f },
	'micro2version' => { 342 => 0x2d },
	'mieversion' => { 149 => '0Vers' },
	'mime' => { 414 => 'Mime' },
	'minaperture' => { 33 => 0x1b, 148 => 'MinAperture', 311 => '0.2' },
	'minaperturevalue' => { 329 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 116 => 0x1404, 148 => 'MinFocalLength', 197 => 0x8, 198 => 0xd, 199 => 0xe, 266 => 0x207, 388 => 0x127a, 389 => 0x1136, 390 => 0x32e, 391 => 0x32e, 392 => 0x30c },
	'minfocusdistance' => { 311 => 0x3 },
	'minoltadate' => { 165 => 0x15 },
	'minoltaimagesize' => { 165 => 0x4, 166 => 0xc, 167 => 0x2, 170 => 0x103 },
	'minoltamodelid' => { 165 => 0x25 },
	'minoltaquality' => { 165 => 0x5, 166 => 0xd, 167 => 0x3, 170 => [0x102,0x103] },
	'minoltatime' => { 165 => 0x16 },
	'minormodelagedisclosure' => { 275 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 111 => 0x118 },
	'mirrorlockup' => { 74 => 0xc, 75 => 0xc, 76 => 0x60f, 77 => 0xb, 78 => 0xc, 79 => 0x6, 80 => 0x6, 81 => 0xc, 82 => 0x3 },
	'mobilecountrycode' => { 427 => 'mcc' },
	'mobilenetworkcode' => { 427 => 'mnc' },
	'moddate' => { 278 => 'modify-date', 440 => 'ModDate' },
	'modedialposition' => { 370 => 0x14 },
	'model' => { 90 => 0x6, 111 => 0x110, 141 => 'Model', 278 => 'Model', 290 => 0x110, 320 => 0x23f, 356 => 0x84, 414 => 'Model', 442 => 'model', 449 => 'Model' },
	'modelage' => { 439 => 'ModelAge' },
	'modelid' => { 264 => 0x0 },
	'modelingflash' => { 248 => '21.4', 249 => '31.1', 251 => '31.1', 252 => '31.1', 257 => '26.4', 258 => '30.2', 259 => '7.4', 260 => '30.1', 261 => '31.1', 262 => '31.1', 263 => '31.3' },
	'modelreleaseid' => { 275 => 'ModelReleaseID' },
	'modelreleasestatus' => { 275 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 396 => 0x52, 397 => 0x46, 398 => 0x53 },
	'modelyear' => { 442 => 'modelYear' },
	'modificationdate' => { 443 => 'modificationDate' },
	'modifiedcolortemp' => { 60 => 0x9 },
	'modifieddigitalgain' => { 60 => 0xb },
	'modifiedparamflag' => { 53 => 0x1 },
	'modifiedpicturestyle' => { 60 => 0xa },
	'modifiedsaturation' => { 265 => 0x504 },
	'modifiedsensorbluelevel' => { 60 => 0x5 },
	'modifiedsensorredlevel' => { 60 => 0x4 },
	'modifiedsharpness' => { 60 => 0x2 },
	'modifiedsharpnessfreq' => { 60 => 0x3 },
	'modifiedtonecurve' => { 60 => 0x1 },
	'modifiedwhitebalance' => { 60 => 0x8 },
	'modifiedwhitebalanceblue' => { 60 => 0x7 },
	'modifiedwhitebalancered' => { 60 => 0x6 },
	'modifydate' => { 111 => 0x132, 142 => 'ModifyDate', 274 => 'ModDate', 276 => 'tIME', 336 => 'ModDate', 338 => 0x2, 451 => 'ModifyDate' },
	'moirefilter' => { 111 => 0xfe58, 429 => 'MoireFilter' },
	'monitordisplayoff' => { 168 => 0x4c },
	'monitorofftime' => { 248 => '18.2', 250 => '3.1', 259 => '3.1' },
	'monochromecolor' => { 265 => 0x53b },
	'monochromecontrast' => { 101 => 0x3c },
	'monochromefiltereffect' => { 95 => 0x20307, 101 => 0x3a, 320 => 0x73 },
	'monochromelinear' => { 101 => 0x3d },
	'monochromeoutputhighlightpoint' => { 101 => 0x41 },
	'monochromeoutputshadowpoint' => { 101 => 0x42 },
	'monochromeprofilesettings' => { 265 => 0x537 },
	'monochromerawhighlight' => { 101 => 0x7a },
	'monochromerawhighlightpoint' => { 101 => 0x3f },
	'monochromerawshadow' => { 101 => 0x83 },
	'monochromerawshadowpoint' => { 101 => 0x40 },
	'monochromesharpness' => { 101 => 0x3e },
	'monochrometoning' => { 320 => 0x74 },
	'monochrometoningeffect' => { 95 => 0x20306, 101 => 0x3b },
	'monochromeunsharpmaskfineness' => { 101 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 101 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 101 => 0xb4 },
	'monochromevignetting' => { 265 => 0x53a },
	'monthdaycreated' => { 127 => 0x12, 136 => 0xe },
	'moonphase' => { 341 => 0x12, 342 => 0x43 },
	'morepermissions' => { 426 => 'morePermissions' },
	'motionsensitivity' => { 341 => 0x29 },
	'movieaelockbuttonassignment' => { 261 => '40.1' },
	'moviefunc1button' => { 251 => '41.1', 252 => '41.1', 262 => '41.1' },
	'moviefunctionbutton' => { 249 => '41.1', 261 => '41.1' },
	'moviefunctionbuttonplusdials' => { 249 => '52.1' },
	'moviepreviewbutton' => { 249 => '41.2', 251 => '41.2', 252 => '41.2', 261 => '41.2', 262 => '41.2' },
	'moviepreviewbuttonplusdials' => { 249 => '52.2' },
	'movieshutterbutton' => { 249 => '38.3', 251 => '38.3', 252 => '38.3', 261 => '38.3', 262 => '38.3' },
	'moviesubselectorassignment' => { 249 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 249 => '53.1' },
	'multiburstimageheight' => { 376 => 0x1002 },
	'multiburstimagewidth' => { 376 => 0x1001 },
	'multiburstmode' => { 376 => 0x1000 },
	'multicontrollerwhilemetering' => { 76 => 0x517 },
	'multiexposure' => { 62 => 0x1 },
	'multiexposureautogain' => { 203 => 0x3 },
	'multiexposurecontrol' => { 62 => 0x2 },
	'multiexposuremode' => { 203 => 0x1 },
	'multiexposureshots' => { 62 => 0x3, 203 => 0x2 },
	'multiframenoisereduction' => { 366 => 0x35, 376 => 0x200b, 381 => 0x15 },
	'multiframenreffect' => { 376 => 0x2023 },
	'multifunctionlock' => { 76 => 0x70f },
	'multipleexposuremode' => { 269 => 0x101c },
	'multipleexposureset' => { 301 => '10.1' },
	'multisample' => { 209 => 0x40 },
	'multiselector' => { 248 => '9.4', 249 => '10.3', 251 => '10.3', 252 => '10.3', 257 => '27.4', 261 => '10.3', 262 => '10.3' },
	'multiselectorliveview' => { 248 => '4.3', 251 => '37.1', 252 => '37.1', 261 => '37.1', 262 => '37.1' },
	'multiselectorliveviewmode' => { 219 => 0x18c2 },
	'multiselectorplaybackmode' => { 248 => ['13.5','9.2'], 249 => '10.2', 252 => '10.2', 257 => '27.2', 261 => '10.2', 262 => '10.2' },
	'multiselectorshootmode' => { 248 => '9.1', 249 => '10.1', 251 => '10.1', 252 => '10.1', 257 => '27.1', 261 => '10.1', 262 => '10.1' },
	'mycolormode' => { 63 => 0x2 },
	'nationalcatalognumber' => { 443 => 'nationalCatalogNumber' },
	'nativedigest' => { 433 => 'NativeDigest', 449 => 'NativeDigest' },
	'ncdfileinfo' => { 125 => 0x414 },
	'ndfilter' => { 70 => 0x1c, 265 => 0x204, 346 => 0x1019 },
	'near' => { 414 => 'Near' },
	'nefbitdepth' => { 202 => 0xe22 },
	'nefcompression' => { 202 => 0x93 },
	'neflinearizationtable' => { 202 => 0x96 },
	'negativecachelargepreviewsize' => { 429 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 429 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 429 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 320 => 0x88 },
	'neutraloutputhighlightpoint' => { 101 => 0x2f },
	'neutraloutputshadowpoint' => { 101 => 0x30 },
	'neutralrawcolortone' => { 101 => 0x28 },
	'neutralrawcontrast' => { 101 => 0x2a },
	'neutralrawhighlight' => { 101 => 0x78 },
	'neutralrawhighlightpoint' => { 101 => 0x2d },
	'neutralrawlinear' => { 101 => 0x2b },
	'neutralrawsaturation' => { 101 => 0x29 },
	'neutralrawshadow' => { 101 => 0x81 },
	'neutralrawshadowpoint' => { 101 => 0x2e },
	'neutralrawsharpness' => { 101 => 0x2c },
	'neutralunsharpmaskfineness' => { 101 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 101 => 0xa8 },
	'neutraunsharpmaskstrength' => { 101 => 0xa4 },
	'newrawimagedigest' => { 111 => 0xc7a7 },
	'newsphotoversion' => { 121 => 0x0 },
	'nickname' => { 451 => 'Nickname' },
	'nikoncapturedata' => { 202 => 0xe01 },
	'nikoncaptureeditversions' => { 202 => 0xe13 },
	'nikoncaptureoutput' => { 202 => 0xe1e },
	'nikoncaptureversion' => { 202 => 0xe09 },
	'nikoniccprofile' => { 202 => 0xe1d },
	'nikonimagesize' => { 216 => '723.1', 217 => '732.1', 226 => 0x2c4 },
	'noisefilter' => { 265 => 0x527 },
	'noiseprofile' => { 111 => 0xc761 },
	'noisereduction' => { 116 => 0x100b, 166 => 0xb0, 167 => 0x60, 168 => 0x3f, 202 => 0x95, 241 => 0x753dcbc0, 242 => 0x17, 265 => 0x50a, 270 => 0x103a, 286 => 0x2d, 320 => 0x49, 346 => 0x100f, 348 => 0x2a },
	'noisereduction2' => { 269 => 0x1010 },
	'noisereductionapplied' => { 111 => 0xc6f7 },
	'noisereductionintensity' => { 242 => 0x9 },
	'noisereductionmethod' => { 242 => 0x11 },
	'noisereductionmode' => { 409 => 0x801e },
	'noisereductionsharpness' => { 242 => 0xd },
	'noisereductionvalue' => { 409 => 0x8027 },
	'nomemorycard' => { 248 => '22.1', 249 => '4.2', 250 => '0.3', 253 => '2.4', 254 => '3.2', 255 => '3.2', 257 => '33.7', 258 => '3.2', 259 => '0.3', 261 => '4.2', 263 => '4.5' },
	'nominalmaxaperture' => { 311 => 0xa },
	'nominalminaperture' => { 311 => '10.1' },
	'normalwhitelevel' => { 40 => [0x2b8,0x2cf,0x2d3], 42 => 0x1e3, 43 => [0x1fc,0x2dc], 44 => [0x230,0x30e], 45 => 0x31c },
	'notes' => { 410 => 'Notes', 423 => 'notes' },
	'npages' => { 458 => 'NPages' },
	'nrwdata' => { 202 => 0x14 },
	'nullrecord' => { 89 => 0x0 },
	'numafpoints' => { 297 => 0x2 },
	'number' => { 443 => 'number' },
	'numberofbeats' => { 453 => 'numberOfBeats' },
	'numberoffocuspoints' => { 251 => '1.2', 252 => '1.2', 255 => '0.2', 256 => '0.3', 258 => '0.3' },
	'numfaceelements' => { 116 => 0x4200 },
	'numfacepositions' => { 280 => 0x0 },
	'numindexentries' => { 121 => 0x54 },
	'numwbentries' => { 291 => 0x0, 292 => 0x0 },
	'object' => { 443 => 'object' },
	'objectattributereference' => { 119 => 0x4 },
	'objectcycle' => { 119 => 0x4b, 423 => 'ObjectCycle' },
	'objectdescription' => { 442 => 'objectDescription' },
	'objectdistance' => { 104 => 0x6, 105 => 0x2022 },
	'objectname' => { 119 => 0x5 },
	'objectpreviewdata' => { 119 => 0xca },
	'objectpreviewfileformat' => { 119 => 0xc8 },
	'objectpreviewfileversion' => { 119 => 0xc9 },
	'objectsubtype' => { 442 => 'objectSubtype' },
	'objecttype' => { 442 => 'objectType' },
	'objecttypereference' => { 119 => 0x3 },
	'occurrence' => { 110 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 110 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 110 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 110 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 110 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 110 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 110 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 110 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 110 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 110 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 110 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 110 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 110 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 110 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 110 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 110 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 110 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 110 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 110 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 110 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 110 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 110 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 110 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 110 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 433 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 433 => [\'OECF','OECFNames'] },
	'oecfrows' => { 433 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 433 => [\'OECF','OECFValues'] },
	'offsaledate' => { 443 => 'offSaleDate' },
	'offsaledatea-platform' => { 443 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 443 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 111 => 0xea1d },
	'offsettime' => { 111 => 0x9010 },
	'offsettimedigitized' => { 111 => 0x9012 },
	'offsettimeoriginal' => { 111 => 0x9011 },
	'okbutton' => { 258 => '15.1', 263 => '16.1' },
	'oldsubfiletype' => { 111 => 0xff },
	'olympusimageheight' => { 270 => 0x102f },
	'olympusimagewidth' => { 270 => 0x102e },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 270 => 0x302 },
	'onsaledate' => { 443 => 'onSaleDate' },
	'onsaledatea-platform' => { 443 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 443 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 443 => 'onSaleDay' },
	'onsaledaya-platform' => { 443 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 443 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 111 => 0xc740 },
	'opcodelist2' => { 111 => 0xc741 },
	'opcodelist3' => { 111 => 0xc74e },
	'opticalzoom' => { 129 => 0xfa3d, 131 => [0x6006,0xf006], 132 => 0x1000, 133 => 0xf, 136 => 0x1e, 148 => 'OpticalZoom' },
	'opticalzoomcode' => { 70 => 0xa },
	'opticalzoommode' => { 286 => 0x34 },
	'opticalzoomon' => { 355 => 0x219 },
	'optionenddate' => { 446 => 'optionEndDate' },
	'opto-electricconvfactor' => { 433 => 'OECF' },
	'orangehsl' => { 95 => 0x20911 },
	'ordernumber' => { 116 => 0x8002 },
	'organisationinimagecode' => { 439 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 439 => 'OrganisationInImageName' },
	'organization' => { 443 => 'organization' },
	'orientation' => { 111 => 0x112, 290 => 0x112, 442 => 'orientation', 449 => 'Orientation' },
	'orientation2' => { 381 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 76 => 0x516 },
	'originalbestqualitysize' => { 111 => 0xc792 },
	'originalcreatedatetime' => { 419 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 106 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 58 => 0x83 },
	'originaldefaultcropsize' => { 111 => 0xc793 },
	'originaldefaultfinalsize' => { 111 => 0xc791 },
	'originaldirectory' => { 284 => 0x408 },
	'originaldocumentid' => { 454 => 'OriginalDocumentID' },
	'originalfilename' => { 89 => 0x816, 125 => 0x3e9, 137 => 0x20, 284 => 0x407, 419 => 'OriginalFilename' },
	'originalimageheight' => { 72 => 0xc, 115 => 0x1 },
	'originalimagewidth' => { 72 => 0xb, 115 => 0x0 },
	'originalrawfiledata' => { 111 => 0xc68c },
	'originalrawfiledigest' => { 111 => 0xc71d },
	'originalrawfilename' => { 111 => 0xc68b },
	'originaltransmissionreference' => { 119 => 0x67 },
	'originatingprogram' => { 119 => 0x41, 423 => 'OriginatingProgram' },
	'originplatform' => { 443 => 'originPlatform' },
	'os' => { 431 => 'os' },
	'otherconditions' => { 275 => 'OtherConditions' },
	'otherconstraints' => { 275 => 'OtherConstraints' },
	'otherimage' => { 106 => 'OtherImage' },
	'otherimageinfo' => { 275 => 'OtherImageInfo' },
	'otherimagelength' => { 111 => 0x202 },
	'otherimagestart' => { 111 => 0x201 },
	'otherlicensedocuments' => { 275 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 275 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 275 => 'OtherLicenseRequirements' },
	'outcue' => { 453 => 'outCue' },
	'outcuescale' => { 453 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 453 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 180 => 0x3 },
	'outputimagewidth' => { 180 => 0x2 },
	'outputprofile' => { 125 => 0x138b },
	'outputresolution' => { 180 => 0x4 },
	'owner' => { 457 => 'Owner' },
	'ownerid' => { 119 => 0xbc },
	'ownername' => { 14 => 0x10f, 58 => 0x9, 89 => 0x810, 111 => [0xa430,0xfde8], 141 => 'OwnerName', 425 => 'OwnerName', 434 => 'CameraOwnerName' },
	'padding' => { 111 => 0xea1c },
	'pagecount' => { 443 => 'pageCount' },
	'pageimage' => { 451 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 451 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 451 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 451 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 451 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 451 => 'PageInfo' },
	'pagename' => { 111 => 0x11d },
	'pagenumber' => { 111 => 0x129 },
	'pageprogressiondirection' => { 443 => 'pageProgressionDirection' },
	'pagerange' => { 443 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 429 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 429 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 286 => 0x26 },
	'panasonicimageheight' => { 286 => 0x4c },
	'panasonicimagewidth' => { 286 => 0x4b },
	'panasonicrawversion' => { 290 => 0x1 },
	'panasonictitle' => { 111 => 0xc6d2 },
	'panasonictitle2' => { 111 => 0xc6d3 },
	'panoramaangle' => { 116 => 0x1153 },
	'panoramacropbottom' => { 382 => 0x7 },
	'panoramacropleft' => { 382 => 0x4 },
	'panoramacropright' => { 382 => 0x6 },
	'panoramacroptop' => { 382 => 0x5 },
	'panoramadirection' => { 66 => 0x5, 116 => 0x1154, 382 => 0x3 },
	'panoramaframeheight' => { 382 => 0x9 },
	'panoramaframenumber' => { 66 => 0x2 },
	'panoramaframewidth' => { 382 => 0x8 },
	'panoramafullheight' => { 382 => 0x2 },
	'panoramafullwidth' => { 382 => 0x1 },
	'panoramamode' => { 127 => 0x3c, 265 => 0x601 },
	'panoramasize3d' => { 366 => 0x38 },
	'panoramasourceheight' => { 382 => 0xb },
	'panoramasourcewidth' => { 382 => 0xa },
	'panoramicstitchcameramotion' => { 161 => 'PanoramicStitchCameraMotion', 162 => 0x1 },
	'panoramicstitchmaptype' => { 161 => 'PanoramicStitchMapType', 162 => 0x2 },
	'panoramicstitchphi0' => { 161 => 'PanoramicStitchPhi0', 162 => 0x5 },
	'panoramicstitchphi1' => { 161 => 'PanoramicStitchPhi1', 162 => 0x6 },
	'panoramicstitchtheta0' => { 161 => 'PanoramicStitchTheta0', 162 => 0x3 },
	'panoramicstitchtheta1' => { 161 => 'PanoramicStitchTheta1', 162 => 0x4 },
	'panoramicstitchversion' => { 162 => 0x0 },
	'pantry' => { 454 => 'Pantry' },
	'parallax' => { 116 => 0xb211, 264 => 0x28 },
	'parametricdarks' => { 429 => 'ParametricDarks' },
	'parametrichighlights' => { 429 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 429 => 'ParametricHighlightSplit' },
	'parametriclights' => { 429 => 'ParametricLights' },
	'parametricmidtonesplit' => { 429 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 429 => 'ParametricShadows' },
	'parametricshadowsplit' => { 429 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 419 => 'ParentMediaEventID' },
	'parentmeid' => { 419 => 'ParentMEID' },
	'parentreference1' => { 437 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 437 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 453 => 'partOfCompilation' },
	'patientbirthdate' => { 411 => 'PatientDOB' },
	'patientid' => { 411 => 'PatientID' },
	'patientname' => { 411 => 'PatientName' },
	'patientsex' => { 411 => 'PatientSex' },
	'pdfversion' => { 440 => 'PDFVersion' },
	'pentaximagesize' => { 320 => 0x9 },
	'pentaxmodelid' => { 300 => 0x0, 320 => 0x5 },
	'pentaxmodeltype' => { 320 => 0x1 },
	'pentaxversion' => { 320 => 0x0 },
	'people' => { 412 => 'People', 421 => 'People' },
	'perchannelblacklevel' => { 39 => 0xc4, 40 => [0x2b4,0x2cb,0x2cf], 41 => 0x108, 42 => 0x1df, 43 => [0x1f8,0x2d8], 44 => [0x22c,0x30a], 45 => 0x149 },
	'peripheralillumcentralradius' => { 409 => 0x8030 },
	'peripheralillumcentralvalue' => { 409 => 0x8031 },
	'peripheralillumination' => { 95 => 0x20702, 101 => 0x68 },
	'peripheralilluminationcorr' => { 57 => 0x1, 310 => 0x2 },
	'peripheralilluminationon' => { 95 => '0x20702.0', 101 => 0x64 },
	'peripheralillumperiphvalue' => { 409 => 0x8032 },
	'peripherallighting' => { 72 => 0x2 },
	'peripherallightingsetting' => { 73 => 0x5 },
	'peripherallightingvalue' => { 72 => 0x6 },
	'permissions' => { 446 => 'permissions' },
	'permits' => { 426 => 'permits' },
	'person' => { 443 => 'person' },
	'personality' => { 419 => 'Personality' },
	'personheard' => { 439 => 'PersonHeard' },
	'personheardidentifier' => { 439 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 439 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 439 => 'PersonInImage' },
	'personinimagecharacteristic' => { 439 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 439 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 439 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 439 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 439 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 439 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 439 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 439 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 439 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 429 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 429 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 429 => 'PerspectiveRotate' },
	'perspectivescale' => { 429 => 'PerspectiveScale' },
	'perspectiveupright' => { 429 => 'PerspectiveUpright' },
	'perspectivevertical' => { 429 => 'PerspectiveVertical' },
	'perspectivex' => { 429 => 'PerspectiveX' },
	'perspectivey' => { 429 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 84 => 0x1 },
	'pf10retainprogramshift' => { 84 => 0xb },
	'pf13drivepriority' => { 84 => 0xe },
	'pf14disablefocussearch' => { 84 => 0xf },
	'pf15disableafassistbeam' => { 84 => 0x10 },
	'pf16autofocuspointshoot' => { 84 => 0x11 },
	'pf17disableafpointsel' => { 84 => 0x12 },
	'pf18enableautoafpointsel' => { 84 => 0x13 },
	'pf19continuousshootspeed' => { 84 => 0x14 },
	'pf19shootingspeedhigh' => { 83 => 0xa },
	'pf19shootingspeedlow' => { 83 => 0x9 },
	'pf1disableshootingmodes' => { 84 => 0x2 },
	'pf1value' => { 83 => 0x1 },
	'pf20limitcontinousshots' => { 84 => 0x15 },
	'pf20maxcontinousshots' => { 83 => 0xb },
	'pf21enablequietoperation' => { 84 => 0x16 },
	'pf23felocktime' => { 83 => 0xd },
	'pf23postreleasetime' => { 83 => 0xe },
	'pf23settimerlengths' => { 84 => 0x18 },
	'pf23shutterbuttontime' => { 83 => 0xc },
	'pf24lightlcdduringbulb' => { 84 => 0x19 },
	'pf25aemode' => { 83 => 0xf },
	'pf25afmode' => { 83 => 0x12 },
	'pf25afpointsel' => { 83 => 0x13 },
	'pf25colormatrix' => { 83 => 0x17 },
	'pf25defaultclearsettings' => { 84 => 0x1a },
	'pf25drivemode' => { 83 => 0x11 },
	'pf25imagesize' => { 83 => 0x14 },
	'pf25meteringmode' => { 83 => 0x10 },
	'pf25parameters' => { 83 => 0x16 },
	'pf25wbmode' => { 83 => 0x15 },
	'pf26shortenreleaselag' => { 84 => 0x1b },
	'pf27reversedialrotation' => { 84 => 0x1c },
	'pf27value' => { 83 => 0x18 },
	'pf28noquickdialexpcomp' => { 84 => 0x1d },
	'pf29quickdialswitchoff' => { 84 => 0x1e },
	'pf2disablemeteringmodes' => { 84 => 0x3 },
	'pf2value' => { 83 => 0x2 },
	'pf30enlargementmode' => { 84 => 0x1f },
	'pf31originaldecisiondata' => { 84 => 0x20 },
	'pf3manualexposuremetering' => { 84 => 0x4 },
	'pf3value' => { 83 => 0x3 },
	'pf4exposuretimelimits' => { 84 => 0x5 },
	'pf4exposuretimemax' => { 83 => 0x5 },
	'pf4exposuretimemin' => { 83 => 0x4 },
	'pf5aperturelimits' => { 84 => 0x6 },
	'pf5aperturemax' => { 83 => 0x7 },
	'pf5aperturemin' => { 83 => 0x6 },
	'pf6presetshootingmodes' => { 84 => 0x7 },
	'pf7bracketcontinuousshoot' => { 84 => 0x8 },
	'pf8bracketshots' => { 83 => 0x8 },
	'pf8setbracketshots' => { 84 => 0x9 },
	'pf9changebracketsequence' => { 84 => 0xa },
	'phasedetectaf' => { 177 => 0x6 },
	'phonenumber' => { 142 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 241 => 0xe9651831 },
	'photoeffects' => { 241 => 0xab5eca5e },
	'photoeffectsblue' => { 243 => 0x8 },
	'photoeffectsgreen' => { 243 => 0x6 },
	'photoeffectsred' => { 243 => 0x4 },
	'photoeffectstype' => { 243 => 0x0 },
	'photographicsensitivity' => { 434 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 248 => '17.6', 257 => '33.6' },
	'photometricinterpretation' => { 111 => 0x106, 449 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 220 => 0xe7d, 229 => 0xfbd },
	'photoshootingmenubankimagearea' => { 220 => '3716.1', 229 => 0x791 },
	'photoshopbgrthumbnail' => { 334 => 0x409 },
	'photoshopquality' => { 333 => 0x0 },
	'photoshopthumbnail' => { 334 => 0x40c },
	'photostyle' => { 286 => 0x89 },
	'picklabel' => { 432 => 'PickLabel' },
	'pictinfo' => { 355 => 0x208 },
	'picturecontrol' => { 241 => 0xe2173c47 },
	'picturecontrolactive' => { 244 => 0x0 },
	'picturecontroladjust' => { 204 => 0x30, 205 => 0x30 },
	'picturecontrolbase' => { 204 => 0x18, 205 => 0x18 },
	'picturecontroldata' => { 202 => [0xbd,0x23] },
	'picturecontrolmode' => { 244 => 0x13 },
	'picturecontrolname' => { 204 => 0x4, 205 => 0x4 },
	'picturecontrolquickadjust' => { 204 => 0x31, 205 => 0x31 },
	'pictureeffect' => { 376 => 0x200e },
	'pictureeffect2' => { 384 => 0x1163, 385 => 0x1167, 386 => 0x1143, 387 => 0x11bf, 388 => 0x119b, 389 => 0x1053, 390 => 0x24b, 391 => 0x24b, 392 => 0x23c, 405 => 0x46 },
	'picturefinish' => { 166 => 0x71 },
	'picturemode' => { 116 => 0x1031, 265 => 0x520, 320 => [0xb,0x33], 356 => 0x3d },
	'picturemode2' => { 301 => 0x0 },
	'picturemodebwfilter' => { 265 => 0x525 },
	'picturemodecontrast' => { 265 => 0x523 },
	'picturemodeeffect' => { 265 => 0x52d },
	'picturemodehue' => { 265 => 0x522 },
	'picturemodesaturation' => { 265 => 0x521 },
	'picturemodesharpness' => { 265 => 0x524 },
	'picturemodetone' => { 265 => 0x526 },
	'pictureprofile' => { 384 => [0x115e,0x115f], 385 => [0x1162,0x1163], 386 => [0x113e,0x113f], 387 => [0x11ba,0x11bb], 388 => [0x1196,0x1197], 389 => [0x104e,0x104f], 390 => [0x246,0x247], 391 => [0x246,0x247], 392 => [0x237,0x238] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 68 => 0xa, 95 => 0x20301, 101 => 0x2 },
	'picturewizard' => { 353 => 0x21 },
	'picturewizardcolor' => { 352 => 0x1 },
	'picturewizardcontrast' => { 352 => 0x4 },
	'picturewizardmode' => { 352 => 0x0 },
	'picturewizardsaturation' => { 352 => 0x2 },
	'picturewizardsharpness' => { 352 => 0x3 },
	'pipelineversion' => { 161 => 'PipelineVersion' },
	'pitch' => { 107 => 0x6, 249 => '4.1', 261 => '4.1' },
	'pitchangle' => { 219 => 0x350f, 220 => 0x2c28, 228 => 0x36f8, 265 => 0x904, 286 => 0x91, 319 => 0x2, 351 => 0x1 },
	'pixelshiftinfo' => { 376 => 0x202f },
	'pixelshiftresolution' => { 321 => 0x0 },
	'pixelsperunitx' => { 277 => 0x0 },
	'pixelsperunity' => { 277 => 0x4 },
	'pixelunits' => { 277 => 0x8 },
	'planarconfiguration' => { 111 => 0x11c, 449 => 'PlanarConfiguration' },
	'platenames' => { 458 => 'PlateNames' },
	'platform' => { 443 => 'platform' },
	'playbackmenustime' => { 253 => '20.1', 254 => '21.1', 255 => '21.1' },
	'playbackmonitorofftime' => { 248 => '25.2', 249 => '36.1', 251 => '36.1', 252 => '36.1', 256 => '35.1', 257 => '8.1', 258 => '35.1', 261 => '36.1', 262 => '36.1', 263 => '21.1' },
	'playbackzoom' => { 249 => '37.1' },
	'playdisplay' => { 168 => 0x4e },
	'plusversion' => { 275 => 'Version' },
	'pmversion' => { 332 => 'PMVersion' },
	'pngwarning' => { 278 => 'Warning' },
	'poilevel' => { 201 => 0x8 },
	'portraitoutputhighlightpoint' => { 101 => 0x1d },
	'portraitoutputshadowpoint' => { 101 => 0x1e },
	'portraitrawcolortone' => { 101 => 0x16 },
	'portraitrawcontrast' => { 101 => 0x18 },
	'portraitrawhighlight' => { 101 => 0x76 },
	'portraitrawhighlightpoint' => { 101 => 0x1b },
	'portraitrawlinear' => { 101 => 0x19 },
	'portraitrawsaturation' => { 101 => 0x17 },
	'portraitrawshadow' => { 101 => 0x7f },
	'portraitrawshadowpoint' => { 101 => 0x1c },
	'portraitrawsharpness' => { 101 => 0x1a },
	'portraitrefiner' => { 105 => 0x302b },
	'portraitunsharpmaskfineness' => { 101 => 0x9a },
	'portraitunsharpmaskstrength' => { 101 => 0x98 },
	'portraitunsharpmaskthreshold' => { 101 => 0x9c },
	'poseheadingdegrees' => { 417 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 417 => 'PosePitchDegrees' },
	'poserolldegrees' => { 417 => 'PoseRollDegrees' },
	'positiondescriptor' => { 442 => 'positionDescriptor' },
	'postalcode' => { 146 => 'PostalCode' },
	'postcropvignetteamount' => { 429 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 429 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 429 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 429 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 429 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 429 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 374 => 0xb },
	'potentialface2position' => { 374 => 0x15 },
	'potentialface3position' => { 374 => 0x1f },
	'potentialface4position' => { 374 => 0x29 },
	'potentialface5position' => { 374 => 0x33 },
	'potentialface6position' => { 374 => 0x3d },
	'potentialface7position' => { 374 => 0x47 },
	'potentialface8position' => { 374 => 0x51 },
	'powersource' => { 299 => '0.1' },
	'poweruptime' => { 202 => 0xb6 },
	'precaptureframes' => { 270 => 0x300 },
	'predictor' => { 111 => 0x13d },
	'preflashreturnstrength' => { 217 => 0x28a },
	'prefs' => { 119 => 0xdd, 332 => 'Prefs' },
	'preservedfilename' => { 454 => 'PreservedFileName' },
	'presetwhitebalance' => { 168 => 0x24, 409 => 0x8002 },
	'presetwhitebalanceadj' => { 409 => 0x8014 },
	'pressure' => { 111 => 0x9402 },
	'previewapplicationname' => { 111 => 0xc716 },
	'previewapplicationversion' => { 111 => 0xc717 },
	'previewbutton' => { 248 => ['14.1','15.1'], 249 => '15.1', 251 => '15.1', 252 => '15.1', 257 => '29.1', 258 => '14.1', 261 => '15.1', 262 => '15.1' },
	'previewbuttonplusdials' => { 248 => ['14.2','15.2'], 249 => '15.2', 251 => '43.1', 252 => '43.1', 257 => '31.2', 261 => '43.1', 262 => '43.1' },
	'previewcolorspace' => { 111 => 0xc71a },
	'previewcropbottom' => { 331 => 0xef },
	'previewcropleft' => { 331 => 0xec },
	'previewcropright' => { 331 => 0xee },
	'previewcroptop' => { 331 => 0xed },
	'previewdate' => { 339 => 0x0 },
	'previewdatetime' => { 111 => 0xc71b },
	'previewimage' => { 105 => 0x2000, 106 => 'PreviewImage', 112 => 'PreviewImage', 114 => 0x4, 151 => 'data', 170 => 0x81, 270 => 0x280, 285 => 0x300, 376 => 0x2001 },
	'previewimageborders' => { 320 => 0x3e },
	'previewimageheight' => { 67 => 0x4, 129 => 0xfa58 },
	'previewimagelength' => { 67 => 0x2, 105 => 0x3, 111 => [0x117,0x202], 170 => 0x89, 206 => 0x202, 265 => 0x102, 270 => 0x1037, 320 => 0x3, 345 => 0x1e, 350 => 0x3, 356 => [0x1b,0x1d], 367 => 0x202 },
	'previewimagename' => { 151 => '1Name' },
	'previewimagesize' => { 105 => 0x2, 134 => 0x2, 151 => 'ImageSize', 320 => 0x2, 356 => [0x1c,0x1e], 376 => 0xb02c },
	'previewimagestart' => { 67 => 0x5, 105 => 0x4, 111 => [0x111,0x201], 170 => 0x88, 206 => 0x201, 265 => 0x101, 270 => 0x1036, 320 => 0x4, 345 => 0x1c, 350 => 0x2, 356 => [0x1a,0x1c], 367 => 0x201 },
	'previewimagetype' => { 151 => '0Type' },
	'previewimagevalid' => { 265 => 0x100, 270 => 0x1035 },
	'previewimagewidth' => { 67 => 0x3, 129 => 0xfa57 },
	'previewquality' => { 67 => 0x1 },
	'previewsettingsdigest' => { 111 => 0xc719 },
	'previewsettingsname' => { 111 => 0xc718 },
	'primaryafpoint' => { 177 => [0x44,0x7] },
	'primarychromaticities' => { 111 => 0x13f, 449 => 'PrimaryChromaticities' },
	'primaryftp' => { 419 => 'PrimaryFTP' },
	'primaryslot' => { 220 => 0xe7f, 229 => 0xfbf },
	'printim' => { 111 => 0xc4a5 },
	'prioritysetinawb' => { 376 => 0x202b },
	'prioritysetupshutterrelease' => { 168 => 0x1d, 364 => 0x28 },
	'privatertkinfo' => { 420 => 'privateRTKInfo' },
	'processingsoftware' => { 111 => 0xb },
	'processversion' => { 429 => 'ProcessVersion' },
	'producer' => { 274 => 'Producer', 440 => 'Producer' },
	'productcode' => { 443 => 'productCode' },
	'productid' => { 120 => 0x32, 442 => 'productID' },
	'productidtype' => { 442 => 'productIDType' },
	'productinimage' => { 439 => 'ProductInImage' },
	'productinimagedescription' => { 439 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 439 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 439 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 300 => 0x2 },
	'productorserviceconstraints' => { 275 => 'ProductOrServiceConstraints' },
	'profession' => { 443 => 'profession' },
	'profilecalibrationsig' => { 111 => 0xc6f4 },
	'profilecopyright' => { 111 => 0xc6fe },
	'profileembedpolicy' => { 111 => 0xc6fd },
	'profilehuesatmapdata1' => { 111 => 0xc6fa },
	'profilehuesatmapdata2' => { 111 => 0xc6fb },
	'profilehuesatmapdims' => { 111 => 0xc6f9 },
	'profilehuesatmapencoding' => { 111 => 0xc7a3 },
	'profilelooktabledata' => { 111 => 0xc726 },
	'profilelooktabledims' => { 111 => 0xc725 },
	'profilelooktableencoding' => { 111 => 0xc7a4 },
	'profilename' => { 111 => 0xc6f8 },
	'profiletonecurve' => { 111 => 0xc6fc },
	'programiso' => { 286 => 0x3c },
	'programline' => { 301 => '1.1' },
	'programmode' => { 173 => 0x5 },
	'programshift' => { 202 => 0xd },
	'programversion' => { 119 => 0x46 },
	'prohibits' => { 426 => 'prohibits' },
	'projectiontype' => { 417 => 'ProjectionType', 418 => 'ProjectionType' },
	'projectname' => { 453 => 'projectName' },
	'projectref' => { 453 => 'projectRef' },
	'projectrefpath' => { 453 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 453 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 275 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 275 => 'PropertyReleaseStatus' },
	'province-state' => { 119 => 0x5f },
	'publicationdate' => { 443 => 'publicationDate' },
	'publicationdatea-platform' => { 443 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 443 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 443 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 443 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 443 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 439 => 'PublicationEvent' },
	'publicationeventdate' => { 439 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 439 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 439 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 443 => 'publicationName' },
	'publisher' => { 430 => 'publisher' },
	'publishingfrequency' => { 443 => 'publishingFrequency' },
	'pulldown' => { 453 => 'pullDown' },
	'purplehsl' => { 95 => 0x20916 },
	'quality' => { 0 => 0x1, 33 => 0x3, 104 => 0x2, 105 => 0x3002, 116 => 0x1000, 127 => 0x9, 202 => 0x4, 231 => 0x3, 270 => 0x201, 282 => 0x300, 320 => 0x8, 327 => 0x2, 356 => 0x16, 364 => 0x56, 365 => 0x56, 366 => 0xb, 376 => [0x102,0x202e] },
	'quality2' => { 384 => 0x1170, 385 => 0x1174, 386 => 0x1150, 388 => 0x11a8, 389 => 0x1060, 390 => 0x258, 391 => 0x258, 392 => 0x247, 396 => 0x29, 397 => 0x25, 398 => 0x2a },
	'qualitymode' => { 105 => 0x8 },
	'quantizationmethod' => { 121 => 0x78 },
	'quickadjust' => { 244 => 0x2a },
	'quickcontroldialinmeter' => { 76 => 0x703 },
	'quickfix' => { 241 => 0x416391c6 },
	'quickshot' => { 355 => 0x213 },
	'rangefinder' => { 253 => '4.1', 254 => '5.1', 255 => '5.1' },
	'rasterizedcaption' => { 119 => 0x7d },
	'rating' => { 111 => 0x4746, 116 => 0x1431, 331 => 0xdf, 376 => 0x2002, 423 => 'rating', 431 => 'rating', 439 => 'Rating', 443 => 'rating', 451 => 'Rating' },
	'ratingpercent' => { 111 => 0x4749, 163 => 'Rating' },
	'ratingratingregion' => { 439 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 439 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 439 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 439 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 439 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 439 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 439 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 439 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 439 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 439 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 439 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 439 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 439 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 439 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 439 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 439 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 439 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 439 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 74 => 0x8, 170 => 0x109, 301 => 0xd },
	'rawbrightnessadj' => { 95 => 0x20001, 100 => 0x38 },
	'rawcoloradj' => { 100 => 0x2e },
	'rawcropbottom' => { 331 => 0xd4 },
	'rawcropleft' => { 331 => 0xd1 },
	'rawcropright' => { 331 => 0xd3 },
	'rawcroptop' => { 331 => 0xd2 },
	'rawcustomsaturation' => { 100 => 0x30 },
	'rawcustomtone' => { 100 => 0x34 },
	'rawdata' => { 353 => 0xa048 },
	'rawdatabyteorder' => { 353 => 0x40 },
	'rawdatacfapattern' => { 353 => 0x50 },
	'rawdatauniqueid' => { 111 => 0xc65d },
	'rawdepth' => { 172 => 0x10 },
	'rawdevartfilter' => { 272 => 0x121 },
	'rawdevautogradation' => { 272 => 0x119 },
	'rawdevcolorspace' => { 271 => 0x108, 272 => 0x109 },
	'rawdevcontrastvalue' => { 271 => 0x106, 272 => 0x105 },
	'rawdeveditstatus' => { 271 => 0x10b },
	'rawdevelopmentprocess' => { 320 => 0x62 },
	'rawdevengine' => { 271 => 0x109, 272 => 0x10b },
	'rawdevexposurebiasvalue' => { 271 => 0x100, 272 => 0x100 },
	'rawdevgradation' => { 272 => 0x112 },
	'rawdevgraypoint' => { 271 => 0x103, 272 => 0x104 },
	'rawdevmemorycoloremphasis' => { 271 => 0x105, 272 => 0x108 },
	'rawdevnoisereduction' => { 271 => 0x10a, 272 => 0x10a },
	'rawdevpicturemode' => { 272 => 0x10c },
	'rawdevpm_bwfilter' => { 272 => 0x110 },
	'rawdevpmcontrast' => { 272 => 0x10e },
	'rawdevpmnoisefilter' => { 272 => 0x120 },
	'rawdevpmpicturetone' => { 272 => 0x111 },
	'rawdevpmsaturation' => { 272 => 0x10d },
	'rawdevpmsharpness' => { 272 => 0x10f },
	'rawdevsaturation3' => { 272 => 0x113 },
	'rawdevsaturationemphasis' => { 271 => 0x104, 272 => 0x107 },
	'rawdevsettings' => { 271 => 0x10c },
	'rawdevsharpnessvalue' => { 271 => 0x107, 272 => 0x106 },
	'rawdevversion' => { 271 => 0x0, 272 => 0x0 },
	'rawdevwbfineadjustment' => { 271 => 0x102, 272 => 0x103 },
	'rawdevwhitebalance' => { 272 => 0x101 },
	'rawdevwhitebalancevalue' => { 271 => 0x101, 272 => 0x102 },
	'rawfile' => { 111 => 0xfe4c },
	'rawfilename' => { 429 => 'RawFileName' },
	'rawfiletype' => { 376 => 0x2029 },
	'rawformat' => { 290 => 0x2d, 329 => 0x10e },
	'rawimagecenter' => { 202 => 0x99 },
	'rawimagedigest' => { 111 => 0xc71c },
	'rawimagesize' => { 320 => 0x39 },
	'rawinfoversion' => { 273 => 0x0 },
	'rawjpgheight' => { 91 => 0x4 },
	'rawjpgquality' => { 52 => 0x6, 91 => 0x1 },
	'rawjpgsize' => { 52 => 0x7, 91 => 0x2 },
	'rawjpgwidth' => { 91 => 0x3 },
	'rawmeasuredrggb' => { 38 => 0x26a, 40 => 0x280, 42 => 0x194, 43 => [0x1ad,0x26b] },
	'rawrppused' => { 423 => 'rawrppused' },
	'rawtopreviewgain' => { 111 => 0xc7a8 },
	'reardisplay' => { 248 => '12.3', 249 => '6.2' },
	'recipeendingpage' => { 445 => 'recipeEndingPage' },
	'recipepagerange' => { 445 => 'recipePageRange' },
	'recipesource' => { 445 => 'recipeSource' },
	'recipestartingpage' => { 445 => 'recipeStartingPage' },
	'recipetitle' => { 445 => 'recipeTitle' },
	'recognizedface1age' => { 281 => 0x20 },
	'recognizedface1name' => { 281 => 0x4 },
	'recognizedface1position' => { 281 => 0x18 },
	'recognizedface2age' => { 281 => 0x50 },
	'recognizedface2name' => { 281 => 0x34 },
	'recognizedface2position' => { 281 => 0x48 },
	'recognizedface3age' => { 281 => 0x80 },
	'recognizedface3name' => { 281 => 0x64 },
	'recognizedface3position' => { 281 => 0x78 },
	'recognizedfaceflags' => { 286 => 0x63 },
	'recommendedexposureindex' => { 111 => 0x8832, 434 => 'RecommendedExposureIndex' },
	'record' => { 110 => 'Record' },
	'recordbasisofrecord' => { 110 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 110 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 110 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 110 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 110 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 110 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 168 => 0x4d },
	'recorddynamicproperties' => { 110 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 89 => 0x1804 },
	'recordinformationwithheld' => { 110 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 346 => 0x1000 },
	'recordingmode' => { 104 => 0x1, 327 => 0x1 },
	'recordinstitutioncode' => { 110 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 110 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 105 => 0x3000 },
	'recordownerinstitutioncode' => { 110 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 355 => 0x217 },
	'redbalance' => { 185 => 0x270, 270 => 0x1017, 290 => 0x11, 320 => 0x1c },
	'redcurvelimits' => { 100 => 0x18a },
	'redcurvepoints' => { 99 => 0x2d, 100 => 0x160 },
	'redeyecorrection' => { 245 => 0x0 },
	'redeyeinfo' => { 429 => 'RedEyeInfo' },
	'redeyereduction' => { 168 => 0x41, 364 => 0x6a, 366 => 0x28 },
	'redhsl' => { 95 => 0x20910 },
	'redhue' => { 429 => 'RedHue' },
	'redsaturation' => { 429 => 'RedSaturation' },
	'reductionmatrix1' => { 111 => 0xc625 },
	'reductionmatrix2' => { 111 => 0xc626 },
	'reelname' => { 111 => 0xc789 },
	'reference1' => { 437 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 437 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 111 => 0x214, 449 => 'ReferenceBlackWhite' },
	'referencedate' => { 119 => 0x2f },
	'referencenumber' => { 119 => 0x32 },
	'references' => { 142 => 'References' },
	'referenceservice' => { 119 => 0x2d },
	'regionappliedtodimensions' => { 157 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 157 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 157 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 157 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 157 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 157 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 157 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 157 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 157 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 157 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 157 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 157 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 275 => 'RegionConstraints' },
	'regiondescription' => { 157 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 157 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 157 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 157 => 'Regions' },
	'regioninfodateregionsvalid' => { 160 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 160 => 'RegionInfo' },
	'regioninforegions' => { 160 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 157 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 157 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 160 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 160 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 160 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 160 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 160 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 157 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 157 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 157 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 439 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 439 => 'RegistryId' },
	'registryitemid' => { 439 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 439 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 140 => 'data' },
	'relatedaudiofilename' => { 140 => '1Name' },
	'relatedaudiofiletype' => { 140 => '0Type' },
	'relatedimagefileformat' => { 111 => 0x1000 },
	'relatedimageheight' => { 111 => 0x1002 },
	'relatedimagewidth' => { 111 => 0x1001 },
	'relatedresourceid' => { 110 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 111 => 0xa004, 433 => 'RelatedSoundFile' },
	'relatedvideofile' => { 154 => 'data' },
	'relatedvideofilename' => { 154 => '1Name' },
	'relatedvideofiletype' => { 154 => '0Type' },
	'relation' => { 430 => 'relation' },
	'relationshipaccordingto' => { 110 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 110 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 110 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 110 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 108 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 453 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 453 => 'relativeTimestamp' },
	'relativetimestampscale' => { 453 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 453 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 248 => '17.8', 249 => '18.5', 251 => '18.4', 252 => '18.4', 257 => '33.8', 258 => '17.6', 261 => '18.5', 262 => '18.4' },
	'releasedate' => { 119 => 0x1e, 423 => 'ReleaseDate', 453 => 'releaseDate' },
	'releasemode' => { 105 => 0x3001, 219 => 0x184d, 376 => 0xb049 },
	'releasemode2' => { 384 => 0x112c, 385 => [0x112c,0x8], 386 => [0x1108,0x8], 387 => [0x1184,0x8], 388 => [0x1160,0x8], 389 => [0x4,0x1018], 390 => [0x4,0x210], 391 => [0x4,0x210], 392 => [0x4,0x208], 394 => [0x67,0x3f], 395 => [0x73,0x4b], 396 => 0x10, 397 => 0x10, 398 => 0x9, 405 => 0x34 },
	'releasemode3' => { 384 => 0x1128, 385 => 0x1128, 386 => 0x1104, 387 => 0x1180, 388 => 0x115c, 389 => 0x1014, 390 => 0x20c, 391 => 0x20c, 392 => 0x204 },
	'releaseready' => { 439 => 'ReleaseReady' },
	'releasesetting' => { 89 => 0x1016 },
	'releasetime' => { 119 => 0x23, 423 => 'ReleaseTime' },
	'remoteonduration' => { 250 => '3.4', 253 => '17.2', 254 => '18.2', 255 => '18.2', 256 => '18.2', 258 => '18.2', 259 => '4.3', 263 => '19.2' },
	'renditionclass' => { 454 => 'RenditionClass' },
	'renditionof' => { 454 => 'RenditionOf' },
	'renditionofalternatepaths' => { 454 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 454 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 454 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 454 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 454 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 454 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 454 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 454 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 454 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 454 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 454 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 454 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 454 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 454 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 454 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 454 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 454 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 454 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 454 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 454 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 454 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 454 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 454 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 454 => 'RenditionParams' },
	'repeatingflashcount' => { 190 => 0xd, 191 => 0xe, 192 => 0xe, 193 => 0xe, 257 => '17.2', 258 => '24.2', 259 => '9.2', 260 => '24.2', 263 => '25.2' },
	'repeatingflashcountbuilt-in' => { 227 => 0x4db },
	'repeatingflashcountexternal' => { 227 => 0x4c3 },
	'repeatingflashoutput' => { 257 => '17.1', 258 => '24.1', 259 => '9.1', 260 => '24.1', 263 => '25.1' },
	'repeatingflashoutputexternal' => { 227 => 0x4c0 },
	'repeatingflashrate' => { 190 => 0xc, 191 => 0xd, 192 => 0xd, 193 => 0xd, 257 => '18.1', 258 => '25.1', 259 => '10.1', 260 => '25.1', 263 => '26.1' },
	'repeatingflashratebuilt-in' => { 227 => 0x4da },
	'repeatingflashrateexternal' => { 227 => 0x4c2 },
	'requires' => { 426 => 'requires' },
	'resampleparams' => { 453 => 'resampleParams' },
	'resampleparamsquality' => { 453 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 355 => 0x21e },
	'resolution' => { 147 => 'Resolution' },
	'resolutionmode' => { 356 => 0x4 },
	'resolutionunit' => { 111 => 0x128, 122 => 0x2, 449 => 'ResolutionUnit' },
	'resourceid' => { 110 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 110 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 110 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 76 => 0x612 },
	'restrictions' => { 446 => 'restrictions' },
	'retouchareafeather' => { 429 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 429 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 429 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 429 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 429 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 429 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 429 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 429 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 429 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 429 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 429 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 429 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 429 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 429 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 429 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 429 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 429 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 429 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 429 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 429 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 429 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 429 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 429 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 429 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 429 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 429 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 429 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 429 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 429 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 429 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 429 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 429 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 429 => 'RetouchAreas' },
	'retouchareaseed' => { 429 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 429 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 429 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 429 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 202 => 0x9e },
	'retouchinfo' => { 429 => 'RetouchInfo' },
	'retouchnefprocessing' => { 208 => 0x5 },
	'retractlensonpoweroff' => { 76 => 0x814 },
	'reuse' => { 275 => 'Reuse' },
	'reuseallowed' => { 456 => 'ReuseAllowed' },
	'reuseprohibited' => { 446 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 255 => '5.2' },
	'reverseindicators' => { 248 => '12.1', 249 => '6.1', 251 => '6.1', 252 => '6.1', 253 => '4.3', 254 => '5.2', 255 => '5.4', 257 => '33.5', 258 => '5.1', 261 => '6.1', 262 => '6.1', 263 => '6.2' },
	'reverseshutterspeedaperture' => { 255 => '5.3' },
	'revision' => { 431 => 'revision' },
	'rgbcurvelimits' => { 100 => 0x238 },
	'rgbcurvepoints' => { 99 => 0x7, 100 => 0x20e },
	'richtextcomment' => { 436 => 'RichTextComment' },
	'ricohdate' => { 345 => 0x6 },
	'ricohimageheight' => { 345 => 0x2 },
	'ricohimagewidth' => { 345 => 0x0 },
	'rightascension' => { 150 => 'RightAscension' },
	'rights' => { 430 => 'rights' },
	'rightsagent' => { 446 => 'rightsAgent' },
	'rightsowner' => { 446 => 'rightsOwner' },
	'roll' => { 107 => 0x8 },
	'rollangle' => { 219 => 0x350b, 220 => 0x2c24, 228 => 0x36f4, 265 => 0x903, 286 => 0x90, 319 => 0x1, 351 => 0x2 },
	'romoperationmode' => { 89 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 88 => 0x3, 95 => 0x10002, 100 => 0x26e, 115 => 0x4, 150 => 'Rotation', 166 => [0x65,0x50], 167 => 0x46, 168 => 0x5a, 171 => 0x10, 219 => 0x3693, 220 => 0xca, 226 => '590.1', 241 => 0x76a43207, 286 => 0x30, 301 => '17.2', 331 => 0xd8, 364 => 0x3f, 365 => 0x3f, 375 => 0x10 },
	'routedto' => { 435 => 'RoutedTo' },
	'routing' => { 336 => 'Routing' },
	'routingdestinations' => { 419 => 'RoutingDestinations' },
	'routingexclusions' => { 419 => 'RoutingExclusions' },
	'routingnotes' => { 435 => 'RoutingNotes' },
	'rowsperstrip' => { 111 => 0x116 },
	'rpp' => { 423 => 'rpp' },
	'safetyshift' => { 76 => 0x108 },
	'safetyshiftinavortv' => { 74 => 0x10, 75 => 0x10, 77 => 0xf, 78 => 0x10, 81 => 0x10 },
	'sameexposurefornewaperture' => { 76 => 0x112 },
	'samplebits' => { 140 => 'SampleBits' },
	'samplepagerange' => { 443 => 'samplePageRange' },
	'samplerate' => { 140 => 'SampleRate' },
	'samplesperpixel' => { 111 => 0x115, 290 => 0x8, 449 => 'SamplesPerPixel' },
	'samplestructure' => { 121 => 0x5a },
	'samsungmodelid' => { 353 => 0x3 },
	'sanyoquality' => { 355 => 0x201 },
	'sanyothumbnail' => { 355 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 46 => 0x1, 104 => 0xd, 105 => [0x3013,0x1f], 111 => [0xa409,0xfe55], 116 => 0x1003, 141 => 'Saturation', 165 => 0x1f, 166 => 0x32, 167 => 0x28, 168 => 0x1a, 173 => 0x1, 202 => [0x94,0xaa], 204 => 0x35, 205 => 0x3b, 286 => 0x40, 288 => 0x300d, 320 => 0x1f, 327 => 0xd, 341 => 0x27, 345 => 0x28, 346 => 0x1013, 356 => 0x10, 364 => 0x1e, 365 => 0x1b, 376 => 0x2005, 429 => 'Saturation', 433 => 'Saturation' },
	'saturationadj' => { 95 => 0x20901, 100 => 0x116, 240 => 0x1, 244 => 0x2e, 409 => 0x8016 },
	'saturationadjustmentaqua' => { 429 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 429 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 429 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 429 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 429 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 429 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 429 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 429 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 65 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 64 => 0x68, 65 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 64 => 0x38, 65 => 0x38 },
	'saturationmonochrome' => { 64 => 0x80, 65 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 64 => 0x50, 65 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 64 => 0x20, 65 => 0x20 },
	'saturationsetting' => { 273 => 0x1010, 366 => 0x11, 381 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 64 => 0x8, 65 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 64 => 0x98, 65 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 64 => 0xb0, 65 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 64 => 0xc8, 65 => 0xe0 },
	'saveid' => { 454 => 'SaveID' },
	'scaletype' => { 453 => 'scaleType' },
	'scanimageenhancer' => { 209 => 0x60 },
	'scanningdirection' => { 121 => 0x64 },
	'scene' => { 438 => 'Scene', 453 => 'scene' },
	'scenearea' => { 268 => 0x211, 270 => 0x1031 },
	'sceneassist' => { 202 => 0x9c },
	'scenecapturetype' => { 111 => 0xa406, 433 => 'SceneCaptureType' },
	'scenedetect' => { 268 => 0x210, 270 => 0x1030 },
	'scenedetectdata' => { 268 => 0x212, 270 => 0x1033 },
	'scenemode' => { 129 => 0xfa02, 170 => 0x100, 202 => 0x8f, 265 => 0x509, 270 => 0x403, 286 => 0x8001, 294 => 0xf, 376 => 0xb023 },
	'scenemodeused' => { 131 => [0x6002,0xf002] },
	'scenerecognition' => { 116 => 0x1425 },
	'sceneselect' => { 355 => 0x21f },
	'scenetype' => { 111 => 0xa301, 433 => 'SceneType' },
	'screentips' => { 248 => '12.7', 249 => '5.3', 257 => '13.1', 258 => '4.4', 261 => '5.4', 263 => '5.1' },
	'season' => { 439 => 'Season', 442 => 'season' },
	'seasonidentifier' => { 439 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 439 => [\'Season','SeasonName'] },
	'seasonnumber' => { 439 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 419 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 219 => 0x1d0, 228 => 0x1d0 },
	'section' => { 443 => 'section' },
	'securityclassification' => { 111 => 0x9212 },
	'selectableafpoint' => { 76 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 76 => 0x512 },
	'selftimer' => { 33 => 0x2, 286 => 0x2e, 355 => 0x214, 384 => 0x1134, 385 => 0x1134, 386 => 0x1110, 387 => 0x118c, 388 => 0x1168, 389 => 0x1020, 390 => 0x218, 391 => 0x218, 392 => 0x210 },
	'selftimer2' => { 70 => 0x1d },
	'selftimerinterval' => { 258 => '19.2' },
	'selftimermode' => { 111 => 0x882b },
	'selftimershotcount' => { 249 => '20.2', 251 => '20.3', 252 => '20.3', 253 => '18.2', 254 => '19.2', 255 => '19.2', 256 => '19.3', 258 => '19.3', 261 => '20.3', 262 => '20.3', 263 => '20.2' },
	'selftimershotinterval' => { 249 => '20.3', 251 => '20.2', 252 => '20.2', 256 => '19.2', 261 => '20.2', 262 => '20.2' },
	'selftimertime' => { 89 => 0x1806, 168 => 0x1f, 248 => '18.1', 249 => '20.1', 250 => '3.3', 251 => '20.1', 252 => '20.1', 253 => '18.1', 254 => '19.1', 255 => '19.1', 256 => '19.1', 257 => '7.2', 258 => '19.1', 259 => '3.3', 261 => '20.1', 262 => '20.1', 263 => '20.1' },
	'sellingagency' => { 443 => 'sellingAgency' },
	'seminfo' => { 111 => 0x8546 },
	'sensingmethod' => { 111 => 0xa217, 433 => 'SensingMethod' },
	'sensitivityadjust' => { 320 => 0x40 },
	'sensitivitysteps' => { 301 => ['14.3','17.4'], 303 => 0x1 },
	'sensitivitytype' => { 111 => 0x8830, 434 => 'SensitivityType' },
	'sensor' => { 175 => 0x665e },
	'sensorareas' => { 353 => 0xa010 },
	'sensorbitdepth' => { 288 => 0x312d },
	'sensorbluelevel' => { 68 => 0x5 },
	'sensorcalibration' => { 269 => 0x805 },
	'sensorcleaning' => { 82 => 0xd },
	'sensorfullheight' => { 124 => 0xf904 },
	'sensorfullwidth' => { 124 => 0xf903 },
	'sensorheight' => { 124 => 0xf901, 129 => 0xfa21, 172 => 0x8, 288 => 0x312c, 329 => 0x109, 346 => 0x1602 },
	'sensorleftmargin' => { 329 => 0x10a },
	'sensorpixelsize' => { 202 => 0x9a },
	'sensorredlevel' => { 68 => 0x4 },
	'sensorserialnumber' => { 125 => 0x9ce },
	'sensorsize' => { 141 => 'SensorSize', 320 => 0x35 },
	'sensortemperature' => { 268 => 0x1500, 270 => 0x1007, 325 => 0xc, 329 => 0x210, 356 => [0x39,0x55] },
	'sensortemperature2' => { 325 => 0xe, 329 => 0x211 },
	'sensortopmargin' => { 329 => 0x10b },
	'sensorwidth' => { 124 => 0xf900, 129 => 0xfa20, 172 => 0xa, 288 => 0x312b, 329 => 0x108, 346 => 0x1601 },
	'sequence' => { 341 => 0x7, 342 => 0x35 },
	'sequencefilenumber' => { 385 => 0x4, 386 => 0x4, 387 => 0x4, 388 => 0x4, 396 => 0xc, 397 => 0xc, 398 => 0x1a },
	'sequenceimagenumber' => { 385 => 0x0, 386 => 0x0, 387 => 0x0, 388 => 0x0, 396 => 0x8, 397 => 0x8, 398 => 0x12, 405 => 0x24 },
	'sequencelength' => { 396 => 0x22, 397 => 0x1e, 398 => [0x16,0x1e] },
	'sequencename' => { 442 => 'sequenceName' },
	'sequencenumber' => { 70 => 0x9, 105 => 0x301c, 116 => 0x1101, 127 => 0x1d, 227 => 0x51c, 286 => 0x2b, 366 => [0x10c,0x30c], 376 => 0xb04a, 442 => 'sequenceNumber' },
	'sequenceshotinterval' => { 355 => 0x224 },
	'sequencetotalnumber' => { 442 => 'sequenceTotalNumber' },
	'sequentialshot' => { 355 => 0x20e },
	'serialnumber' => { 58 => 0xc, 89 => 0x180b, 111 => [0xa431,0xfde9], 124 => 0xfa04, 126 => 0xfa00, 128 => 0xc354, 129 => 0xfa19, 138 => 0x0, 141 => 'SerialNumber', 202 => [0xa0,0x1d], 266 => 0x101, 270 => [0x404,0x101a], 282 => 0x303, 288 => 0x3103, 320 => 0x229, 329 => 0x102, 330 => 0x407, 341 => 0x15, 342 => 0x4b, 346 => 0x5, 356 => 0x2, 376 => 0x2031, 425 => 'SerialNumber', 434 => 'BodySerialNumber' },
	'serialnumberformat' => { 58 => 0x15, 89 => 0x183b },
	'series' => { 439 => 'Series' },
	'seriesdatetime' => { 411 => 'SeriesDateTime' },
	'seriesdescription' => { 411 => 'SeriesDescription' },
	'seriesidentifier' => { 439 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 411 => 'SeriesModality' },
	'seriesname' => { 439 => [\'Series','SeriesName'] },
	'seriesnumber' => { 411 => 'SeriesNumber', 443 => 'seriesNumber' },
	'seriestitle' => { 443 => 'seriesTitle' },
	'serviceidentifier' => { 120 => 0x1e },
	'servingsize' => { 445 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 79 => 0x0, 80 => 0x0 },
	'setbuttonwhenshooting' => { 74 => 0x1, 76 => 0x704, 82 => 0xc },
	'setfunctionwhenshooting' => { 77 => 0x0, 78 => 0x1, 81 => 0x1 },
	'setting' => { 442 => 'setting' },
	'shadingcompensation' => { 265 => 0x50c, 286 => 0x8a },
	'shadingcompensation2' => { 269 => 0x1012 },
	'shadow' => { 356 => 0xe },
	'shadowadj' => { 95 => 0x2030b },
	'shadowcorrection' => { 320 => 0x79 },
	'shadowprotection' => { 240 => 0x0 },
	'shadows' => { 111 => 0xfe52, 422 => 'Shadows', 429 => 'Shadows' },
	'shadows2012' => { 429 => 'Shadows2012' },
	'shadowscale' => { 111 => 0xc633 },
	'shadowtint' => { 429 => 'ShadowTint' },
	'shadowtone' => { 116 => 0x1040 },
	'shakereduction' => { 322 => 0x1, 323 => 0x1 },
	'sharpendetail' => { 429 => 'SharpenDetail' },
	'sharpenedgemasking' => { 429 => 'SharpenEdgeMasking' },
	'sharpening' => { 288 => 0x300b },
	'sharpeningadj' => { 244 => 0x2b },
	'sharpenradius' => { 429 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 68 => 0x2, 104 => 0xb, 105 => [0x3011,0x21], 111 => [0xa40a,0xfe56], 116 => 0x1001, 127 => 0x6b, 136 => 0x37, 141 => 'Sharpness', 165 => 0x21, 166 => 0x30, 167 => 0x26, 168 => 0x18, 173 => 0x3, 202 => 0x6, 204 => 0x32, 205 => 0x33, 270 => 0x100f, 286 => 0x41, 320 => 0x21, 327 => 0xb, 341 => 0x26, 345 => 0x22, 346 => [0x1003,0x1014], 356 => 0x11, 364 => 0x1c, 365 => 0x19, 376 => 0x2006, 405 => 0x52, 429 => 'Sharpness', 433 => 'Sharpness' },
	'sharpnessadj' => { 95 => 0x20310, 100 => 0x25a, 409 => 0x801a },
	'sharpnessadjon' => { 95 => '0x20310.0' },
	'sharpnessauto' => { 65 => 0x94 },
	'sharpnessfactor' => { 270 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 64 => 0x64, 65 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 68 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 64 => 0x34, 65 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 64 => 0x7c, 65 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 64 => 0x4c, 65 => 0x4c },
	'sharpnessovershoot' => { 409 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 64 => 0x1c, 65 => 0x1c },
	'sharpnesssetting' => { 265 => 0x506, 273 => 0x1013, 366 => 0x12, 381 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 64 => 0x4, 65 => 0x4 },
	'sharpnessstrength' => { 95 => 0x20311 },
	'sharpnessthreshold' => { 409 => 0x801d },
	'sharpnessundershoot' => { 409 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 64 => 0x94, 65 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 64 => 0xac, 65 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 64 => 0xc4, 65 => 0xdc },
	'shootid' => { 442 => 'shootID' },
	'shootingdistance' => { 95 => 0x20701 },
	'shootinginfodisplay' => { 248 => '13.2', 249 => '5.1', 257 => '10.2', 258 => '4.1', 261 => '5.1', 263 => '5.3' },
	'shootinginfomonitorofftime' => { 248 => '26.2', 249 => '22.2', 251 => '22.2', 252 => '22.2', 256 => '21.2', 257 => '9.1', 258 => '21.2', 261 => '22.2', 262 => '22.2', 263 => '22.2' },
	'shootingmode' => { 141 => 'ShootingMode', 202 => 0x89, 286 => 0x1f },
	'shootingmodesetting' => { 250 => '5.1' },
	'shortdescription' => { 431 => 'shortdescription' },
	'shortdocumentid' => { 119 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 76 => 0x80d },
	'shotdate' => { 453 => 'shotDate' },
	'shotday' => { 453 => 'shotDay' },
	'shotlocation' => { 453 => 'shotLocation' },
	'shotname' => { 453 => 'shotName' },
	'shotnumber' => { 453 => 'shotNumber' },
	'shotnumbersincepowerup' => { 380 => 0x44e, 396 => 0x1a, 397 => 0x16, 398 => 0xa },
	'shotnumbersincepowerup2' => { 366 => 0x200 },
	'shotsize' => { 453 => 'shotSize' },
	'shownevent' => { 439 => 'EventExt' },
	'showneventidentifier' => { 439 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 439 => [\'EventExt','EventExtName'] },
	'shutter-aelock' => { 74 => 0x4, 76 => 0x701, 77 => 0x3, 78 => 0x4, 79 => 0x3, 80 => 0x3, 81 => 0x4, 82 => 0x2 },
	'shutteraelbutton' => { 75 => 0x4 },
	'shutterbuttonafonbutton' => { 76 => 0x701 },
	'shuttercount' => { 10 => 0x176, 52 => 0x1, 202 => 0xa7, 210 => [0x6a,0x157,0x24d], 211 => 0x286, 212 => 0x279, 213 => 0x284, 214 => 0x242, 215 => 0x280, 216 => 0x276, 217 => [0x27d,0x27f], 218 => 0x246, 221 => 0x2d6, 222 => 0x321, 223 => 0xbd8, 224 => 0x287, 225 => 0x320, 226 => 0x24a, 227 => 0x5fb, 230 => 0x2d5, 320 => 0x5d, 375 => 0x846, 379 => [0x125,0x14a] },
	'shuttercurtainsync' => { 74 => 0xf, 75 => 0xf, 76 => 0x305, 77 => 0xe, 78 => 0xf, 79 => 0x8, 80 => 0x8, 81 => 0xf, 82 => 0x8 },
	'shuttermode' => { 127 => 0x1b },
	'shutterreleasebuttonae-l' => { 248 => '17.7', 249 => '18.4', 251 => '78.4', 252 => '78.4', 253 => '16.1', 254 => '17.1', 255 => '17.1', 256 => '17.1', 257 => '7.1', 258 => '17.5', 261 => '18.4', 262 => '78.4', 263 => '18.2' },
	'shutterreleasemethod' => { 89 => 0x1010 },
	'shutterreleasenocfcard' => { 74 => 0x2, 75 => 0x2, 82 => 0xf },
	'shutterreleasetiming' => { 89 => 0x1011 },
	'shutterreleasewithoutlens' => { 76 => 0x711 },
	'shutterspeedlock' => { 249 => '38.1', 251 => '38.1', 252 => '38.1', 261 => '38.1', 262 => '38.1' },
	'shutterspeedrange' => { 76 => 0x10c },
	'shutterspeedsetting' => { 168 => 0x6, 364 => 0x2f, 365 => 0x28, 366 => 0x0 },
	'shutterspeedvalue' => { 85 => 0x1, 111 => 0x9201, 270 => 0x1000, 329 => 0x400, 433 => 'ShutterSpeedValue' },
	'shuttertype' => { 116 => 0x1050, 286 => 0x9f },
	'sidecarforextension' => { 441 => 'SidecarForExtension' },
	'similarityindex' => { 119 => 0xe4 },
	'singleframebracketing' => { 168 => 0x21 },
	'skilllevel' => { 445 => 'skillLevel' },
	'skintonecorrection' => { 320 => 0x95 },
	'slaveflashmeteringsegments' => { 320 => 0x20b },
	'slideshowname' => { 442 => 'slideshowName' },
	'slideshownumber' => { 442 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 442 => 'slideshowTotalNumber' },
	'slowshutter' => { 70 => 0x8 },
	'slowsync' => { 116 => 0x1030 },
	'smartalbumcolor' => { 353 => 0x20 },
	'smartrange' => { 353 => 0xa012 },
	'smileshutter' => { 366 => 0x31 },
	'smileshuttermode' => { 366 => 0x27 },
	'smoothness' => { 111 => 0xfe57, 429 => 'Smoothness' },
	'snapshot' => { 439 => 'SnapshotLink' },
	'snapshotformat' => { 439 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 439 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 439 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 439 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 439 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 423 => 'Snapshots' },
	'snapshotusedvideoframe' => { 439 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 439 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 439 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 439 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 439 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 376 => 0x200f },
	'software' => { 111 => 0x131, 142 => 'Software', 278 => 'Software', 329 => 0x203, 356 => 0x18, 414 => 'Software', 449 => 'Software' },
	'softwareversion' => { 355 => 0x207 },
	'sonydatetime' => { 383 => 0x6, 385 => 0x1b6, 386 => 0x210, 387 => 0x1fe, 388 => 0x22c },
	'sonydatetime2' => { 394 => 0x51 },
	'sonyexposuretime' => { 394 => 0x3a, 395 => 0x46 },
	'sonyexposuretime2' => { 405 => 0xe },
	'sonyfnumber' => { 394 => 0x3c, 395 => 0x48, 405 => 0x14 },
	'sonyimageheight' => { 383 => 0x1a, 396 => 0x44, 397 => 0x3f, 398 => 0x47 },
	'sonyimageheightmax' => { 405 => 0x40 },
	'sonyimagesize' => { 168 => 0x3b, 364 => 0x54, 365 => 0x54, 366 => 0x9 },
	'sonyimagewidth' => { 383 => 0x1c },
	'sonyimagewidthmax' => { 405 => 0x3e },
	'sonyiso' => { 385 => 0x1218, 386 => 0x11f4, 387 => 0x1270, 388 => [0x1254,0x1258,0x1280], 389 => 0x113c, 390 => 0x344, 391 => 0x346, 392 => 0x320, 405 => 0x4 },
	'sonymaxaperture' => { 394 => 0x0, 395 => 0x0 },
	'sonymaxaperturevalue' => { 405 => 0x16 },
	'sonyminaperture' => { 394 => 0x1, 395 => 0x1 },
	'sonymodelid' => { 376 => 0xb001 },
	'sonyquality' => { 168 => 0x3c },
	'sonytimeminsec' => { 395 => 0x61 },
	'source' => { 119 => 0x73, 278 => 'Source', 430 => 'source', 431 => 'source', 441 => 'Source' },
	'sourcecount' => { 418 => 'SourceCount' },
	'sourcedirectoryindex' => { 307 => 0x0 },
	'sourcefileindex' => { 307 => 0x2 },
	'sourcephotoscount' => { 417 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 433 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 433 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 433 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 433 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 433 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 453 => 'speakerPlacement' },
	'specialeffectlevel' => { 105 => 0x3030 },
	'specialeffectmode' => { 105 => 0x2076 },
	'specialeffectsetting' => { 105 => 0x3031 },
	'specialinstructions' => { 119 => 0x28 },
	'specialmode' => { 270 => 0x200, 355 => 0x200 },
	'specialoccasion' => { 445 => 'specialOccasion' },
	'spectralsensitivity' => { 111 => 0x8824, 433 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 40 => [0x2b9,0x2d0,0x2d4], 42 => 0x1e4, 43 => [0x1fd,0x2dd], 44 => [0x231,0x30f], 45 => 0x31d },
	'speedx' => { 107 => 0x3 },
	'speedy' => { 107 => 0x4 },
	'speedz' => { 107 => 0x5 },
	'spherical' => { 418 => 'Spherical' },
	'splitcolumn' => { 329 => 0x222 },
	'splittoningbalance' => { 429 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 429 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 429 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 429 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 429 => 'SplitToningShadowSaturation' },
	'sport' => { 443 => 'sport' },
	'spotfocuspointx' => { 165 => 0x2d },
	'spotfocuspointy' => { 165 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 76 => 0x107 },
	'sractive' => { 301 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 322 => 0x3 },
	'srhalfpresstime' => { 322 => 0x2 },
	'srresult' => { 322 => 0x0, 323 => 0x0 },
	'stackedimage' => { 265 => 0x804 },
	'standardoutputhighlightpoint' => { 101 => 0x14 },
	'standardoutputsensitivity' => { 111 => 0x8831, 434 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 101 => 0x15 },
	'standardrawcolortone' => { 101 => 0xd },
	'standardrawcontrast' => { 101 => 0xf },
	'standardrawhighlight' => { 101 => 0x75 },
	'standardrawhighlightpoint' => { 101 => 0x12 },
	'standardrawlinear' => { 101 => 0x10 },
	'standardrawsaturation' => { 101 => 0xe },
	'standardrawshadow' => { 101 => 0x7e },
	'standardrawshadowpoint' => { 101 => 0x13 },
	'standardrawsharpness' => { 101 => 0x11 },
	'standardunsharpmaskfineness' => { 101 => 0x94 },
	'standardunsharpmaskstrength' => { 101 => 0x92 },
	'standardunsharpmaskthreshold' => { 101 => 0x96 },
	'standbytimer' => { 249 => '19.1', 251 => '19.1', 252 => '19.1', 255 => '18.1', 256 => '18.1', 261 => '19.1', 262 => '19.1' },
	'startingpage' => { 443 => 'startingPage' },
	'startmovieshooting' => { 76 => 0x70d },
	'starttimecode' => { 453 => 'startTimecode' },
	'starttimecodetimeformat' => { 453 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 453 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 453 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 453 => 'startTimeSampleSize' },
	'starttimescale' => { 453 => 'startTimeScale' },
	'state' => { 146 => 'State', 286 => 0x6b, 441 => 'State' },
	'status' => { 412 => 'Status', 421 => 'Status' },
	'stereomode' => { 418 => 'StereoMode' },
	'stitched' => { 418 => 'Stitched' },
	'stitchingsoftware' => { 417 => 'StitchingSoftware', 418 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 384 => 0x113e, 385 => 0x113e, 386 => 0x111a, 387 => 0x1196, 388 => 0x1172, 389 => 0x102a, 390 => 0x222, 391 => 0x222, 392 => 0x217, 405 => 0xa },
	'storagemethod' => { 172 => 0x12 },
	'storebyorientation' => { 249 => '46.3', 251 => '47.3', 252 => '47.3', 261 => '47.3', 262 => '47.3' },
	'storylineidentifier' => { 439 => 'StorylineIdentifier' },
	'straightenangle' => { 241 => 0x2fc08431 },
	'streamready' => { 439 => 'StreamReady' },
	'streamtype' => { 161 => 'StreamType' },
	'stretchmode' => { 453 => 'stretchMode' },
	'studydatetime' => { 411 => 'StudyDateTime' },
	'studydescription' => { 411 => 'StudyDescription' },
	'studyid' => { 411 => 'StudyID' },
	'studyphysician' => { 411 => 'StudyPhysician' },
	'styleperiod' => { 439 => 'StylePeriod' },
	'sub-location' => { 119 => 0x5c },
	'subfiledata' => { 149 => 'data' },
	'subfiledirectory' => { 149 => '1Directory' },
	'subfilemimetype' => { 149 => '2MIME' },
	'subfilename' => { 149 => '1Name' },
	'subfileresource' => { 149 => 'rsrc' },
	'subfiletype' => { 111 => 0xfe, 149 => '0Type' },
	'subject' => { 274 => 'Subject', 336 => 'Subject', 430 => 'subject', 440 => 'Subject', 454 => 'subject' },
	'subjectarea' => { 111 => 0x9214, 433 => 'SubjectArea' },
	'subjectcode' => { 438 => 'SubjectCode' },
	'subjectdistance' => { 111 => 0x9206, 127 => 0x3e, 433 => 'SubjectDistance' },
	'subjectdistancerange' => { 111 => 0xa40c, 433 => 'SubjectDistanceRange' },
	'subjectlocation' => { 111 => 0xa214, 433 => 'SubjectLocation' },
	'subjectmotion' => { 251 => '78.2', 252 => '78.2', 262 => '78.2' },
	'subjectprogram' => { 165 => 0x22 },
	'subjectreference' => { 119 => 0xc },
	'sublabels4' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 437 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 437 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 106 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 106 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 106 => 'SubSecModifyDate' },
	'subsectime' => { 111 => 0x9290 },
	'subsectimedigitized' => { 111 => 0x9292 },
	'subsectimeoriginal' => { 111 => 0x9291 },
	'subsection1' => { 443 => 'subsection1' },
	'subsection2' => { 443 => 'subsection2' },
	'subsection3' => { 443 => 'subsection3' },
	'subsection4' => { 443 => 'subsection4' },
	'subselector' => { 249 => '49.1', 251 => '71.1', 252 => '71.1', 262 => '71.1' },
	'subselectorassignment' => { 249 => '48.1' },
	'subselectorcenter' => { 251 => '72.1', 252 => '72.1', 262 => '72.1' },
	'subselectorplusdials' => { 249 => '49.2', 251 => '73.1', 252 => '73.1', 262 => '73.1' },
	'subtitle' => { 443 => 'subtitle' },
	'subversionfilename' => { 437 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 437 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 437 => 'SubVersions' },
	'superimposeddisplay' => { 74 => 0xa, 76 => 0x510, 77 => 0x9, 78 => 0xa, 81 => 0xa, 82 => 0xe },
	'supermacro' => { 58 => 0x1a },
	'supplementalcategories' => { 119 => 0x14, 441 => 'SupplementalCategories' },
	'supplementaltype' => { 121 => 0x37 },
	'supplementdisplayid' => { 443 => 'supplementDisplayID' },
	'supplementstartingpage' => { 443 => 'supplementStartingPage' },
	'supplementtitle' => { 443 => 'supplementTitle' },
	'supplychainsource' => { 439 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 439 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 439 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 301 => 0x14 },
	'swatchcoloranta' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 458 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 458 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 458 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 458 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 458 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 286 => 0x93, 366 => 0x33 },
	'sweeppanoramafieldofview' => { 286 => 0x94 },
	'sweeppanoramasize' => { 366 => 0x32 },
	'switchtoregisteredafpoint' => { 75 => 0x12, 76 => 0x50a },
	'syncreleasemode' => { 251 => '77.1', 252 => '77.1', 262 => '77.1' },
	'system' => { 329 => 0x204 },
	'tagged' => { 331 => 0xdd, 332 => 'Tagged', 423 => 'tagged' },
	'tagslist' => { 432 => 'TagsList' },
	'tagstructure' => { 437 => 'TagStructure' },
	'takenumber' => { 453 => 'takeNumber' },
	'tapename' => { 453 => 'tapeName' },
	'targetaperture' => { 70 => 0x4 },
	'targetcompressionratio' => { 87 => 0x1 },
	'targetdistancesetting' => { 89 => 0x1807 },
	'targetexposuretime' => { 70 => 0x5 },
	'targetimagetype' => { 89 => 0x100a },
	'targetprinter' => { 111 => 0x151 },
	'taxon' => { 110 => 'Taxon' },
	'taxonacceptednameusage' => { 110 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 110 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 110 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 110 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 110 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 110 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 110 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 110 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 110 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 110 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 110 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 110 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 110 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 110 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 110 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 110 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 110 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 110 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 110 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 110 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 110 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 110 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 110 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 110 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 110 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 110 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 110 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 110 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 110 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 110 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 110 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 110 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 110 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 443 => 'teaser' },
	'teleconverter' => { 170 => 0x105, 376 => 0x105 },
	'tempo' => { 453 => 'tempo' },
	'temporalcoverage' => { 439 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 439 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 439 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 275 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 275 => 'TermsAndConditionsURL' },
	'testname' => { 112 => 'TestName' },
	'textencoding' => { 201 => 0x4 },
	'textlayername' => { 441 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 441 => 'TextLayers' },
	'textlayertext' => { 441 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 286 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 251 => '1.3', 252 => '1.3', 262 => '1.4' },
	'three-dtrackingwatcharea' => { 251 => '78.1', 252 => '78.1', 262 => '78.1' },
	'thresholding' => { 111 => 0x107 },
	'thumbnailfilename' => { 89 => 0x817 },
	'thumbnailformat' => { 451 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 129 => 0xfa55, 451 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 89 => 0x2008, 106 => 'ThumbnailImage', 114 => 0x3, 152 => 'data', 270 => 0x100, 451 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 152 => '1Name' },
	'thumbnailimagesize' => { 152 => 'ImageSize' },
	'thumbnailimagetype' => { 152 => '0Type' },
	'thumbnailimagevalidarea' => { 58 => 0x13 },
	'thumbnaillength' => { 111 => 0x202 },
	'thumbnailoffset' => { 111 => 0x201 },
	'thumbnails' => { 451 => 'Thumbnails' },
	'thumbnailwidth' => { 129 => 0xfa54, 451 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 443 => 'ticker' },
	'tiffhandling' => { 429 => 'TIFFHandling' },
	'tiffmeteringimage' => { 171 => 0x104c, 375 => 0x1110 },
	'tilelength' => { 111 => 0x143 },
	'tilewidth' => { 111 => 0x142 },
	'time' => { 125 => 0x401, 320 => 0x7 },
	'timecodes' => { 111 => 0xc763 },
	'timecreated' => { 119 => 0x3c, 127 => 0x14, 136 => 0x10, 332 => 'TimeCreated' },
	'timeperiod' => { 443 => 'timePeriod' },
	'timerfunctionbutton' => { 250 => '5.2', 253 => '12.1', 254 => '13.1' },
	'timerlength' => { 76 => 0x80c },
	'timerrecording' => { 286 => 0x96 },
	'timescaleparams' => { 453 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 453 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 453 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 453 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 120 => 0x50 },
	'timeshot' => { 419 => 'TimeShot' },
	'timesignature' => { 453 => 'timeSignature' },
	'timesincepoweron' => { 286 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 264 => 0x8, 278 => 'TimeStamp', 286 => 0xaf, 418 => 'Timestamp', 424 => 'Timestamp', 437 => 'TimeStamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 71 => 0x1, 233 => 0x0, 349 => 0xa },
	'timezonecity' => { 71 => 0x2 },
	'timezonecode' => { 92 => 0x1 },
	'timezoneinfo' => { 92 => 0x2 },
	'timezoneoffset' => { 111 => 0x882a },
	'tint' => { 429 => 'Tint' },
	'title' => { 142 => 'Title', 274 => 'Title', 278 => 'Title', 286 => 0x65, 336 => 'Title', 430 => 'title', 440 => 'Title', 451 => 'Title' },
	'tonecomp' => { 202 => 0x81 },
	'tonecurve' => { 68 => 0x1, 320 => 0x402, 429 => 'ToneCurve' },
	'tonecurveactive' => { 100 => 0x110 },
	'tonecurveadobergb' => { 353 => 0xa043 },
	'tonecurveadobergbdefault' => { 353 => 0xa041 },
	'tonecurveblue' => { 429 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 409 => 0x9003 },
	'tonecurvebluey' => { 409 => 0x9007 },
	'tonecurvebrightness' => { 95 => 0x20410 },
	'tonecurvebrightnessx' => { 409 => 0x9000 },
	'tonecurvebrightnessy' => { 409 => 0x9004 },
	'tonecurvecolorspace' => { 99 => 0x0 },
	'tonecurvecontrast' => { 95 => 0x20411 },
	'tonecurvefilename' => { 125 => 0x1391 },
	'tonecurvegreen' => { 429 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 409 => 0x9002 },
	'tonecurvegreeny' => { 409 => 0x9006 },
	'tonecurveinputrange' => { 99 => 0x3 },
	'tonecurveinterpolation' => { 100 => 0x159 },
	'tonecurvemode' => { 100 => 0x113 },
	'tonecurvename' => { 429 => 'ToneCurveName' },
	'tonecurvename2012' => { 429 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 95 => '0x20400.1' },
	'tonecurveoutputrange' => { 99 => 0x5 },
	'tonecurveproperty' => { 100 => 0x3c },
	'tonecurvepv2012' => { 429 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 429 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 429 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 429 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 429 => 'ToneCurveRed' },
	'tonecurveredx' => { 409 => 0x9001 },
	'tonecurveredy' => { 409 => 0x9005 },
	'tonecurves' => { 320 => 0x403 },
	'tonecurveshape' => { 99 => 0x1 },
	'tonecurvesrgb' => { 353 => 0xa042 },
	'tonecurvesrgbdefault' => { 353 => 0xa040 },
	'tonecurvex' => { 99 => 0xa },
	'tonecurvey' => { 99 => 0xb },
	'tonelevel' => { 265 => 0x52e },
	'tonemapstrength' => { 429 => 'ToneMapStrength' },
	'toningeffect' => { 52 => 0xf, 202 => 0xb3, 204 => 0x38, 205 => 0x40, 346 => 0x1015 },
	'toningeffectauto' => { 65 => 0xa4 },
	'toningeffectfaithful' => { 64 => 0x74, 65 => 0x74 },
	'toningeffectlandscape' => { 64 => 0x44, 65 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 64 => 0x8c, 65 => 0x8c },
	'toningeffectneutral' => { 64 => 0x5c, 65 => 0x5c },
	'toningeffectportrait' => { 64 => 0x2c, 65 => 0x2c },
	'toningeffectstandard' => { 64 => 0x14, 65 => 0x14 },
	'toningeffectuserdef1' => { 64 => 0xa4, 65 => 0xbc },
	'toningeffectuserdef2' => { 64 => 0xbc, 65 => 0xd4 },
	'toningeffectuserdef3' => { 64 => 0xd4, 65 => 0xec },
	'toningsaturation' => { 204 => 0x39, 205 => 0x41 },
	'totalzoom' => { 127 => 0x62 },
	'touchae' => { 286 => 0xab },
	'trackcreatedate' => { 340 => 0x1 },
	'trackmodifydate' => { 340 => 0x2 },
	'tracknumber' => { 453 => 'trackNumber' },
	'tracks' => { 453 => 'Tracks' },
	'tracksframerate' => { 453 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 453 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 453 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 453 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 453 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 453 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 453 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 453 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 453 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 453 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 453 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 453 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 453 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 453 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 453 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 453 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 453 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 149 => 'zmie' },
	'transcript' => { 439 => 'Transcript' },
	'transcriptlink' => { 439 => 'TranscriptLink' },
	'transcriptlinklink' => { 439 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 439 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 111 => 0x12d, 449 => 'TransferFunction' },
	'transform' => { 286 => [0x8012,0x59] },
	'transmissionreference' => { 441 => 'TransmissionReference' },
	'trapped' => { 274 => 'Trapped', 440 => 'Trapped' },
	'trashbuttonfunction' => { 76 => 0x710 },
	'travelday' => { 286 => 0x36 },
	'triggermode' => { 341 => 0x6, 342 => 0x34 },
	'tstop' => { 111 => 0xc772 },
	'ttl_da_adown' => { 308 => 0x5 },
	'ttl_da_aup' => { 308 => 0x4 },
	'ttl_da_bdown' => { 308 => 0x7 },
	'ttl_da_bup' => { 308 => 0x6 },
	'tungstenawb' => { 298 => 0x1 },
	'tvexposuretimesetting' => { 301 => 0x12 },
	'type' => { 430 => 'type', 448 => 'type' },
	'typestatus' => { 110 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 111 => 0xc614 },
	'uniquedocumentid' => { 119 => 0xbb },
	'uniqueobjectname' => { 120 => 0x64 },
	'units' => { 414 => 'Units' },
	'unknownblock' => { 320 => 0x405 },
	'unknownblock1' => { 269 => 0x635 },
	'unknownblock2' => { 269 => 0x636 },
	'unknownblock3' => { 269 => 0x1103 },
	'unknownblock4' => { 269 => 0x1104 },
	'unknowncontrast' => { 101 => 0x45 },
	'unknowndate' => { 329 => 0x212 },
	'unknownev' => { 125 => 0x1 },
	'unknownlinear' => { 101 => 0x46 },
	'unknownnumber' => { 89 => 0x180b },
	'unknownoutputhighlightpoint' => { 101 => 0x4a },
	'unknownoutputshadowpoint' => { 101 => 0x4b },
	'unknownrawhighlight' => { 101 => 0x7b },
	'unknownrawhighlightpoint' => { 101 => 0x48 },
	'unknownrawshadow' => { 101 => 0x84 },
	'unknownrawshadowpoint' => { 101 => 0x49 },
	'unknownsharpness' => { 101 => 0x47 },
	'unknowntemperature' => { 113 => 0x4 },
	'unsharp1color' => { 246 => 0x13 },
	'unsharp1halowidth' => { 246 => 0x19 },
	'unsharp1intensity' => { 246 => 0x17 },
	'unsharp1threshold' => { 246 => 0x1b },
	'unsharp2color' => { 246 => 0x2e },
	'unsharp2halowidth' => { 246 => 0x34 },
	'unsharp2intensity' => { 246 => 0x32 },
	'unsharp2threshold' => { 246 => 0x36 },
	'unsharp3color' => { 246 => 0x49 },
	'unsharp3halowidth' => { 246 => 0x4f },
	'unsharp3intensity' => { 246 => 0x4d },
	'unsharp3threshold' => { 246 => 0x51 },
	'unsharp4color' => { 246 => 0x64 },
	'unsharp4halowidth' => { 246 => 0x6a },
	'unsharp4intensity' => { 246 => 0x68 },
	'unsharp4threshold' => { 246 => 0x6c },
	'unsharpcount' => { 246 => 0x0 },
	'unsharpmask' => { 101 => 0x90, 241 => 0x76a43200 },
	'unsharpmaskfineness' => { 95 => 0x20309 },
	'unsharpmaskstrength' => { 95 => 0x20308 },
	'unsharpmaskthreshold' => { 95 => 0x2030a },
	'uprightcentermode' => { 429 => 'UprightCenterMode' },
	'uprightcenternormx' => { 429 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 429 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 429 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 429 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 429 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 429 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 429 => 'UprightPreview' },
	'uprighttransform_0' => { 429 => 'UprightTransform_0' },
	'uprighttransform_1' => { 429 => 'UprightTransform_1' },
	'uprighttransform_2' => { 429 => 'UprightTransform_2' },
	'uprighttransform_3' => { 429 => 'UprightTransform_3' },
	'uprighttransform_4' => { 429 => 'UprightTransform_4' },
	'uprighttransform_5' => { 429 => 'UprightTransform_5' },
	'uprighttransformcount' => { 429 => 'UprightTransformCount' },
	'uprightversion' => { 429 => 'UprightVersion' },
	'urgency' => { 119 => 0xa, 441 => 'Urgency' },
	'url' => { 142 => 'URL', 278 => 'URL', 334 => 0x40b, 443 => 'url' },
	'url_list' => { 334 => 0x41e },
	'urla-platform' => { 443 => [\'url','urlA-platform'] },
	'urlurl' => { 443 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 76 => 0x10a },
	'usableshootingmodes' => { 76 => 0x109 },
	'usage' => { 444 => 'usage' },
	'usageterms' => { 457 => 'UsageTerms' },
	'useguidelines' => { 426 => 'useGuidelines' },
	'usepanoramaviewer' => { 417 => 'UsePanoramaViewer' },
	'usercomment' => { 89 => 0x805, 111 => 0x9286, 433 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 64 => 0xd8, 65 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 64 => 0xda, 65 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 64 => 0xdc, 65 => 0xf4 },
	'userfields' => { 421 => 'UserFields' },
	'userlabel' => { 341 => 0x2b, 342 => 0x5a },
	'userprofile' => { 282 => 0x302, 288 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 75 => 0x7, 76 => 0x501 },
	'uspsnumber' => { 443 => 'uspsNumber' },
	'utmeasting' => { 153 => 'Easting' },
	'utmmapdatum' => { 153 => 'Datum' },
	'utmnorthing' => { 153 => 'Northing' },
	'utmzone' => { 153 => 'Zone' },
	'uv-irfiltercorrection' => { 282 => 0x325 },
	'validbits' => { 269 => 0x611, 270 => 0x102c },
	'validpixeldepth' => { 273 => 0x611 },
	'variablelowpassfilter' => { 376 => 0x2028 },
	'variousmodes' => { 127 => 0x26 },
	'variousmodes2' => { 127 => 0x3a },
	'variprogram' => { 202 => 0xab },
	'version' => { 116 => 0x0, 336 => 'Version', 429 => 'Version' },
	'versioncreatedate' => { 409 => 0xd100 },
	'versionid' => { 454 => 'VersionID' },
	'versionidentifier' => { 443 => 'versionIdentifier' },
	'versionmodifydate' => { 409 => 0xd101 },
	'versions' => { 454 => 'Versions' },
	'versionscomments' => { 454 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 454 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 454 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 454 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 454 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 454 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 454 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 454 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 454 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 454 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 454 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 248 => '3.2', 249 => '47.2', 251 => '79.1' },
	'verticalfuncbutton' => { 249 => '42.2', 251 => '67.1' },
	'verticalfuncbuttonplusdials' => { 249 => '43.1' },
	'verticalfuncplusdials' => { 251 => '68.1' },
	'verticalmultiselector' => { 249 => '42.1', 251 => '66.1', 252 => '66.1', 262 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 76 => [0x510,0x51d] },
	'vibrance' => { 422 => 'Vibrance', 429 => 'Vibrance' },
	'vibrationreduction' => { 210 => [0x75,0x82,0x1ae], 218 => '586.1', 226 => '590.2', 232 => 0x4 },
	'videoalphamode' => { 453 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 453 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 453 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 453 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 439 => 'videoBitRate' },
	'videobitratemode' => { 439 => 'videoBitRateMode' },
	'videocodec' => { 61 => 0x74 },
	'videocolorspace' => { 453 => 'videoColorSpace' },
	'videocompressor' => { 453 => 'videoCompressor' },
	'videodisplayaspectratio' => { 439 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 439 => 'videoEncodingProfile' },
	'videofieldorder' => { 453 => 'videoFieldOrder' },
	'videoframerate' => { 453 => 'videoFrameRate' },
	'videoframesize' => { 453 => 'videoFrameSize' },
	'videoframesizeh' => { 453 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 453 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 453 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 453 => 'videoModDate' },
	'videopixelaspectratio' => { 453 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 453 => 'videoPixelDepth' },
	'videoquality' => { 105 => 0x4003 },
	'videoshottype' => { 439 => 'VideoShotType' },
	'videoshottypeidentifier' => { 439 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 439 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 439 => 'videoStreamsCount' },
	'viewfinder' => { 329 => 0x455 },
	'viewfinderdisplay' => { 248 => '12.4', 249 => '6.3' },
	'viewfinderwarning' => { 248 => '13.4', 258 => '3.5', 259 => '6.2', 263 => '4.4' },
	'viewfinderwarnings' => { 76 => 0x40a },
	'viewinfoduringexposure' => { 76 => 0x407 },
	'viewingmode' => { 366 => 0x2f, 381 => 0x18 },
	'viewingmode2' => { 366 => [0x85,0x285] },
	'viewpoint' => { 442 => 'viewpoint' },
	'vignetteamount' => { 429 => 'VignetteAmount' },
	'vignettecontrol' => { 202 => 0x2a, 241 => 0x76a43205 },
	'vignettecontrolintensity' => { 241 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 425 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 429 => 'VignetteMidpoint' },
	'vignetting' => { 346 => 0x1011, 353 => 0xa052 },
	'vignettingcorrection' => { 353 => 0xa053, 376 => 0x2011 },
	'vignettingcorrparams' => { 111 => 0x7032, 404 => 0x64a, 405 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 353 => 0xa054 },
	'visualcolor' => { 439 => 'VisualColour' },
	'visualtechnique' => { 442 => 'visualTechnique' },
	'voicememo' => { 355 => 0x216 },
	'volume' => { 443 => 'volume' },
	'vr_0x66' => { 210 => 0x66 },
	'vrdoffset' => { 58 => 0xd0 },
	'vrmode' => { 232 => 0x6 },
	'waterdepth' => { 111 => 0x9403 },
	'wb_bluelevel3500k' => { 171 => 0x19a },
	'wb_bluelevel6500k' => { 171 => 0x18a },
	'wb_bluelevelcustom' => { 171 => 0x18e },
	'wb_bluelevelscloudy' => { 171 => 0x106 },
	'wb_bluelevelsdaylight' => { 171 => 0xea },
	'wb_bluelevelsflash' => { 171 => 0x122 },
	'wb_bluelevelsfluorescent' => { 171 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 171 => 0x254 },
	'wb_bluelevelsshade' => { 171 => 0x176 },
	'wb_bluelevelstungsten' => { 171 => 0xce },
	'wb_gbrglevels' => { 171 => 0xae, 174 => 0x4 },
	'wb_glevel' => { 269 => 0x11f },
	'wb_glevel3000k' => { 269 => 0x113 },
	'wb_glevel3300k' => { 269 => 0x114 },
	'wb_glevel3600k' => { 269 => 0x115 },
	'wb_glevel3900k' => { 269 => 0x116 },
	'wb_glevel4000k' => { 269 => 0x117 },
	'wb_glevel4300k' => { 269 => 0x118 },
	'wb_glevel4500k' => { 269 => 0x119 },
	'wb_glevel4800k' => { 269 => 0x11a },
	'wb_glevel5300k' => { 269 => 0x11b },
	'wb_glevel6000k' => { 269 => 0x11c },
	'wb_glevel6600k' => { 269 => 0x11d },
	'wb_glevel7500k' => { 269 => 0x11e },
	'wb_grbglevels' => { 184 => 0x0 },
	'wb_rbgglevels' => { 181 => 0x0 },
	'wb_rblevels' => { 202 => 0xc, 269 => 0x100 },
	'wb_rblevels1' => { 291 => 0x2 },
	'wb_rblevels2' => { 291 => 0x5 },
	'wb_rblevels3' => { 291 => 0x8 },
	'wb_rblevels3000k' => { 269 => 0x102 },
	'wb_rblevels3300k' => { 269 => 0x103 },
	'wb_rblevels3500k' => { 171 => 0x430 },
	'wb_rblevels3600k' => { 269 => 0x104 },
	'wb_rblevels3900k' => { 269 => 0x105 },
	'wb_rblevels4' => { 291 => 0xb },
	'wb_rblevels4000k' => { 269 => 0x106 },
	'wb_rblevels4300k' => { 269 => 0x107 },
	'wb_rblevels4500k' => { 269 => 0x108 },
	'wb_rblevels4800k' => { 269 => 0x109 },
	'wb_rblevels5' => { 291 => 0xe },
	'wb_rblevels5300k' => { 269 => 0x10a },
	'wb_rblevels6' => { 291 => 0x11 },
	'wb_rblevels6000k' => { 269 => 0x10b },
	'wb_rblevels6500k' => { 171 => 0x420 },
	'wb_rblevels6600k' => { 269 => 0x10c },
	'wb_rblevels7' => { 291 => 0x14 },
	'wb_rblevels7500k' => { 269 => 0x10d },
	'wb_rblevelsauto' => { 273 => 0x110 },
	'wb_rblevelscloudy' => { 171 => 0x3f0, 173 => 0x10, 273 => 0x121 },
	'wb_rblevelscoolwhitef' => { 171 => 0x308, 173 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 273 => 0x132 },
	'wb_rblevelscustom' => { 171 => 0x424 },
	'wb_rblevelscwb1' => { 269 => 0x10e },
	'wb_rblevelscwb2' => { 269 => 0x10f },
	'wb_rblevelscwb3' => { 269 => 0x110 },
	'wb_rblevelscwb4' => { 269 => 0x111 },
	'wb_rblevelsdaylight' => { 171 => [0x3ec,0x528], 173 => 0xc },
	'wb_rblevelsdaylightf' => { 173 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 273 => 0x130 },
	'wb_rblevelsdaywhitef' => { 173 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 273 => 0x131 },
	'wb_rblevelseveningsunlight' => { 273 => 0x124 },
	'wb_rblevelsfineweather' => { 273 => 0x122 },
	'wb_rblevelsflash' => { 171 => [0x3f4,0x304], 173 => 0x18 },
	'wb_rblevelsshade' => { 171 => 0x418, 173 => 0x20, 273 => 0x120 },
	'wb_rblevelstungsten' => { 171 => 0x3e8, 173 => 0x8, 273 => 0x123 },
	'wb_rblevelsunknown' => { 173 => 0x1c },
	'wb_rblevelsused' => { 273 => 0x100 },
	'wb_rblevelswhitef' => { 173 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 273 => 0x133 },
	'wb_redlevel3500k' => { 171 => 0x198 },
	'wb_redlevel6500k' => { 171 => 0x188 },
	'wb_redlevelcustom' => { 171 => 0x18c },
	'wb_redlevelscloudy' => { 171 => 0xf8 },
	'wb_redlevelsdaylight' => { 171 => 0xdc },
	'wb_redlevelsflash' => { 171 => 0x114 },
	'wb_redlevelsfluorescent' => { 171 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 171 => 0x1be },
	'wb_redlevelsshade' => { 171 => 0x168 },
	'wb_redlevelstungsten' => { 171 => 0xc0 },
	'wb_rgbglevels' => { 183 => 0x0 },
	'wb_rgblevels' => { 171 => [0x546,0x96], 283 => 0xd, 284 => 0x413, 288 => 0x3036, 329 => 0x107, 384 => 0x117c, 385 => 0x1180, 386 => 0x115c, 387 => 0x11d8, 388 => 0x11b4, 389 => 0x106c, 390 => 0x264, 391 => 0x264, 392 => 0x252 },
	'wb_rgblevels1' => { 292 => 0x2 },
	'wb_rgblevels2' => { 292 => 0x6 },
	'wb_rgblevels3' => { 292 => 0xa },
	'wb_rgblevels4' => { 292 => 0xe },
	'wb_rgblevels5' => { 292 => 0x12 },
	'wb_rgblevels6' => { 292 => 0x16 },
	'wb_rgblevels7' => { 292 => 0x1a },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 174 => 0x4, 182 => 0x0 },
	'wb_rggblevelsasshot' => { 36 => 0x0, 37 => 0x19, 38 => 0x22, 39 => 0x3f, 42 => 0x3f, 43 => 0x3f, 44 => 0x3f, 45 => 0x47 },
	'wb_rggblevelsauto' => { 34 => 0x1, 36 => 0x5, 37 => 0x1e, 38 => 0x18, 39 => 0x44, 42 => 0x44, 43 => 0x44, 44 => 0x44, 45 => 0x4c, 353 => 0xa022 },
	'wb_rggblevelsblack' => { 353 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 36 => 0x1e, 37 => 0x2d, 38 => 0x31, 39 => 0x58, 42 => 0x71, 43 => 0x8a, 44 => 0x8f, 45 => 0x92, 320 => 0x20f, 328 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 39 => 0x80 },
	'wb_rggblevelscustom1' => { 37 => 0x41 },
	'wb_rggblevelscustom2' => { 37 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 36 => 0x14, 37 => 0x23, 38 => 0x27, 39 => 0x4e, 42 => 0x67, 43 => 0x80, 44 => 0x85, 45 => 0x88, 320 => 0x20d, 328 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 36 => 0x32, 37 => 0x3c, 38 => 0x45, 39 => 0x6c, 42 => 0x85, 43 => 0x9e, 44 => 0xa3, 45 => 0xa6, 320 => 0x214, 328 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 36 => 0x28, 37 => 0x37, 38 => 0x3b, 39 => 0x62, 42 => 0x7b, 43 => 0x94, 44 => 0x99, 45 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 320 => 0x211, 328 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 328 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 320 => 0x212, 328 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 320 => 0x213, 328 => 0x38 },
	'wb_rggblevelsilluminator1' => { 353 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 353 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 36 => 0x2d, 38 => 0x40, 39 => 0x67, 42 => 0x80, 43 => 0x99, 44 => 0x9e, 45 => 0xa1 },
	'wb_rggblevelsmeasured' => { 36 => 0xa, 39 => 0x49, 42 => 0x49, 43 => 0x49, 44 => 0x49, 45 => 0x51 },
	'wb_rggblevelspc1' => { 38 => 0x90, 39 => 0x71 },
	'wb_rggblevelspc2' => { 38 => 0x95, 39 => 0x76 },
	'wb_rggblevelspc3' => { 38 => 0x9a, 39 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 36 => 0x19, 37 => 0x28, 38 => 0x2c, 39 => 0x53, 42 => 0x6c, 43 => 0x85, 44 => 0x8a, 45 => 0x8d, 320 => 0x20e, 328 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 36 => 0x23, 37 => 0x32, 38 => 0x36, 39 => 0x5d, 42 => 0x76, 43 => 0x8f, 44 => 0x94, 45 => 0x97, 320 => 0x210, 328 => 0x1d },
	'wb_rggblevelsuncorrected' => { 353 => 0xa021 },
	'wb_rggblevelsunknown' => { 36 => 0xf, 38 => 0x1d, 42 => 0x4e, 43 => 0x4e, 44 => 0x4e, 45 => 0x56, 328 => 0x53 },
	'wb_rggblevelsunknown10' => { 36 => 0x5f, 38 => 0x72, 42 => 0x9e, 43 => 0x7b, 44 => 0x7b, 45 => 0x83 },
	'wb_rggblevelsunknown11' => { 36 => 0x64, 38 => 0x77, 42 => 0xa3, 43 => 0xa3, 44 => 0x80, 45 => 0xab },
	'wb_rggblevelsunknown12' => { 36 => 0x69, 38 => 0x7c, 42 => 0xa8, 43 => 0xa8, 44 => 0xa8, 45 => 0xb0 },
	'wb_rggblevelsunknown13' => { 36 => 0x6e, 38 => 0x81, 42 => 0xad, 43 => 0xad, 44 => 0xad, 45 => 0xb5 },
	'wb_rggblevelsunknown14' => { 38 => 0x86, 42 => 0xb2, 43 => 0xb2, 44 => 0xb2, 45 => 0xba },
	'wb_rggblevelsunknown15' => { 38 => 0x8b, 42 => 0xb7, 43 => 0xb7, 44 => 0xb7, 45 => 0xbf },
	'wb_rggblevelsunknown16' => { 38 => 0x9f, 43 => 0xbc, 44 => 0xbc, 45 => 0xc4 },
	'wb_rggblevelsunknown17' => { 43 => 0xc1, 44 => 0xc1, 45 => 0xc9 },
	'wb_rggblevelsunknown18' => { 43 => 0xc6, 44 => 0xc6, 45 => 0xce },
	'wb_rggblevelsunknown19' => { 43 => 0xcb, 44 => 0xcb, 45 => 0xd3 },
	'wb_rggblevelsunknown2' => { 36 => 0x37, 38 => 0x4a, 42 => 0x53, 43 => 0x53, 44 => 0x53, 45 => 0x5b },
	'wb_rggblevelsunknown20' => { 43 => 0xd0, 44 => 0xd0, 45 => 0xd8 },
	'wb_rggblevelsunknown21' => { 44 => 0xd5, 45 => 0xdd },
	'wb_rggblevelsunknown22' => { 44 => 0xda, 45 => 0xe2 },
	'wb_rggblevelsunknown23' => { 44 => 0xdf, 45 => 0xe7 },
	'wb_rggblevelsunknown24' => { 44 => 0xe4, 45 => 0xec },
	'wb_rggblevelsunknown25' => { 44 => 0xe9, 45 => 0xf1 },
	'wb_rggblevelsunknown26' => { 44 => 0xee, 45 => 0xf6 },
	'wb_rggblevelsunknown27' => { 44 => 0xf3, 45 => 0xfb },
	'wb_rggblevelsunknown28' => { 44 => 0xf8, 45 => 0x100 },
	'wb_rggblevelsunknown29' => { 44 => 0xfd, 45 => 0x105 },
	'wb_rggblevelsunknown3' => { 36 => 0x3c, 38 => 0x4f, 42 => 0x58, 43 => 0x58, 44 => 0x58, 45 => 0x60 },
	'wb_rggblevelsunknown30' => { 44 => 0x102 },
	'wb_rggblevelsunknown4' => { 36 => 0x41, 38 => 0x54, 42 => 0x5d, 43 => 0x5d, 44 => 0x5d, 45 => 0x65 },
	'wb_rggblevelsunknown5' => { 36 => 0x46, 38 => 0x59, 42 => 0x62, 43 => 0x62, 44 => 0x62, 45 => 0x6a },
	'wb_rggblevelsunknown6' => { 36 => 0x4b, 38 => 0x5e, 42 => 0x8a, 43 => 0x67, 44 => 0x67, 45 => 0x6f },
	'wb_rggblevelsunknown7' => { 36 => 0x50, 38 => 0x63, 42 => 0x8f, 43 => 0x6c, 44 => 0x6c, 45 => 0x74 },
	'wb_rggblevelsunknown8' => { 36 => 0x55, 38 => 0x68, 42 => 0x94, 43 => 0x71, 44 => 0x71, 45 => 0x79 },
	'wb_rggblevelsunknown9' => { 36 => 0x5a, 38 => 0x6d, 42 => 0x99, 43 => 0x76, 44 => 0x76, 45 => 0x7e },
	'wb_rggblevelsuserselected' => { 328 => 0x5c },
	'wbadjblueamber' => { 95 => 0x20106 },
	'wbadjbluebalance' => { 247 => 0x8 },
	'wbadjcolortemp' => { 95 => 0x20102, 100 => 0x1a },
	'wbadjlighting' => { 247 => 0x14 },
	'wbadjmagentagreen' => { 95 => 0x20105 },
	'wbadjmode' => { 247 => 0x10 },
	'wbadjredbalance' => { 247 => 0x0 },
	'wbadjrggblevels' => { 95 => 0x20125, 100 => 0x6 },
	'wbadjtemperature' => { 247 => 0x18 },
	'wbadjtint' => { 247 => 0x25 },
	'wbbluelevel' => { 282 => 0x324, 286 => 0x8006, 290 => 0x26 },
	'wbbracketingsteps' => { 219 => 0x174d, 220 => 0x87c, 228 => 0x1757 },
	'wbbracketmode' => { 52 => 0x9 },
	'wbbracketshotnumber' => { 171 => 0x2b, 346 => 0x101a },
	'wbbracketvalueab' => { 52 => 0xc },
	'wbbracketvaluegm' => { 52 => 0xd },
	'wbfinetuneactive' => { 100 => 0x24 },
	'wbfinetunesaturation' => { 100 => 0x28 },
	'wbfinetunetone' => { 100 => 0x2c },
	'wbgreenlevel' => { 282 => 0x323, 286 => 0x8005, 290 => 0x25 },
	'wbmediaimagesizesetting' => { 76 => 0x708 },
	'wbmode' => { 173 => 0x4, 270 => 0x1015 },
	'wbredlevel' => { 282 => 0x322, 286 => 0x8004, 290 => 0x24 },
	'wbscale' => { 174 => 0x0 },
	'wbshiftab' => { 68 => 0xc, 286 => 0x46, 302 => 0x10 },
	'wbshiftab_gm' => { 376 => 0x2014 },
	'wbshiftab_gm_precise' => { 376 => 0x2026 },
	'wbshiftgm' => { 68 => 0xd, 286 => 0x47, 302 => 0x11 },
	'wbtype1' => { 291 => 0x1, 292 => 0x1 },
	'wbtype2' => { 291 => 0x4, 292 => 0x5 },
	'wbtype3' => { 291 => 0x7, 292 => 0x9 },
	'wbtype4' => { 291 => 0xa, 292 => 0xd },
	'wbtype5' => { 291 => 0xd, 292 => 0x11 },
	'wbtype6' => { 291 => 0x10, 292 => 0x15 },
	'wbtype7' => { 291 => 0x13, 292 => 0x19 },
	'webstatement' => { 457 => 'WebStatement' },
	'what' => { 429 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 68 => 0x8, 70 => 0x7, 104 => 0x7, 105 => [0x19,0x2012], 111 => [0xa403,0xfe4e], 116 => 0x1002, 125 => 0x3fc, 126 => 0xfa0d, 127 => 0x40, 165 => 0x3, 166 => 0xe, 167 => 0x4, 168 => 0xb, 170 => 0x115, 202 => 0x5, 231 => 0x7, 282 => 0x304, 286 => 0x3, 288 => 0x3033, 320 => 0x19, 327 => 0x7, 345 => 0x26, 346 => 0x1003, 356 => [0x3c,0x7,0x58], 364 => 0xf, 365 => 0xe, 376 => [0x115,0xb054], 429 => 'WhiteBalance', 433 => 'WhiteBalance' },
	'whitebalance0' => { 161 => 'WhiteBalance0' },
	'whitebalance1' => { 161 => 'WhiteBalance1' },
	'whitebalance2' => { 161 => 'WhiteBalance2', 265 => 0x500 },
	'whitebalanceadj' => { 95 => 0x20101, 100 => 0x18, 241 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 298 => 0x0 },
	'whitebalancebias' => { 105 => 0x2011, 270 => 0x304, 286 => 0x23 },
	'whitebalanceblue' => { 68 => 0x7 },
	'whitebalancebracket' => { 265 => 0x502, 270 => 0x303 },
	'whitebalancebracketing' => { 168 => 0x22, 171 => 0x2c, 375 => 0x2c },
	'whitebalancecomp' => { 273 => 0x1001 },
	'whitebalancefinetune' => { 116 => 0x100a, 168 => 0x38, 170 => 0x112, 202 => 0xb, 346 => 0x1004, 364 => 0x6, 365 => 0x5, 376 => 0x112 },
	'whitebalancemode' => { 320 => 0x1a },
	'whitebalancered' => { 68 => 0x6 },
	'whitebalanceset' => { 301 => 0xa },
	'whitebalancesetting' => { 168 => 0x23, 364 => 0x5, 365 => 0x4, 366 => 0x16, 381 => 0xd },
	'whitebalancesetup' => { 353 => 0x41 },
	'whitebalancetemperature' => { 265 => 0x501 },
	'whiteboard' => { 270 => 0x301 },
	'whitelevel' => { 111 => 0xc61d, 320 => 0x7e },
	'whitepoint' => { 111 => 0x13e, 320 => 0x201, 449 => 'WhitePoint' },
	'whites2012' => { 429 => 'Whites2012' },
	'wideadapter' => { 346 => 0x1017 },
	'widefocuszone' => { 165 => 0x2f },
	'widerange' => { 355 => 0x20f },
	'windowsatom' => { 428 => 'windowsAtom' },
	'windowsatomextension' => { 428 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 428 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 428 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 443 => 'wordCount' },
	'workcolorspace' => { 95 => 0x10200, 100 => 0x270 },
	'workflowtag' => { 439 => 'WorkflowTag' },
	'workflowtagcvid' => { 439 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 439 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 439 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 439 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 435 => 'WorkToDo' },
	'worldtimelocation' => { 286 => 0x3a, 320 => 0x22, 326 => '0.1' },
	'writer-editor' => { 119 => 0x7a },
	'x3filllight' => { 356 => 0x12 },
	'xattrquarantine' => { 159 => 'com.apple.quarantine' },
	'xml' => { 123 => 'xml ' },
	'xmp' => { 98 => 0xffff00f6, 112 => 'XMP' },
	'xmptoolkit' => { 450 => 'xmptk' },
	'xpauthor' => { 111 => 0x9c9d },
	'xpcomment' => { 111 => 0x9c9c },
	'xpkeywords' => { 111 => 0x9c9e },
	'xposition' => { 111 => 0x11e },
	'xpsubject' => { 111 => 0x9c9f },
	'xptitle' => { 111 => 0x9c9b },
	'xresolution' => { 111 => 0x11a, 122 => 0x3, 335 => 0x0, 449 => 'XResolution' },
	'xyresolution' => { 115 => 0x3 },
	'yaw' => { 107 => 0x7 },
	'yawangle' => { 219 => 0x3513, 220 => 0x2c2c, 228 => 0x36fc, 351 => 0x0 },
	'ycbcrcoefficients' => { 111 => 0x211, 449 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 111 => 0x213, 449 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 111 => 0x212, 449 => 'YCbCrSubSampling' },
	'yearcreated' => { 127 => 0x10, 136 => 0xc },
	'yellowhsl' => { 95 => 0x20912 },
	'yield' => { 445 => 'yield' },
	'yposition' => { 111 => 0x11f },
	'yresolution' => { 111 => 0x11b, 122 => 0x5, 335 => 0x4, 449 => 'YResolution' },
	'zonematching' => { 170 => 0x10a, 173 => [0x3a,0x4a], 376 => 0xb024 },
	'zonematchingmode' => { 168 => 0x14 },
	'zonematchingon' => { 167 => 0x75 },
	'zonematchingvalue' => { 364 => 0x1f },
	'zoomedpreviewlength' => { 270 => 0xf05 },
	'zoomedpreviewsize' => { 270 => 0xf06 },
	'zoomedpreviewstart' => { 270 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 268 => 0x300, 270 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemailflagged' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrolocation' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketinginfooffset' => 1,
	'bracketingoffset' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'camm6' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'croparea' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'cx' => 1,
	'cy' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaytime' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpscoordinates' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstrackraw' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'levelmeter' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'listtype' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlatitude' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemusertags' => 1,
	'mditemversion' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metasampledesc' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rads' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrfinderinfo' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2018, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
