#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.12';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 96 => 0x69 },
	'about' => { 414 => 'about' },
	'aboutcvterm' => { 405 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 405 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 405 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 405 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 405 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 420 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 72 => 0x518 },
	'accelerometer' => { 327 => 0x3 },
	'accelerometerx' => { 268 => 0x8d },
	'accelerometery' => { 268 => 0x8e },
	'accelerometerz' => { 268 => 0x8c },
	'accessoryserialnumber' => { 268 => 0x54 },
	'accessorytype' => { 268 => 0x53 },
	'acedemicfield' => { 410 => 'acedemicField' },
	'actionadvised' => { 112 => 0x2a },
	'activearea' => { 104 => 0xc68d },
	'actived-lighting' => { 192 => 0x22, 226 => 0x24 },
	'actived-lightingmode' => { 226 => 0x25 },
	'adaptervoltage' => { 118 => 0x407 },
	'addaspectratioinfo' => { 72 => 0x80e },
	'additionalmodelinformation' => { 405 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 72 => 0x80f, 73 => 0x11, 74 => 0x13, 77 => 0x14 },
	'address' => { 139 => 'Address' },
	'adjustmentmode' => { 333 => 0x15 },
	'adobe' => { 105 => 'Adobe' },
	'adultcontentwarning' => { 408 => 'AdultContentWarning', 413 => 'adultContentWarning' },
	'advancedfilter' => { 109 => 0x1201 },
	'advancedraw' => { 228 => 0x76a43203 },
	'advancedscenetype' => { 268 => 0x3d },
	'advisory' => { 418 => 'Advisory' },
	'ae_iso' => { 275 => 0x2, 276 => 0x4, 277 => 0x12 },
	'aeaperture' => { 275 => 0x1, 276 => 0x3, 277 => 0x11 },
	'aeaperturesteps' => { 275 => 0x8, 276 => 0xb },
	'aebautocancel' => { 72 => 0x104 },
	'aebbracketvalue' => { 66 => 0x11 },
	'aebsequence' => { 72 => 0x105 },
	'aebsequenceautocancel' => { 70 => 0x9, 71 => 0x9, 73 => 0x8, 74 => 0x9, 77 => 0x9, 78 => 0x7 },
	'aebshotcount' => { 72 => 0x106 },
	'aebxv' => { 275 => 0x4, 276 => 0x6 },
	'aeerror' => { 276 => 0x8 },
	'aeexposuretime' => { 275 => 0x0, 276 => 0x2, 277 => 0x10 },
	'aelbutton' => { 159 => 0x45 },
	'aelexposureindicator' => { 159 => 0x51 },
	'aelock' => { 159 => 0x5b, 237 => '4.2', 243 => '4.2', 248 => 0x201, 301 => 0x48, 340 => 0x40, 341 => 0x40, 342 => [0x86,0x286] },
	'aelockbutton' => { 235 => '16.1', 237 => '4.1', 238 => '15.1', 239 => '16.1', 240 => '16.1', 241 => '30.1', 242 => '16.1', 243 => '4.1', 245 => '17.1', 246 => '17.1' },
	'aelockbuttonplusdials' => { 235 => '16.2', 241 => '32.1', 245 => '44.1' },
	'aelockformb-d80' => { 246 => '3.1' },
	'aemaxaperture' => { 275 => 0x9, 276 => 0x10, 277 => 0x1c },
	'aemaxaperture2' => { 275 => 0xa, 276 => 0x11, 277 => 0x1d },
	'aemeteringmode' => { 275 => 0xc },
	'aemeteringmode2' => { 275 => '13.1' },
	'aemeteringsegments' => { 162 => 0x628, 301 => 0x209 },
	'aemicroadjustment' => { 72 => 0x110 },
	'aeminaperture' => { 275 => 0xb, 276 => 0x12, 277 => 0x1e },
	'aeminexposuretime' => { 275 => 0x5, 276 => 0x13, 277 => 0x1f },
	'aeprogrammode' => { 275 => 0x6 },
	'aeprojectlink' => { 394 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 394 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 394 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 394 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 394 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 394 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 30 => 0x21 },
	'aewhitebalance' => { 275 => 0xd },
	'aexv' => { 275 => 0x3, 276 => 0x5 },
	'af-cpriorityselection' => { 235 => '1.1', 236 => '1.1', 239 => '0.1', 240 => '0.1', 241 => '1.1', 242 => '0.1', 245 => '1.1' },
	'af-onformb-d10' => { 235 => '3.3', 241 => '3.2' },
	'af-onformb-d11' => { 242 => '2.2' },
	'af-onformb-d12' => { 245 => '50.1' },
	'af-spriorityselection' => { 235 => '1.2', 236 => '1.2', 241 => '1.2', 242 => '0.2', 245 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 235 => '2.1', 236 => '2.1', 241 => '2.1', 245 => '2.1' },
	'afadjustment' => { 301 => 0x72 },
	'afandmeteringbuttons' => { 72 => 0x701 },
	'afaperture' => { 188 => 0x5, 189 => 0x5 },
	'afareaheight' => { 168 => 0x1a },
	'afareaillumination' => { 159 => 0x4b, 243 => '15.3' },
	'afareamode' => { 155 => 0x33, 159 => 0xe, 167 => 0x0, 168 => 0x5, 268 => 0xf, 324 => 0x1205, 334 => [0xa,0x3a], 340 => 0x11, 341 => 0x10, 342 => 0x24, 352 => 0xb043, 371 => 0x17 },
	'afareamodesetting' => { 237 => '11.1', 238 => '0.1', 243 => '16.1', 246 => '2.1', 352 => 0x201c },
	'afareas' => { 248 => 0x304 },
	'afareaselectmethod' => { 72 => 0x51b },
	'afareawidth' => { 168 => 0x18 },
	'afareaxposition' => { 168 => 0x14, 324 => 0x1203 },
	'afareaxposition1' => { 324 => 0x1201 },
	'afareayposition' => { 168 => 0x16, 324 => 0x1204 },
	'afareayposition1' => { 324 => 0x1202 },
	'afassist' => { 70 => 0x5, 78 => 0x5, 159 => 0x48, 235 => '2.5', 237 => '0.2', 238 => '0.2', 239 => '1.1', 240 => '1.1', 241 => '2.4', 242 => '1.4', 243 => '0.2', 245 => '2.4', 246 => '2.3' },
	'afassistbeam' => { 72 => 0x50e, 73 => 0x4, 74 => 0x5, 75 => 0x4, 76 => 0x4, 77 => 0x5 },
	'afassistlamp' => { 268 => 0x31 },
	'afbuttonpressed' => { 342 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 278 => 0x6 },
	'afduringliveview' => { 72 => 0x511 },
	'affinea' => { 388 => 'AffineA' },
	'affineb' => { 388 => 'AffineB' },
	'affinec' => { 388 => 'AffineC' },
	'affined' => { 388 => 'AffineD' },
	'affinetune' => { 169 => 0x0, 248 => 0x306 },
	'affinetuneadj' => { 169 => 0x2, 201 => 0x2d1, 202 => 0x2dc, 248 => 0x307 },
	'affinetuneindex' => { 169 => 0x1 },
	'affinex' => { 388 => 'AffineX' },
	'affiney' => { 388 => 'AffineY' },
	'afhold' => { 278 => 0x1fd },
	'afilluminator' => { 340 => 0x29, 352 => 0xb044 },
	'afimageheight' => { 168 => 0x12 },
	'afimagewidth' => { 168 => 0x10 },
	'afintegrationtime' => { 278 => 0x7 },
	'afmicroadj' => { 334 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 337 => 0x131 },
	'afmicroadjregisteredlenses' => { 337 => '305.1' },
	'afmicroadjustment' => { 72 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 337 => 0x130 },
	'afmode' => { 100 => 0x3009, 109 => 0x1022, 155 => 0x16, 333 => 0x5 },
	'afmoderestrictions' => { 236 => '50.3', 245 => '48.3' },
	'afonaelockbuttonswitch' => { 72 => 0x702 },
	'afonbutton' => { 235 => '3.1', 236 => '47.1' },
	'afpoint' => { 30 => 0x13, 99 => 0x18, 155 => 0x15, 167 => 0x1, 251 => 0x308, 333 => 0x1f, 334 => 0x7, 337 => 0x19, 338 => 0x18, 339 => [0x18,0x20] },
	'afpointactivationarea' => { 71 => 0x11, 77 => 0x11 },
	'afpointareaexpansion' => { 72 => 0x508 },
	'afpointatshutterrelease' => { 334 => 0x9 },
	'afpointautoselection' => { 72 => 0x50b },
	'afpointbrightness' => { 72 => 0x50d, 235 => '2.4', 236 => '46.5', 245 => '2.3' },
	'afpointdisplayduringfocus' => { 72 => 0x50c },
	'afpointillumination' => { 71 => 0xa, 235 => '2.3', 236 => '46.2', 241 => '2.3', 242 => '1.3', 245 => '47.2', 246 => '2.4' },
	'afpointinfocus' => { 334 => 0x8 },
	'afpointmode' => { 282 => 0x3 },
	'afpointposition' => { 100 => 0x2021, 268 => 0x4d },
	'afpointregistration' => { 70 => 0x7 },
	'afpoints' => { 158 => 0x10 },
	'afpointselected' => { 159 => 0xd, 248 => 0x305, 301 => 0xe, 337 => 0x15, 338 => 0x14, 339 => [0x14,0x1c], 352 => 0x201e },
	'afpointselected2' => { 282 => 0x4 },
	'afpointselection' => { 71 => 0xb, 235 => '1.3', 236 => '1.3', 241 => '1.3', 245 => '1.3' },
	'afpointselectionmethod' => { 72 => 0x50f, 73 => 0xc, 74 => 0xd, 77 => 0xd },
	'afpointsetting' => { 340 => 0x12, 341 => 0x11 },
	'afpointsinfocus' => { 66 => 0xe, 167 => 0x2, 278 => 0xb, 301 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 71 => 0xd },
	'afpointsselected' => { 378 => 0x4 },
	'afpointsunknown1' => { 278 => 0x0 },
	'afpointsunknown2' => { 278 => 0x2 },
	'afpointsused' => { 168 => 0x8, 334 => 0x16e },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 278 => 0x4 },
	'afresponse' => { 192 => 0xad },
	'afresult' => { 253 => 0x1038 },
	'afsearch' => { 248 => 0x303 },
	'afsensoractive' => { 155 => 0x1 },
	'afstatus' => { 324 => 0x1200 },
	'afstatusactivesensor' => { 155 => 0x2, 334 => 0x4, 337 => 0x1e, 338 => 0x1b, 339 => [0x1b,0x21] },
	'afstatusbottom' => { 155 => 0x8, 337 => 0x2a, 338 => 0x21, 339 => 0x21 },
	'afstatusbottom-left' => { 155 => 0x12, 338 => 0x2b, 339 => 0x2b },
	'afstatusbottom-right' => { 155 => 0x6, 338 => 0x1f, 339 => 0x1f },
	'afstatusbottomassist-left' => { 337 => 0x28 },
	'afstatusbottomassist-right' => { 337 => 0x2c },
	'afstatusbottomhorizontal' => { 335 => 0x10, 336 => 0x1c },
	'afstatusbottomvertical' => { 335 => 0x16, 336 => 0x26 },
	'afstatuscenter-10' => { 337 => 0x34 },
	'afstatuscenter-11' => { 337 => 0x36 },
	'afstatuscenter-12' => { 337 => 0x38 },
	'afstatuscenter-14' => { 337 => 0x3c },
	'afstatuscenter-7' => { 337 => 0x2e },
	'afstatuscenter-9' => { 337 => 0x32 },
	'afstatuscenter-horizontal' => { 337 => 0x30 },
	'afstatuscenter-vertical' => { 337 => 0x3a },
	'afstatuscenterf2-8' => { 337 => 0x4c },
	'afstatuscenterhorizontal' => { 155 => 0x2f, 335 => 0xc, 336 => 0x18, 338 => 0x2f, 339 => 0x2f },
	'afstatuscentervertical' => { 155 => 0xc, 335 => 0x14, 336 => 0x22, 338 => 0x25, 339 => 0x25 },
	'afstatusfarleft' => { 335 => 0x6, 337 => 0x26 },
	'afstatusfarlefthorizontal' => { 336 => 0x4 },
	'afstatusfarleftvertical' => { 336 => 0x12 },
	'afstatusfarright' => { 335 => 0x18, 337 => 0x44 },
	'afstatusfarrighthorizontal' => { 336 => 0x2c },
	'afstatusfarrightvertical' => { 336 => 0x34 },
	'afstatusleft' => { 155 => 0x2d, 335 => 0x2, 337 => 0x22, 338 => 0x2d, 339 => 0x2d },
	'afstatuslefthorizontal' => { 336 => 0x6 },
	'afstatusleftvertical' => { 336 => 0xe },
	'afstatuslower-left' => { 335 => 0x4, 337 => 0x24 },
	'afstatuslower-lefthorizontal' => { 336 => 0xa },
	'afstatuslower-leftvertical' => { 336 => 0x10 },
	'afstatuslower-middle' => { 335 => 0x22, 336 => 0x24 },
	'afstatuslower-right' => { 335 => 0x1e, 337 => 0x4a },
	'afstatuslower-righthorizontal' => { 336 => 0x32 },
	'afstatuslower-rightvertical' => { 336 => 0x3a },
	'afstatuslowerfarleft' => { 336 => 0x8 },
	'afstatuslowerfarright' => { 336 => 0x30 },
	'afstatusmiddlehorizontal' => { 155 => 0xa, 338 => 0x23, 339 => 0x23 },
	'afstatusnearleft' => { 335 => 0xe, 336 => 0x1a },
	'afstatusnearright' => { 335 => 0xa, 336 => 0x16 },
	'afstatusright' => { 155 => 0x31, 335 => 0x1c, 337 => 0x48, 338 => 0x31, 339 => 0x31 },
	'afstatusrighthorizontal' => { 336 => 0x2e },
	'afstatusrightvertical' => { 336 => 0x38 },
	'afstatustop' => { 155 => 0xe, 337 => 0x40, 338 => 0x27, 339 => 0x27 },
	'afstatustop-left' => { 155 => 0x10, 338 => 0x29, 339 => 0x29 },
	'afstatustop-right' => { 155 => 0x4, 338 => 0x1d, 339 => 0x1d },
	'afstatustopassist-left' => { 337 => 0x3e },
	'afstatustopassist-right' => { 337 => 0x42 },
	'afstatustophorizontal' => { 335 => 0x8, 336 => 0x14 },
	'afstatustopvertical' => { 335 => 0x12, 336 => 0x1e },
	'afstatusupper-left' => { 335 => 0x0, 337 => 0x20 },
	'afstatusupper-lefthorizontal' => { 336 => 0x2 },
	'afstatusupper-leftvertical' => { 336 => 0xc },
	'afstatusupper-middle' => { 335 => 0x20, 336 => 0x20 },
	'afstatusupper-right' => { 335 => 0x1a, 337 => 0x46 },
	'afstatusupper-righthorizontal' => { 336 => 0x2a },
	'afstatusupper-rightvertical' => { 336 => 0x36 },
	'afstatusupperfarleft' => { 336 => 0x0 },
	'afstatusupperfarright' => { 336 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 334 => 0x2 },
	'afwithshutter' => { 340 => 0x2a },
	'afzoneselected' => { 352 => 0x201e },
	'aggregateissuenumber' => { 410 => 'aggregateIssueNumber' },
	'aggregationtype' => { 410 => 'aggregationType' },
	'agreement' => { 413 => 'agreement' },
	'aiservocontinuousshooting' => { 71 => 0x15 },
	'aiservofirstimagepriority' => { 72 => 0x519 },
	'aiservoimagepriority' => { 72 => 0x503 },
	'aiservosecondimagepriority' => { 72 => 0x51a },
	'aiservotrackingmethod' => { 72 => 0x504 },
	'aiservotrackingsensitivity' => { 71 => 0x14, 72 => 0x502 },
	'album' => { 420 => 'album' },
	'alreadyapplied' => { 395 => 'AlreadyApplied' },
	'alternatetitle' => { 410 => 'alternateTitle' },
	'alternatetitlea-lang' => { 410 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 410 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 410 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 170 => 0x6 },
	'alttapename' => { 420 => 'altTapeName' },
	'alttimecode' => { 420 => 'altTimecode' },
	'alttimecodetimeformat' => { 420 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 420 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 420 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 320 => 0x14, 371 => 0x4 },
	'ambienttemperaturefahrenheit' => { 320 => 0x13 },
	'analogbalance' => { 104 => 0xc627 },
	'angleadj' => { 90 => 0x10003, 96 => 0x8b },
	'angleinforoll' => { 390 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 390 => 'AngleInfoYaw' },
	'anti-blur' => { 352 => 0xb04b },
	'antialiasstrength' => { 104 => 0xc632 },
	'aperturelock' => { 236 => '38.2', 245 => '38.2' },
	'aperturerange' => { 72 => 0x10d },
	'apertureringuse' => { 282 => '1.4' },
	'aperturesetting' => { 159 => 0x7, 340 => 0x30, 341 => 0x29, 342 => 0x1 },
	'aperturevalue' => { 81 => 0x2, 104 => 0x9202, 253 => 0x1002, 399 => 'ApertureValue' },
	'applekeywords' => { 257 => 'AAPL:Keywords' },
	'applicationnotes' => { 104 => 0x2bc, 272 => 0x2bc },
	'applicationrecordversion' => { 112 => 0x0 },
	'applyshootingmeteringmode' => { 72 => 0x10e },
	'approved' => { 401 => 'Approved' },
	'approvedby' => { 401 => 'ApprovedBy' },
	'approximatefnumber' => { 264 => 0x313, 270 => 0x3406 },
	'approximatefocusdistance' => { 391 => 'ApproximateFocusDistance' },
	'aquahsl' => { 90 => 0x20913 },
	'armidentifier' => { 113 => 0x78 },
	'armversion' => { 113 => 0x7a },
	'artfilter' => { 248 => 0x529 },
	'artfiltereffect' => { 248 => 0x52f },
	'artist' => { 104 => 0x13b, 260 => 'Artist', 301 => 0x22e, 416 => 'Artist', 420 => 'artist' },
	'artmode' => { 100 => 0x301b },
	'artmodeparameters' => { 100 => 0x310b },
	'artworkcircadatecreated' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 405 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 405 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 252 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 252 => 0x1112, 301 => 0x80, 340 => 0x55, 341 => 0x55, 342 => 0xa },
	'asshoticcprofile' => { 104 => 0xc68f },
	'asshotneutral' => { 104 => 0xc628 },
	'asshotpreprofilematrix' => { 104 => 0xc690 },
	'asshotprofilename' => { 104 => 0xc6f6 },
	'asshotwhitexy' => { 104 => 0xc629 },
	'assignbktbutton' => { 235 => '4.2', 236 => '16.1', 245 => '16.1' },
	'assignfuncbutton' => { 72 => 0x70b },
	'assignmovierecordbutton' => { 236 => '43.2', 245 => '45.1' },
	'assignremotefnbutton' => { 236 => '54.1', 245 => '51.1' },
	'assistbuttonfunction' => { 70 => 0xd },
	'attributionname' => { 392 => 'attributionName' },
	'attributionurl' => { 392 => 'attributionURL' },
	'audio' => { 268 => 0x20 },
	'audiobitrate' => { 57 => 0x6c },
	'audiochannels' => { 57 => 0x70 },
	'audiochanneltype' => { 420 => 'audioChannelType' },
	'audiocompression' => { 133 => 'Compression' },
	'audiocompressor' => { 420 => 'audioCompressor' },
	'audioduration' => { 112 => 0x99 },
	'audiomoddate' => { 420 => 'audioModDate' },
	'audiooutcue' => { 112 => 0x9a },
	'audiosamplerate' => { 57 => 0x6e, 420 => 'audioSampleRate' },
	'audiosampletype' => { 420 => 'audioSampleType' },
	'audiosamplingrate' => { 112 => 0x97 },
	'audiosamplingresolution' => { 112 => 0x98 },
	'audiotype' => { 112 => 0x96 },
	'author' => { 135 => 'Author', 257 => 'Author', 260 => 'Author', 315 => 'Author', 389 => 'author', 406 => 'Author', 418 => 'Author' },
	'authorsposition' => { 407 => 'AuthorsPosition' },
	'autoaperture' => { 292 => '0.1' },
	'autobracket' => { 333 => 0x19 },
	'autobracketing' => { 109 => 0x1100, 301 => 0x18, 324 => 0x1007 },
	'autobracketingmode' => { 244 => '12.3' },
	'autobracketingset' => { 244 => '12.1' },
	'autobracketmodem' => { 235 => '21.2', 236 => '13.3', 241 => '26.2', 245 => '13.3' },
	'autobracketorder' => { 159 => 0x43, 235 => '21.3', 236 => '13.2', 241 => '26.3', 242 => '12.2', 243 => '2.2', 244 => '12.2', 245 => '13.2', 246 => '13.2' },
	'autobracketset' => { 235 => '21.1', 236 => '13.1', 238 => '11.1', 239 => '12.1', 240 => '12.1', 241 => '26.1', 242 => '12.1', 243 => '2.1', 245 => '13.1', 246 => '13.1' },
	'autobrightness' => { 395 => 'AutoBrightness' },
	'autocontrast' => { 395 => 'AutoContrast' },
	'autodistortioncontrol' => { 178 => 0x4 },
	'autodynamicrange' => { 109 => 0x140b },
	'autoexposure' => { 395 => 'AutoExposure' },
	'autoexposurebracketing' => { 66 => 0x10 },
	'autofocus' => { 251 => 0x209 },
	'autofp' => { 243 => '7.3', 246 => '31.4' },
	'autoiso' => { 66 => 0x1, 100 => 0x3008, 237 => '1.1', 243 => '1.1' },
	'autoisomax' => { 237 => '1.2', 243 => '1.2' },
	'autoisominshutterspeed' => { 237 => '1.3', 243 => '1.3' },
	'autolateralca' => { 395 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 53 => 0x2, 72 => 0x204, 90 => 0x20500, 96 => 0x6f },
	'autolightingoptimizeron' => { 90 => '0x20500.0', 96 => 0x6e },
	'autoportraitframed' => { 352 => 0x2016 },
	'autoredeye' => { 228 => 0xfe28a44f },
	'autorotate' => { 66 => 0x1b },
	'autoshadows' => { 395 => 'AutoShadows' },
	'autowhiteversion' => { 395 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 192 => 0x82 },
	'avaperturesetting' => { 282 => 0x13 },
	'averageblacklevel' => { 37 => 0xe7, 39 => 0xfb, 40 => 0x114, 41 => 0x146 },
	'averagelv' => { 162 => 0x38 },
	'avsettingwithoutlens' => { 72 => 0x707 },
	'azimuth' => { 143 => 'Azimuth' },
	'babyage' => { 268 => [0x8010,0x33] },
	'babyname' => { 268 => 0x66 },
	'backgroundalpha' => { 415 => 'bgalpha' },
	'baseexposurecompensation' => { 282 => 0x15 },
	'baseiso' => { 66 => 0x2, 85 => 0x101c, 118 => 0x903, 270 => 0x312a, 376 => 0x6 },
	'baselineexposure' => { 104 => 0xc62a },
	'baselineexposureoffset' => { 104 => 0xc7a5 },
	'baselinenoise' => { 104 => 0xc62b },
	'baselinesharpness' => { 104 => 0xc62c },
	'baseurl' => { 418 => 'BaseURL' },
	'batterylevel' => { 340 => 0x51, 344 => 0xc, 345 => 0x4, 346 => 0x4, 377 => 0x7 },
	'batterylevelgrip1' => { 377 => 0x6 },
	'batterylevelgrip2' => { 377 => 0x8 },
	'batteryorder' => { 235 => '12.5', 241 => '13.2', 242 => '2.1', 245 => '3.1' },
	'batterystate' => { 159 => 0x60, 340 => 0x50, 346 => 0x14 },
	'batterytemperature' => { 344 => 0x1, 346 => 0x2, 377 => 0x5 },
	'batteryunknown' => { 344 => 0x2, 346 => 0x0 },
	'batteryvoltage' => { 118 => 0x408, 320 => 0x2a, 344 => 0x8 },
	'batteryvoltage1' => { 346 => 0x6 },
	'batteryvoltage2' => { 346 => 0x8 },
	'bayergreensplit' => { 104 => 0xc62d },
	'bayerpattern' => { 117 => 0xf902, 163 => 0x17 },
	'beatspliceparams' => { 420 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 420 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 420 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 420 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 420 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 420 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 235 => '13.1', 236 => '5.4', 237 => '0.1', 238 => '2.1', 239 => '3.1', 240 => '3.1', 241 => '10.1', 243 => '0.1', 245 => '5.5', 246 => '4.1' },
	'beeppitch' => { 242 => '3.1' },
	'beepvolume' => { 242 => '4.5' },
	'bestqualityscale' => { 104 => 0xc65c },
	'bestshotmode' => { 100 => 0x3007 },
	'bitdepth' => { 140 => 'BitDepth', 163 => 0x11, 198 => 0x41 },
	'bitspercomponent' => { 114 => 0x87 },
	'bitspersample' => { 104 => 0x102, 416 => 'BitsPerSample' },
	'blacklevel' => { 104 => 0xc61a, 192 => 0x3d, 253 => [0x401,0x1012] },
	'blacklevel1' => { 272 => 0x8 },
	'blacklevel2' => { 252 => 0x600, 256 => 0x600, 272 => 0x9 },
	'blacklevel3' => { 272 => 0xa },
	'blacklevelblue' => { 272 => 0x1e },
	'blackleveldeltah' => { 104 => 0xc61b },
	'blackleveldeltav' => { 104 => 0xc61c },
	'blacklevelgreen' => { 272 => 0x1d },
	'blacklevelred' => { 272 => 0x1c },
	'blacklevelrepeatdim' => { 104 => 0xc619 },
	'blackpoint' => { 301 => 0x200 },
	'blacks2012' => { 395 => 'Blacks2012' },
	'bleachbypasstoning' => { 301 => 0x7f },
	'blogtitle' => { 410 => 'blogTitle' },
	'blogurl' => { 410 => 'blogURL' },
	'bluebalance' => { 176 => 0x271, 253 => 0x1018, 272 => 0x12, 301 => 0x1b },
	'bluecurvelimits' => { 95 => 0x1fe },
	'bluecurvepoints' => { 94 => 0x79, 95 => 0x1d4 },
	'bluehsl' => { 90 => [0x20914,0x20915] },
	'bluehue' => { 395 => 'BlueHue' },
	'bluesaturation' => { 395 => 'BlueSaturation' },
	'blurcontrol' => { 301 => 0x82 },
	'blurwarning' => { 109 => 0x1300 },
	'bodybatteryadload' => { 280 => 0x3 },
	'bodybatteryadnoload' => { 280 => 0x2 },
	'bodybatterystate' => { 280 => '1.1' },
	'bodybatteryvoltage1' => { 280 => 0x2 },
	'bodybatteryvoltage2' => { 280 => 0x4 },
	'bodybatteryvoltage3' => { 280 => 0x6 },
	'bodybatteryvoltage4' => { 280 => 0x8 },
	'bodyfirmware' => { 325 => 0x0 },
	'bodyfirmwareversion' => { 249 => 0x104, 250 => 0x100, 253 => 0x104 },
	'bodyserialnumber' => { 325 => 0x10 },
	'bookedition' => { 410 => 'bookEdition' },
	'bracketmode' => { 48 => 0x3 },
	'bracketsequence' => { 100 => 0x301d },
	'bracketsettings' => { 268 => 0x45 },
	'bracketshotnumber' => { 48 => 0x5, 282 => 0x9, 351 => 0x2b },
	'bracketshotnumber2' => { 351 => 0x2d },
	'bracketstep' => { 156 => 0xe },
	'bracketvalue' => { 48 => 0x4 },
	'brightness' => { 104 => 0xfe53, 134 => 'Brightness', 152 => 'Brightness', 156 => 0x2c, 194 => 0x34, 320 => 0x25, 340 => 0x22, 352 => 0x2007, 395 => 'Brightness' },
	'brightnessadj' => { 95 => 0x114, 221 => 0x0, 231 => 0x2d, 380 => 0x8018 },
	'brightnessvalue' => { 104 => 0x9203, 162 => [0x691,0x49c3], 253 => 0x1003, 356 => 0x1e, 359 => 0x1140, 360 => 0x1140, 361 => 0x111c, 362 => 0x1198, 363 => 0x1174, 364 => 0x102c, 365 => 0x224, 366 => 0x224, 399 => 'BrightnessValue' },
	'bulbduration' => { 66 => 0x18 },
	'burstmode' => { 120 => 0xa, 268 => 0x2a },
	'burstmode2' => { 120 => 0x18 },
	'burstshot' => { 333 => 0x34 },
	'burstspeed' => { 268 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 72 => 0x70a },
	'bwfilter' => { 156 => 0x2a, 164 => 0x39 },
	'bwmode' => { 253 => 0x203 },
	'by-line' => { 112 => 0x50 },
	'by-linetitle' => { 112 => 0x55 },
	'bytecount' => { 410 => 'byteCount' },
	'calibration' => { 333 => [0x24,0x30] },
	'calibrationilluminant1' => { 104 => 0xc65a },
	'calibrationilluminant2' => { 104 => 0xc65b },
	'cameraangle' => { 420 => 'cameraAngle' },
	'cameracalibration1' => { 104 => 0xc623 },
	'cameracalibration2' => { 104 => 0xc624 },
	'cameracalibrationsig' => { 104 => 0xc6f3 },
	'cameracolorcalibration01' => { 32 => 0x0, 38 => 0xba },
	'cameracolorcalibration02' => { 32 => 0x4, 38 => 0xbf },
	'cameracolorcalibration03' => { 32 => 0x8, 38 => 0xc4 },
	'cameracolorcalibration04' => { 32 => 0xc, 38 => 0xc9 },
	'cameracolorcalibration05' => { 32 => 0x10, 38 => 0xce },
	'cameracolorcalibration06' => { 32 => 0x14, 38 => 0xd3 },
	'cameracolorcalibration07' => { 32 => 0x18, 38 => 0xd8 },
	'cameracolorcalibration08' => { 32 => 0x1c, 38 => 0xdd },
	'cameracolorcalibration09' => { 32 => 0x20, 38 => 0xe2 },
	'cameracolorcalibration10' => { 32 => 0x24, 38 => 0xe7 },
	'cameracolorcalibration11' => { 32 => 0x28, 38 => 0xec },
	'cameracolorcalibration12' => { 32 => 0x2c, 38 => 0xf1 },
	'cameracolorcalibration13' => { 32 => 0x30, 38 => 0xf6 },
	'cameracolorcalibration14' => { 32 => 0x34, 38 => 0xfb },
	'cameracolorcalibration15' => { 32 => 0x38, 38 => 0x100 },
	'camerae-mountversion' => { 379 => 0xb },
	'cameraid' => { 253 => 0x209, 332 => 0x209 },
	'cameraiso' => { 30 => 0x10 },
	'cameralabel' => { 104 => 0xc7a1, 420 => 'cameraLabel' },
	'cameramodel' => { 420 => 'cameraModel' },
	'cameramodelid' => { 152 => 'CameraModelID' },
	'cameramove' => { 420 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 268 => 0x8f, 305 => 0x1, 346 => [0x16,0x18], 368 => 0x28, 369 => 0x24, 370 => 0x29 },
	'cameraowner' => { 121 => 0xc353 },
	'cameraparameters' => { 253 => 0x2050 },
	'cameraprofile' => { 395 => 'CameraProfile' },
	'cameraprofiledigest' => { 395 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 104 => 0xc62f, 154 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 248 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 29 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 66 => 0xc, 118 => 0x406, 252 => 0x1306, 264 => 0x320, 270 => 0x3402, 301 => 0x47, 330 => 0x43, 372 => 0x5 },
	'cameratemperature4' => { 306 => 0x14 },
	'cameratemperature5' => { 306 => 0x16 },
	'cameratemperaturerangemax' => { 106 => 0x5 },
	'cameratemperaturerangemin' => { 106 => 0x6 },
	'cameratype' => { 66 => 0x1a, 253 => 0x207 },
	'cameratype2' => { 249 => 0x100 },
	'canondr4' => { 105 => 'CanonDR4' },
	'canonexposuremode' => { 30 => 0x14 },
	'canonfiledescription' => { 85 => 0x805 },
	'canonfilelength' => { 54 => 0xe },
	'canonfirmwareversion' => { 54 => 0x7, 85 => 0x80b },
	'canonflashinfo' => { 85 => 0x1028 },
	'canonflashmode' => { 30 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 30 => 0xa },
	'canonimagetype' => { 54 => 0x6, 85 => 0x815 },
	'canonmodelid' => { 54 => 0x10, 85 => 0x1834 },
	'canonvrd' => { 105 => 'CanonVRD' },
	'caption' => { 389 => 'caption' },
	'caption-abstract' => { 112 => 0x78 },
	'captionsauthornames' => { 398 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 398 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 407 => 'CaptionWriter' },
	'captureframerate' => { 100 => 0x4001 },
	'capturesoftware' => { 384 => 'CaptureSoftware' },
	'cardshutterlock' => { 159 => 0x49 },
	'casioimagesize' => { 100 => 0x9 },
	'catalogsets' => { 112 => 0xff, 383 => 'CatalogSets', 387 => 'CatalogSets' },
	'categories' => { 54 => 0x23, 389 => 'categories' },
	'category' => { 112 => 0xf, 247 => 0x30, 407 => 'Category' },
	'cbcrgain' => { 330 => 0xa036 },
	'cbcrgaindefault' => { 330 => 0xa035 },
	'cbcrmatrix' => { 330 => 0xa034 },
	'cbcrmatrixdefault' => { 330 => 0xa033 },
	'ccdboardversion' => { 264 => 0x331 },
	'ccdscanmode' => { 253 => 0x1039 },
	'ccdsensitivity' => { 218 => 0x6 },
	'ccdversion' => { 264 => 0x330 },
	'cellglobalid' => { 393 => 'cgi' },
	'celllength' => { 104 => 0x109 },
	'cellr' => { 393 => 'r' },
	'celltowerid' => { 393 => 'cellid' },
	'cellwidth' => { 104 => 0x108 },
	'centerafarea' => { 243 => '15.1' },
	'centerfocuspoint' => { 246 => '2.2' },
	'centerweightedareasize' => { 235 => '7.1', 236 => '8.1', 241 => '5.1', 242 => '7.1', 243 => '6.3', 245 => '8.1', 246 => '8.1' },
	'certificate' => { 424 => 'Certificate' },
	'cfapattern' => { 104 => 0xa302, 399 => 'CFAPattern' },
	'cfapattern2' => { 104 => 0x828e },
	'cfapatterncolumns' => { 399 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 399 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 399 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 104 => 0x828d },
	'channel' => { 410 => 'channel' },
	'channela-lang' => { 410 => [\'channel','channelA-lang'] },
	'channelchannel' => { 410 => [\'channel','channelChannel'] },
	'channels' => { 133 => 'Channels' },
	'channelsubchannel1' => { 410 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 410 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 410 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 410 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 90 => 0x10101, 95 => 0x26a },
	'checkmark2' => { 96 => 0x8e },
	'childfontfiles' => { 425 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 235 => '10.3', 236 => '11.2' },
	'chromablurradius' => { 104 => 0xc631 },
	'chromaticaberration' => { 90 => 0x20703, 96 => 0x66, 330 => 0xa051 },
	'chromaticaberrationb' => { 395 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 90 => 0x20708, 96 => 0x6b },
	'chromaticaberrationcorr' => { 68 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 291 => 0x1 },
	'chromaticaberrationon' => { 90 => '0x20703.0', 96 => 0x62 },
	'chromaticaberrationr' => { 395 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 90 => 0x20707, 96 => 0x6a },
	'chromaticaberrationsetting' => { 69 => 0x6 },
	'chrominancenoisereduction' => { 90 => 0x20601, 96 => 0x5e, 333 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 96 => 0x60 },
	'circgradbasedcorractive' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 395 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 395 => 'CircularGradientBasedCorrections' },
	'city' => { 112 => 0x5a, 139 => 'City', 268 => 0x6d, 407 => 'City' },
	'city2' => { 268 => 0x80 },
	'clarity' => { 395 => 'Clarity' },
	'clarity2012' => { 395 => 'Clarity2012' },
	'classifystate' => { 112 => 0xe1 },
	'clearretouch' => { 268 => 0x7c },
	'clearretouchvalue' => { 268 => 0xa3 },
	'client' => { 420 => 'client' },
	'clientname' => { 401 => 'ClientName' },
	'clmodeshootingspeed' => { 235 => '10.2', 236 => '11.3', 241 => '11.2', 242 => '10.2', 245 => '11.2', 246 => '11.1' },
	'cmcontrast' => { 256 => 0x2022 },
	'cmexposurecompensation' => { 256 => 0x2000 },
	'cmhue' => { 256 => 0x2021 },
	'cmsaturation' => { 256 => 0x2020 },
	'cmsharpness' => { 256 => 0x2023 },
	'cmwhitebalance' => { 256 => 0x2001 },
	'cmwhitebalancecomp' => { 256 => 0x2002 },
	'cmwhitebalancegraypoint' => { 256 => 0x2010 },
	'codec' => { 147 => 'Codec' },
	'codedcharacterset' => { 113 => 0x5a },
	'collectionname' => { 148 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 148 => 'Collections' },
	'collectionuri' => { 148 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 409 => 'color' },
	'coloraberrationcontrol' => { 228 => 0xc89224b },
	'coloradjustment' => { 333 => 0x14 },
	'coloradjustmentmode' => { 332 => 0x210 },
	'coloranta' => { 425 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 425 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 425 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 425 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 425 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 425 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 425 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 425 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 425 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 425 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 425 => 'Colorants' },
	'colorantswatchname' => { 425 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 425 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 425 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 425 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 134 => 'ColorBalance' },
	'colorbalanceadj' => { 228 => 0x76a43202 },
	'colorbalanceblue' => { 156 => 0x1e },
	'colorbalancegreen' => { 156 => 0x1d },
	'colorbalancered' => { 156 => 0x1c },
	'colorbalanceversion' => { 177 => 0x0 },
	'colorblur' => { 96 => 0x65 },
	'colorbluron' => { 90 => 0x20704 },
	'colorbooster' => { 228 => 0x5f0e7d23 },
	'colorboostlevel' => { 222 => 0x1 },
	'colorboosttype' => { 222 => 0x0 },
	'colorclass' => { 310 => 0xde, 311 => 'ColorClass' },
	'colorcompensationfilter' => { 159 => [0x3a,0x5f], 161 => 0x111, 352 => 0xb022 },
	'colorcompensationfiltercustom' => { 340 => 0xd, 341 => 0xc },
	'colorcompensationfilterset' => { 340 => 0x8, 341 => 0x7, 342 => 0x18, 356 => 0xf },
	'colorcontrol' => { 253 => 0x102b },
	'colorcorrection' => { 380 => 0x8015 },
	'colordataversion' => { 36 => 0x0, 37 => 0x0, 39 => 0x0, 40 => 0x0, 41 => 0x0 },
	'coloreffect' => { 268 => 0x28 },
	'colorfilter' => { 99 => 0x17, 100 => 0x3017, 156 => 0x29, 164 => [0x38,0x4d,0x4f], 308 => 0x17 },
	'colorgain' => { 198 => 0x51 },
	'colorhue' => { 90 => 0x20900, 192 => 0x8d },
	'colorimetricreference' => { 104 => 0xc6bf },
	'colorlabel' => { 398 => 'ColorLabel' },
	'colormatrix' => { 252 => 0x200, 253 => 0x1011, 330 => 0xa030 },
	'colormatrix1' => { 104 => 0xc621 },
	'colormatrix2' => { 104 => 0xc622, 256 => 0x200 },
	'colormatrixa' => { 301 => 0x203 },
	'colormatrixadobergb' => { 330 => 0xa032 },
	'colormatrixb' => { 301 => 0x204 },
	'colormatrixnumber' => { 253 => 0x1019 },
	'colormatrixsrgb' => { 330 => 0xa031 },
	'colormode' => { 100 => 0x3015, 109 => 0x1210, 120 => 0x66, 156 => 0x28, 159 => 0x16, 161 => 0x101, 162 => 0x36, 164 => 0x7, 192 => 0x3, 218 => 0x4, 268 => 0x32, 333 => 0x2c, 352 => 0xb029, 407 => 'ColorMode' },
	'colormoirereduction' => { 229 => 0x15 },
	'colormoirereductionmode' => { 229 => 0x5 },
	'colornoisereduction' => { 380 => 0x8029, 395 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 395 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 229 => 0x18 },
	'colornoisereductionsharpness' => { 229 => 0x1c },
	'colornoisereductionsmoothness' => { 395 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 108 => 0x2 },
	'colorprofile' => { 156 => 0x33 },
	'colorrepresentation' => { 114 => 0x3c },
	'colorsaturationadj' => { 90 => 0x20305 },
	'colorsequence' => { 114 => 0x41 },
	'colorspace' => { 42 => 0x3, 54 => 0xb4, 85 => 0x10b4, 104 => 0xa001, 140 => 'ColorSpace', 157 => 0x2f, 158 => 0x25, 159 => 0x17, 192 => 0x1e, 248 => 0x507, 301 => 0x37, 330 => 0xa011, 333 => 0xb, 340 => 0x1b, 341 => 0x83, 342 => 0xe, 356 => 0x6, 399 => 'ColorSpace' },
	'colortempasshot' => { 33 => 0x4, 34 => 0x1d, 35 => 0x26, 36 => 0x43, 39 => 0x43, 40 => 0x43, 41 => 0x43 },
	'colortempauto' => { 33 => 0x9, 34 => 0x22, 35 => 0x1c, 36 => 0x48, 39 => 0x48, 40 => 0x48, 41 => 0x48 },
	'colortempcloudy' => { 33 => 0x22, 34 => 0x31, 35 => 0x35, 36 => 0x5c, 39 => 0x75, 40 => 0x8e, 41 => 0x93, 301 => 0x55 },
	'colortempcustom' => { 36 => 0x84 },
	'colortempcustom1' => { 34 => 0x45 },
	'colortempcustom2' => { 34 => 0x4a },
	'colortempdaylight' => { 33 => 0x18, 34 => 0x27, 35 => 0x2b, 36 => 0x52, 39 => 0x6b, 40 => 0x84, 41 => 0x89, 301 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 54 => 0xae, 64 => 0x9, 85 => 0x10ae, 109 => 0x1005, 118 => 0x846, 134 => 'ColorTemperature', 157 => [0x6e,0x49], 158 => 0x3f, 159 => [0x39,0x5e], 161 => 0x10b, 164 => [0x3c,0x4c,0x4e], 264 => 0x321, 301 => 0x50, 324 => 0x1308, 352 => 0xb021, 395 => 'Temperature' },
	'colortemperatureadj' => { 380 => 0x8013 },
	'colortemperaturebg' => { 253 => 0x1013 },
	'colortemperaturecustom' => { 340 => 0xc, 341 => 0xb },
	'colortemperaturerg' => { 253 => 0x1014 },
	'colortemperatureset' => { 340 => 0x7, 341 => 0x6 },
	'colortemperaturesetting' => { 159 => 0x25, 342 => 0x17, 356 => 0xe },
	'colortempflash' => { 33 => 0x36, 34 => 0x40, 35 => 0x49, 36 => 0x70, 39 => 0x89, 40 => 0xa2, 41 => 0xa7, 301 => 0x5a },
	'colortempflashdata' => { 36 => 0x24a },
	'colortempfluorescent' => { 33 => 0x2c, 34 => 0x3b, 35 => 0x3f, 36 => 0x66, 39 => 0x7f, 40 => 0x98, 41 => 0x9d },
	'colortempfluorescentd' => { 301 => 0x57 },
	'colortempfluorescentn' => { 301 => 0x58 },
	'colortempfluorescentw' => { 301 => 0x59 },
	'colortempkelvin' => { 33 => 0x31, 35 => 0x44, 36 => 0x6b, 39 => 0x84, 40 => 0x9d, 41 => 0xa2, 268 => 0x44, 324 => 0x1307 },
	'colortempmeasured' => { 33 => 0xe, 36 => 0x4d, 39 => 0x4d, 40 => 0x4d, 41 => 0x4d },
	'colortemppc1' => { 35 => 0x94, 36 => 0x75 },
	'colortemppc2' => { 35 => 0x99, 36 => 0x7a },
	'colortemppc3' => { 35 => 0x9e, 36 => 0x7f },
	'colortempshade' => { 33 => 0x1d, 34 => 0x2c, 35 => 0x30, 36 => 0x57, 39 => 0x70, 40 => 0x89, 41 => 0x8e, 301 => 0x54 },
	'colortemptungsten' => { 33 => 0x27, 34 => 0x36, 35 => 0x3a, 36 => 0x61, 39 => 0x7a, 40 => 0x93, 41 => 0x98, 301 => 0x56 },
	'colortempunknown' => { 33 => 0x13, 35 => 0x21, 39 => 0x52, 40 => 0x52, 41 => 0x52 },
	'colortempunknown10' => { 33 => 0x63, 35 => 0x76, 39 => 0xa2, 40 => 0x7f, 41 => 0x7f },
	'colortempunknown11' => { 33 => 0x68, 35 => 0x7b, 39 => 0xa7, 40 => 0xa7, 41 => 0x84 },
	'colortempunknown12' => { 33 => 0x6d, 35 => 0x80, 39 => 0xac, 40 => 0xac, 41 => 0xac },
	'colortempunknown13' => { 33 => 0x72, 35 => 0x85, 39 => 0xb1, 40 => 0xb1, 41 => 0xb1 },
	'colortempunknown14' => { 35 => 0x8a, 39 => 0xb6, 40 => 0xb6, 41 => 0xb6 },
	'colortempunknown15' => { 35 => 0x8f, 39 => 0xbb, 40 => 0xbb, 41 => 0xbb },
	'colortempunknown16' => { 35 => 0xa3, 40 => 0xc0, 41 => 0xc0 },
	'colortempunknown17' => { 40 => 0xc5, 41 => 0xc5 },
	'colortempunknown18' => { 40 => 0xca, 41 => 0xca },
	'colortempunknown19' => { 40 => 0xcf, 41 => 0xcf },
	'colortempunknown2' => { 33 => 0x3b, 35 => 0x4e, 39 => 0x57, 40 => 0x57, 41 => 0x57 },
	'colortempunknown20' => { 40 => 0xd4, 41 => 0xd4 },
	'colortempunknown21' => { 41 => 0xd9 },
	'colortempunknown22' => { 41 => 0xde },
	'colortempunknown23' => { 41 => 0xe3 },
	'colortempunknown24' => { 41 => 0xe8 },
	'colortempunknown25' => { 41 => 0xed },
	'colortempunknown26' => { 41 => 0xf2 },
	'colortempunknown27' => { 41 => 0xf7 },
	'colortempunknown28' => { 41 => 0xfc },
	'colortempunknown29' => { 41 => 0x101 },
	'colortempunknown3' => { 33 => 0x40, 35 => 0x53, 39 => 0x5c, 40 => 0x5c, 41 => 0x5c },
	'colortempunknown30' => { 41 => 0x106 },
	'colortempunknown4' => { 33 => 0x45, 35 => 0x58, 39 => 0x61, 40 => 0x61, 41 => 0x61 },
	'colortempunknown5' => { 33 => 0x4a, 35 => 0x5d, 39 => 0x66, 40 => 0x66, 41 => 0x66 },
	'colortempunknown6' => { 33 => 0x4f, 35 => 0x62, 39 => 0x8e, 40 => 0x6b, 41 => 0x6b },
	'colortempunknown7' => { 33 => 0x54, 35 => 0x67, 39 => 0x93, 40 => 0x70, 41 => 0x70 },
	'colortempunknown8' => { 33 => 0x59, 35 => 0x6c, 39 => 0x98, 40 => 0x75, 41 => 0x75 },
	'colortempunknown9' => { 33 => 0x5e, 35 => 0x71, 39 => 0x9d, 40 => 0x7a, 41 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 30 => 0x2a, 42 => 0x2 },
	'colortoneadj' => { 90 => 0x20304, 95 => 0x11e },
	'colortoneauto' => { 61 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 60 => 0x6c, 61 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 60 => 0x3c, 61 => 0x3c },
	'colortonemonochrome' => { 60 => 0x84, 61 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 60 => 0x54, 61 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 60 => 0x24, 61 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 60 => 0xc, 61 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 60 => 0x9c, 61 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 60 => 0xb4, 61 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 60 => 0xcc, 61 => 0xe4 },
	'commanddials' => { 243 => '5.1' },
	'commanddialsaperturesetting' => { 235 => '17.3', 236 => '18.3', 241 => '33.3', 242 => '17.3', 245 => '18.3' },
	'commanddialschangemainsub' => { 235 => '17.2', 236 => '18.1', 241 => '33.2', 242 => '17.2', 245 => '18.1' },
	'commanddialsmenuandplayback' => { 235 => '17.4', 236 => '18.2', 241 => '33.4', 242 => '17.4', 245 => '18.2' },
	'commanddialsreverserotation' => { 235 => '17.1', 236 => '6.4', 238 => '16.2', 239 => '17.2', 241 => '33.1', 242 => '17.1', 245 => '6.2', 246 => '18.1' },
	'commanderchannel' => { 243 => '10.2', 244 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 243 => '13.1', 244 => '31.1' },
	'commandergroupa_ttlcomp' => { 246 => '32.1' },
	'commandergroupamanualoutput' => { 243 => '13.2', 244 => '28.2' },
	'commandergroupamode' => { 243 => '11.2', 244 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 243 => '14.1', 244 => '32.1' },
	'commandergroupb_ttlcomp' => { 246 => '33.1' },
	'commandergroupbmanualoutput' => { 243 => '14.2', 244 => '29.2' },
	'commandergroupbmode' => { 243 => '11.3', 244 => '29.1' },
	'commanderinternalflash' => { 243 => '11.1', 244 => '27.1' },
	'commanderinternalmanualoutput' => { 243 => '12.2', 244 => '27.2' },
	'commanderinternalttlchannel' => { 241 => '18.2' },
	'commanderinternalttlcomp' => { 243 => '12.1', 244 => '30.2', 246 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 241 => '20.1', 242 => '26.1' },
	'commanderinternalttlcompgroupa' => { 241 => '21.1', 242 => '27.1' },
	'commanderinternalttlcompgroupb' => { 241 => '22.1', 242 => '28.1' },
	'comment' => { 0 => 0x2, 105 => 'Comment', 135 => 'Comment', 260 => 'Comment' },
	'compass' => { 327 => 0x4 },
	'complianceprofile' => { 410 => 'complianceProfile' },
	'componentsconfiguration' => { 104 => 0x9101, 140 => 'Components', 399 => 'ComponentsConfiguration' },
	'componentversion' => { 85 => 0x80c },
	'composer' => { 420 => 'composer' },
	'compositionadjust' => { 300 => '0.1' },
	'compositionadjustrotation' => { 300 => 0x7 },
	'compositionadjustx' => { 300 => 0x5 },
	'compositionadjusty' => { 300 => 0x6 },
	'compressedbitsperpixel' => { 104 => 0x9102, 399 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 161 => 0x40, 253 => 0x40 },
	'compression' => { 104 => 0x103, 416 => 'Compression' },
	'compressionfactor' => { 248 => 0x50d },
	'compressionratio' => { 140 => 'Compression', 253 => 0x1034 },
	'confidencelevel' => { 390 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 95 => 0x266, 310 => 0xd6 },
	'constrainedcropwidth' => { 95 => 0x262, 310 => 0xd5 },
	'contact' => { 112 => 0x76 },
	'contactinfo' => { 409 => 'contactInfo' },
	'contentlocationcode' => { 112 => 0x1a },
	'contentlocationname' => { 112 => 0x1b },
	'contenttype' => { 410 => 'contentType' },
	'continuousbracketing' => { 159 => 0x20 },
	'continuousdrive' => { 30 => 0x5 },
	'continuousshootingspeed' => { 72 => 0x610 },
	'continuousshotlimit' => { 72 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 30 => 0xd, 99 => 0xc, 100 => [0x3012,0x20], 104 => [0xa408,0xfe54], 109 => [0x1004,0x1006], 134 => 'Contrast', 152 => 'Contrast', 156 => 0x20, 157 => 0x31, 158 => 0x27, 159 => 0x19, 164 => 0x2, 194 => 0x33, 253 => 0x1029, 268 => 0x39, 270 => 0x300a, 301 => 0x20, 308 => 0xc, 320 => 0x24, 324 => 0x1012, 333 => 0xd, 340 => 0x1d, 341 => 0x1a, 352 => 0x2004, 395 => 'Contrast', 399 => 'Contrast' },
	'contrast2012' => { 395 => 'Contrast2012' },
	'contrastadj' => { 90 => 0x20303, 95 => 0x115, 231 => 0x2c, 380 => 0x8017 },
	'contrastauto' => { 61 => 0x90 },
	'contrastcurve' => { 192 => 0x8c },
	'contrastdetectaf' => { 168 => 0x4 },
	'contrastdetectafarea' => { 301 => 0x231 },
	'contrastdetectafinfocus' => { 168 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 60 => 0x60, 61 => 0x60 },
	'contrasthighlight' => { 301 => 0x6d },
	'contrasthighlightshadowadj' => { 301 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 60 => 0x30, 61 => 0x30 },
	'contrastmode' => { 268 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 60 => 0x78, 61 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 60 => 0x48, 61 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 60 => 0x18, 61 => 0x18 },
	'contrastsetting' => { 248 => 0x505, 256 => 0x1012, 342 => 0x10, 356 => 0x8 },
	'contrastshadow' => { 301 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 60 => 0x0, 61 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 60 => 0x90, 61 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 60 => 0xa8, 61 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 60 => 0xc0, 61 => 0xd8 },
	'contributedmedia' => { 420 => 'contributedMedia' },
	'contributedmediaduration' => { 420 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 420 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 420 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 420 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 420 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 420 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 420 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 420 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 420 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 420 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 396 => 'contributor' },
	'contributors' => { 135 => 'Contributors' },
	'controldialset' => { 159 => 0x46 },
	'controlledvocabularyterm' => { 405 => 'CVterm' },
	'controllerboardversion' => { 264 => 0x332 },
	'controlmode' => { 66 => 0x12 },
	'conversionlens' => { 249 => 0x403, 268 => 0x35 },
	'converter' => { 104 => 0xfe4d, 218 => 0xb, 395 => 'Converter' },
	'converttograyscale' => { 395 => 'ConvertToGrayscale' },
	'cookingequipment' => { 412 => 'cookingEquipment' },
	'cookingmethod' => { 412 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 104 => 0x8298, 135 => 'Copyright', 260 => 'Copyright', 301 => 0x22f, 315 => 'Copyright', 406 => 'Copyright', 413 => 'copyright', 416 => 'Copyright', 420 => 'copyright' },
	'copyrightflag' => { 313 => 0x40a },
	'copyrightnotice' => { 112 => 0x74 },
	'copyrightowner' => { 408 => 'CopyrightOwner' },
	'copyrightownerid' => { 408 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 408 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 408 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 408 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 408 => 'CopyrightStatus' },
	'copyrightyear' => { 410 => 'copyrightYear' },
	'coringfilter' => { 252 => 0x310, 253 => 0x102d, 256 => 0x310 },
	'coringvalues' => { 252 => 0x311, 256 => 0x311 },
	'corporateentity' => { 410 => 'corporateEntity' },
	'country' => { 139 => 'Country', 268 => 0x69, 407 => 'Country' },
	'country-primarylocationcode' => { 112 => 0x64 },
	'country-primarylocationname' => { 112 => 0x65 },
	'countrycode' => { 191 => 0x5, 311 => 'CountryCode', 404 => 'CountryCode' },
	'course' => { 412 => 'course' },
	'coverage' => { 396 => 'coverage' },
	'coverdate' => { 410 => 'coverDate' },
	'coverdisplaydate' => { 410 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 301 => 0x28 },
	'crc32' => { 397 => 'crc32' },
	'createdate' => { 104 => 0x9004, 135 => 'CreateDate', 257 => 'CreationDate', 260 => 'create-date', 315 => 'CreationDate', 317 => 0x1, 418 => 'CreateDate' },
	'creationdate' => { 406 => 'CreationDate', 410 => 'creationDate' },
	'creationtime' => { 260 => 'Creation Time' },
	'creativestyle' => { 340 => 0x1a, 341 => 0x18, 351 => 0x41, 352 => 0xb020, 376 => 0x4a },
	'creativestylesetting' => { 342 => 0xf, 356 => 0x7 },
	'creativestylewaschanged' => { 380 => 0x8001 },
	'creator' => { 257 => 'Creator', 315 => 'Creator', 396 => 'creator', 406 => 'Creator' },
	'creatoraddress' => { 404 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 154 => 'CreatorAppId' },
	'creatorcity' => { 404 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 404 => 'CreatorContactInfo' },
	'creatorcountry' => { 404 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoropenwithuioptions' => { 154 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 404 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 404 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 418 => 'CreatorTool' },
	'creatorworkemail' => { 404 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 404 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 404 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 112 => 0x6e, 407 => 'Credit' },
	'creditline' => { 413 => 'creditLine' },
	'creditlinereq' => { 423 => 'CreditLineReq' },
	'creditlinerequired' => { 408 => 'CreditLineRequired' },
	'cropactive' => { 89 => 0x0, 95 => 0x244 },
	'cropangle' => { 395 => 'CropAngle' },
	'cropaspectratio' => { 90 => 0x30101, 95 => 0x260 },
	'cropaspectratiocustom' => { 90 => 0x30102 },
	'cropbottom' => { 108 => 0x9, 223 => 0x36, 272 => 0x31, 310 => 0xdc, 395 => 'CropBottom' },
	'cropbottommargin' => { 44 => 0x3 },
	'cropcircleactive' => { 96 => 0xd6 },
	'cropcircleradius' => { 96 => 0xd9 },
	'cropcirclex' => { 96 => 0xd7 },
	'cropcircley' => { 96 => 0xd8 },
	'cropconstraintowarp' => { 395 => 'CropConstrainToWarp' },
	'croph' => { 388 => 'CropH' },
	'cropheight' => { 89 => 0x6, 95 => 0x24c, 252 => 0x615, 256 => 0x615, 395 => 'CropHeight' },
	'crophispeed' => { 192 => 0x1b },
	'cropleft' => { 95 => 0x246, 108 => 0x6, 223 => 0x1e, 252 => 0x612, 256 => 0x612, 272 => 0x30, 310 => 0xd9, 395 => 'CropLeft' },
	'cropleftmargin' => { 44 => 0x0 },
	'cropmode35mm' => { 324 => 0x1018 },
	'croporiginalheight' => { 89 => 0xb },
	'croporiginalwidth' => { 89 => 0xa },
	'cropoutputheight' => { 223 => 0xce },
	'cropoutputheightinches' => { 223 => 0x96 },
	'cropoutputpixels' => { 223 => 0xd6 },
	'cropoutputresolution' => { 223 => 0xb6 },
	'cropoutputscale' => { 223 => 0xbe },
	'cropoutputwidth' => { 223 => 0xc6 },
	'cropoutputwidthinches' => { 223 => 0x8e },
	'croppedareaimageheightpixels' => { 384 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 384 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 384 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 384 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 324 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 324 => 0x1603 },
	'cropright' => { 108 => 0x8, 223 => 0x2e, 272 => 0x32, 310 => 0xdb, 395 => 'CropRight' },
	'croprightmargin' => { 44 => 0x1 },
	'croprotatedoriginalheight' => { 89 => 0x2 },
	'croprotatedoriginalwidth' => { 89 => 0x1 },
	'croprotation' => { 89 => 0x8, 108 => 0xb },
	'cropscaledresolution' => { 223 => 0x9e },
	'cropsourceresolution' => { 223 => 0xae },
	'croptop' => { 95 => 0x248, 108 => 0x7, 223 => 0x26, 252 => 0x613, 256 => 0x613, 272 => 0x2f, 310 => 0xda, 395 => 'CropTop' },
	'croptopmargin' => { 44 => 0x2 },
	'cropunit' => { 395 => 'CropUnit' },
	'cropunits' => { 395 => 'CropUnits' },
	'cropw' => { 388 => 'CropW' },
	'cropwidth' => { 89 => 0x5, 95 => 0x24a, 252 => 0x614, 256 => 0x614, 395 => 'CropWidth' },
	'cropx' => { 89 => 0x3, 388 => 'CropX' },
	'cropy' => { 89 => 0x4, 388 => 'CropY' },
	'crossprocess' => { 301 => 0x7b },
	'crossprocessparams' => { 301 => 0x235 },
	'cuisine' => { 412 => 'cuisine' },
	'currenticcprofile' => { 104 => 0xc691 },
	'currentpreprofilematrix' => { 104 => 0xc692 },
	'currentversion' => { 380 => 0xd000 },
	'curve0x' => { 388 => 'Curve0x' },
	'curve0y' => { 388 => 'Curve0y' },
	'curve1x' => { 388 => 'Curve1x' },
	'curve1y' => { 388 => 'Curve1y' },
	'curve2x' => { 388 => 'Curve2x' },
	'curve2y' => { 388 => 'Curve2y' },
	'curve3x' => { 388 => 'Curve3x' },
	'curve3y' => { 388 => 'Curve3y' },
	'curve4x' => { 388 => 'Curve4x' },
	'curve4y' => { 388 => 'Curve4y' },
	'curves' => { 228 => 0x76a43201 },
	'custom1' => { 408 => 'Custom1' },
	'custom10' => { 408 => 'Custom10' },
	'custom2' => { 408 => 'Custom2' },
	'custom3' => { 408 => 'Custom3' },
	'custom4' => { 408 => 'Custom4' },
	'custom5' => { 408 => 'Custom5' },
	'custom6' => { 408 => 'Custom6' },
	'custom7' => { 408 => 'Custom7' },
	'custom8' => { 408 => 'Custom8' },
	'custom9' => { 408 => 'Custom9' },
	'customcolortone' => { 96 => 0x4c },
	'customcontrast' => { 96 => 0x4e },
	'customcontrols' => { 72 => 0x70c },
	'customdefaultunsharpfineness' => { 96 => 0xbe },
	'customdefaultunsharpstrength' => { 96 => 0xbc },
	'customdefaultunsharpthreshold' => { 96 => 0xc0 },
	'customlinear' => { 96 => 0x4f },
	'customoutputhighlightpoint' => { 96 => 0x53 },
	'customoutputshadowpoint' => { 96 => 0x54 },
	'custompicturestyle' => { 90 => 0x10021 },
	'custompicturestyledata' => { 90 => 0xf0500 },
	'custompicturestylefilename' => { 54 => 0x4010 },
	'customrawhighlight' => { 96 => 0x7c },
	'customrawhighlightpoint' => { 96 => 0x51 },
	'customrawshadow' => { 96 => 0x85 },
	'customrawshadowpoint' => { 96 => 0x52 },
	'customrendered' => { 104 => 0xa401, 399 => 'CustomRendered' },
	'customsaturation' => { 96 => 0x4d, 248 => 0x503 },
	'customsettingsalldefault' => { 235 => '0.2', 241 => '0.2' },
	'customsettingsbank' => { 235 => '0.1', 236 => '0.1', 241 => '0.1', 245 => '0.2' },
	'customsharpness' => { 96 => 0x50 },
	'customunsharpmaskfineness' => { 96 => 0xb8 },
	'customunsharpmaskstrength' => { 96 => 0xb6 },
	'customunsharpmaskthreshold' => { 96 => 0xba },
	'customwb_rblevels' => { 356 => 0x1a },
	'customwb_rgblevels' => { 341 => 0x8, 342 => 0x19 },
	'customwbbluelevel' => { 159 => 0x36 },
	'customwberror' => { 159 => 0x37 },
	'customwbgreenlevel' => { 159 => 0x35 },
	'customwbredlevel' => { 159 => 0x34 },
	'customwbsetting' => { 159 => 0x26 },
	'd-lightinghq' => { 228 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 224 => 0x2 },
	'd-lightinghqhighlight' => { 224 => 0x1 },
	'd-lightinghqselected' => { 228 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 224 => 0x0 },
	'd-lightinghs' => { 228 => 0xce5554aa },
	'd-lightinghsadjustment' => { 225 => 0x0 },
	'd-lightinghscolorboost' => { 225 => 0x1 },
	'd-rangeoptimizerhighlight' => { 380 => 0x8024 },
	'd-rangeoptimizermode' => { 380 => 0x8022 },
	'd-rangeoptimizershadow' => { 380 => 0x802d },
	'd-rangeoptimizervalue' => { 380 => 0x8023 },
	'd810meteringmode' => { 216 => 0x175e },
	'datacompressionmethod' => { 114 => 0x6e },
	'dataimprint' => { 156 => 0x34 },
	'datascaling' => { 301 => 0x3d },
	'date' => { 301 => 0x6, 396 => 'date' },
	'dateacquired' => { 154 => 'DateAcquired' },
	'datecreated' => { 112 => 0x37, 407 => 'DateCreated' },
	'datedisplayformat' => { 220 => 0x3 },
	'dateidentified' => { 103 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 238 => '4.2' },
	'daterecieved' => { 410 => 'dateRecieved' },
	'datesent' => { 113 => 0x46 },
	'datestampmode' => { 54 => 0x1c },
	'datetime' => { 389 => 'datetime', 416 => 'DateTime' },
	'datetimedigitized' => { 399 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 88 => 0x0, 104 => 0x9003, 132 => 0x14, 135 => 'OriginalDate', 320 => 0xb, 399 => 'DateTimeOriginal' },
	'datetimestamp' => { 120 => 0x64 },
	'datetimeutc' => { 248 => 0x908 },
	'daylightsavings' => { 67 => 0x3, 220 => 0x2 },
	'dccontinent' => { 103 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 103 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 103 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 103 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 103 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 103 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 103 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 103 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 103 => 'Event' },
	'dcfootprintspatialfit' => { 103 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 103 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 103 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 103 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 103 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 103 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 103 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 103 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 103 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 103 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 103 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 103 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 103 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 103 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 103 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 103 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 103 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 143 => 'Declination' },
	'decposition' => { 156 => 0x32 },
	'defaultblackrender' => { 104 => 0xc7a6 },
	'defaultcroporigin' => { 104 => 0xc61f },
	'defaultcropsize' => { 104 => 0xc620 },
	'defaulteraseoption' => { 72 => 0x813 },
	'defaultscale' => { 104 => 0xc61e },
	'defaultusercrop' => { 104 => 0xc7b5 },
	'defringe' => { 395 => 'Defringe' },
	'defringegreenamount' => { 395 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 395 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 395 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 395 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 395 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 395 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 192 => 0xa6, 199 => 0x6e },
	'deprecatedon' => { 392 => 'deprecatedOn' },
	'derivedfrom' => { 421 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 421 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 421 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 421 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 421 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 421 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 421 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 421 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 421 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 421 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 421 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 421 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 421 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 421 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 421 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 421 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 421 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 421 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 260 => 'Description', 396 => 'description', 418 => 'Description' },
	'destination' => { 113 => 0x5 },
	'destinationcity' => { 301 => 0x24, 307 => 0x3 },
	'destinationcitycode' => { 308 => 0x1001 },
	'destinationdst' => { 301 => 0x26, 307 => '0.3' },
	'developmentdynamicrange' => { 109 => 0x1403 },
	'device' => { 410 => 'device' },
	'devicesettingdescription' => { 399 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 399 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 399 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 399 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 330 => 0x2 },
	'dialdirectiontvav' => { 72 => 0x706 },
	'dietaryneeds' => { 412 => 'dietaryNeeds' },
	'diffractioncorrection' => { 291 => 0x3 },
	'digitalcreationdate' => { 112 => 0x3e },
	'digitalcreationtime' => { 112 => 0x3f },
	'digitaldeehighlightadj' => { 198 => 0x202 },
	'digitaldeeshadowadj' => { 198 => 0x200 },
	'digitaldeethreshold' => { 198 => 0x201 },
	'digitalfilter' => { 333 => 0x59 },
	'digitalfilter01' => { 288 => 0x5 },
	'digitalfilter02' => { 288 => 0x16 },
	'digitalfilter03' => { 288 => 0x27 },
	'digitalfilter04' => { 288 => 0x38 },
	'digitalfilter05' => { 288 => 0x49 },
	'digitalfilter06' => { 288 => 0x5a },
	'digitalfilter07' => { 288 => 0x6b },
	'digitalfilter08' => { 288 => 0x7c },
	'digitalfilter09' => { 288 => 0x8d },
	'digitalfilter10' => { 288 => 0x9e },
	'digitalfilter11' => { 288 => 0xaf },
	'digitalfilter12' => { 288 => 0xc0 },
	'digitalfilter13' => { 288 => 0xd1 },
	'digitalfilter14' => { 288 => 0xe2 },
	'digitalfilter15' => { 288 => 0xf3 },
	'digitalfilter16' => { 288 => 0x104 },
	'digitalfilter17' => { 288 => 0x115 },
	'digitalfilter18' => { 288 => 0x126 },
	'digitalfilter19' => { 288 => 0x137 },
	'digitalfilter20' => { 288 => 0x148 },
	'digitalgain' => { 64 => 0xb },
	'digitalgem' => { 184 => 0x0 },
	'digitalice' => { 198 => 0x100 },
	'digitalimageguid' => { 405 => 'DigImageGUID' },
	'digitalroc' => { 196 => 0x0 },
	'digitalsourcefiletype' => { 405 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 405 => 'DigitalSourceType' },
	'digitalzoom' => { 30 => 0xc, 99 => 0xa, 120 => 0x68, 134 => 'DigitalZoom', 156 => 0xc, 192 => 0x86, 218 => 0xa, 253 => 0x204, 301 => 0x1e, 308 => 0xa, 332 => 0x204, 368 => 0x12, 369 => 0x12 },
	'digitalzoomon' => { 332 => 0x21b },
	'digitalzoomratio' => { 104 => 0xa404, 361 => 0x200, 363 => 0x21c, 399 => 'DigitalZoomRatio' },
	'director' => { 420 => 'director' },
	'directorphotography' => { 420 => 'directorPhotography' },
	'directory' => { 105 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 180 => 0x3 },
	'disclaimer' => { 260 => 'Disclaimer' },
	'discnumber' => { 420 => 'discNumber' },
	'dishtype' => { 412 => 'dishType' },
	'displayallafpoints' => { 72 => 0x514 },
	'displayaperture' => { 30 => 0x23 },
	'displayedunitsx' => { 314 => 0x2 },
	'displayedunitsy' => { 314 => 0x6 },
	'displayname' => { 409 => 'displayName' },
	'distance1' => { 120 => 0x28 },
	'distance2' => { 120 => 0x2c },
	'distance3' => { 120 => 0x30 },
	'distance4' => { 120 => 0x34 },
	'distortion' => { 330 => 0xa050 },
	'distortioncontrol' => { 199 => 0x10 },
	'distortioncorrection' => { 90 => 0x20705, 96 => 0x67, 248 => 0x50b, 271 => '7.1', 291 => 0x0, 375 => 0x601, 376 => 0x5b },
	'distortioncorrection2' => { 252 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 391 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 90 => '0x20705.0', 96 => 0x63 },
	'distortioncorrectionsetting' => { 352 => 0x2013 },
	'distortioneffect' => { 90 => 0x20709 },
	'distortionn' => { 271 => 0xc },
	'distortionparam02' => { 271 => 0x2 },
	'distortionparam04' => { 271 => 0x4 },
	'distortionparam08' => { 271 => 0x8 },
	'distortionparam09' => { 271 => 0x9 },
	'distortionparam11' => { 271 => 0xb },
	'distortionscale' => { 271 => 0x5 },
	'distributor' => { 410 => 'distributor' },
	'distributorproductid' => { 409 => 'distributorProductID' },
	'dloon' => { 90 => '0x20706.0', 96 => 0xdc },
	'dlosetting' => { 90 => 0x20706, 96 => 0xdd },
	'dlosettingapplied' => { 96 => 0xe4 },
	'dloshootingdistance' => { 96 => 0xde },
	'dloversion' => { 96 => 0xe5 },
	'dmcomment' => { 420 => 'comment' },
	'dngadobedata' => { 104 => 0xc634 },
	'dngbackwardversion' => { 104 => 0xc613 },
	'dnglensinfo' => { 104 => 0xc630 },
	'dngprivatedata' => { 104 => 0xc634 },
	'dngversion' => { 104 => 0xc612 },
	'document' => { 260 => 'Document' },
	'documentancestors' => { 407 => 'DocumentAncestors' },
	'documenthistory' => { 112 => 0xe7 },
	'documentid' => { 421 => 'DocumentID' },
	'documentname' => { 104 => 0x10d },
	'documentnotes' => { 112 => 0xe6 },
	'doi' => { 410 => 'doi' },
	'dotrange' => { 104 => 0x150 },
	'dpp' => { 389 => 'dpp' },
	'dr4cameramodel' => { 91 => 0x3 },
	'drivemode' => { 100 => 0x3103, 156 => 0x6, 159 => 0x1e, 162 => 0xe, 248 => 0x600, 301 => 0x34, 324 => 0x1002, 333 => 0x3, 340 => 0x4, 341 => 0x7e, 342 => 0x34 },
	'drivemode2' => { 159 => 0xa, 282 => 0x7, 351 => 0xe, 356 => 0x1 },
	'drivemodesetting' => { 342 => 0x4 },
	'dspfirmwareversion' => { 301 => 0x27 },
	'duration' => { 57 => 0x6a, 133 => 'Duration', 147 => 'Duration', 412 => 'duration', 420 => 'duration' },
	'durationscale' => { 420 => [\'duration','durationScale'] },
	'durationvalue' => { 420 => [\'duration','durationValue'] },
	'dustremovaldata' => { 54 => 0x97 },
	'dynamicafarea' => { 235 => '1.4', 241 => '1.4' },
	'dynamicareaafdisplay' => { 236 => '46.1', 245 => '47.1' },
	'dynamicrange' => { 109 => 0x1400 },
	'dynamicrangeexpansion' => { 301 => 0x69, 324 => 0x100e },
	'dynamicrangemax' => { 95 => 0x7c },
	'dynamicrangemin' => { 95 => 0x7a },
	'dynamicrangeoptimizer' => { 159 => 0x15, 352 => [0xb025,0xb04f], 359 => 0x1144, 360 => [0x1144,0x324], 361 => [0x1120,0x300], 362 => [0x119c,0x37c], 363 => [0x1178,0x328], 364 => [0x1030,0x50], 365 => [0x228,0x50], 366 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 351 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 340 => 0x19, 341 => 0x17, 342 => 0xd, 351 => 0x79, 356 => 0x5 },
	'dynamicrangeoptimizermode' => { 162 => 0x15, 340 => 0x18, 341 => 0x16, 351 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 159 => 0x27, 342 => 0xc, 356 => 0x4 },
	'dynamicrangesetting' => { 109 => 0x1402 },
	'e-dialinprogram' => { 282 => '1.3' },
	'earliestageorloweststage' => { 103 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 103 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 103 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 103 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 103 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 246 => '6.1' },
	'easyexposurecompensation' => { 235 => '6.4', 236 => '6.5', 241 => '4.4', 242 => '5.2', 245 => '6.3' },
	'easymode' => { 30 => 0xb },
	'edgenoisereduction' => { 229 => 0x4, 380 => 0x8028 },
	'edition' => { 410 => 'edition' },
	'editorialupdate' => { 112 => 0x8 },
	'editstatus' => { 112 => 0x7, 311 => 'EditStatus' },
	'editversionname' => { 228 => 0x3d136244 },
	'effectivelv' => { 301 => 0x2d },
	'effectivemaxaperture' => { 188 => 0x12, 189 => 0x13 },
	'eissn' => { 410 => 'eIssn' },
	'electronicfront-curtainshutter' => { 245 => '5.3' },
	'elevation' => { 143 => 'Elevation' },
	'email' => { 135 => 'EMail' },
	'embargodate' => { 413 => 'embargoDate' },
	'embdencrightsexpr' => { 405 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 405 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 405 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 405 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 407 => 'EmbeddedXMPDigest' },
	'emissivity' => { 106 => 0x3 },
	'encryptionkey' => { 330 => 0xa020 },
	'endingpage' => { 410 => 'endingPage' },
	'enduser' => { 408 => 'EndUser' },
	'enduserid' => { 408 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 408 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 420 => 'engineer' },
	'enhancedarktones' => { 221 => 0x8 },
	'enhancement' => { 99 => 0x16, 100 => 0x3016 },
	'enhancer' => { 252 => 0x300 },
	'enhancervalues' => { 252 => 0x301 },
	'envelopenumber' => { 113 => 0x28 },
	'envelopepriority' => { 113 => 0x3c },
	'enveloperecordversion' => { 113 => 0x0 },
	'epsonimageheight' => { 253 => 0x20c },
	'epsonimagewidth' => { 253 => 0x20b },
	'epsonsoftware' => { 253 => 0x20d },
	'equipmentinstitution' => { 382 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 382 => 'EquipmentManufacturer' },
	'equipmentversion' => { 249 => 0x0 },
	'ettlii' => { 72 => 0x304, 73 => 0xd, 74 => 0xe, 75 => 0x7, 76 => 0x7, 77 => 0xe },
	'event' => { 383 => 'Event', 387 => 'Event', 405 => 'Event', 410 => 'event' },
	'eventalias' => { 409 => 'eventAlias' },
	'eventday' => { 103 => [\'Event','EventDay'] },
	'eventearliestdate' => { 103 => [\'Event','EventEarliestDate'] },
	'eventend' => { 409 => 'eventEnd' },
	'eventenddayofyear' => { 103 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 103 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 103 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 103 => [\'Event','EventHabitat'] },
	'eventid' => { 103 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 103 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 103 => [\'Event','EventMonth'] },
	'eventnumber' => { 320 => 0x9 },
	'eventremarks' => { 103 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 103 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 103 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 409 => 'eventStart' },
	'eventstartdayofyear' => { 103 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 409 => 'eventSubtype' },
	'eventtime' => { 103 => [\'Event','EventEventTime'] },
	'eventtype' => { 409 => 'eventType' },
	'eventverbatimeventdate' => { 103 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 103 => [\'Event','EventYear'] },
	'evsteps' => { 282 => '1.2', 284 => 0x0 },
	'evstepsize' => { 238 => '5.1', 239 => '6.1', 240 => '6.1', 243 => '0.7' },
	'exclusivityenddate' => { 413 => 'exclusivityEndDate' },
	'excursiontolerance' => { 114 => 0x82 },
	'exif' => { 105 => 'EXIF' },
	'exifbyteorder' => { 105 => 'ExifByteOrder' },
	'exifcamerainfo' => { 112 => 0xe8 },
	'exifimageheight' => { 104 => 0xa003, 399 => 'PixelYDimension' },
	'exifimagewidth' => { 104 => 0xa002, 399 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 105 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 104 => 0x9000, 399 => 'ExifVersion' },
	'exitpupilposition' => { 188 => 0x4, 189 => 0x4 },
	'expirationdate' => { 112 => 0x25, 413 => 'expirationDate' },
	'expirationtime' => { 112 => 0x26 },
	'exposure' => { 104 => 0xfe51, 395 => 'Exposure' },
	'exposure2012' => { 395 => 'Exposure2012' },
	'exposureadj' => { 226 => 0x0 },
	'exposureadj2' => { 226 => 0x12 },
	'exposureadjust' => { 333 => 0xc },
	'exposurebracketingindicatorlast' => { 159 => 0x52 },
	'exposurebracketshotnumber' => { 162 => 0x2d, 351 => 0x2f },
	'exposurebracketstepsize' => { 282 => 0x8 },
	'exposurebracketvalue' => { 192 => 0x19 },
	'exposurecompensation' => { 66 => 0x6, 81 => 0x0, 104 => 0x9204, 120 => 0x24, 134 => 'ExposureComp', 152 => 'ExposureCompensation', 156 => 0xd, 157 => 0x53, 158 => 0x1e, 162 => 0x49c0, 253 => 0x1006, 301 => 0x16, 330 => 0xa013, 333 => [0xc,0x35,0x4d], 359 => 0x114c, 360 => 0x114c, 361 => 0x1128, 363 => 0x1180, 364 => 0x1038, 365 => 0x230, 366 => 0x230, 399 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 356 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 159 => 0x47, 162 => 0x2a },
	'exposurecompensationset' => { 340 => 0x3, 341 => 0x3, 342 => 0x3, 356 => 0x1e },
	'exposurecompensationsetting' => { 159 => 0x1 },
	'exposurecompstepsize' => { 235 => '6.3', 236 => '7.3', 241 => '4.3', 245 => '7.3' },
	'exposurecontrolstep' => { 242 => '6.1' },
	'exposurecontrolstepsize' => { 235 => '6.2', 236 => '7.1', 241 => '4.2', 245 => '7.1', 246 => '7.1' },
	'exposurecount' => { 109 => 0x1032 },
	'exposuredelaymode' => { 235 => '10.1', 236 => '11.1', 238 => '9.1', 239 => '10.1', 240 => '10.1', 241 => '10.4', 242 => '10.1', 243 => '6.4', 245 => '11.1', 246 => '11.2' },
	'exposuredifference' => { 192 => 0xe },
	'exposureindex' => { 104 => 0xa215, 399 => 'ExposureIndex' },
	'exposureindicator' => { 159 => 0x50 },
	'exposurelevelincrements' => { 70 => 0x6, 71 => 0x6, 72 => 0x101, 73 => 0x5, 74 => 0x6, 75 => 0x5, 76 => 0x5, 77 => 0x6, 78 => 0x4, 340 => 0x58, 341 => 0x58 },
	'exposurelockused' => { 384 => 'ExposureLockUsed' },
	'exposuremode' => { 104 => 0xa402, 134 => 'ExposureMode', 156 => 0x1, 157 => 0xa, 158 => 0x0, 159 => 0x0, 162 => 0x34, 248 => 0x200, 266 => 0x40d, 333 => 0x8, 352 => 0xb041, 399 => 'ExposureMode' },
	'exposuremodeinmanual' => { 72 => 0x10b },
	'exposureprogram' => { 104 => 0x8822, 324 => 0x1001, 334 => 0x17e, 340 => 0x3c, 341 => 0x3c, 342 => 0x5, 346 => 0x14, 351 => 0x3f, 356 => 0x2, 359 => 0x1175, 360 => 0x1179, 361 => 0x1155, 362 => 0x11d1, 363 => 0x11ad, 364 => 0x1065, 365 => 0x25d, 366 => 0x25d, 376 => 0x48, 399 => 'ExposureProgram' },
	'exposureshift' => { 248 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 66 => 0x16, 104 => 0x829a, 117 => 0xfd05, 120 => 0x20, 122 => 0xfa24, 124 => 0xf104, 127 => 0x12, 129 => 0x38, 132 => 0x10, 134 => 'ExposureTime', 156 => 0x9, 157 => 0x35, 158 => 0x48, 159 => 0x8, 162 => 0x49b8, 301 => 0x12, 330 => 0xa018, 333 => [0x32,0x4a], 340 => 0x0, 341 => 0x0, 356 => [0x21,0x23,0x27], 376 => 0x10, 399 => 'ExposureTime' },
	'exposuretime2' => { 333 => [0x33,0x4b] },
	'exposuretuning' => { 192 => 0x1c },
	'exposurevalue' => { 118 => 0x3 },
	'exposurewarning' => { 109 => 0x1302 },
	'exrauto' => { 109 => 0x1033 },
	'exrmode' => { 109 => 0x1034 },
	'extendedwbdetect' => { 248 => 0x902 },
	'extender' => { 249 => 0x301 },
	'extenderfirmwareversion' => { 249 => 0x304 },
	'extendermagnification' => { 136 => 'Magnification' },
	'extendermake' => { 136 => 'Make' },
	'extendermodel' => { 136 => 'Model', 249 => 0x303 },
	'extenderserialnumber' => { 136 => 'SerialNumber', 249 => 0x302 },
	'extenderstatus' => { 299 => 0x3 },
	'externalflash' => { 251 => 0x1201 },
	'externalflashae1' => { 253 => 0x101f },
	'externalflashae1_0' => { 253 => 0x101b },
	'externalflashae2' => { 253 => 0x1020 },
	'externalflashae2_0' => { 253 => 0x101c },
	'externalflashbounce' => { 251 => 0x1204, 253 => 0x1026, 289 => 0x1a },
	'externalflashcompensation' => { 183 => 0x1b },
	'externalflashexposurecomp' => { 192 => 0x17, 289 => 0x19 },
	'externalflashfirmware' => { 181 => 0x6, 182 => 0x6, 183 => 0x6 },
	'externalflashflags' => { 181 => 0x8, 182 => 0x8, 183 => 0x8 },
	'externalflashguidenumber' => { 251 => 0x1203, 289 => '24.1' },
	'externalflashgvalue' => { 253 => 0x1025 },
	'externalflashmode' => { 253 => 0x1028, 289 => 0x2 },
	'externalflashzoom' => { 251 => 0x1205, 253 => 0x1027 },
	'externalsensorbrightnessvalue' => { 264 => 0x311, 270 => 0x3408 },
	'extrainfoversion' => { 344 => 0x1a },
	'eyestartaf' => { 159 => 0x40 },
	'face10position' => { 97 => 0x3f4, 98 => 0x1ec, 179 => 0x28, 286 => 0x12 },
	'face10size' => { 287 => 0x12 },
	'face11position' => { 179 => 0x2c, 286 => 0x14 },
	'face11size' => { 287 => 0x14 },
	'face12position' => { 179 => 0x30, 286 => 0x16 },
	'face12size' => { 287 => 0x16 },
	'face13position' => { 286 => 0x18 },
	'face13size' => { 287 => 0x18 },
	'face14position' => { 286 => 0x1a },
	'face14size' => { 287 => 0x1a },
	'face15position' => { 286 => 0x1c },
	'face15size' => { 287 => 0x1c },
	'face16position' => { 286 => 0x1e },
	'face16size' => { 287 => 0x1e },
	'face17position' => { 286 => 0x20 },
	'face17size' => { 287 => 0x20 },
	'face18position' => { 286 => 0x22 },
	'face18size' => { 287 => 0x22 },
	'face19position' => { 286 => 0x24 },
	'face19size' => { 287 => 0x24 },
	'face1position' => { 45 => 0x8, 97 => 0xd, 98 => 0x18, 179 => 0x4, 262 => 0x1, 286 => 0x0, 321 => 0xbc, 347 => 0x1, 348 => 0x0, 349 => 0x0, 350 => 0x5b },
	'face1size' => { 287 => 0x0 },
	'face20position' => { 286 => 0x26 },
	'face20size' => { 287 => 0x26 },
	'face21position' => { 286 => 0x28 },
	'face21size' => { 287 => 0x28 },
	'face22position' => { 286 => 0x2a },
	'face22size' => { 287 => 0x2a },
	'face23position' => { 286 => 0x2c },
	'face23size' => { 287 => 0x2c },
	'face24position' => { 286 => 0x2e },
	'face24size' => { 287 => 0x2e },
	'face25position' => { 286 => 0x30 },
	'face25size' => { 287 => 0x30 },
	'face26position' => { 286 => 0x32 },
	'face26size' => { 287 => 0x32 },
	'face27position' => { 286 => 0x34 },
	'face27size' => { 287 => 0x34 },
	'face28position' => { 286 => 0x36 },
	'face28size' => { 287 => 0x36 },
	'face29position' => { 286 => 0x38 },
	'face29size' => { 287 => 0x38 },
	'face2position' => { 45 => 0xa, 97 => 0x7c, 98 => 0x4c, 179 => 0x8, 262 => 0x5, 286 => 0x2, 321 => 0xc8, 347 => 0x6, 348 => 0x20, 349 => 0x25, 350 => 0x65 },
	'face2size' => { 287 => 0x2 },
	'face30position' => { 286 => 0x3a },
	'face30size' => { 287 => 0x3a },
	'face31position' => { 286 => 0x3c },
	'face31size' => { 287 => 0x3c },
	'face32position' => { 286 => 0x3e },
	'face32size' => { 287 => 0x3e },
	'face3position' => { 45 => 0xc, 97 => 0xeb, 98 => 0x80, 179 => 0xc, 262 => 0x9, 286 => 0x4, 321 => 0xd4, 347 => 0xb, 348 => 0x40, 349 => 0x4a, 350 => 0x6f },
	'face3size' => { 287 => 0x4 },
	'face4position' => { 45 => 0xe, 97 => 0x15a, 98 => 0xb4, 179 => 0x10, 262 => 0xd, 286 => 0x6, 321 => 0xe0, 347 => 0x10, 348 => 0x60, 349 => 0x6f, 350 => 0x79 },
	'face4size' => { 287 => 0x6 },
	'face5position' => { 45 => 0x10, 97 => 0x1c9, 98 => 0xe8, 179 => 0x14, 262 => 0x11, 286 => 0x8, 321 => 0xec, 347 => 0x15, 348 => 0x80, 349 => 0x94 },
	'face5size' => { 287 => 0x8 },
	'face6position' => { 45 => 0x12, 97 => 0x238, 98 => 0x11c, 179 => 0x18, 286 => 0xa, 321 => 0xf8, 347 => 0x1a, 348 => 0xa0, 349 => 0xb9 },
	'face6size' => { 287 => 0xa },
	'face7position' => { 45 => 0x14, 97 => 0x2a7, 98 => 0x150, 179 => 0x1c, 286 => 0xc, 321 => 0x104, 347 => 0x1f, 348 => 0xc0, 349 => 0xde },
	'face7size' => { 287 => 0xc },
	'face8position' => { 45 => 0x16, 97 => 0x316, 98 => 0x184, 179 => 0x20, 286 => 0xe, 321 => 0x110, 347 => 0x24, 348 => 0xe0, 349 => 0x103 },
	'face8size' => { 287 => 0xe },
	'face9position' => { 45 => 0x18, 97 => 0x385, 98 => 0x1b8, 179 => 0x24, 286 => 0x10 },
	'face9size' => { 287 => 0x10 },
	'facedetect' => { 301 => 0x76, 330 => 0x100 },
	'facedetectarea' => { 252 => 0x1201 },
	'facedetectframecrop' => { 252 => 0x1207 },
	'facedetectframesize' => { 45 => 0x3, 97 => 0x1, 98 => 0x4, 179 => 0x1, 252 => 0x1203, 301 => 0x77, 321 => 0xb6 },
	'facedetection' => { 342 => 0x30, 356 => 0x19 },
	'faceid' => { 390 => 'FaceID' },
	'faceinfounknown' => { 100 => 0x2089 },
	'facename' => { 330 => 0x123 },
	'faceorientation' => { 98 => 0x8 },
	'faceposition' => { 285 => 0x2, 331 => 0x4 },
	'facepositions' => { 109 => 0x4103 },
	'facerecognition' => { 330 => 0x120 },
	'facesdetected' => { 45 => 0x2, 46 => 0x2, 47 => 0x3, 97 => 0x0, 98 => 0x2, 100 => 0x211c, 109 => 0x4100, 179 => 0x3, 252 => 0x1200, 268 => 0x3f, 285 => 0x0, 321 => 0xb5, 331 => 0x0, 347 => 0x0, 350 => 0x3, 358 => 0x30 },
	'facesrecognized' => { 263 => 0x0 },
	'facewidth' => { 46 => 0x1 },
	'faithfuloutputhighlightpoint' => { 96 => 0x38 },
	'faithfuloutputshadowpoint' => { 96 => 0x39 },
	'faithfulrawcolortone' => { 96 => 0x31 },
	'faithfulrawcontrast' => { 96 => 0x33 },
	'faithfulrawhighlight' => { 96 => 0x79 },
	'faithfulrawhighlightpoint' => { 96 => 0x36 },
	'faithfulrawlinear' => { 96 => 0x34 },
	'faithfulrawsaturation' => { 96 => 0x32 },
	'faithfulrawshadow' => { 96 => 0x82 },
	'faithfulrawshadowpoint' => { 96 => 0x37 },
	'faithfulrawsharpness' => { 96 => 0x35 },
	'faithfulunsharpmaskfineness' => { 96 => 0xac },
	'faithfulunsharpmaskstrength' => { 96 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 96 => 0xae },
	'femicroadjustment' => { 72 => 0x111 },
	'ffid' => { 397 => 'ffid' },
	'field' => { 409 => 'field' },
	'fieldcount' => { 253 => 0x103f },
	'filecreatedate' => { 105 => 'FileCreateDate' },
	'filedatarate' => { 420 => 'fileDataRate' },
	'fileformat' => { 83 => 0x0, 113 => 0x14, 333 => [0x22,0x26], 352 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 269 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 105 => 'FileModifyDate' },
	'filename' => { 105 => 'FileName' },
	'filenameasdelivered' => { 408 => 'FileNameAsDelivered' },
	'filenumber' => { 48 => 0x1, 54 => 0x8, 85 => 0x1817, 101 => 'FileNumber', 180 => 0x4 },
	'filenumbermemory' => { 156 => 0x1a },
	'filenumbersequence' => { 235 => '12.2', 238 => '3.1', 239 => '4.1', 240 => '4.1', 241 => '11.1', 242 => '4.3', 246 => '5.2' },
	'filesource' => { 104 => 0xa300, 109 => 0x8000, 399 => 'FileSource' },
	'fileversion' => { 113 => 0x16 },
	'fillflashautoreduction' => { 70 => 0xe, 71 => 0xe, 78 => 0xa },
	'filllight' => { 395 => 'FillLight' },
	'fillorder' => { 104 => 0x10a },
	'filmmode' => { 109 => 0x1401, 266 => 0x412, 268 => 0x42 },
	'filmtype' => { 198 => 0x2 },
	'filtereffect' => { 48 => 0xe, 194 => 0x37 },
	'filtereffectauto' => { 61 => 0xa0 },
	'filtereffectfaithful' => { 60 => 0x70, 61 => 0x70 },
	'filtereffectlandscape' => { 60 => 0x40, 61 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 60 => 0x88, 61 => 0x88 },
	'filtereffectneutral' => { 60 => 0x58, 61 => 0x58 },
	'filtereffectportrait' => { 60 => 0x28, 61 => 0x28 },
	'filtereffectstandard' => { 60 => 0x10, 61 => 0x10 },
	'filtereffectuserdef1' => { 60 => 0xa0, 61 => 0xb8 },
	'filtereffectuserdef2' => { 60 => 0xb8, 61 => 0xd0 },
	'filtereffectuserdef3' => { 60 => 0xd0, 61 => 0xe8 },
	'finderdisplayduringexposure' => { 71 => 0x1 },
	'finesharpness' => { 301 => 0x70 },
	'finetuneoptcenterweighted' => { 235 => '7.2', 236 => '9.1', 245 => '9.1', 246 => '9.1' },
	'finetuneopthighlightweighted' => { 245 => '46.1' },
	'finetuneoptmatrixmetering' => { 235 => '8.1', 236 => '8.2', 241 => '6.1', 245 => '8.2', 246 => '8.2' },
	'finetuneoptspotmetering' => { 235 => '8.2', 236 => '9.2', 241 => '6.2', 245 => '9.2', 246 => '9.2' },
	'firmware' => { 253 => 0x405, 333 => [0x17,0x3b,0x57], 391 => 'Firmware' },
	'firmwaredate' => { 99 => 0x15, 100 => 0x2001, 320 => 0x4 },
	'firmwareid' => { 163 => 0x0 },
	'firmwarename' => { 330 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 54 => 0x1e, 322 => 0x0 },
	'firmwarerevision2' => { 322 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 118 => 0xce5, 132 => 0x57, 134 => 'FirmwareVersion', 268 => 0x2, 270 => 0x3109, 301 => 0x230, 324 => 0x2 },
	'firstphotodate' => { 384 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 408 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 112 => 0x16 },
	'flash' => { 101 => 'Flash', 104 => 0x9209, 157 => 0x1f, 158 => 0x15, 399 => 'Flash' },
	'flashaction' => { 340 => 0x3e, 341 => 0x3e, 352 => 0x2017, 356 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 340 => 0x4c, 341 => 0x4c, 356 => 0x77 },
	'flashactionexternal' => { 356 => [0x78,0x7c] },
	'flashactivity' => { 30 => 0x1c },
	'flashbatterylevel' => { 36 => 0x249 },
	'flashbias' => { 268 => 0x24 },
	'flashbits' => { 30 => 0x1d },
	'flashbuttonfunction' => { 72 => 0x70e },
	'flashchargelevel' => { 253 => 0x1010 },
	'flashcolorfilter' => { 183 => 0x10 },
	'flashcommandermode' => { 181 => '9.1', 182 => '9.1', 183 => '9.1' },
	'flashcompensation' => { 181 => 0xa, 182 => 0xa, 183 => 0xa, 391 => 'FlashCompensation' },
	'flashcontrol' => { 340 => 0x23, 341 => 0x1f, 342 => 0x21 },
	'flashcontrolbuilt-in' => { 241 => '16.1', 242 => '23.1', 244 => '23.1', 245 => '24.1' },
	'flashcontrolmode' => { 181 => '9.2', 182 => '9.2', 183 => '9.2', 248 => 0x404 },
	'flashcurtain' => { 268 => 0x48 },
	'flashdefault' => { 159 => 0x42 },
	'flashdevice' => { 253 => 0x1005 },
	'flashdistance' => { 100 => 0x2034 },
	'flashenergy' => { 104 => 0xa20b, 399 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 192 => 0x18 },
	'flashexposurecomp' => { 66 => 0xf, 109 => 0x1011, 137 => 'ExposureComp', 156 => 0x23, 161 => 0x104, 162 => 0x49c1, 192 => 0x12, 248 => 0x401, 253 => 0x1023, 301 => 0x4d, 324 => 0x100b, 333 => [0x3a,0x56], 352 => 0x104 },
	'flashexposurecomp2' => { 215 => 0x4d2 },
	'flashexposurecomp3' => { 183 => 0x1d },
	'flashexposurecomp4' => { 183 => 0x27 },
	'flashexposurecomparea' => { 236 => '38.4', 245 => '38.4' },
	'flashexposurecompset' => { 159 => 0x10, 275 => 0xe, 340 => 0x14, 341 => 0x12, 342 => 0x23, 356 => 0x1f },
	'flashexposurecompset2' => { 356 => [0x26,0x2c] },
	'flashexposureindicator' => { 159 => 0x54 },
	'flashexposureindicatorlast' => { 159 => 0x56 },
	'flashexposureindicatornext' => { 159 => 0x55 },
	'flashexposurelock' => { 48 => 0x19 },
	'flashfired' => { 120 => 0x5d, 137 => 'Fired', 156 => 0x14, 214 => '590.3', 268 => 0x8007, 399 => [\'Flash','FlashFired'] },
	'flashfiring' => { 72 => 0x306, 73 => 0x6, 74 => 0x7, 77 => 0x7 },
	'flashfirmwareversion' => { 249 => 0x1002 },
	'flashfocallength' => { 181 => 0xb, 182 => 0xc, 183 => 0xc },
	'flashfunction' => { 162 => 0x31, 399 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 181 => 0xe, 182 => 0xf, 183 => 0xf },
	'flashgroupacompensation' => { 181 => 0x11, 182 => 0x12, 183 => 0x13 },
	'flashgroupacontrolmode' => { 181 => 0xf, 182 => '16.1', 183 => '17.1' },
	'flashgroupaoutput' => { 181 => 0x11, 182 => 0x12, 183 => 0x13 },
	'flashgroupbcompensation' => { 181 => 0x12, 182 => 0x13, 183 => 0x14 },
	'flashgroupbcontrolmode' => { 181 => 0x10, 182 => '17.1', 183 => '18.1' },
	'flashgroupboutput' => { 181 => 0x12, 182 => 0x13, 183 => 0x14 },
	'flashgroupccompensation' => { 182 => 0x14, 183 => 0x15 },
	'flashgroupccontrolmode' => { 182 => '17.2', 183 => '18.2' },
	'flashgroupcoutput' => { 182 => 0x14, 183 => 0x15 },
	'flashguidenumber' => { 66 => 0xd, 82 => 0x0, 137 => 'GuideNumber' },
	'flashintensity' => { 99 => [0x19,0x5], 248 => 0x405 },
	'flashlevel' => { 237 => 0x9, 352 => 0xb048 },
	'flashmake' => { 137 => 'Make' },
	'flashmanufacturer' => { 154 => 'FlashManufacturer' },
	'flashmetering' => { 156 => 0x3f, 159 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 301 => 0x20a },
	'flashmode' => { 99 => 0x4, 120 => 0x5c, 137 => 'Mode', 156 => 0x2, 157 => 0x20, 158 => 0x16, 159 => 0xf, 192 => 0x87, 248 => 0x400, 253 => 0x1004, 301 => 0xc, 308 => 0x4, 323 => 0x20, 324 => 0x100a, 332 => 0x225, 340 => 0x13, 341 => 0x7f, 342 => 0x20, 356 => 0x10, 359 => 0x1138, 360 => 0x1138, 361 => 0x1114, 362 => 0x1190, 363 => 0x116c, 364 => 0x1024, 365 => 0x21c, 366 => 0x21c, 399 => [\'Flash','FlashMode'] },
	'flashmodel' => { 137 => 'Model', 154 => 'FlashModel', 249 => 0x1001 },
	'flashoptions' => { 282 => 0x2 },
	'flashoptions2' => { 282 => 0x10 },
	'flashoutput' => { 36 => 0x248, 66 => 0x21, 181 => 0xa, 182 => 0xa, 183 => 0xa },
	'flashpixversion' => { 104 => 0xa000, 399 => 'FlashpixVersion' },
	'flashredeyemode' => { 399 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 248 => 0x403 },
	'flashreturn' => { 399 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 137 => 'SerialNumber', 249 => 0x1003 },
	'flashsetting' => { 192 => 0x8 },
	'flashshutterspeed' => { 235 => '20.2', 236 => '23.2', 241 => '15.2', 242 => '22.2', 243 => '7.2', 244 => '22.2', 245 => '23.2', 246 => '23.1' },
	'flashsource' => { 181 => 0x4, 182 => 0x4, 183 => 0x4 },
	'flashstatus' => { 289 => 0x0, 356 => [0x82,0x86], 367 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 342 => [0x87,0x287] },
	'flashstatusexternal' => { 342 => [0x88,0x288] },
	'flashsyncspeed' => { 235 => '20.1', 236 => '23.1', 241 => '15.1', 242 => '22.1', 244 => '22.1', 245 => '23.1' },
	'flashsyncspeedav' => { 70 => 0x3, 72 => 0x10f, 73 => 0x2, 74 => 0x3, 75 => 0x2, 76 => 0x2, 77 => 0x3, 78 => 0x6 },
	'flashthreshold' => { 82 => 0x1 },
	'flashtype' => { 137 => 'Type', 159 => 0x59, 192 => 0x9, 249 => 0x1000 },
	'flashwarning' => { 242 => '30.1', 243 => '7.1', 246 => '31.1', 268 => 0x62 },
	'flexiblespotposition' => { 352 => 0x201d },
	'flickerreduce' => { 332 => 0x218 },
	'fliphorizontal' => { 228 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 66 => 0x15, 104 => 0x829d, 117 => 0xfd04, 120 => 0x1e, 122 => 0xfa23, 124 => 0xf103, 127 => 0x13, 129 => 0x3c, 132 => 0xc, 141 => 'FNumber', 156 => 0xa, 157 => 0x36, 158 => 0x47, 159 => 0x9, 162 => 0x49c7, 301 => 0x13, 330 => 0xa019, 333 => [0x31,0x49], 340 => 0x1, 341 => 0x1, 356 => [0x20,0x22,0x26], 399 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 50 => 0x1, 100 => 0x1d, 104 => 0x920a, 127 => 0x1d, 141 => 'FocalLength', 156 => 0x12, 188 => 0xa, 189 => 0xb, 301 => 0x1d, 324 => 0x1500, 339 => 0xe, 363 => 0x1278, 364 => 0x1134, 365 => 0x32c, 366 => 0x32c, 399 => 'FocalLength' },
	'focallength2' => { 356 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 104 => 0xa405, 330 => 0xa01a, 399 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 339 => 0x10 },
	'focalplanediagonal' => { 249 => 0x103, 253 => 0x205 },
	'focalplaneresolutionunit' => { 104 => 0xa210, 399 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 104 => 0xa20e, 399 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 50 => 0x2 },
	'focalplanexunknown' => { 50 => 0x2 },
	'focalplaneyresolution' => { 104 => 0xa20f, 399 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 50 => 0x3 },
	'focalplaneyunknown' => { 50 => 0x3 },
	'focaltype' => { 9 => 0x2d, 50 => 0x0 },
	'focalunits' => { 30 => 0x19 },
	'focus' => { 218 => 0x8 },
	'focusarea' => { 156 => 0x31 },
	'focusareaselection' => { 243 => '15.2' },
	'focuscontinuous' => { 30 => 0x20 },
	'focusdisplayaiservoandmf' => { 72 => 0x515 },
	'focusdistance' => { 141 => 'FocusDistance', 156 => 0x13, 162 => 0x49bb, 188 => 0x9, 189 => 0xa, 251 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 48 => 0x15, 66 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 48 => 0x14, 66 => 0x13 },
	'focusholdbutton' => { 159 => 0x44 },
	'focusinfoversion' => { 251 => 0x0 },
	'focusingscreen' => { 71 => 0x0, 72 => 0x80b, 77 => 0x0 },
	'focuslocked' => { 155 => 0x14 },
	'focusmode' => { 30 => 0x7, 99 => 0x3, 100 => [0x3003,0xd], 109 => 0x1021, 120 => 0x38, 134 => 'FocusMode', 156 => 0x30, 158 => 0xe, 159 => 0xc, 192 => 0x7, 248 => 0x301, 253 => 0x100b, 268 => 0x7, 301 => 0xd, 308 => 0x3, 324 => 0x1006, 334 => [0xb,0x5], 339 => [0x15,0x1d], 340 => 0x4d, 341 => 0x4d, 352 => [0xb042,0xb04e,0x201b], 356 => 0x13, 371 => 0x16 },
	'focusmode2' => { 282 => '3.1', 356 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 237 => '10.1', 337 => 0x14, 338 => 0x15, 340 => 0x10, 341 => 0xf, 342 => 0x6 },
	'focusmodeswitch' => { 159 => 0x58, 340 => 0x2e },
	'focuspixel' => { 109 => 0x1023 },
	'focuspointwrap' => { 235 => '2.2', 236 => '2.2', 241 => '2.2', 242 => '1.2', 245 => '2.2', 246 => '2.5' },
	'focusposition' => { 188 => 0x8, 189 => 0x8, 301 => 0x10, 351 => 0x9bb },
	'focusposition2' => { 356 => [0x29,0x2b,0x2f], 371 => 0x2d, 374 => 0x20 },
	'focusprocess' => { 248 => 0x302 },
	'focusrange' => { 30 => 0x12, 253 => 0x100a },
	'focusrangeindex' => { 292 => '3.1' },
	'focussetting' => { 333 => 0x6 },
	'focusstatus' => { 339 => 0x19, 340 => 0x53, 341 => 0x53 },
	'focusstepcount' => { 251 => 0x301, 253 => 0x100e },
	'focusstepinfinity' => { 251 => 0x303, 253 => 0x103b },
	'focusstepnear' => { 251 => 0x304, 253 => 0x103c },
	'focustrackinglockon' => { 235 => ['1.5','4.1'], 236 => '1.4', 241 => '3.1', 242 => '0.4', 245 => '1.4' },
	'focuswarning' => { 109 => 0x1301 },
	'foldername' => { 156 => 0x27 },
	'foldernumber' => { 340 => 0x9a, 342 => [0x402,0x114,0x316] },
	'fontcomposite' => { 425 => [\'Fonts','FontsComposite'] },
	'fontface' => { 425 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 425 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 425 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 425 => [\'Fonts','FontsFontName'] },
	'fonts' => { 425 => 'Fonts' },
	'fonttype' => { 425 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 425 => [\'Fonts','FontsVersionString'] },
	'for' => { 315 => 'For' },
	'format' => { 396 => 'format', 418 => 'Format' },
	'forwardlock' => { 415 => 'forwardlock' },
	'forwardmatrix1' => { 104 => 0xc714 },
	'forwardmatrix2' => { 104 => 0xc715 },
	'framecount' => { 57 => [0x2,0x4] },
	'frameheight' => { 109 => 0x3822 },
	'framenum' => { 310 => 0xd7 },
	'framenumber' => { 109 => 0x8003, 162 => 0x3c, 301 => 0x29 },
	'framerate' => { 57 => [0x1,0x6], 104 => 0xc764, 109 => 0x3820 },
	'framewidth' => { 109 => 0x3821 },
	'framing' => { 409 => 'framing' },
	'freebytes' => { 85 => 0x1 },
	'freememorycardimages' => { 157 => [0x37,0x54], 158 => [0x2d,0x4a], 159 => 0x32 },
	'fujiflashmode' => { 109 => 0x1010 },
	'fullimagesize' => { 352 => 0xb02b },
	'fullpanoheightpixels' => { 384 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 384 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 324 => 0x100d },
	'fullsizeimage' => { 140 => 'data' },
	'fullsizeimagename' => { 140 => '1Name' },
	'fullsizeimagetype' => { 140 => '0Type' },
	'funcbutton' => { 235 => ['14.1','15.1'], 236 => '14.1', 241 => '28.1', 242 => '13.1', 245 => '14.1', 246 => '14.1' },
	'funcbuttonplusdials' => { 235 => ['14.2','15.2'], 236 => '14.2', 241 => '31.1', 245 => '42.1' },
	'functionbutton' => { 240 => '13.1', 243 => '5.2' },
	'gainbase' => { 252 => 0x610 },
	'gaincontrol' => { 104 => 0xa407, 399 => 'GainControl' },
	'gamma' => { 104 => 0xa500, 400 => 'Gamma' },
	'gammablackpoint' => { 92 => 0xc },
	'gammacolortone' => { 92 => 0x3 },
	'gammacompensatedvalue' => { 114 => 0x91 },
	'gammacontrast' => { 92 => 0x2 },
	'gammacurveoutputrange' => { 92 => 0xf },
	'gammahighlight' => { 92 => 0xa },
	'gammalinear' => { 90 => 0x20200 },
	'gammamidpoint' => { 92 => 0xe },
	'gammasaturation' => { 92 => 0x4 },
	'gammashadow' => { 92 => 0x9 },
	'gammasharpnessstrength' => { 92 => 0x8 },
	'gammaunsharpmaskfineness' => { 92 => 0x6 },
	'gammaunsharpmaskstrength' => { 92 => 0x5 },
	'gammaunsharpmaskthreshold' => { 92 => 0x7 },
	'gammawhitepoint' => { 92 => 0xd },
	'geimagesize' => { 109 => 0x1304 },
	'gemake' => { 110 => 0x300 },
	'gemodel' => { 110 => 0x207 },
	'genre' => { 410 => 'genre', 420 => 'genre' },
	'geography' => { 411 => 'geography' },
	'geologicalcontext' => { 103 => 'GeologicalContext' },
	'geologicalcontextbed' => { 103 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 103 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 103 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 103 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 103 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 105 => 'Geosync' },
	'geotag' => { 105 => 'Geotag' },
	'geotiffasciiparams' => { 104 => 0x87b1 },
	'geotiffdirectory' => { 104 => 0x87af },
	'geotiffdoubleparams' => { 104 => 0x87b0 },
	'geotime' => { 105 => 'Geotime' },
	'globalaltitude' => { 313 => 0x419 },
	'globalangle' => { 313 => 0x40d },
	'good' => { 420 => 'good' },
	'googleplusuploadcode' => { 104 => 0x9009 },
	'gpsaltitude' => { 111 => 0x6, 138 => 'Altitude', 399 => 'GPSAltitude' },
	'gpsaltituderef' => { 111 => 0x5, 399 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 111 => 0x1c, 399 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 111 => 0x1d },
	'gpsdatetime' => { 138 => 'DateTime', 399 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 111 => 0x18, 138 => 'Bearing', 399 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 111 => 0x17, 399 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 111 => 0x1a, 138 => 'Distance', 399 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 111 => 0x19, 399 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 111 => 0x14, 399 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 111 => 0x13 },
	'gpsdestlongitude' => { 111 => 0x16, 399 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 111 => 0x15 },
	'gpsdifferential' => { 111 => 0x1e, 138 => 'Differential', 399 => 'GPSDifferential' },
	'gpsdop' => { 111 => 0xb, 399 => 'GPSDOP' },
	'gpshpositioningerror' => { 111 => 0x1f, 399 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 111 => 0x11, 399 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 111 => 0x10, 399 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 111 => 0x2, 138 => 'Latitude', 399 => 'GPSLatitude' },
	'gpslatituderef' => { 111 => 0x1 },
	'gpslongitude' => { 111 => 0x4, 138 => 'Longitude', 399 => 'GPSLongitude' },
	'gpslongituderef' => { 111 => 0x3 },
	'gpsmapdatum' => { 111 => 0x12, 138 => 'Datum', 399 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 111 => 0xa, 138 => 'MeasureMode', 399 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 111 => 0x1b, 399 => 'GPSProcessingMethod' },
	'gpssatellites' => { 111 => 0x8, 138 => 'Satellites', 399 => 'GPSSatellites' },
	'gpsspeed' => { 111 => 0xd, 138 => 'Speed', 399 => 'GPSSpeed' },
	'gpsspeedref' => { 111 => 0xc, 399 => 'GPSSpeedRef' },
	'gpsstatus' => { 111 => 0x9, 399 => 'GPSStatus' },
	'gpstimestamp' => { 111 => 0x7 },
	'gpstrack' => { 111 => 0xf, 138 => 'Heading', 399 => 'GPSTrack' },
	'gpstrackref' => { 111 => 0xe, 399 => 'GPSTrackRef' },
	'gpsversionid' => { 111 => 0x0, 399 => 'GPSVersionID' },
	'gradation' => { 248 => 0x50f },
	'gradientbasedcorractive' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 395 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 395 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 395 => 'GrainAmount' },
	'grainfrequency' => { 395 => 'GrainFrequency' },
	'grainsize' => { 395 => 'GrainSize' },
	'graymixeraqua' => { 395 => 'GrayMixerAqua' },
	'graymixerblue' => { 395 => 'GrayMixerBlue' },
	'graymixergreen' => { 395 => 'GrayMixerGreen' },
	'graymixermagenta' => { 395 => 'GrayMixerMagenta' },
	'graymixerorange' => { 395 => 'GrayMixerOrange' },
	'graymixerpurple' => { 395 => 'GrayMixerPurple' },
	'graymixerred' => { 395 => 'GrayMixerRed' },
	'graymixeryellow' => { 395 => 'GrayMixerYellow' },
	'graypoint' => { 380 => 0x8021 },
	'grayresponseunit' => { 104 => 0x122 },
	'greencurvelimits' => { 95 => 0x1c4 },
	'greencurvepoints' => { 94 => 0x53, 95 => 0x19a },
	'greenhsl' => { 90 => 0x20912 },
	'greenhue' => { 395 => 'GreenHue' },
	'greensaturation' => { 395 => 'GreenSaturation' },
	'griddisplay' => { 235 => '13.3', 236 => '4.3', 238 => '2.2', 241 => '10.5', 242 => '3.4', 243 => '6.1', 245 => '4.4', 246 => '4.2' },
	'gripbatteryadload' => { 280 => 0x5 },
	'gripbatteryadnoload' => { 280 => 0x4 },
	'gripbatterystate' => { 280 => '1.2' },
	'groupareaafillumination' => { 236 => '46.4', 245 => '47.4' },
	'halftonehints' => { 104 => 0x141 },
	'hardlink' => { 105 => 'HardLink' },
	'hasalternative' => { 410 => 'hasAlternative' },
	'hascorrection' => { 410 => 'hasCorrection' },
	'hascorrectiona-lang' => { 410 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 410 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 410 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 395 => 'HasCrop' },
	'hasextendedxmp' => { 422 => 'HasExtendedXMP' },
	'hassettings' => { 395 => 'HasSettings' },
	'hastranslation' => { 410 => 'hasTranslation' },
	'hdr' => { 51 => 0x1, 185 => 0x4, 268 => 0x9e, 301 => 0x85, 352 => 0x200a },
	'hdreffect' => { 51 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 185 => 0x0 },
	'hdrlevel' => { 185 => 0x5, 342 => 0x2e, 356 => 0x17 },
	'hdrlevel2' => { 185 => 0x7 },
	'hdrsetting' => { 342 => 0x2d, 356 => 0x16, 359 => 0x1148, 360 => 0x1148, 361 => 0x1124, 362 => 0x11a0, 363 => 0x117c, 364 => 0x1034, 365 => 0x22c, 366 => 0x22c },
	'hdrsmoothing' => { 185 => 0x6 },
	'headline' => { 112 => 0x69, 407 => 'Headline' },
	'hierarchicalkeywords' => { 149 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 149 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 149 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 149 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 149 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 386 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 103 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 272 => 0x1a },
	'highisomultipliergreen' => { 272 => 0x19 },
	'highisomultiplierred' => { 272 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 53 => 0x5, 72 => 0x202, 109 => 0x100e, 192 => 0xb1, 301 => 0x71, 340 => 0x2c, 341 => 0x26, 342 => 0x26, 352 => 0x2009, 356 => 0x12, 376 => 0x42 },
	'highisonoisereduction2' => { 352 => 0xb050 },
	'highlight' => { 333 => 0xf },
	'highlightadj' => { 90 => 0x2030c },
	'highlightcolordistortreduct' => { 380 => 0x8026 },
	'highlightprotection' => { 227 => 0x6 },
	'highlightrecovery' => { 395 => 'HighlightRecovery' },
	'highlights' => { 388 => 'Highlights' },
	'highlights2012' => { 395 => 'Highlights2012' },
	'highlighttone' => { 109 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 53 => 0x3, 72 => 0x203 },
	'highlowkeyadj' => { 301 => 0x6c },
	'highspeedsync' => { 159 => 0x5, 340 => 0x2, 341 => 0x2 },
	'histogramxml' => { 228 => 0x83a1a25 },
	'history' => { 407 => 'History', 421 => 'History' },
	'historyaction' => { 421 => [\'History','HistoryAction'] },
	'historychanged' => { 421 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 421 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 421 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 421 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 421 => [\'History','HistoryWhen'] },
	'hometowncity' => { 100 => 0x3006, 301 => 0x23, 307 => 0x2 },
	'hometowncitycode' => { 308 => 0x1000 },
	'hometowndst' => { 301 => 0x25, 307 => '0.2' },
	'hostcomputer' => { 104 => 0x13c },
	'hue' => { 164 => 0x3b, 301 => 0x67 },
	'hueadj' => { 231 => 0x2f, 380 => 0x8019 },
	'hueadjust' => { 324 => 0x1016 },
	'hueadjustment' => { 157 => 0x4a, 158 => 0x40, 192 => 0x92, 194 => 0x36 },
	'hueadjustmentaqua' => { 395 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 395 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 395 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 395 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 395 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 395 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 395 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 395 => 'HueAdjustmentYellow' },
	'huesetting' => { 256 => 0x1011 },
	'icc_profile' => { 105 => 'ICC_Profile' },
	'iccprofilename' => { 407 => 'ICCProfile' },
	'idccreativestyle' => { 380 => 0x8000 },
	'idcpreviewlength' => { 380 => 0x202 },
	'idcpreviewstart' => { 380 => 0x201 },
	'identification' => { 103 => 'Identification' },
	'identificationid' => { 103 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 103 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 103 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 103 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 103 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 103 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 396 => 'identifier', 418 => 'Identifier' },
	'illumination' => { 243 => '0.5' },
	'imageadjustment' => { 192 => 0x80, 218 => 0x5 },
	'imagealterationconstraints' => { 408 => 'ImageAlterationConstraints' },
	'imagearea' => { 203 => 0x10, 206 => 0x10 },
	'imageareaoffset' => { 301 => 0x38 },
	'imageauthentication' => { 192 => 0x20 },
	'imageboundary' => { 192 => 0x16 },
	'imagecount' => { 109 => 0x1438, 192 => 0xa5, 354 => 0x11b, 367 => [0x32,0x3a] },
	'imagecount2' => { 367 => [0x4c,0x58] },
	'imagecount3' => { 367 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 408 => 'ImageCreator' },
	'imagecreatorid' => { 408 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 408 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 408 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 192 => 0xa2 },
	'imagedescription' => { 104 => 0x10e, 416 => 'ImageDescription' },
	'imageduplicationconstraints' => { 408 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 228 => 0xfe443a45 },
	'imageeditcount' => { 301 => 0x41 },
	'imageediting' => { 301 => 0x32 },
	'imageeffects' => { 324 => 0x1010 },
	'imagefileconstraints' => { 408 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 408 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 408 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 109 => 0x1436 },
	'imageheight' => { 104 => 0x101, 163 => 0xc, 416 => 'ImageLength' },
	'imagehistory' => { 104 => 0x9213 },
	'imageidnumber' => { 264 => 0x340 },
	'imagenumber' => { 104 => 0x9211, 134 => 'ImageNumber', 157 => 0xae, 158 => 0x5e, 340 => 0x9b, 342 => [0x400,'276.1',0x314], 391 => 'ImageNumber' },
	'imagenumber2' => { 158 => 0x62 },
	'imageoptimization' => { 192 => 0xa9 },
	'imageorientation' => { 112 => 0x83 },
	'imageprocessing' => { 192 => 0x1a },
	'imageprocessingversion' => { 252 => 0x0 },
	'imagequality' => { 134 => 'ImageQuality', 205 => '723.2', 206 => '732.2', 214 => '708.1', 268 => 0x1 },
	'imagequality2' => { 248 => 0x603 },
	'imageref' => { 403 => 'ImageRef' },
	'imagereview' => { 237 => '0.4', 243 => '0.4' },
	'imagereviewmonitorofftime' => { 236 => '21.1', 245 => '21.1' },
	'imagereviewtime' => { 235 => '25.1', 237 => '2.1', 238 => '19.1', 239 => '20.1', 240 => '20.1', 241 => '9.2', 242 => '20.1', 246 => '21.2' },
	'imagesize' => { 140 => 'ImageSize' },
	'imagesizerestriction' => { 413 => 'imageSizeRestriction' },
	'imagesourcedata' => { 104 => 0x935c },
	'imagestabilization' => { 30 => 0x22, 100 => 0x3020, 109 => 0x1422, 134 => 'ImageStabilization', 157 => 0xbd, 158 => 0x71, 159 => 0x57, 160 => 0x0, 161 => [0x18,0x107,0x113], 162 => 0x49c2, 192 => 0xac, 248 => 0x604, 251 => 0x1600, 268 => 0x1a, 345 => 0x12, 346 => 0x11, 352 => 0xb026 },
	'imagestabilization2' => { 344 => 0xa },
	'imagestabilizationsetting' => { 162 => 0x14, 340 => 0x3d, 341 => 0x3d, 351 => 0x14 },
	'imagestyle' => { 340 => 0x2d, 341 => 0x27 },
	'imagesupplier' => { 408 => 'ImageSupplier' },
	'imagesupplierid' => { 408 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 408 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 408 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 106 => 0x1 },
	'imagetemperaturemin' => { 106 => 0x2 },
	'imagetone' => { 301 => 0x4f },
	'imagetype' => { 112 => 0x82, 408 => 'ImageType' },
	'imageuniqueid' => { 54 => 0x28, 104 => 0xa420, 399 => 'ImageUniqueID' },
	'imagewidth' => { 104 => 0x100, 163 => 0xe, 416 => 'ImageWidth' },
	'incrementaltemperature' => { 395 => 'IncrementalTemperature' },
	'incrementaltint' => { 395 => 'IncrementalTint' },
	'industry' => { 410 => 'industry', 411 => 'industry' },
	'infobuttonwhenshooting' => { 72 => 0x409 },
	'infraredilluminator' => { 320 => 0x28 },
	'ingredientexclusion' => { 412 => 'ingredientExclusion' },
	'ingredients' => { 421 => 'Ingredients' },
	'ingredientsalternatepaths' => { 421 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 421 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 421 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 421 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 421 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 421 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 421 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 421 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 421 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 421 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 421 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 421 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 421 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 421 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 421 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 421 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 421 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 384 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 384 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 384 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 384 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 235 => '4.4' },
	'initialzoomsetting' => { 235 => '9.3', 241 => '27.3' },
	'inkset' => { 104 => 0x14c },
	'inputprofile' => { 118 => 0x1389 },
	'instanceid' => { 421 => 'InstanceID' },
	'instantplaybacksetup' => { 159 => 0x3e },
	'instantplaybacktime' => { 159 => 0x3d },
	'instructions' => { 407 => 'Instructions' },
	'instrument' => { 420 => 'instrument' },
	'intellectualgenre' => { 404 => 'IntellectualGenre' },
	'intelligentauto' => { 352 => 0xb052 },
	'intelligentcontrast' => { 43 => 0x4 },
	'intelligentd-range' => { 268 => 0x79 },
	'intelligentexposure' => { 268 => 0x5d },
	'intelligentresolution' => { 268 => 0x70 },
	'interchangecolorspace' => { 114 => 0x40 },
	'internalflash' => { 156 => 0x2b, 235 => '23.1', 237 => '8.1', 238 => '22.1', 240 => '23.1', 243 => '8.1', 246 => '24.1', 251 => 0x1208 },
	'internalflashae1' => { 253 => 0x1021 },
	'internalflashae1_0' => { 253 => 0x101d },
	'internalflashae2' => { 253 => 0x1022 },
	'internalflashae2_0' => { 253 => 0x101e },
	'internalflashmode' => { 289 => 0x1 },
	'internalflashstrength' => { 289 => 0x3 },
	'internalflashtable' => { 253 => 0x1024 },
	'internallensserialnumber' => { 330 => 0xa005 },
	'internalndfilter' => { 268 => 0x9d },
	'internalserialnumber' => { 54 => 0x96, 65 => 0x9, 109 => 0x10, 162 => 0x49dc, 247 => 0x18, 249 => 0x102, 268 => 0x25, 281 => 0x4, 324 => 0x5, 367 => [0x7c,0x88,0xf0] },
	'interopindex' => { 104 => 0x1, 400 => 'InteroperabilityIndex' },
	'interopversion' => { 104 => 0x2 },
	'intervallength' => { 156 => 0x10 },
	'intervalmode' => { 156 => 0x26 },
	'intervalnumber' => { 156 => 0x11 },
	'introtime' => { 420 => 'introTime' },
	'introtimescale' => { 420 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 420 => [\'introTime','introTimeValue'] },
	'iptc' => { 105 => 'IPTC' },
	'iptc-naa' => { 104 => 0x83bb, 272 => 0x83bb },
	'iptcbitspersample' => { 114 => 0x56 },
	'iptcdigest' => { 313 => 0x425 },
	'iptcimageheight' => { 114 => 0x1e },
	'iptcimagerotation' => { 114 => 0x66 },
	'iptcimagewidth' => { 114 => 0x14 },
	'iptclastedited' => { 405 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 114 => 0xa },
	'iptcpixelheight' => { 114 => 0x32 },
	'iptcpixelwidth' => { 114 => 0x28 },
	'isalternativeof' => { 410 => 'isAlternativeOf' },
	'isbn' => { 410 => 'isbn' },
	'iscorrectionof' => { 410 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 96 => 0x3 },
	'ismergedhdr' => { 391 => 'IsMergedHDR' },
	'ismergedpanorama' => { 391 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 99 => 0x14, 100 => [0x3014,0x14], 104 => 0x8827, 117 => 0xfd06, 118 => 0x1784, 120 => 0x60, 122 => [0xfa2e,0xfa46], 123 => [0x27,0x28], 124 => 0xf105, 127 => 0x14, 129 => 0x4e, 132 => 0x34, 134 => 'ISO', 156 => 0x8, 162 => 0x49ba, 186 => 0x0, 192 => 0x2, 272 => 0x17, 301 => [0x8b,0x14], 308 => 0x14, 330 => 0xa014, 351 => 0x6f, 356 => [0x1f,0x21,0x25], 399 => 'ISOSpeedRatings' },
	'iso2' => { 186 => 0x6, 200 => 0x265, 201 => 0x25c, 202 => 0x265, 203 => 0x221, 204 => 0x25d, 205 => 0x256, 206 => 0x25d, 209 => 0x2b5, 212 => 0x265, 217 => 0x2b5 },
	'isoauto' => { 282 => '14.4' },
	'isoautoparameters' => { 301 => 0x7a },
	'isodisplay' => { 238 => '2.3', 239 => '3.3', 240 => '3.3', 242 => '3.3', 245 => '4.3', 246 => '4.3' },
	'isoexpansion' => { 72 => 0x103, 73 => 0x7, 74 => 0x8, 77 => 0x8, 186 => 0x4 },
	'isoexpansion2' => { 186 => 0xa },
	'isofloor' => { 282 => 0x6 },
	'isoselection' => { 192 => 0xf },
	'isosensitivitystep' => { 242 => '6.2' },
	'isosetting' => { 120 => 0x5e, 134 => 'ISOSetting', 156 => 0x24, 157 => 0x26, 158 => 0x1c, 159 => 0x13, 164 => 0x6, 192 => 0x13, 282 => '17.3', 323 => 0x27, 340 => 0x16, 341 => 0x14, 342 => 0x2, 351 => 0x6d },
	'isospeed' => { 104 => 0x8833, 400 => 'ISOSpeed' },
	'isospeedexpansion' => { 71 => 0x3 },
	'isospeedincrements' => { 72 => 0x102 },
	'isospeedlatitudeyyy' => { 104 => 0x8834, 400 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 104 => 0x8835, 400 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 72 => 0x103 },
	'isostepsize' => { 235 => '6.1', 236 => '7.2', 241 => '4.1', 245 => '7.2' },
	'isovalue' => { 253 => 0x1001 },
	'issn' => { 410 => 'issn' },
	'issueidentifier' => { 410 => 'issueIdentifier' },
	'issuename' => { 410 => 'issueName' },
	'issueteaser' => { 410 => 'issueTeaser' },
	'issuetype' => { 410 => 'issueType' },
	'istranslationof' => { 410 => 'isTranslationOf' },
	'jobid' => { 112 => 0xb8 },
	'jobname' => { 401 => 'JobName' },
	'jobref' => { 419 => 'JobRef' },
	'jobrefid' => { 419 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 419 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 419 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 401 => 'JobStatus' },
	'jpegquality' => { 9 => 0x66, 270 => 0x3034, 352 => 0xb047 },
	'jpegsize' => { 270 => 0x303a },
	'jpgfromraw' => { 85 => 0x2007, 101 => 'JpgFromRaw', 272 => 0x2e },
	'jpgfromrawlength' => { 104 => [0x117,0x202] },
	'jpgfromrawstart' => { 104 => [0x111,0x201] },
	'jpgrecordedpixels' => { 282 => '14.1' },
	'jurisdiction' => { 392 => 'jurisdiction' },
	'kelvinwb_01' => { 290 => 0x5 },
	'kelvinwb_02' => { 290 => 0x9 },
	'kelvinwb_03' => { 290 => 0xd },
	'kelvinwb_04' => { 290 => 0x11 },
	'kelvinwb_05' => { 290 => 0x15 },
	'kelvinwb_06' => { 290 => 0x19 },
	'kelvinwb_07' => { 290 => 0x1d },
	'kelvinwb_08' => { 290 => 0x21 },
	'kelvinwb_09' => { 290 => 0x25 },
	'kelvinwb_10' => { 290 => 0x29 },
	'kelvinwb_11' => { 290 => 0x2d },
	'kelvinwb_12' => { 290 => 0x31 },
	'kelvinwb_13' => { 290 => 0x35 },
	'kelvinwb_14' => { 290 => 0x39 },
	'kelvinwb_15' => { 290 => 0x3d },
	'kelvinwb_16' => { 290 => 0x41 },
	'kelvinwb_daylight' => { 290 => 0x1 },
	'key' => { 420 => 'key' },
	'keyword' => { 410 => 'keyword' },
	'keywordinfo' => { 149 => 'Keywords' },
	'keywords' => { 112 => 0x19, 135 => 'Keywords', 257 => 'Keywords', 315 => 'Keywords', 389 => 'keywords', 406 => 'Keywords', 418 => 'Keywords' },
	'killdate' => { 410 => 'killDate' },
	'killdatea-platform' => { 410 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 410 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 117 => 0xf908, 120 => 0xe, 122 => [0xfa1e,0xfa52], 128 => 0x70 },
	'kodakimagewidth' => { 117 => 0xf907, 120 => 0xc, 122 => [0xfa1d,0xfa51], 128 => 0x6c },
	'kodakinfotype' => { 117 => 0xfa00 },
	'kodaklook' => { 118 => 0xe4c },
	'kodaklookprofile' => { 118 => 0x138a },
	'kodakmaker' => { 128 => 0x8 },
	'kodakmodel' => { 120 => 0x0, 128 => 0x28 },
	'label' => { 260 => 'Label', 418 => 'Label' },
	'labelname1' => { 403 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 403 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 268 => 0x6f },
	'landscapeoutputhighlightpoint' => { 96 => 0x26 },
	'landscapeoutputshadowpoint' => { 96 => 0x27 },
	'landscaperawcolortone' => { 96 => 0x1f },
	'landscaperawcontrast' => { 96 => 0x21 },
	'landscaperawhighlight' => { 96 => 0x77 },
	'landscaperawhighlightpoint' => { 96 => 0x24 },
	'landscaperawlinear' => { 96 => 0x22 },
	'landscaperawsaturation' => { 96 => 0x20 },
	'landscaperawshadow' => { 96 => 0x80 },
	'landscaperawshadowpoint' => { 96 => 0x25 },
	'landscaperawsharpness' => { 96 => 0x23 },
	'landscapeunsharpmaskfineness' => { 96 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 96 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 96 => 0xa2 },
	'language' => { 396 => 'language' },
	'languageidentifier' => { 112 => 0x87 },
	'largestvalidinteriorrectheight' => { 384 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 384 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 384 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 384 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 156 => 0x1b },
	'lastkeywordiptc' => { 154 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 154 => 'LastKeywordXMP' },
	'lastphotodate' => { 384 => 'LastPhotoDate' },
	'lasturl' => { 421 => 'LastURL' },
	'lateralchromaticaberration' => { 352 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 391 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 103 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 103 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 103 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 103 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 103 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 292 => 0x2 },
	'lc10' => { 292 => 0xb },
	'lc11' => { 292 => 0xc },
	'lc12' => { 292 => 0xd },
	'lc14' => { 292 => 0xf },
	'lc15' => { 292 => 0x10 },
	'lc3' => { 292 => 0x4 },
	'lc4' => { 292 => 0x5 },
	'lc5' => { 292 => 0x6 },
	'lc6' => { 292 => 0x7 },
	'lc7' => { 292 => 0x8 },
	'lc8' => { 292 => 0x9 },
	'lcddisplayatpoweron' => { 72 => 0x811, 76 => 0xa },
	'lcddisplayreturntoshoot' => { 77 => 0x12 },
	'lcdillumination' => { 235 => '17.5', 236 => '5.2', 241 => '10.3', 242 => '4.2', 245 => '5.2', 246 => '5.4' },
	'lcdilluminationduringbulb' => { 72 => 0x408 },
	'lcdpanels' => { 71 => 0x8 },
	'lcheditor' => { 228 => 0x8ae85e },
	'legacyiptcdigest' => { 407 => 'LegacyIPTCDigest' },
	'legalcode' => { 392 => 'legalcode' },
	'lens' => { 104 => 0xfdea, 192 => 0x84, 391 => 'Lens' },
	'lensafstopbutton' => { 70 => 0x11, 71 => 0x13, 72 => 0x506, 73 => 0x10, 74 => 0x12, 77 => 0x13, 78 => 0x9 },
	'lensaperturerange' => { 333 => [0x30,0x48] },
	'lensdistortionparams' => { 253 => 0x206 },
	'lensdrivenoaf' => { 72 => 0x505 },
	'lense-mountversion' => { 342 => 0x3f0, 379 => 0xd },
	'lensfirmware' => { 325 => 0x20, 330 => 0xa004 },
	'lensfirmwareversion' => { 249 => 0x204, 268 => 0x60, 342 => 0x3f4, 379 => 0x15 },
	'lensfocallength' => { 90 => 0xf0512, 292 => 0x9 },
	'lensfocalrange' => { 333 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 236 => '55.1', 245 => '52.1' },
	'lensformat' => { 363 => 0x1891, 365 => 0x18bd, 366 => 0x18ed, 367 => 0x106, 375 => 0x603, 376 => 0x5d },
	'lensfstops' => { 187 => 0x7, 188 => 0xc, 189 => 0xd, 192 => 0x8b, 292 => '0.3' },
	'lensid' => { 391 => 'LensID' },
	'lensidnumber' => { 187 => 0x6, 188 => 0xb, 189 => 0xc },
	'lensinfo' => { 104 => 0xa432, 298 => 0x2a, 391 => 'LensInfo', 400 => 'LensSpecification' },
	'lenskind' => { 292 => 0x1 },
	'lensmake' => { 104 => 0xa433, 141 => 'Make', 400 => 'LensMake' },
	'lensmanualdistortionamount' => { 395 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 154 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 333 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 54 => 0x95, 104 => 0xa434, 141 => 'Model', 154 => 'LensModel', 190 => 0x18a, 249 => 0x203, 266 => 0x303, 298 => 0xc, 400 => 'LensModel' },
	'lensmount' => { 342 => 0x99, 363 => 0x1892, 365 => 0x18be, 366 => 0x18ee, 367 => 0x105, 375 => 0x604, 376 => 0x5e },
	'lensmount2' => { 379 => 0x8 },
	'lensparameters' => { 360 => 0x1a23, 363 => 0x1870, 365 => 0x189c, 366 => 0x18cc, 375 => 0x6ca, 376 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 395 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 395 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 395 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 395 => 'LensProfileEnable' },
	'lensprofilefilename' => { 395 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 395 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 395 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 395 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 395 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 395 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 395 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 395 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 395 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 395 => 'LensProfileName' },
	'lensprofilesetup' => { 395 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 395 => 'LensProfileVignettingScale' },
	'lensproperties' => { 249 => 0x20b },
	'lensserialnumber' => { 52 => 0x0, 104 => 0xa435, 141 => 'SerialNumber', 249 => 0x202, 268 => 0x52, 325 => 0x30, 391 => 'LensSerialNumber', 400 => 'LensSerialNumber' },
	'lensshutterlock' => { 159 => 0x4a },
	'lensspec' => { 337 => 0x0, 338 => 0x0, 339 => 0x0, 352 => 0xb02a },
	'lensspecfeatures' => { 367 => [0x115,0x116] },
	'lenstemperature' => { 253 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 30 => 0x16, 161 => 0x10c, 162 => 0x49bd, 192 => 0x83, 249 => 0x201, 261 => 0x16, 264 => 0x310, 267 => 0x303, 268 => 0x51, 270 => 0x3405, 293 => 0x0, 294 => 0x0, 295 => 0x1, 296 => 0x1, 297 => 0x1, 299 => 0x0, 330 => 0xa003, 333 => 0x27, 352 => 0xb027, 363 => 0x1896, 365 => 0x18c2, 366 => 0x18f2, 367 => 0x109, 375 => 0x608, 376 => 0x62 },
	'lenstype2' => { 342 => 0x3f7, 363 => 0x1893, 365 => 0x18bf, 366 => 0x18ef, 367 => 0x107, 375 => 0x605, 376 => 0x60 },
	'lenstype3' => { 379 => 0x9 },
	'lenszoomposition' => { 373 => 0x19, 374 => 0x1e, 376 => [0x342,0x35a] },
	'levelindicator' => { 275 => 0x15 },
	'levelorientation' => { 300 => 0x0 },
	'license' => { 392 => 'license' },
	'licensee' => { 408 => 'Licensee' },
	'licenseeid' => { 408 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 408 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 408 => 'LicenseeImageNotes' },
	'licenseename' => { 408 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 408 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 408 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 408 => 'LicenseeTransactionID' },
	'licenseid' => { 408 => 'LicenseID' },
	'licensestartdate' => { 408 => 'LicenseStartDate' },
	'licensetransactiondate' => { 408 => 'LicenseTransactionDate' },
	'licensetype' => { 397 => 'licensetype' },
	'licensor' => { 408 => 'Licensor' },
	'licensorcity' => { 408 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 408 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 408 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 408 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 408 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 408 => 'LicensorImageID' },
	'licensorname' => { 408 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 408 => 'LicensorNotes' },
	'licensorpostalcode' => { 408 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 408 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 408 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 408 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 408 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 408 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 408 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 408 => 'LicensorTransactionID' },
	'licensorurl' => { 408 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 253 => 0x1009 },
	'lightingmode' => { 100 => 0x302a },
	'lightreading' => { 301 => 0x15 },
	'lightsource' => { 104 => 0x9208, 192 => 0x90, 256 => 0x1000, 399 => 'LightSource' },
	'lightsourcespecial' => { 332 => 0x21d },
	'lightswitch' => { 245 => '0.1', 246 => '0.1' },
	'lightvaluecenter' => { 253 => 0x103d },
	'lightvalueperiphery' => { 253 => 0x103e },
	'limitafareamodeselection' => { 236 => '51.1', 245 => '49.1' },
	'linearitylimitblue' => { 272 => 0x10 },
	'linearitylimitgreen' => { 272 => 0xf },
	'linearitylimitred' => { 272 => 0xe },
	'linearityuppermargin' => { 37 => [0x2ba,0x2d1,0x2d5], 39 => 0x1e5, 40 => [0x1fe,0x2de], 41 => 0x310 },
	'linearizationtable' => { 104 => 0xc618 },
	'linearresponselimit' => { 104 => 0xc62e },
	'link' => { 410 => 'link' },
	'linkaetoafpoint' => { 282 => '14.2' },
	'linkedencodedrightsexpr' => { 405 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 405 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 405 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 405 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 103 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 238 => '32.1', 246 => '34.1' },
	'liveviewafareamode' => { 242 => '34.1' },
	'liveviewafmethod' => { 356 => 0x20 },
	'liveviewafmode' => { 242 => '34.2' },
	'liveviewafsetting' => { 342 => 0x36 },
	'liveviewbuttonoptions' => { 236 => '50.2', 245 => '48.2' },
	'liveviewexposuresimulation' => { 72 => 0x810 },
	'liveviewfocusmode' => { 342 => [0x8b,0x28b] },
	'liveviewmetering' => { 342 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 236 => '21.2', 239 => '20.2', 240 => '20.2', 242 => '20.2', 245 => '21.2' },
	'liveviewshooting' => { 48 => 0x13 },
	'localcaption' => { 112 => 0x79 },
	'localizedcameramodel' => { 104 => 0xc615 },
	'locallocationname' => { 330 => 0x30 },
	'location' => { 191 => 0x9, 268 => 0x67, 387 => 'Location', 404 => 'Location', 409 => 'location', 410 => 'location' },
	'locationareacode' => { 393 => 'lac' },
	'locationcreated' => { 405 => 'LocationCreated' },
	'locationcreatedcity' => { 405 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 405 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 405 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 405 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 405 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 405 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 405 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 191 => 0x0 },
	'locationname' => { 330 => 0x31 },
	'locationshown' => { 405 => 'LocationShown' },
	'locationshowncity' => { 405 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 405 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 405 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 405 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 405 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 405 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 405 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 72 => 0x709 },
	'logcomment' => { 420 => 'logComment' },
	'longexposurenoisereduction' => { 53 => 0x4, 72 => 0x201, 73 => 0x1, 74 => 0x2, 75 => 0x1, 76 => 0x1, 77 => 0x2, 78 => 0x1, 268 => 0x49, 340 => 0x2b, 341 => 0x25, 342 => 0x25, 352 => 0x2008, 356 => 0x11, 376 => 0x44 },
	'longexposurenoisereduction2' => { 48 => 0x8 },
	'loop' => { 420 => 'loop' },
	'lowestbiostratigraphiczone' => { 103 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 395 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 395 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 395 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 395 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 395 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 395 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 395 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 395 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 95 => 0x150 },
	'luminancecurvepoints' => { 95 => 0x126 },
	'luminancenoisereduction' => { 90 => 0x20600, 96 => 0x5f, 333 => 0x1b },
	'luminancenoisereductioncontrast' => { 395 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 395 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 96 => 0x6d },
	'luminancesmoothing' => { 395 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 72 => 0x40b },
	'lyrics' => { 420 => 'lyrics' },
	'm16cversion' => { 264 => 0x333 },
	'macatom' => { 394 => 'macAtom' },
	'macatomapplicationcode' => { 394 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 394 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 394 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 109 => 0x1020, 110 => 0x202, 253 => 0x202, 323 => 0x21, 332 => 0x202, 352 => 0xb040 },
	'macroled' => { 251 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 48 => 0x10 },
	'macromode' => { 30 => 0x1, 156 => 0xb, 248 => 0x300, 268 => 0x1c, 324 => 0x1009 },
	'magentahsl' => { 90 => 0x20917 },
	'magicfilter' => { 248 => 0x52c },
	'magnifiedview' => { 74 => 0x11, 76 => 0x9 },
	'maindialexposurecomp' => { 243 => '0.6' },
	'mainingredient' => { 412 => 'mainIngredient' },
	'make' => { 86 => 0x0, 104 => 0x10f, 134 => 'Make', 260 => 'Make', 272 => 0x10f, 409 => 'make', 416 => 'Make' },
	'makernote' => { 399 => 'MakerNote' },
	'makernoteapple' => { 102 => 'MakN', 104 => 0x927c },
	'makernotecanon' => { 102 => 'MakN', 104 => 0x927c },
	'makernotecasio' => { 102 => 'MakN', 104 => 0x927c },
	'makernotecasio2' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteflir' => { 102 => 'MakN', 104 => 0x927c },
	'makernotefujifilm' => { 102 => 'MakN', 104 => 0x927c },
	'makernotege' => { 102 => 'MakN', 104 => 0x927c },
	'makernotege2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehasselblad' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehp' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehp2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehp4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehp6' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteisl' => { 102 => 'MakN', 104 => 0x927c },
	'makernotejvc' => { 102 => 'MakN', 104 => 0x927c },
	'makernotejvctext' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak10' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak11' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak1a' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak1b' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak5' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak6a' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak6b' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak7' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak8a' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak8b' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak8c' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak9' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodakunknown' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekyocera' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica2' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica3' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica4' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica5' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica6' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica7' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica8' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica9' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteminolta' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteminolta2' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteminolta3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotemotorola' => { 102 => 'MakN', 104 => 0x927c },
	'makernotenikon' => { 102 => 'MakN', 104 => 0x927c },
	'makernotenikon2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotenikon3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotenintendo' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteoffset' => { 332 => 0xff },
	'makernoteolympus' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteolympus2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepanasonic' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepanasonic2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax5' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax6' => { 102 => 'MakN', 104 => 0x927c },
	'makernotephaseone' => { 102 => 'MakN', 104 => 0x927c },
	'makernotereconyx' => { 102 => 'MakN', 104 => 0x927c },
	'makernotericoh' => { 102 => 'MakN', 104 => 0x927c },
	'makernotericoh2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotericohtext' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesafety' => { 104 => 0xc635 },
	'makernotesamsung1a' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesamsung1b' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesamsung2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesanyo' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesanyoc4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesanyopatch' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesigma' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony5' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesonyericsson' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesonysrf' => { 102 => 'MakN', 104 => 0x927c },
	'makernotetype' => { 324 => 0x1 },
	'makernoteunknown' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteunknownbinary' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteunknowntext' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteversion' => { 161 => 0x0, 192 => 0x1, 253 => 0x0, 268 => 0x8000, 328 => 0x0, 330 => 0x1, 333 => [0x1d,0x1f], 343 => 0x2000 },
	'managedfrom' => { 421 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 421 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 421 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 421 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 421 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 421 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 421 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 421 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 421 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 421 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 421 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 421 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 421 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 421 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 421 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 421 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 421 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 421 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 421 => 'Manager' },
	'managervariant' => { 421 => 'ManagerVariant' },
	'manageto' => { 421 => 'ManageTo' },
	'manageui' => { 421 => 'ManageUI' },
	'manifest' => { 421 => 'Manifest' },
	'manifestlinkform' => { 421 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 421 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 421 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 421 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 421 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 421 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 421 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 421 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 421 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 421 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 421 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 421 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 421 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 421 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 421 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 421 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 421 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 421 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 421 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 421 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 421 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 421 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 248 => 0x900, 268 => 0x86 },
	'manometerreading' => { 248 => 0x901 },
	'manualafpointselectpattern' => { 72 => 0x513 },
	'manualflash' => { 251 => 0x1209 },
	'manualflashoutput' => { 30 => 0x29, 237 => '8.2', 238 => '22.2', 239 => '23.1', 240 => '23.2', 241 => '16.2', 242 => '23.2', 243 => '8.2', 244 => '23.2', 246 => '24.2', 324 => 0x100c },
	'manualflashstrength' => { 248 => 0x406 },
	'manualfocusdistance' => { 192 => 0x85, 253 => 0x100c, 332 => 0x223 },
	'manualtv' => { 71 => 0x5, 72 => 0x705 },
	'manufacturedate' => { 166 => 0x6705, 281 => 0x1 },
	'manufacturedate1' => { 326 => 0x4 },
	'manufacturedate2' => { 326 => 0x5 },
	'manufacturer' => { 409 => 'manufacturer' },
	'marked' => { 406 => 'Marked', 424 => 'Marked' },
	'markers' => { 420 => 'markers' },
	'markerscomment' => { 420 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 420 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 420 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 420 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 420 => [\'markers','markersCuePointType'] },
	'markersduration' => { 420 => [\'markers','markersDuration'] },
	'markerslocation' => { 420 => [\'markers','markersLocation'] },
	'markersname' => { 420 => [\'markers','markersName'] },
	'markersprobability' => { 420 => [\'markers','markersProbability'] },
	'markersspeaker' => { 420 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 420 => [\'markers','markersStartTime'] },
	'markerstarget' => { 420 => [\'markers','markersTarget'] },
	'markerstype' => { 420 => [\'markers','markersType'] },
	'maskedareas' => { 104 => 0xc68e },
	'masterdocumentid' => { 112 => 0xb9 },
	'mastergain' => { 198 => 0x50 },
	'matrixmetering' => { 236 => '50.1', 245 => '48.1' },
	'maxaperture' => { 30 => 0x1a, 124 => 0x6103, 141 => 'MaxAperture', 156 => 0x17, 162 => 0x49c5, 249 => 0x20a, 292 => '14.1', 367 => 0x0 },
	'maxapertureatmaxfocal' => { 109 => 0x1407, 141 => 'MaxApertureAtMaxFocal', 187 => 0xb, 188 => 0x10, 189 => 0x11, 249 => 0x206 },
	'maxapertureatminfocal' => { 109 => 0x1406, 187 => 0xa, 188 => 0xf, 189 => 0x10, 249 => 0x205 },
	'maxaperturevalue' => { 104 => 0x9205, 399 => 'MaxApertureValue' },
	'maxavailheight' => { 405 => 'MaxAvailHeight' },
	'maxavailwidth' => { 405 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 235 => 0xb, 236 => 0xc, 241 => 0xc, 242 => 0xb, 245 => '12.1' },
	'maxfaces' => { 252 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 30 => 0x17, 109 => 0x1405, 141 => 'MaxFocalLength', 187 => 0x9, 188 => 0xe, 189 => 0xf, 249 => 0x208, 363 => 0x127c, 364 => 0x1138, 365 => 0x330, 366 => 0x330 },
	'maximumdensityrange' => { 114 => 0x8c },
	'maxpagesize' => { 425 => 'MaxPageSize' },
	'maxpagesizeh' => { 425 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 425 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 425 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 104 => 0x119 },
	'maxstorage' => { 415 => 'maxstorage' },
	'mb-d10batteries' => { 235 => '12.6' },
	'mb-d10batterytype' => { 241 => '13.3' },
	'mb-d11batterytype' => { 242 => '2.3' },
	'mb-d12batterytype' => { 245 => '3.2' },
	'mb-d80batteries' => { 243 => '6.5' },
	'mb-d80batterytype' => { 246 => '3.2' },
	'mcuversion' => { 187 => 0xc, 188 => 0x11, 189 => 0x12 },
	'md5digest' => { 142 => 'zmd5' },
	'meal' => { 412 => 'meal' },
	'measuredev' => { 26 => 0x9, 66 => 0x3, 85 => 0x1814, 134 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 66 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 162 => 0x690, 264 => 0x312, 270 => 0x3407 },
	'measuredrggb' => { 55 => 0x1 },
	'measuredrggbdata' => { 36 => 0x287 },
	'measurementaccuracy' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 103 => 'MeasurementOrFact' },
	'measurementremarks' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 408 => 'MediaConstraints' },
	'mediacreatedate' => { 316 => 0x1 },
	'mediamodifydate' => { 316 => 0x2 },
	'mediasummarycode' => { 408 => 'MediaSummaryCode' },
	'memoaudioquality' => { 72 => 0x812 },
	'memorycardconfiguration' => { 346 => 0x16 },
	'menubuttondisplayposition' => { 70 => 0xb, 73 => 0xa, 74 => 0xb, 77 => 0xb },
	'menubuttonreturn' => { 78 => 0xb },
	'menumonitorofftime' => { 235 => '26.1', 236 => '22.1', 241 => '8.2', 242 => '21.1', 245 => '22.1', 246 => '22.1' },
	'metadatadate' => { 418 => 'MetadataDate' },
	'metadatamoddate' => { 420 => 'metadataModDate' },
	'metaversion' => { 358 => 0x34 },
	'meterinfo1row1' => { 353 => 0x0 },
	'meterinfo1row2' => { 353 => 0x6c },
	'meterinfo1row3' => { 353 => 0xd8 },
	'meterinfo1row4' => { 353 => 0x144 },
	'meterinfo1row5' => { 353 => 0x1b0 },
	'meterinfo1row6' => { 353 => 0x21c },
	'meterinfo1row7' => { 353 => 0x288 },
	'meterinfo2row1' => { 353 => 0x2f4 },
	'meterinfo2row2' => { 353 => 0x378 },
	'meterinfo2row3' => { 353 => 0x3fc },
	'meterinfo2row4' => { 353 => 0x480 },
	'meterinfo2row5' => { 353 => 0x504 },
	'meterinfo2row6' => { 353 => 0x588 },
	'meterinfo2row7' => { 353 => 0x60c },
	'meterinfo2row8' => { 353 => 0x690 },
	'meterinfo2row9' => { 353 => 0x714 },
	'metering' => { 237 => '6.1' },
	'meteringmode' => { 30 => 0x11, 104 => 0x9207, 120 => 0x1c, 156 => 0x7, 157 => 0x25, 159 => 0x12, 248 => 0x202, 301 => 0x17, 333 => 0x9, 340 => 0x15, 341 => 0x13, 342 => 0x7, 356 => 0x3, 359 => 0x1174, 360 => 0x1178, 361 => 0x1154, 362 => 0x11d0, 363 => 0x11ac, 364 => 0x1064, 365 => 0x25c, 366 => 0x25c, 399 => 'MeteringMode' },
	'meteringmode2' => { 282 => '2.1' },
	'meteringmode3' => { 282 => '16.1' },
	'meteringoffscaleindicator' => { 159 => 0x53 },
	'meteringtime' => { 235 => '22.2', 237 => '3.2', 238 => '17.1', 239 => '18.1', 241 => '7.3', 242 => '18.1', 243 => '3.2', 246 => '19.1' },
	'mieversion' => { 142 => '0Vers' },
	'minaperture' => { 30 => 0x1b, 141 => 'MinAperture', 292 => '0.2', 367 => 0x1 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 30 => 0x18, 109 => 0x1404, 141 => 'MinFocalLength', 187 => 0x8, 188 => 0xd, 189 => 0xe, 249 => 0x207, 363 => 0x127a, 364 => 0x1136, 365 => 0x32e, 366 => 0x32e },
	'minfocusdistance' => { 292 => 0x3 },
	'minoltadate' => { 156 => 0x15 },
	'minoltaimagesize' => { 156 => 0x4, 157 => 0xc, 158 => 0x2, 161 => 0x103 },
	'minoltamodelid' => { 156 => 0x25 },
	'minoltaquality' => { 156 => 0x5, 157 => 0xd, 158 => 0x3, 161 => [0x102,0x103] },
	'minoltatime' => { 156 => 0x16 },
	'minormodelagedisclosure' => { 408 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 104 => 0x118 },
	'mirrorlockup' => { 70 => 0xc, 71 => 0xc, 72 => 0x60f, 73 => 0xb, 74 => 0xc, 75 => 0x6, 76 => 0x6, 77 => 0xc, 78 => 0x3 },
	'mobilecountrycode' => { 393 => 'mcc' },
	'mobilenetworkcode' => { 393 => 'mnc' },
	'moddate' => { 260 => 'modify-date', 406 => 'ModDate' },
	'modedialposition' => { 346 => 0x14 },
	'model' => { 86 => 0x6, 104 => 0x110, 134 => 'Model', 260 => 'Model', 272 => 0x110, 409 => 'model', 416 => 'Model' },
	'modelage' => { 405 => 'ModelAge' },
	'modelid' => { 247 => 0x0 },
	'modelingflash' => { 235 => '21.4', 236 => '31.1', 241 => '26.4', 242 => '30.2', 243 => '7.4', 244 => '30.1', 245 => '31.1', 246 => '31.3' },
	'modelreleaseid' => { 408 => 'ModelReleaseID' },
	'modelreleasestatus' => { 408 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 368 => 0x52, 369 => 0x46, 370 => 0x53 },
	'modelyear' => { 409 => 'modelYear' },
	'modificationdate' => { 410 => 'modificationDate' },
	'modifiedcolortemp' => { 56 => 0x9 },
	'modifieddigitalgain' => { 56 => 0xb },
	'modifiedparamflag' => { 49 => 0x1 },
	'modifiedpicturestyle' => { 56 => 0xa },
	'modifiedsaturation' => { 248 => 0x504 },
	'modifiedsensorbluelevel' => { 56 => 0x5 },
	'modifiedsensorredlevel' => { 56 => 0x4 },
	'modifiedsharpness' => { 56 => 0x2 },
	'modifiedsharpnessfreq' => { 56 => 0x3 },
	'modifiedtonecurve' => { 56 => 0x1 },
	'modifiedwhitebalance' => { 56 => 0x8 },
	'modifiedwhitebalanceblue' => { 56 => 0x7 },
	'modifiedwhitebalancered' => { 56 => 0x6 },
	'modifydate' => { 104 => 0x132, 135 => 'ModifyDate', 257 => 'ModDate', 258 => 'tIME', 315 => 'ModDate', 317 => 0x2, 418 => 'ModifyDate' },
	'moirefilter' => { 104 => 0xfe58, 395 => 'MoireFilter' },
	'monitordisplayoff' => { 159 => 0x4c },
	'monitorofftime' => { 235 => '18.2', 237 => '3.1', 243 => '3.1' },
	'monochromecontrast' => { 96 => 0x3c },
	'monochromefiltereffect' => { 90 => 0x20307, 96 => 0x3a, 301 => 0x73 },
	'monochromelinear' => { 96 => 0x3d },
	'monochromeoutputhighlightpoint' => { 96 => 0x41 },
	'monochromeoutputshadowpoint' => { 96 => 0x42 },
	'monochromerawhighlight' => { 96 => 0x7a },
	'monochromerawhighlightpoint' => { 96 => 0x3f },
	'monochromerawshadow' => { 96 => 0x83 },
	'monochromerawshadowpoint' => { 96 => 0x40 },
	'monochromesharpness' => { 96 => 0x3e },
	'monochrometoning' => { 301 => 0x74 },
	'monochrometoningeffect' => { 90 => 0x20306, 96 => 0x3b },
	'monochromeunsharpmaskfineness' => { 96 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 96 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 96 => 0xb4 },
	'monthdaycreated' => { 120 => 0x12, 129 => 0xe },
	'moonphase' => { 320 => 0x12 },
	'morepermissions' => { 392 => 'morePermissions' },
	'motionsensitivity' => { 320 => 0x29 },
	'movieaelockbuttonassignment' => { 245 => '40.1' },
	'moviefunctionbutton' => { 236 => '41.1', 245 => '41.1' },
	'moviefunctionbuttonplusdials' => { 236 => '52.1' },
	'moviepreviewbutton' => { 236 => '41.2', 245 => '41.2' },
	'moviepreviewbuttonplusdials' => { 236 => '52.2' },
	'movieshutterbutton' => { 236 => '38.3', 245 => '38.3' },
	'moviesubselectorassignment' => { 236 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 236 => '53.1' },
	'multiburstimageheight' => { 352 => 0x1002 },
	'multiburstimagewidth' => { 352 => 0x1001 },
	'multiburstmode' => { 352 => 0x1000 },
	'multicontrollerwhilemetering' => { 72 => 0x517 },
	'multiexposure' => { 58 => 0x1 },
	'multiexposureautogain' => { 193 => 0x3 },
	'multiexposurecontrol' => { 58 => 0x2 },
	'multiexposuremode' => { 193 => 0x1 },
	'multiexposureshots' => { 58 => 0x3, 193 => 0x2 },
	'multiframenoisereduction' => { 342 => 0x35, 352 => 0x200b, 356 => 0x15 },
	'multifunctionlock' => { 72 => 0x70f },
	'multipleexposuremode' => { 252 => 0x101c },
	'multipleexposureset' => { 282 => '10.1' },
	'multisample' => { 198 => 0x40 },
	'multiselector' => { 235 => '9.4', 236 => '10.3', 241 => '27.4', 245 => '10.3' },
	'multiselectorliveview' => { 235 => '4.3', 245 => '37.1' },
	'multiselectorliveviewmode' => { 208 => 0x18c2 },
	'multiselectorplaybackmode' => { 235 => ['13.5','9.2'], 236 => '10.2', 241 => '27.2', 245 => '10.2' },
	'multiselectorshootmode' => { 235 => '9.1', 236 => '10.1', 241 => '27.1', 245 => '10.1' },
	'mycolormode' => { 59 => 0x2 },
	'nationalcatalognumber' => { 410 => 'nationalCatalogNumber' },
	'nativedigest' => { 399 => 'NativeDigest', 416 => 'NativeDigest' },
	'ncdfileinfo' => { 118 => 0x414 },
	'ndfilter' => { 66 => 0x1c, 248 => 0x204, 324 => 0x1019 },
	'nefbitdepth' => { 192 => 0xe22 },
	'nefcompression' => { 192 => 0x93 },
	'neflinearizationtable' => { 192 => 0x96 },
	'neutraldensityfilter' => { 301 => 0x88 },
	'neutraloutputhighlightpoint' => { 96 => 0x2f },
	'neutraloutputshadowpoint' => { 96 => 0x30 },
	'neutralrawcolortone' => { 96 => 0x28 },
	'neutralrawcontrast' => { 96 => 0x2a },
	'neutralrawhighlight' => { 96 => 0x78 },
	'neutralrawhighlightpoint' => { 96 => 0x2d },
	'neutralrawlinear' => { 96 => 0x2b },
	'neutralrawsaturation' => { 96 => 0x29 },
	'neutralrawshadow' => { 96 => 0x81 },
	'neutralrawshadowpoint' => { 96 => 0x2e },
	'neutralrawsharpness' => { 96 => 0x2c },
	'neutralunsharpmaskfineness' => { 96 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 96 => 0xa8 },
	'neutraunsharpmaskstrength' => { 96 => 0xa4 },
	'newrawimagedigest' => { 104 => 0xc7a7 },
	'newsphotoversion' => { 114 => 0x0 },
	'nickname' => { 418 => 'Nickname' },
	'nikoncapturedata' => { 192 => 0xe01 },
	'nikoncaptureeditversions' => { 192 => 0xe13 },
	'nikoncaptureoutput' => { 192 => 0xe1e },
	'nikoncaptureversion' => { 192 => 0xe09 },
	'nikoniccprofile' => { 192 => 0xe1d },
	'nikonimagesize' => { 205 => '723.1', 206 => '732.1', 214 => 0x2c4 },
	'noisefilter' => { 248 => 0x527 },
	'noiseprofile' => { 104 => 0xc761 },
	'noisereduction' => { 109 => 0x100b, 157 => 0xb0, 158 => 0x60, 159 => 0x3f, 192 => 0x95, 228 => 0x753dcbc0, 229 => 0x17, 248 => 0x50a, 253 => 0x103a, 268 => 0x2d, 301 => 0x49, 324 => 0x100f, 326 => 0x2a },
	'noisereduction2' => { 252 => 0x1010 },
	'noisereductionapplied' => { 104 => 0xc6f7 },
	'noisereductionintensity' => { 229 => 0x9 },
	'noisereductionmethod' => { 229 => 0x11 },
	'noisereductionmode' => { 380 => 0x801e },
	'noisereductionsharpness' => { 229 => 0xd },
	'noisereductionvalue' => { 380 => 0x8027 },
	'nomemorycard' => { 235 => '22.1', 236 => '4.2', 237 => '0.3', 238 => '2.4', 239 => '3.2', 240 => '3.2', 241 => '33.7', 242 => '3.2', 243 => '0.3', 245 => '4.2', 246 => '4.5' },
	'nominalmaxaperture' => { 292 => 0xa },
	'nominalminaperture' => { 292 => '10.1' },
	'normalwhitelevel' => { 37 => [0x2b8,0x2cf,0x2d3], 39 => 0x1e3, 40 => [0x1fc,0x2dc], 41 => 0x30e },
	'notes' => { 381 => 'Notes', 389 => 'notes' },
	'npages' => { 425 => 'NPages' },
	'nrwdata' => { 192 => 0x14 },
	'nullrecord' => { 85 => 0x0 },
	'number' => { 410 => 'number' },
	'numberofbeats' => { 420 => 'numberOfBeats' },
	'numberoffocuspoints' => { 240 => '0.2', 242 => '0.3' },
	'numfacepositions' => { 262 => 0x0 },
	'numindexentries' => { 114 => 0x54 },
	'numwbentries' => { 273 => 0x0, 274 => 0x0 },
	'object' => { 410 => 'object' },
	'objectattributereference' => { 112 => 0x4 },
	'objectcycle' => { 112 => 0x4b },
	'objectdescription' => { 409 => 'objectDescription' },
	'objectdistance' => { 99 => 0x6, 100 => 0x2022 },
	'objectname' => { 112 => 0x5 },
	'objectpreviewdata' => { 112 => 0xca },
	'objectpreviewfileformat' => { 112 => 0xc8 },
	'objectpreviewfileversion' => { 112 => 0xc9 },
	'objectsubtype' => { 409 => 'objectSubtype' },
	'objecttype' => { 409 => 'objectType' },
	'objecttypereference' => { 112 => 0x3 },
	'occurrence' => { 103 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 103 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 103 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 103 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 103 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 103 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 103 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 103 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 103 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 103 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 103 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 103 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 103 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 103 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 103 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 103 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 103 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 103 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 103 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 103 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 103 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 103 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 103 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 103 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 399 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 399 => [\'OECF','OECFNames'] },
	'oecfrows' => { 399 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 399 => [\'OECF','OECFValues'] },
	'offsaledate' => { 410 => 'offSaleDate' },
	'offsaledatea-platform' => { 410 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 410 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 104 => 0xea1d },
	'okbutton' => { 242 => '15.1', 246 => '16.1' },
	'oldsubfiletype' => { 104 => 0xff },
	'olympusimageheight' => { 253 => 0x102f },
	'olympusimagewidth' => { 253 => 0x102e },
	'onetouchwb' => { 253 => 0x302 },
	'onsaledate' => { 410 => 'onSaleDate' },
	'onsaledatea-platform' => { 410 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 410 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 410 => 'onSaleDay' },
	'onsaledaya-platform' => { 410 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 410 => [\'onSaleDay','onSaleDayDay'] },
	'opticalzoom' => { 122 => 0xfa3d, 124 => [0x6006,0xf006], 125 => 0x1000, 126 => 0xf, 129 => 0x1e, 141 => 'OpticalZoom' },
	'opticalzoomcode' => { 66 => 0xa },
	'opticalzoommode' => { 268 => 0x34 },
	'opticalzoomon' => { 332 => 0x219 },
	'optionenddate' => { 413 => 'optionEndDate' },
	'opto-electricconvfactor' => { 399 => 'OECF' },
	'orangehsl' => { 90 => 0x20911 },
	'ordernumber' => { 109 => 0x8002 },
	'organisationinimagecode' => { 405 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 405 => 'OrganisationInImageName' },
	'organization' => { 410 => 'organization' },
	'orientation' => { 104 => 0x112, 272 => 0x112, 409 => 'orientation', 416 => 'Orientation' },
	'orientation2' => { 356 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 72 => 0x516 },
	'originalbestqualitysize' => { 104 => 0xc792 },
	'originaldecisiondata' => { 101 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 54 => 0x83 },
	'originaldefaultcropsize' => { 104 => 0xc793 },
	'originaldefaultfinalsize' => { 104 => 0xc791 },
	'originaldirectory' => { 266 => 0x408 },
	'originaldocumentid' => { 421 => 'OriginalDocumentID' },
	'originalfilename' => { 85 => 0x816, 118 => 0x3e9, 130 => 0x20, 266 => 0x407, 385 => 'OriginalFilename' },
	'originalimageheight' => { 68 => 0xc, 108 => 0x1 },
	'originalimagewidth' => { 68 => 0xb, 108 => 0x0 },
	'originalrawfiledata' => { 104 => 0xc68c },
	'originalrawfiledigest' => { 104 => 0xc71d },
	'originalrawfilename' => { 104 => 0xc68b },
	'originaltransmissionreference' => { 112 => 0x67 },
	'originatingprogram' => { 112 => 0x41 },
	'originplatform' => { 410 => 'originPlatform' },
	'os' => { 397 => 'os' },
	'otherconditions' => { 408 => 'OtherConditions' },
	'otherconstraints' => { 408 => 'OtherConstraints' },
	'otherimage' => { 101 => 'OtherImage' },
	'otherimageinfo' => { 408 => 'OtherImageInfo' },
	'otherimagelength' => { 104 => 0x202 },
	'otherimagestart' => { 104 => 0x201 },
	'otherlicensedocuments' => { 408 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 408 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 408 => 'OtherLicenseRequirements' },
	'outcue' => { 420 => 'outCue' },
	'outcuescale' => { 420 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 420 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 171 => 0x3 },
	'outputimagewidth' => { 171 => 0x2 },
	'outputprofile' => { 118 => 0x138b },
	'outputresolution' => { 171 => 0x4 },
	'owner' => { 424 => 'Owner' },
	'ownerid' => { 112 => 0xbc },
	'ownername' => { 14 => 0x10f, 54 => 0x9, 85 => 0x810, 104 => [0xa430,0xfde8], 134 => 'OwnerName', 391 => 'OwnerName', 400 => 'CameraOwnerName' },
	'padding' => { 104 => 0xea1c },
	'pagecount' => { 410 => 'pageCount' },
	'pageimage' => { 418 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 418 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 418 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 418 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 418 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 418 => 'PageInfo' },
	'pagename' => { 104 => 0x11d },
	'pagenumber' => { 104 => 0x129 },
	'pageprogressiondirection' => { 410 => 'pageProgressionDirection' },
	'pagerange' => { 410 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 395 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 395 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 268 => 0x26 },
	'panasonicimageheight' => { 268 => 0x4c },
	'panasonicimagewidth' => { 268 => 0x4b },
	'panasonicrawversion' => { 272 => 0x1 },
	'panasonictitle' => { 104 => 0xc6d2 },
	'panasonictitle2' => { 104 => 0xc6d3 },
	'panoramacropbottom' => { 357 => 0x7 },
	'panoramacropleft' => { 357 => 0x4 },
	'panoramacropright' => { 357 => 0x6 },
	'panoramacroptop' => { 357 => 0x5 },
	'panoramadirection' => { 62 => 0x5, 357 => 0x3 },
	'panoramaframeheight' => { 357 => 0x9 },
	'panoramaframenumber' => { 62 => 0x2 },
	'panoramaframewidth' => { 357 => 0x8 },
	'panoramafullheight' => { 357 => 0x2 },
	'panoramafullwidth' => { 357 => 0x1 },
	'panoramamode' => { 120 => 0x3c, 248 => 0x601 },
	'panoramasize3d' => { 342 => 0x38 },
	'panoramasourceheight' => { 357 => 0xb },
	'panoramasourcewidth' => { 357 => 0xa },
	'panoramicstitchcameramotion' => { 152 => 'PanoramicStitchCameraMotion', 153 => 0x1 },
	'panoramicstitchmaptype' => { 152 => 'PanoramicStitchMapType', 153 => 0x2 },
	'panoramicstitchphi0' => { 152 => 'PanoramicStitchPhi0', 153 => 0x5 },
	'panoramicstitchphi1' => { 152 => 'PanoramicStitchPhi1', 153 => 0x6 },
	'panoramicstitchtheta0' => { 152 => 'PanoramicStitchTheta0', 153 => 0x3 },
	'panoramicstitchtheta1' => { 152 => 'PanoramicStitchTheta1', 153 => 0x4 },
	'panoramicstitchversion' => { 153 => 0x0 },
	'pantry' => { 421 => 'Pantry' },
	'parallax' => { 109 => 0xb211, 247 => 0x28 },
	'parametricdarks' => { 395 => 'ParametricDarks' },
	'parametrichighlights' => { 395 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 395 => 'ParametricHighlightSplit' },
	'parametriclights' => { 395 => 'ParametricLights' },
	'parametricmidtonesplit' => { 395 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 395 => 'ParametricShadows' },
	'parametricshadowsplit' => { 395 => 'ParametricShadowSplit' },
	'parentmeid' => { 385 => 'ParentMEID' },
	'parentreference1' => { 403 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 403 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 420 => 'partOfCompilation' },
	'patientbirthdate' => { 382 => 'PatientDOB' },
	'patientid' => { 382 => 'PatientID' },
	'patientname' => { 382 => 'PatientName' },
	'patientsex' => { 382 => 'PatientSex' },
	'pdfversion' => { 406 => 'PDFVersion' },
	'pentaximagesize' => { 301 => 0x9 },
	'pentaxmodelid' => { 281 => 0x0, 301 => 0x5 },
	'pentaxmodeltype' => { 301 => 0x1 },
	'pentaxversion' => { 301 => 0x0 },
	'people' => { 383 => 'People', 387 => 'People' },
	'perchannelblacklevel' => { 36 => 0xc4, 37 => [0x2b4,0x2cb,0x2cf], 38 => 0x108, 39 => 0x1df, 40 => [0x1f8,0x2d8], 41 => 0x30a },
	'peripheralillumcentralradius' => { 380 => 0x8030 },
	'peripheralillumcentralvalue' => { 380 => 0x8031 },
	'peripheralillumination' => { 90 => 0x20702, 96 => 0x68 },
	'peripheralilluminationcorr' => { 53 => 0x1, 291 => 0x2 },
	'peripheralilluminationon' => { 90 => '0x20702.0', 96 => 0x64 },
	'peripheralillumperiphvalue' => { 380 => 0x8032 },
	'peripherallighting' => { 68 => 0x2 },
	'peripherallightingsetting' => { 69 => 0x5 },
	'peripherallightingvalue' => { 68 => 0x6 },
	'permissions' => { 413 => 'permissions' },
	'permits' => { 392 => 'permits' },
	'person' => { 410 => 'person' },
	'personality' => { 385 => 'Personality' },
	'personinimage' => { 405 => 'PersonInImage' },
	'personinimagecharacteristic' => { 405 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 405 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 405 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 405 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 405 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 405 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 405 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 405 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 405 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 395 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 395 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 395 => 'PerspectiveRotate' },
	'perspectivescale' => { 395 => 'PerspectiveScale' },
	'perspectiveupright' => { 395 => 'PerspectiveUpright' },
	'perspectivevertical' => { 395 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 80 => 0x1 },
	'pf10retainprogramshift' => { 80 => 0xb },
	'pf13drivepriority' => { 80 => 0xe },
	'pf14disablefocussearch' => { 80 => 0xf },
	'pf15disableafassistbeam' => { 80 => 0x10 },
	'pf16autofocuspointshoot' => { 80 => 0x11 },
	'pf17disableafpointsel' => { 80 => 0x12 },
	'pf18enableautoafpointsel' => { 80 => 0x13 },
	'pf19continuousshootspeed' => { 80 => 0x14 },
	'pf19shootingspeedhigh' => { 79 => 0xa },
	'pf19shootingspeedlow' => { 79 => 0x9 },
	'pf1disableshootingmodes' => { 80 => 0x2 },
	'pf1value' => { 79 => 0x1 },
	'pf20limitcontinousshots' => { 80 => 0x15 },
	'pf20maxcontinousshots' => { 79 => 0xb },
	'pf21enablequietoperation' => { 80 => 0x16 },
	'pf23felocktime' => { 79 => 0xd },
	'pf23postreleasetime' => { 79 => 0xe },
	'pf23settimerlengths' => { 80 => 0x18 },
	'pf23shutterbuttontime' => { 79 => 0xc },
	'pf24lightlcdduringbulb' => { 80 => 0x19 },
	'pf25aemode' => { 79 => 0xf },
	'pf25afmode' => { 79 => 0x12 },
	'pf25afpointsel' => { 79 => 0x13 },
	'pf25colormatrix' => { 79 => 0x17 },
	'pf25defaultclearsettings' => { 80 => 0x1a },
	'pf25drivemode' => { 79 => 0x11 },
	'pf25imagesize' => { 79 => 0x14 },
	'pf25meteringmode' => { 79 => 0x10 },
	'pf25parameters' => { 79 => 0x16 },
	'pf25wbmode' => { 79 => 0x15 },
	'pf26shortenreleaselag' => { 80 => 0x1b },
	'pf27reversedialrotation' => { 80 => 0x1c },
	'pf27value' => { 79 => 0x18 },
	'pf28noquickdialexpcomp' => { 80 => 0x1d },
	'pf29quickdialswitchoff' => { 80 => 0x1e },
	'pf2disablemeteringmodes' => { 80 => 0x3 },
	'pf2value' => { 79 => 0x2 },
	'pf30enlargementmode' => { 80 => 0x1f },
	'pf31originaldecisiondata' => { 80 => 0x20 },
	'pf3manualexposuremetering' => { 80 => 0x4 },
	'pf3value' => { 79 => 0x3 },
	'pf4exposuretimelimits' => { 80 => 0x5 },
	'pf4exposuretimemax' => { 79 => 0x5 },
	'pf4exposuretimemin' => { 79 => 0x4 },
	'pf5aperturelimits' => { 80 => 0x6 },
	'pf5aperturemax' => { 79 => 0x7 },
	'pf5aperturemin' => { 79 => 0x6 },
	'pf6presetshootingmodes' => { 80 => 0x7 },
	'pf7bracketcontinuousshoot' => { 80 => 0x8 },
	'pf8bracketshots' => { 79 => 0x8 },
	'pf8setbracketshots' => { 80 => 0x9 },
	'pf9changebracketsequence' => { 80 => 0xa },
	'phasedetectaf' => { 168 => 0x6 },
	'phonenumber' => { 135 => 'Phone' },
	'photoeffect' => { 30 => 0x28 },
	'photoeffecthistoryxml' => { 228 => 0xe9651831 },
	'photoeffects' => { 228 => 0xab5eca5e },
	'photoeffectsblue' => { 230 => 0x8 },
	'photoeffectsgreen' => { 230 => 0x6 },
	'photoeffectsred' => { 230 => 0x4 },
	'photoeffectstype' => { 230 => 0x0 },
	'photographicsensitivity' => { 400 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 235 => '17.6', 241 => '33.6' },
	'photometricinterpretation' => { 104 => 0x106, 416 => 'PhotometricInterpretation' },
	'photoshopbgrthumbnail' => { 313 => 0x409 },
	'photoshopquality' => { 312 => 0x0 },
	'photoshopthumbnail' => { 313 => 0x40c },
	'photostyle' => { 268 => 0x89 },
	'picklabel' => { 398 => 'PickLabel' },
	'pictinfo' => { 332 => 0x208 },
	'picturecontrol' => { 228 => 0xe2173c47 },
	'picturecontrolactive' => { 231 => 0x0 },
	'picturecontroladjust' => { 194 => 0x30 },
	'picturecontrolbase' => { 194 => 0x18 },
	'picturecontroldata' => { 192 => [0xbd,0x23] },
	'picturecontrolmode' => { 231 => 0x13 },
	'picturecontrolname' => { 194 => 0x4 },
	'picturecontrolquickadjust' => { 194 => 0x31 },
	'pictureeffect' => { 352 => 0x200e },
	'pictureeffect2' => { 359 => 0x1163, 360 => 0x1167, 361 => 0x1143, 362 => 0x11bf, 363 => 0x119b, 364 => 0x1053, 365 => 0x24b, 366 => 0x24b, 376 => 0x46 },
	'picturefinish' => { 157 => 0x71 },
	'picturemode' => { 109 => 0x1031, 248 => 0x520, 301 => [0xb,0x33], 333 => 0x3d },
	'picturemode2' => { 282 => 0x0 },
	'picturemodebwfilter' => { 248 => 0x525 },
	'picturemodecontrast' => { 248 => 0x523 },
	'picturemodeeffect' => { 248 => 0x52d },
	'picturemodehue' => { 248 => 0x522 },
	'picturemodesaturation' => { 248 => 0x521 },
	'picturemodesharpness' => { 248 => 0x524 },
	'picturemodetone' => { 248 => 0x526 },
	'pictureprofile' => { 359 => [0x115e,0x115f], 360 => [0x1162,0x1163], 361 => [0x113e,0x113f], 362 => [0x11ba,0x11bb], 363 => [0x1196,0x1197], 364 => [0x104e,0x104f], 365 => [0x246,0x247], 366 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 64 => 0xa, 90 => 0x20301, 96 => 0x2 },
	'picturewizard' => { 330 => 0x21 },
	'picturewizardcolor' => { 329 => 0x1 },
	'picturewizardcontrast' => { 329 => 0x4 },
	'picturewizardmode' => { 329 => 0x0 },
	'picturewizardsaturation' => { 329 => 0x2 },
	'picturewizardsharpness' => { 329 => 0x3 },
	'pipelineversion' => { 152 => 'PipelineVersion' },
	'pitch' => { 236 => '4.1', 245 => '4.1' },
	'pitchangle' => { 208 => 0x350f, 248 => 0x904, 268 => 0x91, 300 => 0x2 },
	'pixelshiftresolution' => { 302 => 0x0 },
	'pixelsperunitx' => { 259 => 0x0 },
	'pixelsperunity' => { 259 => 0x4 },
	'pixelunits' => { 259 => 0x8 },
	'planarconfiguration' => { 104 => 0x11c, 416 => 'PlanarConfiguration' },
	'platenames' => { 425 => 'PlateNames' },
	'platform' => { 410 => 'platform' },
	'playbackmenustime' => { 238 => '20.1', 239 => '21.1', 240 => '21.1' },
	'playbackmonitorofftime' => { 235 => '25.2', 236 => '36.1', 241 => '8.1', 242 => '35.1', 245 => '36.1', 246 => '21.1' },
	'playbackzoom' => { 236 => '37.1' },
	'playdisplay' => { 159 => 0x4e },
	'plusversion' => { 408 => 'Version' },
	'pmversion' => { 311 => 'PMVersion' },
	'pngwarning' => { 260 => 'Warning' },
	'poilevel' => { 191 => 0x8 },
	'portraitoutputhighlightpoint' => { 96 => 0x1d },
	'portraitoutputshadowpoint' => { 96 => 0x1e },
	'portraitrawcolortone' => { 96 => 0x16 },
	'portraitrawcontrast' => { 96 => 0x18 },
	'portraitrawhighlight' => { 96 => 0x76 },
	'portraitrawhighlightpoint' => { 96 => 0x1b },
	'portraitrawlinear' => { 96 => 0x19 },
	'portraitrawsaturation' => { 96 => 0x17 },
	'portraitrawshadow' => { 96 => 0x7f },
	'portraitrawshadowpoint' => { 96 => 0x1c },
	'portraitrawsharpness' => { 96 => 0x1a },
	'portraitrefiner' => { 100 => 0x302b },
	'portraitunsharpmaskfineness' => { 96 => 0x9a },
	'portraitunsharpmaskstrength' => { 96 => 0x98 },
	'portraitunsharpmaskthreshold' => { 96 => 0x9c },
	'poseheadingdegrees' => { 384 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 384 => 'PosePitchDegrees' },
	'poserolldegrees' => { 384 => 'PoseRollDegrees' },
	'positiondescriptor' => { 409 => 'positionDescriptor' },
	'postalcode' => { 139 => 'PostalCode' },
	'postcropvignetteamount' => { 395 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 395 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 395 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 395 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 395 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 395 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 350 => 0xb },
	'potentialface2position' => { 350 => 0x15 },
	'potentialface3position' => { 350 => 0x1f },
	'potentialface4position' => { 350 => 0x29 },
	'potentialface5position' => { 350 => 0x33 },
	'potentialface6position' => { 350 => 0x3d },
	'potentialface7position' => { 350 => 0x47 },
	'potentialface8position' => { 350 => 0x51 },
	'powersource' => { 280 => '0.1' },
	'poweruptime' => { 192 => 0xb6 },
	'precaptureframes' => { 253 => 0x300 },
	'predictor' => { 104 => 0x13d },
	'preflashreturnstrength' => { 206 => 0x28a },
	'prefs' => { 112 => 0xdd, 311 => 'Prefs' },
	'preservedfilename' => { 421 => 'PreservedFileName' },
	'presetwhitebalance' => { 159 => 0x24, 380 => 0x8002 },
	'presetwhitebalanceadj' => { 380 => 0x8014 },
	'previewapplicationname' => { 104 => 0xc716 },
	'previewapplicationversion' => { 104 => 0xc717 },
	'previewbutton' => { 235 => ['14.1','15.1'], 236 => '15.1', 241 => '29.1', 242 => '14.1', 245 => '15.1' },
	'previewbuttonplusdials' => { 235 => ['14.2','15.2'], 236 => '15.2', 241 => '31.2', 245 => '43.1' },
	'previewcolorspace' => { 104 => 0xc71a },
	'previewcropbottom' => { 310 => 0xef },
	'previewcropleft' => { 310 => 0xec },
	'previewcropright' => { 310 => 0xee },
	'previewcroptop' => { 310 => 0xed },
	'previewdate' => { 318 => 0x0 },
	'previewdatetime' => { 104 => 0xc71b },
	'previewimage' => { 100 => 0x2000, 101 => 'PreviewImage', 105 => 'PreviewImage', 107 => 0x4, 144 => 'data', 161 => 0x81, 253 => 0x280, 267 => 0x300, 352 => 0x2001 },
	'previewimageborders' => { 301 => 0x3e },
	'previewimageheight' => { 63 => 0x4, 122 => 0xfa58 },
	'previewimagelength' => { 63 => 0x2, 100 => 0x3, 104 => [0x117,0x202], 161 => 0x89, 195 => 0x202, 248 => 0x102, 253 => 0x1037, 301 => 0x3, 323 => 0x1e, 328 => 0x3, 333 => [0x1b,0x1d], 343 => 0x202 },
	'previewimagename' => { 144 => '1Name' },
	'previewimagesize' => { 100 => 0x2, 127 => 0x2, 144 => 'ImageSize', 301 => 0x2, 333 => [0x1c,0x1e], 352 => 0xb02c },
	'previewimagestart' => { 63 => 0x5, 100 => 0x4, 104 => [0x111,0x201], 161 => 0x88, 195 => 0x201, 248 => 0x101, 253 => 0x1036, 301 => 0x4, 323 => 0x1c, 328 => 0x2, 333 => [0x1a,0x1c], 343 => 0x201 },
	'previewimagetype' => { 144 => '0Type' },
	'previewimagevalid' => { 248 => 0x100, 253 => 0x1035 },
	'previewimagewidth' => { 63 => 0x3, 122 => 0xfa57 },
	'previewquality' => { 63 => 0x1 },
	'previewsettingsdigest' => { 104 => 0xc719 },
	'previewsettingsname' => { 104 => 0xc718 },
	'primaryafpoint' => { 168 => 0x7 },
	'primarychromaticities' => { 104 => 0x13f, 416 => 'PrimaryChromaticities' },
	'printim' => { 104 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 159 => 0x1d, 340 => 0x28 },
	'privatertkinfo' => { 386 => 'privateRTKInfo' },
	'processingsoftware' => { 104 => 0xb },
	'processversion' => { 395 => 'ProcessVersion' },
	'producer' => { 257 => 'Producer', 406 => 'Producer' },
	'productcode' => { 410 => 'productCode' },
	'productid' => { 113 => 0x32, 409 => 'productID' },
	'productidtype' => { 409 => 'productIDType' },
	'productinimage' => { 405 => 'ProductInImage' },
	'productinimagedescription' => { 405 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 405 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 405 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 281 => 0x2 },
	'productorserviceconstraints' => { 408 => 'ProductOrServiceConstraints' },
	'profession' => { 410 => 'profession' },
	'profilecalibrationsig' => { 104 => 0xc6f4 },
	'profilecopyright' => { 104 => 0xc6fe },
	'profileembedpolicy' => { 104 => 0xc6fd },
	'profilehuesatmapdata1' => { 104 => 0xc6fa },
	'profilehuesatmapdata2' => { 104 => 0xc6fb },
	'profilehuesatmapdims' => { 104 => 0xc6f9 },
	'profilehuesatmapencoding' => { 104 => 0xc7a3 },
	'profilelooktabledata' => { 104 => 0xc726 },
	'profilelooktabledims' => { 104 => 0xc725 },
	'profilelooktableencoding' => { 104 => 0xc7a4 },
	'profilename' => { 104 => 0xc6f8 },
	'profiletonecurve' => { 104 => 0xc6fc },
	'programiso' => { 268 => 0x3c },
	'programline' => { 282 => '1.1' },
	'programmode' => { 164 => 0x5 },
	'programshift' => { 192 => 0xd },
	'programversion' => { 112 => 0x46 },
	'prohibits' => { 392 => 'prohibits' },
	'projectiontype' => { 384 => 'ProjectionType' },
	'projectname' => { 420 => 'projectName' },
	'projectref' => { 420 => 'projectRef' },
	'projectrefpath' => { 420 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 420 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 408 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 408 => 'PropertyReleaseStatus' },
	'province-state' => { 112 => 0x5f },
	'publicationdate' => { 410 => 'publicationDate' },
	'publicationdatea-platform' => { 410 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 410 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 410 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 410 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 410 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 410 => 'publicationName' },
	'publisher' => { 396 => 'publisher' },
	'publishingfrequency' => { 410 => 'publishingFrequency' },
	'pulldown' => { 420 => 'pullDown' },
	'purplehsl' => { 90 => 0x20916 },
	'quality' => { 0 => 0x1, 30 => 0x3, 99 => 0x2, 100 => 0x3002, 109 => 0x1000, 120 => 0x9, 192 => 0x4, 218 => 0x3, 253 => 0x201, 264 => 0x300, 301 => 0x8, 308 => 0x2, 333 => 0x16, 340 => 0x56, 341 => 0x56, 342 => 0xb, 352 => 0x102 },
	'quality2' => { 359 => 0x1170, 360 => 0x1174, 361 => 0x1150, 363 => 0x11a8, 364 => 0x1060, 365 => 0x258, 366 => 0x258, 368 => 0x29, 369 => 0x25, 370 => 0x2a },
	'qualitymode' => { 100 => 0x8 },
	'quantizationmethod' => { 114 => 0x78 },
	'quickadjust' => { 231 => 0x2a },
	'quickcontroldialinmeter' => { 72 => 0x703 },
	'quickfix' => { 228 => 0x416391c6 },
	'quickshot' => { 332 => 0x213 },
	'rangefinder' => { 238 => '4.1', 239 => '5.1', 240 => '5.1' },
	'rasterizedcaption' => { 112 => 0x7d },
	'rating' => { 104 => 0x4746, 109 => 0x1431, 310 => 0xdf, 352 => 0x2002, 389 => 'rating', 397 => 'rating', 410 => 'rating', 418 => 'Rating' },
	'ratingpercent' => { 104 => 0x4749, 154 => 'Rating' },
	'rawandjpgrecording' => { 70 => 0x8, 161 => 0x109, 282 => 0xd },
	'rawbrightnessadj' => { 90 => 0x20001, 95 => 0x38 },
	'rawcoloradj' => { 95 => 0x2e },
	'rawcompressionmode' => { 330 => 0x45 },
	'rawcropbottom' => { 310 => 0xd4 },
	'rawcropleft' => { 310 => 0xd1 },
	'rawcropright' => { 310 => 0xd3 },
	'rawcroptop' => { 310 => 0xd2 },
	'rawcustomsaturation' => { 95 => 0x30 },
	'rawcustomtone' => { 95 => 0x34 },
	'rawdata' => { 330 => 0xa048 },
	'rawdatauniqueid' => { 104 => 0xc65d },
	'rawdepth' => { 163 => 0x10 },
	'rawdevartfilter' => { 255 => 0x121 },
	'rawdevautogradation' => { 255 => 0x119 },
	'rawdevcolorspace' => { 254 => 0x108, 255 => 0x109 },
	'rawdevcontrastvalue' => { 254 => 0x106, 255 => 0x105 },
	'rawdeveditstatus' => { 254 => 0x10b },
	'rawdevelopmentprocess' => { 301 => 0x62 },
	'rawdevengine' => { 254 => 0x109, 255 => 0x10b },
	'rawdevexposurebiasvalue' => { 254 => 0x100, 255 => 0x100 },
	'rawdevgradation' => { 255 => 0x112 },
	'rawdevgraypoint' => { 254 => 0x103, 255 => 0x104 },
	'rawdevmemorycoloremphasis' => { 254 => 0x105, 255 => 0x108 },
	'rawdevnoisereduction' => { 254 => 0x10a, 255 => 0x10a },
	'rawdevpicturemode' => { 255 => 0x10c },
	'rawdevpm_bwfilter' => { 255 => 0x110 },
	'rawdevpmcontrast' => { 255 => 0x10e },
	'rawdevpmnoisefilter' => { 255 => 0x120 },
	'rawdevpmpicturetone' => { 255 => 0x111 },
	'rawdevpmsaturation' => { 255 => 0x10d },
	'rawdevpmsharpness' => { 255 => 0x10f },
	'rawdevsaturation3' => { 255 => 0x113 },
	'rawdevsaturationemphasis' => { 254 => 0x104, 255 => 0x107 },
	'rawdevsettings' => { 254 => 0x10c },
	'rawdevsharpnessvalue' => { 254 => 0x107, 255 => 0x106 },
	'rawdevversion' => { 254 => 0x0, 255 => 0x0 },
	'rawdevwbfineadjustment' => { 254 => 0x102, 255 => 0x103 },
	'rawdevwhitebalance' => { 255 => 0x101 },
	'rawdevwhitebalancevalue' => { 254 => 0x101, 255 => 0x102 },
	'rawfile' => { 104 => 0xfe4c },
	'rawfilename' => { 395 => 'RawFileName' },
	'rawimagecenter' => { 192 => 0x99 },
	'rawimagedigest' => { 104 => 0xc71c },
	'rawimagesize' => { 301 => 0x39 },
	'rawinfoversion' => { 256 => 0x0 },
	'rawjpgheight' => { 87 => 0x4 },
	'rawjpgquality' => { 48 => 0x6, 87 => 0x1 },
	'rawjpgsize' => { 48 => 0x7, 87 => 0x2 },
	'rawjpgwidth' => { 87 => 0x3 },
	'rawmeasuredrggb' => { 35 => 0x26a, 37 => 0x280, 39 => 0x194, 40 => [0x1ad,0x26b] },
	'rawrppused' => { 389 => 'rawrppused' },
	'rawtopreviewgain' => { 104 => 0xc7a8 },
	'reardisplay' => { 235 => '12.3', 236 => '6.2' },
	'recipeendingpage' => { 412 => 'recipeEndingPage' },
	'recipepagerange' => { 412 => 'recipePageRange' },
	'recipesource' => { 412 => 'recipeSource' },
	'recipestartingpage' => { 412 => 'recipeStartingPage' },
	'recipetitle' => { 412 => 'recipeTitle' },
	'recognizedface1age' => { 263 => 0x20 },
	'recognizedface1name' => { 263 => 0x4 },
	'recognizedface1position' => { 263 => 0x18 },
	'recognizedface2age' => { 263 => 0x50 },
	'recognizedface2name' => { 263 => 0x34 },
	'recognizedface2position' => { 263 => 0x48 },
	'recognizedface3age' => { 263 => 0x80 },
	'recognizedface3name' => { 263 => 0x64 },
	'recognizedface3position' => { 263 => 0x78 },
	'recognizedfaceflags' => { 268 => 0x63 },
	'recommendedexposureindex' => { 104 => 0x8832, 400 => 'RecommendedExposureIndex' },
	'record' => { 103 => 'Record' },
	'recordbasisofrecord' => { 103 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 103 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 103 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 103 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 103 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 103 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 159 => 0x4d },
	'recorddynamicproperties' => { 103 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 85 => 0x1804 },
	'recordinformationwithheld' => { 103 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 324 => 0x1000 },
	'recordingmode' => { 99 => 0x1, 308 => 0x1 },
	'recordinstitutioncode' => { 103 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 103 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 30 => 0x9, 100 => 0x3000 },
	'recordownerinstitutioncode' => { 103 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 332 => 0x217 },
	'redbalance' => { 176 => 0x270, 253 => 0x1017, 272 => 0x11, 301 => 0x1c },
	'redcurvelimits' => { 95 => 0x18a },
	'redcurvepoints' => { 94 => 0x2d, 95 => 0x160 },
	'redeyecorrection' => { 232 => 0x0 },
	'redeyeinfo' => { 395 => 'RedEyeInfo' },
	'redeyereduction' => { 159 => 0x41, 340 => 0x6a, 342 => 0x28 },
	'redhsl' => { 90 => 0x20910 },
	'redhue' => { 395 => 'RedHue' },
	'redsaturation' => { 395 => 'RedSaturation' },
	'reductionmatrix1' => { 104 => 0xc625 },
	'reductionmatrix2' => { 104 => 0xc626 },
	'reelname' => { 104 => 0xc789 },
	'reference1' => { 403 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 403 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 104 => 0x214, 416 => 'ReferenceBlackWhite' },
	'referencedate' => { 112 => 0x2f },
	'referencenumber' => { 112 => 0x32 },
	'references' => { 135 => 'References' },
	'referenceservice' => { 112 => 0x2d },
	'regionappliedtodimensions' => { 150 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 150 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 150 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 150 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 150 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 150 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 150 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 150 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 150 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 150 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 150 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 150 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 408 => 'RegionConstraints' },
	'regiondescription' => { 150 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 150 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 150 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 150 => 'Regions' },
	'regioninfodateregionsvalid' => { 151 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 151 => 'RegionInfo' },
	'regioninforegions' => { 151 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 150 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 150 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 151 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 151 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 151 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 151 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 151 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 150 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 150 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 150 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 405 => 'RegistryId' },
	'registryitemid' => { 405 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 405 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 133 => 'data' },
	'relatedaudiofilename' => { 133 => '1Name' },
	'relatedaudiofiletype' => { 133 => '0Type' },
	'relatedimagefileformat' => { 104 => 0x1000 },
	'relatedimageheight' => { 104 => 0x1002 },
	'relatedimagewidth' => { 104 => 0x1001 },
	'relatedresourceid' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 104 => 0xa004, 399 => 'RelatedSoundFile' },
	'relatedvideofile' => { 147 => 'data' },
	'relatedvideofilename' => { 147 => '1Name' },
	'relatedvideofiletype' => { 147 => '0Type' },
	'relation' => { 396 => 'relation' },
	'relationshipaccordingto' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 420 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 420 => 'relativeTimestamp' },
	'relativetimestampscale' => { 420 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 420 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 235 => '17.8', 236 => '18.5', 241 => '33.8', 242 => '17.6', 245 => '18.5' },
	'releasedate' => { 112 => 0x1e, 420 => 'releaseDate' },
	'releasemode' => { 100 => 0x3001, 352 => 0xb049 },
	'releasemode2' => { 359 => 0x112c, 360 => [0x112c,0x8], 361 => [0x1108,0x8], 362 => [0x1184,0x8], 363 => [0x1160,0x8], 364 => [0x4,0x1018], 365 => [0x4,0x210], 366 => [0x4,0x210], 367 => [0x67,0x73,0x3f,0x4b], 368 => 0x10, 369 => 0x10, 370 => 0x9, 376 => 0x34 },
	'releasemode3' => { 359 => 0x1128, 360 => 0x1128, 361 => 0x1104, 362 => 0x1180, 363 => 0x115c, 364 => 0x1014, 365 => 0x20c, 366 => 0x20c },
	'releasesetting' => { 85 => 0x1016 },
	'releasetime' => { 112 => 0x23 },
	'remoteonduration' => { 237 => '3.4', 238 => '17.2', 239 => '18.2', 240 => '18.2', 242 => '18.2', 243 => '4.3', 246 => '19.2' },
	'renditionclass' => { 421 => 'RenditionClass' },
	'renditionof' => { 421 => 'RenditionOf' },
	'renditionofalternatepaths' => { 421 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 421 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 421 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 421 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 421 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 421 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 421 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 421 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 421 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 421 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 421 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 421 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 421 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 421 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 421 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 421 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 421 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 421 => 'RenditionParams' },
	'repeatingflashcount' => { 181 => 0xd, 182 => 0xe, 183 => 0xe, 241 => '17.2', 242 => '24.2', 243 => '9.2', 244 => '24.2', 246 => '25.2' },
	'repeatingflashcountbuilt-in' => { 215 => 0x4db },
	'repeatingflashcountexternal' => { 215 => 0x4c3 },
	'repeatingflashoutput' => { 241 => '17.1', 242 => '24.1', 243 => '9.1', 244 => '24.1', 246 => '25.1' },
	'repeatingflashoutputexternal' => { 215 => 0x4c0 },
	'repeatingflashrate' => { 181 => 0xc, 182 => 0xd, 183 => 0xd, 241 => '18.1', 242 => '25.1', 243 => '10.1', 244 => '25.1', 246 => '26.1' },
	'repeatingflashratebuilt-in' => { 215 => 0x4da },
	'repeatingflashrateexternal' => { 215 => 0x4c2 },
	'requires' => { 392 => 'requires' },
	'resampleparams' => { 420 => 'resampleParams' },
	'resampleparamsquality' => { 420 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 332 => 0x21e },
	'resolution' => { 140 => 'Resolution' },
	'resolutionmode' => { 333 => 0x4 },
	'resolutionunit' => { 104 => 0x128, 115 => 0x2, 416 => 'ResolutionUnit' },
	'resourceid' => { 103 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 103 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 103 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 72 => 0x612 },
	'restrictions' => { 413 => 'restrictions' },
	'retouchareafeather' => { 395 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 395 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 395 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 395 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 395 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 395 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 395 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 395 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 395 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 395 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 395 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 395 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 395 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 395 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 395 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 395 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 395 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 395 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 395 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 395 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 395 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 395 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 395 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 395 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 395 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 395 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 395 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 395 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 395 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 395 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 395 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 395 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 395 => 'RetouchAreas' },
	'retouchareaseed' => { 395 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 395 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 395 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 395 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 192 => 0x9e },
	'retouchinfo' => { 395 => 'RetouchInfo' },
	'retouchnefprocessing' => { 197 => 0x5 },
	'reuse' => { 408 => 'Reuse' },
	'reuseallowed' => { 423 => 'ReuseAllowed' },
	'reuseprohibited' => { 413 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 240 => '5.2' },
	'reverseindicators' => { 235 => '12.1', 236 => '6.1', 238 => '4.3', 239 => '5.2', 240 => '5.4', 241 => '33.5', 242 => '5.1', 245 => '6.1', 246 => '6.2' },
	'reverseshutterspeedaperture' => { 240 => '5.3' },
	'revision' => { 397 => 'revision' },
	'rgbcurvelimits' => { 95 => 0x238 },
	'rgbcurvepoints' => { 94 => 0x7, 95 => 0x20e },
	'richtextcomment' => { 402 => 'RichTextComment' },
	'ricohdate' => { 323 => 0x6 },
	'ricohimageheight' => { 323 => 0x2 },
	'ricohimagewidth' => { 323 => 0x0 },
	'rightascension' => { 143 => 'RightAscension' },
	'rights' => { 396 => 'rights' },
	'rightsagent' => { 413 => 'rightsAgent' },
	'rightsowner' => { 413 => 'rightsOwner' },
	'rollangle' => { 208 => 0x350b, 248 => 0x903, 268 => 0x90, 300 => 0x1 },
	'romoperationmode' => { 85 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 84 => 0x3, 90 => 0x10002, 95 => 0x26e, 108 => 0x4, 143 => 'Rotation', 157 => [0x65,0x50], 158 => 0x46, 159 => 0x5a, 162 => 0x10, 214 => '590.1', 228 => 0x76a43207, 268 => 0x30, 282 => '17.2', 310 => 0xd8, 340 => 0x3f, 341 => 0x3f, 351 => 0x10 },
	'routedto' => { 401 => 'RoutedTo' },
	'routing' => { 315 => 'Routing' },
	'routingnotes' => { 401 => 'RoutingNotes' },
	'rowsperstrip' => { 104 => 0x116 },
	'rpp' => { 389 => 'rpp' },
	'safetyshift' => { 72 => 0x108 },
	'safetyshiftinavortv' => { 70 => 0x10, 71 => 0x10, 73 => 0xf, 74 => 0x10, 77 => 0x10 },
	'samplebits' => { 133 => 'SampleBits' },
	'samplepagerange' => { 410 => 'samplePageRange' },
	'samplerate' => { 133 => 'SampleRate' },
	'samplesperpixel' => { 104 => 0x115, 416 => 'SamplesPerPixel' },
	'samplestructure' => { 114 => 0x5a },
	'samsungmodelid' => { 330 => 0x3 },
	'sanyoquality' => { 332 => 0x201 },
	'sanyothumbnail' => { 332 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 30 => 0xe, 42 => 0x1, 99 => 0xd, 100 => [0x3013,0x1f], 104 => [0xa409,0xfe55], 109 => 0x1003, 134 => 'Saturation', 156 => 0x1f, 157 => 0x32, 158 => 0x28, 159 => 0x1a, 164 => 0x1, 192 => [0x94,0xaa], 194 => 0x35, 268 => 0x40, 270 => 0x300d, 301 => 0x1f, 308 => 0xd, 320 => 0x27, 323 => 0x28, 324 => 0x1013, 333 => 0x10, 340 => 0x1e, 341 => 0x1b, 352 => 0x2005, 395 => 'Saturation', 399 => 'Saturation' },
	'saturationadj' => { 90 => 0x20901, 95 => 0x116, 227 => 0x1, 231 => 0x2e, 380 => 0x8016 },
	'saturationadjustmentaqua' => { 395 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 395 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 395 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 395 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 395 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 395 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 395 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 395 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 61 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 60 => 0x68, 61 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 60 => 0x38, 61 => 0x38 },
	'saturationmonochrome' => { 60 => 0x80, 61 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 60 => 0x50, 61 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 60 => 0x20, 61 => 0x20 },
	'saturationsetting' => { 256 => 0x1010, 342 => 0x11, 356 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 60 => 0x8, 61 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 60 => 0x98, 61 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 60 => 0xb0, 61 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 60 => 0xc8, 61 => 0xe0 },
	'saveid' => { 421 => 'SaveID' },
	'scaletype' => { 420 => 'scaleType' },
	'scanimageenhancer' => { 198 => 0x60 },
	'scanningdirection' => { 114 => 0x64 },
	'scene' => { 404 => 'Scene', 420 => 'scene' },
	'scenearea' => { 251 => 0x211, 253 => 0x1031 },
	'sceneassist' => { 192 => 0x9c },
	'scenecapturetype' => { 104 => 0xa406, 399 => 'SceneCaptureType' },
	'scenedetect' => { 251 => 0x210, 253 => 0x1030 },
	'scenedetectdata' => { 251 => 0x212, 253 => 0x1033 },
	'scenemode' => { 122 => 0xfa02, 161 => 0x100, 192 => 0x8f, 248 => 0x509, 253 => 0x403, 268 => 0x8001, 276 => 0xf, 352 => 0xb023 },
	'scenemodeused' => { 124 => [0x6002,0xf002] },
	'sceneselect' => { 332 => 0x21f },
	'scenetype' => { 104 => 0xa301, 399 => 'SceneType' },
	'screentips' => { 235 => '12.7', 236 => '5.3', 241 => '13.1', 242 => '4.4', 245 => '5.4', 246 => '5.1' },
	'season' => { 409 => 'season' },
	'section' => { 410 => 'section' },
	'securityclassification' => { 104 => 0x9212 },
	'selectableafpoint' => { 72 => 0x509 },
	'selectafareaselectmode' => { 72 => 0x512 },
	'selftimer' => { 30 => 0x2, 268 => 0x2e, 332 => 0x214 },
	'selftimer2' => { 66 => 0x1d },
	'selftimerinterval' => { 242 => '19.2' },
	'selftimermode' => { 104 => 0x882b },
	'selftimershotcount' => { 236 => '20.2', 238 => '18.2', 239 => '19.2', 240 => '19.2', 242 => '19.3', 245 => '20.3', 246 => '20.2' },
	'selftimershotinterval' => { 236 => '20.3', 245 => '20.2' },
	'selftimertime' => { 85 => 0x1806, 159 => 0x1f, 235 => '18.1', 236 => '20.1', 237 => '3.3', 238 => '18.1', 239 => '19.1', 240 => '19.1', 241 => '7.2', 242 => '19.1', 243 => '3.3', 245 => '20.1', 246 => '20.1' },
	'sellingagency' => { 410 => 'sellingAgency' },
	'seminfo' => { 104 => 0x8546 },
	'sensingmethod' => { 104 => 0xa217, 399 => 'SensingMethod' },
	'sensitivityadjust' => { 301 => 0x40 },
	'sensitivitysteps' => { 282 => ['14.3','17.4'], 284 => 0x1 },
	'sensitivitytype' => { 104 => 0x8830, 400 => 'SensitivityType' },
	'sensor' => { 166 => 0x665e },
	'sensorareas' => { 330 => 0xa010 },
	'sensorbitdepth' => { 270 => 0x312d },
	'sensorbluelevel' => { 64 => 0x5 },
	'sensorcalibration' => { 252 => 0x805 },
	'sensorcleaning' => { 78 => 0xd },
	'sensorfullheight' => { 117 => 0xf904 },
	'sensorfullwidth' => { 117 => 0xf903 },
	'sensorheight' => { 117 => 0xf901, 122 => 0xfa21, 163 => 0x8, 270 => 0x312c, 324 => 0x1602 },
	'sensorpixelsize' => { 192 => 0x9a },
	'sensorredlevel' => { 64 => 0x4 },
	'sensorserialnumber' => { 118 => 0x9ce },
	'sensorsize' => { 134 => 'SensorSize', 301 => 0x35 },
	'sensortemperature' => { 251 => 0x1500, 253 => 0x1007, 306 => 0xc, 333 => [0x39,0x55] },
	'sensortemperature2' => { 306 => 0xe },
	'sensorwidth' => { 117 => 0xf900, 122 => 0xfa20, 163 => 0xa, 270 => 0x312b, 324 => 0x1601 },
	'sequence' => { 320 => 0x7 },
	'sequencefilenumber' => { 360 => 0x4, 361 => 0x4, 362 => 0x4, 363 => 0x4, 368 => 0xc, 369 => 0xc, 370 => 0x1a },
	'sequenceimagenumber' => { 360 => 0x0, 361 => 0x0, 362 => 0x0, 363 => 0x0, 368 => 0x8, 369 => 0x8, 370 => 0x12, 376 => 0x24 },
	'sequencelength' => { 368 => 0x22, 369 => 0x1e, 370 => [0x16,0x1e] },
	'sequencename' => { 409 => 'sequenceName' },
	'sequencenumber' => { 66 => 0x9, 100 => 0x301c, 109 => 0x1101, 120 => 0x1d, 215 => 0x51c, 268 => 0x2b, 342 => [0x10c,0x30c], 352 => 0xb04a, 409 => 'sequenceNumber' },
	'sequenceshotinterval' => { 332 => 0x224 },
	'sequencetotalnumber' => { 409 => 'sequenceTotalNumber' },
	'sequentialshot' => { 332 => 0x20e },
	'serialnumber' => { 54 => 0xc, 85 => 0x180b, 104 => [0xa431,0xfde9], 117 => 0xfa04, 119 => 0xfa00, 121 => 0xc354, 122 => 0xfa19, 131 => 0x0, 134 => 'SerialNumber', 192 => [0xa0,0x1d], 249 => 0x101, 253 => [0x404,0x101a], 264 => 0x303, 270 => 0x3103, 301 => 0x229, 320 => 0x15, 324 => 0x5, 333 => 0x2, 391 => 'SerialNumber', 400 => 'BodySerialNumber' },
	'serialnumberformat' => { 54 => 0x15, 85 => 0x183b },
	'seriesdatetime' => { 382 => 'SeriesDateTime' },
	'seriesdescription' => { 382 => 'SeriesDescription' },
	'seriesmodality' => { 382 => 'SeriesModality' },
	'seriesnumber' => { 382 => 'SeriesNumber', 410 => 'seriesNumber' },
	'seriestitle' => { 410 => 'seriesTitle' },
	'serviceidentifier' => { 113 => 0x1e },
	'servingsize' => { 412 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 75 => 0x0, 76 => 0x0 },
	'setbuttonwhenshooting' => { 70 => 0x1, 72 => 0x704, 78 => 0xc },
	'setfunctionwhenshooting' => { 73 => 0x0, 74 => 0x1, 77 => 0x1 },
	'setting' => { 409 => 'setting' },
	'shadingcompensation' => { 248 => 0x50c, 268 => 0x8a },
	'shadingcompensation2' => { 252 => 0x1012 },
	'shadow' => { 333 => 0xe },
	'shadowadj' => { 90 => 0x2030b },
	'shadowcorrection' => { 301 => 0x79 },
	'shadowprotection' => { 227 => 0x0 },
	'shadows' => { 104 => 0xfe52, 388 => 'Shadows', 395 => 'Shadows' },
	'shadows2012' => { 395 => 'Shadows2012' },
	'shadowscale' => { 104 => 0xc633 },
	'shadowtint' => { 395 => 'ShadowTint' },
	'shadowtone' => { 109 => 0x1040 },
	'shakereduction' => { 303 => 0x1, 304 => 0x1 },
	'sharpendetail' => { 395 => 'SharpenDetail' },
	'sharpenedgemasking' => { 395 => 'SharpenEdgeMasking' },
	'sharpening' => { 270 => 0x300b },
	'sharpeningadj' => { 231 => 0x2b },
	'sharpenradius' => { 395 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 30 => 0xf, 64 => 0x2, 99 => 0xb, 100 => [0x3011,0x21], 104 => [0xa40a,0xfe56], 109 => 0x1001, 120 => 0x6b, 129 => 0x37, 134 => 'Sharpness', 156 => 0x21, 157 => 0x30, 158 => 0x26, 159 => 0x18, 164 => 0x3, 192 => 0x6, 194 => 0x32, 253 => 0x100f, 268 => 0x41, 301 => 0x21, 308 => 0xb, 320 => 0x26, 323 => 0x22, 324 => [0x1003,0x1014], 333 => 0x11, 340 => 0x1c, 341 => 0x19, 352 => 0x2006, 376 => 0x52, 395 => 'Sharpness', 399 => 'Sharpness' },
	'sharpnessadj' => { 90 => 0x20310, 95 => 0x25a, 380 => 0x801a },
	'sharpnessadjon' => { 90 => '0x20310.0' },
	'sharpnessauto' => { 61 => 0x94 },
	'sharpnessfactor' => { 253 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 60 => 0x64, 61 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 64 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 60 => 0x34, 61 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 60 => 0x7c, 61 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 60 => 0x4c, 61 => 0x4c },
	'sharpnessovershoot' => { 380 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 60 => 0x1c, 61 => 0x1c },
	'sharpnesssetting' => { 248 => 0x506, 256 => 0x1013, 342 => 0x12, 356 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 60 => 0x4, 61 => 0x4 },
	'sharpnessstrength' => { 90 => 0x20311 },
	'sharpnessthreshold' => { 380 => 0x801d },
	'sharpnessundershoot' => { 380 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 60 => 0x94, 61 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 60 => 0xac, 61 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 60 => 0xc4, 61 => 0xdc },
	'shootid' => { 409 => 'shootID' },
	'shootingdistance' => { 90 => 0x20701 },
	'shootinginfodisplay' => { 235 => '13.2', 236 => '5.1', 241 => '10.2', 242 => '4.1', 245 => '5.1', 246 => '5.3' },
	'shootinginfomonitorofftime' => { 235 => '26.2', 236 => '22.2', 241 => '9.1', 242 => '21.2', 245 => '22.2', 246 => '22.2' },
	'shootingmode' => { 134 => 'ShootingMode', 192 => 0x89, 268 => 0x1f },
	'shootingmodesetting' => { 237 => '5.1' },
	'shortdescription' => { 397 => 'shortdescription' },
	'shortdocumentid' => { 112 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 72 => 0x80d },
	'shotdate' => { 420 => 'shotDate' },
	'shotday' => { 420 => 'shotDay' },
	'shotlocation' => { 420 => 'shotLocation' },
	'shotname' => { 420 => 'shotName' },
	'shotnumber' => { 420 => 'shotNumber' },
	'shotnumbersincepowerup' => { 355 => 0x44e, 368 => 0x1a, 369 => 0x16, 370 => 0xa },
	'shotnumbersincepowerup2' => { 342 => 0x200 },
	'shotsize' => { 420 => 'shotSize' },
	'shutter-aelock' => { 70 => 0x4, 72 => 0x701, 73 => 0x3, 74 => 0x4, 75 => 0x3, 76 => 0x3, 77 => 0x4, 78 => 0x2 },
	'shutteraelbutton' => { 71 => 0x4 },
	'shutterbuttonafonbutton' => { 72 => 0x701 },
	'shuttercount' => { 10 => 0x176, 48 => 0x1, 192 => 0xa7, 199 => [0x6a,0x157,0x24d], 200 => 0x286, 201 => 0x279, 202 => 0x284, 203 => 0x242, 204 => 0x280, 205 => 0x276, 206 => [0x27d,0x27f], 207 => 0x246, 209 => 0x2d6, 210 => 0x321, 211 => 0xbd8, 212 => 0x287, 213 => 0x320, 214 => 0x24a, 215 => 0x5fb, 217 => 0x2d5, 301 => 0x5d, 351 => 0x846, 354 => [0x125,0x14a] },
	'shuttercurtainsync' => { 70 => 0xf, 71 => 0xf, 72 => 0x305, 73 => 0xe, 74 => 0xf, 75 => 0x8, 76 => 0x8, 77 => 0xf, 78 => 0x8 },
	'shuttermode' => { 120 => 0x1b },
	'shutterreleasebuttonae-l' => { 235 => '17.7', 236 => '18.4', 238 => '16.1', 239 => '17.1', 240 => '17.1', 241 => '7.1', 242 => '17.5', 245 => '18.4', 246 => '18.2' },
	'shutterreleasemethod' => { 85 => 0x1010 },
	'shutterreleasenocfcard' => { 70 => 0x2, 71 => 0x2, 78 => 0xf },
	'shutterreleasetiming' => { 85 => 0x1011 },
	'shutterreleasewithoutlens' => { 72 => 0x711 },
	'shutterspeedlock' => { 236 => '38.1', 245 => '38.1' },
	'shutterspeedrange' => { 72 => 0x10c },
	'shutterspeedsetting' => { 159 => 0x6, 340 => 0x2f, 341 => 0x28, 342 => 0x0 },
	'shutterspeedvalue' => { 81 => 0x1, 104 => 0x9201, 253 => 0x1000, 399 => 'ShutterSpeedValue' },
	'shuttertype' => { 109 => 0x1050, 268 => 0x9f },
	'sidecarforextension' => { 407 => 'SidecarForExtension' },
	'similarityindex' => { 112 => 0xe4 },
	'singleframebracketing' => { 159 => 0x21 },
	'skilllevel' => { 412 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 301 => 0x20b },
	'slideshowname' => { 409 => 'slideshowName' },
	'slideshownumber' => { 409 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 409 => 'slideshowTotalNumber' },
	'slowshutter' => { 66 => 0x8 },
	'slowsync' => { 109 => 0x1030 },
	'smartrange' => { 330 => 0xa012 },
	'smileshutter' => { 342 => 0x31 },
	'smileshuttermode' => { 342 => 0x27 },
	'smoothness' => { 104 => 0xfe57, 395 => 'Smoothness' },
	'softskineffect' => { 352 => 0x200f },
	'software' => { 104 => 0x131, 135 => 'Software', 260 => 'Software', 333 => 0x18, 416 => 'Software' },
	'softwareversion' => { 332 => 0x207 },
	'sonydatetime' => { 358 => 0x6, 360 => 0x1b6, 361 => 0x210, 362 => 0x1fe, 363 => 0x22c },
	'sonydatetime2' => { 367 => [0x51,0x5d] },
	'sonyexposuretime' => { 367 => 0x46 },
	'sonyexposuretime2' => { 376 => 0xe },
	'sonyfnumber' => { 367 => [0x3c,0x48], 376 => 0x14 },
	'sonyimageheight' => { 358 => 0x1a, 368 => 0x44, 369 => 0x3f, 370 => 0x47 },
	'sonyimagesize' => { 159 => 0x3b, 340 => 0x54, 341 => 0x54, 342 => 0x9 },
	'sonyimagewidth' => { 358 => 0x1c },
	'sonyiso' => { 360 => 0x1218, 361 => 0x11f4, 362 => 0x1270, 363 => [0x1254,0x1258,0x1280], 364 => 0x113c, 365 => 0x344, 366 => 0x346, 376 => 0x4 },
	'sonymaxaperturevalue' => { 376 => 0x16 },
	'sonymodelid' => { 352 => 0xb001 },
	'sonyquality' => { 159 => 0x3c },
	'source' => { 112 => 0x73, 260 => 'Source', 396 => 'source', 397 => 'source', 407 => 'Source' },
	'sourcedirectoryindex' => { 288 => 0x0 },
	'sourcefileindex' => { 288 => 0x2 },
	'sourcephotoscount' => { 384 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 399 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 399 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 399 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 399 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 399 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 420 => 'speakerPlacement' },
	'specialeffectlevel' => { 100 => 0x3030 },
	'specialeffectmode' => { 100 => 0x2076 },
	'specialeffectsetting' => { 100 => 0x3031 },
	'specialinstructions' => { 112 => 0x28 },
	'specialmode' => { 253 => 0x200, 332 => 0x200 },
	'specialoccasion' => { 412 => 'specialOccasion' },
	'spectralsensitivity' => { 104 => 0x8824, 399 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 37 => [0x2b9,0x2d0,0x2d4], 39 => 0x1e4, 40 => [0x1fd,0x2dd], 41 => 0x30f },
	'splittoningbalance' => { 395 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 395 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 395 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 395 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 395 => 'SplitToningShadowSaturation' },
	'sport' => { 410 => 'sport' },
	'spotfocuspointx' => { 156 => 0x2d },
	'spotfocuspointy' => { 156 => 0x2e },
	'spotmeteringmode' => { 30 => 0x27 },
	'spotmeterlinktoafpoint' => { 72 => 0x107 },
	'sractive' => { 282 => '17.1' },
	'srawquality' => { 30 => 0x2e },
	'srfocallength' => { 303 => 0x3 },
	'srhalfpresstime' => { 303 => 0x2 },
	'srresult' => { 303 => 0x0, 304 => 0x0 },
	'standardoutputhighlightpoint' => { 96 => 0x14 },
	'standardoutputsensitivity' => { 104 => 0x8831, 400 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 96 => 0x15 },
	'standardrawcolortone' => { 96 => 0xd },
	'standardrawcontrast' => { 96 => 0xf },
	'standardrawhighlight' => { 96 => 0x75 },
	'standardrawhighlightpoint' => { 96 => 0x12 },
	'standardrawlinear' => { 96 => 0x10 },
	'standardrawsaturation' => { 96 => 0xe },
	'standardrawshadow' => { 96 => 0x7e },
	'standardrawshadowpoint' => { 96 => 0x13 },
	'standardrawsharpness' => { 96 => 0x11 },
	'standardunsharpmaskfineness' => { 96 => 0x94 },
	'standardunsharpmaskstrength' => { 96 => 0x92 },
	'standardunsharpmaskthreshold' => { 96 => 0x96 },
	'standbytimer' => { 236 => '19.1', 240 => '18.1', 245 => '19.1' },
	'startingpage' => { 410 => 'startingPage' },
	'startmovieshooting' => { 72 => 0x70d },
	'starttimecode' => { 420 => 'startTimecode' },
	'starttimecodetimeformat' => { 420 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 420 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 420 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 420 => 'startTimeSampleSize' },
	'starttimescale' => { 420 => 'startTimeScale' },
	'state' => { 139 => 'State', 268 => 0x6b, 407 => 'State' },
	'status' => { 383 => 'Status', 387 => 'Status' },
	'stitchingsoftware' => { 384 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 359 => 0x113e, 360 => 0x113e, 361 => 0x111a, 362 => 0x1196, 363 => 0x1172, 364 => 0x102a, 365 => 0x222, 366 => 0x222, 376 => 0xa },
	'storagemethod' => { 163 => 0x12 },
	'storebyorientation' => { 236 => '46.3', 245 => '47.3' },
	'straightenangle' => { 228 => 0x2fc08431 },
	'streamtype' => { 152 => 'StreamType' },
	'stretchmode' => { 420 => 'stretchMode' },
	'studydatetime' => { 382 => 'StudyDateTime' },
	'studydescription' => { 382 => 'StudyDescription' },
	'studyid' => { 382 => 'StudyID' },
	'studyphysician' => { 382 => 'StudyPhysician' },
	'sub-location' => { 112 => 0x5c },
	'subfiledata' => { 142 => 'data' },
	'subfiledirectory' => { 142 => '1Directory' },
	'subfilemimetype' => { 142 => '2MIME' },
	'subfilename' => { 142 => '1Name' },
	'subfileresource' => { 142 => 'rsrc' },
	'subfiletype' => { 104 => 0xfe, 142 => '0Type' },
	'subject' => { 257 => 'Subject', 315 => 'Subject', 396 => 'subject', 406 => 'Subject', 421 => 'subject' },
	'subjectarea' => { 104 => 0x9214, 399 => 'SubjectArea' },
	'subjectcode' => { 404 => 'SubjectCode' },
	'subjectdistance' => { 104 => 0x9206, 120 => 0x3e, 399 => 'SubjectDistance' },
	'subjectdistancerange' => { 104 => 0xa40c, 399 => 'SubjectDistanceRange' },
	'subjectlocation' => { 104 => 0xa214, 399 => 'SubjectLocation' },
	'subjectprogram' => { 156 => 0x22 },
	'subjectreference' => { 112 => 0xc },
	'sublabels4' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 403 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 403 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 104 => 0x9290 },
	'subsectimedigitized' => { 104 => 0x9292 },
	'subsectimeoriginal' => { 104 => 0x9291 },
	'subsection1' => { 410 => 'subsection1' },
	'subsection2' => { 410 => 'subsection2' },
	'subsection3' => { 410 => 'subsection3' },
	'subsection4' => { 410 => 'subsection4' },
	'subselector' => { 236 => '49.1' },
	'subselectorassignment' => { 236 => '48.1' },
	'subselectorplusdials' => { 236 => '49.2' },
	'subtitle' => { 410 => 'subtitle' },
	'subversionfilename' => { 403 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 403 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 403 => 'SubVersions' },
	'superimposeddisplay' => { 70 => 0xa, 72 => 0x510, 73 => 0x9, 74 => 0xa, 77 => 0xa, 78 => 0xe },
	'supermacro' => { 54 => 0x1a },
	'supplementalcategories' => { 112 => 0x14, 407 => 'SupplementalCategories' },
	'supplementaltype' => { 114 => 0x37 },
	'supplementdisplayid' => { 410 => 'supplementDisplayID' },
	'supplementstartingpage' => { 410 => 'supplementStartingPage' },
	'supplementtitle' => { 410 => 'supplementTitle' },
	'svisosetting' => { 282 => 0x14 },
	'sweeppanoramadirection' => { 268 => 0x93, 342 => 0x33 },
	'sweeppanoramafieldofview' => { 268 => 0x94 },
	'sweeppanoramasize' => { 342 => 0x32 },
	'switchtoregisteredafpoint' => { 71 => 0x12, 72 => 0x50a },
	'tagged' => { 310 => 0xdd, 311 => 'Tagged', 389 => 'tagged' },
	'tagslist' => { 398 => 'TagsList' },
	'tagstructure' => { 403 => 'TagStructure' },
	'takenumber' => { 420 => 'takeNumber' },
	'tapename' => { 420 => 'tapeName' },
	'targetaperture' => { 66 => 0x4 },
	'targetcompressionratio' => { 83 => 0x1 },
	'targetdistancesetting' => { 85 => 0x1807 },
	'targetexposuretime' => { 66 => 0x5 },
	'targetimagetype' => { 85 => 0x100a },
	'taxon' => { 103 => 'Taxon' },
	'taxonacceptednameusage' => { 103 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 103 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 103 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 103 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 103 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 103 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 103 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 103 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 103 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 103 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 103 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 103 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 103 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 103 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 103 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 103 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 103 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 103 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 103 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 103 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 103 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 103 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 103 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 103 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 103 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 103 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 103 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 103 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 103 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 103 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 103 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 103 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 103 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 410 => 'teaser' },
	'teleconverter' => { 161 => 0x105, 352 => 0x105 },
	'tempo' => { 420 => 'tempo' },
	'termsandconditionstext' => { 408 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 408 => 'TermsAndConditionsURL' },
	'testname' => { 105 => 'TestName' },
	'textencoding' => { 191 => 0x4 },
	'textlayername' => { 407 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 407 => 'TextLayers' },
	'textlayertext' => { 407 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 268 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 104 => 0x107 },
	'thumbnailfilename' => { 85 => 0x817 },
	'thumbnailformat' => { 418 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 122 => 0xfa55, 418 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 85 => 0x2008, 101 => 'ThumbnailImage', 107 => 0x3, 145 => 'data', 253 => 0x100, 418 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 145 => '1Name' },
	'thumbnailimagesize' => { 145 => 'ImageSize' },
	'thumbnailimagetype' => { 145 => '0Type' },
	'thumbnailimagevalidarea' => { 54 => 0x13 },
	'thumbnaillength' => { 104 => 0x202 },
	'thumbnailoffset' => { 104 => 0x201 },
	'thumbnails' => { 418 => 'Thumbnails' },
	'thumbnailwidth' => { 122 => 0xfa54, 418 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 410 => 'ticker' },
	'tiffmeteringimage' => { 162 => 0x104c, 351 => 0x1110 },
	'tilelength' => { 104 => 0x143 },
	'tilewidth' => { 104 => 0x142 },
	'time' => { 118 => 0x401, 301 => 0x7 },
	'timecodes' => { 104 => 0xc763 },
	'timecreated' => { 112 => 0x3c, 120 => 0x14, 129 => 0x10, 311 => 'TimeCreated' },
	'timeperiod' => { 410 => 'timePeriod' },
	'timerfunctionbutton' => { 237 => '5.2', 238 => '12.1', 239 => '13.1' },
	'timerlength' => { 72 => 0x80c },
	'timerrecording' => { 268 => 0x96 },
	'timescaleparams' => { 420 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 420 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 420 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 420 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 113 => 0x50 },
	'timesignature' => { 420 => 'timeSignature' },
	'timesincepoweron' => { 268 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 247 => 0x8, 260 => 'TimeStamp', 390 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 67 => 0x1, 220 => 0x0, 327 => 0xa },
	'timezonecity' => { 67 => 0x2 },
	'timezonecode' => { 88 => 0x1 },
	'timezoneinfo' => { 88 => 0x2 },
	'timezoneoffset' => { 104 => 0x882a },
	'tint' => { 395 => 'Tint' },
	'title' => { 135 => 'Title', 257 => 'Title', 260 => 'Title', 268 => 0x65, 315 => 'Title', 396 => 'title', 406 => 'Title', 418 => 'Title' },
	'tonecomp' => { 192 => 0x81 },
	'tonecurve' => { 64 => 0x1, 301 => 0x402, 395 => 'ToneCurve' },
	'tonecurveactive' => { 95 => 0x110 },
	'tonecurveadobergb' => { 330 => 0xa043 },
	'tonecurveadobergbdefault' => { 330 => 0xa041 },
	'tonecurveblue' => { 395 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 380 => 0x9003 },
	'tonecurvebluey' => { 380 => 0x9007 },
	'tonecurvebrightness' => { 90 => 0x20410 },
	'tonecurvebrightnessx' => { 380 => 0x9000 },
	'tonecurvebrightnessy' => { 380 => 0x9004 },
	'tonecurvecolorspace' => { 94 => 0x0 },
	'tonecurvecontrast' => { 90 => 0x20411 },
	'tonecurvefilename' => { 118 => 0x1391 },
	'tonecurvegreen' => { 395 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 380 => 0x9002 },
	'tonecurvegreeny' => { 380 => 0x9006 },
	'tonecurveinputrange' => { 94 => 0x3 },
	'tonecurveinterpolation' => { 95 => 0x159 },
	'tonecurvemode' => { 95 => 0x113 },
	'tonecurvename' => { 395 => 'ToneCurveName' },
	'tonecurvename2012' => { 395 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 90 => '0x20400.1' },
	'tonecurveoutputrange' => { 94 => 0x5 },
	'tonecurveproperty' => { 95 => 0x3c },
	'tonecurvepv2012' => { 395 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 395 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 395 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 395 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 395 => 'ToneCurveRed' },
	'tonecurveredx' => { 380 => 0x9001 },
	'tonecurveredy' => { 380 => 0x9005 },
	'tonecurves' => { 301 => 0x403 },
	'tonecurveshape' => { 94 => 0x1 },
	'tonecurvesrgb' => { 330 => 0xa042 },
	'tonecurvesrgbdefault' => { 330 => 0xa040 },
	'tonecurvex' => { 94 => 0xa },
	'tonecurvey' => { 94 => 0xb },
	'tonelevel' => { 248 => 0x52e },
	'toningeffect' => { 48 => 0xf, 192 => 0xb3, 194 => 0x38, 324 => 0x1015 },
	'toningeffectauto' => { 61 => 0xa4 },
	'toningeffectfaithful' => { 60 => 0x74, 61 => 0x74 },
	'toningeffectlandscape' => { 60 => 0x44, 61 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 60 => 0x8c, 61 => 0x8c },
	'toningeffectneutral' => { 60 => 0x5c, 61 => 0x5c },
	'toningeffectportrait' => { 60 => 0x2c, 61 => 0x2c },
	'toningeffectstandard' => { 60 => 0x14, 61 => 0x14 },
	'toningeffectuserdef1' => { 60 => 0xa4, 61 => 0xbc },
	'toningeffectuserdef2' => { 60 => 0xbc, 61 => 0xd4 },
	'toningeffectuserdef3' => { 60 => 0xd4, 61 => 0xec },
	'toningsaturation' => { 194 => 0x39 },
	'totalzoom' => { 120 => 0x62 },
	'touchae' => { 268 => 0xab },
	'trackcreatedate' => { 319 => 0x1 },
	'trackmodifydate' => { 319 => 0x2 },
	'tracknumber' => { 420 => 'trackNumber' },
	'tracks' => { 420 => 'Tracks' },
	'tracksframerate' => { 420 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 420 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 420 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 420 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 420 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 420 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 420 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 420 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 420 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 420 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 420 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 420 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 420 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 420 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 420 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 420 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 420 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 142 => 'zmie' },
	'transferfunction' => { 104 => 0x12d, 416 => 'TransferFunction' },
	'transform' => { 268 => [0x8012,0x59] },
	'transmissionreference' => { 407 => 'TransmissionReference' },
	'trapped' => { 257 => 'Trapped', 406 => 'Trapped' },
	'trashbuttonfunction' => { 72 => 0x710 },
	'travelday' => { 268 => 0x36 },
	'triggermode' => { 320 => 0x6 },
	'tstop' => { 104 => 0xc772 },
	'ttl_da_adown' => { 289 => 0x5 },
	'ttl_da_aup' => { 289 => 0x4 },
	'ttl_da_bdown' => { 289 => 0x7 },
	'ttl_da_bup' => { 289 => 0x6 },
	'tungstenawb' => { 279 => 0x1 },
	'tvexposuretimesetting' => { 282 => 0x12 },
	'type' => { 396 => 'type', 415 => 'type' },
	'typestatus' => { 103 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 104 => 0xc614 },
	'uniquedocumentid' => { 112 => 0xbb },
	'uniqueobjectname' => { 113 => 0x64 },
	'unknownblock' => { 301 => 0x405 },
	'unknownblock1' => { 252 => 0x635 },
	'unknownblock2' => { 252 => 0x636 },
	'unknownblock3' => { 252 => 0x1103 },
	'unknownblock4' => { 252 => 0x1104 },
	'unknowncontrast' => { 96 => 0x45 },
	'unknownev' => { 118 => 0x1 },
	'unknownlinear' => { 96 => 0x46 },
	'unknownnumber' => { 85 => 0x180b },
	'unknownoutputhighlightpoint' => { 96 => 0x4a },
	'unknownoutputshadowpoint' => { 96 => 0x4b },
	'unknownrawhighlight' => { 96 => 0x7b },
	'unknownrawhighlightpoint' => { 96 => 0x48 },
	'unknownrawshadow' => { 96 => 0x84 },
	'unknownrawshadowpoint' => { 96 => 0x49 },
	'unknownsharpness' => { 96 => 0x47 },
	'unknowntemperature' => { 106 => 0x4 },
	'unsharp1color' => { 233 => 0x13 },
	'unsharp1halowidth' => { 233 => 0x19 },
	'unsharp1intensity' => { 233 => 0x17 },
	'unsharp1threshold' => { 233 => 0x1b },
	'unsharp2color' => { 233 => 0x2e },
	'unsharp2halowidth' => { 233 => 0x34 },
	'unsharp2intensity' => { 233 => 0x32 },
	'unsharp2threshold' => { 233 => 0x36 },
	'unsharp3color' => { 233 => 0x49 },
	'unsharp3halowidth' => { 233 => 0x4f },
	'unsharp3intensity' => { 233 => 0x4d },
	'unsharp3threshold' => { 233 => 0x51 },
	'unsharp4color' => { 233 => 0x64 },
	'unsharp4halowidth' => { 233 => 0x6a },
	'unsharp4intensity' => { 233 => 0x68 },
	'unsharp4threshold' => { 233 => 0x6c },
	'unsharpcount' => { 233 => 0x0 },
	'unsharpmask' => { 96 => 0x90, 228 => 0x76a43200 },
	'unsharpmaskfineness' => { 90 => 0x20309 },
	'unsharpmaskstrength' => { 90 => 0x20308 },
	'unsharpmaskthreshold' => { 90 => 0x2030a },
	'uprightcentermode' => { 395 => 'UprightCenterMode' },
	'uprightcenternormx' => { 395 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 395 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 395 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 395 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 395 => 'UprightFocalMode' },
	'uprightpreview' => { 395 => 'UprightPreview' },
	'uprighttransform_0' => { 395 => 'UprightTransform_0' },
	'uprighttransform_1' => { 395 => 'UprightTransform_1' },
	'uprighttransform_2' => { 395 => 'UprightTransform_2' },
	'uprighttransform_3' => { 395 => 'UprightTransform_3' },
	'uprighttransform_4' => { 395 => 'UprightTransform_4' },
	'uprighttransformcount' => { 395 => 'UprightTransformCount' },
	'uprightversion' => { 395 => 'UprightVersion' },
	'urgency' => { 112 => 0xa, 407 => 'Urgency' },
	'url' => { 135 => 'URL', 260 => 'URL', 313 => 0x40b, 410 => 'url' },
	'urla-platform' => { 410 => [\'url','urlA-platform'] },
	'urlurl' => { 410 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 72 => 0x10a },
	'usableshootingmodes' => { 72 => 0x109 },
	'usage' => { 411 => 'usage' },
	'usageterms' => { 424 => 'UsageTerms' },
	'useguidelines' => { 392 => 'useGuidelines' },
	'usepanoramaviewer' => { 384 => 'UsePanoramaViewer' },
	'usercomment' => { 85 => 0x805, 104 => 0x9286, 399 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 60 => 0xd8, 61 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 60 => 0xda, 61 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 60 => 0xdc, 61 => 0xf4 },
	'userfields' => { 387 => 'UserFields' },
	'userlabel' => { 320 => 0x2b },
	'userprofile' => { 264 => 0x302, 270 => 0x3038 },
	'usmlenselectronicmf' => { 71 => 0x7, 72 => 0x501 },
	'uspsnumber' => { 410 => 'uspsNumber' },
	'utmeasting' => { 146 => 'Easting' },
	'utmmapdatum' => { 146 => 'Datum' },
	'utmnorthing' => { 146 => 'Northing' },
	'utmzone' => { 146 => 'Zone' },
	'uv-irfiltercorrection' => { 264 => 0x325 },
	'validbits' => { 252 => 0x611, 253 => 0x102c },
	'validpixeldepth' => { 256 => 0x611 },
	'variousmodes' => { 120 => 0x26 },
	'variousmodes2' => { 120 => 0x3a },
	'variprogram' => { 192 => 0xab },
	'version' => { 109 => 0x0, 315 => 'Version', 395 => 'Version' },
	'versioncreatedate' => { 380 => 0xd100 },
	'versionid' => { 421 => 'VersionID' },
	'versionidentifier' => { 410 => 'versionIdentifier' },
	'versionmodifydate' => { 380 => 0xd101 },
	'versions' => { 421 => 'Versions' },
	'versionscomments' => { 421 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 421 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 421 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 421 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 421 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 421 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 421 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 421 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 421 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 421 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 421 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 235 => '3.2', 236 => '47.2' },
	'verticalfuncbutton' => { 236 => '42.2' },
	'verticalfuncbuttonplusdials' => { 236 => '43.1' },
	'verticalmultiselector' => { 236 => '42.1' },
	'vfdisplayillumination' => { 72 => 0x510 },
	'vibrance' => { 388 => 'Vibrance', 395 => 'Vibrance' },
	'vibrationreduction' => { 199 => [0x75,0x82,0x1ae], 207 => '586.1', 214 => '590.2', 219 => 0x4 },
	'videoalphamode' => { 420 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 420 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 420 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 420 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 57 => 0x74 },
	'videocolorspace' => { 420 => 'videoColorSpace' },
	'videocompressor' => { 420 => 'videoCompressor' },
	'videofieldorder' => { 420 => 'videoFieldOrder' },
	'videoframerate' => { 420 => 'videoFrameRate' },
	'videoframesize' => { 420 => 'videoFrameSize' },
	'videoframesizeh' => { 420 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 420 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 420 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 420 => 'videoModDate' },
	'videopixelaspectratio' => { 420 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 420 => 'videoPixelDepth' },
	'videoquality' => { 100 => 0x4003 },
	'viewfinderdisplay' => { 235 => '12.4', 236 => '6.3' },
	'viewfinderwarning' => { 235 => '13.4', 242 => '3.5', 243 => '6.2', 246 => '4.4' },
	'viewfinderwarnings' => { 72 => 0x40a },
	'viewinfoduringexposure' => { 72 => 0x407 },
	'viewingmode' => { 342 => 0x2f, 356 => 0x18 },
	'viewingmode2' => { 342 => [0x85,0x285] },
	'viewpoint' => { 409 => 'viewpoint' },
	'vignetteamount' => { 395 => 'VignetteAmount' },
	'vignettecontrol' => { 192 => 0x2a, 228 => 0x76a43205 },
	'vignettecontrolintensity' => { 228 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 391 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 395 => 'VignetteMidpoint' },
	'vignetting' => { 324 => 0x1011, 330 => 0xa052 },
	'vignettingcorrection' => { 330 => 0xa053, 352 => 0x2011 },
	'vignettingsetting' => { 330 => 0xa054 },
	'visualtechnique' => { 409 => 'visualTechnique' },
	'voicememo' => { 332 => 0x216 },
	'volume' => { 410 => 'volume' },
	'vr_0x66' => { 199 => 0x66 },
	'vrdoffset' => { 54 => 0xd0 },
	'vrmode' => { 219 => 0x6 },
	'wb_bluelevel3500k' => { 162 => 0x19a },
	'wb_bluelevel6500k' => { 162 => 0x18a },
	'wb_bluelevelcustom' => { 162 => 0x18e },
	'wb_bluelevelscloudy' => { 162 => 0x106 },
	'wb_bluelevelsdaylight' => { 162 => 0xea },
	'wb_bluelevelsflash' => { 162 => 0x122 },
	'wb_bluelevelsfluorescent' => { 162 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 162 => 0x254 },
	'wb_bluelevelsshade' => { 162 => 0x176 },
	'wb_bluelevelstungsten' => { 162 => 0xce },
	'wb_gbrglevels' => { 162 => 0xae, 165 => 0x4 },
	'wb_glevel' => { 252 => 0x11f },
	'wb_glevel3000k' => { 252 => 0x113 },
	'wb_glevel3300k' => { 252 => 0x114 },
	'wb_glevel3600k' => { 252 => 0x115 },
	'wb_glevel3900k' => { 252 => 0x116 },
	'wb_glevel4000k' => { 252 => 0x117 },
	'wb_glevel4300k' => { 252 => 0x118 },
	'wb_glevel4500k' => { 252 => 0x119 },
	'wb_glevel4800k' => { 252 => 0x11a },
	'wb_glevel5300k' => { 252 => 0x11b },
	'wb_glevel6000k' => { 252 => 0x11c },
	'wb_glevel6600k' => { 252 => 0x11d },
	'wb_glevel7500k' => { 252 => 0x11e },
	'wb_grbglevels' => { 175 => 0x0 },
	'wb_rbgglevels' => { 172 => 0x0 },
	'wb_rblevels' => { 192 => 0xc, 252 => 0x100 },
	'wb_rblevels1' => { 273 => 0x2 },
	'wb_rblevels2' => { 273 => 0x5 },
	'wb_rblevels3' => { 273 => 0x8 },
	'wb_rblevels3000k' => { 252 => 0x102 },
	'wb_rblevels3300k' => { 252 => 0x103 },
	'wb_rblevels3500k' => { 162 => 0x430 },
	'wb_rblevels3600k' => { 252 => 0x104 },
	'wb_rblevels3900k' => { 252 => 0x105 },
	'wb_rblevels4' => { 273 => 0xb },
	'wb_rblevels4000k' => { 252 => 0x106 },
	'wb_rblevels4300k' => { 252 => 0x107 },
	'wb_rblevels4500k' => { 252 => 0x108 },
	'wb_rblevels4800k' => { 252 => 0x109 },
	'wb_rblevels5' => { 273 => 0xe },
	'wb_rblevels5300k' => { 252 => 0x10a },
	'wb_rblevels6' => { 273 => 0x11 },
	'wb_rblevels6000k' => { 252 => 0x10b },
	'wb_rblevels6500k' => { 162 => 0x420 },
	'wb_rblevels6600k' => { 252 => 0x10c },
	'wb_rblevels7' => { 273 => 0x14 },
	'wb_rblevels7500k' => { 252 => 0x10d },
	'wb_rblevelsauto' => { 256 => 0x110 },
	'wb_rblevelscloudy' => { 162 => 0x3f0, 164 => 0x10, 256 => 0x121 },
	'wb_rblevelscoolwhitef' => { 162 => 0x308, 164 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 256 => 0x132 },
	'wb_rblevelscustom' => { 162 => 0x424 },
	'wb_rblevelscwb1' => { 252 => 0x10e },
	'wb_rblevelscwb2' => { 252 => 0x10f },
	'wb_rblevelscwb3' => { 252 => 0x110 },
	'wb_rblevelscwb4' => { 252 => 0x111 },
	'wb_rblevelsdaylight' => { 162 => [0x3ec,0x528], 164 => 0xc },
	'wb_rblevelsdaylightf' => { 164 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 256 => 0x130 },
	'wb_rblevelsdaywhitef' => { 164 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 256 => 0x131 },
	'wb_rblevelseveningsunlight' => { 256 => 0x124 },
	'wb_rblevelsfineweather' => { 256 => 0x122 },
	'wb_rblevelsflash' => { 162 => [0x3f4,0x304], 164 => 0x18 },
	'wb_rblevelsshade' => { 162 => 0x418, 164 => 0x20, 256 => 0x120 },
	'wb_rblevelstungsten' => { 162 => 0x3e8, 164 => 0x8, 256 => 0x123 },
	'wb_rblevelsunknown' => { 164 => 0x1c },
	'wb_rblevelsused' => { 256 => 0x100 },
	'wb_rblevelswhitef' => { 164 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 256 => 0x133 },
	'wb_redlevel3500k' => { 162 => 0x198 },
	'wb_redlevel6500k' => { 162 => 0x188 },
	'wb_redlevelcustom' => { 162 => 0x18c },
	'wb_redlevelscloudy' => { 162 => 0xf8 },
	'wb_redlevelsdaylight' => { 162 => 0xdc },
	'wb_redlevelsflash' => { 162 => 0x114 },
	'wb_redlevelsfluorescent' => { 162 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 162 => 0x1be },
	'wb_redlevelsshade' => { 162 => 0x168 },
	'wb_redlevelstungsten' => { 162 => 0xc0 },
	'wb_rgbglevels' => { 174 => 0x0 },
	'wb_rgblevels' => { 162 => [0x546,0x96], 265 => 0xd, 266 => 0x413, 270 => 0x3036, 359 => 0x117c, 360 => 0x1180, 361 => 0x115c, 362 => 0x11d8, 363 => 0x11b4, 364 => 0x106c, 365 => 0x264, 366 => 0x264 },
	'wb_rgblevels1' => { 274 => 0x2 },
	'wb_rgblevels2' => { 274 => 0x6 },
	'wb_rgblevels3' => { 274 => 0xa },
	'wb_rgblevels4' => { 274 => 0xe },
	'wb_rgblevels5' => { 274 => 0x12 },
	'wb_rgblevels6' => { 274 => 0x16 },
	'wb_rgblevels7' => { 274 => 0x1a },
	'wb_rggbblacklevels' => { 31 => 0x25 },
	'wb_rggblevels' => { 165 => 0x4, 173 => 0x0 },
	'wb_rggblevelsasshot' => { 33 => 0x0, 34 => 0x19, 35 => 0x22, 36 => 0x3f, 39 => 0x3f, 40 => 0x3f, 41 => 0x3f },
	'wb_rggblevelsauto' => { 31 => 0x1, 33 => 0x5, 34 => 0x1e, 35 => 0x18, 36 => 0x44, 39 => 0x44, 40 => 0x44, 41 => 0x44, 330 => 0xa022 },
	'wb_rggblevelsblack' => { 330 => 0xa028 },
	'wb_rggblevelscloudy' => { 31 => 0xd, 33 => 0x1e, 34 => 0x2d, 35 => 0x31, 36 => 0x58, 39 => 0x71, 40 => 0x8a, 41 => 0x8f, 301 => 0x20f, 309 => 0x14 },
	'wb_rggblevelscustom' => { 31 => 0x1d, 36 => 0x80 },
	'wb_rggblevelscustom1' => { 34 => 0x41 },
	'wb_rggblevelscustom2' => { 34 => 0x46 },
	'wb_rggblevelsdaylight' => { 31 => 0x5, 33 => 0x14, 34 => 0x23, 35 => 0x27, 36 => 0x4e, 39 => 0x67, 40 => 0x80, 41 => 0x85, 301 => 0x20d, 309 => 0x2 },
	'wb_rggblevelsflash' => { 31 => 0x19, 33 => 0x32, 34 => 0x3c, 35 => 0x45, 36 => 0x6c, 39 => 0x85, 40 => 0x9e, 41 => 0xa3, 301 => 0x214, 309 => 0x41 },
	'wb_rggblevelsfluorescent' => { 31 => 0x15, 33 => 0x28, 34 => 0x37, 35 => 0x3b, 36 => 0x62, 39 => 0x7b, 40 => 0x94, 41 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 301 => 0x211, 309 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 309 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 301 => 0x212, 309 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 301 => 0x213, 309 => 0x38 },
	'wb_rggblevelsilluminator1' => { 330 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 330 => 0xa024 },
	'wb_rggblevelskelvin' => { 31 => 0x21, 33 => 0x2d, 35 => 0x40, 36 => 0x67, 39 => 0x80, 40 => 0x99, 41 => 0x9e },
	'wb_rggblevelsmeasured' => { 33 => 0xa, 36 => 0x49, 39 => 0x49, 40 => 0x49, 41 => 0x49 },
	'wb_rggblevelspc1' => { 35 => 0x90, 36 => 0x71 },
	'wb_rggblevelspc2' => { 35 => 0x95, 36 => 0x76 },
	'wb_rggblevelspc3' => { 35 => 0x9a, 36 => 0x7b },
	'wb_rggblevelsshade' => { 31 => 0x9, 33 => 0x19, 34 => 0x28, 35 => 0x2c, 36 => 0x53, 39 => 0x6c, 40 => 0x85, 41 => 0x8a, 301 => 0x20e, 309 => 0xb },
	'wb_rggblevelstungsten' => { 31 => 0x11, 33 => 0x23, 34 => 0x32, 35 => 0x36, 36 => 0x5d, 39 => 0x76, 40 => 0x8f, 41 => 0x94, 301 => 0x210, 309 => 0x1d },
	'wb_rggblevelsuncorrected' => { 330 => 0xa021 },
	'wb_rggblevelsunknown' => { 33 => 0xf, 35 => 0x1d, 39 => 0x4e, 40 => 0x4e, 41 => 0x4e, 309 => 0x53 },
	'wb_rggblevelsunknown10' => { 33 => 0x5f, 35 => 0x72, 39 => 0x9e, 40 => 0x7b, 41 => 0x7b },
	'wb_rggblevelsunknown11' => { 33 => 0x64, 35 => 0x77, 39 => 0xa3, 40 => 0xa3, 41 => 0x80 },
	'wb_rggblevelsunknown12' => { 33 => 0x69, 35 => 0x7c, 39 => 0xa8, 40 => 0xa8, 41 => 0xa8 },
	'wb_rggblevelsunknown13' => { 33 => 0x6e, 35 => 0x81, 39 => 0xad, 40 => 0xad, 41 => 0xad },
	'wb_rggblevelsunknown14' => { 35 => 0x86, 39 => 0xb2, 40 => 0xb2, 41 => 0xb2 },
	'wb_rggblevelsunknown15' => { 35 => 0x8b, 39 => 0xb7, 40 => 0xb7, 41 => 0xb7 },
	'wb_rggblevelsunknown16' => { 35 => 0x9f, 40 => 0xbc, 41 => 0xbc },
	'wb_rggblevelsunknown17' => { 40 => 0xc1, 41 => 0xc1 },
	'wb_rggblevelsunknown18' => { 40 => 0xc6, 41 => 0xc6 },
	'wb_rggblevelsunknown19' => { 40 => 0xcb, 41 => 0xcb },
	'wb_rggblevelsunknown2' => { 33 => 0x37, 35 => 0x4a, 39 => 0x53, 40 => 0x53, 41 => 0x53 },
	'wb_rggblevelsunknown20' => { 40 => 0xd0, 41 => 0xd0 },
	'wb_rggblevelsunknown21' => { 41 => 0xd5 },
	'wb_rggblevelsunknown22' => { 41 => 0xda },
	'wb_rggblevelsunknown23' => { 41 => 0xdf },
	'wb_rggblevelsunknown24' => { 41 => 0xe4 },
	'wb_rggblevelsunknown25' => { 41 => 0xe9 },
	'wb_rggblevelsunknown26' => { 41 => 0xee },
	'wb_rggblevelsunknown27' => { 41 => 0xf3 },
	'wb_rggblevelsunknown28' => { 41 => 0xf8 },
	'wb_rggblevelsunknown29' => { 41 => 0xfd },
	'wb_rggblevelsunknown3' => { 33 => 0x3c, 35 => 0x4f, 39 => 0x58, 40 => 0x58, 41 => 0x58 },
	'wb_rggblevelsunknown30' => { 41 => 0x102 },
	'wb_rggblevelsunknown4' => { 33 => 0x41, 35 => 0x54, 39 => 0x5d, 40 => 0x5d, 41 => 0x5d },
	'wb_rggblevelsunknown5' => { 33 => 0x46, 35 => 0x59, 39 => 0x62, 40 => 0x62, 41 => 0x62 },
	'wb_rggblevelsunknown6' => { 33 => 0x4b, 35 => 0x5e, 39 => 0x8a, 40 => 0x67, 41 => 0x67 },
	'wb_rggblevelsunknown7' => { 33 => 0x50, 35 => 0x63, 39 => 0x8f, 40 => 0x6c, 41 => 0x6c },
	'wb_rggblevelsunknown8' => { 33 => 0x55, 35 => 0x68, 39 => 0x94, 40 => 0x71, 41 => 0x71 },
	'wb_rggblevelsunknown9' => { 33 => 0x5a, 35 => 0x6d, 39 => 0x99, 40 => 0x76, 41 => 0x76 },
	'wb_rggblevelsuserselected' => { 309 => 0x5c },
	'wbadjblueamber' => { 90 => 0x20106 },
	'wbadjbluebalance' => { 234 => 0x8 },
	'wbadjcolortemp' => { 90 => 0x20102, 95 => 0x1a },
	'wbadjlighting' => { 234 => 0x14 },
	'wbadjmagentagreen' => { 90 => 0x20105 },
	'wbadjmode' => { 234 => 0x10 },
	'wbadjredbalance' => { 234 => 0x0 },
	'wbadjrggblevels' => { 90 => 0x20125, 95 => 0x6 },
	'wbadjtemperature' => { 234 => 0x18 },
	'wbadjtint' => { 234 => 0x25 },
	'wbbluelevel' => { 264 => 0x324, 268 => 0x8006, 272 => 0x26 },
	'wbbracketmode' => { 48 => 0x9 },
	'wbbracketshotnumber' => { 162 => 0x2b, 324 => 0x101a },
	'wbbracketvalueab' => { 48 => 0xc },
	'wbbracketvaluegm' => { 48 => 0xd },
	'wbfinetuneactive' => { 95 => 0x24 },
	'wbfinetunesaturation' => { 95 => 0x28 },
	'wbfinetunetone' => { 95 => 0x2c },
	'wbgreenlevel' => { 264 => 0x323, 268 => 0x8005, 272 => 0x25 },
	'wbmediaimagesizesetting' => { 72 => 0x708 },
	'wbmode' => { 164 => 0x4, 253 => 0x1015 },
	'wbredlevel' => { 264 => 0x322, 268 => 0x8004, 272 => 0x24 },
	'wbscale' => { 165 => 0x0 },
	'wbshiftab' => { 64 => 0xc, 268 => 0x46, 283 => 0x10 },
	'wbshiftab_gm' => { 352 => 0x2014 },
	'wbshiftgm' => { 64 => 0xd, 268 => 0x47, 283 => 0x11 },
	'wbtype1' => { 273 => 0x1, 274 => 0x1 },
	'wbtype2' => { 273 => 0x4, 274 => 0x5 },
	'wbtype3' => { 273 => 0x7, 274 => 0x9 },
	'wbtype4' => { 273 => 0xa, 274 => 0xd },
	'wbtype5' => { 273 => 0xd, 274 => 0x11 },
	'wbtype6' => { 273 => 0x10, 274 => 0x15 },
	'wbtype7' => { 273 => 0x13, 274 => 0x19 },
	'webstatement' => { 424 => 'WebStatement' },
	'what' => { 395 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 64 => 0x8, 66 => 0x7, 99 => 0x7, 100 => [0x19,0x2012], 104 => [0xa403,0xfe4e], 109 => 0x1002, 118 => 0x3fc, 119 => 0xfa0d, 120 => 0x40, 156 => 0x3, 157 => 0xe, 158 => 0x4, 159 => 0xb, 161 => 0x115, 192 => 0x5, 218 => 0x7, 264 => 0x304, 268 => 0x3, 270 => 0x3033, 301 => 0x19, 308 => 0x7, 323 => 0x26, 324 => 0x1003, 333 => [0x3c,0x7,0x58], 340 => 0xf, 341 => 0xe, 352 => [0x115,0xb054], 395 => 'WhiteBalance', 399 => 'WhiteBalance' },
	'whitebalance0' => { 152 => 'WhiteBalance0' },
	'whitebalance1' => { 152 => 'WhiteBalance1' },
	'whitebalance2' => { 152 => 'WhiteBalance2', 248 => 0x500 },
	'whitebalanceadj' => { 90 => 0x20101, 95 => 0x18, 228 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 279 => 0x0 },
	'whitebalancebias' => { 100 => 0x2011, 253 => 0x304, 268 => 0x23 },
	'whitebalanceblue' => { 64 => 0x7 },
	'whitebalancebracket' => { 248 => 0x502, 253 => 0x303 },
	'whitebalancebracketing' => { 159 => 0x22, 162 => 0x2c, 351 => 0x2c },
	'whitebalancecomp' => { 256 => 0x1001 },
	'whitebalancefinetune' => { 109 => 0x100a, 159 => 0x38, 161 => 0x112, 192 => 0xb, 324 => 0x1004, 340 => 0x6, 341 => 0x5, 352 => 0x112 },
	'whitebalancemode' => { 301 => 0x1a },
	'whitebalancered' => { 64 => 0x6 },
	'whitebalanceset' => { 282 => 0xa },
	'whitebalancesetting' => { 159 => 0x23, 340 => 0x5, 341 => 0x4, 342 => 0x16, 356 => 0xd },
	'whitebalancetemperature' => { 248 => 0x501 },
	'whiteboard' => { 253 => 0x301 },
	'whitelevel' => { 104 => 0xc61d, 301 => 0x7e },
	'whitepoint' => { 104 => 0x13e, 301 => 0x201, 416 => 'WhitePoint' },
	'whites2012' => { 395 => 'Whites2012' },
	'wideadapter' => { 324 => 0x1017 },
	'widefocuszone' => { 156 => 0x2f },
	'widerange' => { 332 => 0x20f },
	'windowsatom' => { 394 => 'windowsAtom' },
	'windowsatomextension' => { 394 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 394 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 394 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 410 => 'wordCount' },
	'workcolorspace' => { 90 => 0x10200, 95 => 0x270 },
	'worktodo' => { 401 => 'WorkToDo' },
	'worldtimelocation' => { 268 => 0x3a, 301 => 0x22, 307 => '0.1' },
	'writer-editor' => { 112 => 0x7a },
	'x3filllight' => { 333 => 0x12 },
	'xml' => { 116 => 'xml ' },
	'xmp' => { 93 => 0xffff00f6, 105 => 'XMP' },
	'xmptoolkit' => { 417 => 'xmptk' },
	'xpauthor' => { 104 => 0x9c9d },
	'xpcomment' => { 104 => 0x9c9c },
	'xpkeywords' => { 104 => 0x9c9e },
	'xposition' => { 104 => 0x11e },
	'xpsubject' => { 104 => 0x9c9f },
	'xptitle' => { 104 => 0x9c9b },
	'xresolution' => { 104 => 0x11a, 115 => 0x3, 314 => 0x0, 416 => 'XResolution' },
	'xyresolution' => { 108 => 0x3 },
	'yawangle' => { 208 => 0x3513 },
	'ycbcrcoefficients' => { 104 => 0x211, 416 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 104 => 0x213, 416 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 104 => 0x212, 416 => 'YCbCrSubSampling' },
	'yearcreated' => { 120 => 0x10, 129 => 0xc },
	'yield' => { 412 => 'yield' },
	'yposition' => { 104 => 0x11f },
	'yresolution' => { 104 => 0x11b, 115 => 0x5, 314 => 0x4, 416 => 'YResolution' },
	'zonematching' => { 161 => 0x10a, 164 => [0x3a,0x4a], 352 => 0xb024 },
	'zonematchingmode' => { 159 => 0x14 },
	'zonematchingon' => { 158 => 0x75 },
	'zonematchingvalue' => { 340 => 0x1f },
	'zoomedpreviewlength' => { 253 => 0xf05 },
	'zoomedpreviewsize' => { 253 => 0xf06 },
	'zoomedpreviewstart' => { 253 => 0xf04 },
	'zoomsourcewidth' => { 30 => 0x24 },
	'zoomstepcount' => { 251 => 0x300, 253 => 0x100d },
	'zoomtargetwidth' => { 30 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationcorrparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioncorrparams' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplaneafpointsused' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2015, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
