<?php
// Call Text_StatisticsTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD')) {
    define('PHPUnit_MAIN_METHOD', 'Text_StatisticsTest::main');
}

require_once 'PHPUnit/Framework.php';

chdir(dirname(__FILE__) . '/../');
require_once 'Text/Statistics.php';

/**
 * Test class for Text_Statistics.
 * Generated by PHPUnit on 2008-01-31 at 21:26:09.
 */
class Text_StatisticsTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var    Text_Statistics
     * @access protected
     */
    protected $object;

    protected $sample;
    protected $sampleAbbr;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main()
    {
        require_once 'PHPUnit/TextUI/TestRunner.php';

        $suite  = new PHPUnit_Framework_TestSuite('Text_StatisticsTest');
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }



    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp()
    {
        $this->sample = "
Returns the number of words in the analysed text file or block. A word must
consist of letters a-z with at least one vowel sound, and optionally an
apostrophe or hyphen.";
        $this->object = new Text_Statistics($this->sample);
        $this->sampleAbbr = "
Dear Mr. Schlossnagle,

Your request for a leave of absense has been approved.  Enjoy your vacation.
";
    }



    public function testPropertyNumSentences()
    {
        $this->assertEquals(2, $this->object->numSentences);
    }



    public function testPropertyNumWords()
    {
        $this->assertEquals(31, $this->object->numWords);
    }



    public function testPropertyNumSyllables()
    {
        $this->assertEquals(45, $this->object->numSyllables);
    }



    public function testPropertyNumSentencesAbbr()
    {
        $object = new Text_Statistics($this->sampleAbbr);
        $this->assertEquals(2, $object->numSentences);
    }



    /**
     * @todo Implement testGetCharFreq().
     */
    public function testGetCharFreq() {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
          'This test has not been implemented yet.'
        );
    }



    public function testGetNumParagraphs()
    {
        $sample = "
This is a test of the multi paragraph support.


We'll try to be a bit clever.

Hopefully clever enough.

";
        $object = new Text_Statistics($sample);
        $this->assertEquals(3, $object->getNumParagraphs());
    }
}

// Call Text_StatisticsTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'Text_StatisticsTest::main') {
    Text_StatisticsTest::main();
}
?>
