<?php
/**
 * An example script that updates PEAR::DB using PEAR_PackageUpdater with a 
 * PHP-GTK 2 front end.
 *
 * @author    Scott Mattocks
 * @package   PEAR_PackageUpdate_Gtk2
 * @version   @version@
 * @license   PHP License
 * @copyright Copyright 2006 Scott Mattocks
 */
// Create a Gtk2 package updater for the DB package on the pear channel.
require_once 'PEAR/PackageUpdate.php';
$ppu = PEAR_PackageUpdate::factory('Gtk2', 'DB', 'pear');

// Uncommenting this line will change the user's preferences. It is NOT
// recommended for production use, but is handy when debugging.
//$ppu->setDontAskUntilNextRelease(false);

// Make sure the updater was created properly.
if ($ppu == false) {
    echo "Could not create updater.\n";
    echo "You might want to check for and install updates manually.\n";
    exit;
}

// Check to see if any updates are availble.
if ($ppu->checkUpdate()) {
    // If updates are available, present the user with the option to update.
    if ($ppu->presentUpdate()) {
        // Update the package.
        $ppu->update();
    }
}

// Check for errors.
if ($ppu->hasErrors()) {
    while($ppu->errorDialog()) ; // Empty loop.
}

// Don't ask me again until another version has been released. This restores 
// the preference changed above. Again, this is for debugging only.
//$ppu->setDontAskUntilNextRelease(true);
?>
