<?php
/**
* @author Paul Querna <chip@force-elite.com>
* @package Net_IRC-PHPbot
*/

/**
* This is a Simple example of a Bot that Queries a Database for 
* information, and then sends it to a Channel.
* 
* To make it work, you need to install the php_manual.sql into a SQL
* database.  It has only been tested with MySQL, but since it uses the
* PEAR DB class, it should work on most Databases.
*/



/* IRC Config */
$options = array(
    'server'    => 'irc.netgamers.org',  /* Where are we connecting to*/
    'port'      => 6667,  /* what port? */
    'nick'      => 'PHPbot', /* Default Nickname */
    'host'      => '10.0.0.8', /* stupid IRC protocol */
    'log_types'  => array(0,1,2,3,4, 5, 6), /* by default, log everything */
);

/* DB Config */

/* See PEAR::DB for Documentation on DSN: http://pear.php.net/manual/en/core.db.tut_dsn.php  */
$dsn = 'mysql://pa_irc:fubar@10.0.0.8/chip';
/* End Config */

/* This is the PEAR DB class */
require_once 'DB.php';

/* Connect to a database */
$db = DB::connect($dsn, false);

/* Test for error on DB connection */
if (DB::isError($db)) {
   die ($db->getMessage());
}

/* Turn off the timeout, so we can stay for longer than 30 seconds */
set_time_limit(0);

/* Include the PEAR Net_IRC class */
/* if Net_IRC is installed, you can change the path */
require_once '../../IRC.php';

/* create a new IRC object */
$irc = new Net_IRC;

/* Adding the IRC options we setup earlier to the IRC object */
echo "Adding IRC Connection\n";
$id = $irc->Add_Connection($options);

/* here we add our callbacks -- function to be called when somthing happens */
/* We want to do somthing on Private Messages, and also when the server gives us the welcome message */
$irc->Add_Callback('PRIVMSG', privmsg);
$irc->Add_Callback('DISCONNECT', disconnect);
$irc->Add_Callback('RPL_WELCOME', welcome);

$sql = "SELECT name, PHP_VER, return, args, purpose FROM php_manual WHERE name = ? LIMIT 0,1";
$sth = $db->prepare($sql);
echo "Starting Run()\n";
$irc->Run();

function privmsg_dyn($server_id, &$irc, $origin, $orighost, $target, $params) {
	global $ircd;
        $GLOBALS['my_data'] = array($server_id, $origin, $orighost, $target, $params);
        include('privmsg.php');
}


function privmsg($server_id, &$irc, $origin, $orighost, $target, $params) {
    global $db, $sth;
    $mirror_php = "http://www.php.net/manual/en/";
    $spaces = preg_split("/\s+/",$params);
    if(strtolower($spaces[0]) == "!php" || strtolower($spaces[0]) == "@php") {
        $keyword = str_replace("-","_",$spaces[1]);
        $res = $db->execute($sth, $keyword);
	$row = $res->fetchRow(DB_FETCHMODE_ASSOC);
        if($row !== null) {
            $url = str_replace("_","-",$row['name']);
            $def = "{$row['name']}: {$row['return']} {$row['name']}({$row['args']}) - Version Info: {$row['PHP_VER']} - " . 
                    "Description: {$row['purpose']} - More Details on ".
                                                        $mirror_php ."function." . $url . ".php";
            if(strtolower($spaces[0]) == "@php") {
                  $irc->send_notice($server_id, $origin, $def);
            } else {
                  $irc->send_privmsg($server_id, $target, $def);
            }
            $res->free();
        } else {
            $irc->send_notice($server_id, $origin, "[ {$spaces[1]} ] was not found in the database");
        }
    }

}
function disconnect ($server_id, &$irc, $origin, $orighost, $target, $params) {
    die("Got Disconnect Message!");
}

function welcome($server_id, &$irc, $origin, $orighost, $target, $params) {
    $irc->command($server_id, "JOIN #php");
    $irc->command($server_id, "JOIN #pear");
    $irc->command($server_id, "JOIN #sd");
}

