<?php
require_once 'System.php';
require_once 'PHPUnit.php';
require_once 'File/Passwd/Authdigest.php';

$GLOBALS['tmpfile'] = System::mktemp();
$GLOBALS['user']    = array (
    'mike' => array('realm1' => 'bbcaa08c9944893b29376d9536a5c0d8'),
    'pete' => array('realm1' => 'd5ae80288114955ea9d71fcbd8ca4b7d'),
    'mary' => array('realm1' => 'f6b5c730306e1860292640d7be039680')
);

/**
 * TestCase for File_Passwd_AuthdigestTest class
 * Generated by PHPEdit.XUnit Plugin
 * 
 */
class File_Passwd_AuthdigestTest extends PHPUnit_TestCase{

    var $pwd;

    /**
     * Constructor
     * @param string $name The name of the test.
     * @access protected
     */
    function File_Passwd_AuthdigestTest($name){
        $this->PHPUnit_TestCase($name);
    }
    
    /**
     * Called before the test functions will be executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function setUp(){
        $this->pwd = &new File_Passwd_Authdigest();
    }
    
    /**
     * Called after the test functions are executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function tearDown(){
        $this->pwd = null;
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.File_Passwd_Authdigest method
     * @access public
     */
    function testFile_Passwd_Authdigest(){
        $this->assertTrue(is_a($this->pwd, 'File_Passwd_Authdigest'));
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.save method
     * @access public
     */
    function testsave(){
        $this->pwd->setFile($GLOBALS['tmpfile']);
        $this->pwd->_users = $GLOBALS['user'];
        $this->assertTrue($this->pwd->save());
        $this->assertEquals(file('passwd.authdigest.txt'), file($GLOBALS['tmpfile']));
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.addUser method
     * @access public
     */
    function testaddUser(){
        $this->assertTrue($this->pwd->addUser('add', 'realm2', 123));
        $this->assertTrue($this->pwd->userExists('add'));
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.listUserInRealm method
     * @access public
     */
    function testlistUserInRealm(){
        $this->pwd->_users = $GLOBALS['user'];
        $array = array(
            'realm1' => array(
                'mike' => 'bbcaa08c9944893b29376d9536a5c0d8',
                'pete' => 'd5ae80288114955ea9d71fcbd8ca4b7d',
                'mary' => 'f6b5c730306e1860292640d7be039680'
            )
        );
        $this->assertEquals($array, $this->pwd->listUserInRealm('realm1'));
        $this->assertEquals($array, $this->pwd->listUserInRealm());
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.changePasswd method
     * @access public
     */
    function testchangePasswd(){
        $this->pwd->addUser('change', 'realm2', 123);
        $this->assertTrue($this->pwd->changePasswd('change', 'realm2', 'abc'));
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.verifyPasswd method
     * @access public
     */
    function testverifyPasswd(){
        $this->pwd->addUser('verify', 'realm2', 12345);
        $this->assertTrue($this->pwd->verifyPasswd('verify', 'realm2', 12345));
        $this->assertFalse($this->pwd->verifyPasswd('verify', 'realm2', ''));
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.userInRealm method
     * @access public
     */
    function testuserInRealm(){
        $this->pwd->_users = $GLOBALS['user'];
        $this->assertTrue($this->pwd->userInRealm('mike', 'realm1'));
        $this->assertFalse($this->pwd->userInRealm('sam', 'realm1'));
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.delUserInRealm method
     * @access public
     */
    function testdelUserInRealm(){
        $this->pwd->_users = $GLOBALS['user'];
        $this->assertTrue($this->pwd->delUserInRealm('mike', 'realm1'));
        $this->assertTrue(PEAR::isError($this->pwd->delUserInRealm('sam', 'realm2')));
    }
    
    /**
     * Regression test for File_Passwd_Authdigest.parse method
     * @access public
     */
    function testparse(){
        $this->pwd->setFile('passwd.authdigest.txt');
        $this->assertTrue($this->pwd->load());
        $this->assertEquals($GLOBALS['user'], $this->pwd->_users);
    }
    
    function teststaticAuth(){
        $this->assertTrue(true === File_Passwd::staticAuth('authdigest', 'passwd.authdigest.txt', 'mike', 123, 'realm1'));
        $this->assertTrue(false === File_Passwd::staticAuth('authdigest', 'passwd.authdigest.txt', 'mike', 'abc', 'realm1'));
        $this->assertFalse((File_Passwd::staticAuth('authdigest', 'passwd.authdigest.txt', 'nonexist', 'asd', 'norealm')));
    }
}

?>